/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils.structuremap;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.utils.structuremap.Variable;
import org.hl7.fhir.r5.utils.structuremap.VariableMode;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;

public class Variables {
    private List<Variable> list = new ArrayList<Variable>();

    public void add(VariableMode mode, String name, Base object) {
        Variable vv = null;
        for (Variable v : this.list) {
            if (v.getMode() != mode || !v.getName().equals(name)) continue;
            vv = v;
        }
        if (vv != null) {
            this.list.remove(vv);
        }
        this.list.add(new Variable(mode, name, object));
    }

    public Variables copy() {
        Variables result = new Variables();
        result.list.addAll(this.list);
        return result;
    }

    public Base get(VariableMode mode, String name) {
        for (Variable v : this.list) {
            if (v.getMode() != mode || !v.getName().equals(name)) continue;
            return v.getObject();
        }
        return null;
    }

    public String summary() {
        CommaSeparatedStringBuilder s = new CommaSeparatedStringBuilder();
        CommaSeparatedStringBuilder t = new CommaSeparatedStringBuilder();
        CommaSeparatedStringBuilder sh = new CommaSeparatedStringBuilder();
        for (Variable v : this.list) {
            switch (v.getMode()) {
                case INPUT: {
                    s.append(v.summary());
                    break;
                }
                case OUTPUT: {
                    t.append(v.summary());
                    break;
                }
                case SHARED: {
                    sh.append(v.summary());
                }
            }
        }
        return "source variables [" + s.toString() + "], target variables [" + t.toString() + "], shared variables [" + sh.toString() + "]";
    }
}

