/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.conformance;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.npm.BasePackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;

public class R5ExtensionsLoader {
    private BasePackageCacheManager pcm;
    private int count;
    private byte[] map;
    private NpmPackage pck;

    public R5ExtensionsLoader(BasePackageCacheManager pcm) {
        this.pcm = pcm;
    }

    public void loadR5Extensions(IWorkerContext context) throws FHIRException, IOException {
        this.pck = this.pcm.loadPackage("hl7.fhir.r5.core", "current");
        String[] types = new String[]{"StructureDefinition", "ValueSet", "CodeSystem"};
        HashMap<String, ValueSet> valueSets = new HashMap<String, ValueSet>();
        HashMap<String, CodeSystem> codeSystems = new HashMap<String, CodeSystem>();
        ArrayList<StructureDefinition> extensions = new ArrayList<StructureDefinition>();
        JsonParser json = new JsonParser();
        for (NpmPackage.PackageResourceInformation pri : this.pck.listIndexedResources(types)) {
            CanonicalResource r = (CanonicalResource)json.parse(this.pck.load(pri));
            r.setUserData("path", Utilities.pathURL((String[])new String[]{this.pck.getWebLocation(), r.fhirType().toLowerCase() + "-" + r.getId().toLowerCase() + ".html"}));
            if (r instanceof CodeSystem) {
                codeSystems.put(r.getUrl(), (CodeSystem)r);
                continue;
            }
            if (r instanceof ValueSet) {
                valueSets.put(r.getUrl(), (ValueSet)r);
                continue;
            }
            if (!(r instanceof StructureDefinition)) continue;
            extensions.add((StructureDefinition)r);
        }
        IWorkerContext.PackageVersion pd = new IWorkerContext.PackageVersion(this.pck.name(), this.pck.version(), this.pck.dateAsDate());
        this.count = 0;
        List<String> typeNames = context.getTypeNames();
        for (StructureDefinition sd : extensions) {
            if (!sd.getType().equals("Extension") || sd.getDerivation() != StructureDefinition.TypeDerivationRule.CONSTRAINT || context.hasResource(StructureDefinition.class, sd.getUrl()) || !this.survivesStrippingTypes(sd, context, typeNames)) continue;
            ++this.count;
            sd.setUserData("path", Utilities.pathURL((String[])new String[]{this.pck.getWebLocation(), "extension-" + sd.getId().toLowerCase() + ".html"}));
            context.cacheResourceFromPackage(sd, pd);
            this.registerTerminologies(sd, context, valueSets, codeSystems, pd);
        }
        this.map = this.pck.hasFile("other", "spec.internals") ? TextFile.streamToBytes((InputStream)this.pck.load("other", "spec.internals")) : null;
    }

    private void registerTerminologies(StructureDefinition sd, IWorkerContext context, Map<String, ValueSet> valueSets, Map<String, CodeSystem> codeSystems, IWorkerContext.PackageVersion pd) {
        for (ElementDefinition ed : sd.getSnapshot().getElement()) {
            String vs;
            if (!ed.hasBinding() || !ed.getBinding().hasValueSet() || context.hasResource(ValueSet.class, vs = ed.getBinding().getValueSet())) continue;
            this.loadValueSet(vs, context, valueSets, codeSystems, pd);
        }
    }

    private void loadValueSet(String url, IWorkerContext context, Map<String, ValueSet> valueSets, Map<String, CodeSystem> codeSystems, IWorkerContext.PackageVersion pd) {
        if (valueSets.containsKey(url)) {
            ValueSet vs = valueSets.get(url);
            context.cacheResourceFromPackage(vs, pd);
            for (ValueSet.ConceptSetComponent inc : vs.getCompose().getInclude()) {
                for (CanonicalType t : inc.getValueSet()) {
                    this.loadValueSet(t.asStringValue(), context, valueSets, codeSystems, pd);
                }
                if (!inc.hasSystem() || context.hasResource(CodeSystem.class, inc.getSystem()) || !codeSystems.containsKey(inc.getSystem())) continue;
                context.cacheResourceFromPackage(codeSystems.get(inc.getSystem()), pd);
            }
        }
    }

    private boolean survivesStrippingTypes(StructureDefinition sd, IWorkerContext context, List<String> typeNames) {
        for (ElementDefinition ed : sd.getDifferential().getElement()) {
            this.stripTypes(ed, context, typeNames);
        }
        for (ElementDefinition ed : sd.getSnapshot().getElement()) {
            if (this.stripTypes(ed, context, typeNames)) continue;
            return false;
        }
        return true;
    }

    private boolean stripTypes(ElementDefinition ed, IWorkerContext context, List<String> typeNames) {
        if (!ed.getPath().contains(".") || !ed.hasType()) {
            return true;
        }
        ed.getType().removeIf(tr -> !typeNames.contains(tr.getWorkingCode()));
        if (!ed.hasType()) {
            return false;
        }
        for (ElementDefinition.TypeRefComponent tr2 : ed.getType()) {
            if (!tr2.hasTargetProfile()) continue;
            tr2.getTargetProfile().removeIf(n -> !context.hasResource(StructureDefinition.class, n.asStringValue()));
            if (tr2.hasTargetProfile()) continue;
            return false;
        }
        return true;
    }

    public BasePackageCacheManager getPcm() {
        return this.pcm;
    }

    public int getCount() {
        return this.count;
    }

    public byte[] getMap() {
        return this.map;
    }

    public NpmPackage getPck() {
        return this.pck;
    }
}

