/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.context;

import ca.uhn.fhir.parser.DataFormatException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.conformance.ProfileUtilities;
import org.hl7.fhir.r5.context.BaseWorkerContext;
import org.hl7.fhir.r5.context.CanonicalResourceManager;
import org.hl7.fhir.r5.context.HTMLClientLogger;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.context.SystemOutLoggingService;
import org.hl7.fhir.r5.context.TextClientLogger;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.formats.ParserType;
import org.hl7.fhir.r5.formats.XmlParser;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.terminologies.JurisdictionUtilities;
import org.hl7.fhir.r5.terminologies.TerminologyClient;
import org.hl7.fhir.r5.utils.XVerExtensionManager;
import org.hl7.fhir.r5.utils.validation.IResourceValidator;
import org.hl7.fhir.utilities.CSFileInputStream;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.TimeTracker;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.npm.BasePackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class SimpleWorkerContext
extends BaseWorkerContext
implements IWorkerContext,
ProfileUtilities.ProfileKnowledgeProvider {
    private Questionnaire questionnaire;
    private String revision;
    private String date;
    private IValidatorFactory validatorFactory;
    private boolean ignoreProfileErrors;
    private boolean progress;
    private final List<String> loadedPackages = new ArrayList<String>();
    private boolean canNoTS;
    private XVerExtensionManager xverManager;
    private boolean allowLazyLoading = true;
    private boolean suppressDebugMessages;

    private SimpleWorkerContext() throws IOException, FHIRException {
    }

    private SimpleWorkerContext(Locale locale) throws IOException, FHIRException {
        super(locale);
    }

    private SimpleWorkerContext(SimpleWorkerContext other) throws IOException, FHIRException {
        this.copy(other);
    }

    private SimpleWorkerContext(SimpleWorkerContext other, Locale locale) throws IOException, FHIRException {
        super(locale);
        this.copy(other);
    }

    protected void copy(SimpleWorkerContext other) {
        super.copy(other);
        this.questionnaire = other.questionnaire;
        this.binaries.putAll(other.binaries);
        this.version = other.version;
        this.revision = other.revision;
        this.date = other.date;
        this.validatorFactory = other.validatorFactory;
    }

    public List<String> getLoadedPackages() {
        return this.loadedPackages;
    }

    private void loadDefinitionItem(String name, InputStream stream, IWorkerContext.IContextResourceLoader loader, ILoadFilter filter, IWorkerContext.PackageVersion pi) throws IOException, FHIRException {
        if (name.endsWith(".xml")) {
            this.loadFromFile(stream, name, loader, filter);
        } else if (name.endsWith(".json")) {
            this.loadFromFileJson(stream, name, loader, filter, pi);
        } else if (name.equals("version.info")) {
            this.readVersionInfo(stream);
        } else {
            this.loadBytes(name, stream);
        }
    }

    public String connectToTSServer(TerminologyClient client, String log) {
        try {
            this.txLog("Connect to " + client.getAddress());
            this.txClient = client;
            this.txLog = log != null && log.endsWith(".txt") ? new TextClientLogger(log) : new HTMLClientLogger(log);
            this.txClient.setLogger(this.txLog);
            this.txClient.setUserAgent(this.userAgent);
            CapabilityStatement capabilitiesStatementQuick = this.txCache.hasCapabilityStatement() ? this.txCache.getCapabilityStatement() : this.txClient.getCapabilitiesStatementQuick();
            this.txCache.cacheCapabilityStatement(capabilitiesStatementQuick);
            TerminologyCapabilities capabilityStatement = this.txCache.hasTerminologyCapabilities() ? this.txCache.getTerminologyCapabilities() : this.txClient.getTerminologyCapabilities();
            this.txCache.cacheTerminologyCapabilities(capabilityStatement);
            this.setTxCaps(capabilityStatement);
            return capabilitiesStatementQuick.getSoftware().getVersion();
        }
        catch (Exception e) {
            throw new FHIRException(this.formatMessage(this.canNoTS ? "Unable_to_connect_to_terminology_server_Use_parameter_tx_na_tun_run_without_using_terminology_services_to_validate_LOINC_SNOMED_ICDX_etc_Error__" : "Unable_to_connect_to_terminology_server", new Object[]{e.getMessage()}), (Throwable)e);
        }
    }

    public void loadFromFile(InputStream stream, String name, IWorkerContext.IContextResourceLoader loader) throws FHIRException {
        this.loadFromFile(stream, name, loader, null);
    }

    public void loadFromFile(InputStream stream, String name, IWorkerContext.IContextResourceLoader loader, ILoadFilter filter) throws FHIRException {
        Resource f;
        try {
            if (loader != null) {
                f = loader.loadBundle(stream, false);
            } else {
                XmlParser xml = new XmlParser();
                f = xml.parse(stream);
            }
        }
        catch (DataFormatException e1) {
            throw new FHIRFormatError(this.formatMessage("Error_parsing_", new Object[]{name, e1.getMessage()}), (Throwable)e1);
        }
        catch (Exception e1) {
            throw new FHIRFormatError(this.formatMessage("Error_parsing_", new Object[]{name, e1.getMessage()}), (Throwable)e1);
        }
        if (f instanceof Bundle) {
            Resource bnd = f;
            for (Bundle.BundleEntryComponent e : ((Bundle)bnd).getEntry()) {
                String path;
                if (e.getFullUrl() == null) {
                    this.logger.logDebugMessage(IWorkerContext.ILoggingService.LogCategory.CONTEXT, "unidentified resource in " + name + " (no fullUrl)");
                }
                if (filter != null && !filter.isOkToLoad(e.getResource())) continue;
                String string = path = loader != null ? loader.getResourcePath(e.getResource()) : null;
                if (path != null) {
                    e.getResource().setUserData("path", path);
                }
                this.cacheResource(e.getResource());
            }
        } else if (f instanceof CanonicalResource && (filter == null || filter.isOkToLoad(f))) {
            String path;
            String string = path = loader != null ? loader.getResourcePath(f) : null;
            if (path != null) {
                f.setUserData("path", path);
            }
            this.cacheResource(f);
        }
    }

    private void loadFromFileJson(InputStream stream, String name, IWorkerContext.IContextResourceLoader loader, ILoadFilter filter, IWorkerContext.PackageVersion pi) throws IOException, FHIRException {
        Bundle f = null;
        try {
            if (loader != null) {
                f = loader.loadBundle(stream, true);
            } else {
                JsonParser json = new JsonParser();
                Resource r = json.parse(stream);
                if (r instanceof Bundle) {
                    f = (Bundle)r;
                } else if (filter == null || filter.isOkToLoad(f)) {
                    this.cacheResourceFromPackage(r, pi);
                }
            }
        }
        catch (FHIRFormatError e1) {
            throw new FHIRFormatError(e1.getMessage(), (Throwable)e1);
        }
        if (f != null) {
            for (Bundle.BundleEntryComponent e : f.getEntry()) {
                String path;
                if (filter != null && !filter.isOkToLoad(e.getResource())) continue;
                String string = path = loader != null ? loader.getResourcePath(e.getResource()) : null;
                if (path != null) {
                    e.getResource().setUserData("path", path);
                }
                this.cacheResourceFromPackage(e.getResource(), pi);
            }
        }
    }

    private void loadFromPack(String path, IWorkerContext.IContextResourceLoader loader) throws IOException, FHIRException {
        this.loadFromStream((InputStream)new CSFileInputStream(path), loader);
    }

    @Override
    public int loadFromPackage(NpmPackage pi, IWorkerContext.IContextResourceLoader loader) throws IOException, FHIRException {
        return this.loadFromPackageInt(pi, loader, loader == null ? SimpleWorkerContext.defaultTypesToLoad() : loader.getTypes());
    }

    public static String[] defaultTypesToLoad() {
        return new String[]{"CodeSystem", "ValueSet", "ConceptMap", "NamingSystem", "StructureDefinition", "StructureMap", "SearchParameter", "OperationDefinition", "CapabilityStatement", "Conformance", "Questionnaire", "ImplementationGuide", "Measure"};
    }

    @Override
    public int loadFromPackage(NpmPackage pi, IWorkerContext.IContextResourceLoader loader, String[] types) throws IOException, FHIRException {
        return this.loadFromPackageInt(pi, loader, types);
    }

    @Override
    public int loadFromPackageAndDependencies(NpmPackage pi, IWorkerContext.IContextResourceLoader loader, BasePackageCacheManager pcm) throws IOException, FHIRException {
        return this.loadFromPackageAndDependenciesInt(pi, loader, pcm, pi.name() + "#" + pi.version());
    }

    public int loadFromPackageAndDependenciesInt(NpmPackage pi, IWorkerContext.IContextResourceLoader loader, BasePackageCacheManager pcm, String path) throws IOException, FHIRException {
        int t = 0;
        for (String e : pi.dependencies()) {
            if (this.loadedPackages.contains(e) || VersionUtilities.isCorePackage((String)e)) continue;
            NpmPackage npm = pcm.loadPackage(e);
            if (!VersionUtilities.versionsMatch((String)this.version, (String)npm.fhirVersion())) {
                System.out.println(this.formatMessage("PACKAGE_VERSION_MISMATCH", new Object[]{e, this.version, npm.fhirVersion(), path}));
            }
            t += this.loadFromPackageAndDependenciesInt(npm, loader.getNewLoader(npm), pcm, path + " -> " + npm.name() + "#" + npm.version());
        }
        return t += this.loadFromPackageInt(pi, loader, loader.getTypes());
    }

    public int loadFromPackageInt(NpmPackage pi, IWorkerContext.IContextResourceLoader loader, String ... types) throws IOException, FHIRException {
        int t = 0;
        if (this.progress) {
            System.out.println("Load Package " + pi.name() + "#" + pi.version());
        }
        if (this.loadedPackages.contains(pi.id() + "#" + pi.version())) {
            return 0;
        }
        this.loadedPackages.add(pi.id() + "#" + pi.version());
        if (this.packageTracker != null) {
            this.packageTracker.packageLoaded(pi.id(), pi.version());
        }
        if ((types == null || types.length == 0) && loader != null) {
            types = loader.getTypes();
        }
        if (VersionUtilities.isR2Ver((String)pi.fhirVersion()) || !pi.canLazyLoad() || !this.allowLazyLoading) {
            if (types.length == 0) {
                types = new String[]{"StructureDefinition", "ValueSet", "SearchParameter", "OperationDefinition", "Questionnaire", "ConceptMap", "StructureMap", "NamingSystem"};
            }
            for (String s : pi.listResources(types)) {
                try {
                    this.loadDefinitionItem(s, pi.load("package", s), loader, null, new IWorkerContext.PackageVersion(pi.id(), pi.version(), pi.dateAsDate()));
                    ++t;
                }
                catch (Exception e) {
                    throw new FHIRException(this.formatMessage("Error_reading__from_package__", new Object[]{s, pi.name(), pi.version(), e.getMessage()}), (Throwable)e);
                }
            }
        } else {
            if (types.length == 0) {
                types = new String[]{"StructureDefinition", "ValueSet", "CodeSystem", "SearchParameter", "OperationDefinition", "Questionnaire", "ConceptMap", "StructureMap", "NamingSystem", "Measures"};
            }
            for (NpmPackage.PackageResourceInformation pri : pi.listIndexedResources(types)) {
                if (pri.getFilename().contains("ig-r4")) continue;
                try {
                    this.registerResourceFromPackage(new PackageResourceLoader(pri, loader), new IWorkerContext.PackageVersion(pi.id(), pi.version(), pi.dateAsDate()));
                    ++t;
                }
                catch (FHIRException e) {
                    throw new FHIRException(this.formatMessage("Error_reading__from_package__", new Object[]{pri.getFilename(), pi.name(), pi.version(), e.getMessage()}), (Throwable)e);
                }
            }
        }
        for (String s : pi.list("other")) {
            this.binaries.put(s, TextFile.streamToBytes((InputStream)pi.load("other", s)));
        }
        if (this.version == null) {
            this.version = pi.version();
        }
        return t;
    }

    public void loadFromFile(String file, IWorkerContext.IContextResourceLoader loader) throws IOException, FHIRException {
        this.loadDefinitionItem(file, (InputStream)new CSFileInputStream(file), loader, null, null);
    }

    private void loadFromStream(InputStream stream, IWorkerContext.IContextResourceLoader loader) throws IOException, FHIRException {
        ZipEntry ze;
        ZipInputStream zip = new ZipInputStream(stream);
        while ((ze = zip.getNextEntry()) != null) {
            this.loadDefinitionItem(ze.getName(), zip, loader, null, null);
            zip.closeEntry();
        }
        zip.close();
    }

    private void readVersionInfo(InputStream stream) throws IOException, DefinitionException {
        String[] vi;
        byte[] bytes = IOUtils.toByteArray((InputStream)stream);
        this.binaries.put("version.info", bytes);
        for (String s : vi = new String(bytes).split("\\r?\\n")) {
            if (s.startsWith("version=")) {
                if (this.version == null) {
                    this.version = s.substring(8);
                } else if (!this.version.equals(s.substring(8))) {
                    throw new DefinitionException(this.formatMessage("Version_mismatch_The_context_has_version__loaded_and_the_new_content_being_loaded_is_version_", new Object[]{this.version, s.substring(8)}));
                }
            }
            if (s.startsWith("revision=")) {
                this.revision = s.substring(9);
            }
            if (!s.startsWith("date=")) continue;
            this.date = s.substring(5);
        }
    }

    private void loadBytes(String name, InputStream stream) throws IOException {
        byte[] bytes = IOUtils.toByteArray((InputStream)stream);
        this.binaries.put(name, bytes);
    }

    @Override
    public IParser getParser(ParserType type) {
        switch (type) {
            case JSON: {
                return this.newJsonParser();
            }
            case XML: {
                return this.newXmlParser();
            }
        }
        throw new Error(this.formatMessage("Parser_Type__not_supported", new Object[]{type.toString()}));
    }

    @Override
    public IParser getParser(String type) {
        if (type.equalsIgnoreCase("JSON")) {
            return new JsonParser();
        }
        if (type.equalsIgnoreCase("XML")) {
            return new XmlParser();
        }
        throw new Error(this.formatMessage("Parser_Type__not_supported", new Object[]{type.toString()}));
    }

    @Override
    public IParser newJsonParser() {
        return new JsonParser();
    }

    @Override
    public IParser newXmlParser() {
        return new XmlParser();
    }

    @Override
    public IResourceValidator newValidator() throws FHIRException {
        if (this.validatorFactory == null) {
            throw new Error(this.formatMessage("No_validator_configured", new Object[0]));
        }
        return this.validatorFactory.makeValidator(this, this.xverManager).setJurisdiction(JurisdictionUtilities.getJurisdictionCodingFromLocale(Locale.getDefault().getCountry()));
    }

    @Override
    public List<String> getResourceNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (StructureDefinition sd : this.listStructures()) {
            if (sd.getKind() != StructureDefinition.StructureDefinitionKind.RESOURCE || sd.getDerivation() != StructureDefinition.TypeDerivationRule.SPECIALIZATION) continue;
            result.add(sd.getName());
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public List<String> getTypeNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (StructureDefinition sd : this.listStructures()) {
            if (sd.getKind() == StructureDefinition.StructureDefinitionKind.LOGICAL || sd.getDerivation() != StructureDefinition.TypeDerivationRule.SPECIALIZATION) continue;
            result.add(sd.getName());
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public String getAbbreviation(String name) {
        return "xxx";
    }

    @Override
    public boolean isDatatype(String typeSimple) {
        return false;
    }

    @Override
    public boolean isResource(String t) {
        StructureDefinition sd;
        try {
            sd = this.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + t);
        }
        catch (Exception e) {
            return false;
        }
        if (sd == null) {
            return false;
        }
        if (sd.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT) {
            return false;
        }
        return sd.getKind() == StructureDefinition.StructureDefinitionKind.RESOURCE;
    }

    @Override
    public boolean hasLinkFor(String typeSimple) {
        return false;
    }

    @Override
    public String getLinkFor(String corePath, String typeSimple) {
        return null;
    }

    @Override
    public ProfileUtilities.ProfileKnowledgeProvider.BindingResolution resolveBinding(StructureDefinition profile, ElementDefinition.ElementDefinitionBindingComponent binding, String path) {
        return null;
    }

    @Override
    public ProfileUtilities.ProfileKnowledgeProvider.BindingResolution resolveBinding(StructureDefinition profile, String url, String path) {
        return null;
    }

    @Override
    public String getLinkForProfile(StructureDefinition profile, String url) {
        return null;
    }

    public Questionnaire getQuestionnaire() {
        return this.questionnaire;
    }

    public void setQuestionnaire(Questionnaire questionnaire) {
        this.questionnaire = questionnaire;
    }

    @Override
    public List<StructureDefinition> allStructures() {
        ArrayList<StructureDefinition> result = new ArrayList<StructureDefinition>();
        HashSet<StructureDefinition> set = new HashSet<StructureDefinition>();
        for (StructureDefinition sd : this.listStructures()) {
            block3: {
                if (set.contains(sd)) continue;
                try {
                    this.generateSnapshot(sd);
                }
                catch (Exception e) {
                    if (this.suppressDebugMessages) break block3;
                    System.out.println("Unable to generate snapshot for " + this.tail(sd.getUrl()) + " from " + this.tail(sd.getBaseDefinition()) + " because " + e.getMessage());
                    e.printStackTrace();
                }
            }
            result.add(sd);
            set.add(sd);
        }
        return result;
    }

    public void loadBinariesFromFolder(String folder) throws IOException {
        for (String n : new File(folder).list()) {
            this.loadBytes(n, new FileInputStream(Utilities.path((String[])new String[]{folder, n})));
        }
    }

    public void loadBinariesFromFolder(NpmPackage pi) throws IOException {
        for (String n : pi.list("other")) {
            this.loadBytes(n, pi.load("other", n));
        }
    }

    public void loadFromFolder(String folder) throws IOException {
        for (String n : new File(folder).list()) {
            if (n.endsWith(".json")) {
                this.loadFromFile(Utilities.path((String[])new String[]{folder, n}), new JsonParser());
                continue;
            }
            if (!n.endsWith(".xml")) continue;
            this.loadFromFile(Utilities.path((String[])new String[]{folder, n}), new XmlParser());
        }
    }

    private void loadFromFile(String filename, IParser p) {
        try {
            Resource r = p.parse(new FileInputStream(filename));
            if (r.getResourceType() == ResourceType.Bundle) {
                for (Bundle.BundleEntryComponent e : ((Bundle)r).getEntry()) {
                    this.cacheResource(e.getResource());
                }
            } else {
                this.cacheResource(r);
            }
        }
        catch (Exception e) {
            return;
        }
    }

    @Override
    public boolean prependLinks() {
        return false;
    }

    @Override
    public boolean hasCache() {
        return true;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public List<StructureMap> findTransformsforSource(String url) {
        ArrayList<StructureMap> res = new ArrayList<StructureMap>();
        for (StructureMap map : this.listTransforms()) {
            boolean match = false;
            boolean ok = true;
            for (StructureMap.StructureMapStructureComponent t : map.getStructure()) {
                if (t.getMode() != StructureMap.StructureMapModelMode.SOURCE) continue;
                match = match || t.getUrl().equals(url);
                ok = ok && t.getUrl().equals(url);
            }
            if (!match || !ok) continue;
            res.add(map);
        }
        return res;
    }

    public IValidatorFactory getValidatorFactory() {
        return this.validatorFactory;
    }

    public void setValidatorFactory(IValidatorFactory validatorFactory) {
        this.validatorFactory = validatorFactory;
    }

    @Override
    public <T extends Resource> T fetchResource(Class<T> class_, String uri) {
        T r;
        block3: {
            r = super.fetchResource(class_, uri);
            if (r instanceof StructureDefinition) {
                StructureDefinition p = (StructureDefinition)r;
                try {
                    this.generateSnapshot(p);
                }
                catch (Exception e) {
                    if (this.suppressDebugMessages) break block3;
                    System.out.println("Unable to generate snapshot for " + uri + ": " + e.getMessage());
                }
            }
        }
        return r;
    }

    @Override
    public StructureDefinition fetchRawProfile(String uri) {
        StructureDefinition r = super.fetchResource(StructureDefinition.class, uri);
        return r;
    }

    @Override
    public void generateSnapshot(StructureDefinition p) throws FHIRException {
        this.generateSnapshot(p, false);
    }

    @Override
    public void generateSnapshot(StructureDefinition p, boolean logical) throws FHIRException {
        if (!(p.hasSnapshot() && !this.isProfileNeedsRegenerate(p) || !logical && p.getKind() == StructureDefinition.StructureDefinitionKind.LOGICAL)) {
            if (!p.hasBaseDefinition()) {
                throw new DefinitionException(this.formatMessage("Profile___has_no_base_and_no_snapshot", new Object[]{p.getName(), p.getUrl()}));
            }
            StructureDefinition sd = this.fetchResource(StructureDefinition.class, p.getBaseDefinition());
            if (sd == null && "http://hl7.org/fhir/StructureDefinition/Base".equals(p.getBaseDefinition())) {
                sd = ProfileUtilities.makeBaseDefinition(p.getFhirVersion());
            }
            if (sd == null) {
                throw new DefinitionException(this.formatMessage("Profile___base__could_not_be_resolved", new Object[]{p.getName(), p.getUrl(), p.getBaseDefinition()}));
            }
            ArrayList<ValidationMessage> msgs = new ArrayList<ValidationMessage>();
            ArrayList<String> errors = new ArrayList<String>();
            ProfileUtilities pu = new ProfileUtilities(this, msgs, this);
            pu.setAutoFixSliceNames(true);
            pu.setThrowException(false);
            if (this.xverManager == null) {
                this.xverManager = new XVerExtensionManager(this);
            }
            pu.setXver(this.xverManager);
            if (sd.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT) {
                pu.sortDifferential(sd, p, p.getUrl(), errors, true);
            }
            pu.setDebug(false);
            for (String err : errors) {
                msgs.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.EXCEPTION, p.getUserString("path"), "Error sorting Differential: " + err, ValidationMessage.IssueSeverity.ERROR));
            }
            pu.generateSnapshot(sd, p, p.getUrl(), sd.getUserString("webroot"), p.getName());
            for (ValidationMessage msg : msgs) {
                if ((this.ignoreProfileErrors || msg.getLevel() != ValidationMessage.IssueSeverity.ERROR) && msg.getLevel() != ValidationMessage.IssueSeverity.FATAL) continue;
                throw new DefinitionException(this.formatMessage("Profile___element__Error_generating_snapshot_", new Object[]{p.getName(), p.getUrl(), msg.getLocation(), msg.getMessage()}));
            }
            if (!p.hasSnapshot()) {
                throw new FHIRException(this.formatMessage("Profile___Error_generating_snapshot", new Object[]{p.getName(), p.getUrl()}));
            }
            pu = null;
        }
    }

    private boolean isProfileNeedsRegenerate(StructureDefinition p) {
        boolean needs;
        boolean bl = needs = !p.hasUserData("hack.regnerated") && Utilities.existsInList((String)p.getUrl(), (String[])new String[]{"http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaireresponse"});
        if (needs) {
            p.setUserData("hack.regnerated", "yes");
        }
        return needs;
    }

    public boolean isIgnoreProfileErrors() {
        return this.ignoreProfileErrors;
    }

    public void setIgnoreProfileErrors(boolean ignoreProfileErrors) {
        this.ignoreProfileErrors = ignoreProfileErrors;
    }

    public String listMapUrls() {
        return Utilities.listCanonicalUrls(this.transforms.keys());
    }

    public boolean isProgress() {
        return this.progress;
    }

    public void setProgress(boolean progress) {
        this.progress = progress;
    }

    public void setClock(TimeTracker tt) {
        this.clock = tt;
    }

    public boolean isCanNoTS() {
        return this.canNoTS;
    }

    public void setCanNoTS(boolean canNoTS) {
        this.canNoTS = canNoTS;
    }

    public XVerExtensionManager getXVer() {
        if (this.xverManager == null) {
            this.xverManager = new XVerExtensionManager(this);
        }
        return this.xverManager;
    }

    public void cachePackage(IWorkerContext.PackageVersion packageDetails, List<IWorkerContext.PackageVersion> dependencies) {
    }

    @Override
    public boolean hasPackage(String id, String ver) {
        return this.loadedPackages.contains(id + "#" + ver);
    }

    public boolean hasPackage(String idAndver) {
        return this.loadedPackages.contains(idAndver);
    }

    @Override
    public void cachePackage(IWorkerContext.PackageDetails packageDetails, List<IWorkerContext.PackageVersion> dependencies) {
    }

    @Override
    public boolean hasPackage(IWorkerContext.PackageVersion pack) {
        return false;
    }

    @Override
    public IWorkerContext.PackageDetails getPackage(IWorkerContext.PackageVersion pack) {
        return null;
    }

    public boolean isAllowLazyLoading() {
        return this.allowLazyLoading;
    }

    public void setAllowLazyLoading(boolean allowLazyLoading) {
        this.allowLazyLoading = allowLazyLoading;
    }

    public boolean isSuppressDebugMessages() {
        return this.suppressDebugMessages;
    }

    public void setSuppressDebugMessages(boolean suppressDebugMessages) {
        this.suppressDebugMessages = suppressDebugMessages;
    }

    public static class SimpleWorkerContextBuilder {
        private final String terminologyCachePath;
        private final boolean cacheTerminologyClientErrors;
        private final boolean alwaysUseTerminologyServer;
        private final boolean readOnlyCache;
        private final Locale locale;
        private final String userAgent;
        private final boolean allowLoadingDuplicates;
        private final IWorkerContext.ILoggingService loggingService;

        public SimpleWorkerContextBuilder() {
            this.cacheTerminologyClientErrors = false;
            this.alwaysUseTerminologyServer = false;
            this.readOnlyCache = false;
            this.terminologyCachePath = null;
            this.locale = null;
            this.userAgent = null;
            this.allowLoadingDuplicates = false;
            this.loggingService = new SystemOutLoggingService();
        }

        private SimpleWorkerContext getSimpleWorkerContextInstance() throws IOException {
            if (this.locale != null) {
                return new SimpleWorkerContext(this.locale);
            }
            return new SimpleWorkerContext();
        }

        public SimpleWorkerContext build() throws IOException {
            SimpleWorkerContext context = this.getSimpleWorkerContextInstance();
            return this.build(context);
        }

        private SimpleWorkerContext build(SimpleWorkerContext context) throws IOException {
            context.initTS(this.terminologyCachePath);
            context.setUserAgent(this.userAgent);
            context.setLogger(this.loggingService);
            return context;
        }

        public SimpleWorkerContext fromPackage(NpmPackage pi) throws IOException, FHIRException {
            SimpleWorkerContext context = this.getSimpleWorkerContextInstance();
            context.setAllowLoadingDuplicates(this.allowLoadingDuplicates);
            context.loadFromPackage(pi, null);
            return this.build(context);
        }

        public SimpleWorkerContext fromPackage(NpmPackage pi, IWorkerContext.IContextResourceLoader loader) throws IOException, FHIRException {
            SimpleWorkerContext context = this.getSimpleWorkerContextInstance();
            context.setAllowLoadingDuplicates(this.allowLoadingDuplicates);
            context.version = pi.getNpm().get("version").getAsString();
            context.loadFromPackage(pi, loader);
            context.finishLoading();
            return this.build(context);
        }

        public SimpleWorkerContext fromPack(String path) throws IOException, FHIRException {
            SimpleWorkerContext context = this.getSimpleWorkerContextInstance();
            context.setAllowLoadingDuplicates(this.allowLoadingDuplicates);
            context.loadFromPack(path, null);
            return this.build(context);
        }

        public SimpleWorkerContext fromPack(String path, IWorkerContext.IContextResourceLoader loader) throws IOException, FHIRException {
            SimpleWorkerContext context = this.getSimpleWorkerContextInstance();
            context.loadFromPack(path, loader);
            return this.build(context);
        }

        public SimpleWorkerContext fromClassPath() throws IOException, FHIRException {
            SimpleWorkerContext context = this.getSimpleWorkerContextInstance();
            context.loadFromStream(SimpleWorkerContext.class.getResourceAsStream("validation.json.zip"), null);
            return this.build(context);
        }

        public SimpleWorkerContext fromClassPath(String name) throws IOException, FHIRException {
            SimpleWorkerContext context = this.getSimpleWorkerContextInstance();
            InputStream s = SimpleWorkerContext.class.getResourceAsStream("/" + name);
            context.setAllowLoadingDuplicates(this.allowLoadingDuplicates);
            context.loadFromStream(s, null);
            return this.build(context);
        }

        public SimpleWorkerContext fromDefinitions(Map<String, byte[]> source, IWorkerContext.IContextResourceLoader loader, IWorkerContext.PackageVersion pi) throws IOException, FHIRException {
            SimpleWorkerContext context = this.getSimpleWorkerContextInstance();
            for (String name : source.keySet()) {
                try {
                    context.loadDefinitionItem(name, new ByteArrayInputStream(source.get(name)), loader, null, pi);
                }
                catch (Exception e) {
                    System.out.println("Error loading " + name + ": " + e.getMessage());
                    throw new FHIRException("Error loading " + name + ": " + e.getMessage(), (Throwable)e);
                }
            }
            return this.build(context);
        }

        public SimpleWorkerContext fromNothing() throws FHIRException, IOException {
            return this.build();
        }

        private SimpleWorkerContextBuilder(String terminologyCachePath, boolean cacheTerminologyClientErrors, boolean alwaysUseTerminologyServer, boolean readOnlyCache, Locale locale, String userAgent, boolean allowLoadingDuplicates, IWorkerContext.ILoggingService loggingService) {
            this.terminologyCachePath = terminologyCachePath;
            this.cacheTerminologyClientErrors = cacheTerminologyClientErrors;
            this.alwaysUseTerminologyServer = alwaysUseTerminologyServer;
            this.readOnlyCache = readOnlyCache;
            this.locale = locale;
            this.userAgent = userAgent;
            this.allowLoadingDuplicates = allowLoadingDuplicates;
            this.loggingService = loggingService;
        }

        public SimpleWorkerContextBuilder withTerminologyCachePath(String terminologyCachePath) {
            return this.terminologyCachePath == terminologyCachePath ? this : new SimpleWorkerContextBuilder(terminologyCachePath, this.cacheTerminologyClientErrors, this.alwaysUseTerminologyServer, this.readOnlyCache, this.locale, this.userAgent, this.allowLoadingDuplicates, this.loggingService);
        }

        public SimpleWorkerContextBuilder withCacheTerminologyClientErrors(boolean cacheTerminologyClientErrors) {
            return this.cacheTerminologyClientErrors == cacheTerminologyClientErrors ? this : new SimpleWorkerContextBuilder(this.terminologyCachePath, cacheTerminologyClientErrors, this.alwaysUseTerminologyServer, this.readOnlyCache, this.locale, this.userAgent, this.allowLoadingDuplicates, this.loggingService);
        }

        public SimpleWorkerContextBuilder withAlwaysUseTerminologyServer(boolean alwaysUseTerminologyServer) {
            return this.alwaysUseTerminologyServer == alwaysUseTerminologyServer ? this : new SimpleWorkerContextBuilder(this.terminologyCachePath, this.cacheTerminologyClientErrors, alwaysUseTerminologyServer, this.readOnlyCache, this.locale, this.userAgent, this.allowLoadingDuplicates, this.loggingService);
        }

        public SimpleWorkerContextBuilder withReadOnlyCache(boolean readOnlyCache) {
            return this.readOnlyCache == readOnlyCache ? this : new SimpleWorkerContextBuilder(this.terminologyCachePath, this.cacheTerminologyClientErrors, this.alwaysUseTerminologyServer, readOnlyCache, this.locale, this.userAgent, this.allowLoadingDuplicates, this.loggingService);
        }

        public SimpleWorkerContextBuilder withLocale(Locale locale) {
            return this.locale == locale ? this : new SimpleWorkerContextBuilder(this.terminologyCachePath, this.cacheTerminologyClientErrors, this.alwaysUseTerminologyServer, this.readOnlyCache, locale, this.userAgent, this.allowLoadingDuplicates, this.loggingService);
        }

        public SimpleWorkerContextBuilder withUserAgent(String userAgent) {
            return this.userAgent == userAgent ? this : new SimpleWorkerContextBuilder(this.terminologyCachePath, this.cacheTerminologyClientErrors, this.alwaysUseTerminologyServer, this.readOnlyCache, this.locale, userAgent, this.allowLoadingDuplicates, this.loggingService);
        }

        public SimpleWorkerContextBuilder withAllowLoadingDuplicates(boolean allowLoadingDuplicates) {
            return this.allowLoadingDuplicates == allowLoadingDuplicates ? this : new SimpleWorkerContextBuilder(this.terminologyCachePath, this.cacheTerminologyClientErrors, this.alwaysUseTerminologyServer, this.readOnlyCache, this.locale, this.userAgent, allowLoadingDuplicates, this.loggingService);
        }

        public SimpleWorkerContextBuilder withLoggingService(IWorkerContext.ILoggingService loggingService) {
            return this.loggingService == loggingService ? this : new SimpleWorkerContextBuilder(this.terminologyCachePath, this.cacheTerminologyClientErrors, this.alwaysUseTerminologyServer, this.readOnlyCache, this.locale, this.userAgent, this.allowLoadingDuplicates, loggingService);
        }
    }

    public static interface IValidatorFactory {
        public IResourceValidator makeValidator(IWorkerContext var1) throws FHIRException;

        public IResourceValidator makeValidator(IWorkerContext var1, XVerExtensionManager var2) throws FHIRException;
    }

    public static interface ILoadFilter {
        public boolean isOkToLoad(Resource var1);

        public boolean isOkToLoad(String var1);
    }

    public static class PackageResourceLoader
    extends CanonicalResourceManager.CanonicalResourceProxy {
        private final String filename;
        private final IWorkerContext.IContextResourceLoader loader;

        public PackageResourceLoader(NpmPackage.PackageResourceInformation pri, IWorkerContext.IContextResourceLoader loader) {
            super(pri.getType(), pri.getId(), pri.getUrl(), pri.getVersion());
            this.filename = pri.getFilename();
            this.loader = loader;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public CanonicalResource loadResource() {
            try (FileInputStream f = new FileInputStream(this.filename);){
                if (this.loader != null) {
                    CanonicalResource canonicalResource = (CanonicalResource)this.loader.loadResource(f, true);
                    return canonicalResource;
                }
                CanonicalResource canonicalResource = (CanonicalResource)new JsonParser().parse(f);
                return canonicalResource;
            }
            catch (Exception e) {
                throw new FHIRException("Error loading " + this.filename + ": " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

