/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Base64BinaryType;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.Count;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Duration;
import org.hl7.fhir.r5.model.Endpoint;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Device", profile="http://hl7.org/fhir/StructureDefinition/Device")
public class Device
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Instance identifier", formalDefinition="Unique instance identifiers assigned to a device by manufacturers other organizations or owners.")
    protected List<Identifier> identifier;
    @Child(name="displayName", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The name used to display by default when the device is referenced", formalDefinition="The name used to display by default when the device is referenced. Based on intent of use by the resource creator, this may reflect one of the names in Device.deviceName, or may be another simple name.")
    protected StringType displayName;
    @Child(name="definition", type={CodeableReference.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The reference to the definition for the device", formalDefinition="The reference to the definition for the device.")
    protected CodeableReference definition;
    @Child(name="udiCarrier", type={}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Unique Device Identifier (UDI) Barcode string", formalDefinition="Unique device identifier (UDI) assigned to device label or package.  Note that the Device may include multiple udiCarriers as it either may include just the udiCarrier for the jurisdiction it is sold, or for multiple jurisdictions it could have been sold.")
    protected List<DeviceUdiCarrierComponent> udiCarrier;
    @Child(name="status", type={CodeType.class}, order=4, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | inactive | entered-in-error", formalDefinition="The Device record status. This is not the status of the device like availability.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/device-status")
    protected Enumeration<FHIRDeviceStatus> status;
    @Child(name="availabilityStatus", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="lost | damaged | destroyed | available", formalDefinition="The availability of the device.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/device-availability-status")
    protected CodeableConcept availabilityStatus;
    @Child(name="biologicalSourceEvent", type={Identifier.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="An identifier that supports traceability to the event during which material in this product from one or more biological entities was obtained or pooled", formalDefinition="An identifier that supports traceability to the event during which material in this product from one or more biological entities was obtained or pooled.")
    protected Identifier biologicalSourceEvent;
    @Child(name="manufacturer", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Name of device manufacturer", formalDefinition="A name of the manufacturer or entity legally responsible for the device.")
    protected StringType manufacturer;
    @Child(name="manufactureDate", type={DateTimeType.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Date when the device was made", formalDefinition="The date and time when the device was manufactured.")
    protected DateTimeType manufactureDate;
    @Child(name="expirationDate", type={DateTimeType.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Date and time of expiry of this device (if applicable)", formalDefinition="The date and time beyond which this device is no longer valid or should not be used (if applicable).")
    protected DateTimeType expirationDate;
    @Child(name="lotNumber", type={StringType.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Lot number of manufacture", formalDefinition="Lot number assigned by the manufacturer.")
    protected StringType lotNumber;
    @Child(name="serialNumber", type={StringType.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Serial number assigned by the manufacturer", formalDefinition="The serial number assigned by the organization when the device was manufactured.")
    protected StringType serialNumber;
    @Child(name="deviceName", type={}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The name or names of the device as known to the manufacturer and/or patient", formalDefinition="This represents the manufacturer's name of the device as provided by the device, from a UDI label, or by a person describing the Device.  This typically would be used when a person provides the name(s) or when the device represents one of the names available from DeviceDefinition.")
    protected List<DeviceDeviceNameComponent> deviceName;
    @Child(name="modelNumber", type={StringType.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The manufacturer's model number for the device", formalDefinition="The manufacturer's model number for the device.")
    protected StringType modelNumber;
    @Child(name="partNumber", type={StringType.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The part number or catalog number of the device", formalDefinition="The part number or catalog number of the device.")
    protected StringType partNumber;
    @Child(name="category", type={CodeableConcept.class}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Indicates a high-level grouping of the device", formalDefinition="Devices may be associated with one or more categories.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/device-category")
    protected List<CodeableConcept> category;
    @Child(name="type", type={CodeableConcept.class}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The kind or type of device", formalDefinition="The kind or type of device. A device instance may have more than one type - in which case those are the types that apply to the specific instance of the device.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/device-type")
    protected List<CodeableConcept> type;
    @Child(name="version", type={}, order=17, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The actual design of the device or software version running on the device", formalDefinition="The actual design of the device or software version running on the device.")
    protected List<DeviceVersionComponent> version;
    @Child(name="specialization", type={}, order=18, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The standard(s) the device supports", formalDefinition="The standards to which the device adheres and may be certified to in support of its capabilities, e.g., communication, performance, process, or measurement standards.")
    protected List<DeviceSpecializationComponent> specialization;
    @Child(name="property", type={}, order=19, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The actual configuration settings of a device as it actually operates, e.g., regulation status, time properties", formalDefinition="Characteristics or features of the device that are otherwise not captured in available attributes, e.g., actual configuration settings, time or timing attributes, resolution, accuracy, and physical attributes.  The focus is on properties of the device actually in use while DeviceDefinition focuses on properties that are available to be used.")
    protected List<DevicePropertyComponent> property;
    @Child(name="operation", type={}, order=20, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The details about the device when it is in use to describe the actions, conditions and status", formalDefinition="The status of the device itself - whether it is switched on, or activated, etc.")
    protected List<DeviceOperationComponent> operation;
    @Child(name="association", type={}, order=21, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Current association of the device", formalDefinition="The details about the device when it is affixed or inside of a patient.")
    protected List<DeviceAssociationComponent> association;
    @Child(name="owner", type={Organization.class}, order=22, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Organization responsible for device", formalDefinition="An organization that is responsible for the provision and ongoing maintenance of the device.")
    protected Reference owner;
    @Child(name="contact", type={ContactPoint.class}, order=23, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Details for human/organization for support", formalDefinition="Contact details for an organization or a particular human that is responsible for the device.")
    protected List<ContactPoint> contact;
    @Child(name="location", type={Location.class}, order=24, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Where the device is found", formalDefinition="The place where the device can be found.")
    protected Reference location;
    @Child(name="url", type={UriType.class}, order=25, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Network address to contact device", formalDefinition="A network address on which the device may be contacted directly.")
    protected UriType url;
    @Child(name="endpoint", type={Endpoint.class}, order=26, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Technical endpoints providing access to electronic services provided by the device", formalDefinition="Technical endpoints providing access to services provided by the device defined at this resource.")
    protected List<Reference> endpoint;
    @Child(name="gateway", type={CodeableReference.class}, order=27, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Linked device acting as a communication/data collector, translator or controller", formalDefinition="The linked device acting as a communication/data collector, translator or controller for the current device (e.g., mobile phone application that relays a blood pressure device's data).")
    protected List<CodeableReference> gateway;
    @Child(name="note", type={Annotation.class}, order=28, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Device notes and comments", formalDefinition="Descriptive information, usage information or implantation information that is not captured in an existing element.")
    protected List<Annotation> note;
    @Child(name="safety", type={CodeableConcept.class}, order=29, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Safety Characteristics of Device", formalDefinition="Provides additional safety characteristics about a medical device.  For example devices containing latex.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/device-safety")
    protected List<CodeableConcept> safety;
    @Child(name="parent", type={Device.class}, order=30, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The higher level or encompassing device that this device is a logical part of", formalDefinition="The higher level or encompassing device that this device is a logical part of.")
    protected Reference parent;
    private static final long serialVersionUID = 1481779790L;
    @SearchParamDefinition(name="biological-source-event", path="Device.biologicalSourceEvent", description="The biological source for the device", type="token")
    public static final String SP_BIOLOGICAL_SOURCE_EVENT = "biological-source-event";
    public static final TokenClientParam BIOLOGICAL_SOURCE_EVENT = new TokenClientParam("biological-source-event");
    @SearchParamDefinition(name="definition", path="Device.definition.reference", description="The definition / type of the device", type="reference")
    public static final String SP_DEFINITION = "definition";
    public static final ReferenceClientParam DEFINITION = new ReferenceClientParam("definition");
    public static final Include INCLUDE_DEFINITION = new Include("Device:definition").toLocked();
    @SearchParamDefinition(name="device-name", path="Device.deviceName.name | Device.type.coding.display | Device.type.text", description="A server defined search that may match any of the string fields in Device.deviceName or Device.type.", type="string")
    public static final String SP_DEVICE_NAME = "device-name";
    public static final StringClientParam DEVICE_NAME = new StringClientParam("device-name");
    @SearchParamDefinition(name="expiration-date", path="Device.expirationDate", description="The expiration date of the device", type="date")
    public static final String SP_EXPIRATION_DATE = "expiration-date";
    public static final DateClientParam EXPIRATION_DATE = new DateClientParam("expiration-date");
    @SearchParamDefinition(name="identifier", path="Device.identifier", description="Instance id from manufacturer, owner, and others", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="location", path="Device.location", description="A location, where the resource is found", type="reference", target={Location.class})
    public static final String SP_LOCATION = "location";
    public static final ReferenceClientParam LOCATION = new ReferenceClientParam("location");
    public static final Include INCLUDE_LOCATION = new Include("Device:location").toLocked();
    @SearchParamDefinition(name="lot-number", path="Device.lotNumber", description="The lot number of the device", type="string")
    public static final String SP_LOT_NUMBER = "lot-number";
    public static final StringClientParam LOT_NUMBER = new StringClientParam("lot-number");
    @SearchParamDefinition(name="manufacture-date", path="Device.manufactureDate", description="The manufacture date of the device", type="date")
    public static final String SP_MANUFACTURE_DATE = "manufacture-date";
    public static final DateClientParam MANUFACTURE_DATE = new DateClientParam("manufacture-date");
    @SearchParamDefinition(name="manufacturer", path="Device.manufacturer", description="The manufacturer of the device", type="string")
    public static final String SP_MANUFACTURER = "manufacturer";
    public static final StringClientParam MANUFACTURER = new StringClientParam("manufacturer");
    @SearchParamDefinition(name="model", path="Device.modelNumber", description="The model of the device", type="string")
    public static final String SP_MODEL = "model";
    public static final StringClientParam MODEL = new StringClientParam("model");
    @SearchParamDefinition(name="organization", path="Device.owner", description="The organization responsible for the device", type="reference", target={Organization.class})
    public static final String SP_ORGANIZATION = "organization";
    public static final ReferenceClientParam ORGANIZATION = new ReferenceClientParam("organization");
    public static final Include INCLUDE_ORGANIZATION = new Include("Device:organization").toLocked();
    @SearchParamDefinition(name="parent", path="Device.parent", description="The parent device", type="reference", target={Device.class})
    public static final String SP_PARENT = "parent";
    public static final ReferenceClientParam PARENT = new ReferenceClientParam("parent");
    public static final Include INCLUDE_PARENT = new Include("Device:parent").toLocked();
    @SearchParamDefinition(name="patient", path="Device.association.humanSubject.where(resolve() is Patient)", description="Patient information, if the resource is affixed to a person", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Device:patient").toLocked();
    @SearchParamDefinition(name="serial-number", path="Device.serialNumber | Device.identifier.where(type='SNO')", description="The serial number of the device", type="string")
    public static final String SP_SERIAL_NUMBER = "serial-number";
    public static final StringClientParam SERIAL_NUMBER = new StringClientParam("serial-number");
    @SearchParamDefinition(name="status", path="Device.status", description="active | inactive | entered-in-error | unknown", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject", path="Device.association.humanSubject", description="Subject to which the device is associated of affixed", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Device:subject").toLocked();
    @SearchParamDefinition(name="type", path="Device.type", description="The type of the device", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="udi-carrier", path="Device.udiCarrier.carrierHRF", description="UDI Barcode (RFID or other technology) string in *HRF* format.", type="string")
    public static final String SP_UDI_CARRIER = "udi-carrier";
    public static final StringClientParam UDI_CARRIER = new StringClientParam("udi-carrier");
    @SearchParamDefinition(name="udi-di", path="Device.udiCarrier.deviceIdentifier", description="The udi Device Identifier (DI)", type="string")
    public static final String SP_UDI_DI = "udi-di";
    public static final StringClientParam UDI_DI = new StringClientParam("udi-di");
    @SearchParamDefinition(name="url", path="Device.url", description="Network address to contact device", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="version", path="Device.version.value", description="The specific version of the device", type="string")
    public static final String SP_VERSION = "version";
    public static final StringClientParam VERSION = new StringClientParam("version");
    @SearchParamDefinition(name="din", path="Device.extension('http://hl7.org/fhir/SearchParameter/device-extensions-Device-din').value", description="The donation identification number (DIN)", type="token")
    public static final String SP_DIN = "din";
    public static final TokenClientParam DIN = new TokenClientParam("din");

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Device setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Device addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public StringType getDisplayNameElement() {
        if (this.displayName == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.displayName");
            }
            if (Configuration.doAutoCreate()) {
                this.displayName = new StringType();
            }
        }
        return this.displayName;
    }

    public boolean hasDisplayNameElement() {
        return this.displayName != null && !this.displayName.isEmpty();
    }

    public boolean hasDisplayName() {
        return this.displayName != null && !this.displayName.isEmpty();
    }

    public Device setDisplayNameElement(StringType value) {
        this.displayName = value;
        return this;
    }

    public String getDisplayName() {
        return this.displayName == null ? null : (String)this.displayName.getValue();
    }

    public Device setDisplayName(String value) {
        if (Utilities.noString((String)value)) {
            this.displayName = null;
        } else {
            if (this.displayName == null) {
                this.displayName = new StringType();
            }
            this.displayName.setValue(value);
        }
        return this;
    }

    public CodeableReference getDefinition() {
        if (this.definition == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.definition");
            }
            if (Configuration.doAutoCreate()) {
                this.definition = new CodeableReference();
            }
        }
        return this.definition;
    }

    public boolean hasDefinition() {
        return this.definition != null && !this.definition.isEmpty();
    }

    public Device setDefinition(CodeableReference value) {
        this.definition = value;
        return this;
    }

    public List<DeviceUdiCarrierComponent> getUdiCarrier() {
        if (this.udiCarrier == null) {
            this.udiCarrier = new ArrayList<DeviceUdiCarrierComponent>();
        }
        return this.udiCarrier;
    }

    public Device setUdiCarrier(List<DeviceUdiCarrierComponent> theUdiCarrier) {
        this.udiCarrier = theUdiCarrier;
        return this;
    }

    public boolean hasUdiCarrier() {
        if (this.udiCarrier == null) {
            return false;
        }
        for (DeviceUdiCarrierComponent item : this.udiCarrier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DeviceUdiCarrierComponent addUdiCarrier() {
        DeviceUdiCarrierComponent t = new DeviceUdiCarrierComponent();
        if (this.udiCarrier == null) {
            this.udiCarrier = new ArrayList<DeviceUdiCarrierComponent>();
        }
        this.udiCarrier.add(t);
        return t;
    }

    public Device addUdiCarrier(DeviceUdiCarrierComponent t) {
        if (t == null) {
            return this;
        }
        if (this.udiCarrier == null) {
            this.udiCarrier = new ArrayList<DeviceUdiCarrierComponent>();
        }
        this.udiCarrier.add(t);
        return this;
    }

    public DeviceUdiCarrierComponent getUdiCarrierFirstRep() {
        if (this.getUdiCarrier().isEmpty()) {
            this.addUdiCarrier();
        }
        return this.getUdiCarrier().get(0);
    }

    public Enumeration<FHIRDeviceStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<FHIRDeviceStatus>(new FHIRDeviceStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Device setStatusElement(Enumeration<FHIRDeviceStatus> value) {
        this.status = value;
        return this;
    }

    public FHIRDeviceStatus getStatus() {
        return this.status == null ? null : (FHIRDeviceStatus)((Object)this.status.getValue());
    }

    public Device setStatus(FHIRDeviceStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<FHIRDeviceStatus>(new FHIRDeviceStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public CodeableConcept getAvailabilityStatus() {
        if (this.availabilityStatus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.availabilityStatus");
            }
            if (Configuration.doAutoCreate()) {
                this.availabilityStatus = new CodeableConcept();
            }
        }
        return this.availabilityStatus;
    }

    public boolean hasAvailabilityStatus() {
        return this.availabilityStatus != null && !this.availabilityStatus.isEmpty();
    }

    public Device setAvailabilityStatus(CodeableConcept value) {
        this.availabilityStatus = value;
        return this;
    }

    public Identifier getBiologicalSourceEvent() {
        if (this.biologicalSourceEvent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.biologicalSourceEvent");
            }
            if (Configuration.doAutoCreate()) {
                this.biologicalSourceEvent = new Identifier();
            }
        }
        return this.biologicalSourceEvent;
    }

    public boolean hasBiologicalSourceEvent() {
        return this.biologicalSourceEvent != null && !this.biologicalSourceEvent.isEmpty();
    }

    public Device setBiologicalSourceEvent(Identifier value) {
        this.biologicalSourceEvent = value;
        return this;
    }

    public StringType getManufacturerElement() {
        if (this.manufacturer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.manufacturer");
            }
            if (Configuration.doAutoCreate()) {
                this.manufacturer = new StringType();
            }
        }
        return this.manufacturer;
    }

    public boolean hasManufacturerElement() {
        return this.manufacturer != null && !this.manufacturer.isEmpty();
    }

    public boolean hasManufacturer() {
        return this.manufacturer != null && !this.manufacturer.isEmpty();
    }

    public Device setManufacturerElement(StringType value) {
        this.manufacturer = value;
        return this;
    }

    public String getManufacturer() {
        return this.manufacturer == null ? null : (String)this.manufacturer.getValue();
    }

    public Device setManufacturer(String value) {
        if (Utilities.noString((String)value)) {
            this.manufacturer = null;
        } else {
            if (this.manufacturer == null) {
                this.manufacturer = new StringType();
            }
            this.manufacturer.setValue(value);
        }
        return this;
    }

    public DateTimeType getManufactureDateElement() {
        if (this.manufactureDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.manufactureDate");
            }
            if (Configuration.doAutoCreate()) {
                this.manufactureDate = new DateTimeType();
            }
        }
        return this.manufactureDate;
    }

    public boolean hasManufactureDateElement() {
        return this.manufactureDate != null && !this.manufactureDate.isEmpty();
    }

    public boolean hasManufactureDate() {
        return this.manufactureDate != null && !this.manufactureDate.isEmpty();
    }

    public Device setManufactureDateElement(DateTimeType value) {
        this.manufactureDate = value;
        return this;
    }

    public Date getManufactureDate() {
        return this.manufactureDate == null ? null : (Date)this.manufactureDate.getValue();
    }

    public Device setManufactureDate(Date value) {
        if (value == null) {
            this.manufactureDate = null;
        } else {
            if (this.manufactureDate == null) {
                this.manufactureDate = new DateTimeType();
            }
            this.manufactureDate.setValue(value);
        }
        return this;
    }

    public DateTimeType getExpirationDateElement() {
        if (this.expirationDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.expirationDate");
            }
            if (Configuration.doAutoCreate()) {
                this.expirationDate = new DateTimeType();
            }
        }
        return this.expirationDate;
    }

    public boolean hasExpirationDateElement() {
        return this.expirationDate != null && !this.expirationDate.isEmpty();
    }

    public boolean hasExpirationDate() {
        return this.expirationDate != null && !this.expirationDate.isEmpty();
    }

    public Device setExpirationDateElement(DateTimeType value) {
        this.expirationDate = value;
        return this;
    }

    public Date getExpirationDate() {
        return this.expirationDate == null ? null : (Date)this.expirationDate.getValue();
    }

    public Device setExpirationDate(Date value) {
        if (value == null) {
            this.expirationDate = null;
        } else {
            if (this.expirationDate == null) {
                this.expirationDate = new DateTimeType();
            }
            this.expirationDate.setValue(value);
        }
        return this;
    }

    public StringType getLotNumberElement() {
        if (this.lotNumber == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.lotNumber");
            }
            if (Configuration.doAutoCreate()) {
                this.lotNumber = new StringType();
            }
        }
        return this.lotNumber;
    }

    public boolean hasLotNumberElement() {
        return this.lotNumber != null && !this.lotNumber.isEmpty();
    }

    public boolean hasLotNumber() {
        return this.lotNumber != null && !this.lotNumber.isEmpty();
    }

    public Device setLotNumberElement(StringType value) {
        this.lotNumber = value;
        return this;
    }

    public String getLotNumber() {
        return this.lotNumber == null ? null : (String)this.lotNumber.getValue();
    }

    public Device setLotNumber(String value) {
        if (Utilities.noString((String)value)) {
            this.lotNumber = null;
        } else {
            if (this.lotNumber == null) {
                this.lotNumber = new StringType();
            }
            this.lotNumber.setValue(value);
        }
        return this;
    }

    public StringType getSerialNumberElement() {
        if (this.serialNumber == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.serialNumber");
            }
            if (Configuration.doAutoCreate()) {
                this.serialNumber = new StringType();
            }
        }
        return this.serialNumber;
    }

    public boolean hasSerialNumberElement() {
        return this.serialNumber != null && !this.serialNumber.isEmpty();
    }

    public boolean hasSerialNumber() {
        return this.serialNumber != null && !this.serialNumber.isEmpty();
    }

    public Device setSerialNumberElement(StringType value) {
        this.serialNumber = value;
        return this;
    }

    public String getSerialNumber() {
        return this.serialNumber == null ? null : (String)this.serialNumber.getValue();
    }

    public Device setSerialNumber(String value) {
        if (Utilities.noString((String)value)) {
            this.serialNumber = null;
        } else {
            if (this.serialNumber == null) {
                this.serialNumber = new StringType();
            }
            this.serialNumber.setValue(value);
        }
        return this;
    }

    public List<DeviceDeviceNameComponent> getDeviceName() {
        if (this.deviceName == null) {
            this.deviceName = new ArrayList<DeviceDeviceNameComponent>();
        }
        return this.deviceName;
    }

    public Device setDeviceName(List<DeviceDeviceNameComponent> theDeviceName) {
        this.deviceName = theDeviceName;
        return this;
    }

    public boolean hasDeviceName() {
        if (this.deviceName == null) {
            return false;
        }
        for (DeviceDeviceNameComponent item : this.deviceName) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DeviceDeviceNameComponent addDeviceName() {
        DeviceDeviceNameComponent t = new DeviceDeviceNameComponent();
        if (this.deviceName == null) {
            this.deviceName = new ArrayList<DeviceDeviceNameComponent>();
        }
        this.deviceName.add(t);
        return t;
    }

    public Device addDeviceName(DeviceDeviceNameComponent t) {
        if (t == null) {
            return this;
        }
        if (this.deviceName == null) {
            this.deviceName = new ArrayList<DeviceDeviceNameComponent>();
        }
        this.deviceName.add(t);
        return this;
    }

    public DeviceDeviceNameComponent getDeviceNameFirstRep() {
        if (this.getDeviceName().isEmpty()) {
            this.addDeviceName();
        }
        return this.getDeviceName().get(0);
    }

    public StringType getModelNumberElement() {
        if (this.modelNumber == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.modelNumber");
            }
            if (Configuration.doAutoCreate()) {
                this.modelNumber = new StringType();
            }
        }
        return this.modelNumber;
    }

    public boolean hasModelNumberElement() {
        return this.modelNumber != null && !this.modelNumber.isEmpty();
    }

    public boolean hasModelNumber() {
        return this.modelNumber != null && !this.modelNumber.isEmpty();
    }

    public Device setModelNumberElement(StringType value) {
        this.modelNumber = value;
        return this;
    }

    public String getModelNumber() {
        return this.modelNumber == null ? null : (String)this.modelNumber.getValue();
    }

    public Device setModelNumber(String value) {
        if (Utilities.noString((String)value)) {
            this.modelNumber = null;
        } else {
            if (this.modelNumber == null) {
                this.modelNumber = new StringType();
            }
            this.modelNumber.setValue(value);
        }
        return this;
    }

    public StringType getPartNumberElement() {
        if (this.partNumber == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.partNumber");
            }
            if (Configuration.doAutoCreate()) {
                this.partNumber = new StringType();
            }
        }
        return this.partNumber;
    }

    public boolean hasPartNumberElement() {
        return this.partNumber != null && !this.partNumber.isEmpty();
    }

    public boolean hasPartNumber() {
        return this.partNumber != null && !this.partNumber.isEmpty();
    }

    public Device setPartNumberElement(StringType value) {
        this.partNumber = value;
        return this;
    }

    public String getPartNumber() {
        return this.partNumber == null ? null : (String)this.partNumber.getValue();
    }

    public Device setPartNumber(String value) {
        if (Utilities.noString((String)value)) {
            this.partNumber = null;
        } else {
            if (this.partNumber == null) {
                this.partNumber = new StringType();
            }
            this.partNumber.setValue(value);
        }
        return this;
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public Device setCategory(List<CodeableConcept> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public Device addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public List<CodeableConcept> getType() {
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        return this.type;
    }

    public Device setType(List<CodeableConcept> theType) {
        this.type = theType;
        return this;
    }

    public boolean hasType() {
        if (this.type == null) {
            return false;
        }
        for (CodeableConcept item : this.type) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addType() {
        CodeableConcept t = new CodeableConcept();
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        this.type.add(t);
        return t;
    }

    public Device addType(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        this.type.add(t);
        return this;
    }

    public CodeableConcept getTypeFirstRep() {
        if (this.getType().isEmpty()) {
            this.addType();
        }
        return this.getType().get(0);
    }

    public List<DeviceVersionComponent> getVersion() {
        if (this.version == null) {
            this.version = new ArrayList<DeviceVersionComponent>();
        }
        return this.version;
    }

    public Device setVersion(List<DeviceVersionComponent> theVersion) {
        this.version = theVersion;
        return this;
    }

    public boolean hasVersion() {
        if (this.version == null) {
            return false;
        }
        for (DeviceVersionComponent item : this.version) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DeviceVersionComponent addVersion() {
        DeviceVersionComponent t = new DeviceVersionComponent();
        if (this.version == null) {
            this.version = new ArrayList<DeviceVersionComponent>();
        }
        this.version.add(t);
        return t;
    }

    public Device addVersion(DeviceVersionComponent t) {
        if (t == null) {
            return this;
        }
        if (this.version == null) {
            this.version = new ArrayList<DeviceVersionComponent>();
        }
        this.version.add(t);
        return this;
    }

    public DeviceVersionComponent getVersionFirstRep() {
        if (this.getVersion().isEmpty()) {
            this.addVersion();
        }
        return this.getVersion().get(0);
    }

    public List<DeviceSpecializationComponent> getSpecialization() {
        if (this.specialization == null) {
            this.specialization = new ArrayList<DeviceSpecializationComponent>();
        }
        return this.specialization;
    }

    public Device setSpecialization(List<DeviceSpecializationComponent> theSpecialization) {
        this.specialization = theSpecialization;
        return this;
    }

    public boolean hasSpecialization() {
        if (this.specialization == null) {
            return false;
        }
        for (DeviceSpecializationComponent item : this.specialization) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DeviceSpecializationComponent addSpecialization() {
        DeviceSpecializationComponent t = new DeviceSpecializationComponent();
        if (this.specialization == null) {
            this.specialization = new ArrayList<DeviceSpecializationComponent>();
        }
        this.specialization.add(t);
        return t;
    }

    public Device addSpecialization(DeviceSpecializationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.specialization == null) {
            this.specialization = new ArrayList<DeviceSpecializationComponent>();
        }
        this.specialization.add(t);
        return this;
    }

    public DeviceSpecializationComponent getSpecializationFirstRep() {
        if (this.getSpecialization().isEmpty()) {
            this.addSpecialization();
        }
        return this.getSpecialization().get(0);
    }

    public List<DevicePropertyComponent> getProperty() {
        if (this.property == null) {
            this.property = new ArrayList<DevicePropertyComponent>();
        }
        return this.property;
    }

    public Device setProperty(List<DevicePropertyComponent> theProperty) {
        this.property = theProperty;
        return this;
    }

    public boolean hasProperty() {
        if (this.property == null) {
            return false;
        }
        for (DevicePropertyComponent item : this.property) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DevicePropertyComponent addProperty() {
        DevicePropertyComponent t = new DevicePropertyComponent();
        if (this.property == null) {
            this.property = new ArrayList<DevicePropertyComponent>();
        }
        this.property.add(t);
        return t;
    }

    public Device addProperty(DevicePropertyComponent t) {
        if (t == null) {
            return this;
        }
        if (this.property == null) {
            this.property = new ArrayList<DevicePropertyComponent>();
        }
        this.property.add(t);
        return this;
    }

    public DevicePropertyComponent getPropertyFirstRep() {
        if (this.getProperty().isEmpty()) {
            this.addProperty();
        }
        return this.getProperty().get(0);
    }

    public List<DeviceOperationComponent> getOperation() {
        if (this.operation == null) {
            this.operation = new ArrayList<DeviceOperationComponent>();
        }
        return this.operation;
    }

    public Device setOperation(List<DeviceOperationComponent> theOperation) {
        this.operation = theOperation;
        return this;
    }

    public boolean hasOperation() {
        if (this.operation == null) {
            return false;
        }
        for (DeviceOperationComponent item : this.operation) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DeviceOperationComponent addOperation() {
        DeviceOperationComponent t = new DeviceOperationComponent();
        if (this.operation == null) {
            this.operation = new ArrayList<DeviceOperationComponent>();
        }
        this.operation.add(t);
        return t;
    }

    public Device addOperation(DeviceOperationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.operation == null) {
            this.operation = new ArrayList<DeviceOperationComponent>();
        }
        this.operation.add(t);
        return this;
    }

    public DeviceOperationComponent getOperationFirstRep() {
        if (this.getOperation().isEmpty()) {
            this.addOperation();
        }
        return this.getOperation().get(0);
    }

    public List<DeviceAssociationComponent> getAssociation() {
        if (this.association == null) {
            this.association = new ArrayList<DeviceAssociationComponent>();
        }
        return this.association;
    }

    public Device setAssociation(List<DeviceAssociationComponent> theAssociation) {
        this.association = theAssociation;
        return this;
    }

    public boolean hasAssociation() {
        if (this.association == null) {
            return false;
        }
        for (DeviceAssociationComponent item : this.association) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DeviceAssociationComponent addAssociation() {
        DeviceAssociationComponent t = new DeviceAssociationComponent();
        if (this.association == null) {
            this.association = new ArrayList<DeviceAssociationComponent>();
        }
        this.association.add(t);
        return t;
    }

    public Device addAssociation(DeviceAssociationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.association == null) {
            this.association = new ArrayList<DeviceAssociationComponent>();
        }
        this.association.add(t);
        return this;
    }

    public DeviceAssociationComponent getAssociationFirstRep() {
        if (this.getAssociation().isEmpty()) {
            this.addAssociation();
        }
        return this.getAssociation().get(0);
    }

    public Reference getOwner() {
        if (this.owner == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.owner");
            }
            if (Configuration.doAutoCreate()) {
                this.owner = new Reference();
            }
        }
        return this.owner;
    }

    public boolean hasOwner() {
        return this.owner != null && !this.owner.isEmpty();
    }

    public Device setOwner(Reference value) {
        this.owner = value;
        return this;
    }

    public List<ContactPoint> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactPoint>();
        }
        return this.contact;
    }

    public Device setContact(List<ContactPoint> theContact) {
        this.contact = theContact;
        return this;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactPoint item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactPoint addContact() {
        ContactPoint t = new ContactPoint();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactPoint>();
        }
        this.contact.add(t);
        return t;
    }

    public Device addContact(ContactPoint t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactPoint>();
        }
        this.contact.add(t);
        return this;
    }

    public ContactPoint getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    public Reference getLocation() {
        if (this.location == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.location");
            }
            if (Configuration.doAutoCreate()) {
                this.location = new Reference();
            }
        }
        return this.location;
    }

    public boolean hasLocation() {
        return this.location != null && !this.location.isEmpty();
    }

    public Device setLocation(Reference value) {
        this.location = value;
        return this;
    }

    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    public Device setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    public Device setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    public List<Reference> getEndpoint() {
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        return this.endpoint;
    }

    public Device setEndpoint(List<Reference> theEndpoint) {
        this.endpoint = theEndpoint;
        return this;
    }

    public boolean hasEndpoint() {
        if (this.endpoint == null) {
            return false;
        }
        for (Reference item : this.endpoint) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addEndpoint() {
        Reference t = new Reference();
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        this.endpoint.add(t);
        return t;
    }

    public Device addEndpoint(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        this.endpoint.add(t);
        return this;
    }

    public Reference getEndpointFirstRep() {
        if (this.getEndpoint().isEmpty()) {
            this.addEndpoint();
        }
        return this.getEndpoint().get(0);
    }

    public List<CodeableReference> getGateway() {
        if (this.gateway == null) {
            this.gateway = new ArrayList<CodeableReference>();
        }
        return this.gateway;
    }

    public Device setGateway(List<CodeableReference> theGateway) {
        this.gateway = theGateway;
        return this;
    }

    public boolean hasGateway() {
        if (this.gateway == null) {
            return false;
        }
        for (CodeableReference item : this.gateway) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableReference addGateway() {
        CodeableReference t = new CodeableReference();
        if (this.gateway == null) {
            this.gateway = new ArrayList<CodeableReference>();
        }
        this.gateway.add(t);
        return t;
    }

    public Device addGateway(CodeableReference t) {
        if (t == null) {
            return this;
        }
        if (this.gateway == null) {
            this.gateway = new ArrayList<CodeableReference>();
        }
        this.gateway.add(t);
        return this;
    }

    public CodeableReference getGatewayFirstRep() {
        if (this.getGateway().isEmpty()) {
            this.addGateway();
        }
        return this.getGateway().get(0);
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public Device setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public Device addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public List<CodeableConcept> getSafety() {
        if (this.safety == null) {
            this.safety = new ArrayList<CodeableConcept>();
        }
        return this.safety;
    }

    public Device setSafety(List<CodeableConcept> theSafety) {
        this.safety = theSafety;
        return this;
    }

    public boolean hasSafety() {
        if (this.safety == null) {
            return false;
        }
        for (CodeableConcept item : this.safety) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addSafety() {
        CodeableConcept t = new CodeableConcept();
        if (this.safety == null) {
            this.safety = new ArrayList<CodeableConcept>();
        }
        this.safety.add(t);
        return t;
    }

    public Device addSafety(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.safety == null) {
            this.safety = new ArrayList<CodeableConcept>();
        }
        this.safety.add(t);
        return this;
    }

    public CodeableConcept getSafetyFirstRep() {
        if (this.getSafety().isEmpty()) {
            this.addSafety();
        }
        return this.getSafety().get(0);
    }

    public Reference getParent() {
        if (this.parent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.parent");
            }
            if (Configuration.doAutoCreate()) {
                this.parent = new Reference();
            }
        }
        return this.parent;
    }

    public boolean hasParent() {
        return this.parent != null && !this.parent.isEmpty();
    }

    public Device setParent(Reference value) {
        this.parent = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Unique instance identifiers assigned to a device by manufacturers other organizations or owners.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("displayName", "string", "The name used to display by default when the device is referenced. Based on intent of use by the resource creator, this may reflect one of the names in Device.deviceName, or may be another simple name.", 0, 1, this.displayName));
        children.add(new Property(SP_DEFINITION, "CodeableReference(DeviceDefinition)", "The reference to the definition for the device.", 0, 1, this.definition));
        children.add(new Property("udiCarrier", "", "Unique device identifier (UDI) assigned to device label or package.  Note that the Device may include multiple udiCarriers as it either may include just the udiCarrier for the jurisdiction it is sold, or for multiple jurisdictions it could have been sold.", 0, Integer.MAX_VALUE, this.udiCarrier));
        children.add(new Property(SP_STATUS, "code", "The Device record status. This is not the status of the device like availability.", 0, 1, this.status));
        children.add(new Property("availabilityStatus", "CodeableConcept", "The availability of the device.", 0, 1, this.availabilityStatus));
        children.add(new Property("biologicalSourceEvent", "Identifier", "An identifier that supports traceability to the event during which material in this product from one or more biological entities was obtained or pooled.", 0, 1, this.biologicalSourceEvent));
        children.add(new Property(SP_MANUFACTURER, "string", "A name of the manufacturer or entity legally responsible for the device.", 0, 1, this.manufacturer));
        children.add(new Property("manufactureDate", "dateTime", "The date and time when the device was manufactured.", 0, 1, this.manufactureDate));
        children.add(new Property("expirationDate", "dateTime", "The date and time beyond which this device is no longer valid or should not be used (if applicable).", 0, 1, this.expirationDate));
        children.add(new Property("lotNumber", "string", "Lot number assigned by the manufacturer.", 0, 1, this.lotNumber));
        children.add(new Property("serialNumber", "string", "The serial number assigned by the organization when the device was manufactured.", 0, 1, this.serialNumber));
        children.add(new Property("deviceName", "", "This represents the manufacturer's name of the device as provided by the device, from a UDI label, or by a person describing the Device.  This typically would be used when a person provides the name(s) or when the device represents one of the names available from DeviceDefinition.", 0, Integer.MAX_VALUE, this.deviceName));
        children.add(new Property("modelNumber", "string", "The manufacturer's model number for the device.", 0, 1, this.modelNumber));
        children.add(new Property("partNumber", "string", "The part number or catalog number of the device.", 0, 1, this.partNumber));
        children.add(new Property("category", "CodeableConcept", "Devices may be associated with one or more categories.", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property(SP_TYPE, "CodeableConcept", "The kind or type of device. A device instance may have more than one type - in which case those are the types that apply to the specific instance of the device.", 0, Integer.MAX_VALUE, this.type));
        children.add(new Property(SP_VERSION, "", "The actual design of the device or software version running on the device.", 0, Integer.MAX_VALUE, this.version));
        children.add(new Property("specialization", "", "The standards to which the device adheres and may be certified to in support of its capabilities, e.g., communication, performance, process, or measurement standards.", 0, Integer.MAX_VALUE, this.specialization));
        children.add(new Property("property", "", "Characteristics or features of the device that are otherwise not captured in available attributes, e.g., actual configuration settings, time or timing attributes, resolution, accuracy, and physical attributes.  The focus is on properties of the device actually in use while DeviceDefinition focuses on properties that are available to be used.", 0, Integer.MAX_VALUE, this.property));
        children.add(new Property("operation", "", "The status of the device itself - whether it is switched on, or activated, etc.", 0, Integer.MAX_VALUE, this.operation));
        children.add(new Property("association", "", "The details about the device when it is affixed or inside of a patient.", 0, Integer.MAX_VALUE, this.association));
        children.add(new Property("owner", "Reference(Organization)", "An organization that is responsible for the provision and ongoing maintenance of the device.", 0, 1, this.owner));
        children.add(new Property("contact", "ContactPoint", "Contact details for an organization or a particular human that is responsible for the device.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_LOCATION, "Reference(Location)", "The place where the device can be found.", 0, 1, this.location));
        children.add(new Property(SP_URL, "uri", "A network address on which the device may be contacted directly.", 0, 1, this.url));
        children.add(new Property("endpoint", "Reference(Endpoint)", "Technical endpoints providing access to services provided by the device defined at this resource.", 0, Integer.MAX_VALUE, this.endpoint));
        children.add(new Property("gateway", "CodeableReference(Device)", "The linked device acting as a communication/data collector, translator or controller for the current device (e.g., mobile phone application that relays a blood pressure device's data).", 0, Integer.MAX_VALUE, this.gateway));
        children.add(new Property("note", "Annotation", "Descriptive information, usage information or implantation information that is not captured in an existing element.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("safety", "CodeableConcept", "Provides additional safety characteristics about a medical device.  For example devices containing latex.", 0, Integer.MAX_VALUE, this.safety));
        children.add(new Property(SP_PARENT, "Reference(Device)", "The higher level or encompassing device that this device is a logical part of.", 0, 1, this.parent));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Unique instance identifiers assigned to a device by manufacturers other organizations or owners.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 1714148973: {
                return new Property("displayName", "string", "The name used to display by default when the device is referenced. Based on intent of use by the resource creator, this may reflect one of the names in Device.deviceName, or may be another simple name.", 0, 1, this.displayName);
            }
            case -1014418093: {
                return new Property(SP_DEFINITION, "CodeableReference(DeviceDefinition)", "The reference to the definition for the device.", 0, 1, this.definition);
            }
            case -1343558178: {
                return new Property("udiCarrier", "", "Unique device identifier (UDI) assigned to device label or package.  Note that the Device may include multiple udiCarriers as it either may include just the udiCarrier for the jurisdiction it is sold, or for multiple jurisdictions it could have been sold.", 0, Integer.MAX_VALUE, this.udiCarrier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The Device record status. This is not the status of the device like availability.", 0, 1, this.status);
            }
            case 804659501: {
                return new Property("availabilityStatus", "CodeableConcept", "The availability of the device.", 0, 1, this.availabilityStatus);
            }
            case -654468482: {
                return new Property("biologicalSourceEvent", "Identifier", "An identifier that supports traceability to the event during which material in this product from one or more biological entities was obtained or pooled.", 0, 1, this.biologicalSourceEvent);
            }
            case -1969347631: {
                return new Property(SP_MANUFACTURER, "string", "A name of the manufacturer or entity legally responsible for the device.", 0, 1, this.manufacturer);
            }
            case 416714767: {
                return new Property("manufactureDate", "dateTime", "The date and time when the device was manufactured.", 0, 1, this.manufactureDate);
            }
            case -668811523: {
                return new Property("expirationDate", "dateTime", "The date and time beyond which this device is no longer valid or should not be used (if applicable).", 0, 1, this.expirationDate);
            }
            case 462547450: {
                return new Property("lotNumber", "string", "Lot number assigned by the manufacturer.", 0, 1, this.lotNumber);
            }
            case 83787357: {
                return new Property("serialNumber", "string", "The serial number assigned by the organization when the device was manufactured.", 0, 1, this.serialNumber);
            }
            case 780988929: {
                return new Property("deviceName", "", "This represents the manufacturer's name of the device as provided by the device, from a UDI label, or by a person describing the Device.  This typically would be used when a person provides the name(s) or when the device represents one of the names available from DeviceDefinition.", 0, Integer.MAX_VALUE, this.deviceName);
            }
            case 346619858: {
                return new Property("modelNumber", "string", "The manufacturer's model number for the device.", 0, 1, this.modelNumber);
            }
            case -731502308: {
                return new Property("partNumber", "string", "The part number or catalog number of the device.", 0, 1, this.partNumber);
            }
            case 50511102: {
                return new Property("category", "CodeableConcept", "Devices may be associated with one or more categories.", 0, Integer.MAX_VALUE, this.category);
            }
            case 3575610: {
                return new Property(SP_TYPE, "CodeableConcept", "The kind or type of device. A device instance may have more than one type - in which case those are the types that apply to the specific instance of the device.", 0, Integer.MAX_VALUE, this.type);
            }
            case 351608024: {
                return new Property(SP_VERSION, "", "The actual design of the device or software version running on the device.", 0, Integer.MAX_VALUE, this.version);
            }
            case 682815883: {
                return new Property("specialization", "", "The standards to which the device adheres and may be certified to in support of its capabilities, e.g., communication, performance, process, or measurement standards.", 0, Integer.MAX_VALUE, this.specialization);
            }
            case -993141291: {
                return new Property("property", "", "Characteristics or features of the device that are otherwise not captured in available attributes, e.g., actual configuration settings, time or timing attributes, resolution, accuracy, and physical attributes.  The focus is on properties of the device actually in use while DeviceDefinition focuses on properties that are available to be used.", 0, Integer.MAX_VALUE, this.property);
            }
            case 1662702951: {
                return new Property("operation", "", "The status of the device itself - whether it is switched on, or activated, etc.", 0, Integer.MAX_VALUE, this.operation);
            }
            case -87499647: {
                return new Property("association", "", "The details about the device when it is affixed or inside of a patient.", 0, Integer.MAX_VALUE, this.association);
            }
            case 106164915: {
                return new Property("owner", "Reference(Organization)", "An organization that is responsible for the provision and ongoing maintenance of the device.", 0, 1, this.owner);
            }
            case 951526432: {
                return new Property("contact", "ContactPoint", "Contact details for an organization or a particular human that is responsible for the device.", 0, Integer.MAX_VALUE, this.contact);
            }
            case 1901043637: {
                return new Property(SP_LOCATION, "Reference(Location)", "The place where the device can be found.", 0, 1, this.location);
            }
            case 116079: {
                return new Property(SP_URL, "uri", "A network address on which the device may be contacted directly.", 0, 1, this.url);
            }
            case 1741102485: {
                return new Property("endpoint", "Reference(Endpoint)", "Technical endpoints providing access to services provided by the device defined at this resource.", 0, Integer.MAX_VALUE, this.endpoint);
            }
            case -189118908: {
                return new Property("gateway", "CodeableReference(Device)", "The linked device acting as a communication/data collector, translator or controller for the current device (e.g., mobile phone application that relays a blood pressure device's data).", 0, Integer.MAX_VALUE, this.gateway);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Descriptive information, usage information or implantation information that is not captured in an existing element.", 0, Integer.MAX_VALUE, this.note);
            }
            case -909893934: {
                return new Property("safety", "CodeableConcept", "Provides additional safety characteristics about a medical device.  For example devices containing latex.", 0, Integer.MAX_VALUE, this.safety);
            }
            case -995424086: {
                return new Property(SP_PARENT, "Reference(Device)", "The higher level or encompassing device that this device is a logical part of.", 0, 1, this.parent);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 1714148973: {
                Base[] baseArray;
                if (this.displayName == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.displayName;
                }
                return baseArray;
            }
            case -1014418093: {
                Base[] baseArray;
                if (this.definition == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.definition;
                }
                return baseArray;
            }
            case -1343558178: {
                return this.udiCarrier == null ? new Base[]{} : this.udiCarrier.toArray(new Base[this.udiCarrier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.status;
                }
                return baseArray;
            }
            case 804659501: {
                Base[] baseArray;
                if (this.availabilityStatus == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.availabilityStatus;
                }
                return baseArray;
            }
            case -654468482: {
                Base[] baseArray;
                if (this.biologicalSourceEvent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.biologicalSourceEvent;
                }
                return baseArray;
            }
            case -1969347631: {
                Base[] baseArray;
                if (this.manufacturer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.manufacturer;
                }
                return baseArray;
            }
            case 416714767: {
                Base[] baseArray;
                if (this.manufactureDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.manufactureDate;
                }
                return baseArray;
            }
            case -668811523: {
                Base[] baseArray;
                if (this.expirationDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.expirationDate;
                }
                return baseArray;
            }
            case 462547450: {
                Base[] baseArray;
                if (this.lotNumber == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.lotNumber;
                }
                return baseArray;
            }
            case 83787357: {
                Base[] baseArray;
                if (this.serialNumber == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.serialNumber;
                }
                return baseArray;
            }
            case 780988929: {
                return this.deviceName == null ? new Base[]{} : this.deviceName.toArray(new Base[this.deviceName.size()]);
            }
            case 346619858: {
                Base[] baseArray;
                if (this.modelNumber == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.modelNumber;
                }
                return baseArray;
            }
            case -731502308: {
                Base[] baseArray;
                if (this.partNumber == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.partNumber;
                }
                return baseArray;
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case 3575610: {
                return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
            }
            case 351608024: {
                return this.version == null ? new Base[]{} : this.version.toArray(new Base[this.version.size()]);
            }
            case 682815883: {
                return this.specialization == null ? new Base[]{} : this.specialization.toArray(new Base[this.specialization.size()]);
            }
            case -993141291: {
                return this.property == null ? new Base[]{} : this.property.toArray(new Base[this.property.size()]);
            }
            case 1662702951: {
                return this.operation == null ? new Base[]{} : this.operation.toArray(new Base[this.operation.size()]);
            }
            case -87499647: {
                return this.association == null ? new Base[]{} : this.association.toArray(new Base[this.association.size()]);
            }
            case 106164915: {
                Base[] baseArray;
                if (this.owner == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.owner;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case 1901043637: {
                Base[] baseArray;
                if (this.location == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.location;
                }
                return baseArray;
            }
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.url;
                }
                return baseArray;
            }
            case 1741102485: {
                return this.endpoint == null ? new Base[]{} : this.endpoint.toArray(new Base[this.endpoint.size()]);
            }
            case -189118908: {
                return this.gateway == null ? new Base[]{} : this.gateway.toArray(new Base[this.gateway.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case -909893934: {
                return this.safety == null ? new Base[]{} : this.safety.toArray(new Base[this.safety.size()]);
            }
            case -995424086: {
                Base[] baseArray;
                if (this.parent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.parent;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 1714148973: {
                this.displayName = TypeConvertor.castToString(value);
                return value;
            }
            case -1014418093: {
                this.definition = TypeConvertor.castToCodeableReference(value);
                return value;
            }
            case -1343558178: {
                this.getUdiCarrier().add((DeviceUdiCarrierComponent)((Object)value));
                return value;
            }
            case -892481550: {
                value = new FHIRDeviceStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 804659501: {
                this.availabilityStatus = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -654468482: {
                this.biologicalSourceEvent = TypeConvertor.castToIdentifier(value);
                return value;
            }
            case -1969347631: {
                this.manufacturer = TypeConvertor.castToString(value);
                return value;
            }
            case 416714767: {
                this.manufactureDate = TypeConvertor.castToDateTime(value);
                return value;
            }
            case -668811523: {
                this.expirationDate = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 462547450: {
                this.lotNumber = TypeConvertor.castToString(value);
                return value;
            }
            case 83787357: {
                this.serialNumber = TypeConvertor.castToString(value);
                return value;
            }
            case 780988929: {
                this.getDeviceName().add((DeviceDeviceNameComponent)((Object)value));
                return value;
            }
            case 346619858: {
                this.modelNumber = TypeConvertor.castToString(value);
                return value;
            }
            case -731502308: {
                this.partNumber = TypeConvertor.castToString(value);
                return value;
            }
            case 50511102: {
                this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 3575610: {
                this.getType().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 351608024: {
                this.getVersion().add((DeviceVersionComponent)((Object)value));
                return value;
            }
            case 682815883: {
                this.getSpecialization().add((DeviceSpecializationComponent)((Object)value));
                return value;
            }
            case -993141291: {
                this.getProperty().add((DevicePropertyComponent)((Object)value));
                return value;
            }
            case 1662702951: {
                this.getOperation().add((DeviceOperationComponent)((Object)value));
                return value;
            }
            case -87499647: {
                this.getAssociation().add((DeviceAssociationComponent)((Object)value));
                return value;
            }
            case 106164915: {
                this.owner = TypeConvertor.castToReference(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(TypeConvertor.castToContactPoint(value));
                return value;
            }
            case 1901043637: {
                this.location = TypeConvertor.castToReference(value);
                return value;
            }
            case 116079: {
                this.url = TypeConvertor.castToUri(value);
                return value;
            }
            case 1741102485: {
                this.getEndpoint().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -189118908: {
                this.getGateway().add(TypeConvertor.castToCodeableReference(value));
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
            case -909893934: {
                this.getSafety().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -995424086: {
                this.parent = TypeConvertor.castToReference(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("displayName")) {
            this.displayName = TypeConvertor.castToString(value);
        } else if (name.equals(SP_DEFINITION)) {
            this.definition = TypeConvertor.castToCodeableReference(value);
        } else if (name.equals("udiCarrier")) {
            this.getUdiCarrier().add((DeviceUdiCarrierComponent)((Object)value));
        } else if (name.equals(SP_STATUS)) {
            value = new FHIRDeviceStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("availabilityStatus")) {
            this.availabilityStatus = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("biologicalSourceEvent")) {
            this.biologicalSourceEvent = TypeConvertor.castToIdentifier(value);
        } else if (name.equals(SP_MANUFACTURER)) {
            this.manufacturer = TypeConvertor.castToString(value);
        } else if (name.equals("manufactureDate")) {
            this.manufactureDate = TypeConvertor.castToDateTime(value);
        } else if (name.equals("expirationDate")) {
            this.expirationDate = TypeConvertor.castToDateTime(value);
        } else if (name.equals("lotNumber")) {
            this.lotNumber = TypeConvertor.castToString(value);
        } else if (name.equals("serialNumber")) {
            this.serialNumber = TypeConvertor.castToString(value);
        } else if (name.equals("deviceName")) {
            this.getDeviceName().add((DeviceDeviceNameComponent)((Object)value));
        } else if (name.equals("modelNumber")) {
            this.modelNumber = TypeConvertor.castToString(value);
        } else if (name.equals("partNumber")) {
            this.partNumber = TypeConvertor.castToString(value);
        } else if (name.equals("category")) {
            this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_TYPE)) {
            this.getType().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_VERSION)) {
            this.getVersion().add((DeviceVersionComponent)((Object)value));
        } else if (name.equals("specialization")) {
            this.getSpecialization().add((DeviceSpecializationComponent)((Object)value));
        } else if (name.equals("property")) {
            this.getProperty().add((DevicePropertyComponent)((Object)value));
        } else if (name.equals("operation")) {
            this.getOperation().add((DeviceOperationComponent)((Object)value));
        } else if (name.equals("association")) {
            this.getAssociation().add((DeviceAssociationComponent)((Object)value));
        } else if (name.equals("owner")) {
            this.owner = TypeConvertor.castToReference(value);
        } else if (name.equals("contact")) {
            this.getContact().add(TypeConvertor.castToContactPoint(value));
        } else if (name.equals(SP_LOCATION)) {
            this.location = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_URL)) {
            this.url = TypeConvertor.castToUri(value);
        } else if (name.equals("endpoint")) {
            this.getEndpoint().add(TypeConvertor.castToReference(value));
        } else if (name.equals("gateway")) {
            this.getGateway().add(TypeConvertor.castToCodeableReference(value));
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else if (name.equals("safety")) {
            this.getSafety().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_PARENT)) {
            this.parent = TypeConvertor.castToReference(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 1714148973: {
                return this.getDisplayNameElement();
            }
            case -1014418093: {
                return this.getDefinition();
            }
            case -1343558178: {
                return this.addUdiCarrier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 804659501: {
                return this.getAvailabilityStatus();
            }
            case -654468482: {
                return this.getBiologicalSourceEvent();
            }
            case -1969347631: {
                return this.getManufacturerElement();
            }
            case 416714767: {
                return this.getManufactureDateElement();
            }
            case -668811523: {
                return this.getExpirationDateElement();
            }
            case 462547450: {
                return this.getLotNumberElement();
            }
            case 83787357: {
                return this.getSerialNumberElement();
            }
            case 780988929: {
                return this.addDeviceName();
            }
            case 346619858: {
                return this.getModelNumberElement();
            }
            case -731502308: {
                return this.getPartNumberElement();
            }
            case 50511102: {
                return this.addCategory();
            }
            case 3575610: {
                return this.addType();
            }
            case 351608024: {
                return this.addVersion();
            }
            case 682815883: {
                return this.addSpecialization();
            }
            case -993141291: {
                return this.addProperty();
            }
            case 1662702951: {
                return this.addOperation();
            }
            case -87499647: {
                return this.addAssociation();
            }
            case 106164915: {
                return this.getOwner();
            }
            case 951526432: {
                return this.addContact();
            }
            case 1901043637: {
                return this.getLocation();
            }
            case 116079: {
                return this.getUrlElement();
            }
            case 1741102485: {
                return this.addEndpoint();
            }
            case -189118908: {
                return this.addGateway();
            }
            case 3387378: {
                return this.addNote();
            }
            case -909893934: {
                return this.addSafety();
            }
            case -995424086: {
                return this.getParent();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 1714148973: {
                return new String[]{"string"};
            }
            case -1014418093: {
                return new String[]{"CodeableReference"};
            }
            case -1343558178: {
                return new String[0];
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 804659501: {
                return new String[]{"CodeableConcept"};
            }
            case -654468482: {
                return new String[]{"Identifier"};
            }
            case -1969347631: {
                return new String[]{"string"};
            }
            case 416714767: {
                return new String[]{"dateTime"};
            }
            case -668811523: {
                return new String[]{"dateTime"};
            }
            case 462547450: {
                return new String[]{"string"};
            }
            case 83787357: {
                return new String[]{"string"};
            }
            case 780988929: {
                return new String[0];
            }
            case 346619858: {
                return new String[]{"string"};
            }
            case -731502308: {
                return new String[]{"string"};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case 351608024: {
                return new String[0];
            }
            case 682815883: {
                return new String[0];
            }
            case -993141291: {
                return new String[0];
            }
            case 1662702951: {
                return new String[0];
            }
            case -87499647: {
                return new String[0];
            }
            case 106164915: {
                return new String[]{"Reference"};
            }
            case 951526432: {
                return new String[]{"ContactPoint"};
            }
            case 1901043637: {
                return new String[]{"Reference"};
            }
            case 116079: {
                return new String[]{"uri"};
            }
            case 1741102485: {
                return new String[]{"Reference"};
            }
            case -189118908: {
                return new String[]{"CodeableReference"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case -909893934: {
                return new String[]{"CodeableConcept"};
            }
            case -995424086: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("displayName")) {
            throw new FHIRException("Cannot call addChild on a primitive type Device.displayName");
        }
        if (name.equals(SP_DEFINITION)) {
            this.definition = new CodeableReference();
            return this.definition;
        }
        if (name.equals("udiCarrier")) {
            return this.addUdiCarrier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Device.status");
        }
        if (name.equals("availabilityStatus")) {
            this.availabilityStatus = new CodeableConcept();
            return this.availabilityStatus;
        }
        if (name.equals("biologicalSourceEvent")) {
            this.biologicalSourceEvent = new Identifier();
            return this.biologicalSourceEvent;
        }
        if (name.equals(SP_MANUFACTURER)) {
            throw new FHIRException("Cannot call addChild on a primitive type Device.manufacturer");
        }
        if (name.equals("manufactureDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type Device.manufactureDate");
        }
        if (name.equals("expirationDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type Device.expirationDate");
        }
        if (name.equals("lotNumber")) {
            throw new FHIRException("Cannot call addChild on a primitive type Device.lotNumber");
        }
        if (name.equals("serialNumber")) {
            throw new FHIRException("Cannot call addChild on a primitive type Device.serialNumber");
        }
        if (name.equals("deviceName")) {
            return this.addDeviceName();
        }
        if (name.equals("modelNumber")) {
            throw new FHIRException("Cannot call addChild on a primitive type Device.modelNumber");
        }
        if (name.equals("partNumber")) {
            throw new FHIRException("Cannot call addChild on a primitive type Device.partNumber");
        }
        if (name.equals("category")) {
            return this.addCategory();
        }
        if (name.equals(SP_TYPE)) {
            return this.addType();
        }
        if (name.equals(SP_VERSION)) {
            return this.addVersion();
        }
        if (name.equals("specialization")) {
            return this.addSpecialization();
        }
        if (name.equals("property")) {
            return this.addProperty();
        }
        if (name.equals("operation")) {
            return this.addOperation();
        }
        if (name.equals("association")) {
            return this.addAssociation();
        }
        if (name.equals("owner")) {
            this.owner = new Reference();
            return this.owner;
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_LOCATION)) {
            this.location = new Reference();
            return this.location;
        }
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type Device.url");
        }
        if (name.equals("endpoint")) {
            return this.addEndpoint();
        }
        if (name.equals("gateway")) {
            return this.addGateway();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("safety")) {
            return this.addSafety();
        }
        if (name.equals(SP_PARENT)) {
            this.parent = new Reference();
            return this.parent;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Device";
    }

    @Override
    public Device copy() {
        Device dst = new Device();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Device dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.displayName = this.displayName == null ? null : this.displayName.copy();
        CodeableReference codeableReference = dst.definition = this.definition == null ? null : this.definition.copy();
        if (this.udiCarrier != null) {
            dst.udiCarrier = new ArrayList<DeviceUdiCarrierComponent>();
            for (DeviceUdiCarrierComponent deviceUdiCarrierComponent : this.udiCarrier) {
                dst.udiCarrier.add(deviceUdiCarrierComponent.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.availabilityStatus = this.availabilityStatus == null ? null : this.availabilityStatus.copy();
        dst.biologicalSourceEvent = this.biologicalSourceEvent == null ? null : this.biologicalSourceEvent.copy();
        dst.manufacturer = this.manufacturer == null ? null : this.manufacturer.copy();
        dst.manufactureDate = this.manufactureDate == null ? null : this.manufactureDate.copy();
        dst.expirationDate = this.expirationDate == null ? null : this.expirationDate.copy();
        dst.lotNumber = this.lotNumber == null ? null : this.lotNumber.copy();
        StringType stringType = dst.serialNumber = this.serialNumber == null ? null : this.serialNumber.copy();
        if (this.deviceName != null) {
            dst.deviceName = new ArrayList<DeviceDeviceNameComponent>();
            for (DeviceDeviceNameComponent deviceDeviceNameComponent : this.deviceName) {
                dst.deviceName.add(deviceDeviceNameComponent.copy());
            }
        }
        dst.modelNumber = this.modelNumber == null ? null : this.modelNumber.copy();
        StringType stringType2 = dst.partNumber = this.partNumber == null ? null : this.partNumber.copy();
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.category) {
                dst.category.add(codeableConcept.copy());
            }
        }
        if (this.type != null) {
            dst.type = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.type) {
                dst.type.add(codeableConcept.copy());
            }
        }
        if (this.version != null) {
            dst.version = new ArrayList<DeviceVersionComponent>();
            for (DeviceVersionComponent deviceVersionComponent : this.version) {
                dst.version.add(deviceVersionComponent.copy());
            }
        }
        if (this.specialization != null) {
            dst.specialization = new ArrayList<DeviceSpecializationComponent>();
            for (DeviceSpecializationComponent deviceSpecializationComponent : this.specialization) {
                dst.specialization.add(deviceSpecializationComponent.copy());
            }
        }
        if (this.property != null) {
            dst.property = new ArrayList<DevicePropertyComponent>();
            for (DevicePropertyComponent devicePropertyComponent : this.property) {
                dst.property.add(devicePropertyComponent.copy());
            }
        }
        if (this.operation != null) {
            dst.operation = new ArrayList<DeviceOperationComponent>();
            for (DeviceOperationComponent deviceOperationComponent : this.operation) {
                dst.operation.add(deviceOperationComponent.copy());
            }
        }
        if (this.association != null) {
            dst.association = new ArrayList<DeviceAssociationComponent>();
            for (DeviceAssociationComponent deviceAssociationComponent : this.association) {
                dst.association.add(deviceAssociationComponent.copy());
            }
        }
        Reference reference = dst.owner = this.owner == null ? null : this.owner.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactPoint>();
            for (ContactPoint contactPoint : this.contact) {
                dst.contact.add(contactPoint.copy());
            }
        }
        dst.location = this.location == null ? null : this.location.copy();
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.endpoint != null) {
            dst.endpoint = new ArrayList<Reference>();
            for (Reference reference2 : this.endpoint) {
                dst.endpoint.add(reference2.copy());
            }
        }
        if (this.gateway != null) {
            dst.gateway = new ArrayList<CodeableReference>();
            for (CodeableReference codeableReference2 : this.gateway) {
                dst.gateway.add(codeableReference2.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.safety != null) {
            dst.safety = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.safety) {
                dst.safety.add(codeableConcept.copy());
            }
        }
        dst.parent = this.parent == null ? null : this.parent.copy();
    }

    protected Device typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Device)) {
            return false;
        }
        Device o = (Device)other_;
        return Device.compareDeep(this.identifier, o.identifier, true) && Device.compareDeep(this.displayName, o.displayName, true) && Device.compareDeep(this.definition, o.definition, true) && Device.compareDeep(this.udiCarrier, o.udiCarrier, true) && Device.compareDeep(this.status, o.status, true) && Device.compareDeep(this.availabilityStatus, o.availabilityStatus, true) && Device.compareDeep(this.biologicalSourceEvent, o.biologicalSourceEvent, true) && Device.compareDeep(this.manufacturer, o.manufacturer, true) && Device.compareDeep(this.manufactureDate, o.manufactureDate, true) && Device.compareDeep(this.expirationDate, o.expirationDate, true) && Device.compareDeep(this.lotNumber, o.lotNumber, true) && Device.compareDeep(this.serialNumber, o.serialNumber, true) && Device.compareDeep(this.deviceName, o.deviceName, true) && Device.compareDeep(this.modelNumber, o.modelNumber, true) && Device.compareDeep(this.partNumber, o.partNumber, true) && Device.compareDeep(this.category, o.category, true) && Device.compareDeep(this.type, o.type, true) && Device.compareDeep(this.version, o.version, true) && Device.compareDeep(this.specialization, o.specialization, true) && Device.compareDeep(this.property, o.property, true) && Device.compareDeep(this.operation, o.operation, true) && Device.compareDeep(this.association, o.association, true) && Device.compareDeep(this.owner, o.owner, true) && Device.compareDeep(this.contact, o.contact, true) && Device.compareDeep(this.location, o.location, true) && Device.compareDeep(this.url, o.url, true) && Device.compareDeep(this.endpoint, o.endpoint, true) && Device.compareDeep(this.gateway, o.gateway, true) && Device.compareDeep(this.note, o.note, true) && Device.compareDeep(this.safety, o.safety, true) && Device.compareDeep(this.parent, o.parent, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Device)) {
            return false;
        }
        Device o = (Device)other_;
        return Device.compareValues(this.displayName, o.displayName, true) && Device.compareValues(this.status, o.status, true) && Device.compareValues(this.manufacturer, o.manufacturer, true) && Device.compareValues(this.manufactureDate, o.manufactureDate, true) && Device.compareValues(this.expirationDate, o.expirationDate, true) && Device.compareValues(this.lotNumber, o.lotNumber, true) && Device.compareValues(this.serialNumber, o.serialNumber, true) && Device.compareValues(this.modelNumber, o.modelNumber, true) && Device.compareValues(this.partNumber, o.partNumber, true) && Device.compareValues(this.url, o.url, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.displayName, this.definition, this.udiCarrier, this.status, this.availabilityStatus, this.biologicalSourceEvent, this.manufacturer, this.manufactureDate, this.expirationDate, this.lotNumber, this.serialNumber, this.deviceName, this.modelNumber, this.partNumber, this.category, this.type, this.version, this.specialization, this.property, this.operation, this.association, this.owner, this.contact, this.location, this.url, this.endpoint, this.gateway, this.note, this.safety, this.parent});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Device;
    }

    @Block
    public static class DeviceAssociationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="status", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Device useage state", formalDefinition="The state of the usage or application of the device.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/device-association-status")
        protected CodeableConcept status;
        @Child(name="statusReason", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The reasons given for the current association status", formalDefinition="The reasons given for the current association status - i.e. why is the device explanted, or attached to the patient, etc.")
        protected List<CodeableConcept> statusReason;
        @Child(name="humanSubject", type={Patient.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The individual associated with the device", formalDefinition="The individual to whom the device is affixed or inserted in their body.")
        protected Reference humanSubject;
        @Child(name="bodyStructure", type={CodeableReference.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Current anatomical location of device in/on humanSubject", formalDefinition="The current anatomical location of the device in/on the humanSubject where it is attached or placed.")
        protected CodeableReference bodyStructure;
        private static final long serialVersionUID = -534050127L;

        public DeviceAssociationComponent() {
        }

        public DeviceAssociationComponent(CodeableConcept status) {
            this.setStatus(status);
        }

        public CodeableConcept getStatus() {
            if (this.status == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceAssociationComponent.status");
                }
                if (Configuration.doAutoCreate()) {
                    this.status = new CodeableConcept();
                }
            }
            return this.status;
        }

        public boolean hasStatus() {
            return this.status != null && !this.status.isEmpty();
        }

        public DeviceAssociationComponent setStatus(CodeableConcept value) {
            this.status = value;
            return this;
        }

        public List<CodeableConcept> getStatusReason() {
            if (this.statusReason == null) {
                this.statusReason = new ArrayList<CodeableConcept>();
            }
            return this.statusReason;
        }

        public DeviceAssociationComponent setStatusReason(List<CodeableConcept> theStatusReason) {
            this.statusReason = theStatusReason;
            return this;
        }

        public boolean hasStatusReason() {
            if (this.statusReason == null) {
                return false;
            }
            for (CodeableConcept item : this.statusReason) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addStatusReason() {
            CodeableConcept t = new CodeableConcept();
            if (this.statusReason == null) {
                this.statusReason = new ArrayList<CodeableConcept>();
            }
            this.statusReason.add(t);
            return t;
        }

        public DeviceAssociationComponent addStatusReason(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.statusReason == null) {
                this.statusReason = new ArrayList<CodeableConcept>();
            }
            this.statusReason.add(t);
            return this;
        }

        public CodeableConcept getStatusReasonFirstRep() {
            if (this.getStatusReason().isEmpty()) {
                this.addStatusReason();
            }
            return this.getStatusReason().get(0);
        }

        public Reference getHumanSubject() {
            if (this.humanSubject == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceAssociationComponent.humanSubject");
                }
                if (Configuration.doAutoCreate()) {
                    this.humanSubject = new Reference();
                }
            }
            return this.humanSubject;
        }

        public boolean hasHumanSubject() {
            return this.humanSubject != null && !this.humanSubject.isEmpty();
        }

        public DeviceAssociationComponent setHumanSubject(Reference value) {
            this.humanSubject = value;
            return this;
        }

        public CodeableReference getBodyStructure() {
            if (this.bodyStructure == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceAssociationComponent.bodyStructure");
                }
                if (Configuration.doAutoCreate()) {
                    this.bodyStructure = new CodeableReference();
                }
            }
            return this.bodyStructure;
        }

        public boolean hasBodyStructure() {
            return this.bodyStructure != null && !this.bodyStructure.isEmpty();
        }

        public DeviceAssociationComponent setBodyStructure(CodeableReference value) {
            this.bodyStructure = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Device.SP_STATUS, "CodeableConcept", "The state of the usage or application of the device.", 0, 1, this.status));
            children.add(new Property("statusReason", "CodeableConcept", "The reasons given for the current association status - i.e. why is the device explanted, or attached to the patient, etc.", 0, Integer.MAX_VALUE, this.statusReason));
            children.add(new Property("humanSubject", "Reference(Patient)", "The individual to whom the device is affixed or inserted in their body.", 0, 1, this.humanSubject));
            children.add(new Property("bodyStructure", "CodeableReference(BodyStructure)", "The current anatomical location of the device in/on the humanSubject where it is attached or placed.", 0, 1, this.bodyStructure));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -892481550: {
                    return new Property(Device.SP_STATUS, "CodeableConcept", "The state of the usage or application of the device.", 0, 1, this.status);
                }
                case 2051346646: {
                    return new Property("statusReason", "CodeableConcept", "The reasons given for the current association status - i.e. why is the device explanted, or attached to the patient, etc.", 0, Integer.MAX_VALUE, this.statusReason);
                }
                case -192393409: {
                    return new Property("humanSubject", "Reference(Patient)", "The individual to whom the device is affixed or inserted in their body.", 0, 1, this.humanSubject);
                }
                case -1001731599: {
                    return new Property("bodyStructure", "CodeableReference(BodyStructure)", "The current anatomical location of the device in/on the humanSubject where it is attached or placed.", 0, 1, this.bodyStructure);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    Base[] baseArray;
                    if (this.status == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.status;
                    }
                    return baseArray;
                }
                case 2051346646: {
                    return this.statusReason == null ? new Base[]{} : this.statusReason.toArray(new Base[this.statusReason.size()]);
                }
                case -192393409: {
                    Base[] baseArray;
                    if (this.humanSubject == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.humanSubject;
                    }
                    return baseArray;
                }
                case -1001731599: {
                    Base[] baseArray;
                    if (this.bodyStructure == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.bodyStructure;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    this.status = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 2051346646: {
                    this.getStatusReason().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -192393409: {
                    this.humanSubject = TypeConvertor.castToReference(value);
                    return value;
                }
                case -1001731599: {
                    this.bodyStructure = TypeConvertor.castToCodeableReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Device.SP_STATUS)) {
                this.status = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("statusReason")) {
                this.getStatusReason().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("humanSubject")) {
                this.humanSubject = TypeConvertor.castToReference(value);
            } else if (name.equals("bodyStructure")) {
                this.bodyStructure = TypeConvertor.castToCodeableReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    return this.getStatus();
                }
                case 2051346646: {
                    return this.addStatusReason();
                }
                case -192393409: {
                    return this.getHumanSubject();
                }
                case -1001731599: {
                    return this.getBodyStructure();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    return new String[]{"CodeableConcept"};
                }
                case 2051346646: {
                    return new String[]{"CodeableConcept"};
                }
                case -192393409: {
                    return new String[]{"Reference"};
                }
                case -1001731599: {
                    return new String[]{"CodeableReference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Device.SP_STATUS)) {
                this.status = new CodeableConcept();
                return this.status;
            }
            if (name.equals("statusReason")) {
                return this.addStatusReason();
            }
            if (name.equals("humanSubject")) {
                this.humanSubject = new Reference();
                return this.humanSubject;
            }
            if (name.equals("bodyStructure")) {
                this.bodyStructure = new CodeableReference();
                return this.bodyStructure;
            }
            return super.addChild(name);
        }

        @Override
        public DeviceAssociationComponent copy() {
            DeviceAssociationComponent dst = new DeviceAssociationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DeviceAssociationComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.status = this.status == null ? null : this.status.copy();
            if (this.statusReason != null) {
                dst.statusReason = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.statusReason) {
                    dst.statusReason.add(i.copy());
                }
            }
            dst.humanSubject = this.humanSubject == null ? null : this.humanSubject.copy();
            dst.bodyStructure = this.bodyStructure == null ? null : this.bodyStructure.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceAssociationComponent)) {
                return false;
            }
            DeviceAssociationComponent o = (DeviceAssociationComponent)other_;
            return DeviceAssociationComponent.compareDeep(this.status, o.status, true) && DeviceAssociationComponent.compareDeep(this.statusReason, o.statusReason, true) && DeviceAssociationComponent.compareDeep(this.humanSubject, o.humanSubject, true) && DeviceAssociationComponent.compareDeep(this.bodyStructure, o.bodyStructure, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceAssociationComponent)) {
                return false;
            }
            DeviceAssociationComponent o = (DeviceAssociationComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.status, this.statusReason, this.humanSubject, this.bodyStructure});
        }

        @Override
        public String fhirType() {
            return "Device.association";
        }
    }

    @Block
    public static class DeviceOperationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="status", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Device operational condition", formalDefinition="The state or condition of the device's operation.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/device-operationstatus")
        protected CodeableConcept status;
        @Child(name="statusReason", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The rationale given for the current operational status", formalDefinition="The reasons given for the current operational status - i.e. why is the device switched on etc.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/device-operation-status-reason")
        protected List<CodeableConcept> statusReason;
        @Child(name="operator", type={Patient.class, Practitioner.class, RelatedPerson.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The individual performing the action enabled by the device", formalDefinition="The individual performing the action enabled by the device.")
        protected List<Reference> operator;
        @Child(name="mode", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The designated condition for performing a task", formalDefinition="The designated condition for performing a task with the device.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/device-operation-mode")
        protected CodeableConcept mode;
        @Child(name="cycle", type={Count.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The series of occurrences that repeats during the operation of the device", formalDefinition="The series of occurrences that repeats during the operation of the device.")
        protected Count cycle;
        @Child(name="duration", type={Duration.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A measurement of time during the device's operation (e.g., days, hours, mins, etc)", formalDefinition="A measurement of time during the device's operation (e.g., days, hours, mins, etc).")
        protected Duration duration;
        private static final long serialVersionUID = 824534566L;

        public DeviceOperationComponent() {
        }

        public DeviceOperationComponent(CodeableConcept status) {
            this.setStatus(status);
        }

        public CodeableConcept getStatus() {
            if (this.status == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceOperationComponent.status");
                }
                if (Configuration.doAutoCreate()) {
                    this.status = new CodeableConcept();
                }
            }
            return this.status;
        }

        public boolean hasStatus() {
            return this.status != null && !this.status.isEmpty();
        }

        public DeviceOperationComponent setStatus(CodeableConcept value) {
            this.status = value;
            return this;
        }

        public List<CodeableConcept> getStatusReason() {
            if (this.statusReason == null) {
                this.statusReason = new ArrayList<CodeableConcept>();
            }
            return this.statusReason;
        }

        public DeviceOperationComponent setStatusReason(List<CodeableConcept> theStatusReason) {
            this.statusReason = theStatusReason;
            return this;
        }

        public boolean hasStatusReason() {
            if (this.statusReason == null) {
                return false;
            }
            for (CodeableConcept item : this.statusReason) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addStatusReason() {
            CodeableConcept t = new CodeableConcept();
            if (this.statusReason == null) {
                this.statusReason = new ArrayList<CodeableConcept>();
            }
            this.statusReason.add(t);
            return t;
        }

        public DeviceOperationComponent addStatusReason(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.statusReason == null) {
                this.statusReason = new ArrayList<CodeableConcept>();
            }
            this.statusReason.add(t);
            return this;
        }

        public CodeableConcept getStatusReasonFirstRep() {
            if (this.getStatusReason().isEmpty()) {
                this.addStatusReason();
            }
            return this.getStatusReason().get(0);
        }

        public List<Reference> getOperator() {
            if (this.operator == null) {
                this.operator = new ArrayList<Reference>();
            }
            return this.operator;
        }

        public DeviceOperationComponent setOperator(List<Reference> theOperator) {
            this.operator = theOperator;
            return this;
        }

        public boolean hasOperator() {
            if (this.operator == null) {
                return false;
            }
            for (Reference item : this.operator) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addOperator() {
            Reference t = new Reference();
            if (this.operator == null) {
                this.operator = new ArrayList<Reference>();
            }
            this.operator.add(t);
            return t;
        }

        public DeviceOperationComponent addOperator(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.operator == null) {
                this.operator = new ArrayList<Reference>();
            }
            this.operator.add(t);
            return this;
        }

        public Reference getOperatorFirstRep() {
            if (this.getOperator().isEmpty()) {
                this.addOperator();
            }
            return this.getOperator().get(0);
        }

        public CodeableConcept getMode() {
            if (this.mode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceOperationComponent.mode");
                }
                if (Configuration.doAutoCreate()) {
                    this.mode = new CodeableConcept();
                }
            }
            return this.mode;
        }

        public boolean hasMode() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public DeviceOperationComponent setMode(CodeableConcept value) {
            this.mode = value;
            return this;
        }

        public Count getCycle() {
            if (this.cycle == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceOperationComponent.cycle");
                }
                if (Configuration.doAutoCreate()) {
                    this.cycle = new Count();
                }
            }
            return this.cycle;
        }

        public boolean hasCycle() {
            return this.cycle != null && !this.cycle.isEmpty();
        }

        public DeviceOperationComponent setCycle(Count value) {
            this.cycle = value;
            return this;
        }

        public Duration getDuration() {
            if (this.duration == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceOperationComponent.duration");
                }
                if (Configuration.doAutoCreate()) {
                    this.duration = new Duration();
                }
            }
            return this.duration;
        }

        public boolean hasDuration() {
            return this.duration != null && !this.duration.isEmpty();
        }

        public DeviceOperationComponent setDuration(Duration value) {
            this.duration = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Device.SP_STATUS, "CodeableConcept", "The state or condition of the device's operation.", 0, 1, this.status));
            children.add(new Property("statusReason", "CodeableConcept", "The reasons given for the current operational status - i.e. why is the device switched on etc.", 0, Integer.MAX_VALUE, this.statusReason));
            children.add(new Property("operator", "Reference(Patient|Practitioner|RelatedPerson)", "The individual performing the action enabled by the device.", 0, Integer.MAX_VALUE, this.operator));
            children.add(new Property("mode", "CodeableConcept", "The designated condition for performing a task with the device.", 0, 1, this.mode));
            children.add(new Property("cycle", "Count", "The series of occurrences that repeats during the operation of the device.", 0, 1, this.cycle));
            children.add(new Property("duration", "Duration", "A measurement of time during the device's operation (e.g., days, hours, mins, etc).", 0, 1, this.duration));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -892481550: {
                    return new Property(Device.SP_STATUS, "CodeableConcept", "The state or condition of the device's operation.", 0, 1, this.status);
                }
                case 2051346646: {
                    return new Property("statusReason", "CodeableConcept", "The reasons given for the current operational status - i.e. why is the device switched on etc.", 0, Integer.MAX_VALUE, this.statusReason);
                }
                case -500553564: {
                    return new Property("operator", "Reference(Patient|Practitioner|RelatedPerson)", "The individual performing the action enabled by the device.", 0, Integer.MAX_VALUE, this.operator);
                }
                case 0x3339A3: {
                    return new Property("mode", "CodeableConcept", "The designated condition for performing a task with the device.", 0, 1, this.mode);
                }
                case 95131878: {
                    return new Property("cycle", "Count", "The series of occurrences that repeats during the operation of the device.", 0, 1, this.cycle);
                }
                case -1992012396: {
                    return new Property("duration", "Duration", "A measurement of time during the device's operation (e.g., days, hours, mins, etc).", 0, 1, this.duration);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    Base[] baseArray;
                    if (this.status == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.status;
                    }
                    return baseArray;
                }
                case 2051346646: {
                    return this.statusReason == null ? new Base[]{} : this.statusReason.toArray(new Base[this.statusReason.size()]);
                }
                case -500553564: {
                    return this.operator == null ? new Base[]{} : this.operator.toArray(new Base[this.operator.size()]);
                }
                case 0x3339A3: {
                    Base[] baseArray;
                    if (this.mode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.mode;
                    }
                    return baseArray;
                }
                case 95131878: {
                    Base[] baseArray;
                    if (this.cycle == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.cycle;
                    }
                    return baseArray;
                }
                case -1992012396: {
                    Base[] baseArray;
                    if (this.duration == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.duration;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    this.status = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 2051346646: {
                    this.getStatusReason().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -500553564: {
                    this.getOperator().add(TypeConvertor.castToReference(value));
                    return value;
                }
                case 0x3339A3: {
                    this.mode = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 95131878: {
                    this.cycle = TypeConvertor.castToCount(value);
                    return value;
                }
                case -1992012396: {
                    this.duration = TypeConvertor.castToDuration(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Device.SP_STATUS)) {
                this.status = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("statusReason")) {
                this.getStatusReason().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("operator")) {
                this.getOperator().add(TypeConvertor.castToReference(value));
            } else if (name.equals("mode")) {
                this.mode = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("cycle")) {
                this.cycle = TypeConvertor.castToCount(value);
            } else if (name.equals("duration")) {
                this.duration = TypeConvertor.castToDuration(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    return this.getStatus();
                }
                case 2051346646: {
                    return this.addStatusReason();
                }
                case -500553564: {
                    return this.addOperator();
                }
                case 0x3339A3: {
                    return this.getMode();
                }
                case 95131878: {
                    return this.getCycle();
                }
                case -1992012396: {
                    return this.getDuration();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    return new String[]{"CodeableConcept"};
                }
                case 2051346646: {
                    return new String[]{"CodeableConcept"};
                }
                case -500553564: {
                    return new String[]{"Reference"};
                }
                case 0x3339A3: {
                    return new String[]{"CodeableConcept"};
                }
                case 95131878: {
                    return new String[]{"Count"};
                }
                case -1992012396: {
                    return new String[]{"Duration"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Device.SP_STATUS)) {
                this.status = new CodeableConcept();
                return this.status;
            }
            if (name.equals("statusReason")) {
                return this.addStatusReason();
            }
            if (name.equals("operator")) {
                return this.addOperator();
            }
            if (name.equals("mode")) {
                this.mode = new CodeableConcept();
                return this.mode;
            }
            if (name.equals("cycle")) {
                this.cycle = new Count();
                return this.cycle;
            }
            if (name.equals("duration")) {
                this.duration = new Duration();
                return this.duration;
            }
            return super.addChild(name);
        }

        @Override
        public DeviceOperationComponent copy() {
            DeviceOperationComponent dst = new DeviceOperationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DeviceOperationComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.status = this.status == null ? null : this.status.copy();
            if (this.statusReason != null) {
                dst.statusReason = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.statusReason) {
                    dst.statusReason.add(codeableConcept2.copy());
                }
            }
            if (this.operator != null) {
                dst.operator = new ArrayList<Reference>();
                for (Reference reference : this.operator) {
                    dst.operator.add(reference.copy());
                }
            }
            dst.mode = this.mode == null ? null : this.mode.copy();
            dst.cycle = this.cycle == null ? null : this.cycle.copy();
            dst.duration = this.duration == null ? null : this.duration.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceOperationComponent)) {
                return false;
            }
            DeviceOperationComponent o = (DeviceOperationComponent)other_;
            return DeviceOperationComponent.compareDeep(this.status, o.status, true) && DeviceOperationComponent.compareDeep(this.statusReason, o.statusReason, true) && DeviceOperationComponent.compareDeep(this.operator, o.operator, true) && DeviceOperationComponent.compareDeep(this.mode, o.mode, true) && DeviceOperationComponent.compareDeep(this.cycle, o.cycle, true) && DeviceOperationComponent.compareDeep(this.duration, o.duration, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceOperationComponent)) {
                return false;
            }
            DeviceOperationComponent o = (DeviceOperationComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.status, this.statusReason, this.operator, this.mode, this.cycle, this.duration});
        }

        @Override
        public String fhirType() {
            return "Device.operation";
        }
    }

    @Block
    public static class DevicePropertyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code that specifies the property being represented", formalDefinition="Code that specifies the property being represented. No codes are specified but the MDC codes are an example: https://terminology.hl7.org/MDC.html.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/device-property-type")
        protected CodeableConcept type;
        @Child(name="value", type={Quantity.class, CodeableConcept.class, StringType.class, BooleanType.class, IntegerType.class, Range.class, Attachment.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Property value - as a code, quantity, boolean, string or attachment", formalDefinition="Property value - can be a code, quantity, boolean, string or attachment.")
        protected DataType value;
        private static final long serialVersionUID = -1659186716L;

        public DevicePropertyComponent() {
        }

        public DevicePropertyComponent(CodeableConcept type, DataType value) {
            this.setType(type);
            this.setValue(value);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DevicePropertyComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public DevicePropertyComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                this.value = new Quantity();
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this != null && this.value instanceof Quantity;
        }

        public CodeableConcept getValueCodeableConcept() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeableConcept();
            }
            if (!(this.value instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.value;
        }

        public boolean hasValueCodeableConcept() {
            return this != null && this.value instanceof CodeableConcept;
        }

        public StringType getValueStringType() throws FHIRException {
            if (this.value == null) {
                this.value = new StringType();
            }
            if (!(this.value instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (StringType)this.value;
        }

        public boolean hasValueStringType() {
            return this != null && this.value instanceof StringType;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (this.value == null) {
                this.value = new BooleanType();
            }
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this != null && this.value instanceof BooleanType;
        }

        public IntegerType getValueIntegerType() throws FHIRException {
            if (this.value == null) {
                this.value = new IntegerType();
            }
            if (!(this.value instanceof IntegerType)) {
                throw new FHIRException("Type mismatch: the type IntegerType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (IntegerType)this.value;
        }

        public boolean hasValueIntegerType() {
            return this != null && this.value instanceof IntegerType;
        }

        public Range getValueRange() throws FHIRException {
            if (this.value == null) {
                this.value = new Range();
            }
            if (!(this.value instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Range)this.value;
        }

        public boolean hasValueRange() {
            return this != null && this.value instanceof Range;
        }

        public Attachment getValueAttachment() throws FHIRException {
            if (this.value == null) {
                this.value = new Attachment();
            }
            if (!(this.value instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Attachment)this.value;
        }

        public boolean hasValueAttachment() {
            return this != null && this.value instanceof Attachment;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public DevicePropertyComponent setValue(DataType value) {
            if (!(value == null || value instanceof Quantity || value instanceof CodeableConcept || value instanceof StringType || value instanceof BooleanType || value instanceof IntegerType || value instanceof Range || value instanceof Attachment)) {
                throw new Error("Not the right type for Device.property.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Device.SP_TYPE, "CodeableConcept", "Code that specifies the property being represented. No codes are specified but the MDC codes are an example: https://terminology.hl7.org/MDC.html.", 0, 1, this.type));
            children.add(new Property("value[x]", "Quantity|CodeableConcept|string|boolean|integer|Range|Attachment", "Property value - can be a code, quantity, boolean, string or attachment.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(Device.SP_TYPE, "CodeableConcept", "Code that specifies the property being represented. No codes are specified but the MDC codes are an example: https://terminology.hl7.org/MDC.html.", 0, 1, this.type);
                }
                case -1410166417: {
                    return new Property("value[x]", "Quantity|CodeableConcept|string|boolean|integer|Range|Attachment", "Property value - can be a code, quantity, boolean, string or attachment.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "Quantity|CodeableConcept|string|boolean|integer|Range|Attachment", "Property value - can be a code, quantity, boolean, string or attachment.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "Quantity", "Property value - can be a code, quantity, boolean, string or attachment.", 0, 1, this.value);
                }
                case 924902896: {
                    return new Property("value[x]", "CodeableConcept", "Property value - can be a code, quantity, boolean, string or attachment.", 0, 1, this.value);
                }
                case -1424603934: {
                    return new Property("value[x]", "string", "Property value - can be a code, quantity, boolean, string or attachment.", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "boolean", "Property value - can be a code, quantity, boolean, string or attachment.", 0, 1, this.value);
                }
                case -1668204915: {
                    return new Property("value[x]", "integer", "Property value - can be a code, quantity, boolean, string or attachment.", 0, 1, this.value);
                }
                case 2030761548: {
                    return new Property("value[x]", "Range", "Property value - can be a code, quantity, boolean, string or attachment.", 0, 1, this.value);
                }
                case -475566732: {
                    return new Property("value[x]", "Attachment", "Property value - can be a code, quantity, boolean, string or attachment.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Device.SP_TYPE)) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"Quantity", "CodeableConcept", "string", "boolean", "integer", "Range", "Attachment"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Device.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueInteger")) {
                this.value = new IntegerType();
                return this.value;
            }
            if (name.equals("valueRange")) {
                this.value = new Range();
                return this.value;
            }
            if (name.equals("valueAttachment")) {
                this.value = new Attachment();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public DevicePropertyComponent copy() {
            DevicePropertyComponent dst = new DevicePropertyComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DevicePropertyComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DevicePropertyComponent)) {
                return false;
            }
            DevicePropertyComponent o = (DevicePropertyComponent)other_;
            return DevicePropertyComponent.compareDeep(this.type, o.type, true) && DevicePropertyComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DevicePropertyComponent)) {
                return false;
            }
            DevicePropertyComponent o = (DevicePropertyComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.value});
        }

        @Override
        public String fhirType() {
            return "Device.property";
        }
    }

    @Block
    public static class DeviceSpecializationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="systemType", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code of the system that identifies the standard that the device adheres to", formalDefinition="Code that specifies the system that identifies the specific standard that the device adheres to.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/device-specialization-systemtype")
        protected CodeableConcept systemType;
        @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Standard version used", formalDefinition="The version of the standard that is used to operate and communicate.")
        protected StringType version;
        @Child(name="category", type={Coding.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="communication | performance | measurement", formalDefinition="Kind of standards that the device adheres to, e.g., communication, performance or communication.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/device-specialization-category")
        protected Coding category;
        private static final long serialVersionUID = 1771791003L;

        public DeviceSpecializationComponent() {
        }

        public DeviceSpecializationComponent(CodeableConcept systemType) {
            this.setSystemType(systemType);
        }

        public CodeableConcept getSystemType() {
            if (this.systemType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceSpecializationComponent.systemType");
                }
                if (Configuration.doAutoCreate()) {
                    this.systemType = new CodeableConcept();
                }
            }
            return this.systemType;
        }

        public boolean hasSystemType() {
            return this.systemType != null && !this.systemType.isEmpty();
        }

        public DeviceSpecializationComponent setSystemType(CodeableConcept value) {
            this.systemType = value;
            return this;
        }

        public StringType getVersionElement() {
            if (this.version == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceSpecializationComponent.version");
                }
                if (Configuration.doAutoCreate()) {
                    this.version = new StringType();
                }
            }
            return this.version;
        }

        public boolean hasVersionElement() {
            return this.version != null && !this.version.isEmpty();
        }

        public boolean hasVersion() {
            return this.version != null && !this.version.isEmpty();
        }

        public DeviceSpecializationComponent setVersionElement(StringType value) {
            this.version = value;
            return this;
        }

        public String getVersion() {
            return this.version == null ? null : (String)this.version.getValue();
        }

        public DeviceSpecializationComponent setVersion(String value) {
            if (Utilities.noString((String)value)) {
                this.version = null;
            } else {
                if (this.version == null) {
                    this.version = new StringType();
                }
                this.version.setValue(value);
            }
            return this;
        }

        public Coding getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceSpecializationComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new Coding();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public DeviceSpecializationComponent setCategory(Coding value) {
            this.category = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("systemType", "CodeableConcept", "Code that specifies the system that identifies the specific standard that the device adheres to.", 0, 1, this.systemType));
            children.add(new Property(Device.SP_VERSION, "string", "The version of the standard that is used to operate and communicate.", 0, 1, this.version));
            children.add(new Property("category", "Coding", "Kind of standards that the device adheres to, e.g., communication, performance or communication.", 0, 1, this.category));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 642893321: {
                    return new Property("systemType", "CodeableConcept", "Code that specifies the system that identifies the specific standard that the device adheres to.", 0, 1, this.systemType);
                }
                case 351608024: {
                    return new Property(Device.SP_VERSION, "string", "The version of the standard that is used to operate and communicate.", 0, 1, this.version);
                }
                case 50511102: {
                    return new Property("category", "Coding", "Kind of standards that the device adheres to, e.g., communication, performance or communication.", 0, 1, this.category);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 642893321: {
                    Base[] baseArray;
                    if (this.systemType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.systemType;
                    }
                    return baseArray;
                }
                case 351608024: {
                    Base[] baseArray;
                    if (this.version == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.version;
                    }
                    return baseArray;
                }
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.category;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 642893321: {
                    this.systemType = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 351608024: {
                    this.version = TypeConvertor.castToString(value);
                    return value;
                }
                case 50511102: {
                    this.category = TypeConvertor.castToCoding(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("systemType")) {
                this.systemType = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals(Device.SP_VERSION)) {
                this.version = TypeConvertor.castToString(value);
            } else if (name.equals("category")) {
                this.category = TypeConvertor.castToCoding(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 642893321: {
                    return this.getSystemType();
                }
                case 351608024: {
                    return this.getVersionElement();
                }
                case 50511102: {
                    return this.getCategory();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 642893321: {
                    return new String[]{"CodeableConcept"};
                }
                case 351608024: {
                    return new String[]{"string"};
                }
                case 50511102: {
                    return new String[]{"Coding"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("systemType")) {
                this.systemType = new CodeableConcept();
                return this.systemType;
            }
            if (name.equals(Device.SP_VERSION)) {
                throw new FHIRException("Cannot call addChild on a primitive type Device.specialization.version");
            }
            if (name.equals("category")) {
                this.category = new Coding();
                return this.category;
            }
            return super.addChild(name);
        }

        @Override
        public DeviceSpecializationComponent copy() {
            DeviceSpecializationComponent dst = new DeviceSpecializationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DeviceSpecializationComponent dst) {
            super.copyValues(dst);
            dst.systemType = this.systemType == null ? null : this.systemType.copy();
            dst.version = this.version == null ? null : this.version.copy();
            dst.category = this.category == null ? null : this.category.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceSpecializationComponent)) {
                return false;
            }
            DeviceSpecializationComponent o = (DeviceSpecializationComponent)other_;
            return DeviceSpecializationComponent.compareDeep(this.systemType, o.systemType, true) && DeviceSpecializationComponent.compareDeep(this.version, o.version, true) && DeviceSpecializationComponent.compareDeep(this.category, o.category, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceSpecializationComponent)) {
                return false;
            }
            DeviceSpecializationComponent o = (DeviceSpecializationComponent)other_;
            return DeviceSpecializationComponent.compareValues(this.version, o.version, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.systemType, this.version, this.category});
        }

        @Override
        public String fhirType() {
            return "Device.specialization";
        }
    }

    @Block
    public static class DeviceVersionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The type of the device version, e.g. manufacturer, approved, internal", formalDefinition="The type of the device version, e.g. manufacturer, approved, internal.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/device-versiontype")
        protected CodeableConcept type;
        @Child(name="component", type={Identifier.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The hardware or software module of the device to which the version applies", formalDefinition="The hardware or software module of the device to which the version applies.")
        protected Identifier component;
        @Child(name="installDate", type={DateTimeType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The date the version was installed on the device", formalDefinition="The date the version was installed on the device.")
        protected DateTimeType installDate;
        @Child(name="value", type={StringType.class}, order=4, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The version text", formalDefinition="The version text.")
        protected StringType value;
        private static final long serialVersionUID = 1358422741L;

        public DeviceVersionComponent() {
        }

        public DeviceVersionComponent(String value) {
            this.setValue(value);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceVersionComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public DeviceVersionComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Identifier getComponent() {
            if (this.component == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceVersionComponent.component");
                }
                if (Configuration.doAutoCreate()) {
                    this.component = new Identifier();
                }
            }
            return this.component;
        }

        public boolean hasComponent() {
            return this.component != null && !this.component.isEmpty();
        }

        public DeviceVersionComponent setComponent(Identifier value) {
            this.component = value;
            return this;
        }

        public DateTimeType getInstallDateElement() {
            if (this.installDate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceVersionComponent.installDate");
                }
                if (Configuration.doAutoCreate()) {
                    this.installDate = new DateTimeType();
                }
            }
            return this.installDate;
        }

        public boolean hasInstallDateElement() {
            return this.installDate != null && !this.installDate.isEmpty();
        }

        public boolean hasInstallDate() {
            return this.installDate != null && !this.installDate.isEmpty();
        }

        public DeviceVersionComponent setInstallDateElement(DateTimeType value) {
            this.installDate = value;
            return this;
        }

        public Date getInstallDate() {
            return this.installDate == null ? null : (Date)this.installDate.getValue();
        }

        public DeviceVersionComponent setInstallDate(Date value) {
            if (value == null) {
                this.installDate = null;
            } else {
                if (this.installDate == null) {
                    this.installDate = new DateTimeType();
                }
                this.installDate.setValue(value);
            }
            return this;
        }

        public StringType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceVersionComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new StringType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public DeviceVersionComponent setValueElement(StringType value) {
            this.value = value;
            return this;
        }

        public String getValue() {
            return this.value == null ? null : (String)this.value.getValue();
        }

        public DeviceVersionComponent setValue(String value) {
            if (this.value == null) {
                this.value = new StringType();
            }
            this.value.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Device.SP_TYPE, "CodeableConcept", "The type of the device version, e.g. manufacturer, approved, internal.", 0, 1, this.type));
            children.add(new Property("component", "Identifier", "The hardware or software module of the device to which the version applies.", 0, 1, this.component));
            children.add(new Property("installDate", "dateTime", "The date the version was installed on the device.", 0, 1, this.installDate));
            children.add(new Property("value", "string", "The version text.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(Device.SP_TYPE, "CodeableConcept", "The type of the device version, e.g. manufacturer, approved, internal.", 0, 1, this.type);
                }
                case -1399907075: {
                    return new Property("component", "Identifier", "The hardware or software module of the device to which the version applies.", 0, 1, this.component);
                }
                case 2143044585: {
                    return new Property("installDate", "dateTime", "The date the version was installed on the device.", 0, 1, this.installDate);
                }
                case 111972721: {
                    return new Property("value", "string", "The version text.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -1399907075: {
                    Base[] baseArray;
                    if (this.component == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.component;
                    }
                    return baseArray;
                }
                case 2143044585: {
                    Base[] baseArray;
                    if (this.installDate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.installDate;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1399907075: {
                    this.component = TypeConvertor.castToIdentifier(value);
                    return value;
                }
                case 2143044585: {
                    this.installDate = TypeConvertor.castToDateTime(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Device.SP_TYPE)) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("component")) {
                this.component = TypeConvertor.castToIdentifier(value);
            } else if (name.equals("installDate")) {
                this.installDate = TypeConvertor.castToDateTime(value);
            } else if (name.equals("value")) {
                this.value = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1399907075: {
                    return this.getComponent();
                }
                case 2143044585: {
                    return this.getInstallDateElement();
                }
                case 111972721: {
                    return this.getValueElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1399907075: {
                    return new String[]{"Identifier"};
                }
                case 2143044585: {
                    return new String[]{"dateTime"};
                }
                case 111972721: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Device.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("component")) {
                this.component = new Identifier();
                return this.component;
            }
            if (name.equals("installDate")) {
                throw new FHIRException("Cannot call addChild on a primitive type Device.version.installDate");
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type Device.version.value");
            }
            return super.addChild(name);
        }

        @Override
        public DeviceVersionComponent copy() {
            DeviceVersionComponent dst = new DeviceVersionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DeviceVersionComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.component = this.component == null ? null : this.component.copy();
            dst.installDate = this.installDate == null ? null : this.installDate.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceVersionComponent)) {
                return false;
            }
            DeviceVersionComponent o = (DeviceVersionComponent)other_;
            return DeviceVersionComponent.compareDeep(this.type, o.type, true) && DeviceVersionComponent.compareDeep(this.component, o.component, true) && DeviceVersionComponent.compareDeep(this.installDate, o.installDate, true) && DeviceVersionComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceVersionComponent)) {
                return false;
            }
            DeviceVersionComponent o = (DeviceVersionComponent)other_;
            return DeviceVersionComponent.compareValues(this.installDate, o.installDate, true) && DeviceVersionComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.component, this.installDate, this.value});
        }

        @Override
        public String fhirType() {
            return "Device.version";
        }
    }

    @Block
    public static class DeviceDeviceNameComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The name that identifies the device", formalDefinition="The name that identifies the device.")
        protected StringType name;
        @Child(name="type", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="registered-name | user-friendly-name | patient-reported-name", formalDefinition="The type of deviceName. Note that ManufactureDeviceName means that the name is the name as given by the manufacturer, not the name of the manufacturer.\nRegisteredName | UserFriendlyName | PatientReportedName.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/device-nametype")
        protected Enumeration<Enumerations.DeviceNameType> type;
        private static final long serialVersionUID = 918983440L;

        public DeviceDeviceNameComponent() {
        }

        public DeviceDeviceNameComponent(String name, Enumerations.DeviceNameType type) {
            this.setName(name);
            this.setType(type);
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDeviceNameComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public DeviceDeviceNameComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public DeviceDeviceNameComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public Enumeration<Enumerations.DeviceNameType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDeviceNameComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<Enumerations.DeviceNameType>(new Enumerations.DeviceNameTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public DeviceDeviceNameComponent setTypeElement(Enumeration<Enumerations.DeviceNameType> value) {
            this.type = value;
            return this;
        }

        public Enumerations.DeviceNameType getType() {
            return this.type == null ? null : (Enumerations.DeviceNameType)((Object)this.type.getValue());
        }

        public DeviceDeviceNameComponent setType(Enumerations.DeviceNameType value) {
            if (this.type == null) {
                this.type = new Enumeration<Enumerations.DeviceNameType>(new Enumerations.DeviceNameTypeEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("name", "string", "The name that identifies the device.", 0, 1, this.name));
            children.add(new Property(Device.SP_TYPE, "code", "The type of deviceName. Note that ManufactureDeviceName means that the name is the name as given by the manufacturer, not the name of the manufacturer.\nRegisteredName | UserFriendlyName | PatientReportedName.", 0, 1, this.type));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property("name", "string", "The name that identifies the device.", 0, 1, this.name);
                }
                case 3575610: {
                    return new Property(Device.SP_TYPE, "code", "The type of deviceName. Note that ManufactureDeviceName means that the name is the name as given by the manufacturer, not the name of the manufacturer.\nRegisteredName | UserFriendlyName | PatientReportedName.", 0, 1, this.type);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = TypeConvertor.castToString(value);
                    return value;
                }
                case 3575610: {
                    value = new Enumerations.DeviceNameTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.type = value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = TypeConvertor.castToString(value);
            } else if (name.equals(Device.SP_TYPE)) {
                value = new Enumerations.DeviceNameTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.type = value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case 3575610: {
                    return this.getTypeElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"string"};
                }
                case 3575610: {
                    return new String[]{"code"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a primitive type Device.deviceName.name");
            }
            if (name.equals(Device.SP_TYPE)) {
                throw new FHIRException("Cannot call addChild on a primitive type Device.deviceName.type");
            }
            return super.addChild(name);
        }

        @Override
        public DeviceDeviceNameComponent copy() {
            DeviceDeviceNameComponent dst = new DeviceDeviceNameComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DeviceDeviceNameComponent dst) {
            super.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.type = this.type == null ? null : this.type.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceDeviceNameComponent)) {
                return false;
            }
            DeviceDeviceNameComponent o = (DeviceDeviceNameComponent)other_;
            return DeviceDeviceNameComponent.compareDeep(this.name, o.name, true) && DeviceDeviceNameComponent.compareDeep(this.type, o.type, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceDeviceNameComponent)) {
                return false;
            }
            DeviceDeviceNameComponent o = (DeviceDeviceNameComponent)other_;
            return DeviceDeviceNameComponent.compareValues(this.name, o.name, true) && DeviceDeviceNameComponent.compareValues(this.type, o.type, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.name, this.type});
        }

        @Override
        public String fhirType() {
            return "Device.deviceName";
        }
    }

    @Block
    public static class DeviceUdiCarrierComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="deviceIdentifier", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Mandatory fixed portion of UDI", formalDefinition="The device identifier (DI) is a mandatory, fixed portion of a UDI that identifies the labeler and the specific version or model of a device.")
        protected StringType deviceIdentifier;
        @Child(name="issuer", type={UriType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="UDI Issuing Organization", formalDefinition="Organization that is charged with issuing UDIs for devices. For example, the US FDA issuers include: \n1) GS1: http://hl7.org/fhir/NamingSystem/gs1-di, \n2) HIBCC: http://hl7.org/fhir/NamingSystem/hibcc-diI, \n3) ICCBBA for blood containers: http://hl7.org/fhir/NamingSystem/iccbba-blood-di, \n4) ICCBA for other devices: http://hl7.org/fhir/NamingSystem/iccbba-other-di # Informationsstelle f\u00fcr Arzneispezialit\u00e4ten (IFA GmbH) (EU only): http://hl7.org/fhir/NamingSystem/ifa-gmbh-di.")
        protected UriType issuer;
        @Child(name="jurisdiction", type={UriType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Regional UDI authority", formalDefinition="The identity of the authoritative source for UDI generation within a jurisdiction. All UDIs are globally unique within a single namespace with the appropriate repository uri as the system. For example, UDIs of devices managed in the U.S. by the FDA, the value is http://hl7.org/fhir/NamingSystem/us-fda-udi or in the European Union by the European Commission http://hl7.org/fhir/NamingSystem/eu-ec-udi.")
        protected UriType jurisdiction;
        @Child(name="carrierAIDC", type={Base64BinaryType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="UDI Machine Readable Barcode String", formalDefinition="The full UDI carrier of the Automatic Identification and Data Capture (AIDC) technology representation of the barcode string as printed on the packaging of the device - e.g., a barcode or RFID.   Because of limitations on character sets in XML and the need to round-trip JSON data through XML, AIDC Formats *SHALL* be base64 encoded.")
        protected Base64BinaryType carrierAIDC;
        @Child(name="carrierHRF", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="UDI Human Readable Barcode String", formalDefinition="The full UDI carrier as the human readable form (HRF) representation of the barcode string as printed on the packaging of the device.")
        protected StringType carrierHRF;
        @Child(name="entryType", type={CodeType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="barcode | rfid | manual | card | self-reported | electronic-transmission | unknown", formalDefinition="A coded entry to indicate how the data was entered.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/udi-entry-type")
        protected Enumeration<UDIEntryType> entryType;
        private static final long serialVersionUID = -191630425L;

        public DeviceUdiCarrierComponent() {
        }

        public DeviceUdiCarrierComponent(String deviceIdentifier, String issuer) {
            this.setDeviceIdentifier(deviceIdentifier);
            this.setIssuer(issuer);
        }

        public StringType getDeviceIdentifierElement() {
            if (this.deviceIdentifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceUdiCarrierComponent.deviceIdentifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.deviceIdentifier = new StringType();
                }
            }
            return this.deviceIdentifier;
        }

        public boolean hasDeviceIdentifierElement() {
            return this.deviceIdentifier != null && !this.deviceIdentifier.isEmpty();
        }

        public boolean hasDeviceIdentifier() {
            return this.deviceIdentifier != null && !this.deviceIdentifier.isEmpty();
        }

        public DeviceUdiCarrierComponent setDeviceIdentifierElement(StringType value) {
            this.deviceIdentifier = value;
            return this;
        }

        public String getDeviceIdentifier() {
            return this.deviceIdentifier == null ? null : (String)this.deviceIdentifier.getValue();
        }

        public DeviceUdiCarrierComponent setDeviceIdentifier(String value) {
            if (this.deviceIdentifier == null) {
                this.deviceIdentifier = new StringType();
            }
            this.deviceIdentifier.setValue(value);
            return this;
        }

        public UriType getIssuerElement() {
            if (this.issuer == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceUdiCarrierComponent.issuer");
                }
                if (Configuration.doAutoCreate()) {
                    this.issuer = new UriType();
                }
            }
            return this.issuer;
        }

        public boolean hasIssuerElement() {
            return this.issuer != null && !this.issuer.isEmpty();
        }

        public boolean hasIssuer() {
            return this.issuer != null && !this.issuer.isEmpty();
        }

        public DeviceUdiCarrierComponent setIssuerElement(UriType value) {
            this.issuer = value;
            return this;
        }

        public String getIssuer() {
            return this.issuer == null ? null : (String)this.issuer.getValue();
        }

        public DeviceUdiCarrierComponent setIssuer(String value) {
            if (this.issuer == null) {
                this.issuer = new UriType();
            }
            this.issuer.setValue(value);
            return this;
        }

        public UriType getJurisdictionElement() {
            if (this.jurisdiction == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceUdiCarrierComponent.jurisdiction");
                }
                if (Configuration.doAutoCreate()) {
                    this.jurisdiction = new UriType();
                }
            }
            return this.jurisdiction;
        }

        public boolean hasJurisdictionElement() {
            return this.jurisdiction != null && !this.jurisdiction.isEmpty();
        }

        public boolean hasJurisdiction() {
            return this.jurisdiction != null && !this.jurisdiction.isEmpty();
        }

        public DeviceUdiCarrierComponent setJurisdictionElement(UriType value) {
            this.jurisdiction = value;
            return this;
        }

        public String getJurisdiction() {
            return this.jurisdiction == null ? null : (String)this.jurisdiction.getValue();
        }

        public DeviceUdiCarrierComponent setJurisdiction(String value) {
            if (Utilities.noString((String)value)) {
                this.jurisdiction = null;
            } else {
                if (this.jurisdiction == null) {
                    this.jurisdiction = new UriType();
                }
                this.jurisdiction.setValue(value);
            }
            return this;
        }

        public Base64BinaryType getCarrierAIDCElement() {
            if (this.carrierAIDC == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceUdiCarrierComponent.carrierAIDC");
                }
                if (Configuration.doAutoCreate()) {
                    this.carrierAIDC = new Base64BinaryType();
                }
            }
            return this.carrierAIDC;
        }

        public boolean hasCarrierAIDCElement() {
            return this.carrierAIDC != null && !this.carrierAIDC.isEmpty();
        }

        public boolean hasCarrierAIDC() {
            return this.carrierAIDC != null && !this.carrierAIDC.isEmpty();
        }

        public DeviceUdiCarrierComponent setCarrierAIDCElement(Base64BinaryType value) {
            this.carrierAIDC = value;
            return this;
        }

        public byte[] getCarrierAIDC() {
            return this.carrierAIDC == null ? null : this.carrierAIDC.getValue();
        }

        public DeviceUdiCarrierComponent setCarrierAIDC(byte[] value) {
            if (value == null) {
                this.carrierAIDC = null;
            } else {
                if (this.carrierAIDC == null) {
                    this.carrierAIDC = new Base64BinaryType();
                }
                this.carrierAIDC.setValue(value);
            }
            return this;
        }

        public StringType getCarrierHRFElement() {
            if (this.carrierHRF == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceUdiCarrierComponent.carrierHRF");
                }
                if (Configuration.doAutoCreate()) {
                    this.carrierHRF = new StringType();
                }
            }
            return this.carrierHRF;
        }

        public boolean hasCarrierHRFElement() {
            return this.carrierHRF != null && !this.carrierHRF.isEmpty();
        }

        public boolean hasCarrierHRF() {
            return this.carrierHRF != null && !this.carrierHRF.isEmpty();
        }

        public DeviceUdiCarrierComponent setCarrierHRFElement(StringType value) {
            this.carrierHRF = value;
            return this;
        }

        public String getCarrierHRF() {
            return this.carrierHRF == null ? null : (String)this.carrierHRF.getValue();
        }

        public DeviceUdiCarrierComponent setCarrierHRF(String value) {
            if (Utilities.noString((String)value)) {
                this.carrierHRF = null;
            } else {
                if (this.carrierHRF == null) {
                    this.carrierHRF = new StringType();
                }
                this.carrierHRF.setValue(value);
            }
            return this;
        }

        public Enumeration<UDIEntryType> getEntryTypeElement() {
            if (this.entryType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceUdiCarrierComponent.entryType");
                }
                if (Configuration.doAutoCreate()) {
                    this.entryType = new Enumeration<UDIEntryType>(new UDIEntryTypeEnumFactory());
                }
            }
            return this.entryType;
        }

        public boolean hasEntryTypeElement() {
            return this.entryType != null && !this.entryType.isEmpty();
        }

        public boolean hasEntryType() {
            return this.entryType != null && !this.entryType.isEmpty();
        }

        public DeviceUdiCarrierComponent setEntryTypeElement(Enumeration<UDIEntryType> value) {
            this.entryType = value;
            return this;
        }

        public UDIEntryType getEntryType() {
            return this.entryType == null ? null : (UDIEntryType)((Object)this.entryType.getValue());
        }

        public DeviceUdiCarrierComponent setEntryType(UDIEntryType value) {
            if (value == null) {
                this.entryType = null;
            } else {
                if (this.entryType == null) {
                    this.entryType = new Enumeration<UDIEntryType>(new UDIEntryTypeEnumFactory());
                }
                this.entryType.setValue((Object)value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("deviceIdentifier", "string", "The device identifier (DI) is a mandatory, fixed portion of a UDI that identifies the labeler and the specific version or model of a device.", 0, 1, this.deviceIdentifier));
            children.add(new Property("issuer", "uri", "Organization that is charged with issuing UDIs for devices. For example, the US FDA issuers include: \n1) GS1: http://hl7.org/fhir/NamingSystem/gs1-di, \n2) HIBCC: http://hl7.org/fhir/NamingSystem/hibcc-diI, \n3) ICCBBA for blood containers: http://hl7.org/fhir/NamingSystem/iccbba-blood-di, \n4) ICCBA for other devices: http://hl7.org/fhir/NamingSystem/iccbba-other-di # Informationsstelle f\u00fcr Arzneispezialit\u00e4ten (IFA GmbH) (EU only): http://hl7.org/fhir/NamingSystem/ifa-gmbh-di.", 0, 1, this.issuer));
            children.add(new Property("jurisdiction", "uri", "The identity of the authoritative source for UDI generation within a jurisdiction. All UDIs are globally unique within a single namespace with the appropriate repository uri as the system. For example, UDIs of devices managed in the U.S. by the FDA, the value is http://hl7.org/fhir/NamingSystem/us-fda-udi or in the European Union by the European Commission http://hl7.org/fhir/NamingSystem/eu-ec-udi.", 0, 1, this.jurisdiction));
            children.add(new Property("carrierAIDC", "base64Binary", "The full UDI carrier of the Automatic Identification and Data Capture (AIDC) technology representation of the barcode string as printed on the packaging of the device - e.g., a barcode or RFID.   Because of limitations on character sets in XML and the need to round-trip JSON data through XML, AIDC Formats *SHALL* be base64 encoded.", 0, 1, this.carrierAIDC));
            children.add(new Property("carrierHRF", "string", "The full UDI carrier as the human readable form (HRF) representation of the barcode string as printed on the packaging of the device.", 0, 1, this.carrierHRF));
            children.add(new Property("entryType", "code", "A coded entry to indicate how the data was entered.", 0, 1, this.entryType));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1322005407: {
                    return new Property("deviceIdentifier", "string", "The device identifier (DI) is a mandatory, fixed portion of a UDI that identifies the labeler and the specific version or model of a device.", 0, 1, this.deviceIdentifier);
                }
                case -1179159879: {
                    return new Property("issuer", "uri", "Organization that is charged with issuing UDIs for devices. For example, the US FDA issuers include: \n1) GS1: http://hl7.org/fhir/NamingSystem/gs1-di, \n2) HIBCC: http://hl7.org/fhir/NamingSystem/hibcc-diI, \n3) ICCBBA for blood containers: http://hl7.org/fhir/NamingSystem/iccbba-blood-di, \n4) ICCBA for other devices: http://hl7.org/fhir/NamingSystem/iccbba-other-di # Informationsstelle f\u00fcr Arzneispezialit\u00e4ten (IFA GmbH) (EU only): http://hl7.org/fhir/NamingSystem/ifa-gmbh-di.", 0, 1, this.issuer);
                }
                case -507075711: {
                    return new Property("jurisdiction", "uri", "The identity of the authoritative source for UDI generation within a jurisdiction. All UDIs are globally unique within a single namespace with the appropriate repository uri as the system. For example, UDIs of devices managed in the U.S. by the FDA, the value is http://hl7.org/fhir/NamingSystem/us-fda-udi or in the European Union by the European Commission http://hl7.org/fhir/NamingSystem/eu-ec-udi.", 0, 1, this.jurisdiction);
                }
                case -768521825: {
                    return new Property("carrierAIDC", "base64Binary", "The full UDI carrier of the Automatic Identification and Data Capture (AIDC) technology representation of the barcode string as printed on the packaging of the device - e.g., a barcode or RFID.   Because of limitations on character sets in XML and the need to round-trip JSON data through XML, AIDC Formats *SHALL* be base64 encoded.", 0, 1, this.carrierAIDC);
                }
                case 806499972: {
                    return new Property("carrierHRF", "string", "The full UDI carrier as the human readable form (HRF) representation of the barcode string as printed on the packaging of the device.", 0, 1, this.carrierHRF);
                }
                case -479362356: {
                    return new Property("entryType", "code", "A coded entry to indicate how the data was entered.", 0, 1, this.entryType);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1322005407: {
                    Base[] baseArray;
                    if (this.deviceIdentifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.deviceIdentifier;
                    }
                    return baseArray;
                }
                case -1179159879: {
                    Base[] baseArray;
                    if (this.issuer == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.issuer;
                    }
                    return baseArray;
                }
                case -507075711: {
                    Base[] baseArray;
                    if (this.jurisdiction == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.jurisdiction;
                    }
                    return baseArray;
                }
                case -768521825: {
                    Base[] baseArray;
                    if (this.carrierAIDC == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.carrierAIDC;
                    }
                    return baseArray;
                }
                case 806499972: {
                    Base[] baseArray;
                    if (this.carrierHRF == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.carrierHRF;
                    }
                    return baseArray;
                }
                case -479362356: {
                    Base[] baseArray;
                    if (this.entryType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.entryType;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1322005407: {
                    this.deviceIdentifier = TypeConvertor.castToString(value);
                    return value;
                }
                case -1179159879: {
                    this.issuer = TypeConvertor.castToUri(value);
                    return value;
                }
                case -507075711: {
                    this.jurisdiction = TypeConvertor.castToUri(value);
                    return value;
                }
                case -768521825: {
                    this.carrierAIDC = TypeConvertor.castToBase64Binary(value);
                    return value;
                }
                case 806499972: {
                    this.carrierHRF = TypeConvertor.castToString(value);
                    return value;
                }
                case -479362356: {
                    value = new UDIEntryTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.entryType = value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("deviceIdentifier")) {
                this.deviceIdentifier = TypeConvertor.castToString(value);
            } else if (name.equals("issuer")) {
                this.issuer = TypeConvertor.castToUri(value);
            } else if (name.equals("jurisdiction")) {
                this.jurisdiction = TypeConvertor.castToUri(value);
            } else if (name.equals("carrierAIDC")) {
                this.carrierAIDC = TypeConvertor.castToBase64Binary(value);
            } else if (name.equals("carrierHRF")) {
                this.carrierHRF = TypeConvertor.castToString(value);
            } else if (name.equals("entryType")) {
                value = new UDIEntryTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.entryType = value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1322005407: {
                    return this.getDeviceIdentifierElement();
                }
                case -1179159879: {
                    return this.getIssuerElement();
                }
                case -507075711: {
                    return this.getJurisdictionElement();
                }
                case -768521825: {
                    return this.getCarrierAIDCElement();
                }
                case 806499972: {
                    return this.getCarrierHRFElement();
                }
                case -479362356: {
                    return this.getEntryTypeElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1322005407: {
                    return new String[]{"string"};
                }
                case -1179159879: {
                    return new String[]{"uri"};
                }
                case -507075711: {
                    return new String[]{"uri"};
                }
                case -768521825: {
                    return new String[]{"base64Binary"};
                }
                case 806499972: {
                    return new String[]{"string"};
                }
                case -479362356: {
                    return new String[]{"code"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("deviceIdentifier")) {
                throw new FHIRException("Cannot call addChild on a primitive type Device.udiCarrier.deviceIdentifier");
            }
            if (name.equals("issuer")) {
                throw new FHIRException("Cannot call addChild on a primitive type Device.udiCarrier.issuer");
            }
            if (name.equals("jurisdiction")) {
                throw new FHIRException("Cannot call addChild on a primitive type Device.udiCarrier.jurisdiction");
            }
            if (name.equals("carrierAIDC")) {
                throw new FHIRException("Cannot call addChild on a primitive type Device.udiCarrier.carrierAIDC");
            }
            if (name.equals("carrierHRF")) {
                throw new FHIRException("Cannot call addChild on a primitive type Device.udiCarrier.carrierHRF");
            }
            if (name.equals("entryType")) {
                throw new FHIRException("Cannot call addChild on a primitive type Device.udiCarrier.entryType");
            }
            return super.addChild(name);
        }

        @Override
        public DeviceUdiCarrierComponent copy() {
            DeviceUdiCarrierComponent dst = new DeviceUdiCarrierComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DeviceUdiCarrierComponent dst) {
            super.copyValues(dst);
            dst.deviceIdentifier = this.deviceIdentifier == null ? null : this.deviceIdentifier.copy();
            dst.issuer = this.issuer == null ? null : this.issuer.copy();
            dst.jurisdiction = this.jurisdiction == null ? null : this.jurisdiction.copy();
            dst.carrierAIDC = this.carrierAIDC == null ? null : this.carrierAIDC.copy();
            dst.carrierHRF = this.carrierHRF == null ? null : this.carrierHRF.copy();
            dst.entryType = this.entryType == null ? null : this.entryType.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceUdiCarrierComponent)) {
                return false;
            }
            DeviceUdiCarrierComponent o = (DeviceUdiCarrierComponent)other_;
            return DeviceUdiCarrierComponent.compareDeep(this.deviceIdentifier, o.deviceIdentifier, true) && DeviceUdiCarrierComponent.compareDeep(this.issuer, o.issuer, true) && DeviceUdiCarrierComponent.compareDeep(this.jurisdiction, o.jurisdiction, true) && DeviceUdiCarrierComponent.compareDeep(this.carrierAIDC, o.carrierAIDC, true) && DeviceUdiCarrierComponent.compareDeep(this.carrierHRF, o.carrierHRF, true) && DeviceUdiCarrierComponent.compareDeep(this.entryType, o.entryType, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceUdiCarrierComponent)) {
                return false;
            }
            DeviceUdiCarrierComponent o = (DeviceUdiCarrierComponent)other_;
            return DeviceUdiCarrierComponent.compareValues(this.deviceIdentifier, o.deviceIdentifier, true) && DeviceUdiCarrierComponent.compareValues(this.issuer, o.issuer, true) && DeviceUdiCarrierComponent.compareValues(this.jurisdiction, o.jurisdiction, true) && DeviceUdiCarrierComponent.compareValues(this.carrierAIDC, o.carrierAIDC, true) && DeviceUdiCarrierComponent.compareValues(this.carrierHRF, o.carrierHRF, true) && DeviceUdiCarrierComponent.compareValues(this.entryType, o.entryType, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.deviceIdentifier, this.issuer, this.jurisdiction, this.carrierAIDC, this.carrierHRF, this.entryType});
        }

        @Override
        public String fhirType() {
            return "Device.udiCarrier";
        }
    }

    public static class UDIEntryTypeEnumFactory
    implements EnumFactory<UDIEntryType> {
        @Override
        public UDIEntryType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("barcode".equals(codeString)) {
                return UDIEntryType.BARCODE;
            }
            if ("rfid".equals(codeString)) {
                return UDIEntryType.RFID;
            }
            if ("manual".equals(codeString)) {
                return UDIEntryType.MANUAL;
            }
            if ("card".equals(codeString)) {
                return UDIEntryType.CARD;
            }
            if ("self-reported".equals(codeString)) {
                return UDIEntryType.SELFREPORTED;
            }
            if ("electronic-transmission".equals(codeString)) {
                return UDIEntryType.ELECTRONICTRANSMISSION;
            }
            if ("unknown".equals(codeString)) {
                return UDIEntryType.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown UDIEntryType code '" + codeString + "'");
        }

        public Enumeration<UDIEntryType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<UDIEntryType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("barcode".equals(codeString)) {
                return new Enumeration<UDIEntryType>(this, UDIEntryType.BARCODE);
            }
            if ("rfid".equals(codeString)) {
                return new Enumeration<UDIEntryType>(this, UDIEntryType.RFID);
            }
            if ("manual".equals(codeString)) {
                return new Enumeration<UDIEntryType>(this, UDIEntryType.MANUAL);
            }
            if ("card".equals(codeString)) {
                return new Enumeration<UDIEntryType>(this, UDIEntryType.CARD);
            }
            if ("self-reported".equals(codeString)) {
                return new Enumeration<UDIEntryType>(this, UDIEntryType.SELFREPORTED);
            }
            if ("electronic-transmission".equals(codeString)) {
                return new Enumeration<UDIEntryType>(this, UDIEntryType.ELECTRONICTRANSMISSION);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<UDIEntryType>(this, UDIEntryType.UNKNOWN);
            }
            throw new FHIRException("Unknown UDIEntryType code '" + codeString + "'");
        }

        @Override
        public String toCode(UDIEntryType code) {
            if (code == UDIEntryType.BARCODE) {
                return "barcode";
            }
            if (code == UDIEntryType.RFID) {
                return "rfid";
            }
            if (code == UDIEntryType.MANUAL) {
                return "manual";
            }
            if (code == UDIEntryType.CARD) {
                return "card";
            }
            if (code == UDIEntryType.SELFREPORTED) {
                return "self-reported";
            }
            if (code == UDIEntryType.ELECTRONICTRANSMISSION) {
                return "electronic-transmission";
            }
            if (code == UDIEntryType.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(UDIEntryType code) {
            return code.getSystem();
        }
    }

    public static enum UDIEntryType {
        BARCODE,
        RFID,
        MANUAL,
        CARD,
        SELFREPORTED,
        ELECTRONICTRANSMISSION,
        UNKNOWN,
        NULL;


        public static UDIEntryType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("barcode".equals(codeString)) {
                return BARCODE;
            }
            if ("rfid".equals(codeString)) {
                return RFID;
            }
            if ("manual".equals(codeString)) {
                return MANUAL;
            }
            if ("card".equals(codeString)) {
                return CARD;
            }
            if ("self-reported".equals(codeString)) {
                return SELFREPORTED;
            }
            if ("electronic-transmission".equals(codeString)) {
                return ELECTRONICTRANSMISSION;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown UDIEntryType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case BARCODE: {
                    return "barcode";
                }
                case RFID: {
                    return "rfid";
                }
                case MANUAL: {
                    return "manual";
                }
                case CARD: {
                    return "card";
                }
                case SELFREPORTED: {
                    return "self-reported";
                }
                case ELECTRONICTRANSMISSION: {
                    return "electronic-transmission";
                }
                case UNKNOWN: {
                    return "unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case BARCODE: {
                    return "http://hl7.org/fhir/udi-entry-type";
                }
                case RFID: {
                    return "http://hl7.org/fhir/udi-entry-type";
                }
                case MANUAL: {
                    return "http://hl7.org/fhir/udi-entry-type";
                }
                case CARD: {
                    return "http://hl7.org/fhir/udi-entry-type";
                }
                case SELFREPORTED: {
                    return "http://hl7.org/fhir/udi-entry-type";
                }
                case ELECTRONICTRANSMISSION: {
                    return "http://hl7.org/fhir/udi-entry-type";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/udi-entry-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case BARCODE: {
                    return "a barcodescanner captured the data from the device label.";
                }
                case RFID: {
                    return "An RFID chip reader captured the data from the device label.";
                }
                case MANUAL: {
                    return "The data was read from the label by a person and manually entered. (e.g.  via a keyboard).";
                }
                case CARD: {
                    return "The data originated from a patient's implant card and was read by an operator.";
                }
                case SELFREPORTED: {
                    return "The data originated from a patient source and was not directly scanned or read from a label or card.";
                }
                case ELECTRONICTRANSMISSION: {
                    return "The UDI information was received electronically from the device through a communication protocol, such as the IEEE 11073 20601 version 4 exchange protocol over Bluetooth or USB.";
                }
                case UNKNOWN: {
                    return "The method of data capture has not been determined.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case BARCODE: {
                    return "Barcode";
                }
                case RFID: {
                    return "RFID";
                }
                case MANUAL: {
                    return "Manual";
                }
                case CARD: {
                    return "Card";
                }
                case SELFREPORTED: {
                    return "Self Reported";
                }
                case ELECTRONICTRANSMISSION: {
                    return "Electronic Transmission";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class FHIRDeviceStatusEnumFactory
    implements EnumFactory<FHIRDeviceStatus> {
        @Override
        public FHIRDeviceStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return FHIRDeviceStatus.ACTIVE;
            }
            if ("inactive".equals(codeString)) {
                return FHIRDeviceStatus.INACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return FHIRDeviceStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown FHIRDeviceStatus code '" + codeString + "'");
        }

        public Enumeration<FHIRDeviceStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<FHIRDeviceStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return new Enumeration<FHIRDeviceStatus>(this, FHIRDeviceStatus.ACTIVE);
            }
            if ("inactive".equals(codeString)) {
                return new Enumeration<FHIRDeviceStatus>(this, FHIRDeviceStatus.INACTIVE);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<FHIRDeviceStatus>(this, FHIRDeviceStatus.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown FHIRDeviceStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(FHIRDeviceStatus code) {
            if (code == FHIRDeviceStatus.ACTIVE) {
                return "active";
            }
            if (code == FHIRDeviceStatus.INACTIVE) {
                return "inactive";
            }
            if (code == FHIRDeviceStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(FHIRDeviceStatus code) {
            return code.getSystem();
        }
    }

    public static enum FHIRDeviceStatus {
        ACTIVE,
        INACTIVE,
        ENTEREDINERROR,
        NULL;


        public static FHIRDeviceStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("inactive".equals(codeString)) {
                return INACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown FHIRDeviceStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case INACTIVE: {
                    return "inactive";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/device-status";
                }
                case INACTIVE: {
                    return "http://hl7.org/fhir/device-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/device-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "The device record is current and is appropriate for reference in new instances.";
                }
                case INACTIVE: {
                    return "The device record is not current and is not appropriate for reference in new instances.";
                }
                case ENTEREDINERROR: {
                    return "The device record is not current and is not appropriate for reference in new instances.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case INACTIVE: {
                    return "Inactive";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

