/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Account;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.ActorDefinition;
import org.hl7.fhir.r5.model.AdministrableProductDefinition;
import org.hl7.fhir.r5.model.AdverseEvent;
import org.hl7.fhir.r5.model.AllergyIntolerance;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.Appointment;
import org.hl7.fhir.r5.model.AppointmentResponse;
import org.hl7.fhir.r5.model.ArtifactAssessment;
import org.hl7.fhir.r5.model.AuditEvent;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Basic;
import org.hl7.fhir.r5.model.Binary;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.BodyStructure;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.ChargeItem;
import org.hl7.fhir.r5.model.ChargeItemDefinition;
import org.hl7.fhir.r5.model.Citation;
import org.hl7.fhir.r5.model.Claim;
import org.hl7.fhir.r5.model.ClaimResponse;
import org.hl7.fhir.r5.model.ClinicalImpression;
import org.hl7.fhir.r5.model.ClinicalUseDefinition;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Communication;
import org.hl7.fhir.r5.model.CommunicationRequest;
import org.hl7.fhir.r5.model.CompartmentDefinition;
import org.hl7.fhir.r5.model.Composition;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.Condition;
import org.hl7.fhir.r5.model.ConditionDefinition;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Consent;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.Contract;
import org.hl7.fhir.r5.model.Coverage;
import org.hl7.fhir.r5.model.CoverageEligibilityRequest;
import org.hl7.fhir.r5.model.CoverageEligibilityResponse;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DetectedIssue;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DeviceDefinition;
import org.hl7.fhir.r5.model.DeviceDispense;
import org.hl7.fhir.r5.model.DeviceMetric;
import org.hl7.fhir.r5.model.DeviceRequest;
import org.hl7.fhir.r5.model.DeviceUsage;
import org.hl7.fhir.r5.model.DiagnosticReport;
import org.hl7.fhir.r5.model.DocumentManifest;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.Endpoint;
import org.hl7.fhir.r5.model.EnrollmentRequest;
import org.hl7.fhir.r5.model.EnrollmentResponse;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.EpisodeOfCare;
import org.hl7.fhir.r5.model.EventDefinition;
import org.hl7.fhir.r5.model.Evidence;
import org.hl7.fhir.r5.model.EvidenceReport;
import org.hl7.fhir.r5.model.ExampleScenario;
import org.hl7.fhir.r5.model.ExplanationOfBenefit;
import org.hl7.fhir.r5.model.Expression;
import org.hl7.fhir.r5.model.FamilyMemberHistory;
import org.hl7.fhir.r5.model.Flag;
import org.hl7.fhir.r5.model.FormularyItem;
import org.hl7.fhir.r5.model.GenomicStudy;
import org.hl7.fhir.r5.model.Goal;
import org.hl7.fhir.r5.model.GraphDefinition;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.GuidanceResponse;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImagingSelection;
import org.hl7.fhir.r5.model.ImagingStudy;
import org.hl7.fhir.r5.model.Immunization;
import org.hl7.fhir.r5.model.ImmunizationEvaluation;
import org.hl7.fhir.r5.model.ImmunizationRecommendation;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.Ingredient;
import org.hl7.fhir.r5.model.InsurancePlan;
import org.hl7.fhir.r5.model.InventoryReport;
import org.hl7.fhir.r5.model.Invoice;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.Linkage;
import org.hl7.fhir.r5.model.ListResource;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.ManufacturedItemDefinition;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Measure;
import org.hl7.fhir.r5.model.MeasureReport;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MedicationAdministration;
import org.hl7.fhir.r5.model.MedicationDispense;
import org.hl7.fhir.r5.model.MedicationKnowledge;
import org.hl7.fhir.r5.model.MedicationRequest;
import org.hl7.fhir.r5.model.MedicationUsage;
import org.hl7.fhir.r5.model.MedicinalProductDefinition;
import org.hl7.fhir.r5.model.MessageDefinition;
import org.hl7.fhir.r5.model.MessageHeader;
import org.hl7.fhir.r5.model.MetadataResource;
import org.hl7.fhir.r5.model.MolecularSequence;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.NutritionIntake;
import org.hl7.fhir.r5.model.NutritionOrder;
import org.hl7.fhir.r5.model.NutritionProduct;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.ObservationDefinition;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.OrganizationAffiliation;
import org.hl7.fhir.r5.model.PackagedProductDefinition;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.PaymentNotice;
import org.hl7.fhir.r5.model.PaymentReconciliation;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Permission;
import org.hl7.fhir.r5.model.Person;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.PositiveIntType;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Provenance;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RegulatedAuthorization;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.RequestOrchestration;
import org.hl7.fhir.r5.model.Requirements;
import org.hl7.fhir.r5.model.ResearchStudy;
import org.hl7.fhir.r5.model.ResearchSubject;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.RiskAssessment;
import org.hl7.fhir.r5.model.Schedule;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.Slot;
import org.hl7.fhir.r5.model.Specimen;
import org.hl7.fhir.r5.model.SpecimenDefinition;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.Subscription;
import org.hl7.fhir.r5.model.SubscriptionStatus;
import org.hl7.fhir.r5.model.SubscriptionTopic;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.SubstanceDefinition;
import org.hl7.fhir.r5.model.SubstanceNucleicAcid;
import org.hl7.fhir.r5.model.SubstancePolymer;
import org.hl7.fhir.r5.model.SubstanceProtein;
import org.hl7.fhir.r5.model.SubstanceReferenceInformation;
import org.hl7.fhir.r5.model.SubstanceSourceMaterial;
import org.hl7.fhir.r5.model.SupplyDelivery;
import org.hl7.fhir.r5.model.SupplyRequest;
import org.hl7.fhir.r5.model.Task;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.TestReport;
import org.hl7.fhir.r5.model.TestScript;
import org.hl7.fhir.r5.model.Transport;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.model.VerificationResult;
import org.hl7.fhir.r5.model.VisionPrescription;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="EvidenceVariable", profile="http://hl7.org/fhir/StructureDefinition/EvidenceVariable")
public class EvidenceVariable
extends MetadataResource {
    @Child(name="url", type={UriType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Canonical identifier for this evidence variable, represented as a URI (globally unique)", formalDefinition="An absolute URI that is used to identify this evidence variable when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which an authoritative instance of this evidence variable is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the evidence variable is stored on different servers.")
    protected UriType url;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional identifier for the evidence variable", formalDefinition="A formal identifier that is used to identify this evidence variable when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected List<Identifier> identifier;
    @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business version of the evidence variable", formalDefinition="The identifier that is used to identify this version of the evidence variable when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the evidence variable author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence. To provide a version consistent with the Decision Support Service specification, use the format Major.Minor.Revision (e.g. 1.0.0). For more information on versioning knowledge assets, refer to the Decision Support Service specification. Note that a version is required for non-experimental active artifacts.")
    protected StringType version;
    @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this evidence variable (computer friendly)", formalDefinition="A natural language name identifying the evidence variable. This name should be usable as an identifier for the module by machine processing applications such as code generation.")
    protected StringType name;
    @Child(name="title", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this evidence variable (human friendly)", formalDefinition="A short, descriptive, user-friendly title for the evidence variable.")
    protected StringType title;
    @Child(name="shortTitle", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Title for use in informal contexts", formalDefinition="The short title provides an alternate title for use in informal descriptive contexts where the full, formal title is not necessary.")
    protected StringType shortTitle;
    @Child(name="subtitle", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Subordinate title of the EvidenceVariable", formalDefinition="An explanatory or alternate title for the EvidenceVariable giving additional information about its content.")
    protected StringType subtitle;
    @Child(name="status", type={CodeType.class}, order=7, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired | unknown", formalDefinition="The status of this evidence variable. Enables tracking the life-cycle of the content.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected Enumeration<Enumerations.PublicationStatus> status;
    @Child(name="experimental", type={BooleanType.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="For testing purposes, not real usage", formalDefinition="A Boolean value to indicate that this resource is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.")
    protected BooleanType experimental;
    @Child(name="date", type={DateTimeType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date last changed", formalDefinition="The date  (and optionally time) when the evidence variable was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the evidence variable changes.")
    protected DateTimeType date;
    @Child(name="publisher", type={StringType.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of the publisher/steward (organization or individual)", formalDefinition="The name of the organization or individual responsible for the release and ongoing maintenance of the evidence variable.")
    protected StringType publisher;
    @Child(name="contact", type={ContactDetail.class}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details for the publisher", formalDefinition="Contact details to assist a user in finding and communicating with the publisher.")
    protected List<ContactDetail> contact;
    @Child(name="description", type={MarkdownType.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Natural language description of the evidence variable", formalDefinition="A free text natural language description of the evidence variable from a consumer's perspective.")
    protected MarkdownType description;
    @Child(name="note", type={Annotation.class}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Used for footnotes or explanatory notes", formalDefinition="A human-readable string to clarify or explain concepts about the resource.")
    protected List<Annotation> note;
    @Child(name="useContext", type={UsageContext.class}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The context that the content is intended to support", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate evidence variable instances.")
    protected List<UsageContext> useContext;
    @Child(name="copyright", type={MarkdownType.class}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the resource and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the resource.")
    protected MarkdownType copyright;
    @Child(name="approvalDate", type={DateType.class}, order=16, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the resource was approved by publisher", formalDefinition="The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.")
    protected DateType approvalDate;
    @Child(name="lastReviewDate", type={DateType.class}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the resource was last reviewed", formalDefinition="The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.")
    protected DateType lastReviewDate;
    @Child(name="effectivePeriod", type={Period.class}, order=18, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the resource is expected to be used", formalDefinition="The period during which the resource content was or is planned to be in active use.")
    protected Period effectivePeriod;
    @Child(name="author", type={ContactDetail.class}, order=19, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who authored the content", formalDefinition="An individiual or organization primarily involved in the creation and maintenance of the content.")
    protected List<ContactDetail> author;
    @Child(name="editor", type={ContactDetail.class}, order=20, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who edited the content", formalDefinition="An individual or organization primarily responsible for internal coherence of the content.")
    protected List<ContactDetail> editor;
    @Child(name="reviewer", type={ContactDetail.class}, order=21, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who reviewed the content", formalDefinition="An individual or organization primarily responsible for review of some aspect of the content.")
    protected List<ContactDetail> reviewer;
    @Child(name="endorser", type={ContactDetail.class}, order=22, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who endorsed the content", formalDefinition="An individual or organization responsible for officially endorsing the content for use in some setting.")
    protected List<ContactDetail> endorser;
    @Child(name="relatedArtifact", type={RelatedArtifact.class}, order=23, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional documentation, citations, etc.", formalDefinition="Related artifacts such as additional documentation, justification, or bibliographic references.")
    protected List<RelatedArtifact> relatedArtifact;
    @Child(name="actual", type={BooleanType.class}, order=24, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Actual or conceptual", formalDefinition="True if the actual variable measured, false if a conceptual representation of the intended variable.")
    protected BooleanType actual;
    @Child(name="characteristic", type={}, order=25, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A defining factor of the EvidenceVariable", formalDefinition="A defining factor of the EvidenceVariable. Multiple characteristics are applied with \"and\" semantics.")
    protected List<EvidenceVariableCharacteristicComponent> characteristic;
    @Child(name="handling", type={CodeType.class}, order=26, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="continuous | dichotomous | ordinal | polychotomous", formalDefinition="The method of handling in statistical analysis.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/variable-handling")
    protected Enumeration<Enumerations.EvidenceVariableHandling> handling;
    @Child(name="category", type={}, order=27, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A grouping for ordinal or polychotomous variables", formalDefinition="A grouping for ordinal or polychotomous variables.")
    protected List<EvidenceVariableCategoryComponent> category;
    private static final long serialVersionUID = -532650354L;
    @SearchParamDefinition(name="composed-of", path="EvidenceVariable.relatedArtifact.where(type='composed-of').resource", description="What resource is being referenced", type="reference", target={Account.class, ActivityDefinition.class, ActorDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, ArtifactAssessment.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CarePlan.class, CareTeam.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceDispense.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, FormularyItem.class, GenomicStudy.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingSelection.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationUsage.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestOrchestration.class, Requirements.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, Transport.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_COMPOSED_OF = "composed-of";
    public static final ReferenceClientParam COMPOSED_OF = new ReferenceClientParam("composed-of");
    public static final Include INCLUDE_COMPOSED_OF = new Include("EvidenceVariable:composed-of").toLocked();
    @SearchParamDefinition(name="context-quantity", path="(EvidenceVariable.useContext.value as Quantity) | (EvidenceVariable.useContext.value as Range)", description="A quantity- or range-valued use context assigned to the evidence variable", type="quantity")
    public static final String SP_CONTEXT_QUANTITY = "context-quantity";
    public static final QuantityClientParam CONTEXT_QUANTITY = new QuantityClientParam("context-quantity");
    @SearchParamDefinition(name="context-type-quantity", path="EvidenceVariable.useContext", description="A use context type and quantity- or range-based value assigned to the evidence variable", type="composite", compositeOf={"context-type", "context-quantity"})
    public static final String SP_CONTEXT_TYPE_QUANTITY = "context-type-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> CONTEXT_TYPE_QUANTITY = new CompositeClientParam("context-type-quantity");
    @SearchParamDefinition(name="context-type-value", path="EvidenceVariable.useContext", description="A use context type and value assigned to the evidence variable", type="composite", compositeOf={"context-type", "context"})
    public static final String SP_CONTEXT_TYPE_VALUE = "context-type-value";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CONTEXT_TYPE_VALUE = new CompositeClientParam("context-type-value");
    @SearchParamDefinition(name="context-type", path="EvidenceVariable.useContext.code", description="A type of use context assigned to the evidence variable", type="token")
    public static final String SP_CONTEXT_TYPE = "context-type";
    public static final TokenClientParam CONTEXT_TYPE = new TokenClientParam("context-type");
    @SearchParamDefinition(name="context", path="(EvidenceVariable.useContext.value as CodeableConcept)", description="A use context assigned to the evidence variable", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="date", path="EvidenceVariable.date", description="The evidence variable publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="depends-on", path="EvidenceVariable.relatedArtifact.where(type='depends-on').resource", description="What resource is being referenced", type="reference", target={Account.class, ActivityDefinition.class, ActorDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, ArtifactAssessment.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CarePlan.class, CareTeam.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceDispense.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, FormularyItem.class, GenomicStudy.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingSelection.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationUsage.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestOrchestration.class, Requirements.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, Transport.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_DEPENDS_ON = "depends-on";
    public static final ReferenceClientParam DEPENDS_ON = new ReferenceClientParam("depends-on");
    public static final Include INCLUDE_DEPENDS_ON = new Include("EvidenceVariable:depends-on").toLocked();
    @SearchParamDefinition(name="derived-from", path="EvidenceVariable.relatedArtifact.where(type='derived-from').resource", description="What resource is being referenced", type="reference", target={Account.class, ActivityDefinition.class, ActorDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, ArtifactAssessment.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CarePlan.class, CareTeam.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceDispense.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, FormularyItem.class, GenomicStudy.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingSelection.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationUsage.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestOrchestration.class, Requirements.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, Transport.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_DERIVED_FROM = "derived-from";
    public static final ReferenceClientParam DERIVED_FROM = new ReferenceClientParam("derived-from");
    public static final Include INCLUDE_DERIVED_FROM = new Include("EvidenceVariable:derived-from").toLocked();
    @SearchParamDefinition(name="description", path="EvidenceVariable.description", description="The description of the evidence variable", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="identifier", path="EvidenceVariable.identifier", description="External identifier for the evidence variable", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="name", path="EvidenceVariable.name", description="Computationally friendly name of the evidence variable", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="predecessor", path="EvidenceVariable.relatedArtifact.where(type='predecessor').resource", description="What resource is being referenced", type="reference", target={Account.class, ActivityDefinition.class, ActorDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, ArtifactAssessment.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CarePlan.class, CareTeam.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceDispense.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, FormularyItem.class, GenomicStudy.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingSelection.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationUsage.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestOrchestration.class, Requirements.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, Transport.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_PREDECESSOR = "predecessor";
    public static final ReferenceClientParam PREDECESSOR = new ReferenceClientParam("predecessor");
    public static final Include INCLUDE_PREDECESSOR = new Include("EvidenceVariable:predecessor").toLocked();
    @SearchParamDefinition(name="publisher", path="EvidenceVariable.publisher", description="Name of the publisher of the evidence variable", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="status", path="EvidenceVariable.status", description="The current status of the evidence variable", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="successor", path="EvidenceVariable.relatedArtifact.where(type='successor').resource", description="What resource is being referenced", type="reference", target={Account.class, ActivityDefinition.class, ActorDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, ArtifactAssessment.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CarePlan.class, CareTeam.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceDispense.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, FormularyItem.class, GenomicStudy.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingSelection.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationUsage.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestOrchestration.class, Requirements.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, Transport.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_SUCCESSOR = "successor";
    public static final ReferenceClientParam SUCCESSOR = new ReferenceClientParam("successor");
    public static final Include INCLUDE_SUCCESSOR = new Include("EvidenceVariable:successor").toLocked();
    @SearchParamDefinition(name="title", path="EvidenceVariable.title", description="The human-friendly name of the evidence variable", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="topic", path="", description="Topics associated with the EvidenceVariable", type="token")
    public static final String SP_TOPIC = "topic";
    public static final TokenClientParam TOPIC = new TokenClientParam("topic");
    @SearchParamDefinition(name="url", path="EvidenceVariable.url", description="The uri that identifies the evidence variable", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="version", path="EvidenceVariable.version", description="The business version of the evidence variable", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");

    public EvidenceVariable() {
    }

    public EvidenceVariable(Enumerations.PublicationStatus status) {
        this.setStatus(status);
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceVariable.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public EvidenceVariable setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public EvidenceVariable setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    @Override
    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    @Override
    public EvidenceVariable setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    @Override
    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    @Override
    public EvidenceVariable addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    @Override
    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceVariable.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public EvidenceVariable setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public EvidenceVariable setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceVariable.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public EvidenceVariable setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public EvidenceVariable setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceVariable.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    @Override
    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public EvidenceVariable setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    @Override
    public EvidenceVariable setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    public StringType getShortTitleElement() {
        if (this.shortTitle == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceVariable.shortTitle");
            }
            if (Configuration.doAutoCreate()) {
                this.shortTitle = new StringType();
            }
        }
        return this.shortTitle;
    }

    public boolean hasShortTitleElement() {
        return this.shortTitle != null && !this.shortTitle.isEmpty();
    }

    public boolean hasShortTitle() {
        return this.shortTitle != null && !this.shortTitle.isEmpty();
    }

    public EvidenceVariable setShortTitleElement(StringType value) {
        this.shortTitle = value;
        return this;
    }

    public String getShortTitle() {
        return this.shortTitle == null ? null : (String)this.shortTitle.getValue();
    }

    public EvidenceVariable setShortTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.shortTitle = null;
        } else {
            if (this.shortTitle == null) {
                this.shortTitle = new StringType();
            }
            this.shortTitle.setValue(value);
        }
        return this;
    }

    public StringType getSubtitleElement() {
        if (this.subtitle == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceVariable.subtitle");
            }
            if (Configuration.doAutoCreate()) {
                this.subtitle = new StringType();
            }
        }
        return this.subtitle;
    }

    public boolean hasSubtitleElement() {
        return this.subtitle != null && !this.subtitle.isEmpty();
    }

    public boolean hasSubtitle() {
        return this.subtitle != null && !this.subtitle.isEmpty();
    }

    public EvidenceVariable setSubtitleElement(StringType value) {
        this.subtitle = value;
        return this;
    }

    public String getSubtitle() {
        return this.subtitle == null ? null : (String)this.subtitle.getValue();
    }

    public EvidenceVariable setSubtitle(String value) {
        if (Utilities.noString((String)value)) {
            this.subtitle = null;
        } else {
            if (this.subtitle == null) {
                this.subtitle = new StringType();
            }
            this.subtitle.setValue(value);
        }
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceVariable.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public EvidenceVariable setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public EvidenceVariable setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceVariable.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public EvidenceVariable setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public EvidenceVariable setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceVariable.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public EvidenceVariable setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public EvidenceVariable setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceVariable.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public EvidenceVariable setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public EvidenceVariable setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        return this.contact;
    }

    @Override
    public EvidenceVariable setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public EvidenceVariable addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceVariable.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public EvidenceVariable setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public EvidenceVariable setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public EvidenceVariable setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public EvidenceVariable addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        return this.useContext;
    }

    @Override
    public EvidenceVariable setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public EvidenceVariable addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceVariable.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    @Override
    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    @Override
    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    @Override
    public EvidenceVariable setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    @Override
    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    @Override
    public EvidenceVariable setCopyright(String value) {
        if (value == null) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    @Override
    public DateType getApprovalDateElement() {
        if (this.approvalDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceVariable.approvalDate");
            }
            if (Configuration.doAutoCreate()) {
                this.approvalDate = new DateType();
            }
        }
        return this.approvalDate;
    }

    @Override
    public boolean hasApprovalDateElement() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    @Override
    public boolean hasApprovalDate() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    @Override
    public EvidenceVariable setApprovalDateElement(DateType value) {
        this.approvalDate = value;
        return this;
    }

    @Override
    public Date getApprovalDate() {
        return this.approvalDate == null ? null : (Date)this.approvalDate.getValue();
    }

    @Override
    public EvidenceVariable setApprovalDate(Date value) {
        if (value == null) {
            this.approvalDate = null;
        } else {
            if (this.approvalDate == null) {
                this.approvalDate = new DateType();
            }
            this.approvalDate.setValue(value);
        }
        return this;
    }

    @Override
    public DateType getLastReviewDateElement() {
        if (this.lastReviewDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceVariable.lastReviewDate");
            }
            if (Configuration.doAutoCreate()) {
                this.lastReviewDate = new DateType();
            }
        }
        return this.lastReviewDate;
    }

    @Override
    public boolean hasLastReviewDateElement() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    @Override
    public boolean hasLastReviewDate() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    @Override
    public EvidenceVariable setLastReviewDateElement(DateType value) {
        this.lastReviewDate = value;
        return this;
    }

    @Override
    public Date getLastReviewDate() {
        return this.lastReviewDate == null ? null : (Date)this.lastReviewDate.getValue();
    }

    @Override
    public EvidenceVariable setLastReviewDate(Date value) {
        if (value == null) {
            this.lastReviewDate = null;
        } else {
            if (this.lastReviewDate == null) {
                this.lastReviewDate = new DateType();
            }
            this.lastReviewDate.setValue(value);
        }
        return this;
    }

    @Override
    public Period getEffectivePeriod() {
        if (this.effectivePeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceVariable.effectivePeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.effectivePeriod = new Period();
            }
        }
        return this.effectivePeriod;
    }

    @Override
    public boolean hasEffectivePeriod() {
        return this.effectivePeriod != null && !this.effectivePeriod.isEmpty();
    }

    @Override
    public EvidenceVariable setEffectivePeriod(Period value) {
        this.effectivePeriod = value;
        return this;
    }

    @Override
    public List<ContactDetail> getAuthor() {
        if (this.author == null) {
            this.author = new ArrayList<ContactDetail>();
        }
        return this.author;
    }

    @Override
    public EvidenceVariable setAuthor(List<ContactDetail> theAuthor) {
        this.author = theAuthor;
        return this;
    }

    @Override
    public boolean hasAuthor() {
        if (this.author == null) {
            return false;
        }
        for (ContactDetail item : this.author) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addAuthor() {
        ContactDetail t = new ContactDetail();
        if (this.author == null) {
            this.author = new ArrayList<ContactDetail>();
        }
        this.author.add(t);
        return t;
    }

    @Override
    public EvidenceVariable addAuthor(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.author == null) {
            this.author = new ArrayList<ContactDetail>();
        }
        this.author.add(t);
        return this;
    }

    @Override
    public ContactDetail getAuthorFirstRep() {
        if (this.getAuthor().isEmpty()) {
            this.addAuthor();
        }
        return this.getAuthor().get(0);
    }

    @Override
    public List<ContactDetail> getEditor() {
        if (this.editor == null) {
            this.editor = new ArrayList<ContactDetail>();
        }
        return this.editor;
    }

    @Override
    public EvidenceVariable setEditor(List<ContactDetail> theEditor) {
        this.editor = theEditor;
        return this;
    }

    @Override
    public boolean hasEditor() {
        if (this.editor == null) {
            return false;
        }
        for (ContactDetail item : this.editor) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addEditor() {
        ContactDetail t = new ContactDetail();
        if (this.editor == null) {
            this.editor = new ArrayList<ContactDetail>();
        }
        this.editor.add(t);
        return t;
    }

    @Override
    public EvidenceVariable addEditor(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.editor == null) {
            this.editor = new ArrayList<ContactDetail>();
        }
        this.editor.add(t);
        return this;
    }

    @Override
    public ContactDetail getEditorFirstRep() {
        if (this.getEditor().isEmpty()) {
            this.addEditor();
        }
        return this.getEditor().get(0);
    }

    @Override
    public List<ContactDetail> getReviewer() {
        if (this.reviewer == null) {
            this.reviewer = new ArrayList<ContactDetail>();
        }
        return this.reviewer;
    }

    @Override
    public EvidenceVariable setReviewer(List<ContactDetail> theReviewer) {
        this.reviewer = theReviewer;
        return this;
    }

    @Override
    public boolean hasReviewer() {
        if (this.reviewer == null) {
            return false;
        }
        for (ContactDetail item : this.reviewer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addReviewer() {
        ContactDetail t = new ContactDetail();
        if (this.reviewer == null) {
            this.reviewer = new ArrayList<ContactDetail>();
        }
        this.reviewer.add(t);
        return t;
    }

    @Override
    public EvidenceVariable addReviewer(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.reviewer == null) {
            this.reviewer = new ArrayList<ContactDetail>();
        }
        this.reviewer.add(t);
        return this;
    }

    @Override
    public ContactDetail getReviewerFirstRep() {
        if (this.getReviewer().isEmpty()) {
            this.addReviewer();
        }
        return this.getReviewer().get(0);
    }

    @Override
    public List<ContactDetail> getEndorser() {
        if (this.endorser == null) {
            this.endorser = new ArrayList<ContactDetail>();
        }
        return this.endorser;
    }

    @Override
    public EvidenceVariable setEndorser(List<ContactDetail> theEndorser) {
        this.endorser = theEndorser;
        return this;
    }

    @Override
    public boolean hasEndorser() {
        if (this.endorser == null) {
            return false;
        }
        for (ContactDetail item : this.endorser) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addEndorser() {
        ContactDetail t = new ContactDetail();
        if (this.endorser == null) {
            this.endorser = new ArrayList<ContactDetail>();
        }
        this.endorser.add(t);
        return t;
    }

    @Override
    public EvidenceVariable addEndorser(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.endorser == null) {
            this.endorser = new ArrayList<ContactDetail>();
        }
        this.endorser.add(t);
        return this;
    }

    @Override
    public ContactDetail getEndorserFirstRep() {
        if (this.getEndorser().isEmpty()) {
            this.addEndorser();
        }
        return this.getEndorser().get(0);
    }

    @Override
    public List<RelatedArtifact> getRelatedArtifact() {
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        return this.relatedArtifact;
    }

    @Override
    public EvidenceVariable setRelatedArtifact(List<RelatedArtifact> theRelatedArtifact) {
        this.relatedArtifact = theRelatedArtifact;
        return this;
    }

    @Override
    public boolean hasRelatedArtifact() {
        if (this.relatedArtifact == null) {
            return false;
        }
        for (RelatedArtifact item : this.relatedArtifact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public RelatedArtifact addRelatedArtifact() {
        RelatedArtifact t = new RelatedArtifact();
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        this.relatedArtifact.add(t);
        return t;
    }

    @Override
    public EvidenceVariable addRelatedArtifact(RelatedArtifact t) {
        if (t == null) {
            return this;
        }
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        this.relatedArtifact.add(t);
        return this;
    }

    @Override
    public RelatedArtifact getRelatedArtifactFirstRep() {
        if (this.getRelatedArtifact().isEmpty()) {
            this.addRelatedArtifact();
        }
        return this.getRelatedArtifact().get(0);
    }

    public BooleanType getActualElement() {
        if (this.actual == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceVariable.actual");
            }
            if (Configuration.doAutoCreate()) {
                this.actual = new BooleanType();
            }
        }
        return this.actual;
    }

    public boolean hasActualElement() {
        return this.actual != null && !this.actual.isEmpty();
    }

    public boolean hasActual() {
        return this.actual != null && !this.actual.isEmpty();
    }

    public EvidenceVariable setActualElement(BooleanType value) {
        this.actual = value;
        return this;
    }

    public boolean getActual() {
        return this.actual == null || this.actual.isEmpty() ? false : (Boolean)this.actual.getValue();
    }

    public EvidenceVariable setActual(boolean value) {
        if (this.actual == null) {
            this.actual = new BooleanType();
        }
        this.actual.setValue((Object)value);
        return this;
    }

    public List<EvidenceVariableCharacteristicComponent> getCharacteristic() {
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<EvidenceVariableCharacteristicComponent>();
        }
        return this.characteristic;
    }

    public EvidenceVariable setCharacteristic(List<EvidenceVariableCharacteristicComponent> theCharacteristic) {
        this.characteristic = theCharacteristic;
        return this;
    }

    public boolean hasCharacteristic() {
        if (this.characteristic == null) {
            return false;
        }
        for (EvidenceVariableCharacteristicComponent item : this.characteristic) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public EvidenceVariableCharacteristicComponent addCharacteristic() {
        EvidenceVariableCharacteristicComponent t = new EvidenceVariableCharacteristicComponent();
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<EvidenceVariableCharacteristicComponent>();
        }
        this.characteristic.add(t);
        return t;
    }

    public EvidenceVariable addCharacteristic(EvidenceVariableCharacteristicComponent t) {
        if (t == null) {
            return this;
        }
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<EvidenceVariableCharacteristicComponent>();
        }
        this.characteristic.add(t);
        return this;
    }

    public EvidenceVariableCharacteristicComponent getCharacteristicFirstRep() {
        if (this.getCharacteristic().isEmpty()) {
            this.addCharacteristic();
        }
        return this.getCharacteristic().get(0);
    }

    public Enumeration<Enumerations.EvidenceVariableHandling> getHandlingElement() {
        if (this.handling == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EvidenceVariable.handling");
            }
            if (Configuration.doAutoCreate()) {
                this.handling = new Enumeration<Enumerations.EvidenceVariableHandling>(new Enumerations.EvidenceVariableHandlingEnumFactory());
            }
        }
        return this.handling;
    }

    public boolean hasHandlingElement() {
        return this.handling != null && !this.handling.isEmpty();
    }

    public boolean hasHandling() {
        return this.handling != null && !this.handling.isEmpty();
    }

    public EvidenceVariable setHandlingElement(Enumeration<Enumerations.EvidenceVariableHandling> value) {
        this.handling = value;
        return this;
    }

    public Enumerations.EvidenceVariableHandling getHandling() {
        return this.handling == null ? null : (Enumerations.EvidenceVariableHandling)((Object)this.handling.getValue());
    }

    public EvidenceVariable setHandling(Enumerations.EvidenceVariableHandling value) {
        if (value == null) {
            this.handling = null;
        } else {
            if (this.handling == null) {
                this.handling = new Enumeration<Enumerations.EvidenceVariableHandling>(new Enumerations.EvidenceVariableHandlingEnumFactory());
            }
            this.handling.setValue((Object)value);
        }
        return this;
    }

    public List<EvidenceVariableCategoryComponent> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<EvidenceVariableCategoryComponent>();
        }
        return this.category;
    }

    public EvidenceVariable setCategory(List<EvidenceVariableCategoryComponent> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (EvidenceVariableCategoryComponent item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public EvidenceVariableCategoryComponent addCategory() {
        EvidenceVariableCategoryComponent t = new EvidenceVariableCategoryComponent();
        if (this.category == null) {
            this.category = new ArrayList<EvidenceVariableCategoryComponent>();
        }
        this.category.add(t);
        return t;
    }

    public EvidenceVariable addCategory(EvidenceVariableCategoryComponent t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<EvidenceVariableCategoryComponent>();
        }
        this.category.add(t);
        return this;
    }

    public EvidenceVariableCategoryComponent getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    @Override
    public int getVersionAlgorithmMax() {
        return 0;
    }

    @Override
    public DataType getVersionAlgorithm() {
        throw new Error("The resource type \"EvidenceVariable\" does not implement the property \"versionAlgorithm[x]\"");
    }

    @Override
    public StringType getVersionAlgorithmStringType() {
        throw new Error("The resource type \"EvidenceVariable\" does not implement the property \"versionAlgorithm[x]\"");
    }

    @Override
    public boolean hasVersionAlgorithmStringType() {
        return false;
    }

    @Override
    public Coding getVersionAlgorithmCoding() {
        throw new Error("The resource type \"EvidenceVariable\" does not implement the property \"versionAlgorithm[x]\"");
    }

    @Override
    public boolean hasVersionAlgorithmCoding() {
        return false;
    }

    @Override
    public boolean hasVersionAlgorithm() {
        return false;
    }

    @Override
    public EvidenceVariable setVersionAlgorithm(DataType value) {
        throw new Error("The resource type \"EvidenceVariable\" does not implement the property \"versionAlgorithm[x]\"");
    }

    @Override
    public int getJurisdictionMax() {
        return 0;
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        return new ArrayList<CodeableConcept>();
    }

    @Override
    public EvidenceVariable setJurisdiction(List<CodeableConcept> theJurisdiction) {
        throw new Error("The resource type \"EvidenceVariable\" does not implement the property \"jurisdiction\"");
    }

    @Override
    public boolean hasJurisdiction() {
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        throw new Error("The resource type \"EvidenceVariable\" does not implement the property \"jurisdiction\"");
    }

    @Override
    public EvidenceVariable addJurisdiction(CodeableConcept t) {
        throw new Error("The resource type \"EvidenceVariable\" does not implement the property \"jurisdiction\"");
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        throw new Error("The resource type \"EvidenceVariable\" does not implement the property \"jurisdiction\"");
    }

    @Override
    public int getPurposeMax() {
        return 0;
    }

    @Override
    public MarkdownType getPurposeElement() {
        throw new Error("The resource type \"EvidenceVariable\" does not implement the property \"purpose\"");
    }

    @Override
    public boolean hasPurposeElement() {
        return false;
    }

    @Override
    public boolean hasPurpose() {
        return false;
    }

    @Override
    public EvidenceVariable setPurposeElement(MarkdownType value) {
        throw new Error("The resource type \"EvidenceVariable\" does not implement the property \"purpose\"");
    }

    @Override
    public String getPurpose() {
        throw new Error("The resource type \"EvidenceVariable\" does not implement the property \"purpose\"");
    }

    @Override
    public EvidenceVariable setPurpose(String value) {
        throw new Error("The resource type \"EvidenceVariable\" does not implement the property \"purpose\"");
    }

    @Override
    public int getCopyrightLabelMax() {
        return 0;
    }

    @Override
    public StringType getCopyrightLabelElement() {
        throw new Error("The resource type \"EvidenceVariable\" does not implement the property \"copyrightLabel\"");
    }

    @Override
    public boolean hasCopyrightLabelElement() {
        return false;
    }

    @Override
    public boolean hasCopyrightLabel() {
        return false;
    }

    @Override
    public EvidenceVariable setCopyrightLabelElement(StringType value) {
        throw new Error("The resource type \"EvidenceVariable\" does not implement the property \"copyrightLabel\"");
    }

    @Override
    public String getCopyrightLabel() {
        throw new Error("The resource type \"EvidenceVariable\" does not implement the property \"copyrightLabel\"");
    }

    @Override
    public EvidenceVariable setCopyrightLabel(String value) {
        throw new Error("The resource type \"EvidenceVariable\" does not implement the property \"copyrightLabel\"");
    }

    @Override
    public int getTopicMax() {
        return 0;
    }

    @Override
    public List<CodeableConcept> getTopic() {
        return new ArrayList<CodeableConcept>();
    }

    @Override
    public EvidenceVariable setTopic(List<CodeableConcept> theTopic) {
        throw new Error("The resource type \"EvidenceVariable\" does not implement the property \"topic\"");
    }

    @Override
    public boolean hasTopic() {
        return false;
    }

    @Override
    public CodeableConcept addTopic() {
        throw new Error("The resource type \"EvidenceVariable\" does not implement the property \"topic\"");
    }

    @Override
    public EvidenceVariable addTopic(CodeableConcept t) {
        throw new Error("The resource type \"EvidenceVariable\" does not implement the property \"topic\"");
    }

    @Override
    public CodeableConcept getTopicFirstRep() {
        throw new Error("The resource type \"EvidenceVariable\" does not implement the property \"topic\"");
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this evidence variable when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which an authoritative instance of this evidence variable is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the evidence variable is stored on different servers.", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this evidence variable when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the evidence variable when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the evidence variable author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence. To provide a version consistent with the Decision Support Service specification, use the format Major.Minor.Revision (e.g. 1.0.0). For more information on versioning knowledge assets, refer to the Decision Support Service specification. Note that a version is required for non-experimental active artifacts.", 0, 1, this.version));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the evidence variable. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the evidence variable.", 0, 1, this.title));
        children.add(new Property("shortTitle", "string", "The short title provides an alternate title for use in informal descriptive contexts where the full, formal title is not necessary.", 0, 1, this.shortTitle));
        children.add(new Property("subtitle", "string", "An explanatory or alternate title for the EvidenceVariable giving additional information about its content.", 0, 1, this.subtitle));
        children.add(new Property(SP_STATUS, "code", "The status of this evidence variable. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property("experimental", "boolean", "A Boolean value to indicate that this resource is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the evidence variable was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the evidence variable changes.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the organization or individual responsible for the release and ongoing maintenance of the evidence variable.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the evidence variable from a consumer's perspective.", 0, 1, this.description));
        children.add(new Property("note", "Annotation", "A human-readable string to clarify or explain concepts about the resource.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate evidence variable instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property("copyright", "markdown", "A copyright statement relating to the resource and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the resource.", 0, 1, this.copyright));
        children.add(new Property("approvalDate", SP_DATE, "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate));
        children.add(new Property("lastReviewDate", SP_DATE, "The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.", 0, 1, this.lastReviewDate));
        children.add(new Property("effectivePeriod", "Period", "The period during which the resource content was or is planned to be in active use.", 0, 1, this.effectivePeriod));
        children.add(new Property("author", "ContactDetail", "An individiual or organization primarily involved in the creation and maintenance of the content.", 0, Integer.MAX_VALUE, this.author));
        children.add(new Property("editor", "ContactDetail", "An individual or organization primarily responsible for internal coherence of the content.", 0, Integer.MAX_VALUE, this.editor));
        children.add(new Property("reviewer", "ContactDetail", "An individual or organization primarily responsible for review of some aspect of the content.", 0, Integer.MAX_VALUE, this.reviewer));
        children.add(new Property("endorser", "ContactDetail", "An individual or organization responsible for officially endorsing the content for use in some setting.", 0, Integer.MAX_VALUE, this.endorser));
        children.add(new Property("relatedArtifact", "RelatedArtifact", "Related artifacts such as additional documentation, justification, or bibliographic references.", 0, Integer.MAX_VALUE, this.relatedArtifact));
        children.add(new Property("actual", "boolean", "True if the actual variable measured, false if a conceptual representation of the intended variable.", 0, 1, this.actual));
        children.add(new Property("characteristic", "", "A defining factor of the EvidenceVariable. Multiple characteristics are applied with \"and\" semantics.", 0, Integer.MAX_VALUE, this.characteristic));
        children.add(new Property("handling", "code", "The method of handling in statistical analysis.", 0, 1, this.handling));
        children.add(new Property("category", "", "A grouping for ordinal or polychotomous variables.", 0, Integer.MAX_VALUE, this.category));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this evidence variable when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which an authoritative instance of this evidence variable is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the evidence variable is stored on different servers.", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this evidence variable when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the evidence variable when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the evidence variable author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence. To provide a version consistent with the Decision Support Service specification, use the format Major.Minor.Revision (e.g. 1.0.0). For more information on versioning knowledge assets, refer to the Decision Support Service specification. Note that a version is required for non-experimental active artifacts.", 0, 1, this.version);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the evidence variable. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the evidence variable.", 0, 1, this.title);
            }
            case 1555503932: {
                return new Property("shortTitle", "string", "The short title provides an alternate title for use in informal descriptive contexts where the full, formal title is not necessary.", 0, 1, this.shortTitle);
            }
            case -2060497896: {
                return new Property("subtitle", "string", "An explanatory or alternate title for the EvidenceVariable giving additional information about its content.", 0, 1, this.subtitle);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this evidence variable. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A Boolean value to indicate that this resource is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the evidence variable was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the evidence variable changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the organization or individual responsible for the release and ongoing maintenance of the evidence variable.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the evidence variable from a consumer's perspective.", 0, 1, this.description);
            }
            case 3387378: {
                return new Property("note", "Annotation", "A human-readable string to clarify or explain concepts about the resource.", 0, Integer.MAX_VALUE, this.note);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate evidence variable instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "A copyright statement relating to the resource and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the resource.", 0, 1, this.copyright);
            }
            case 223539345: {
                return new Property("approvalDate", SP_DATE, "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate);
            }
            case -1687512484: {
                return new Property("lastReviewDate", SP_DATE, "The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.", 0, 1, this.lastReviewDate);
            }
            case -403934648: {
                return new Property("effectivePeriod", "Period", "The period during which the resource content was or is planned to be in active use.", 0, 1, this.effectivePeriod);
            }
            case -1406328437: {
                return new Property("author", "ContactDetail", "An individiual or organization primarily involved in the creation and maintenance of the content.", 0, Integer.MAX_VALUE, this.author);
            }
            case -1307827859: {
                return new Property("editor", "ContactDetail", "An individual or organization primarily responsible for internal coherence of the content.", 0, Integer.MAX_VALUE, this.editor);
            }
            case -261190139: {
                return new Property("reviewer", "ContactDetail", "An individual or organization primarily responsible for review of some aspect of the content.", 0, Integer.MAX_VALUE, this.reviewer);
            }
            case 1740277666: {
                return new Property("endorser", "ContactDetail", "An individual or organization responsible for officially endorsing the content for use in some setting.", 0, Integer.MAX_VALUE, this.endorser);
            }
            case 666807069: {
                return new Property("relatedArtifact", "RelatedArtifact", "Related artifacts such as additional documentation, justification, or bibliographic references.", 0, Integer.MAX_VALUE, this.relatedArtifact);
            }
            case -1422939762: {
                return new Property("actual", "boolean", "True if the actual variable measured, false if a conceptual representation of the intended variable.", 0, 1, this.actual);
            }
            case 366313883: {
                return new Property("characteristic", "", "A defining factor of the EvidenceVariable. Multiple characteristics are applied with \"and\" semantics.", 0, Integer.MAX_VALUE, this.characteristic);
            }
            case 2072805: {
                return new Property("handling", "code", "The method of handling in statistical analysis.", 0, 1, this.handling);
            }
            case 50511102: {
                return new Property("category", "", "A grouping for ordinal or polychotomous variables.", 0, Integer.MAX_VALUE, this.category);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.title;
                }
                return baseArray;
            }
            case 1555503932: {
                Base[] baseArray;
                if (this.shortTitle == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.shortTitle;
                }
                return baseArray;
            }
            case -2060497896: {
                Base[] baseArray;
                if (this.subtitle == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.subtitle;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.description;
                }
                return baseArray;
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.copyright;
                }
                return baseArray;
            }
            case 223539345: {
                Base[] baseArray;
                if (this.approvalDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.approvalDate;
                }
                return baseArray;
            }
            case -1687512484: {
                Base[] baseArray;
                if (this.lastReviewDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.lastReviewDate;
                }
                return baseArray;
            }
            case -403934648: {
                Base[] baseArray;
                if (this.effectivePeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.effectivePeriod;
                }
                return baseArray;
            }
            case -1406328437: {
                return this.author == null ? new Base[]{} : this.author.toArray(new Base[this.author.size()]);
            }
            case -1307827859: {
                return this.editor == null ? new Base[]{} : this.editor.toArray(new Base[this.editor.size()]);
            }
            case -261190139: {
                return this.reviewer == null ? new Base[]{} : this.reviewer.toArray(new Base[this.reviewer.size()]);
            }
            case 1740277666: {
                return this.endorser == null ? new Base[]{} : this.endorser.toArray(new Base[this.endorser.size()]);
            }
            case 666807069: {
                return this.relatedArtifact == null ? new Base[]{} : this.relatedArtifact.toArray(new Base[this.relatedArtifact.size()]);
            }
            case -1422939762: {
                Base[] baseArray;
                if (this.actual == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.actual;
                }
                return baseArray;
            }
            case 366313883: {
                return this.characteristic == null ? new Base[]{} : this.characteristic.toArray(new Base[this.characteristic.size()]);
            }
            case 2072805: {
                Base[] baseArray;
                if (this.handling == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray18 = new Base[1];
                    baseArray = baseArray18;
                    baseArray18[0] = this.handling;
                }
                return baseArray;
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = TypeConvertor.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 351608024: {
                this.version = TypeConvertor.castToString(value);
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = TypeConvertor.castToString(value);
                return value;
            }
            case 1555503932: {
                this.shortTitle = TypeConvertor.castToString(value);
                return value;
            }
            case -2060497896: {
                this.subtitle = TypeConvertor.castToString(value);
                return value;
            }
            case -892481550: {
                value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -404562712: {
                this.experimental = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = TypeConvertor.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
            case -669707736: {
                this.getUseContext().add(TypeConvertor.castToUsageContext(value));
                return value;
            }
            case 1522889671: {
                this.copyright = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 223539345: {
                this.approvalDate = TypeConvertor.castToDate(value);
                return value;
            }
            case -1687512484: {
                this.lastReviewDate = TypeConvertor.castToDate(value);
                return value;
            }
            case -403934648: {
                this.effectivePeriod = TypeConvertor.castToPeriod(value);
                return value;
            }
            case -1406328437: {
                this.getAuthor().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -1307827859: {
                this.getEditor().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -261190139: {
                this.getReviewer().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case 1740277666: {
                this.getEndorser().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case 666807069: {
                this.getRelatedArtifact().add(TypeConvertor.castToRelatedArtifact(value));
                return value;
            }
            case -1422939762: {
                this.actual = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 366313883: {
                this.getCharacteristic().add((EvidenceVariableCharacteristicComponent)((Object)value));
                return value;
            }
            case 2072805: {
                value = new Enumerations.EvidenceVariableHandlingEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.handling = value;
                return value;
            }
            case 50511102: {
                this.getCategory().add((EvidenceVariableCategoryComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = TypeConvertor.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = TypeConvertor.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = TypeConvertor.castToString(value);
        } else if (name.equals("shortTitle")) {
            this.shortTitle = TypeConvertor.castToString(value);
        } else if (name.equals("subtitle")) {
            this.subtitle = TypeConvertor.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("experimental")) {
            this.experimental = TypeConvertor.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = TypeConvertor.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = TypeConvertor.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else if (name.equals("useContext")) {
            this.getUseContext().add(TypeConvertor.castToUsageContext(value));
        } else if (name.equals("copyright")) {
            this.copyright = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("approvalDate")) {
            this.approvalDate = TypeConvertor.castToDate(value);
        } else if (name.equals("lastReviewDate")) {
            this.lastReviewDate = TypeConvertor.castToDate(value);
        } else if (name.equals("effectivePeriod")) {
            this.effectivePeriod = TypeConvertor.castToPeriod(value);
        } else if (name.equals("author")) {
            this.getAuthor().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("editor")) {
            this.getEditor().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("reviewer")) {
            this.getReviewer().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("endorser")) {
            this.getEndorser().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("relatedArtifact")) {
            this.getRelatedArtifact().add(TypeConvertor.castToRelatedArtifact(value));
        } else if (name.equals("actual")) {
            this.actual = TypeConvertor.castToBoolean(value);
        } else if (name.equals("characteristic")) {
            this.getCharacteristic().add((EvidenceVariableCharacteristicComponent)((Object)value));
        } else if (name.equals("handling")) {
            value = new Enumerations.EvidenceVariableHandlingEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.handling = value;
        } else if (name.equals("category")) {
            this.getCategory().add((EvidenceVariableCategoryComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case 1555503932: {
                return this.getShortTitleElement();
            }
            case -2060497896: {
                return this.getSubtitleElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case 3387378: {
                return this.addNote();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case 223539345: {
                return this.getApprovalDateElement();
            }
            case -1687512484: {
                return this.getLastReviewDateElement();
            }
            case -403934648: {
                return this.getEffectivePeriod();
            }
            case -1406328437: {
                return this.addAuthor();
            }
            case -1307827859: {
                return this.addEditor();
            }
            case -261190139: {
                return this.addReviewer();
            }
            case 1740277666: {
                return this.addEndorser();
            }
            case 666807069: {
                return this.addRelatedArtifact();
            }
            case -1422939762: {
                return this.getActualElement();
            }
            case 366313883: {
                return this.addCharacteristic();
            }
            case 2072805: {
                return this.getHandlingElement();
            }
            case 50511102: {
                return this.addCategory();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case 1555503932: {
                return new String[]{"string"};
            }
            case -2060497896: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case 223539345: {
                return new String[]{SP_DATE};
            }
            case -1687512484: {
                return new String[]{SP_DATE};
            }
            case -403934648: {
                return new String[]{"Period"};
            }
            case -1406328437: {
                return new String[]{"ContactDetail"};
            }
            case -1307827859: {
                return new String[]{"ContactDetail"};
            }
            case -261190139: {
                return new String[]{"ContactDetail"};
            }
            case 1740277666: {
                return new String[]{"ContactDetail"};
            }
            case 666807069: {
                return new String[]{"RelatedArtifact"};
            }
            case -1422939762: {
                return new String[]{"boolean"};
            }
            case 366313883: {
                return new String[0];
            }
            case 2072805: {
                return new String[]{"code"};
            }
            case 50511102: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type EvidenceVariable.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type EvidenceVariable.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type EvidenceVariable.name");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a primitive type EvidenceVariable.title");
        }
        if (name.equals("shortTitle")) {
            throw new FHIRException("Cannot call addChild on a primitive type EvidenceVariable.shortTitle");
        }
        if (name.equals("subtitle")) {
            throw new FHIRException("Cannot call addChild on a primitive type EvidenceVariable.subtitle");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type EvidenceVariable.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a primitive type EvidenceVariable.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type EvidenceVariable.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a primitive type EvidenceVariable.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a primitive type EvidenceVariable.description");
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a primitive type EvidenceVariable.copyright");
        }
        if (name.equals("approvalDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type EvidenceVariable.approvalDate");
        }
        if (name.equals("lastReviewDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type EvidenceVariable.lastReviewDate");
        }
        if (name.equals("effectivePeriod")) {
            this.effectivePeriod = new Period();
            return this.effectivePeriod;
        }
        if (name.equals("author")) {
            return this.addAuthor();
        }
        if (name.equals("editor")) {
            return this.addEditor();
        }
        if (name.equals("reviewer")) {
            return this.addReviewer();
        }
        if (name.equals("endorser")) {
            return this.addEndorser();
        }
        if (name.equals("relatedArtifact")) {
            return this.addRelatedArtifact();
        }
        if (name.equals("actual")) {
            throw new FHIRException("Cannot call addChild on a primitive type EvidenceVariable.actual");
        }
        if (name.equals("characteristic")) {
            return this.addCharacteristic();
        }
        if (name.equals("handling")) {
            throw new FHIRException("Cannot call addChild on a primitive type EvidenceVariable.handling");
        }
        if (name.equals("category")) {
            return this.addCategory();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "EvidenceVariable";
    }

    @Override
    public EvidenceVariable copy() {
        EvidenceVariable dst = new EvidenceVariable();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(EvidenceVariable dst) {
        super.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.title = this.title == null ? null : this.title.copy();
        dst.shortTitle = this.shortTitle == null ? null : this.shortTitle.copy();
        dst.subtitle = this.subtitle == null ? null : this.subtitle.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.useContext != null) {
            dst.useContext = new ArrayList<UsageContext>();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        dst.approvalDate = this.approvalDate == null ? null : this.approvalDate.copy();
        dst.lastReviewDate = this.lastReviewDate == null ? null : this.lastReviewDate.copy();
        Period period = dst.effectivePeriod = this.effectivePeriod == null ? null : this.effectivePeriod.copy();
        if (this.author != null) {
            dst.author = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.author) {
                dst.author.add(contactDetail.copy());
            }
        }
        if (this.editor != null) {
            dst.editor = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.editor) {
                dst.editor.add(contactDetail.copy());
            }
        }
        if (this.reviewer != null) {
            dst.reviewer = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.reviewer) {
                dst.reviewer.add(contactDetail.copy());
            }
        }
        if (this.endorser != null) {
            dst.endorser = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.endorser) {
                dst.endorser.add(contactDetail.copy());
            }
        }
        if (this.relatedArtifact != null) {
            dst.relatedArtifact = new ArrayList<RelatedArtifact>();
            for (RelatedArtifact relatedArtifact : this.relatedArtifact) {
                dst.relatedArtifact.add(relatedArtifact.copy());
            }
        }
        BooleanType booleanType = dst.actual = this.actual == null ? null : this.actual.copy();
        if (this.characteristic != null) {
            dst.characteristic = new ArrayList<EvidenceVariableCharacteristicComponent>();
            for (EvidenceVariableCharacteristicComponent evidenceVariableCharacteristicComponent : this.characteristic) {
                dst.characteristic.add(evidenceVariableCharacteristicComponent.copy());
            }
        }
        Enumeration<Enumerations.EvidenceVariableHandling> enumeration = dst.handling = this.handling == null ? null : this.handling.copy();
        if (this.category != null) {
            dst.category = new ArrayList<EvidenceVariableCategoryComponent>();
            for (EvidenceVariableCategoryComponent evidenceVariableCategoryComponent : this.category) {
                dst.category.add(evidenceVariableCategoryComponent.copy());
            }
        }
    }

    protected EvidenceVariable typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof EvidenceVariable)) {
            return false;
        }
        EvidenceVariable o = (EvidenceVariable)other_;
        return EvidenceVariable.compareDeep(this.url, o.url, true) && EvidenceVariable.compareDeep(this.identifier, o.identifier, true) && EvidenceVariable.compareDeep(this.version, o.version, true) && EvidenceVariable.compareDeep(this.name, o.name, true) && EvidenceVariable.compareDeep(this.title, o.title, true) && EvidenceVariable.compareDeep(this.shortTitle, o.shortTitle, true) && EvidenceVariable.compareDeep(this.subtitle, o.subtitle, true) && EvidenceVariable.compareDeep(this.status, o.status, true) && EvidenceVariable.compareDeep(this.experimental, o.experimental, true) && EvidenceVariable.compareDeep(this.date, o.date, true) && EvidenceVariable.compareDeep(this.publisher, o.publisher, true) && EvidenceVariable.compareDeep(this.contact, o.contact, true) && EvidenceVariable.compareDeep(this.description, o.description, true) && EvidenceVariable.compareDeep(this.note, o.note, true) && EvidenceVariable.compareDeep(this.useContext, o.useContext, true) && EvidenceVariable.compareDeep(this.copyright, o.copyright, true) && EvidenceVariable.compareDeep(this.approvalDate, o.approvalDate, true) && EvidenceVariable.compareDeep(this.lastReviewDate, o.lastReviewDate, true) && EvidenceVariable.compareDeep(this.effectivePeriod, o.effectivePeriod, true) && EvidenceVariable.compareDeep(this.author, o.author, true) && EvidenceVariable.compareDeep(this.editor, o.editor, true) && EvidenceVariable.compareDeep(this.reviewer, o.reviewer, true) && EvidenceVariable.compareDeep(this.endorser, o.endorser, true) && EvidenceVariable.compareDeep(this.relatedArtifact, o.relatedArtifact, true) && EvidenceVariable.compareDeep(this.actual, o.actual, true) && EvidenceVariable.compareDeep(this.characteristic, o.characteristic, true) && EvidenceVariable.compareDeep(this.handling, o.handling, true) && EvidenceVariable.compareDeep(this.category, o.category, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof EvidenceVariable)) {
            return false;
        }
        EvidenceVariable o = (EvidenceVariable)other_;
        return EvidenceVariable.compareValues(this.url, o.url, true) && EvidenceVariable.compareValues(this.version, o.version, true) && EvidenceVariable.compareValues(this.name, o.name, true) && EvidenceVariable.compareValues(this.title, o.title, true) && EvidenceVariable.compareValues(this.shortTitle, o.shortTitle, true) && EvidenceVariable.compareValues(this.subtitle, o.subtitle, true) && EvidenceVariable.compareValues(this.status, o.status, true) && EvidenceVariable.compareValues(this.experimental, o.experimental, true) && EvidenceVariable.compareValues(this.date, o.date, true) && EvidenceVariable.compareValues(this.publisher, o.publisher, true) && EvidenceVariable.compareValues(this.description, o.description, true) && EvidenceVariable.compareValues(this.copyright, o.copyright, true) && EvidenceVariable.compareValues(this.approvalDate, o.approvalDate, true) && EvidenceVariable.compareValues(this.lastReviewDate, o.lastReviewDate, true) && EvidenceVariable.compareValues(this.actual, o.actual, true) && EvidenceVariable.compareValues(this.handling, o.handling, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.url, this.identifier, this.version, this.name, this.title, this.shortTitle, this.subtitle, this.status, this.experimental, this.date, this.publisher, this.contact, this.description, this.note, this.useContext, this.copyright, this.approvalDate, this.lastReviewDate, this.effectivePeriod, this.author, this.editor, this.reviewer, this.endorser, this.relatedArtifact, this.actual, this.characteristic, this.handling, this.category});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.EvidenceVariable;
    }

    @Block
    public static class EvidenceVariableCategoryComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of the grouping", formalDefinition="Description of the grouping.")
        protected StringType name;
        @Child(name="value", type={CodeableConcept.class, Quantity.class, Range.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Definition of the grouping", formalDefinition="Definition of the grouping.")
        protected DataType value;
        private static final long serialVersionUID = 1839679495L;

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceVariableCategoryComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public EvidenceVariableCategoryComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public EvidenceVariableCategoryComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public CodeableConcept getValueCodeableConcept() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeableConcept();
            }
            if (!(this.value instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.value;
        }

        public boolean hasValueCodeableConcept() {
            return this != null && this.value instanceof CodeableConcept;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                this.value = new Quantity();
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this != null && this.value instanceof Quantity;
        }

        public Range getValueRange() throws FHIRException {
            if (this.value == null) {
                this.value = new Range();
            }
            if (!(this.value instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Range)this.value;
        }

        public boolean hasValueRange() {
            return this != null && this.value instanceof Range;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public EvidenceVariableCategoryComponent setValue(DataType value) {
            if (!(value == null || value instanceof CodeableConcept || value instanceof Quantity || value instanceof Range)) {
                throw new Error("Not the right type for EvidenceVariable.category.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(EvidenceVariable.SP_NAME, "string", "Description of the grouping.", 0, 1, this.name));
            children.add(new Property("value[x]", "CodeableConcept|Quantity|Range", "Definition of the grouping.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property(EvidenceVariable.SP_NAME, "string", "Description of the grouping.", 0, 1, this.name);
                }
                case -1410166417: {
                    return new Property("value[x]", "CodeableConcept|Quantity|Range", "Definition of the grouping.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "CodeableConcept|Quantity|Range", "Definition of the grouping.", 0, 1, this.value);
                }
                case 924902896: {
                    return new Property("value[x]", "CodeableConcept", "Definition of the grouping.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "Quantity", "Definition of the grouping.", 0, 1, this.value);
                }
                case 2030761548: {
                    return new Property("value[x]", "Range", "Definition of the grouping.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = TypeConvertor.castToString(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(EvidenceVariable.SP_NAME)) {
                this.name = TypeConvertor.castToString(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"string"};
                }
                case 111972721: {
                    return new String[]{"CodeableConcept", "Quantity", "Range"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(EvidenceVariable.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type EvidenceVariable.category.name");
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueRange")) {
                this.value = new Range();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public EvidenceVariableCategoryComponent copy() {
            EvidenceVariableCategoryComponent dst = new EvidenceVariableCategoryComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(EvidenceVariableCategoryComponent dst) {
            super.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof EvidenceVariableCategoryComponent)) {
                return false;
            }
            EvidenceVariableCategoryComponent o = (EvidenceVariableCategoryComponent)other_;
            return EvidenceVariableCategoryComponent.compareDeep(this.name, o.name, true) && EvidenceVariableCategoryComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof EvidenceVariableCategoryComponent)) {
                return false;
            }
            EvidenceVariableCategoryComponent o = (EvidenceVariableCategoryComponent)other_;
            return EvidenceVariableCategoryComponent.compareValues(this.name, o.name, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.name, this.value});
        }

        @Override
        public String fhirType() {
            return "EvidenceVariable.category";
        }
    }

    @Block
    public static class EvidenceVariableCharacteristicTimeFromEventComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Human readable description", formalDefinition="Human readable description.")
        protected StringType description;
        @Child(name="note", type={Annotation.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Used for footnotes or explanatory notes", formalDefinition="A human-readable string to clarify or explain concepts about the timeFromEvent.")
        protected List<Annotation> note;
        @Child(name="event", type={CodeableConcept.class, Reference.class, DateTimeType.class, IdType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The event used as a base point (reference point) in time", formalDefinition="The event used as a base point (reference point) in time.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/evidence-variable-event")
        protected DataType event;
        @Child(name="quantity", type={Quantity.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Used to express the observation at a defined amount of time after the study start", formalDefinition="Used to express the observation at a defined amount of time after the study start.")
        protected Quantity quantity;
        @Child(name="range", type={Range.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Used to express the observation within a period after the study start", formalDefinition="Used to express the observation within a period after the study start.")
        protected Range range;
        private static final long serialVersionUID = 858422874L;

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceVariableCharacteristicTimeFromEventComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public EvidenceVariableCharacteristicTimeFromEventComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public EvidenceVariableCharacteristicTimeFromEventComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public List<Annotation> getNote() {
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            return this.note;
        }

        public EvidenceVariableCharacteristicTimeFromEventComponent setNote(List<Annotation> theNote) {
            this.note = theNote;
            return this;
        }

        public boolean hasNote() {
            if (this.note == null) {
                return false;
            }
            for (Annotation item : this.note) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Annotation addNote() {
            Annotation t = new Annotation();
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return t;
        }

        public EvidenceVariableCharacteristicTimeFromEventComponent addNote(Annotation t) {
            if (t == null) {
                return this;
            }
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return this;
        }

        public Annotation getNoteFirstRep() {
            if (this.getNote().isEmpty()) {
                this.addNote();
            }
            return this.getNote().get(0);
        }

        public DataType getEvent() {
            return this.event;
        }

        public CodeableConcept getEventCodeableConcept() throws FHIRException {
            if (this.event == null) {
                this.event = new CodeableConcept();
            }
            if (!(this.event instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.event.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.event;
        }

        public boolean hasEventCodeableConcept() {
            return this != null && this.event instanceof CodeableConcept;
        }

        public Reference getEventReference() throws FHIRException {
            if (this.event == null) {
                this.event = new Reference();
            }
            if (!(this.event instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.event.getClass().getName() + " was encountered");
            }
            return (Reference)this.event;
        }

        public boolean hasEventReference() {
            return this != null && this.event instanceof Reference;
        }

        public DateTimeType getEventDateTimeType() throws FHIRException {
            if (this.event == null) {
                this.event = new DateTimeType();
            }
            if (!(this.event instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.event.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.event;
        }

        public boolean hasEventDateTimeType() {
            return this != null && this.event instanceof DateTimeType;
        }

        public IdType getEventIdType() throws FHIRException {
            if (this.event == null) {
                this.event = new IdType();
            }
            if (!(this.event instanceof IdType)) {
                throw new FHIRException("Type mismatch: the type IdType was expected, but " + this.event.getClass().getName() + " was encountered");
            }
            return (IdType)this.event;
        }

        public boolean hasEventIdType() {
            return this != null && this.event instanceof IdType;
        }

        public boolean hasEvent() {
            return this.event != null && !this.event.isEmpty();
        }

        public EvidenceVariableCharacteristicTimeFromEventComponent setEvent(DataType value) {
            if (!(value == null || value instanceof CodeableConcept || value instanceof Reference || value instanceof DateTimeType || value instanceof IdType)) {
                throw new Error("Not the right type for EvidenceVariable.characteristic.timeFromEvent.event[x]: " + value.fhirType());
            }
            this.event = value;
            return this;
        }

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceVariableCharacteristicTimeFromEventComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public EvidenceVariableCharacteristicTimeFromEventComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        public Range getRange() {
            if (this.range == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceVariableCharacteristicTimeFromEventComponent.range");
                }
                if (Configuration.doAutoCreate()) {
                    this.range = new Range();
                }
            }
            return this.range;
        }

        public boolean hasRange() {
            return this.range != null && !this.range.isEmpty();
        }

        public EvidenceVariableCharacteristicTimeFromEventComponent setRange(Range value) {
            this.range = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(EvidenceVariable.SP_DESCRIPTION, "string", "Human readable description.", 0, 1, this.description));
            children.add(new Property("note", "Annotation", "A human-readable string to clarify or explain concepts about the timeFromEvent.", 0, Integer.MAX_VALUE, this.note));
            children.add(new Property("event[x]", "CodeableConcept|Reference|dateTime|id", "The event used as a base point (reference point) in time.", 0, 1, this.event));
            children.add(new Property("quantity", "Quantity", "Used to express the observation at a defined amount of time after the study start.", 0, 1, this.quantity));
            children.add(new Property("range", "Range", "Used to express the observation within a period after the study start.", 0, 1, this.range));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property(EvidenceVariable.SP_DESCRIPTION, "string", "Human readable description.", 0, 1, this.description);
                }
                case 3387378: {
                    return new Property("note", "Annotation", "A human-readable string to clarify or explain concepts about the timeFromEvent.", 0, Integer.MAX_VALUE, this.note);
                }
                case 278115238: {
                    return new Property("event[x]", "CodeableConcept|Reference|dateTime|id", "The event used as a base point (reference point) in time.", 0, 1, this.event);
                }
                case 96891546: {
                    return new Property("event[x]", "CodeableConcept|Reference|dateTime|id", "The event used as a base point (reference point) in time.", 0, 1, this.event);
                }
                case 1464167847: {
                    return new Property("event[x]", "CodeableConcept", "The event used as a base point (reference point) in time.", 0, 1, this.event);
                }
                case 30751185: {
                    return new Property("event[x]", "Reference", "The event used as a base point (reference point) in time.", 0, 1, this.event);
                }
                case -116077483: {
                    return new Property("event[x]", "dateTime", "The event used as a base point (reference point) in time.", 0, 1, this.event);
                }
                case -1376502443: {
                    return new Property("event[x]", "id", "The event used as a base point (reference point) in time.", 0, 1, this.event);
                }
                case -1285004149: {
                    return new Property("quantity", "Quantity", "Used to express the observation at a defined amount of time after the study start.", 0, 1, this.quantity);
                }
                case 108280125: {
                    return new Property("range", "Range", "Used to express the observation within a period after the study start.", 0, 1, this.range);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case 3387378: {
                    return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
                }
                case 96891546: {
                    Base[] baseArray;
                    if (this.event == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.event;
                    }
                    return baseArray;
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.quantity;
                    }
                    return baseArray;
                }
                case 108280125: {
                    Base[] baseArray;
                    if (this.range == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.range;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case 3387378: {
                    this.getNote().add(TypeConvertor.castToAnnotation(value));
                    return value;
                }
                case 96891546: {
                    this.event = TypeConvertor.castToType(value);
                    return value;
                }
                case -1285004149: {
                    this.quantity = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case 108280125: {
                    this.range = TypeConvertor.castToRange(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(EvidenceVariable.SP_DESCRIPTION)) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals("note")) {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
            } else if (name.equals("event[x]")) {
                this.event = TypeConvertor.castToType(value);
            } else if (name.equals("quantity")) {
                this.quantity = TypeConvertor.castToQuantity(value);
            } else if (name.equals("range")) {
                this.range = TypeConvertor.castToRange(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 3387378: {
                    return this.addNote();
                }
                case 278115238: {
                    return this.getEvent();
                }
                case 96891546: {
                    return this.getEvent();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case 108280125: {
                    return this.getRange();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"string"};
                }
                case 3387378: {
                    return new String[]{"Annotation"};
                }
                case 96891546: {
                    return new String[]{"CodeableConcept", "Reference", "dateTime", "id"};
                }
                case -1285004149: {
                    return new String[]{"Quantity"};
                }
                case 108280125: {
                    return new String[]{"Range"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(EvidenceVariable.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type EvidenceVariable.characteristic.timeFromEvent.description");
            }
            if (name.equals("note")) {
                return this.addNote();
            }
            if (name.equals("eventCodeableConcept")) {
                this.event = new CodeableConcept();
                return this.event;
            }
            if (name.equals("eventReference")) {
                this.event = new Reference();
                return this.event;
            }
            if (name.equals("eventDateTime")) {
                this.event = new DateTimeType();
                return this.event;
            }
            if (name.equals("eventId")) {
                this.event = new IdType();
                return this.event;
            }
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            if (name.equals("range")) {
                this.range = new Range();
                return this.range;
            }
            return super.addChild(name);
        }

        @Override
        public EvidenceVariableCharacteristicTimeFromEventComponent copy() {
            EvidenceVariableCharacteristicTimeFromEventComponent dst = new EvidenceVariableCharacteristicTimeFromEventComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(EvidenceVariableCharacteristicTimeFromEventComponent dst) {
            super.copyValues(dst);
            StringType stringType = dst.description = this.description == null ? null : this.description.copy();
            if (this.note != null) {
                dst.note = new ArrayList<Annotation>();
                for (Annotation i : this.note) {
                    dst.note.add(i.copy());
                }
            }
            dst.event = this.event == null ? null : this.event.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.range = this.range == null ? null : this.range.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof EvidenceVariableCharacteristicTimeFromEventComponent)) {
                return false;
            }
            EvidenceVariableCharacteristicTimeFromEventComponent o = (EvidenceVariableCharacteristicTimeFromEventComponent)other_;
            return EvidenceVariableCharacteristicTimeFromEventComponent.compareDeep(this.description, o.description, true) && EvidenceVariableCharacteristicTimeFromEventComponent.compareDeep(this.note, o.note, true) && EvidenceVariableCharacteristicTimeFromEventComponent.compareDeep(this.event, o.event, true) && EvidenceVariableCharacteristicTimeFromEventComponent.compareDeep(this.quantity, o.quantity, true) && EvidenceVariableCharacteristicTimeFromEventComponent.compareDeep(this.range, o.range, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof EvidenceVariableCharacteristicTimeFromEventComponent)) {
                return false;
            }
            EvidenceVariableCharacteristicTimeFromEventComponent o = (EvidenceVariableCharacteristicTimeFromEventComponent)other_;
            return EvidenceVariableCharacteristicTimeFromEventComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.description, this.note, this.event, this.quantity, this.range});
        }

        @Override
        public String fhirType() {
            return "EvidenceVariable.characteristic.timeFromEvent";
        }
    }

    @Block
    public static class EvidenceVariableCharacteristicDefinitionByCombinationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="all-of | any-of | at-least | at-most | statistical | net-effect | dataset", formalDefinition="Used to specify if two or more characteristics are combined with OR or AND.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/characteristic-combination")
        protected Enumeration<CharacteristicCombination> code;
        @Child(name="threshold", type={PositiveIntType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Provides the value of \"n\" when \"at-least\" or \"at-most\" codes are used", formalDefinition="Provides the value of \"n\" when \"at-least\" or \"at-most\" codes are used.")
        protected PositiveIntType threshold;
        @Child(name="characteristic", type={EvidenceVariableCharacteristicComponent.class}, order=3, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="A defining factor of the characteristic", formalDefinition="A defining factor of the characteristic.")
        protected List<EvidenceVariableCharacteristicComponent> characteristic;
        private static final long serialVersionUID = -2053118515L;

        public EvidenceVariableCharacteristicDefinitionByCombinationComponent() {
        }

        public EvidenceVariableCharacteristicDefinitionByCombinationComponent(CharacteristicCombination code, EvidenceVariableCharacteristicComponent characteristic) {
            this.setCode(code);
            this.addCharacteristic(characteristic);
        }

        public Enumeration<CharacteristicCombination> getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceVariableCharacteristicDefinitionByCombinationComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new Enumeration<CharacteristicCombination>(new CharacteristicCombinationEnumFactory());
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public EvidenceVariableCharacteristicDefinitionByCombinationComponent setCodeElement(Enumeration<CharacteristicCombination> value) {
            this.code = value;
            return this;
        }

        public CharacteristicCombination getCode() {
            return this.code == null ? null : (CharacteristicCombination)((Object)this.code.getValue());
        }

        public EvidenceVariableCharacteristicDefinitionByCombinationComponent setCode(CharacteristicCombination value) {
            if (this.code == null) {
                this.code = new Enumeration<CharacteristicCombination>(new CharacteristicCombinationEnumFactory());
            }
            this.code.setValue((Object)value);
            return this;
        }

        public PositiveIntType getThresholdElement() {
            if (this.threshold == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceVariableCharacteristicDefinitionByCombinationComponent.threshold");
                }
                if (Configuration.doAutoCreate()) {
                    this.threshold = new PositiveIntType();
                }
            }
            return this.threshold;
        }

        public boolean hasThresholdElement() {
            return this.threshold != null && !this.threshold.isEmpty();
        }

        public boolean hasThreshold() {
            return this.threshold != null && !this.threshold.isEmpty();
        }

        public EvidenceVariableCharacteristicDefinitionByCombinationComponent setThresholdElement(PositiveIntType value) {
            this.threshold = value;
            return this;
        }

        public int getThreshold() {
            return this.threshold == null || this.threshold.isEmpty() ? 0 : (Integer)this.threshold.getValue();
        }

        public EvidenceVariableCharacteristicDefinitionByCombinationComponent setThreshold(int value) {
            if (this.threshold == null) {
                this.threshold = new PositiveIntType();
            }
            this.threshold.setValue((Object)value);
            return this;
        }

        public List<EvidenceVariableCharacteristicComponent> getCharacteristic() {
            if (this.characteristic == null) {
                this.characteristic = new ArrayList<EvidenceVariableCharacteristicComponent>();
            }
            return this.characteristic;
        }

        public EvidenceVariableCharacteristicDefinitionByCombinationComponent setCharacteristic(List<EvidenceVariableCharacteristicComponent> theCharacteristic) {
            this.characteristic = theCharacteristic;
            return this;
        }

        public boolean hasCharacteristic() {
            if (this.characteristic == null) {
                return false;
            }
            for (EvidenceVariableCharacteristicComponent item : this.characteristic) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public EvidenceVariableCharacteristicComponent addCharacteristic() {
            EvidenceVariableCharacteristicComponent t = new EvidenceVariableCharacteristicComponent();
            if (this.characteristic == null) {
                this.characteristic = new ArrayList<EvidenceVariableCharacteristicComponent>();
            }
            this.characteristic.add(t);
            return t;
        }

        public EvidenceVariableCharacteristicDefinitionByCombinationComponent addCharacteristic(EvidenceVariableCharacteristicComponent t) {
            if (t == null) {
                return this;
            }
            if (this.characteristic == null) {
                this.characteristic = new ArrayList<EvidenceVariableCharacteristicComponent>();
            }
            this.characteristic.add(t);
            return this;
        }

        public EvidenceVariableCharacteristicComponent getCharacteristicFirstRep() {
            if (this.getCharacteristic().isEmpty()) {
                this.addCharacteristic();
            }
            return this.getCharacteristic().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "code", "Used to specify if two or more characteristics are combined with OR or AND.", 0, 1, this.code));
            children.add(new Property("threshold", "positiveInt", "Provides the value of \"n\" when \"at-least\" or \"at-most\" codes are used.", 0, 1, this.threshold));
            children.add(new Property("characteristic", "@EvidenceVariable.characteristic", "A defining factor of the characteristic.", 0, Integer.MAX_VALUE, this.characteristic));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "code", "Used to specify if two or more characteristics are combined with OR or AND.", 0, 1, this.code);
                }
                case -1545477013: {
                    return new Property("threshold", "positiveInt", "Provides the value of \"n\" when \"at-least\" or \"at-most\" codes are used.", 0, 1, this.threshold);
                }
                case 366313883: {
                    return new Property("characteristic", "@EvidenceVariable.characteristic", "A defining factor of the characteristic.", 0, Integer.MAX_VALUE, this.characteristic);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case -1545477013: {
                    Base[] baseArray;
                    if (this.threshold == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.threshold;
                    }
                    return baseArray;
                }
                case 366313883: {
                    return this.characteristic == null ? new Base[]{} : this.characteristic.toArray(new Base[this.characteristic.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    value = new CharacteristicCombinationEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.code = value;
                    return value;
                }
                case -1545477013: {
                    this.threshold = TypeConvertor.castToPositiveInt(value);
                    return value;
                }
                case 366313883: {
                    this.getCharacteristic().add((EvidenceVariableCharacteristicComponent)((Object)value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                value = new CharacteristicCombinationEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.code = value;
            } else if (name.equals("threshold")) {
                this.threshold = TypeConvertor.castToPositiveInt(value);
            } else if (name.equals("characteristic")) {
                this.getCharacteristic().add((EvidenceVariableCharacteristicComponent)((Object)value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCodeElement();
                }
                case -1545477013: {
                    return this.getThresholdElement();
                }
                case 366313883: {
                    return this.addCharacteristic();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"code"};
                }
                case -1545477013: {
                    return new String[]{"positiveInt"};
                }
                case 366313883: {
                    return new String[]{"@EvidenceVariable.characteristic"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a primitive type EvidenceVariable.characteristic.definitionByCombination.code");
            }
            if (name.equals("threshold")) {
                throw new FHIRException("Cannot call addChild on a primitive type EvidenceVariable.characteristic.definitionByCombination.threshold");
            }
            if (name.equals("characteristic")) {
                return this.addCharacteristic();
            }
            return super.addChild(name);
        }

        @Override
        public EvidenceVariableCharacteristicDefinitionByCombinationComponent copy() {
            EvidenceVariableCharacteristicDefinitionByCombinationComponent dst = new EvidenceVariableCharacteristicDefinitionByCombinationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(EvidenceVariableCharacteristicDefinitionByCombinationComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            PositiveIntType positiveIntType = dst.threshold = this.threshold == null ? null : this.threshold.copy();
            if (this.characteristic != null) {
                dst.characteristic = new ArrayList<EvidenceVariableCharacteristicComponent>();
                for (EvidenceVariableCharacteristicComponent i : this.characteristic) {
                    dst.characteristic.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof EvidenceVariableCharacteristicDefinitionByCombinationComponent)) {
                return false;
            }
            EvidenceVariableCharacteristicDefinitionByCombinationComponent o = (EvidenceVariableCharacteristicDefinitionByCombinationComponent)other_;
            return EvidenceVariableCharacteristicDefinitionByCombinationComponent.compareDeep(this.code, o.code, true) && EvidenceVariableCharacteristicDefinitionByCombinationComponent.compareDeep(this.threshold, o.threshold, true) && EvidenceVariableCharacteristicDefinitionByCombinationComponent.compareDeep(this.characteristic, o.characteristic, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof EvidenceVariableCharacteristicDefinitionByCombinationComponent)) {
                return false;
            }
            EvidenceVariableCharacteristicDefinitionByCombinationComponent o = (EvidenceVariableCharacteristicDefinitionByCombinationComponent)other_;
            return EvidenceVariableCharacteristicDefinitionByCombinationComponent.compareValues(this.code, o.code, true) && EvidenceVariableCharacteristicDefinitionByCombinationComponent.compareValues(this.threshold, o.threshold, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.threshold, this.characteristic});
        }

        @Override
        public String fhirType() {
            return "EvidenceVariable.characteristic.definitionByCombination";
        }
    }

    @Block
    public static class EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Expresses the type of characteristic", formalDefinition="Used to express the type of characteristic.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/usage-context-type")
        protected CodeableConcept type;
        @Child(name="method", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Method for how the characteristic value was determined", formalDefinition="Method for how the characteristic value was determined.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/definition-method")
        protected List<CodeableConcept> method;
        @Child(name="device", type={Device.class, DeviceMetric.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Device used for determining characteristic", formalDefinition="Device used for determining characteristic.")
        protected Reference device;
        @Child(name="value", type={CodeableConcept.class, BooleanType.class, Quantity.class, Range.class, Reference.class, IdType.class}, order=4, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Defines the characteristic when coupled with characteristic.type", formalDefinition="Defines the characteristic when paired with characteristic.type.")
        protected DataType value;
        @Child(name="offset", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reference point for valueQuantity", formalDefinition="Defines the reference point for comparison when valueQuantity is not compared to zero.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/characteristic-offset")
        protected CodeableConcept offset;
        private static final long serialVersionUID = -498341653L;

        public EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent() {
        }

        public EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent(CodeableConcept type, DataType value) {
            this.setType(type);
            this.setValue(value);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public List<CodeableConcept> getMethod() {
            if (this.method == null) {
                this.method = new ArrayList<CodeableConcept>();
            }
            return this.method;
        }

        public EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent setMethod(List<CodeableConcept> theMethod) {
            this.method = theMethod;
            return this;
        }

        public boolean hasMethod() {
            if (this.method == null) {
                return false;
            }
            for (CodeableConcept item : this.method) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addMethod() {
            CodeableConcept t = new CodeableConcept();
            if (this.method == null) {
                this.method = new ArrayList<CodeableConcept>();
            }
            this.method.add(t);
            return t;
        }

        public EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent addMethod(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.method == null) {
                this.method = new ArrayList<CodeableConcept>();
            }
            this.method.add(t);
            return this;
        }

        public CodeableConcept getMethodFirstRep() {
            if (this.getMethod().isEmpty()) {
                this.addMethod();
            }
            return this.getMethod().get(0);
        }

        public Reference getDevice() {
            if (this.device == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent.device");
                }
                if (Configuration.doAutoCreate()) {
                    this.device = new Reference();
                }
            }
            return this.device;
        }

        public boolean hasDevice() {
            return this.device != null && !this.device.isEmpty();
        }

        public EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent setDevice(Reference value) {
            this.device = value;
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public CodeableConcept getValueCodeableConcept() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeableConcept();
            }
            if (!(this.value instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.value;
        }

        public boolean hasValueCodeableConcept() {
            return this != null && this.value instanceof CodeableConcept;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (this.value == null) {
                this.value = new BooleanType();
            }
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this != null && this.value instanceof BooleanType;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                this.value = new Quantity();
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this != null && this.value instanceof Quantity;
        }

        public Range getValueRange() throws FHIRException {
            if (this.value == null) {
                this.value = new Range();
            }
            if (!(this.value instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Range)this.value;
        }

        public boolean hasValueRange() {
            return this != null && this.value instanceof Range;
        }

        public Reference getValueReference() throws FHIRException {
            if (this.value == null) {
                this.value = new Reference();
            }
            if (!(this.value instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Reference)this.value;
        }

        public boolean hasValueReference() {
            return this != null && this.value instanceof Reference;
        }

        public IdType getValueIdType() throws FHIRException {
            if (this.value == null) {
                this.value = new IdType();
            }
            if (!(this.value instanceof IdType)) {
                throw new FHIRException("Type mismatch: the type IdType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (IdType)this.value;
        }

        public boolean hasValueIdType() {
            return this != null && this.value instanceof IdType;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent setValue(DataType value) {
            if (!(value == null || value instanceof CodeableConcept || value instanceof BooleanType || value instanceof Quantity || value instanceof Range || value instanceof Reference || value instanceof IdType)) {
                throw new Error("Not the right type for EvidenceVariable.characteristic.definitionByTypeAndValue.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        public CodeableConcept getOffset() {
            if (this.offset == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent.offset");
                }
                if (Configuration.doAutoCreate()) {
                    this.offset = new CodeableConcept();
                }
            }
            return this.offset;
        }

        public boolean hasOffset() {
            return this.offset != null && !this.offset.isEmpty();
        }

        public EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent setOffset(CodeableConcept value) {
            this.offset = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Used to express the type of characteristic.", 0, 1, this.type));
            children.add(new Property("method", "CodeableConcept", "Method for how the characteristic value was determined.", 0, Integer.MAX_VALUE, this.method));
            children.add(new Property("device", "Reference(Device|DeviceMetric)", "Device used for determining characteristic.", 0, 1, this.device));
            children.add(new Property("value[x]", "CodeableConcept|boolean|Quantity|Range|Reference|id", "Defines the characteristic when paired with characteristic.type.", 0, 1, this.value));
            children.add(new Property("offset", "CodeableConcept", "Defines the reference point for comparison when valueQuantity is not compared to zero.", 0, 1, this.offset));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Used to express the type of characteristic.", 0, 1, this.type);
                }
                case -1077554975: {
                    return new Property("method", "CodeableConcept", "Method for how the characteristic value was determined.", 0, Integer.MAX_VALUE, this.method);
                }
                case -1335157162: {
                    return new Property("device", "Reference(Device|DeviceMetric)", "Device used for determining characteristic.", 0, 1, this.device);
                }
                case -1410166417: {
                    return new Property("value[x]", "CodeableConcept|boolean|Quantity|Range|Reference|id", "Defines the characteristic when paired with characteristic.type.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "CodeableConcept|boolean|Quantity|Range|Reference|id", "Defines the characteristic when paired with characteristic.type.", 0, 1, this.value);
                }
                case 924902896: {
                    return new Property("value[x]", "CodeableConcept", "Defines the characteristic when paired with characteristic.type.", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "boolean", "Defines the characteristic when paired with characteristic.type.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "Quantity", "Defines the characteristic when paired with characteristic.type.", 0, 1, this.value);
                }
                case 2030761548: {
                    return new Property("value[x]", "Range", "Defines the characteristic when paired with characteristic.type.", 0, 1, this.value);
                }
                case 1755241690: {
                    return new Property("value[x]", "Reference", "Defines the characteristic when paired with characteristic.type.", 0, 1, this.value);
                }
                case 231604844: {
                    return new Property("value[x]", "id", "Defines the characteristic when paired with characteristic.type.", 0, 1, this.value);
                }
                case -1019779949: {
                    return new Property("offset", "CodeableConcept", "Defines the reference point for comparison when valueQuantity is not compared to zero.", 0, 1, this.offset);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -1077554975: {
                    return this.method == null ? new Base[]{} : this.method.toArray(new Base[this.method.size()]);
                }
                case -1335157162: {
                    Base[] baseArray;
                    if (this.device == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.device;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.value;
                    }
                    return baseArray;
                }
                case -1019779949: {
                    Base[] baseArray;
                    if (this.offset == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.offset;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1077554975: {
                    this.getMethod().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -1335157162: {
                    this.device = TypeConvertor.castToReference(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
                case -1019779949: {
                    this.offset = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("method")) {
                this.getMethod().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("device")) {
                this.device = TypeConvertor.castToReference(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else if (name.equals("offset")) {
                this.offset = TypeConvertor.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1077554975: {
                    return this.addMethod();
                }
                case -1335157162: {
                    return this.getDevice();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
                case -1019779949: {
                    return this.getOffset();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1077554975: {
                    return new String[]{"CodeableConcept"};
                }
                case -1335157162: {
                    return new String[]{"Reference"};
                }
                case 111972721: {
                    return new String[]{"CodeableConcept", "boolean", "Quantity", "Range", "Reference", "id"};
                }
                case -1019779949: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("method")) {
                return this.addMethod();
            }
            if (name.equals("device")) {
                this.device = new Reference();
                return this.device;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueRange")) {
                this.value = new Range();
                return this.value;
            }
            if (name.equals("valueReference")) {
                this.value = new Reference();
                return this.value;
            }
            if (name.equals("valueId")) {
                this.value = new IdType();
                return this.value;
            }
            if (name.equals("offset")) {
                this.offset = new CodeableConcept();
                return this.offset;
            }
            return super.addChild(name);
        }

        @Override
        public EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent copy() {
            EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent dst = new EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
            if (this.method != null) {
                dst.method = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.method) {
                    dst.method.add(i.copy());
                }
            }
            dst.device = this.device == null ? null : this.device.copy();
            dst.value = this.value == null ? null : this.value.copy();
            dst.offset = this.offset == null ? null : this.offset.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent)) {
                return false;
            }
            EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent o = (EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent)other_;
            return EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent.compareDeep(this.type, o.type, true) && EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent.compareDeep(this.method, o.method, true) && EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent.compareDeep(this.device, o.device, true) && EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent.compareDeep(this.value, o.value, true) && EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent.compareDeep(this.offset, o.offset, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent)) {
                return false;
            }
            EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent o = (EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.method, this.device, this.value, this.offset});
        }

        @Override
        public String fhirType() {
            return "EvidenceVariable.characteristic.definitionByTypeAndValue";
        }
    }

    @Block
    public static class EvidenceVariableCharacteristicComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="linkId", type={IdType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Label for internal linking", formalDefinition="Label used for when a characteristic refers to another characteristic.")
        protected IdType linkId;
        @Child(name="description", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Natural language description of the characteristic", formalDefinition="A short, natural language description of the characteristic that could be used to communicate the criteria to an end-user.")
        protected StringType description;
        @Child(name="note", type={Annotation.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Used for footnotes or explanatory notes", formalDefinition="A human-readable string to clarify or explain concepts about the characteristic.")
        protected List<Annotation> note;
        @Child(name="exclude", type={BooleanType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Whether the characteristic is an inclusion criterion or exclusion criterion", formalDefinition="When true, this characteristic is an exclusion criterion. In other words, not matching this characteristic definition is equivalent to meeting this criterion.")
        protected BooleanType exclude;
        @Child(name="definitionReference", type={EvidenceVariable.class, Group.class, Evidence.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Defines the characteristic (without using type and value) by a Reference", formalDefinition="Defines the characteristic using a Reference.")
        protected Reference definitionReference;
        @Child(name="definitionCanonical", type={CanonicalType.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Defines the characteristic (without using type and value) by a Canonical", formalDefinition="Defines the characteristic using Canonical.")
        protected CanonicalType definitionCanonical;
        @Child(name="definitionCodeableConcept", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Defines the characteristic (without using type and value) by a CodeableConcept", formalDefinition="Defines the characteristic using CodeableConcept.")
        protected CodeableConcept definitionCodeableConcept;
        @Child(name="definitionExpression", type={Expression.class}, order=8, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Defines the characteristic (without using type and value) by a Expression", formalDefinition="Defines the characteristic using Expression.")
        protected Expression definitionExpression;
        @Child(name="definitionId", type={IdType.class}, order=9, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Defines the characteristic (without using type and value) by a id", formalDefinition="Defines the characteristic using id.")
        protected IdType definitionId;
        @Child(name="definitionByTypeAndValue", type={}, order=10, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Defines the characteristic using type and value", formalDefinition="Defines the characteristic using both a type and value[x] elements.")
        protected EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent definitionByTypeAndValue;
        @Child(name="definitionByCombination", type={}, order=11, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Used to specify how two or more characteristics are combined", formalDefinition="Defines the characteristic as a combination of two or more characteristics.")
        protected EvidenceVariableCharacteristicDefinitionByCombinationComponent definitionByCombination;
        @Child(name="timeFromEvent", type={}, order=12, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Observation time from study specified event", formalDefinition="Observation time from study specified event.")
        protected List<EvidenceVariableCharacteristicTimeFromEventComponent> timeFromEvent;
        private static final long serialVersionUID = -172205544L;

        public IdType getLinkIdElement() {
            if (this.linkId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceVariableCharacteristicComponent.linkId");
                }
                if (Configuration.doAutoCreate()) {
                    this.linkId = new IdType();
                }
            }
            return this.linkId;
        }

        public boolean hasLinkIdElement() {
            return this.linkId != null && !this.linkId.isEmpty();
        }

        public boolean hasLinkId() {
            return this.linkId != null && !this.linkId.isEmpty();
        }

        public EvidenceVariableCharacteristicComponent setLinkIdElement(IdType value) {
            this.linkId = value;
            return this;
        }

        public String getLinkId() {
            return this.linkId == null ? null : this.linkId.getValue();
        }

        public EvidenceVariableCharacteristicComponent setLinkId(String value) {
            if (Utilities.noString((String)value)) {
                this.linkId = null;
            } else {
                if (this.linkId == null) {
                    this.linkId = new IdType();
                }
                this.linkId.setValue(value);
            }
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceVariableCharacteristicComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public EvidenceVariableCharacteristicComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public EvidenceVariableCharacteristicComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public List<Annotation> getNote() {
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            return this.note;
        }

        public EvidenceVariableCharacteristicComponent setNote(List<Annotation> theNote) {
            this.note = theNote;
            return this;
        }

        public boolean hasNote() {
            if (this.note == null) {
                return false;
            }
            for (Annotation item : this.note) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Annotation addNote() {
            Annotation t = new Annotation();
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return t;
        }

        public EvidenceVariableCharacteristicComponent addNote(Annotation t) {
            if (t == null) {
                return this;
            }
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return this;
        }

        public Annotation getNoteFirstRep() {
            if (this.getNote().isEmpty()) {
                this.addNote();
            }
            return this.getNote().get(0);
        }

        public BooleanType getExcludeElement() {
            if (this.exclude == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceVariableCharacteristicComponent.exclude");
                }
                if (Configuration.doAutoCreate()) {
                    this.exclude = new BooleanType();
                }
            }
            return this.exclude;
        }

        public boolean hasExcludeElement() {
            return this.exclude != null && !this.exclude.isEmpty();
        }

        public boolean hasExclude() {
            return this.exclude != null && !this.exclude.isEmpty();
        }

        public EvidenceVariableCharacteristicComponent setExcludeElement(BooleanType value) {
            this.exclude = value;
            return this;
        }

        public boolean getExclude() {
            return this.exclude == null || this.exclude.isEmpty() ? false : (Boolean)this.exclude.getValue();
        }

        public EvidenceVariableCharacteristicComponent setExclude(boolean value) {
            if (this.exclude == null) {
                this.exclude = new BooleanType();
            }
            this.exclude.setValue((Object)value);
            return this;
        }

        public Reference getDefinitionReference() {
            if (this.definitionReference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceVariableCharacteristicComponent.definitionReference");
                }
                if (Configuration.doAutoCreate()) {
                    this.definitionReference = new Reference();
                }
            }
            return this.definitionReference;
        }

        public boolean hasDefinitionReference() {
            return this.definitionReference != null && !this.definitionReference.isEmpty();
        }

        public EvidenceVariableCharacteristicComponent setDefinitionReference(Reference value) {
            this.definitionReference = value;
            return this;
        }

        public CanonicalType getDefinitionCanonicalElement() {
            if (this.definitionCanonical == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceVariableCharacteristicComponent.definitionCanonical");
                }
                if (Configuration.doAutoCreate()) {
                    this.definitionCanonical = new CanonicalType();
                }
            }
            return this.definitionCanonical;
        }

        public boolean hasDefinitionCanonicalElement() {
            return this.definitionCanonical != null && !this.definitionCanonical.isEmpty();
        }

        public boolean hasDefinitionCanonical() {
            return this.definitionCanonical != null && !this.definitionCanonical.isEmpty();
        }

        public EvidenceVariableCharacteristicComponent setDefinitionCanonicalElement(CanonicalType value) {
            this.definitionCanonical = value;
            return this;
        }

        public String getDefinitionCanonical() {
            return this.definitionCanonical == null ? null : (String)this.definitionCanonical.getValue();
        }

        public EvidenceVariableCharacteristicComponent setDefinitionCanonical(String value) {
            if (Utilities.noString((String)value)) {
                this.definitionCanonical = null;
            } else {
                if (this.definitionCanonical == null) {
                    this.definitionCanonical = new CanonicalType();
                }
                this.definitionCanonical.setValue(value);
            }
            return this;
        }

        public CodeableConcept getDefinitionCodeableConcept() {
            if (this.definitionCodeableConcept == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceVariableCharacteristicComponent.definitionCodeableConcept");
                }
                if (Configuration.doAutoCreate()) {
                    this.definitionCodeableConcept = new CodeableConcept();
                }
            }
            return this.definitionCodeableConcept;
        }

        public boolean hasDefinitionCodeableConcept() {
            return this.definitionCodeableConcept != null && !this.definitionCodeableConcept.isEmpty();
        }

        public EvidenceVariableCharacteristicComponent setDefinitionCodeableConcept(CodeableConcept value) {
            this.definitionCodeableConcept = value;
            return this;
        }

        public Expression getDefinitionExpression() {
            if (this.definitionExpression == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceVariableCharacteristicComponent.definitionExpression");
                }
                if (Configuration.doAutoCreate()) {
                    this.definitionExpression = new Expression();
                }
            }
            return this.definitionExpression;
        }

        public boolean hasDefinitionExpression() {
            return this.definitionExpression != null && !this.definitionExpression.isEmpty();
        }

        public EvidenceVariableCharacteristicComponent setDefinitionExpression(Expression value) {
            this.definitionExpression = value;
            return this;
        }

        public IdType getDefinitionIdElement() {
            if (this.definitionId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceVariableCharacteristicComponent.definitionId");
                }
                if (Configuration.doAutoCreate()) {
                    this.definitionId = new IdType();
                }
            }
            return this.definitionId;
        }

        public boolean hasDefinitionIdElement() {
            return this.definitionId != null && !this.definitionId.isEmpty();
        }

        public boolean hasDefinitionId() {
            return this.definitionId != null && !this.definitionId.isEmpty();
        }

        public EvidenceVariableCharacteristicComponent setDefinitionIdElement(IdType value) {
            this.definitionId = value;
            return this;
        }

        public String getDefinitionId() {
            return this.definitionId == null ? null : this.definitionId.getValue();
        }

        public EvidenceVariableCharacteristicComponent setDefinitionId(String value) {
            if (Utilities.noString((String)value)) {
                this.definitionId = null;
            } else {
                if (this.definitionId == null) {
                    this.definitionId = new IdType();
                }
                this.definitionId.setValue(value);
            }
            return this;
        }

        public EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent getDefinitionByTypeAndValue() {
            if (this.definitionByTypeAndValue == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceVariableCharacteristicComponent.definitionByTypeAndValue");
                }
                if (Configuration.doAutoCreate()) {
                    this.definitionByTypeAndValue = new EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent();
                }
            }
            return this.definitionByTypeAndValue;
        }

        public boolean hasDefinitionByTypeAndValue() {
            return this.definitionByTypeAndValue != null && !this.definitionByTypeAndValue.isEmpty();
        }

        public EvidenceVariableCharacteristicComponent setDefinitionByTypeAndValue(EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent value) {
            this.definitionByTypeAndValue = value;
            return this;
        }

        public EvidenceVariableCharacteristicDefinitionByCombinationComponent getDefinitionByCombination() {
            if (this.definitionByCombination == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EvidenceVariableCharacteristicComponent.definitionByCombination");
                }
                if (Configuration.doAutoCreate()) {
                    this.definitionByCombination = new EvidenceVariableCharacteristicDefinitionByCombinationComponent();
                }
            }
            return this.definitionByCombination;
        }

        public boolean hasDefinitionByCombination() {
            return this.definitionByCombination != null && !this.definitionByCombination.isEmpty();
        }

        public EvidenceVariableCharacteristicComponent setDefinitionByCombination(EvidenceVariableCharacteristicDefinitionByCombinationComponent value) {
            this.definitionByCombination = value;
            return this;
        }

        public List<EvidenceVariableCharacteristicTimeFromEventComponent> getTimeFromEvent() {
            if (this.timeFromEvent == null) {
                this.timeFromEvent = new ArrayList<EvidenceVariableCharacteristicTimeFromEventComponent>();
            }
            return this.timeFromEvent;
        }

        public EvidenceVariableCharacteristicComponent setTimeFromEvent(List<EvidenceVariableCharacteristicTimeFromEventComponent> theTimeFromEvent) {
            this.timeFromEvent = theTimeFromEvent;
            return this;
        }

        public boolean hasTimeFromEvent() {
            if (this.timeFromEvent == null) {
                return false;
            }
            for (EvidenceVariableCharacteristicTimeFromEventComponent item : this.timeFromEvent) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public EvidenceVariableCharacteristicTimeFromEventComponent addTimeFromEvent() {
            EvidenceVariableCharacteristicTimeFromEventComponent t = new EvidenceVariableCharacteristicTimeFromEventComponent();
            if (this.timeFromEvent == null) {
                this.timeFromEvent = new ArrayList<EvidenceVariableCharacteristicTimeFromEventComponent>();
            }
            this.timeFromEvent.add(t);
            return t;
        }

        public EvidenceVariableCharacteristicComponent addTimeFromEvent(EvidenceVariableCharacteristicTimeFromEventComponent t) {
            if (t == null) {
                return this;
            }
            if (this.timeFromEvent == null) {
                this.timeFromEvent = new ArrayList<EvidenceVariableCharacteristicTimeFromEventComponent>();
            }
            this.timeFromEvent.add(t);
            return this;
        }

        public EvidenceVariableCharacteristicTimeFromEventComponent getTimeFromEventFirstRep() {
            if (this.getTimeFromEvent().isEmpty()) {
                this.addTimeFromEvent();
            }
            return this.getTimeFromEvent().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("linkId", "id", "Label used for when a characteristic refers to another characteristic.", 0, 1, this.linkId));
            children.add(new Property(EvidenceVariable.SP_DESCRIPTION, "string", "A short, natural language description of the characteristic that could be used to communicate the criteria to an end-user.", 0, 1, this.description));
            children.add(new Property("note", "Annotation", "A human-readable string to clarify or explain concepts about the characteristic.", 0, Integer.MAX_VALUE, this.note));
            children.add(new Property("exclude", "boolean", "When true, this characteristic is an exclusion criterion. In other words, not matching this characteristic definition is equivalent to meeting this criterion.", 0, 1, this.exclude));
            children.add(new Property("definitionReference", "Reference(EvidenceVariable|Group|Evidence)", "Defines the characteristic using a Reference.", 0, 1, this.definitionReference));
            children.add(new Property("definitionCanonical", "canonical(EvidenceVariable|Evidence)", "Defines the characteristic using Canonical.", 0, 1, this.definitionCanonical));
            children.add(new Property("definitionCodeableConcept", "CodeableConcept", "Defines the characteristic using CodeableConcept.", 0, 1, this.definitionCodeableConcept));
            children.add(new Property("definitionExpression", "Expression", "Defines the characteristic using Expression.", 0, 1, this.definitionExpression));
            children.add(new Property("definitionId", "id", "Defines the characteristic using id.", 0, 1, this.definitionId));
            children.add(new Property("definitionByTypeAndValue", "", "Defines the characteristic using both a type and value[x] elements.", 0, 1, this.definitionByTypeAndValue));
            children.add(new Property("definitionByCombination", "", "Defines the characteristic as a combination of two or more characteristics.", 0, 1, this.definitionByCombination));
            children.add(new Property("timeFromEvent", "", "Observation time from study specified event.", 0, Integer.MAX_VALUE, this.timeFromEvent));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1102667083: {
                    return new Property("linkId", "id", "Label used for when a characteristic refers to another characteristic.", 0, 1, this.linkId);
                }
                case -1724546052: {
                    return new Property(EvidenceVariable.SP_DESCRIPTION, "string", "A short, natural language description of the characteristic that could be used to communicate the criteria to an end-user.", 0, 1, this.description);
                }
                case 3387378: {
                    return new Property("note", "Annotation", "A human-readable string to clarify or explain concepts about the characteristic.", 0, Integer.MAX_VALUE, this.note);
                }
                case -1321148966: {
                    return new Property("exclude", "boolean", "When true, this characteristic is an exclusion criterion. In other words, not matching this characteristic definition is equivalent to meeting this criterion.", 0, 1, this.exclude);
                }
                case -820021448: {
                    return new Property("definitionReference", "Reference(EvidenceVariable|Group|Evidence)", "Defines the characteristic using a Reference.", 0, 1, this.definitionReference);
                }
                case 933485793: {
                    return new Property("definitionCanonical", "canonical(EvidenceVariable|Evidence)", "Defines the characteristic using Canonical.", 0, 1, this.definitionCanonical);
                }
                case -1446002226: {
                    return new Property("definitionCodeableConcept", "CodeableConcept", "Defines the characteristic using CodeableConcept.", 0, 1, this.definitionCodeableConcept);
                }
                case 1463703627: {
                    return new Property("definitionExpression", "Expression", "Defines the characteristic using Expression.", 0, 1, this.definitionExpression);
                }
                case 101791182: {
                    return new Property("definitionId", "id", "Defines the characteristic using id.", 0, 1, this.definitionId);
                }
                case -164357794: {
                    return new Property("definitionByTypeAndValue", "", "Defines the characteristic using both a type and value[x] elements.", 0, 1, this.definitionByTypeAndValue);
                }
                case -2043280539: {
                    return new Property("definitionByCombination", "", "Defines the characteristic as a combination of two or more characteristics.", 0, 1, this.definitionByCombination);
                }
                case 2087274691: {
                    return new Property("timeFromEvent", "", "Observation time from study specified event.", 0, Integer.MAX_VALUE, this.timeFromEvent);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1102667083: {
                    Base[] baseArray;
                    if (this.linkId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.linkId;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
                case 3387378: {
                    return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
                }
                case -1321148966: {
                    Base[] baseArray;
                    if (this.exclude == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.exclude;
                    }
                    return baseArray;
                }
                case -820021448: {
                    Base[] baseArray;
                    if (this.definitionReference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.definitionReference;
                    }
                    return baseArray;
                }
                case 933485793: {
                    Base[] baseArray;
                    if (this.definitionCanonical == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.definitionCanonical;
                    }
                    return baseArray;
                }
                case -1446002226: {
                    Base[] baseArray;
                    if (this.definitionCodeableConcept == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.definitionCodeableConcept;
                    }
                    return baseArray;
                }
                case 1463703627: {
                    Base[] baseArray;
                    if (this.definitionExpression == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.definitionExpression;
                    }
                    return baseArray;
                }
                case 101791182: {
                    Base[] baseArray;
                    if (this.definitionId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.definitionId;
                    }
                    return baseArray;
                }
                case -164357794: {
                    Base[] baseArray;
                    if (this.definitionByTypeAndValue == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.definitionByTypeAndValue;
                    }
                    return baseArray;
                }
                case -2043280539: {
                    Base[] baseArray;
                    if (this.definitionByCombination == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray11 = new Base[1];
                        baseArray = baseArray11;
                        baseArray11[0] = this.definitionByCombination;
                    }
                    return baseArray;
                }
                case 2087274691: {
                    return this.timeFromEvent == null ? new Base[]{} : this.timeFromEvent.toArray(new Base[this.timeFromEvent.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1102667083: {
                    this.linkId = TypeConvertor.castToId(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case 3387378: {
                    this.getNote().add(TypeConvertor.castToAnnotation(value));
                    return value;
                }
                case -1321148966: {
                    this.exclude = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -820021448: {
                    this.definitionReference = TypeConvertor.castToReference(value);
                    return value;
                }
                case 933485793: {
                    this.definitionCanonical = TypeConvertor.castToCanonical(value);
                    return value;
                }
                case -1446002226: {
                    this.definitionCodeableConcept = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 1463703627: {
                    this.definitionExpression = TypeConvertor.castToExpression(value);
                    return value;
                }
                case 101791182: {
                    this.definitionId = TypeConvertor.castToId(value);
                    return value;
                }
                case -164357794: {
                    this.definitionByTypeAndValue = (EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent)value;
                    return value;
                }
                case -2043280539: {
                    this.definitionByCombination = (EvidenceVariableCharacteristicDefinitionByCombinationComponent)value;
                    return value;
                }
                case 2087274691: {
                    this.getTimeFromEvent().add((EvidenceVariableCharacteristicTimeFromEventComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("linkId")) {
                this.linkId = TypeConvertor.castToId(value);
            } else if (name.equals(EvidenceVariable.SP_DESCRIPTION)) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals("note")) {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
            } else if (name.equals("exclude")) {
                this.exclude = TypeConvertor.castToBoolean(value);
            } else if (name.equals("definitionReference")) {
                this.definitionReference = TypeConvertor.castToReference(value);
            } else if (name.equals("definitionCanonical")) {
                this.definitionCanonical = TypeConvertor.castToCanonical(value);
            } else if (name.equals("definitionCodeableConcept")) {
                this.definitionCodeableConcept = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("definitionExpression")) {
                this.definitionExpression = TypeConvertor.castToExpression(value);
            } else if (name.equals("definitionId")) {
                this.definitionId = TypeConvertor.castToId(value);
            } else if (name.equals("definitionByTypeAndValue")) {
                this.definitionByTypeAndValue = (EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent)value;
            } else if (name.equals("definitionByCombination")) {
                this.definitionByCombination = (EvidenceVariableCharacteristicDefinitionByCombinationComponent)value;
            } else if (name.equals("timeFromEvent")) {
                this.getTimeFromEvent().add((EvidenceVariableCharacteristicTimeFromEventComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1102667083: {
                    return this.getLinkIdElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 3387378: {
                    return this.addNote();
                }
                case -1321148966: {
                    return this.getExcludeElement();
                }
                case -820021448: {
                    return this.getDefinitionReference();
                }
                case 933485793: {
                    return this.getDefinitionCanonicalElement();
                }
                case -1446002226: {
                    return this.getDefinitionCodeableConcept();
                }
                case 1463703627: {
                    return this.getDefinitionExpression();
                }
                case 101791182: {
                    return this.getDefinitionIdElement();
                }
                case -164357794: {
                    return this.getDefinitionByTypeAndValue();
                }
                case -2043280539: {
                    return this.getDefinitionByCombination();
                }
                case 2087274691: {
                    return this.addTimeFromEvent();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1102667083: {
                    return new String[]{"id"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case 3387378: {
                    return new String[]{"Annotation"};
                }
                case -1321148966: {
                    return new String[]{"boolean"};
                }
                case -820021448: {
                    return new String[]{"Reference"};
                }
                case 933485793: {
                    return new String[]{"canonical"};
                }
                case -1446002226: {
                    return new String[]{"CodeableConcept"};
                }
                case 1463703627: {
                    return new String[]{"Expression"};
                }
                case 101791182: {
                    return new String[]{"id"};
                }
                case -164357794: {
                    return new String[0];
                }
                case -2043280539: {
                    return new String[0];
                }
                case 2087274691: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("linkId")) {
                throw new FHIRException("Cannot call addChild on a primitive type EvidenceVariable.characteristic.linkId");
            }
            if (name.equals(EvidenceVariable.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type EvidenceVariable.characteristic.description");
            }
            if (name.equals("note")) {
                return this.addNote();
            }
            if (name.equals("exclude")) {
                throw new FHIRException("Cannot call addChild on a primitive type EvidenceVariable.characteristic.exclude");
            }
            if (name.equals("definitionReference")) {
                this.definitionReference = new Reference();
                return this.definitionReference;
            }
            if (name.equals("definitionCanonical")) {
                throw new FHIRException("Cannot call addChild on a primitive type EvidenceVariable.characteristic.definitionCanonical");
            }
            if (name.equals("definitionCodeableConcept")) {
                this.definitionCodeableConcept = new CodeableConcept();
                return this.definitionCodeableConcept;
            }
            if (name.equals("definitionExpression")) {
                this.definitionExpression = new Expression();
                return this.definitionExpression;
            }
            if (name.equals("definitionId")) {
                throw new FHIRException("Cannot call addChild on a primitive type EvidenceVariable.characteristic.definitionId");
            }
            if (name.equals("definitionByTypeAndValue")) {
                this.definitionByTypeAndValue = new EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent();
                return this.definitionByTypeAndValue;
            }
            if (name.equals("definitionByCombination")) {
                this.definitionByCombination = new EvidenceVariableCharacteristicDefinitionByCombinationComponent();
                return this.definitionByCombination;
            }
            if (name.equals("timeFromEvent")) {
                return this.addTimeFromEvent();
            }
            return super.addChild(name);
        }

        @Override
        public EvidenceVariableCharacteristicComponent copy() {
            EvidenceVariableCharacteristicComponent dst = new EvidenceVariableCharacteristicComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(EvidenceVariableCharacteristicComponent dst) {
            super.copyValues(dst);
            dst.linkId = this.linkId == null ? null : this.linkId.copy();
            StringType stringType = dst.description = this.description == null ? null : this.description.copy();
            if (this.note != null) {
                dst.note = new ArrayList<Annotation>();
                for (Annotation annotation : this.note) {
                    dst.note.add(annotation.copy());
                }
            }
            dst.exclude = this.exclude == null ? null : this.exclude.copy();
            dst.definitionReference = this.definitionReference == null ? null : this.definitionReference.copy();
            dst.definitionCanonical = this.definitionCanonical == null ? null : this.definitionCanonical.copy();
            dst.definitionCodeableConcept = this.definitionCodeableConcept == null ? null : this.definitionCodeableConcept.copy();
            dst.definitionExpression = this.definitionExpression == null ? null : this.definitionExpression.copy();
            dst.definitionId = this.definitionId == null ? null : this.definitionId.copy();
            dst.definitionByTypeAndValue = this.definitionByTypeAndValue == null ? null : this.definitionByTypeAndValue.copy();
            EvidenceVariableCharacteristicDefinitionByCombinationComponent evidenceVariableCharacteristicDefinitionByCombinationComponent = dst.definitionByCombination = this.definitionByCombination == null ? null : this.definitionByCombination.copy();
            if (this.timeFromEvent != null) {
                dst.timeFromEvent = new ArrayList<EvidenceVariableCharacteristicTimeFromEventComponent>();
                for (EvidenceVariableCharacteristicTimeFromEventComponent evidenceVariableCharacteristicTimeFromEventComponent : this.timeFromEvent) {
                    dst.timeFromEvent.add(evidenceVariableCharacteristicTimeFromEventComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof EvidenceVariableCharacteristicComponent)) {
                return false;
            }
            EvidenceVariableCharacteristicComponent o = (EvidenceVariableCharacteristicComponent)other_;
            return EvidenceVariableCharacteristicComponent.compareDeep(this.linkId, o.linkId, true) && EvidenceVariableCharacteristicComponent.compareDeep(this.description, o.description, true) && EvidenceVariableCharacteristicComponent.compareDeep(this.note, o.note, true) && EvidenceVariableCharacteristicComponent.compareDeep(this.exclude, o.exclude, true) && EvidenceVariableCharacteristicComponent.compareDeep(this.definitionReference, o.definitionReference, true) && EvidenceVariableCharacteristicComponent.compareDeep(this.definitionCanonical, o.definitionCanonical, true) && EvidenceVariableCharacteristicComponent.compareDeep(this.definitionCodeableConcept, o.definitionCodeableConcept, true) && EvidenceVariableCharacteristicComponent.compareDeep(this.definitionExpression, o.definitionExpression, true) && EvidenceVariableCharacteristicComponent.compareDeep(this.definitionId, o.definitionId, true) && EvidenceVariableCharacteristicComponent.compareDeep(this.definitionByTypeAndValue, o.definitionByTypeAndValue, true) && EvidenceVariableCharacteristicComponent.compareDeep(this.definitionByCombination, o.definitionByCombination, true) && EvidenceVariableCharacteristicComponent.compareDeep(this.timeFromEvent, o.timeFromEvent, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof EvidenceVariableCharacteristicComponent)) {
                return false;
            }
            EvidenceVariableCharacteristicComponent o = (EvidenceVariableCharacteristicComponent)other_;
            return EvidenceVariableCharacteristicComponent.compareValues(this.linkId, o.linkId, true) && EvidenceVariableCharacteristicComponent.compareValues(this.description, o.description, true) && EvidenceVariableCharacteristicComponent.compareValues(this.exclude, o.exclude, true) && EvidenceVariableCharacteristicComponent.compareValues(this.definitionCanonical, o.definitionCanonical, true) && EvidenceVariableCharacteristicComponent.compareValues(this.definitionId, o.definitionId, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.linkId, this.description, this.note, this.exclude, this.definitionReference, this.definitionCanonical, this.definitionCodeableConcept, this.definitionExpression, this.definitionId, this.definitionByTypeAndValue, this.definitionByCombination, this.timeFromEvent});
        }

        @Override
        public String fhirType() {
            return "EvidenceVariable.characteristic";
        }
    }

    public static class CharacteristicCombinationEnumFactory
    implements EnumFactory<CharacteristicCombination> {
        @Override
        public CharacteristicCombination fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("all-of".equals(codeString)) {
                return CharacteristicCombination.ALLOF;
            }
            if ("any-of".equals(codeString)) {
                return CharacteristicCombination.ANYOF;
            }
            if ("at-least".equals(codeString)) {
                return CharacteristicCombination.ATLEAST;
            }
            if ("at-most".equals(codeString)) {
                return CharacteristicCombination.ATMOST;
            }
            if ("statistical".equals(codeString)) {
                return CharacteristicCombination.STATISTICAL;
            }
            if ("net-effect".equals(codeString)) {
                return CharacteristicCombination.NETEFFECT;
            }
            if ("dataset".equals(codeString)) {
                return CharacteristicCombination.DATASET;
            }
            throw new IllegalArgumentException("Unknown CharacteristicCombination code '" + codeString + "'");
        }

        public Enumeration<CharacteristicCombination> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<CharacteristicCombination>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("all-of".equals(codeString)) {
                return new Enumeration<CharacteristicCombination>(this, CharacteristicCombination.ALLOF);
            }
            if ("any-of".equals(codeString)) {
                return new Enumeration<CharacteristicCombination>(this, CharacteristicCombination.ANYOF);
            }
            if ("at-least".equals(codeString)) {
                return new Enumeration<CharacteristicCombination>(this, CharacteristicCombination.ATLEAST);
            }
            if ("at-most".equals(codeString)) {
                return new Enumeration<CharacteristicCombination>(this, CharacteristicCombination.ATMOST);
            }
            if ("statistical".equals(codeString)) {
                return new Enumeration<CharacteristicCombination>(this, CharacteristicCombination.STATISTICAL);
            }
            if ("net-effect".equals(codeString)) {
                return new Enumeration<CharacteristicCombination>(this, CharacteristicCombination.NETEFFECT);
            }
            if ("dataset".equals(codeString)) {
                return new Enumeration<CharacteristicCombination>(this, CharacteristicCombination.DATASET);
            }
            throw new FHIRException("Unknown CharacteristicCombination code '" + codeString + "'");
        }

        @Override
        public String toCode(CharacteristicCombination code) {
            if (code == CharacteristicCombination.ALLOF) {
                return "all-of";
            }
            if (code == CharacteristicCombination.ANYOF) {
                return "any-of";
            }
            if (code == CharacteristicCombination.ATLEAST) {
                return "at-least";
            }
            if (code == CharacteristicCombination.ATMOST) {
                return "at-most";
            }
            if (code == CharacteristicCombination.STATISTICAL) {
                return "statistical";
            }
            if (code == CharacteristicCombination.NETEFFECT) {
                return "net-effect";
            }
            if (code == CharacteristicCombination.DATASET) {
                return "dataset";
            }
            return "?";
        }

        @Override
        public String toSystem(CharacteristicCombination code) {
            return code.getSystem();
        }
    }

    public static enum CharacteristicCombination {
        ALLOF,
        ANYOF,
        ATLEAST,
        ATMOST,
        STATISTICAL,
        NETEFFECT,
        DATASET,
        NULL;


        public static CharacteristicCombination fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("all-of".equals(codeString)) {
                return ALLOF;
            }
            if ("any-of".equals(codeString)) {
                return ANYOF;
            }
            if ("at-least".equals(codeString)) {
                return ATLEAST;
            }
            if ("at-most".equals(codeString)) {
                return ATMOST;
            }
            if ("statistical".equals(codeString)) {
                return STATISTICAL;
            }
            if ("net-effect".equals(codeString)) {
                return NETEFFECT;
            }
            if ("dataset".equals(codeString)) {
                return DATASET;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown CharacteristicCombination code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ALLOF: {
                    return "all-of";
                }
                case ANYOF: {
                    return "any-of";
                }
                case ATLEAST: {
                    return "at-least";
                }
                case ATMOST: {
                    return "at-most";
                }
                case STATISTICAL: {
                    return "statistical";
                }
                case NETEFFECT: {
                    return "net-effect";
                }
                case DATASET: {
                    return "dataset";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ALLOF: {
                    return "http://hl7.org/fhir/characteristic-combination";
                }
                case ANYOF: {
                    return "http://hl7.org/fhir/characteristic-combination";
                }
                case ATLEAST: {
                    return "http://hl7.org/fhir/characteristic-combination";
                }
                case ATMOST: {
                    return "http://hl7.org/fhir/characteristic-combination";
                }
                case STATISTICAL: {
                    return "http://hl7.org/fhir/characteristic-combination";
                }
                case NETEFFECT: {
                    return "http://hl7.org/fhir/characteristic-combination";
                }
                case DATASET: {
                    return "http://hl7.org/fhir/characteristic-combination";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ALLOF: {
                    return "Combine characteristics with AND.";
                }
                case ANYOF: {
                    return "Combine characteristics with OR.";
                }
                case ATLEAST: {
                    return "Meet at least the threshold number of characteristics for definition.";
                }
                case ATMOST: {
                    return "Meet at most the threshold number of characteristics for definition.";
                }
                case STATISTICAL: {
                    return "Combine characteristics statistically. Use method to specify the statistical method.";
                }
                case NETEFFECT: {
                    return "Combine characteristics by addition of benefits and subtraction of harms.";
                }
                case DATASET: {
                    return "Combine characteristics as a collection used as the dataset.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ALLOF: {
                    return "All of";
                }
                case ANYOF: {
                    return "Any of";
                }
                case ATLEAST: {
                    return "At least";
                }
                case ATMOST: {
                    return "At most";
                }
                case STATISTICAL: {
                    return "Statistical";
                }
                case NETEFFECT: {
                    return "Net effect";
                }
                case DATASET: {
                    return "Dataset";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

