/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="SubscriptionTopic", profile="http://hl7.org/fhir/StructureDefinition/SubscriptionTopic")
public class SubscriptionTopic
extends DomainResource {
    @Child(name="url", type={UriType.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Logical canonical URL to reference this SubscriptionTopic (globally unique)", formalDefinition="An absolute URL that is used to identify this SubscriptionTopic when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this Topic is (or will be) published. The URL SHOULD include the major version of the Topic. For more information see [Technical and Business Versions](resource.html#versions).")
    protected UriType url;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business Identifier for SubscriptionTopic", formalDefinition="Business identifiers assigned to this SubscriptionTopic by the performer and/or other systems.  These identifiers remain constant as the resource is updated and propagates from server to server.")
    protected List<Identifier> identifier;
    @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business version of the SubscriptionTopic", formalDefinition="The identifier that is used to identify this version of the SubscriptionTopic when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the Topic author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions are orderable.")
    protected StringType version;
    @Child(name="title", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this SubscriptionTopic (Human friendly)", formalDefinition="A short, descriptive, user-friendly title for the SubscriptionTopic, for example, \"admission\".")
    protected StringType title;
    @Child(name="derivedFrom", type={CanonicalType.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Based on FHIR protocol or definition", formalDefinition="The canonical URL pointing to another FHIR-defined SubscriptionTopic that is adhered to in whole or in part by this SubscriptionTopic.")
    protected List<CanonicalType> derivedFrom;
    @Child(name="status", type={CodeType.class}, order=5, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired | unknown", formalDefinition="The current state of the SubscriptionTopic.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected Enumeration<Enumerations.PublicationStatus> status;
    @Child(name="experimental", type={BooleanType.class}, order=6, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="If for testing purposes, not real usage", formalDefinition="A flag to indicate that this TopSubscriptionTopicic is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.")
    protected BooleanType experimental;
    @Child(name="date", type={DateTimeType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date status first applied", formalDefinition="For draft definitions, indicates the date of initial creation.  For active definitions, represents the date of activation.  For withdrawn definitions, indicates the date of withdrawal.")
    protected DateTimeType date;
    @Child(name="publisher", type={Practitioner.class, PractitionerRole.class, Organization.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The name of the individual or organization that published the SubscriptionTopic", formalDefinition="Helps establish the \"authority/credibility\" of the SubscriptionTopic.  May also allow for contact.")
    protected Reference publisher;
    @Child(name="contact", type={ContactDetail.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details for the publisher", formalDefinition="Contact details to assist a user in finding and communicating with the publisher.")
    protected List<ContactDetail> contact;
    @Child(name="description", type={MarkdownType.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Natural language description of the ToSubscriptionTopicpic", formalDefinition="A free text natural language description of the Topic from the consumer's perspective.")
    protected MarkdownType description;
    @Child(name="useContext", type={UsageContext.class}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Content intends to support these contexts", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching of code system definitions.")
    protected List<UsageContext> useContext;
    @Child(name="jurisdiction", type={CodeableConcept.class}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Intended jurisdiction for Topic (if applicable)", formalDefinition="A jurisdiction in which the Topic is intended to be used.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    protected List<CodeableConcept> jurisdiction;
    @Child(name="purpose", type={MarkdownType.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why this SubscriptionTopic is defined", formalDefinition="Explains why this Topic is needed and why it has been designed as it has.")
    protected MarkdownType purpose;
    @Child(name="copyright", type={MarkdownType.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the SubscriptionTopic and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the SubscriptionTopic.")
    protected MarkdownType copyright;
    @Child(name="approvalDate", type={DateType.class}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When SubscriptionTopic is/was approved by publisher", formalDefinition="The date on which the asset content was approved by the publisher. Approval happens once when the content is officially approved for usage.")
    protected DateType approvalDate;
    @Child(name="lastReviewDate", type={DateType.class}, order=16, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Date the Subscription Topic was last reviewed by the publisher", formalDefinition="The date on which the asset content was last reviewed. Review happens periodically after that, but doesn't change the original approval date.")
    protected DateType lastReviewDate;
    @Child(name="effectivePeriod", type={Period.class}, order=17, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The effective date range for the SubscriptionTopic", formalDefinition="The period during which the SubscriptionTopic content was or is planned to be effective.")
    protected Period effectivePeriod;
    @Child(name="resourceTrigger", type={}, order=18, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Criteria for including a resource update in the subscription topic", formalDefinition="The criteria for including updates to a nominated resource in the subscription topic.  Thie criteria may be just a human readable description and/or a full FHIR search string or FHIRPath expression.")
    protected List<SubscriptionTopicResourceTriggerComponent> resourceTrigger;
    private static final long serialVersionUID = 1629931785L;
    @SearchParamDefinition(name="date", path="SubscriptionTopic.date", description="Date status first applied", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="derived-or-self", path="SubscriptionTopic.url | SubscriptionTopic.derivedFrom", description="A server defined search that matches either the url or derivedFrom", type="uri")
    public static final String SP_DERIVED_OR_SELF = "derived-or-self";
    public static final UriClientParam DERIVED_OR_SELF = new UriClientParam("derived-or-self");
    @SearchParamDefinition(name="identifier", path="SubscriptionTopic.identifier", description="Business Identifier for SubscriptionTopic", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="publisher", path="SubscriptionTopic.publisher", description="The name of the individual or organization that published the SubscriptionTopic", type="reference", target={Organization.class, Practitioner.class, PractitionerRole.class})
    public static final String SP_PUBLISHER = "publisher";
    public static final ReferenceClientParam PUBLISHER = new ReferenceClientParam("publisher");
    public static final Include INCLUDE_PUBLISHER = new Include("SubscriptionTopic:publisher").toLocked();
    @SearchParamDefinition(name="resource-type", path="SubscriptionTopic.resourceTrigger.resourceType", description="Allowed Data type or Resource (reference to definition) for this definition", type="uri")
    public static final String SP_RESOURCE_TYPE = "resource-type";
    public static final UriClientParam RESOURCE_TYPE = new UriClientParam("resource-type");
    @SearchParamDefinition(name="status", path="SubscriptionTopic.status", description="draft | active | retired | unknown", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="title", path="SubscriptionTopic.title", description="Name for this SubscriptionTopic (Human friendly)", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="trigger-description", path="SubscriptionTopic.resourceTrigger.description", description="Text representation of the trigger", type="string")
    public static final String SP_TRIGGER_DESCRIPTION = "trigger-description";
    public static final StringClientParam TRIGGER_DESCRIPTION = new StringClientParam("trigger-description");
    @SearchParamDefinition(name="url", path="SubscriptionTopic.url", description="Logical canonical URL to reference this SubscriptionTopic (globally unique)", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="version", path="SubscriptionTopic.version", description="Business version of the SubscriptionTopic", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");

    public SubscriptionTopic() {
    }

    public SubscriptionTopic(String url, Enumerations.PublicationStatus status) {
        this.setUrl(url);
        this.setStatus(status);
    }

    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionTopic.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    public SubscriptionTopic setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    public SubscriptionTopic setUrl(String value) {
        if (this.url == null) {
            this.url = new UriType();
        }
        this.url.setValue(value);
        return this;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public SubscriptionTopic setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public SubscriptionTopic addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionTopic.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    public SubscriptionTopic setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    public SubscriptionTopic setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionTopic.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    public SubscriptionTopic setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    public SubscriptionTopic setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    public List<CanonicalType> getDerivedFrom() {
        if (this.derivedFrom == null) {
            this.derivedFrom = new ArrayList<CanonicalType>();
        }
        return this.derivedFrom;
    }

    public SubscriptionTopic setDerivedFrom(List<CanonicalType> theDerivedFrom) {
        this.derivedFrom = theDerivedFrom;
        return this;
    }

    public boolean hasDerivedFrom() {
        if (this.derivedFrom == null) {
            return false;
        }
        for (CanonicalType item : this.derivedFrom) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CanonicalType addDerivedFromElement() {
        CanonicalType t = new CanonicalType();
        if (this.derivedFrom == null) {
            this.derivedFrom = new ArrayList<CanonicalType>();
        }
        this.derivedFrom.add(t);
        return t;
    }

    public SubscriptionTopic addDerivedFrom(String value) {
        CanonicalType t = new CanonicalType();
        t.setValue(value);
        if (this.derivedFrom == null) {
            this.derivedFrom = new ArrayList<CanonicalType>();
        }
        this.derivedFrom.add(t);
        return this;
    }

    public boolean hasDerivedFrom(String value) {
        if (this.derivedFrom == null) {
            return false;
        }
        for (CanonicalType v : this.derivedFrom) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionTopic.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public SubscriptionTopic setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    public SubscriptionTopic setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionTopic.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    public SubscriptionTopic setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    public SubscriptionTopic setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionTopic.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public SubscriptionTopic setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public SubscriptionTopic setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public Reference getPublisher() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionTopic.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new Reference();
            }
        }
        return this.publisher;
    }

    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    public SubscriptionTopic setPublisher(Reference value) {
        this.publisher = value;
        return this;
    }

    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        return this.contact;
    }

    public SubscriptionTopic setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return t;
    }

    public SubscriptionTopic addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return this;
    }

    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionTopic.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public SubscriptionTopic setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public SubscriptionTopic setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        return this.useContext;
    }

    public SubscriptionTopic setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return t;
    }

    public SubscriptionTopic addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return this;
    }

    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        return this.jurisdiction;
    }

    public SubscriptionTopic setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return t;
    }

    public SubscriptionTopic addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return this;
    }

    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    public MarkdownType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionTopic.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new MarkdownType();
            }
        }
        return this.purpose;
    }

    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public SubscriptionTopic setPurposeElement(MarkdownType value) {
        this.purpose = value;
        return this;
    }

    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    public SubscriptionTopic setPurpose(String value) {
        if (value == null) {
            this.purpose = null;
        } else {
            if (this.purpose == null) {
                this.purpose = new MarkdownType();
            }
            this.purpose.setValue(value);
        }
        return this;
    }

    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionTopic.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public SubscriptionTopic setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    public SubscriptionTopic setCopyright(String value) {
        if (value == null) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public DateType getApprovalDateElement() {
        if (this.approvalDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionTopic.approvalDate");
            }
            if (Configuration.doAutoCreate()) {
                this.approvalDate = new DateType();
            }
        }
        return this.approvalDate;
    }

    public boolean hasApprovalDateElement() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    public boolean hasApprovalDate() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    public SubscriptionTopic setApprovalDateElement(DateType value) {
        this.approvalDate = value;
        return this;
    }

    public Date getApprovalDate() {
        return this.approvalDate == null ? null : (Date)this.approvalDate.getValue();
    }

    public SubscriptionTopic setApprovalDate(Date value) {
        if (value == null) {
            this.approvalDate = null;
        } else {
            if (this.approvalDate == null) {
                this.approvalDate = new DateType();
            }
            this.approvalDate.setValue(value);
        }
        return this;
    }

    public DateType getLastReviewDateElement() {
        if (this.lastReviewDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionTopic.lastReviewDate");
            }
            if (Configuration.doAutoCreate()) {
                this.lastReviewDate = new DateType();
            }
        }
        return this.lastReviewDate;
    }

    public boolean hasLastReviewDateElement() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    public boolean hasLastReviewDate() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    public SubscriptionTopic setLastReviewDateElement(DateType value) {
        this.lastReviewDate = value;
        return this;
    }

    public Date getLastReviewDate() {
        return this.lastReviewDate == null ? null : (Date)this.lastReviewDate.getValue();
    }

    public SubscriptionTopic setLastReviewDate(Date value) {
        if (value == null) {
            this.lastReviewDate = null;
        } else {
            if (this.lastReviewDate == null) {
                this.lastReviewDate = new DateType();
            }
            this.lastReviewDate.setValue(value);
        }
        return this;
    }

    public Period getEffectivePeriod() {
        if (this.effectivePeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionTopic.effectivePeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.effectivePeriod = new Period();
            }
        }
        return this.effectivePeriod;
    }

    public boolean hasEffectivePeriod() {
        return this.effectivePeriod != null && !this.effectivePeriod.isEmpty();
    }

    public SubscriptionTopic setEffectivePeriod(Period value) {
        this.effectivePeriod = value;
        return this;
    }

    public List<SubscriptionTopicResourceTriggerComponent> getResourceTrigger() {
        if (this.resourceTrigger == null) {
            this.resourceTrigger = new ArrayList<SubscriptionTopicResourceTriggerComponent>();
        }
        return this.resourceTrigger;
    }

    public SubscriptionTopic setResourceTrigger(List<SubscriptionTopicResourceTriggerComponent> theResourceTrigger) {
        this.resourceTrigger = theResourceTrigger;
        return this;
    }

    public boolean hasResourceTrigger() {
        if (this.resourceTrigger == null) {
            return false;
        }
        for (SubscriptionTopicResourceTriggerComponent item : this.resourceTrigger) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SubscriptionTopicResourceTriggerComponent addResourceTrigger() {
        SubscriptionTopicResourceTriggerComponent t = new SubscriptionTopicResourceTriggerComponent();
        if (this.resourceTrigger == null) {
            this.resourceTrigger = new ArrayList<SubscriptionTopicResourceTriggerComponent>();
        }
        this.resourceTrigger.add(t);
        return t;
    }

    public SubscriptionTopic addResourceTrigger(SubscriptionTopicResourceTriggerComponent t) {
        if (t == null) {
            return this;
        }
        if (this.resourceTrigger == null) {
            this.resourceTrigger = new ArrayList<SubscriptionTopicResourceTriggerComponent>();
        }
        this.resourceTrigger.add(t);
        return this;
    }

    public SubscriptionTopicResourceTriggerComponent getResourceTriggerFirstRep() {
        if (this.getResourceTrigger().isEmpty()) {
            this.addResourceTrigger();
        }
        return this.getResourceTrigger().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URL that is used to identify this SubscriptionTopic when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this Topic is (or will be) published. The URL SHOULD include the major version of the Topic. For more information see [Technical and Business Versions](resource.html#versions).", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this SubscriptionTopic by the performer and/or other systems.  These identifiers remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the SubscriptionTopic when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the Topic author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions are orderable.", 0, 1, this.version));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the SubscriptionTopic, for example, \"admission\".", 0, 1, this.title));
        children.add(new Property("derivedFrom", "canonical(SubscriptionTopic)", "The canonical URL pointing to another FHIR-defined SubscriptionTopic that is adhered to in whole or in part by this SubscriptionTopic.", 0, Integer.MAX_VALUE, this.derivedFrom));
        children.add(new Property(SP_STATUS, "code", "The current state of the SubscriptionTopic.", 0, 1, this.status));
        children.add(new Property("experimental", "boolean", "A flag to indicate that this TopSubscriptionTopicic is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property(SP_DATE, "dateTime", "For draft definitions, indicates the date of initial creation.  For active definitions, represents the date of activation.  For withdrawn definitions, indicates the date of withdrawal.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "Reference(Practitioner|PractitionerRole|Organization)", "Helps establish the \"authority/credibility\" of the SubscriptionTopic.  May also allow for contact.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property("description", "markdown", "A free text natural language description of the Topic from the consumer's perspective.", 0, 1, this.description));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching of code system definitions.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property("jurisdiction", "CodeableConcept", "A jurisdiction in which the Topic is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("purpose", "markdown", "Explains why this Topic is needed and why it has been designed as it has.", 0, 1, this.purpose));
        children.add(new Property("copyright", "markdown", "A copyright statement relating to the SubscriptionTopic and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the SubscriptionTopic.", 0, 1, this.copyright));
        children.add(new Property("approvalDate", SP_DATE, "The date on which the asset content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate));
        children.add(new Property("lastReviewDate", SP_DATE, "The date on which the asset content was last reviewed. Review happens periodically after that, but doesn't change the original approval date.", 0, 1, this.lastReviewDate));
        children.add(new Property("effectivePeriod", "Period", "The period during which the SubscriptionTopic content was or is planned to be effective.", 0, 1, this.effectivePeriod));
        children.add(new Property("resourceTrigger", "", "The criteria for including updates to a nominated resource in the subscription topic.  Thie criteria may be just a human readable description and/or a full FHIR search string or FHIRPath expression.", 0, Integer.MAX_VALUE, this.resourceTrigger));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URL that is used to identify this SubscriptionTopic when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this Topic is (or will be) published. The URL SHOULD include the major version of the Topic. For more information see [Technical and Business Versions](resource.html#versions).", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this SubscriptionTopic by the performer and/or other systems.  These identifiers remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the SubscriptionTopic when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the Topic author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions are orderable.", 0, 1, this.version);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the SubscriptionTopic, for example, \"admission\".", 0, 1, this.title);
            }
            case 1077922663: {
                return new Property("derivedFrom", "canonical(SubscriptionTopic)", "The canonical URL pointing to another FHIR-defined SubscriptionTopic that is adhered to in whole or in part by this SubscriptionTopic.", 0, Integer.MAX_VALUE, this.derivedFrom);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The current state of the SubscriptionTopic.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A flag to indicate that this TopSubscriptionTopicic is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "For draft definitions, indicates the date of initial creation.  For active definitions, represents the date of activation.  For withdrawn definitions, indicates the date of withdrawal.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "Reference(Practitioner|PractitionerRole|Organization)", "Helps establish the \"authority/credibility\" of the SubscriptionTopic.  May also allow for contact.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property("description", "markdown", "A free text natural language description of the Topic from the consumer's perspective.", 0, 1, this.description);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching of code system definitions.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property("jurisdiction", "CodeableConcept", "A jurisdiction in which the Topic is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case -220463842: {
                return new Property("purpose", "markdown", "Explains why this Topic is needed and why it has been designed as it has.", 0, 1, this.purpose);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "A copyright statement relating to the SubscriptionTopic and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the SubscriptionTopic.", 0, 1, this.copyright);
            }
            case 223539345: {
                return new Property("approvalDate", SP_DATE, "The date on which the asset content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate);
            }
            case -1687512484: {
                return new Property("lastReviewDate", SP_DATE, "The date on which the asset content was last reviewed. Review happens periodically after that, but doesn't change the original approval date.", 0, 1, this.lastReviewDate);
            }
            case -403934648: {
                return new Property("effectivePeriod", "Period", "The period during which the SubscriptionTopic content was or is planned to be effective.", 0, 1, this.effectivePeriod);
            }
            case -424927798: {
                return new Property("resourceTrigger", "", "The criteria for including updates to a nominated resource in the subscription topic.  Thie criteria may be just a human readable description and/or a full FHIR search string or FHIRPath expression.", 0, Integer.MAX_VALUE, this.resourceTrigger);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.title;
                }
                return baseArray;
            }
            case 1077922663: {
                return this.derivedFrom == null ? new Base[]{} : this.derivedFrom.toArray(new Base[this.derivedFrom.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.purpose;
                }
                return baseArray;
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.copyright;
                }
                return baseArray;
            }
            case 223539345: {
                Base[] baseArray;
                if (this.approvalDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.approvalDate;
                }
                return baseArray;
            }
            case -1687512484: {
                Base[] baseArray;
                if (this.lastReviewDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.lastReviewDate;
                }
                return baseArray;
            }
            case -403934648: {
                Base[] baseArray;
                if (this.effectivePeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.effectivePeriod;
                }
                return baseArray;
            }
            case -424927798: {
                return this.resourceTrigger == null ? new Base[]{} : this.resourceTrigger.toArray(new Base[this.resourceTrigger.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = TypeConvertor.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 351608024: {
                this.version = TypeConvertor.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = TypeConvertor.castToString(value);
                return value;
            }
            case 1077922663: {
                this.getDerivedFrom().add(TypeConvertor.castToCanonical(value));
                return value;
            }
            case -892481550: {
                value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -404562712: {
                this.experimental = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = TypeConvertor.castToReference(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(TypeConvertor.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -220463842: {
                this.purpose = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 1522889671: {
                this.copyright = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 223539345: {
                this.approvalDate = TypeConvertor.castToDate(value);
                return value;
            }
            case -1687512484: {
                this.lastReviewDate = TypeConvertor.castToDate(value);
                return value;
            }
            case -403934648: {
                this.effectivePeriod = TypeConvertor.castToPeriod(value);
                return value;
            }
            case -424927798: {
                this.getResourceTrigger().add((SubscriptionTopicResourceTriggerComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = TypeConvertor.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = TypeConvertor.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = TypeConvertor.castToString(value);
        } else if (name.equals("derivedFrom")) {
            this.getDerivedFrom().add(TypeConvertor.castToCanonical(value));
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("experimental")) {
            this.experimental = TypeConvertor.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = TypeConvertor.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = TypeConvertor.castToReference(value);
        } else if (name.equals("contact")) {
            this.getContact().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("description")) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(TypeConvertor.castToUsageContext(value));
        } else if (name.equals("jurisdiction")) {
            this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("purpose")) {
            this.purpose = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("copyright")) {
            this.copyright = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("approvalDate")) {
            this.approvalDate = TypeConvertor.castToDate(value);
        } else if (name.equals("lastReviewDate")) {
            this.lastReviewDate = TypeConvertor.castToDate(value);
        } else if (name.equals("effectivePeriod")) {
            this.effectivePeriod = TypeConvertor.castToPeriod(value);
        } else if (name.equals("resourceTrigger")) {
            this.getResourceTrigger().add((SubscriptionTopicResourceTriggerComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case 1077922663: {
                return this.addDerivedFromElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisher();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case -220463842: {
                return this.getPurposeElement();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case 223539345: {
                return this.getApprovalDateElement();
            }
            case -1687512484: {
                return this.getLastReviewDateElement();
            }
            case -403934648: {
                return this.getEffectivePeriod();
            }
            case -424927798: {
                return this.addResourceTrigger();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case 1077922663: {
                return new String[]{"canonical"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"Reference"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case -220463842: {
                return new String[]{"markdown"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case 223539345: {
                return new String[]{SP_DATE};
            }
            case -1687512484: {
                return new String[]{SP_DATE};
            }
            case -403934648: {
                return new String[]{"Period"};
            }
            case -424927798: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.version");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.title");
        }
        if (name.equals("derivedFrom")) {
            throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.derivedFrom");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            this.publisher = new Reference();
            return this.publisher;
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals("jurisdiction")) {
            return this.addJurisdiction();
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.purpose");
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.copyright");
        }
        if (name.equals("approvalDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.approvalDate");
        }
        if (name.equals("lastReviewDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.lastReviewDate");
        }
        if (name.equals("effectivePeriod")) {
            this.effectivePeriod = new Period();
            return this.effectivePeriod;
        }
        if (name.equals("resourceTrigger")) {
            return this.addResourceTrigger();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "SubscriptionTopic";
    }

    @Override
    public SubscriptionTopic copy() {
        SubscriptionTopic dst = new SubscriptionTopic();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(SubscriptionTopic dst) {
        super.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        StringType stringType = dst.title = this.title == null ? null : this.title.copy();
        if (this.derivedFrom != null) {
            dst.derivedFrom = new ArrayList<CanonicalType>();
            for (CanonicalType canonicalType : this.derivedFrom) {
                dst.derivedFrom.add(canonicalType.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        Reference reference = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList<UsageContext>();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        dst.approvalDate = this.approvalDate == null ? null : this.approvalDate.copy();
        dst.lastReviewDate = this.lastReviewDate == null ? null : this.lastReviewDate.copy();
        Period period = dst.effectivePeriod = this.effectivePeriod == null ? null : this.effectivePeriod.copy();
        if (this.resourceTrigger != null) {
            dst.resourceTrigger = new ArrayList<SubscriptionTopicResourceTriggerComponent>();
            for (SubscriptionTopicResourceTriggerComponent subscriptionTopicResourceTriggerComponent : this.resourceTrigger) {
                dst.resourceTrigger.add(subscriptionTopicResourceTriggerComponent.copy());
            }
        }
    }

    protected SubscriptionTopic typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof SubscriptionTopic)) {
            return false;
        }
        SubscriptionTopic o = (SubscriptionTopic)other_;
        return SubscriptionTopic.compareDeep(this.url, o.url, true) && SubscriptionTopic.compareDeep(this.identifier, o.identifier, true) && SubscriptionTopic.compareDeep(this.version, o.version, true) && SubscriptionTopic.compareDeep(this.title, o.title, true) && SubscriptionTopic.compareDeep(this.derivedFrom, o.derivedFrom, true) && SubscriptionTopic.compareDeep(this.status, o.status, true) && SubscriptionTopic.compareDeep(this.experimental, o.experimental, true) && SubscriptionTopic.compareDeep(this.date, o.date, true) && SubscriptionTopic.compareDeep(this.publisher, o.publisher, true) && SubscriptionTopic.compareDeep(this.contact, o.contact, true) && SubscriptionTopic.compareDeep(this.description, o.description, true) && SubscriptionTopic.compareDeep(this.useContext, o.useContext, true) && SubscriptionTopic.compareDeep(this.jurisdiction, o.jurisdiction, true) && SubscriptionTopic.compareDeep(this.purpose, o.purpose, true) && SubscriptionTopic.compareDeep(this.copyright, o.copyright, true) && SubscriptionTopic.compareDeep(this.approvalDate, o.approvalDate, true) && SubscriptionTopic.compareDeep(this.lastReviewDate, o.lastReviewDate, true) && SubscriptionTopic.compareDeep(this.effectivePeriod, o.effectivePeriod, true) && SubscriptionTopic.compareDeep(this.resourceTrigger, o.resourceTrigger, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof SubscriptionTopic)) {
            return false;
        }
        SubscriptionTopic o = (SubscriptionTopic)other_;
        return SubscriptionTopic.compareValues(this.url, o.url, true) && SubscriptionTopic.compareValues(this.version, o.version, true) && SubscriptionTopic.compareValues(this.title, o.title, true) && SubscriptionTopic.compareValues(this.derivedFrom, o.derivedFrom, true) && SubscriptionTopic.compareValues(this.status, o.status, true) && SubscriptionTopic.compareValues(this.experimental, o.experimental, true) && SubscriptionTopic.compareValues(this.date, o.date, true) && SubscriptionTopic.compareValues(this.description, o.description, true) && SubscriptionTopic.compareValues(this.purpose, o.purpose, true) && SubscriptionTopic.compareValues(this.copyright, o.copyright, true) && SubscriptionTopic.compareValues(this.approvalDate, o.approvalDate, true) && SubscriptionTopic.compareValues(this.lastReviewDate, o.lastReviewDate, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.url, this.identifier, this.version, this.title, this.derivedFrom, this.status, this.experimental, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.purpose, this.copyright, this.approvalDate, this.lastReviewDate, this.effectivePeriod, this.resourceTrigger});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.SubscriptionTopic;
    }

    @Block
    public static class SubscriptionTopicResourceTriggerCanFilterByComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="searchParamName", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Search parameter that serves as filter key", formalDefinition="A search parameter (like \"patient\") which is a label for the filter.")
        protected StringType searchParamName;
        @Child(name="searchModifier", type={CodeType.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="= | eq | ne | gt | lt | ge | le | sa | eb | ap | above | below | in | not-in | of-type", formalDefinition="Allowable operators to apply when determining matches (Search Modifiers).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/subscription-search-modifier")
        protected List<Enumeration<Enumerations.SubscriptionSearchModifier>> searchModifier;
        @Child(name="documentation", type={MarkdownType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Description of this filter parameter", formalDefinition="Description of how this filter parameter is intended to be used.")
        protected MarkdownType documentation;
        private static final long serialVersionUID = 482273720L;

        public StringType getSearchParamNameElement() {
            if (this.searchParamName == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionTopicResourceTriggerCanFilterByComponent.searchParamName");
                }
                if (Configuration.doAutoCreate()) {
                    this.searchParamName = new StringType();
                }
            }
            return this.searchParamName;
        }

        public boolean hasSearchParamNameElement() {
            return this.searchParamName != null && !this.searchParamName.isEmpty();
        }

        public boolean hasSearchParamName() {
            return this.searchParamName != null && !this.searchParamName.isEmpty();
        }

        public SubscriptionTopicResourceTriggerCanFilterByComponent setSearchParamNameElement(StringType value) {
            this.searchParamName = value;
            return this;
        }

        public String getSearchParamName() {
            return this.searchParamName == null ? null : (String)this.searchParamName.getValue();
        }

        public SubscriptionTopicResourceTriggerCanFilterByComponent setSearchParamName(String value) {
            if (Utilities.noString((String)value)) {
                this.searchParamName = null;
            } else {
                if (this.searchParamName == null) {
                    this.searchParamName = new StringType();
                }
                this.searchParamName.setValue(value);
            }
            return this;
        }

        public List<Enumeration<Enumerations.SubscriptionSearchModifier>> getSearchModifier() {
            if (this.searchModifier == null) {
                this.searchModifier = new ArrayList<Enumeration<Enumerations.SubscriptionSearchModifier>>();
            }
            return this.searchModifier;
        }

        public SubscriptionTopicResourceTriggerCanFilterByComponent setSearchModifier(List<Enumeration<Enumerations.SubscriptionSearchModifier>> theSearchModifier) {
            this.searchModifier = theSearchModifier;
            return this;
        }

        public boolean hasSearchModifier() {
            if (this.searchModifier == null) {
                return false;
            }
            for (Enumeration<Enumerations.SubscriptionSearchModifier> item : this.searchModifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Enumeration<Enumerations.SubscriptionSearchModifier> addSearchModifierElement() {
            Enumeration<Enumerations.SubscriptionSearchModifier> t = new Enumeration<Enumerations.SubscriptionSearchModifier>(new Enumerations.SubscriptionSearchModifierEnumFactory());
            if (this.searchModifier == null) {
                this.searchModifier = new ArrayList<Enumeration<Enumerations.SubscriptionSearchModifier>>();
            }
            this.searchModifier.add(t);
            return t;
        }

        public SubscriptionTopicResourceTriggerCanFilterByComponent addSearchModifier(Enumerations.SubscriptionSearchModifier value) {
            Enumeration<Enumerations.SubscriptionSearchModifier> t = new Enumeration<Enumerations.SubscriptionSearchModifier>(new Enumerations.SubscriptionSearchModifierEnumFactory());
            t.setValue((Object)value);
            if (this.searchModifier == null) {
                this.searchModifier = new ArrayList<Enumeration<Enumerations.SubscriptionSearchModifier>>();
            }
            this.searchModifier.add(t);
            return this;
        }

        public boolean hasSearchModifier(Enumerations.SubscriptionSearchModifier value) {
            if (this.searchModifier == null) {
                return false;
            }
            for (Enumeration<Enumerations.SubscriptionSearchModifier> v : this.searchModifier) {
                if (!((Enumerations.SubscriptionSearchModifier)((Object)v.getValue())).equals((Object)value)) continue;
                return true;
            }
            return false;
        }

        public MarkdownType getDocumentationElement() {
            if (this.documentation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionTopicResourceTriggerCanFilterByComponent.documentation");
                }
                if (Configuration.doAutoCreate()) {
                    this.documentation = new MarkdownType();
                }
            }
            return this.documentation;
        }

        public boolean hasDocumentationElement() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public boolean hasDocumentation() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public SubscriptionTopicResourceTriggerCanFilterByComponent setDocumentationElement(MarkdownType value) {
            this.documentation = value;
            return this;
        }

        public String getDocumentation() {
            return this.documentation == null ? null : (String)this.documentation.getValue();
        }

        public SubscriptionTopicResourceTriggerCanFilterByComponent setDocumentation(String value) {
            if (value == null) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new MarkdownType();
                }
                this.documentation.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("searchParamName", "string", "A search parameter (like \"patient\") which is a label for the filter.", 0, 1, this.searchParamName));
            children.add(new Property("searchModifier", "code", "Allowable operators to apply when determining matches (Search Modifiers).", 0, Integer.MAX_VALUE, this.searchModifier));
            children.add(new Property("documentation", "markdown", "Description of how this filter parameter is intended to be used.", 0, 1, this.documentation));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 83857392: {
                    return new Property("searchParamName", "string", "A search parameter (like \"patient\") which is a label for the filter.", 0, 1, this.searchParamName);
                }
                case 1540924575: {
                    return new Property("searchModifier", "code", "Allowable operators to apply when determining matches (Search Modifiers).", 0, Integer.MAX_VALUE, this.searchModifier);
                }
                case 1587405498: {
                    return new Property("documentation", "markdown", "Description of how this filter parameter is intended to be used.", 0, 1, this.documentation);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 83857392: {
                    Base[] baseArray;
                    if (this.searchParamName == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.searchParamName;
                    }
                    return baseArray;
                }
                case 1540924575: {
                    return this.searchModifier == null ? new Base[]{} : this.searchModifier.toArray(new Base[this.searchModifier.size()]);
                }
                case 1587405498: {
                    Base[] baseArray;
                    if (this.documentation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.documentation;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 83857392: {
                    this.searchParamName = TypeConvertor.castToString(value);
                    return value;
                }
                case 1540924575: {
                    value = new Enumerations.SubscriptionSearchModifierEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.getSearchModifier().add(value);
                    return value;
                }
                case 1587405498: {
                    this.documentation = TypeConvertor.castToMarkdown(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("searchParamName")) {
                this.searchParamName = TypeConvertor.castToString(value);
            } else if (name.equals("searchModifier")) {
                value = new Enumerations.SubscriptionSearchModifierEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.getSearchModifier().add(value);
            } else if (name.equals("documentation")) {
                this.documentation = TypeConvertor.castToMarkdown(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 83857392: {
                    return this.getSearchParamNameElement();
                }
                case 1540924575: {
                    return this.addSearchModifierElement();
                }
                case 1587405498: {
                    return this.getDocumentationElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 83857392: {
                    return new String[]{"string"};
                }
                case 1540924575: {
                    return new String[]{"code"};
                }
                case 1587405498: {
                    return new String[]{"markdown"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("searchParamName")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.resourceTrigger.canFilterBy.searchParamName");
            }
            if (name.equals("searchModifier")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.resourceTrigger.canFilterBy.searchModifier");
            }
            if (name.equals("documentation")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.resourceTrigger.canFilterBy.documentation");
            }
            return super.addChild(name);
        }

        @Override
        public SubscriptionTopicResourceTriggerCanFilterByComponent copy() {
            SubscriptionTopicResourceTriggerCanFilterByComponent dst = new SubscriptionTopicResourceTriggerCanFilterByComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubscriptionTopicResourceTriggerCanFilterByComponent dst) {
            super.copyValues(dst);
            StringType stringType = dst.searchParamName = this.searchParamName == null ? null : this.searchParamName.copy();
            if (this.searchModifier != null) {
                dst.searchModifier = new ArrayList<Enumeration<Enumerations.SubscriptionSearchModifier>>();
                for (Enumeration<Enumerations.SubscriptionSearchModifier> i : this.searchModifier) {
                    dst.searchModifier.add((Enumeration<Enumerations.SubscriptionSearchModifier>)i.copy());
                }
            }
            dst.documentation = this.documentation == null ? null : this.documentation.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubscriptionTopicResourceTriggerCanFilterByComponent)) {
                return false;
            }
            SubscriptionTopicResourceTriggerCanFilterByComponent o = (SubscriptionTopicResourceTriggerCanFilterByComponent)other_;
            return SubscriptionTopicResourceTriggerCanFilterByComponent.compareDeep(this.searchParamName, o.searchParamName, true) && SubscriptionTopicResourceTriggerCanFilterByComponent.compareDeep(this.searchModifier, o.searchModifier, true) && SubscriptionTopicResourceTriggerCanFilterByComponent.compareDeep(this.documentation, o.documentation, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubscriptionTopicResourceTriggerCanFilterByComponent)) {
                return false;
            }
            SubscriptionTopicResourceTriggerCanFilterByComponent o = (SubscriptionTopicResourceTriggerCanFilterByComponent)other_;
            return SubscriptionTopicResourceTriggerCanFilterByComponent.compareValues(this.searchParamName, o.searchParamName, true) && SubscriptionTopicResourceTriggerCanFilterByComponent.compareValues(this.searchModifier, o.searchModifier, true) && SubscriptionTopicResourceTriggerCanFilterByComponent.compareValues(this.documentation, o.documentation, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.searchParamName, this.searchModifier, this.documentation});
        }

        @Override
        public String fhirType() {
            return "SubscriptionTopic.resourceTrigger.canFilterBy";
        }
    }

    @Block
    public static class SubscriptionTopicResourceTriggerQueryCriteriaComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="previous", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Rule applied to previous resource state", formalDefinition="The FHIR query based rules are applied to the previous resource state.")
        protected StringType previous;
        @Child(name="resultForCreate", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="test-passes | test-fails", formalDefinition="What behavior a server will exhibit if the previous state of a resource does NOT exist (e.g., during a CREATE).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/subscriptiontopic-cr-behavior")
        protected Enumeration<CriteriaNotExistsBehavior> resultForCreate;
        @Child(name="current", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Rule applied to current resource state", formalDefinition="The FHIR query based rules are applied to the current resource state.")
        protected StringType current;
        @Child(name="resultForDelete", type={CodeType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="test-passes | test-fails", formalDefinition="What behavior a server will exhibit if the current state of a resource does NOT exist (e.g., during a DELETE).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/subscriptiontopic-cr-behavior")
        protected Enumeration<CriteriaNotExistsBehavior> resultForDelete;
        @Child(name="requireBoth", type={BooleanType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Both must be true flag", formalDefinition="If set to true, both current and previous criteria must evaluate true to  trigger a notification for this topic.  Otherwise a notification for this topic will be triggered if either one evaluates to true.")
        protected BooleanType requireBoth;
        private static final long serialVersionUID = -291746067L;

        public StringType getPreviousElement() {
            if (this.previous == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionTopicResourceTriggerQueryCriteriaComponent.previous");
                }
                if (Configuration.doAutoCreate()) {
                    this.previous = new StringType();
                }
            }
            return this.previous;
        }

        public boolean hasPreviousElement() {
            return this.previous != null && !this.previous.isEmpty();
        }

        public boolean hasPrevious() {
            return this.previous != null && !this.previous.isEmpty();
        }

        public SubscriptionTopicResourceTriggerQueryCriteriaComponent setPreviousElement(StringType value) {
            this.previous = value;
            return this;
        }

        public String getPrevious() {
            return this.previous == null ? null : (String)this.previous.getValue();
        }

        public SubscriptionTopicResourceTriggerQueryCriteriaComponent setPrevious(String value) {
            if (Utilities.noString((String)value)) {
                this.previous = null;
            } else {
                if (this.previous == null) {
                    this.previous = new StringType();
                }
                this.previous.setValue(value);
            }
            return this;
        }

        public Enumeration<CriteriaNotExistsBehavior> getResultForCreateElement() {
            if (this.resultForCreate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionTopicResourceTriggerQueryCriteriaComponent.resultForCreate");
                }
                if (Configuration.doAutoCreate()) {
                    this.resultForCreate = new Enumeration<CriteriaNotExistsBehavior>(new CriteriaNotExistsBehaviorEnumFactory());
                }
            }
            return this.resultForCreate;
        }

        public boolean hasResultForCreateElement() {
            return this.resultForCreate != null && !this.resultForCreate.isEmpty();
        }

        public boolean hasResultForCreate() {
            return this.resultForCreate != null && !this.resultForCreate.isEmpty();
        }

        public SubscriptionTopicResourceTriggerQueryCriteriaComponent setResultForCreateElement(Enumeration<CriteriaNotExistsBehavior> value) {
            this.resultForCreate = value;
            return this;
        }

        public CriteriaNotExistsBehavior getResultForCreate() {
            return this.resultForCreate == null ? null : (CriteriaNotExistsBehavior)((Object)this.resultForCreate.getValue());
        }

        public SubscriptionTopicResourceTriggerQueryCriteriaComponent setResultForCreate(CriteriaNotExistsBehavior value) {
            if (value == null) {
                this.resultForCreate = null;
            } else {
                if (this.resultForCreate == null) {
                    this.resultForCreate = new Enumeration<CriteriaNotExistsBehavior>(new CriteriaNotExistsBehaviorEnumFactory());
                }
                this.resultForCreate.setValue((Object)value);
            }
            return this;
        }

        public StringType getCurrentElement() {
            if (this.current == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionTopicResourceTriggerQueryCriteriaComponent.current");
                }
                if (Configuration.doAutoCreate()) {
                    this.current = new StringType();
                }
            }
            return this.current;
        }

        public boolean hasCurrentElement() {
            return this.current != null && !this.current.isEmpty();
        }

        public boolean hasCurrent() {
            return this.current != null && !this.current.isEmpty();
        }

        public SubscriptionTopicResourceTriggerQueryCriteriaComponent setCurrentElement(StringType value) {
            this.current = value;
            return this;
        }

        public String getCurrent() {
            return this.current == null ? null : (String)this.current.getValue();
        }

        public SubscriptionTopicResourceTriggerQueryCriteriaComponent setCurrent(String value) {
            if (Utilities.noString((String)value)) {
                this.current = null;
            } else {
                if (this.current == null) {
                    this.current = new StringType();
                }
                this.current.setValue(value);
            }
            return this;
        }

        public Enumeration<CriteriaNotExistsBehavior> getResultForDeleteElement() {
            if (this.resultForDelete == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionTopicResourceTriggerQueryCriteriaComponent.resultForDelete");
                }
                if (Configuration.doAutoCreate()) {
                    this.resultForDelete = new Enumeration<CriteriaNotExistsBehavior>(new CriteriaNotExistsBehaviorEnumFactory());
                }
            }
            return this.resultForDelete;
        }

        public boolean hasResultForDeleteElement() {
            return this.resultForDelete != null && !this.resultForDelete.isEmpty();
        }

        public boolean hasResultForDelete() {
            return this.resultForDelete != null && !this.resultForDelete.isEmpty();
        }

        public SubscriptionTopicResourceTriggerQueryCriteriaComponent setResultForDeleteElement(Enumeration<CriteriaNotExistsBehavior> value) {
            this.resultForDelete = value;
            return this;
        }

        public CriteriaNotExistsBehavior getResultForDelete() {
            return this.resultForDelete == null ? null : (CriteriaNotExistsBehavior)((Object)this.resultForDelete.getValue());
        }

        public SubscriptionTopicResourceTriggerQueryCriteriaComponent setResultForDelete(CriteriaNotExistsBehavior value) {
            if (value == null) {
                this.resultForDelete = null;
            } else {
                if (this.resultForDelete == null) {
                    this.resultForDelete = new Enumeration<CriteriaNotExistsBehavior>(new CriteriaNotExistsBehaviorEnumFactory());
                }
                this.resultForDelete.setValue((Object)value);
            }
            return this;
        }

        public BooleanType getRequireBothElement() {
            if (this.requireBoth == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionTopicResourceTriggerQueryCriteriaComponent.requireBoth");
                }
                if (Configuration.doAutoCreate()) {
                    this.requireBoth = new BooleanType();
                }
            }
            return this.requireBoth;
        }

        public boolean hasRequireBothElement() {
            return this.requireBoth != null && !this.requireBoth.isEmpty();
        }

        public boolean hasRequireBoth() {
            return this.requireBoth != null && !this.requireBoth.isEmpty();
        }

        public SubscriptionTopicResourceTriggerQueryCriteriaComponent setRequireBothElement(BooleanType value) {
            this.requireBoth = value;
            return this;
        }

        public boolean getRequireBoth() {
            return this.requireBoth == null || this.requireBoth.isEmpty() ? false : (Boolean)this.requireBoth.getValue();
        }

        public SubscriptionTopicResourceTriggerQueryCriteriaComponent setRequireBoth(boolean value) {
            if (this.requireBoth == null) {
                this.requireBoth = new BooleanType();
            }
            this.requireBoth.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("previous", "string", "The FHIR query based rules are applied to the previous resource state.", 0, 1, this.previous));
            children.add(new Property("resultForCreate", "code", "What behavior a server will exhibit if the previous state of a resource does NOT exist (e.g., during a CREATE).", 0, 1, this.resultForCreate));
            children.add(new Property("current", "string", "The FHIR query based rules are applied to the current resource state.", 0, 1, this.current));
            children.add(new Property("resultForDelete", "code", "What behavior a server will exhibit if the current state of a resource does NOT exist (e.g., during a DELETE).", 0, 1, this.resultForDelete));
            children.add(new Property("requireBoth", "boolean", "If set to true, both current and previous criteria must evaluate true to  trigger a notification for this topic.  Otherwise a notification for this topic will be triggered if either one evaluates to true.", 0, 1, this.requireBoth));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1273775369: {
                    return new Property("previous", "string", "The FHIR query based rules are applied to the previous resource state.", 0, 1, this.previous);
                }
                case -407976056: {
                    return new Property("resultForCreate", "code", "What behavior a server will exhibit if the previous state of a resource does NOT exist (e.g., during a CREATE).", 0, 1, this.resultForCreate);
                }
                case 1126940025: {
                    return new Property("current", "string", "The FHIR query based rules are applied to the current resource state.", 0, 1, this.current);
                }
                case -391140297: {
                    return new Property("resultForDelete", "code", "What behavior a server will exhibit if the current state of a resource does NOT exist (e.g., during a DELETE).", 0, 1, this.resultForDelete);
                }
                case 362116742: {
                    return new Property("requireBoth", "boolean", "If set to true, both current and previous criteria must evaluate true to  trigger a notification for this topic.  Otherwise a notification for this topic will be triggered if either one evaluates to true.", 0, 1, this.requireBoth);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1273775369: {
                    Base[] baseArray;
                    if (this.previous == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.previous;
                    }
                    return baseArray;
                }
                case -407976056: {
                    Base[] baseArray;
                    if (this.resultForCreate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.resultForCreate;
                    }
                    return baseArray;
                }
                case 1126940025: {
                    Base[] baseArray;
                    if (this.current == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.current;
                    }
                    return baseArray;
                }
                case -391140297: {
                    Base[] baseArray;
                    if (this.resultForDelete == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.resultForDelete;
                    }
                    return baseArray;
                }
                case 362116742: {
                    Base[] baseArray;
                    if (this.requireBoth == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.requireBoth;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1273775369: {
                    this.previous = TypeConvertor.castToString(value);
                    return value;
                }
                case -407976056: {
                    value = new CriteriaNotExistsBehaviorEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.resultForCreate = value;
                    return value;
                }
                case 1126940025: {
                    this.current = TypeConvertor.castToString(value);
                    return value;
                }
                case -391140297: {
                    value = new CriteriaNotExistsBehaviorEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.resultForDelete = value;
                    return value;
                }
                case 362116742: {
                    this.requireBoth = TypeConvertor.castToBoolean(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("previous")) {
                this.previous = TypeConvertor.castToString(value);
            } else if (name.equals("resultForCreate")) {
                value = new CriteriaNotExistsBehaviorEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.resultForCreate = value;
            } else if (name.equals("current")) {
                this.current = TypeConvertor.castToString(value);
            } else if (name.equals("resultForDelete")) {
                value = new CriteriaNotExistsBehaviorEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.resultForDelete = value;
            } else if (name.equals("requireBoth")) {
                this.requireBoth = TypeConvertor.castToBoolean(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1273775369: {
                    return this.getPreviousElement();
                }
                case -407976056: {
                    return this.getResultForCreateElement();
                }
                case 1126940025: {
                    return this.getCurrentElement();
                }
                case -391140297: {
                    return this.getResultForDeleteElement();
                }
                case 362116742: {
                    return this.getRequireBothElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1273775369: {
                    return new String[]{"string"};
                }
                case -407976056: {
                    return new String[]{"code"};
                }
                case 1126940025: {
                    return new String[]{"string"};
                }
                case -391140297: {
                    return new String[]{"code"};
                }
                case 362116742: {
                    return new String[]{"boolean"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("previous")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.resourceTrigger.queryCriteria.previous");
            }
            if (name.equals("resultForCreate")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.resourceTrigger.queryCriteria.resultForCreate");
            }
            if (name.equals("current")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.resourceTrigger.queryCriteria.current");
            }
            if (name.equals("resultForDelete")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.resourceTrigger.queryCriteria.resultForDelete");
            }
            if (name.equals("requireBoth")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.resourceTrigger.queryCriteria.requireBoth");
            }
            return super.addChild(name);
        }

        @Override
        public SubscriptionTopicResourceTriggerQueryCriteriaComponent copy() {
            SubscriptionTopicResourceTriggerQueryCriteriaComponent dst = new SubscriptionTopicResourceTriggerQueryCriteriaComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubscriptionTopicResourceTriggerQueryCriteriaComponent dst) {
            super.copyValues(dst);
            dst.previous = this.previous == null ? null : this.previous.copy();
            dst.resultForCreate = this.resultForCreate == null ? null : this.resultForCreate.copy();
            dst.current = this.current == null ? null : this.current.copy();
            dst.resultForDelete = this.resultForDelete == null ? null : this.resultForDelete.copy();
            dst.requireBoth = this.requireBoth == null ? null : this.requireBoth.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubscriptionTopicResourceTriggerQueryCriteriaComponent)) {
                return false;
            }
            SubscriptionTopicResourceTriggerQueryCriteriaComponent o = (SubscriptionTopicResourceTriggerQueryCriteriaComponent)other_;
            return SubscriptionTopicResourceTriggerQueryCriteriaComponent.compareDeep(this.previous, o.previous, true) && SubscriptionTopicResourceTriggerQueryCriteriaComponent.compareDeep(this.resultForCreate, o.resultForCreate, true) && SubscriptionTopicResourceTriggerQueryCriteriaComponent.compareDeep(this.current, o.current, true) && SubscriptionTopicResourceTriggerQueryCriteriaComponent.compareDeep(this.resultForDelete, o.resultForDelete, true) && SubscriptionTopicResourceTriggerQueryCriteriaComponent.compareDeep(this.requireBoth, o.requireBoth, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubscriptionTopicResourceTriggerQueryCriteriaComponent)) {
                return false;
            }
            SubscriptionTopicResourceTriggerQueryCriteriaComponent o = (SubscriptionTopicResourceTriggerQueryCriteriaComponent)other_;
            return SubscriptionTopicResourceTriggerQueryCriteriaComponent.compareValues(this.previous, o.previous, true) && SubscriptionTopicResourceTriggerQueryCriteriaComponent.compareValues(this.resultForCreate, o.resultForCreate, true) && SubscriptionTopicResourceTriggerQueryCriteriaComponent.compareValues(this.current, o.current, true) && SubscriptionTopicResourceTriggerQueryCriteriaComponent.compareValues(this.resultForDelete, o.resultForDelete, true) && SubscriptionTopicResourceTriggerQueryCriteriaComponent.compareValues(this.requireBoth, o.requireBoth, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.previous, this.resultForCreate, this.current, this.resultForDelete, this.requireBoth});
        }

        @Override
        public String fhirType() {
            return "SubscriptionTopic.resourceTrigger.queryCriteria";
        }
    }

    @Block
    public static class SubscriptionTopicResourceTriggerComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Text representation of the trigger", formalDefinition="The human readable description of what triggers inclusion into this subscription topic -  for example, \"Beginning of a clinical encounter\".")
        protected StringType description;
        @Child(name="resourceType", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Allowed Data type or Resource (reference to definition) for this definition", formalDefinition="URL of the Resource that is the type used in this trigger.  Relative URLs are relative to the StructureDefinition root of the implemented FHIR version (e.g., http://hl7.org/fhir/StructureDefinition). For example, \"Patient\" maps to http://hl7.org/fhir/StructureDefinition/Patient.  For more information, see <a href=\"elementdefinition-definitions.html#ElementDefinition.type.code\">ElementDefinition.type.code</a>.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/defined-types")
        protected UriType resourceType;
        @Child(name="methodCriteria", type={CodeType.class}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="create | update | delete", formalDefinition="The REST interaction based rules that the server should use to determine when to trigger a notification for this topic.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/interaction-trigger")
        protected List<Enumeration<InteractionTrigger>> methodCriteria;
        @Child(name="queryCriteria", type={}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Query based trigger rule", formalDefinition="The FHIR query based rules that the server should use to determine when to trigger a notification for this subscription topic.")
        protected SubscriptionTopicResourceTriggerQueryCriteriaComponent queryCriteria;
        @Child(name="fhirPathCriteria", type={StringType.class}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="FHIRPath based trigger rule", formalDefinition="The FHIRPath based rules that the server should use to determine when to trigger a notification for this topic.  If there are multiple, FHIRPath filters are joined with AND.")
        protected List<StringType> fhirPathCriteria;
        @Child(name="canFilterBy", type={}, order=6, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Properties by which a Subscription can further filter a SubscriptionTopic", formalDefinition="List of properties by which Subscriptions on the subscription topic can be filtered.")
        protected List<SubscriptionTopicResourceTriggerCanFilterByComponent> canFilterBy;
        private static final long serialVersionUID = 111786998L;

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionTopicResourceTriggerComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public SubscriptionTopicResourceTriggerComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public SubscriptionTopicResourceTriggerComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public UriType getResourceTypeElement() {
            if (this.resourceType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionTopicResourceTriggerComponent.resourceType");
                }
                if (Configuration.doAutoCreate()) {
                    this.resourceType = new UriType();
                }
            }
            return this.resourceType;
        }

        public boolean hasResourceTypeElement() {
            return this.resourceType != null && !this.resourceType.isEmpty();
        }

        public boolean hasResourceType() {
            return this.resourceType != null && !this.resourceType.isEmpty();
        }

        public SubscriptionTopicResourceTriggerComponent setResourceTypeElement(UriType value) {
            this.resourceType = value;
            return this;
        }

        public String getResourceType() {
            return this.resourceType == null ? null : (String)this.resourceType.getValue();
        }

        public SubscriptionTopicResourceTriggerComponent setResourceType(String value) {
            if (Utilities.noString((String)value)) {
                this.resourceType = null;
            } else {
                if (this.resourceType == null) {
                    this.resourceType = new UriType();
                }
                this.resourceType.setValue(value);
            }
            return this;
        }

        public List<Enumeration<InteractionTrigger>> getMethodCriteria() {
            if (this.methodCriteria == null) {
                this.methodCriteria = new ArrayList<Enumeration<InteractionTrigger>>();
            }
            return this.methodCriteria;
        }

        public SubscriptionTopicResourceTriggerComponent setMethodCriteria(List<Enumeration<InteractionTrigger>> theMethodCriteria) {
            this.methodCriteria = theMethodCriteria;
            return this;
        }

        public boolean hasMethodCriteria() {
            if (this.methodCriteria == null) {
                return false;
            }
            for (Enumeration<InteractionTrigger> item : this.methodCriteria) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Enumeration<InteractionTrigger> addMethodCriteriaElement() {
            Enumeration<InteractionTrigger> t = new Enumeration<InteractionTrigger>(new InteractionTriggerEnumFactory());
            if (this.methodCriteria == null) {
                this.methodCriteria = new ArrayList<Enumeration<InteractionTrigger>>();
            }
            this.methodCriteria.add(t);
            return t;
        }

        public SubscriptionTopicResourceTriggerComponent addMethodCriteria(InteractionTrigger value) {
            Enumeration<InteractionTrigger> t = new Enumeration<InteractionTrigger>(new InteractionTriggerEnumFactory());
            t.setValue((Object)value);
            if (this.methodCriteria == null) {
                this.methodCriteria = new ArrayList<Enumeration<InteractionTrigger>>();
            }
            this.methodCriteria.add(t);
            return this;
        }

        public boolean hasMethodCriteria(InteractionTrigger value) {
            if (this.methodCriteria == null) {
                return false;
            }
            for (Enumeration<InteractionTrigger> v : this.methodCriteria) {
                if (!((InteractionTrigger)((Object)v.getValue())).equals((Object)value)) continue;
                return true;
            }
            return false;
        }

        public SubscriptionTopicResourceTriggerQueryCriteriaComponent getQueryCriteria() {
            if (this.queryCriteria == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionTopicResourceTriggerComponent.queryCriteria");
                }
                if (Configuration.doAutoCreate()) {
                    this.queryCriteria = new SubscriptionTopicResourceTriggerQueryCriteriaComponent();
                }
            }
            return this.queryCriteria;
        }

        public boolean hasQueryCriteria() {
            return this.queryCriteria != null && !this.queryCriteria.isEmpty();
        }

        public SubscriptionTopicResourceTriggerComponent setQueryCriteria(SubscriptionTopicResourceTriggerQueryCriteriaComponent value) {
            this.queryCriteria = value;
            return this;
        }

        public List<StringType> getFhirPathCriteria() {
            if (this.fhirPathCriteria == null) {
                this.fhirPathCriteria = new ArrayList<StringType>();
            }
            return this.fhirPathCriteria;
        }

        public SubscriptionTopicResourceTriggerComponent setFhirPathCriteria(List<StringType> theFhirPathCriteria) {
            this.fhirPathCriteria = theFhirPathCriteria;
            return this;
        }

        public boolean hasFhirPathCriteria() {
            if (this.fhirPathCriteria == null) {
                return false;
            }
            for (StringType item : this.fhirPathCriteria) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addFhirPathCriteriaElement() {
            StringType t = new StringType();
            if (this.fhirPathCriteria == null) {
                this.fhirPathCriteria = new ArrayList<StringType>();
            }
            this.fhirPathCriteria.add(t);
            return t;
        }

        public SubscriptionTopicResourceTriggerComponent addFhirPathCriteria(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.fhirPathCriteria == null) {
                this.fhirPathCriteria = new ArrayList<StringType>();
            }
            this.fhirPathCriteria.add(t);
            return this;
        }

        public boolean hasFhirPathCriteria(String value) {
            if (this.fhirPathCriteria == null) {
                return false;
            }
            for (StringType v : this.fhirPathCriteria) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<SubscriptionTopicResourceTriggerCanFilterByComponent> getCanFilterBy() {
            if (this.canFilterBy == null) {
                this.canFilterBy = new ArrayList<SubscriptionTopicResourceTriggerCanFilterByComponent>();
            }
            return this.canFilterBy;
        }

        public SubscriptionTopicResourceTriggerComponent setCanFilterBy(List<SubscriptionTopicResourceTriggerCanFilterByComponent> theCanFilterBy) {
            this.canFilterBy = theCanFilterBy;
            return this;
        }

        public boolean hasCanFilterBy() {
            if (this.canFilterBy == null) {
                return false;
            }
            for (SubscriptionTopicResourceTriggerCanFilterByComponent item : this.canFilterBy) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SubscriptionTopicResourceTriggerCanFilterByComponent addCanFilterBy() {
            SubscriptionTopicResourceTriggerCanFilterByComponent t = new SubscriptionTopicResourceTriggerCanFilterByComponent();
            if (this.canFilterBy == null) {
                this.canFilterBy = new ArrayList<SubscriptionTopicResourceTriggerCanFilterByComponent>();
            }
            this.canFilterBy.add(t);
            return t;
        }

        public SubscriptionTopicResourceTriggerComponent addCanFilterBy(SubscriptionTopicResourceTriggerCanFilterByComponent t) {
            if (t == null) {
                return this;
            }
            if (this.canFilterBy == null) {
                this.canFilterBy = new ArrayList<SubscriptionTopicResourceTriggerCanFilterByComponent>();
            }
            this.canFilterBy.add(t);
            return this;
        }

        public SubscriptionTopicResourceTriggerCanFilterByComponent getCanFilterByFirstRep() {
            if (this.getCanFilterBy().isEmpty()) {
                this.addCanFilterBy();
            }
            return this.getCanFilterBy().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("description", "string", "The human readable description of what triggers inclusion into this subscription topic -  for example, \"Beginning of a clinical encounter\".", 0, 1, this.description));
            children.add(new Property("resourceType", "uri", "URL of the Resource that is the type used in this trigger.  Relative URLs are relative to the StructureDefinition root of the implemented FHIR version (e.g., http://hl7.org/fhir/StructureDefinition). For example, \"Patient\" maps to http://hl7.org/fhir/StructureDefinition/Patient.  For more information, see <a href=\"elementdefinition-definitions.html#ElementDefinition.type.code\">ElementDefinition.type.code</a>.", 0, 1, this.resourceType));
            children.add(new Property("methodCriteria", "code", "The REST interaction based rules that the server should use to determine when to trigger a notification for this topic.", 0, Integer.MAX_VALUE, this.methodCriteria));
            children.add(new Property("queryCriteria", "", "The FHIR query based rules that the server should use to determine when to trigger a notification for this subscription topic.", 0, 1, this.queryCriteria));
            children.add(new Property("fhirPathCriteria", "string", "The FHIRPath based rules that the server should use to determine when to trigger a notification for this topic.  If there are multiple, FHIRPath filters are joined with AND.", 0, Integer.MAX_VALUE, this.fhirPathCriteria));
            children.add(new Property("canFilterBy", "", "List of properties by which Subscriptions on the subscription topic can be filtered.", 0, Integer.MAX_VALUE, this.canFilterBy));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property("description", "string", "The human readable description of what triggers inclusion into this subscription topic -  for example, \"Beginning of a clinical encounter\".", 0, 1, this.description);
                }
                case -384364440: {
                    return new Property("resourceType", "uri", "URL of the Resource that is the type used in this trigger.  Relative URLs are relative to the StructureDefinition root of the implemented FHIR version (e.g., http://hl7.org/fhir/StructureDefinition). For example, \"Patient\" maps to http://hl7.org/fhir/StructureDefinition/Patient.  For more information, see <a href=\"elementdefinition-definitions.html#ElementDefinition.type.code\">ElementDefinition.type.code</a>.", 0, 1, this.resourceType);
                }
                case -1924160672: {
                    return new Property("methodCriteria", "code", "The REST interaction based rules that the server should use to determine when to trigger a notification for this topic.", 0, Integer.MAX_VALUE, this.methodCriteria);
                }
                case -545123257: {
                    return new Property("queryCriteria", "", "The FHIR query based rules that the server should use to determine when to trigger a notification for this subscription topic.", 0, 1, this.queryCriteria);
                }
                case 1929785263: {
                    return new Property("fhirPathCriteria", "string", "The FHIRPath based rules that the server should use to determine when to trigger a notification for this topic.  If there are multiple, FHIRPath filters are joined with AND.", 0, Integer.MAX_VALUE, this.fhirPathCriteria);
                }
                case -1299519009: {
                    return new Property("canFilterBy", "", "List of properties by which Subscriptions on the subscription topic can be filtered.", 0, Integer.MAX_VALUE, this.canFilterBy);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case -384364440: {
                    Base[] baseArray;
                    if (this.resourceType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.resourceType;
                    }
                    return baseArray;
                }
                case -1924160672: {
                    return this.methodCriteria == null ? new Base[]{} : this.methodCriteria.toArray(new Base[this.methodCriteria.size()]);
                }
                case -545123257: {
                    Base[] baseArray;
                    if (this.queryCriteria == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.queryCriteria;
                    }
                    return baseArray;
                }
                case 1929785263: {
                    return this.fhirPathCriteria == null ? new Base[]{} : this.fhirPathCriteria.toArray(new Base[this.fhirPathCriteria.size()]);
                }
                case -1299519009: {
                    return this.canFilterBy == null ? new Base[]{} : this.canFilterBy.toArray(new Base[this.canFilterBy.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case -384364440: {
                    this.resourceType = TypeConvertor.castToUri(value);
                    return value;
                }
                case -1924160672: {
                    value = new InteractionTriggerEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.getMethodCriteria().add(value);
                    return value;
                }
                case -545123257: {
                    this.queryCriteria = (SubscriptionTopicResourceTriggerQueryCriteriaComponent)((Object)value);
                    return value;
                }
                case 1929785263: {
                    this.getFhirPathCriteria().add(TypeConvertor.castToString(value));
                    return value;
                }
                case -1299519009: {
                    this.getCanFilterBy().add((SubscriptionTopicResourceTriggerCanFilterByComponent)((Object)value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("description")) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals("resourceType")) {
                this.resourceType = TypeConvertor.castToUri(value);
            } else if (name.equals("methodCriteria")) {
                value = new InteractionTriggerEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.getMethodCriteria().add(value);
            } else if (name.equals("queryCriteria")) {
                this.queryCriteria = (SubscriptionTopicResourceTriggerQueryCriteriaComponent)((Object)value);
            } else if (name.equals("fhirPathCriteria")) {
                this.getFhirPathCriteria().add(TypeConvertor.castToString(value));
            } else if (name.equals("canFilterBy")) {
                this.getCanFilterBy().add((SubscriptionTopicResourceTriggerCanFilterByComponent)((Object)value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -384364440: {
                    return this.getResourceTypeElement();
                }
                case -1924160672: {
                    return this.addMethodCriteriaElement();
                }
                case -545123257: {
                    return this.getQueryCriteria();
                }
                case 1929785263: {
                    return this.addFhirPathCriteriaElement();
                }
                case -1299519009: {
                    return this.addCanFilterBy();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"string"};
                }
                case -384364440: {
                    return new String[]{"uri"};
                }
                case -1924160672: {
                    return new String[]{"code"};
                }
                case -545123257: {
                    return new String[0];
                }
                case 1929785263: {
                    return new String[]{"string"};
                }
                case -1299519009: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.resourceTrigger.description");
            }
            if (name.equals("resourceType")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.resourceTrigger.resourceType");
            }
            if (name.equals("methodCriteria")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.resourceTrigger.methodCriteria");
            }
            if (name.equals("queryCriteria")) {
                this.queryCriteria = new SubscriptionTopicResourceTriggerQueryCriteriaComponent();
                return this.queryCriteria;
            }
            if (name.equals("fhirPathCriteria")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.resourceTrigger.fhirPathCriteria");
            }
            if (name.equals("canFilterBy")) {
                return this.addCanFilterBy();
            }
            return super.addChild(name);
        }

        @Override
        public SubscriptionTopicResourceTriggerComponent copy() {
            SubscriptionTopicResourceTriggerComponent dst = new SubscriptionTopicResourceTriggerComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubscriptionTopicResourceTriggerComponent dst) {
            super.copyValues(dst);
            dst.description = this.description == null ? null : this.description.copy();
            UriType uriType = dst.resourceType = this.resourceType == null ? null : this.resourceType.copy();
            if (this.methodCriteria != null) {
                dst.methodCriteria = new ArrayList<Enumeration<InteractionTrigger>>();
                for (Enumeration<InteractionTrigger> enumeration : this.methodCriteria) {
                    dst.methodCriteria.add((Enumeration<InteractionTrigger>)enumeration.copy());
                }
            }
            SubscriptionTopicResourceTriggerQueryCriteriaComponent subscriptionTopicResourceTriggerQueryCriteriaComponent = dst.queryCriteria = this.queryCriteria == null ? null : this.queryCriteria.copy();
            if (this.fhirPathCriteria != null) {
                dst.fhirPathCriteria = new ArrayList<StringType>();
                for (StringType stringType : this.fhirPathCriteria) {
                    dst.fhirPathCriteria.add(stringType.copy());
                }
            }
            if (this.canFilterBy != null) {
                dst.canFilterBy = new ArrayList<SubscriptionTopicResourceTriggerCanFilterByComponent>();
                for (SubscriptionTopicResourceTriggerCanFilterByComponent subscriptionTopicResourceTriggerCanFilterByComponent : this.canFilterBy) {
                    dst.canFilterBy.add(subscriptionTopicResourceTriggerCanFilterByComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubscriptionTopicResourceTriggerComponent)) {
                return false;
            }
            SubscriptionTopicResourceTriggerComponent o = (SubscriptionTopicResourceTriggerComponent)other_;
            return SubscriptionTopicResourceTriggerComponent.compareDeep(this.description, o.description, true) && SubscriptionTopicResourceTriggerComponent.compareDeep(this.resourceType, o.resourceType, true) && SubscriptionTopicResourceTriggerComponent.compareDeep(this.methodCriteria, o.methodCriteria, true) && SubscriptionTopicResourceTriggerComponent.compareDeep(this.queryCriteria, o.queryCriteria, true) && SubscriptionTopicResourceTriggerComponent.compareDeep(this.fhirPathCriteria, o.fhirPathCriteria, true) && SubscriptionTopicResourceTriggerComponent.compareDeep(this.canFilterBy, o.canFilterBy, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubscriptionTopicResourceTriggerComponent)) {
                return false;
            }
            SubscriptionTopicResourceTriggerComponent o = (SubscriptionTopicResourceTriggerComponent)other_;
            return SubscriptionTopicResourceTriggerComponent.compareValues(this.description, o.description, true) && SubscriptionTopicResourceTriggerComponent.compareValues(this.resourceType, o.resourceType, true) && SubscriptionTopicResourceTriggerComponent.compareValues(this.methodCriteria, o.methodCriteria, true) && SubscriptionTopicResourceTriggerComponent.compareValues(this.fhirPathCriteria, o.fhirPathCriteria, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.description, this.resourceType, this.methodCriteria, this.queryCriteria, this.fhirPathCriteria, this.canFilterBy});
        }

        @Override
        public String fhirType() {
            return "SubscriptionTopic.resourceTrigger";
        }
    }

    public static class InteractionTriggerEnumFactory
    implements EnumFactory<InteractionTrigger> {
        @Override
        public InteractionTrigger fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("create".equals(codeString)) {
                return InteractionTrigger.CREATE;
            }
            if ("update".equals(codeString)) {
                return InteractionTrigger.UPDATE;
            }
            if ("delete".equals(codeString)) {
                return InteractionTrigger.DELETE;
            }
            throw new IllegalArgumentException("Unknown InteractionTrigger code '" + codeString + "'");
        }

        public Enumeration<InteractionTrigger> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<InteractionTrigger>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("create".equals(codeString)) {
                return new Enumeration<InteractionTrigger>(this, InteractionTrigger.CREATE);
            }
            if ("update".equals(codeString)) {
                return new Enumeration<InteractionTrigger>(this, InteractionTrigger.UPDATE);
            }
            if ("delete".equals(codeString)) {
                return new Enumeration<InteractionTrigger>(this, InteractionTrigger.DELETE);
            }
            throw new FHIRException("Unknown InteractionTrigger code '" + codeString + "'");
        }

        @Override
        public String toCode(InteractionTrigger code) {
            if (code == InteractionTrigger.CREATE) {
                return "create";
            }
            if (code == InteractionTrigger.UPDATE) {
                return "update";
            }
            if (code == InteractionTrigger.DELETE) {
                return "delete";
            }
            return "?";
        }

        @Override
        public String toSystem(InteractionTrigger code) {
            return code.getSystem();
        }
    }

    public static enum InteractionTrigger {
        CREATE,
        UPDATE,
        DELETE,
        NULL;


        public static InteractionTrigger fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("create".equals(codeString)) {
                return CREATE;
            }
            if ("update".equals(codeString)) {
                return UPDATE;
            }
            if ("delete".equals(codeString)) {
                return DELETE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown InteractionTrigger code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case CREATE: {
                    return "create";
                }
                case UPDATE: {
                    return "update";
                }
                case DELETE: {
                    return "delete";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case CREATE: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
                case UPDATE: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
                case DELETE: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case CREATE: {
                    return "Create a new resource with a server assigned id.";
                }
                case UPDATE: {
                    return "Update an existing resource by its id (or create it if it is new).";
                }
                case DELETE: {
                    return "Delete a resource.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case CREATE: {
                    return "create";
                }
                case UPDATE: {
                    return "update";
                }
                case DELETE: {
                    return "delete";
                }
            }
            return "?";
        }
    }

    public static class CriteriaNotExistsBehaviorEnumFactory
    implements EnumFactory<CriteriaNotExistsBehavior> {
        @Override
        public CriteriaNotExistsBehavior fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("test-passes".equals(codeString)) {
                return CriteriaNotExistsBehavior.TESTPASSES;
            }
            if ("test-fails".equals(codeString)) {
                return CriteriaNotExistsBehavior.TESTFAILS;
            }
            throw new IllegalArgumentException("Unknown CriteriaNotExistsBehavior code '" + codeString + "'");
        }

        public Enumeration<CriteriaNotExistsBehavior> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<CriteriaNotExistsBehavior>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("test-passes".equals(codeString)) {
                return new Enumeration<CriteriaNotExistsBehavior>(this, CriteriaNotExistsBehavior.TESTPASSES);
            }
            if ("test-fails".equals(codeString)) {
                return new Enumeration<CriteriaNotExistsBehavior>(this, CriteriaNotExistsBehavior.TESTFAILS);
            }
            throw new FHIRException("Unknown CriteriaNotExistsBehavior code '" + codeString + "'");
        }

        @Override
        public String toCode(CriteriaNotExistsBehavior code) {
            if (code == CriteriaNotExistsBehavior.TESTPASSES) {
                return "test-passes";
            }
            if (code == CriteriaNotExistsBehavior.TESTFAILS) {
                return "test-fails";
            }
            return "?";
        }

        @Override
        public String toSystem(CriteriaNotExistsBehavior code) {
            return code.getSystem();
        }
    }

    public static enum CriteriaNotExistsBehavior {
        TESTPASSES,
        TESTFAILS,
        NULL;


        public static CriteriaNotExistsBehavior fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("test-passes".equals(codeString)) {
                return TESTPASSES;
            }
            if ("test-fails".equals(codeString)) {
                return TESTFAILS;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown CriteriaNotExistsBehavior code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case TESTPASSES: {
                    return "test-passes";
                }
                case TESTFAILS: {
                    return "test-fails";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case TESTPASSES: {
                    return "http://hl7.org/fhir/subscriptiontopic-cr-behavior";
                }
                case TESTFAILS: {
                    return "http://hl7.org/fhir/subscriptiontopic-cr-behavior";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case TESTPASSES: {
                    return "The requested conditional statement will pass if a matching state does not exist (e.g., previous state during create).";
                }
                case TESTFAILS: {
                    return "The requested conditional statement will fail if a matching state does not exist (e.g., previous state during create).";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case TESTPASSES: {
                    return "test passes";
                }
                case TESTFAILS: {
                    return "test fails";
                }
            }
            return "?";
        }
    }
}

