/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Appointment;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.PositiveIntType;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="AppointmentResponse", profile="http://hl7.org/fhir/StructureDefinition/AppointmentResponse")
public class AppointmentResponse
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External Ids for this item", formalDefinition="This records identifiers associated with this appointment response concern that are defined by business processes and/ or used to refer to it when a direct URL reference to the resource itself is not appropriate.")
    protected List<Identifier> identifier;
    @Child(name="appointment", type={Appointment.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Appointment this response relates to", formalDefinition="Appointment that this response is replying to.")
    protected Reference appointment;
    @Child(name="proposedNewTime", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Indicator for a counter proposal", formalDefinition="Indicates that the response is proposing a different time that was initially requested.  The new proposed time will be indicated in the start and end properties.")
    protected BooleanType proposedNewTime;
    @Child(name="start", type={InstantType.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Time from appointment, or requested new start time", formalDefinition="Date/Time that the appointment is to take place, or requested new start time.")
    protected InstantType start;
    @Child(name="end", type={InstantType.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Time from appointment, or requested new end time", formalDefinition="This may be either the same as the appointment request to confirm the details of the appointment, or alternately a new time to request a re-negotiation of the end time.")
    protected InstantType end;
    @Child(name="participantType", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Role of participant in the appointment", formalDefinition="Role of participant in the appointment.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-participant-type")
    protected List<CodeableConcept> participantType;
    @Child(name="actor", type={Patient.class, Group.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class, Device.class, HealthcareService.class, Location.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Person(s), Location, HealthcareService, or Device", formalDefinition="A Person, Location, HealthcareService, or Device that is participating in the appointment.")
    protected Reference actor;
    @Child(name="participantStatus", type={CodeType.class}, order=7, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="accepted | declined | tentative | needs-action", formalDefinition="Participation status of the participant. When the status is declined or tentative if the start/end times are different to the appointment, then these times should be interpreted as a requested time change. When the status is accepted, the times can either be the time of the appointment (as a confirmation of the time) or can be empty.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/participationstatus")
    protected Enumeration<Enumerations.ParticipationStatus> participantStatus;
    @Child(name="comment", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Additional comments", formalDefinition="Additional comments about the appointment.")
    protected StringType comment;
    @Child(name="recurring", type={BooleanType.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="This response is for all occurrences in a recurring request", formalDefinition="Indicates that this AppointmentResponse applies to all occurrences in a recurring request.")
    protected BooleanType recurring;
    @Child(name="occurrenceDate", type={DateType.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Original date within a recurring request", formalDefinition="The original date within a recurring request. This could be used in place of the recurrenceId to be more direct (or where the template is provided through the simple list of dates in `Appointment.occurrenceDate`).")
    protected DateType occurrenceDate;
    @Child(name="recurrenceId", type={PositiveIntType.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The recurrence ID of the specific recurring request", formalDefinition="The recurrence ID (sequence number) of the specific appointment when responding to a recurring request.")
    protected PositiveIntType recurrenceId;
    private static final long serialVersionUID = 1970686636L;
    @SearchParamDefinition(name="actor", path="AppointmentResponse.actor", description="The Person, Location/HealthcareService or Device that this appointment response replies for", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Device"), @Compartment(name="Base FHIR compartment definition for Patient"), @Compartment(name="Base FHIR compartment definition for Practitioner"), @Compartment(name="Base FHIR compartment definition for RelatedPerson")}, target={Device.class, Group.class, HealthcareService.class, Location.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_ACTOR = "actor";
    public static final ReferenceClientParam ACTOR = new ReferenceClientParam("actor");
    public static final Include INCLUDE_ACTOR = new Include("AppointmentResponse:actor").toLocked();
    @SearchParamDefinition(name="appointment", path="AppointmentResponse.appointment", description="The appointment that the response is attached to", type="reference", target={Appointment.class})
    public static final String SP_APPOINTMENT = "appointment";
    public static final ReferenceClientParam APPOINTMENT = new ReferenceClientParam("appointment");
    public static final Include INCLUDE_APPOINTMENT = new Include("AppointmentResponse:appointment").toLocked();
    @SearchParamDefinition(name="group", path="AppointmentResponse.actor.where(resolve() is Group)", description="This Response is for this Group", type="reference", target={Group.class})
    public static final String SP_GROUP = "group";
    public static final ReferenceClientParam GROUP = new ReferenceClientParam("group");
    public static final Include INCLUDE_GROUP = new Include("AppointmentResponse:group").toLocked();
    @SearchParamDefinition(name="identifier", path="AppointmentResponse.identifier", description="An Identifier in this appointment response", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="location", path="AppointmentResponse.actor.where(resolve() is Location)", description="This Response is for this Location", type="reference", target={Location.class})
    public static final String SP_LOCATION = "location";
    public static final ReferenceClientParam LOCATION = new ReferenceClientParam("location");
    public static final Include INCLUDE_LOCATION = new Include("AppointmentResponse:location").toLocked();
    @SearchParamDefinition(name="part-status", path="AppointmentResponse.participantStatus", description="The participants acceptance status for this appointment", type="token")
    public static final String SP_PART_STATUS = "part-status";
    public static final TokenClientParam PART_STATUS = new TokenClientParam("part-status");
    @SearchParamDefinition(name="patient", path="AppointmentResponse.actor.where(resolve() is Patient)", description="This Response is for this Patient", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("AppointmentResponse:patient").toLocked();
    @SearchParamDefinition(name="practitioner", path="AppointmentResponse.actor.where(resolve() is Practitioner)", description="This Response is for this Practitioner", type="reference", target={Practitioner.class})
    public static final String SP_PRACTITIONER = "practitioner";
    public static final ReferenceClientParam PRACTITIONER = new ReferenceClientParam("practitioner");
    public static final Include INCLUDE_PRACTITIONER = new Include("AppointmentResponse:practitioner").toLocked();

    public AppointmentResponse() {
    }

    public AppointmentResponse(Reference appointment, Enumerations.ParticipationStatus participantStatus) {
        this.setAppointment(appointment);
        this.setParticipantStatus(participantStatus);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public AppointmentResponse setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public AppointmentResponse addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Reference getAppointment() {
        if (this.appointment == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AppointmentResponse.appointment");
            }
            if (Configuration.doAutoCreate()) {
                this.appointment = new Reference();
            }
        }
        return this.appointment;
    }

    public boolean hasAppointment() {
        return this.appointment != null && !this.appointment.isEmpty();
    }

    public AppointmentResponse setAppointment(Reference value) {
        this.appointment = value;
        return this;
    }

    public BooleanType getProposedNewTimeElement() {
        if (this.proposedNewTime == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AppointmentResponse.proposedNewTime");
            }
            if (Configuration.doAutoCreate()) {
                this.proposedNewTime = new BooleanType();
            }
        }
        return this.proposedNewTime;
    }

    public boolean hasProposedNewTimeElement() {
        return this.proposedNewTime != null && !this.proposedNewTime.isEmpty();
    }

    public boolean hasProposedNewTime() {
        return this.proposedNewTime != null && !this.proposedNewTime.isEmpty();
    }

    public AppointmentResponse setProposedNewTimeElement(BooleanType value) {
        this.proposedNewTime = value;
        return this;
    }

    public boolean getProposedNewTime() {
        return this.proposedNewTime == null || this.proposedNewTime.isEmpty() ? false : (Boolean)this.proposedNewTime.getValue();
    }

    public AppointmentResponse setProposedNewTime(boolean value) {
        if (this.proposedNewTime == null) {
            this.proposedNewTime = new BooleanType();
        }
        this.proposedNewTime.setValue((Object)value);
        return this;
    }

    public InstantType getStartElement() {
        if (this.start == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AppointmentResponse.start");
            }
            if (Configuration.doAutoCreate()) {
                this.start = new InstantType();
            }
        }
        return this.start;
    }

    public boolean hasStartElement() {
        return this.start != null && !this.start.isEmpty();
    }

    public boolean hasStart() {
        return this.start != null && !this.start.isEmpty();
    }

    public AppointmentResponse setStartElement(InstantType value) {
        this.start = value;
        return this;
    }

    public Date getStart() {
        return this.start == null ? null : (Date)this.start.getValue();
    }

    public AppointmentResponse setStart(Date value) {
        if (value == null) {
            this.start = null;
        } else {
            if (this.start == null) {
                this.start = new InstantType();
            }
            this.start.setValue(value);
        }
        return this;
    }

    public InstantType getEndElement() {
        if (this.end == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AppointmentResponse.end");
            }
            if (Configuration.doAutoCreate()) {
                this.end = new InstantType();
            }
        }
        return this.end;
    }

    public boolean hasEndElement() {
        return this.end != null && !this.end.isEmpty();
    }

    public boolean hasEnd() {
        return this.end != null && !this.end.isEmpty();
    }

    public AppointmentResponse setEndElement(InstantType value) {
        this.end = value;
        return this;
    }

    public Date getEnd() {
        return this.end == null ? null : (Date)this.end.getValue();
    }

    public AppointmentResponse setEnd(Date value) {
        if (value == null) {
            this.end = null;
        } else {
            if (this.end == null) {
                this.end = new InstantType();
            }
            this.end.setValue(value);
        }
        return this;
    }

    public List<CodeableConcept> getParticipantType() {
        if (this.participantType == null) {
            this.participantType = new ArrayList<CodeableConcept>();
        }
        return this.participantType;
    }

    public AppointmentResponse setParticipantType(List<CodeableConcept> theParticipantType) {
        this.participantType = theParticipantType;
        return this;
    }

    public boolean hasParticipantType() {
        if (this.participantType == null) {
            return false;
        }
        for (CodeableConcept item : this.participantType) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addParticipantType() {
        CodeableConcept t = new CodeableConcept();
        if (this.participantType == null) {
            this.participantType = new ArrayList<CodeableConcept>();
        }
        this.participantType.add(t);
        return t;
    }

    public AppointmentResponse addParticipantType(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.participantType == null) {
            this.participantType = new ArrayList<CodeableConcept>();
        }
        this.participantType.add(t);
        return this;
    }

    public CodeableConcept getParticipantTypeFirstRep() {
        if (this.getParticipantType().isEmpty()) {
            this.addParticipantType();
        }
        return this.getParticipantType().get(0);
    }

    public Reference getActor() {
        if (this.actor == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AppointmentResponse.actor");
            }
            if (Configuration.doAutoCreate()) {
                this.actor = new Reference();
            }
        }
        return this.actor;
    }

    public boolean hasActor() {
        return this.actor != null && !this.actor.isEmpty();
    }

    public AppointmentResponse setActor(Reference value) {
        this.actor = value;
        return this;
    }

    public Enumeration<Enumerations.ParticipationStatus> getParticipantStatusElement() {
        if (this.participantStatus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AppointmentResponse.participantStatus");
            }
            if (Configuration.doAutoCreate()) {
                this.participantStatus = new Enumeration<Enumerations.ParticipationStatus>(new Enumerations.ParticipationStatusEnumFactory());
            }
        }
        return this.participantStatus;
    }

    public boolean hasParticipantStatusElement() {
        return this.participantStatus != null && !this.participantStatus.isEmpty();
    }

    public boolean hasParticipantStatus() {
        return this.participantStatus != null && !this.participantStatus.isEmpty();
    }

    public AppointmentResponse setParticipantStatusElement(Enumeration<Enumerations.ParticipationStatus> value) {
        this.participantStatus = value;
        return this;
    }

    public Enumerations.ParticipationStatus getParticipantStatus() {
        return this.participantStatus == null ? null : (Enumerations.ParticipationStatus)((Object)this.participantStatus.getValue());
    }

    public AppointmentResponse setParticipantStatus(Enumerations.ParticipationStatus value) {
        if (this.participantStatus == null) {
            this.participantStatus = new Enumeration<Enumerations.ParticipationStatus>(new Enumerations.ParticipationStatusEnumFactory());
        }
        this.participantStatus.setValue((Object)value);
        return this;
    }

    public StringType getCommentElement() {
        if (this.comment == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AppointmentResponse.comment");
            }
            if (Configuration.doAutoCreate()) {
                this.comment = new StringType();
            }
        }
        return this.comment;
    }

    public boolean hasCommentElement() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public boolean hasComment() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public AppointmentResponse setCommentElement(StringType value) {
        this.comment = value;
        return this;
    }

    public String getComment() {
        return this.comment == null ? null : (String)this.comment.getValue();
    }

    public AppointmentResponse setComment(String value) {
        if (Utilities.noString((String)value)) {
            this.comment = null;
        } else {
            if (this.comment == null) {
                this.comment = new StringType();
            }
            this.comment.setValue(value);
        }
        return this;
    }

    public BooleanType getRecurringElement() {
        if (this.recurring == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AppointmentResponse.recurring");
            }
            if (Configuration.doAutoCreate()) {
                this.recurring = new BooleanType();
            }
        }
        return this.recurring;
    }

    public boolean hasRecurringElement() {
        return this.recurring != null && !this.recurring.isEmpty();
    }

    public boolean hasRecurring() {
        return this.recurring != null && !this.recurring.isEmpty();
    }

    public AppointmentResponse setRecurringElement(BooleanType value) {
        this.recurring = value;
        return this;
    }

    public boolean getRecurring() {
        return this.recurring == null || this.recurring.isEmpty() ? false : (Boolean)this.recurring.getValue();
    }

    public AppointmentResponse setRecurring(boolean value) {
        if (this.recurring == null) {
            this.recurring = new BooleanType();
        }
        this.recurring.setValue((Object)value);
        return this;
    }

    public DateType getOccurrenceDateElement() {
        if (this.occurrenceDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AppointmentResponse.occurrenceDate");
            }
            if (Configuration.doAutoCreate()) {
                this.occurrenceDate = new DateType();
            }
        }
        return this.occurrenceDate;
    }

    public boolean hasOccurrenceDateElement() {
        return this.occurrenceDate != null && !this.occurrenceDate.isEmpty();
    }

    public boolean hasOccurrenceDate() {
        return this.occurrenceDate != null && !this.occurrenceDate.isEmpty();
    }

    public AppointmentResponse setOccurrenceDateElement(DateType value) {
        this.occurrenceDate = value;
        return this;
    }

    public Date getOccurrenceDate() {
        return this.occurrenceDate == null ? null : (Date)this.occurrenceDate.getValue();
    }

    public AppointmentResponse setOccurrenceDate(Date value) {
        if (value == null) {
            this.occurrenceDate = null;
        } else {
            if (this.occurrenceDate == null) {
                this.occurrenceDate = new DateType();
            }
            this.occurrenceDate.setValue(value);
        }
        return this;
    }

    public PositiveIntType getRecurrenceIdElement() {
        if (this.recurrenceId == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AppointmentResponse.recurrenceId");
            }
            if (Configuration.doAutoCreate()) {
                this.recurrenceId = new PositiveIntType();
            }
        }
        return this.recurrenceId;
    }

    public boolean hasRecurrenceIdElement() {
        return this.recurrenceId != null && !this.recurrenceId.isEmpty();
    }

    public boolean hasRecurrenceId() {
        return this.recurrenceId != null && !this.recurrenceId.isEmpty();
    }

    public AppointmentResponse setRecurrenceIdElement(PositiveIntType value) {
        this.recurrenceId = value;
        return this;
    }

    public int getRecurrenceId() {
        return this.recurrenceId == null || this.recurrenceId.isEmpty() ? 0 : (Integer)this.recurrenceId.getValue();
    }

    public AppointmentResponse setRecurrenceId(int value) {
        if (this.recurrenceId == null) {
            this.recurrenceId = new PositiveIntType();
        }
        this.recurrenceId.setValue((Object)value);
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "This records identifiers associated with this appointment response concern that are defined by business processes and/ or used to refer to it when a direct URL reference to the resource itself is not appropriate.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_APPOINTMENT, "Reference(Appointment)", "Appointment that this response is replying to.", 0, 1, this.appointment));
        children.add(new Property("proposedNewTime", "boolean", "Indicates that the response is proposing a different time that was initially requested.  The new proposed time will be indicated in the start and end properties.", 0, 1, this.proposedNewTime));
        children.add(new Property("start", "instant", "Date/Time that the appointment is to take place, or requested new start time.", 0, 1, this.start));
        children.add(new Property("end", "instant", "This may be either the same as the appointment request to confirm the details of the appointment, or alternately a new time to request a re-negotiation of the end time.", 0, 1, this.end));
        children.add(new Property("participantType", "CodeableConcept", "Role of participant in the appointment.", 0, Integer.MAX_VALUE, this.participantType));
        children.add(new Property(SP_ACTOR, "Reference(Patient|Group|Practitioner|PractitionerRole|RelatedPerson|Device|HealthcareService|Location)", "A Person, Location, HealthcareService, or Device that is participating in the appointment.", 0, 1, this.actor));
        children.add(new Property("participantStatus", "code", "Participation status of the participant. When the status is declined or tentative if the start/end times are different to the appointment, then these times should be interpreted as a requested time change. When the status is accepted, the times can either be the time of the appointment (as a confirmation of the time) or can be empty.", 0, 1, this.participantStatus));
        children.add(new Property("comment", "string", "Additional comments about the appointment.", 0, 1, this.comment));
        children.add(new Property("recurring", "boolean", "Indicates that this AppointmentResponse applies to all occurrences in a recurring request.", 0, 1, this.recurring));
        children.add(new Property("occurrenceDate", "date", "The original date within a recurring request. This could be used in place of the recurrenceId to be more direct (or where the template is provided through the simple list of dates in `Appointment.occurrenceDate`).", 0, 1, this.occurrenceDate));
        children.add(new Property("recurrenceId", "positiveInt", "The recurrence ID (sequence number) of the specific appointment when responding to a recurring request.", 0, 1, this.recurrenceId));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "This records identifiers associated with this appointment response concern that are defined by business processes and/ or used to refer to it when a direct URL reference to the resource itself is not appropriate.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -1474995297: {
                return new Property(SP_APPOINTMENT, "Reference(Appointment)", "Appointment that this response is replying to.", 0, 1, this.appointment);
            }
            case -577024441: {
                return new Property("proposedNewTime", "boolean", "Indicates that the response is proposing a different time that was initially requested.  The new proposed time will be indicated in the start and end properties.", 0, 1, this.proposedNewTime);
            }
            case 109757538: {
                return new Property("start", "instant", "Date/Time that the appointment is to take place, or requested new start time.", 0, 1, this.start);
            }
            case 100571: {
                return new Property("end", "instant", "This may be either the same as the appointment request to confirm the details of the appointment, or alternately a new time to request a re-negotiation of the end time.", 0, 1, this.end);
            }
            case 841294093: {
                return new Property("participantType", "CodeableConcept", "Role of participant in the appointment.", 0, Integer.MAX_VALUE, this.participantType);
            }
            case 92645877: {
                return new Property(SP_ACTOR, "Reference(Patient|Group|Practitioner|PractitionerRole|RelatedPerson|Device|HealthcareService|Location)", "A Person, Location, HealthcareService, or Device that is participating in the appointment.", 0, 1, this.actor);
            }
            case 996096261: {
                return new Property("participantStatus", "code", "Participation status of the participant. When the status is declined or tentative if the start/end times are different to the appointment, then these times should be interpreted as a requested time change. When the status is accepted, the times can either be the time of the appointment (as a confirmation of the time) or can be empty.", 0, 1, this.participantStatus);
            }
            case 950398559: {
                return new Property("comment", "string", "Additional comments about the appointment.", 0, 1, this.comment);
            }
            case 1165749981: {
                return new Property("recurring", "boolean", "Indicates that this AppointmentResponse applies to all occurrences in a recurring request.", 0, 1, this.recurring);
            }
            case 1721761055: {
                return new Property("occurrenceDate", "date", "The original date within a recurring request. This could be used in place of the recurrenceId to be more direct (or where the template is provided through the simple list of dates in `Appointment.occurrenceDate`).", 0, 1, this.occurrenceDate);
            }
            case -362407829: {
                return new Property("recurrenceId", "positiveInt", "The recurrence ID (sequence number) of the specific appointment when responding to a recurring request.", 0, 1, this.recurrenceId);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1474995297: {
                Base[] baseArray;
                if (this.appointment == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.appointment;
                }
                return baseArray;
            }
            case -577024441: {
                Base[] baseArray;
                if (this.proposedNewTime == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.proposedNewTime;
                }
                return baseArray;
            }
            case 109757538: {
                Base[] baseArray;
                if (this.start == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.start;
                }
                return baseArray;
            }
            case 100571: {
                Base[] baseArray;
                if (this.end == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.end;
                }
                return baseArray;
            }
            case 841294093: {
                return this.participantType == null ? new Base[]{} : this.participantType.toArray(new Base[this.participantType.size()]);
            }
            case 92645877: {
                Base[] baseArray;
                if (this.actor == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.actor;
                }
                return baseArray;
            }
            case 996096261: {
                Base[] baseArray;
                if (this.participantStatus == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.participantStatus;
                }
                return baseArray;
            }
            case 950398559: {
                Base[] baseArray;
                if (this.comment == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.comment;
                }
                return baseArray;
            }
            case 1165749981: {
                Base[] baseArray;
                if (this.recurring == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.recurring;
                }
                return baseArray;
            }
            case 1721761055: {
                Base[] baseArray;
                if (this.occurrenceDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.occurrenceDate;
                }
                return baseArray;
            }
            case -362407829: {
                Base[] baseArray;
                if (this.recurrenceId == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.recurrenceId;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -1474995297: {
                this.appointment = TypeConvertor.castToReference(value);
                return value;
            }
            case -577024441: {
                this.proposedNewTime = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 109757538: {
                this.start = TypeConvertor.castToInstant(value);
                return value;
            }
            case 100571: {
                this.end = TypeConvertor.castToInstant(value);
                return value;
            }
            case 841294093: {
                this.getParticipantType().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 92645877: {
                this.actor = TypeConvertor.castToReference(value);
                return value;
            }
            case 996096261: {
                value = new Enumerations.ParticipationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.participantStatus = value;
                return value;
            }
            case 950398559: {
                this.comment = TypeConvertor.castToString(value);
                return value;
            }
            case 1165749981: {
                this.recurring = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 1721761055: {
                this.occurrenceDate = TypeConvertor.castToDate(value);
                return value;
            }
            case -362407829: {
                this.recurrenceId = TypeConvertor.castToPositiveInt(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_APPOINTMENT)) {
            this.appointment = TypeConvertor.castToReference(value);
        } else if (name.equals("proposedNewTime")) {
            this.proposedNewTime = TypeConvertor.castToBoolean(value);
        } else if (name.equals("start")) {
            this.start = TypeConvertor.castToInstant(value);
        } else if (name.equals("end")) {
            this.end = TypeConvertor.castToInstant(value);
        } else if (name.equals("participantType")) {
            this.getParticipantType().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_ACTOR)) {
            this.actor = TypeConvertor.castToReference(value);
        } else if (name.equals("participantStatus")) {
            value = new Enumerations.ParticipationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.participantStatus = value;
        } else if (name.equals("comment")) {
            this.comment = TypeConvertor.castToString(value);
        } else if (name.equals("recurring")) {
            this.recurring = TypeConvertor.castToBoolean(value);
        } else if (name.equals("occurrenceDate")) {
            this.occurrenceDate = TypeConvertor.castToDate(value);
        } else if (name.equals("recurrenceId")) {
            this.recurrenceId = TypeConvertor.castToPositiveInt(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1474995297: {
                return this.getAppointment();
            }
            case -577024441: {
                return this.getProposedNewTimeElement();
            }
            case 109757538: {
                return this.getStartElement();
            }
            case 100571: {
                return this.getEndElement();
            }
            case 841294093: {
                return this.addParticipantType();
            }
            case 92645877: {
                return this.getActor();
            }
            case 996096261: {
                return this.getParticipantStatusElement();
            }
            case 950398559: {
                return this.getCommentElement();
            }
            case 1165749981: {
                return this.getRecurringElement();
            }
            case 1721761055: {
                return this.getOccurrenceDateElement();
            }
            case -362407829: {
                return this.getRecurrenceIdElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -1474995297: {
                return new String[]{"Reference"};
            }
            case -577024441: {
                return new String[]{"boolean"};
            }
            case 109757538: {
                return new String[]{"instant"};
            }
            case 100571: {
                return new String[]{"instant"};
            }
            case 841294093: {
                return new String[]{"CodeableConcept"};
            }
            case 92645877: {
                return new String[]{"Reference"};
            }
            case 996096261: {
                return new String[]{"code"};
            }
            case 950398559: {
                return new String[]{"string"};
            }
            case 1165749981: {
                return new String[]{"boolean"};
            }
            case 1721761055: {
                return new String[]{"date"};
            }
            case -362407829: {
                return new String[]{"positiveInt"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_APPOINTMENT)) {
            this.appointment = new Reference();
            return this.appointment;
        }
        if (name.equals("proposedNewTime")) {
            throw new FHIRException("Cannot call addChild on a primitive type AppointmentResponse.proposedNewTime");
        }
        if (name.equals("start")) {
            throw new FHIRException("Cannot call addChild on a primitive type AppointmentResponse.start");
        }
        if (name.equals("end")) {
            throw new FHIRException("Cannot call addChild on a primitive type AppointmentResponse.end");
        }
        if (name.equals("participantType")) {
            return this.addParticipantType();
        }
        if (name.equals(SP_ACTOR)) {
            this.actor = new Reference();
            return this.actor;
        }
        if (name.equals("participantStatus")) {
            throw new FHIRException("Cannot call addChild on a primitive type AppointmentResponse.participantStatus");
        }
        if (name.equals("comment")) {
            throw new FHIRException("Cannot call addChild on a primitive type AppointmentResponse.comment");
        }
        if (name.equals("recurring")) {
            throw new FHIRException("Cannot call addChild on a primitive type AppointmentResponse.recurring");
        }
        if (name.equals("occurrenceDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type AppointmentResponse.occurrenceDate");
        }
        if (name.equals("recurrenceId")) {
            throw new FHIRException("Cannot call addChild on a primitive type AppointmentResponse.recurrenceId");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "AppointmentResponse";
    }

    @Override
    public AppointmentResponse copy() {
        AppointmentResponse dst = new AppointmentResponse();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(AppointmentResponse dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.appointment = this.appointment == null ? null : this.appointment.copy();
        dst.proposedNewTime = this.proposedNewTime == null ? null : this.proposedNewTime.copy();
        dst.start = this.start == null ? null : this.start.copy();
        InstantType instantType = dst.end = this.end == null ? null : this.end.copy();
        if (this.participantType != null) {
            dst.participantType = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.participantType) {
                dst.participantType.add(codeableConcept.copy());
            }
        }
        dst.actor = this.actor == null ? null : this.actor.copy();
        dst.participantStatus = this.participantStatus == null ? null : this.participantStatus.copy();
        dst.comment = this.comment == null ? null : this.comment.copy();
        dst.recurring = this.recurring == null ? null : this.recurring.copy();
        dst.occurrenceDate = this.occurrenceDate == null ? null : this.occurrenceDate.copy();
        dst.recurrenceId = this.recurrenceId == null ? null : this.recurrenceId.copy();
    }

    protected AppointmentResponse typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof AppointmentResponse)) {
            return false;
        }
        AppointmentResponse o = (AppointmentResponse)other_;
        return AppointmentResponse.compareDeep(this.identifier, o.identifier, true) && AppointmentResponse.compareDeep(this.appointment, o.appointment, true) && AppointmentResponse.compareDeep(this.proposedNewTime, o.proposedNewTime, true) && AppointmentResponse.compareDeep(this.start, o.start, true) && AppointmentResponse.compareDeep(this.end, o.end, true) && AppointmentResponse.compareDeep(this.participantType, o.participantType, true) && AppointmentResponse.compareDeep(this.actor, o.actor, true) && AppointmentResponse.compareDeep(this.participantStatus, o.participantStatus, true) && AppointmentResponse.compareDeep(this.comment, o.comment, true) && AppointmentResponse.compareDeep(this.recurring, o.recurring, true) && AppointmentResponse.compareDeep(this.occurrenceDate, o.occurrenceDate, true) && AppointmentResponse.compareDeep(this.recurrenceId, o.recurrenceId, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof AppointmentResponse)) {
            return false;
        }
        AppointmentResponse o = (AppointmentResponse)other_;
        return AppointmentResponse.compareValues(this.proposedNewTime, o.proposedNewTime, true) && AppointmentResponse.compareValues(this.start, o.start, true) && AppointmentResponse.compareValues(this.end, o.end, true) && AppointmentResponse.compareValues(this.participantStatus, o.participantStatus, true) && AppointmentResponse.compareValues(this.comment, o.comment, true) && AppointmentResponse.compareValues(this.recurring, o.recurring, true) && AppointmentResponse.compareValues(this.occurrenceDate, o.occurrenceDate, true) && AppointmentResponse.compareValues(this.recurrenceId, o.recurrenceId, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.appointment, this.proposedNewTime, this.start, this.end, this.participantType, this.actor, this.participantStatus, this.comment, this.recurring, this.occurrenceDate, this.recurrenceId});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.AppointmentResponse;
    }
}

