/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.Appointment;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.CommunicationRequest;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DeviceRequest;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Goal;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImmunizationRecommendation;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.Measure;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MedicationRequest;
import org.hl7.fhir.r5.model.NutritionOrder;
import org.hl7.fhir.r5.model.NutritionProduct;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.RequestOrchestration;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.SupplyRequest;
import org.hl7.fhir.r5.model.Task;
import org.hl7.fhir.r5.model.Timing;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.VisionPrescription;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="CarePlan", profile="http://hl7.org/fhir/StructureDefinition/CarePlan")
public class CarePlan
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External Ids for this plan", formalDefinition="Business identifiers assigned to this care plan by the performer or other systems which remain constant as the resource is updated and propagates from server to server.")
    protected List<Identifier> identifier;
    @Child(name="instantiatesCanonical", type={CanonicalType.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Instantiates FHIR protocol or definition", formalDefinition="The URL pointing to a FHIR-defined protocol, guideline, questionnaire or other definition that is adhered to in whole or in part by this CarePlan.")
    protected List<CanonicalType> instantiatesCanonical;
    @Child(name="instantiatesUri", type={UriType.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Instantiates external protocol or definition", formalDefinition="The URL pointing to an externally maintained protocol, guideline, questionnaire or other definition that is adhered to in whole or in part by this CarePlan.")
    protected List<UriType> instantiatesUri;
    @Child(name="basedOn", type={CarePlan.class, ServiceRequest.class, RequestOrchestration.class, NutritionOrder.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Fulfills plan, proposal or order", formalDefinition="A higher-level request resource (i.e. a plan, proposal or order) that is fulfilled in whole or in part by this care plan.")
    protected List<Reference> basedOn;
    @Child(name="replaces", type={CarePlan.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="CarePlan replaced by this CarePlan", formalDefinition="Completed or terminated care plan whose function is taken by this new care plan.")
    protected List<Reference> replaces;
    @Child(name="partOf", type={CarePlan.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Part of referenced CarePlan", formalDefinition="A larger care plan of which this particular care plan is a component or step.")
    protected List<Reference> partOf;
    @Child(name="status", type={CodeType.class}, order=6, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | on-hold | revoked | completed | entered-in-error | unknown", formalDefinition="Indicates whether the plan is currently being acted upon, represents future intentions or is now a historical record.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/request-status")
    protected Enumeration<Enumerations.RequestStatus> status;
    @Child(name="intent", type={CodeType.class}, order=7, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="proposal | plan | order | option | directive", formalDefinition="Indicates the level of authority/intentionality associated with the care plan and where the care plan fits into the workflow chain.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/care-plan-intent")
    protected Enumeration<CarePlanIntent> intent;
    @Child(name="category", type={CodeableConcept.class}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Type of plan", formalDefinition="Identifies what \"kind\" of plan this is to support differentiation between multiple co-existing plans; e.g. \"Home health\", \"psychiatric\", \"asthma\", \"disease management\", \"wellness plan\", etc.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/care-plan-category")
    protected List<CodeableConcept> category;
    @Child(name="title", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Human-friendly name for the care plan", formalDefinition="Human-friendly name for the care plan.")
    protected StringType title;
    @Child(name="description", type={StringType.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Summary of nature of plan", formalDefinition="A description of the scope and nature of the plan.")
    protected StringType description;
    @Child(name="subject", type={Patient.class, Group.class}, order=11, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who the care plan is for", formalDefinition="Identifies the patient or group whose intended care is described by the plan.")
    protected Reference subject;
    @Child(name="encounter", type={Encounter.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The Encounter during which this CarePlan was created", formalDefinition="The Encounter during which this CarePlan was created or to which the creation of this record is tightly associated.")
    protected Reference encounter;
    @Child(name="period", type={Period.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Time period plan covers", formalDefinition="Indicates when the plan did (or is intended to) come into effect and end.")
    protected Period period;
    @Child(name="created", type={DateTimeType.class}, order=14, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date record was first recorded", formalDefinition="Represents when this particular CarePlan record was created in the system, which is often a system-generated date.")
    protected DateTimeType created;
    @Child(name="custodian", type={Patient.class, Practitioner.class, PractitionerRole.class, Device.class, RelatedPerson.class, Organization.class, CareTeam.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who is the designated responsible party", formalDefinition="When populated, the custodian is responsible for the care plan. The care plan is attributed to the custodian.")
    protected Reference custodian;
    @Child(name="contributor", type={Patient.class, Practitioner.class, PractitionerRole.class, Device.class, RelatedPerson.class, Organization.class, CareTeam.class}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who provided the content of the care plan", formalDefinition="Identifies the individual(s), organization or device who provided the contents of the care plan.")
    protected List<Reference> contributor;
    @Child(name="careTeam", type={CareTeam.class}, order=17, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who's involved in plan?", formalDefinition="Identifies all people and organizations who are expected to be involved in the care envisioned by this plan.")
    protected List<Reference> careTeam;
    @Child(name="addresses", type={CodeableReference.class}, order=18, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Health issues this plan addresses", formalDefinition="Identifies the conditions/problems/concerns/diagnoses/etc. whose management and/or mitigation are handled by this plan.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/clinical-findings")
    protected List<CodeableReference> addresses;
    @Child(name="supportingInfo", type={Reference.class}, order=19, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Information considered as part of plan", formalDefinition="Identifies portions of the patient's record that specifically influenced the formation of the plan.  These might include comorbidities, recent procedures, limitations, recent assessments, etc.")
    protected List<Reference> supportingInfo;
    @Child(name="goal", type={Goal.class}, order=20, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Desired outcome of plan", formalDefinition="Describes the intended objective(s) of carrying out the care plan.")
    protected List<Reference> goal;
    @Child(name="activity", type={}, order=21, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Action to occur or has occurred as part of plan", formalDefinition="Identifies an action that has occurred or is a planned action to occur as part of the plan. For example, a medication to be used, lab tests to perform, self-monitoring that has occurred, education etc.")
    protected List<CarePlanActivityComponent> activity;
    @Child(name="note", type={Annotation.class}, order=22, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Comments about the plan", formalDefinition="General notes about the care plan not covered elsewhere.")
    protected List<Annotation> note;
    private static final long serialVersionUID = -700769298L;
    @SearchParamDefinition(name="activity-code", path="CarePlan.activity.plannedActivityDetail.code", description="Detail type of activity", type="token")
    public static final String SP_ACTIVITY_CODE = "activity-code";
    public static final TokenClientParam ACTIVITY_CODE = new TokenClientParam("activity-code");
    @SearchParamDefinition(name="activity-reference", path="CarePlan.activity.plannedActivityReference", description="Activity that is intended to be part of the care plan", type="reference", target={Appointment.class, CommunicationRequest.class, DeviceRequest.class, ImmunizationRecommendation.class, MedicationRequest.class, NutritionOrder.class, RequestOrchestration.class, ServiceRequest.class, SupplyRequest.class, Task.class, VisionPrescription.class})
    public static final String SP_ACTIVITY_REFERENCE = "activity-reference";
    public static final ReferenceClientParam ACTIVITY_REFERENCE = new ReferenceClientParam("activity-reference");
    public static final Include INCLUDE_ACTIVITY_REFERENCE = new Include("CarePlan:activity-reference").toLocked();
    @SearchParamDefinition(name="activity-scheduled-date", path="CarePlan.activity.plannedActivityDetail.scheduled.ofType(Timing) | CarePlan.activity.plannedActivityDetail.scheduled.ofType(Period)", description="Specified date occurs within period specified by CarePlan.activity.plannedActivityDetail.scheduled[x]", type="date")
    public static final String SP_ACTIVITY_SCHEDULED_DATE = "activity-scheduled-date";
    public static final DateClientParam ACTIVITY_SCHEDULED_DATE = new DateClientParam("activity-scheduled-date");
    @SearchParamDefinition(name="activity-scheduled-string", path="CarePlan.activity.plannedActivityDetail.scheduled.ofType(string)", description="When activity is to occur", type="string")
    public static final String SP_ACTIVITY_SCHEDULED_STRING = "activity-scheduled-string";
    public static final StringClientParam ACTIVITY_SCHEDULED_STRING = new StringClientParam("activity-scheduled-string");
    @SearchParamDefinition(name="based-on", path="CarePlan.basedOn", description="Fulfills CarePlan", type="reference", target={CarePlan.class, NutritionOrder.class, RequestOrchestration.class, ServiceRequest.class})
    public static final String SP_BASED_ON = "based-on";
    public static final ReferenceClientParam BASED_ON = new ReferenceClientParam("based-on");
    public static final Include INCLUDE_BASED_ON = new Include("CarePlan:based-on").toLocked();
    @SearchParamDefinition(name="care-team", path="CarePlan.careTeam", description="Who's involved in plan?", type="reference", target={CareTeam.class})
    public static final String SP_CARE_TEAM = "care-team";
    public static final ReferenceClientParam CARE_TEAM = new ReferenceClientParam("care-team");
    public static final Include INCLUDE_CARE_TEAM = new Include("CarePlan:care-team").toLocked();
    @SearchParamDefinition(name="category", path="CarePlan.category", description="Type of plan", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="condition", path="CarePlan.addresses.reference", description="Reference to a resource (by instance)", type="reference")
    public static final String SP_CONDITION = "condition";
    public static final ReferenceClientParam CONDITION = new ReferenceClientParam("condition");
    public static final Include INCLUDE_CONDITION = new Include("CarePlan:condition").toLocked();
    @SearchParamDefinition(name="custodian", path="CarePlan.custodian", description="Who is the designated responsible party", type="reference", target={CareTeam.class, Device.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_CUSTODIAN = "custodian";
    public static final ReferenceClientParam CUSTODIAN = new ReferenceClientParam("custodian");
    public static final Include INCLUDE_CUSTODIAN = new Include("CarePlan:custodian").toLocked();
    @SearchParamDefinition(name="encounter", path="CarePlan.encounter", description="The Encounter during which this CarePlan was created", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Encounter")}, target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("CarePlan:encounter").toLocked();
    @SearchParamDefinition(name="goal", path="CarePlan.goal", description="Desired outcome of plan", type="reference", target={Goal.class})
    public static final String SP_GOAL = "goal";
    public static final ReferenceClientParam GOAL = new ReferenceClientParam("goal");
    public static final Include INCLUDE_GOAL = new Include("CarePlan:goal").toLocked();
    @SearchParamDefinition(name="instantiates-canonical", path="CarePlan.instantiatesCanonical", description="Instantiates FHIR protocol or definition", type="reference", target={ActivityDefinition.class, Measure.class, OperationDefinition.class, PlanDefinition.class, Questionnaire.class})
    public static final String SP_INSTANTIATES_CANONICAL = "instantiates-canonical";
    public static final ReferenceClientParam INSTANTIATES_CANONICAL = new ReferenceClientParam("instantiates-canonical");
    public static final Include INCLUDE_INSTANTIATES_CANONICAL = new Include("CarePlan:instantiates-canonical").toLocked();
    @SearchParamDefinition(name="instantiates-uri", path="CarePlan.instantiatesUri", description="Instantiates external protocol or definition", type="uri")
    public static final String SP_INSTANTIATES_URI = "instantiates-uri";
    public static final UriClientParam INSTANTIATES_URI = new UriClientParam("instantiates-uri");
    @SearchParamDefinition(name="intent", path="CarePlan.intent", description="proposal | plan | order | option | directive", type="token")
    public static final String SP_INTENT = "intent";
    public static final TokenClientParam INTENT = new TokenClientParam("intent");
    @SearchParamDefinition(name="part-of", path="CarePlan.partOf", description="Part of referenced CarePlan", type="reference", target={CarePlan.class})
    public static final String SP_PART_OF = "part-of";
    public static final ReferenceClientParam PART_OF = new ReferenceClientParam("part-of");
    public static final Include INCLUDE_PART_OF = new Include("CarePlan:part-of").toLocked();
    @SearchParamDefinition(name="performer", path="CarePlan.activity.plannedActivityDetail.performer", description="Matches if the practitioner is listed as a performer in any of the \"simple\" activities.  (For performers of the detailed activities, chain through the activitydetail search parameter.)", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient"), @Compartment(name="Base FHIR compartment definition for Practitioner"), @Compartment(name="Base FHIR compartment definition for RelatedPerson")}, target={CareTeam.class, Device.class, HealthcareService.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_PERFORMER = "performer";
    public static final ReferenceClientParam PERFORMER = new ReferenceClientParam("performer");
    public static final Include INCLUDE_PERFORMER = new Include("CarePlan:performer").toLocked();
    @SearchParamDefinition(name="replaces", path="CarePlan.replaces", description="CarePlan replaced by this CarePlan", type="reference", target={CarePlan.class})
    public static final String SP_REPLACES = "replaces";
    public static final ReferenceClientParam REPLACES = new ReferenceClientParam("replaces");
    public static final Include INCLUDE_REPLACES = new Include("CarePlan:replaces").toLocked();
    @SearchParamDefinition(name="status", path="CarePlan.status", description="draft | active | on-hold | revoked | completed | entered-in-error | unknown", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject", path="CarePlan.subject", description="Who the care plan is for", type="reference", target={Group.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("CarePlan:subject").toLocked();
    @SearchParamDefinition(name="date", path="AllergyIntolerance.recordedDate | CarePlan.period | ClinicalImpression.date | Composition.date | Consent.date | DiagnosticReport.effective.as(dateTime) | DiagnosticReport.effective.as(Period) | Encounter.actualPeriod | EpisodeOfCare.period | FamilyMemberHistory.date | Flag.period | (Immunization.occurrence as dateTime) | List.date | Observation.effective.as(dateTime) | Observation.effective.as(Period) | Observation.effective.as(Timing) | Observation.effective.as(instant) | Procedure.occurrence.as(dateTime) | Procedure.occurrence.as(Period) | Procedure.occurrence.as(Timing) | (RiskAssessment.occurrence as dateTime) | SupplyRequest.authoredOn", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Date first version of the resource instance was recorded\r\n* [CarePlan](careplan.html): Time period plan covers\r\n* [CareTeam](careteam.html): A date within the coverage time period.\r\n* [ClinicalImpression](clinicalimpression.html): When the assessment was documented\r\n* [Composition](composition.html): Composition editing time\r\n* [Consent](consent.html): When consent was agreed to\r\n* [DiagnosticReport](diagnosticreport.html): The clinically relevant time of the report\r\n* [Encounter](encounter.html): A date within the actualPeriod the Encounter lasted\r\n* [EpisodeOfCare](episodeofcare.html): The provided date search value falls within the episode of care's period\r\n* [FamilyMemberHistory](familymemberhistory.html): When history was recorded or last updated\r\n* [Flag](flag.html): Time period when flag is active\r\n* [Immunization](immunization.html): Vaccination  (non)-Administration Date\r\n* [List](list.html): When the list was prepared\r\n* [Observation](observation.html): Obtained date/time. If the obtained element is a period, a date that falls in the period\r\n* [Procedure](procedure.html): When the procedure occurred or is occurring\r\n* [RiskAssessment](riskassessment.html): When was assessment made?\r\n* [SupplyRequest](supplyrequest.html): When the request was made\r\n", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="AllergyIntolerance.identifier | CarePlan.identifier | CareTeam.identifier | Composition.identifier | Condition.identifier | Consent.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DiagnosticReport.identifier | DocumentManifest.masterIdentifier | DocumentManifest.identifier | DocumentReference.identifier | Encounter.identifier | EpisodeOfCare.identifier | FamilyMemberHistory.identifier | Goal.identifier | ImagingStudy.identifier | Immunization.identifier | List.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationUsage.identifier | NutritionOrder.identifier | Observation.identifier | Procedure.identifier | RiskAssessment.identifier | ServiceRequest.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentManifest](documentmanifest.html): Unique Identifier for the set of documents\r\n* [DocumentReference](documentreference.html): Identifier of the attachment binary\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID\r\n* [Immunization](immunization.html): Business identifier\r\n* [List](list.html): Business identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationUsage](medicationusage.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="AllergyIntolerance.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ClinicalImpression.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | DetectedIssue.subject | DeviceRequest.subject.where(resolve() is Patient) | DeviceUsage.patient | DiagnosticReport.subject.where(resolve() is Patient) | DocumentManifest.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EpisodeOfCare.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | List.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationUsage.subject.where(resolve() is Patient) | NutritionOrder.subject.where(resolve() is Patient) | Observation.subject.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | SupplyDelivery.patient | SupplyRequest.deliverFor | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ClinicalImpression](clinicalimpression.html): Patient assessed\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUsage](deviceusage.html): Search by patient who used / uses the device\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentManifest](documentmanifest.html): The subject of the set of documents\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient present at the encounter\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [List](list.html): If all resources have the same subject\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationUsage](medicationusage.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the individual or set of individuals who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [SupplyRequest](supplyrequest.html): The patient or subject for whom the supply is destined\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={BiologicallyDerivedProduct.class, Device.class, Group.class, Location.class, Medication.class, NutritionProduct.class, Organization.class, Patient.class, Practitioner.class, Procedure.class, Substance.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("CarePlan:patient").toLocked();

    public CarePlan() {
    }

    public CarePlan(Enumerations.RequestStatus status, CarePlanIntent intent, Reference subject) {
        this.setStatus(status);
        this.setIntent(intent);
        this.setSubject(subject);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public CarePlan setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public CarePlan addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<CanonicalType> getInstantiatesCanonical() {
        if (this.instantiatesCanonical == null) {
            this.instantiatesCanonical = new ArrayList<CanonicalType>();
        }
        return this.instantiatesCanonical;
    }

    public CarePlan setInstantiatesCanonical(List<CanonicalType> theInstantiatesCanonical) {
        this.instantiatesCanonical = theInstantiatesCanonical;
        return this;
    }

    public boolean hasInstantiatesCanonical() {
        if (this.instantiatesCanonical == null) {
            return false;
        }
        for (CanonicalType item : this.instantiatesCanonical) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CanonicalType addInstantiatesCanonicalElement() {
        CanonicalType t = new CanonicalType();
        if (this.instantiatesCanonical == null) {
            this.instantiatesCanonical = new ArrayList<CanonicalType>();
        }
        this.instantiatesCanonical.add(t);
        return t;
    }

    public CarePlan addInstantiatesCanonical(String value) {
        CanonicalType t = new CanonicalType();
        t.setValue(value);
        if (this.instantiatesCanonical == null) {
            this.instantiatesCanonical = new ArrayList<CanonicalType>();
        }
        this.instantiatesCanonical.add(t);
        return this;
    }

    public boolean hasInstantiatesCanonical(String value) {
        if (this.instantiatesCanonical == null) {
            return false;
        }
        for (CanonicalType v : this.instantiatesCanonical) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<UriType> getInstantiatesUri() {
        if (this.instantiatesUri == null) {
            this.instantiatesUri = new ArrayList<UriType>();
        }
        return this.instantiatesUri;
    }

    public CarePlan setInstantiatesUri(List<UriType> theInstantiatesUri) {
        this.instantiatesUri = theInstantiatesUri;
        return this;
    }

    public boolean hasInstantiatesUri() {
        if (this.instantiatesUri == null) {
            return false;
        }
        for (UriType item : this.instantiatesUri) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public UriType addInstantiatesUriElement() {
        UriType t = new UriType();
        if (this.instantiatesUri == null) {
            this.instantiatesUri = new ArrayList<UriType>();
        }
        this.instantiatesUri.add(t);
        return t;
    }

    public CarePlan addInstantiatesUri(String value) {
        UriType t = new UriType();
        t.setValue(value);
        if (this.instantiatesUri == null) {
            this.instantiatesUri = new ArrayList<UriType>();
        }
        this.instantiatesUri.add(t);
        return this;
    }

    public boolean hasInstantiatesUri(String value) {
        if (this.instantiatesUri == null) {
            return false;
        }
        for (UriType v : this.instantiatesUri) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public CarePlan setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public CarePlan addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    public List<Reference> getReplaces() {
        if (this.replaces == null) {
            this.replaces = new ArrayList<Reference>();
        }
        return this.replaces;
    }

    public CarePlan setReplaces(List<Reference> theReplaces) {
        this.replaces = theReplaces;
        return this;
    }

    public boolean hasReplaces() {
        if (this.replaces == null) {
            return false;
        }
        for (Reference item : this.replaces) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addReplaces() {
        Reference t = new Reference();
        if (this.replaces == null) {
            this.replaces = new ArrayList<Reference>();
        }
        this.replaces.add(t);
        return t;
    }

    public CarePlan addReplaces(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.replaces == null) {
            this.replaces = new ArrayList<Reference>();
        }
        this.replaces.add(t);
        return this;
    }

    public Reference getReplacesFirstRep() {
        if (this.getReplaces().isEmpty()) {
            this.addReplaces();
        }
        return this.getReplaces().get(0);
    }

    public List<Reference> getPartOf() {
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        return this.partOf;
    }

    public CarePlan setPartOf(List<Reference> thePartOf) {
        this.partOf = thePartOf;
        return this;
    }

    public boolean hasPartOf() {
        if (this.partOf == null) {
            return false;
        }
        for (Reference item : this.partOf) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPartOf() {
        Reference t = new Reference();
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return t;
    }

    public CarePlan addPartOf(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return this;
    }

    public Reference getPartOfFirstRep() {
        if (this.getPartOf().isEmpty()) {
            this.addPartOf();
        }
        return this.getPartOf().get(0);
    }

    public Enumeration<Enumerations.RequestStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CarePlan.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.RequestStatus>(new Enumerations.RequestStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public CarePlan setStatusElement(Enumeration<Enumerations.RequestStatus> value) {
        this.status = value;
        return this;
    }

    public Enumerations.RequestStatus getStatus() {
        return this.status == null ? null : (Enumerations.RequestStatus)((Object)this.status.getValue());
    }

    public CarePlan setStatus(Enumerations.RequestStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.RequestStatus>(new Enumerations.RequestStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public Enumeration<CarePlanIntent> getIntentElement() {
        if (this.intent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CarePlan.intent");
            }
            if (Configuration.doAutoCreate()) {
                this.intent = new Enumeration<CarePlanIntent>(new CarePlanIntentEnumFactory());
            }
        }
        return this.intent;
    }

    public boolean hasIntentElement() {
        return this.intent != null && !this.intent.isEmpty();
    }

    public boolean hasIntent() {
        return this.intent != null && !this.intent.isEmpty();
    }

    public CarePlan setIntentElement(Enumeration<CarePlanIntent> value) {
        this.intent = value;
        return this;
    }

    public CarePlanIntent getIntent() {
        return this.intent == null ? null : (CarePlanIntent)((Object)this.intent.getValue());
    }

    public CarePlan setIntent(CarePlanIntent value) {
        if (this.intent == null) {
            this.intent = new Enumeration<CarePlanIntent>(new CarePlanIntentEnumFactory());
        }
        this.intent.setValue((Object)value);
        return this;
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public CarePlan setCategory(List<CodeableConcept> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public CarePlan addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CarePlan.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    public CarePlan setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    public CarePlan setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CarePlan.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public CarePlan setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public CarePlan setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CarePlan.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public CarePlan setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CarePlan.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public CarePlan setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CarePlan.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public CarePlan setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public DateTimeType getCreatedElement() {
        if (this.created == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CarePlan.created");
            }
            if (Configuration.doAutoCreate()) {
                this.created = new DateTimeType();
            }
        }
        return this.created;
    }

    public boolean hasCreatedElement() {
        return this.created != null && !this.created.isEmpty();
    }

    public boolean hasCreated() {
        return this.created != null && !this.created.isEmpty();
    }

    public CarePlan setCreatedElement(DateTimeType value) {
        this.created = value;
        return this;
    }

    public Date getCreated() {
        return this.created == null ? null : (Date)this.created.getValue();
    }

    public CarePlan setCreated(Date value) {
        if (value == null) {
            this.created = null;
        } else {
            if (this.created == null) {
                this.created = new DateTimeType();
            }
            this.created.setValue(value);
        }
        return this;
    }

    public Reference getCustodian() {
        if (this.custodian == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CarePlan.custodian");
            }
            if (Configuration.doAutoCreate()) {
                this.custodian = new Reference();
            }
        }
        return this.custodian;
    }

    public boolean hasCustodian() {
        return this.custodian != null && !this.custodian.isEmpty();
    }

    public CarePlan setCustodian(Reference value) {
        this.custodian = value;
        return this;
    }

    public List<Reference> getContributor() {
        if (this.contributor == null) {
            this.contributor = new ArrayList<Reference>();
        }
        return this.contributor;
    }

    public CarePlan setContributor(List<Reference> theContributor) {
        this.contributor = theContributor;
        return this;
    }

    public boolean hasContributor() {
        if (this.contributor == null) {
            return false;
        }
        for (Reference item : this.contributor) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addContributor() {
        Reference t = new Reference();
        if (this.contributor == null) {
            this.contributor = new ArrayList<Reference>();
        }
        this.contributor.add(t);
        return t;
    }

    public CarePlan addContributor(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.contributor == null) {
            this.contributor = new ArrayList<Reference>();
        }
        this.contributor.add(t);
        return this;
    }

    public Reference getContributorFirstRep() {
        if (this.getContributor().isEmpty()) {
            this.addContributor();
        }
        return this.getContributor().get(0);
    }

    public List<Reference> getCareTeam() {
        if (this.careTeam == null) {
            this.careTeam = new ArrayList<Reference>();
        }
        return this.careTeam;
    }

    public CarePlan setCareTeam(List<Reference> theCareTeam) {
        this.careTeam = theCareTeam;
        return this;
    }

    public boolean hasCareTeam() {
        if (this.careTeam == null) {
            return false;
        }
        for (Reference item : this.careTeam) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addCareTeam() {
        Reference t = new Reference();
        if (this.careTeam == null) {
            this.careTeam = new ArrayList<Reference>();
        }
        this.careTeam.add(t);
        return t;
    }

    public CarePlan addCareTeam(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.careTeam == null) {
            this.careTeam = new ArrayList<Reference>();
        }
        this.careTeam.add(t);
        return this;
    }

    public Reference getCareTeamFirstRep() {
        if (this.getCareTeam().isEmpty()) {
            this.addCareTeam();
        }
        return this.getCareTeam().get(0);
    }

    public List<CodeableReference> getAddresses() {
        if (this.addresses == null) {
            this.addresses = new ArrayList<CodeableReference>();
        }
        return this.addresses;
    }

    public CarePlan setAddresses(List<CodeableReference> theAddresses) {
        this.addresses = theAddresses;
        return this;
    }

    public boolean hasAddresses() {
        if (this.addresses == null) {
            return false;
        }
        for (CodeableReference item : this.addresses) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableReference addAddresses() {
        CodeableReference t = new CodeableReference();
        if (this.addresses == null) {
            this.addresses = new ArrayList<CodeableReference>();
        }
        this.addresses.add(t);
        return t;
    }

    public CarePlan addAddresses(CodeableReference t) {
        if (t == null) {
            return this;
        }
        if (this.addresses == null) {
            this.addresses = new ArrayList<CodeableReference>();
        }
        this.addresses.add(t);
        return this;
    }

    public CodeableReference getAddressesFirstRep() {
        if (this.getAddresses().isEmpty()) {
            this.addAddresses();
        }
        return this.getAddresses().get(0);
    }

    public List<Reference> getSupportingInfo() {
        if (this.supportingInfo == null) {
            this.supportingInfo = new ArrayList<Reference>();
        }
        return this.supportingInfo;
    }

    public CarePlan setSupportingInfo(List<Reference> theSupportingInfo) {
        this.supportingInfo = theSupportingInfo;
        return this;
    }

    public boolean hasSupportingInfo() {
        if (this.supportingInfo == null) {
            return false;
        }
        for (Reference item : this.supportingInfo) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSupportingInfo() {
        Reference t = new Reference();
        if (this.supportingInfo == null) {
            this.supportingInfo = new ArrayList<Reference>();
        }
        this.supportingInfo.add(t);
        return t;
    }

    public CarePlan addSupportingInfo(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.supportingInfo == null) {
            this.supportingInfo = new ArrayList<Reference>();
        }
        this.supportingInfo.add(t);
        return this;
    }

    public Reference getSupportingInfoFirstRep() {
        if (this.getSupportingInfo().isEmpty()) {
            this.addSupportingInfo();
        }
        return this.getSupportingInfo().get(0);
    }

    public List<Reference> getGoal() {
        if (this.goal == null) {
            this.goal = new ArrayList<Reference>();
        }
        return this.goal;
    }

    public CarePlan setGoal(List<Reference> theGoal) {
        this.goal = theGoal;
        return this;
    }

    public boolean hasGoal() {
        if (this.goal == null) {
            return false;
        }
        for (Reference item : this.goal) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addGoal() {
        Reference t = new Reference();
        if (this.goal == null) {
            this.goal = new ArrayList<Reference>();
        }
        this.goal.add(t);
        return t;
    }

    public CarePlan addGoal(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.goal == null) {
            this.goal = new ArrayList<Reference>();
        }
        this.goal.add(t);
        return this;
    }

    public Reference getGoalFirstRep() {
        if (this.getGoal().isEmpty()) {
            this.addGoal();
        }
        return this.getGoal().get(0);
    }

    public List<CarePlanActivityComponent> getActivity() {
        if (this.activity == null) {
            this.activity = new ArrayList<CarePlanActivityComponent>();
        }
        return this.activity;
    }

    public CarePlan setActivity(List<CarePlanActivityComponent> theActivity) {
        this.activity = theActivity;
        return this;
    }

    public boolean hasActivity() {
        if (this.activity == null) {
            return false;
        }
        for (CarePlanActivityComponent item : this.activity) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CarePlanActivityComponent addActivity() {
        CarePlanActivityComponent t = new CarePlanActivityComponent();
        if (this.activity == null) {
            this.activity = new ArrayList<CarePlanActivityComponent>();
        }
        this.activity.add(t);
        return t;
    }

    public CarePlan addActivity(CarePlanActivityComponent t) {
        if (t == null) {
            return this;
        }
        if (this.activity == null) {
            this.activity = new ArrayList<CarePlanActivityComponent>();
        }
        this.activity.add(t);
        return this;
    }

    public CarePlanActivityComponent getActivityFirstRep() {
        if (this.getActivity().isEmpty()) {
            this.addActivity();
        }
        return this.getActivity().get(0);
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public CarePlan setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public CarePlan addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this care plan by the performer or other systems which remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("instantiatesCanonical", "canonical(PlanDefinition|Questionnaire|Measure|ActivityDefinition|OperationDefinition)", "The URL pointing to a FHIR-defined protocol, guideline, questionnaire or other definition that is adhered to in whole or in part by this CarePlan.", 0, Integer.MAX_VALUE, this.instantiatesCanonical));
        children.add(new Property("instantiatesUri", "uri", "The URL pointing to an externally maintained protocol, guideline, questionnaire or other definition that is adhered to in whole or in part by this CarePlan.", 0, Integer.MAX_VALUE, this.instantiatesUri));
        children.add(new Property("basedOn", "Reference(CarePlan|ServiceRequest|RequestOrchestration|NutritionOrder)", "A higher-level request resource (i.e. a plan, proposal or order) that is fulfilled in whole or in part by this care plan.", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property(SP_REPLACES, "Reference(CarePlan)", "Completed or terminated care plan whose function is taken by this new care plan.", 0, Integer.MAX_VALUE, this.replaces));
        children.add(new Property("partOf", "Reference(CarePlan)", "A larger care plan of which this particular care plan is a component or step.", 0, Integer.MAX_VALUE, this.partOf));
        children.add(new Property(SP_STATUS, "code", "Indicates whether the plan is currently being acted upon, represents future intentions or is now a historical record.", 0, 1, this.status));
        children.add(new Property(SP_INTENT, "code", "Indicates the level of authority/intentionality associated with the care plan and where the care plan fits into the workflow chain.", 0, 1, this.intent));
        children.add(new Property(SP_CATEGORY, "CodeableConcept", "Identifies what \"kind\" of plan this is to support differentiation between multiple co-existing plans; e.g. \"Home health\", \"psychiatric\", \"asthma\", \"disease management\", \"wellness plan\", etc.", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property("title", "string", "Human-friendly name for the care plan.", 0, 1, this.title));
        children.add(new Property("description", "string", "A description of the scope and nature of the plan.", 0, 1, this.description));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group)", "Identifies the patient or group whose intended care is described by the plan.", 0, 1, this.subject));
        children.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "The Encounter during which this CarePlan was created or to which the creation of this record is tightly associated.", 0, 1, this.encounter));
        children.add(new Property("period", "Period", "Indicates when the plan did (or is intended to) come into effect and end.", 0, 1, this.period));
        children.add(new Property("created", "dateTime", "Represents when this particular CarePlan record was created in the system, which is often a system-generated date.", 0, 1, this.created));
        children.add(new Property(SP_CUSTODIAN, "Reference(Patient|Practitioner|PractitionerRole|Device|RelatedPerson|Organization|CareTeam)", "When populated, the custodian is responsible for the care plan. The care plan is attributed to the custodian.", 0, 1, this.custodian));
        children.add(new Property("contributor", "Reference(Patient|Practitioner|PractitionerRole|Device|RelatedPerson|Organization|CareTeam)", "Identifies the individual(s), organization or device who provided the contents of the care plan.", 0, Integer.MAX_VALUE, this.contributor));
        children.add(new Property("careTeam", "Reference(CareTeam)", "Identifies all people and organizations who are expected to be involved in the care envisioned by this plan.", 0, Integer.MAX_VALUE, this.careTeam));
        children.add(new Property("addresses", "CodeableReference(Condition)", "Identifies the conditions/problems/concerns/diagnoses/etc. whose management and/or mitigation are handled by this plan.", 0, Integer.MAX_VALUE, this.addresses));
        children.add(new Property("supportingInfo", "Reference(Any)", "Identifies portions of the patient's record that specifically influenced the formation of the plan.  These might include comorbidities, recent procedures, limitations, recent assessments, etc.", 0, Integer.MAX_VALUE, this.supportingInfo));
        children.add(new Property(SP_GOAL, "Reference(Goal)", "Describes the intended objective(s) of carrying out the care plan.", 0, Integer.MAX_VALUE, this.goal));
        children.add(new Property("activity", "", "Identifies an action that has occurred or is a planned action to occur as part of the plan. For example, a medication to be used, lab tests to perform, self-monitoring that has occurred, education etc.", 0, Integer.MAX_VALUE, this.activity));
        children.add(new Property("note", "Annotation", "General notes about the care plan not covered elsewhere.", 0, Integer.MAX_VALUE, this.note));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this care plan by the performer or other systems which remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 8911915: {
                return new Property("instantiatesCanonical", "canonical(PlanDefinition|Questionnaire|Measure|ActivityDefinition|OperationDefinition)", "The URL pointing to a FHIR-defined protocol, guideline, questionnaire or other definition that is adhered to in whole or in part by this CarePlan.", 0, Integer.MAX_VALUE, this.instantiatesCanonical);
            }
            case -1926393373: {
                return new Property("instantiatesUri", "uri", "The URL pointing to an externally maintained protocol, guideline, questionnaire or other definition that is adhered to in whole or in part by this CarePlan.", 0, Integer.MAX_VALUE, this.instantiatesUri);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(CarePlan|ServiceRequest|RequestOrchestration|NutritionOrder)", "A higher-level request resource (i.e. a plan, proposal or order) that is fulfilled in whole or in part by this care plan.", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case -430332865: {
                return new Property(SP_REPLACES, "Reference(CarePlan)", "Completed or terminated care plan whose function is taken by this new care plan.", 0, Integer.MAX_VALUE, this.replaces);
            }
            case -995410646: {
                return new Property("partOf", "Reference(CarePlan)", "A larger care plan of which this particular care plan is a component or step.", 0, Integer.MAX_VALUE, this.partOf);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "Indicates whether the plan is currently being acted upon, represents future intentions or is now a historical record.", 0, 1, this.status);
            }
            case -1183762788: {
                return new Property(SP_INTENT, "code", "Indicates the level of authority/intentionality associated with the care plan and where the care plan fits into the workflow chain.", 0, 1, this.intent);
            }
            case 50511102: {
                return new Property(SP_CATEGORY, "CodeableConcept", "Identifies what \"kind\" of plan this is to support differentiation between multiple co-existing plans; e.g. \"Home health\", \"psychiatric\", \"asthma\", \"disease management\", \"wellness plan\", etc.", 0, Integer.MAX_VALUE, this.category);
            }
            case 110371416: {
                return new Property("title", "string", "Human-friendly name for the care plan.", 0, 1, this.title);
            }
            case -1724546052: {
                return new Property("description", "string", "A description of the scope and nature of the plan.", 0, 1, this.description);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group)", "Identifies the patient or group whose intended care is described by the plan.", 0, 1, this.subject);
            }
            case 1524132147: {
                return new Property(SP_ENCOUNTER, "Reference(Encounter)", "The Encounter during which this CarePlan was created or to which the creation of this record is tightly associated.", 0, 1, this.encounter);
            }
            case -991726143: {
                return new Property("period", "Period", "Indicates when the plan did (or is intended to) come into effect and end.", 0, 1, this.period);
            }
            case 1028554472: {
                return new Property("created", "dateTime", "Represents when this particular CarePlan record was created in the system, which is often a system-generated date.", 0, 1, this.created);
            }
            case 1611297262: {
                return new Property(SP_CUSTODIAN, "Reference(Patient|Practitioner|PractitionerRole|Device|RelatedPerson|Organization|CareTeam)", "When populated, the custodian is responsible for the care plan. The care plan is attributed to the custodian.", 0, 1, this.custodian);
            }
            case -1895276325: {
                return new Property("contributor", "Reference(Patient|Practitioner|PractitionerRole|Device|RelatedPerson|Organization|CareTeam)", "Identifies the individual(s), organization or device who provided the contents of the care plan.", 0, Integer.MAX_VALUE, this.contributor);
            }
            case -7323378: {
                return new Property("careTeam", "Reference(CareTeam)", "Identifies all people and organizations who are expected to be involved in the care envisioned by this plan.", 0, Integer.MAX_VALUE, this.careTeam);
            }
            case 874544034: {
                return new Property("addresses", "CodeableReference(Condition)", "Identifies the conditions/problems/concerns/diagnoses/etc. whose management and/or mitigation are handled by this plan.", 0, Integer.MAX_VALUE, this.addresses);
            }
            case 1922406657: {
                return new Property("supportingInfo", "Reference(Any)", "Identifies portions of the patient's record that specifically influenced the formation of the plan.  These might include comorbidities, recent procedures, limitations, recent assessments, etc.", 0, Integer.MAX_VALUE, this.supportingInfo);
            }
            case 3178259: {
                return new Property(SP_GOAL, "Reference(Goal)", "Describes the intended objective(s) of carrying out the care plan.", 0, Integer.MAX_VALUE, this.goal);
            }
            case -1655966961: {
                return new Property("activity", "", "Identifies an action that has occurred or is a planned action to occur as part of the plan. For example, a medication to be used, lab tests to perform, self-monitoring that has occurred, education etc.", 0, Integer.MAX_VALUE, this.activity);
            }
            case 3387378: {
                return new Property("note", "Annotation", "General notes about the care plan not covered elsewhere.", 0, Integer.MAX_VALUE, this.note);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 8911915: {
                return this.instantiatesCanonical == null ? new Base[]{} : this.instantiatesCanonical.toArray(new Base[this.instantiatesCanonical.size()]);
            }
            case -1926393373: {
                return this.instantiatesUri == null ? new Base[]{} : this.instantiatesUri.toArray(new Base[this.instantiatesUri.size()]);
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -430332865: {
                return this.replaces == null ? new Base[]{} : this.replaces.toArray(new Base[this.replaces.size()]);
            }
            case -995410646: {
                return this.partOf == null ? new Base[]{} : this.partOf.toArray(new Base[this.partOf.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case -1183762788: {
                Base[] baseArray;
                if (this.intent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.intent;
                }
                return baseArray;
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.title;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.description;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.subject;
                }
                return baseArray;
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.encounter;
                }
                return baseArray;
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.period;
                }
                return baseArray;
            }
            case 1028554472: {
                Base[] baseArray;
                if (this.created == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.created;
                }
                return baseArray;
            }
            case 1611297262: {
                Base[] baseArray;
                if (this.custodian == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.custodian;
                }
                return baseArray;
            }
            case -1895276325: {
                return this.contributor == null ? new Base[]{} : this.contributor.toArray(new Base[this.contributor.size()]);
            }
            case -7323378: {
                return this.careTeam == null ? new Base[]{} : this.careTeam.toArray(new Base[this.careTeam.size()]);
            }
            case 874544034: {
                return this.addresses == null ? new Base[]{} : this.addresses.toArray(new Base[this.addresses.size()]);
            }
            case 1922406657: {
                return this.supportingInfo == null ? new Base[]{} : this.supportingInfo.toArray(new Base[this.supportingInfo.size()]);
            }
            case 3178259: {
                return this.goal == null ? new Base[]{} : this.goal.toArray(new Base[this.goal.size()]);
            }
            case -1655966961: {
                return this.activity == null ? new Base[]{} : this.activity.toArray(new Base[this.activity.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 8911915: {
                this.getInstantiatesCanonical().add(TypeConvertor.castToCanonical(value));
                return value;
            }
            case -1926393373: {
                this.getInstantiatesUri().add(TypeConvertor.castToUri(value));
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -430332865: {
                this.getReplaces().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -995410646: {
                this.getPartOf().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -892481550: {
                value = new Enumerations.RequestStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -1183762788: {
                value = new CarePlanIntentEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.intent = value;
                return value;
            }
            case 50511102: {
                this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 110371416: {
                this.title = TypeConvertor.castToString(value);
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToString(value);
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case 1524132147: {
                this.encounter = TypeConvertor.castToReference(value);
                return value;
            }
            case -991726143: {
                this.period = TypeConvertor.castToPeriod(value);
                return value;
            }
            case 1028554472: {
                this.created = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 1611297262: {
                this.custodian = TypeConvertor.castToReference(value);
                return value;
            }
            case -1895276325: {
                this.getContributor().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -7323378: {
                this.getCareTeam().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 874544034: {
                this.getAddresses().add(TypeConvertor.castToCodeableReference(value));
                return value;
            }
            case 1922406657: {
                this.getSupportingInfo().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 3178259: {
                this.getGoal().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1655966961: {
                this.getActivity().add((CarePlanActivityComponent)((Object)value));
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("instantiatesCanonical")) {
            this.getInstantiatesCanonical().add(TypeConvertor.castToCanonical(value));
        } else if (name.equals("instantiatesUri")) {
            this.getInstantiatesUri().add(TypeConvertor.castToUri(value));
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_REPLACES)) {
            this.getReplaces().add(TypeConvertor.castToReference(value));
        } else if (name.equals("partOf")) {
            this.getPartOf().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.RequestStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_INTENT)) {
            value = new CarePlanIntentEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.intent = value;
        } else if (name.equals(SP_CATEGORY)) {
            this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("title")) {
            this.title = TypeConvertor.castToString(value);
        } else if (name.equals("description")) {
            this.description = TypeConvertor.castToString(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = TypeConvertor.castToReference(value);
        } else if (name.equals("period")) {
            this.period = TypeConvertor.castToPeriod(value);
        } else if (name.equals("created")) {
            this.created = TypeConvertor.castToDateTime(value);
        } else if (name.equals(SP_CUSTODIAN)) {
            this.custodian = TypeConvertor.castToReference(value);
        } else if (name.equals("contributor")) {
            this.getContributor().add(TypeConvertor.castToReference(value));
        } else if (name.equals("careTeam")) {
            this.getCareTeam().add(TypeConvertor.castToReference(value));
        } else if (name.equals("addresses")) {
            this.getAddresses().add(TypeConvertor.castToCodeableReference(value));
        } else if (name.equals("supportingInfo")) {
            this.getSupportingInfo().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_GOAL)) {
            this.getGoal().add(TypeConvertor.castToReference(value));
        } else if (name.equals("activity")) {
            this.getActivity().add((CarePlanActivityComponent)((Object)value));
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 8911915: {
                return this.addInstantiatesCanonicalElement();
            }
            case -1926393373: {
                return this.addInstantiatesUriElement();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -430332865: {
                return this.addReplaces();
            }
            case -995410646: {
                return this.addPartOf();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -1183762788: {
                return this.getIntentElement();
            }
            case 50511102: {
                return this.addCategory();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case 1028554472: {
                return this.getCreatedElement();
            }
            case 1611297262: {
                return this.getCustodian();
            }
            case -1895276325: {
                return this.addContributor();
            }
            case -7323378: {
                return this.addCareTeam();
            }
            case 874544034: {
                return this.addAddresses();
            }
            case 1922406657: {
                return this.addSupportingInfo();
            }
            case 3178259: {
                return this.addGoal();
            }
            case -1655966961: {
                return this.addActivity();
            }
            case 3387378: {
                return this.addNote();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 8911915: {
                return new String[]{"canonical"};
            }
            case -1926393373: {
                return new String[]{"uri"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -430332865: {
                return new String[]{"Reference"};
            }
            case -995410646: {
                return new String[]{"Reference"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -1183762788: {
                return new String[]{"code"};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -1724546052: {
                return new String[]{"string"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 1524132147: {
                return new String[]{"Reference"};
            }
            case -991726143: {
                return new String[]{"Period"};
            }
            case 1028554472: {
                return new String[]{"dateTime"};
            }
            case 1611297262: {
                return new String[]{"Reference"};
            }
            case -1895276325: {
                return new String[]{"Reference"};
            }
            case -7323378: {
                return new String[]{"Reference"};
            }
            case 874544034: {
                return new String[]{"CodeableReference"};
            }
            case 1922406657: {
                return new String[]{"Reference"};
            }
            case 3178259: {
                return new String[]{"Reference"};
            }
            case -1655966961: {
                return new String[0];
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("instantiatesCanonical")) {
            throw new FHIRException("Cannot call addChild on a primitive type CarePlan.instantiatesCanonical");
        }
        if (name.equals("instantiatesUri")) {
            throw new FHIRException("Cannot call addChild on a primitive type CarePlan.instantiatesUri");
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals(SP_REPLACES)) {
            return this.addReplaces();
        }
        if (name.equals("partOf")) {
            return this.addPartOf();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type CarePlan.status");
        }
        if (name.equals(SP_INTENT)) {
            throw new FHIRException("Cannot call addChild on a primitive type CarePlan.intent");
        }
        if (name.equals(SP_CATEGORY)) {
            return this.addCategory();
        }
        if (name.equals("title")) {
            throw new FHIRException("Cannot call addChild on a primitive type CarePlan.title");
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type CarePlan.description");
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals("created")) {
            throw new FHIRException("Cannot call addChild on a primitive type CarePlan.created");
        }
        if (name.equals(SP_CUSTODIAN)) {
            this.custodian = new Reference();
            return this.custodian;
        }
        if (name.equals("contributor")) {
            return this.addContributor();
        }
        if (name.equals("careTeam")) {
            return this.addCareTeam();
        }
        if (name.equals("addresses")) {
            return this.addAddresses();
        }
        if (name.equals("supportingInfo")) {
            return this.addSupportingInfo();
        }
        if (name.equals(SP_GOAL)) {
            return this.addGoal();
        }
        if (name.equals("activity")) {
            return this.addActivity();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "CarePlan";
    }

    @Override
    public CarePlan copy() {
        CarePlan dst = new CarePlan();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(CarePlan dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.instantiatesCanonical != null) {
            dst.instantiatesCanonical = new ArrayList<CanonicalType>();
            for (CanonicalType canonicalType : this.instantiatesCanonical) {
                dst.instantiatesCanonical.add(canonicalType.copy());
            }
        }
        if (this.instantiatesUri != null) {
            dst.instantiatesUri = new ArrayList<UriType>();
            for (UriType uriType : this.instantiatesUri) {
                dst.instantiatesUri.add(uriType.copy());
            }
        }
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        if (this.replaces != null) {
            dst.replaces = new ArrayList<Reference>();
            for (Reference reference : this.replaces) {
                dst.replaces.add(reference.copy());
            }
        }
        if (this.partOf != null) {
            dst.partOf = new ArrayList<Reference>();
            for (Reference reference : this.partOf) {
                dst.partOf.add(reference.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        Enumeration<CarePlanIntent> enumeration = dst.intent = this.intent == null ? null : this.intent.copy();
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.category) {
                dst.category.add(codeableConcept.copy());
            }
        }
        dst.title = this.title == null ? null : this.title.copy();
        dst.description = this.description == null ? null : this.description.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        dst.period = this.period == null ? null : this.period.copy();
        dst.created = this.created == null ? null : this.created.copy();
        Reference reference = dst.custodian = this.custodian == null ? null : this.custodian.copy();
        if (this.contributor != null) {
            dst.contributor = new ArrayList<Reference>();
            for (Reference reference2 : this.contributor) {
                dst.contributor.add(reference2.copy());
            }
        }
        if (this.careTeam != null) {
            dst.careTeam = new ArrayList<Reference>();
            for (Reference reference3 : this.careTeam) {
                dst.careTeam.add(reference3.copy());
            }
        }
        if (this.addresses != null) {
            dst.addresses = new ArrayList<CodeableReference>();
            for (CodeableReference codeableReference : this.addresses) {
                dst.addresses.add(codeableReference.copy());
            }
        }
        if (this.supportingInfo != null) {
            dst.supportingInfo = new ArrayList<Reference>();
            for (Reference reference4 : this.supportingInfo) {
                dst.supportingInfo.add(reference4.copy());
            }
        }
        if (this.goal != null) {
            dst.goal = new ArrayList<Reference>();
            for (Reference reference5 : this.goal) {
                dst.goal.add(reference5.copy());
            }
        }
        if (this.activity != null) {
            dst.activity = new ArrayList<CarePlanActivityComponent>();
            for (CarePlanActivityComponent carePlanActivityComponent : this.activity) {
                dst.activity.add(carePlanActivityComponent.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
    }

    protected CarePlan typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof CarePlan)) {
            return false;
        }
        CarePlan o = (CarePlan)other_;
        return CarePlan.compareDeep(this.identifier, o.identifier, true) && CarePlan.compareDeep(this.instantiatesCanonical, o.instantiatesCanonical, true) && CarePlan.compareDeep(this.instantiatesUri, o.instantiatesUri, true) && CarePlan.compareDeep(this.basedOn, o.basedOn, true) && CarePlan.compareDeep(this.replaces, o.replaces, true) && CarePlan.compareDeep(this.partOf, o.partOf, true) && CarePlan.compareDeep(this.status, o.status, true) && CarePlan.compareDeep(this.intent, o.intent, true) && CarePlan.compareDeep(this.category, o.category, true) && CarePlan.compareDeep(this.title, o.title, true) && CarePlan.compareDeep(this.description, o.description, true) && CarePlan.compareDeep(this.subject, o.subject, true) && CarePlan.compareDeep(this.encounter, o.encounter, true) && CarePlan.compareDeep(this.period, o.period, true) && CarePlan.compareDeep(this.created, o.created, true) && CarePlan.compareDeep(this.custodian, o.custodian, true) && CarePlan.compareDeep(this.contributor, o.contributor, true) && CarePlan.compareDeep(this.careTeam, o.careTeam, true) && CarePlan.compareDeep(this.addresses, o.addresses, true) && CarePlan.compareDeep(this.supportingInfo, o.supportingInfo, true) && CarePlan.compareDeep(this.goal, o.goal, true) && CarePlan.compareDeep(this.activity, o.activity, true) && CarePlan.compareDeep(this.note, o.note, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof CarePlan)) {
            return false;
        }
        CarePlan o = (CarePlan)other_;
        return CarePlan.compareValues(this.instantiatesCanonical, o.instantiatesCanonical, true) && CarePlan.compareValues(this.instantiatesUri, o.instantiatesUri, true) && CarePlan.compareValues(this.status, o.status, true) && CarePlan.compareValues(this.intent, o.intent, true) && CarePlan.compareValues(this.title, o.title, true) && CarePlan.compareValues(this.description, o.description, true) && CarePlan.compareValues(this.created, o.created, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.instantiatesCanonical, this.instantiatesUri, this.basedOn, this.replaces, this.partOf, this.status, this.intent, this.category, this.title, this.description, this.subject, this.encounter, this.period, this.created, this.custodian, this.contributor, this.careTeam, this.addresses, this.supportingInfo, this.goal, this.activity, this.note});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.CarePlan;
    }

    @Block
    public static class CarePlanActivityPlannedActivityDetailComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="kind", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Appointment | CommunicationRequest | DeviceRequest | MedicationRequest | NutritionOrder | Task | ServiceRequest | VisionPrescription", formalDefinition="A description of the kind of resource the in-line definition of a care plan activity is representing.  The CarePlan.activity.detail is an in-line definition when a resource is not referenced using CarePlan.activity.reference.  For example, a MedicationRequest, a ServiceRequest, or a CommunicationRequest.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/care-plan-activity-kind")
        protected Enumeration<CarePlanActivityKind> kind;
        @Child(name="instantiatesCanonical", type={CanonicalType.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Instantiates FHIR protocol or definition", formalDefinition="The URL pointing to a FHIR-defined protocol, guideline, questionnaire or other definition that is adhered to in whole or in part by this CarePlan activity.")
        protected List<CanonicalType> instantiatesCanonical;
        @Child(name="instantiatesUri", type={UriType.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Instantiates external protocol or definition", formalDefinition="The URL pointing to an externally maintained protocol, guideline, questionnaire or other definition that is adhered to in whole or in part by this CarePlan activity.")
        protected List<UriType> instantiatesUri;
        @Child(name="code", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Detail type of activity", formalDefinition="Detailed description of the type of planned activity; e.g. what lab test, what procedure, what kind of encounter.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/procedure-code")
        protected CodeableConcept code;
        @Child(name="reason", type={CodeableReference.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Why activity should be done or why activity was prohibited", formalDefinition="Provides the rationale that drove the inclusion of this particular activity as part of the plan or the reason why the activity was prohibited - either a coded concept, or another resource, such as the health condition(s), whose existence justifies this request and drove the inclusion of this particular activity as part of the plan.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/clinical-findings")
        protected List<CodeableReference> reason;
        @Child(name="goal", type={Goal.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Goals this activity relates to", formalDefinition="Internal reference that identifies the goals that this activity is intended to contribute towards meeting.")
        protected List<Reference> goal;
        @Child(name="status", type={CodeType.class}, order=7, min=1, max=1, modifier=true, summary=false)
        @Description(shortDefinition="not-started | scheduled | in-progress | on-hold | completed | cancelled | stopped | unknown | entered-in-error", formalDefinition="Identifies what progress is being made for the specific activity.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/care-plan-activity-status")
        protected Enumeration<CarePlanActivityStatus> status;
        @Child(name="statusReason", type={CodeableConcept.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reason for current status", formalDefinition="Provides reason why the activity isn't yet started, is on hold, was cancelled, etc.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/care-plan-activity-status-reason")
        protected CodeableConcept statusReason;
        @Child(name="doNotPerform", type={BooleanType.class}, order=9, min=0, max=1, modifier=true, summary=false)
        @Description(shortDefinition="If true, activity is prohibiting action", formalDefinition="If true, indicates that the described activity is one that must NOT be engaged in when following the plan.  If false, or missing, indicates that the described activity is one that should be engaged in when following the plan.")
        protected BooleanType doNotPerform;
        @Child(name="scheduled", type={Timing.class, Period.class, StringType.class}, order=10, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When activity is to occur", formalDefinition="The period, timing or frequency upon which the described activity is to occur.")
        protected DataType scheduled;
        @Child(name="location", type={CodeableReference.class}, order=11, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Where it should happen", formalDefinition="Identifies the facility where the activity will occur; e.g. home, hospital, specific clinic, etc.")
        @Binding(valueSet="http://terminology.hl7.org/ValueSet/v3-ServiceDeliveryLocationRoleType")
        protected CodeableReference location;
        @Child(name="reported", type={BooleanType.class, Patient.class, RelatedPerson.class, Practitioner.class, PractitionerRole.class, Organization.class}, order=12, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reported rather than primary record", formalDefinition="Indicates if this record was captured as a secondary 'reported' record rather than as an original primary source-of-truth record.  It may also indicate the source of the report.")
        protected DataType reported;
        @Child(name="performer", type={Practitioner.class, PractitionerRole.class, Organization.class, RelatedPerson.class, Patient.class, CareTeam.class, HealthcareService.class, Device.class}, order=13, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Who will be responsible?", formalDefinition="Identifies who's expected to be involved in the activity.")
        protected List<Reference> performer;
        @Child(name="product", type={CodeableConcept.class, Medication.class, Substance.class}, order=14, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What is to be administered/supplied", formalDefinition="Identifies the food, drug or other product to be consumed or supplied in the activity.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-codes")
        protected DataType product;
        @Child(name="dailyAmount", type={Quantity.class}, order=15, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="How to consume/day?", formalDefinition="Identifies the quantity expected to be consumed in a given day.")
        protected Quantity dailyAmount;
        @Child(name="quantity", type={Quantity.class}, order=16, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="How much to administer/supply/consume", formalDefinition="Identifies the quantity expected to be supplied, administered or consumed by the subject.")
        protected Quantity quantity;
        @Child(name="description", type={StringType.class}, order=17, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Extra info describing activity to perform", formalDefinition="This provides a textual description of constraints on the intended activity occurrence, including relation to other activities.  It may also include objectives, pre-conditions and end-conditions.  Finally, it may convey specifics about the activity such as body site, method, route, etc.")
        protected StringType description;
        private static final long serialVersionUID = -1258570436L;

        public CarePlanActivityPlannedActivityDetailComponent() {
        }

        public CarePlanActivityPlannedActivityDetailComponent(CarePlanActivityStatus status) {
            this.setStatus(status);
        }

        public Enumeration<CarePlanActivityKind> getKindElement() {
            if (this.kind == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CarePlanActivityPlannedActivityDetailComponent.kind");
                }
                if (Configuration.doAutoCreate()) {
                    this.kind = new Enumeration<CarePlanActivityKind>(new CarePlanActivityKindEnumFactory());
                }
            }
            return this.kind;
        }

        public boolean hasKindElement() {
            return this.kind != null && !this.kind.isEmpty();
        }

        public boolean hasKind() {
            return this.kind != null && !this.kind.isEmpty();
        }

        public CarePlanActivityPlannedActivityDetailComponent setKindElement(Enumeration<CarePlanActivityKind> value) {
            this.kind = value;
            return this;
        }

        public CarePlanActivityKind getKind() {
            return this.kind == null ? null : (CarePlanActivityKind)((Object)this.kind.getValue());
        }

        public CarePlanActivityPlannedActivityDetailComponent setKind(CarePlanActivityKind value) {
            if (value == null) {
                this.kind = null;
            } else {
                if (this.kind == null) {
                    this.kind = new Enumeration<CarePlanActivityKind>(new CarePlanActivityKindEnumFactory());
                }
                this.kind.setValue((Object)value);
            }
            return this;
        }

        public List<CanonicalType> getInstantiatesCanonical() {
            if (this.instantiatesCanonical == null) {
                this.instantiatesCanonical = new ArrayList<CanonicalType>();
            }
            return this.instantiatesCanonical;
        }

        public CarePlanActivityPlannedActivityDetailComponent setInstantiatesCanonical(List<CanonicalType> theInstantiatesCanonical) {
            this.instantiatesCanonical = theInstantiatesCanonical;
            return this;
        }

        public boolean hasInstantiatesCanonical() {
            if (this.instantiatesCanonical == null) {
                return false;
            }
            for (CanonicalType item : this.instantiatesCanonical) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CanonicalType addInstantiatesCanonicalElement() {
            CanonicalType t = new CanonicalType();
            if (this.instantiatesCanonical == null) {
                this.instantiatesCanonical = new ArrayList<CanonicalType>();
            }
            this.instantiatesCanonical.add(t);
            return t;
        }

        public CarePlanActivityPlannedActivityDetailComponent addInstantiatesCanonical(String value) {
            CanonicalType t = new CanonicalType();
            t.setValue(value);
            if (this.instantiatesCanonical == null) {
                this.instantiatesCanonical = new ArrayList<CanonicalType>();
            }
            this.instantiatesCanonical.add(t);
            return this;
        }

        public boolean hasInstantiatesCanonical(String value) {
            if (this.instantiatesCanonical == null) {
                return false;
            }
            for (CanonicalType v : this.instantiatesCanonical) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<UriType> getInstantiatesUri() {
            if (this.instantiatesUri == null) {
                this.instantiatesUri = new ArrayList<UriType>();
            }
            return this.instantiatesUri;
        }

        public CarePlanActivityPlannedActivityDetailComponent setInstantiatesUri(List<UriType> theInstantiatesUri) {
            this.instantiatesUri = theInstantiatesUri;
            return this;
        }

        public boolean hasInstantiatesUri() {
            if (this.instantiatesUri == null) {
                return false;
            }
            for (UriType item : this.instantiatesUri) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public UriType addInstantiatesUriElement() {
            UriType t = new UriType();
            if (this.instantiatesUri == null) {
                this.instantiatesUri = new ArrayList<UriType>();
            }
            this.instantiatesUri.add(t);
            return t;
        }

        public CarePlanActivityPlannedActivityDetailComponent addInstantiatesUri(String value) {
            UriType t = new UriType();
            t.setValue(value);
            if (this.instantiatesUri == null) {
                this.instantiatesUri = new ArrayList<UriType>();
            }
            this.instantiatesUri.add(t);
            return this;
        }

        public boolean hasInstantiatesUri(String value) {
            if (this.instantiatesUri == null) {
                return false;
            }
            for (UriType v : this.instantiatesUri) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CarePlanActivityPlannedActivityDetailComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public CarePlanActivityPlannedActivityDetailComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public List<CodeableReference> getReason() {
            if (this.reason == null) {
                this.reason = new ArrayList<CodeableReference>();
            }
            return this.reason;
        }

        public CarePlanActivityPlannedActivityDetailComponent setReason(List<CodeableReference> theReason) {
            this.reason = theReason;
            return this;
        }

        public boolean hasReason() {
            if (this.reason == null) {
                return false;
            }
            for (CodeableReference item : this.reason) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableReference addReason() {
            CodeableReference t = new CodeableReference();
            if (this.reason == null) {
                this.reason = new ArrayList<CodeableReference>();
            }
            this.reason.add(t);
            return t;
        }

        public CarePlanActivityPlannedActivityDetailComponent addReason(CodeableReference t) {
            if (t == null) {
                return this;
            }
            if (this.reason == null) {
                this.reason = new ArrayList<CodeableReference>();
            }
            this.reason.add(t);
            return this;
        }

        public CodeableReference getReasonFirstRep() {
            if (this.getReason().isEmpty()) {
                this.addReason();
            }
            return this.getReason().get(0);
        }

        public List<Reference> getGoal() {
            if (this.goal == null) {
                this.goal = new ArrayList<Reference>();
            }
            return this.goal;
        }

        public CarePlanActivityPlannedActivityDetailComponent setGoal(List<Reference> theGoal) {
            this.goal = theGoal;
            return this;
        }

        public boolean hasGoal() {
            if (this.goal == null) {
                return false;
            }
            for (Reference item : this.goal) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addGoal() {
            Reference t = new Reference();
            if (this.goal == null) {
                this.goal = new ArrayList<Reference>();
            }
            this.goal.add(t);
            return t;
        }

        public CarePlanActivityPlannedActivityDetailComponent addGoal(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.goal == null) {
                this.goal = new ArrayList<Reference>();
            }
            this.goal.add(t);
            return this;
        }

        public Reference getGoalFirstRep() {
            if (this.getGoal().isEmpty()) {
                this.addGoal();
            }
            return this.getGoal().get(0);
        }

        public Enumeration<CarePlanActivityStatus> getStatusElement() {
            if (this.status == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CarePlanActivityPlannedActivityDetailComponent.status");
                }
                if (Configuration.doAutoCreate()) {
                    this.status = new Enumeration<CarePlanActivityStatus>(new CarePlanActivityStatusEnumFactory());
                }
            }
            return this.status;
        }

        public boolean hasStatusElement() {
            return this.status != null && !this.status.isEmpty();
        }

        public boolean hasStatus() {
            return this.status != null && !this.status.isEmpty();
        }

        public CarePlanActivityPlannedActivityDetailComponent setStatusElement(Enumeration<CarePlanActivityStatus> value) {
            this.status = value;
            return this;
        }

        public CarePlanActivityStatus getStatus() {
            return this.status == null ? null : (CarePlanActivityStatus)((Object)this.status.getValue());
        }

        public CarePlanActivityPlannedActivityDetailComponent setStatus(CarePlanActivityStatus value) {
            if (this.status == null) {
                this.status = new Enumeration<CarePlanActivityStatus>(new CarePlanActivityStatusEnumFactory());
            }
            this.status.setValue((Object)value);
            return this;
        }

        public CodeableConcept getStatusReason() {
            if (this.statusReason == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CarePlanActivityPlannedActivityDetailComponent.statusReason");
                }
                if (Configuration.doAutoCreate()) {
                    this.statusReason = new CodeableConcept();
                }
            }
            return this.statusReason;
        }

        public boolean hasStatusReason() {
            return this.statusReason != null && !this.statusReason.isEmpty();
        }

        public CarePlanActivityPlannedActivityDetailComponent setStatusReason(CodeableConcept value) {
            this.statusReason = value;
            return this;
        }

        public BooleanType getDoNotPerformElement() {
            if (this.doNotPerform == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CarePlanActivityPlannedActivityDetailComponent.doNotPerform");
                }
                if (Configuration.doAutoCreate()) {
                    this.doNotPerform = new BooleanType();
                }
            }
            return this.doNotPerform;
        }

        public boolean hasDoNotPerformElement() {
            return this.doNotPerform != null && !this.doNotPerform.isEmpty();
        }

        public boolean hasDoNotPerform() {
            return this.doNotPerform != null && !this.doNotPerform.isEmpty();
        }

        public CarePlanActivityPlannedActivityDetailComponent setDoNotPerformElement(BooleanType value) {
            this.doNotPerform = value;
            return this;
        }

        public boolean getDoNotPerform() {
            return this.doNotPerform == null || this.doNotPerform.isEmpty() ? false : (Boolean)this.doNotPerform.getValue();
        }

        public CarePlanActivityPlannedActivityDetailComponent setDoNotPerform(boolean value) {
            if (this.doNotPerform == null) {
                this.doNotPerform = new BooleanType();
            }
            this.doNotPerform.setValue((Object)value);
            return this;
        }

        public DataType getScheduled() {
            return this.scheduled;
        }

        public Timing getScheduledTiming() throws FHIRException {
            if (this.scheduled == null) {
                this.scheduled = new Timing();
            }
            if (!(this.scheduled instanceof Timing)) {
                throw new FHIRException("Type mismatch: the type Timing was expected, but " + this.scheduled.getClass().getName() + " was encountered");
            }
            return (Timing)this.scheduled;
        }

        public boolean hasScheduledTiming() {
            return this != null && this.scheduled instanceof Timing;
        }

        public Period getScheduledPeriod() throws FHIRException {
            if (this.scheduled == null) {
                this.scheduled = new Period();
            }
            if (!(this.scheduled instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.scheduled.getClass().getName() + " was encountered");
            }
            return (Period)this.scheduled;
        }

        public boolean hasScheduledPeriod() {
            return this != null && this.scheduled instanceof Period;
        }

        public StringType getScheduledStringType() throws FHIRException {
            if (this.scheduled == null) {
                this.scheduled = new StringType();
            }
            if (!(this.scheduled instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.scheduled.getClass().getName() + " was encountered");
            }
            return (StringType)this.scheduled;
        }

        public boolean hasScheduledStringType() {
            return this != null && this.scheduled instanceof StringType;
        }

        public boolean hasScheduled() {
            return this.scheduled != null && !this.scheduled.isEmpty();
        }

        public CarePlanActivityPlannedActivityDetailComponent setScheduled(DataType value) {
            if (!(value == null || value instanceof Timing || value instanceof Period || value instanceof StringType)) {
                throw new Error("Not the right type for CarePlan.activity.plannedActivityDetail.scheduled[x]: " + value.fhirType());
            }
            this.scheduled = value;
            return this;
        }

        public CodeableReference getLocation() {
            if (this.location == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CarePlanActivityPlannedActivityDetailComponent.location");
                }
                if (Configuration.doAutoCreate()) {
                    this.location = new CodeableReference();
                }
            }
            return this.location;
        }

        public boolean hasLocation() {
            return this.location != null && !this.location.isEmpty();
        }

        public CarePlanActivityPlannedActivityDetailComponent setLocation(CodeableReference value) {
            this.location = value;
            return this;
        }

        public DataType getReported() {
            return this.reported;
        }

        public BooleanType getReportedBooleanType() throws FHIRException {
            if (this.reported == null) {
                this.reported = new BooleanType();
            }
            if (!(this.reported instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.reported.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.reported;
        }

        public boolean hasReportedBooleanType() {
            return this != null && this.reported instanceof BooleanType;
        }

        public Reference getReportedReference() throws FHIRException {
            if (this.reported == null) {
                this.reported = new Reference();
            }
            if (!(this.reported instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.reported.getClass().getName() + " was encountered");
            }
            return (Reference)this.reported;
        }

        public boolean hasReportedReference() {
            return this != null && this.reported instanceof Reference;
        }

        public boolean hasReported() {
            return this.reported != null && !this.reported.isEmpty();
        }

        public CarePlanActivityPlannedActivityDetailComponent setReported(DataType value) {
            if (value != null && !(value instanceof BooleanType) && !(value instanceof Reference)) {
                throw new Error("Not the right type for CarePlan.activity.plannedActivityDetail.reported[x]: " + value.fhirType());
            }
            this.reported = value;
            return this;
        }

        public List<Reference> getPerformer() {
            if (this.performer == null) {
                this.performer = new ArrayList<Reference>();
            }
            return this.performer;
        }

        public CarePlanActivityPlannedActivityDetailComponent setPerformer(List<Reference> thePerformer) {
            this.performer = thePerformer;
            return this;
        }

        public boolean hasPerformer() {
            if (this.performer == null) {
                return false;
            }
            for (Reference item : this.performer) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addPerformer() {
            Reference t = new Reference();
            if (this.performer == null) {
                this.performer = new ArrayList<Reference>();
            }
            this.performer.add(t);
            return t;
        }

        public CarePlanActivityPlannedActivityDetailComponent addPerformer(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.performer == null) {
                this.performer = new ArrayList<Reference>();
            }
            this.performer.add(t);
            return this;
        }

        public Reference getPerformerFirstRep() {
            if (this.getPerformer().isEmpty()) {
                this.addPerformer();
            }
            return this.getPerformer().get(0);
        }

        public DataType getProduct() {
            return this.product;
        }

        public CodeableConcept getProductCodeableConcept() throws FHIRException {
            if (this.product == null) {
                this.product = new CodeableConcept();
            }
            if (!(this.product instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.product.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.product;
        }

        public boolean hasProductCodeableConcept() {
            return this != null && this.product instanceof CodeableConcept;
        }

        public Reference getProductReference() throws FHIRException {
            if (this.product == null) {
                this.product = new Reference();
            }
            if (!(this.product instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.product.getClass().getName() + " was encountered");
            }
            return (Reference)this.product;
        }

        public boolean hasProductReference() {
            return this != null && this.product instanceof Reference;
        }

        public boolean hasProduct() {
            return this.product != null && !this.product.isEmpty();
        }

        public CarePlanActivityPlannedActivityDetailComponent setProduct(DataType value) {
            if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
                throw new Error("Not the right type for CarePlan.activity.plannedActivityDetail.product[x]: " + value.fhirType());
            }
            this.product = value;
            return this;
        }

        public Quantity getDailyAmount() {
            if (this.dailyAmount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CarePlanActivityPlannedActivityDetailComponent.dailyAmount");
                }
                if (Configuration.doAutoCreate()) {
                    this.dailyAmount = new Quantity();
                }
            }
            return this.dailyAmount;
        }

        public boolean hasDailyAmount() {
            return this.dailyAmount != null && !this.dailyAmount.isEmpty();
        }

        public CarePlanActivityPlannedActivityDetailComponent setDailyAmount(Quantity value) {
            this.dailyAmount = value;
            return this;
        }

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CarePlanActivityPlannedActivityDetailComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public CarePlanActivityPlannedActivityDetailComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CarePlanActivityPlannedActivityDetailComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public CarePlanActivityPlannedActivityDetailComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public CarePlanActivityPlannedActivityDetailComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("kind", "code", "A description of the kind of resource the in-line definition of a care plan activity is representing.  The CarePlan.activity.detail is an in-line definition when a resource is not referenced using CarePlan.activity.reference.  For example, a MedicationRequest, a ServiceRequest, or a CommunicationRequest.", 0, 1, this.kind));
            children.add(new Property("instantiatesCanonical", "canonical(PlanDefinition|ActivityDefinition|Questionnaire|Measure|OperationDefinition)", "The URL pointing to a FHIR-defined protocol, guideline, questionnaire or other definition that is adhered to in whole or in part by this CarePlan activity.", 0, Integer.MAX_VALUE, this.instantiatesCanonical));
            children.add(new Property("instantiatesUri", "uri", "The URL pointing to an externally maintained protocol, guideline, questionnaire or other definition that is adhered to in whole or in part by this CarePlan activity.", 0, Integer.MAX_VALUE, this.instantiatesUri));
            children.add(new Property("code", "CodeableConcept", "Detailed description of the type of planned activity; e.g. what lab test, what procedure, what kind of encounter.", 0, 1, this.code));
            children.add(new Property("reason", "CodeableReference(Condition|Observation|DiagnosticReport|DocumentReference)", "Provides the rationale that drove the inclusion of this particular activity as part of the plan or the reason why the activity was prohibited - either a coded concept, or another resource, such as the health condition(s), whose existence justifies this request and drove the inclusion of this particular activity as part of the plan.", 0, Integer.MAX_VALUE, this.reason));
            children.add(new Property(CarePlan.SP_GOAL, "Reference(Goal)", "Internal reference that identifies the goals that this activity is intended to contribute towards meeting.", 0, Integer.MAX_VALUE, this.goal));
            children.add(new Property(CarePlan.SP_STATUS, "code", "Identifies what progress is being made for the specific activity.", 0, 1, this.status));
            children.add(new Property("statusReason", "CodeableConcept", "Provides reason why the activity isn't yet started, is on hold, was cancelled, etc.", 0, 1, this.statusReason));
            children.add(new Property("doNotPerform", "boolean", "If true, indicates that the described activity is one that must NOT be engaged in when following the plan.  If false, or missing, indicates that the described activity is one that should be engaged in when following the plan.", 0, 1, this.doNotPerform));
            children.add(new Property("scheduled[x]", "Timing|Period|string", "The period, timing or frequency upon which the described activity is to occur.", 0, 1, this.scheduled));
            children.add(new Property("location", "CodeableReference(Location)", "Identifies the facility where the activity will occur; e.g. home, hospital, specific clinic, etc.", 0, 1, this.location));
            children.add(new Property("reported[x]", "boolean|Reference(Patient|RelatedPerson|Practitioner|PractitionerRole|Organization)", "Indicates if this record was captured as a secondary 'reported' record rather than as an original primary source-of-truth record.  It may also indicate the source of the report.", 0, 1, this.reported));
            children.add(new Property(CarePlan.SP_PERFORMER, "Reference(Practitioner|PractitionerRole|Organization|RelatedPerson|Patient|CareTeam|HealthcareService|Device)", "Identifies who's expected to be involved in the activity.", 0, Integer.MAX_VALUE, this.performer));
            children.add(new Property("product[x]", "CodeableConcept|Reference(Medication|Substance)", "Identifies the food, drug or other product to be consumed or supplied in the activity.", 0, 1, this.product));
            children.add(new Property("dailyAmount", "Quantity", "Identifies the quantity expected to be consumed in a given day.", 0, 1, this.dailyAmount));
            children.add(new Property("quantity", "Quantity", "Identifies the quantity expected to be supplied, administered or consumed by the subject.", 0, 1, this.quantity));
            children.add(new Property("description", "string", "This provides a textual description of constraints on the intended activity occurrence, including relation to other activities.  It may also include objectives, pre-conditions and end-conditions.  Finally, it may convey specifics about the activity such as body site, method, route, etc.", 0, 1, this.description));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3292052: {
                    return new Property("kind", "code", "A description of the kind of resource the in-line definition of a care plan activity is representing.  The CarePlan.activity.detail is an in-line definition when a resource is not referenced using CarePlan.activity.reference.  For example, a MedicationRequest, a ServiceRequest, or a CommunicationRequest.", 0, 1, this.kind);
                }
                case 8911915: {
                    return new Property("instantiatesCanonical", "canonical(PlanDefinition|ActivityDefinition|Questionnaire|Measure|OperationDefinition)", "The URL pointing to a FHIR-defined protocol, guideline, questionnaire or other definition that is adhered to in whole or in part by this CarePlan activity.", 0, Integer.MAX_VALUE, this.instantiatesCanonical);
                }
                case -1926393373: {
                    return new Property("instantiatesUri", "uri", "The URL pointing to an externally maintained protocol, guideline, questionnaire or other definition that is adhered to in whole or in part by this CarePlan activity.", 0, Integer.MAX_VALUE, this.instantiatesUri);
                }
                case 3059181: {
                    return new Property("code", "CodeableConcept", "Detailed description of the type of planned activity; e.g. what lab test, what procedure, what kind of encounter.", 0, 1, this.code);
                }
                case -934964668: {
                    return new Property("reason", "CodeableReference(Condition|Observation|DiagnosticReport|DocumentReference)", "Provides the rationale that drove the inclusion of this particular activity as part of the plan or the reason why the activity was prohibited - either a coded concept, or another resource, such as the health condition(s), whose existence justifies this request and drove the inclusion of this particular activity as part of the plan.", 0, Integer.MAX_VALUE, this.reason);
                }
                case 3178259: {
                    return new Property(CarePlan.SP_GOAL, "Reference(Goal)", "Internal reference that identifies the goals that this activity is intended to contribute towards meeting.", 0, Integer.MAX_VALUE, this.goal);
                }
                case -892481550: {
                    return new Property(CarePlan.SP_STATUS, "code", "Identifies what progress is being made for the specific activity.", 0, 1, this.status);
                }
                case 2051346646: {
                    return new Property("statusReason", "CodeableConcept", "Provides reason why the activity isn't yet started, is on hold, was cancelled, etc.", 0, 1, this.statusReason);
                }
                case -1788508167: {
                    return new Property("doNotPerform", "boolean", "If true, indicates that the described activity is one that must NOT be engaged in when following the plan.  If false, or missing, indicates that the described activity is one that should be engaged in when following the plan.", 0, 1, this.doNotPerform);
                }
                case 1162627251: {
                    return new Property("scheduled[x]", "Timing|Period|string", "The period, timing or frequency upon which the described activity is to occur.", 0, 1, this.scheduled);
                }
                case -160710483: {
                    return new Property("scheduled[x]", "Timing|Period|string", "The period, timing or frequency upon which the described activity is to occur.", 0, 1, this.scheduled);
                }
                case 998483799: {
                    return new Property("scheduled[x]", "Timing", "The period, timing or frequency upon which the described activity is to occur.", 0, 1, this.scheduled);
                }
                case 880422094: {
                    return new Property("scheduled[x]", "Period", "The period, timing or frequency upon which the described activity is to occur.", 0, 1, this.scheduled);
                }
                case 980162334: {
                    return new Property("scheduled[x]", "string", "The period, timing or frequency upon which the described activity is to occur.", 0, 1, this.scheduled);
                }
                case 1901043637: {
                    return new Property("location", "CodeableReference(Location)", "Identifies the facility where the activity will occur; e.g. home, hospital, specific clinic, etc.", 0, 1, this.location);
                }
                case -241505587: {
                    return new Property("reported[x]", "boolean|Reference(Patient|RelatedPerson|Practitioner|PractitionerRole|Organization)", "Indicates if this record was captured as a secondary 'reported' record rather than as an original primary source-of-truth record.  It may also indicate the source of the report.", 0, 1, this.reported);
                }
                case -427039533: {
                    return new Property("reported[x]", "boolean|Reference(Patient|RelatedPerson|Practitioner|PractitionerRole|Organization)", "Indicates if this record was captured as a secondary 'reported' record rather than as an original primary source-of-truth record.  It may also indicate the source of the report.", 0, 1, this.reported);
                }
                case 1219992533: {
                    return new Property("reported[x]", "boolean", "Indicates if this record was captured as a secondary 'reported' record rather than as an original primary source-of-truth record.  It may also indicate the source of the report.", 0, 1, this.reported);
                }
                case 1198143416: {
                    return new Property("reported[x]", "Reference(Patient|RelatedPerson|Practitioner|PractitionerRole|Organization)", "Indicates if this record was captured as a secondary 'reported' record rather than as an original primary source-of-truth record.  It may also indicate the source of the report.", 0, 1, this.reported);
                }
                case 481140686: {
                    return new Property(CarePlan.SP_PERFORMER, "Reference(Practitioner|PractitionerRole|Organization|RelatedPerson|Patient|CareTeam|HealthcareService|Device)", "Identifies who's expected to be involved in the activity.", 0, Integer.MAX_VALUE, this.performer);
                }
                case 1753005361: {
                    return new Property("product[x]", "CodeableConcept|Reference(Medication|Substance)", "Identifies the food, drug or other product to be consumed or supplied in the activity.", 0, 1, this.product);
                }
                case -309474065: {
                    return new Property("product[x]", "CodeableConcept|Reference(Medication|Substance)", "Identifies the food, drug or other product to be consumed or supplied in the activity.", 0, 1, this.product);
                }
                case 906854066: {
                    return new Property("product[x]", "CodeableConcept", "Identifies the food, drug or other product to be consumed or supplied in the activity.", 0, 1, this.product);
                }
                case -669667556: {
                    return new Property("product[x]", "Reference(Medication|Substance)", "Identifies the food, drug or other product to be consumed or supplied in the activity.", 0, 1, this.product);
                }
                case -768908335: {
                    return new Property("dailyAmount", "Quantity", "Identifies the quantity expected to be consumed in a given day.", 0, 1, this.dailyAmount);
                }
                case -1285004149: {
                    return new Property("quantity", "Quantity", "Identifies the quantity expected to be supplied, administered or consumed by the subject.", 0, 1, this.quantity);
                }
                case -1724546052: {
                    return new Property("description", "string", "This provides a textual description of constraints on the intended activity occurrence, including relation to other activities.  It may also include objectives, pre-conditions and end-conditions.  Finally, it may convey specifics about the activity such as body site, method, route, etc.", 0, 1, this.description);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3292052: {
                    Base[] baseArray;
                    if (this.kind == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.kind;
                    }
                    return baseArray;
                }
                case 8911915: {
                    return this.instantiatesCanonical == null ? new Base[]{} : this.instantiatesCanonical.toArray(new Base[this.instantiatesCanonical.size()]);
                }
                case -1926393373: {
                    return this.instantiatesUri == null ? new Base[]{} : this.instantiatesUri.toArray(new Base[this.instantiatesUri.size()]);
                }
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.code;
                    }
                    return baseArray;
                }
                case -934964668: {
                    return this.reason == null ? new Base[]{} : this.reason.toArray(new Base[this.reason.size()]);
                }
                case 3178259: {
                    return this.goal == null ? new Base[]{} : this.goal.toArray(new Base[this.goal.size()]);
                }
                case -892481550: {
                    Base[] baseArray;
                    if (this.status == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.status;
                    }
                    return baseArray;
                }
                case 2051346646: {
                    Base[] baseArray;
                    if (this.statusReason == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.statusReason;
                    }
                    return baseArray;
                }
                case -1788508167: {
                    Base[] baseArray;
                    if (this.doNotPerform == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.doNotPerform;
                    }
                    return baseArray;
                }
                case -160710483: {
                    Base[] baseArray;
                    if (this.scheduled == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.scheduled;
                    }
                    return baseArray;
                }
                case 1901043637: {
                    Base[] baseArray;
                    if (this.location == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.location;
                    }
                    return baseArray;
                }
                case -427039533: {
                    Base[] baseArray;
                    if (this.reported == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.reported;
                    }
                    return baseArray;
                }
                case 481140686: {
                    return this.performer == null ? new Base[]{} : this.performer.toArray(new Base[this.performer.size()]);
                }
                case -309474065: {
                    Base[] baseArray;
                    if (this.product == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.product;
                    }
                    return baseArray;
                }
                case -768908335: {
                    Base[] baseArray;
                    if (this.dailyAmount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray11 = new Base[1];
                        baseArray = baseArray11;
                        baseArray11[0] = this.dailyAmount;
                    }
                    return baseArray;
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray12 = new Base[1];
                        baseArray = baseArray12;
                        baseArray12[0] = this.quantity;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray13 = new Base[1];
                        baseArray = baseArray13;
                        baseArray13[0] = this.description;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3292052: {
                    value = new CarePlanActivityKindEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.kind = value;
                    return value;
                }
                case 8911915: {
                    this.getInstantiatesCanonical().add(TypeConvertor.castToCanonical(value));
                    return value;
                }
                case -1926393373: {
                    this.getInstantiatesUri().add(TypeConvertor.castToUri(value));
                    return value;
                }
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -934964668: {
                    this.getReason().add(TypeConvertor.castToCodeableReference(value));
                    return value;
                }
                case 3178259: {
                    this.getGoal().add(TypeConvertor.castToReference(value));
                    return value;
                }
                case -892481550: {
                    value = new CarePlanActivityStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.status = value;
                    return value;
                }
                case 2051346646: {
                    this.statusReason = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1788508167: {
                    this.doNotPerform = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -160710483: {
                    this.scheduled = TypeConvertor.castToType(value);
                    return value;
                }
                case 1901043637: {
                    this.location = TypeConvertor.castToCodeableReference(value);
                    return value;
                }
                case -427039533: {
                    this.reported = TypeConvertor.castToType(value);
                    return value;
                }
                case 481140686: {
                    this.getPerformer().add(TypeConvertor.castToReference(value));
                    return value;
                }
                case -309474065: {
                    this.product = TypeConvertor.castToType(value);
                    return value;
                }
                case -768908335: {
                    this.dailyAmount = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case -1285004149: {
                    this.quantity = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("kind")) {
                value = new CarePlanActivityKindEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.kind = value;
            } else if (name.equals("instantiatesCanonical")) {
                this.getInstantiatesCanonical().add(TypeConvertor.castToCanonical(value));
            } else if (name.equals("instantiatesUri")) {
                this.getInstantiatesUri().add(TypeConvertor.castToUri(value));
            } else if (name.equals("code")) {
                this.code = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("reason")) {
                this.getReason().add(TypeConvertor.castToCodeableReference(value));
            } else if (name.equals(CarePlan.SP_GOAL)) {
                this.getGoal().add(TypeConvertor.castToReference(value));
            } else if (name.equals(CarePlan.SP_STATUS)) {
                value = new CarePlanActivityStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
            } else if (name.equals("statusReason")) {
                this.statusReason = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("doNotPerform")) {
                this.doNotPerform = TypeConvertor.castToBoolean(value);
            } else if (name.equals("scheduled[x]")) {
                this.scheduled = TypeConvertor.castToType(value);
            } else if (name.equals("location")) {
                this.location = TypeConvertor.castToCodeableReference(value);
            } else if (name.equals("reported[x]")) {
                this.reported = TypeConvertor.castToType(value);
            } else if (name.equals(CarePlan.SP_PERFORMER)) {
                this.getPerformer().add(TypeConvertor.castToReference(value));
            } else if (name.equals("product[x]")) {
                this.product = TypeConvertor.castToType(value);
            } else if (name.equals("dailyAmount")) {
                this.dailyAmount = TypeConvertor.castToQuantity(value);
            } else if (name.equals("quantity")) {
                this.quantity = TypeConvertor.castToQuantity(value);
            } else if (name.equals("description")) {
                this.description = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3292052: {
                    return this.getKindElement();
                }
                case 8911915: {
                    return this.addInstantiatesCanonicalElement();
                }
                case -1926393373: {
                    return this.addInstantiatesUriElement();
                }
                case 3059181: {
                    return this.getCode();
                }
                case -934964668: {
                    return this.addReason();
                }
                case 3178259: {
                    return this.addGoal();
                }
                case -892481550: {
                    return this.getStatusElement();
                }
                case 2051346646: {
                    return this.getStatusReason();
                }
                case -1788508167: {
                    return this.getDoNotPerformElement();
                }
                case 1162627251: {
                    return this.getScheduled();
                }
                case -160710483: {
                    return this.getScheduled();
                }
                case 1901043637: {
                    return this.getLocation();
                }
                case -241505587: {
                    return this.getReported();
                }
                case -427039533: {
                    return this.getReported();
                }
                case 481140686: {
                    return this.addPerformer();
                }
                case 1753005361: {
                    return this.getProduct();
                }
                case -309474065: {
                    return this.getProduct();
                }
                case -768908335: {
                    return this.getDailyAmount();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3292052: {
                    return new String[]{"code"};
                }
                case 8911915: {
                    return new String[]{"canonical"};
                }
                case -1926393373: {
                    return new String[]{"uri"};
                }
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case -934964668: {
                    return new String[]{"CodeableReference"};
                }
                case 3178259: {
                    return new String[]{"Reference"};
                }
                case -892481550: {
                    return new String[]{"code"};
                }
                case 2051346646: {
                    return new String[]{"CodeableConcept"};
                }
                case -1788508167: {
                    return new String[]{"boolean"};
                }
                case -160710483: {
                    return new String[]{"Timing", "Period", "string"};
                }
                case 1901043637: {
                    return new String[]{"CodeableReference"};
                }
                case -427039533: {
                    return new String[]{"boolean", "Reference"};
                }
                case 481140686: {
                    return new String[]{"Reference"};
                }
                case -309474065: {
                    return new String[]{"CodeableConcept", "Reference"};
                }
                case -768908335: {
                    return new String[]{"Quantity"};
                }
                case -1285004149: {
                    return new String[]{"Quantity"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("kind")) {
                throw new FHIRException("Cannot call addChild on a primitive type CarePlan.activity.plannedActivityDetail.kind");
            }
            if (name.equals("instantiatesCanonical")) {
                throw new FHIRException("Cannot call addChild on a primitive type CarePlan.activity.plannedActivityDetail.instantiatesCanonical");
            }
            if (name.equals("instantiatesUri")) {
                throw new FHIRException("Cannot call addChild on a primitive type CarePlan.activity.plannedActivityDetail.instantiatesUri");
            }
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("reason")) {
                return this.addReason();
            }
            if (name.equals(CarePlan.SP_GOAL)) {
                return this.addGoal();
            }
            if (name.equals(CarePlan.SP_STATUS)) {
                throw new FHIRException("Cannot call addChild on a primitive type CarePlan.activity.plannedActivityDetail.status");
            }
            if (name.equals("statusReason")) {
                this.statusReason = new CodeableConcept();
                return this.statusReason;
            }
            if (name.equals("doNotPerform")) {
                throw new FHIRException("Cannot call addChild on a primitive type CarePlan.activity.plannedActivityDetail.doNotPerform");
            }
            if (name.equals("scheduledTiming")) {
                this.scheduled = new Timing();
                return this.scheduled;
            }
            if (name.equals("scheduledPeriod")) {
                this.scheduled = new Period();
                return this.scheduled;
            }
            if (name.equals("scheduledString")) {
                this.scheduled = new StringType();
                return this.scheduled;
            }
            if (name.equals("location")) {
                this.location = new CodeableReference();
                return this.location;
            }
            if (name.equals("reportedBoolean")) {
                this.reported = new BooleanType();
                return this.reported;
            }
            if (name.equals("reportedReference")) {
                this.reported = new Reference();
                return this.reported;
            }
            if (name.equals(CarePlan.SP_PERFORMER)) {
                return this.addPerformer();
            }
            if (name.equals("productCodeableConcept")) {
                this.product = new CodeableConcept();
                return this.product;
            }
            if (name.equals("productReference")) {
                this.product = new Reference();
                return this.product;
            }
            if (name.equals("dailyAmount")) {
                this.dailyAmount = new Quantity();
                return this.dailyAmount;
            }
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type CarePlan.activity.plannedActivityDetail.description");
            }
            return super.addChild(name);
        }

        @Override
        public CarePlanActivityPlannedActivityDetailComponent copy() {
            CarePlanActivityPlannedActivityDetailComponent dst = new CarePlanActivityPlannedActivityDetailComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CarePlanActivityPlannedActivityDetailComponent dst) {
            super.copyValues(dst);
            Enumeration<CarePlanActivityKind> enumeration = dst.kind = this.kind == null ? null : this.kind.copy();
            if (this.instantiatesCanonical != null) {
                dst.instantiatesCanonical = new ArrayList<CanonicalType>();
                for (CanonicalType canonicalType : this.instantiatesCanonical) {
                    dst.instantiatesCanonical.add(canonicalType.copy());
                }
            }
            if (this.instantiatesUri != null) {
                dst.instantiatesUri = new ArrayList<UriType>();
                for (UriType uriType : this.instantiatesUri) {
                    dst.instantiatesUri.add(uriType.copy());
                }
            }
            CodeableConcept codeableConcept = dst.code = this.code == null ? null : this.code.copy();
            if (this.reason != null) {
                dst.reason = new ArrayList<CodeableReference>();
                for (CodeableReference codeableReference : this.reason) {
                    dst.reason.add(codeableReference.copy());
                }
            }
            if (this.goal != null) {
                dst.goal = new ArrayList<Reference>();
                for (Reference reference : this.goal) {
                    dst.goal.add(reference.copy());
                }
            }
            dst.status = this.status == null ? null : this.status.copy();
            dst.statusReason = this.statusReason == null ? null : this.statusReason.copy();
            dst.doNotPerform = this.doNotPerform == null ? null : this.doNotPerform.copy();
            dst.scheduled = this.scheduled == null ? null : this.scheduled.copy();
            dst.location = this.location == null ? null : this.location.copy();
            DataType dataType = dst.reported = this.reported == null ? null : this.reported.copy();
            if (this.performer != null) {
                dst.performer = new ArrayList<Reference>();
                for (Reference reference : this.performer) {
                    dst.performer.add(reference.copy());
                }
            }
            dst.product = this.product == null ? null : this.product.copy();
            dst.dailyAmount = this.dailyAmount == null ? null : this.dailyAmount.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.description = this.description == null ? null : this.description.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CarePlanActivityPlannedActivityDetailComponent)) {
                return false;
            }
            CarePlanActivityPlannedActivityDetailComponent o = (CarePlanActivityPlannedActivityDetailComponent)other_;
            return CarePlanActivityPlannedActivityDetailComponent.compareDeep(this.kind, o.kind, true) && CarePlanActivityPlannedActivityDetailComponent.compareDeep(this.instantiatesCanonical, o.instantiatesCanonical, true) && CarePlanActivityPlannedActivityDetailComponent.compareDeep(this.instantiatesUri, o.instantiatesUri, true) && CarePlanActivityPlannedActivityDetailComponent.compareDeep(this.code, o.code, true) && CarePlanActivityPlannedActivityDetailComponent.compareDeep(this.reason, o.reason, true) && CarePlanActivityPlannedActivityDetailComponent.compareDeep(this.goal, o.goal, true) && CarePlanActivityPlannedActivityDetailComponent.compareDeep(this.status, o.status, true) && CarePlanActivityPlannedActivityDetailComponent.compareDeep(this.statusReason, o.statusReason, true) && CarePlanActivityPlannedActivityDetailComponent.compareDeep(this.doNotPerform, o.doNotPerform, true) && CarePlanActivityPlannedActivityDetailComponent.compareDeep(this.scheduled, o.scheduled, true) && CarePlanActivityPlannedActivityDetailComponent.compareDeep(this.location, o.location, true) && CarePlanActivityPlannedActivityDetailComponent.compareDeep(this.reported, o.reported, true) && CarePlanActivityPlannedActivityDetailComponent.compareDeep(this.performer, o.performer, true) && CarePlanActivityPlannedActivityDetailComponent.compareDeep(this.product, o.product, true) && CarePlanActivityPlannedActivityDetailComponent.compareDeep(this.dailyAmount, o.dailyAmount, true) && CarePlanActivityPlannedActivityDetailComponent.compareDeep(this.quantity, o.quantity, true) && CarePlanActivityPlannedActivityDetailComponent.compareDeep(this.description, o.description, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CarePlanActivityPlannedActivityDetailComponent)) {
                return false;
            }
            CarePlanActivityPlannedActivityDetailComponent o = (CarePlanActivityPlannedActivityDetailComponent)other_;
            return CarePlanActivityPlannedActivityDetailComponent.compareValues(this.kind, o.kind, true) && CarePlanActivityPlannedActivityDetailComponent.compareValues(this.instantiatesCanonical, o.instantiatesCanonical, true) && CarePlanActivityPlannedActivityDetailComponent.compareValues(this.instantiatesUri, o.instantiatesUri, true) && CarePlanActivityPlannedActivityDetailComponent.compareValues(this.status, o.status, true) && CarePlanActivityPlannedActivityDetailComponent.compareValues(this.doNotPerform, o.doNotPerform, true) && CarePlanActivityPlannedActivityDetailComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.kind, this.instantiatesCanonical, this.instantiatesUri, this.code, this.reason, this.goal, this.status, this.statusReason, this.doNotPerform, this.scheduled, this.location, this.reported, this.performer, this.product, this.dailyAmount, this.quantity, this.description});
        }

        @Override
        public String fhirType() {
            return "CarePlan.activity.plannedActivityDetail";
        }
    }

    @Block
    public static class CarePlanActivityComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="performedActivity", type={CodeableReference.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Results of the activity (concept, or Appointment, Encounter, Procedure, etc)", formalDefinition="Identifies the activity that was performed. For example, an activity could be patient education, exercise, or a medication administration. The reference to an \"event\" resource, such as Procedure or Encounter or Observation, represents the activity that was performed. The requested activity can be conveyed using CarePlan.activity.plannedActivityDetail OR using the CarePlan.activity.plannedActivityReference (a reference to a \u201crequest\u201d resource).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/care-plan-activity-performed")
        protected List<CodeableReference> performedActivity;
        @Child(name="progress", type={Annotation.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Comments about the activity status/progress", formalDefinition="Notes about the adherence/status/progress of the activity.")
        protected List<Annotation> progress;
        @Child(name="plannedActivityReference", type={Appointment.class, CommunicationRequest.class, DeviceRequest.class, MedicationRequest.class, NutritionOrder.class, Task.class, ServiceRequest.class, VisionPrescription.class, RequestOrchestration.class, ImmunizationRecommendation.class, SupplyRequest.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Activity that is intended to be part of the care plan", formalDefinition="The details of the proposed activity represented in a specific resource.")
        protected Reference plannedActivityReference;
        @Child(name="plannedActivityDetail", type={}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="In-line definition of activity", formalDefinition="A simple summary of a planned activity suitable for a general care plan system (e.g. form driven) that doesn't know about specific resources such as procedure etc.")
        protected CarePlanActivityPlannedActivityDetailComponent plannedActivityDetail;
        private static final long serialVersionUID = 1513409624L;

        public List<CodeableReference> getPerformedActivity() {
            if (this.performedActivity == null) {
                this.performedActivity = new ArrayList<CodeableReference>();
            }
            return this.performedActivity;
        }

        public CarePlanActivityComponent setPerformedActivity(List<CodeableReference> thePerformedActivity) {
            this.performedActivity = thePerformedActivity;
            return this;
        }

        public boolean hasPerformedActivity() {
            if (this.performedActivity == null) {
                return false;
            }
            for (CodeableReference item : this.performedActivity) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableReference addPerformedActivity() {
            CodeableReference t = new CodeableReference();
            if (this.performedActivity == null) {
                this.performedActivity = new ArrayList<CodeableReference>();
            }
            this.performedActivity.add(t);
            return t;
        }

        public CarePlanActivityComponent addPerformedActivity(CodeableReference t) {
            if (t == null) {
                return this;
            }
            if (this.performedActivity == null) {
                this.performedActivity = new ArrayList<CodeableReference>();
            }
            this.performedActivity.add(t);
            return this;
        }

        public CodeableReference getPerformedActivityFirstRep() {
            if (this.getPerformedActivity().isEmpty()) {
                this.addPerformedActivity();
            }
            return this.getPerformedActivity().get(0);
        }

        public List<Annotation> getProgress() {
            if (this.progress == null) {
                this.progress = new ArrayList<Annotation>();
            }
            return this.progress;
        }

        public CarePlanActivityComponent setProgress(List<Annotation> theProgress) {
            this.progress = theProgress;
            return this;
        }

        public boolean hasProgress() {
            if (this.progress == null) {
                return false;
            }
            for (Annotation item : this.progress) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Annotation addProgress() {
            Annotation t = new Annotation();
            if (this.progress == null) {
                this.progress = new ArrayList<Annotation>();
            }
            this.progress.add(t);
            return t;
        }

        public CarePlanActivityComponent addProgress(Annotation t) {
            if (t == null) {
                return this;
            }
            if (this.progress == null) {
                this.progress = new ArrayList<Annotation>();
            }
            this.progress.add(t);
            return this;
        }

        public Annotation getProgressFirstRep() {
            if (this.getProgress().isEmpty()) {
                this.addProgress();
            }
            return this.getProgress().get(0);
        }

        public Reference getPlannedActivityReference() {
            if (this.plannedActivityReference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CarePlanActivityComponent.plannedActivityReference");
                }
                if (Configuration.doAutoCreate()) {
                    this.plannedActivityReference = new Reference();
                }
            }
            return this.plannedActivityReference;
        }

        public boolean hasPlannedActivityReference() {
            return this.plannedActivityReference != null && !this.plannedActivityReference.isEmpty();
        }

        public CarePlanActivityComponent setPlannedActivityReference(Reference value) {
            this.plannedActivityReference = value;
            return this;
        }

        public CarePlanActivityPlannedActivityDetailComponent getPlannedActivityDetail() {
            if (this.plannedActivityDetail == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CarePlanActivityComponent.plannedActivityDetail");
                }
                if (Configuration.doAutoCreate()) {
                    this.plannedActivityDetail = new CarePlanActivityPlannedActivityDetailComponent();
                }
            }
            return this.plannedActivityDetail;
        }

        public boolean hasPlannedActivityDetail() {
            return this.plannedActivityDetail != null && !this.plannedActivityDetail.isEmpty();
        }

        public CarePlanActivityComponent setPlannedActivityDetail(CarePlanActivityPlannedActivityDetailComponent value) {
            this.plannedActivityDetail = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("performedActivity", "CodeableReference(Any)", "Identifies the activity that was performed. For example, an activity could be patient education, exercise, or a medication administration. The reference to an \"event\" resource, such as Procedure or Encounter or Observation, represents the activity that was performed. The requested activity can be conveyed using CarePlan.activity.plannedActivityDetail OR using the CarePlan.activity.plannedActivityReference (a reference to a \u201crequest\u201d resource).", 0, Integer.MAX_VALUE, this.performedActivity));
            children.add(new Property("progress", "Annotation", "Notes about the adherence/status/progress of the activity.", 0, Integer.MAX_VALUE, this.progress));
            children.add(new Property("plannedActivityReference", "Reference(Appointment|CommunicationRequest|DeviceRequest|MedicationRequest|NutritionOrder|Task|ServiceRequest|VisionPrescription|RequestOrchestration|ImmunizationRecommendation|SupplyRequest)", "The details of the proposed activity represented in a specific resource.", 0, 1, this.plannedActivityReference));
            children.add(new Property("plannedActivityDetail", "", "A simple summary of a planned activity suitable for a general care plan system (e.g. form driven) that doesn't know about specific resources such as procedure etc.", 0, 1, this.plannedActivityDetail));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1964521199: {
                    return new Property("performedActivity", "CodeableReference(Any)", "Identifies the activity that was performed. For example, an activity could be patient education, exercise, or a medication administration. The reference to an \"event\" resource, such as Procedure or Encounter or Observation, represents the activity that was performed. The requested activity can be conveyed using CarePlan.activity.plannedActivityDetail OR using the CarePlan.activity.plannedActivityReference (a reference to a \u201crequest\u201d resource).", 0, Integer.MAX_VALUE, this.performedActivity);
                }
                case -1001078227: {
                    return new Property("progress", "Annotation", "Notes about the adherence/status/progress of the activity.", 0, Integer.MAX_VALUE, this.progress);
                }
                case -1114371176: {
                    return new Property("plannedActivityReference", "Reference(Appointment|CommunicationRequest|DeviceRequest|MedicationRequest|NutritionOrder|Task|ServiceRequest|VisionPrescription|RequestOrchestration|ImmunizationRecommendation|SupplyRequest)", "The details of the proposed activity represented in a specific resource.", 0, 1, this.plannedActivityReference);
                }
                case 2072803108: {
                    return new Property("plannedActivityDetail", "", "A simple summary of a planned activity suitable for a general care plan system (e.g. form driven) that doesn't know about specific resources such as procedure etc.", 0, 1, this.plannedActivityDetail);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1964521199: {
                    return this.performedActivity == null ? new Base[]{} : this.performedActivity.toArray(new Base[this.performedActivity.size()]);
                }
                case -1001078227: {
                    return this.progress == null ? new Base[]{} : this.progress.toArray(new Base[this.progress.size()]);
                }
                case -1114371176: {
                    Base[] baseArray;
                    if (this.plannedActivityReference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.plannedActivityReference;
                    }
                    return baseArray;
                }
                case 2072803108: {
                    Base[] baseArray;
                    if (this.plannedActivityDetail == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.plannedActivityDetail;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1964521199: {
                    this.getPerformedActivity().add(TypeConvertor.castToCodeableReference(value));
                    return value;
                }
                case -1001078227: {
                    this.getProgress().add(TypeConvertor.castToAnnotation(value));
                    return value;
                }
                case -1114371176: {
                    this.plannedActivityReference = TypeConvertor.castToReference(value);
                    return value;
                }
                case 2072803108: {
                    this.plannedActivityDetail = (CarePlanActivityPlannedActivityDetailComponent)value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("performedActivity")) {
                this.getPerformedActivity().add(TypeConvertor.castToCodeableReference(value));
            } else if (name.equals("progress")) {
                this.getProgress().add(TypeConvertor.castToAnnotation(value));
            } else if (name.equals("plannedActivityReference")) {
                this.plannedActivityReference = TypeConvertor.castToReference(value);
            } else if (name.equals("plannedActivityDetail")) {
                this.plannedActivityDetail = (CarePlanActivityPlannedActivityDetailComponent)value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1964521199: {
                    return this.addPerformedActivity();
                }
                case -1001078227: {
                    return this.addProgress();
                }
                case -1114371176: {
                    return this.getPlannedActivityReference();
                }
                case 2072803108: {
                    return this.getPlannedActivityDetail();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1964521199: {
                    return new String[]{"CodeableReference"};
                }
                case -1001078227: {
                    return new String[]{"Annotation"};
                }
                case -1114371176: {
                    return new String[]{"Reference"};
                }
                case 2072803108: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("performedActivity")) {
                return this.addPerformedActivity();
            }
            if (name.equals("progress")) {
                return this.addProgress();
            }
            if (name.equals("plannedActivityReference")) {
                this.plannedActivityReference = new Reference();
                return this.plannedActivityReference;
            }
            if (name.equals("plannedActivityDetail")) {
                this.plannedActivityDetail = new CarePlanActivityPlannedActivityDetailComponent();
                return this.plannedActivityDetail;
            }
            return super.addChild(name);
        }

        @Override
        public CarePlanActivityComponent copy() {
            CarePlanActivityComponent dst = new CarePlanActivityComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CarePlanActivityComponent dst) {
            super.copyValues(dst);
            if (this.performedActivity != null) {
                dst.performedActivity = new ArrayList<CodeableReference>();
                for (CodeableReference codeableReference : this.performedActivity) {
                    dst.performedActivity.add(codeableReference.copy());
                }
            }
            if (this.progress != null) {
                dst.progress = new ArrayList<Annotation>();
                for (Annotation annotation : this.progress) {
                    dst.progress.add(annotation.copy());
                }
            }
            dst.plannedActivityReference = this.plannedActivityReference == null ? null : this.plannedActivityReference.copy();
            dst.plannedActivityDetail = this.plannedActivityDetail == null ? null : this.plannedActivityDetail.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CarePlanActivityComponent)) {
                return false;
            }
            CarePlanActivityComponent o = (CarePlanActivityComponent)other_;
            return CarePlanActivityComponent.compareDeep(this.performedActivity, o.performedActivity, true) && CarePlanActivityComponent.compareDeep(this.progress, o.progress, true) && CarePlanActivityComponent.compareDeep(this.plannedActivityReference, o.plannedActivityReference, true) && CarePlanActivityComponent.compareDeep(this.plannedActivityDetail, o.plannedActivityDetail, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CarePlanActivityComponent)) {
                return false;
            }
            CarePlanActivityComponent o = (CarePlanActivityComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.performedActivity, this.progress, this.plannedActivityReference, this.plannedActivityDetail});
        }

        @Override
        public String fhirType() {
            return "CarePlan.activity";
        }
    }

    public static class CarePlanIntentEnumFactory
    implements EnumFactory<CarePlanIntent> {
        @Override
        public CarePlanIntent fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("proposal".equals(codeString)) {
                return CarePlanIntent.PROPOSAL;
            }
            if ("plan".equals(codeString)) {
                return CarePlanIntent.PLAN;
            }
            if ("order".equals(codeString)) {
                return CarePlanIntent.ORDER;
            }
            if ("option".equals(codeString)) {
                return CarePlanIntent.OPTION;
            }
            if ("directive".equals(codeString)) {
                return CarePlanIntent.DIRECTIVE;
            }
            throw new IllegalArgumentException("Unknown CarePlanIntent code '" + codeString + "'");
        }

        public Enumeration<CarePlanIntent> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<CarePlanIntent>(this, CarePlanIntent.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<CarePlanIntent>(this, CarePlanIntent.NULL, code);
            }
            if ("proposal".equals(codeString)) {
                return new Enumeration<CarePlanIntent>(this, CarePlanIntent.PROPOSAL, code);
            }
            if ("plan".equals(codeString)) {
                return new Enumeration<CarePlanIntent>(this, CarePlanIntent.PLAN, code);
            }
            if ("order".equals(codeString)) {
                return new Enumeration<CarePlanIntent>(this, CarePlanIntent.ORDER, code);
            }
            if ("option".equals(codeString)) {
                return new Enumeration<CarePlanIntent>(this, CarePlanIntent.OPTION, code);
            }
            if ("directive".equals(codeString)) {
                return new Enumeration<CarePlanIntent>(this, CarePlanIntent.DIRECTIVE, code);
            }
            throw new FHIRException("Unknown CarePlanIntent code '" + codeString + "'");
        }

        @Override
        public String toCode(CarePlanIntent code) {
            if (code == CarePlanIntent.PROPOSAL) {
                return "proposal";
            }
            if (code == CarePlanIntent.PLAN) {
                return "plan";
            }
            if (code == CarePlanIntent.ORDER) {
                return "order";
            }
            if (code == CarePlanIntent.OPTION) {
                return "option";
            }
            if (code == CarePlanIntent.DIRECTIVE) {
                return "directive";
            }
            return "?";
        }

        @Override
        public String toSystem(CarePlanIntent code) {
            return code.getSystem();
        }
    }

    public static enum CarePlanIntent {
        PROPOSAL,
        PLAN,
        ORDER,
        OPTION,
        DIRECTIVE,
        NULL;


        public static CarePlanIntent fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("proposal".equals(codeString)) {
                return PROPOSAL;
            }
            if ("plan".equals(codeString)) {
                return PLAN;
            }
            if ("order".equals(codeString)) {
                return ORDER;
            }
            if ("option".equals(codeString)) {
                return OPTION;
            }
            if ("directive".equals(codeString)) {
                return DIRECTIVE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown CarePlanIntent code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PROPOSAL: {
                    return "proposal";
                }
                case PLAN: {
                    return "plan";
                }
                case ORDER: {
                    return "order";
                }
                case OPTION: {
                    return "option";
                }
                case DIRECTIVE: {
                    return "directive";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PROPOSAL: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case PLAN: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case ORDER: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case OPTION: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case DIRECTIVE: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PROPOSAL: {
                    return "The request is a suggestion made by someone/something that does not have an intention to ensure it occurs and without providing an authorization to act.";
                }
                case PLAN: {
                    return "The request represents an intention to ensure something occurs without providing an authorization for others to act.";
                }
                case ORDER: {
                    return "The request represents a request/demand and authorization for action by the requestor.";
                }
                case OPTION: {
                    return "The request represents a component or option for a RequestOrchestration that establishes timing, conditionality and/or other constraints among a set of requests.  Refer to [[[RequestOrchestration]]] for additional information on how this status is used.";
                }
                case DIRECTIVE: {
                    return "The request represents a legally binding instruction authored by a Patient or RelatedPerson.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PROPOSAL: {
                    return "Proposal";
                }
                case PLAN: {
                    return "Plan";
                }
                case ORDER: {
                    return "Order";
                }
                case OPTION: {
                    return "Option";
                }
                case DIRECTIVE: {
                    return "Directive";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class CarePlanActivityStatusEnumFactory
    implements EnumFactory<CarePlanActivityStatus> {
        @Override
        public CarePlanActivityStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("not-started".equals(codeString)) {
                return CarePlanActivityStatus.NOTSTARTED;
            }
            if ("scheduled".equals(codeString)) {
                return CarePlanActivityStatus.SCHEDULED;
            }
            if ("in-progress".equals(codeString)) {
                return CarePlanActivityStatus.INPROGRESS;
            }
            if ("on-hold".equals(codeString)) {
                return CarePlanActivityStatus.ONHOLD;
            }
            if ("completed".equals(codeString)) {
                return CarePlanActivityStatus.COMPLETED;
            }
            if ("cancelled".equals(codeString)) {
                return CarePlanActivityStatus.CANCELLED;
            }
            if ("stopped".equals(codeString)) {
                return CarePlanActivityStatus.STOPPED;
            }
            if ("unknown".equals(codeString)) {
                return CarePlanActivityStatus.UNKNOWN;
            }
            if ("entered-in-error".equals(codeString)) {
                return CarePlanActivityStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown CarePlanActivityStatus code '" + codeString + "'");
        }

        public Enumeration<CarePlanActivityStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<CarePlanActivityStatus>(this, CarePlanActivityStatus.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<CarePlanActivityStatus>(this, CarePlanActivityStatus.NULL, code);
            }
            if ("not-started".equals(codeString)) {
                return new Enumeration<CarePlanActivityStatus>(this, CarePlanActivityStatus.NOTSTARTED, code);
            }
            if ("scheduled".equals(codeString)) {
                return new Enumeration<CarePlanActivityStatus>(this, CarePlanActivityStatus.SCHEDULED, code);
            }
            if ("in-progress".equals(codeString)) {
                return new Enumeration<CarePlanActivityStatus>(this, CarePlanActivityStatus.INPROGRESS, code);
            }
            if ("on-hold".equals(codeString)) {
                return new Enumeration<CarePlanActivityStatus>(this, CarePlanActivityStatus.ONHOLD, code);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<CarePlanActivityStatus>(this, CarePlanActivityStatus.COMPLETED, code);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<CarePlanActivityStatus>(this, CarePlanActivityStatus.CANCELLED, code);
            }
            if ("stopped".equals(codeString)) {
                return new Enumeration<CarePlanActivityStatus>(this, CarePlanActivityStatus.STOPPED, code);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<CarePlanActivityStatus>(this, CarePlanActivityStatus.UNKNOWN, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<CarePlanActivityStatus>(this, CarePlanActivityStatus.ENTEREDINERROR, code);
            }
            throw new FHIRException("Unknown CarePlanActivityStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(CarePlanActivityStatus code) {
            if (code == CarePlanActivityStatus.NOTSTARTED) {
                return "not-started";
            }
            if (code == CarePlanActivityStatus.SCHEDULED) {
                return "scheduled";
            }
            if (code == CarePlanActivityStatus.INPROGRESS) {
                return "in-progress";
            }
            if (code == CarePlanActivityStatus.ONHOLD) {
                return "on-hold";
            }
            if (code == CarePlanActivityStatus.COMPLETED) {
                return "completed";
            }
            if (code == CarePlanActivityStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == CarePlanActivityStatus.STOPPED) {
                return "stopped";
            }
            if (code == CarePlanActivityStatus.UNKNOWN) {
                return "unknown";
            }
            if (code == CarePlanActivityStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(CarePlanActivityStatus code) {
            return code.getSystem();
        }
    }

    public static enum CarePlanActivityStatus {
        NOTSTARTED,
        SCHEDULED,
        INPROGRESS,
        ONHOLD,
        COMPLETED,
        CANCELLED,
        STOPPED,
        UNKNOWN,
        ENTEREDINERROR,
        NULL;


        public static CarePlanActivityStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("not-started".equals(codeString)) {
                return NOTSTARTED;
            }
            if ("scheduled".equals(codeString)) {
                return SCHEDULED;
            }
            if ("in-progress".equals(codeString)) {
                return INPROGRESS;
            }
            if ("on-hold".equals(codeString)) {
                return ONHOLD;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("stopped".equals(codeString)) {
                return STOPPED;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown CarePlanActivityStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case NOTSTARTED: {
                    return "not-started";
                }
                case SCHEDULED: {
                    return "scheduled";
                }
                case INPROGRESS: {
                    return "in-progress";
                }
                case ONHOLD: {
                    return "on-hold";
                }
                case COMPLETED: {
                    return "completed";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case STOPPED: {
                    return "stopped";
                }
                case UNKNOWN: {
                    return "unknown";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case NOTSTARTED: {
                    return "http://hl7.org/fhir/care-plan-activity-status";
                }
                case SCHEDULED: {
                    return "http://hl7.org/fhir/care-plan-activity-status";
                }
                case INPROGRESS: {
                    return "http://hl7.org/fhir/care-plan-activity-status";
                }
                case ONHOLD: {
                    return "http://hl7.org/fhir/care-plan-activity-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/care-plan-activity-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/care-plan-activity-status";
                }
                case STOPPED: {
                    return "http://hl7.org/fhir/care-plan-activity-status";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/care-plan-activity-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/care-plan-activity-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case NOTSTARTED: {
                    return "Care plan activity is planned but no action has yet been taken.";
                }
                case SCHEDULED: {
                    return "Appointment or other booking has occurred but activity has not yet begun.";
                }
                case INPROGRESS: {
                    return "Care plan activity has been started but is not yet complete.";
                }
                case ONHOLD: {
                    return "Care plan activity was started but has temporarily ceased with an expectation of resumption at a future time.";
                }
                case COMPLETED: {
                    return "Care plan activity has been completed (more or less) as planned.";
                }
                case CANCELLED: {
                    return "The planned care plan activity has been withdrawn.";
                }
                case STOPPED: {
                    return "The planned care plan activity has been ended prior to completion after the activity was started.";
                }
                case UNKNOWN: {
                    return "The current state of the care plan activity is not known.  Note: This concept is not to be used for \"other\" - one of the listed statuses is presumed to apply, but the authoring/source system does not know which one.";
                }
                case ENTEREDINERROR: {
                    return "Care plan activity was entered in error and voided.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case NOTSTARTED: {
                    return "Not Started";
                }
                case SCHEDULED: {
                    return "Scheduled";
                }
                case INPROGRESS: {
                    return "In Progress";
                }
                case ONHOLD: {
                    return "On Hold";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case STOPPED: {
                    return "Stopped";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class CarePlanActivityKindEnumFactory
    implements EnumFactory<CarePlanActivityKind> {
        @Override
        public CarePlanActivityKind fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("Appointment".equals(codeString)) {
                return CarePlanActivityKind.APPOINTMENT;
            }
            if ("CommunicationRequest".equals(codeString)) {
                return CarePlanActivityKind.COMMUNICATIONREQUEST;
            }
            if ("DeviceRequest".equals(codeString)) {
                return CarePlanActivityKind.DEVICEREQUEST;
            }
            if ("MedicationRequest".equals(codeString)) {
                return CarePlanActivityKind.MEDICATIONREQUEST;
            }
            if ("NutritionOrder".equals(codeString)) {
                return CarePlanActivityKind.NUTRITIONORDER;
            }
            if ("Task".equals(codeString)) {
                return CarePlanActivityKind.TASK;
            }
            if ("ServiceRequest".equals(codeString)) {
                return CarePlanActivityKind.SERVICEREQUEST;
            }
            if ("VisionPrescription".equals(codeString)) {
                return CarePlanActivityKind.VISIONPRESCRIPTION;
            }
            throw new IllegalArgumentException("Unknown CarePlanActivityKind code '" + codeString + "'");
        }

        public Enumeration<CarePlanActivityKind> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<CarePlanActivityKind>(this, CarePlanActivityKind.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<CarePlanActivityKind>(this, CarePlanActivityKind.NULL, code);
            }
            if ("Appointment".equals(codeString)) {
                return new Enumeration<CarePlanActivityKind>(this, CarePlanActivityKind.APPOINTMENT, code);
            }
            if ("CommunicationRequest".equals(codeString)) {
                return new Enumeration<CarePlanActivityKind>(this, CarePlanActivityKind.COMMUNICATIONREQUEST, code);
            }
            if ("DeviceRequest".equals(codeString)) {
                return new Enumeration<CarePlanActivityKind>(this, CarePlanActivityKind.DEVICEREQUEST, code);
            }
            if ("MedicationRequest".equals(codeString)) {
                return new Enumeration<CarePlanActivityKind>(this, CarePlanActivityKind.MEDICATIONREQUEST, code);
            }
            if ("NutritionOrder".equals(codeString)) {
                return new Enumeration<CarePlanActivityKind>(this, CarePlanActivityKind.NUTRITIONORDER, code);
            }
            if ("Task".equals(codeString)) {
                return new Enumeration<CarePlanActivityKind>(this, CarePlanActivityKind.TASK, code);
            }
            if ("ServiceRequest".equals(codeString)) {
                return new Enumeration<CarePlanActivityKind>(this, CarePlanActivityKind.SERVICEREQUEST, code);
            }
            if ("VisionPrescription".equals(codeString)) {
                return new Enumeration<CarePlanActivityKind>(this, CarePlanActivityKind.VISIONPRESCRIPTION, code);
            }
            throw new FHIRException("Unknown CarePlanActivityKind code '" + codeString + "'");
        }

        @Override
        public String toCode(CarePlanActivityKind code) {
            if (code == CarePlanActivityKind.APPOINTMENT) {
                return "Appointment";
            }
            if (code == CarePlanActivityKind.COMMUNICATIONREQUEST) {
                return "CommunicationRequest";
            }
            if (code == CarePlanActivityKind.DEVICEREQUEST) {
                return "DeviceRequest";
            }
            if (code == CarePlanActivityKind.MEDICATIONREQUEST) {
                return "MedicationRequest";
            }
            if (code == CarePlanActivityKind.NUTRITIONORDER) {
                return "NutritionOrder";
            }
            if (code == CarePlanActivityKind.TASK) {
                return "Task";
            }
            if (code == CarePlanActivityKind.SERVICEREQUEST) {
                return "ServiceRequest";
            }
            if (code == CarePlanActivityKind.VISIONPRESCRIPTION) {
                return "VisionPrescription";
            }
            return "?";
        }

        @Override
        public String toSystem(CarePlanActivityKind code) {
            return code.getSystem();
        }
    }

    public static enum CarePlanActivityKind {
        APPOINTMENT,
        COMMUNICATIONREQUEST,
        DEVICEREQUEST,
        MEDICATIONREQUEST,
        NUTRITIONORDER,
        TASK,
        SERVICEREQUEST,
        VISIONPRESCRIPTION,
        NULL;


        public static CarePlanActivityKind fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("Appointment".equals(codeString)) {
                return APPOINTMENT;
            }
            if ("CommunicationRequest".equals(codeString)) {
                return COMMUNICATIONREQUEST;
            }
            if ("DeviceRequest".equals(codeString)) {
                return DEVICEREQUEST;
            }
            if ("MedicationRequest".equals(codeString)) {
                return MEDICATIONREQUEST;
            }
            if ("NutritionOrder".equals(codeString)) {
                return NUTRITIONORDER;
            }
            if ("Task".equals(codeString)) {
                return TASK;
            }
            if ("ServiceRequest".equals(codeString)) {
                return SERVICEREQUEST;
            }
            if ("VisionPrescription".equals(codeString)) {
                return VISIONPRESCRIPTION;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown CarePlanActivityKind code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case APPOINTMENT: {
                    return "Appointment";
                }
                case COMMUNICATIONREQUEST: {
                    return "CommunicationRequest";
                }
                case DEVICEREQUEST: {
                    return "DeviceRequest";
                }
                case MEDICATIONREQUEST: {
                    return "MedicationRequest";
                }
                case NUTRITIONORDER: {
                    return "NutritionOrder";
                }
                case TASK: {
                    return "Task";
                }
                case SERVICEREQUEST: {
                    return "ServiceRequest";
                }
                case VISIONPRESCRIPTION: {
                    return "VisionPrescription";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case APPOINTMENT: {
                    return "http://hl7.org/fhir/fhir-types";
                }
                case COMMUNICATIONREQUEST: {
                    return "http://hl7.org/fhir/fhir-types";
                }
                case DEVICEREQUEST: {
                    return "http://hl7.org/fhir/fhir-types";
                }
                case MEDICATIONREQUEST: {
                    return "http://hl7.org/fhir/fhir-types";
                }
                case NUTRITIONORDER: {
                    return "http://hl7.org/fhir/fhir-types";
                }
                case TASK: {
                    return "http://hl7.org/fhir/fhir-types";
                }
                case SERVICEREQUEST: {
                    return "http://hl7.org/fhir/fhir-types";
                }
                case VISIONPRESCRIPTION: {
                    return "http://hl7.org/fhir/fhir-types";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case APPOINTMENT: {
                    return "A booking of a healthcare event among patient(s), practitioner(s), related person(s) and/or device(s) for a specific date/time. This may result in one or more Encounter(s).";
                }
                case COMMUNICATIONREQUEST: {
                    return "A request to convey information; e.g. the CDS system proposes that an alert be sent to a responsible provider, the CDS system proposes that the public health agency be notified about a reportable condition.";
                }
                case DEVICEREQUEST: {
                    return "Represents a request a device to be provided to a specific patient. The device may be an implantable device to be subsequently implanted, or an external assistive device, such as a walker, to be delivered and subsequently be used.";
                }
                case MEDICATIONREQUEST: {
                    return "An order or request for both supply of the medication and the instructions for administration of the medication to a patient. The resource is called \"MedicationRequest\" rather than \"MedicationPrescription\" or \"MedicationOrder\" to generalize the use across inpatient and outpatient settings, including care plans, etc., and to harmonize with workflow patterns.";
                }
                case NUTRITIONORDER: {
                    return "A request to supply a diet, formula feeding (enteral) or oral nutritional supplement to a patient/resident.";
                }
                case TASK: {
                    return "A task to be performed.";
                }
                case SERVICEREQUEST: {
                    return "A record of a request for service such as diagnostic investigations, treatments, or operations to be performed.";
                }
                case VISIONPRESCRIPTION: {
                    return "An authorization for the provision of glasses and/or contact lenses to a patient.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case APPOINTMENT: {
                    return "Appointment";
                }
                case COMMUNICATIONREQUEST: {
                    return "CommunicationRequest";
                }
                case DEVICEREQUEST: {
                    return "DeviceRequest";
                }
                case MEDICATIONREQUEST: {
                    return "MedicationRequest";
                }
                case NUTRITIONORDER: {
                    return "NutritionOrder";
                }
                case TASK: {
                    return "Task";
                }
                case SERVICEREQUEST: {
                    return "ServiceRequest";
                }
                case VISIONPRESCRIPTION: {
                    return "VisionPrescription";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

