/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.NumberClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.Citation;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DiagnosticReport;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.EvidenceReport;
import org.hl7.fhir.r5.model.EvidenceVariable;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UnsignedIntType;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ResearchStudy", profile="http://hl7.org/fhir/StructureDefinition/ResearchStudy")
public class ResearchStudy
extends DomainResource {
    @Child(name="url", type={UriType.class}, order=0, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Canonical identifier for this study resource", formalDefinition="Canonical identifier for this study resource, represented as a globally unique URI.")
    protected UriType url;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business Identifier for study", formalDefinition="Identifiers assigned to this research study by the sponsor or other systems.")
    protected List<Identifier> identifier;
    @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The business version for the study record", formalDefinition="The business version for the study record.")
    protected StringType version;
    @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Name for this study (computer friendly)", formalDefinition="Name for this study (computer friendly).")
    protected StringType name;
    @Child(name="title", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Human readable name of the study", formalDefinition="The human readable name of the research study.")
    protected StringType title;
    @Child(name="label", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional names for the study", formalDefinition="Additional names for the study.")
    protected List<ResearchStudyLabelComponent> label;
    @Child(name="protocol", type={PlanDefinition.class}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Steps followed in executing study", formalDefinition="The set of steps expected to be performed as part of the execution of the study.")
    protected List<Reference> protocol;
    @Child(name="partOf", type={ResearchStudy.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Part of larger study", formalDefinition="A larger research study of which this particular study is a component or step.")
    protected List<Reference> partOf;
    @Child(name="relatedArtifact", type={RelatedArtifact.class}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="References, URLs, and attachments", formalDefinition="Citations, references, URLs and other related documents.  When using relatedArtifact to share URLs, the relatedArtifact.type will often be set to one of \"documentation\" or \"supported-with\" and the URL value will often be in relatedArtifact.document.url but another possible location is relatedArtifact.resource when it is a canonical URL.")
    protected List<RelatedArtifact> relatedArtifact;
    @Child(name="date", type={DateTimeType.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Date the resource last changed", formalDefinition="The date (and optionally time) when the ResearchStudy Resource was last significantly changed. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the ResearchStudy Resource changes.")
    protected DateTimeType date;
    @Child(name="status", type={CodeType.class}, order=10, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired | unknown", formalDefinition="The publication state of the resource (not of the study).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected Enumeration<Enumerations.PublicationStatus> status;
    @Child(name="primaryPurposeType", type={CodeableConcept.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="treatment | prevention | diagnostic | supportive-care | screening | health-services-research | basic-science | device-feasibility", formalDefinition="The type of study based upon the intent of the study activities. A classification of the intent of the study.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/research-study-prim-purp-type")
    protected CodeableConcept primaryPurposeType;
    @Child(name="phase", type={CodeableConcept.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="n-a | early-phase-1 | phase-1 | phase-1-phase-2 | phase-2 | phase-2-phase-3 | phase-3 | phase-4", formalDefinition="The stage in the progression of a therapy from initial experimental use in humans in clinical trials to post-market evaluation.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/research-study-phase")
    protected CodeableConcept phase;
    @Child(name="studyDesign", type={CodeableConcept.class}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Classifications of the study design characteristics", formalDefinition="Codes categorizing the type of study such as investigational vs. observational, type of blinding, type of randomization, safety vs. efficacy, etc.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/study-design")
    protected List<CodeableConcept> studyDesign;
    @Child(name="focus", type={CodeableReference.class}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Drugs, devices, etc. under study", formalDefinition="The medication(s), food(s), therapy(ies), device(s) or other concerns or interventions that the study is seeking to gain more information about.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/research-study-focus-type")
    protected List<CodeableReference> focus;
    @Child(name="condition", type={CodeableConcept.class}, order=15, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Condition being studied", formalDefinition="The condition that is the focus of the study.  For example, In a study to examine risk factors for Lupus, might have as an inclusion criterion \"healthy volunteer\", but the target condition code would be a Lupus SNOMED code.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-code")
    protected List<CodeableConcept> condition;
    @Child(name="keyword", type={CodeableConcept.class}, order=16, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Used to search for the study", formalDefinition="Key terms to aid in searching for or filtering the study.")
    protected List<CodeableConcept> keyword;
    @Child(name="region", type={CodeableConcept.class}, order=17, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Geographic area for the study", formalDefinition="A country, state or other area where the study is taking place rather than its precise geographic location or address.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    protected List<CodeableConcept> region;
    @Child(name="descriptionSummary", type={MarkdownType.class}, order=18, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Brief text explaining the study", formalDefinition="A brief text for explaining the study.")
    protected MarkdownType descriptionSummary;
    @Child(name="description", type={MarkdownType.class}, order=19, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Detailed narrative of the study", formalDefinition="A detailed and human-readable narrative of the study. E.g., study abstract.")
    protected MarkdownType description;
    @Child(name="period", type={Period.class}, order=20, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the study began and ended", formalDefinition="Identifies the start date and the expected (or actual, depending on status) end date for the study.")
    protected Period period;
    @Child(name="site", type={Location.class, ResearchStudy.class, Organization.class}, order=21, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Facility where study activities are conducted", formalDefinition="A facility in which study activities are conducted.")
    protected List<Reference> site;
    @Child(name="note", type={Annotation.class}, order=22, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Comments made about the study", formalDefinition="Comments made about the study by the performer, subject or other participants.")
    protected List<Annotation> note;
    @Child(name="classifier", type={CodeableConcept.class}, order=23, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Classification for the study", formalDefinition="Additional grouping mechanism or categorization of a research study. Example: FDA regulated device, FDA regulated drug, MPG Paragraph 23b (a German legal requirement), IRB-exempt, etc. Implementation Note: do not use the classifier element to support existing semantics that are already supported thru explicit elements in the resource.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/research-study-classifiers")
    protected List<CodeableConcept> classifier;
    @Child(name="associatedParty", type={}, order=24, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Sponsors, collaborators, and other parties", formalDefinition="Sponsors, collaborators, and other parties.")
    protected List<ResearchStudyAssociatedPartyComponent> associatedParty;
    @Child(name="progressStatus", type={}, order=25, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Status of study with time for that status", formalDefinition="Status of study with time for that status.")
    protected List<ResearchStudyProgressStatusComponent> progressStatus;
    @Child(name="whyStopped", type={CodeableConcept.class}, order=26, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="accrual-goal-met | closed-due-to-toxicity | closed-due-to-lack-of-study-progress | temporarily-closed-per-study-design", formalDefinition="A description and/or code explaining the premature termination of the study.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/research-study-reason-stopped")
    protected CodeableConcept whyStopped;
    @Child(name="recruitment", type={}, order=27, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Target or actual group of participants enrolled in study", formalDefinition="Target or actual group of participants enrolled in study.")
    protected ResearchStudyRecruitmentComponent recruitment;
    @Child(name="comparisonGroup", type={}, order=28, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Defined path through the study for a subject", formalDefinition="Describes an expected event or sequence of events for one of the subjects of a study. E.g. for a living subject: exposure to drug A, wash-out, exposure to drug B, wash-out, follow-up. E.g. for a stability study: {store sample from lot A at 25 degrees for 1 month}, {store sample from lot A at 40 degrees for 1 month}.")
    protected List<ResearchStudyComparisonGroupComponent> comparisonGroup;
    @Child(name="objective", type={}, order=29, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A goal for the study", formalDefinition="A goal that the study is aiming to achieve in terms of a scientific question to be answered by the analysis of data collected during the study.")
    protected List<ResearchStudyObjectiveComponent> objective;
    @Child(name="outcomeMeasure", type={}, order=30, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A variable measured during the study", formalDefinition="An \"outcome measure\", \"endpoint\", \"effect measure\" or \"measure of effect\" is a specific measurement or observation used to quantify the effect of experimental variables on the participants in a study, or for observational studies, to describe patterns of diseases or traits or associations with exposures, risk factors or treatment.")
    protected List<ResearchStudyOutcomeMeasureComponent> outcomeMeasure;
    @Child(name="result", type={EvidenceReport.class, Citation.class, DiagnosticReport.class}, order=31, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Link to results generated during the study", formalDefinition="Link to one or more sets of results generated by the study.  Could also link to a research registry holding the results such as ClinicalTrials.gov.")
    protected List<Reference> result;
    private static final long serialVersionUID = -1217395129L;
    @SearchParamDefinition(name="condition", path="ResearchStudy.condition", description="Condition being studied", type="token")
    public static final String SP_CONDITION = "condition";
    public static final TokenClientParam CONDITION = new TokenClientParam("condition");
    @SearchParamDefinition(name="date", path="ResearchStudy.period", description="When the study began and ended", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="focus", path="ResearchStudy.focus", description="Drugs, devices, etc. under study", type="token")
    public static final String SP_FOCUS = "focus";
    public static final TokenClientParam FOCUS = new TokenClientParam("focus");
    @SearchParamDefinition(name="identifier", path="ResearchStudy.identifier", description="Business Identifier for study", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="keyword", path="ResearchStudy.keyword", description="Used to search for the study", type="token")
    public static final String SP_KEYWORD = "keyword";
    public static final TokenClientParam KEYWORD = new TokenClientParam("keyword");
    @SearchParamDefinition(name="partof", path="ResearchStudy.partOf", description="Part of larger study", type="reference", target={ResearchStudy.class})
    public static final String SP_PARTOF = "partof";
    public static final ReferenceClientParam PARTOF = new ReferenceClientParam("partof");
    public static final Include INCLUDE_PARTOF = new Include("ResearchStudy:partof").toLocked();
    @SearchParamDefinition(name="protocol", path="ResearchStudy.protocol", description="Steps followed in executing study", type="reference", target={PlanDefinition.class})
    public static final String SP_PROTOCOL = "protocol";
    public static final ReferenceClientParam PROTOCOL = new ReferenceClientParam("protocol");
    public static final Include INCLUDE_PROTOCOL = new Include("ResearchStudy:protocol").toLocked();
    @SearchParamDefinition(name="recruitment_actual", path="ResearchStudy.recruitment.actualNumber", description="Actual number of participants enrolled in study across all groups", type="number")
    public static final String SP_RECRUITMENTACTUAL = "recruitment_actual";
    public static final NumberClientParam RECRUITMENTACTUAL = new NumberClientParam("recruitment_actual");
    @SearchParamDefinition(name="recruitment_target", path="ResearchStudy.recruitment.targetNumber", description="Target number of participants enrolled in study across all groups", type="number")
    public static final String SP_RECRUITMENTTARGET = "recruitment_target";
    public static final NumberClientParam RECRUITMENTTARGET = new NumberClientParam("recruitment_target");
    @SearchParamDefinition(name="region", path="ResearchStudy.region", description="Geographic area for the study", type="token")
    public static final String SP_REGION = "region";
    public static final TokenClientParam REGION = new TokenClientParam("region");
    @SearchParamDefinition(name="site", path="ResearchStudy.site", description="Facility where study activities are conducted", type="reference", target={Location.class, Organization.class, ResearchStudy.class})
    public static final String SP_SITE = "site";
    public static final ReferenceClientParam SITE = new ReferenceClientParam("site");
    public static final Include INCLUDE_SITE = new Include("ResearchStudy:site").toLocked();
    @SearchParamDefinition(name="status", path="ResearchStudy.status", description="active | active-but-not-recruiting | administratively-completed | approved | closed-to-accrual | closed-to-accrual-and-intervention | completed | disapproved | enrolling-by-invitation | in-review | not-yet-recruiting | recruiting | temporarily-closed-to-accrual | temporarily-closed-to-accrual-and-intervention | terminated | withdrawn", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="title", path="ResearchStudy.title", description="Name for this study", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");

    public ResearchStudy() {
    }

    public ResearchStudy(Enumerations.PublicationStatus status) {
        this.setStatus(status);
    }

    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchStudy.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    public ResearchStudy setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    public ResearchStudy setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public ResearchStudy setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ResearchStudy addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchStudy.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    public ResearchStudy setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    public ResearchStudy setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchStudy.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public ResearchStudy setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public ResearchStudy setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchStudy.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    public ResearchStudy setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    public ResearchStudy setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    public List<ResearchStudyLabelComponent> getLabel() {
        if (this.label == null) {
            this.label = new ArrayList<ResearchStudyLabelComponent>();
        }
        return this.label;
    }

    public ResearchStudy setLabel(List<ResearchStudyLabelComponent> theLabel) {
        this.label = theLabel;
        return this;
    }

    public boolean hasLabel() {
        if (this.label == null) {
            return false;
        }
        for (ResearchStudyLabelComponent item : this.label) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ResearchStudyLabelComponent addLabel() {
        ResearchStudyLabelComponent t = new ResearchStudyLabelComponent();
        if (this.label == null) {
            this.label = new ArrayList<ResearchStudyLabelComponent>();
        }
        this.label.add(t);
        return t;
    }

    public ResearchStudy addLabel(ResearchStudyLabelComponent t) {
        if (t == null) {
            return this;
        }
        if (this.label == null) {
            this.label = new ArrayList<ResearchStudyLabelComponent>();
        }
        this.label.add(t);
        return this;
    }

    public ResearchStudyLabelComponent getLabelFirstRep() {
        if (this.getLabel().isEmpty()) {
            this.addLabel();
        }
        return this.getLabel().get(0);
    }

    public List<Reference> getProtocol() {
        if (this.protocol == null) {
            this.protocol = new ArrayList<Reference>();
        }
        return this.protocol;
    }

    public ResearchStudy setProtocol(List<Reference> theProtocol) {
        this.protocol = theProtocol;
        return this;
    }

    public boolean hasProtocol() {
        if (this.protocol == null) {
            return false;
        }
        for (Reference item : this.protocol) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addProtocol() {
        Reference t = new Reference();
        if (this.protocol == null) {
            this.protocol = new ArrayList<Reference>();
        }
        this.protocol.add(t);
        return t;
    }

    public ResearchStudy addProtocol(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.protocol == null) {
            this.protocol = new ArrayList<Reference>();
        }
        this.protocol.add(t);
        return this;
    }

    public Reference getProtocolFirstRep() {
        if (this.getProtocol().isEmpty()) {
            this.addProtocol();
        }
        return this.getProtocol().get(0);
    }

    public List<Reference> getPartOf() {
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        return this.partOf;
    }

    public ResearchStudy setPartOf(List<Reference> thePartOf) {
        this.partOf = thePartOf;
        return this;
    }

    public boolean hasPartOf() {
        if (this.partOf == null) {
            return false;
        }
        for (Reference item : this.partOf) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPartOf() {
        Reference t = new Reference();
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return t;
    }

    public ResearchStudy addPartOf(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return this;
    }

    public Reference getPartOfFirstRep() {
        if (this.getPartOf().isEmpty()) {
            this.addPartOf();
        }
        return this.getPartOf().get(0);
    }

    public List<RelatedArtifact> getRelatedArtifact() {
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        return this.relatedArtifact;
    }

    public ResearchStudy setRelatedArtifact(List<RelatedArtifact> theRelatedArtifact) {
        this.relatedArtifact = theRelatedArtifact;
        return this;
    }

    public boolean hasRelatedArtifact() {
        if (this.relatedArtifact == null) {
            return false;
        }
        for (RelatedArtifact item : this.relatedArtifact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public RelatedArtifact addRelatedArtifact() {
        RelatedArtifact t = new RelatedArtifact();
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        this.relatedArtifact.add(t);
        return t;
    }

    public ResearchStudy addRelatedArtifact(RelatedArtifact t) {
        if (t == null) {
            return this;
        }
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        this.relatedArtifact.add(t);
        return this;
    }

    public RelatedArtifact getRelatedArtifactFirstRep() {
        if (this.getRelatedArtifact().isEmpty()) {
            this.addRelatedArtifact();
        }
        return this.getRelatedArtifact().get(0);
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchStudy.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public ResearchStudy setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public ResearchStudy setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchStudy.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public ResearchStudy setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    public ResearchStudy setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public CodeableConcept getPrimaryPurposeType() {
        if (this.primaryPurposeType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchStudy.primaryPurposeType");
            }
            if (Configuration.doAutoCreate()) {
                this.primaryPurposeType = new CodeableConcept();
            }
        }
        return this.primaryPurposeType;
    }

    public boolean hasPrimaryPurposeType() {
        return this.primaryPurposeType != null && !this.primaryPurposeType.isEmpty();
    }

    public ResearchStudy setPrimaryPurposeType(CodeableConcept value) {
        this.primaryPurposeType = value;
        return this;
    }

    public CodeableConcept getPhase() {
        if (this.phase == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchStudy.phase");
            }
            if (Configuration.doAutoCreate()) {
                this.phase = new CodeableConcept();
            }
        }
        return this.phase;
    }

    public boolean hasPhase() {
        return this.phase != null && !this.phase.isEmpty();
    }

    public ResearchStudy setPhase(CodeableConcept value) {
        this.phase = value;
        return this;
    }

    public List<CodeableConcept> getStudyDesign() {
        if (this.studyDesign == null) {
            this.studyDesign = new ArrayList<CodeableConcept>();
        }
        return this.studyDesign;
    }

    public ResearchStudy setStudyDesign(List<CodeableConcept> theStudyDesign) {
        this.studyDesign = theStudyDesign;
        return this;
    }

    public boolean hasStudyDesign() {
        if (this.studyDesign == null) {
            return false;
        }
        for (CodeableConcept item : this.studyDesign) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addStudyDesign() {
        CodeableConcept t = new CodeableConcept();
        if (this.studyDesign == null) {
            this.studyDesign = new ArrayList<CodeableConcept>();
        }
        this.studyDesign.add(t);
        return t;
    }

    public ResearchStudy addStudyDesign(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.studyDesign == null) {
            this.studyDesign = new ArrayList<CodeableConcept>();
        }
        this.studyDesign.add(t);
        return this;
    }

    public CodeableConcept getStudyDesignFirstRep() {
        if (this.getStudyDesign().isEmpty()) {
            this.addStudyDesign();
        }
        return this.getStudyDesign().get(0);
    }

    public List<CodeableReference> getFocus() {
        if (this.focus == null) {
            this.focus = new ArrayList<CodeableReference>();
        }
        return this.focus;
    }

    public ResearchStudy setFocus(List<CodeableReference> theFocus) {
        this.focus = theFocus;
        return this;
    }

    public boolean hasFocus() {
        if (this.focus == null) {
            return false;
        }
        for (CodeableReference item : this.focus) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableReference addFocus() {
        CodeableReference t = new CodeableReference();
        if (this.focus == null) {
            this.focus = new ArrayList<CodeableReference>();
        }
        this.focus.add(t);
        return t;
    }

    public ResearchStudy addFocus(CodeableReference t) {
        if (t == null) {
            return this;
        }
        if (this.focus == null) {
            this.focus = new ArrayList<CodeableReference>();
        }
        this.focus.add(t);
        return this;
    }

    public CodeableReference getFocusFirstRep() {
        if (this.getFocus().isEmpty()) {
            this.addFocus();
        }
        return this.getFocus().get(0);
    }

    public List<CodeableConcept> getCondition() {
        if (this.condition == null) {
            this.condition = new ArrayList<CodeableConcept>();
        }
        return this.condition;
    }

    public ResearchStudy setCondition(List<CodeableConcept> theCondition) {
        this.condition = theCondition;
        return this;
    }

    public boolean hasCondition() {
        if (this.condition == null) {
            return false;
        }
        for (CodeableConcept item : this.condition) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCondition() {
        CodeableConcept t = new CodeableConcept();
        if (this.condition == null) {
            this.condition = new ArrayList<CodeableConcept>();
        }
        this.condition.add(t);
        return t;
    }

    public ResearchStudy addCondition(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.condition == null) {
            this.condition = new ArrayList<CodeableConcept>();
        }
        this.condition.add(t);
        return this;
    }

    public CodeableConcept getConditionFirstRep() {
        if (this.getCondition().isEmpty()) {
            this.addCondition();
        }
        return this.getCondition().get(0);
    }

    public List<CodeableConcept> getKeyword() {
        if (this.keyword == null) {
            this.keyword = new ArrayList<CodeableConcept>();
        }
        return this.keyword;
    }

    public ResearchStudy setKeyword(List<CodeableConcept> theKeyword) {
        this.keyword = theKeyword;
        return this;
    }

    public boolean hasKeyword() {
        if (this.keyword == null) {
            return false;
        }
        for (CodeableConcept item : this.keyword) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addKeyword() {
        CodeableConcept t = new CodeableConcept();
        if (this.keyword == null) {
            this.keyword = new ArrayList<CodeableConcept>();
        }
        this.keyword.add(t);
        return t;
    }

    public ResearchStudy addKeyword(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.keyword == null) {
            this.keyword = new ArrayList<CodeableConcept>();
        }
        this.keyword.add(t);
        return this;
    }

    public CodeableConcept getKeywordFirstRep() {
        if (this.getKeyword().isEmpty()) {
            this.addKeyword();
        }
        return this.getKeyword().get(0);
    }

    public List<CodeableConcept> getRegion() {
        if (this.region == null) {
            this.region = new ArrayList<CodeableConcept>();
        }
        return this.region;
    }

    public ResearchStudy setRegion(List<CodeableConcept> theRegion) {
        this.region = theRegion;
        return this;
    }

    public boolean hasRegion() {
        if (this.region == null) {
            return false;
        }
        for (CodeableConcept item : this.region) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addRegion() {
        CodeableConcept t = new CodeableConcept();
        if (this.region == null) {
            this.region = new ArrayList<CodeableConcept>();
        }
        this.region.add(t);
        return t;
    }

    public ResearchStudy addRegion(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.region == null) {
            this.region = new ArrayList<CodeableConcept>();
        }
        this.region.add(t);
        return this;
    }

    public CodeableConcept getRegionFirstRep() {
        if (this.getRegion().isEmpty()) {
            this.addRegion();
        }
        return this.getRegion().get(0);
    }

    public MarkdownType getDescriptionSummaryElement() {
        if (this.descriptionSummary == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchStudy.descriptionSummary");
            }
            if (Configuration.doAutoCreate()) {
                this.descriptionSummary = new MarkdownType();
            }
        }
        return this.descriptionSummary;
    }

    public boolean hasDescriptionSummaryElement() {
        return this.descriptionSummary != null && !this.descriptionSummary.isEmpty();
    }

    public boolean hasDescriptionSummary() {
        return this.descriptionSummary != null && !this.descriptionSummary.isEmpty();
    }

    public ResearchStudy setDescriptionSummaryElement(MarkdownType value) {
        this.descriptionSummary = value;
        return this;
    }

    public String getDescriptionSummary() {
        return this.descriptionSummary == null ? null : (String)this.descriptionSummary.getValue();
    }

    public ResearchStudy setDescriptionSummary(String value) {
        if (value == null) {
            this.descriptionSummary = null;
        } else {
            if (this.descriptionSummary == null) {
                this.descriptionSummary = new MarkdownType();
            }
            this.descriptionSummary.setValue(value);
        }
        return this;
    }

    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchStudy.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public ResearchStudy setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public ResearchStudy setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchStudy.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public ResearchStudy setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public List<Reference> getSite() {
        if (this.site == null) {
            this.site = new ArrayList<Reference>();
        }
        return this.site;
    }

    public ResearchStudy setSite(List<Reference> theSite) {
        this.site = theSite;
        return this;
    }

    public boolean hasSite() {
        if (this.site == null) {
            return false;
        }
        for (Reference item : this.site) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSite() {
        Reference t = new Reference();
        if (this.site == null) {
            this.site = new ArrayList<Reference>();
        }
        this.site.add(t);
        return t;
    }

    public ResearchStudy addSite(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.site == null) {
            this.site = new ArrayList<Reference>();
        }
        this.site.add(t);
        return this;
    }

    public Reference getSiteFirstRep() {
        if (this.getSite().isEmpty()) {
            this.addSite();
        }
        return this.getSite().get(0);
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public ResearchStudy setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public ResearchStudy addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public List<CodeableConcept> getClassifier() {
        if (this.classifier == null) {
            this.classifier = new ArrayList<CodeableConcept>();
        }
        return this.classifier;
    }

    public ResearchStudy setClassifier(List<CodeableConcept> theClassifier) {
        this.classifier = theClassifier;
        return this;
    }

    public boolean hasClassifier() {
        if (this.classifier == null) {
            return false;
        }
        for (CodeableConcept item : this.classifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addClassifier() {
        CodeableConcept t = new CodeableConcept();
        if (this.classifier == null) {
            this.classifier = new ArrayList<CodeableConcept>();
        }
        this.classifier.add(t);
        return t;
    }

    public ResearchStudy addClassifier(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.classifier == null) {
            this.classifier = new ArrayList<CodeableConcept>();
        }
        this.classifier.add(t);
        return this;
    }

    public CodeableConcept getClassifierFirstRep() {
        if (this.getClassifier().isEmpty()) {
            this.addClassifier();
        }
        return this.getClassifier().get(0);
    }

    public List<ResearchStudyAssociatedPartyComponent> getAssociatedParty() {
        if (this.associatedParty == null) {
            this.associatedParty = new ArrayList<ResearchStudyAssociatedPartyComponent>();
        }
        return this.associatedParty;
    }

    public ResearchStudy setAssociatedParty(List<ResearchStudyAssociatedPartyComponent> theAssociatedParty) {
        this.associatedParty = theAssociatedParty;
        return this;
    }

    public boolean hasAssociatedParty() {
        if (this.associatedParty == null) {
            return false;
        }
        for (ResearchStudyAssociatedPartyComponent item : this.associatedParty) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ResearchStudyAssociatedPartyComponent addAssociatedParty() {
        ResearchStudyAssociatedPartyComponent t = new ResearchStudyAssociatedPartyComponent();
        if (this.associatedParty == null) {
            this.associatedParty = new ArrayList<ResearchStudyAssociatedPartyComponent>();
        }
        this.associatedParty.add(t);
        return t;
    }

    public ResearchStudy addAssociatedParty(ResearchStudyAssociatedPartyComponent t) {
        if (t == null) {
            return this;
        }
        if (this.associatedParty == null) {
            this.associatedParty = new ArrayList<ResearchStudyAssociatedPartyComponent>();
        }
        this.associatedParty.add(t);
        return this;
    }

    public ResearchStudyAssociatedPartyComponent getAssociatedPartyFirstRep() {
        if (this.getAssociatedParty().isEmpty()) {
            this.addAssociatedParty();
        }
        return this.getAssociatedParty().get(0);
    }

    public List<ResearchStudyProgressStatusComponent> getProgressStatus() {
        if (this.progressStatus == null) {
            this.progressStatus = new ArrayList<ResearchStudyProgressStatusComponent>();
        }
        return this.progressStatus;
    }

    public ResearchStudy setProgressStatus(List<ResearchStudyProgressStatusComponent> theProgressStatus) {
        this.progressStatus = theProgressStatus;
        return this;
    }

    public boolean hasProgressStatus() {
        if (this.progressStatus == null) {
            return false;
        }
        for (ResearchStudyProgressStatusComponent item : this.progressStatus) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ResearchStudyProgressStatusComponent addProgressStatus() {
        ResearchStudyProgressStatusComponent t = new ResearchStudyProgressStatusComponent();
        if (this.progressStatus == null) {
            this.progressStatus = new ArrayList<ResearchStudyProgressStatusComponent>();
        }
        this.progressStatus.add(t);
        return t;
    }

    public ResearchStudy addProgressStatus(ResearchStudyProgressStatusComponent t) {
        if (t == null) {
            return this;
        }
        if (this.progressStatus == null) {
            this.progressStatus = new ArrayList<ResearchStudyProgressStatusComponent>();
        }
        this.progressStatus.add(t);
        return this;
    }

    public ResearchStudyProgressStatusComponent getProgressStatusFirstRep() {
        if (this.getProgressStatus().isEmpty()) {
            this.addProgressStatus();
        }
        return this.getProgressStatus().get(0);
    }

    public CodeableConcept getWhyStopped() {
        if (this.whyStopped == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchStudy.whyStopped");
            }
            if (Configuration.doAutoCreate()) {
                this.whyStopped = new CodeableConcept();
            }
        }
        return this.whyStopped;
    }

    public boolean hasWhyStopped() {
        return this.whyStopped != null && !this.whyStopped.isEmpty();
    }

    public ResearchStudy setWhyStopped(CodeableConcept value) {
        this.whyStopped = value;
        return this;
    }

    public ResearchStudyRecruitmentComponent getRecruitment() {
        if (this.recruitment == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchStudy.recruitment");
            }
            if (Configuration.doAutoCreate()) {
                this.recruitment = new ResearchStudyRecruitmentComponent();
            }
        }
        return this.recruitment;
    }

    public boolean hasRecruitment() {
        return this.recruitment != null && !this.recruitment.isEmpty();
    }

    public ResearchStudy setRecruitment(ResearchStudyRecruitmentComponent value) {
        this.recruitment = value;
        return this;
    }

    public List<ResearchStudyComparisonGroupComponent> getComparisonGroup() {
        if (this.comparisonGroup == null) {
            this.comparisonGroup = new ArrayList<ResearchStudyComparisonGroupComponent>();
        }
        return this.comparisonGroup;
    }

    public ResearchStudy setComparisonGroup(List<ResearchStudyComparisonGroupComponent> theComparisonGroup) {
        this.comparisonGroup = theComparisonGroup;
        return this;
    }

    public boolean hasComparisonGroup() {
        if (this.comparisonGroup == null) {
            return false;
        }
        for (ResearchStudyComparisonGroupComponent item : this.comparisonGroup) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ResearchStudyComparisonGroupComponent addComparisonGroup() {
        ResearchStudyComparisonGroupComponent t = new ResearchStudyComparisonGroupComponent();
        if (this.comparisonGroup == null) {
            this.comparisonGroup = new ArrayList<ResearchStudyComparisonGroupComponent>();
        }
        this.comparisonGroup.add(t);
        return t;
    }

    public ResearchStudy addComparisonGroup(ResearchStudyComparisonGroupComponent t) {
        if (t == null) {
            return this;
        }
        if (this.comparisonGroup == null) {
            this.comparisonGroup = new ArrayList<ResearchStudyComparisonGroupComponent>();
        }
        this.comparisonGroup.add(t);
        return this;
    }

    public ResearchStudyComparisonGroupComponent getComparisonGroupFirstRep() {
        if (this.getComparisonGroup().isEmpty()) {
            this.addComparisonGroup();
        }
        return this.getComparisonGroup().get(0);
    }

    public List<ResearchStudyObjectiveComponent> getObjective() {
        if (this.objective == null) {
            this.objective = new ArrayList<ResearchStudyObjectiveComponent>();
        }
        return this.objective;
    }

    public ResearchStudy setObjective(List<ResearchStudyObjectiveComponent> theObjective) {
        this.objective = theObjective;
        return this;
    }

    public boolean hasObjective() {
        if (this.objective == null) {
            return false;
        }
        for (ResearchStudyObjectiveComponent item : this.objective) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ResearchStudyObjectiveComponent addObjective() {
        ResearchStudyObjectiveComponent t = new ResearchStudyObjectiveComponent();
        if (this.objective == null) {
            this.objective = new ArrayList<ResearchStudyObjectiveComponent>();
        }
        this.objective.add(t);
        return t;
    }

    public ResearchStudy addObjective(ResearchStudyObjectiveComponent t) {
        if (t == null) {
            return this;
        }
        if (this.objective == null) {
            this.objective = new ArrayList<ResearchStudyObjectiveComponent>();
        }
        this.objective.add(t);
        return this;
    }

    public ResearchStudyObjectiveComponent getObjectiveFirstRep() {
        if (this.getObjective().isEmpty()) {
            this.addObjective();
        }
        return this.getObjective().get(0);
    }

    public List<ResearchStudyOutcomeMeasureComponent> getOutcomeMeasure() {
        if (this.outcomeMeasure == null) {
            this.outcomeMeasure = new ArrayList<ResearchStudyOutcomeMeasureComponent>();
        }
        return this.outcomeMeasure;
    }

    public ResearchStudy setOutcomeMeasure(List<ResearchStudyOutcomeMeasureComponent> theOutcomeMeasure) {
        this.outcomeMeasure = theOutcomeMeasure;
        return this;
    }

    public boolean hasOutcomeMeasure() {
        if (this.outcomeMeasure == null) {
            return false;
        }
        for (ResearchStudyOutcomeMeasureComponent item : this.outcomeMeasure) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ResearchStudyOutcomeMeasureComponent addOutcomeMeasure() {
        ResearchStudyOutcomeMeasureComponent t = new ResearchStudyOutcomeMeasureComponent();
        if (this.outcomeMeasure == null) {
            this.outcomeMeasure = new ArrayList<ResearchStudyOutcomeMeasureComponent>();
        }
        this.outcomeMeasure.add(t);
        return t;
    }

    public ResearchStudy addOutcomeMeasure(ResearchStudyOutcomeMeasureComponent t) {
        if (t == null) {
            return this;
        }
        if (this.outcomeMeasure == null) {
            this.outcomeMeasure = new ArrayList<ResearchStudyOutcomeMeasureComponent>();
        }
        this.outcomeMeasure.add(t);
        return this;
    }

    public ResearchStudyOutcomeMeasureComponent getOutcomeMeasureFirstRep() {
        if (this.getOutcomeMeasure().isEmpty()) {
            this.addOutcomeMeasure();
        }
        return this.getOutcomeMeasure().get(0);
    }

    public List<Reference> getResult() {
        if (this.result == null) {
            this.result = new ArrayList<Reference>();
        }
        return this.result;
    }

    public ResearchStudy setResult(List<Reference> theResult) {
        this.result = theResult;
        return this;
    }

    public boolean hasResult() {
        if (this.result == null) {
            return false;
        }
        for (Reference item : this.result) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addResult() {
        Reference t = new Reference();
        if (this.result == null) {
            this.result = new ArrayList<Reference>();
        }
        this.result.add(t);
        return t;
    }

    public ResearchStudy addResult(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.result == null) {
            this.result = new ArrayList<Reference>();
        }
        this.result.add(t);
        return this;
    }

    public Reference getResultFirstRep() {
        if (this.getResult().isEmpty()) {
            this.addResult();
        }
        return this.getResult().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("url", "uri", "Canonical identifier for this study resource, represented as a globally unique URI.", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifiers assigned to this research study by the sponsor or other systems.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("version", "string", "The business version for the study record.", 0, 1, this.version));
        children.add(new Property("name", "string", "Name for this study (computer friendly).", 0, 1, this.name));
        children.add(new Property(SP_TITLE, "string", "The human readable name of the research study.", 0, 1, this.title));
        children.add(new Property("label", "", "Additional names for the study.", 0, Integer.MAX_VALUE, this.label));
        children.add(new Property(SP_PROTOCOL, "Reference(PlanDefinition)", "The set of steps expected to be performed as part of the execution of the study.", 0, Integer.MAX_VALUE, this.protocol));
        children.add(new Property("partOf", "Reference(ResearchStudy)", "A larger research study of which this particular study is a component or step.", 0, Integer.MAX_VALUE, this.partOf));
        children.add(new Property("relatedArtifact", "RelatedArtifact", "Citations, references, URLs and other related documents.  When using relatedArtifact to share URLs, the relatedArtifact.type will often be set to one of \"documentation\" or \"supported-with\" and the URL value will often be in relatedArtifact.document.url but another possible location is relatedArtifact.resource when it is a canonical URL.", 0, Integer.MAX_VALUE, this.relatedArtifact));
        children.add(new Property(SP_DATE, "dateTime", "The date (and optionally time) when the ResearchStudy Resource was last significantly changed. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the ResearchStudy Resource changes.", 0, 1, this.date));
        children.add(new Property(SP_STATUS, "code", "The publication state of the resource (not of the study).", 0, 1, this.status));
        children.add(new Property("primaryPurposeType", "CodeableConcept", "The type of study based upon the intent of the study activities. A classification of the intent of the study.", 0, 1, this.primaryPurposeType));
        children.add(new Property("phase", "CodeableConcept", "The stage in the progression of a therapy from initial experimental use in humans in clinical trials to post-market evaluation.", 0, 1, this.phase));
        children.add(new Property("studyDesign", "CodeableConcept", "Codes categorizing the type of study such as investigational vs. observational, type of blinding, type of randomization, safety vs. efficacy, etc.", 0, Integer.MAX_VALUE, this.studyDesign));
        children.add(new Property(SP_FOCUS, "CodeableReference(Medication|MedicinalProductDefinition|SubstanceDefinition|EvidenceVariable)", "The medication(s), food(s), therapy(ies), device(s) or other concerns or interventions that the study is seeking to gain more information about.", 0, Integer.MAX_VALUE, this.focus));
        children.add(new Property(SP_CONDITION, "CodeableConcept", "The condition that is the focus of the study.  For example, In a study to examine risk factors for Lupus, might have as an inclusion criterion \"healthy volunteer\", but the target condition code would be a Lupus SNOMED code.", 0, Integer.MAX_VALUE, this.condition));
        children.add(new Property(SP_KEYWORD, "CodeableConcept", "Key terms to aid in searching for or filtering the study.", 0, Integer.MAX_VALUE, this.keyword));
        children.add(new Property(SP_REGION, "CodeableConcept", "A country, state or other area where the study is taking place rather than its precise geographic location or address.", 0, Integer.MAX_VALUE, this.region));
        children.add(new Property("descriptionSummary", "markdown", "A brief text for explaining the study.", 0, 1, this.descriptionSummary));
        children.add(new Property("description", "markdown", "A detailed and human-readable narrative of the study. E.g., study abstract.", 0, 1, this.description));
        children.add(new Property("period", "Period", "Identifies the start date and the expected (or actual, depending on status) end date for the study.", 0, 1, this.period));
        children.add(new Property(SP_SITE, "Reference(Location|ResearchStudy|Organization)", "A facility in which study activities are conducted.", 0, Integer.MAX_VALUE, this.site));
        children.add(new Property("note", "Annotation", "Comments made about the study by the performer, subject or other participants.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("classifier", "CodeableConcept", "Additional grouping mechanism or categorization of a research study. Example: FDA regulated device, FDA regulated drug, MPG Paragraph 23b (a German legal requirement), IRB-exempt, etc. Implementation Note: do not use the classifier element to support existing semantics that are already supported thru explicit elements in the resource.", 0, Integer.MAX_VALUE, this.classifier));
        children.add(new Property("associatedParty", "", "Sponsors, collaborators, and other parties.", 0, Integer.MAX_VALUE, this.associatedParty));
        children.add(new Property("progressStatus", "", "Status of study with time for that status.", 0, Integer.MAX_VALUE, this.progressStatus));
        children.add(new Property("whyStopped", "CodeableConcept", "A description and/or code explaining the premature termination of the study.", 0, 1, this.whyStopped));
        children.add(new Property("recruitment", "", "Target or actual group of participants enrolled in study.", 0, 1, this.recruitment));
        children.add(new Property("comparisonGroup", "", "Describes an expected event or sequence of events for one of the subjects of a study. E.g. for a living subject: exposure to drug A, wash-out, exposure to drug B, wash-out, follow-up. E.g. for a stability study: {store sample from lot A at 25 degrees for 1 month}, {store sample from lot A at 40 degrees for 1 month}.", 0, Integer.MAX_VALUE, this.comparisonGroup));
        children.add(new Property("objective", "", "A goal that the study is aiming to achieve in terms of a scientific question to be answered by the analysis of data collected during the study.", 0, Integer.MAX_VALUE, this.objective));
        children.add(new Property("outcomeMeasure", "", "An \"outcome measure\", \"endpoint\", \"effect measure\" or \"measure of effect\" is a specific measurement or observation used to quantify the effect of experimental variables on the participants in a study, or for observational studies, to describe patterns of diseases or traits or associations with exposures, risk factors or treatment.", 0, Integer.MAX_VALUE, this.outcomeMeasure));
        children.add(new Property("result", "Reference(EvidenceReport|Citation|DiagnosticReport)", "Link to one or more sets of results generated by the study.  Could also link to a research registry holding the results such as ClinicalTrials.gov.", 0, Integer.MAX_VALUE, this.result));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property("url", "uri", "Canonical identifier for this study resource, represented as a globally unique URI.", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifiers assigned to this research study by the sponsor or other systems.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 351608024: {
                return new Property("version", "string", "The business version for the study record.", 0, 1, this.version);
            }
            case 3373707: {
                return new Property("name", "string", "Name for this study (computer friendly).", 0, 1, this.name);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "The human readable name of the research study.", 0, 1, this.title);
            }
            case 102727412: {
                return new Property("label", "", "Additional names for the study.", 0, Integer.MAX_VALUE, this.label);
            }
            case -989163880: {
                return new Property(SP_PROTOCOL, "Reference(PlanDefinition)", "The set of steps expected to be performed as part of the execution of the study.", 0, Integer.MAX_VALUE, this.protocol);
            }
            case -995410646: {
                return new Property("partOf", "Reference(ResearchStudy)", "A larger research study of which this particular study is a component or step.", 0, Integer.MAX_VALUE, this.partOf);
            }
            case 666807069: {
                return new Property("relatedArtifact", "RelatedArtifact", "Citations, references, URLs and other related documents.  When using relatedArtifact to share URLs, the relatedArtifact.type will often be set to one of \"documentation\" or \"supported-with\" and the URL value will often be in relatedArtifact.document.url but another possible location is relatedArtifact.resource when it is a canonical URL.", 0, Integer.MAX_VALUE, this.relatedArtifact);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date (and optionally time) when the ResearchStudy Resource was last significantly changed. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the ResearchStudy Resource changes.", 0, 1, this.date);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The publication state of the resource (not of the study).", 0, 1, this.status);
            }
            case -2132842986: {
                return new Property("primaryPurposeType", "CodeableConcept", "The type of study based upon the intent of the study activities. A classification of the intent of the study.", 0, 1, this.primaryPurposeType);
            }
            case 106629499: {
                return new Property("phase", "CodeableConcept", "The stage in the progression of a therapy from initial experimental use in humans in clinical trials to post-market evaluation.", 0, 1, this.phase);
            }
            case 1709211879: {
                return new Property("studyDesign", "CodeableConcept", "Codes categorizing the type of study such as investigational vs. observational, type of blinding, type of randomization, safety vs. efficacy, etc.", 0, Integer.MAX_VALUE, this.studyDesign);
            }
            case 97604824: {
                return new Property(SP_FOCUS, "CodeableReference(Medication|MedicinalProductDefinition|SubstanceDefinition|EvidenceVariable)", "The medication(s), food(s), therapy(ies), device(s) or other concerns or interventions that the study is seeking to gain more information about.", 0, Integer.MAX_VALUE, this.focus);
            }
            case -861311717: {
                return new Property(SP_CONDITION, "CodeableConcept", "The condition that is the focus of the study.  For example, In a study to examine risk factors for Lupus, might have as an inclusion criterion \"healthy volunteer\", but the target condition code would be a Lupus SNOMED code.", 0, Integer.MAX_VALUE, this.condition);
            }
            case -814408215: {
                return new Property(SP_KEYWORD, "CodeableConcept", "Key terms to aid in searching for or filtering the study.", 0, Integer.MAX_VALUE, this.keyword);
            }
            case -934795532: {
                return new Property(SP_REGION, "CodeableConcept", "A country, state or other area where the study is taking place rather than its precise geographic location or address.", 0, Integer.MAX_VALUE, this.region);
            }
            case 21530634: {
                return new Property("descriptionSummary", "markdown", "A brief text for explaining the study.", 0, 1, this.descriptionSummary);
            }
            case -1724546052: {
                return new Property("description", "markdown", "A detailed and human-readable narrative of the study. E.g., study abstract.", 0, 1, this.description);
            }
            case -991726143: {
                return new Property("period", "Period", "Identifies the start date and the expected (or actual, depending on status) end date for the study.", 0, 1, this.period);
            }
            case 3530567: {
                return new Property(SP_SITE, "Reference(Location|ResearchStudy|Organization)", "A facility in which study activities are conducted.", 0, Integer.MAX_VALUE, this.site);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Comments made about the study by the performer, subject or other participants.", 0, Integer.MAX_VALUE, this.note);
            }
            case -281470431: {
                return new Property("classifier", "CodeableConcept", "Additional grouping mechanism or categorization of a research study. Example: FDA regulated device, FDA regulated drug, MPG Paragraph 23b (a German legal requirement), IRB-exempt, etc. Implementation Note: do not use the classifier element to support existing semantics that are already supported thru explicit elements in the resource.", 0, Integer.MAX_VALUE, this.classifier);
            }
            case -1841460864: {
                return new Property("associatedParty", "", "Sponsors, collaborators, and other parties.", 0, Integer.MAX_VALUE, this.associatedParty);
            }
            case -1897502593: {
                return new Property("progressStatus", "", "Status of study with time for that status.", 0, Integer.MAX_VALUE, this.progressStatus);
            }
            case -699986715: {
                return new Property("whyStopped", "CodeableConcept", "A description and/or code explaining the premature termination of the study.", 0, 1, this.whyStopped);
            }
            case 780783004: {
                return new Property("recruitment", "", "Target or actual group of participants enrolled in study.", 0, 1, this.recruitment);
            }
            case -138266634: {
                return new Property("comparisonGroup", "", "Describes an expected event or sequence of events for one of the subjects of a study. E.g. for a living subject: exposure to drug A, wash-out, exposure to drug B, wash-out, follow-up. E.g. for a stability study: {store sample from lot A at 25 degrees for 1 month}, {store sample from lot A at 40 degrees for 1 month}.", 0, Integer.MAX_VALUE, this.comparisonGroup);
            }
            case -1489585863: {
                return new Property("objective", "", "A goal that the study is aiming to achieve in terms of a scientific question to be answered by the analysis of data collected during the study.", 0, Integer.MAX_VALUE, this.objective);
            }
            case -1510689364: {
                return new Property("outcomeMeasure", "", "An \"outcome measure\", \"endpoint\", \"effect measure\" or \"measure of effect\" is a specific measurement or observation used to quantify the effect of experimental variables on the participants in a study, or for observational studies, to describe patterns of diseases or traits or associations with exposures, risk factors or treatment.", 0, Integer.MAX_VALUE, this.outcomeMeasure);
            }
            case -934426595: {
                return new Property("result", "Reference(EvidenceReport|Citation|DiagnosticReport)", "Link to one or more sets of results generated by the study.  Could also link to a research registry holding the results such as ClinicalTrials.gov.", 0, Integer.MAX_VALUE, this.result);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.title;
                }
                return baseArray;
            }
            case 102727412: {
                return this.label == null ? new Base[]{} : this.label.toArray(new Base[this.label.size()]);
            }
            case -989163880: {
                return this.protocol == null ? new Base[]{} : this.protocol.toArray(new Base[this.protocol.size()]);
            }
            case -995410646: {
                return this.partOf == null ? new Base[]{} : this.partOf.toArray(new Base[this.partOf.size()]);
            }
            case 666807069: {
                return this.relatedArtifact == null ? new Base[]{} : this.relatedArtifact.toArray(new Base[this.relatedArtifact.size()]);
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.date;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.status;
                }
                return baseArray;
            }
            case -2132842986: {
                Base[] baseArray;
                if (this.primaryPurposeType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.primaryPurposeType;
                }
                return baseArray;
            }
            case 106629499: {
                Base[] baseArray;
                if (this.phase == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.phase;
                }
                return baseArray;
            }
            case 1709211879: {
                return this.studyDesign == null ? new Base[]{} : this.studyDesign.toArray(new Base[this.studyDesign.size()]);
            }
            case 97604824: {
                return this.focus == null ? new Base[]{} : this.focus.toArray(new Base[this.focus.size()]);
            }
            case -861311717: {
                return this.condition == null ? new Base[]{} : this.condition.toArray(new Base[this.condition.size()]);
            }
            case -814408215: {
                return this.keyword == null ? new Base[]{} : this.keyword.toArray(new Base[this.keyword.size()]);
            }
            case -934795532: {
                return this.region == null ? new Base[]{} : this.region.toArray(new Base[this.region.size()]);
            }
            case 21530634: {
                Base[] baseArray;
                if (this.descriptionSummary == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.descriptionSummary;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.description;
                }
                return baseArray;
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.period;
                }
                return baseArray;
            }
            case 3530567: {
                return this.site == null ? new Base[]{} : this.site.toArray(new Base[this.site.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case -281470431: {
                return this.classifier == null ? new Base[]{} : this.classifier.toArray(new Base[this.classifier.size()]);
            }
            case -1841460864: {
                return this.associatedParty == null ? new Base[]{} : this.associatedParty.toArray(new Base[this.associatedParty.size()]);
            }
            case -1897502593: {
                return this.progressStatus == null ? new Base[]{} : this.progressStatus.toArray(new Base[this.progressStatus.size()]);
            }
            case -699986715: {
                Base[] baseArray;
                if (this.whyStopped == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.whyStopped;
                }
                return baseArray;
            }
            case 780783004: {
                Base[] baseArray;
                if (this.recruitment == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.recruitment;
                }
                return baseArray;
            }
            case -138266634: {
                return this.comparisonGroup == null ? new Base[]{} : this.comparisonGroup.toArray(new Base[this.comparisonGroup.size()]);
            }
            case -1489585863: {
                return this.objective == null ? new Base[]{} : this.objective.toArray(new Base[this.objective.size()]);
            }
            case -1510689364: {
                return this.outcomeMeasure == null ? new Base[]{} : this.outcomeMeasure.toArray(new Base[this.outcomeMeasure.size()]);
            }
            case -934426595: {
                return this.result == null ? new Base[]{} : this.result.toArray(new Base[this.result.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = TypeConvertor.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 351608024: {
                this.version = TypeConvertor.castToString(value);
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = TypeConvertor.castToString(value);
                return value;
            }
            case 102727412: {
                this.getLabel().add((ResearchStudyLabelComponent)((Object)value));
                return value;
            }
            case -989163880: {
                this.getProtocol().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -995410646: {
                this.getPartOf().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 666807069: {
                this.getRelatedArtifact().add(TypeConvertor.castToRelatedArtifact(value));
                return value;
            }
            case 3076014: {
                this.date = TypeConvertor.castToDateTime(value);
                return value;
            }
            case -892481550: {
                value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -2132842986: {
                this.primaryPurposeType = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 106629499: {
                this.phase = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 1709211879: {
                this.getStudyDesign().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 97604824: {
                this.getFocus().add(TypeConvertor.castToCodeableReference(value));
                return value;
            }
            case -861311717: {
                this.getCondition().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -814408215: {
                this.getKeyword().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -934795532: {
                this.getRegion().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 21530634: {
                this.descriptionSummary = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -991726143: {
                this.period = TypeConvertor.castToPeriod(value);
                return value;
            }
            case 3530567: {
                this.getSite().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
            case -281470431: {
                this.getClassifier().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1841460864: {
                this.getAssociatedParty().add((ResearchStudyAssociatedPartyComponent)((Object)value));
                return value;
            }
            case -1897502593: {
                this.getProgressStatus().add((ResearchStudyProgressStatusComponent)((Object)value));
                return value;
            }
            case -699986715: {
                this.whyStopped = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 780783004: {
                this.recruitment = (ResearchStudyRecruitmentComponent)((Object)value);
                return value;
            }
            case -138266634: {
                this.getComparisonGroup().add((ResearchStudyComparisonGroupComponent)((Object)value));
                return value;
            }
            case -1489585863: {
                this.getObjective().add((ResearchStudyObjectiveComponent)((Object)value));
                return value;
            }
            case -1510689364: {
                this.getOutcomeMeasure().add((ResearchStudyOutcomeMeasureComponent)((Object)value));
                return value;
            }
            case -934426595: {
                this.getResult().add(TypeConvertor.castToReference(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("url")) {
            this.url = TypeConvertor.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("version")) {
            this.version = TypeConvertor.castToString(value);
        } else if (name.equals("name")) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = TypeConvertor.castToString(value);
        } else if (name.equals("label")) {
            this.getLabel().add((ResearchStudyLabelComponent)((Object)value));
        } else if (name.equals(SP_PROTOCOL)) {
            this.getProtocol().add(TypeConvertor.castToReference(value));
        } else if (name.equals("partOf")) {
            this.getPartOf().add(TypeConvertor.castToReference(value));
        } else if (name.equals("relatedArtifact")) {
            this.getRelatedArtifact().add(TypeConvertor.castToRelatedArtifact(value));
        } else if (name.equals(SP_DATE)) {
            this.date = TypeConvertor.castToDateTime(value);
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("primaryPurposeType")) {
            this.primaryPurposeType = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("phase")) {
            this.phase = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("studyDesign")) {
            this.getStudyDesign().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_FOCUS)) {
            this.getFocus().add(TypeConvertor.castToCodeableReference(value));
        } else if (name.equals(SP_CONDITION)) {
            this.getCondition().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_KEYWORD)) {
            this.getKeyword().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_REGION)) {
            this.getRegion().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("descriptionSummary")) {
            this.descriptionSummary = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("description")) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("period")) {
            this.period = TypeConvertor.castToPeriod(value);
        } else if (name.equals(SP_SITE)) {
            this.getSite().add(TypeConvertor.castToReference(value));
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else if (name.equals("classifier")) {
            this.getClassifier().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("associatedParty")) {
            this.getAssociatedParty().add((ResearchStudyAssociatedPartyComponent)((Object)value));
        } else if (name.equals("progressStatus")) {
            this.getProgressStatus().add((ResearchStudyProgressStatusComponent)((Object)value));
        } else if (name.equals("whyStopped")) {
            this.whyStopped = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("recruitment")) {
            this.recruitment = (ResearchStudyRecruitmentComponent)((Object)value);
        } else if (name.equals("comparisonGroup")) {
            this.getComparisonGroup().add((ResearchStudyComparisonGroupComponent)((Object)value));
        } else if (name.equals("objective")) {
            this.getObjective().add((ResearchStudyObjectiveComponent)((Object)value));
        } else if (name.equals("outcomeMeasure")) {
            this.getOutcomeMeasure().add((ResearchStudyOutcomeMeasureComponent)((Object)value));
        } else if (name.equals("result")) {
            this.getResult().add(TypeConvertor.castToReference(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case 102727412: {
                return this.addLabel();
            }
            case -989163880: {
                return this.addProtocol();
            }
            case -995410646: {
                return this.addPartOf();
            }
            case 666807069: {
                return this.addRelatedArtifact();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -2132842986: {
                return this.getPrimaryPurposeType();
            }
            case 106629499: {
                return this.getPhase();
            }
            case 1709211879: {
                return this.addStudyDesign();
            }
            case 97604824: {
                return this.addFocus();
            }
            case -861311717: {
                return this.addCondition();
            }
            case -814408215: {
                return this.addKeyword();
            }
            case -934795532: {
                return this.addRegion();
            }
            case 21530634: {
                return this.getDescriptionSummaryElement();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case 3530567: {
                return this.addSite();
            }
            case 3387378: {
                return this.addNote();
            }
            case -281470431: {
                return this.addClassifier();
            }
            case -1841460864: {
                return this.addAssociatedParty();
            }
            case -1897502593: {
                return this.addProgressStatus();
            }
            case -699986715: {
                return this.getWhyStopped();
            }
            case 780783004: {
                return this.getRecruitment();
            }
            case -138266634: {
                return this.addComparisonGroup();
            }
            case -1489585863: {
                return this.addObjective();
            }
            case -1510689364: {
                return this.addOutcomeMeasure();
            }
            case -934426595: {
                return this.addResult();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case 102727412: {
                return new String[0];
            }
            case -989163880: {
                return new String[]{"Reference"};
            }
            case -995410646: {
                return new String[]{"Reference"};
            }
            case 666807069: {
                return new String[]{"RelatedArtifact"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -2132842986: {
                return new String[]{"CodeableConcept"};
            }
            case 106629499: {
                return new String[]{"CodeableConcept"};
            }
            case 1709211879: {
                return new String[]{"CodeableConcept"};
            }
            case 97604824: {
                return new String[]{"CodeableReference"};
            }
            case -861311717: {
                return new String[]{"CodeableConcept"};
            }
            case -814408215: {
                return new String[]{"CodeableConcept"};
            }
            case -934795532: {
                return new String[]{"CodeableConcept"};
            }
            case 21530634: {
                return new String[]{"markdown"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -991726143: {
                return new String[]{"Period"};
            }
            case 3530567: {
                return new String[]{"Reference"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case -281470431: {
                return new String[]{"CodeableConcept"};
            }
            case -1841460864: {
                return new String[0];
            }
            case -1897502593: {
                return new String[0];
            }
            case -699986715: {
                return new String[]{"CodeableConcept"};
            }
            case 780783004: {
                return new String[0];
            }
            case -138266634: {
                return new String[0];
            }
            case -1489585863: {
                return new String[0];
            }
            case -1510689364: {
                return new String[0];
            }
            case -934426595: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("url")) {
            throw new FHIRException("Cannot call addChild on a primitive type ResearchStudy.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("version")) {
            throw new FHIRException("Cannot call addChild on a primitive type ResearchStudy.version");
        }
        if (name.equals("name")) {
            throw new FHIRException("Cannot call addChild on a primitive type ResearchStudy.name");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a primitive type ResearchStudy.title");
        }
        if (name.equals("label")) {
            return this.addLabel();
        }
        if (name.equals(SP_PROTOCOL)) {
            return this.addProtocol();
        }
        if (name.equals("partOf")) {
            return this.addPartOf();
        }
        if (name.equals("relatedArtifact")) {
            return this.addRelatedArtifact();
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type ResearchStudy.date");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type ResearchStudy.status");
        }
        if (name.equals("primaryPurposeType")) {
            this.primaryPurposeType = new CodeableConcept();
            return this.primaryPurposeType;
        }
        if (name.equals("phase")) {
            this.phase = new CodeableConcept();
            return this.phase;
        }
        if (name.equals("studyDesign")) {
            return this.addStudyDesign();
        }
        if (name.equals(SP_FOCUS)) {
            return this.addFocus();
        }
        if (name.equals(SP_CONDITION)) {
            return this.addCondition();
        }
        if (name.equals(SP_KEYWORD)) {
            return this.addKeyword();
        }
        if (name.equals(SP_REGION)) {
            return this.addRegion();
        }
        if (name.equals("descriptionSummary")) {
            throw new FHIRException("Cannot call addChild on a primitive type ResearchStudy.descriptionSummary");
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type ResearchStudy.description");
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals(SP_SITE)) {
            return this.addSite();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("classifier")) {
            return this.addClassifier();
        }
        if (name.equals("associatedParty")) {
            return this.addAssociatedParty();
        }
        if (name.equals("progressStatus")) {
            return this.addProgressStatus();
        }
        if (name.equals("whyStopped")) {
            this.whyStopped = new CodeableConcept();
            return this.whyStopped;
        }
        if (name.equals("recruitment")) {
            this.recruitment = new ResearchStudyRecruitmentComponent();
            return this.recruitment;
        }
        if (name.equals("comparisonGroup")) {
            return this.addComparisonGroup();
        }
        if (name.equals("objective")) {
            return this.addObjective();
        }
        if (name.equals("outcomeMeasure")) {
            return this.addOutcomeMeasure();
        }
        if (name.equals("result")) {
            return this.addResult();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ResearchStudy";
    }

    @Override
    public ResearchStudy copy() {
        ResearchStudy dst = new ResearchStudy();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ResearchStudy dst) {
        super.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        StringType stringType = dst.title = this.title == null ? null : this.title.copy();
        if (this.label != null) {
            dst.label = new ArrayList<ResearchStudyLabelComponent>();
            for (ResearchStudyLabelComponent researchStudyLabelComponent : this.label) {
                dst.label.add(researchStudyLabelComponent.copy());
            }
        }
        if (this.protocol != null) {
            dst.protocol = new ArrayList<Reference>();
            for (Reference reference : this.protocol) {
                dst.protocol.add(reference.copy());
            }
        }
        if (this.partOf != null) {
            dst.partOf = new ArrayList<Reference>();
            for (Reference reference : this.partOf) {
                dst.partOf.add(reference.copy());
            }
        }
        if (this.relatedArtifact != null) {
            dst.relatedArtifact = new ArrayList<RelatedArtifact>();
            for (RelatedArtifact relatedArtifact : this.relatedArtifact) {
                dst.relatedArtifact.add(relatedArtifact.copy());
            }
        }
        dst.date = this.date == null ? null : this.date.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.primaryPurposeType = this.primaryPurposeType == null ? null : this.primaryPurposeType.copy();
        CodeableConcept codeableConcept = dst.phase = this.phase == null ? null : this.phase.copy();
        if (this.studyDesign != null) {
            dst.studyDesign = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.studyDesign) {
                dst.studyDesign.add(codeableConcept2.copy());
            }
        }
        if (this.focus != null) {
            dst.focus = new ArrayList<CodeableReference>();
            for (CodeableReference codeableReference : this.focus) {
                dst.focus.add(codeableReference.copy());
            }
        }
        if (this.condition != null) {
            dst.condition = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept3 : this.condition) {
                dst.condition.add(codeableConcept3.copy());
            }
        }
        if (this.keyword != null) {
            dst.keyword = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept4 : this.keyword) {
                dst.keyword.add(codeableConcept4.copy());
            }
        }
        if (this.region != null) {
            dst.region = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept5 : this.region) {
                dst.region.add(codeableConcept5.copy());
            }
        }
        dst.descriptionSummary = this.descriptionSummary == null ? null : this.descriptionSummary.copy();
        dst.description = this.description == null ? null : this.description.copy();
        Period period = dst.period = this.period == null ? null : this.period.copy();
        if (this.site != null) {
            dst.site = new ArrayList<Reference>();
            for (Reference reference : this.site) {
                dst.site.add(reference.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.classifier != null) {
            dst.classifier = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept6 : this.classifier) {
                dst.classifier.add(codeableConcept6.copy());
            }
        }
        if (this.associatedParty != null) {
            dst.associatedParty = new ArrayList<ResearchStudyAssociatedPartyComponent>();
            for (ResearchStudyAssociatedPartyComponent researchStudyAssociatedPartyComponent : this.associatedParty) {
                dst.associatedParty.add(researchStudyAssociatedPartyComponent.copy());
            }
        }
        if (this.progressStatus != null) {
            dst.progressStatus = new ArrayList<ResearchStudyProgressStatusComponent>();
            for (ResearchStudyProgressStatusComponent researchStudyProgressStatusComponent : this.progressStatus) {
                dst.progressStatus.add(researchStudyProgressStatusComponent.copy());
            }
        }
        dst.whyStopped = this.whyStopped == null ? null : this.whyStopped.copy();
        ResearchStudyRecruitmentComponent researchStudyRecruitmentComponent = dst.recruitment = this.recruitment == null ? null : this.recruitment.copy();
        if (this.comparisonGroup != null) {
            dst.comparisonGroup = new ArrayList<ResearchStudyComparisonGroupComponent>();
            for (ResearchStudyComparisonGroupComponent researchStudyComparisonGroupComponent : this.comparisonGroup) {
                dst.comparisonGroup.add(researchStudyComparisonGroupComponent.copy());
            }
        }
        if (this.objective != null) {
            dst.objective = new ArrayList<ResearchStudyObjectiveComponent>();
            for (ResearchStudyObjectiveComponent researchStudyObjectiveComponent : this.objective) {
                dst.objective.add(researchStudyObjectiveComponent.copy());
            }
        }
        if (this.outcomeMeasure != null) {
            dst.outcomeMeasure = new ArrayList<ResearchStudyOutcomeMeasureComponent>();
            for (ResearchStudyOutcomeMeasureComponent researchStudyOutcomeMeasureComponent : this.outcomeMeasure) {
                dst.outcomeMeasure.add(researchStudyOutcomeMeasureComponent.copy());
            }
        }
        if (this.result != null) {
            dst.result = new ArrayList<Reference>();
            for (Reference reference : this.result) {
                dst.result.add(reference.copy());
            }
        }
    }

    protected ResearchStudy typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ResearchStudy)) {
            return false;
        }
        ResearchStudy o = (ResearchStudy)other_;
        return ResearchStudy.compareDeep(this.url, o.url, true) && ResearchStudy.compareDeep(this.identifier, o.identifier, true) && ResearchStudy.compareDeep(this.version, o.version, true) && ResearchStudy.compareDeep(this.name, o.name, true) && ResearchStudy.compareDeep(this.title, o.title, true) && ResearchStudy.compareDeep(this.label, o.label, true) && ResearchStudy.compareDeep(this.protocol, o.protocol, true) && ResearchStudy.compareDeep(this.partOf, o.partOf, true) && ResearchStudy.compareDeep(this.relatedArtifact, o.relatedArtifact, true) && ResearchStudy.compareDeep(this.date, o.date, true) && ResearchStudy.compareDeep(this.status, o.status, true) && ResearchStudy.compareDeep(this.primaryPurposeType, o.primaryPurposeType, true) && ResearchStudy.compareDeep(this.phase, o.phase, true) && ResearchStudy.compareDeep(this.studyDesign, o.studyDesign, true) && ResearchStudy.compareDeep(this.focus, o.focus, true) && ResearchStudy.compareDeep(this.condition, o.condition, true) && ResearchStudy.compareDeep(this.keyword, o.keyword, true) && ResearchStudy.compareDeep(this.region, o.region, true) && ResearchStudy.compareDeep(this.descriptionSummary, o.descriptionSummary, true) && ResearchStudy.compareDeep(this.description, o.description, true) && ResearchStudy.compareDeep(this.period, o.period, true) && ResearchStudy.compareDeep(this.site, o.site, true) && ResearchStudy.compareDeep(this.note, o.note, true) && ResearchStudy.compareDeep(this.classifier, o.classifier, true) && ResearchStudy.compareDeep(this.associatedParty, o.associatedParty, true) && ResearchStudy.compareDeep(this.progressStatus, o.progressStatus, true) && ResearchStudy.compareDeep(this.whyStopped, o.whyStopped, true) && ResearchStudy.compareDeep(this.recruitment, o.recruitment, true) && ResearchStudy.compareDeep(this.comparisonGroup, o.comparisonGroup, true) && ResearchStudy.compareDeep(this.objective, o.objective, true) && ResearchStudy.compareDeep(this.outcomeMeasure, o.outcomeMeasure, true) && ResearchStudy.compareDeep(this.result, o.result, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ResearchStudy)) {
            return false;
        }
        ResearchStudy o = (ResearchStudy)other_;
        return ResearchStudy.compareValues(this.url, o.url, true) && ResearchStudy.compareValues(this.version, o.version, true) && ResearchStudy.compareValues(this.name, o.name, true) && ResearchStudy.compareValues(this.title, o.title, true) && ResearchStudy.compareValues(this.date, o.date, true) && ResearchStudy.compareValues(this.status, o.status, true) && ResearchStudy.compareValues(this.descriptionSummary, o.descriptionSummary, true) && ResearchStudy.compareValues(this.description, o.description, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.url, this.identifier, this.version, this.name, this.title, this.label, this.protocol, this.partOf, this.relatedArtifact, this.date, this.status, this.primaryPurposeType, this.phase, this.studyDesign, this.focus, this.condition, this.keyword, this.region, this.descriptionSummary, this.description, this.period, this.site, this.note, this.classifier, this.associatedParty, this.progressStatus, this.whyStopped, this.recruitment, this.comparisonGroup, this.objective, this.outcomeMeasure, this.result});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ResearchStudy;
    }

    @Block
    public static class ResearchStudyOutcomeMeasureComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Label for the outcome", formalDefinition="Label for the outcome.")
        protected StringType name;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="primary | secondary | exploratory", formalDefinition="The parameter or characteristic being assessed as one of the values by which the study is assessed.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/research-study-objective-type")
        protected List<CodeableConcept> type;
        @Child(name="description", type={MarkdownType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of the outcome", formalDefinition="Description of the outcome.")
        protected MarkdownType description;
        @Child(name="reference", type={EvidenceVariable.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Structured outcome definition", formalDefinition="Structured outcome definition.")
        protected Reference reference;
        private static final long serialVersionUID = 1786559672L;

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchStudyOutcomeMeasureComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ResearchStudyOutcomeMeasureComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ResearchStudyOutcomeMeasureComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public List<CodeableConcept> getType() {
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            return this.type;
        }

        public ResearchStudyOutcomeMeasureComponent setType(List<CodeableConcept> theType) {
            this.type = theType;
            return this;
        }

        public boolean hasType() {
            if (this.type == null) {
                return false;
            }
            for (CodeableConcept item : this.type) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addType() {
            CodeableConcept t = new CodeableConcept();
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return t;
        }

        public ResearchStudyOutcomeMeasureComponent addType(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return this;
        }

        public CodeableConcept getTypeFirstRep() {
            if (this.getType().isEmpty()) {
                this.addType();
            }
            return this.getType().get(0);
        }

        public MarkdownType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchStudyOutcomeMeasureComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new MarkdownType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ResearchStudyOutcomeMeasureComponent setDescriptionElement(MarkdownType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ResearchStudyOutcomeMeasureComponent setDescription(String value) {
            if (value == null) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new MarkdownType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public Reference getReference() {
            if (this.reference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchStudyOutcomeMeasureComponent.reference");
                }
                if (Configuration.doAutoCreate()) {
                    this.reference = new Reference();
                }
            }
            return this.reference;
        }

        public boolean hasReference() {
            return this.reference != null && !this.reference.isEmpty();
        }

        public ResearchStudyOutcomeMeasureComponent setReference(Reference value) {
            this.reference = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("name", "string", "Label for the outcome.", 0, 1, this.name));
            children.add(new Property("type", "CodeableConcept", "The parameter or characteristic being assessed as one of the values by which the study is assessed.", 0, Integer.MAX_VALUE, this.type));
            children.add(new Property("description", "markdown", "Description of the outcome.", 0, 1, this.description));
            children.add(new Property("reference", "Reference(EvidenceVariable)", "Structured outcome definition.", 0, 1, this.reference));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property("name", "string", "Label for the outcome.", 0, 1, this.name);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The parameter or characteristic being assessed as one of the values by which the study is assessed.", 0, Integer.MAX_VALUE, this.type);
                }
                case -1724546052: {
                    return new Property("description", "markdown", "Description of the outcome.", 0, 1, this.description);
                }
                case -925155509: {
                    return new Property("reference", "Reference(EvidenceVariable)", "Structured outcome definition.", 0, 1, this.reference);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 3575610: {
                    return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
                case -925155509: {
                    Base[] baseArray;
                    if (this.reference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.reference;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = TypeConvertor.castToString(value);
                    return value;
                }
                case 3575610: {
                    this.getType().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case -925155509: {
                    this.reference = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = TypeConvertor.castToString(value);
            } else if (name.equals("type")) {
                this.getType().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("description")) {
                this.description = TypeConvertor.castToMarkdown(value);
            } else if (name.equals("reference")) {
                this.reference = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case 3575610: {
                    return this.addType();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -925155509: {
                    return this.getReference();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"string"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1724546052: {
                    return new String[]{"markdown"};
                }
                case -925155509: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a primitive type ResearchStudy.outcomeMeasure.name");
            }
            if (name.equals("type")) {
                return this.addType();
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type ResearchStudy.outcomeMeasure.description");
            }
            if (name.equals("reference")) {
                this.reference = new Reference();
                return this.reference;
            }
            return super.addChild(name);
        }

        @Override
        public ResearchStudyOutcomeMeasureComponent copy() {
            ResearchStudyOutcomeMeasureComponent dst = new ResearchStudyOutcomeMeasureComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ResearchStudyOutcomeMeasureComponent dst) {
            super.copyValues(dst);
            StringType stringType = dst.name = this.name == null ? null : this.name.copy();
            if (this.type != null) {
                dst.type = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.type) {
                    dst.type.add(i.copy());
                }
            }
            dst.description = this.description == null ? null : this.description.copy();
            dst.reference = this.reference == null ? null : this.reference.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ResearchStudyOutcomeMeasureComponent)) {
                return false;
            }
            ResearchStudyOutcomeMeasureComponent o = (ResearchStudyOutcomeMeasureComponent)other_;
            return ResearchStudyOutcomeMeasureComponent.compareDeep(this.name, o.name, true) && ResearchStudyOutcomeMeasureComponent.compareDeep(this.type, o.type, true) && ResearchStudyOutcomeMeasureComponent.compareDeep(this.description, o.description, true) && ResearchStudyOutcomeMeasureComponent.compareDeep(this.reference, o.reference, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ResearchStudyOutcomeMeasureComponent)) {
                return false;
            }
            ResearchStudyOutcomeMeasureComponent o = (ResearchStudyOutcomeMeasureComponent)other_;
            return ResearchStudyOutcomeMeasureComponent.compareValues(this.name, o.name, true) && ResearchStudyOutcomeMeasureComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.name, this.type, this.description, this.reference});
        }

        @Override
        public String fhirType() {
            return "ResearchStudy.outcomeMeasure";
        }
    }

    @Block
    public static class ResearchStudyObjectiveComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Label for the objective", formalDefinition="Unique, human-readable label for this objective of the study.")
        protected StringType name;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="primary | secondary | exploratory", formalDefinition="The kind of study objective.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/research-study-objective-type")
        protected CodeableConcept type;
        @Child(name="description", type={MarkdownType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of the objective", formalDefinition="Free text description of the objective of the study.  This is what the study is trying to achieve rather than how it is going to achieve it (see ResearchStudy.description).")
        protected MarkdownType description;
        private static final long serialVersionUID = -1976083810L;

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchStudyObjectiveComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ResearchStudyObjectiveComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ResearchStudyObjectiveComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchStudyObjectiveComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ResearchStudyObjectiveComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public MarkdownType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchStudyObjectiveComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new MarkdownType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ResearchStudyObjectiveComponent setDescriptionElement(MarkdownType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ResearchStudyObjectiveComponent setDescription(String value) {
            if (value == null) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new MarkdownType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("name", "string", "Unique, human-readable label for this objective of the study.", 0, 1, this.name));
            children.add(new Property("type", "CodeableConcept", "The kind of study objective.", 0, 1, this.type));
            children.add(new Property("description", "markdown", "Free text description of the objective of the study.  This is what the study is trying to achieve rather than how it is going to achieve it (see ResearchStudy.description).", 0, 1, this.description));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property("name", "string", "Unique, human-readable label for this objective of the study.", 0, 1, this.name);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The kind of study objective.", 0, 1, this.type);
                }
                case -1724546052: {
                    return new Property("description", "markdown", "Free text description of the objective of the study.  This is what the study is trying to achieve rather than how it is going to achieve it (see ResearchStudy.description).", 0, 1, this.description);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.description;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = TypeConvertor.castToString(value);
                    return value;
                }
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToMarkdown(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = TypeConvertor.castToString(value);
            } else if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("description")) {
                this.description = TypeConvertor.castToMarkdown(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case 3575610: {
                    return this.getType();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"string"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1724546052: {
                    return new String[]{"markdown"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a primitive type ResearchStudy.objective.name");
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type ResearchStudy.objective.description");
            }
            return super.addChild(name);
        }

        @Override
        public ResearchStudyObjectiveComponent copy() {
            ResearchStudyObjectiveComponent dst = new ResearchStudyObjectiveComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ResearchStudyObjectiveComponent dst) {
            super.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.description = this.description == null ? null : this.description.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ResearchStudyObjectiveComponent)) {
                return false;
            }
            ResearchStudyObjectiveComponent o = (ResearchStudyObjectiveComponent)other_;
            return ResearchStudyObjectiveComponent.compareDeep(this.name, o.name, true) && ResearchStudyObjectiveComponent.compareDeep(this.type, o.type, true) && ResearchStudyObjectiveComponent.compareDeep(this.description, o.description, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ResearchStudyObjectiveComponent)) {
                return false;
            }
            ResearchStudyObjectiveComponent o = (ResearchStudyObjectiveComponent)other_;
            return ResearchStudyObjectiveComponent.compareValues(this.name, o.name, true) && ResearchStudyObjectiveComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.name, this.type, this.description});
        }

        @Override
        public String fhirType() {
            return "ResearchStudy.objective";
        }
    }

    @Block
    public static class ResearchStudyComparisonGroupComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Allows the comparisonGroup for the study and the comparisonGroup for the subject to be linked easily", formalDefinition="Allows the comparisonGroup for the study and the comparisonGroup for the subject to be linked easily.")
        protected List<Identifier> identifier;
        @Child(name="name", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Label for study comparisonGroup", formalDefinition="Unique, human-readable label for this comparisonGroup of the study.")
        protected StringType name;
        @Child(name="type", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Categorization of study comparisonGroup", formalDefinition="Categorization of study comparisonGroup, e.g. experimental, active comparator, placebo comparater.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/research-study-arm-type")
        protected CodeableConcept type;
        @Child(name="description", type={MarkdownType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Short explanation of study path", formalDefinition="A succinct description of the path through the study that would be followed by a subject adhering to this comparisonGroup.")
        protected MarkdownType description;
        @Child(name="intendedExposure", type={EvidenceVariable.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Interventions or exposures in this comparisonGroup or cohort", formalDefinition="Interventions or exposures in this comparisonGroup or cohort.")
        protected List<Reference> intendedExposure;
        @Child(name="observedGroup", type={Group.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Group of participants who were enrolled in study comparisonGroup", formalDefinition="Group of participants who were enrolled in study comparisonGroup.")
        protected Reference observedGroup;
        private static final long serialVersionUID = -1154017097L;

        public ResearchStudyComparisonGroupComponent() {
        }

        public ResearchStudyComparisonGroupComponent(String name) {
            this.setName(name);
        }

        public List<Identifier> getIdentifier() {
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            return this.identifier;
        }

        public ResearchStudyComparisonGroupComponent setIdentifier(List<Identifier> theIdentifier) {
            this.identifier = theIdentifier;
            return this;
        }

        public boolean hasIdentifier() {
            if (this.identifier == null) {
                return false;
            }
            for (Identifier item : this.identifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Identifier addIdentifier() {
            Identifier t = new Identifier();
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return t;
        }

        public ResearchStudyComparisonGroupComponent addIdentifier(Identifier t) {
            if (t == null) {
                return this;
            }
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return this;
        }

        public Identifier getIdentifierFirstRep() {
            if (this.getIdentifier().isEmpty()) {
                this.addIdentifier();
            }
            return this.getIdentifier().get(0);
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchStudyComparisonGroupComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ResearchStudyComparisonGroupComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ResearchStudyComparisonGroupComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchStudyComparisonGroupComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ResearchStudyComparisonGroupComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public MarkdownType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchStudyComparisonGroupComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new MarkdownType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ResearchStudyComparisonGroupComponent setDescriptionElement(MarkdownType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ResearchStudyComparisonGroupComponent setDescription(String value) {
            if (value == null) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new MarkdownType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public List<Reference> getIntendedExposure() {
            if (this.intendedExposure == null) {
                this.intendedExposure = new ArrayList<Reference>();
            }
            return this.intendedExposure;
        }

        public ResearchStudyComparisonGroupComponent setIntendedExposure(List<Reference> theIntendedExposure) {
            this.intendedExposure = theIntendedExposure;
            return this;
        }

        public boolean hasIntendedExposure() {
            if (this.intendedExposure == null) {
                return false;
            }
            for (Reference item : this.intendedExposure) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addIntendedExposure() {
            Reference t = new Reference();
            if (this.intendedExposure == null) {
                this.intendedExposure = new ArrayList<Reference>();
            }
            this.intendedExposure.add(t);
            return t;
        }

        public ResearchStudyComparisonGroupComponent addIntendedExposure(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.intendedExposure == null) {
                this.intendedExposure = new ArrayList<Reference>();
            }
            this.intendedExposure.add(t);
            return this;
        }

        public Reference getIntendedExposureFirstRep() {
            if (this.getIntendedExposure().isEmpty()) {
                this.addIntendedExposure();
            }
            return this.getIntendedExposure().get(0);
        }

        public Reference getObservedGroup() {
            if (this.observedGroup == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchStudyComparisonGroupComponent.observedGroup");
                }
                if (Configuration.doAutoCreate()) {
                    this.observedGroup = new Reference();
                }
            }
            return this.observedGroup;
        }

        public boolean hasObservedGroup() {
            return this.observedGroup != null && !this.observedGroup.isEmpty();
        }

        public ResearchStudyComparisonGroupComponent setObservedGroup(Reference value) {
            this.observedGroup = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(ResearchStudy.SP_IDENTIFIER, "Identifier", "Allows the comparisonGroup for the study and the comparisonGroup for the subject to be linked easily.", 0, Integer.MAX_VALUE, this.identifier));
            children.add(new Property("name", "string", "Unique, human-readable label for this comparisonGroup of the study.", 0, 1, this.name));
            children.add(new Property("type", "CodeableConcept", "Categorization of study comparisonGroup, e.g. experimental, active comparator, placebo comparater.", 0, 1, this.type));
            children.add(new Property("description", "markdown", "A succinct description of the path through the study that would be followed by a subject adhering to this comparisonGroup.", 0, 1, this.description));
            children.add(new Property("intendedExposure", "Reference(EvidenceVariable)", "Interventions or exposures in this comparisonGroup or cohort.", 0, Integer.MAX_VALUE, this.intendedExposure));
            children.add(new Property("observedGroup", "Reference(Group)", "Group of participants who were enrolled in study comparisonGroup.", 0, 1, this.observedGroup));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1618432855: {
                    return new Property(ResearchStudy.SP_IDENTIFIER, "Identifier", "Allows the comparisonGroup for the study and the comparisonGroup for the subject to be linked easily.", 0, Integer.MAX_VALUE, this.identifier);
                }
                case 3373707: {
                    return new Property("name", "string", "Unique, human-readable label for this comparisonGroup of the study.", 0, 1, this.name);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Categorization of study comparisonGroup, e.g. experimental, active comparator, placebo comparater.", 0, 1, this.type);
                }
                case -1724546052: {
                    return new Property("description", "markdown", "A succinct description of the path through the study that would be followed by a subject adhering to this comparisonGroup.", 0, 1, this.description);
                }
                case -407218606: {
                    return new Property("intendedExposure", "Reference(EvidenceVariable)", "Interventions or exposures in this comparisonGroup or cohort.", 0, Integer.MAX_VALUE, this.intendedExposure);
                }
                case 375599255: {
                    return new Property("observedGroup", "Reference(Group)", "Group of participants who were enrolled in study comparisonGroup.", 0, 1, this.observedGroup);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.description;
                    }
                    return baseArray;
                }
                case -407218606: {
                    return this.intendedExposure == null ? new Base[]{} : this.intendedExposure.toArray(new Base[this.intendedExposure.size()]);
                }
                case 375599255: {
                    Base[] baseArray;
                    if (this.observedGroup == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.observedGroup;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                    return value;
                }
                case 3373707: {
                    this.name = TypeConvertor.castToString(value);
                    return value;
                }
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case -407218606: {
                    this.getIntendedExposure().add(TypeConvertor.castToReference(value));
                    return value;
                }
                case 375599255: {
                    this.observedGroup = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ResearchStudy.SP_IDENTIFIER)) {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
            } else if (name.equals("name")) {
                this.name = TypeConvertor.castToString(value);
            } else if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("description")) {
                this.description = TypeConvertor.castToMarkdown(value);
            } else if (name.equals("intendedExposure")) {
                this.getIntendedExposure().add(TypeConvertor.castToReference(value));
            } else if (name.equals("observedGroup")) {
                this.observedGroup = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.addIdentifier();
                }
                case 3373707: {
                    return this.getNameElement();
                }
                case 3575610: {
                    return this.getType();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -407218606: {
                    return this.addIntendedExposure();
                }
                case 375599255: {
                    return this.getObservedGroup();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case 3373707: {
                    return new String[]{"string"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1724546052: {
                    return new String[]{"markdown"};
                }
                case -407218606: {
                    return new String[]{"Reference"};
                }
                case 375599255: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ResearchStudy.SP_IDENTIFIER)) {
                return this.addIdentifier();
            }
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a primitive type ResearchStudy.comparisonGroup.name");
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type ResearchStudy.comparisonGroup.description");
            }
            if (name.equals("intendedExposure")) {
                return this.addIntendedExposure();
            }
            if (name.equals("observedGroup")) {
                this.observedGroup = new Reference();
                return this.observedGroup;
            }
            return super.addChild(name);
        }

        @Override
        public ResearchStudyComparisonGroupComponent copy() {
            ResearchStudyComparisonGroupComponent dst = new ResearchStudyComparisonGroupComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ResearchStudyComparisonGroupComponent dst) {
            super.copyValues(dst);
            if (this.identifier != null) {
                dst.identifier = new ArrayList<Identifier>();
                for (Identifier identifier : this.identifier) {
                    dst.identifier.add(identifier.copy());
                }
            }
            dst.name = this.name == null ? null : this.name.copy();
            dst.type = this.type == null ? null : this.type.copy();
            MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
            if (this.intendedExposure != null) {
                dst.intendedExposure = new ArrayList<Reference>();
                for (Reference reference : this.intendedExposure) {
                    dst.intendedExposure.add(reference.copy());
                }
            }
            dst.observedGroup = this.observedGroup == null ? null : this.observedGroup.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ResearchStudyComparisonGroupComponent)) {
                return false;
            }
            ResearchStudyComparisonGroupComponent o = (ResearchStudyComparisonGroupComponent)other_;
            return ResearchStudyComparisonGroupComponent.compareDeep(this.identifier, o.identifier, true) && ResearchStudyComparisonGroupComponent.compareDeep(this.name, o.name, true) && ResearchStudyComparisonGroupComponent.compareDeep(this.type, o.type, true) && ResearchStudyComparisonGroupComponent.compareDeep(this.description, o.description, true) && ResearchStudyComparisonGroupComponent.compareDeep(this.intendedExposure, o.intendedExposure, true) && ResearchStudyComparisonGroupComponent.compareDeep(this.observedGroup, o.observedGroup, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ResearchStudyComparisonGroupComponent)) {
                return false;
            }
            ResearchStudyComparisonGroupComponent o = (ResearchStudyComparisonGroupComponent)other_;
            return ResearchStudyComparisonGroupComponent.compareValues(this.name, o.name, true) && ResearchStudyComparisonGroupComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.name, this.type, this.description, this.intendedExposure, this.observedGroup});
        }

        @Override
        public String fhirType() {
            return "ResearchStudy.comparisonGroup";
        }
    }

    @Block
    public static class ResearchStudyRecruitmentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="targetNumber", type={UnsignedIntType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Estimated total number of participants to be enrolled", formalDefinition="Estimated total number of participants to be enrolled.")
        protected UnsignedIntType targetNumber;
        @Child(name="actualNumber", type={UnsignedIntType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Actual total number of participants enrolled in study", formalDefinition="Actual total number of participants enrolled in study.")
        protected UnsignedIntType actualNumber;
        @Child(name="eligibility", type={Group.class, EvidenceVariable.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Inclusion and exclusion criteria", formalDefinition="Inclusion and exclusion criteria.")
        protected Reference eligibility;
        @Child(name="actualGroup", type={Group.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Group of participants who were enrolled in study", formalDefinition="Group of participants who were enrolled in study.")
        protected Reference actualGroup;
        private static final long serialVersionUID = 1483229827L;

        public UnsignedIntType getTargetNumberElement() {
            if (this.targetNumber == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchStudyRecruitmentComponent.targetNumber");
                }
                if (Configuration.doAutoCreate()) {
                    this.targetNumber = new UnsignedIntType();
                }
            }
            return this.targetNumber;
        }

        public boolean hasTargetNumberElement() {
            return this.targetNumber != null && !this.targetNumber.isEmpty();
        }

        public boolean hasTargetNumber() {
            return this.targetNumber != null && !this.targetNumber.isEmpty();
        }

        public ResearchStudyRecruitmentComponent setTargetNumberElement(UnsignedIntType value) {
            this.targetNumber = value;
            return this;
        }

        public int getTargetNumber() {
            return this.targetNumber == null || this.targetNumber.isEmpty() ? 0 : (Integer)this.targetNumber.getValue();
        }

        public ResearchStudyRecruitmentComponent setTargetNumber(int value) {
            if (this.targetNumber == null) {
                this.targetNumber = new UnsignedIntType();
            }
            this.targetNumber.setValue((Object)value);
            return this;
        }

        public UnsignedIntType getActualNumberElement() {
            if (this.actualNumber == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchStudyRecruitmentComponent.actualNumber");
                }
                if (Configuration.doAutoCreate()) {
                    this.actualNumber = new UnsignedIntType();
                }
            }
            return this.actualNumber;
        }

        public boolean hasActualNumberElement() {
            return this.actualNumber != null && !this.actualNumber.isEmpty();
        }

        public boolean hasActualNumber() {
            return this.actualNumber != null && !this.actualNumber.isEmpty();
        }

        public ResearchStudyRecruitmentComponent setActualNumberElement(UnsignedIntType value) {
            this.actualNumber = value;
            return this;
        }

        public int getActualNumber() {
            return this.actualNumber == null || this.actualNumber.isEmpty() ? 0 : (Integer)this.actualNumber.getValue();
        }

        public ResearchStudyRecruitmentComponent setActualNumber(int value) {
            if (this.actualNumber == null) {
                this.actualNumber = new UnsignedIntType();
            }
            this.actualNumber.setValue((Object)value);
            return this;
        }

        public Reference getEligibility() {
            if (this.eligibility == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchStudyRecruitmentComponent.eligibility");
                }
                if (Configuration.doAutoCreate()) {
                    this.eligibility = new Reference();
                }
            }
            return this.eligibility;
        }

        public boolean hasEligibility() {
            return this.eligibility != null && !this.eligibility.isEmpty();
        }

        public ResearchStudyRecruitmentComponent setEligibility(Reference value) {
            this.eligibility = value;
            return this;
        }

        public Reference getActualGroup() {
            if (this.actualGroup == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchStudyRecruitmentComponent.actualGroup");
                }
                if (Configuration.doAutoCreate()) {
                    this.actualGroup = new Reference();
                }
            }
            return this.actualGroup;
        }

        public boolean hasActualGroup() {
            return this.actualGroup != null && !this.actualGroup.isEmpty();
        }

        public ResearchStudyRecruitmentComponent setActualGroup(Reference value) {
            this.actualGroup = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("targetNumber", "unsignedInt", "Estimated total number of participants to be enrolled.", 0, 1, this.targetNumber));
            children.add(new Property("actualNumber", "unsignedInt", "Actual total number of participants enrolled in study.", 0, 1, this.actualNumber));
            children.add(new Property("eligibility", "Reference(Group|EvidenceVariable)", "Inclusion and exclusion criteria.", 0, 1, this.eligibility));
            children.add(new Property("actualGroup", "Reference(Group)", "Group of participants who were enrolled in study.", 0, 1, this.actualGroup));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -682948550: {
                    return new Property("targetNumber", "unsignedInt", "Estimated total number of participants to be enrolled.", 0, 1, this.targetNumber);
                }
                case 746557047: {
                    return new Property("actualNumber", "unsignedInt", "Actual total number of participants enrolled in study.", 0, 1, this.actualNumber);
                }
                case -930847859: {
                    return new Property("eligibility", "Reference(Group|EvidenceVariable)", "Inclusion and exclusion criteria.", 0, 1, this.eligibility);
                }
                case 1403004305: {
                    return new Property("actualGroup", "Reference(Group)", "Group of participants who were enrolled in study.", 0, 1, this.actualGroup);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -682948550: {
                    Base[] baseArray;
                    if (this.targetNumber == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.targetNumber;
                    }
                    return baseArray;
                }
                case 746557047: {
                    Base[] baseArray;
                    if (this.actualNumber == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.actualNumber;
                    }
                    return baseArray;
                }
                case -930847859: {
                    Base[] baseArray;
                    if (this.eligibility == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.eligibility;
                    }
                    return baseArray;
                }
                case 1403004305: {
                    Base[] baseArray;
                    if (this.actualGroup == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.actualGroup;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -682948550: {
                    this.targetNumber = TypeConvertor.castToUnsignedInt(value);
                    return value;
                }
                case 746557047: {
                    this.actualNumber = TypeConvertor.castToUnsignedInt(value);
                    return value;
                }
                case -930847859: {
                    this.eligibility = TypeConvertor.castToReference(value);
                    return value;
                }
                case 1403004305: {
                    this.actualGroup = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("targetNumber")) {
                this.targetNumber = TypeConvertor.castToUnsignedInt(value);
            } else if (name.equals("actualNumber")) {
                this.actualNumber = TypeConvertor.castToUnsignedInt(value);
            } else if (name.equals("eligibility")) {
                this.eligibility = TypeConvertor.castToReference(value);
            } else if (name.equals("actualGroup")) {
                this.actualGroup = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -682948550: {
                    return this.getTargetNumberElement();
                }
                case 746557047: {
                    return this.getActualNumberElement();
                }
                case -930847859: {
                    return this.getEligibility();
                }
                case 1403004305: {
                    return this.getActualGroup();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -682948550: {
                    return new String[]{"unsignedInt"};
                }
                case 746557047: {
                    return new String[]{"unsignedInt"};
                }
                case -930847859: {
                    return new String[]{"Reference"};
                }
                case 1403004305: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("targetNumber")) {
                throw new FHIRException("Cannot call addChild on a primitive type ResearchStudy.recruitment.targetNumber");
            }
            if (name.equals("actualNumber")) {
                throw new FHIRException("Cannot call addChild on a primitive type ResearchStudy.recruitment.actualNumber");
            }
            if (name.equals("eligibility")) {
                this.eligibility = new Reference();
                return this.eligibility;
            }
            if (name.equals("actualGroup")) {
                this.actualGroup = new Reference();
                return this.actualGroup;
            }
            return super.addChild(name);
        }

        @Override
        public ResearchStudyRecruitmentComponent copy() {
            ResearchStudyRecruitmentComponent dst = new ResearchStudyRecruitmentComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ResearchStudyRecruitmentComponent dst) {
            super.copyValues(dst);
            dst.targetNumber = this.targetNumber == null ? null : this.targetNumber.copy();
            dst.actualNumber = this.actualNumber == null ? null : this.actualNumber.copy();
            dst.eligibility = this.eligibility == null ? null : this.eligibility.copy();
            dst.actualGroup = this.actualGroup == null ? null : this.actualGroup.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ResearchStudyRecruitmentComponent)) {
                return false;
            }
            ResearchStudyRecruitmentComponent o = (ResearchStudyRecruitmentComponent)other_;
            return ResearchStudyRecruitmentComponent.compareDeep(this.targetNumber, o.targetNumber, true) && ResearchStudyRecruitmentComponent.compareDeep(this.actualNumber, o.actualNumber, true) && ResearchStudyRecruitmentComponent.compareDeep(this.eligibility, o.eligibility, true) && ResearchStudyRecruitmentComponent.compareDeep(this.actualGroup, o.actualGroup, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ResearchStudyRecruitmentComponent)) {
                return false;
            }
            ResearchStudyRecruitmentComponent o = (ResearchStudyRecruitmentComponent)other_;
            return ResearchStudyRecruitmentComponent.compareValues(this.targetNumber, o.targetNumber, true) && ResearchStudyRecruitmentComponent.compareValues(this.actualNumber, o.actualNumber, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.targetNumber, this.actualNumber, this.eligibility, this.actualGroup});
        }

        @Override
        public String fhirType() {
            return "ResearchStudy.recruitment";
        }
    }

    @Block
    public static class ResearchStudyProgressStatusComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="state", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Label for status or state (e.g. recruitment status)", formalDefinition="Label for status or state (e.g. recruitment status).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/research-study-status")
        protected CodeableConcept state;
        @Child(name="actual", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Actual if true else anticipated", formalDefinition="An indication of whether or not the date is a known date when the state changed or will change. A value of true indicates a known date. A value of false indicates an estimated date.")
        protected BooleanType actual;
        @Child(name="period", type={Period.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Date range", formalDefinition="Date range.")
        protected Period period;
        private static final long serialVersionUID = 1232680620L;

        public ResearchStudyProgressStatusComponent() {
        }

        public ResearchStudyProgressStatusComponent(CodeableConcept state) {
            this.setState(state);
        }

        public CodeableConcept getState() {
            if (this.state == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchStudyProgressStatusComponent.state");
                }
                if (Configuration.doAutoCreate()) {
                    this.state = new CodeableConcept();
                }
            }
            return this.state;
        }

        public boolean hasState() {
            return this.state != null && !this.state.isEmpty();
        }

        public ResearchStudyProgressStatusComponent setState(CodeableConcept value) {
            this.state = value;
            return this;
        }

        public BooleanType getActualElement() {
            if (this.actual == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchStudyProgressStatusComponent.actual");
                }
                if (Configuration.doAutoCreate()) {
                    this.actual = new BooleanType();
                }
            }
            return this.actual;
        }

        public boolean hasActualElement() {
            return this.actual != null && !this.actual.isEmpty();
        }

        public boolean hasActual() {
            return this.actual != null && !this.actual.isEmpty();
        }

        public ResearchStudyProgressStatusComponent setActualElement(BooleanType value) {
            this.actual = value;
            return this;
        }

        public boolean getActual() {
            return this.actual == null || this.actual.isEmpty() ? false : (Boolean)this.actual.getValue();
        }

        public ResearchStudyProgressStatusComponent setActual(boolean value) {
            if (this.actual == null) {
                this.actual = new BooleanType();
            }
            this.actual.setValue((Object)value);
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchStudyProgressStatusComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public ResearchStudyProgressStatusComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("state", "CodeableConcept", "Label for status or state (e.g. recruitment status).", 0, 1, this.state));
            children.add(new Property("actual", "boolean", "An indication of whether or not the date is a known date when the state changed or will change. A value of true indicates a known date. A value of false indicates an estimated date.", 0, 1, this.actual));
            children.add(new Property("period", "Period", "Date range.", 0, 1, this.period));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 109757585: {
                    return new Property("state", "CodeableConcept", "Label for status or state (e.g. recruitment status).", 0, 1, this.state);
                }
                case -1422939762: {
                    return new Property("actual", "boolean", "An indication of whether or not the date is a known date when the state changed or will change. A value of true indicates a known date. A value of false indicates an estimated date.", 0, 1, this.actual);
                }
                case -991726143: {
                    return new Property("period", "Period", "Date range.", 0, 1, this.period);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 109757585: {
                    Base[] baseArray;
                    if (this.state == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.state;
                    }
                    return baseArray;
                }
                case -1422939762: {
                    Base[] baseArray;
                    if (this.actual == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.actual;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.period;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 109757585: {
                    this.state = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1422939762: {
                    this.actual = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -991726143: {
                    this.period = TypeConvertor.castToPeriod(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("state")) {
                this.state = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("actual")) {
                this.actual = TypeConvertor.castToBoolean(value);
            } else if (name.equals("period")) {
                this.period = TypeConvertor.castToPeriod(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 109757585: {
                    return this.getState();
                }
                case -1422939762: {
                    return this.getActualElement();
                }
                case -991726143: {
                    return this.getPeriod();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 109757585: {
                    return new String[]{"CodeableConcept"};
                }
                case -1422939762: {
                    return new String[]{"boolean"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("state")) {
                this.state = new CodeableConcept();
                return this.state;
            }
            if (name.equals("actual")) {
                throw new FHIRException("Cannot call addChild on a primitive type ResearchStudy.progressStatus.actual");
            }
            if (name.equals("period")) {
                this.period = new Period();
                return this.period;
            }
            return super.addChild(name);
        }

        @Override
        public ResearchStudyProgressStatusComponent copy() {
            ResearchStudyProgressStatusComponent dst = new ResearchStudyProgressStatusComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ResearchStudyProgressStatusComponent dst) {
            super.copyValues(dst);
            dst.state = this.state == null ? null : this.state.copy();
            dst.actual = this.actual == null ? null : this.actual.copy();
            dst.period = this.period == null ? null : this.period.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ResearchStudyProgressStatusComponent)) {
                return false;
            }
            ResearchStudyProgressStatusComponent o = (ResearchStudyProgressStatusComponent)other_;
            return ResearchStudyProgressStatusComponent.compareDeep(this.state, o.state, true) && ResearchStudyProgressStatusComponent.compareDeep(this.actual, o.actual, true) && ResearchStudyProgressStatusComponent.compareDeep(this.period, o.period, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ResearchStudyProgressStatusComponent)) {
                return false;
            }
            ResearchStudyProgressStatusComponent o = (ResearchStudyProgressStatusComponent)other_;
            return ResearchStudyProgressStatusComponent.compareValues(this.actual, o.actual, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.state, this.actual, this.period});
        }

        @Override
        public String fhirType() {
            return "ResearchStudy.progressStatus";
        }
    }

    @Block
    public static class ResearchStudyAssociatedPartyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Name of associated party", formalDefinition="Name of associated party.")
        protected StringType name;
        @Child(name="role", type={CodeableConcept.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="sponsor | lead-sponsor | sponsor-investigator | primary-investigator | collaborator | funding-source | general-contact | recruitment-contact | sub-investigator | study-director | study-chair", formalDefinition="Type of association.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/research-study-party-role")
        protected CodeableConcept role;
        @Child(name="period", type={Period.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="When active in the role", formalDefinition="Identifies the start date and the end date of the associated party in the role.")
        protected List<Period> period;
        @Child(name="classifier", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="nih | fda | government | nonprofit | academic | industry", formalDefinition="A categorization other than role for the associated party.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/research-study-party-org-type")
        protected List<CodeableConcept> classifier;
        @Child(name="party", type={Practitioner.class, PractitionerRole.class, Organization.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Individual or organization associated with study (use practitionerRole to specify their organisation)", formalDefinition="Individual or organization associated with study (use practitionerRole to specify their organisation).")
        protected Reference party;
        private static final long serialVersionUID = -1418550998L;

        public ResearchStudyAssociatedPartyComponent() {
        }

        public ResearchStudyAssociatedPartyComponent(CodeableConcept role) {
            this.setRole(role);
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchStudyAssociatedPartyComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ResearchStudyAssociatedPartyComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ResearchStudyAssociatedPartyComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public CodeableConcept getRole() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchStudyAssociatedPartyComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new CodeableConcept();
                }
            }
            return this.role;
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public ResearchStudyAssociatedPartyComponent setRole(CodeableConcept value) {
            this.role = value;
            return this;
        }

        public List<Period> getPeriod() {
            if (this.period == null) {
                this.period = new ArrayList<Period>();
            }
            return this.period;
        }

        public ResearchStudyAssociatedPartyComponent setPeriod(List<Period> thePeriod) {
            this.period = thePeriod;
            return this;
        }

        public boolean hasPeriod() {
            if (this.period == null) {
                return false;
            }
            for (Period item : this.period) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Period addPeriod() {
            Period t = new Period();
            if (this.period == null) {
                this.period = new ArrayList<Period>();
            }
            this.period.add(t);
            return t;
        }

        public ResearchStudyAssociatedPartyComponent addPeriod(Period t) {
            if (t == null) {
                return this;
            }
            if (this.period == null) {
                this.period = new ArrayList<Period>();
            }
            this.period.add(t);
            return this;
        }

        public Period getPeriodFirstRep() {
            if (this.getPeriod().isEmpty()) {
                this.addPeriod();
            }
            return this.getPeriod().get(0);
        }

        public List<CodeableConcept> getClassifier() {
            if (this.classifier == null) {
                this.classifier = new ArrayList<CodeableConcept>();
            }
            return this.classifier;
        }

        public ResearchStudyAssociatedPartyComponent setClassifier(List<CodeableConcept> theClassifier) {
            this.classifier = theClassifier;
            return this;
        }

        public boolean hasClassifier() {
            if (this.classifier == null) {
                return false;
            }
            for (CodeableConcept item : this.classifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addClassifier() {
            CodeableConcept t = new CodeableConcept();
            if (this.classifier == null) {
                this.classifier = new ArrayList<CodeableConcept>();
            }
            this.classifier.add(t);
            return t;
        }

        public ResearchStudyAssociatedPartyComponent addClassifier(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.classifier == null) {
                this.classifier = new ArrayList<CodeableConcept>();
            }
            this.classifier.add(t);
            return this;
        }

        public CodeableConcept getClassifierFirstRep() {
            if (this.getClassifier().isEmpty()) {
                this.addClassifier();
            }
            return this.getClassifier().get(0);
        }

        public Reference getParty() {
            if (this.party == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchStudyAssociatedPartyComponent.party");
                }
                if (Configuration.doAutoCreate()) {
                    this.party = new Reference();
                }
            }
            return this.party;
        }

        public boolean hasParty() {
            return this.party != null && !this.party.isEmpty();
        }

        public ResearchStudyAssociatedPartyComponent setParty(Reference value) {
            this.party = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("name", "string", "Name of associated party.", 0, 1, this.name));
            children.add(new Property("role", "CodeableConcept", "Type of association.", 0, 1, this.role));
            children.add(new Property("period", "Period", "Identifies the start date and the end date of the associated party in the role.", 0, Integer.MAX_VALUE, this.period));
            children.add(new Property("classifier", "CodeableConcept", "A categorization other than role for the associated party.", 0, Integer.MAX_VALUE, this.classifier));
            children.add(new Property("party", "Reference(Practitioner|PractitionerRole|Organization)", "Individual or organization associated with study (use practitionerRole to specify their organisation).", 0, 1, this.party));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property("name", "string", "Name of associated party.", 0, 1, this.name);
                }
                case 3506294: {
                    return new Property("role", "CodeableConcept", "Type of association.", 0, 1, this.role);
                }
                case -991726143: {
                    return new Property("period", "Period", "Identifies the start date and the end date of the associated party in the role.", 0, Integer.MAX_VALUE, this.period);
                }
                case -281470431: {
                    return new Property("classifier", "CodeableConcept", "A categorization other than role for the associated party.", 0, Integer.MAX_VALUE, this.classifier);
                }
                case 106437350: {
                    return new Property("party", "Reference(Practitioner|PractitionerRole|Organization)", "Individual or organization associated with study (use practitionerRole to specify their organisation).", 0, 1, this.party);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.role;
                    }
                    return baseArray;
                }
                case -991726143: {
                    return this.period == null ? new Base[]{} : this.period.toArray(new Base[this.period.size()]);
                }
                case -281470431: {
                    return this.classifier == null ? new Base[]{} : this.classifier.toArray(new Base[this.classifier.size()]);
                }
                case 106437350: {
                    Base[] baseArray;
                    if (this.party == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.party;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = TypeConvertor.castToString(value);
                    return value;
                }
                case 3506294: {
                    this.role = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -991726143: {
                    this.getPeriod().add(TypeConvertor.castToPeriod(value));
                    return value;
                }
                case -281470431: {
                    this.getClassifier().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 106437350: {
                    this.party = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = TypeConvertor.castToString(value);
            } else if (name.equals("role")) {
                this.role = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("period")) {
                this.getPeriod().add(TypeConvertor.castToPeriod(value));
            } else if (name.equals("classifier")) {
                this.getClassifier().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("party")) {
                this.party = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case 3506294: {
                    return this.getRole();
                }
                case -991726143: {
                    return this.addPeriod();
                }
                case -281470431: {
                    return this.addClassifier();
                }
                case 106437350: {
                    return this.getParty();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"string"};
                }
                case 3506294: {
                    return new String[]{"CodeableConcept"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
                case -281470431: {
                    return new String[]{"CodeableConcept"};
                }
                case 106437350: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a primitive type ResearchStudy.associatedParty.name");
            }
            if (name.equals("role")) {
                this.role = new CodeableConcept();
                return this.role;
            }
            if (name.equals("period")) {
                return this.addPeriod();
            }
            if (name.equals("classifier")) {
                return this.addClassifier();
            }
            if (name.equals("party")) {
                this.party = new Reference();
                return this.party;
            }
            return super.addChild(name);
        }

        @Override
        public ResearchStudyAssociatedPartyComponent copy() {
            ResearchStudyAssociatedPartyComponent dst = new ResearchStudyAssociatedPartyComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ResearchStudyAssociatedPartyComponent dst) {
            super.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            CodeableConcept codeableConcept = dst.role = this.role == null ? null : this.role.copy();
            if (this.period != null) {
                dst.period = new ArrayList<Period>();
                for (Period period : this.period) {
                    dst.period.add(period.copy());
                }
            }
            if (this.classifier != null) {
                dst.classifier = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.classifier) {
                    dst.classifier.add(codeableConcept2.copy());
                }
            }
            dst.party = this.party == null ? null : this.party.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ResearchStudyAssociatedPartyComponent)) {
                return false;
            }
            ResearchStudyAssociatedPartyComponent o = (ResearchStudyAssociatedPartyComponent)other_;
            return ResearchStudyAssociatedPartyComponent.compareDeep(this.name, o.name, true) && ResearchStudyAssociatedPartyComponent.compareDeep(this.role, o.role, true) && ResearchStudyAssociatedPartyComponent.compareDeep(this.period, o.period, true) && ResearchStudyAssociatedPartyComponent.compareDeep(this.classifier, o.classifier, true) && ResearchStudyAssociatedPartyComponent.compareDeep(this.party, o.party, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ResearchStudyAssociatedPartyComponent)) {
                return false;
            }
            ResearchStudyAssociatedPartyComponent o = (ResearchStudyAssociatedPartyComponent)other_;
            return ResearchStudyAssociatedPartyComponent.compareValues(this.name, o.name, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.name, this.role, this.period, this.classifier, this.party});
        }

        @Override
        public String fhirType() {
            return "ResearchStudy.associatedParty";
        }
    }

    @Block
    public static class ResearchStudyLabelComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="primary | official | scientific | plain-language | subtitle | short-title | acronym | earlier-title | language | auto-translated | human-use | machine-use | duplicate-uid", formalDefinition="Kind of name.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/title-type")
        protected CodeableConcept type;
        @Child(name="value", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The name", formalDefinition="The name.")
        protected StringType value;
        private static final long serialVersionUID = 944223389L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchStudyLabelComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ResearchStudyLabelComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public StringType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchStudyLabelComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new StringType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ResearchStudyLabelComponent setValueElement(StringType value) {
            this.value = value;
            return this;
        }

        public String getValue() {
            return this.value == null ? null : (String)this.value.getValue();
        }

        public ResearchStudyLabelComponent setValue(String value) {
            if (Utilities.noString((String)value)) {
                this.value = null;
            } else {
                if (this.value == null) {
                    this.value = new StringType();
                }
                this.value.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Kind of name.", 0, 1, this.type));
            children.add(new Property("value", "string", "The name.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Kind of name.", 0, 1, this.type);
                }
                case 111972721: {
                    return new Property("value", "string", "The name.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value")) {
                this.value = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 111972721: {
                    return this.getValueElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type ResearchStudy.label.value");
            }
            return super.addChild(name);
        }

        @Override
        public ResearchStudyLabelComponent copy() {
            ResearchStudyLabelComponent dst = new ResearchStudyLabelComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ResearchStudyLabelComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ResearchStudyLabelComponent)) {
                return false;
            }
            ResearchStudyLabelComponent o = (ResearchStudyLabelComponent)other_;
            return ResearchStudyLabelComponent.compareDeep(this.type, o.type, true) && ResearchStudyLabelComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ResearchStudyLabelComponent)) {
                return false;
            }
            ResearchStudyLabelComponent o = (ResearchStudyLabelComponent)other_;
            return ResearchStudyLabelComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.value});
        }

        @Override
        public String fhirType() {
            return "ResearchStudy.label";
        }
    }
}

