/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="SubscriptionTopic", profile="http://hl7.org/fhir/StructureDefinition/SubscriptionTopic")
public class SubscriptionTopic
extends CanonicalResource {
    @Child(name="url", type={UriType.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Canonical identifier for this subscription topic definition, represented as a URI (globally unique)", formalDefinition="An absolute URI that is used to identify this subscription topic when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which an authoritative instance of this subscription topic is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the subscription topic is stored on different servers.")
    protected UriType url;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business Identifier for this subscription topic", formalDefinition="Business identifiers assigned to this subscription topic by the performer and/or other systems.  These identifiers remain constant as the resource is updated and propagates from server to server.")
    protected List<Identifier> identifier;
    @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business version of the subscription topic", formalDefinition="The identifier that is used to identify this version of the subscription topic when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the Topic author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions are orderable.")
    protected StringType version;
    @Child(name="title", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this subscription topic (Human friendly)", formalDefinition="A short, descriptive, user-friendly title for the SubscriptionTopic, for example, \"admission\".")
    protected StringType title;
    @Child(name="derivedFrom", type={CanonicalType.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Based on FHIR protocol or definition", formalDefinition="The canonical URL pointing to another FHIR-defined SubscriptionTopic that is adhered to in whole or in part by this SubscriptionTopic.")
    protected List<CanonicalType> derivedFrom;
    @Child(name="status", type={CodeType.class}, order=5, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired | unknown", formalDefinition="The current state of the SubscriptionTopic.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected Enumeration<Enumerations.PublicationStatus> status;
    @Child(name="experimental", type={BooleanType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If for testing purposes, not real usage", formalDefinition="A flag to indicate that this TopSubscriptionTopicic is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.")
    protected BooleanType experimental;
    @Child(name="date", type={DateTimeType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date status first applied", formalDefinition="For draft definitions, indicates the date of initial creation.  For active definitions, represents the date of activation.  For withdrawn definitions, indicates the date of withdrawal.")
    protected DateTimeType date;
    @Child(name="publisher", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The name of the individual or organization that published the SubscriptionTopic", formalDefinition="Helps establish the \"authority/credibility\" of the SubscriptionTopic.  May also allow for contact.")
    protected StringType publisher;
    @Child(name="contact", type={ContactDetail.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details for the publisher", formalDefinition="Contact details to assist a user in finding and communicating with the publisher.")
    protected List<ContactDetail> contact;
    @Child(name="description", type={MarkdownType.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Natural language description of the SubscriptionTopic", formalDefinition="A free text natural language description of the Topic from the consumer's perspective.")
    protected MarkdownType description;
    @Child(name="useContext", type={UsageContext.class}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Content intends to support these contexts", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching of code system definitions.")
    protected List<UsageContext> useContext;
    @Child(name="jurisdiction", type={CodeableConcept.class}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Intended jurisdiction of the SubscriptionTopic (if applicable)", formalDefinition="A jurisdiction in which the Topic is intended to be used.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    protected List<CodeableConcept> jurisdiction;
    @Child(name="purpose", type={MarkdownType.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why this SubscriptionTopic is defined", formalDefinition="Explains why this Topic is needed and why it has been designed as it has.")
    protected MarkdownType purpose;
    @Child(name="copyright", type={MarkdownType.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the SubscriptionTopic and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the SubscriptionTopic.")
    protected MarkdownType copyright;
    @Child(name="copyrightLabel", type={StringType.class}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Copyright holder and year(s)", formalDefinition="A short string (<50 characters), suitable for inclusion in a page footer that identifies the copyright holder, effective period, and optionally whether rights are resctricted. (e.g. 'All rights reserved', 'Some rights reserved').")
    protected StringType copyrightLabel;
    @Child(name="approvalDate", type={DateType.class}, order=16, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When SubscriptionTopic is/was approved by publisher", formalDefinition="The date on which the asset content was approved by the publisher. Approval happens once when the content is officially approved for usage.")
    protected DateType approvalDate;
    @Child(name="lastReviewDate", type={DateType.class}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Date the Subscription Topic was last reviewed by the publisher", formalDefinition="The date on which the asset content was last reviewed. Review happens periodically after that, but doesn't change the original approval date.")
    protected DateType lastReviewDate;
    @Child(name="effectivePeriod", type={Period.class}, order=18, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The effective date range for the SubscriptionTopic", formalDefinition="The period during which the SubscriptionTopic content was or is planned to be effective.")
    protected Period effectivePeriod;
    @Child(name="resourceTrigger", type={}, order=19, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Definition of a resource-based trigger for the subscription topic", formalDefinition="A definition of a resource-based event that triggers a notification based on the SubscriptionTopic. The criteria may be just a human readable description and/or a full FHIR search string or FHIRPath expression. Multiple triggers are considered OR joined (e.g., a resource update matching ANY of the definitions will trigger a notification).")
    protected List<SubscriptionTopicResourceTriggerComponent> resourceTrigger;
    @Child(name="eventTrigger", type={}, order=20, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Event definitions the SubscriptionTopic", formalDefinition="Event definition which can be used to trigger the SubscriptionTopic.")
    protected List<SubscriptionTopicEventTriggerComponent> eventTrigger;
    @Child(name="canFilterBy", type={}, order=21, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Properties by which a Subscription can filter notifications from the SubscriptionTopic", formalDefinition="List of properties by which Subscriptions on the SubscriptionTopic can be filtered. May be defined Search Parameters (e.g., Encounter.patient) or parameters defined within this SubscriptionTopic context (e.g., hub.event).")
    protected List<SubscriptionTopicCanFilterByComponent> canFilterBy;
    @Child(name="notificationShape", type={}, order=22, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Properties for describing the shape of notifications generated by this topic", formalDefinition="List of properties to describe the shape (e.g., resources) included in notifications from this Subscription Topic.")
    protected List<SubscriptionTopicNotificationShapeComponent> notificationShape;
    private static final long serialVersionUID = -117076104L;
    @SearchParamDefinition(name="date", path="ActivityDefinition.date | ActorDefinition.date | CapabilityStatement.date | ChargeItemDefinition.date | Citation.date | CodeSystem.date | CompartmentDefinition.date | ConceptMap.date | ConditionDefinition.date | EventDefinition.date | Evidence.date | EvidenceVariable.date | ExampleScenario.date | GraphDefinition.date | ImplementationGuide.date | Library.date | Measure.date | MessageDefinition.date | NamingSystem.date | OperationDefinition.date | PlanDefinition.date | Questionnaire.date | Requirements.date | SearchParameter.date | StructureDefinition.date | StructureMap.date | SubscriptionTopic.date | TerminologyCapabilities.date | TestScript.date | ValueSet.date", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The activity definition publication date\r\n* [ActorDefinition](actordefinition.html): The Actor Definition publication date\r\n* [CapabilityStatement](capabilitystatement.html): The capability statement publication date\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The charge item definition publication date\r\n* [Citation](citation.html): The citation publication date\r\n* [CodeSystem](codesystem.html): The code system publication date\r\n* [CompartmentDefinition](compartmentdefinition.html): The compartment definition publication date\r\n* [ConceptMap](conceptmap.html): The concept map publication date\r\n* [ConditionDefinition](conditiondefinition.html): The condition definition publication date\r\n* [EventDefinition](eventdefinition.html): The event definition publication date\r\n* [Evidence](evidence.html): The evidence publication date\r\n* [EvidenceVariable](evidencevariable.html): The evidence variable publication date\r\n* [ExampleScenario](examplescenario.html): The example scenario publication date\r\n* [GraphDefinition](graphdefinition.html): The graph definition publication date\r\n* [ImplementationGuide](implementationguide.html): The implementation guide publication date\r\n* [Library](library.html): The library publication date\r\n* [Measure](measure.html): The measure publication date\r\n* [MessageDefinition](messagedefinition.html): The message definition publication date\r\n* [NamingSystem](namingsystem.html): The naming system publication date\r\n* [OperationDefinition](operationdefinition.html): The operation definition publication date\r\n* [PlanDefinition](plandefinition.html): The plan definition publication date\r\n* [Questionnaire](questionnaire.html): The questionnaire publication date\r\n* [Requirements](requirements.html): The requirements publication date\r\n* [SearchParameter](searchparameter.html): The search parameter publication date\r\n* [StructureDefinition](structuredefinition.html): The structure definition publication date\r\n* [StructureMap](structuremap.html): The structure map publication date\r\n* [SubscriptionTopic](subscriptiontopic.html): Date status first applied\r\n* [TerminologyCapabilities](terminologycapabilities.html): The terminology capabilities publication date\r\n* [TestScript](testscript.html): The test script publication date\r\n* [ValueSet](valueset.html): The value set publication date\r\n", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="ActivityDefinition.identifier | ActorDefinition.identifier | ChargeItemDefinition.identifier | Citation.identifier | CodeSystem.identifier | ConceptMap.identifier | ConditionDefinition.identifier | EventDefinition.identifier | Evidence.identifier | EvidenceReport.identifier | EvidenceVariable.identifier | ExampleScenario.identifier | Library.identifier | Measure.identifier | MedicationKnowledge.identifier | MessageDefinition.identifier | NamingSystem.identifier | ObservationDefinition.identifier | PlanDefinition.identifier | Questionnaire.identifier | Requirements.identifier | SpecimenDefinition.identifier | StructureDefinition.identifier | StructureMap.identifier | SubscriptionTopic.identifier | TerminologyCapabilities.identifier | TestScript.identifier | ValueSet.identifier", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): External identifier for the activity definition\r\n* [ActorDefinition](actordefinition.html): External identifier for the Actor Definition\r\n* [ChargeItemDefinition](chargeitemdefinition.html): External identifier for the charge item definition\r\n* [Citation](citation.html): External identifier for the citation\r\n* [CodeSystem](codesystem.html): External identifier for the code system\r\n* [ConceptMap](conceptmap.html): External identifier for the concept map\r\n* [ConditionDefinition](conditiondefinition.html): External identifier for the condition definition\r\n* [EventDefinition](eventdefinition.html): External identifier for the event definition\r\n* [Evidence](evidence.html): External identifier for the evidence\r\n* [EvidenceReport](evidencereport.html): External identifier for the evidence report\r\n* [EvidenceVariable](evidencevariable.html): External identifier for the evidence variable\r\n* [ExampleScenario](examplescenario.html): External identifier for the example scenario\r\n* [Library](library.html): External identifier for the library\r\n* [Measure](measure.html): External identifier for the measure\r\n* [MedicationKnowledge](medicationknowledge.html): Business identifier for this medication\r\n* [MessageDefinition](messagedefinition.html): External identifier for the message definition\r\n* [NamingSystem](namingsystem.html): External identifier for the naming system\r\n* [ObservationDefinition](observationdefinition.html): The unique identifier associated with the specimen definition\r\n* [PlanDefinition](plandefinition.html): External identifier for the plan definition\r\n* [Questionnaire](questionnaire.html): External identifier for the questionnaire\r\n* [Requirements](requirements.html): External identifier for the requirements\r\n* [SpecimenDefinition](specimendefinition.html): The unique identifier associated with the SpecimenDefinition\r\n* [StructureDefinition](structuredefinition.html): External identifier for the structure definition\r\n* [StructureMap](structuremap.html): External identifier for the structure map\r\n* [SubscriptionTopic](subscriptiontopic.html): Business Identifier for SubscriptionTopic\r\n* [TerminologyCapabilities](terminologycapabilities.html): External identifier for the terminology capabilities\r\n* [TestScript](testscript.html): External identifier for the test script\r\n* [ValueSet](valueset.html): External identifier for the value set\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="status", path="ActivityDefinition.status | ActorDefinition.status | CapabilityStatement.status | ChargeItemDefinition.status | Citation.status | CodeSystem.status | CompartmentDefinition.status | ConceptMap.status | ConditionDefinition.status | EventDefinition.status | Evidence.status | EvidenceReport.status | EvidenceVariable.status | ExampleScenario.status | GraphDefinition.status | ImplementationGuide.status | Library.status | Measure.status | MedicationKnowledge.status | MessageDefinition.status | NamingSystem.status | ObservationDefinition.status | OperationDefinition.status | PlanDefinition.status | Questionnaire.status | Requirements.status | SearchParameter.status | SpecimenDefinition.status | StructureDefinition.status | StructureMap.status | SubscriptionTopic.status | TerminologyCapabilities.status | TestScript.status | ValueSet.status", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The current status of the activity definition\r\n* [ActorDefinition](actordefinition.html): The current status of the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): The current status of the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The current status of the charge item definition\r\n* [Citation](citation.html): The current status of the citation\r\n* [CodeSystem](codesystem.html): The current status of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The current status of the compartment definition\r\n* [ConceptMap](conceptmap.html): The current status of the concept map\r\n* [ConditionDefinition](conditiondefinition.html): The current status of the condition definition\r\n* [EventDefinition](eventdefinition.html): The current status of the event definition\r\n* [Evidence](evidence.html): The current status of the evidence\r\n* [EvidenceReport](evidencereport.html): The current status of the evidence report\r\n* [EvidenceVariable](evidencevariable.html): The current status of the evidence variable\r\n* [ExampleScenario](examplescenario.html): The current status of the example scenario\r\n* [GraphDefinition](graphdefinition.html): The current status of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The current status of the implementation guide\r\n* [Library](library.html): The current status of the library\r\n* [Measure](measure.html): The current status of the measure\r\n* [MedicationKnowledge](medicationknowledge.html): active | inactive | entered-in-error\r\n* [MessageDefinition](messagedefinition.html): The current status of the message definition\r\n* [NamingSystem](namingsystem.html): The current status of the naming system\r\n* [ObservationDefinition](observationdefinition.html): Publication status of the ObservationDefinition: draft, active, retired, unknown\r\n* [OperationDefinition](operationdefinition.html): The current status of the operation definition\r\n* [PlanDefinition](plandefinition.html): The current status of the plan definition\r\n* [Questionnaire](questionnaire.html): The current status of the questionnaire\r\n* [Requirements](requirements.html): The current status of the requirements\r\n* [SearchParameter](searchparameter.html): The current status of the search parameter\r\n* [SpecimenDefinition](specimendefinition.html): Publication status of the SpecimenDefinition: draft, active, retired, unknown\r\n* [StructureDefinition](structuredefinition.html): The current status of the structure definition\r\n* [StructureMap](structuremap.html): The current status of the structure map\r\n* [SubscriptionTopic](subscriptiontopic.html): draft | active | retired | unknown\r\n* [TerminologyCapabilities](terminologycapabilities.html): The current status of the terminology capabilities\r\n* [TestScript](testscript.html): The current status of the test script\r\n* [ValueSet](valueset.html): The current status of the value set\r\n", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="title", path="ActivityDefinition.title | ActorDefinition.title | CapabilityStatement.title | ChargeItemDefinition.title | Citation.title | CodeSystem.title | ConceptMap.title | ConditionDefinition.title | EventDefinition.title | Evidence.title | EvidenceVariable.title | ImplementationGuide.title | Library.title | Measure.title | MessageDefinition.title | ObservationDefinition.title | OperationDefinition.title | PlanDefinition.title | Questionnaire.title | Requirements.title | SpecimenDefinition.title | StructureDefinition.title | StructureMap.title | SubscriptionTopic.title | TerminologyCapabilities.title | TestScript.title | ValueSet.title", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The human-friendly name of the activity definition\r\n* [ActorDefinition](actordefinition.html): The human-friendly name of the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): The human-friendly name of the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The human-friendly name of the charge item definition\r\n* [Citation](citation.html): The human-friendly name of the citation\r\n* [CodeSystem](codesystem.html): The human-friendly name of the code system\r\n* [ConceptMap](conceptmap.html): The human-friendly name of the concept map\r\n* [ConditionDefinition](conditiondefinition.html): The human-friendly name of the condition definition\r\n* [EventDefinition](eventdefinition.html): The human-friendly name of the event definition\r\n* [Evidence](evidence.html): The human-friendly name of the evidence\r\n* [EvidenceVariable](evidencevariable.html): The human-friendly name of the evidence variable\r\n* [ImplementationGuide](implementationguide.html): The human-friendly name of the implementation guide\r\n* [Library](library.html): The human-friendly name of the library\r\n* [Measure](measure.html): The human-friendly name of the measure\r\n* [MessageDefinition](messagedefinition.html): The human-friendly name of the message definition\r\n* [ObservationDefinition](observationdefinition.html): Human-friendly name of the ObservationDefinition\r\n* [OperationDefinition](operationdefinition.html): The human-friendly name of the operation definition\r\n* [PlanDefinition](plandefinition.html): The human-friendly name of the plan definition\r\n* [Questionnaire](questionnaire.html): The human-friendly name of the questionnaire\r\n* [Requirements](requirements.html): The human-friendly name of the requirements\r\n* [SpecimenDefinition](specimendefinition.html): Human-friendly name of the SpecimenDefinition\r\n* [StructureDefinition](structuredefinition.html): The human-friendly name of the structure definition\r\n* [StructureMap](structuremap.html): The human-friendly name of the structure map\r\n* [SubscriptionTopic](subscriptiontopic.html): Name for this SubscriptionTopic (Human friendly)\r\n* [TerminologyCapabilities](terminologycapabilities.html): The human-friendly name of the terminology capabilities\r\n* [TestScript](testscript.html): The human-friendly name of the test script\r\n* [ValueSet](valueset.html): The human-friendly name of the value set\r\n", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="url", path="ActivityDefinition.url | ActorDefinition.url | CapabilityStatement.url | ChargeItemDefinition.url | Citation.url | CodeSystem.url | CompartmentDefinition.url | ConceptMap.url | ConditionDefinition.url | EventDefinition.url | Evidence.url | EvidenceReport.url | EvidenceVariable.url | ExampleScenario.url | GraphDefinition.url | ImplementationGuide.url | Library.url | Measure.url | MessageDefinition.url | NamingSystem.url | ObservationDefinition.url | OperationDefinition.url | PlanDefinition.url | Questionnaire.url | Requirements.url | SearchParameter.url | SpecimenDefinition.url | StructureDefinition.url | StructureMap.url | SubscriptionTopic.url | TerminologyCapabilities.url | TestScript.url | ValueSet.url", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The uri that identifies the activity definition\r\n* [ActorDefinition](actordefinition.html): The uri that identifies the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): The uri that identifies the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The uri that identifies the charge item definition\r\n* [Citation](citation.html): The uri that identifies the citation\r\n* [CodeSystem](codesystem.html): The uri that identifies the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The uri that identifies the compartment definition\r\n* [ConceptMap](conceptmap.html): The URI that identifies the concept map\r\n* [ConditionDefinition](conditiondefinition.html): The uri that identifies the condition definition\r\n* [EventDefinition](eventdefinition.html): The uri that identifies the event definition\r\n* [Evidence](evidence.html): The uri that identifies the evidence\r\n* [EvidenceReport](evidencereport.html): The uri that identifies the evidence report\r\n* [EvidenceVariable](evidencevariable.html): The uri that identifies the evidence variable\r\n* [ExampleScenario](examplescenario.html): The uri that identifies the example scenario\r\n* [GraphDefinition](graphdefinition.html): The uri that identifies the graph definition\r\n* [ImplementationGuide](implementationguide.html): The uri that identifies the implementation guide\r\n* [Library](library.html): The uri that identifies the library\r\n* [Measure](measure.html): The uri that identifies the measure\r\n* [MessageDefinition](messagedefinition.html): The uri that identifies the message definition\r\n* [NamingSystem](namingsystem.html): The uri that identifies the naming system\r\n* [ObservationDefinition](observationdefinition.html): The uri that identifies the observation definition\r\n* [OperationDefinition](operationdefinition.html): The uri that identifies the operation definition\r\n* [PlanDefinition](plandefinition.html): The uri that identifies the plan definition\r\n* [Questionnaire](questionnaire.html): The uri that identifies the questionnaire\r\n* [Requirements](requirements.html): The uri that identifies the requirements\r\n* [SearchParameter](searchparameter.html): The uri that identifies the search parameter\r\n* [SpecimenDefinition](specimendefinition.html): The uri that identifies the specimen definition\r\n* [StructureDefinition](structuredefinition.html): The uri that identifies the structure definition\r\n* [StructureMap](structuremap.html): The uri that identifies the structure map\r\n* [SubscriptionTopic](subscriptiontopic.html): Logical canonical URL to reference this SubscriptionTopic (globally unique)\r\n* [TerminologyCapabilities](terminologycapabilities.html): The uri that identifies the terminology capabilities\r\n* [TestScript](testscript.html): The uri that identifies the test script\r\n* [ValueSet](valueset.html): The uri that identifies the value set\r\n", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="version", path="ActivityDefinition.version | ActorDefinition.version | CapabilityStatement.version | ChargeItemDefinition.version | Citation.version | CodeSystem.version | CompartmentDefinition.version | ConceptMap.version | ConditionDefinition.version | EventDefinition.version | Evidence.version | EvidenceVariable.version | ExampleScenario.version | GraphDefinition.version | ImplementationGuide.version | Library.version | Measure.version | MessageDefinition.version | NamingSystem.version | OperationDefinition.version | PlanDefinition.version | Questionnaire.version | Requirements.version | SearchParameter.version | StructureDefinition.version | StructureMap.version | SubscriptionTopic.version | TerminologyCapabilities.version | TestScript.version | ValueSet.version", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The business version of the activity definition\r\n* [ActorDefinition](actordefinition.html): The business version of the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): The business version of the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The business version of the charge item definition\r\n* [Citation](citation.html): The business version of the citation\r\n* [CodeSystem](codesystem.html): The business version of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The business version of the compartment definition\r\n* [ConceptMap](conceptmap.html): The business version of the concept map\r\n* [ConditionDefinition](conditiondefinition.html): The business version of the condition definition\r\n* [EventDefinition](eventdefinition.html): The business version of the event definition\r\n* [Evidence](evidence.html): The business version of the evidence\r\n* [EvidenceVariable](evidencevariable.html): The business version of the evidence variable\r\n* [ExampleScenario](examplescenario.html): The business version of the example scenario\r\n* [GraphDefinition](graphdefinition.html): The business version of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The business version of the implementation guide\r\n* [Library](library.html): The business version of the library\r\n* [Measure](measure.html): The business version of the measure\r\n* [MessageDefinition](messagedefinition.html): The business version of the message definition\r\n* [NamingSystem](namingsystem.html): The business version of the naming system\r\n* [OperationDefinition](operationdefinition.html): The business version of the operation definition\r\n* [PlanDefinition](plandefinition.html): The business version of the plan definition\r\n* [Questionnaire](questionnaire.html): The business version of the questionnaire\r\n* [Requirements](requirements.html): The business version of the requirements\r\n* [SearchParameter](searchparameter.html): The business version of the search parameter\r\n* [StructureDefinition](structuredefinition.html): The business version of the structure definition\r\n* [StructureMap](structuremap.html): The business version of the structure map\r\n* [SubscriptionTopic](subscriptiontopic.html): Business version of the SubscriptionTopic\r\n* [TerminologyCapabilities](terminologycapabilities.html): The business version of the terminology capabilities\r\n* [TestScript](testscript.html): The business version of the test script\r\n* [ValueSet](valueset.html): The business version of the value set\r\n", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="derived-or-self", path="SubscriptionTopic.url | SubscriptionTopic.derivedFrom", description="A server defined search that matches either the url or derivedFrom", type="uri")
    public static final String SP_DERIVED_OR_SELF = "derived-or-self";
    public static final UriClientParam DERIVED_OR_SELF = new UriClientParam("derived-or-self");
    @SearchParamDefinition(name="resource", path="SubscriptionTopic.resourceTrigger.resource", description="Allowed Data type or Resource (reference to definition) for this definition, searches resourceTrigger, eventTrigger, and notificationShape for matches.", type="uri")
    public static final String SP_RESOURCE = "resource";
    public static final UriClientParam RESOURCE = new UriClientParam("resource");
    @SearchParamDefinition(name="trigger-description", path="SubscriptionTopic.resourceTrigger.description", description="Text representation of the trigger", type="string")
    public static final String SP_TRIGGER_DESCRIPTION = "trigger-description";
    public static final StringClientParam TRIGGER_DESCRIPTION = new StringClientParam("trigger-description");

    public SubscriptionTopic() {
    }

    public SubscriptionTopic(String url, Enumerations.PublicationStatus status) {
        this.setUrl(url);
        this.setStatus(status);
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionTopic.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public SubscriptionTopic setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public SubscriptionTopic setUrl(String value) {
        if (this.url == null) {
            this.url = new UriType();
        }
        this.url.setValue(value);
        return this;
    }

    @Override
    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    @Override
    public SubscriptionTopic setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    @Override
    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    @Override
    public SubscriptionTopic addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    @Override
    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionTopic.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public SubscriptionTopic setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public SubscriptionTopic setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionTopic.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    @Override
    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public SubscriptionTopic setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    @Override
    public SubscriptionTopic setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    public List<CanonicalType> getDerivedFrom() {
        if (this.derivedFrom == null) {
            this.derivedFrom = new ArrayList<CanonicalType>();
        }
        return this.derivedFrom;
    }

    public SubscriptionTopic setDerivedFrom(List<CanonicalType> theDerivedFrom) {
        this.derivedFrom = theDerivedFrom;
        return this;
    }

    public boolean hasDerivedFrom() {
        if (this.derivedFrom == null) {
            return false;
        }
        for (CanonicalType item : this.derivedFrom) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CanonicalType addDerivedFromElement() {
        CanonicalType t = new CanonicalType();
        if (this.derivedFrom == null) {
            this.derivedFrom = new ArrayList<CanonicalType>();
        }
        this.derivedFrom.add(t);
        return t;
    }

    public SubscriptionTopic addDerivedFrom(String value) {
        CanonicalType t = new CanonicalType();
        t.setValue(value);
        if (this.derivedFrom == null) {
            this.derivedFrom = new ArrayList<CanonicalType>();
        }
        this.derivedFrom.add(t);
        return this;
    }

    public boolean hasDerivedFrom(String value) {
        if (this.derivedFrom == null) {
            return false;
        }
        for (CanonicalType v : this.derivedFrom) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionTopic.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public SubscriptionTopic setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public SubscriptionTopic setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionTopic.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public SubscriptionTopic setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public SubscriptionTopic setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionTopic.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public SubscriptionTopic setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public SubscriptionTopic setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionTopic.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public SubscriptionTopic setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public SubscriptionTopic setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        return this.contact;
    }

    @Override
    public SubscriptionTopic setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public SubscriptionTopic addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionTopic.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public SubscriptionTopic setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public SubscriptionTopic setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        return this.useContext;
    }

    @Override
    public SubscriptionTopic setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public SubscriptionTopic addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        return this.jurisdiction;
    }

    @Override
    public SubscriptionTopic setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public SubscriptionTopic addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    @Override
    public MarkdownType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionTopic.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new MarkdownType();
            }
        }
        return this.purpose;
    }

    @Override
    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    @Override
    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    @Override
    public SubscriptionTopic setPurposeElement(MarkdownType value) {
        this.purpose = value;
        return this;
    }

    @Override
    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    @Override
    public SubscriptionTopic setPurpose(String value) {
        if (value == null) {
            this.purpose = null;
        } else {
            if (this.purpose == null) {
                this.purpose = new MarkdownType();
            }
            this.purpose.setValue(value);
        }
        return this;
    }

    @Override
    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionTopic.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    @Override
    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    @Override
    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    @Override
    public SubscriptionTopic setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    @Override
    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    @Override
    public SubscriptionTopic setCopyright(String value) {
        if (value == null) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getCopyrightLabelElement() {
        if (this.copyrightLabel == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionTopic.copyrightLabel");
            }
            if (Configuration.doAutoCreate()) {
                this.copyrightLabel = new StringType();
            }
        }
        return this.copyrightLabel;
    }

    @Override
    public boolean hasCopyrightLabelElement() {
        return this.copyrightLabel != null && !this.copyrightLabel.isEmpty();
    }

    @Override
    public boolean hasCopyrightLabel() {
        return this.copyrightLabel != null && !this.copyrightLabel.isEmpty();
    }

    @Override
    public SubscriptionTopic setCopyrightLabelElement(StringType value) {
        this.copyrightLabel = value;
        return this;
    }

    @Override
    public String getCopyrightLabel() {
        return this.copyrightLabel == null ? null : (String)this.copyrightLabel.getValue();
    }

    @Override
    public SubscriptionTopic setCopyrightLabel(String value) {
        if (Utilities.noString((String)value)) {
            this.copyrightLabel = null;
        } else {
            if (this.copyrightLabel == null) {
                this.copyrightLabel = new StringType();
            }
            this.copyrightLabel.setValue(value);
        }
        return this;
    }

    public DateType getApprovalDateElement() {
        if (this.approvalDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionTopic.approvalDate");
            }
            if (Configuration.doAutoCreate()) {
                this.approvalDate = new DateType();
            }
        }
        return this.approvalDate;
    }

    public boolean hasApprovalDateElement() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    public boolean hasApprovalDate() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    public SubscriptionTopic setApprovalDateElement(DateType value) {
        this.approvalDate = value;
        return this;
    }

    public Date getApprovalDate() {
        return this.approvalDate == null ? null : (Date)this.approvalDate.getValue();
    }

    public SubscriptionTopic setApprovalDate(Date value) {
        if (value == null) {
            this.approvalDate = null;
        } else {
            if (this.approvalDate == null) {
                this.approvalDate = new DateType();
            }
            this.approvalDate.setValue(value);
        }
        return this;
    }

    public DateType getLastReviewDateElement() {
        if (this.lastReviewDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionTopic.lastReviewDate");
            }
            if (Configuration.doAutoCreate()) {
                this.lastReviewDate = new DateType();
            }
        }
        return this.lastReviewDate;
    }

    public boolean hasLastReviewDateElement() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    public boolean hasLastReviewDate() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    public SubscriptionTopic setLastReviewDateElement(DateType value) {
        this.lastReviewDate = value;
        return this;
    }

    public Date getLastReviewDate() {
        return this.lastReviewDate == null ? null : (Date)this.lastReviewDate.getValue();
    }

    public SubscriptionTopic setLastReviewDate(Date value) {
        if (value == null) {
            this.lastReviewDate = null;
        } else {
            if (this.lastReviewDate == null) {
                this.lastReviewDate = new DateType();
            }
            this.lastReviewDate.setValue(value);
        }
        return this;
    }

    public Period getEffectivePeriod() {
        if (this.effectivePeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionTopic.effectivePeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.effectivePeriod = new Period();
            }
        }
        return this.effectivePeriod;
    }

    public boolean hasEffectivePeriod() {
        return this.effectivePeriod != null && !this.effectivePeriod.isEmpty();
    }

    public SubscriptionTopic setEffectivePeriod(Period value) {
        this.effectivePeriod = value;
        return this;
    }

    public List<SubscriptionTopicResourceTriggerComponent> getResourceTrigger() {
        if (this.resourceTrigger == null) {
            this.resourceTrigger = new ArrayList<SubscriptionTopicResourceTriggerComponent>();
        }
        return this.resourceTrigger;
    }

    public SubscriptionTopic setResourceTrigger(List<SubscriptionTopicResourceTriggerComponent> theResourceTrigger) {
        this.resourceTrigger = theResourceTrigger;
        return this;
    }

    public boolean hasResourceTrigger() {
        if (this.resourceTrigger == null) {
            return false;
        }
        for (SubscriptionTopicResourceTriggerComponent item : this.resourceTrigger) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SubscriptionTopicResourceTriggerComponent addResourceTrigger() {
        SubscriptionTopicResourceTriggerComponent t = new SubscriptionTopicResourceTriggerComponent();
        if (this.resourceTrigger == null) {
            this.resourceTrigger = new ArrayList<SubscriptionTopicResourceTriggerComponent>();
        }
        this.resourceTrigger.add(t);
        return t;
    }

    public SubscriptionTopic addResourceTrigger(SubscriptionTopicResourceTriggerComponent t) {
        if (t == null) {
            return this;
        }
        if (this.resourceTrigger == null) {
            this.resourceTrigger = new ArrayList<SubscriptionTopicResourceTriggerComponent>();
        }
        this.resourceTrigger.add(t);
        return this;
    }

    public SubscriptionTopicResourceTriggerComponent getResourceTriggerFirstRep() {
        if (this.getResourceTrigger().isEmpty()) {
            this.addResourceTrigger();
        }
        return this.getResourceTrigger().get(0);
    }

    public List<SubscriptionTopicEventTriggerComponent> getEventTrigger() {
        if (this.eventTrigger == null) {
            this.eventTrigger = new ArrayList<SubscriptionTopicEventTriggerComponent>();
        }
        return this.eventTrigger;
    }

    public SubscriptionTopic setEventTrigger(List<SubscriptionTopicEventTriggerComponent> theEventTrigger) {
        this.eventTrigger = theEventTrigger;
        return this;
    }

    public boolean hasEventTrigger() {
        if (this.eventTrigger == null) {
            return false;
        }
        for (SubscriptionTopicEventTriggerComponent item : this.eventTrigger) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SubscriptionTopicEventTriggerComponent addEventTrigger() {
        SubscriptionTopicEventTriggerComponent t = new SubscriptionTopicEventTriggerComponent();
        if (this.eventTrigger == null) {
            this.eventTrigger = new ArrayList<SubscriptionTopicEventTriggerComponent>();
        }
        this.eventTrigger.add(t);
        return t;
    }

    public SubscriptionTopic addEventTrigger(SubscriptionTopicEventTriggerComponent t) {
        if (t == null) {
            return this;
        }
        if (this.eventTrigger == null) {
            this.eventTrigger = new ArrayList<SubscriptionTopicEventTriggerComponent>();
        }
        this.eventTrigger.add(t);
        return this;
    }

    public SubscriptionTopicEventTriggerComponent getEventTriggerFirstRep() {
        if (this.getEventTrigger().isEmpty()) {
            this.addEventTrigger();
        }
        return this.getEventTrigger().get(0);
    }

    public List<SubscriptionTopicCanFilterByComponent> getCanFilterBy() {
        if (this.canFilterBy == null) {
            this.canFilterBy = new ArrayList<SubscriptionTopicCanFilterByComponent>();
        }
        return this.canFilterBy;
    }

    public SubscriptionTopic setCanFilterBy(List<SubscriptionTopicCanFilterByComponent> theCanFilterBy) {
        this.canFilterBy = theCanFilterBy;
        return this;
    }

    public boolean hasCanFilterBy() {
        if (this.canFilterBy == null) {
            return false;
        }
        for (SubscriptionTopicCanFilterByComponent item : this.canFilterBy) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SubscriptionTopicCanFilterByComponent addCanFilterBy() {
        SubscriptionTopicCanFilterByComponent t = new SubscriptionTopicCanFilterByComponent();
        if (this.canFilterBy == null) {
            this.canFilterBy = new ArrayList<SubscriptionTopicCanFilterByComponent>();
        }
        this.canFilterBy.add(t);
        return t;
    }

    public SubscriptionTopic addCanFilterBy(SubscriptionTopicCanFilterByComponent t) {
        if (t == null) {
            return this;
        }
        if (this.canFilterBy == null) {
            this.canFilterBy = new ArrayList<SubscriptionTopicCanFilterByComponent>();
        }
        this.canFilterBy.add(t);
        return this;
    }

    public SubscriptionTopicCanFilterByComponent getCanFilterByFirstRep() {
        if (this.getCanFilterBy().isEmpty()) {
            this.addCanFilterBy();
        }
        return this.getCanFilterBy().get(0);
    }

    public List<SubscriptionTopicNotificationShapeComponent> getNotificationShape() {
        if (this.notificationShape == null) {
            this.notificationShape = new ArrayList<SubscriptionTopicNotificationShapeComponent>();
        }
        return this.notificationShape;
    }

    public SubscriptionTopic setNotificationShape(List<SubscriptionTopicNotificationShapeComponent> theNotificationShape) {
        this.notificationShape = theNotificationShape;
        return this;
    }

    public boolean hasNotificationShape() {
        if (this.notificationShape == null) {
            return false;
        }
        for (SubscriptionTopicNotificationShapeComponent item : this.notificationShape) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SubscriptionTopicNotificationShapeComponent addNotificationShape() {
        SubscriptionTopicNotificationShapeComponent t = new SubscriptionTopicNotificationShapeComponent();
        if (this.notificationShape == null) {
            this.notificationShape = new ArrayList<SubscriptionTopicNotificationShapeComponent>();
        }
        this.notificationShape.add(t);
        return t;
    }

    public SubscriptionTopic addNotificationShape(SubscriptionTopicNotificationShapeComponent t) {
        if (t == null) {
            return this;
        }
        if (this.notificationShape == null) {
            this.notificationShape = new ArrayList<SubscriptionTopicNotificationShapeComponent>();
        }
        this.notificationShape.add(t);
        return this;
    }

    public SubscriptionTopicNotificationShapeComponent getNotificationShapeFirstRep() {
        if (this.getNotificationShape().isEmpty()) {
            this.addNotificationShape();
        }
        return this.getNotificationShape().get(0);
    }

    @Override
    public int getVersionAlgorithmMax() {
        return 0;
    }

    @Override
    public DataType getVersionAlgorithm() {
        throw new Error("The resource type \"SubscriptionTopic\" does not implement the property \"versionAlgorithm[x]\"");
    }

    @Override
    public StringType getVersionAlgorithmStringType() {
        throw new Error("The resource type \"SubscriptionTopic\" does not implement the property \"versionAlgorithm[x]\"");
    }

    @Override
    public boolean hasVersionAlgorithmStringType() {
        return false;
    }

    @Override
    public Coding getVersionAlgorithmCoding() {
        throw new Error("The resource type \"SubscriptionTopic\" does not implement the property \"versionAlgorithm[x]\"");
    }

    @Override
    public boolean hasVersionAlgorithmCoding() {
        return false;
    }

    @Override
    public boolean hasVersionAlgorithm() {
        return false;
    }

    @Override
    public SubscriptionTopic setVersionAlgorithm(DataType value) {
        throw new Error("The resource type \"SubscriptionTopic\" does not implement the property \"versionAlgorithm[x]\"");
    }

    @Override
    public int getNameMax() {
        return 0;
    }

    @Override
    public StringType getNameElement() {
        throw new Error("The resource type \"SubscriptionTopic\" does not implement the property \"name\"");
    }

    @Override
    public boolean hasNameElement() {
        return false;
    }

    @Override
    public boolean hasName() {
        return false;
    }

    @Override
    public SubscriptionTopic setNameElement(StringType value) {
        throw new Error("The resource type \"SubscriptionTopic\" does not implement the property \"name\"");
    }

    @Override
    public String getName() {
        throw new Error("The resource type \"SubscriptionTopic\" does not implement the property \"name\"");
    }

    @Override
    public SubscriptionTopic setName(String value) {
        throw new Error("The resource type \"SubscriptionTopic\" does not implement the property \"name\"");
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this subscription topic when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which an authoritative instance of this subscription topic is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the subscription topic is stored on different servers.", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this subscription topic by the performer and/or other systems.  These identifiers remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the subscription topic when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the Topic author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions are orderable.", 0, 1, this.version));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the SubscriptionTopic, for example, \"admission\".", 0, 1, this.title));
        children.add(new Property("derivedFrom", "canonical(SubscriptionTopic)", "The canonical URL pointing to another FHIR-defined SubscriptionTopic that is adhered to in whole or in part by this SubscriptionTopic.", 0, Integer.MAX_VALUE, this.derivedFrom));
        children.add(new Property(SP_STATUS, "code", "The current state of the SubscriptionTopic.", 0, 1, this.status));
        children.add(new Property("experimental", "boolean", "A flag to indicate that this TopSubscriptionTopicic is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property(SP_DATE, "dateTime", "For draft definitions, indicates the date of initial creation.  For active definitions, represents the date of activation.  For withdrawn definitions, indicates the date of withdrawal.", 0, 1, this.date));
        children.add(new Property("publisher", "string", "Helps establish the \"authority/credibility\" of the SubscriptionTopic.  May also allow for contact.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property("description", "markdown", "A free text natural language description of the Topic from the consumer's perspective.", 0, 1, this.description));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching of code system definitions.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property("jurisdiction", "CodeableConcept", "A jurisdiction in which the Topic is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("purpose", "markdown", "Explains why this Topic is needed and why it has been designed as it has.", 0, 1, this.purpose));
        children.add(new Property("copyright", "markdown", "A copyright statement relating to the SubscriptionTopic and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the SubscriptionTopic.", 0, 1, this.copyright));
        children.add(new Property("copyrightLabel", "string", "A short string (<50 characters), suitable for inclusion in a page footer that identifies the copyright holder, effective period, and optionally whether rights are resctricted. (e.g. 'All rights reserved', 'Some rights reserved').", 0, 1, this.copyrightLabel));
        children.add(new Property("approvalDate", SP_DATE, "The date on which the asset content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate));
        children.add(new Property("lastReviewDate", SP_DATE, "The date on which the asset content was last reviewed. Review happens periodically after that, but doesn't change the original approval date.", 0, 1, this.lastReviewDate));
        children.add(new Property("effectivePeriod", "Period", "The period during which the SubscriptionTopic content was or is planned to be effective.", 0, 1, this.effectivePeriod));
        children.add(new Property("resourceTrigger", "", "A definition of a resource-based event that triggers a notification based on the SubscriptionTopic. The criteria may be just a human readable description and/or a full FHIR search string or FHIRPath expression. Multiple triggers are considered OR joined (e.g., a resource update matching ANY of the definitions will trigger a notification).", 0, Integer.MAX_VALUE, this.resourceTrigger));
        children.add(new Property("eventTrigger", "", "Event definition which can be used to trigger the SubscriptionTopic.", 0, Integer.MAX_VALUE, this.eventTrigger));
        children.add(new Property("canFilterBy", "", "List of properties by which Subscriptions on the SubscriptionTopic can be filtered. May be defined Search Parameters (e.g., Encounter.patient) or parameters defined within this SubscriptionTopic context (e.g., hub.event).", 0, Integer.MAX_VALUE, this.canFilterBy));
        children.add(new Property("notificationShape", "", "List of properties to describe the shape (e.g., resources) included in notifications from this Subscription Topic.", 0, Integer.MAX_VALUE, this.notificationShape));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this subscription topic when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which an authoritative instance of this subscription topic is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the subscription topic is stored on different servers.", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this subscription topic by the performer and/or other systems.  These identifiers remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the subscription topic when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the Topic author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions are orderable.", 0, 1, this.version);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the SubscriptionTopic, for example, \"admission\".", 0, 1, this.title);
            }
            case 1077922663: {
                return new Property("derivedFrom", "canonical(SubscriptionTopic)", "The canonical URL pointing to another FHIR-defined SubscriptionTopic that is adhered to in whole or in part by this SubscriptionTopic.", 0, Integer.MAX_VALUE, this.derivedFrom);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The current state of the SubscriptionTopic.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A flag to indicate that this TopSubscriptionTopicic is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "For draft definitions, indicates the date of initial creation.  For active definitions, represents the date of activation.  For withdrawn definitions, indicates the date of withdrawal.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property("publisher", "string", "Helps establish the \"authority/credibility\" of the SubscriptionTopic.  May also allow for contact.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property("description", "markdown", "A free text natural language description of the Topic from the consumer's perspective.", 0, 1, this.description);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching of code system definitions.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property("jurisdiction", "CodeableConcept", "A jurisdiction in which the Topic is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case -220463842: {
                return new Property("purpose", "markdown", "Explains why this Topic is needed and why it has been designed as it has.", 0, 1, this.purpose);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "A copyright statement relating to the SubscriptionTopic and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the SubscriptionTopic.", 0, 1, this.copyright);
            }
            case 765157229: {
                return new Property("copyrightLabel", "string", "A short string (<50 characters), suitable for inclusion in a page footer that identifies the copyright holder, effective period, and optionally whether rights are resctricted. (e.g. 'All rights reserved', 'Some rights reserved').", 0, 1, this.copyrightLabel);
            }
            case 223539345: {
                return new Property("approvalDate", SP_DATE, "The date on which the asset content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate);
            }
            case -1687512484: {
                return new Property("lastReviewDate", SP_DATE, "The date on which the asset content was last reviewed. Review happens periodically after that, but doesn't change the original approval date.", 0, 1, this.lastReviewDate);
            }
            case -403934648: {
                return new Property("effectivePeriod", "Period", "The period during which the SubscriptionTopic content was or is planned to be effective.", 0, 1, this.effectivePeriod);
            }
            case -424927798: {
                return new Property("resourceTrigger", "", "A definition of a resource-based event that triggers a notification based on the SubscriptionTopic. The criteria may be just a human readable description and/or a full FHIR search string or FHIRPath expression. Multiple triggers are considered OR joined (e.g., a resource update matching ANY of the definitions will trigger a notification).", 0, Integer.MAX_VALUE, this.resourceTrigger);
            }
            case -151635522: {
                return new Property("eventTrigger", "", "Event definition which can be used to trigger the SubscriptionTopic.", 0, Integer.MAX_VALUE, this.eventTrigger);
            }
            case -1299519009: {
                return new Property("canFilterBy", "", "List of properties by which Subscriptions on the SubscriptionTopic can be filtered. May be defined Search Parameters (e.g., Encounter.patient) or parameters defined within this SubscriptionTopic context (e.g., hub.event).", 0, Integer.MAX_VALUE, this.canFilterBy);
            }
            case -1583369866: {
                return new Property("notificationShape", "", "List of properties to describe the shape (e.g., resources) included in notifications from this Subscription Topic.", 0, Integer.MAX_VALUE, this.notificationShape);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.title;
                }
                return baseArray;
            }
            case 1077922663: {
                return this.derivedFrom == null ? new Base[]{} : this.derivedFrom.toArray(new Base[this.derivedFrom.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.purpose;
                }
                return baseArray;
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.copyright;
                }
                return baseArray;
            }
            case 765157229: {
                Base[] baseArray;
                if (this.copyrightLabel == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.copyrightLabel;
                }
                return baseArray;
            }
            case 223539345: {
                Base[] baseArray;
                if (this.approvalDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.approvalDate;
                }
                return baseArray;
            }
            case -1687512484: {
                Base[] baseArray;
                if (this.lastReviewDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.lastReviewDate;
                }
                return baseArray;
            }
            case -403934648: {
                Base[] baseArray;
                if (this.effectivePeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.effectivePeriod;
                }
                return baseArray;
            }
            case -424927798: {
                return this.resourceTrigger == null ? new Base[]{} : this.resourceTrigger.toArray(new Base[this.resourceTrigger.size()]);
            }
            case -151635522: {
                return this.eventTrigger == null ? new Base[]{} : this.eventTrigger.toArray(new Base[this.eventTrigger.size()]);
            }
            case -1299519009: {
                return this.canFilterBy == null ? new Base[]{} : this.canFilterBy.toArray(new Base[this.canFilterBy.size()]);
            }
            case -1583369866: {
                return this.notificationShape == null ? new Base[]{} : this.notificationShape.toArray(new Base[this.notificationShape.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = TypeConvertor.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 351608024: {
                this.version = TypeConvertor.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = TypeConvertor.castToString(value);
                return value;
            }
            case 1077922663: {
                this.getDerivedFrom().add(TypeConvertor.castToCanonical(value));
                return value;
            }
            case -892481550: {
                value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -404562712: {
                this.experimental = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = TypeConvertor.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(TypeConvertor.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -220463842: {
                this.purpose = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 1522889671: {
                this.copyright = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 765157229: {
                this.copyrightLabel = TypeConvertor.castToString(value);
                return value;
            }
            case 223539345: {
                this.approvalDate = TypeConvertor.castToDate(value);
                return value;
            }
            case -1687512484: {
                this.lastReviewDate = TypeConvertor.castToDate(value);
                return value;
            }
            case -403934648: {
                this.effectivePeriod = TypeConvertor.castToPeriod(value);
                return value;
            }
            case -424927798: {
                this.getResourceTrigger().add((SubscriptionTopicResourceTriggerComponent)((Object)value));
                return value;
            }
            case -151635522: {
                this.getEventTrigger().add((SubscriptionTopicEventTriggerComponent)((Object)value));
                return value;
            }
            case -1299519009: {
                this.getCanFilterBy().add((SubscriptionTopicCanFilterByComponent)((Object)value));
                return value;
            }
            case -1583369866: {
                this.getNotificationShape().add((SubscriptionTopicNotificationShapeComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = TypeConvertor.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = TypeConvertor.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = TypeConvertor.castToString(value);
        } else if (name.equals("derivedFrom")) {
            this.getDerivedFrom().add(TypeConvertor.castToCanonical(value));
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("experimental")) {
            this.experimental = TypeConvertor.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = TypeConvertor.castToDateTime(value);
        } else if (name.equals("publisher")) {
            this.publisher = TypeConvertor.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("description")) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(TypeConvertor.castToUsageContext(value));
        } else if (name.equals("jurisdiction")) {
            this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("purpose")) {
            this.purpose = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("copyright")) {
            this.copyright = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("copyrightLabel")) {
            this.copyrightLabel = TypeConvertor.castToString(value);
        } else if (name.equals("approvalDate")) {
            this.approvalDate = TypeConvertor.castToDate(value);
        } else if (name.equals("lastReviewDate")) {
            this.lastReviewDate = TypeConvertor.castToDate(value);
        } else if (name.equals("effectivePeriod")) {
            this.effectivePeriod = TypeConvertor.castToPeriod(value);
        } else if (name.equals("resourceTrigger")) {
            this.getResourceTrigger().add((SubscriptionTopicResourceTriggerComponent)((Object)value));
        } else if (name.equals("eventTrigger")) {
            this.getEventTrigger().add((SubscriptionTopicEventTriggerComponent)((Object)value));
        } else if (name.equals("canFilterBy")) {
            this.getCanFilterBy().add((SubscriptionTopicCanFilterByComponent)((Object)value));
        } else if (name.equals("notificationShape")) {
            this.getNotificationShape().add((SubscriptionTopicNotificationShapeComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case 1077922663: {
                return this.addDerivedFromElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case -220463842: {
                return this.getPurposeElement();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case 765157229: {
                return this.getCopyrightLabelElement();
            }
            case 223539345: {
                return this.getApprovalDateElement();
            }
            case -1687512484: {
                return this.getLastReviewDateElement();
            }
            case -403934648: {
                return this.getEffectivePeriod();
            }
            case -424927798: {
                return this.addResourceTrigger();
            }
            case -151635522: {
                return this.addEventTrigger();
            }
            case -1299519009: {
                return this.addCanFilterBy();
            }
            case -1583369866: {
                return this.addNotificationShape();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case 1077922663: {
                return new String[]{"canonical"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case -220463842: {
                return new String[]{"markdown"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case 765157229: {
                return new String[]{"string"};
            }
            case 223539345: {
                return new String[]{SP_DATE};
            }
            case -1687512484: {
                return new String[]{SP_DATE};
            }
            case -403934648: {
                return new String[]{"Period"};
            }
            case -424927798: {
                return new String[0];
            }
            case -151635522: {
                return new String[0];
            }
            case -1299519009: {
                return new String[0];
            }
            case -1583369866: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.version");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.title");
        }
        if (name.equals("derivedFrom")) {
            throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.derivedFrom");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.date");
        }
        if (name.equals("publisher")) {
            throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals("jurisdiction")) {
            return this.addJurisdiction();
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.purpose");
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.copyright");
        }
        if (name.equals("copyrightLabel")) {
            throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.copyrightLabel");
        }
        if (name.equals("approvalDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.approvalDate");
        }
        if (name.equals("lastReviewDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.lastReviewDate");
        }
        if (name.equals("effectivePeriod")) {
            this.effectivePeriod = new Period();
            return this.effectivePeriod;
        }
        if (name.equals("resourceTrigger")) {
            return this.addResourceTrigger();
        }
        if (name.equals("eventTrigger")) {
            return this.addEventTrigger();
        }
        if (name.equals("canFilterBy")) {
            return this.addCanFilterBy();
        }
        if (name.equals("notificationShape")) {
            return this.addNotificationShape();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "SubscriptionTopic";
    }

    @Override
    public SubscriptionTopic copy() {
        SubscriptionTopic dst = new SubscriptionTopic();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(SubscriptionTopic dst) {
        super.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        StringType stringType = dst.title = this.title == null ? null : this.title.copy();
        if (this.derivedFrom != null) {
            dst.derivedFrom = new ArrayList<CanonicalType>();
            for (CanonicalType canonicalType : this.derivedFrom) {
                dst.derivedFrom.add(canonicalType.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType2 = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList<UsageContext>();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        dst.copyrightLabel = this.copyrightLabel == null ? null : this.copyrightLabel.copy();
        dst.approvalDate = this.approvalDate == null ? null : this.approvalDate.copy();
        dst.lastReviewDate = this.lastReviewDate == null ? null : this.lastReviewDate.copy();
        Period period = dst.effectivePeriod = this.effectivePeriod == null ? null : this.effectivePeriod.copy();
        if (this.resourceTrigger != null) {
            dst.resourceTrigger = new ArrayList<SubscriptionTopicResourceTriggerComponent>();
            for (SubscriptionTopicResourceTriggerComponent subscriptionTopicResourceTriggerComponent : this.resourceTrigger) {
                dst.resourceTrigger.add(subscriptionTopicResourceTriggerComponent.copy());
            }
        }
        if (this.eventTrigger != null) {
            dst.eventTrigger = new ArrayList<SubscriptionTopicEventTriggerComponent>();
            for (SubscriptionTopicEventTriggerComponent subscriptionTopicEventTriggerComponent : this.eventTrigger) {
                dst.eventTrigger.add(subscriptionTopicEventTriggerComponent.copy());
            }
        }
        if (this.canFilterBy != null) {
            dst.canFilterBy = new ArrayList<SubscriptionTopicCanFilterByComponent>();
            for (SubscriptionTopicCanFilterByComponent subscriptionTopicCanFilterByComponent : this.canFilterBy) {
                dst.canFilterBy.add(subscriptionTopicCanFilterByComponent.copy());
            }
        }
        if (this.notificationShape != null) {
            dst.notificationShape = new ArrayList<SubscriptionTopicNotificationShapeComponent>();
            for (SubscriptionTopicNotificationShapeComponent subscriptionTopicNotificationShapeComponent : this.notificationShape) {
                dst.notificationShape.add(subscriptionTopicNotificationShapeComponent.copy());
            }
        }
    }

    protected SubscriptionTopic typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof SubscriptionTopic)) {
            return false;
        }
        SubscriptionTopic o = (SubscriptionTopic)other_;
        return SubscriptionTopic.compareDeep(this.url, o.url, true) && SubscriptionTopic.compareDeep(this.identifier, o.identifier, true) && SubscriptionTopic.compareDeep(this.version, o.version, true) && SubscriptionTopic.compareDeep(this.title, o.title, true) && SubscriptionTopic.compareDeep(this.derivedFrom, o.derivedFrom, true) && SubscriptionTopic.compareDeep(this.status, o.status, true) && SubscriptionTopic.compareDeep(this.experimental, o.experimental, true) && SubscriptionTopic.compareDeep(this.date, o.date, true) && SubscriptionTopic.compareDeep(this.publisher, o.publisher, true) && SubscriptionTopic.compareDeep(this.contact, o.contact, true) && SubscriptionTopic.compareDeep(this.description, o.description, true) && SubscriptionTopic.compareDeep(this.useContext, o.useContext, true) && SubscriptionTopic.compareDeep(this.jurisdiction, o.jurisdiction, true) && SubscriptionTopic.compareDeep(this.purpose, o.purpose, true) && SubscriptionTopic.compareDeep(this.copyright, o.copyright, true) && SubscriptionTopic.compareDeep(this.copyrightLabel, o.copyrightLabel, true) && SubscriptionTopic.compareDeep(this.approvalDate, o.approvalDate, true) && SubscriptionTopic.compareDeep(this.lastReviewDate, o.lastReviewDate, true) && SubscriptionTopic.compareDeep(this.effectivePeriod, o.effectivePeriod, true) && SubscriptionTopic.compareDeep(this.resourceTrigger, o.resourceTrigger, true) && SubscriptionTopic.compareDeep(this.eventTrigger, o.eventTrigger, true) && SubscriptionTopic.compareDeep(this.canFilterBy, o.canFilterBy, true) && SubscriptionTopic.compareDeep(this.notificationShape, o.notificationShape, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof SubscriptionTopic)) {
            return false;
        }
        SubscriptionTopic o = (SubscriptionTopic)other_;
        return SubscriptionTopic.compareValues(this.url, o.url, true) && SubscriptionTopic.compareValues(this.version, o.version, true) && SubscriptionTopic.compareValues(this.title, o.title, true) && SubscriptionTopic.compareValues(this.derivedFrom, o.derivedFrom, true) && SubscriptionTopic.compareValues(this.status, o.status, true) && SubscriptionTopic.compareValues(this.experimental, o.experimental, true) && SubscriptionTopic.compareValues(this.date, o.date, true) && SubscriptionTopic.compareValues(this.publisher, o.publisher, true) && SubscriptionTopic.compareValues(this.description, o.description, true) && SubscriptionTopic.compareValues(this.purpose, o.purpose, true) && SubscriptionTopic.compareValues(this.copyright, o.copyright, true) && SubscriptionTopic.compareValues(this.copyrightLabel, o.copyrightLabel, true) && SubscriptionTopic.compareValues(this.approvalDate, o.approvalDate, true) && SubscriptionTopic.compareValues(this.lastReviewDate, o.lastReviewDate, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.url, this.identifier, this.version, this.title, this.derivedFrom, this.status, this.experimental, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.purpose, this.copyright, this.copyrightLabel, this.approvalDate, this.lastReviewDate, this.effectivePeriod, this.resourceTrigger, this.eventTrigger, this.canFilterBy, this.notificationShape});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.SubscriptionTopic;
    }

    @Block
    public static class SubscriptionTopicNotificationShapeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="resource", type={UriType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="URL of the Resource that is the focus (main) resource in a notification shape", formalDefinition="URL of the Resource that is the type used in this shape. This is the \"focus\" of the topic (or one of them if there are more than one) and the root resource for this shape definition. It will be the same, a generality, or a specificity of SubscriptionTopic.resourceTrigger.resource or SubscriptionTopic.eventTrigger.resource when they are present.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/fhir-types")
        protected UriType resource;
        @Child(name="include", type={StringType.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Include directives, rooted in the resource for this shape", formalDefinition="Search-style _include directives, rooted in the resource for this shape. Servers SHOULD include resources listed here, if they exist and the user is authorized to receive them.  Clients SHOULD be prepared to receive these additional resources, but SHALL function properly without them.")
        protected List<StringType> include;
        @Child(name="revInclude", type={StringType.class}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Reverse include directives, rooted in the resource for this shape", formalDefinition="Search-style _revinclude directives, rooted in the resource for this shape. Servers SHOULD include resources listed here, if they exist and the user is authorized to receive them.  Clients SHOULD be prepared to receive these additional resources, but SHALL function properly without them.")
        protected List<StringType> revInclude;
        private static final long serialVersionUID = -1718592091L;

        public SubscriptionTopicNotificationShapeComponent() {
        }

        public SubscriptionTopicNotificationShapeComponent(String resource) {
            this.setResource(resource);
        }

        public UriType getResourceElement() {
            if (this.resource == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionTopicNotificationShapeComponent.resource");
                }
                if (Configuration.doAutoCreate()) {
                    this.resource = new UriType();
                }
            }
            return this.resource;
        }

        public boolean hasResourceElement() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public boolean hasResource() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public SubscriptionTopicNotificationShapeComponent setResourceElement(UriType value) {
            this.resource = value;
            return this;
        }

        public String getResource() {
            return this.resource == null ? null : (String)this.resource.getValue();
        }

        public SubscriptionTopicNotificationShapeComponent setResource(String value) {
            if (this.resource == null) {
                this.resource = new UriType();
            }
            this.resource.setValue(value);
            return this;
        }

        public List<StringType> getInclude() {
            if (this.include == null) {
                this.include = new ArrayList<StringType>();
            }
            return this.include;
        }

        public SubscriptionTopicNotificationShapeComponent setInclude(List<StringType> theInclude) {
            this.include = theInclude;
            return this;
        }

        public boolean hasInclude() {
            if (this.include == null) {
                return false;
            }
            for (StringType item : this.include) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addIncludeElement() {
            StringType t = new StringType();
            if (this.include == null) {
                this.include = new ArrayList<StringType>();
            }
            this.include.add(t);
            return t;
        }

        public SubscriptionTopicNotificationShapeComponent addInclude(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.include == null) {
                this.include = new ArrayList<StringType>();
            }
            this.include.add(t);
            return this;
        }

        public boolean hasInclude(String value) {
            if (this.include == null) {
                return false;
            }
            for (StringType v : this.include) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<StringType> getRevInclude() {
            if (this.revInclude == null) {
                this.revInclude = new ArrayList<StringType>();
            }
            return this.revInclude;
        }

        public SubscriptionTopicNotificationShapeComponent setRevInclude(List<StringType> theRevInclude) {
            this.revInclude = theRevInclude;
            return this;
        }

        public boolean hasRevInclude() {
            if (this.revInclude == null) {
                return false;
            }
            for (StringType item : this.revInclude) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addRevIncludeElement() {
            StringType t = new StringType();
            if (this.revInclude == null) {
                this.revInclude = new ArrayList<StringType>();
            }
            this.revInclude.add(t);
            return t;
        }

        public SubscriptionTopicNotificationShapeComponent addRevInclude(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.revInclude == null) {
                this.revInclude = new ArrayList<StringType>();
            }
            this.revInclude.add(t);
            return this;
        }

        public boolean hasRevInclude(String value) {
            if (this.revInclude == null) {
                return false;
            }
            for (StringType v : this.revInclude) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(SubscriptionTopic.SP_RESOURCE, "uri", "URL of the Resource that is the type used in this shape. This is the \"focus\" of the topic (or one of them if there are more than one) and the root resource for this shape definition. It will be the same, a generality, or a specificity of SubscriptionTopic.resourceTrigger.resource or SubscriptionTopic.eventTrigger.resource when they are present.", 0, 1, this.resource));
            children.add(new Property("include", "string", "Search-style _include directives, rooted in the resource for this shape. Servers SHOULD include resources listed here, if they exist and the user is authorized to receive them.  Clients SHOULD be prepared to receive these additional resources, but SHALL function properly without them.", 0, Integer.MAX_VALUE, this.include));
            children.add(new Property("revInclude", "string", "Search-style _revinclude directives, rooted in the resource for this shape. Servers SHOULD include resources listed here, if they exist and the user is authorized to receive them.  Clients SHOULD be prepared to receive these additional resources, but SHALL function properly without them.", 0, Integer.MAX_VALUE, this.revInclude));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -341064690: {
                    return new Property(SubscriptionTopic.SP_RESOURCE, "uri", "URL of the Resource that is the type used in this shape. This is the \"focus\" of the topic (or one of them if there are more than one) and the root resource for this shape definition. It will be the same, a generality, or a specificity of SubscriptionTopic.resourceTrigger.resource or SubscriptionTopic.eventTrigger.resource when they are present.", 0, 1, this.resource);
                }
                case 1942574248: {
                    return new Property("include", "string", "Search-style _include directives, rooted in the resource for this shape. Servers SHOULD include resources listed here, if they exist and the user is authorized to receive them.  Clients SHOULD be prepared to receive these additional resources, but SHALL function properly without them.", 0, Integer.MAX_VALUE, this.include);
                }
                case 8439429: {
                    return new Property("revInclude", "string", "Search-style _revinclude directives, rooted in the resource for this shape. Servers SHOULD include resources listed here, if they exist and the user is authorized to receive them.  Clients SHOULD be prepared to receive these additional resources, but SHALL function properly without them.", 0, Integer.MAX_VALUE, this.revInclude);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -341064690: {
                    Base[] baseArray;
                    if (this.resource == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.resource;
                    }
                    return baseArray;
                }
                case 1942574248: {
                    return this.include == null ? new Base[]{} : this.include.toArray(new Base[this.include.size()]);
                }
                case 8439429: {
                    return this.revInclude == null ? new Base[]{} : this.revInclude.toArray(new Base[this.revInclude.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -341064690: {
                    this.resource = TypeConvertor.castToUri(value);
                    return value;
                }
                case 1942574248: {
                    this.getInclude().add(TypeConvertor.castToString(value));
                    return value;
                }
                case 8439429: {
                    this.getRevInclude().add(TypeConvertor.castToString(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(SubscriptionTopic.SP_RESOURCE)) {
                this.resource = TypeConvertor.castToUri(value);
            } else if (name.equals("include")) {
                this.getInclude().add(TypeConvertor.castToString(value));
            } else if (name.equals("revInclude")) {
                this.getRevInclude().add(TypeConvertor.castToString(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -341064690: {
                    return this.getResourceElement();
                }
                case 1942574248: {
                    return this.addIncludeElement();
                }
                case 8439429: {
                    return this.addRevIncludeElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -341064690: {
                    return new String[]{"uri"};
                }
                case 1942574248: {
                    return new String[]{"string"};
                }
                case 8439429: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(SubscriptionTopic.SP_RESOURCE)) {
                throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.notificationShape.resource");
            }
            if (name.equals("include")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.notificationShape.include");
            }
            if (name.equals("revInclude")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.notificationShape.revInclude");
            }
            return super.addChild(name);
        }

        @Override
        public SubscriptionTopicNotificationShapeComponent copy() {
            SubscriptionTopicNotificationShapeComponent dst = new SubscriptionTopicNotificationShapeComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubscriptionTopicNotificationShapeComponent dst) {
            super.copyValues(dst);
            UriType uriType = dst.resource = this.resource == null ? null : this.resource.copy();
            if (this.include != null) {
                dst.include = new ArrayList<StringType>();
                for (StringType i : this.include) {
                    dst.include.add(i.copy());
                }
            }
            if (this.revInclude != null) {
                dst.revInclude = new ArrayList<StringType>();
                for (StringType i : this.revInclude) {
                    dst.revInclude.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubscriptionTopicNotificationShapeComponent)) {
                return false;
            }
            SubscriptionTopicNotificationShapeComponent o = (SubscriptionTopicNotificationShapeComponent)other_;
            return SubscriptionTopicNotificationShapeComponent.compareDeep(this.resource, o.resource, true) && SubscriptionTopicNotificationShapeComponent.compareDeep(this.include, o.include, true) && SubscriptionTopicNotificationShapeComponent.compareDeep(this.revInclude, o.revInclude, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubscriptionTopicNotificationShapeComponent)) {
                return false;
            }
            SubscriptionTopicNotificationShapeComponent o = (SubscriptionTopicNotificationShapeComponent)other_;
            return SubscriptionTopicNotificationShapeComponent.compareValues(this.resource, o.resource, true) && SubscriptionTopicNotificationShapeComponent.compareValues(this.include, o.include, true) && SubscriptionTopicNotificationShapeComponent.compareValues(this.revInclude, o.revInclude, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.resource, this.include, this.revInclude});
        }

        @Override
        public String fhirType() {
            return "SubscriptionTopic.notificationShape";
        }
    }

    @Block
    public static class SubscriptionTopicCanFilterByComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={MarkdownType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Description of this filter parameter", formalDefinition="Description of how this filtering parameter is intended to be used.")
        protected MarkdownType description;
        @Child(name="resource", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="URL of the triggering Resource that this filter applies to", formalDefinition="URL of the Resource that is the type used in this filter. This is the \"focus\" of the topic (or one of them if there are more than one). It will be the same, a generality, or a specificity of SubscriptionTopic.resourceTrigger.resource or SubscriptionTopic.eventTrigger.resource when they are present.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/fhir-types")
        protected UriType resource;
        @Child(name="filterParameter", type={StringType.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Human-readable and computation-friendly name for a filter parameter usable by subscriptions on this topic, via Subscription.filterBy.filterParameter", formalDefinition="Either the canonical URL to a search parameter (like \"http://hl7.org/fhir/SearchParameter/encounter-patient\") or topic-defined parameter (like \"hub.event\") which is a label for the filter.")
        protected StringType filterParameter;
        @Child(name="filterDefinition", type={UriType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Canonical URL for a filterParameter definition", formalDefinition="Either the canonical URL to a search parameter (like \"http://hl7.org/fhir/SearchParameter/encounter-patient\") or the officially-defined URI for a shared filter concept (like \"http://example.org/concepts/shared-common-event\").")
        protected UriType filterDefinition;
        @Child(name="modifier", type={CodeType.class}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="= | eq | ne | gt | lt | ge | le | sa | eb | ap | above | below | in | not-in | of-type", formalDefinition="Allowable operators to apply when determining matches (Search Modifiers).  If the filterParameter is a SearchParameter, this list of modifiers SHALL be a strict subset of the modifiers defined on that SearchParameter.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/subscription-search-modifier")
        protected List<Enumeration<Enumerations.SubscriptionSearchModifier>> modifier;
        private static final long serialVersionUID = 1579878218L;

        public SubscriptionTopicCanFilterByComponent() {
        }

        public SubscriptionTopicCanFilterByComponent(String filterParameter) {
            this.setFilterParameter(filterParameter);
        }

        public MarkdownType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionTopicCanFilterByComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new MarkdownType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public SubscriptionTopicCanFilterByComponent setDescriptionElement(MarkdownType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public SubscriptionTopicCanFilterByComponent setDescription(String value) {
            if (value == null) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new MarkdownType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public UriType getResourceElement() {
            if (this.resource == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionTopicCanFilterByComponent.resource");
                }
                if (Configuration.doAutoCreate()) {
                    this.resource = new UriType();
                }
            }
            return this.resource;
        }

        public boolean hasResourceElement() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public boolean hasResource() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public SubscriptionTopicCanFilterByComponent setResourceElement(UriType value) {
            this.resource = value;
            return this;
        }

        public String getResource() {
            return this.resource == null ? null : (String)this.resource.getValue();
        }

        public SubscriptionTopicCanFilterByComponent setResource(String value) {
            if (Utilities.noString((String)value)) {
                this.resource = null;
            } else {
                if (this.resource == null) {
                    this.resource = new UriType();
                }
                this.resource.setValue(value);
            }
            return this;
        }

        public StringType getFilterParameterElement() {
            if (this.filterParameter == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionTopicCanFilterByComponent.filterParameter");
                }
                if (Configuration.doAutoCreate()) {
                    this.filterParameter = new StringType();
                }
            }
            return this.filterParameter;
        }

        public boolean hasFilterParameterElement() {
            return this.filterParameter != null && !this.filterParameter.isEmpty();
        }

        public boolean hasFilterParameter() {
            return this.filterParameter != null && !this.filterParameter.isEmpty();
        }

        public SubscriptionTopicCanFilterByComponent setFilterParameterElement(StringType value) {
            this.filterParameter = value;
            return this;
        }

        public String getFilterParameter() {
            return this.filterParameter == null ? null : (String)this.filterParameter.getValue();
        }

        public SubscriptionTopicCanFilterByComponent setFilterParameter(String value) {
            if (this.filterParameter == null) {
                this.filterParameter = new StringType();
            }
            this.filterParameter.setValue(value);
            return this;
        }

        public UriType getFilterDefinitionElement() {
            if (this.filterDefinition == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionTopicCanFilterByComponent.filterDefinition");
                }
                if (Configuration.doAutoCreate()) {
                    this.filterDefinition = new UriType();
                }
            }
            return this.filterDefinition;
        }

        public boolean hasFilterDefinitionElement() {
            return this.filterDefinition != null && !this.filterDefinition.isEmpty();
        }

        public boolean hasFilterDefinition() {
            return this.filterDefinition != null && !this.filterDefinition.isEmpty();
        }

        public SubscriptionTopicCanFilterByComponent setFilterDefinitionElement(UriType value) {
            this.filterDefinition = value;
            return this;
        }

        public String getFilterDefinition() {
            return this.filterDefinition == null ? null : (String)this.filterDefinition.getValue();
        }

        public SubscriptionTopicCanFilterByComponent setFilterDefinition(String value) {
            if (Utilities.noString((String)value)) {
                this.filterDefinition = null;
            } else {
                if (this.filterDefinition == null) {
                    this.filterDefinition = new UriType();
                }
                this.filterDefinition.setValue(value);
            }
            return this;
        }

        public List<Enumeration<Enumerations.SubscriptionSearchModifier>> getModifier() {
            if (this.modifier == null) {
                this.modifier = new ArrayList<Enumeration<Enumerations.SubscriptionSearchModifier>>();
            }
            return this.modifier;
        }

        public SubscriptionTopicCanFilterByComponent setModifier(List<Enumeration<Enumerations.SubscriptionSearchModifier>> theModifier) {
            this.modifier = theModifier;
            return this;
        }

        public boolean hasModifier() {
            if (this.modifier == null) {
                return false;
            }
            for (Enumeration<Enumerations.SubscriptionSearchModifier> item : this.modifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Enumeration<Enumerations.SubscriptionSearchModifier> addModifierElement() {
            Enumeration<Enumerations.SubscriptionSearchModifier> t = new Enumeration<Enumerations.SubscriptionSearchModifier>(new Enumerations.SubscriptionSearchModifierEnumFactory());
            if (this.modifier == null) {
                this.modifier = new ArrayList<Enumeration<Enumerations.SubscriptionSearchModifier>>();
            }
            this.modifier.add(t);
            return t;
        }

        public SubscriptionTopicCanFilterByComponent addModifier(Enumerations.SubscriptionSearchModifier value) {
            Enumeration<Enumerations.SubscriptionSearchModifier> t = new Enumeration<Enumerations.SubscriptionSearchModifier>(new Enumerations.SubscriptionSearchModifierEnumFactory());
            t.setValue((Object)value);
            if (this.modifier == null) {
                this.modifier = new ArrayList<Enumeration<Enumerations.SubscriptionSearchModifier>>();
            }
            this.modifier.add(t);
            return this;
        }

        public boolean hasModifier(Enumerations.SubscriptionSearchModifier value) {
            if (this.modifier == null) {
                return false;
            }
            for (Enumeration<Enumerations.SubscriptionSearchModifier> v : this.modifier) {
                if (!((Enumerations.SubscriptionSearchModifier)((Object)v.getValue())).equals((Object)value)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("description", "markdown", "Description of how this filtering parameter is intended to be used.", 0, 1, this.description));
            children.add(new Property(SubscriptionTopic.SP_RESOURCE, "uri", "URL of the Resource that is the type used in this filter. This is the \"focus\" of the topic (or one of them if there are more than one). It will be the same, a generality, or a specificity of SubscriptionTopic.resourceTrigger.resource or SubscriptionTopic.eventTrigger.resource when they are present.", 0, 1, this.resource));
            children.add(new Property("filterParameter", "string", "Either the canonical URL to a search parameter (like \"http://hl7.org/fhir/SearchParameter/encounter-patient\") or topic-defined parameter (like \"hub.event\") which is a label for the filter.", 0, 1, this.filterParameter));
            children.add(new Property("filterDefinition", "uri", "Either the canonical URL to a search parameter (like \"http://hl7.org/fhir/SearchParameter/encounter-patient\") or the officially-defined URI for a shared filter concept (like \"http://example.org/concepts/shared-common-event\").", 0, 1, this.filterDefinition));
            children.add(new Property("modifier", "code", "Allowable operators to apply when determining matches (Search Modifiers).  If the filterParameter is a SearchParameter, this list of modifiers SHALL be a strict subset of the modifiers defined on that SearchParameter.", 0, Integer.MAX_VALUE, this.modifier));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property("description", "markdown", "Description of how this filtering parameter is intended to be used.", 0, 1, this.description);
                }
                case -341064690: {
                    return new Property(SubscriptionTopic.SP_RESOURCE, "uri", "URL of the Resource that is the type used in this filter. This is the \"focus\" of the topic (or one of them if there are more than one). It will be the same, a generality, or a specificity of SubscriptionTopic.resourceTrigger.resource or SubscriptionTopic.eventTrigger.resource when they are present.", 0, 1, this.resource);
                }
                case 618257: {
                    return new Property("filterParameter", "string", "Either the canonical URL to a search parameter (like \"http://hl7.org/fhir/SearchParameter/encounter-patient\") or topic-defined parameter (like \"hub.event\") which is a label for the filter.", 0, 1, this.filterParameter);
                }
                case -1453988117: {
                    return new Property("filterDefinition", "uri", "Either the canonical URL to a search parameter (like \"http://hl7.org/fhir/SearchParameter/encounter-patient\") or the officially-defined URI for a shared filter concept (like \"http://example.org/concepts/shared-common-event\").", 0, 1, this.filterDefinition);
                }
                case -615513385: {
                    return new Property("modifier", "code", "Allowable operators to apply when determining matches (Search Modifiers).  If the filterParameter is a SearchParameter, this list of modifiers SHALL be a strict subset of the modifiers defined on that SearchParameter.", 0, Integer.MAX_VALUE, this.modifier);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case -341064690: {
                    Base[] baseArray;
                    if (this.resource == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.resource;
                    }
                    return baseArray;
                }
                case 618257: {
                    Base[] baseArray;
                    if (this.filterParameter == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.filterParameter;
                    }
                    return baseArray;
                }
                case -1453988117: {
                    Base[] baseArray;
                    if (this.filterDefinition == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.filterDefinition;
                    }
                    return baseArray;
                }
                case -615513385: {
                    return this.modifier == null ? new Base[]{} : this.modifier.toArray(new Base[this.modifier.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case -341064690: {
                    this.resource = TypeConvertor.castToUri(value);
                    return value;
                }
                case 618257: {
                    this.filterParameter = TypeConvertor.castToString(value);
                    return value;
                }
                case -1453988117: {
                    this.filterDefinition = TypeConvertor.castToUri(value);
                    return value;
                }
                case -615513385: {
                    value = new Enumerations.SubscriptionSearchModifierEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.getModifier().add(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("description")) {
                this.description = TypeConvertor.castToMarkdown(value);
            } else if (name.equals(SubscriptionTopic.SP_RESOURCE)) {
                this.resource = TypeConvertor.castToUri(value);
            } else if (name.equals("filterParameter")) {
                this.filterParameter = TypeConvertor.castToString(value);
            } else if (name.equals("filterDefinition")) {
                this.filterDefinition = TypeConvertor.castToUri(value);
            } else if (name.equals("modifier")) {
                value = new Enumerations.SubscriptionSearchModifierEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.getModifier().add(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -341064690: {
                    return this.getResourceElement();
                }
                case 618257: {
                    return this.getFilterParameterElement();
                }
                case -1453988117: {
                    return this.getFilterDefinitionElement();
                }
                case -615513385: {
                    return this.addModifierElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"markdown"};
                }
                case -341064690: {
                    return new String[]{"uri"};
                }
                case 618257: {
                    return new String[]{"string"};
                }
                case -1453988117: {
                    return new String[]{"uri"};
                }
                case -615513385: {
                    return new String[]{"code"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.canFilterBy.description");
            }
            if (name.equals(SubscriptionTopic.SP_RESOURCE)) {
                throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.canFilterBy.resource");
            }
            if (name.equals("filterParameter")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.canFilterBy.filterParameter");
            }
            if (name.equals("filterDefinition")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.canFilterBy.filterDefinition");
            }
            if (name.equals("modifier")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.canFilterBy.modifier");
            }
            return super.addChild(name);
        }

        @Override
        public SubscriptionTopicCanFilterByComponent copy() {
            SubscriptionTopicCanFilterByComponent dst = new SubscriptionTopicCanFilterByComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubscriptionTopicCanFilterByComponent dst) {
            super.copyValues(dst);
            dst.description = this.description == null ? null : this.description.copy();
            dst.resource = this.resource == null ? null : this.resource.copy();
            dst.filterParameter = this.filterParameter == null ? null : this.filterParameter.copy();
            UriType uriType = dst.filterDefinition = this.filterDefinition == null ? null : this.filterDefinition.copy();
            if (this.modifier != null) {
                dst.modifier = new ArrayList<Enumeration<Enumerations.SubscriptionSearchModifier>>();
                for (Enumeration<Enumerations.SubscriptionSearchModifier> i : this.modifier) {
                    dst.modifier.add((Enumeration<Enumerations.SubscriptionSearchModifier>)i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubscriptionTopicCanFilterByComponent)) {
                return false;
            }
            SubscriptionTopicCanFilterByComponent o = (SubscriptionTopicCanFilterByComponent)other_;
            return SubscriptionTopicCanFilterByComponent.compareDeep(this.description, o.description, true) && SubscriptionTopicCanFilterByComponent.compareDeep(this.resource, o.resource, true) && SubscriptionTopicCanFilterByComponent.compareDeep(this.filterParameter, o.filterParameter, true) && SubscriptionTopicCanFilterByComponent.compareDeep(this.filterDefinition, o.filterDefinition, true) && SubscriptionTopicCanFilterByComponent.compareDeep(this.modifier, o.modifier, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubscriptionTopicCanFilterByComponent)) {
                return false;
            }
            SubscriptionTopicCanFilterByComponent o = (SubscriptionTopicCanFilterByComponent)other_;
            return SubscriptionTopicCanFilterByComponent.compareValues(this.description, o.description, true) && SubscriptionTopicCanFilterByComponent.compareValues(this.resource, o.resource, true) && SubscriptionTopicCanFilterByComponent.compareValues(this.filterParameter, o.filterParameter, true) && SubscriptionTopicCanFilterByComponent.compareValues(this.filterDefinition, o.filterDefinition, true) && SubscriptionTopicCanFilterByComponent.compareValues(this.modifier, o.modifier, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.description, this.resource, this.filterParameter, this.filterDefinition, this.modifier});
        }

        @Override
        public String fhirType() {
            return "SubscriptionTopic.canFilterBy";
        }
    }

    @Block
    public static class SubscriptionTopicEventTriggerComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={MarkdownType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Text representation of the event trigger", formalDefinition="The human readable description of an event to trigger a notification for the SubscriptionTopic - for example, \"Patient Admission, as defined in HL7v2 via message ADT^A01\". Multiple values are considered OR joined (e.g., matching any single event listed).")
        protected MarkdownType description;
        @Child(name="event", type={CodeableConcept.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Event which can trigger a notification from the SubscriptionTopic", formalDefinition="A well-defined event which can be used to trigger notifications from the SubscriptionTopic.")
        @Binding(valueSet="http://terminology.hl7.org/ValueSet/v2-0003")
        protected CodeableConcept event;
        @Child(name="resource", type={UriType.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Data Type or Resource (reference to definition) for this trigger definition", formalDefinition="URL of the Resource that is the focus type used in this event trigger.  Relative URLs are relative to the StructureDefinition root of the implemented FHIR version (e.g., http://hl7.org/fhir/StructureDefinition). For example, \"Patient\" maps to http://hl7.org/fhir/StructureDefinition/Patient.  For more information, see <a href=\"elementdefinition-definitions.html#ElementDefinition.type.code\">ElementDefinition.type.code</a>.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/fhir-types")
        protected UriType resource;
        private static final long serialVersionUID = 1818872110L;

        public SubscriptionTopicEventTriggerComponent() {
        }

        public SubscriptionTopicEventTriggerComponent(CodeableConcept event, String resource) {
            this.setEvent(event);
            this.setResource(resource);
        }

        public MarkdownType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionTopicEventTriggerComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new MarkdownType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public SubscriptionTopicEventTriggerComponent setDescriptionElement(MarkdownType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public SubscriptionTopicEventTriggerComponent setDescription(String value) {
            if (value == null) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new MarkdownType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public CodeableConcept getEvent() {
            if (this.event == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionTopicEventTriggerComponent.event");
                }
                if (Configuration.doAutoCreate()) {
                    this.event = new CodeableConcept();
                }
            }
            return this.event;
        }

        public boolean hasEvent() {
            return this.event != null && !this.event.isEmpty();
        }

        public SubscriptionTopicEventTriggerComponent setEvent(CodeableConcept value) {
            this.event = value;
            return this;
        }

        public UriType getResourceElement() {
            if (this.resource == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionTopicEventTriggerComponent.resource");
                }
                if (Configuration.doAutoCreate()) {
                    this.resource = new UriType();
                }
            }
            return this.resource;
        }

        public boolean hasResourceElement() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public boolean hasResource() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public SubscriptionTopicEventTriggerComponent setResourceElement(UriType value) {
            this.resource = value;
            return this;
        }

        public String getResource() {
            return this.resource == null ? null : (String)this.resource.getValue();
        }

        public SubscriptionTopicEventTriggerComponent setResource(String value) {
            if (this.resource == null) {
                this.resource = new UriType();
            }
            this.resource.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("description", "markdown", "The human readable description of an event to trigger a notification for the SubscriptionTopic - for example, \"Patient Admission, as defined in HL7v2 via message ADT^A01\". Multiple values are considered OR joined (e.g., matching any single event listed).", 0, 1, this.description));
            children.add(new Property("event", "CodeableConcept", "A well-defined event which can be used to trigger notifications from the SubscriptionTopic.", 0, 1, this.event));
            children.add(new Property(SubscriptionTopic.SP_RESOURCE, "uri", "URL of the Resource that is the focus type used in this event trigger.  Relative URLs are relative to the StructureDefinition root of the implemented FHIR version (e.g., http://hl7.org/fhir/StructureDefinition). For example, \"Patient\" maps to http://hl7.org/fhir/StructureDefinition/Patient.  For more information, see <a href=\"elementdefinition-definitions.html#ElementDefinition.type.code\">ElementDefinition.type.code</a>.", 0, 1, this.resource));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property("description", "markdown", "The human readable description of an event to trigger a notification for the SubscriptionTopic - for example, \"Patient Admission, as defined in HL7v2 via message ADT^A01\". Multiple values are considered OR joined (e.g., matching any single event listed).", 0, 1, this.description);
                }
                case 96891546: {
                    return new Property("event", "CodeableConcept", "A well-defined event which can be used to trigger notifications from the SubscriptionTopic.", 0, 1, this.event);
                }
                case -341064690: {
                    return new Property(SubscriptionTopic.SP_RESOURCE, "uri", "URL of the Resource that is the focus type used in this event trigger.  Relative URLs are relative to the StructureDefinition root of the implemented FHIR version (e.g., http://hl7.org/fhir/StructureDefinition). For example, \"Patient\" maps to http://hl7.org/fhir/StructureDefinition/Patient.  For more information, see <a href=\"elementdefinition-definitions.html#ElementDefinition.type.code\">ElementDefinition.type.code</a>.", 0, 1, this.resource);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case 96891546: {
                    Base[] baseArray;
                    if (this.event == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.event;
                    }
                    return baseArray;
                }
                case -341064690: {
                    Base[] baseArray;
                    if (this.resource == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.resource;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case 96891546: {
                    this.event = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -341064690: {
                    this.resource = TypeConvertor.castToUri(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("description")) {
                this.description = TypeConvertor.castToMarkdown(value);
            } else if (name.equals("event")) {
                this.event = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals(SubscriptionTopic.SP_RESOURCE)) {
                this.resource = TypeConvertor.castToUri(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 96891546: {
                    return this.getEvent();
                }
                case -341064690: {
                    return this.getResourceElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"markdown"};
                }
                case 96891546: {
                    return new String[]{"CodeableConcept"};
                }
                case -341064690: {
                    return new String[]{"uri"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.eventTrigger.description");
            }
            if (name.equals("event")) {
                this.event = new CodeableConcept();
                return this.event;
            }
            if (name.equals(SubscriptionTopic.SP_RESOURCE)) {
                throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.eventTrigger.resource");
            }
            return super.addChild(name);
        }

        @Override
        public SubscriptionTopicEventTriggerComponent copy() {
            SubscriptionTopicEventTriggerComponent dst = new SubscriptionTopicEventTriggerComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubscriptionTopicEventTriggerComponent dst) {
            super.copyValues(dst);
            dst.description = this.description == null ? null : this.description.copy();
            dst.event = this.event == null ? null : this.event.copy();
            dst.resource = this.resource == null ? null : this.resource.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubscriptionTopicEventTriggerComponent)) {
                return false;
            }
            SubscriptionTopicEventTriggerComponent o = (SubscriptionTopicEventTriggerComponent)other_;
            return SubscriptionTopicEventTriggerComponent.compareDeep(this.description, o.description, true) && SubscriptionTopicEventTriggerComponent.compareDeep(this.event, o.event, true) && SubscriptionTopicEventTriggerComponent.compareDeep(this.resource, o.resource, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubscriptionTopicEventTriggerComponent)) {
                return false;
            }
            SubscriptionTopicEventTriggerComponent o = (SubscriptionTopicEventTriggerComponent)other_;
            return SubscriptionTopicEventTriggerComponent.compareValues(this.description, o.description, true) && SubscriptionTopicEventTriggerComponent.compareValues(this.resource, o.resource, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.description, this.event, this.resource});
        }

        @Override
        public String fhirType() {
            return "SubscriptionTopic.eventTrigger";
        }
    }

    @Block
    public static class SubscriptionTopicResourceTriggerQueryCriteriaComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="previous", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Rule applied to previous resource state", formalDefinition="The FHIR query based rules are applied to the previous resource state (e.g., state before an update).")
        protected StringType previous;
        @Child(name="resultForCreate", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="test-passes | test-fails", formalDefinition="For \"create\" interactions, should the \"previous\" criteria count as an automatic pass or an automatic fail.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/subscriptiontopic-cr-behavior")
        protected Enumeration<CriteriaNotExistsBehavior> resultForCreate;
        @Child(name="current", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Rule applied to current resource state", formalDefinition="The FHIR query based rules are applied to the current resource state (e.g., state after an update).")
        protected StringType current;
        @Child(name="resultForDelete", type={CodeType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="test-passes | test-fails", formalDefinition="For \"delete\" interactions, should the \"current\" criteria count as an automatic pass or an automatic fail.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/subscriptiontopic-cr-behavior")
        protected Enumeration<CriteriaNotExistsBehavior> resultForDelete;
        @Child(name="requireBoth", type={BooleanType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Both must be true flag", formalDefinition="If set to true, both current and previous criteria must evaluate true to  trigger a notification for this topic.  Otherwise a notification for this topic will be triggered if either one evaluates to true.")
        protected BooleanType requireBoth;
        private static final long serialVersionUID = -291746067L;

        public StringType getPreviousElement() {
            if (this.previous == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionTopicResourceTriggerQueryCriteriaComponent.previous");
                }
                if (Configuration.doAutoCreate()) {
                    this.previous = new StringType();
                }
            }
            return this.previous;
        }

        public boolean hasPreviousElement() {
            return this.previous != null && !this.previous.isEmpty();
        }

        public boolean hasPrevious() {
            return this.previous != null && !this.previous.isEmpty();
        }

        public SubscriptionTopicResourceTriggerQueryCriteriaComponent setPreviousElement(StringType value) {
            this.previous = value;
            return this;
        }

        public String getPrevious() {
            return this.previous == null ? null : (String)this.previous.getValue();
        }

        public SubscriptionTopicResourceTriggerQueryCriteriaComponent setPrevious(String value) {
            if (Utilities.noString((String)value)) {
                this.previous = null;
            } else {
                if (this.previous == null) {
                    this.previous = new StringType();
                }
                this.previous.setValue(value);
            }
            return this;
        }

        public Enumeration<CriteriaNotExistsBehavior> getResultForCreateElement() {
            if (this.resultForCreate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionTopicResourceTriggerQueryCriteriaComponent.resultForCreate");
                }
                if (Configuration.doAutoCreate()) {
                    this.resultForCreate = new Enumeration<CriteriaNotExistsBehavior>(new CriteriaNotExistsBehaviorEnumFactory());
                }
            }
            return this.resultForCreate;
        }

        public boolean hasResultForCreateElement() {
            return this.resultForCreate != null && !this.resultForCreate.isEmpty();
        }

        public boolean hasResultForCreate() {
            return this.resultForCreate != null && !this.resultForCreate.isEmpty();
        }

        public SubscriptionTopicResourceTriggerQueryCriteriaComponent setResultForCreateElement(Enumeration<CriteriaNotExistsBehavior> value) {
            this.resultForCreate = value;
            return this;
        }

        public CriteriaNotExistsBehavior getResultForCreate() {
            return this.resultForCreate == null ? null : (CriteriaNotExistsBehavior)((Object)this.resultForCreate.getValue());
        }

        public SubscriptionTopicResourceTriggerQueryCriteriaComponent setResultForCreate(CriteriaNotExistsBehavior value) {
            if (value == null) {
                this.resultForCreate = null;
            } else {
                if (this.resultForCreate == null) {
                    this.resultForCreate = new Enumeration<CriteriaNotExistsBehavior>(new CriteriaNotExistsBehaviorEnumFactory());
                }
                this.resultForCreate.setValue((Object)value);
            }
            return this;
        }

        public StringType getCurrentElement() {
            if (this.current == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionTopicResourceTriggerQueryCriteriaComponent.current");
                }
                if (Configuration.doAutoCreate()) {
                    this.current = new StringType();
                }
            }
            return this.current;
        }

        public boolean hasCurrentElement() {
            return this.current != null && !this.current.isEmpty();
        }

        public boolean hasCurrent() {
            return this.current != null && !this.current.isEmpty();
        }

        public SubscriptionTopicResourceTriggerQueryCriteriaComponent setCurrentElement(StringType value) {
            this.current = value;
            return this;
        }

        public String getCurrent() {
            return this.current == null ? null : (String)this.current.getValue();
        }

        public SubscriptionTopicResourceTriggerQueryCriteriaComponent setCurrent(String value) {
            if (Utilities.noString((String)value)) {
                this.current = null;
            } else {
                if (this.current == null) {
                    this.current = new StringType();
                }
                this.current.setValue(value);
            }
            return this;
        }

        public Enumeration<CriteriaNotExistsBehavior> getResultForDeleteElement() {
            if (this.resultForDelete == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionTopicResourceTriggerQueryCriteriaComponent.resultForDelete");
                }
                if (Configuration.doAutoCreate()) {
                    this.resultForDelete = new Enumeration<CriteriaNotExistsBehavior>(new CriteriaNotExistsBehaviorEnumFactory());
                }
            }
            return this.resultForDelete;
        }

        public boolean hasResultForDeleteElement() {
            return this.resultForDelete != null && !this.resultForDelete.isEmpty();
        }

        public boolean hasResultForDelete() {
            return this.resultForDelete != null && !this.resultForDelete.isEmpty();
        }

        public SubscriptionTopicResourceTriggerQueryCriteriaComponent setResultForDeleteElement(Enumeration<CriteriaNotExistsBehavior> value) {
            this.resultForDelete = value;
            return this;
        }

        public CriteriaNotExistsBehavior getResultForDelete() {
            return this.resultForDelete == null ? null : (CriteriaNotExistsBehavior)((Object)this.resultForDelete.getValue());
        }

        public SubscriptionTopicResourceTriggerQueryCriteriaComponent setResultForDelete(CriteriaNotExistsBehavior value) {
            if (value == null) {
                this.resultForDelete = null;
            } else {
                if (this.resultForDelete == null) {
                    this.resultForDelete = new Enumeration<CriteriaNotExistsBehavior>(new CriteriaNotExistsBehaviorEnumFactory());
                }
                this.resultForDelete.setValue((Object)value);
            }
            return this;
        }

        public BooleanType getRequireBothElement() {
            if (this.requireBoth == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionTopicResourceTriggerQueryCriteriaComponent.requireBoth");
                }
                if (Configuration.doAutoCreate()) {
                    this.requireBoth = new BooleanType();
                }
            }
            return this.requireBoth;
        }

        public boolean hasRequireBothElement() {
            return this.requireBoth != null && !this.requireBoth.isEmpty();
        }

        public boolean hasRequireBoth() {
            return this.requireBoth != null && !this.requireBoth.isEmpty();
        }

        public SubscriptionTopicResourceTriggerQueryCriteriaComponent setRequireBothElement(BooleanType value) {
            this.requireBoth = value;
            return this;
        }

        public boolean getRequireBoth() {
            return this.requireBoth == null || this.requireBoth.isEmpty() ? false : (Boolean)this.requireBoth.getValue();
        }

        public SubscriptionTopicResourceTriggerQueryCriteriaComponent setRequireBoth(boolean value) {
            if (this.requireBoth == null) {
                this.requireBoth = new BooleanType();
            }
            this.requireBoth.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("previous", "string", "The FHIR query based rules are applied to the previous resource state (e.g., state before an update).", 0, 1, this.previous));
            children.add(new Property("resultForCreate", "code", "For \"create\" interactions, should the \"previous\" criteria count as an automatic pass or an automatic fail.", 0, 1, this.resultForCreate));
            children.add(new Property("current", "string", "The FHIR query based rules are applied to the current resource state (e.g., state after an update).", 0, 1, this.current));
            children.add(new Property("resultForDelete", "code", "For \"delete\" interactions, should the \"current\" criteria count as an automatic pass or an automatic fail.", 0, 1, this.resultForDelete));
            children.add(new Property("requireBoth", "boolean", "If set to true, both current and previous criteria must evaluate true to  trigger a notification for this topic.  Otherwise a notification for this topic will be triggered if either one evaluates to true.", 0, 1, this.requireBoth));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1273775369: {
                    return new Property("previous", "string", "The FHIR query based rules are applied to the previous resource state (e.g., state before an update).", 0, 1, this.previous);
                }
                case -407976056: {
                    return new Property("resultForCreate", "code", "For \"create\" interactions, should the \"previous\" criteria count as an automatic pass or an automatic fail.", 0, 1, this.resultForCreate);
                }
                case 1126940025: {
                    return new Property("current", "string", "The FHIR query based rules are applied to the current resource state (e.g., state after an update).", 0, 1, this.current);
                }
                case -391140297: {
                    return new Property("resultForDelete", "code", "For \"delete\" interactions, should the \"current\" criteria count as an automatic pass or an automatic fail.", 0, 1, this.resultForDelete);
                }
                case 362116742: {
                    return new Property("requireBoth", "boolean", "If set to true, both current and previous criteria must evaluate true to  trigger a notification for this topic.  Otherwise a notification for this topic will be triggered if either one evaluates to true.", 0, 1, this.requireBoth);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1273775369: {
                    Base[] baseArray;
                    if (this.previous == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.previous;
                    }
                    return baseArray;
                }
                case -407976056: {
                    Base[] baseArray;
                    if (this.resultForCreate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.resultForCreate;
                    }
                    return baseArray;
                }
                case 1126940025: {
                    Base[] baseArray;
                    if (this.current == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.current;
                    }
                    return baseArray;
                }
                case -391140297: {
                    Base[] baseArray;
                    if (this.resultForDelete == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.resultForDelete;
                    }
                    return baseArray;
                }
                case 362116742: {
                    Base[] baseArray;
                    if (this.requireBoth == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.requireBoth;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1273775369: {
                    this.previous = TypeConvertor.castToString(value);
                    return value;
                }
                case -407976056: {
                    value = new CriteriaNotExistsBehaviorEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.resultForCreate = value;
                    return value;
                }
                case 1126940025: {
                    this.current = TypeConvertor.castToString(value);
                    return value;
                }
                case -391140297: {
                    value = new CriteriaNotExistsBehaviorEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.resultForDelete = value;
                    return value;
                }
                case 362116742: {
                    this.requireBoth = TypeConvertor.castToBoolean(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("previous")) {
                this.previous = TypeConvertor.castToString(value);
            } else if (name.equals("resultForCreate")) {
                value = new CriteriaNotExistsBehaviorEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.resultForCreate = value;
            } else if (name.equals("current")) {
                this.current = TypeConvertor.castToString(value);
            } else if (name.equals("resultForDelete")) {
                value = new CriteriaNotExistsBehaviorEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.resultForDelete = value;
            } else if (name.equals("requireBoth")) {
                this.requireBoth = TypeConvertor.castToBoolean(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1273775369: {
                    return this.getPreviousElement();
                }
                case -407976056: {
                    return this.getResultForCreateElement();
                }
                case 1126940025: {
                    return this.getCurrentElement();
                }
                case -391140297: {
                    return this.getResultForDeleteElement();
                }
                case 362116742: {
                    return this.getRequireBothElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1273775369: {
                    return new String[]{"string"};
                }
                case -407976056: {
                    return new String[]{"code"};
                }
                case 1126940025: {
                    return new String[]{"string"};
                }
                case -391140297: {
                    return new String[]{"code"};
                }
                case 362116742: {
                    return new String[]{"boolean"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("previous")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.resourceTrigger.queryCriteria.previous");
            }
            if (name.equals("resultForCreate")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.resourceTrigger.queryCriteria.resultForCreate");
            }
            if (name.equals("current")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.resourceTrigger.queryCriteria.current");
            }
            if (name.equals("resultForDelete")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.resourceTrigger.queryCriteria.resultForDelete");
            }
            if (name.equals("requireBoth")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.resourceTrigger.queryCriteria.requireBoth");
            }
            return super.addChild(name);
        }

        @Override
        public SubscriptionTopicResourceTriggerQueryCriteriaComponent copy() {
            SubscriptionTopicResourceTriggerQueryCriteriaComponent dst = new SubscriptionTopicResourceTriggerQueryCriteriaComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubscriptionTopicResourceTriggerQueryCriteriaComponent dst) {
            super.copyValues(dst);
            dst.previous = this.previous == null ? null : this.previous.copy();
            dst.resultForCreate = this.resultForCreate == null ? null : this.resultForCreate.copy();
            dst.current = this.current == null ? null : this.current.copy();
            dst.resultForDelete = this.resultForDelete == null ? null : this.resultForDelete.copy();
            dst.requireBoth = this.requireBoth == null ? null : this.requireBoth.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubscriptionTopicResourceTriggerQueryCriteriaComponent)) {
                return false;
            }
            SubscriptionTopicResourceTriggerQueryCriteriaComponent o = (SubscriptionTopicResourceTriggerQueryCriteriaComponent)other_;
            return SubscriptionTopicResourceTriggerQueryCriteriaComponent.compareDeep(this.previous, o.previous, true) && SubscriptionTopicResourceTriggerQueryCriteriaComponent.compareDeep(this.resultForCreate, o.resultForCreate, true) && SubscriptionTopicResourceTriggerQueryCriteriaComponent.compareDeep(this.current, o.current, true) && SubscriptionTopicResourceTriggerQueryCriteriaComponent.compareDeep(this.resultForDelete, o.resultForDelete, true) && SubscriptionTopicResourceTriggerQueryCriteriaComponent.compareDeep(this.requireBoth, o.requireBoth, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubscriptionTopicResourceTriggerQueryCriteriaComponent)) {
                return false;
            }
            SubscriptionTopicResourceTriggerQueryCriteriaComponent o = (SubscriptionTopicResourceTriggerQueryCriteriaComponent)other_;
            return SubscriptionTopicResourceTriggerQueryCriteriaComponent.compareValues(this.previous, o.previous, true) && SubscriptionTopicResourceTriggerQueryCriteriaComponent.compareValues(this.resultForCreate, o.resultForCreate, true) && SubscriptionTopicResourceTriggerQueryCriteriaComponent.compareValues(this.current, o.current, true) && SubscriptionTopicResourceTriggerQueryCriteriaComponent.compareValues(this.resultForDelete, o.resultForDelete, true) && SubscriptionTopicResourceTriggerQueryCriteriaComponent.compareValues(this.requireBoth, o.requireBoth, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.previous, this.resultForCreate, this.current, this.resultForDelete, this.requireBoth});
        }

        @Override
        public String fhirType() {
            return "SubscriptionTopic.resourceTrigger.queryCriteria";
        }
    }

    @Block
    public static class SubscriptionTopicResourceTriggerComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={MarkdownType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Text representation of the resource trigger", formalDefinition="The human readable description of this resource trigger for the SubscriptionTopic -  for example, \"An Encounter enters the 'in-progress' state\".")
        protected MarkdownType description;
        @Child(name="resource", type={UriType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Data Type or Resource (reference to definition) for this trigger definition", formalDefinition="URL of the Resource that is the type used in this resource trigger.  Relative URLs are relative to the StructureDefinition root of the implemented FHIR version (e.g., http://hl7.org/fhir/StructureDefinition). For example, \"Patient\" maps to http://hl7.org/fhir/StructureDefinition/Patient.  For more information, see <a href=\"elementdefinition-definitions.html#ElementDefinition.type.code\">ElementDefinition.type.code</a>.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/fhir-types")
        protected UriType resource;
        @Child(name="supportedInteraction", type={CodeType.class}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="create | update | delete", formalDefinition="The FHIR RESTful interaction which can be used to trigger a notification for the SubscriptionTopic. Multiple values are considered OR joined (e.g., CREATE or UPDATE).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/interaction-trigger")
        protected List<Enumeration<InteractionTrigger>> supportedInteraction;
        @Child(name="queryCriteria", type={}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Query based trigger rule", formalDefinition="The FHIR query based rules that the server should use to determine when to trigger a notification for this subscription topic.")
        protected SubscriptionTopicResourceTriggerQueryCriteriaComponent queryCriteria;
        @Child(name="fhirPathCriteria", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="FHIRPath based trigger rule", formalDefinition="The FHIRPath based rules that the server should use to determine when to trigger a notification for this topic.")
        protected StringType fhirPathCriteria;
        private static final long serialVersionUID = -1086940999L;

        public SubscriptionTopicResourceTriggerComponent() {
        }

        public SubscriptionTopicResourceTriggerComponent(String resource) {
            this.setResource(resource);
        }

        public MarkdownType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionTopicResourceTriggerComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new MarkdownType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public SubscriptionTopicResourceTriggerComponent setDescriptionElement(MarkdownType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public SubscriptionTopicResourceTriggerComponent setDescription(String value) {
            if (value == null) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new MarkdownType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public UriType getResourceElement() {
            if (this.resource == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionTopicResourceTriggerComponent.resource");
                }
                if (Configuration.doAutoCreate()) {
                    this.resource = new UriType();
                }
            }
            return this.resource;
        }

        public boolean hasResourceElement() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public boolean hasResource() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public SubscriptionTopicResourceTriggerComponent setResourceElement(UriType value) {
            this.resource = value;
            return this;
        }

        public String getResource() {
            return this.resource == null ? null : (String)this.resource.getValue();
        }

        public SubscriptionTopicResourceTriggerComponent setResource(String value) {
            if (this.resource == null) {
                this.resource = new UriType();
            }
            this.resource.setValue(value);
            return this;
        }

        public List<Enumeration<InteractionTrigger>> getSupportedInteraction() {
            if (this.supportedInteraction == null) {
                this.supportedInteraction = new ArrayList<Enumeration<InteractionTrigger>>();
            }
            return this.supportedInteraction;
        }

        public SubscriptionTopicResourceTriggerComponent setSupportedInteraction(List<Enumeration<InteractionTrigger>> theSupportedInteraction) {
            this.supportedInteraction = theSupportedInteraction;
            return this;
        }

        public boolean hasSupportedInteraction() {
            if (this.supportedInteraction == null) {
                return false;
            }
            for (Enumeration<InteractionTrigger> item : this.supportedInteraction) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Enumeration<InteractionTrigger> addSupportedInteractionElement() {
            Enumeration<InteractionTrigger> t = new Enumeration<InteractionTrigger>(new InteractionTriggerEnumFactory());
            if (this.supportedInteraction == null) {
                this.supportedInteraction = new ArrayList<Enumeration<InteractionTrigger>>();
            }
            this.supportedInteraction.add(t);
            return t;
        }

        public SubscriptionTopicResourceTriggerComponent addSupportedInteraction(InteractionTrigger value) {
            Enumeration<InteractionTrigger> t = new Enumeration<InteractionTrigger>(new InteractionTriggerEnumFactory());
            t.setValue((Object)value);
            if (this.supportedInteraction == null) {
                this.supportedInteraction = new ArrayList<Enumeration<InteractionTrigger>>();
            }
            this.supportedInteraction.add(t);
            return this;
        }

        public boolean hasSupportedInteraction(InteractionTrigger value) {
            if (this.supportedInteraction == null) {
                return false;
            }
            for (Enumeration<InteractionTrigger> v : this.supportedInteraction) {
                if (!((InteractionTrigger)((Object)v.getValue())).equals((Object)value)) continue;
                return true;
            }
            return false;
        }

        public SubscriptionTopicResourceTriggerQueryCriteriaComponent getQueryCriteria() {
            if (this.queryCriteria == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionTopicResourceTriggerComponent.queryCriteria");
                }
                if (Configuration.doAutoCreate()) {
                    this.queryCriteria = new SubscriptionTopicResourceTriggerQueryCriteriaComponent();
                }
            }
            return this.queryCriteria;
        }

        public boolean hasQueryCriteria() {
            return this.queryCriteria != null && !this.queryCriteria.isEmpty();
        }

        public SubscriptionTopicResourceTriggerComponent setQueryCriteria(SubscriptionTopicResourceTriggerQueryCriteriaComponent value) {
            this.queryCriteria = value;
            return this;
        }

        public StringType getFhirPathCriteriaElement() {
            if (this.fhirPathCriteria == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubscriptionTopicResourceTriggerComponent.fhirPathCriteria");
                }
                if (Configuration.doAutoCreate()) {
                    this.fhirPathCriteria = new StringType();
                }
            }
            return this.fhirPathCriteria;
        }

        public boolean hasFhirPathCriteriaElement() {
            return this.fhirPathCriteria != null && !this.fhirPathCriteria.isEmpty();
        }

        public boolean hasFhirPathCriteria() {
            return this.fhirPathCriteria != null && !this.fhirPathCriteria.isEmpty();
        }

        public SubscriptionTopicResourceTriggerComponent setFhirPathCriteriaElement(StringType value) {
            this.fhirPathCriteria = value;
            return this;
        }

        public String getFhirPathCriteria() {
            return this.fhirPathCriteria == null ? null : (String)this.fhirPathCriteria.getValue();
        }

        public SubscriptionTopicResourceTriggerComponent setFhirPathCriteria(String value) {
            if (Utilities.noString((String)value)) {
                this.fhirPathCriteria = null;
            } else {
                if (this.fhirPathCriteria == null) {
                    this.fhirPathCriteria = new StringType();
                }
                this.fhirPathCriteria.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("description", "markdown", "The human readable description of this resource trigger for the SubscriptionTopic -  for example, \"An Encounter enters the 'in-progress' state\".", 0, 1, this.description));
            children.add(new Property(SubscriptionTopic.SP_RESOURCE, "uri", "URL of the Resource that is the type used in this resource trigger.  Relative URLs are relative to the StructureDefinition root of the implemented FHIR version (e.g., http://hl7.org/fhir/StructureDefinition). For example, \"Patient\" maps to http://hl7.org/fhir/StructureDefinition/Patient.  For more information, see <a href=\"elementdefinition-definitions.html#ElementDefinition.type.code\">ElementDefinition.type.code</a>.", 0, 1, this.resource));
            children.add(new Property("supportedInteraction", "code", "The FHIR RESTful interaction which can be used to trigger a notification for the SubscriptionTopic. Multiple values are considered OR joined (e.g., CREATE or UPDATE).", 0, Integer.MAX_VALUE, this.supportedInteraction));
            children.add(new Property("queryCriteria", "", "The FHIR query based rules that the server should use to determine when to trigger a notification for this subscription topic.", 0, 1, this.queryCriteria));
            children.add(new Property("fhirPathCriteria", "string", "The FHIRPath based rules that the server should use to determine when to trigger a notification for this topic.", 0, 1, this.fhirPathCriteria));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property("description", "markdown", "The human readable description of this resource trigger for the SubscriptionTopic -  for example, \"An Encounter enters the 'in-progress' state\".", 0, 1, this.description);
                }
                case -341064690: {
                    return new Property(SubscriptionTopic.SP_RESOURCE, "uri", "URL of the Resource that is the type used in this resource trigger.  Relative URLs are relative to the StructureDefinition root of the implemented FHIR version (e.g., http://hl7.org/fhir/StructureDefinition). For example, \"Patient\" maps to http://hl7.org/fhir/StructureDefinition/Patient.  For more information, see <a href=\"elementdefinition-definitions.html#ElementDefinition.type.code\">ElementDefinition.type.code</a>.", 0, 1, this.resource);
                }
                case 1838450820: {
                    return new Property("supportedInteraction", "code", "The FHIR RESTful interaction which can be used to trigger a notification for the SubscriptionTopic. Multiple values are considered OR joined (e.g., CREATE or UPDATE).", 0, Integer.MAX_VALUE, this.supportedInteraction);
                }
                case -545123257: {
                    return new Property("queryCriteria", "", "The FHIR query based rules that the server should use to determine when to trigger a notification for this subscription topic.", 0, 1, this.queryCriteria);
                }
                case 1929785263: {
                    return new Property("fhirPathCriteria", "string", "The FHIRPath based rules that the server should use to determine when to trigger a notification for this topic.", 0, 1, this.fhirPathCriteria);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case -341064690: {
                    Base[] baseArray;
                    if (this.resource == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.resource;
                    }
                    return baseArray;
                }
                case 1838450820: {
                    return this.supportedInteraction == null ? new Base[]{} : this.supportedInteraction.toArray(new Base[this.supportedInteraction.size()]);
                }
                case -545123257: {
                    Base[] baseArray;
                    if (this.queryCriteria == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.queryCriteria;
                    }
                    return baseArray;
                }
                case 1929785263: {
                    Base[] baseArray;
                    if (this.fhirPathCriteria == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.fhirPathCriteria;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case -341064690: {
                    this.resource = TypeConvertor.castToUri(value);
                    return value;
                }
                case 1838450820: {
                    value = new InteractionTriggerEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.getSupportedInteraction().add(value);
                    return value;
                }
                case -545123257: {
                    this.queryCriteria = (SubscriptionTopicResourceTriggerQueryCriteriaComponent)((Object)value);
                    return value;
                }
                case 1929785263: {
                    this.fhirPathCriteria = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("description")) {
                this.description = TypeConvertor.castToMarkdown(value);
            } else if (name.equals(SubscriptionTopic.SP_RESOURCE)) {
                this.resource = TypeConvertor.castToUri(value);
            } else if (name.equals("supportedInteraction")) {
                value = new InteractionTriggerEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.getSupportedInteraction().add(value);
            } else if (name.equals("queryCriteria")) {
                this.queryCriteria = (SubscriptionTopicResourceTriggerQueryCriteriaComponent)((Object)value);
            } else if (name.equals("fhirPathCriteria")) {
                this.fhirPathCriteria = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -341064690: {
                    return this.getResourceElement();
                }
                case 1838450820: {
                    return this.addSupportedInteractionElement();
                }
                case -545123257: {
                    return this.getQueryCriteria();
                }
                case 1929785263: {
                    return this.getFhirPathCriteriaElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"markdown"};
                }
                case -341064690: {
                    return new String[]{"uri"};
                }
                case 1838450820: {
                    return new String[]{"code"};
                }
                case -545123257: {
                    return new String[0];
                }
                case 1929785263: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.resourceTrigger.description");
            }
            if (name.equals(SubscriptionTopic.SP_RESOURCE)) {
                throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.resourceTrigger.resource");
            }
            if (name.equals("supportedInteraction")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.resourceTrigger.supportedInteraction");
            }
            if (name.equals("queryCriteria")) {
                this.queryCriteria = new SubscriptionTopicResourceTriggerQueryCriteriaComponent();
                return this.queryCriteria;
            }
            if (name.equals("fhirPathCriteria")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubscriptionTopic.resourceTrigger.fhirPathCriteria");
            }
            return super.addChild(name);
        }

        @Override
        public SubscriptionTopicResourceTriggerComponent copy() {
            SubscriptionTopicResourceTriggerComponent dst = new SubscriptionTopicResourceTriggerComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubscriptionTopicResourceTriggerComponent dst) {
            super.copyValues(dst);
            dst.description = this.description == null ? null : this.description.copy();
            UriType uriType = dst.resource = this.resource == null ? null : this.resource.copy();
            if (this.supportedInteraction != null) {
                dst.supportedInteraction = new ArrayList<Enumeration<InteractionTrigger>>();
                for (Enumeration<InteractionTrigger> i : this.supportedInteraction) {
                    dst.supportedInteraction.add((Enumeration<InteractionTrigger>)i.copy());
                }
            }
            dst.queryCriteria = this.queryCriteria == null ? null : this.queryCriteria.copy();
            dst.fhirPathCriteria = this.fhirPathCriteria == null ? null : this.fhirPathCriteria.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubscriptionTopicResourceTriggerComponent)) {
                return false;
            }
            SubscriptionTopicResourceTriggerComponent o = (SubscriptionTopicResourceTriggerComponent)other_;
            return SubscriptionTopicResourceTriggerComponent.compareDeep(this.description, o.description, true) && SubscriptionTopicResourceTriggerComponent.compareDeep(this.resource, o.resource, true) && SubscriptionTopicResourceTriggerComponent.compareDeep(this.supportedInteraction, o.supportedInteraction, true) && SubscriptionTopicResourceTriggerComponent.compareDeep(this.queryCriteria, o.queryCriteria, true) && SubscriptionTopicResourceTriggerComponent.compareDeep(this.fhirPathCriteria, o.fhirPathCriteria, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubscriptionTopicResourceTriggerComponent)) {
                return false;
            }
            SubscriptionTopicResourceTriggerComponent o = (SubscriptionTopicResourceTriggerComponent)other_;
            return SubscriptionTopicResourceTriggerComponent.compareValues(this.description, o.description, true) && SubscriptionTopicResourceTriggerComponent.compareValues(this.resource, o.resource, true) && SubscriptionTopicResourceTriggerComponent.compareValues(this.supportedInteraction, o.supportedInteraction, true) && SubscriptionTopicResourceTriggerComponent.compareValues(this.fhirPathCriteria, o.fhirPathCriteria, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.description, this.resource, this.supportedInteraction, this.queryCriteria, this.fhirPathCriteria});
        }

        @Override
        public String fhirType() {
            return "SubscriptionTopic.resourceTrigger";
        }
    }

    public static class InteractionTriggerEnumFactory
    implements EnumFactory<InteractionTrigger> {
        @Override
        public InteractionTrigger fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("create".equals(codeString)) {
                return InteractionTrigger.CREATE;
            }
            if ("update".equals(codeString)) {
                return InteractionTrigger.UPDATE;
            }
            if ("delete".equals(codeString)) {
                return InteractionTrigger.DELETE;
            }
            throw new IllegalArgumentException("Unknown InteractionTrigger code '" + codeString + "'");
        }

        public Enumeration<InteractionTrigger> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<InteractionTrigger>(this, InteractionTrigger.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<InteractionTrigger>(this, InteractionTrigger.NULL, code);
            }
            if ("create".equals(codeString)) {
                return new Enumeration<InteractionTrigger>(this, InteractionTrigger.CREATE, code);
            }
            if ("update".equals(codeString)) {
                return new Enumeration<InteractionTrigger>(this, InteractionTrigger.UPDATE, code);
            }
            if ("delete".equals(codeString)) {
                return new Enumeration<InteractionTrigger>(this, InteractionTrigger.DELETE, code);
            }
            throw new FHIRException("Unknown InteractionTrigger code '" + codeString + "'");
        }

        @Override
        public String toCode(InteractionTrigger code) {
            if (code == InteractionTrigger.CREATE) {
                return "create";
            }
            if (code == InteractionTrigger.UPDATE) {
                return "update";
            }
            if (code == InteractionTrigger.DELETE) {
                return "delete";
            }
            return "?";
        }

        @Override
        public String toSystem(InteractionTrigger code) {
            return code.getSystem();
        }
    }

    public static enum InteractionTrigger {
        CREATE,
        UPDATE,
        DELETE,
        NULL;


        public static InteractionTrigger fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("create".equals(codeString)) {
                return CREATE;
            }
            if ("update".equals(codeString)) {
                return UPDATE;
            }
            if ("delete".equals(codeString)) {
                return DELETE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown InteractionTrigger code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case CREATE: {
                    return "create";
                }
                case UPDATE: {
                    return "update";
                }
                case DELETE: {
                    return "delete";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case CREATE: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
                case UPDATE: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
                case DELETE: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case CREATE: {
                    return "Create a new resource with a server assigned id.";
                }
                case UPDATE: {
                    return "Update an existing resource by its id (or create it if it is new).";
                }
                case DELETE: {
                    return "Delete a resource.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case CREATE: {
                    return "create";
                }
                case UPDATE: {
                    return "update";
                }
                case DELETE: {
                    return "delete";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class CriteriaNotExistsBehaviorEnumFactory
    implements EnumFactory<CriteriaNotExistsBehavior> {
        @Override
        public CriteriaNotExistsBehavior fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("test-passes".equals(codeString)) {
                return CriteriaNotExistsBehavior.TESTPASSES;
            }
            if ("test-fails".equals(codeString)) {
                return CriteriaNotExistsBehavior.TESTFAILS;
            }
            throw new IllegalArgumentException("Unknown CriteriaNotExistsBehavior code '" + codeString + "'");
        }

        public Enumeration<CriteriaNotExistsBehavior> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<CriteriaNotExistsBehavior>(this, CriteriaNotExistsBehavior.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<CriteriaNotExistsBehavior>(this, CriteriaNotExistsBehavior.NULL, code);
            }
            if ("test-passes".equals(codeString)) {
                return new Enumeration<CriteriaNotExistsBehavior>(this, CriteriaNotExistsBehavior.TESTPASSES, code);
            }
            if ("test-fails".equals(codeString)) {
                return new Enumeration<CriteriaNotExistsBehavior>(this, CriteriaNotExistsBehavior.TESTFAILS, code);
            }
            throw new FHIRException("Unknown CriteriaNotExistsBehavior code '" + codeString + "'");
        }

        @Override
        public String toCode(CriteriaNotExistsBehavior code) {
            if (code == CriteriaNotExistsBehavior.TESTPASSES) {
                return "test-passes";
            }
            if (code == CriteriaNotExistsBehavior.TESTFAILS) {
                return "test-fails";
            }
            return "?";
        }

        @Override
        public String toSystem(CriteriaNotExistsBehavior code) {
            return code.getSystem();
        }
    }

    public static enum CriteriaNotExistsBehavior {
        TESTPASSES,
        TESTFAILS,
        NULL;


        public static CriteriaNotExistsBehavior fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("test-passes".equals(codeString)) {
                return TESTPASSES;
            }
            if ("test-fails".equals(codeString)) {
                return TESTFAILS;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown CriteriaNotExistsBehavior code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case TESTPASSES: {
                    return "test-passes";
                }
                case TESTFAILS: {
                    return "test-fails";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case TESTPASSES: {
                    return "http://hl7.org/fhir/subscriptiontopic-cr-behavior";
                }
                case TESTFAILS: {
                    return "http://hl7.org/fhir/subscriptiontopic-cr-behavior";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case TESTPASSES: {
                    return "The requested conditional statement will pass if a matching state does not exist (e.g., previous state during create).";
                }
                case TESTFAILS: {
                    return "The requested conditional statement will fail if a matching state does not exist (e.g., previous state during create).";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case TESTPASSES: {
                    return "test passes";
                }
                case TESTFAILS: {
                    return "test fails";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

