/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.conformance.profile.BindingResolution;
import org.hl7.fhir.r5.conformance.profile.ProfileKnowledgeProvider;
import org.hl7.fhir.r5.conformance.profile.ProfileUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.r5.utils.XVerExtensionManager;
import org.hl7.fhir.utilities.OIDUtils;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class ContextUtilities
implements ProfileKnowledgeProvider {
    private IWorkerContext context;
    private boolean suppressDebugMessages;
    private boolean ignoreProfileErrors;
    private XVerExtensionManager xverManager;
    private Map<String, String> oidCache = new HashMap<String, String>();
    private List<StructureDefinition> allStructuresList = new ArrayList<StructureDefinition>();
    private List<String> canonicalResourceNames;
    private List<String> concreteResourceNames;

    public ContextUtilities(IWorkerContext context) {
        this.context = context;
    }

    public boolean isSuppressDebugMessages() {
        return this.suppressDebugMessages;
    }

    public void setSuppressDebugMessages(boolean suppressDebugMessages) {
        this.suppressDebugMessages = suppressDebugMessages;
    }

    public boolean isIgnoreProfileErrors() {
        return this.ignoreProfileErrors;
    }

    public void setIgnoreProfileErrors(boolean ignoreProfileErrors) {
        this.ignoreProfileErrors = ignoreProfileErrors;
    }

    public String oid2Uri(String oid) {
        if (oid != null && oid.startsWith("urn:oid:")) {
            oid = oid.substring(8);
        }
        if (this.oidCache.containsKey(oid)) {
            return this.oidCache.get(oid);
        }
        String uri = OIDUtils.getUriForOid((String)oid);
        if (uri != null) {
            this.oidCache.put(oid, uri);
            return uri;
        }
        CodeSystem cs = this.context.fetchCodeSystem("http://terminology.hl7.org/CodeSystem/v2-tables");
        if (cs != null) {
            for (CodeSystem.ConceptDefinitionComponent cc : cs.getConcept()) {
                for (CodeSystem.ConceptPropertyComponent cp : cc.getProperty()) {
                    if (!Utilities.existsInList((String)cp.getCode(), (String[])new String[]{"v2-table-oid", "v2-cs-oid"}) || !oid.equals(cp.getValue().primitiveValue())) continue;
                    for (CodeSystem.ConceptPropertyComponent cp2 : cc.getProperty()) {
                        if (!"v2-cs-uri".equals(cp2.getCode())) continue;
                        this.oidCache.put(oid, cp2.getValue().primitiveValue());
                        return cp2.getValue().primitiveValue();
                    }
                }
            }
        }
        for (CodeSystem css : this.context.fetchResourcesByType(CodeSystem.class)) {
            if (("urn:oid:" + oid).equals(css.getUrl())) {
                this.oidCache.put(oid, css.getUrl());
                return css.getUrl();
            }
            for (Identifier id : css.getIdentifier()) {
                if (!"urn:ietf:rfc:3986".equals(id.getSystem()) || !("urn:oid:" + oid).equals(id.getValue())) continue;
                this.oidCache.put(oid, css.getUrl());
                return css.getUrl();
            }
        }
        for (NamingSystem ns : this.context.fetchResourcesByType(NamingSystem.class)) {
            if (!this.hasOid(ns, oid) || (uri = this.getUri(ns)) == null) continue;
            this.oidCache.put(oid, null);
            return null;
        }
        this.oidCache.put(oid, null);
        return null;
    }

    private String getUri(NamingSystem ns) {
        for (NamingSystem.NamingSystemUniqueIdComponent id : ns.getUniqueId()) {
            if (id.getType() != NamingSystem.NamingSystemIdentifierType.URI) continue;
            return id.getValue();
        }
        return null;
    }

    private boolean hasOid(NamingSystem ns, String oid) {
        for (NamingSystem.NamingSystemUniqueIdComponent id : ns.getUniqueId()) {
            if (id.getType() != NamingSystem.NamingSystemIdentifierType.OID || !id.getValue().equals(oid)) continue;
            return true;
        }
        return false;
    }

    public List<String> getTypeNames() {
        HashSet<String> result = new HashSet<String>();
        for (StructureDefinition sd : this.context.fetchResourcesByType(StructureDefinition.class)) {
            if (sd.getKind() == StructureDefinition.StructureDefinitionKind.LOGICAL || sd.getDerivation() != StructureDefinition.TypeDerivationRule.SPECIALIZATION) continue;
            result.add(sd.getName());
        }
        return Utilities.sorted(result);
    }

    public Set<String> getTypeNameSet() {
        HashSet<String> result = new HashSet<String>();
        for (StructureDefinition sd : this.context.fetchResourcesByType(StructureDefinition.class)) {
            if (sd.getKind() == StructureDefinition.StructureDefinitionKind.LOGICAL || sd.getDerivation() != StructureDefinition.TypeDerivationRule.SPECIALIZATION) continue;
            result.add(sd.getName());
        }
        return result;
    }

    @Override
    public String getLinkForUrl(String corePath, String url) {
        if (url == null) {
            return null;
        }
        if (this.context.hasResource(CanonicalResource.class, url)) {
            CanonicalResource cr = this.context.fetchResource(CanonicalResource.class, url);
            return cr.getWebPath();
        }
        return null;
    }

    protected String tail(String url) {
        if (Utilities.noString((String)url)) {
            return "noname";
        }
        if (url.contains("/")) {
            return url.substring(url.lastIndexOf("/") + 1);
        }
        return url;
    }

    private boolean hasUrlProperty(StructureDefinition sd) {
        for (ElementDefinition ed : sd.getSnapshot().getElement()) {
            if (!ed.getPath().equals(sd.getType() + ".url")) continue;
            return true;
        }
        return false;
    }

    public List<String> getCanonicalResourceNames() {
        if (this.canonicalResourceNames == null) {
            this.canonicalResourceNames = new ArrayList<String>();
            HashSet<String> names = new HashSet<String>();
            for (StructureDefinition sd : this.allStructures()) {
                if (sd.getKind() != StructureDefinition.StructureDefinitionKind.RESOURCE || sd.getAbstract() || !this.hasUrlProperty(sd)) continue;
                names.add(sd.getType());
            }
            this.canonicalResourceNames.addAll(Utilities.sorted(names));
        }
        return this.canonicalResourceNames;
    }

    public List<StructureDefinition> allStructures() {
        if (this.allStructuresList.isEmpty()) {
            HashSet<StructureDefinition> set = new HashSet<StructureDefinition>();
            for (StructureDefinition sd : this.getStructures()) {
                block4: {
                    if (set.contains(sd)) continue;
                    try {
                        this.generateSnapshot(sd);
                    }
                    catch (Exception e) {
                        if (this.isSuppressDebugMessages()) break block4;
                        System.out.println("Unable to generate snapshot for " + this.tail(sd.getUrl()) + " from " + this.tail(sd.getBaseDefinition()) + " because " + e.getMessage());
                        if (!this.context.getLogger().isDebugLogging()) break block4;
                        e.printStackTrace();
                    }
                }
                this.allStructuresList.add(sd);
                set.add(sd);
            }
        }
        return this.allStructuresList;
    }

    public List<StructureDefinition> getStructures() {
        return this.context.fetchResourcesByType(StructureDefinition.class);
    }

    public void generateSnapshot(StructureDefinition p) throws DefinitionException, FHIRException {
        this.generateSnapshot(p, false);
    }

    public void generateSnapshot(StructureDefinition p, boolean ifLogical) {
        if (!(p.hasSnapshot() && !this.isProfileNeedsRegenerate(p) || !ifLogical && p.getKind() == StructureDefinition.StructureDefinitionKind.LOGICAL)) {
            if (!p.hasBaseDefinition()) {
                throw new DefinitionException(this.context.formatMessage("Profile___has_no_base_and_no_snapshot", p.getName(), p.getUrl()));
            }
            StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, p.getBaseDefinition(), p);
            if (sd == null && "http://hl7.org/fhir/StructureDefinition/Base".equals(p.getBaseDefinition())) {
                sd = ProfileUtilities.makeBaseDefinition(p.getFhirVersion());
            }
            if (sd == null) {
                throw new DefinitionException(this.context.formatMessage("Profile___base__could_not_be_resolved", p.getName(), p.getUrl(), p.getBaseDefinition()));
            }
            ArrayList<ValidationMessage> msgs = new ArrayList<ValidationMessage>();
            ArrayList<String> errors = new ArrayList<String>();
            ProfileUtilities pu = new ProfileUtilities(this.context, msgs, this);
            pu.setAutoFixSliceNames(true);
            pu.setThrowException(false);
            pu.setForPublication(this.context.isForPublication());
            if (this.xverManager == null) {
                this.xverManager = new XVerExtensionManager(this.context);
            }
            pu.setXver(this.xverManager);
            if (sd.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT) {
                pu.sortDifferential(sd, p, p.getUrl(), errors, true);
            }
            pu.setDebug(false);
            for (String err : errors) {
                msgs.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.EXCEPTION, p.getWebPath(), "Error sorting Differential: " + err, ValidationMessage.IssueSeverity.ERROR));
            }
            pu.generateSnapshot(sd, p, p.getUrl(), sd.getUserString("webroot"), p.getName());
            for (ValidationMessage msg : msgs) {
                if ((this.ignoreProfileErrors || msg.getLevel() != ValidationMessage.IssueSeverity.ERROR) && msg.getLevel() != ValidationMessage.IssueSeverity.FATAL) continue;
                throw new DefinitionException(this.context.formatMessage("Profile___element__Error_generating_snapshot_", p.getName(), p.getUrl(), msg.getLocation(), msg.getMessage()));
            }
            if (!p.hasSnapshot()) {
                throw new FHIRException(this.context.formatMessage("Profile___Error_generating_snapshot", p.getName(), p.getUrl()));
            }
            pu = null;
        }
        p.setGeneratedSnapshot(true);
    }

    private boolean isProfileNeedsRegenerate(StructureDefinition p) {
        boolean needs;
        boolean bl = needs = !p.hasUserData("hack.regnerated") && Utilities.existsInList((String)p.getUrl(), (String[])new String[]{"http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaireresponse"});
        if (needs) {
            p.setUserData("hack.regnerated", "yes");
        }
        return needs;
    }

    @Override
    public boolean isPrimitiveType(String type) {
        StructureDefinition sd = this.context.fetchTypeDefinition(type);
        return sd != null && sd.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE;
    }

    @Override
    public boolean isDatatype(String type) {
        StructureDefinition sd = this.context.fetchTypeDefinition(type);
        return sd != null && (sd.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE || sd.getKind() == StructureDefinition.StructureDefinitionKind.COMPLEXTYPE) && sd.getDerivation() == StructureDefinition.TypeDerivationRule.SPECIALIZATION;
    }

    @Override
    public boolean isResource(String t) {
        StructureDefinition sd;
        try {
            sd = this.context.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + t);
        }
        catch (Exception e) {
            return false;
        }
        if (sd == null) {
            return false;
        }
        if (sd.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT) {
            return false;
        }
        return sd.getKind() == StructureDefinition.StructureDefinitionKind.RESOURCE;
    }

    @Override
    public boolean hasLinkFor(String typeSimple) {
        return false;
    }

    @Override
    public String getLinkFor(String corePath, String typeSimple) {
        return null;
    }

    @Override
    public BindingResolution resolveBinding(StructureDefinition profile, ElementDefinition.ElementDefinitionBindingComponent binding, String path) {
        return null;
    }

    @Override
    public BindingResolution resolveBinding(StructureDefinition profile, String url, String path) {
        return null;
    }

    @Override
    public String getLinkForProfile(StructureDefinition profile, String url) {
        return null;
    }

    @Override
    public boolean prependLinks() {
        return false;
    }

    public boolean isPrimitiveDatatype(String type) {
        StructureDefinition sd = this.context.fetchTypeDefinition(type);
        return sd != null && sd.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE;
    }

    public StructureDefinition fetchByJsonName(String key) {
        for (StructureDefinition sd : this.context.fetchResourcesByType(StructureDefinition.class)) {
            ElementDefinition ed = sd.getSnapshot().getElementFirstRep();
            if (sd.getKind() != StructureDefinition.StructureDefinitionKind.LOGICAL || ed == null || !ed.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-json-name") || !key.equals(ToolingExtensions.readStringExtension(ed, "http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-json-name"))) continue;
            return sd;
        }
        return null;
    }

    public List<String> getConcreteResources() {
        if (this.concreteResourceNames == null) {
            this.concreteResourceNames = new ArrayList<String>();
            HashSet<String> names = new HashSet<String>();
            for (StructureDefinition sd : this.allStructures()) {
                if (sd.getKind() != StructureDefinition.StructureDefinitionKind.RESOURCE || sd.getAbstract()) continue;
                names.add(sd.getType());
            }
            this.concreteResourceNames.addAll(Utilities.sorted(names));
        }
        return this.concreteResourceNames;
    }

    public List<StructureMap> listMaps(String url) {
        ArrayList<StructureMap> res = new ArrayList<StructureMap>();
        String start = url.substring(0, url.indexOf("*"));
        String end = url.substring(url.indexOf("*") + 1);
        for (StructureMap map : this.context.fetchResourcesByType(StructureMap.class)) {
            String u = map.getUrl();
            if (!u.startsWith(start) || !u.endsWith(end)) continue;
            res.add(map);
        }
        return res;
    }

    public List<String> fetchCodeSystemVersions(String system) {
        ArrayList<String> res = new ArrayList<String>();
        for (CodeSystem cs : this.context.fetchResourcesByType(CodeSystem.class)) {
            if (!system.equals(cs.getUrl()) || !cs.hasVersion()) continue;
            res.add(cs.getVersion());
        }
        return res;
    }
}

