/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.elementmodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.r5.context.ContextUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.terminologies.CodeSystemUtilities;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.i18n.LanguageFileProducer;

public class LanguageUtils {
    public static final List<String> TRANSLATION_SUPPLEMENT_RESOURCE_TYPES = Arrays.asList("CodeSystem", "StructureDefinition");
    private static final String ORPHAN_TRANSLATIONS_NAME = "translations.orphans";
    private static final String SUPPLEMENT_NAME = "translations.supplement";
    IWorkerContext context;
    private List<String> crlist;

    public LanguageUtils(IWorkerContext context) {
        this.context = context;
    }

    public void generateTranslations(Element resource, LanguageFileProducer.LanguageProducerLanguageSession session) {
        this.translate(null, resource, session);
    }

    private void translate(Element parent, Element element, LanguageFileProducer.LanguageProducerLanguageSession langSession) {
        String base;
        if (element.isPrimitive() && this.isTranslatable(element) && (base = element.primitiveValue()) != null) {
            String translation = this.getSpecialTranslation(parent, element, langSession.getTargetLang());
            if (translation == null) {
                translation = element.getTranslation(langSession.getTargetLang());
            }
            langSession.entry(new LanguageFileProducer.TextUnit(this.pathForElement(element), base, translation));
        }
        for (Element c : element.getChildren()) {
            if (c.getName().equals("designation")) continue;
            this.translate(element, c, langSession);
        }
    }

    private String getSpecialTranslation(Element parent, Element element, String targetLang) {
        if (parent == null) {
            return null;
        }
        if (Utilities.existsInList((String)this.pathForElement(parent), (String[])new String[]{"CodeSystem.concept", "CodeSystem.concept.concept"}) && "CodeSystem.concept.display".equals(this.pathForElement(element))) {
            return this.getDesignationTranslation(parent, targetLang);
        }
        if (Utilities.existsInList((String)this.pathForElement(parent), (String[])new String[]{"ValueSet.compose.include.concept"}) && "ValueSet.compose.include.concept.display".equals(this.pathForElement(element))) {
            return this.getDesignationTranslation(parent, targetLang);
        }
        if (Utilities.existsInList((String)this.pathForElement(parent), (String[])new String[]{"ValueSet.expansion.contains", "ValueSet.expansion.contains.contains"}) && "ValueSet.expansion.contains.display".equals(this.pathForElement(element))) {
            return this.getDesignationTranslation(parent, targetLang);
        }
        return null;
    }

    private String getDesignationTranslation(Element parent, String targetLang) {
        for (Element e : parent.getChildren("designation")) {
            String lang = e.getNamedChildValue("language");
            if (!LanguageUtils.langsMatch(targetLang, lang)) continue;
            return e.getNamedChildValue("value");
        }
        return null;
    }

    private boolean isTranslatable(Element element) {
        return element.getProperty().isTranslatable() && !Utilities.existsInList((String)this.pathForElement(element), (String[])new String[]{"CanonicalResource.version"});
    }

    private String pathForElement(Element element) {
        if (this.crlist == null) {
            this.crlist = new ContextUtilities(this.context).getCanonicalResourceNames();
        }
        String bp = element.getBasePath();
        if (this.crlist.contains(element.getProperty().getStructure().getType())) {
            String fp = bp.replace(element.getProperty().getStructure().getType() + ".", "CanonicalResource.");
            if (Utilities.existsInList((String)fp, (String[])new String[]{"CanonicalResource.url", "CanonicalResource.identifier", "CanonicalResource.version", "CanonicalResource.name", "CanonicalResource.title", "CanonicalResource.status", "CanonicalResource.experimental", "CanonicalResource.date", "CanonicalResource.publisher", "CanonicalResource.contact", "CanonicalResource.description", "CanonicalResource.useContext", "CanonicalResource.jurisdiction"})) {
                return fp;
            }
        }
        return bp;
    }

    public int importFromTranslations(Element resource, Set<LanguageFileProducer.TranslationUnit> translations) {
        return this.importFromTranslations(null, resource, translations);
    }

    private int importFromTranslations(Element parent, Element element, Set<LanguageFileProducer.TranslationUnit> translations) {
        String base;
        int t = 0;
        if (element.isPrimitive() && this.isTranslatable(element) && (base = element.primitiveValue()) != null) {
            Set<LanguageFileProducer.TranslationUnit> tlist = this.findTranslations(this.pathForElement(element), base, translations);
            for (LanguageFileProducer.TranslationUnit translation : tlist) {
                ++t;
                if (this.handleAsSpecial(parent, element, translation)) continue;
                element.setTranslation(translation.getLanguage(), translation.getTgtText());
            }
        }
        for (Element c : element.getChildren()) {
            if (c.getName().equals("designation")) continue;
            t += this.importFromTranslations(element, c, translations);
        }
        return t;
    }

    private boolean handleAsSpecial(Element parent, Element element, LanguageFileProducer.TranslationUnit translation) {
        if (parent == null) {
            return false;
        }
        if (Utilities.existsInList((String)this.pathForElement(parent), (String[])new String[]{"CodeSystem.concept", "CodeSystem.concept.concept"}) && "CodeSystem.concept.display".equals(this.pathForElement(element))) {
            return this.setDesignationTranslation(parent, translation.getLanguage(), translation.getTgtText());
        }
        if (Utilities.existsInList((String)this.pathForElement(parent), (String[])new String[]{"ValueSet.compose.include.concept"}) && "ValueSet.compose.include.concept.display".equals(this.pathForElement(element))) {
            return this.setDesignationTranslation(parent, translation.getLanguage(), translation.getTgtText());
        }
        if (Utilities.existsInList((String)this.pathForElement(parent), (String[])new String[]{"ValueSet.expansion.contains", "ValueSet.expansion.contains.contains"}) && "ValueSet.expansion.contains.display".equals(this.pathForElement(element))) {
            return this.setDesignationTranslation(parent, translation.getLanguage(), translation.getTgtText());
        }
        return false;
    }

    private boolean setDesignationTranslation(Element parent, String targetLang, String translation) {
        for (Element e : parent.getChildren("designation")) {
            String lang = e.getNamedChildValue("language");
            if (!LanguageUtils.langsMatch(targetLang, lang)) continue;
            Element value = e.getNamedChild("value");
            if (value != null) {
                value.setValue(translation);
            } else {
                e.addElement("value").setValue(translation);
            }
            return true;
        }
        Element d = parent.addElement("designation");
        d.addElement("language").setValue(targetLang);
        d.addElement("value").setValue(translation);
        return true;
    }

    private Set<LanguageFileProducer.TranslationUnit> findTranslations(String path, String src, Set<LanguageFileProducer.TranslationUnit> translations) {
        HashSet<LanguageFileProducer.TranslationUnit> res = new HashSet<LanguageFileProducer.TranslationUnit>();
        for (LanguageFileProducer.TranslationUnit translation : translations) {
            if (!path.equals(translation.getContext()) || !src.equals(translation.getSrcText())) continue;
            res.add(translation);
        }
        return res;
    }

    public static boolean langsMatch(String dstLang, String srcLang) {
        return dstLang == null ? false : dstLang.equals(srcLang);
    }

    public static void fillSupplement(CodeSystem cs, List<LanguageFileProducer.TranslationUnit> list) {
        cs.setUserData(SUPPLEMENT_NAME, "true");
        for (LanguageFileProducer.TranslationUnit tu : list) {
            CodeSystem.ConceptDefinitionComponent cd = CodeSystemUtilities.getCode(cs, tu.getContext());
            if (cd != null && cd.hasDisplay() && cd.getDisplay().equals(tu.getSrcText())) {
                cd.addDesignation().setLanguage(tu.getLanguage()).setValue(tu.getTgtText());
                continue;
            }
            LanguageUtils.addOrphanTranslation(cs, tu);
        }
    }

    private static void addOrphanTranslation(CodeSystem cs, LanguageFileProducer.TranslationUnit tu) {
        ArrayList<LanguageFileProducer.TranslationUnit> list = (ArrayList<LanguageFileProducer.TranslationUnit>)cs.getUserData(ORPHAN_TRANSLATIONS_NAME);
        if (list == null) {
            list = new ArrayList<LanguageFileProducer.TranslationUnit>();
            cs.setUserData(ORPHAN_TRANSLATIONS_NAME, list);
        }
        list.add(tu);
    }

    public static String nameForLang(String lang) {
        switch (lang) {
            case "en": {
                return "English";
            }
            case "de": {
                return "German";
            }
            case "es": {
                return "Spanish";
            }
            case "nl": {
                return "Dutch";
            }
        }
        return Utilities.capitalize((String)lang);
    }

    public static String titleForLang(String lang) {
        switch (lang) {
            case "en": {
                return "English";
            }
            case "de": {
                return "German";
            }
            case "es": {
                return "Spanish";
            }
            case "nl": {
                return "Dutch";
            }
        }
        return Utilities.capitalize((String)lang);
    }

    public static boolean handlesAsResource(Resource resource) {
        return resource instanceof CodeSystem && resource.hasUserData(SUPPLEMENT_NAME);
    }

    public static boolean handlesAsElement(Element element) {
        return false;
    }

    public static List<LanguageFileProducer.TranslationUnit> generateTranslations(Resource res, String lang) {
        ArrayList<LanguageFileProducer.TranslationUnit> list = new ArrayList<LanguageFileProducer.TranslationUnit>();
        CodeSystem cs = (CodeSystem)res;
        for (CodeSystem.ConceptDefinitionComponent cd : cs.getConcept()) {
            LanguageUtils.generateTranslations(list, cd, lang);
        }
        return list;
    }

    private static void generateTranslations(List<LanguageFileProducer.TranslationUnit> list, CodeSystem.ConceptDefinitionComponent cd, String lang) {
        String code = cd.getCode();
        String display = cd.getDisplay();
        String target = null;
        for (CodeSystem.ConceptDefinitionDesignationComponent d : cd.getDesignation()) {
            if (target != null || d.hasUse() || !d.hasLanguage() || !lang.equals(d.getLanguage())) continue;
            target = d.getValue();
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent d : cd.getDesignation()) {
            if (target != null || !d.hasLanguage() || !lang.equals(d.getLanguage())) continue;
            target = d.getValue();
        }
        list.add(new LanguageFileProducer.TranslationUnit(lang, code, display, target));
        for (CodeSystem.ConceptDefinitionComponent cd1 : cd.getConcept()) {
            LanguageUtils.generateTranslations(list, cd1, lang);
        }
    }
}

