/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Binary;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.MarketingStatus;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ManufacturedItemDefinition", profile="http://hl7.org/fhir/StructureDefinition/ManufacturedItemDefinition")
public class ManufacturedItemDefinition
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Unique identifier", formalDefinition="Unique identifier.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired | unknown", formalDefinition="The status of this item. Enables tracking the life-cycle of the content.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected Enumeration<Enumerations.PublicationStatus> status;
    @Child(name="name", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="A descriptive name applied to this item", formalDefinition="A descriptive name applied to this item.")
    protected StringType name;
    @Child(name="manufacturedDoseForm", type={CodeableConcept.class}, order=3, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Dose form as manufactured (before any necessary transformation)", formalDefinition="Dose form as manufactured and before any transformation into the pharmaceutical product.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/manufactured-dose-form")
    protected CodeableConcept manufacturedDoseForm;
    @Child(name="unitOfPresentation", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The \u201creal-world\u201d units in which the quantity of the item is described", formalDefinition="The \u201creal-world\u201d units in which the quantity of the manufactured item is described.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/unit-of-presentation")
    protected CodeableConcept unitOfPresentation;
    @Child(name="manufacturer", type={Organization.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Manufacturer of the item, one of several possible", formalDefinition="Manufacturer of the item, one of several possible.")
    protected List<Reference> manufacturer;
    @Child(name="marketingStatus", type={MarketingStatus.class}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Allows specifying that an item is on the market for sale, or that it is not available, and the dates and locations associated", formalDefinition="Allows specifying that an item is on the market for sale, or that it is not available, and the dates and locations associated.")
    protected List<MarketingStatus> marketingStatus;
    @Child(name="ingredient", type={CodeableConcept.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The ingredients of this manufactured item. Only needed if these are not specified by incoming references from the Ingredient resource", formalDefinition="The ingredients of this manufactured item. This is only needed if the ingredients are not specified by incoming references from the Ingredient resource.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/substance-codes")
    protected List<CodeableConcept> ingredient;
    @Child(name="property", type={}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="General characteristics of this item", formalDefinition="General characteristics of this item.")
    protected List<ManufacturedItemDefinitionPropertyComponent> property;
    @Child(name="component", type={}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Physical parts of the manufactured item, that it is intrisically made from. This is distinct from the ingredients that are part of its chemical makeup", formalDefinition="Physical parts of the manufactured item, that it is intrisically made from. This is distinct from the ingredients that are part of its chemical makeup.")
    protected List<ManufacturedItemDefinitionComponentComponent> component;
    private static final long serialVersionUID = 516510494L;
    @SearchParamDefinition(name="dose-form", path="ManufacturedItemDefinition.manufacturedDoseForm", description="Dose form as manufactured and before any transformation into the pharmaceutical product", type="token")
    public static final String SP_DOSE_FORM = "dose-form";
    public static final TokenClientParam DOSE_FORM = new TokenClientParam("dose-form");
    @SearchParamDefinition(name="identifier", path="ManufacturedItemDefinition.identifier", description="Unique identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="ingredient", path="ManufacturedItemDefinition.ingredient", description="An ingredient of this item", type="token")
    public static final String SP_INGREDIENT = "ingredient";
    public static final TokenClientParam INGREDIENT = new TokenClientParam("ingredient");
    @SearchParamDefinition(name="name", path="ManufacturedItemDefinition.name", description="A descriptive name applied to this item", type="token")
    public static final String SP_NAME = "name";
    public static final TokenClientParam NAME = new TokenClientParam("name");
    @SearchParamDefinition(name="status", path="ManufacturedItemDefinition.status", description="The status of this item. Enables tracking the life-cycle of the content.", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public ManufacturedItemDefinition() {
    }

    public ManufacturedItemDefinition(Enumerations.PublicationStatus status, CodeableConcept manufacturedDoseForm) {
        this.setStatus(status);
        this.setManufacturedDoseForm(manufacturedDoseForm);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public ManufacturedItemDefinition setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ManufacturedItemDefinition addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ManufacturedItemDefinition.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public ManufacturedItemDefinition setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    public ManufacturedItemDefinition setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ManufacturedItemDefinition.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public ManufacturedItemDefinition setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public ManufacturedItemDefinition setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public CodeableConcept getManufacturedDoseForm() {
        if (this.manufacturedDoseForm == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ManufacturedItemDefinition.manufacturedDoseForm");
            }
            if (Configuration.doAutoCreate()) {
                this.manufacturedDoseForm = new CodeableConcept();
            }
        }
        return this.manufacturedDoseForm;
    }

    public boolean hasManufacturedDoseForm() {
        return this.manufacturedDoseForm != null && !this.manufacturedDoseForm.isEmpty();
    }

    public ManufacturedItemDefinition setManufacturedDoseForm(CodeableConcept value) {
        this.manufacturedDoseForm = value;
        return this;
    }

    public CodeableConcept getUnitOfPresentation() {
        if (this.unitOfPresentation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ManufacturedItemDefinition.unitOfPresentation");
            }
            if (Configuration.doAutoCreate()) {
                this.unitOfPresentation = new CodeableConcept();
            }
        }
        return this.unitOfPresentation;
    }

    public boolean hasUnitOfPresentation() {
        return this.unitOfPresentation != null && !this.unitOfPresentation.isEmpty();
    }

    public ManufacturedItemDefinition setUnitOfPresentation(CodeableConcept value) {
        this.unitOfPresentation = value;
        return this;
    }

    public List<Reference> getManufacturer() {
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<Reference>();
        }
        return this.manufacturer;
    }

    public ManufacturedItemDefinition setManufacturer(List<Reference> theManufacturer) {
        this.manufacturer = theManufacturer;
        return this;
    }

    public boolean hasManufacturer() {
        if (this.manufacturer == null) {
            return false;
        }
        for (Reference item : this.manufacturer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addManufacturer() {
        Reference t = new Reference();
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<Reference>();
        }
        this.manufacturer.add(t);
        return t;
    }

    public ManufacturedItemDefinition addManufacturer(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<Reference>();
        }
        this.manufacturer.add(t);
        return this;
    }

    public Reference getManufacturerFirstRep() {
        if (this.getManufacturer().isEmpty()) {
            this.addManufacturer();
        }
        return this.getManufacturer().get(0);
    }

    public List<MarketingStatus> getMarketingStatus() {
        if (this.marketingStatus == null) {
            this.marketingStatus = new ArrayList<MarketingStatus>();
        }
        return this.marketingStatus;
    }

    public ManufacturedItemDefinition setMarketingStatus(List<MarketingStatus> theMarketingStatus) {
        this.marketingStatus = theMarketingStatus;
        return this;
    }

    public boolean hasMarketingStatus() {
        if (this.marketingStatus == null) {
            return false;
        }
        for (MarketingStatus item : this.marketingStatus) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MarketingStatus addMarketingStatus() {
        MarketingStatus t = new MarketingStatus();
        if (this.marketingStatus == null) {
            this.marketingStatus = new ArrayList<MarketingStatus>();
        }
        this.marketingStatus.add(t);
        return t;
    }

    public ManufacturedItemDefinition addMarketingStatus(MarketingStatus t) {
        if (t == null) {
            return this;
        }
        if (this.marketingStatus == null) {
            this.marketingStatus = new ArrayList<MarketingStatus>();
        }
        this.marketingStatus.add(t);
        return this;
    }

    public MarketingStatus getMarketingStatusFirstRep() {
        if (this.getMarketingStatus().isEmpty()) {
            this.addMarketingStatus();
        }
        return this.getMarketingStatus().get(0);
    }

    public List<CodeableConcept> getIngredient() {
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<CodeableConcept>();
        }
        return this.ingredient;
    }

    public ManufacturedItemDefinition setIngredient(List<CodeableConcept> theIngredient) {
        this.ingredient = theIngredient;
        return this;
    }

    public boolean hasIngredient() {
        if (this.ingredient == null) {
            return false;
        }
        for (CodeableConcept item : this.ingredient) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addIngredient() {
        CodeableConcept t = new CodeableConcept();
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<CodeableConcept>();
        }
        this.ingredient.add(t);
        return t;
    }

    public ManufacturedItemDefinition addIngredient(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<CodeableConcept>();
        }
        this.ingredient.add(t);
        return this;
    }

    public CodeableConcept getIngredientFirstRep() {
        if (this.getIngredient().isEmpty()) {
            this.addIngredient();
        }
        return this.getIngredient().get(0);
    }

    public List<ManufacturedItemDefinitionPropertyComponent> getProperty() {
        if (this.property == null) {
            this.property = new ArrayList<ManufacturedItemDefinitionPropertyComponent>();
        }
        return this.property;
    }

    public ManufacturedItemDefinition setProperty(List<ManufacturedItemDefinitionPropertyComponent> theProperty) {
        this.property = theProperty;
        return this;
    }

    public boolean hasProperty() {
        if (this.property == null) {
            return false;
        }
        for (ManufacturedItemDefinitionPropertyComponent item : this.property) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ManufacturedItemDefinitionPropertyComponent addProperty() {
        ManufacturedItemDefinitionPropertyComponent t = new ManufacturedItemDefinitionPropertyComponent();
        if (this.property == null) {
            this.property = new ArrayList<ManufacturedItemDefinitionPropertyComponent>();
        }
        this.property.add(t);
        return t;
    }

    public ManufacturedItemDefinition addProperty(ManufacturedItemDefinitionPropertyComponent t) {
        if (t == null) {
            return this;
        }
        if (this.property == null) {
            this.property = new ArrayList<ManufacturedItemDefinitionPropertyComponent>();
        }
        this.property.add(t);
        return this;
    }

    public ManufacturedItemDefinitionPropertyComponent getPropertyFirstRep() {
        if (this.getProperty().isEmpty()) {
            this.addProperty();
        }
        return this.getProperty().get(0);
    }

    public List<ManufacturedItemDefinitionComponentComponent> getComponent() {
        if (this.component == null) {
            this.component = new ArrayList<ManufacturedItemDefinitionComponentComponent>();
        }
        return this.component;
    }

    public ManufacturedItemDefinition setComponent(List<ManufacturedItemDefinitionComponentComponent> theComponent) {
        this.component = theComponent;
        return this;
    }

    public boolean hasComponent() {
        if (this.component == null) {
            return false;
        }
        for (ManufacturedItemDefinitionComponentComponent item : this.component) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ManufacturedItemDefinitionComponentComponent addComponent() {
        ManufacturedItemDefinitionComponentComponent t = new ManufacturedItemDefinitionComponentComponent();
        if (this.component == null) {
            this.component = new ArrayList<ManufacturedItemDefinitionComponentComponent>();
        }
        this.component.add(t);
        return t;
    }

    public ManufacturedItemDefinition addComponent(ManufacturedItemDefinitionComponentComponent t) {
        if (t == null) {
            return this;
        }
        if (this.component == null) {
            this.component = new ArrayList<ManufacturedItemDefinitionComponentComponent>();
        }
        this.component.add(t);
        return this;
    }

    public ManufacturedItemDefinitionComponentComponent getComponentFirstRep() {
        if (this.getComponent().isEmpty()) {
            this.addComponent();
        }
        return this.getComponent().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Unique identifier.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "The status of this item. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property(SP_NAME, "string", "A descriptive name applied to this item.", 0, 1, this.name));
        children.add(new Property("manufacturedDoseForm", "CodeableConcept", "Dose form as manufactured and before any transformation into the pharmaceutical product.", 0, 1, this.manufacturedDoseForm));
        children.add(new Property("unitOfPresentation", "CodeableConcept", "The \u201creal-world\u201d units in which the quantity of the manufactured item is described.", 0, 1, this.unitOfPresentation));
        children.add(new Property("manufacturer", "Reference(Organization)", "Manufacturer of the item, one of several possible.", 0, Integer.MAX_VALUE, this.manufacturer));
        children.add(new Property("marketingStatus", "MarketingStatus", "Allows specifying that an item is on the market for sale, or that it is not available, and the dates and locations associated.", 0, Integer.MAX_VALUE, this.marketingStatus));
        children.add(new Property(SP_INGREDIENT, "CodeableConcept", "The ingredients of this manufactured item. This is only needed if the ingredients are not specified by incoming references from the Ingredient resource.", 0, Integer.MAX_VALUE, this.ingredient));
        children.add(new Property("property", "", "General characteristics of this item.", 0, Integer.MAX_VALUE, this.property));
        children.add(new Property("component", "", "Physical parts of the manufactured item, that it is intrisically made from. This is distinct from the ingredients that are part of its chemical makeup.", 0, Integer.MAX_VALUE, this.component));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Unique identifier.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this item. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A descriptive name applied to this item.", 0, 1, this.name);
            }
            case -1451400348: {
                return new Property("manufacturedDoseForm", "CodeableConcept", "Dose form as manufactured and before any transformation into the pharmaceutical product.", 0, 1, this.manufacturedDoseForm);
            }
            case -1427765963: {
                return new Property("unitOfPresentation", "CodeableConcept", "The \u201creal-world\u201d units in which the quantity of the manufactured item is described.", 0, 1, this.unitOfPresentation);
            }
            case -1969347631: {
                return new Property("manufacturer", "Reference(Organization)", "Manufacturer of the item, one of several possible.", 0, Integer.MAX_VALUE, this.manufacturer);
            }
            case 70767032: {
                return new Property("marketingStatus", "MarketingStatus", "Allows specifying that an item is on the market for sale, or that it is not available, and the dates and locations associated.", 0, Integer.MAX_VALUE, this.marketingStatus);
            }
            case -206409263: {
                return new Property(SP_INGREDIENT, "CodeableConcept", "The ingredients of this manufactured item. This is only needed if the ingredients are not specified by incoming references from the Ingredient resource.", 0, Integer.MAX_VALUE, this.ingredient);
            }
            case -993141291: {
                return new Property("property", "", "General characteristics of this item.", 0, Integer.MAX_VALUE, this.property);
            }
            case -1399907075: {
                return new Property("component", "", "Physical parts of the manufactured item, that it is intrisically made from. This is distinct from the ingredients that are part of its chemical makeup.", 0, Integer.MAX_VALUE, this.component);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.name;
                }
                return baseArray;
            }
            case -1451400348: {
                Base[] baseArray;
                if (this.manufacturedDoseForm == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.manufacturedDoseForm;
                }
                return baseArray;
            }
            case -1427765963: {
                Base[] baseArray;
                if (this.unitOfPresentation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.unitOfPresentation;
                }
                return baseArray;
            }
            case -1969347631: {
                return this.manufacturer == null ? new Base[]{} : this.manufacturer.toArray(new Base[this.manufacturer.size()]);
            }
            case 70767032: {
                return this.marketingStatus == null ? new Base[]{} : this.marketingStatus.toArray(new Base[this.marketingStatus.size()]);
            }
            case -206409263: {
                return this.ingredient == null ? new Base[]{} : this.ingredient.toArray(new Base[this.ingredient.size()]);
            }
            case -993141291: {
                return this.property == null ? new Base[]{} : this.property.toArray(new Base[this.property.size()]);
            }
            case -1399907075: {
                return this.component == null ? new Base[]{} : this.component.toArray(new Base[this.component.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case -1451400348: {
                this.manufacturedDoseForm = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1427765963: {
                this.unitOfPresentation = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1969347631: {
                this.getManufacturer().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 70767032: {
                this.getMarketingStatus().add(TypeConvertor.castToMarketingStatus(value));
                return value;
            }
            case -206409263: {
                this.getIngredient().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -993141291: {
                this.getProperty().add((ManufacturedItemDefinitionPropertyComponent)((Object)value));
                return value;
            }
            case -1399907075: {
                this.getComponent().add((ManufacturedItemDefinitionComponentComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_NAME)) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals("manufacturedDoseForm")) {
            this.manufacturedDoseForm = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("unitOfPresentation")) {
            this.unitOfPresentation = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("manufacturer")) {
            this.getManufacturer().add(TypeConvertor.castToReference(value));
        } else if (name.equals("marketingStatus")) {
            this.getMarketingStatus().add(TypeConvertor.castToMarketingStatus(value));
        } else if (name.equals(SP_INGREDIENT)) {
            this.getIngredient().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("property")) {
            this.getProperty().add((ManufacturedItemDefinitionPropertyComponent)((Object)value));
        } else if (name.equals("component")) {
            this.getComponent().add((ManufacturedItemDefinitionComponentComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case -1451400348: {
                return this.getManufacturedDoseForm();
            }
            case -1427765963: {
                return this.getUnitOfPresentation();
            }
            case -1969347631: {
                return this.addManufacturer();
            }
            case 70767032: {
                return this.addMarketingStatus();
            }
            case -206409263: {
                return this.addIngredient();
            }
            case -993141291: {
                return this.addProperty();
            }
            case -1399907075: {
                return this.addComponent();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case -1451400348: {
                return new String[]{"CodeableConcept"};
            }
            case -1427765963: {
                return new String[]{"CodeableConcept"};
            }
            case -1969347631: {
                return new String[]{"Reference"};
            }
            case 70767032: {
                return new String[]{"MarketingStatus"};
            }
            case -206409263: {
                return new String[]{"CodeableConcept"};
            }
            case -993141291: {
                return new String[0];
            }
            case -1399907075: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type ManufacturedItemDefinition.status");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type ManufacturedItemDefinition.name");
        }
        if (name.equals("manufacturedDoseForm")) {
            this.manufacturedDoseForm = new CodeableConcept();
            return this.manufacturedDoseForm;
        }
        if (name.equals("unitOfPresentation")) {
            this.unitOfPresentation = new CodeableConcept();
            return this.unitOfPresentation;
        }
        if (name.equals("manufacturer")) {
            return this.addManufacturer();
        }
        if (name.equals("marketingStatus")) {
            return this.addMarketingStatus();
        }
        if (name.equals(SP_INGREDIENT)) {
            return this.addIngredient();
        }
        if (name.equals("property")) {
            return this.addProperty();
        }
        if (name.equals("component")) {
            return this.addComponent();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ManufacturedItemDefinition";
    }

    @Override
    public ManufacturedItemDefinition copy() {
        ManufacturedItemDefinition dst = new ManufacturedItemDefinition();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ManufacturedItemDefinition dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.manufacturedDoseForm = this.manufacturedDoseForm == null ? null : this.manufacturedDoseForm.copy();
        CodeableConcept codeableConcept = dst.unitOfPresentation = this.unitOfPresentation == null ? null : this.unitOfPresentation.copy();
        if (this.manufacturer != null) {
            dst.manufacturer = new ArrayList<Reference>();
            for (Reference reference : this.manufacturer) {
                dst.manufacturer.add(reference.copy());
            }
        }
        if (this.marketingStatus != null) {
            dst.marketingStatus = new ArrayList<MarketingStatus>();
            for (MarketingStatus marketingStatus : this.marketingStatus) {
                dst.marketingStatus.add(marketingStatus.copy());
            }
        }
        if (this.ingredient != null) {
            dst.ingredient = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.ingredient) {
                dst.ingredient.add(codeableConcept2.copy());
            }
        }
        if (this.property != null) {
            dst.property = new ArrayList<ManufacturedItemDefinitionPropertyComponent>();
            for (ManufacturedItemDefinitionPropertyComponent manufacturedItemDefinitionPropertyComponent : this.property) {
                dst.property.add(manufacturedItemDefinitionPropertyComponent.copy());
            }
        }
        if (this.component != null) {
            dst.component = new ArrayList<ManufacturedItemDefinitionComponentComponent>();
            for (ManufacturedItemDefinitionComponentComponent manufacturedItemDefinitionComponentComponent : this.component) {
                dst.component.add(manufacturedItemDefinitionComponentComponent.copy());
            }
        }
    }

    protected ManufacturedItemDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ManufacturedItemDefinition)) {
            return false;
        }
        ManufacturedItemDefinition o = (ManufacturedItemDefinition)other_;
        return ManufacturedItemDefinition.compareDeep(this.identifier, o.identifier, true) && ManufacturedItemDefinition.compareDeep(this.status, o.status, true) && ManufacturedItemDefinition.compareDeep(this.name, o.name, true) && ManufacturedItemDefinition.compareDeep(this.manufacturedDoseForm, o.manufacturedDoseForm, true) && ManufacturedItemDefinition.compareDeep(this.unitOfPresentation, o.unitOfPresentation, true) && ManufacturedItemDefinition.compareDeep(this.manufacturer, o.manufacturer, true) && ManufacturedItemDefinition.compareDeep(this.marketingStatus, o.marketingStatus, true) && ManufacturedItemDefinition.compareDeep(this.ingredient, o.ingredient, true) && ManufacturedItemDefinition.compareDeep(this.property, o.property, true) && ManufacturedItemDefinition.compareDeep(this.component, o.component, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ManufacturedItemDefinition)) {
            return false;
        }
        ManufacturedItemDefinition o = (ManufacturedItemDefinition)other_;
        return ManufacturedItemDefinition.compareValues(this.status, o.status, true) && ManufacturedItemDefinition.compareValues(this.name, o.name, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.name, this.manufacturedDoseForm, this.unitOfPresentation, this.manufacturer, this.marketingStatus, this.ingredient, this.property, this.component});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ManufacturedItemDefinition;
    }

    @Block
    public static class ManufacturedItemDefinitionComponentConstituentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="amount", type={Quantity.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The measurable amount of the substance, expressable in different ways (e.g. by mass or volume)", formalDefinition="The measurable amount of the substance, expressable in different ways (e.g. by mass or volume).")
        protected List<Quantity> amount;
        @Child(name="location", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The physical location of the constituent/ingredient within the component", formalDefinition="The physical location of the constituent/ingredient within the component. Example \u2013 if the component is the bead in the capsule, then the location would be where the ingredient resides within the product part \u2013 intragranular, extra-granular, etc.")
        protected List<CodeableConcept> location;
        @Child(name="function", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The function of this constituent within the component e.g. binder", formalDefinition="The function of this constituent within the component e.g. binder.")
        protected List<CodeableConcept> function;
        @Child(name="hasIngredient", type={CodeableReference.class}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The ingredient that is the constituent of the given component", formalDefinition="The ingredient that is the constituent of the given component.")
        protected List<CodeableReference> hasIngredient;
        private static final long serialVersionUID = -708786069L;

        public List<Quantity> getAmount() {
            if (this.amount == null) {
                this.amount = new ArrayList<Quantity>();
            }
            return this.amount;
        }

        public ManufacturedItemDefinitionComponentConstituentComponent setAmount(List<Quantity> theAmount) {
            this.amount = theAmount;
            return this;
        }

        public boolean hasAmount() {
            if (this.amount == null) {
                return false;
            }
            for (Quantity item : this.amount) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Quantity addAmount() {
            Quantity t = new Quantity();
            if (this.amount == null) {
                this.amount = new ArrayList<Quantity>();
            }
            this.amount.add(t);
            return t;
        }

        public ManufacturedItemDefinitionComponentConstituentComponent addAmount(Quantity t) {
            if (t == null) {
                return this;
            }
            if (this.amount == null) {
                this.amount = new ArrayList<Quantity>();
            }
            this.amount.add(t);
            return this;
        }

        public Quantity getAmountFirstRep() {
            if (this.getAmount().isEmpty()) {
                this.addAmount();
            }
            return this.getAmount().get(0);
        }

        public List<CodeableConcept> getLocation() {
            if (this.location == null) {
                this.location = new ArrayList<CodeableConcept>();
            }
            return this.location;
        }

        public ManufacturedItemDefinitionComponentConstituentComponent setLocation(List<CodeableConcept> theLocation) {
            this.location = theLocation;
            return this;
        }

        public boolean hasLocation() {
            if (this.location == null) {
                return false;
            }
            for (CodeableConcept item : this.location) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addLocation() {
            CodeableConcept t = new CodeableConcept();
            if (this.location == null) {
                this.location = new ArrayList<CodeableConcept>();
            }
            this.location.add(t);
            return t;
        }

        public ManufacturedItemDefinitionComponentConstituentComponent addLocation(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.location == null) {
                this.location = new ArrayList<CodeableConcept>();
            }
            this.location.add(t);
            return this;
        }

        public CodeableConcept getLocationFirstRep() {
            if (this.getLocation().isEmpty()) {
                this.addLocation();
            }
            return this.getLocation().get(0);
        }

        public List<CodeableConcept> getFunction() {
            if (this.function == null) {
                this.function = new ArrayList<CodeableConcept>();
            }
            return this.function;
        }

        public ManufacturedItemDefinitionComponentConstituentComponent setFunction(List<CodeableConcept> theFunction) {
            this.function = theFunction;
            return this;
        }

        public boolean hasFunction() {
            if (this.function == null) {
                return false;
            }
            for (CodeableConcept item : this.function) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addFunction() {
            CodeableConcept t = new CodeableConcept();
            if (this.function == null) {
                this.function = new ArrayList<CodeableConcept>();
            }
            this.function.add(t);
            return t;
        }

        public ManufacturedItemDefinitionComponentConstituentComponent addFunction(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.function == null) {
                this.function = new ArrayList<CodeableConcept>();
            }
            this.function.add(t);
            return this;
        }

        public CodeableConcept getFunctionFirstRep() {
            if (this.getFunction().isEmpty()) {
                this.addFunction();
            }
            return this.getFunction().get(0);
        }

        public List<CodeableReference> getHasIngredient() {
            if (this.hasIngredient == null) {
                this.hasIngredient = new ArrayList<CodeableReference>();
            }
            return this.hasIngredient;
        }

        public ManufacturedItemDefinitionComponentConstituentComponent setHasIngredient(List<CodeableReference> theHasIngredient) {
            this.hasIngredient = theHasIngredient;
            return this;
        }

        public boolean hasHasIngredient() {
            if (this.hasIngredient == null) {
                return false;
            }
            for (CodeableReference item : this.hasIngredient) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableReference addHasIngredient() {
            CodeableReference t = new CodeableReference();
            if (this.hasIngredient == null) {
                this.hasIngredient = new ArrayList<CodeableReference>();
            }
            this.hasIngredient.add(t);
            return t;
        }

        public ManufacturedItemDefinitionComponentConstituentComponent addHasIngredient(CodeableReference t) {
            if (t == null) {
                return this;
            }
            if (this.hasIngredient == null) {
                this.hasIngredient = new ArrayList<CodeableReference>();
            }
            this.hasIngredient.add(t);
            return this;
        }

        public CodeableReference getHasIngredientFirstRep() {
            if (this.getHasIngredient().isEmpty()) {
                this.addHasIngredient();
            }
            return this.getHasIngredient().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("amount", "Quantity", "The measurable amount of the substance, expressable in different ways (e.g. by mass or volume).", 0, Integer.MAX_VALUE, this.amount));
            children.add(new Property("location", "CodeableConcept", "The physical location of the constituent/ingredient within the component. Example \u2013 if the component is the bead in the capsule, then the location would be where the ingredient resides within the product part \u2013 intragranular, extra-granular, etc.", 0, Integer.MAX_VALUE, this.location));
            children.add(new Property("function", "CodeableConcept", "The function of this constituent within the component e.g. binder.", 0, Integer.MAX_VALUE, this.function));
            children.add(new Property("hasIngredient", "CodeableReference(Ingredient)", "The ingredient that is the constituent of the given component.", 0, Integer.MAX_VALUE, this.hasIngredient));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1413853096: {
                    return new Property("amount", "Quantity", "The measurable amount of the substance, expressable in different ways (e.g. by mass or volume).", 0, Integer.MAX_VALUE, this.amount);
                }
                case 1901043637: {
                    return new Property("location", "CodeableConcept", "The physical location of the constituent/ingredient within the component. Example \u2013 if the component is the bead in the capsule, then the location would be where the ingredient resides within the product part \u2013 intragranular, extra-granular, etc.", 0, Integer.MAX_VALUE, this.location);
                }
                case 1380938712: {
                    return new Property("function", "CodeableConcept", "The function of this constituent within the component e.g. binder.", 0, Integer.MAX_VALUE, this.function);
                }
                case 483059723: {
                    return new Property("hasIngredient", "CodeableReference(Ingredient)", "The ingredient that is the constituent of the given component.", 0, Integer.MAX_VALUE, this.hasIngredient);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1413853096: {
                    return this.amount == null ? new Base[]{} : this.amount.toArray(new Base[this.amount.size()]);
                }
                case 1901043637: {
                    return this.location == null ? new Base[]{} : this.location.toArray(new Base[this.location.size()]);
                }
                case 1380938712: {
                    return this.function == null ? new Base[]{} : this.function.toArray(new Base[this.function.size()]);
                }
                case 483059723: {
                    return this.hasIngredient == null ? new Base[]{} : this.hasIngredient.toArray(new Base[this.hasIngredient.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1413853096: {
                    this.getAmount().add(TypeConvertor.castToQuantity(value));
                    return value;
                }
                case 1901043637: {
                    this.getLocation().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 1380938712: {
                    this.getFunction().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 483059723: {
                    this.getHasIngredient().add(TypeConvertor.castToCodeableReference(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("amount")) {
                this.getAmount().add(TypeConvertor.castToQuantity(value));
            } else if (name.equals("location")) {
                this.getLocation().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("function")) {
                this.getFunction().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("hasIngredient")) {
                this.getHasIngredient().add(TypeConvertor.castToCodeableReference(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1413853096: {
                    return this.addAmount();
                }
                case 1901043637: {
                    return this.addLocation();
                }
                case 1380938712: {
                    return this.addFunction();
                }
                case 483059723: {
                    return this.addHasIngredient();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1413853096: {
                    return new String[]{"Quantity"};
                }
                case 1901043637: {
                    return new String[]{"CodeableConcept"};
                }
                case 1380938712: {
                    return new String[]{"CodeableConcept"};
                }
                case 483059723: {
                    return new String[]{"CodeableReference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("amount")) {
                return this.addAmount();
            }
            if (name.equals("location")) {
                return this.addLocation();
            }
            if (name.equals("function")) {
                return this.addFunction();
            }
            if (name.equals("hasIngredient")) {
                return this.addHasIngredient();
            }
            return super.addChild(name);
        }

        @Override
        public ManufacturedItemDefinitionComponentConstituentComponent copy() {
            ManufacturedItemDefinitionComponentConstituentComponent dst = new ManufacturedItemDefinitionComponentConstituentComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ManufacturedItemDefinitionComponentConstituentComponent dst) {
            super.copyValues(dst);
            if (this.amount != null) {
                dst.amount = new ArrayList<Quantity>();
                for (Quantity quantity : this.amount) {
                    dst.amount.add(quantity.copy());
                }
            }
            if (this.location != null) {
                dst.location = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.location) {
                    dst.location.add(codeableConcept.copy());
                }
            }
            if (this.function != null) {
                dst.function = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.function) {
                    dst.function.add(codeableConcept.copy());
                }
            }
            if (this.hasIngredient != null) {
                dst.hasIngredient = new ArrayList<CodeableReference>();
                for (CodeableReference codeableReference : this.hasIngredient) {
                    dst.hasIngredient.add(codeableReference.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ManufacturedItemDefinitionComponentConstituentComponent)) {
                return false;
            }
            ManufacturedItemDefinitionComponentConstituentComponent o = (ManufacturedItemDefinitionComponentConstituentComponent)other_;
            return ManufacturedItemDefinitionComponentConstituentComponent.compareDeep(this.amount, o.amount, true) && ManufacturedItemDefinitionComponentConstituentComponent.compareDeep(this.location, o.location, true) && ManufacturedItemDefinitionComponentConstituentComponent.compareDeep(this.function, o.function, true) && ManufacturedItemDefinitionComponentConstituentComponent.compareDeep(this.hasIngredient, o.hasIngredient, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ManufacturedItemDefinitionComponentConstituentComponent)) {
                return false;
            }
            ManufacturedItemDefinitionComponentConstituentComponent o = (ManufacturedItemDefinitionComponentConstituentComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.amount, this.location, this.function, this.hasIngredient});
        }

        @Override
        public String fhirType() {
            return "ManufacturedItemDefinition.component.constituent";
        }
    }

    @Block
    public static class ManufacturedItemDefinitionComponentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Defining type of the component e.g. shell, layer, ink", formalDefinition="Defining type of the component e.g. shell, layer, ink.")
        protected CodeableConcept type;
        @Child(name="function", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The function of this component within the item e.g. delivers active ingredient, masks taste", formalDefinition="The function of this component within the item e.g. delivers active ingredient, masks taste.")
        protected List<CodeableConcept> function;
        @Child(name="amount", type={Quantity.class}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The measurable amount of total quantity of all substances in the component, expressable in different ways (e.g. by mass or volume)", formalDefinition="The measurable amount of total quantity of all substances in the component, expressable in different ways (e.g. by mass or volume).")
        protected List<Quantity> amount;
        @Child(name="constituent", type={}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="A reference to a constituent of the manufactured item as a whole, linked here so that its component location within the item can be indicated. This not where the item's ingredient are primarily stated (for which see Ingredient.for or ManufacturedItemDefinition.ingredient)", formalDefinition="A reference to a constituent of the manufactured item as a whole, linked here so that its component location within the item can be indicated. This not where the item's ingredient are primarily stated (for which see Ingredient.for or ManufacturedItemDefinition.ingredient).")
        protected List<ManufacturedItemDefinitionComponentConstituentComponent> constituent;
        @Child(name="property", type={ManufacturedItemDefinitionPropertyComponent.class}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="General characteristics of this component", formalDefinition="General characteristics of this component.")
        protected List<ManufacturedItemDefinitionPropertyComponent> property;
        @Child(name="component", type={ManufacturedItemDefinitionComponentComponent.class}, order=6, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="A component that this component contains or is made from", formalDefinition="A component that this component contains or is made from.")
        protected List<ManufacturedItemDefinitionComponentComponent> component;
        private static final long serialVersionUID = 537950590L;

        public ManufacturedItemDefinitionComponentComponent() {
        }

        public ManufacturedItemDefinitionComponentComponent(CodeableConcept type) {
            this.setType(type);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ManufacturedItemDefinitionComponentComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ManufacturedItemDefinitionComponentComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public List<CodeableConcept> getFunction() {
            if (this.function == null) {
                this.function = new ArrayList<CodeableConcept>();
            }
            return this.function;
        }

        public ManufacturedItemDefinitionComponentComponent setFunction(List<CodeableConcept> theFunction) {
            this.function = theFunction;
            return this;
        }

        public boolean hasFunction() {
            if (this.function == null) {
                return false;
            }
            for (CodeableConcept item : this.function) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addFunction() {
            CodeableConcept t = new CodeableConcept();
            if (this.function == null) {
                this.function = new ArrayList<CodeableConcept>();
            }
            this.function.add(t);
            return t;
        }

        public ManufacturedItemDefinitionComponentComponent addFunction(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.function == null) {
                this.function = new ArrayList<CodeableConcept>();
            }
            this.function.add(t);
            return this;
        }

        public CodeableConcept getFunctionFirstRep() {
            if (this.getFunction().isEmpty()) {
                this.addFunction();
            }
            return this.getFunction().get(0);
        }

        public List<Quantity> getAmount() {
            if (this.amount == null) {
                this.amount = new ArrayList<Quantity>();
            }
            return this.amount;
        }

        public ManufacturedItemDefinitionComponentComponent setAmount(List<Quantity> theAmount) {
            this.amount = theAmount;
            return this;
        }

        public boolean hasAmount() {
            if (this.amount == null) {
                return false;
            }
            for (Quantity item : this.amount) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Quantity addAmount() {
            Quantity t = new Quantity();
            if (this.amount == null) {
                this.amount = new ArrayList<Quantity>();
            }
            this.amount.add(t);
            return t;
        }

        public ManufacturedItemDefinitionComponentComponent addAmount(Quantity t) {
            if (t == null) {
                return this;
            }
            if (this.amount == null) {
                this.amount = new ArrayList<Quantity>();
            }
            this.amount.add(t);
            return this;
        }

        public Quantity getAmountFirstRep() {
            if (this.getAmount().isEmpty()) {
                this.addAmount();
            }
            return this.getAmount().get(0);
        }

        public List<ManufacturedItemDefinitionComponentConstituentComponent> getConstituent() {
            if (this.constituent == null) {
                this.constituent = new ArrayList<ManufacturedItemDefinitionComponentConstituentComponent>();
            }
            return this.constituent;
        }

        public ManufacturedItemDefinitionComponentComponent setConstituent(List<ManufacturedItemDefinitionComponentConstituentComponent> theConstituent) {
            this.constituent = theConstituent;
            return this;
        }

        public boolean hasConstituent() {
            if (this.constituent == null) {
                return false;
            }
            for (ManufacturedItemDefinitionComponentConstituentComponent item : this.constituent) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ManufacturedItemDefinitionComponentConstituentComponent addConstituent() {
            ManufacturedItemDefinitionComponentConstituentComponent t = new ManufacturedItemDefinitionComponentConstituentComponent();
            if (this.constituent == null) {
                this.constituent = new ArrayList<ManufacturedItemDefinitionComponentConstituentComponent>();
            }
            this.constituent.add(t);
            return t;
        }

        public ManufacturedItemDefinitionComponentComponent addConstituent(ManufacturedItemDefinitionComponentConstituentComponent t) {
            if (t == null) {
                return this;
            }
            if (this.constituent == null) {
                this.constituent = new ArrayList<ManufacturedItemDefinitionComponentConstituentComponent>();
            }
            this.constituent.add(t);
            return this;
        }

        public ManufacturedItemDefinitionComponentConstituentComponent getConstituentFirstRep() {
            if (this.getConstituent().isEmpty()) {
                this.addConstituent();
            }
            return this.getConstituent().get(0);
        }

        public List<ManufacturedItemDefinitionPropertyComponent> getProperty() {
            if (this.property == null) {
                this.property = new ArrayList<ManufacturedItemDefinitionPropertyComponent>();
            }
            return this.property;
        }

        public ManufacturedItemDefinitionComponentComponent setProperty(List<ManufacturedItemDefinitionPropertyComponent> theProperty) {
            this.property = theProperty;
            return this;
        }

        public boolean hasProperty() {
            if (this.property == null) {
                return false;
            }
            for (ManufacturedItemDefinitionPropertyComponent item : this.property) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ManufacturedItemDefinitionPropertyComponent addProperty() {
            ManufacturedItemDefinitionPropertyComponent t = new ManufacturedItemDefinitionPropertyComponent();
            if (this.property == null) {
                this.property = new ArrayList<ManufacturedItemDefinitionPropertyComponent>();
            }
            this.property.add(t);
            return t;
        }

        public ManufacturedItemDefinitionComponentComponent addProperty(ManufacturedItemDefinitionPropertyComponent t) {
            if (t == null) {
                return this;
            }
            if (this.property == null) {
                this.property = new ArrayList<ManufacturedItemDefinitionPropertyComponent>();
            }
            this.property.add(t);
            return this;
        }

        public ManufacturedItemDefinitionPropertyComponent getPropertyFirstRep() {
            if (this.getProperty().isEmpty()) {
                this.addProperty();
            }
            return this.getProperty().get(0);
        }

        public List<ManufacturedItemDefinitionComponentComponent> getComponent() {
            if (this.component == null) {
                this.component = new ArrayList<ManufacturedItemDefinitionComponentComponent>();
            }
            return this.component;
        }

        public ManufacturedItemDefinitionComponentComponent setComponent(List<ManufacturedItemDefinitionComponentComponent> theComponent) {
            this.component = theComponent;
            return this;
        }

        public boolean hasComponent() {
            if (this.component == null) {
                return false;
            }
            for (ManufacturedItemDefinitionComponentComponent item : this.component) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ManufacturedItemDefinitionComponentComponent addComponent() {
            ManufacturedItemDefinitionComponentComponent t = new ManufacturedItemDefinitionComponentComponent();
            if (this.component == null) {
                this.component = new ArrayList<ManufacturedItemDefinitionComponentComponent>();
            }
            this.component.add(t);
            return t;
        }

        public ManufacturedItemDefinitionComponentComponent addComponent(ManufacturedItemDefinitionComponentComponent t) {
            if (t == null) {
                return this;
            }
            if (this.component == null) {
                this.component = new ArrayList<ManufacturedItemDefinitionComponentComponent>();
            }
            this.component.add(t);
            return this;
        }

        public ManufacturedItemDefinitionComponentComponent getComponentFirstRep() {
            if (this.getComponent().isEmpty()) {
                this.addComponent();
            }
            return this.getComponent().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Defining type of the component e.g. shell, layer, ink.", 0, 1, this.type));
            children.add(new Property("function", "CodeableConcept", "The function of this component within the item e.g. delivers active ingredient, masks taste.", 0, Integer.MAX_VALUE, this.function));
            children.add(new Property("amount", "Quantity", "The measurable amount of total quantity of all substances in the component, expressable in different ways (e.g. by mass or volume).", 0, Integer.MAX_VALUE, this.amount));
            children.add(new Property("constituent", "", "A reference to a constituent of the manufactured item as a whole, linked here so that its component location within the item can be indicated. This not where the item's ingredient are primarily stated (for which see Ingredient.for or ManufacturedItemDefinition.ingredient).", 0, Integer.MAX_VALUE, this.constituent));
            children.add(new Property("property", "@ManufacturedItemDefinition.property", "General characteristics of this component.", 0, Integer.MAX_VALUE, this.property));
            children.add(new Property("component", "@ManufacturedItemDefinition.component", "A component that this component contains or is made from.", 0, Integer.MAX_VALUE, this.component));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Defining type of the component e.g. shell, layer, ink.", 0, 1, this.type);
                }
                case 1380938712: {
                    return new Property("function", "CodeableConcept", "The function of this component within the item e.g. delivers active ingredient, masks taste.", 0, Integer.MAX_VALUE, this.function);
                }
                case -1413853096: {
                    return new Property("amount", "Quantity", "The measurable amount of total quantity of all substances in the component, expressable in different ways (e.g. by mass or volume).", 0, Integer.MAX_VALUE, this.amount);
                }
                case -1846470364: {
                    return new Property("constituent", "", "A reference to a constituent of the manufactured item as a whole, linked here so that its component location within the item can be indicated. This not where the item's ingredient are primarily stated (for which see Ingredient.for or ManufacturedItemDefinition.ingredient).", 0, Integer.MAX_VALUE, this.constituent);
                }
                case -993141291: {
                    return new Property("property", "@ManufacturedItemDefinition.property", "General characteristics of this component.", 0, Integer.MAX_VALUE, this.property);
                }
                case -1399907075: {
                    return new Property("component", "@ManufacturedItemDefinition.component", "A component that this component contains or is made from.", 0, Integer.MAX_VALUE, this.component);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 1380938712: {
                    return this.function == null ? new Base[]{} : this.function.toArray(new Base[this.function.size()]);
                }
                case -1413853096: {
                    return this.amount == null ? new Base[]{} : this.amount.toArray(new Base[this.amount.size()]);
                }
                case -1846470364: {
                    return this.constituent == null ? new Base[]{} : this.constituent.toArray(new Base[this.constituent.size()]);
                }
                case -993141291: {
                    return this.property == null ? new Base[]{} : this.property.toArray(new Base[this.property.size()]);
                }
                case -1399907075: {
                    return this.component == null ? new Base[]{} : this.component.toArray(new Base[this.component.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 1380938712: {
                    this.getFunction().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -1413853096: {
                    this.getAmount().add(TypeConvertor.castToQuantity(value));
                    return value;
                }
                case -1846470364: {
                    this.getConstituent().add((ManufacturedItemDefinitionComponentConstituentComponent)value);
                    return value;
                }
                case -993141291: {
                    this.getProperty().add((ManufacturedItemDefinitionPropertyComponent)value);
                    return value;
                }
                case -1399907075: {
                    this.getComponent().add((ManufacturedItemDefinitionComponentComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("function")) {
                this.getFunction().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("amount")) {
                this.getAmount().add(TypeConvertor.castToQuantity(value));
            } else if (name.equals("constituent")) {
                this.getConstituent().add((ManufacturedItemDefinitionComponentConstituentComponent)value);
            } else if (name.equals("property")) {
                this.getProperty().add((ManufacturedItemDefinitionPropertyComponent)value);
            } else if (name.equals("component")) {
                this.getComponent().add((ManufacturedItemDefinitionComponentComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 1380938712: {
                    return this.addFunction();
                }
                case -1413853096: {
                    return this.addAmount();
                }
                case -1846470364: {
                    return this.addConstituent();
                }
                case -993141291: {
                    return this.addProperty();
                }
                case -1399907075: {
                    return this.addComponent();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 1380938712: {
                    return new String[]{"CodeableConcept"};
                }
                case -1413853096: {
                    return new String[]{"Quantity"};
                }
                case -1846470364: {
                    return new String[0];
                }
                case -993141291: {
                    return new String[]{"@ManufacturedItemDefinition.property"};
                }
                case -1399907075: {
                    return new String[]{"@ManufacturedItemDefinition.component"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("function")) {
                return this.addFunction();
            }
            if (name.equals("amount")) {
                return this.addAmount();
            }
            if (name.equals("constituent")) {
                return this.addConstituent();
            }
            if (name.equals("property")) {
                return this.addProperty();
            }
            if (name.equals("component")) {
                return this.addComponent();
            }
            return super.addChild(name);
        }

        @Override
        public ManufacturedItemDefinitionComponentComponent copy() {
            ManufacturedItemDefinitionComponentComponent dst = new ManufacturedItemDefinitionComponentComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ManufacturedItemDefinitionComponentComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
            if (this.function != null) {
                dst.function = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.function) {
                    dst.function.add(codeableConcept2.copy());
                }
            }
            if (this.amount != null) {
                dst.amount = new ArrayList<Quantity>();
                for (Quantity quantity : this.amount) {
                    dst.amount.add(quantity.copy());
                }
            }
            if (this.constituent != null) {
                dst.constituent = new ArrayList<ManufacturedItemDefinitionComponentConstituentComponent>();
                for (ManufacturedItemDefinitionComponentConstituentComponent manufacturedItemDefinitionComponentConstituentComponent : this.constituent) {
                    dst.constituent.add(manufacturedItemDefinitionComponentConstituentComponent.copy());
                }
            }
            if (this.property != null) {
                dst.property = new ArrayList<ManufacturedItemDefinitionPropertyComponent>();
                for (ManufacturedItemDefinitionPropertyComponent manufacturedItemDefinitionPropertyComponent : this.property) {
                    dst.property.add(manufacturedItemDefinitionPropertyComponent.copy());
                }
            }
            if (this.component != null) {
                dst.component = new ArrayList<ManufacturedItemDefinitionComponentComponent>();
                for (ManufacturedItemDefinitionComponentComponent manufacturedItemDefinitionComponentComponent : this.component) {
                    dst.component.add(manufacturedItemDefinitionComponentComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ManufacturedItemDefinitionComponentComponent)) {
                return false;
            }
            ManufacturedItemDefinitionComponentComponent o = (ManufacturedItemDefinitionComponentComponent)other_;
            return ManufacturedItemDefinitionComponentComponent.compareDeep(this.type, o.type, true) && ManufacturedItemDefinitionComponentComponent.compareDeep(this.function, o.function, true) && ManufacturedItemDefinitionComponentComponent.compareDeep(this.amount, o.amount, true) && ManufacturedItemDefinitionComponentComponent.compareDeep(this.constituent, o.constituent, true) && ManufacturedItemDefinitionComponentComponent.compareDeep(this.property, o.property, true) && ManufacturedItemDefinitionComponentComponent.compareDeep(this.component, o.component, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ManufacturedItemDefinitionComponentComponent)) {
                return false;
            }
            ManufacturedItemDefinitionComponentComponent o = (ManufacturedItemDefinitionComponentComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.function, this.amount, this.constituent, this.property, this.component});
        }

        @Override
        public String fhirType() {
            return "ManufacturedItemDefinition.component";
        }
    }

    @Block
    public static class ManufacturedItemDefinitionPropertyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A code expressing the type of characteristic", formalDefinition="A code expressing the type of characteristic.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/product-characteristic-codes")
        protected CodeableConcept type;
        @Child(name="value", type={CodeableConcept.class, Quantity.class, DateType.class, BooleanType.class, MarkdownType.class, Attachment.class, Binary.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A value for the characteristic", formalDefinition="A value for the characteristic.")
        protected DataType value;
        private static final long serialVersionUID = -1659186716L;

        public ManufacturedItemDefinitionPropertyComponent() {
        }

        public ManufacturedItemDefinitionPropertyComponent(CodeableConcept type) {
            this.setType(type);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ManufacturedItemDefinitionPropertyComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ManufacturedItemDefinitionPropertyComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public CodeableConcept getValueCodeableConcept() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeableConcept();
            }
            if (!(this.value instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.value;
        }

        public boolean hasValueCodeableConcept() {
            return this != null && this.value instanceof CodeableConcept;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                this.value = new Quantity();
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this != null && this.value instanceof Quantity;
        }

        public DateType getValueDateType() throws FHIRException {
            if (this.value == null) {
                this.value = new DateType();
            }
            if (!(this.value instanceof DateType)) {
                throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateType)this.value;
        }

        public boolean hasValueDateType() {
            return this != null && this.value instanceof DateType;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (this.value == null) {
                this.value = new BooleanType();
            }
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this != null && this.value instanceof BooleanType;
        }

        public MarkdownType getValueMarkdownType() throws FHIRException {
            if (this.value == null) {
                this.value = new MarkdownType();
            }
            if (!(this.value instanceof MarkdownType)) {
                throw new FHIRException("Type mismatch: the type MarkdownType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (MarkdownType)this.value;
        }

        public boolean hasValueMarkdownType() {
            return this != null && this.value instanceof MarkdownType;
        }

        public Attachment getValueAttachment() throws FHIRException {
            if (this.value == null) {
                this.value = new Attachment();
            }
            if (!(this.value instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Attachment)this.value;
        }

        public boolean hasValueAttachment() {
            return this != null && this.value instanceof Attachment;
        }

        public Reference getValueReference() throws FHIRException {
            if (this.value == null) {
                this.value = new Reference();
            }
            if (!(this.value instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Reference)this.value;
        }

        public boolean hasValueReference() {
            return this != null && this.value instanceof Reference;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ManufacturedItemDefinitionPropertyComponent setValue(DataType value) {
            if (!(value == null || value instanceof CodeableConcept || value instanceof Quantity || value instanceof DateType || value instanceof BooleanType || value instanceof MarkdownType || value instanceof Attachment || value instanceof Reference)) {
                throw new FHIRException("Not the right type for ManufacturedItemDefinition.property.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "A code expressing the type of characteristic.", 0, 1, this.type));
            children.add(new Property("value[x]", "CodeableConcept|Quantity|date|boolean|markdown|Attachment|Reference(Binary)", "A value for the characteristic.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "A code expressing the type of characteristic.", 0, 1, this.type);
                }
                case -1410166417: {
                    return new Property("value[x]", "CodeableConcept|Quantity|date|boolean|markdown|Attachment|Reference(Binary)", "A value for the characteristic.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "CodeableConcept|Quantity|date|boolean|markdown|Attachment|Reference(Binary)", "A value for the characteristic.", 0, 1, this.value);
                }
                case 924902896: {
                    return new Property("value[x]", "CodeableConcept", "A value for the characteristic.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "Quantity", "A value for the characteristic.", 0, 1, this.value);
                }
                case -766192449: {
                    return new Property("value[x]", "date", "A value for the characteristic.", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "boolean", "A value for the characteristic.", 0, 1, this.value);
                }
                case -497880704: {
                    return new Property("value[x]", "markdown", "A value for the characteristic.", 0, 1, this.value);
                }
                case -475566732: {
                    return new Property("value[x]", "Attachment", "A value for the characteristic.", 0, 1, this.value);
                }
                case 1755241690: {
                    return new Property("value[x]", "Reference(Binary)", "A value for the characteristic.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"CodeableConcept", "Quantity", "date", "boolean", "markdown", "Attachment", "Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueDate")) {
                this.value = new DateType();
                return this.value;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueMarkdown")) {
                this.value = new MarkdownType();
                return this.value;
            }
            if (name.equals("valueAttachment")) {
                this.value = new Attachment();
                return this.value;
            }
            if (name.equals("valueReference")) {
                this.value = new Reference();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public ManufacturedItemDefinitionPropertyComponent copy() {
            ManufacturedItemDefinitionPropertyComponent dst = new ManufacturedItemDefinitionPropertyComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ManufacturedItemDefinitionPropertyComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ManufacturedItemDefinitionPropertyComponent)) {
                return false;
            }
            ManufacturedItemDefinitionPropertyComponent o = (ManufacturedItemDefinitionPropertyComponent)other_;
            return ManufacturedItemDefinitionPropertyComponent.compareDeep(this.type, o.type, true) && ManufacturedItemDefinitionPropertyComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ManufacturedItemDefinitionPropertyComponent)) {
                return false;
            }
            ManufacturedItemDefinitionPropertyComponent o = (ManufacturedItemDefinitionPropertyComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.value});
        }

        @Override
        public String fhirType() {
            return "ManufacturedItemDefinition.property";
        }
    }
}

