/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.utils.TranslatingUtilities;
import org.hl7.fhir.utilities.MarkDownProcessor;
import org.hl7.fhir.utilities.StandardsStatus;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationOptions;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class Renderer
extends TranslatingUtilities {
    protected RenderingContext context;
    protected static final String RENDER_BUNDLE_HEADER_ROOT = "RENDER_BUNDLE_HEADER_ROOT";
    protected static final String RENDER_BUNDLE_HEADER_ENTRY = "RENDER_BUNDLE_HEADER_ENTRY";
    protected static final String RENDER_BUNDLE_HEADER_ENTRY_URL = "RENDER_BUNDLE_HEADER_ENTRY_URL";
    protected static final String RENDER_BUNDLE_RESOURCE = "RENDER_BUNDLE_RESOURCE";
    protected static final String RENDER_BUNDLE_SEARCH = "RENDER_BUNDLE_SEARCH";
    protected static final String RENDER_BUNDLE_SEARCH_MODE = "RENDER_BUNDLE_SEARCH_MODE";
    protected static final String RENDER_BUNDLE_SEARCH_SCORE = "RENDER_BUNDLE_SEARCH_SCORE";
    protected static final String RENDER_BUNDLE_RESPONSE = "RENDER_BUNDLE_RESPONSE";
    protected static final String RENDER_BUNDLE_LOCATION = "RENDER_BUNDLE_LOCATION";
    protected static final String RENDER_BUNDLE_ETAG = "RENDER_BUNDLE_ETAG";
    protected static final String RENDER_BUNDLE_LAST_MOD = "RENDER_BUNDLE_LAST_MOD";
    protected static final String RENDER_BUNDLE_REQUEST = "RENDER_BUNDLE_REQUEST";
    protected static final String RENDER_BUNDLE_IF_NON_MATCH = "RENDER_BUNDLE_IF_NON_MATCH";
    protected static final String RENDER_BUNDLE_IF_MOD = "RENDER_BUNDLE_IF_MOD";
    protected static final String RENDER_BUNDLE_IF_MATCH = "RENDER_BUNDLE_IF_MATCH";
    protected static final String RENDER_BUNDLE_IF_NONE = "RENDER_BUNDLE_IF_NONE";
    protected static final String RENDER_BUNDLE_DOCUMENT_CONTENT = "RENDER_BUNDLE_DOCUMENT_CONTENT";
    protected static final String RENDER_BUNDLE_HEADER_DOC_ENTRY_URD = "RENDER_BUNDLE_HEADER_DOC_ENTRY_URD";
    protected static final String RENDER_BUNDLE_HEADER_DOC_ENTRY_U = "RENDER_BUNDLE_HEADER_DOC_ENTRY_U";
    protected static final String RENDER_BUNDLE_HEADER_DOC_ENTRY_RD = "RENDER_BUNDLE_HEADER_DOC_ENTRY_RD";

    public Renderer(RenderingContext context) {
        this.context = context;
    }

    public Renderer(IWorkerContext worker) {
        this.context = new RenderingContext(worker, new MarkDownProcessor(MarkDownProcessor.Dialect.COMMON_MARK), ValidationOptions.defaults(), "http://hl7.org/fhir/R5", "", null, RenderingContext.ResourceRendererMode.END_USER, RenderingContext.GenerationRules.IG_PUBLISHER);
    }

    protected String formatMessage(String theMessage, Object ... theMessageArguments) {
        return this.context.getWorker().formatMessage(theMessage, theMessageArguments);
    }

    public void genStandardsStatus(XhtmlNode td, StandardsStatus ss) {
        if (ss != null) {
            td.tx(" ");
            XhtmlNode a = td.ah(Utilities.pathURL((String[])new String[]{this.context.getLink(RenderingContext.KnownLinkType.SPEC), "versions.html#std-process"}), "Standards Status = " + ss.toDisplay());
            a.style("padding-left: 3px; padding-right: 3px; border: 1px grey solid; font-weight: bold; color: black; background-color: " + ss.getColor());
            a.tx(ss.getAbbrev());
        }
    }
}

