/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Meta;
import org.hl7.fhir.r5.model.UriType;

public class ConceptMapUtilities {
    public static boolean hasOID(ConceptMap cm) {
        return ConceptMapUtilities.getOID(cm) != null;
    }

    public static String getOID(ConceptMap cm) {
        for (Identifier id : cm.getIdentifier()) {
            if (!"urn:ietf:rfc:3986".equals(id.getSystem()) || !id.hasValue() || !id.getValue().startsWith("urn:oid:")) continue;
            return id.getValue().substring(8);
        }
        return null;
    }

    public static void setOID(ConceptMap cm, String oid) {
        if (!((String)oid).startsWith("urn:oid:")) {
            oid = "urn:oid:" + (String)oid;
        }
        for (Identifier id : cm.getIdentifier()) {
            if (!"urn:ietf:rfc:3986".equals(id.getSystem()) || !id.hasValue() || !id.getValue().startsWith("urn:oid:")) continue;
            id.setValue((String)oid);
            return;
        }
        cm.addIdentifier().setSystem("urn:ietf:rfc:3986").setValue((String)oid);
    }

    public static boolean hasMappingForSource(ConceptMap cm, String system, String version, String code) {
        for (ConceptMap.ConceptMapGroupComponent grp : cm.getGroup()) {
            if (!system.equals(grp.getSource())) continue;
            for (ConceptMap.SourceElementComponent e : grp.getElement()) {
                if (!code.equals(e.getCode())) continue;
                return true;
            }
        }
        return false;
    }

    public static List<Coding> listTargets(ConceptMap cm, List<String> systems) {
        ArrayList<Coding> list = new ArrayList<Coding>();
        for (ConceptMap.ConceptMapGroupComponent grp : cm.getGroup()) {
            if (!systems.isEmpty() && !systems.contains(grp.getSource())) continue;
            for (ConceptMap.SourceElementComponent e : grp.getElement()) {
                for (ConceptMap.TargetElementComponent t : e.getTarget()) {
                    if (!t.hasCode()) continue;
                    list.add(new Coding(grp.getTarget(), t.getCode(), t.getDisplay()));
                }
            }
        }
        return list;
    }

    public static ConceptMap makeShareable(ConceptMap cm) {
        if (!cm.hasExperimental()) {
            cm.setExperimental(false);
        }
        if (!cm.hasMeta()) {
            cm.setMeta(new Meta());
        }
        for (UriType uriType : cm.getMeta().getProfile()) {
            if (!"http://hl7.org/fhir/StructureDefinition/shareableconceptmap".equals(uriType.getValue())) continue;
            return cm;
        }
        cm.getMeta().getProfile().add(new CanonicalType("http://hl7.org/fhir/StructureDefinition/shareableconceptmap"));
        return cm;
    }
}

