/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.elementmodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.context.ContextUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.Property;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public abstract class ParserBase {
    protected IWorkerContext context;
    protected ValidationPolicy policy;
    protected List<ValidationMessage> errors;
    protected ILinkResolver linkResolver;
    protected boolean showDecorations;
    protected IdRenderingPolicy idPolicy = IdRenderingPolicy.All;
    protected StructureDefinition logical;

    public boolean isPrimitive(String code) {
        StructureDefinition sd = this.context.fetchTypeDefinition(code);
        if (sd != null) {
            return sd.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE;
        }
        return Utilities.existsInList((String)code, (String[])new String[]{"boolean", "integer", "integer64", "string", "decimal", "uri", "base64Binary", "instant", "date", "dateTime", "time", "code", "oid", "id", "markdown", "unsignedInt", "positiveInt", "uuid", "xhtml", "url", "canonical"});
    }

    public ParserBase(IWorkerContext context) {
        this.context = context;
        this.policy = ValidationPolicy.NONE;
    }

    public void setupValidation(ValidationPolicy policy, List<ValidationMessage> errors) {
        this.policy = policy;
        this.errors = errors;
    }

    public abstract List<NamedElement> parse(InputStream var1) throws IOException, FHIRFormatError, DefinitionException, FHIRException;

    public Element parseSingle(InputStream stream) throws IOException, FHIRFormatError, DefinitionException, FHIRException {
        List<NamedElement> res = this.parse(stream);
        if (res == null) {
            throw new FHIRException("Parsing FHIR content failed: " + this.errors.get(0).summary());
        }
        if (res.size() == 0) {
            throw new FHIRException("Parsing FHIR content returned no elements in a context where one element is required because: " + this.errors.get(0).summary());
        }
        if (res.size() != 1) {
            throw new FHIRException("Parsing FHIR content returned multiple elements in a context where only one element is allowed");
        }
        return res.get(0).getElement();
    }

    public abstract void compose(Element var1, OutputStream var2, IParser.OutputStyle var3, String var4) throws FHIRException, IOException;

    public void logError(String ruleDate, int line, int col, String path, ValidationMessage.IssueType type, String message, ValidationMessage.IssueSeverity level) throws FHIRFormatError {
        if (this.errors != null) {
            if (this.policy == ValidationPolicy.EVERYTHING) {
                ValidationMessage msg = new ValidationMessage(ValidationMessage.Source.InstanceValidator, type, line, col, path, message, level);
                msg.setRuleDate(ruleDate);
                this.errors.add(msg);
            } else if (level == ValidationMessage.IssueSeverity.FATAL || level == ValidationMessage.IssueSeverity.ERROR && this.policy == ValidationPolicy.QUICK) {
                throw new FHIRFormatError(message + String.format(" at line %d col %d", line, col));
            }
        }
    }

    protected StructureDefinition getDefinition(int line, int col, String ns, String name) throws FHIRFormatError {
        if (ns == null) {
            this.logError(ValidationMessage.NO_RULE_DATE, line, col, name, ValidationMessage.IssueType.STRUCTURE, this.context.formatMessage("This__cannot_be_parsed_as_a_FHIR_object_no_namespace", name), ValidationMessage.IssueSeverity.FATAL);
            return null;
        }
        if (name == null) {
            this.logError(ValidationMessage.NO_RULE_DATE, line, col, name, ValidationMessage.IssueType.STRUCTURE, this.context.formatMessage("This_cannot_be_parsed_as_a_FHIR_object_no_name", new Object[0]), ValidationMessage.IssueSeverity.FATAL);
            return null;
        }
        for (StructureDefinition sd : new ContextUtilities(this.context).allStructures()) {
            if (sd.getDerivation() != StructureDefinition.TypeDerivationRule.SPECIALIZATION || sd.getUrl().startsWith("http://hl7.org/fhir/StructureDefinition/de-")) continue;
            if (name.equals(sd.getType()) && (ns == null || ns.equals("http://hl7.org/fhir")) && !ToolingExtensions.hasExtension(sd, "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace")) {
                return sd;
            }
            String sns = ToolingExtensions.readStringExtension(sd, "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace");
            if (!name.equals(sd.getType()) && !name.equals(sd.getName()) || ns == null || !ns.equals(sns)) continue;
            return sd;
        }
        this.logError(ValidationMessage.NO_RULE_DATE, line, col, name, ValidationMessage.IssueType.STRUCTURE, this.context.formatMessage("This_does_not_appear_to_be_a_FHIR_resource_unknown_namespacename_", ns, name), ValidationMessage.IssueSeverity.FATAL);
        return null;
    }

    protected StructureDefinition getDefinition(int line, int col, String name) throws FHIRFormatError {
        if (name == null) {
            this.logError(ValidationMessage.NO_RULE_DATE, line, col, name, ValidationMessage.IssueType.STRUCTURE, this.context.formatMessage("This_cannot_be_parsed_as_a_FHIR_object_no_name", new Object[0]), ValidationMessage.IssueSeverity.FATAL);
            return null;
        }
        for (StructureDefinition sd : this.context.fetchResourcesByType(StructureDefinition.class)) {
            if (!sd.getUrl().equals("http://hl7.org/fhir/StructureDefinition/" + name)) continue;
            new ContextUtilities(this.context).generateSnapshot(sd);
            return sd;
        }
        for (StructureDefinition sd : this.context.fetchResourcesByType(StructureDefinition.class)) {
            if (!name.equals(sd.getType()) || sd.getDerivation() != StructureDefinition.TypeDerivationRule.SPECIALIZATION) continue;
            new ContextUtilities(this.context).generateSnapshot(sd);
            return sd;
        }
        this.logError(ValidationMessage.NO_RULE_DATE, line, col, name, ValidationMessage.IssueType.STRUCTURE, this.context.formatMessage("This_does_not_appear_to_be_a_FHIR_resource_unknown_name_", name), ValidationMessage.IssueSeverity.FATAL);
        return null;
    }

    public ILinkResolver getLinkResolver() {
        return this.linkResolver;
    }

    public ParserBase setLinkResolver(ILinkResolver linkResolver) {
        this.linkResolver = linkResolver;
        return this;
    }

    public boolean isShowDecorations() {
        return this.showDecorations;
    }

    public void setShowDecorations(boolean showDecorations) {
        this.showDecorations = showDecorations;
    }

    public String getImpliedProfile() {
        return null;
    }

    public IdRenderingPolicy getIdPolicy() {
        return this.idPolicy;
    }

    public void setIdPolicy(IdRenderingPolicy idPolicy) {
        this.idPolicy = idPolicy;
    }

    protected boolean wantCompose(String path, Element e) {
        if (!"id".equals(e.getName())) {
            return true;
        }
        if (path != null && path.contains(".")) {
            return this.idPolicy.forInner();
        }
        return this.idPolicy.forRoot();
    }

    public boolean hasLogical() {
        return this.logical != null;
    }

    public StructureDefinition getLogical() {
        return this.logical;
    }

    public ParserBase setLogical(StructureDefinition logical) {
        this.logical = logical;
        return this;
    }

    public static enum ValidationPolicy {
        NONE,
        QUICK,
        EVERYTHING;

    }

    public static interface ILinkResolver {
        public String resolveType(String var1);

        public String resolveProperty(Property var1);

        public String resolvePage(String var1);
    }

    public class NamedElement {
        private String name;
        private Element element;

        public NamedElement(String name, Element element) {
            this.name = name;
            this.element = element;
        }

        public String getName() {
            return this.name;
        }

        public Element getElement() {
            return this.element;
        }
    }

    public static enum IdRenderingPolicy {
        All,
        None,
        RootOnly,
        NotRoot;


        boolean forRoot() {
            return this == All || this == RootOnly;
        }

        boolean forInner() {
            return this == All || this == NotRoot;
        }
    }
}

