/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies.expansion;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.exceptions.NoTerminologyServiceException;
import org.hl7.fhir.exceptions.TerminologyServiceException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.LanguageUtils;
import org.hl7.fhir.r5.extensions.Extensions;
import org.hl7.fhir.r5.extensions.ExtensionsUtils;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.Factory;
import org.hl7.fhir.r5.model.PackageInformation;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.CodeSystemUtilities;
import org.hl7.fhir.r5.terminologies.ValueSetUtilities;
import org.hl7.fhir.r5.terminologies.expansion.AllConceptsFilter;
import org.hl7.fhir.r5.terminologies.expansion.ConceptFilter;
import org.hl7.fhir.r5.terminologies.expansion.EFinished;
import org.hl7.fhir.r5.terminologies.expansion.ETooCostly;
import org.hl7.fhir.r5.terminologies.expansion.PropertyFilter;
import org.hl7.fhir.r5.terminologies.expansion.RegexFilter;
import org.hl7.fhir.r5.terminologies.expansion.ValueSetExpansionOutcome;
import org.hl7.fhir.r5.terminologies.expansion.WorkingContext;
import org.hl7.fhir.r5.terminologies.providers.CodeSystemProvider;
import org.hl7.fhir.r5.terminologies.providers.CodeSystemProviderExtension;
import org.hl7.fhir.r5.terminologies.utilities.TerminologyServiceErrorClass;
import org.hl7.fhir.utilities.Utilities;

public class ValueSetExpander {
    private static final boolean REPORT_VERSION_ANYWAY = false;
    private IWorkerContext context;
    private ValueSet focus;
    private List<String> allErrors = new ArrayList<String>();
    private List<String> requiredSupplements = new ArrayList<String>();
    private int maxExpansionSize = 1000;
    private WorkingContext dwc = new WorkingContext();
    private boolean checkCodesWhenExpanding;
    private boolean includeAbstract = true;

    public ValueSetExpander(IWorkerContext context) {
        this.context = context;
    }

    public ValueSetExpander(IWorkerContext context, List<String> allErrors) {
        this.context = context;
        this.allErrors = allErrors;
    }

    public void setMaxExpansionSize(int theMaxExpansionSize) {
        this.maxExpansionSize = theMaxExpansionSize;
    }

    private ValueSet.ValueSetExpansionContainsComponent addCode(WorkingContext wc, String system, String code, String display, String dispLang, ValueSet.ValueSetExpansionContainsComponent parent, List<CodeSystem.ConceptDefinitionDesignationComponent> designations, Parameters expParams, boolean isAbstract, boolean inactive, String definition, List<ValueSet> filters, boolean noInactive, boolean deprecated, List<ValueSet.ValueSetExpansionPropertyComponent> vsProp, List<CodeSystem.ConceptPropertyComponent> csProps, List<ValueSet.ConceptPropertyComponent> expProps, List<Extension> csExtList, List<Extension> vsExtList) throws ETooCostly {
        CodeSystem.ConceptDefinitionDesignationComponent tu;
        if (filters != null && !filters.isEmpty() && !this.filterContainsCode(filters, system, code)) {
            return null;
        }
        if (noInactive && inactive) {
            return null;
        }
        ValueSet.ValueSetExpansionContainsComponent n = new ValueSet.ValueSetExpansionContainsComponent();
        n.setSystem(system);
        n.setCode(code);
        if (isAbstract) {
            n.setAbstract(true);
        }
        if (inactive) {
            n.setInactive(true);
        }
        if (deprecated) {
            ValueSetUtilities.setDeprecated(vsProp, n);
        }
        if (expParams.getParameterBool("includeDefinition") && definition != null) {
            n.addExtension(Extensions.makeVSConceptDefinition(definition));
        }
        if (ExtensionsUtils.hasExtension(csExtList, "http://hl7.org/fhir/StructureDefinition/codesystem-label")) {
            ValueSetUtilities.addProperty(this.focus, n, "http://hl7.org/fhir/concept-properties#label", "label", ExtensionsUtils.getExtensionValue(csExtList, "http://hl7.org/fhir/StructureDefinition/codesystem-label"));
        }
        if (ExtensionsUtils.hasExtension(vsExtList, "http://hl7.org/fhir/StructureDefinition/valueset-label")) {
            ValueSetUtilities.addProperty(this.focus, n, "http://hl7.org/fhir/concept-properties#label", "label", ExtensionsUtils.getExtensionValue(vsExtList, "http://hl7.org/fhir/StructureDefinition/valueset-label"));
        }
        if (ExtensionsUtils.hasExtension(csExtList, "http://hl7.org/fhir/StructureDefinition/codesystem-conceptOrder")) {
            ValueSetUtilities.addProperty(this.focus, n, "http://hl7.org/fhir/concept-properties#order", "order", ExtensionsUtils.getExtensionValue(csExtList, "http://hl7.org/fhir/StructureDefinition/codesystem-conceptOrder"));
        }
        if (ExtensionsUtils.hasExtension(vsExtList, "http://hl7.org/fhir/StructureDefinition/valueset-conceptOrder")) {
            ValueSetUtilities.addProperty(this.focus, n, "http://hl7.org/fhir/concept-properties#order", "order", ExtensionsUtils.getExtensionValue(vsExtList, "http://hl7.org/fhir/StructureDefinition/valueset-conceptOrder"));
        }
        if (ExtensionsUtils.hasExtension(csExtList, "http://hl7.org/fhir/StructureDefinition/itemWeight")) {
            ValueSetUtilities.addProperty(this.focus, n, "http://hl7.org/fhir/concept-properties#itemWeight", "weight", ExtensionsUtils.getExtensionValue(csExtList, "http://hl7.org/fhir/StructureDefinition/itemWeight"));
        }
        if (ExtensionsUtils.hasExtension(vsExtList, "http://hl7.org/fhir/StructureDefinition/itemWeight")) {
            ValueSetUtilities.addProperty(this.focus, n, "http://hl7.org/fhir/concept-properties#itemWeight", "weight", ExtensionsUtils.getExtensionValue(vsExtList, "http://hl7.org/fhir/StructureDefinition/itemWeight"));
        }
        ExtensionsUtils.copyExtensions(csExtList, n.getExtension(), "http://hl7.org/fhir/StructureDefinition/coding-sctdescid", "http://hl7.org/fhir/StructureDefinition/rendering-style", "http://hl7.org/fhir/StructureDefinition/rendering-xhtml", "http://hl7.org/fhir/StructureDefinition/codesystem-alternate");
        ExtensionsUtils.copyExtensions(vsExtList, n.getExtension(), "http://hl7.org/fhir/StructureDefinition/valueset-supplement", "http://hl7.org/fhir/StructureDefinition/valueset-deprecated", "http://hl7.org/fhir/StructureDefinition/valueset-concept-definition", "http://hl7.org/fhir/StructureDefinition/coding-sctdescid", "http://hl7.org/fhir/StructureDefinition/rendering-style", "http://hl7.org/fhir/StructureDefinition/rendering-xhtml");
        String srcLang = dispLang;
        String dstLang = this.focus.getLanguage();
        boolean usedDisplay = false;
        CodeSystem.ConceptDefinitionDesignationComponent conceptDefinitionDesignationComponent = tu = expParams.hasParameter("displayLanguage") ? this.getMatchingLang(designations, expParams.getParameterString("displayLanguage")) : null;
        if (tu != null) {
            n.setDisplay(tu.getValue());
        } else if (display != null && (srcLang == null || dstLang == null || LanguageUtils.langsMatch(dstLang, srcLang))) {
            n.setDisplay(display);
            usedDisplay = true;
        }
        if (expParams.getParameterBool("includeDesignations") && designations != null) {
            if (!usedDisplay && display != null) {
                n.addDesignation().setLanguage(srcLang).setValue(display);
            }
            for (CodeSystem.ConceptDefinitionDesignationComponent t : designations) {
                if (t == tu || !t.hasLanguage() && !t.hasUse() || t.getValue() == null) continue;
                ValueSet.ConceptReferenceDesignationComponent d = n.addDesignation();
                if (t.getLanguage() != null) {
                    d.setLanguage(t.getLanguage().trim());
                }
                if (t.getValue() != null) {
                    d.setValue(t.getValue().trim());
                }
                if (t.getUse() != null) {
                    d.setUse(t.getUse());
                }
                for (Extension ext : t.getExtension()) {
                    if (!Utilities.existsInList((String)ext.getUrl(), (String[])new String[]{"http://hl7.org/fhir/StructureDefinition/coding-sctdescid"})) continue;
                    d.addExtension(ext);
                }
            }
        }
        for (Parameters.ParametersParameterComponent p : expParams.getParameter()) {
            if (!"property".equals(p.getName())) continue;
            if (csProps != null && p.hasValue()) {
                for (CodeSystem.ConceptPropertyComponent conceptPropertyComponent : csProps) {
                    if (!p.getValue().primitiveValue().equals(conceptPropertyComponent.getCode())) continue;
                    n.addProperty().setCode(conceptPropertyComponent.getCode()).setValue(conceptPropertyComponent.getValue());
                }
            }
            if (expProps == null || !p.hasValue()) continue;
            for (ValueSet.ConceptPropertyComponent conceptPropertyComponent : expProps) {
                if (!p.getValue().primitiveValue().equals(conceptPropertyComponent.getCode())) continue;
                n.addProperty(conceptPropertyComponent);
            }
        }
        String s = this.key(n);
        if (wc.getMap().containsKey(s) || wc.getExcludeKeys().contains(s)) {
            wc.setCanBeHeirarchy(false);
        } else {
            wc.getCodes().add(n);
            wc.getMap().put(s, n);
            wc.incTotal();
            if (wc == this.dwc && wc.getTotal() > this.maxExpansionSize) {
                if (wc.getOffset() + wc.getCount() > 0 && wc.getTotal() > wc.getOffset() + wc.getCount()) {
                    wc.setTotal(-1);
                    throw new EFinished();
                }
                throw this.failCostly(this.context.formatMessage("VALUESET_TOO_COSTLY", this.focus.getUrl(), ">" + Integer.toString(this.maxExpansionSize)));
            }
        }
        if (wc.isCanBeHeirarchy() && parent != null) {
            parent.getContains().add(n);
        } else {
            wc.getRoots().add(n);
        }
        return n;
    }

    private boolean filterContainsCode(List<ValueSet> filters, String system, String code) {
        for (ValueSet vse : filters) {
            if (!this.expansionContainsCode(vse.getExpansion().getContains(), system, code)) continue;
            return true;
        }
        return false;
    }

    private boolean expansionContainsCode(List<ValueSet.ValueSetExpansionContainsComponent> contains, String system, String code) {
        for (ValueSet.ValueSetExpansionContainsComponent cc : contains) {
            if (system.equals(cc.getSystem()) && code.equals(cc.getCode())) {
                return true;
            }
            if (!this.expansionContainsCode(cc.getContains(), system, code)) continue;
            return true;
        }
        return false;
    }

    private CodeSystem.ConceptDefinitionDesignationComponent getMatchingLang(List<CodeSystem.ConceptDefinitionDesignationComponent> list, String lang) {
        for (CodeSystem.ConceptDefinitionDesignationComponent t : list) {
            if (!t.getLanguage().equals(lang)) continue;
            return t;
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent t : list) {
            if (!t.getLanguage().startsWith(lang)) continue;
            return t;
        }
        return null;
    }

    private void addCodeAndDescendents(WorkingContext wc, ValueSet.ValueSetExpansionContainsComponent focus, ValueSet.ValueSetExpansionContainsComponent parent, Parameters expParams, List<ValueSet> filters, boolean noInactive, List<ValueSet.ValueSetExpansionPropertyComponent> vsProps, ValueSet vsSrc) throws FHIRException, ETooCostly {
        focus.checkNoModifiers("Expansion.contains", "expanding");
        ValueSet.ValueSetExpansionContainsComponent np = this.addCode(wc, focus.getSystem(), focus.getCode(), focus.getDisplay(), vsSrc.getLanguage(), parent, this.convert(focus.getDesignation()), expParams, focus.getAbstract(), focus.getInactive(), focus.getExtensionString("http://hl7.org/fhir/StructureDefinition/valueset-concept-definition"), filters, noInactive, false, vsProps, null, focus.getProperty(), null, focus.getExtension());
        for (ValueSet.ValueSetExpansionContainsComponent c : focus.getContains()) {
            this.addCodeAndDescendents(wc, c, np, expParams, filters, noInactive, vsProps, vsSrc);
        }
    }

    private List<CodeSystem.ConceptDefinitionDesignationComponent> convert(List<ValueSet.ConceptReferenceDesignationComponent> designations) {
        ArrayList<CodeSystem.ConceptDefinitionDesignationComponent> list = new ArrayList<CodeSystem.ConceptDefinitionDesignationComponent>();
        for (ValueSet.ConceptReferenceDesignationComponent d : designations) {
            CodeSystem.ConceptDefinitionDesignationComponent n = new CodeSystem.ConceptDefinitionDesignationComponent();
            n.setLanguage(d.getLanguage());
            n.setUse(d.getUse());
            n.setValue(d.getValue());
            list.add(n);
        }
        return list;
    }

    private void addCodeAndDescendents(WorkingContext wc, CodeSystem cs, String system, CodeSystem.ConceptDefinitionComponent def, ValueSet.ValueSetExpansionContainsComponent parent, Parameters expParams, List<ValueSet> filters, CodeSystem.ConceptDefinitionComponent exclusion, ConceptFilter filterFunc, boolean noInactive, List<ValueSet.ValueSetExpansionPropertyComponent> vsProps, List<WorkingContext> otherFilters) throws FHIRException, ETooCostly {
        def.checkNoModifiers("Code in Code System", "expanding");
        if (exclusion != null && exclusion.getCode().equals(def.getCode())) {
            return;
        }
        ValueSet.ValueSetExpansionContainsComponent np = null;
        boolean abs = CodeSystemUtilities.isNotSelectable(cs, def);
        boolean inc = CodeSystemUtilities.isInactive(cs, def);
        boolean dep = CodeSystemUtilities.isDeprecated(cs, def, false);
        if ((this.includeAbstract || !abs) && filterFunc.includeConcept(cs, def) && this.passesOtherFilters(otherFilters, cs, def.getCode())) {
            np = this.addCode(wc, system, def.getCode(), def.getDisplay(), cs.getLanguage(), parent, def.getDesignation(), expParams, abs, inc, def.getDefinition(), filters, noInactive, dep, vsProps, def.getProperty(), null, def.getExtension(), null);
        }
        for (CodeSystem.ConceptDefinitionComponent c : def.getConcept()) {
            this.addCodeAndDescendents(wc, cs, system, c, np, expParams, filters, exclusion, filterFunc, noInactive, vsProps, otherFilters);
        }
        if (def.hasUserData("cs.utils.cross.link")) {
            List children = (List)def.getUserData("cs.utils.cross.link");
            for (CodeSystem.ConceptDefinitionComponent c : children) {
                this.addCodeAndDescendents(wc, cs, system, c, np, expParams, filters, exclusion, filterFunc, noInactive, vsProps, otherFilters);
            }
        }
    }

    private void addCodes(ValueSet.ValueSetExpansionComponent expand, List<ValueSet.ValueSetExpansionParameterComponent> params, Parameters expParams, List<ValueSet> filters, boolean noInactive, List<ValueSet.ValueSetExpansionPropertyComponent> vsProps, ValueSet vsSrc) throws ETooCostly, FHIRException {
        if (expand != null) {
            if (expand.getContains().size() > this.maxExpansionSize) {
                throw this.failCostly(this.context.formatMessage("VALUESET_TOO_COSTLY", vsSrc.getUrl(), ">" + Integer.toString(expand.getContains().size())));
            }
            for (ValueSet.ValueSetExpansionParameterComponent p : expand.getParameter()) {
                if (this.existsInParams(params, p.getName(), p.getValue())) continue;
                params.add(p);
            }
            this.copyImportContains(expand.getContains(), null, expParams, filters, noInactive, vsProps, vsSrc);
        }
    }

    private void excludeCode(WorkingContext wc, String theSystem, String theCode) {
        ValueSet.ValueSetExpansionContainsComponent n = new ValueSet.ValueSetExpansionContainsComponent();
        n.setSystem(theSystem);
        n.setCode(theCode);
        String s = this.key(n);
        wc.getExcludeKeys().add(s);
    }

    private void excludeCodes(WorkingContext wc, ValueSet.ConceptSetComponent exc, List<ValueSet.ValueSetExpansionParameterComponent> params, String ctxt) throws FHIRException {
        exc.checkNoModifiers("Compose.exclude", "expanding");
        if (exc.hasSystem() && exc.getConcept().size() == 0 && exc.getFilter().size() == 0) {
            wc.getExcludeSystems().add(exc.getSystem());
        }
        if (exc.hasValueSet()) {
            throw this.fail("Processing Value set references in exclude is not yet done in " + ctxt);
        }
        CodeSystem cs = this.context.fetchSupplementedCodeSystem(exc.getSystem());
        if ((cs == null || cs.getContent() != Enumerations.CodeSystemContentMode.COMPLETE) && this.context.supportsSystem(exc.getSystem())) {
            ValueSetExpansionOutcome vse = this.context.expandVS(exc, false, false);
            ValueSet valueset = vse.getValueset();
            if (valueset == null) {
                throw this.failTSE("Error Expanding ValueSet: " + vse.getError());
            }
            this.excludeCodes(wc, valueset.getExpansion(), params);
            return;
        }
        for (ValueSet.ConceptReferenceComponent c : exc.getConcept()) {
            this.excludeCode(wc, exc.getSystem(), c.getCode());
        }
        if (exc.getFilter().size() > 0) {
            throw this.fail("not done yet - multiple filters");
        }
    }

    private void excludeCodes(WorkingContext wc, ValueSet.ValueSetExpansionComponent expand, List<ValueSet.ValueSetExpansionParameterComponent> params) {
        for (ValueSet.ValueSetExpansionContainsComponent c : expand.getContains()) {
            this.excludeCode(wc, c.getSystem(), c.getCode());
        }
    }

    private boolean existsInParams(List<ValueSet.ValueSetExpansionParameterComponent> params, String name, DataType value) {
        for (ValueSet.ValueSetExpansionParameterComponent p : params) {
            if (!p.getName().equals(name) || !PrimitiveType.compareDeep(p.getValue(), value, false)) continue;
            return true;
        }
        return false;
    }

    public ValueSetExpansionOutcome expand(ValueSet source, Parameters expParams) {
        this.allErrors.clear();
        try {
            return this.expandInternal(source, expParams);
        }
        catch (NoTerminologyServiceException e) {
            return new ValueSetExpansionOutcome(e.getMessage(), TerminologyServiceErrorClass.NOSERVICE, this.allErrors);
        }
        catch (CodeSystemProviderExtension e) {
            return new ValueSetExpansionOutcome(e.getMessage(), TerminologyServiceErrorClass.INTERNAL_ERROR, this.allErrors);
        }
        catch (ETooCostly e) {
            return new ValueSetExpansionOutcome(e.getMessage(), TerminologyServiceErrorClass.TOO_COSTLY, this.allErrors);
        }
        catch (Exception e) {
            return new ValueSetExpansionOutcome(e.getMessage(), TerminologyServiceErrorClass.UNKNOWN, this.allErrors);
        }
    }

    public ValueSetExpansionOutcome expandInternal(ValueSet source, Parameters expParams) throws FHIRException, FileNotFoundException, ETooCostly, IOException, CodeSystemProviderExtension {
        return this.doExpand(source, expParams);
    }

    public ValueSetExpansionOutcome doExpand(ValueSet source, Parameters expParams) throws FHIRException, ETooCostly, FileNotFoundException, IOException, CodeSystemProviderExtension {
        if (expParams == null) {
            expParams = this.makeDefaultExpansion();
        }
        source.checkNoModifiers("ValueSet", "expanding");
        this.focus = source.copy();
        this.focus.setIdBase(null);
        this.focus.setExpansion(new ValueSet.ValueSetExpansionComponent());
        this.focus.getExpansion().setTimestampElement(DateTimeType.now());
        this.focus.getExpansion().setIdentifier(Factory.createUUID());
        for (Parameters.ParametersParameterComponent p : expParams.getParameter()) {
            if (Utilities.existsInList((String)p.getName(), (String[])new String[]{"includeDesignations", "excludeNested", "activeOnly", "offset", "count"})) {
                this.focus.getExpansion().addParameter().setName(p.getName()).setValue(p.getValue());
            }
            if (!(!"displayLanguage".equals(p.getName()) || expParams.hasLanguage() && expParams.getLanguage().equals(p.getValue().primitiveValue()))) {
                this.focus.getExpansion().addParameter().setName(p.getName()).setValue(p.getValue());
            }
            if ("offset".equals(p.getName()) && p.hasValueIntegerType()) {
                this.dwc.setOffset((Integer)p.getValueIntegerType().getValue());
                if (this.dwc.getOffset() < 0) {
                    this.dwc.setOffset(0);
                }
            }
            if (!"count".equals(p.getName()) || !p.hasValueIntegerType()) continue;
            this.dwc.setCount((Integer)p.getValueIntegerType().getValue());
            if (this.dwc.getCount() >= 0) continue;
            this.dwc.setCount(0);
        }
        for (Extension s : this.focus.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/valueset-supplement")) {
            this.requiredSupplements.add(s.getValue().primitiveValue());
        }
        if (expParams.hasLanguage()) {
            this.focus.setLanguage(expParams.getLanguage());
        }
        try {
            if (source.hasCompose()) {
                ExtensionsUtils.stripExtensions((Element)this.focus.getCompose(), new String[0]);
                this.handleCompose(source.getCompose(), this.focus.getExpansion(), expParams, source.getUrl(), this.focus.getExpansion().getExtension(), source);
            }
        }
        catch (EFinished eFinished) {
            // empty catch block
        }
        if (this.dwc.isCanBeHeirarchy()) {
            for (ValueSet.ValueSetExpansionContainsComponent c : this.dwc.getRoots()) {
                this.focus.getExpansion().getContains().add(c);
            }
        } else {
            int i = 0;
            int cc = 0;
            for (ValueSet.ValueSetExpansionContainsComponent c : this.dwc.getCodes()) {
                if (!this.dwc.getMap().containsKey(this.key(c)) || !this.includeAbstract && c.getAbstract()) continue;
                if (this.dwc.getOffset() == 0 || i >= this.dwc.getOffset()) {
                    this.focus.getExpansion().getContains().add(c);
                    c.getContains().clear();
                    if (++cc == this.dwc.getCount()) break;
                }
                ++i;
            }
        }
        if (this.dwc.getTotal() >= 0) {
            this.focus.getExpansion().setTotal(this.dwc.getTotal());
        }
        if (!this.requiredSupplements.isEmpty()) {
            return new ValueSetExpansionOutcome("Required supplements not found: " + this.requiredSupplements.toString(), TerminologyServiceErrorClass.BUSINESS_RULE, this.allErrors);
        }
        if (!expParams.hasParameter("includeDefinition") || !expParams.getParameterBool("includeDefinition")) {
            this.focus.setCompose(null);
            this.focus.getExtension().clear();
            this.focus.setPublisher(null);
            this.focus.setDescription(null);
            this.focus.setPurpose(null);
            this.focus.getContact().clear();
            this.focus.setCopyright(null);
            this.focus.setText(null);
        }
        return new ValueSetExpansionOutcome(this.focus);
    }

    private Parameters makeDefaultExpansion() {
        Parameters res = new Parameters();
        res.addParameter("excludeNested", true);
        res.addParameter("includeDesignations", false);
        return res;
    }

    private CodeSystem.ConceptDefinitionComponent getConceptForCode(List<CodeSystem.ConceptDefinitionComponent> clist, String code) {
        for (CodeSystem.ConceptDefinitionComponent c : clist) {
            if (code.equals(c.getCode())) {
                return c;
            }
            CodeSystem.ConceptDefinitionComponent v = this.getConceptForCode(c.getConcept(), code);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    private void handleCompose(ValueSet.ValueSetComposeComponent compose, ValueSet.ValueSetExpansionComponent exp, Parameters expParams, String ctxt, List<Extension> extensions, ValueSet valueSet) throws ETooCostly, FileNotFoundException, IOException, FHIRException, CodeSystemProviderExtension {
        compose.checkNoModifiers("ValueSet.compose", "expanding");
        for (ValueSet.ConceptSetComponent inc : compose.getExclude()) {
            this.excludeCodes(this.dwc, inc, exp.getParameter(), ctxt);
        }
        this.dwc.setCanBeHeirarchy(!expParams.getParameterBool("excludeNested") && this.dwc.getExcludeKeys().isEmpty() && this.dwc.getExcludeSystems().isEmpty() && this.dwc.getOffset() + this.dwc.getCount() == 0);
        this.includeAbstract = !expParams.getParameterBool("excludeNotForUI");
        boolean first = true;
        for (ValueSet.ConceptSetComponent inc : compose.getInclude()) {
            if (first) {
                first = false;
            } else {
                this.dwc.setCanBeHeirarchy(false);
            }
            this.includeCodes(inc, exp, expParams, this.dwc.isCanBeHeirarchy(), compose.hasInactive() ? !compose.getInactive() : this.checkNoInActiveFromParam(expParams), extensions, valueSet);
        }
    }

    private boolean checkNoInActiveFromParam(Parameters expParams) {
        for (Parameters.ParametersParameterComponent p : expParams.getParameter()) {
            if (!p.getName().equals("activeOnly")) continue;
            return (Boolean)p.getValueBooleanType().getValue();
        }
        return false;
    }

    private ValueSet importValueSet(WorkingContext wc, String value, ValueSet.ValueSetExpansionComponent exp, Parameters expParams, boolean noInactive, ValueSet valueSet) throws ETooCostly, TerminologyServiceException, FileNotFoundException, IOException, FHIRFormatError {
        ValueSetExpansionOutcome vso;
        if (value == null) {
            throw this.fail("unable to find value set with no identity");
        }
        ValueSet vs = this.context.fetchResource(ValueSet.class, value, valueSet);
        if (vs == null) {
            if (this.context.fetchResource(CodeSystem.class, value, valueSet) != null) {
                throw this.fail("Cannot include value set " + value + " because it's actually a code system");
            }
            throw this.fail("Unable to find imported value set " + value);
        }
        if (noInactive) {
            expParams = expParams.copy();
            expParams.addParameter("activeOnly", true);
        }
        if ((vso = new ValueSetExpander(this.context, this.allErrors).expand(vs, expParams)).getError() != null) {
            this.addErrors(vso.getAllErrors());
            throw this.fail("Unable to expand imported value set " + vs.getUrl() + ": " + vso.getError());
        }
        if (vs.hasVersion()) {
            UriType u = new UriType(vs.getUrl() + (String)(vs.hasVersion() ? "|" + vs.getVersion() : ""));
            if (!this.existsInParams(exp.getParameter(), "version", u)) {
                exp.getParameter().add(new ValueSet.ValueSetExpansionParameterComponent().setName("version").setValue(u));
            }
        }
        for (Extension ex : vso.getValueset().getExpansion().getExtension()) {
            if (!ex.getUrl().equals("http://hl7.org/fhir/StructureDefinition/valueset-toocostly")) continue;
            if (ex.getValue() instanceof BooleanType) {
                exp.getExtension().add(new Extension("http://hl7.org/fhir/StructureDefinition/valueset-toocostly").setValue(new CanonicalType(value)));
                continue;
            }
            exp.getExtension().add(ex);
        }
        for (ValueSet.ValueSetExpansionParameterComponent p : vso.getValueset().getExpansion().getParameter()) {
            if (this.existsInParams(exp.getParameter(), p.getName(), p.getValue())) continue;
            exp.getParameter().add(p);
        }
        if (this.isValueSetUnionImports(valueSet)) {
            this.copyExpansion(wc, vso.getValueset().getExpansion().getContains());
        }
        wc.setCanBeHeirarchy(false);
        return vso.getValueset();
    }

    protected boolean isValueSetUnionImports(ValueSet valueSet) {
        PackageInformation p = valueSet.getSourcePackage();
        if (p != null) {
            return p.getDate().before(new GregorianCalendar(2022, 2, 31).getTime());
        }
        return false;
    }

    public void copyExpansion(WorkingContext wc, List<ValueSet.ValueSetExpansionContainsComponent> list) {
        for (ValueSet.ValueSetExpansionContainsComponent cc : list) {
            ValueSet.ValueSetExpansionContainsComponent n = new ValueSet.ValueSetExpansionContainsComponent();
            n.setSystem(cc.getSystem());
            n.setCode(cc.getCode());
            n.setAbstract(cc.getAbstract());
            n.setInactive(cc.getInactive());
            n.setDisplay(cc.getDisplay());
            n.getDesignation().addAll(cc.getDesignation());
            String s = this.key(n);
            if (!wc.getMap().containsKey(s) && !wc.getExcludeKeys().contains(s)) {
                wc.getCodes().add(n);
                wc.getMap().put(s, n);
                wc.incTotal();
            }
            this.copyExpansion(wc, cc.getContains());
        }
    }

    private void addErrors(List<String> errs) {
        for (String s : errs) {
            if (this.allErrors.contains(s)) continue;
            this.allErrors.add(s);
        }
    }

    private void copyImportContains(List<ValueSet.ValueSetExpansionContainsComponent> list, ValueSet.ValueSetExpansionContainsComponent parent, Parameters expParams, List<ValueSet> filter, boolean noInactive, List<ValueSet.ValueSetExpansionPropertyComponent> vsProps, ValueSet vsSrc) throws FHIRException, ETooCostly {
        for (ValueSet.ValueSetExpansionContainsComponent c : list) {
            c.checkNoModifiers("Imported Expansion in Code System", "expanding");
            ValueSet.ValueSetExpansionContainsComponent np = this.addCode(this.dwc, c.getSystem(), c.getCode(), c.getDisplay(), vsSrc.getLanguage(), parent, null, expParams, c.getAbstract(), c.getInactive(), c.getExtensionString("http://hl7.org/fhir/StructureDefinition/valueset-concept-definition"), filter, noInactive, false, vsProps, null, c.getProperty(), null, c.getExtension());
            this.copyImportContains(c.getContains(), np, expParams, filter, noInactive, vsProps, vsSrc);
        }
    }

    private void includeCodes(ValueSet.ConceptSetComponent inc, ValueSet.ValueSetExpansionComponent exp, Parameters expParams, boolean heirarchical, boolean noInactive, List<Extension> extensions, ValueSet valueSet) throws ETooCostly, FileNotFoundException, IOException, FHIRException, CodeSystemProviderExtension {
        inc.checkNoModifiers("Compose.include", "expanding");
        ArrayList<ValueSet> imports = new ArrayList<ValueSet>();
        for (CanonicalType imp : inc.getValueSet()) {
            imports.add(this.importValueSet(this.dwc, (String)imp.getValue(), exp, expParams, noInactive, valueSet));
        }
        if (!inc.hasSystem()) {
            if (imports.isEmpty()) {
                return;
            }
            ValueSet base = (ValueSet)imports.get(0);
            imports.remove(0);
            base.checkNoModifiers("Imported ValueSet", "expanding");
            this.copyImportContains(base.getExpansion().getContains(), null, expParams, imports, noInactive, base.getExpansion().getProperty(), base);
        } else {
            CodeSystem cs = this.context.fetchSupplementedCodeSystem(inc.getSystem());
            if (ValueSetUtilities.isServerSide(inc.getSystem()) || cs == null || cs.getContent() != Enumerations.CodeSystemContentMode.COMPLETE && cs.getContent() != Enumerations.CodeSystemContentMode.FRAGMENT) {
                this.doServerIncludeCodes(inc, heirarchical, exp, imports, expParams, extensions, noInactive, valueSet.getExpansion().getProperty());
            } else {
                if (cs.hasUserData("supplements.installed")) {
                    for (String s : cs.getUserString("supplements.installed").split("\\,")) {
                        this.requiredSupplements.remove(s);
                    }
                }
                this.doInternalIncludeCodes(inc, exp, expParams, imports, cs, noInactive, valueSet);
            }
        }
    }

    private void doServerIncludeCodes(ValueSet.ConceptSetComponent inc, boolean heirarchical, ValueSet.ValueSetExpansionComponent exp, List<ValueSet> imports, Parameters expParams, List<Extension> extensions, boolean noInactive, List<ValueSet.ValueSetExpansionPropertyComponent> vsProps) throws FHIRException, CodeSystemProviderExtension, ETooCostly {
        CodeSystemProvider csp = CodeSystemProvider.factory(inc.getSystem());
        if (csp != null) {
            csp.includeCodes(inc, heirarchical, exp, imports, expParams, extensions, noInactive, vsProps);
            return;
        }
        ValueSetExpansionOutcome vso = this.context.expandVS(inc, heirarchical, noInactive);
        if (vso.getError() != null) {
            throw this.failTSE("Unable to expand imported value set: " + vso.getError());
        }
        ValueSet vs = vso.getValueset();
        if (vs.hasVersion()) {
            UriType u = new UriType(vs.getUrl() + (String)(vs.hasVersion() ? "|" + vs.getVersion() : ""));
            if (!this.existsInParams(exp.getParameter(), "version", u)) {
                exp.getParameter().add(new ValueSet.ValueSetExpansionParameterComponent().setName("version").setValue(u));
            }
        }
        for (ValueSet.ValueSetExpansionParameterComponent p : vso.getValueset().getExpansion().getParameter()) {
            if (this.existsInParams(exp.getParameter(), p.getName(), p.getValue())) continue;
            exp.getParameter().add(p);
        }
        for (Extension ex : vs.getExpansion().getExtension()) {
            if (!Utilities.existsInList((String)ex.getUrl(), (String[])new String[]{"http://hl7.org/fhir/StructureDefinition/valueset-toocostly", "http://hl7.org/fhir/StructureDefinition/valueset-unclosed"}) || ExtensionsUtils.hasExtension(extensions, ex.getUrl())) continue;
            extensions.add(ex);
        }
        for (ValueSet.ValueSetExpansionContainsComponent cc : vs.getExpansion().getContains()) {
            this.addCodeAndDescendents(this.dwc, cc, null, expParams, imports, noInactive, vsProps, vs);
        }
    }

    public void doInternalIncludeCodes(ValueSet.ConceptSetComponent inc, ValueSet.ValueSetExpansionComponent exp, Parameters expParams, List<ValueSet> imports, CodeSystem cs, boolean noInactive, Resource vsSrc) throws NoTerminologyServiceException, TerminologyServiceException, FHIRException, ETooCostly {
        if (cs == null) {
            if (this.context.isNoTerminologyServer()) {
                throw this.failTSE("Unable to find code system " + inc.getSystem().toString());
            }
            throw this.failTSE("Unable to find code system " + inc.getSystem().toString());
        }
        cs.checkNoModifiers("Code System", "expanding");
        if (cs.getContent() != Enumerations.CodeSystemContentMode.COMPLETE && cs.getContent() != Enumerations.CodeSystemContentMode.FRAGMENT) {
            throw this.failTSE("Code system " + inc.getSystem().toString() + " is incomplete");
        }
        if (cs.hasVersion()) {
            Iterator<ValueSet.ConceptReferenceComponent> u = new UriType(cs.getUrl() + (String)(cs.hasVersion() ? "|" + cs.getVersion() : ""));
            if (!this.existsInParams(exp.getParameter(), "version", (DataType)((Object)u))) {
                exp.getParameter().add(new ValueSet.ValueSetExpansionParameterComponent().setName("version").setValue((DataType)((Object)u)));
            }
        }
        if (inc.getConcept().size() == 0 && inc.getFilter().size() == 0) {
            for (CodeSystem.ConceptDefinitionComponent def : cs.getConcept()) {
                this.addCodeAndDescendents(this.dwc, cs, inc.getSystem(), def, null, expParams, imports, null, new AllConceptsFilter(this.allErrors), noInactive, exp.getProperty(), null);
            }
            if (cs.getContent() == Enumerations.CodeSystemContentMode.FRAGMENT) {
                this.addFragmentWarning(exp, cs);
            }
            if (cs.getContent() == Enumerations.CodeSystemContentMode.EXAMPLE) {
                this.addExampleWarning(exp, cs);
            }
        }
        if (!inc.getConcept().isEmpty()) {
            this.dwc.setCanBeHeirarchy(false);
            for (ValueSet.ConceptReferenceComponent c : inc.getConcept()) {
                c.checkNoModifiers("Code in Value Set", "expanding");
                CodeSystem.ConceptDefinitionComponent def = CodeSystemUtilities.findCode(cs.getConcept(), c.getCode());
                boolean inactive = false;
                boolean isAbstract = false;
                if (def == null) {
                    def.checkNoModifiers("Code in Code System", "expanding");
                    if (cs.getContent() == Enumerations.CodeSystemContentMode.FRAGMENT) {
                        this.addFragmentWarning(exp, cs);
                    } else if (cs.getContent() == Enumerations.CodeSystemContentMode.EXAMPLE) {
                        this.addExampleWarning(exp, cs);
                    } else if (this.checkCodesWhenExpanding) {
                        throw this.failTSE("Unable to find code '" + c.getCode() + "' in code system " + cs.getUrl());
                    }
                } else {
                    inactive = CodeSystemUtilities.isInactive(cs, def);
                    isAbstract = CodeSystemUtilities.isNotSelectable(cs, def);
                }
                this.addCode(this.dwc, inc.getSystem(), c.getCode(), (String)(!Utilities.noString((String)c.getDisplay()) ? c.getDisplay() : (def == null ? null : def.getDisplay())), c.hasDisplay() ? vsSrc.getLanguage() : cs.getLanguage(), null, this.mergeDesignations(def, this.convertDesignations(c.getDesignation())), expParams, isAbstract, inactive, def == null ? null : def.getDefinition(), imports, noInactive, false, exp.getProperty(), def != null ? def.getProperty() : null, null, def == null ? null : def.getExtension(), c.getExtension());
            }
        }
        if (inc.getFilter().size() > 0) {
            WorkingContext wc;
            if (inc.getFilter().size() > 1) {
                this.dwc.setCanBeHeirarchy(false);
            }
            if (cs.getContent() == Enumerations.CodeSystemContentMode.FRAGMENT) {
                this.addFragmentWarning(exp, cs);
            }
            ArrayList<WorkingContext> filters = new ArrayList<WorkingContext>();
            for (int i = 1; i < inc.getFilter().size(); ++i) {
                wc = new WorkingContext();
                filters.add(wc);
                this.processFilter(inc, exp, expParams, imports, cs, noInactive, inc.getFilter().get(i), wc, null);
            }
            ValueSet.ConceptSetFilterComponent fc = inc.getFilter().get(0);
            wc = this.dwc;
            this.processFilter(inc, exp, expParams, imports, cs, noInactive, fc, wc, filters);
        }
    }

    private void processFilter(ValueSet.ConceptSetComponent inc, ValueSet.ValueSetExpansionComponent exp, Parameters expParams, List<ValueSet> imports, CodeSystem cs, boolean noInactive, ValueSet.ConceptSetFilterComponent fc, WorkingContext wc, List<WorkingContext> filters) throws ETooCostly {
        if ("concept".equals(fc.getProperty()) && fc.getOp() == Enumerations.FilterOperator.ISA) {
            CodeSystem.ConceptDefinitionComponent def = this.getConceptForCode(cs.getConcept(), fc.getValue());
            if (def == null) {
                throw this.failTSE("Code '" + fc.getValue() + "' not found in system '" + inc.getSystem() + "'");
            }
            this.addCodeAndDescendents(wc, cs, inc.getSystem(), def, null, expParams, imports, null, new AllConceptsFilter(this.allErrors), noInactive, exp.getProperty(), filters);
        } else if ("concept".equals(fc.getProperty()) && fc.getOp() == Enumerations.FilterOperator.ISNOTA) {
            CodeSystem.ConceptDefinitionComponent defEx = this.getConceptForCode(cs.getConcept(), fc.getValue());
            if (defEx == null) {
                throw this.failTSE("Code '" + fc.getValue() + "' not found in system '" + inc.getSystem() + "'");
            }
            for (CodeSystem.ConceptDefinitionComponent def : cs.getConcept()) {
                this.addCodeAndDescendents(wc, cs, inc.getSystem(), def, null, expParams, imports, defEx, new AllConceptsFilter(this.allErrors), noInactive, exp.getProperty(), filters);
            }
        } else if ("concept".equals(fc.getProperty()) && fc.getOp() == Enumerations.FilterOperator.DESCENDENTOF) {
            CodeSystem.ConceptDefinitionComponent def = this.getConceptForCode(cs.getConcept(), fc.getValue());
            if (def == null) {
                throw this.failTSE("Code '" + fc.getValue() + "' not found in system '" + inc.getSystem() + "'");
            }
            for (CodeSystem.ConceptDefinitionComponent c : def.getConcept()) {
                this.addCodeAndDescendents(wc, cs, inc.getSystem(), c, null, expParams, imports, null, new AllConceptsFilter(this.allErrors), noInactive, exp.getProperty(), filters);
            }
            if (def.hasUserData("cs.utils.cross.link")) {
                List children = (List)def.getUserData("cs.utils.cross.link");
                for (CodeSystem.ConceptDefinitionComponent c : children) {
                    this.addCodeAndDescendents(wc, cs, inc.getSystem(), c, null, expParams, imports, null, new AllConceptsFilter(this.allErrors), noInactive, exp.getProperty(), filters);
                }
            }
        } else if ("display".equals(fc.getProperty()) && fc.getOp() == Enumerations.FilterOperator.EQUAL) {
            this.dwc.setCanBeHeirarchy(false);
            CodeSystem.ConceptDefinitionComponent def = this.getConceptForCode(cs.getConcept(), fc.getValue());
            if (def != null && StringUtils.isNotBlank((CharSequence)def.getDisplay()) && StringUtils.isNotBlank((CharSequence)fc.getValue()) && def.getDisplay().contains(fc.getValue()) && this.passesOtherFilters(filters, cs, def.getCode())) {
                this.addCode(wc, inc.getSystem(), def.getCode(), def.getDisplay(), cs.getLanguage(), null, def.getDesignation(), expParams, CodeSystemUtilities.isNotSelectable(cs, def), CodeSystemUtilities.isInactive(cs, def), def.getDefinition(), imports, noInactive, false, exp.getProperty(), def.getProperty(), null, def.getExtension(), null);
            }
        } else if (this.isDefinedProperty(cs, fc.getProperty())) {
            for (CodeSystem.ConceptDefinitionComponent def : cs.getConcept()) {
                this.addCodeAndDescendents(wc, cs, inc.getSystem(), def, null, expParams, imports, null, new PropertyFilter(this.allErrors, fc, this.getPropertyDefinition(cs, fc.getProperty())), noInactive, exp.getProperty(), filters);
            }
        } else if ("code".equals(fc.getProperty()) && fc.getOp() == Enumerations.FilterOperator.REGEX) {
            for (CodeSystem.ConceptDefinitionComponent def : cs.getConcept()) {
                this.addCodeAndDescendents(wc, cs, inc.getSystem(), def, null, expParams, imports, null, new RegexFilter(this.allErrors, fc.getValue()), noInactive, exp.getProperty(), filters);
            }
        } else {
            throw this.fail("Filter by property[" + fc.getProperty() + "] and op[" + fc.getOp() + "] is not supported yet");
        }
    }

    private List<CodeSystem.ConceptDefinitionDesignationComponent> mergeDesignations(CodeSystem.ConceptDefinitionComponent def, List<CodeSystem.ConceptDefinitionDesignationComponent> list) {
        ArrayList<CodeSystem.ConceptDefinitionDesignationComponent> res = new ArrayList<CodeSystem.ConceptDefinitionDesignationComponent>();
        res.addAll(def.getDesignation());
        res.addAll(list);
        return res;
    }

    private CodeSystem.PropertyComponent getPropertyDefinition(CodeSystem cs, String property) {
        for (CodeSystem.PropertyComponent cp : cs.getProperty()) {
            if (!cp.getCode().equals(property)) continue;
            return cp;
        }
        return null;
    }

    private boolean isDefinedProperty(CodeSystem cs, String property) {
        for (CodeSystem.PropertyComponent cp : cs.getProperty()) {
            if (!cp.getCode().equals(property)) continue;
            return true;
        }
        return false;
    }

    private void addFragmentWarning(ValueSet.ValueSetExpansionComponent exp, CodeSystem cs) {
        String url = cs.getVersionedUrl();
        for (ValueSet.ValueSetExpansionParameterComponent p : exp.getParameter()) {
            if (!"fragment".equals(p.getName()) || !p.hasValueUriType() || !url.equals(p.getValue().primitiveValue())) continue;
            return;
        }
        exp.addParameter().setName("fragment").setValue(new CanonicalType(url));
    }

    private void addExampleWarning(ValueSet.ValueSetExpansionComponent exp, CodeSystem cs) {
        String url = cs.getVersionedUrl();
        for (ValueSet.ValueSetExpansionParameterComponent p : exp.getParameter()) {
            if (!"example".equals(p.getName()) || !p.hasValueUriType() || !url.equals(p.getValue().primitiveValue())) continue;
            return;
        }
        exp.addParameter().setName("example").setValue(new CanonicalType(url));
    }

    private List<CodeSystem.ConceptDefinitionDesignationComponent> convertDesignations(List<ValueSet.ConceptReferenceDesignationComponent> list) {
        ArrayList<CodeSystem.ConceptDefinitionDesignationComponent> res = new ArrayList<CodeSystem.ConceptDefinitionDesignationComponent>();
        for (ValueSet.ConceptReferenceDesignationComponent t : list) {
            CodeSystem.ConceptDefinitionDesignationComponent c = new CodeSystem.ConceptDefinitionDesignationComponent();
            c.setLanguage(t.getLanguage());
            c.setUse(t.getUse());
            c.setValue(t.getValue());
            c.getExtension().addAll(t.getExtension());
            res.add(c);
        }
        return res;
    }

    private String key(String uri, String code) {
        return "{" + uri + "}" + code;
    }

    private String key(ValueSet.ValueSetExpansionContainsComponent c) {
        return this.key(c.getSystem(), c.getCode());
    }

    private FHIRException fail(String msg) {
        this.allErrors.add(msg);
        return new FHIRException(msg);
    }

    private ETooCostly failCostly(String msg) {
        this.allErrors.add(msg);
        return new ETooCostly(msg);
    }

    private TerminologyServiceException failTSE(String msg) {
        this.allErrors.add(msg);
        return new TerminologyServiceException(msg);
    }

    public Collection<? extends String> getAllErrors() {
        return this.allErrors;
    }

    public boolean isCheckCodesWhenExpanding() {
        return this.checkCodesWhenExpanding;
    }

    public void setCheckCodesWhenExpanding(boolean checkCodesWhenExpanding) {
        this.checkCodesWhenExpanding = checkCodesWhenExpanding;
    }

    private boolean passesOtherFilters(List<WorkingContext> otherFilters, CodeSystem cs, String code) {
        if (otherFilters == null) {
            return true;
        }
        String key = this.key(cs.getUrl(), code);
        for (WorkingContext wc : otherFilters) {
            if (wc.getMap().containsKey(key)) continue;
            return false;
        }
        return true;
    }
}

