/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.context;

import com.google.gson.JsonSyntaxException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.fhir.ucum.UcumService;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.TerminologyServiceException;
import org.hl7.fhir.r5.context.IWorkerContextManager;
import org.hl7.fhir.r5.context.TerminologyCache;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.PackageInformation;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.profilemodel.PEBuilder;
import org.hl7.fhir.r5.terminologies.expansion.ValueSetExpansionOutcome;
import org.hl7.fhir.r5.terminologies.utilities.TerminologyServiceErrorClass;
import org.hl7.fhir.r5.utils.validation.IResourceValidator;
import org.hl7.fhir.r5.utils.validation.ValidationContextCarrier;
import org.hl7.fhir.utilities.TimeTracker;
import org.hl7.fhir.utilities.TranslationServices;
import org.hl7.fhir.utilities.npm.BasePackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;

public interface IWorkerContext {
    public String getVersion();

    public UcumService getUcumService();

    public void setUcumService(UcumService var1);

    public IResourceValidator newValidator() throws FHIRException;

    public <T extends Resource> T fetchResource(Class<T> var1, String var2);

    public <T extends Resource> T fetchResourceRaw(Class<T> var1, String var2);

    public <T extends Resource> T fetchResourceWithException(Class<T> var1, String var2) throws FHIRException;

    public <T extends Resource> T fetchResourceWithException(Class<T> var1, String var2, Resource var3) throws FHIRException;

    public <T extends Resource> T fetchResource(Class<T> var1, String var2, String var3);

    public <T extends Resource> T fetchResource(Class<T> var1, String var2, Resource var3);

    public <T extends Resource> List<T> fetchResourcesByType(Class<T> var1);

    public Resource fetchResourceById(String var1, String var2);

    public <T extends Resource> boolean hasResource(Class<T> var1, String var2);

    public void cacheResource(Resource var1) throws FHIRException;

    public void cacheResourceFromPackage(Resource var1, PackageInformation var2) throws FHIRException;

    public void cachePackage(PackageInformation var1);

    public List<String> getResourceNames();

    public Set<String> getResourceNamesAsSet();

    public Parameters getExpansionParameters();

    public void setExpansionProfile(Parameters var1);

    public CodeSystem fetchCodeSystem(String var1);

    public CodeSystem fetchCodeSystem(String var1, String var2);

    public CodeSystem fetchSupplementedCodeSystem(String var1);

    public CodeSystem fetchSupplementedCodeSystem(String var1, String var2);

    public boolean supportsSystem(String var1) throws TerminologyServiceException;

    public ValueSetExpansionOutcome expandVS(ValueSet var1, boolean var2, boolean var3);

    public ValueSetExpansionOutcome expandVS(ValueSet var1, boolean var2, boolean var3, boolean var4);

    public ValueSetExpansionOutcome expandVS(Resource var1, ElementDefinition.ElementDefinitionBindingComponent var2, boolean var3, boolean var4) throws FHIRException;

    public ValueSetExpansionOutcome expandVS(ValueSet.ConceptSetComponent var1, boolean var2, boolean var3) throws TerminologyServiceException;

    public Locale getLocale();

    public void setLocale(Locale var1);

    public void setValidationMessageLanguage(Locale var1);

    public String formatMessage(String var1, Object ... var2);

    public String formatMessagePlural(Integer var1, String var2, Object ... var3);

    public ValidationResult validateCode(ValidationOptions var1, String var2, ValueSet var3);

    public ValidationResult validateCode(ValidationOptions var1, String var2, String var3, String var4, String var5);

    public ValidationResult validateCode(ValidationOptions var1, String var2, String var3, String var4, String var5, ValueSet var6);

    public ValidationResult validateCode(ValidationOptions var1, CodeableConcept var2, ValueSet var3);

    public ValidationResult validateCode(ValidationOptions var1, Coding var2, ValueSet var3);

    public ValidationResult validateCode(ValidationOptions var1, Coding var2, ValueSet var3, ValidationContextCarrier var4);

    public void validateCodeBatch(ValidationOptions var1, List<? extends CodingValidationRequest> var2, ValueSet var3);

    public Map<String, NamingSystem> getNSUrlMap();

    public TranslationServices translator();

    public void setLogger(@Nonnull ILoggingService var1);

    public ILoggingService getLogger();

    public boolean isNoTerminologyServer();

    public Set<String> getCodeSystemsUsed();

    public int getClientRetryCount();

    public IWorkerContext setClientRetryCount(int var1);

    public TimeTracker clock();

    public StructureDefinition fetchTypeDefinition(String var1);

    public List<StructureDefinition> fetchTypeDefinitions(String var1);

    public Set<String> getBinaryKeysAsSet();

    public boolean hasBinaryKey(String var1);

    public byte[] getBinaryForKey(String var1);

    public int loadFromPackage(NpmPackage var1, IContextResourceLoader var2) throws FileNotFoundException, IOException, FHIRException;

    @Deprecated
    public int loadFromPackage(NpmPackage var1, IContextResourceLoader var2, List<String> var3) throws FileNotFoundException, IOException, FHIRException;

    public int loadFromPackageAndDependencies(NpmPackage var1, IContextResourceLoader var2, BasePackageCacheManager var3) throws FileNotFoundException, IOException, FHIRException;

    public boolean hasPackage(String var1, String var2);

    public boolean hasPackage(PackageInformation var1);

    public PackageInformation getPackage(String var1, String var2);

    public PackageInformation getPackageForUrl(String var1);

    public IWorkerContextManager.IPackageLoadingTracker getPackageTracker();

    public IWorkerContext setPackageTracker(IWorkerContextManager.IPackageLoadingTracker var1);

    public String getSpecUrl();

    public PEBuilder getProfiledElementBuilder(PEBuilder.PEElementPropertiesPolicy var1, boolean var2);

    public boolean isForPublication();

    public void setForPublication(boolean var1);

    public static interface ILoggingService {
        public void logMessage(String var1);

        public void logDebugMessage(LogCategory var1, String var2);

        public boolean isDebugLogging();

        public static enum LogCategory {
            INIT,
            PROGRESS,
            TX,
            CONTEXT,
            GENERATE,
            HTML;

        }
    }

    public static interface IContextResourceLoader {
        public List<String> getTypes();

        public Bundle loadBundle(InputStream var1, boolean var2) throws FHIRException, IOException;

        public Resource loadResource(InputStream var1, boolean var2) throws FHIRException, IOException;

        public String getResourcePath(Resource var1);

        public IContextResourceLoader getNewLoader(NpmPackage var1) throws JsonSyntaxException, IOException;

        public List<CodeSystem> getCodeSystems();

        public void setPatchUrls(boolean var1);

        public String patchUrl(String var1, String var2);

        public IContextResourceLoader setLoadProfiles(boolean var1);

        public boolean wantLoad(NpmPackage var1, NpmPackage.PackageResourceInformation var2);
    }

    public static class CodingValidationRequest {
        private Coding coding;
        private ValidationResult result;
        private TerminologyCache.CacheToken cacheToken;

        public CodingValidationRequest(Coding coding) {
            this.coding = coding;
        }

        public ValidationResult getResult() {
            return this.result;
        }

        public void setResult(ValidationResult result) {
            this.result = result;
        }

        public Coding getCoding() {
            return this.coding;
        }

        public boolean hasResult() {
            return this.result != null;
        }

        public TerminologyCache.CacheToken getCacheToken() {
            return this.cacheToken;
        }

        public void setCacheToken(TerminologyCache.CacheToken cacheToken) {
            this.cacheToken = cacheToken;
        }
    }

    public static class ValidationResult {
        private CodeSystem.ConceptDefinitionComponent definition;
        private String preferredDisplay;
        private String system;
        private String version;
        private ValidationMessage.IssueSeverity severity;
        private String message;
        private TerminologyServiceErrorClass errorClass;
        private String txLink;
        private String diagnostics;
        private List<OperationOutcome.OperationOutcomeIssueComponent> issues = new ArrayList<OperationOutcome.OperationOutcomeIssueComponent>();
        private CodeableConcept codeableConcept;
        private Set<String> unknownSystems;

        public String toString() {
            return "ValidationResult [definition=" + this.definition + ", system=" + this.system + ", severity=" + this.severity + ", message=" + this.message + ", errorClass=" + this.errorClass + ", txLink=" + this.txLink + "]";
        }

        public ValidationResult(ValidationMessage.IssueSeverity severity, String message, List<OperationOutcome.OperationOutcomeIssueComponent> issues) {
            this.severity = severity;
            this.message = message;
            if (issues != null) {
                this.issues.addAll(issues);
            }
        }

        public ValidationResult(String system, String version, CodeSystem.ConceptDefinitionComponent definition, String preferredDisplay) {
            this.system = system;
            this.version = version;
            this.definition = definition;
            this.preferredDisplay = preferredDisplay;
        }

        public ValidationResult(ValidationMessage.IssueSeverity severity, String message, String system, String version, CodeSystem.ConceptDefinitionComponent definition, String preferredDisplay, List<OperationOutcome.OperationOutcomeIssueComponent> issues) {
            this.severity = severity;
            this.message = message;
            this.system = system;
            this.version = version;
            this.definition = definition;
            this.preferredDisplay = preferredDisplay;
            if (issues != null) {
                this.issues.addAll(issues);
            }
        }

        public ValidationResult(ValidationMessage.IssueSeverity severity, String message, TerminologyServiceErrorClass errorClass, List<OperationOutcome.OperationOutcomeIssueComponent> issues) {
            this.severity = severity;
            this.message = message;
            this.errorClass = errorClass;
            if (issues != null) {
                this.issues.addAll(issues);
            }
        }

        public boolean isOk() {
            return this.severity == null || this.severity == ValidationMessage.IssueSeverity.INFORMATION || this.severity == ValidationMessage.IssueSeverity.WARNING;
        }

        public String getSystem() {
            return this.system;
        }

        public String getVersion() {
            return this.version;
        }

        public String getDisplay() {
            if (this.preferredDisplay != null) {
                return this.preferredDisplay;
            }
            return this.definition == null ? null : this.definition.getDisplay();
        }

        public void setDisplay(String display) {
            this.preferredDisplay = display;
        }

        public void setSystem(String system) {
            this.system = system;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getCode() {
            return this.definition == null ? null : this.definition.getCode();
        }

        public String getDefinition() {
            return this.definition == null ? null : this.definition.getDefinition();
        }

        public void setDefinition(CodeSystem.ConceptDefinitionComponent definition) {
            this.definition = definition;
        }

        public CodeSystem.ConceptDefinitionComponent asConceptDefinition() {
            return this.definition;
        }

        public ValidationMessage.IssueSeverity getSeverity() {
            return this.severity;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean IsNoService() {
            return this.errorClass == TerminologyServiceErrorClass.NOSERVICE;
        }

        public TerminologyServiceErrorClass getErrorClass() {
            return this.errorClass;
        }

        public ValidationResult setSeverity(ValidationMessage.IssueSeverity severity) {
            this.severity = severity;
            return this;
        }

        public ValidationResult setMessage(String message) {
            this.message = message;
            return this;
        }

        public ValidationResult addToMessage(String message) {
            this.message = this.message == null ? message : this.message + "; " + message;
            return this;
        }

        public ValidationResult setErrorClass(TerminologyServiceErrorClass errorClass) {
            this.errorClass = errorClass;
            return this;
        }

        public String getTxLink() {
            return this.txLink;
        }

        public ValidationResult setTxLink(String txLink) {
            this.txLink = txLink;
            return this;
        }

        public boolean hasMessage() {
            return this.message != null;
        }

        public String getDiagnostics() {
            return this.diagnostics;
        }

        public void setDiagnostics(String diagnostics) {
            this.diagnostics = diagnostics;
        }

        public Coding asCoding() {
            if (this.isOk() && this.definition != null && this.definition.getCode() != null) {
                return new Coding(this.system, this.definition.getCode(), this.definition.getDisplay());
            }
            return null;
        }

        public List<OperationOutcome.OperationOutcomeIssueComponent> getIssues() {
            return this.issues;
        }

        public ValidationResult addCodeableConcept(CodeableConcept vcc) {
            if (!vcc.isEmpty()) {
                this.codeableConcept = vcc;
            }
            return this;
        }

        public CodeableConcept getCodeableConcept() {
            return this.codeableConcept;
        }

        public Set<String> getUnknownSystems() {
            return this.unknownSystems;
        }

        public ValidationResult setUnknownSystems(Set<String> unknownSystems) {
            this.unknownSystems = unknownSystems;
            return this;
        }

        public String unknownSystems() {
            if (this.unknownSystems == null) {
                return null;
            }
            if (this.unknownSystems.size() == 1) {
                return this.unknownSystems.iterator().next();
            }
            return String.join((CharSequence)",", this.unknownSystems);
        }
    }
}

