/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.elementmodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.Manager;
import org.hl7.fhir.r5.elementmodel.ParserBase;
import org.hl7.fhir.r5.elementmodel.Property;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.ExpressionNode;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.utils.FHIRLexer;
import org.hl7.fhir.r5.utils.FHIRPathEngine;
import org.hl7.fhir.utilities.SourceLocation;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class FmlParser
extends ParserBase {
    private FHIRPathEngine fpe;

    public FmlParser(IWorkerContext context) {
        super(context);
        this.fpe = new FHIRPathEngine(context);
    }

    @Override
    public List<ParserBase.NamedElement> parse(InputStream stream) throws IOException, FHIRFormatError, DefinitionException, FHIRException {
        String text = TextFile.streamToString((InputStream)stream);
        ArrayList<ParserBase.NamedElement> result = new ArrayList<ParserBase.NamedElement>();
        result.add(new ParserBase.NamedElement(this, null, this.parse(text)));
        return result;
    }

    @Override
    public void compose(Element e, OutputStream destination, IParser.OutputStyle style, String base) throws FHIRException, IOException {
        throw new Error("Not done yet");
    }

    public Element parse(String text) throws FHIRException {
        FHIRLexer lexer = new FHIRLexer(text, "source", true, true);
        if (lexer.done()) {
            throw lexer.error("Map Input cannot be empty");
        }
        Element result = Manager.build(this.context, this.context.fetchTypeDefinition("StructureMap"));
        try {
            String id;
            if (lexer.hasToken("map")) {
                lexer.token("map");
                result.makeElement("url").markLocation(lexer.getCurrentLocation()).setValue(lexer.readConstant("url"));
                lexer.token("=");
                result.makeElement("name").markLocation(lexer.getCurrentLocation()).setValue(lexer.readConstant("name"));
                if (lexer.hasComments()) {
                    result.makeElement("description").markLocation(lexer.getCurrentLocation()).setValue(lexer.getAllComments());
                }
            } else {
                while (lexer.hasToken("///")) {
                    lexer.next();
                    String fid = lexer.takeDottedToken();
                    Element e = result.makeElement(fid).markLocation(lexer.getCurrentLocation());
                    lexer.token("=");
                    e.setValue(lexer.readConstant("meta value"));
                }
            }
            lexer.setMetadataFormat(false);
            if (!result.hasChild("status")) {
                result.makeElement("status").setValue("draft");
            }
            if (!result.hasChild("id") && result.hasChild("name") && !Utilities.noString((String)(id = Utilities.makeId((String)result.getChildValue("name"))))) {
                result.makeElement("id").setValue(id);
            }
            if (!result.hasChild("description") && result.hasChild("title")) {
                result.makeElement("description").setValue(Utilities.makeId((String)result.getChildValue("title")));
            }
            while (lexer.hasToken("conceptmap")) {
                this.parseConceptMap(result, lexer);
            }
            while (lexer.hasToken("uses")) {
                this.parseUses(result, lexer);
            }
            while (lexer.hasToken("imports")) {
                this.parseImports(result, lexer);
            }
            while (lexer.hasToken("conceptmap")) {
                this.parseConceptMap(result, lexer);
            }
            while (!lexer.done()) {
                this.parseGroup(result, lexer);
            }
        }
        catch (FHIRLexer.FHIRLexerException e) {
            if (this.policy == ParserBase.ValidationPolicy.NONE) {
                throw e;
            }
            this.logError("2023-02-24", e.getLocation().getLine(), e.getLocation().getColumn(), "??", ValidationMessage.IssueType.INVALID, e.getMessage(), ValidationMessage.IssueSeverity.FATAL);
        }
        catch (Exception e) {
            if (this.policy == ParserBase.ValidationPolicy.NONE) {
                throw e;
            }
            this.logError("2023-02-24", -1, -1, "?", ValidationMessage.IssueType.INVALID, e.getMessage(), ValidationMessage.IssueSeverity.FATAL);
        }
        result.setIgnorePropertyOrder(true);
        return result;
    }

    private void parseConceptMap(Element structureMap, FHIRLexer lexer) throws FHIRLexer.FHIRLexerException {
        String n;
        lexer.token("conceptmap");
        Element map = structureMap.makeElement("contained");
        StructureDefinition sd = this.context.fetchTypeDefinition("ConceptMap");
        map.updateProperty(new Property(this.context, sd.getSnapshot().getElement().get(0), sd), Element.SpecialElement.fromProperty(map.getElementProperty() != null ? map.getElementProperty() : map.getProperty()), map.getProperty());
        map.setType("ConceptMap");
        Element eid = map.makeElement("id").markLocation(lexer.getCurrentLocation());
        String id = lexer.readConstant("map id");
        if (id.startsWith("#")) {
            throw lexer.error("Concept Map identifier must not start with #");
        }
        eid.setValue(id);
        map.makeElement("status").setValue(structureMap.getChildValue("status"));
        lexer.token("{");
        HashMap<String, String> prefixes = new HashMap<String, String>();
        while (lexer.hasToken("prefix")) {
            lexer.token("prefix");
            n = lexer.take();
            lexer.token("=");
            String v = lexer.readConstant("prefix url");
            prefixes.put(n, v);
        }
        while (lexer.hasToken("unmapped")) {
            lexer.token("unmapped");
            lexer.token("for");
            n = this.readPrefix(prefixes, lexer);
            Element g = this.getGroupE(map, n, null);
            lexer.token("=");
            SourceLocation loc = lexer.getCurrentLocation();
            String v = lexer.take();
            if (v.equals("provided")) {
                g.makeElement("unmapped").makeElement("mode").markLocation(loc).setValue(ConceptMap.ConceptMapGroupUnmappedMode.USESOURCECODE.toCode());
                continue;
            }
            throw lexer.error("Only unmapped mode PROVIDED is supported at this time");
        }
        while (!lexer.hasToken("}")) {
            String comments = lexer.hasComments() ? lexer.getAllComments() : null;
            String srcs = this.readPrefix(prefixes, lexer);
            lexer.token(":");
            SourceLocation scloc = lexer.getCurrentLocation();
            String sc = lexer.getCurrent().startsWith("\"") ? lexer.readConstant("code") : lexer.take();
            SourceLocation relLoc = lexer.getCurrentLocation();
            Enumerations.ConceptMapRelationship rel = this.readRelationship(lexer);
            String tgts = this.readPrefix(prefixes, lexer);
            Element g = this.getGroupE(map, srcs, tgts);
            Element e = g.addElement("element");
            if (comments != null) {
                for (String s : comments.split("\\r\\n")) {
                    e.getComments().add(s);
                }
            }
            e.makeElement("code").markLocation(scloc).setValue(sc.startsWith("\"") ? lexer.processConstant(sc) : sc);
            Element tgt = e.addElement("target");
            tgt.makeElement("relationship").markLocation(relLoc).setValue(rel.toCode());
            lexer.token(":");
            tgt.makeElement("code").markLocation(lexer.getCurrentLocation()).setValue(lexer.getCurrent().startsWith("\"") ? lexer.readConstant("code") : lexer.take());
            if (!lexer.hasComments()) continue;
            tgt.makeElement("comment").markLocation(lexer.getCommentLocation()).setValue(lexer.getFirstComment());
        }
        lexer.token("}");
    }

    private Element getGroupE(Element map, String srcs, String tgts) {
        for (Element grp : map.getChildrenByName("group")) {
            Element tgt;
            if (!grp.getChildValue("source").equals(srcs) || (tgt = grp.getNamedChild("target")) != null && tgts != null && !tgts.equals(tgt.getValue())) continue;
            if (tgt == null && tgts != null) {
                grp.makeElement("target").setValue(tgts);
            }
            return grp;
        }
        Element grp = map.addElement("group");
        grp.makeElement("source").setValue(srcs);
        grp.makeElement("target").setValue(tgts);
        return grp;
    }

    private String readPrefix(Map<String, String> prefixes, FHIRLexer lexer) throws FHIRLexer.FHIRLexerException {
        String prefix = lexer.take();
        if (!prefixes.containsKey(prefix)) {
            throw lexer.error("Unknown prefix '" + prefix + "'");
        }
        return prefixes.get(prefix);
    }

    private Enumerations.ConceptMapRelationship readRelationship(FHIRLexer lexer) throws FHIRLexer.FHIRLexerException {
        String token = lexer.take();
        if (token.equals("-")) {
            return Enumerations.ConceptMapRelationship.RELATEDTO;
        }
        if (token.equals("==")) {
            return Enumerations.ConceptMapRelationship.EQUIVALENT;
        }
        if (token.equals("!=")) {
            return Enumerations.ConceptMapRelationship.NOTRELATEDTO;
        }
        if (token.equals("<=")) {
            return Enumerations.ConceptMapRelationship.SOURCEISNARROWERTHANTARGET;
        }
        if (token.equals(">=")) {
            return Enumerations.ConceptMapRelationship.SOURCEISBROADERTHANTARGET;
        }
        throw lexer.error("Unknown relationship token '" + token + "'");
    }

    private void parseUses(Element result, FHIRLexer lexer) throws FHIRException {
        lexer.token("uses");
        Element st = result.addElement("structure");
        st.makeElement("url").markLocation(lexer.getCurrentLocation()).setValue(lexer.readConstant("url"));
        if (lexer.hasToken("alias")) {
            lexer.token("alias");
            st.makeElement("alias").markLocation(lexer.getCurrentLocation()).setValue(lexer.take());
        }
        lexer.token("as");
        st.makeElement("mode").markLocation(lexer.getCurrentLocation()).setValue(lexer.take());
        lexer.skipToken(";");
        if (lexer.hasComments()) {
            st.makeElement("documentation").markLocation(lexer.getCommentLocation()).setValue(lexer.getFirstComment());
        }
    }

    private void parseImports(Element result, FHIRLexer lexer) throws FHIRException {
        lexer.token("imports");
        result.addElement("import").markLocation(lexer.getCurrentLocation()).setValue(lexer.readConstant("url"));
        lexer.skipToken(";");
    }

    private void parseGroup(Element result, FHIRLexer lexer) throws FHIRException {
        SourceLocation commLoc = lexer.getCommentLocation();
        String comment = lexer.getAllComments();
        lexer.token("group");
        Element group = result.addElement("group").markLocation(lexer.getCurrentLocation());
        if (!Utilities.noString((String)comment)) {
            group.makeElement("documentation").markLocation(commLoc).setValue(comment);
        }
        boolean newFmt = false;
        if (lexer.hasToken("for")) {
            lexer.token("for");
            SourceLocation loc = lexer.getCurrentLocation();
            if ("type".equals(lexer.getCurrent())) {
                lexer.token("type");
                lexer.token("+");
                lexer.token("types");
                group.makeElement("typeMode").markLocation(loc).setValue(StructureMap.StructureMapGroupTypeMode.TYPEANDTYPES.toCode());
            } else {
                lexer.token("types");
                group.makeElement("typeMode").markLocation(loc).setValue(StructureMap.StructureMapGroupTypeMode.TYPES.toCode());
            }
        }
        group.makeElement("name").markLocation(lexer.getCurrentLocation()).setValue(lexer.take());
        if (lexer.hasToken("(")) {
            newFmt = true;
            lexer.take();
            while (!lexer.hasToken(")")) {
                this.parseInput(group, lexer, true);
                if (!lexer.hasToken(",")) continue;
                lexer.token(",");
            }
            lexer.take();
        }
        if (lexer.hasToken("extends")) {
            lexer.next();
            group.makeElement("extends").markLocation(lexer.getCurrentLocation()).setValue(lexer.take());
        }
        if (newFmt) {
            if (lexer.hasToken("<")) {
                lexer.token("<");
                lexer.token("<");
                if (lexer.hasToken("types")) {
                    group.makeElement("typeMode").markLocation(lexer.getCurrentLocation()).setValue(StructureMap.StructureMapGroupTypeMode.TYPES.toCode());
                    lexer.token("types");
                } else {
                    group.makeElement("typeMode").markLocation(lexer.getCurrentLocation()).setValue(StructureMap.StructureMapGroupTypeMode.TYPEANDTYPES.toCode());
                    lexer.token("type");
                    lexer.token("+");
                }
                lexer.token(">");
                lexer.token(">");
            }
            lexer.token("{");
        }
        if (newFmt) {
            while (!lexer.hasToken("}")) {
                if (lexer.done()) {
                    throw lexer.error("premature termination expecting 'endgroup'");
                }
                this.parseRule(result, group, lexer, true);
            }
        } else {
            while (lexer.hasToken("input")) {
                this.parseInput(group, lexer, false);
            }
            while (!lexer.hasToken("endgroup")) {
                if (lexer.done()) {
                    throw lexer.error("premature termination expecting 'endgroup'");
                }
                this.parseRule(result, group, lexer, false);
            }
        }
        lexer.next();
        if (newFmt && lexer.hasToken(";")) {
            lexer.next();
        }
    }

    private void parseRule(Element map, Element context, FHIRLexer lexer, boolean newFmt) throws FHIRException {
        Element rule = context.addElement("rule").markLocation(lexer.getCurrentLocation());
        if (!newFmt) {
            rule.makeElement("name").markLocation(lexer.getCurrentLocation()).setValue(lexer.takeDottedToken());
            lexer.token(":");
            lexer.token("for");
        } else if (lexer.hasComments()) {
            rule.makeElement("documentation").markLocation(lexer.getCommentLocation()).setValue(lexer.getFirstComment());
        }
        boolean done = false;
        while (!done) {
            this.parseSource(rule, lexer);
            done = !lexer.hasToken(",");
            if (done) continue;
            lexer.next();
        }
        if (newFmt && lexer.hasToken("->") || !newFmt && lexer.hasToken("make")) {
            lexer.token(newFmt ? "->" : "make");
            done = false;
            while (!done) {
                this.parseTarget(rule, lexer);
                done = !lexer.hasToken(",");
                if (done) continue;
                lexer.next();
            }
        }
        if (lexer.hasToken("then")) {
            lexer.token("then");
            if (lexer.hasToken("{")) {
                lexer.token("{");
                while (!lexer.hasToken("}")) {
                    if (lexer.done()) {
                        throw lexer.error("premature termination expecting '}' in nested group");
                    }
                    this.parseRule(map, rule, lexer, newFmt);
                }
                lexer.token("}");
            } else {
                done = false;
                while (!done) {
                    this.parseRuleReference(rule, lexer);
                    done = !lexer.hasToken(",");
                    if (done) continue;
                    lexer.next();
                }
            }
        }
        if (!rule.hasChild("documentation") && lexer.hasComments()) {
            rule.makeElement("documentation").markLocation(lexer.getCommentLocation()).setValue(lexer.getFirstComment());
        }
        if (this.isSimpleSyntax(rule)) {
            rule.forceElement("source").makeElement("variable").setValue("vvv");
            rule.forceElement("target").makeElement("variable").setValue("vvv");
            rule.forceElement("target").makeElement("transform").setValue(StructureMap.StructureMapTransform.CREATE.toCode());
            Element dep = rule.forceElement("dependent").markLocation(rule);
            dep.makeElement("name").markLocation(rule).setValue("DefaultMappingGroupAnonymousAlias");
            dep.addElement("parameter").markLocation(dep).makeElement("valueId").markLocation(dep).setValue("vvv");
            dep.addElement("parameter").markLocation(dep).makeElement("valueId").markLocation(dep).setValue("vvv");
        }
        if (newFmt) {
            if (lexer.isConstant()) {
                if (lexer.isStringConstant()) {
                    rule.makeElement("name").markLocation(lexer.getCurrentLocation()).setValue(lexer.readConstant("ruleName"));
                } else {
                    rule.makeElement("name").markLocation(lexer.getCurrentLocation()).setValue(lexer.take());
                }
            } else {
                if (rule.getChildrenByName("source").size() != 1 || !rule.getChildrenByName("source").get(0).hasChild("element")) {
                    throw lexer.error("Complex rules must have an explicit name");
                }
                if (rule.getChildrenByName("source").get(0).hasChild("type")) {
                    rule.makeElement("name").setValue(rule.getChildrenByName("source").get(0).getNamedChildValue("element") + Utilities.capitalize((String)rule.getChildrenByName("source").get(0).getNamedChildValue("type")));
                } else {
                    rule.makeElement("name").setValue(rule.getChildrenByName("source").get(0).getNamedChildValue("element"));
                }
            }
            lexer.token(";");
        }
    }

    private void parseRuleReference(Element rule, FHIRLexer lexer) throws FHIRLexer.FHIRLexerException {
        Element ref = rule.addElement("dependent").markLocation(lexer.getCurrentLocation());
        ref.makeElement("name").markLocation(lexer.getCurrentLocation()).setValue(lexer.take());
        lexer.token("(");
        boolean done = false;
        while (!done) {
            this.parseParameter(ref, lexer);
            done = !lexer.hasToken(",");
            if (done) continue;
            lexer.next();
        }
        lexer.token(")");
    }

    private void parseSource(Element rule, FHIRLexer lexer) throws FHIRException {
        ExpressionNode node;
        SourceLocation loc;
        Element source = rule.addElement("source").markLocation(lexer.getCurrentLocation());
        source.makeElement("context").markLocation(lexer.getCurrentLocation()).setValue(lexer.take());
        if (source.getChildValue("context").equals("search") && lexer.hasToken("(")) {
            source.makeElement("context").markLocation(lexer.getCurrentLocation()).setValue("@search");
            lexer.take();
            loc = lexer.getCurrentLocation();
            node = this.fpe.parse(lexer);
            source.setUserData("map.search.expression", node);
            source.makeElement("element").markLocation(loc).setValue(node.toString());
            lexer.token(")");
        } else if (lexer.hasToken(".")) {
            lexer.token(".");
            source.makeElement("element").markLocation(lexer.getCurrentLocation()).setValue(lexer.take());
        }
        if (lexer.hasToken(":")) {
            lexer.token(":");
            source.makeElement("type").markLocation(lexer.getCurrentLocation()).setValue(lexer.takeDottedToken());
        }
        if (Utilities.isInteger((String)lexer.getCurrent())) {
            source.makeElement("min").markLocation(lexer.getCurrentLocation()).setValue(lexer.take());
            lexer.token("..");
            source.makeElement("max").markLocation(lexer.getCurrentLocation()).setValue(lexer.take());
        }
        if (lexer.hasToken("default")) {
            lexer.token("default");
            source.makeElement("defaultValue").markLocation(lexer.getCurrentLocation()).setValue(lexer.readConstant("default value"));
        }
        if (Utilities.existsInList((String)lexer.getCurrent(), (String[])new String[]{"first", "last", "not_first", "not_last", "only_one"})) {
            source.makeElement("listMode").markLocation(lexer.getCurrentLocation()).setValue(lexer.take());
        }
        if (lexer.hasToken("as")) {
            lexer.take();
            source.makeElement("variable").markLocation(lexer.getCurrentLocation()).setValue(lexer.take());
        }
        if (lexer.hasToken("where")) {
            lexer.take();
            loc = lexer.getCurrentLocation();
            node = this.fpe.parse(lexer);
            source.setUserData("map.where.expression", node);
            source.makeElement("condition").markLocation(loc).setValue(node.toString());
        }
        if (lexer.hasToken("check")) {
            lexer.take();
            loc = lexer.getCurrentLocation();
            node = this.fpe.parse(lexer);
            source.setUserData("map.where.check", node);
            source.makeElement("check").markLocation(loc).setValue(node.toString());
        }
        if (lexer.hasToken("log")) {
            lexer.take();
            loc = lexer.getCurrentLocation();
            node = this.fpe.parse(lexer);
            source.setUserData("map.where.check", node);
            source.makeElement("logMessage").markLocation(loc).setValue(lexer.take());
        }
    }

    private void parseTarget(Element rule, FHIRLexer lexer) throws FHIRException {
        ExpressionNode node;
        String name;
        Element target = rule.addElement("target").markLocation(lexer.getCurrentLocation());
        SourceLocation loc = lexer.getCurrentLocation();
        String start = lexer.take();
        if (lexer.hasToken(".")) {
            target.makeElement("context").markLocation(loc).setValue(start);
            start = null;
            lexer.token(".");
            target.makeElement("element").markLocation(lexer.getCurrentLocation()).setValue(lexer.take());
        }
        boolean isConstant = false;
        if (lexer.hasToken("=")) {
            if (start != null) {
                target.makeElement("context").markLocation(loc).setValue(start);
            }
            lexer.token("=");
            isConstant = lexer.isConstant();
            loc = lexer.getCurrentLocation();
            name = lexer.take();
        } else {
            loc = lexer.getCurrentLocation();
            name = start;
        }
        if ("(".equals(name)) {
            target.makeElement("transform").markLocation(lexer.getCurrentLocation()).setValue(StructureMap.StructureMapTransform.EVALUATE.toCode());
            loc = lexer.getCurrentLocation();
            node = this.fpe.parse(lexer);
            target.setUserData("map.transform.expression", node);
            target.addElement("parameter").markLocation(loc).makeElement("valueString").setValue(node.toString());
            lexer.token(")");
        } else if (lexer.hasToken("(")) {
            target.makeElement("transform").markLocation(loc).setValue(name);
            lexer.token("(");
            if (target.getChildValue("transform").equals(StructureMap.StructureMapTransform.EVALUATE.toCode())) {
                this.parseParameter(target, lexer);
                lexer.token(",");
                loc = lexer.getCurrentLocation();
                node = this.fpe.parse(lexer);
                target.setUserData("map.transform.expression", node);
                target.addElement("parameter").markLocation(loc).makeElement("valueString").setValue(node.toString());
            } else {
                while (!lexer.hasToken(")")) {
                    this.parseParameter(target, lexer);
                    if (lexer.hasToken(")")) continue;
                    lexer.token(",");
                }
            }
            lexer.token(")");
        } else if (name != null) {
            target.makeElement("transform").markLocation(loc).setValue(StructureMap.StructureMapTransform.COPY.toCode());
            if (!isConstant) {
                loc = lexer.getCurrentLocation();
                Object id = name;
                while (lexer.hasToken(".")) {
                    id = (String)id + lexer.take() + lexer.take();
                }
                target.addElement("parameter").markLocation(loc).makeElement("valueId").setValue((String)id);
            } else {
                target.addElement("parameter").markLocation(lexer.getCurrentLocation()).makeElement("valueString").setValue(this.readConstant(name, lexer));
            }
        }
        if (lexer.hasToken("as")) {
            lexer.take();
            target.makeElement("variable").markLocation(lexer.getCurrentLocation()).setValue(lexer.take());
        }
        while (Utilities.existsInList((String)lexer.getCurrent(), (String[])new String[]{"first", "last", "share", "collate"})) {
            if (lexer.getCurrent().equals("share")) {
                target.makeElement("listMode").markLocation(lexer.getCurrentLocation()).setValue(lexer.take());
                target.makeElement("listRuleId").markLocation(lexer.getCurrentLocation()).setValue(lexer.take());
                continue;
            }
            target.makeElement("listMode").markLocation(lexer.getCurrentLocation()).setValue(lexer.take());
        }
    }

    private void parseParameter(Element ref, FHIRLexer lexer) throws FHIRLexer.FHIRLexerException, FHIRFormatError {
        if (!lexer.isConstant()) {
            ref.addElement("parameter").markLocation(lexer.getCurrentLocation()).makeElement("valueId").setValue(lexer.take());
        } else if (lexer.isStringConstant()) {
            ref.addElement("parameter").markLocation(lexer.getCurrentLocation()).makeElement("valueString").setValue(lexer.readConstant("??"));
        } else {
            ref.addElement("parameter").markLocation(lexer.getCurrentLocation()).makeElement("valueString").setValue(this.readConstant(lexer.take(), lexer));
        }
    }

    private void parseInput(Element group, FHIRLexer lexer, boolean newFmt) throws FHIRException {
        Element input = group.addElement("input").markLocation(lexer.getCurrentLocation());
        if (newFmt) {
            input.makeElement("mode").markLocation(lexer.getCurrentLocation()).setValue(lexer.take());
        } else {
            lexer.token("input");
        }
        input.makeElement("name").markLocation(lexer.getCurrentLocation()).setValue(lexer.take());
        if (lexer.hasToken(":")) {
            lexer.token(":");
            input.makeElement("type").markLocation(lexer.getCurrentLocation()).setValue(lexer.take());
        }
        if (!newFmt) {
            lexer.token("as");
            input.makeElement("mode").markLocation(lexer.getCurrentLocation()).setValue(lexer.take());
            if (lexer.hasComments()) {
                input.makeElement("documentation").markLocation(lexer.getCommentLocation()).setValue(lexer.getFirstComment());
            }
            lexer.skipToken(";");
        }
    }

    private boolean isSimpleSyntax(Element rule) {
        return rule.getChildren("source").size() == 1 && rule.getChildren("source").get(0).hasChild("context") && rule.getChildren("source").get(0).hasChild("element") && !rule.getChildren("source").get(0).hasChild("variable") && rule.getChildren("target").size() == 1 && rule.getChildren("target").get(0).hasChild("context") && rule.getChildren("target").get(0).hasChild("element") && !rule.getChildren("target").get(0).hasChild("variable") && !rule.getChildren("target").get(0).hasChild("parameter") && rule.getChildren("dependent").size() == 0 && rule.getChildren("rule").size() == 0;
    }

    private String readConstant(String s, FHIRLexer lexer) throws FHIRLexer.FHIRLexerException {
        if (Utilities.isInteger((String)s)) {
            return s;
        }
        if (Utilities.isDecimal((String)s, (boolean)false)) {
            return s;
        }
        if (Utilities.existsInList((String)s, (String[])new String[]{"true", "false"})) {
            return s;
        }
        return lexer.processConstant(s);
    }
}

