/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Account;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.ActorDefinition;
import org.hl7.fhir.r5.model.AdministrableProductDefinition;
import org.hl7.fhir.r5.model.AdverseEvent;
import org.hl7.fhir.r5.model.AllergyIntolerance;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.Appointment;
import org.hl7.fhir.r5.model.AppointmentResponse;
import org.hl7.fhir.r5.model.ArtifactAssessment;
import org.hl7.fhir.r5.model.AuditEvent;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Basic;
import org.hl7.fhir.r5.model.Binary;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.BiologicallyDerivedProductDispense;
import org.hl7.fhir.r5.model.BodyStructure;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.ChargeItem;
import org.hl7.fhir.r5.model.ChargeItemDefinition;
import org.hl7.fhir.r5.model.Citation;
import org.hl7.fhir.r5.model.Claim;
import org.hl7.fhir.r5.model.ClaimResponse;
import org.hl7.fhir.r5.model.ClinicalImpression;
import org.hl7.fhir.r5.model.ClinicalUseDefinition;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Communication;
import org.hl7.fhir.r5.model.CommunicationRequest;
import org.hl7.fhir.r5.model.CompartmentDefinition;
import org.hl7.fhir.r5.model.Composition;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.Condition;
import org.hl7.fhir.r5.model.ConditionDefinition;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Consent;
import org.hl7.fhir.r5.model.Contract;
import org.hl7.fhir.r5.model.Coverage;
import org.hl7.fhir.r5.model.CoverageEligibilityRequest;
import org.hl7.fhir.r5.model.CoverageEligibilityResponse;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DeviceAssociation;
import org.hl7.fhir.r5.model.DeviceDefinition;
import org.hl7.fhir.r5.model.DeviceDispense;
import org.hl7.fhir.r5.model.DeviceMetric;
import org.hl7.fhir.r5.model.DeviceRequest;
import org.hl7.fhir.r5.model.DeviceUsage;
import org.hl7.fhir.r5.model.DiagnosticReport;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.EncounterHistory;
import org.hl7.fhir.r5.model.Endpoint;
import org.hl7.fhir.r5.model.EnrollmentRequest;
import org.hl7.fhir.r5.model.EnrollmentResponse;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.EpisodeOfCare;
import org.hl7.fhir.r5.model.EventDefinition;
import org.hl7.fhir.r5.model.Evidence;
import org.hl7.fhir.r5.model.EvidenceReport;
import org.hl7.fhir.r5.model.EvidenceVariable;
import org.hl7.fhir.r5.model.ExampleScenario;
import org.hl7.fhir.r5.model.ExplanationOfBenefit;
import org.hl7.fhir.r5.model.FamilyMemberHistory;
import org.hl7.fhir.r5.model.Flag;
import org.hl7.fhir.r5.model.FormularyItem;
import org.hl7.fhir.r5.model.GenomicStudy;
import org.hl7.fhir.r5.model.Goal;
import org.hl7.fhir.r5.model.GraphDefinition;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.GuidanceResponse;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImagingSelection;
import org.hl7.fhir.r5.model.ImagingStudy;
import org.hl7.fhir.r5.model.Immunization;
import org.hl7.fhir.r5.model.ImmunizationEvaluation;
import org.hl7.fhir.r5.model.ImmunizationRecommendation;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.Ingredient;
import org.hl7.fhir.r5.model.InsurancePlan;
import org.hl7.fhir.r5.model.InventoryItem;
import org.hl7.fhir.r5.model.InventoryReport;
import org.hl7.fhir.r5.model.Invoice;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.Linkage;
import org.hl7.fhir.r5.model.ListResource;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.ManufacturedItemDefinition;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Measure;
import org.hl7.fhir.r5.model.MeasureReport;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MedicationAdministration;
import org.hl7.fhir.r5.model.MedicationDispense;
import org.hl7.fhir.r5.model.MedicationKnowledge;
import org.hl7.fhir.r5.model.MedicationRequest;
import org.hl7.fhir.r5.model.MedicationStatement;
import org.hl7.fhir.r5.model.MedicinalProductDefinition;
import org.hl7.fhir.r5.model.MessageDefinition;
import org.hl7.fhir.r5.model.MessageHeader;
import org.hl7.fhir.r5.model.MolecularSequence;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.NutritionIntake;
import org.hl7.fhir.r5.model.NutritionOrder;
import org.hl7.fhir.r5.model.NutritionProduct;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.ObservationDefinition;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.OrganizationAffiliation;
import org.hl7.fhir.r5.model.PackagedProductDefinition;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.PaymentNotice;
import org.hl7.fhir.r5.model.PaymentReconciliation;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Permission;
import org.hl7.fhir.r5.model.Person;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Provenance;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RegulatedAuthorization;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.RequestOrchestration;
import org.hl7.fhir.r5.model.Requirements;
import org.hl7.fhir.r5.model.ResearchStudy;
import org.hl7.fhir.r5.model.ResearchSubject;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.RiskAssessment;
import org.hl7.fhir.r5.model.Schedule;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.Slot;
import org.hl7.fhir.r5.model.Specimen;
import org.hl7.fhir.r5.model.SpecimenDefinition;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.Subscription;
import org.hl7.fhir.r5.model.SubscriptionStatus;
import org.hl7.fhir.r5.model.SubscriptionTopic;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.SubstanceDefinition;
import org.hl7.fhir.r5.model.SubstanceNucleicAcid;
import org.hl7.fhir.r5.model.SubstancePolymer;
import org.hl7.fhir.r5.model.SubstanceProtein;
import org.hl7.fhir.r5.model.SubstanceReferenceInformation;
import org.hl7.fhir.r5.model.SubstanceSourceMaterial;
import org.hl7.fhir.r5.model.SupplyDelivery;
import org.hl7.fhir.r5.model.SupplyRequest;
import org.hl7.fhir.r5.model.Task;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.TestPlan;
import org.hl7.fhir.r5.model.TestReport;
import org.hl7.fhir.r5.model.TestScript;
import org.hl7.fhir.r5.model.Transport;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.model.VerificationResult;
import org.hl7.fhir.r5.model.VisionPrescription;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="DetectedIssue", profile="http://hl7.org/fhir/StructureDefinition/DetectedIssue")
public class DetectedIssue
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Unique id for the detected issue", formalDefinition="Business identifier associated with the detected issue record.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="preliminary | final | entered-in-error | mitigated", formalDefinition="Indicates the status of the detected issue.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/detectedissue-status")
    protected Enumeration<DetectedIssueStatus> status;
    @Child(name="category", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Type of detected issue, e.g. drug-drug, duplicate therapy, etc", formalDefinition="A code that classifies the general type of detected issue.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/detectedissue-category")
    protected List<CodeableConcept> category;
    @Child(name="code", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Specific type of detected issue, e.g. drug-drug, duplicate therapy, etc", formalDefinition="Identifies the specific type of issue identified.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/detectedissue-category")
    protected CodeableConcept code;
    @Child(name="severity", type={CodeType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="high | moderate | low", formalDefinition="Indicates the degree of importance associated with the identified issue based on the potential impact on the patient.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/detectedissue-severity")
    protected Enumeration<DetectedIssueSeverity> severity;
    @Child(name="subject", type={Patient.class, Group.class, Device.class, Location.class, Organization.class, Procedure.class, Practitioner.class, Medication.class, Substance.class, BiologicallyDerivedProduct.class, NutritionProduct.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Associated subject", formalDefinition="Indicates the subject whose record the detected issue is associated with.")
    protected Reference subject;
    @Child(name="encounter", type={Encounter.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Encounter detected issue is part of", formalDefinition="The encounter during which this issue was detected.")
    protected Reference encounter;
    @Child(name="identified", type={DateTimeType.class, Period.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When identified", formalDefinition="The date or period when the detected issue was initially identified.")
    protected DataType identified;
    @Child(name="author", type={Patient.class, RelatedPerson.class, Practitioner.class, PractitionerRole.class, Device.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The provider or device that identified the issue", formalDefinition="Individual or device responsible for the issue being raised.  For example, a decision support application or a pharmacist conducting a medication review.")
    protected Reference author;
    @Child(name="implicated", type={Reference.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Problem resource", formalDefinition="Indicates the resource representing the current activity or proposed activity that is potentially problematic.")
    protected List<Reference> implicated;
    @Child(name="evidence", type={}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Supporting evidence", formalDefinition="Supporting evidence or manifestations that provide the basis for identifying the detected issue such as a GuidanceResponse or MeasureReport.")
    protected List<DetectedIssueEvidenceComponent> evidence;
    @Child(name="detail", type={MarkdownType.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Description and context", formalDefinition="A textual explanation of the detected issue.")
    protected MarkdownType detail;
    @Child(name="reference", type={UriType.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Authority for issue", formalDefinition="The literature, knowledge-base or similar reference that describes the propensity for the detected issue identified.")
    protected UriType reference;
    @Child(name="mitigation", type={}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Step taken to address", formalDefinition="Indicates an action that has been taken or is committed to reduce or eliminate the likelihood of the risk identified by the detected issue from manifesting.  Can also reflect an observation of known mitigating factors that may reduce/eliminate the need for any action.")
    protected List<DetectedIssueMitigationComponent> mitigation;
    private static final long serialVersionUID = 1031242519L;
    @SearchParamDefinition(name="author", path="DetectedIssue.author", description="The provider or device that identified the issue", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Device"), @Compartment(name="Base FHIR compartment definition for Practitioner")}, target={Device.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_AUTHOR = "author";
    public static final ReferenceClientParam AUTHOR = new ReferenceClientParam("author");
    public static final Include INCLUDE_AUTHOR = new Include("DetectedIssue:author").toLocked();
    @SearchParamDefinition(name="category", path="DetectedIssue.category", description="Issue Category, e.g. drug-drug, duplicate therapy, etc.", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="identified", path="DetectedIssue.identified.ofType(dateTime) | DetectedIssue.identified.ofType(Period)", description="When identified", type="date")
    public static final String SP_IDENTIFIED = "identified";
    public static final DateClientParam IDENTIFIED = new DateClientParam("identified");
    @SearchParamDefinition(name="implicated", path="DetectedIssue.implicated", description="Problem resource", type="reference", target={Account.class, ActivityDefinition.class, ActorDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, ArtifactAssessment.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BiologicallyDerivedProductDispense.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CarePlan.class, CareTeam.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceAssociation.class, DeviceDefinition.class, DeviceDispense.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentReference.class, Encounter.class, EncounterHistory.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, FormularyItem.class, GenomicStudy.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingSelection.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryItem.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationStatement.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Parameters.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestOrchestration.class, Requirements.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestPlan.class, TestReport.class, TestScript.class, Transport.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_IMPLICATED = "implicated";
    public static final ReferenceClientParam IMPLICATED = new ReferenceClientParam("implicated");
    public static final Include INCLUDE_IMPLICATED = new Include("DetectedIssue:implicated").toLocked();
    @SearchParamDefinition(name="status", path="DetectedIssue.status", description="The status of the issue", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject", path="DetectedIssue.subject", description="Associated subject", type="reference", target={BiologicallyDerivedProduct.class, Device.class, Group.class, Location.class, Medication.class, NutritionProduct.class, Organization.class, Patient.class, Practitioner.class, Procedure.class, Substance.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("DetectedIssue:subject").toLocked();
    @SearchParamDefinition(name="code", path="AdverseEvent.code | AllergyIntolerance.code | AllergyIntolerance.reaction.substance | AuditEvent.code | Basic.code | ChargeItem.code | Condition.code | DetectedIssue.code | DeviceRequest.code.concept | DiagnosticReport.code | FamilyMemberHistory.condition.code | ImagingSelection.status | List.code | Medication.code | MedicationAdministration.medication.concept | MedicationDispense.medication.concept | MedicationRequest.medication.concept | MedicationStatement.medication.concept | NutritionIntake.code | Observation.code | Procedure.code | RequestOrchestration.code | Task.code", description="Multiple Resources: \r\n\r\n* [AdverseEvent](adverseevent.html): Event or incident that occurred or was averted\r\n* [AllergyIntolerance](allergyintolerance.html): Code that identifies the allergy or intolerance\r\n* [AuditEvent](auditevent.html): More specific code for the event\r\n* [Basic](basic.html): Kind of Resource\r\n* [ChargeItem](chargeitem.html): A code that identifies the charge, like a billing code\r\n* [Condition](condition.html): Code for the condition\r\n* [DetectedIssue](detectedissue.html): Issue Type, e.g. drug-drug, duplicate therapy, etc.\r\n* [DeviceRequest](devicerequest.html): Code for what is being requested/ordered\r\n* [DiagnosticReport](diagnosticreport.html): The code for the report, as opposed to codes for the atomic results, which are the names on the observation resource referred to from the result\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a condition code\r\n* [ImagingSelection](imagingselection.html): The imaging selection status\r\n* [List](list.html): What the purpose of this list is\r\n* [Medication](medication.html): Returns medications for a specific code\r\n* [MedicationAdministration](medicationadministration.html): Return administrations of this medication code\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses of this medicine code\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions of this medication code\r\n* [MedicationStatement](medicationstatement.html): Return statements of this medication code\r\n* [NutritionIntake](nutritionintake.html): Returns statements of this code of NutritionIntake\r\n* [Observation](observation.html): The code of the observation type\r\n* [Procedure](procedure.html): A code to identify a  procedure\r\n* [RequestOrchestration](requestorchestration.html): The code of the request orchestration\r\n* [Task](task.html): Search by task code\r\n", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="identifier", path="Account.identifier | AdverseEvent.identifier | AllergyIntolerance.identifier | Appointment.identifier | AppointmentResponse.identifier | Basic.identifier | BodyStructure.identifier | CarePlan.identifier | CareTeam.identifier | ChargeItem.identifier | Claim.identifier | ClaimResponse.identifier | ClinicalImpression.identifier | Communication.identifier | CommunicationRequest.identifier | Composition.identifier | Condition.identifier | Consent.identifier | Contract.identifier | Coverage.identifier | CoverageEligibilityRequest.identifier | CoverageEligibilityResponse.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DeviceUsage.identifier | DiagnosticReport.identifier | DocumentReference.identifier | Encounter.identifier | EnrollmentRequest.identifier | EpisodeOfCare.identifier | ExplanationOfBenefit.identifier | FamilyMemberHistory.identifier | Flag.identifier | Goal.identifier | GuidanceResponse.identifier | ImagingSelection.identifier | ImagingStudy.identifier | Immunization.identifier | ImmunizationEvaluation.identifier | ImmunizationRecommendation.identifier | Invoice.identifier | List.identifier | MeasureReport.identifier | Medication.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationStatement.identifier | MolecularSequence.identifier | NutritionIntake.identifier | NutritionOrder.identifier | Observation.identifier | Person.identifier | Procedure.identifier | QuestionnaireResponse.identifier | RelatedPerson.identifier | RequestOrchestration.identifier | ResearchSubject.identifier | RiskAssessment.identifier | ServiceRequest.identifier | Specimen.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | Task.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [Account](account.html): Account number\r\n* [AdverseEvent](adverseevent.html): Business identifier for the event\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [Appointment](appointment.html): An Identifier of the Appointment\r\n* [AppointmentResponse](appointmentresponse.html): An Identifier in this appointment response\r\n* [Basic](basic.html): Business identifier\r\n* [BodyStructure](bodystructure.html): Bodystructure identifier\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [ChargeItem](chargeitem.html): Business Identifier for item\r\n* [Claim](claim.html): The primary identifier of the financial resource\r\n* [ClaimResponse](claimresponse.html): The identity of the ClaimResponse\r\n* [ClinicalImpression](clinicalimpression.html): Business identifier\r\n* [Communication](communication.html): Unique identifier\r\n* [CommunicationRequest](communicationrequest.html): Unique identifier\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [Contract](contract.html): The identity of the contract\r\n* [Coverage](coverage.html): The primary identifier of the insured and the coverage\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The business identifier of the Eligibility\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The business identifier\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DeviceUsage](deviceusage.html): Search by identifier\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentReference](documentreference.html): Identifier of the attachment binary\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EnrollmentRequest](enrollmentrequest.html): The business identifier of the Enrollment\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The business identifier of the Explanation of Benefit\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Flag](flag.html): Business identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [GuidanceResponse](guidanceresponse.html): The identifier of the guidance response\r\n* [ImagingSelection](imagingselection.html): Identifiers for the imaging selection\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID\r\n* [Immunization](immunization.html): Business identifier\r\n* [ImmunizationEvaluation](immunizationevaluation.html): ID of the evaluation\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Business identifier\r\n* [Invoice](invoice.html): Business Identifier for item\r\n* [List](list.html): Business identifier\r\n* [MeasureReport](measurereport.html): External identifier of the measure report to be returned\r\n* [Medication](medication.html): Returns medications with this external identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationStatement](medicationstatement.html): Return statements with this external identifier\r\n* [MolecularSequence](molecularsequence.html): The unique identity for a particular sequence\r\n* [NutritionIntake](nutritionintake.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Person](person.html): A person Identifier\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [QuestionnaireResponse](questionnaireresponse.html): The unique identifier for the questionnaire response\r\n* [RelatedPerson](relatedperson.html): An Identifier of the RelatedPerson\r\n* [RequestOrchestration](requestorchestration.html): External identifiers for the request orchestration\r\n* [ResearchSubject](researchsubject.html): Business Identifier for research subject in a study\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [Specimen](specimen.html): The unique identifier associated with the specimen\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [Task](task.html): Search for a task instance by its business identifier\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="Account.subject.where(resolve() is Patient) | AdverseEvent.subject.where(resolve() is Patient) | AllergyIntolerance.patient | Appointment.participant.actor.where(resolve() is Patient) | Appointment.subject.where(resolve() is Patient) | AppointmentResponse.actor.where(resolve() is Patient) | AuditEvent.patient | Basic.subject.where(resolve() is Patient) | BodyStructure.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ChargeItem.subject.where(resolve() is Patient) | Claim.patient | ClaimResponse.patient | ClinicalImpression.subject.where(resolve() is Patient) | Communication.subject.where(resolve() is Patient) | CommunicationRequest.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | Contract.subject.where(resolve() is Patient) | Coverage.beneficiary | CoverageEligibilityRequest.patient | CoverageEligibilityResponse.patient | DetectedIssue.subject.where(resolve() is Patient) | DeviceRequest.subject.where(resolve() is Patient) | DeviceUsage.patient | DiagnosticReport.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EnrollmentRequest.candidate | EpisodeOfCare.patient | ExplanationOfBenefit.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | GuidanceResponse.subject.where(resolve() is Patient) | ImagingSelection.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | ImmunizationEvaluation.patient | ImmunizationRecommendation.patient | Invoice.subject.where(resolve() is Patient) | List.subject.where(resolve() is Patient) | MeasureReport.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationStatement.subject.where(resolve() is Patient) | MolecularSequence.subject.where(resolve() is Patient) | NutritionIntake.subject.where(resolve() is Patient) | NutritionOrder.subject.where(resolve() is Patient) | Observation.subject.where(resolve() is Patient) | Person.link.target.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | Provenance.patient | QuestionnaireResponse.subject.where(resolve() is Patient) | RelatedPerson.patient | RequestOrchestration.subject.where(resolve() is Patient) | ResearchSubject.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | Specimen.subject.where(resolve() is Patient) | SupplyDelivery.patient | SupplyRequest.deliverFor | Task.for.where(resolve() is Patient) | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [Account](account.html): The entity that caused the expenses\r\n* [AdverseEvent](adverseevent.html): Subject impacted by event\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [Appointment](appointment.html): One of the individuals of the appointment is this patient\r\n* [AppointmentResponse](appointmentresponse.html): This Response is for this Patient\r\n* [AuditEvent](auditevent.html): Where the activity involved patient data\r\n* [Basic](basic.html): Identifies the focus of this resource\r\n* [BodyStructure](bodystructure.html): Who this is about\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ChargeItem](chargeitem.html): Individual service was done for/to\r\n* [Claim](claim.html): Patient receiving the products or services\r\n* [ClaimResponse](claimresponse.html): The subject of care\r\n* [ClinicalImpression](clinicalimpression.html): Patient assessed\r\n* [Communication](communication.html): Focus of message\r\n* [CommunicationRequest](communicationrequest.html): Focus of message\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [Contract](contract.html): The identity of the subject of the contract (if a patient)\r\n* [Coverage](coverage.html): Retrieve coverages for a patient\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The reference to the patient\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The reference to the patient\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUsage](deviceusage.html): Search by patient who used / uses the device\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient present at the encounter\r\n* [EnrollmentRequest](enrollmentrequest.html): The party to be enrolled\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The reference to the patient\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [GuidanceResponse](guidanceresponse.html): The identity of a patient to search for guidance response results\r\n* [ImagingSelection](imagingselection.html): Who the study is about\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [ImmunizationEvaluation](immunizationevaluation.html): The patient being evaluated\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Who this profile is for\r\n* [Invoice](invoice.html): Recipient(s) of goods and services\r\n* [List](list.html): If all resources have the same subject\r\n* [MeasureReport](measurereport.html): The identity of a patient to search for individual measure report results for\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationStatement](medicationstatement.html): Returns statements for a specific patient.\r\n* [MolecularSequence](molecularsequence.html): The subject that the sequence is about\r\n* [NutritionIntake](nutritionintake.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the individual or set of individuals who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Person](person.html): The Person links to this Patient\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [Provenance](provenance.html): Where the activity involved patient data\r\n* [QuestionnaireResponse](questionnaireresponse.html): The patient that is the subject of the questionnaire response\r\n* [RelatedPerson](relatedperson.html): The patient this related person is related to\r\n* [RequestOrchestration](requestorchestration.html): The identity of a patient to search for request orchestrations\r\n* [ResearchSubject](researchsubject.html): Who or what is part of study\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [Specimen](specimen.html): The patient the specimen comes from\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [SupplyRequest](supplyrequest.html): The patient or subject for whom the supply is destined\r\n* [Task](task.html): Search by patient\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("DetectedIssue:patient").toLocked();

    public DetectedIssue() {
    }

    public DetectedIssue(DetectedIssueStatus status) {
        this.setStatus(status);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public DetectedIssue setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public DetectedIssue addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<DetectedIssueStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DetectedIssue.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<DetectedIssueStatus>(new DetectedIssueStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public DetectedIssue setStatusElement(Enumeration<DetectedIssueStatus> value) {
        this.status = value;
        return this;
    }

    public DetectedIssueStatus getStatus() {
        return this.status == null ? null : (DetectedIssueStatus)((Object)this.status.getValue());
    }

    public DetectedIssue setStatus(DetectedIssueStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<DetectedIssueStatus>(new DetectedIssueStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public DetectedIssue setCategory(List<CodeableConcept> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public DetectedIssue addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DetectedIssue.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public DetectedIssue setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public Enumeration<DetectedIssueSeverity> getSeverityElement() {
        if (this.severity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DetectedIssue.severity");
            }
            if (Configuration.doAutoCreate()) {
                this.severity = new Enumeration<DetectedIssueSeverity>(new DetectedIssueSeverityEnumFactory());
            }
        }
        return this.severity;
    }

    public boolean hasSeverityElement() {
        return this.severity != null && !this.severity.isEmpty();
    }

    public boolean hasSeverity() {
        return this.severity != null && !this.severity.isEmpty();
    }

    public DetectedIssue setSeverityElement(Enumeration<DetectedIssueSeverity> value) {
        this.severity = value;
        return this;
    }

    public DetectedIssueSeverity getSeverity() {
        return this.severity == null ? null : (DetectedIssueSeverity)((Object)this.severity.getValue());
    }

    public DetectedIssue setSeverity(DetectedIssueSeverity value) {
        if (value == null) {
            this.severity = null;
        } else {
            if (this.severity == null) {
                this.severity = new Enumeration<DetectedIssueSeverity>(new DetectedIssueSeverityEnumFactory());
            }
            this.severity.setValue((Object)value);
        }
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DetectedIssue.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public DetectedIssue setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DetectedIssue.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public DetectedIssue setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public DataType getIdentified() {
        return this.identified;
    }

    public DateTimeType getIdentifiedDateTimeType() throws FHIRException {
        if (this.identified == null) {
            this.identified = new DateTimeType();
        }
        if (!(this.identified instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.identified.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.identified;
    }

    public boolean hasIdentifiedDateTimeType() {
        return this != null && this.identified instanceof DateTimeType;
    }

    public Period getIdentifiedPeriod() throws FHIRException {
        if (this.identified == null) {
            this.identified = new Period();
        }
        if (!(this.identified instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.identified.getClass().getName() + " was encountered");
        }
        return (Period)this.identified;
    }

    public boolean hasIdentifiedPeriod() {
        return this != null && this.identified instanceof Period;
    }

    public boolean hasIdentified() {
        return this.identified != null && !this.identified.isEmpty();
    }

    public DetectedIssue setIdentified(DataType value) {
        if (value != null && !(value instanceof DateTimeType) && !(value instanceof Period)) {
            throw new FHIRException("Not the right type for DetectedIssue.identified[x]: " + value.fhirType());
        }
        this.identified = value;
        return this;
    }

    public Reference getAuthor() {
        if (this.author == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DetectedIssue.author");
            }
            if (Configuration.doAutoCreate()) {
                this.author = new Reference();
            }
        }
        return this.author;
    }

    public boolean hasAuthor() {
        return this.author != null && !this.author.isEmpty();
    }

    public DetectedIssue setAuthor(Reference value) {
        this.author = value;
        return this;
    }

    public List<Reference> getImplicated() {
        if (this.implicated == null) {
            this.implicated = new ArrayList<Reference>();
        }
        return this.implicated;
    }

    public DetectedIssue setImplicated(List<Reference> theImplicated) {
        this.implicated = theImplicated;
        return this;
    }

    public boolean hasImplicated() {
        if (this.implicated == null) {
            return false;
        }
        for (Reference item : this.implicated) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addImplicated() {
        Reference t = new Reference();
        if (this.implicated == null) {
            this.implicated = new ArrayList<Reference>();
        }
        this.implicated.add(t);
        return t;
    }

    public DetectedIssue addImplicated(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.implicated == null) {
            this.implicated = new ArrayList<Reference>();
        }
        this.implicated.add(t);
        return this;
    }

    public Reference getImplicatedFirstRep() {
        if (this.getImplicated().isEmpty()) {
            this.addImplicated();
        }
        return this.getImplicated().get(0);
    }

    public List<DetectedIssueEvidenceComponent> getEvidence() {
        if (this.evidence == null) {
            this.evidence = new ArrayList<DetectedIssueEvidenceComponent>();
        }
        return this.evidence;
    }

    public DetectedIssue setEvidence(List<DetectedIssueEvidenceComponent> theEvidence) {
        this.evidence = theEvidence;
        return this;
    }

    public boolean hasEvidence() {
        if (this.evidence == null) {
            return false;
        }
        for (DetectedIssueEvidenceComponent item : this.evidence) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DetectedIssueEvidenceComponent addEvidence() {
        DetectedIssueEvidenceComponent t = new DetectedIssueEvidenceComponent();
        if (this.evidence == null) {
            this.evidence = new ArrayList<DetectedIssueEvidenceComponent>();
        }
        this.evidence.add(t);
        return t;
    }

    public DetectedIssue addEvidence(DetectedIssueEvidenceComponent t) {
        if (t == null) {
            return this;
        }
        if (this.evidence == null) {
            this.evidence = new ArrayList<DetectedIssueEvidenceComponent>();
        }
        this.evidence.add(t);
        return this;
    }

    public DetectedIssueEvidenceComponent getEvidenceFirstRep() {
        if (this.getEvidence().isEmpty()) {
            this.addEvidence();
        }
        return this.getEvidence().get(0);
    }

    public MarkdownType getDetailElement() {
        if (this.detail == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DetectedIssue.detail");
            }
            if (Configuration.doAutoCreate()) {
                this.detail = new MarkdownType();
            }
        }
        return this.detail;
    }

    public boolean hasDetailElement() {
        return this.detail != null && !this.detail.isEmpty();
    }

    public boolean hasDetail() {
        return this.detail != null && !this.detail.isEmpty();
    }

    public DetectedIssue setDetailElement(MarkdownType value) {
        this.detail = value;
        return this;
    }

    public String getDetail() {
        return this.detail == null ? null : (String)this.detail.getValue();
    }

    public DetectedIssue setDetail(String value) {
        if (Utilities.noString((String)value)) {
            this.detail = null;
        } else {
            if (this.detail == null) {
                this.detail = new MarkdownType();
            }
            this.detail.setValue(value);
        }
        return this;
    }

    public UriType getReferenceElement() {
        if (this.reference == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DetectedIssue.reference");
            }
            if (Configuration.doAutoCreate()) {
                this.reference = new UriType();
            }
        }
        return this.reference;
    }

    public boolean hasReferenceElement() {
        return this.reference != null && !this.reference.isEmpty();
    }

    public boolean hasReference() {
        return this.reference != null && !this.reference.isEmpty();
    }

    public DetectedIssue setReferenceElement(UriType value) {
        this.reference = value;
        return this;
    }

    public String getReference() {
        return this.reference == null ? null : (String)this.reference.getValue();
    }

    public DetectedIssue setReference(String value) {
        if (Utilities.noString((String)value)) {
            this.reference = null;
        } else {
            if (this.reference == null) {
                this.reference = new UriType();
            }
            this.reference.setValue(value);
        }
        return this;
    }

    public List<DetectedIssueMitigationComponent> getMitigation() {
        if (this.mitigation == null) {
            this.mitigation = new ArrayList<DetectedIssueMitigationComponent>();
        }
        return this.mitigation;
    }

    public DetectedIssue setMitigation(List<DetectedIssueMitigationComponent> theMitigation) {
        this.mitigation = theMitigation;
        return this;
    }

    public boolean hasMitigation() {
        if (this.mitigation == null) {
            return false;
        }
        for (DetectedIssueMitigationComponent item : this.mitigation) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DetectedIssueMitigationComponent addMitigation() {
        DetectedIssueMitigationComponent t = new DetectedIssueMitigationComponent();
        if (this.mitigation == null) {
            this.mitigation = new ArrayList<DetectedIssueMitigationComponent>();
        }
        this.mitigation.add(t);
        return t;
    }

    public DetectedIssue addMitigation(DetectedIssueMitigationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.mitigation == null) {
            this.mitigation = new ArrayList<DetectedIssueMitigationComponent>();
        }
        this.mitigation.add(t);
        return this;
    }

    public DetectedIssueMitigationComponent getMitigationFirstRep() {
        if (this.getMitigation().isEmpty()) {
            this.addMitigation();
        }
        return this.getMitigation().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifier associated with the detected issue record.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, SP_CODE, "Indicates the status of the detected issue.", 0, 1, this.status));
        children.add(new Property(SP_CATEGORY, "CodeableConcept", "A code that classifies the general type of detected issue.", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property(SP_CODE, "CodeableConcept", "Identifies the specific type of issue identified.", 0, 1, this.code));
        children.add(new Property("severity", SP_CODE, "Indicates the degree of importance associated with the identified issue based on the potential impact on the patient.", 0, 1, this.severity));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group|Device|Location|Organization|Procedure|Practitioner|Medication|Substance|BiologicallyDerivedProduct|NutritionProduct)", "Indicates the subject whose record the detected issue is associated with.", 0, 1, this.subject));
        children.add(new Property("encounter", "Reference(Encounter)", "The encounter during which this issue was detected.", 0, 1, this.encounter));
        children.add(new Property("identified[x]", "dateTime|Period", "The date or period when the detected issue was initially identified.", 0, 1, this.identified));
        children.add(new Property(SP_AUTHOR, "Reference(Patient|RelatedPerson|Practitioner|PractitionerRole|Device)", "Individual or device responsible for the issue being raised.  For example, a decision support application or a pharmacist conducting a medication review.", 0, 1, this.author));
        children.add(new Property(SP_IMPLICATED, "Reference(Any)", "Indicates the resource representing the current activity or proposed activity that is potentially problematic.", 0, Integer.MAX_VALUE, this.implicated));
        children.add(new Property("evidence", "", "Supporting evidence or manifestations that provide the basis for identifying the detected issue such as a GuidanceResponse or MeasureReport.", 0, Integer.MAX_VALUE, this.evidence));
        children.add(new Property("detail", "markdown", "A textual explanation of the detected issue.", 0, 1, this.detail));
        children.add(new Property("reference", "uri", "The literature, knowledge-base or similar reference that describes the propensity for the detected issue identified.", 0, 1, this.reference));
        children.add(new Property("mitigation", "", "Indicates an action that has been taken or is committed to reduce or eliminate the likelihood of the risk identified by the detected issue from manifesting.  Can also reflect an observation of known mitigating factors that may reduce/eliminate the need for any action.", 0, Integer.MAX_VALUE, this.mitigation));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Business identifier associated with the detected issue record.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "Indicates the status of the detected issue.", 0, 1, this.status);
            }
            case 50511102: {
                return new Property(SP_CATEGORY, "CodeableConcept", "A code that classifies the general type of detected issue.", 0, Integer.MAX_VALUE, this.category);
            }
            case 3059181: {
                return new Property(SP_CODE, "CodeableConcept", "Identifies the specific type of issue identified.", 0, 1, this.code);
            }
            case 1478300413: {
                return new Property("severity", SP_CODE, "Indicates the degree of importance associated with the identified issue based on the potential impact on the patient.", 0, 1, this.severity);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group|Device|Location|Organization|Procedure|Practitioner|Medication|Substance|BiologicallyDerivedProduct|NutritionProduct)", "Indicates the subject whose record the detected issue is associated with.", 0, 1, this.subject);
            }
            case 1524132147: {
                return new Property("encounter", "Reference(Encounter)", "The encounter during which this issue was detected.", 0, 1, this.encounter);
            }
            case 569355781: {
                return new Property("identified[x]", "dateTime|Period", "The date or period when the detected issue was initially identified.", 0, 1, this.identified);
            }
            case -1618432869: {
                return new Property("identified[x]", "dateTime|Period", "The date or period when the detected issue was initially identified.", 0, 1, this.identified);
            }
            case -968788650: {
                return new Property("identified[x]", "dateTime", "The date or period when the detected issue was initially identified.", 0, 1, this.identified);
            }
            case 520482364: {
                return new Property("identified[x]", "Period", "The date or period when the detected issue was initially identified.", 0, 1, this.identified);
            }
            case -1406328437: {
                return new Property(SP_AUTHOR, "Reference(Patient|RelatedPerson|Practitioner|PractitionerRole|Device)", "Individual or device responsible for the issue being raised.  For example, a decision support application or a pharmacist conducting a medication review.", 0, 1, this.author);
            }
            case -810216884: {
                return new Property(SP_IMPLICATED, "Reference(Any)", "Indicates the resource representing the current activity or proposed activity that is potentially problematic.", 0, Integer.MAX_VALUE, this.implicated);
            }
            case 382967383: {
                return new Property("evidence", "", "Supporting evidence or manifestations that provide the basis for identifying the detected issue such as a GuidanceResponse or MeasureReport.", 0, Integer.MAX_VALUE, this.evidence);
            }
            case -1335224239: {
                return new Property("detail", "markdown", "A textual explanation of the detected issue.", 0, 1, this.detail);
            }
            case -925155509: {
                return new Property("reference", "uri", "The literature, knowledge-base or similar reference that describes the propensity for the detected issue identified.", 0, 1, this.reference);
            }
            case 1293793087: {
                return new Property("mitigation", "", "Indicates an action that has been taken or is committed to reduce or eliminate the likelihood of the risk identified by the detected issue from manifesting.  Can also reflect an observation of known mitigating factors that may reduce/eliminate the need for any action.", 0, Integer.MAX_VALUE, this.mitigation);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.code;
                }
                return baseArray;
            }
            case 1478300413: {
                Base[] baseArray;
                if (this.severity == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.severity;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.subject;
                }
                return baseArray;
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.encounter;
                }
                return baseArray;
            }
            case -1618432869: {
                Base[] baseArray;
                if (this.identified == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.identified;
                }
                return baseArray;
            }
            case -1406328437: {
                Base[] baseArray;
                if (this.author == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.author;
                }
                return baseArray;
            }
            case -810216884: {
                return this.implicated == null ? new Base[]{} : this.implicated.toArray(new Base[this.implicated.size()]);
            }
            case 382967383: {
                return this.evidence == null ? new Base[]{} : this.evidence.toArray(new Base[this.evidence.size()]);
            }
            case -1335224239: {
                Base[] baseArray;
                if (this.detail == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.detail;
                }
                return baseArray;
            }
            case -925155509: {
                Base[] baseArray;
                if (this.reference == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.reference;
                }
                return baseArray;
            }
            case 1293793087: {
                return this.mitigation == null ? new Base[]{} : this.mitigation.toArray(new Base[this.mitigation.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new DetectedIssueStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 50511102: {
                this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 3059181: {
                this.code = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 1478300413: {
                value = new DetectedIssueSeverityEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.severity = value;
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case 1524132147: {
                this.encounter = TypeConvertor.castToReference(value);
                return value;
            }
            case -1618432869: {
                this.identified = TypeConvertor.castToType(value);
                return value;
            }
            case -1406328437: {
                this.author = TypeConvertor.castToReference(value);
                return value;
            }
            case -810216884: {
                this.getImplicated().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 382967383: {
                this.getEvidence().add((DetectedIssueEvidenceComponent)((Object)value));
                return value;
            }
            case -1335224239: {
                this.detail = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -925155509: {
                this.reference = TypeConvertor.castToUri(value);
                return value;
            }
            case 1293793087: {
                this.getMitigation().add((DetectedIssueMitigationComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new DetectedIssueStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_CATEGORY)) {
            this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_CODE)) {
            this.code = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("severity")) {
            value = new DetectedIssueSeverityEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.severity = value;
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals("encounter")) {
            this.encounter = TypeConvertor.castToReference(value);
        } else if (name.equals("identified[x]")) {
            this.identified = TypeConvertor.castToType(value);
        } else if (name.equals(SP_AUTHOR)) {
            this.author = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_IMPLICATED)) {
            this.getImplicated().add(TypeConvertor.castToReference(value));
        } else if (name.equals("evidence")) {
            this.getEvidence().add((DetectedIssueEvidenceComponent)((Object)value));
        } else if (name.equals("detail")) {
            this.detail = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("reference")) {
            this.reference = TypeConvertor.castToUri(value);
        } else if (name.equals("mitigation")) {
            this.getMitigation().add((DetectedIssueMitigationComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 50511102: {
                return this.addCategory();
            }
            case 3059181: {
                return this.getCode();
            }
            case 1478300413: {
                return this.getSeverityElement();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case 569355781: {
                return this.getIdentified();
            }
            case -1618432869: {
                return this.getIdentified();
            }
            case -1406328437: {
                return this.getAuthor();
            }
            case -810216884: {
                return this.addImplicated();
            }
            case 382967383: {
                return this.addEvidence();
            }
            case -1335224239: {
                return this.getDetailElement();
            }
            case -925155509: {
                return this.getReferenceElement();
            }
            case 1293793087: {
                return this.addMitigation();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case 1478300413: {
                return new String[]{SP_CODE};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 1524132147: {
                return new String[]{"Reference"};
            }
            case -1618432869: {
                return new String[]{"dateTime", "Period"};
            }
            case -1406328437: {
                return new String[]{"Reference"};
            }
            case -810216884: {
                return new String[]{"Reference"};
            }
            case 382967383: {
                return new String[0];
            }
            case -1335224239: {
                return new String[]{"markdown"};
            }
            case -925155509: {
                return new String[]{"uri"};
            }
            case 1293793087: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type DetectedIssue.status");
        }
        if (name.equals(SP_CATEGORY)) {
            return this.addCategory();
        }
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals("severity")) {
            throw new FHIRException("Cannot call addChild on a primitive type DetectedIssue.severity");
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals("encounter")) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals("identifiedDateTime")) {
            this.identified = new DateTimeType();
            return this.identified;
        }
        if (name.equals("identifiedPeriod")) {
            this.identified = new Period();
            return this.identified;
        }
        if (name.equals(SP_AUTHOR)) {
            this.author = new Reference();
            return this.author;
        }
        if (name.equals(SP_IMPLICATED)) {
            return this.addImplicated();
        }
        if (name.equals("evidence")) {
            return this.addEvidence();
        }
        if (name.equals("detail")) {
            throw new FHIRException("Cannot call addChild on a primitive type DetectedIssue.detail");
        }
        if (name.equals("reference")) {
            throw new FHIRException("Cannot call addChild on a primitive type DetectedIssue.reference");
        }
        if (name.equals("mitigation")) {
            return this.addMitigation();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DetectedIssue";
    }

    @Override
    public DetectedIssue copy() {
        DetectedIssue dst = new DetectedIssue();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(DetectedIssue dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        Enumeration<DetectedIssueStatus> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.category) {
                dst.category.add(codeableConcept.copy());
            }
        }
        dst.code = this.code == null ? null : this.code.copy();
        dst.severity = this.severity == null ? null : this.severity.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        dst.identified = this.identified == null ? null : this.identified.copy();
        Reference reference = dst.author = this.author == null ? null : this.author.copy();
        if (this.implicated != null) {
            dst.implicated = new ArrayList<Reference>();
            for (Reference reference2 : this.implicated) {
                dst.implicated.add(reference2.copy());
            }
        }
        if (this.evidence != null) {
            dst.evidence = new ArrayList<DetectedIssueEvidenceComponent>();
            for (DetectedIssueEvidenceComponent detectedIssueEvidenceComponent : this.evidence) {
                dst.evidence.add(detectedIssueEvidenceComponent.copy());
            }
        }
        dst.detail = this.detail == null ? null : this.detail.copy();
        UriType uriType = dst.reference = this.reference == null ? null : this.reference.copy();
        if (this.mitigation != null) {
            dst.mitigation = new ArrayList<DetectedIssueMitigationComponent>();
            for (DetectedIssueMitigationComponent detectedIssueMitigationComponent : this.mitigation) {
                dst.mitigation.add(detectedIssueMitigationComponent.copy());
            }
        }
    }

    protected DetectedIssue typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof DetectedIssue)) {
            return false;
        }
        DetectedIssue o = (DetectedIssue)other_;
        return DetectedIssue.compareDeep(this.identifier, o.identifier, true) && DetectedIssue.compareDeep(this.status, o.status, true) && DetectedIssue.compareDeep(this.category, o.category, true) && DetectedIssue.compareDeep(this.code, o.code, true) && DetectedIssue.compareDeep(this.severity, o.severity, true) && DetectedIssue.compareDeep(this.subject, o.subject, true) && DetectedIssue.compareDeep(this.encounter, o.encounter, true) && DetectedIssue.compareDeep(this.identified, o.identified, true) && DetectedIssue.compareDeep(this.author, o.author, true) && DetectedIssue.compareDeep(this.implicated, o.implicated, true) && DetectedIssue.compareDeep(this.evidence, o.evidence, true) && DetectedIssue.compareDeep(this.detail, o.detail, true) && DetectedIssue.compareDeep(this.reference, o.reference, true) && DetectedIssue.compareDeep(this.mitigation, o.mitigation, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof DetectedIssue)) {
            return false;
        }
        DetectedIssue o = (DetectedIssue)other_;
        return DetectedIssue.compareValues(this.status, o.status, true) && DetectedIssue.compareValues(this.severity, o.severity, true) && DetectedIssue.compareValues(this.detail, o.detail, true) && DetectedIssue.compareValues(this.reference, o.reference, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.category, this.code, this.severity, this.subject, this.encounter, this.identified, this.author, this.implicated, this.evidence, this.detail, this.reference, this.mitigation});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.DetectedIssue;
    }

    @Block
    public static class DetectedIssueMitigationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="action", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What mitigation?", formalDefinition="Describes the action that was taken or the observation that was made that reduces/eliminates the risk associated with the identified issue.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/detectedissue-mitigation-action")
        protected CodeableConcept action;
        @Child(name="date", type={DateTimeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Date committed", formalDefinition="Indicates when the mitigating action was documented.")
        protected DateTimeType date;
        @Child(name="author", type={Practitioner.class, PractitionerRole.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Who is committing?", formalDefinition="Identifies the practitioner who determined the mitigation and takes responsibility for the mitigation step occurring.")
        protected Reference author;
        @Child(name="note", type={Annotation.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Additional notes about the mitigation", formalDefinition="Clinicians may add additional notes or justifications about the mitigation action. For example, patient can have this drug because they have had it before without any issues. Multiple justifications may be provided.")
        protected List<Annotation> note;
        private static final long serialVersionUID = 1504361133L;

        public DetectedIssueMitigationComponent() {
        }

        public DetectedIssueMitigationComponent(CodeableConcept action) {
            this.setAction(action);
        }

        public CodeableConcept getAction() {
            if (this.action == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetectedIssueMitigationComponent.action");
                }
                if (Configuration.doAutoCreate()) {
                    this.action = new CodeableConcept();
                }
            }
            return this.action;
        }

        public boolean hasAction() {
            return this.action != null && !this.action.isEmpty();
        }

        public DetectedIssueMitigationComponent setAction(CodeableConcept value) {
            this.action = value;
            return this;
        }

        public DateTimeType getDateElement() {
            if (this.date == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetectedIssueMitigationComponent.date");
                }
                if (Configuration.doAutoCreate()) {
                    this.date = new DateTimeType();
                }
            }
            return this.date;
        }

        public boolean hasDateElement() {
            return this.date != null && !this.date.isEmpty();
        }

        public boolean hasDate() {
            return this.date != null && !this.date.isEmpty();
        }

        public DetectedIssueMitigationComponent setDateElement(DateTimeType value) {
            this.date = value;
            return this;
        }

        public Date getDate() {
            return this.date == null ? null : (Date)this.date.getValue();
        }

        public DetectedIssueMitigationComponent setDate(Date value) {
            if (value == null) {
                this.date = null;
            } else {
                if (this.date == null) {
                    this.date = new DateTimeType();
                }
                this.date.setValue(value);
            }
            return this;
        }

        public Reference getAuthor() {
            if (this.author == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetectedIssueMitigationComponent.author");
                }
                if (Configuration.doAutoCreate()) {
                    this.author = new Reference();
                }
            }
            return this.author;
        }

        public boolean hasAuthor() {
            return this.author != null && !this.author.isEmpty();
        }

        public DetectedIssueMitigationComponent setAuthor(Reference value) {
            this.author = value;
            return this;
        }

        public List<Annotation> getNote() {
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            return this.note;
        }

        public DetectedIssueMitigationComponent setNote(List<Annotation> theNote) {
            this.note = theNote;
            return this;
        }

        public boolean hasNote() {
            if (this.note == null) {
                return false;
            }
            for (Annotation item : this.note) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Annotation addNote() {
            Annotation t = new Annotation();
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return t;
        }

        public DetectedIssueMitigationComponent addNote(Annotation t) {
            if (t == null) {
                return this;
            }
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return this;
        }

        public Annotation getNoteFirstRep() {
            if (this.getNote().isEmpty()) {
                this.addNote();
            }
            return this.getNote().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("action", "CodeableConcept", "Describes the action that was taken or the observation that was made that reduces/eliminates the risk associated with the identified issue.", 0, 1, this.action));
            children.add(new Property("date", "dateTime", "Indicates when the mitigating action was documented.", 0, 1, this.date));
            children.add(new Property(DetectedIssue.SP_AUTHOR, "Reference(Practitioner|PractitionerRole)", "Identifies the practitioner who determined the mitigation and takes responsibility for the mitigation step occurring.", 0, 1, this.author));
            children.add(new Property("note", "Annotation", "Clinicians may add additional notes or justifications about the mitigation action. For example, patient can have this drug because they have had it before without any issues. Multiple justifications may be provided.", 0, Integer.MAX_VALUE, this.note));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1422950858: {
                    return new Property("action", "CodeableConcept", "Describes the action that was taken or the observation that was made that reduces/eliminates the risk associated with the identified issue.", 0, 1, this.action);
                }
                case 3076014: {
                    return new Property("date", "dateTime", "Indicates when the mitigating action was documented.", 0, 1, this.date);
                }
                case -1406328437: {
                    return new Property(DetectedIssue.SP_AUTHOR, "Reference(Practitioner|PractitionerRole)", "Identifies the practitioner who determined the mitigation and takes responsibility for the mitigation step occurring.", 0, 1, this.author);
                }
                case 3387378: {
                    return new Property("note", "Annotation", "Clinicians may add additional notes or justifications about the mitigation action. For example, patient can have this drug because they have had it before without any issues. Multiple justifications may be provided.", 0, Integer.MAX_VALUE, this.note);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1422950858: {
                    Base[] baseArray;
                    if (this.action == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.action;
                    }
                    return baseArray;
                }
                case 3076014: {
                    Base[] baseArray;
                    if (this.date == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.date;
                    }
                    return baseArray;
                }
                case -1406328437: {
                    Base[] baseArray;
                    if (this.author == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.author;
                    }
                    return baseArray;
                }
                case 3387378: {
                    return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1422950858: {
                    this.action = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 3076014: {
                    this.date = TypeConvertor.castToDateTime(value);
                    return value;
                }
                case -1406328437: {
                    this.author = TypeConvertor.castToReference(value);
                    return value;
                }
                case 3387378: {
                    this.getNote().add(TypeConvertor.castToAnnotation(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("action")) {
                this.action = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("date")) {
                this.date = TypeConvertor.castToDateTime(value);
            } else if (name.equals(DetectedIssue.SP_AUTHOR)) {
                this.author = TypeConvertor.castToReference(value);
            } else if (name.equals("note")) {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1422950858: {
                    return this.getAction();
                }
                case 3076014: {
                    return this.getDateElement();
                }
                case -1406328437: {
                    return this.getAuthor();
                }
                case 3387378: {
                    return this.addNote();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1422950858: {
                    return new String[]{"CodeableConcept"};
                }
                case 3076014: {
                    return new String[]{"dateTime"};
                }
                case -1406328437: {
                    return new String[]{"Reference"};
                }
                case 3387378: {
                    return new String[]{"Annotation"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("action")) {
                this.action = new CodeableConcept();
                return this.action;
            }
            if (name.equals("date")) {
                throw new FHIRException("Cannot call addChild on a primitive type DetectedIssue.mitigation.date");
            }
            if (name.equals(DetectedIssue.SP_AUTHOR)) {
                this.author = new Reference();
                return this.author;
            }
            if (name.equals("note")) {
                return this.addNote();
            }
            return super.addChild(name);
        }

        @Override
        public DetectedIssueMitigationComponent copy() {
            DetectedIssueMitigationComponent dst = new DetectedIssueMitigationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DetectedIssueMitigationComponent dst) {
            super.copyValues(dst);
            dst.action = this.action == null ? null : this.action.copy();
            dst.date = this.date == null ? null : this.date.copy();
            Reference reference = dst.author = this.author == null ? null : this.author.copy();
            if (this.note != null) {
                dst.note = new ArrayList<Annotation>();
                for (Annotation i : this.note) {
                    dst.note.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DetectedIssueMitigationComponent)) {
                return false;
            }
            DetectedIssueMitigationComponent o = (DetectedIssueMitigationComponent)other_;
            return DetectedIssueMitigationComponent.compareDeep(this.action, o.action, true) && DetectedIssueMitigationComponent.compareDeep(this.date, o.date, true) && DetectedIssueMitigationComponent.compareDeep(this.author, o.author, true) && DetectedIssueMitigationComponent.compareDeep(this.note, o.note, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DetectedIssueMitigationComponent)) {
                return false;
            }
            DetectedIssueMitigationComponent o = (DetectedIssueMitigationComponent)other_;
            return DetectedIssueMitigationComponent.compareValues(this.date, o.date, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.action, this.date, this.author, this.note});
        }

        @Override
        public String fhirType() {
            return "DetectedIssue.mitigation";
        }
    }

    @Block
    public static class DetectedIssueEvidenceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Manifestation", formalDefinition="A manifestation that led to the recording of this detected issue.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/manifestation-or-symptom")
        protected List<CodeableConcept> code;
        @Child(name="detail", type={Reference.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Supporting information", formalDefinition="Links to resources that constitute evidence for the detected issue such as a GuidanceResponse or MeasureReport.")
        protected List<Reference> detail;
        private static final long serialVersionUID = -672691342L;

        public List<CodeableConcept> getCode() {
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            return this.code;
        }

        public DetectedIssueEvidenceComponent setCode(List<CodeableConcept> theCode) {
            this.code = theCode;
            return this;
        }

        public boolean hasCode() {
            if (this.code == null) {
                return false;
            }
            for (CodeableConcept item : this.code) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addCode() {
            CodeableConcept t = new CodeableConcept();
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            this.code.add(t);
            return t;
        }

        public DetectedIssueEvidenceComponent addCode(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            this.code.add(t);
            return this;
        }

        public CodeableConcept getCodeFirstRep() {
            if (this.getCode().isEmpty()) {
                this.addCode();
            }
            return this.getCode().get(0);
        }

        public List<Reference> getDetail() {
            if (this.detail == null) {
                this.detail = new ArrayList<Reference>();
            }
            return this.detail;
        }

        public DetectedIssueEvidenceComponent setDetail(List<Reference> theDetail) {
            this.detail = theDetail;
            return this;
        }

        public boolean hasDetail() {
            if (this.detail == null) {
                return false;
            }
            for (Reference item : this.detail) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addDetail() {
            Reference t = new Reference();
            if (this.detail == null) {
                this.detail = new ArrayList<Reference>();
            }
            this.detail.add(t);
            return t;
        }

        public DetectedIssueEvidenceComponent addDetail(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.detail == null) {
                this.detail = new ArrayList<Reference>();
            }
            this.detail.add(t);
            return this;
        }

        public Reference getDetailFirstRep() {
            if (this.getDetail().isEmpty()) {
                this.addDetail();
            }
            return this.getDetail().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(DetectedIssue.SP_CODE, "CodeableConcept", "A manifestation that led to the recording of this detected issue.", 0, Integer.MAX_VALUE, this.code));
            children.add(new Property("detail", "Reference(Any)", "Links to resources that constitute evidence for the detected issue such as a GuidanceResponse or MeasureReport.", 0, Integer.MAX_VALUE, this.detail));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property(DetectedIssue.SP_CODE, "CodeableConcept", "A manifestation that led to the recording of this detected issue.", 0, Integer.MAX_VALUE, this.code);
                }
                case -1335224239: {
                    return new Property("detail", "Reference(Any)", "Links to resources that constitute evidence for the detected issue such as a GuidanceResponse or MeasureReport.", 0, Integer.MAX_VALUE, this.detail);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.code == null ? new Base[]{} : this.code.toArray(new Base[this.code.size()]);
                }
                case -1335224239: {
                    return this.detail == null ? new Base[]{} : this.detail.toArray(new Base[this.detail.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.getCode().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -1335224239: {
                    this.getDetail().add(TypeConvertor.castToReference(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(DetectedIssue.SP_CODE)) {
                this.getCode().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("detail")) {
                this.getDetail().add(TypeConvertor.castToReference(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.addCode();
                }
                case -1335224239: {
                    return this.addDetail();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case -1335224239: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(DetectedIssue.SP_CODE)) {
                return this.addCode();
            }
            if (name.equals("detail")) {
                return this.addDetail();
            }
            return super.addChild(name);
        }

        @Override
        public DetectedIssueEvidenceComponent copy() {
            DetectedIssueEvidenceComponent dst = new DetectedIssueEvidenceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DetectedIssueEvidenceComponent dst) {
            super.copyValues(dst);
            if (this.code != null) {
                dst.code = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.code) {
                    dst.code.add(codeableConcept.copy());
                }
            }
            if (this.detail != null) {
                dst.detail = new ArrayList<Reference>();
                for (Reference reference : this.detail) {
                    dst.detail.add(reference.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DetectedIssueEvidenceComponent)) {
                return false;
            }
            DetectedIssueEvidenceComponent o = (DetectedIssueEvidenceComponent)other_;
            return DetectedIssueEvidenceComponent.compareDeep(this.code, o.code, true) && DetectedIssueEvidenceComponent.compareDeep(this.detail, o.detail, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DetectedIssueEvidenceComponent)) {
                return false;
            }
            DetectedIssueEvidenceComponent o = (DetectedIssueEvidenceComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.detail});
        }

        @Override
        public String fhirType() {
            return "DetectedIssue.evidence";
        }
    }

    public static class DetectedIssueStatusEnumFactory
    implements EnumFactory<DetectedIssueStatus> {
        @Override
        public DetectedIssueStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("preliminary".equals(codeString)) {
                return DetectedIssueStatus.PRELIMINARY;
            }
            if ("final".equals(codeString)) {
                return DetectedIssueStatus.FINAL;
            }
            if ("entered-in-error".equals(codeString)) {
                return DetectedIssueStatus.ENTEREDINERROR;
            }
            if ("mitigated".equals(codeString)) {
                return DetectedIssueStatus.MITIGATED;
            }
            throw new IllegalArgumentException("Unknown DetectedIssueStatus code '" + codeString + "'");
        }

        public Enumeration<DetectedIssueStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<DetectedIssueStatus>(this, DetectedIssueStatus.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<DetectedIssueStatus>(this, DetectedIssueStatus.NULL, code);
            }
            if ("preliminary".equals(codeString)) {
                return new Enumeration<DetectedIssueStatus>(this, DetectedIssueStatus.PRELIMINARY, code);
            }
            if ("final".equals(codeString)) {
                return new Enumeration<DetectedIssueStatus>(this, DetectedIssueStatus.FINAL, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<DetectedIssueStatus>(this, DetectedIssueStatus.ENTEREDINERROR, code);
            }
            if ("mitigated".equals(codeString)) {
                return new Enumeration<DetectedIssueStatus>(this, DetectedIssueStatus.MITIGATED, code);
            }
            throw new FHIRException("Unknown DetectedIssueStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(DetectedIssueStatus code) {
            if (code == DetectedIssueStatus.PRELIMINARY) {
                return "preliminary";
            }
            if (code == DetectedIssueStatus.FINAL) {
                return "final";
            }
            if (code == DetectedIssueStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == DetectedIssueStatus.MITIGATED) {
                return "mitigated";
            }
            return "?";
        }

        @Override
        public String toSystem(DetectedIssueStatus code) {
            return code.getSystem();
        }
    }

    public static enum DetectedIssueStatus {
        PRELIMINARY,
        FINAL,
        ENTEREDINERROR,
        MITIGATED,
        NULL;


        public static DetectedIssueStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("preliminary".equals(codeString)) {
                return PRELIMINARY;
            }
            if ("final".equals(codeString)) {
                return FINAL;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("mitigated".equals(codeString)) {
                return MITIGATED;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown DetectedIssueStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PRELIMINARY: {
                    return "preliminary";
                }
                case FINAL: {
                    return "final";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case MITIGATED: {
                    return "mitigated";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PRELIMINARY: {
                    return "http://hl7.org/fhir/observation-status";
                }
                case FINAL: {
                    return "http://hl7.org/fhir/observation-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/observation-status";
                }
                case MITIGATED: {
                    return "http://hl7.org/fhir/detectedissue-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PRELIMINARY: {
                    return "This is an initial or interim observation: data may be incomplete or unverified.";
                }
                case FINAL: {
                    return "The observation is complete and there are no further actions needed. Additional information such \"released\", \"signed\", etc. would be represented using [Provenance](provenance.html) which provides not only the act but also the actors and dates and other related data. These act states would be associated with an observation status of `preliminary` until they are all completed and then a status of `final` would be applied.";
                }
                case ENTEREDINERROR: {
                    return "The observation has been withdrawn following previous final release.  This electronic record should never have existed, though it is possible that real-world decisions were based on it. (If real-world activity has occurred, the status should be \"cancelled\" rather than \"entered-in-error\".).";
                }
                case MITIGATED: {
                    return "Indicates the detected issue has been mitigated";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PRELIMINARY: {
                    return "Preliminary";
                }
                case FINAL: {
                    return "Final";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case MITIGATED: {
                    return "Mitigated";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class DetectedIssueSeverityEnumFactory
    implements EnumFactory<DetectedIssueSeverity> {
        @Override
        public DetectedIssueSeverity fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("high".equals(codeString)) {
                return DetectedIssueSeverity.HIGH;
            }
            if ("moderate".equals(codeString)) {
                return DetectedIssueSeverity.MODERATE;
            }
            if ("low".equals(codeString)) {
                return DetectedIssueSeverity.LOW;
            }
            throw new IllegalArgumentException("Unknown DetectedIssueSeverity code '" + codeString + "'");
        }

        public Enumeration<DetectedIssueSeverity> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<DetectedIssueSeverity>(this, DetectedIssueSeverity.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<DetectedIssueSeverity>(this, DetectedIssueSeverity.NULL, code);
            }
            if ("high".equals(codeString)) {
                return new Enumeration<DetectedIssueSeverity>(this, DetectedIssueSeverity.HIGH, code);
            }
            if ("moderate".equals(codeString)) {
                return new Enumeration<DetectedIssueSeverity>(this, DetectedIssueSeverity.MODERATE, code);
            }
            if ("low".equals(codeString)) {
                return new Enumeration<DetectedIssueSeverity>(this, DetectedIssueSeverity.LOW, code);
            }
            throw new FHIRException("Unknown DetectedIssueSeverity code '" + codeString + "'");
        }

        @Override
        public String toCode(DetectedIssueSeverity code) {
            if (code == DetectedIssueSeverity.HIGH) {
                return "high";
            }
            if (code == DetectedIssueSeverity.MODERATE) {
                return "moderate";
            }
            if (code == DetectedIssueSeverity.LOW) {
                return "low";
            }
            return "?";
        }

        @Override
        public String toSystem(DetectedIssueSeverity code) {
            return code.getSystem();
        }
    }

    public static enum DetectedIssueSeverity {
        HIGH,
        MODERATE,
        LOW,
        NULL;


        public static DetectedIssueSeverity fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("high".equals(codeString)) {
                return HIGH;
            }
            if ("moderate".equals(codeString)) {
                return MODERATE;
            }
            if ("low".equals(codeString)) {
                return LOW;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown DetectedIssueSeverity code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case HIGH: {
                    return "high";
                }
                case MODERATE: {
                    return "moderate";
                }
                case LOW: {
                    return "low";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case HIGH: {
                    return "http://hl7.org/fhir/detectedissue-severity";
                }
                case MODERATE: {
                    return "http://hl7.org/fhir/detectedissue-severity";
                }
                case LOW: {
                    return "http://hl7.org/fhir/detectedissue-severity";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case HIGH: {
                    return "Indicates the issue may be life-threatening or has the potential to cause permanent injury.";
                }
                case MODERATE: {
                    return "Indicates the issue may result in noticeable adverse consequences but is unlikely to be life-threatening or cause permanent injury.";
                }
                case LOW: {
                    return "Indicates the issue may result in some adverse consequences but is unlikely to substantially affect the situation of the subject.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case HIGH: {
                    return "High";
                }
                case MODERATE: {
                    return "Moderate";
                }
                case LOW: {
                    return "Low";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

