/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Duration;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.TypeConvertor;

@ResourceDef(name="EncounterHistory", profile="http://hl7.org/fhir/StructureDefinition/EncounterHistory")
public class EncounterHistory
extends DomainResource {
    @Child(name="encounter", type={Encounter.class}, order=0, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The Encounter associated with this set of historic values", formalDefinition="The Encounter associated with this set of historic values.")
    protected Reference encounter;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Identifier(s) by which this encounter is known", formalDefinition="Identifier(s) by which this encounter is known.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=2, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="planned | in-progress | on-hold | discharged | completed | cancelled | discontinued | entered-in-error | unknown", formalDefinition="planned | in-progress | on-hold | discharged | completed | cancelled | discontinued | entered-in-error | unknown.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-status")
    protected Enumeration<Enumerations.EncounterStatus> status;
    @Child(name="class", type={CodeableConcept.class}, order=3, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Classification of patient encounter", formalDefinition="Concepts representing classification of patient encounter such as ambulatory (outpatient), inpatient, emergency, home health or others due to local variations.")
    @Binding(valueSet="http://terminology.hl7.org/ValueSet/v3-ActEncounterCode")
    protected CodeableConcept class_;
    @Child(name="type", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Specific type of encounter", formalDefinition="Specific type of encounter (e.g. e-mail consultation, surgical day-care, skilled nursing, rehabilitation).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-type")
    protected List<CodeableConcept> type;
    @Child(name="serviceType", type={CodeableReference.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Specific type of service", formalDefinition="Broad categorization of the service that is to be provided (e.g. cardiology).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-type")
    protected List<CodeableReference> serviceType;
    @Child(name="subject", type={Patient.class, Group.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The patient or group related to this encounter", formalDefinition="The patient or group related to this encounter. In some use-cases the patient MAY not be present, such as a case meeting about a patient between several practitioners or a careteam.")
    protected Reference subject;
    @Child(name="subjectStatus", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The current status of the subject in relation to the Encounter", formalDefinition="The subjectStatus value can be used to track the patient's status within the encounter. It details whether the patient has arrived or departed, has been triaged or is currently in a waiting status.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-subject-status")
    protected CodeableConcept subjectStatus;
    @Child(name="actualPeriod", type={Period.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The actual start and end time associated with this set of values associated with the encounter", formalDefinition="The start and end time associated with this set of values associated with the encounter, may be different to the planned times for various reasons.")
    protected Period actualPeriod;
    @Child(name="plannedStartDate", type={DateTimeType.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The planned start date/time (or admission date) of the encounter", formalDefinition="The planned start date/time (or admission date) of the encounter.")
    protected DateTimeType plannedStartDate;
    @Child(name="plannedEndDate", type={DateTimeType.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The planned end date/time (or discharge date) of the encounter", formalDefinition="The planned end date/time (or discharge date) of the encounter.")
    protected DateTimeType plannedEndDate;
    @Child(name="length", type={Duration.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Actual quantity of time the encounter lasted (less time absent)", formalDefinition="Actual quantity of time the encounter lasted. This excludes the time during leaves of absence.\r\rWhen missing it is the time in between the start and end values.")
    protected Duration length;
    @Child(name="location", type={}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Location of the patient at this point in the encounter", formalDefinition="The location of the patient at this point in the encounter, the multiple cardinality permits de-normalizing the levels of the location hierarchy, such as site/ward/room/bed.")
    protected List<EncounterHistoryLocationComponent> location;
    private static final long serialVersionUID = 775989939L;
    @SearchParamDefinition(name="identifier", path="EncounterHistory.identifier", description="Identifier(s) by which this encounter is known", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="EncounterHistory.subject.where(resolve() is Patient)", description="The patient present at the encounter", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("EncounterHistory:patient").toLocked();
    @SearchParamDefinition(name="status", path="EncounterHistory.status", description="Status of the Encounter history entry", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject", path="EncounterHistory.subject", description="The patient or group present at the encounter", type="reference", target={Group.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("EncounterHistory:subject").toLocked();
    @SearchParamDefinition(name="encounter", path="AuditEvent.encounter | CarePlan.encounter | ChargeItem.encounter | Claim.item.encounter | ClinicalImpression.encounter | Communication.encounter | CommunicationRequest.encounter | Composition.encounter | Condition.encounter | DeviceRequest.encounter | DiagnosticReport.encounter | EncounterHistory.encounter | ExplanationOfBenefit.item.encounter | Flag.encounter | ImagingStudy.encounter | List.encounter | MedicationDispense.encounter | MedicationStatement.encounter | NutritionIntake.encounter | NutritionOrder.encounter | Observation.encounter | Procedure.encounter | Provenance.encounter | QuestionnaireResponse.encounter | RequestOrchestration.encounter | RiskAssessment.encounter | ServiceRequest.encounter | Task.encounter | VisionPrescription.encounter", description="Multiple Resources: \r\n\r\n* [AuditEvent](auditevent.html): Encounter related to the activity recorded in the AuditEvent\r\n* [CarePlan](careplan.html): The Encounter during which this CarePlan was created\r\n* [ChargeItem](chargeitem.html): Encounter associated with event\r\n* [Claim](claim.html): Encounters associated with a billed line item\r\n* [ClinicalImpression](clinicalimpression.html): The Encounter during which this ClinicalImpression was created\r\n* [Communication](communication.html): The Encounter during which this Communication was created\r\n* [CommunicationRequest](communicationrequest.html): The Encounter during which this CommunicationRequest was created\r\n* [Composition](composition.html): Context of the Composition\r\n* [Condition](condition.html): The Encounter during which this Condition was created\r\n* [DeviceRequest](devicerequest.html): Encounter during which request was created\r\n* [DiagnosticReport](diagnosticreport.html): The Encounter when the order was made\r\n* [EncounterHistory](encounterhistory.html): The Encounter associated with this set of history values\r\n* [ExplanationOfBenefit](explanationofbenefit.html): Encounters associated with a billed line item\r\n* [Flag](flag.html): Alert relevant during encounter\r\n* [ImagingStudy](imagingstudy.html): The context of the study\r\n* [List](list.html): Context in which list created\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with a specific encounter\r\n* [MedicationStatement](medicationstatement.html): Returns statements for a specific encounter\r\n* [NutritionIntake](nutritionintake.html): Returns statements for a specific encounter\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this encounter identifier\r\n* [Observation](observation.html): Encounter related to the observation\r\n* [Procedure](procedure.html): The Encounter during which this Procedure was created\r\n* [Provenance](provenance.html): Encounter related to the Provenance\r\n* [QuestionnaireResponse](questionnaireresponse.html): Encounter associated with the questionnaire response\r\n* [RequestOrchestration](requestorchestration.html): The encounter the request orchestration applies to\r\n* [RiskAssessment](riskassessment.html): Where was assessment performed?\r\n* [ServiceRequest](servicerequest.html): An encounter in which this request is made\r\n* [Task](task.html): Search by encounter\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this encounter identifier\r\n", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Encounter")}, target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("EncounterHistory:encounter").toLocked();

    public EncounterHistory() {
    }

    public EncounterHistory(Enumerations.EncounterStatus status, CodeableConcept class_) {
        this.setStatus(status);
        this.setClass_(class_);
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EncounterHistory.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public EncounterHistory setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public EncounterHistory setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public EncounterHistory addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<Enumerations.EncounterStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EncounterHistory.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.EncounterStatus>(new Enumerations.EncounterStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public EncounterHistory setStatusElement(Enumeration<Enumerations.EncounterStatus> value) {
        this.status = value;
        return this;
    }

    public Enumerations.EncounterStatus getStatus() {
        return this.status == null ? null : (Enumerations.EncounterStatus)((Object)this.status.getValue());
    }

    public EncounterHistory setStatus(Enumerations.EncounterStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.EncounterStatus>(new Enumerations.EncounterStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public CodeableConcept getClass_() {
        if (this.class_ == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EncounterHistory.class_");
            }
            if (Configuration.doAutoCreate()) {
                this.class_ = new CodeableConcept();
            }
        }
        return this.class_;
    }

    public boolean hasClass_() {
        return this.class_ != null && !this.class_.isEmpty();
    }

    public EncounterHistory setClass_(CodeableConcept value) {
        this.class_ = value;
        return this;
    }

    public List<CodeableConcept> getType() {
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        return this.type;
    }

    public EncounterHistory setType(List<CodeableConcept> theType) {
        this.type = theType;
        return this;
    }

    public boolean hasType() {
        if (this.type == null) {
            return false;
        }
        for (CodeableConcept item : this.type) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addType() {
        CodeableConcept t = new CodeableConcept();
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        this.type.add(t);
        return t;
    }

    public EncounterHistory addType(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        this.type.add(t);
        return this;
    }

    public CodeableConcept getTypeFirstRep() {
        if (this.getType().isEmpty()) {
            this.addType();
        }
        return this.getType().get(0);
    }

    public List<CodeableReference> getServiceType() {
        if (this.serviceType == null) {
            this.serviceType = new ArrayList<CodeableReference>();
        }
        return this.serviceType;
    }

    public EncounterHistory setServiceType(List<CodeableReference> theServiceType) {
        this.serviceType = theServiceType;
        return this;
    }

    public boolean hasServiceType() {
        if (this.serviceType == null) {
            return false;
        }
        for (CodeableReference item : this.serviceType) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableReference addServiceType() {
        CodeableReference t = new CodeableReference();
        if (this.serviceType == null) {
            this.serviceType = new ArrayList<CodeableReference>();
        }
        this.serviceType.add(t);
        return t;
    }

    public EncounterHistory addServiceType(CodeableReference t) {
        if (t == null) {
            return this;
        }
        if (this.serviceType == null) {
            this.serviceType = new ArrayList<CodeableReference>();
        }
        this.serviceType.add(t);
        return this;
    }

    public CodeableReference getServiceTypeFirstRep() {
        if (this.getServiceType().isEmpty()) {
            this.addServiceType();
        }
        return this.getServiceType().get(0);
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EncounterHistory.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public EncounterHistory setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public CodeableConcept getSubjectStatus() {
        if (this.subjectStatus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EncounterHistory.subjectStatus");
            }
            if (Configuration.doAutoCreate()) {
                this.subjectStatus = new CodeableConcept();
            }
        }
        return this.subjectStatus;
    }

    public boolean hasSubjectStatus() {
        return this.subjectStatus != null && !this.subjectStatus.isEmpty();
    }

    public EncounterHistory setSubjectStatus(CodeableConcept value) {
        this.subjectStatus = value;
        return this;
    }

    public Period getActualPeriod() {
        if (this.actualPeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EncounterHistory.actualPeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.actualPeriod = new Period();
            }
        }
        return this.actualPeriod;
    }

    public boolean hasActualPeriod() {
        return this.actualPeriod != null && !this.actualPeriod.isEmpty();
    }

    public EncounterHistory setActualPeriod(Period value) {
        this.actualPeriod = value;
        return this;
    }

    public DateTimeType getPlannedStartDateElement() {
        if (this.plannedStartDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EncounterHistory.plannedStartDate");
            }
            if (Configuration.doAutoCreate()) {
                this.plannedStartDate = new DateTimeType();
            }
        }
        return this.plannedStartDate;
    }

    public boolean hasPlannedStartDateElement() {
        return this.plannedStartDate != null && !this.plannedStartDate.isEmpty();
    }

    public boolean hasPlannedStartDate() {
        return this.plannedStartDate != null && !this.plannedStartDate.isEmpty();
    }

    public EncounterHistory setPlannedStartDateElement(DateTimeType value) {
        this.plannedStartDate = value;
        return this;
    }

    public Date getPlannedStartDate() {
        return this.plannedStartDate == null ? null : (Date)this.plannedStartDate.getValue();
    }

    public EncounterHistory setPlannedStartDate(Date value) {
        if (value == null) {
            this.plannedStartDate = null;
        } else {
            if (this.plannedStartDate == null) {
                this.plannedStartDate = new DateTimeType();
            }
            this.plannedStartDate.setValue(value);
        }
        return this;
    }

    public DateTimeType getPlannedEndDateElement() {
        if (this.plannedEndDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EncounterHistory.plannedEndDate");
            }
            if (Configuration.doAutoCreate()) {
                this.plannedEndDate = new DateTimeType();
            }
        }
        return this.plannedEndDate;
    }

    public boolean hasPlannedEndDateElement() {
        return this.plannedEndDate != null && !this.plannedEndDate.isEmpty();
    }

    public boolean hasPlannedEndDate() {
        return this.plannedEndDate != null && !this.plannedEndDate.isEmpty();
    }

    public EncounterHistory setPlannedEndDateElement(DateTimeType value) {
        this.plannedEndDate = value;
        return this;
    }

    public Date getPlannedEndDate() {
        return this.plannedEndDate == null ? null : (Date)this.plannedEndDate.getValue();
    }

    public EncounterHistory setPlannedEndDate(Date value) {
        if (value == null) {
            this.plannedEndDate = null;
        } else {
            if (this.plannedEndDate == null) {
                this.plannedEndDate = new DateTimeType();
            }
            this.plannedEndDate.setValue(value);
        }
        return this;
    }

    public Duration getLength() {
        if (this.length == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EncounterHistory.length");
            }
            if (Configuration.doAutoCreate()) {
                this.length = new Duration();
            }
        }
        return this.length;
    }

    public boolean hasLength() {
        return this.length != null && !this.length.isEmpty();
    }

    public EncounterHistory setLength(Duration value) {
        this.length = value;
        return this;
    }

    public List<EncounterHistoryLocationComponent> getLocation() {
        if (this.location == null) {
            this.location = new ArrayList<EncounterHistoryLocationComponent>();
        }
        return this.location;
    }

    public EncounterHistory setLocation(List<EncounterHistoryLocationComponent> theLocation) {
        this.location = theLocation;
        return this;
    }

    public boolean hasLocation() {
        if (this.location == null) {
            return false;
        }
        for (EncounterHistoryLocationComponent item : this.location) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public EncounterHistoryLocationComponent addLocation() {
        EncounterHistoryLocationComponent t = new EncounterHistoryLocationComponent();
        if (this.location == null) {
            this.location = new ArrayList<EncounterHistoryLocationComponent>();
        }
        this.location.add(t);
        return t;
    }

    public EncounterHistory addLocation(EncounterHistoryLocationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.location == null) {
            this.location = new ArrayList<EncounterHistoryLocationComponent>();
        }
        this.location.add(t);
        return this;
    }

    public EncounterHistoryLocationComponent getLocationFirstRep() {
        if (this.getLocation().isEmpty()) {
            this.addLocation();
        }
        return this.getLocation().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "The Encounter associated with this set of historic values.", 0, 1, this.encounter));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifier(s) by which this encounter is known.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "planned | in-progress | on-hold | discharged | completed | cancelled | discontinued | entered-in-error | unknown.", 0, 1, this.status));
        children.add(new Property("class", "CodeableConcept", "Concepts representing classification of patient encounter such as ambulatory (outpatient), inpatient, emergency, home health or others due to local variations.", 0, 1, this.class_));
        children.add(new Property("type", "CodeableConcept", "Specific type of encounter (e.g. e-mail consultation, surgical day-care, skilled nursing, rehabilitation).", 0, Integer.MAX_VALUE, this.type));
        children.add(new Property("serviceType", "CodeableReference(HealthcareService)", "Broad categorization of the service that is to be provided (e.g. cardiology).", 0, Integer.MAX_VALUE, this.serviceType));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group)", "The patient or group related to this encounter. In some use-cases the patient MAY not be present, such as a case meeting about a patient between several practitioners or a careteam.", 0, 1, this.subject));
        children.add(new Property("subjectStatus", "CodeableConcept", "The subjectStatus value can be used to track the patient's status within the encounter. It details whether the patient has arrived or departed, has been triaged or is currently in a waiting status.", 0, 1, this.subjectStatus));
        children.add(new Property("actualPeriod", "Period", "The start and end time associated with this set of values associated with the encounter, may be different to the planned times for various reasons.", 0, 1, this.actualPeriod));
        children.add(new Property("plannedStartDate", "dateTime", "The planned start date/time (or admission date) of the encounter.", 0, 1, this.plannedStartDate));
        children.add(new Property("plannedEndDate", "dateTime", "The planned end date/time (or discharge date) of the encounter.", 0, 1, this.plannedEndDate));
        children.add(new Property("length", "Duration", "Actual quantity of time the encounter lasted. This excludes the time during leaves of absence.\r\rWhen missing it is the time in between the start and end values.", 0, 1, this.length));
        children.add(new Property("location", "", "The location of the patient at this point in the encounter, the multiple cardinality permits de-normalizing the levels of the location hierarchy, such as site/ward/room/bed.", 0, Integer.MAX_VALUE, this.location));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 1524132147: {
                return new Property(SP_ENCOUNTER, "Reference(Encounter)", "The Encounter associated with this set of historic values.", 0, 1, this.encounter);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifier(s) by which this encounter is known.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "planned | in-progress | on-hold | discharged | completed | cancelled | discontinued | entered-in-error | unknown.", 0, 1, this.status);
            }
            case 94742904: {
                return new Property("class", "CodeableConcept", "Concepts representing classification of patient encounter such as ambulatory (outpatient), inpatient, emergency, home health or others due to local variations.", 0, 1, this.class_);
            }
            case 3575610: {
                return new Property("type", "CodeableConcept", "Specific type of encounter (e.g. e-mail consultation, surgical day-care, skilled nursing, rehabilitation).", 0, Integer.MAX_VALUE, this.type);
            }
            case -1928370289: {
                return new Property("serviceType", "CodeableReference(HealthcareService)", "Broad categorization of the service that is to be provided (e.g. cardiology).", 0, Integer.MAX_VALUE, this.serviceType);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group)", "The patient or group related to this encounter. In some use-cases the patient MAY not be present, such as a case meeting about a patient between several practitioners or a careteam.", 0, 1, this.subject);
            }
            case 110854206: {
                return new Property("subjectStatus", "CodeableConcept", "The subjectStatus value can be used to track the patient's status within the encounter. It details whether the patient has arrived or departed, has been triaged or is currently in a waiting status.", 0, 1, this.subjectStatus);
            }
            case 789194991: {
                return new Property("actualPeriod", "Period", "The start and end time associated with this set of values associated with the encounter, may be different to the planned times for various reasons.", 0, 1, this.actualPeriod);
            }
            case 460857804: {
                return new Property("plannedStartDate", "dateTime", "The planned start date/time (or admission date) of the encounter.", 0, 1, this.plannedStartDate);
            }
            case 1657534661: {
                return new Property("plannedEndDate", "dateTime", "The planned end date/time (or discharge date) of the encounter.", 0, 1, this.plannedEndDate);
            }
            case -1106363674: {
                return new Property("length", "Duration", "Actual quantity of time the encounter lasted. This excludes the time during leaves of absence.\r\rWhen missing it is the time in between the start and end values.", 0, 1, this.length);
            }
            case 1901043637: {
                return new Property("location", "", "The location of the patient at this point in the encounter, the multiple cardinality permits de-normalizing the levels of the location hierarchy, such as site/ward/room/bed.", 0, Integer.MAX_VALUE, this.location);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.encounter;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case 94742904: {
                Base[] baseArray;
                if (this.class_ == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.class_;
                }
                return baseArray;
            }
            case 3575610: {
                return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
            }
            case -1928370289: {
                return this.serviceType == null ? new Base[]{} : this.serviceType.toArray(new Base[this.serviceType.size()]);
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.subject;
                }
                return baseArray;
            }
            case 110854206: {
                Base[] baseArray;
                if (this.subjectStatus == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.subjectStatus;
                }
                return baseArray;
            }
            case 789194991: {
                Base[] baseArray;
                if (this.actualPeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.actualPeriod;
                }
                return baseArray;
            }
            case 460857804: {
                Base[] baseArray;
                if (this.plannedStartDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.plannedStartDate;
                }
                return baseArray;
            }
            case 1657534661: {
                Base[] baseArray;
                if (this.plannedEndDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.plannedEndDate;
                }
                return baseArray;
            }
            case -1106363674: {
                Base[] baseArray;
                if (this.length == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.length;
                }
                return baseArray;
            }
            case 1901043637: {
                return this.location == null ? new Base[]{} : this.location.toArray(new Base[this.location.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 1524132147: {
                this.encounter = TypeConvertor.castToReference(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new Enumerations.EncounterStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 94742904: {
                this.class_ = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 3575610: {
                this.getType().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1928370289: {
                this.getServiceType().add(TypeConvertor.castToCodeableReference(value));
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case 110854206: {
                this.subjectStatus = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 789194991: {
                this.actualPeriod = TypeConvertor.castToPeriod(value);
                return value;
            }
            case 460857804: {
                this.plannedStartDate = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 1657534661: {
                this.plannedEndDate = TypeConvertor.castToDateTime(value);
                return value;
            }
            case -1106363674: {
                this.length = TypeConvertor.castToDuration(value);
                return value;
            }
            case 1901043637: {
                this.getLocation().add((EncounterHistoryLocationComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.EncounterStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("class")) {
            this.class_ = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("type")) {
            this.getType().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("serviceType")) {
            this.getServiceType().add(TypeConvertor.castToCodeableReference(value));
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals("subjectStatus")) {
            this.subjectStatus = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("actualPeriod")) {
            this.actualPeriod = TypeConvertor.castToPeriod(value);
        } else if (name.equals("plannedStartDate")) {
            this.plannedStartDate = TypeConvertor.castToDateTime(value);
        } else if (name.equals("plannedEndDate")) {
            this.plannedEndDate = TypeConvertor.castToDateTime(value);
        } else if (name.equals("length")) {
            this.length = TypeConvertor.castToDuration(value);
        } else if (name.equals("location")) {
            this.getLocation().add((EncounterHistoryLocationComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1524132147: {
                return this.getEncounter();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 94742904: {
                return this.getClass_();
            }
            case 3575610: {
                return this.addType();
            }
            case -1928370289: {
                return this.addServiceType();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 110854206: {
                return this.getSubjectStatus();
            }
            case 789194991: {
                return this.getActualPeriod();
            }
            case 460857804: {
                return this.getPlannedStartDateElement();
            }
            case 1657534661: {
                return this.getPlannedEndDateElement();
            }
            case -1106363674: {
                return this.getLength();
            }
            case 1901043637: {
                return this.addLocation();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1524132147: {
                return new String[]{"Reference"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 94742904: {
                return new String[]{"CodeableConcept"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case -1928370289: {
                return new String[]{"CodeableReference"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 110854206: {
                return new String[]{"CodeableConcept"};
            }
            case 789194991: {
                return new String[]{"Period"};
            }
            case 460857804: {
                return new String[]{"dateTime"};
            }
            case 1657534661: {
                return new String[]{"dateTime"};
            }
            case -1106363674: {
                return new String[]{"Duration"};
            }
            case 1901043637: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type EncounterHistory.status");
        }
        if (name.equals("class")) {
            this.class_ = new CodeableConcept();
            return this.class_;
        }
        if (name.equals("type")) {
            return this.addType();
        }
        if (name.equals("serviceType")) {
            return this.addServiceType();
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals("subjectStatus")) {
            this.subjectStatus = new CodeableConcept();
            return this.subjectStatus;
        }
        if (name.equals("actualPeriod")) {
            this.actualPeriod = new Period();
            return this.actualPeriod;
        }
        if (name.equals("plannedStartDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type EncounterHistory.plannedStartDate");
        }
        if (name.equals("plannedEndDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type EncounterHistory.plannedEndDate");
        }
        if (name.equals("length")) {
            this.length = new Duration();
            return this.length;
        }
        if (name.equals("location")) {
            return this.addLocation();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "EncounterHistory";
    }

    @Override
    public EncounterHistory copy() {
        EncounterHistory dst = new EncounterHistory();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(EncounterHistory dst) {
        super.copyValues(dst);
        Reference reference = dst.encounter = this.encounter == null ? null : this.encounter.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        CodeableConcept codeableConcept = dst.class_ = this.class_ == null ? null : this.class_.copy();
        if (this.type != null) {
            dst.type = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.type) {
                dst.type.add(codeableConcept2.copy());
            }
        }
        if (this.serviceType != null) {
            dst.serviceType = new ArrayList<CodeableReference>();
            for (CodeableReference codeableReference : this.serviceType) {
                dst.serviceType.add(codeableReference.copy());
            }
        }
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.subjectStatus = this.subjectStatus == null ? null : this.subjectStatus.copy();
        dst.actualPeriod = this.actualPeriod == null ? null : this.actualPeriod.copy();
        dst.plannedStartDate = this.plannedStartDate == null ? null : this.plannedStartDate.copy();
        dst.plannedEndDate = this.plannedEndDate == null ? null : this.plannedEndDate.copy();
        Duration duration = dst.length = this.length == null ? null : this.length.copy();
        if (this.location != null) {
            dst.location = new ArrayList<EncounterHistoryLocationComponent>();
            for (EncounterHistoryLocationComponent encounterHistoryLocationComponent : this.location) {
                dst.location.add(encounterHistoryLocationComponent.copy());
            }
        }
    }

    protected EncounterHistory typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof EncounterHistory)) {
            return false;
        }
        EncounterHistory o = (EncounterHistory)other_;
        return EncounterHistory.compareDeep(this.encounter, o.encounter, true) && EncounterHistory.compareDeep(this.identifier, o.identifier, true) && EncounterHistory.compareDeep(this.status, o.status, true) && EncounterHistory.compareDeep(this.class_, o.class_, true) && EncounterHistory.compareDeep(this.type, o.type, true) && EncounterHistory.compareDeep(this.serviceType, o.serviceType, true) && EncounterHistory.compareDeep(this.subject, o.subject, true) && EncounterHistory.compareDeep(this.subjectStatus, o.subjectStatus, true) && EncounterHistory.compareDeep(this.actualPeriod, o.actualPeriod, true) && EncounterHistory.compareDeep(this.plannedStartDate, o.plannedStartDate, true) && EncounterHistory.compareDeep(this.plannedEndDate, o.plannedEndDate, true) && EncounterHistory.compareDeep(this.length, o.length, true) && EncounterHistory.compareDeep(this.location, o.location, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof EncounterHistory)) {
            return false;
        }
        EncounterHistory o = (EncounterHistory)other_;
        return EncounterHistory.compareValues(this.status, o.status, true) && EncounterHistory.compareValues(this.plannedStartDate, o.plannedStartDate, true) && EncounterHistory.compareValues(this.plannedEndDate, o.plannedEndDate, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.encounter, this.identifier, this.status, this.class_, this.type, this.serviceType, this.subject, this.subjectStatus, this.actualPeriod, this.plannedStartDate, this.plannedEndDate, this.length, this.location});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.EncounterHistory;
    }

    @Block
    public static class EncounterHistoryLocationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="location", type={Location.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Location the encounter takes place", formalDefinition="The location where the encounter takes place.")
        protected Reference location;
        @Child(name="form", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The physical type of the location (usually the level in the location hierarchy - bed, room, ward, virtual etc.)", formalDefinition="This will be used to specify the required levels (bed/ward/room/etc.) desired to be recorded to simplify either messaging or query.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/location-form")
        protected CodeableConcept form;
        private static final long serialVersionUID = -1306742681L;

        public EncounterHistoryLocationComponent() {
        }

        public EncounterHistoryLocationComponent(Reference location) {
            this.setLocation(location);
        }

        public Reference getLocation() {
            if (this.location == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterHistoryLocationComponent.location");
                }
                if (Configuration.doAutoCreate()) {
                    this.location = new Reference();
                }
            }
            return this.location;
        }

        public boolean hasLocation() {
            return this.location != null && !this.location.isEmpty();
        }

        public EncounterHistoryLocationComponent setLocation(Reference value) {
            this.location = value;
            return this;
        }

        public CodeableConcept getForm() {
            if (this.form == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterHistoryLocationComponent.form");
                }
                if (Configuration.doAutoCreate()) {
                    this.form = new CodeableConcept();
                }
            }
            return this.form;
        }

        public boolean hasForm() {
            return this.form != null && !this.form.isEmpty();
        }

        public EncounterHistoryLocationComponent setForm(CodeableConcept value) {
            this.form = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("location", "Reference(Location)", "The location where the encounter takes place.", 0, 1, this.location));
            children.add(new Property("form", "CodeableConcept", "This will be used to specify the required levels (bed/ward/room/etc.) desired to be recorded to simplify either messaging or query.", 0, 1, this.form));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1901043637: {
                    return new Property("location", "Reference(Location)", "The location where the encounter takes place.", 0, 1, this.location);
                }
                case 3148996: {
                    return new Property("form", "CodeableConcept", "This will be used to specify the required levels (bed/ward/room/etc.) desired to be recorded to simplify either messaging or query.", 0, 1, this.form);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1901043637: {
                    Base[] baseArray;
                    if (this.location == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.location;
                    }
                    return baseArray;
                }
                case 3148996: {
                    Base[] baseArray;
                    if (this.form == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.form;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1901043637: {
                    this.location = TypeConvertor.castToReference(value);
                    return value;
                }
                case 3148996: {
                    this.form = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("location")) {
                this.location = TypeConvertor.castToReference(value);
            } else if (name.equals("form")) {
                this.form = TypeConvertor.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1901043637: {
                    return this.getLocation();
                }
                case 3148996: {
                    return this.getForm();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1901043637: {
                    return new String[]{"Reference"};
                }
                case 3148996: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("location")) {
                this.location = new Reference();
                return this.location;
            }
            if (name.equals("form")) {
                this.form = new CodeableConcept();
                return this.form;
            }
            return super.addChild(name);
        }

        @Override
        public EncounterHistoryLocationComponent copy() {
            EncounterHistoryLocationComponent dst = new EncounterHistoryLocationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(EncounterHistoryLocationComponent dst) {
            super.copyValues(dst);
            dst.location = this.location == null ? null : this.location.copy();
            dst.form = this.form == null ? null : this.form.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof EncounterHistoryLocationComponent)) {
                return false;
            }
            EncounterHistoryLocationComponent o = (EncounterHistoryLocationComponent)other_;
            return EncounterHistoryLocationComponent.compareDeep(this.location, o.location, true) && EncounterHistoryLocationComponent.compareDeep(this.form, o.form, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof EncounterHistoryLocationComponent)) {
                return false;
            }
            EncounterHistoryLocationComponent o = (EncounterHistoryLocationComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.location, this.form});
        }

        @Override
        public String fhirType() {
            return "EncounterHistory.location";
        }
    }
}

