/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.conformance.profile.BindingResolution;
import org.hl7.fhir.r5.conformance.profile.ProfileKnowledgeProvider;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.renderers.CodeResolver;
import org.hl7.fhir.r5.renderers.DataRenderer;
import org.hl7.fhir.r5.renderers.IMarkdownProcessor;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.xhtml.HierarchicalTableGenerator;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.utilities.xhtml.XhtmlNodeList;

public class AdditionalBindingsRenderer {
    private static String STYLE_UNCHANGED = "opacity: 0.5;";
    private static String STYLE_REMOVED = STYLE_UNCHANGED + "text-decoration: line-through;";
    private List<AdditionalBindingDetail> bindings = new ArrayList<AdditionalBindingDetail>();
    private ProfileKnowledgeProvider pkp;
    private String corePath;
    private StructureDefinition profile;
    private String path;
    private RenderingContext context;
    private IMarkdownProcessor md;
    private CodeResolver cr;

    public AdditionalBindingsRenderer(ProfileKnowledgeProvider pkp, String corePath, StructureDefinition profile, String path, RenderingContext context, IMarkdownProcessor md, CodeResolver cr) {
        this.pkp = pkp;
        this.corePath = corePath;
        this.profile = profile;
        this.path = path;
        this.context = context;
        this.md = md;
        this.cr = cr;
    }

    public void seeMaxBinding(Extension ext) {
        this.seeMaxBinding(ext, null, false);
    }

    public void seeMaxBinding(Extension ext, Extension compExt, boolean compare) {
        this.seeBinding(ext, compExt, compare, "maximum");
    }

    protected void seeBinding(Extension ext, Extension compExt, boolean compare, String label) {
        AdditionalBindingDetail abr = new AdditionalBindingDetail();
        abr.purpose = label;
        abr.valueSet = ext.getValue().primitiveValue();
        if (compare) {
            abr.isUnchanged = compExt != null && ext.getValue().primitiveValue().equals(compExt.getValue().primitiveValue());
            (abr.compare = (AdditionalBindingsRenderer)this.new AdditionalBindingDetail()).valueSet = compExt == null ? null : compExt.getValue().primitiveValue();
        } else {
            abr.isUnchanged = ext.hasUserData("derivation.equals");
        }
        this.bindings.add(abr);
    }

    public void seeMinBinding(Extension ext) {
        this.seeMinBinding(ext, null, false);
    }

    public void seeMinBinding(Extension ext, Extension compExt, boolean compare) {
        this.seeBinding(ext, compExt, compare, "minimum");
    }

    public void seeAdditionalBindings(List<Extension> list) {
        this.seeAdditionalBindings(list, null, false);
    }

    public void seeAdditionalBindings(List<Extension> list, List<Extension> compList, boolean compare) {
        AdditionalBindingDetail abr;
        HashMap<String, AdditionalBindingDetail> compBindings = new HashMap<String, AdditionalBindingDetail>();
        if (compare && compList != null) {
            for (Extension ext : compList) {
                abr = this.additionalBinding(ext);
                if (compBindings.containsKey(abr.getKey())) {
                    abr.incrementCount();
                }
                compBindings.put(abr.getKey(), abr);
            }
        }
        for (Extension ext : list) {
            abr = this.additionalBinding(ext);
            if (compare && compList != null) {
                AdditionalBindingDetail match = null;
                do {
                    match = (AdditionalBindingDetail)compBindings.get(abr.getKey());
                    if (!abr.alreadyMatched()) continue;
                    abr.incrementCount();
                } while (match != null && abr.alreadyMatched());
                if (match != null) {
                    abr.setCompare(match);
                }
                this.bindings.add(abr);
                if (abr.compare == null) continue;
                compBindings.remove(abr.compare.getKey());
                continue;
            }
            this.bindings.add(abr);
        }
        for (AdditionalBindingDetail b : compBindings.values()) {
            b.removed = true;
            this.bindings.add(b);
        }
    }

    protected AdditionalBindingDetail additionalBinding(Extension ext) {
        AdditionalBindingDetail abr = new AdditionalBindingDetail();
        abr.purpose = ext.getExtensionString("purpose");
        abr.valueSet = ext.getExtensionString("valueSet");
        abr.doco = ext.getExtensionString("documentation");
        abr.docoShort = ext.getExtensionString("shortDoco");
        abr.usage = ext.hasExtension("usage") && ext.getExtensionByUrl("usage").hasValueUsageContext() ? ext.getExtensionByUrl("usage").getValueUsageContext() : null;
        abr.any = "any".equals(ext.getExtensionString("scope"));
        abr.isUnchanged = ext.hasUserData("derivation.equals");
        return abr;
    }

    public String render() throws IOException {
        if (this.bindings.isEmpty()) {
            return "";
        }
        XhtmlNode tbl = new XhtmlNode(NodeType.Element, "table");
        tbl.attribute("class", "grid");
        this.render((List<XhtmlNode>)tbl.getChildNodes(), true);
        return new XhtmlComposer(false).compose(tbl);
    }

    public void render(HierarchicalTableGenerator gen, HierarchicalTableGenerator.Cell c) throws FHIRFormatError, DefinitionException, IOException {
        if (this.bindings.isEmpty()) {
            return;
        }
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.Piece piece = new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "table").attr("class", "grid");
        c.getPieces().add(piece);
        this.render((List<XhtmlNode>)piece.getChildren(), false);
    }

    public void render(List<XhtmlNode> children, boolean fullDoco) throws FHIRFormatError, DefinitionException, IOException {
        boolean doco = false;
        boolean usage = false;
        boolean any = false;
        for (AdditionalBindingDetail binding : this.bindings) {
            doco = doco || binding.getDoco(fullDoco) != null || binding.compare != null && binding.compare.getDoco(fullDoco) != null;
            usage = usage || binding.usage != null || binding.compare != null && binding.compare.usage != null;
            any = any || binding.any || binding.compare != null && binding.compare.any;
        }
        XhtmlNode tr = new XhtmlNode(NodeType.Element, "tr");
        children.add(tr);
        tr.td().style("font-size: 11px").b().tx("Additional Bindings");
        tr.td().style("font-size: 11px").tx("Purpose");
        if (usage) {
            tr.td().style("font-size: 11px").tx("Usage");
        }
        if (any) {
            tr.td().style("font-size: 11px").tx("Any");
        }
        if (doco) {
            tr.td().style("font-size: 11px").tx("Documentation");
        }
        for (AdditionalBindingDetail binding : this.bindings) {
            tr = new XhtmlNode(NodeType.Element, "tr");
            if (binding.unchanged()) {
                tr.style(STYLE_REMOVED);
            } else if (binding.removed) {
                tr.style(STYLE_REMOVED);
            }
            children.add(tr);
            BindingResolution br = this.pkp == null ? this.makeNullBr(binding) : this.pkp.resolveBinding(this.profile, binding.valueSet, this.path);
            BindingResolution compBr = null;
            if (binding.compare != null && binding.compare.valueSet != null) {
                compBr = this.pkp == null ? this.makeNullBr(binding.compare) : this.pkp.resolveBinding(this.profile, binding.compare.valueSet, this.path);
            }
            XhtmlNode valueset = tr.td().style("font-size: 11px");
            if (binding.compare != null && binding.valueSet.equals(binding.compare.valueSet)) {
                valueset.style(STYLE_UNCHANGED);
            }
            if (br.url != null) {
                valueset.ah(this.determineUrl(br.url), binding.valueSet).tx(br.display);
            } else {
                valueset.span(null, binding.valueSet).tx(br.display);
            }
            if (binding.compare != null && binding.compare.valueSet != null && !binding.valueSet.equals(binding.compare.valueSet)) {
                valueset.br();
                valueset = valueset.span(STYLE_REMOVED, null);
                if (compBr.url != null) {
                    valueset.ah(this.determineUrl(compBr.url), binding.compare.valueSet).tx(compBr.display);
                } else {
                    valueset.span(null, binding.compare.valueSet).tx(compBr.display);
                }
            }
            XhtmlNode purpose = tr.td().style("font-size: 11px");
            if (binding.compare != null && binding.purpose.equals(binding.compare.purpose)) {
                purpose.style("font-color: darkgray");
            }
            this.renderPurpose(purpose, binding.purpose);
            if (binding.compare != null && binding.compare.purpose != null && !binding.purpose.equals(binding.compare.purpose)) {
                purpose.br();
                purpose = purpose.span(STYLE_UNCHANGED, null);
                this.renderPurpose(purpose, binding.compare.purpose);
            }
            if (usage) {
                if (binding.usage != null) {
                    new DataRenderer(this.context).render(tr.td(), binding.usage);
                } else {
                    tr.td();
                }
            }
            if (any) {
                String newRepeat = binding.any ? "Any repeats" : "All repeats";
                String oldRepeat = binding.compare != null && binding.compare.any ? "Any repeats" : "All repeats";
                this.compareString(tr.td().style("font-size: 11px"), newRepeat, oldRepeat);
            }
            if (!doco) continue;
            if (binding.doco != null) {
                String d;
                String string = d = fullDoco ? this.md.processMarkdown("Binding.description", binding.doco) : binding.docoShort;
                String oldD = binding.compare == null ? null : (fullDoco ? this.md.processMarkdown("Binding.description.compare", binding.compare.doco) : binding.compare.docoShort);
                tr.td().style("font-size: 11px").innerHTML(this.compareHtml(d, oldD));
                continue;
            }
            tr.td().style("font-size: 11px");
        }
    }

    private XhtmlNode compareString(XhtmlNode node, String newS, String oldS) {
        if (oldS == null) {
            return node.tx(newS);
        }
        if (newS.equals(oldS)) {
            return node.style(STYLE_UNCHANGED).tx(newS);
        }
        node.tx(newS);
        node.br();
        return node.span(STYLE_REMOVED, null).tx(oldS);
    }

    private String compareHtml(String newS, String oldS) {
        if (oldS == null) {
            return newS;
        }
        if (newS.equals(oldS)) {
            return "<span style=\"" + STYLE_UNCHANGED + "\">" + newS + "</span>";
        }
        return newS + "<br/><span style=\"" + STYLE_REMOVED + "\">" + oldS + "</span>";
    }

    private String determineUrl(String url) {
        return Utilities.isAbsoluteUrl((String)url) || !this.pkp.prependLinks() ? url : this.corePath + url;
    }

    private void renderPurpose(XhtmlNode td, String purpose) {
        boolean r5 = this.context == null || this.context.getWorker() == null ? false : VersionUtilities.isR5Plus((String)this.context.getWorker().getVersion());
        switch (purpose) {
            case "maximum": {
                td.ah(r5 ? this.corePath + "valueset-additional-binding-purpose.html#additional-binding-purpose-maximum" : this.corePath + "extension-elementdefinition-maxvalueset.html", "A required binding, for use when the binding strength is 'extensible' or 'preferred'").tx("Max Binding");
                break;
            }
            case "minimum": {
                td.ah(r5 ? this.corePath + "valueset-additional-binding-purpose.html#additional-binding-purpose-minimum" : this.corePath + "extension-elementdefinition-minvalueset.html", "The minimum allowable value set - any conformant system SHALL support all these codes").tx("Min Binding");
                break;
            }
            case "required": {
                td.ah(r5 ? this.corePath + "valueset-additional-binding-purpose.html#additional-binding-purpose-required" : this.corePath + "terminologies.html#strength", "Validators will check this binding (strength = required)").tx("Required Binding");
                break;
            }
            case "extensible": {
                td.ah(r5 ? this.corePath + "valueset-additional-binding-purpose.html#additional-binding-purpose-extensible" : this.corePath + "terminologies.html#strength", "Validators will check this binding (strength = extensible)").tx("Extensible Binding");
                break;
            }
            case "current": {
                if (r5) {
                    td.ah(r5 ? this.corePath + "valueset-additional-binding-purpose.html#additional-binding-purpose-current" : this.corePath + "terminologies.html#strength", "New records are required to use this value set, but legacy records may use other codes").tx("Current Binding");
                    break;
                }
                td.span(null, "New records are required to use this value set, but legacy records may use other codes").tx("Required");
                break;
            }
            case "preferred": {
                if (r5) {
                    td.ah(r5 ? this.corePath + "valueset-additional-binding-purpose.html#additional-binding-purpose-preferred" : this.corePath + "terminologies.html#strength", "This is the value set that is recommended (documentation should explain why)").tx("Preferred Binding");
                    break;
                }
                td.span(null, "This is the value set that is recommended (documentation should explain why)").tx("Recommended");
                break;
            }
            case "ui": {
                if (r5) {
                    td.ah(r5 ? this.corePath + "valueset-additional-binding-purpose.html#additional-binding-purpose-ui" : this.corePath + "terminologies.html#strength", "This value set is provided to user look up in a given context").tx("UI Binding");
                    break;
                }
                td.span(null, "This value set is provided to user look up in a given context").tx("UI");
                break;
            }
            case "starter": {
                if (r5) {
                    td.ah(r5 ? this.corePath + "valueset-additional-binding-purpose.html#additional-binding-purpose-starter" : this.corePath + "terminologies.html#strength", "This value set is a good set of codes to start with when designing your system").tx("Starter Set");
                    break;
                }
                td.span(null, "This value set is a good set of codes to start with when designing your system").tx("Starter");
                break;
            }
            case "component": {
                if (r5) {
                    td.ah(r5 ? this.corePath + "valueset-additional-binding-purpose.html#additional-binding-purpose-component" : this.corePath + "terminologies.html#strength", "This value set is a component of the base value set").tx("Component");
                    break;
                }
                td.span(null, "This value set is a component of the base value set").tx("Component");
                break;
            }
            default: {
                td.span(null, "Unknown code for purpose").tx(purpose);
            }
        }
    }

    private BindingResolution makeNullBr(AdditionalBindingDetail binding) {
        BindingResolution br = new BindingResolution();
        br.url = "http://none.none/none";
        br.display = "todo";
        return br;
    }

    public boolean hasBindings() {
        return !this.bindings.isEmpty();
    }

    public void render(XhtmlNodeList children, List<ElementDefinition.ElementDefinitionBindingAdditionalComponent> list) {
        if (list.size() == 1) {
            this.render(children, list.get(0));
        } else {
            XhtmlNode ul = children.ul();
            for (ElementDefinition.ElementDefinitionBindingAdditionalComponent b : list) {
                this.render(ul.li().getChildNodes(), b);
            }
        }
    }

    private void render(XhtmlNodeList children, ElementDefinition.ElementDefinitionBindingAdditionalComponent b) {
        if (b.getValueSet() == null) {
            return;
        }
        BindingResolution br = this.pkp.resolveBinding(this.profile, b.getValueSet(), this.corePath);
        XhtmlNode a = children.ahOrCode((String)(br.url == null ? null : (Utilities.isAbsoluteUrl((String)br.url) || !this.context.getPkp().prependLinks() ? br.url : this.corePath + br.url)), b.hasDocumentation() ? b.getDocumentation() : null);
        if (b.hasDocumentation()) {
            a.attribute("title", b.getDocumentation());
        }
        a.tx(br.display);
        if (b.hasShortDoco()) {
            children.tx(": ");
            children.tx(b.getShortDoco());
        }
        if (b.getAny() || b.hasUsage()) {
            boolean ffirst;
            children.tx(" (");
            boolean bl = ffirst = !b.getAny();
            if (b.getAny()) {
                children.tx("any repeat");
            }
            for (UsageContext uc : b.getUsage()) {
                if (ffirst) {
                    ffirst = false;
                } else {
                    children.tx(",");
                }
                if (!uc.getCode().is("http://terminology.hl7.org/CodeSystem/usage-context-type", "jurisdiction")) {
                    children.tx(this.displayForUsage(uc.getCode()));
                    children.tx("=");
                }
                CodeResolver.CodeResolution ccr = this.cr.resolveCode(uc.getValueCodeableConcept());
                children.ah(ccr.getLink(), ccr.getHint()).tx(ccr.getDisplay());
            }
            children.tx(")");
        }
    }

    private String displayForUsage(Coding c) {
        if (c.hasDisplay()) {
            return c.getDisplay();
        }
        if ("http://terminology.hl7.org/CodeSystem/usage-context-type".equals(c.getSystem())) {
            return c.getCode();
        }
        return c.getCode();
    }

    public void seeAdditionalBinding(String purpose, String doco, ValueSet valueSet) {
        AdditionalBindingDetail abr = new AdditionalBindingDetail();
        abr.purpose = purpose;
        abr.valueSet = valueSet.getUrl();
        abr.vs = valueSet;
        this.bindings.add(abr);
    }

    public void seeAdditionalBinding(String purpose, String doco, String ref) {
        AdditionalBindingDetail abr = new AdditionalBindingDetail();
        abr.purpose = purpose;
        abr.valueSet = ref;
        this.bindings.add(abr);
    }

    public class AdditionalBindingDetail {
        private String purpose;
        private String valueSet;
        private String doco;
        private String docoShort;
        private UsageContext usage;
        private boolean any = false;
        private boolean isUnchanged = false;
        private boolean matched = false;
        private boolean removed = false;
        private ValueSet vs;
        private AdditionalBindingDetail compare;
        private int count = 1;

        private String getKey() {
            return this.purpose + Integer.toString(this.count);
        }

        private void incrementCount() {
            ++this.count;
        }

        private void setCompare(AdditionalBindingDetail match) {
            this.compare = match;
            match.matched = true;
        }

        private boolean alreadyMatched() {
            return this.matched;
        }

        public String getDoco(boolean full) {
            return full ? this.doco : this.docoShort;
        }

        public boolean unchanged() {
            if (!this.isUnchanged) {
                return false;
            }
            if (this.compare == null) {
                return true;
            }
            this.isUnchanged = true;
            this.isUnchanged = this.isUnchanged && (this.purpose == null && this.compare.purpose == null || this.purpose.equals(this.compare.purpose));
            this.isUnchanged = this.isUnchanged && (this.valueSet == null && this.compare.valueSet == null || this.valueSet.equals(this.compare.valueSet));
            this.isUnchanged = this.isUnchanged && (this.doco == null && this.compare.doco == null || this.doco.equals(this.compare.doco));
            this.isUnchanged = this.isUnchanged && (this.docoShort == null && this.compare.docoShort == null || this.docoShort.equals(this.compare.docoShort));
            this.isUnchanged = this.isUnchanged && (this.usage == null && this.compare.usage == null || this.usage.equals(this.compare.usage));
            return this.isUnchanged;
        }
    }
}

