/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.TestPlan;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.BaseWrappers;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.Resolver;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class TestPlanRenderer
extends ResourceRenderer {
    public TestPlanRenderer(RenderingContext context) {
        super(context);
    }

    public TestPlanRenderer(RenderingContext context, Resolver.ResourceContext rcontext) {
        super(context, rcontext);
    }

    @Override
    public boolean render(XhtmlNode x, Resource r) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        return this.render(x, (TestPlan)r);
    }

    /*
     * WARNING - void declaration
     */
    public boolean render(XhtmlNode x, TestPlan tp) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        XhtmlNode p = null;
        if (!tp.getContact().isEmpty()) {
            p = x.para();
            p.b().tx("Contact:");
            p.tx(" (");
            boolean firsti = true;
            for (ContactDetail contactDetail : tp.getContact()) {
                if (firsti) {
                    firsti = false;
                } else {
                    p.tx(", ");
                }
                if (contactDetail.hasName()) {
                    p.addText(contactDetail.getName() + ": ");
                }
                boolean first = true;
                for (ContactPoint c : contactDetail.getTelecom()) {
                    if (first) {
                        first = false;
                    } else {
                        p.tx(", ");
                    }
                    this.addTelecom(p, c);
                }
            }
            p.tx(")");
        }
        if (tp.hasCategory()) {
            p = x.para();
            p.b().tx("Category: ");
            boolean first = true;
            for (CodeableConcept codeableConcept : tp.getCategory()) {
                if (first) {
                    first = false;
                } else {
                    p.tx(", ");
                }
                this.renderCodeableConcept(p, codeableConcept, false);
            }
        }
        if (tp.hasScope()) {
            if (tp.getScope().size() == 1) {
                p = x.para();
                p.b().tx("Test Plan Scope: ");
                this.renderReference(tp, p, tp.getScopeFirstRep());
            } else {
                x.para().b().tx("Test Plan Scopes:");
                XhtmlNode ul = x.ul();
                for (Reference reference : tp.getScope()) {
                    this.renderReference(tp, ul.li(), reference);
                }
            }
        }
        if (tp.hasDependency()) {
            if (tp.getDependency().size() == 1) {
                p = x.para();
                p.b().tx("Test Plan Dependency: ");
                XhtmlNode t = x.table("grid");
                XhtmlNode tr = t.tr();
                if (!Utilities.noString((String)tp.getDependencyFirstRep().getDescription())) {
                    this.addMarkdown(tr.td(), tp.getDependencyFirstRep().getDescription());
                }
                tr = t.tr();
                this.renderReference(tp, tr.td(), tp.getDependencyFirstRep().getPredecessor());
            } else {
                x.para().b().tx("Test Plan Dependencies:");
                XhtmlNode ul = x.ul();
                XhtmlNode li = null;
                for (TestPlan.TestPlanDependencyComponent d : tp.getDependency()) {
                    li = ul.li();
                    if (!Utilities.noString((String)d.getDescription())) {
                        this.addMarkdown(li, d.getDescription());
                    } else {
                        li.addText("Dependency -  no description");
                    }
                    if (!d.hasPredecessor()) continue;
                    XhtmlNode xhtmlNode = li.ul();
                    XhtmlNode liulli = xhtmlNode.li();
                    this.renderReference(tp, liulli, d.getPredecessor());
                }
            }
        }
        if (tp.hasExitCriteria()) {
            this.addMarkdown(x, tp.getExitCriteria());
        }
        if (tp.hasTestCase()) {
            for (TestPlan.TestPlanTestCaseComponent tc : tp.getTestCase()) {
                x.h2().addText("Test Case" + (String)(tc.hasSequence() ? " - Sequence" + tc.getSequence() : ""));
                if (tc.hasScope()) {
                    if (tc.getScope().size() == 1) {
                        p = x.para();
                        p.b().tx("Test Case Scope: ");
                        this.renderReference(tp, p, tc.getScopeFirstRep());
                    } else {
                        x.para().b().tx("Test Case Scopes:");
                        XhtmlNode xhtmlNode = x.ul();
                        for (Reference reference : tc.getScope()) {
                            this.renderReference(tp, xhtmlNode.li(), reference);
                        }
                    }
                }
                if (tc.hasDependency()) {
                    if (tc.getDependency().size() == 1) {
                        x.h3().addText("Test Case Dependency");
                        XhtmlNode xhtmlNode = x.table("grid");
                        XhtmlNode tr = xhtmlNode.tr();
                        if (!Utilities.noString((String)tc.getDependencyFirstRep().getDescription())) {
                            this.addMarkdown(tr.td(), tc.getDependencyFirstRep().getDescription());
                        }
                        tr = xhtmlNode.tr();
                        this.renderReference(tp, tr.td(), tc.getDependencyFirstRep().getPredecessor());
                    } else {
                        x.h3().addText("Test Case Dependencies");
                        XhtmlNode xhtmlNode = x.ul();
                        XhtmlNode li = null;
                        for (TestPlan.TestCaseDependencyComponent d : tc.getDependency()) {
                            li = xhtmlNode.li();
                            if (!Utilities.noString((String)d.getDescription())) {
                                this.addMarkdown(li, d.getDescription());
                            } else {
                                li.addText("Dependency -  no description");
                            }
                            if (!d.hasPredecessor()) continue;
                            XhtmlNode liul = li.ul();
                            XhtmlNode liulli = liul.li();
                            this.renderReference(tp, liulli, d.getPredecessor());
                        }
                    }
                }
                if (tc.hasTestRun()) {
                    if (tc.getTestRun().size() == 1) {
                        x.h3().addText("Test Run");
                        this.renderTestRun(x, tp, tc.getTestRunFirstRep());
                    } else {
                        boolean bl = false;
                        for (TestPlan.TestPlanTestCaseTestRunComponent testPlanTestCaseTestRunComponent : tc.getTestRun()) {
                            void var6_21;
                            x.h3().addText("Test Run " + (int)(++var6_21));
                            this.renderTestRun(x, tp, testPlanTestCaseTestRunComponent);
                        }
                    }
                }
                if (tc.hasTestData()) {
                    if (tc.getTestData().size() == 1) {
                        x.h3().addText("Test Data");
                        this.renderTestData(x, tp, tc.getTestDataFirstRep());
                    } else {
                        boolean bl = false;
                        for (TestPlan.TestPlanTestCaseTestDataComponent testPlanTestCaseTestDataComponent : tc.getTestData()) {
                            void var6_23;
                            x.h3().addText("Test Data " + (int)(++var6_23));
                            this.renderTestData(x, tp, testPlanTestCaseTestDataComponent);
                        }
                    }
                }
                if (!tc.hasAssertion()) continue;
                if (tc.getAssertion().size() == 1) {
                    x.h3().addText("Assertion");
                    this.renderAssertion(x, tp, tc.getAssertionFirstRep());
                    continue;
                }
                boolean bl = false;
                for (TestPlan.TestPlanTestCaseAssertionComponent testPlanTestCaseAssertionComponent : tc.getAssertion()) {
                    void var6_25;
                    x.h3().addText("Assertion " + (int)(++var6_25));
                    this.renderAssertion(x, tp, testPlanTestCaseAssertionComponent);
                }
            }
        }
        return false;
    }

    private void renderTestRun(XhtmlNode x, TestPlan tp, TestPlan.TestPlanTestCaseTestRunComponent trun) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        if (trun.hasNarrative()) {
            this.addMarkdown(x, trun.getNarrative());
        }
        if (trun.hasScript()) {
            XhtmlNode t = x.table("grid");
            XhtmlNode tr = t.tr();
            tr.td().b().addText("Language");
            tr.td().b().addText("Source[x]");
            tr = t.tr();
            if (trun.getScript().hasLanguage()) {
                this.renderCodeableConcept(tr.td(), trun.getScript().getLanguage(), false);
            } else {
                tr.td().addText("??");
            }
            if (trun.getScript().hasSourceReference()) {
                this.renderReference(tp, tr.td(), trun.getScript().getSourceReference());
            } else if (trun.getScript().hasSourceStringType()) {
                tr.td().addText(trun.getScript().getSourceStringType().asStringValue());
            } else {
                tr.td().addText("??");
            }
        }
    }

    private void renderTestData(XhtmlNode x, TestPlan tp, TestPlan.TestPlanTestCaseTestDataComponent tdata) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        XhtmlNode t = x.table("grid");
        XhtmlNode tr = t.tr();
        tr.td().b().addText("Type");
        tr.td().b().addText("Content");
        tr.td().b().addText("Source[x]");
        tr = t.tr();
        if (tdata.hasType()) {
            this.renderCoding(tr.td(), tdata.getType());
        } else {
            tr.td().addText("??");
        }
        if (tdata.hasContent()) {
            this.renderReference(tp, tr.td(), tdata.getContent());
        } else {
            tr.td().addText("??");
        }
        if (tdata.hasSourceReference()) {
            this.renderReference(tp, tr.td(), tdata.getSourceReference());
        } else if (tdata.hasSourceStringType()) {
            tr.td().addText(tdata.getSourceStringType().asStringValue());
        } else {
            tr.td().addText("??");
        }
    }

    private void renderAssertion(XhtmlNode x, TestPlan tp, TestPlan.TestPlanTestCaseAssertionComponent as) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        XhtmlNode ul;
        XhtmlNode td;
        XhtmlNode t = x.table("grid");
        XhtmlNode tr = t.tr();
        tr.td().b().addText("Type");
        tr.td().b().addText("Content");
        tr.td().b().addText("Result");
        tr = t.tr();
        if (as.hasType()) {
            td = tr.td();
            ul = td.ul();
            for (CodeableConcept cc : as.getType()) {
                this.renderCodeableConcept(ul.li(), cc, false);
            }
        } else {
            tr.td().addText("??");
        }
        if (as.hasObject()) {
            td = tr.td();
            ul = td.ul();
            for (CodeableReference cr : as.getObject()) {
                this.renderCodeableReference(ul.li(), cr, false);
            }
        } else {
            tr.td().addText("??");
        }
        if (as.hasResult()) {
            td = tr.td();
            ul = td.ul();
            for (CodeableReference cr : as.getResult()) {
                this.renderCodeableReference(ul.li(), cr, false);
            }
        } else {
            tr.td().addText("??");
        }
    }

    @Override
    public String display(Resource r) throws UnsupportedEncodingException, IOException {
        return null;
    }

    @Override
    public String display(BaseWrappers.ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        if (r.has("title")) {
            return r.children("title").get(0).getBase().primitiveValue();
        }
        return "??";
    }
}

