/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="BiologicallyDerivedProductDispense", profile="http://hl7.org/fhir/StructureDefinition/BiologicallyDerivedProductDispense")
public class BiologicallyDerivedProductDispense
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifier for this dispense", formalDefinition="Unique instance identifiers assigned to a biologically derived product dispense. Note: This is a business identifier, not a resource identifier.")
    protected List<Identifier> identifier;
    @Child(name="basedOn", type={ServiceRequest.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The order or request that this dispense is fulfilling", formalDefinition="The order or request that the dispense is fulfilling. This is a reference to a ServiceRequest resource.")
    protected List<Reference> basedOn;
    @Child(name="partOf", type={BiologicallyDerivedProductDispense.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Short description", formalDefinition="A larger event of which this particular event is a component.")
    protected List<Reference> partOf;
    @Child(name="status", type={CodeType.class}, order=3, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="preparation | in-progress | allocated | issued | unfulfilled | returned | entered-in-error | unknown", formalDefinition="A code specifying the state of the dispense event.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/biologicallyderivedproductdispense-status")
    protected Enumeration<BiologicallyDerivedProductDispenseCodes> status;
    @Child(name="originRelationshipType", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Relationship between the donor and intended recipient", formalDefinition="Indicates the relationship between the donor of the biologically derived product and the intended recipient.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/biologicallyderivedproductdispense-origin-relationship")
    protected CodeableConcept originRelationshipType;
    @Child(name="product", type={BiologicallyDerivedProduct.class}, order=5, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The BiologicallyDerivedProduct that is dispensed", formalDefinition="A link to a resource identifying the biologically derived product that is being dispensed.")
    protected Reference product;
    @Child(name="patient", type={Patient.class}, order=6, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The intended recipient of the dispensed product", formalDefinition="A link to a resource representing the patient that the product is dispensed for.")
    protected Reference patient;
    @Child(name="matchStatus", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Indicates the type of matching associated with the dispense", formalDefinition="Indicates the type of matching associated with the dispense.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/biologicallyderivedproductdispense-match-status")
    protected CodeableConcept matchStatus;
    @Child(name="performer", type={}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Indicates who or what performed an action", formalDefinition="Indicates who or what performed an action.")
    protected List<BiologicallyDerivedProductDispensePerformerComponent> performer;
    @Child(name="location", type={Location.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Where the dispense occurred", formalDefinition="The physical location where the dispense was performed.")
    protected Reference location;
    @Child(name="quantity", type={Quantity.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Amount dispensed", formalDefinition="The amount of product in the dispense. Quantity will depend on the product being dispensed. Examples are: volume; cell count; concentration.")
    protected Quantity quantity;
    @Child(name="preparedDate", type={DateTimeType.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When product was selected/matched", formalDefinition="When the product was selected/ matched.")
    protected DateTimeType preparedDate;
    @Child(name="whenHandedOver", type={DateTimeType.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the product was dispatched", formalDefinition="When the product was dispatched for clinical use.")
    protected DateTimeType whenHandedOver;
    @Child(name="destination", type={Location.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Where the product was dispatched to", formalDefinition="Link to a resource identifying the physical location that the product was dispatched to.")
    protected Reference destination;
    @Child(name="note", type={Annotation.class}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional notes", formalDefinition="Additional notes.")
    protected List<Annotation> note;
    @Child(name="usageInstruction", type={StringType.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Specific instructions for use", formalDefinition="Specific instructions for use.")
    protected StringType usageInstruction;
    private static final long serialVersionUID = -109945994L;
    @SearchParamDefinition(name="identifier", path="BiologicallyDerivedProductDispense.identifier", description="The identifier of the dispense", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="BiologicallyDerivedProductDispense.patient", description="The identity of a patient for whom to list dispenses", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("BiologicallyDerivedProductDispense:patient").toLocked();
    @SearchParamDefinition(name="performer", path="BiologicallyDerivedProductDispense.performer.actor", description="The identity of a patient for whom to list dispenses", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Practitioner")}, target={Practitioner.class})
    public static final String SP_PERFORMER = "performer";
    public static final ReferenceClientParam PERFORMER = new ReferenceClientParam("performer");
    public static final Include INCLUDE_PERFORMER = new Include("BiologicallyDerivedProductDispense:performer").toLocked();
    @SearchParamDefinition(name="product", path="BiologicallyDerivedProductDispense.product", description="Search for products that match this code", type="reference", target={BiologicallyDerivedProduct.class})
    public static final String SP_PRODUCT = "product";
    public static final ReferenceClientParam PRODUCT = new ReferenceClientParam("product");
    public static final Include INCLUDE_PRODUCT = new Include("BiologicallyDerivedProductDispense:product").toLocked();
    @SearchParamDefinition(name="status", path="BiologicallyDerivedProductDispense.status", description="The status of the dispense", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public BiologicallyDerivedProductDispense() {
    }

    public BiologicallyDerivedProductDispense(BiologicallyDerivedProductDispenseCodes status, Reference product, Reference patient) {
        this.setStatus(status);
        this.setProduct(product);
        this.setPatient(patient);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public BiologicallyDerivedProductDispense setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public BiologicallyDerivedProductDispense addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public BiologicallyDerivedProductDispense setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public BiologicallyDerivedProductDispense addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    public List<Reference> getPartOf() {
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        return this.partOf;
    }

    public BiologicallyDerivedProductDispense setPartOf(List<Reference> thePartOf) {
        this.partOf = thePartOf;
        return this;
    }

    public boolean hasPartOf() {
        if (this.partOf == null) {
            return false;
        }
        for (Reference item : this.partOf) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPartOf() {
        Reference t = new Reference();
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return t;
    }

    public BiologicallyDerivedProductDispense addPartOf(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return this;
    }

    public Reference getPartOfFirstRep() {
        if (this.getPartOf().isEmpty()) {
            this.addPartOf();
        }
        return this.getPartOf().get(0);
    }

    public Enumeration<BiologicallyDerivedProductDispenseCodes> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create BiologicallyDerivedProductDispense.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<BiologicallyDerivedProductDispenseCodes>(new BiologicallyDerivedProductDispenseCodesEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public BiologicallyDerivedProductDispense setStatusElement(Enumeration<BiologicallyDerivedProductDispenseCodes> value) {
        this.status = value;
        return this;
    }

    public BiologicallyDerivedProductDispenseCodes getStatus() {
        return this.status == null ? null : (BiologicallyDerivedProductDispenseCodes)((Object)this.status.getValue());
    }

    public BiologicallyDerivedProductDispense setStatus(BiologicallyDerivedProductDispenseCodes value) {
        if (this.status == null) {
            this.status = new Enumeration<BiologicallyDerivedProductDispenseCodes>(new BiologicallyDerivedProductDispenseCodesEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public CodeableConcept getOriginRelationshipType() {
        if (this.originRelationshipType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create BiologicallyDerivedProductDispense.originRelationshipType");
            }
            if (Configuration.doAutoCreate()) {
                this.originRelationshipType = new CodeableConcept();
            }
        }
        return this.originRelationshipType;
    }

    public boolean hasOriginRelationshipType() {
        return this.originRelationshipType != null && !this.originRelationshipType.isEmpty();
    }

    public BiologicallyDerivedProductDispense setOriginRelationshipType(CodeableConcept value) {
        this.originRelationshipType = value;
        return this;
    }

    public Reference getProduct() {
        if (this.product == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create BiologicallyDerivedProductDispense.product");
            }
            if (Configuration.doAutoCreate()) {
                this.product = new Reference();
            }
        }
        return this.product;
    }

    public boolean hasProduct() {
        return this.product != null && !this.product.isEmpty();
    }

    public BiologicallyDerivedProductDispense setProduct(Reference value) {
        this.product = value;
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create BiologicallyDerivedProductDispense.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public BiologicallyDerivedProductDispense setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public CodeableConcept getMatchStatus() {
        if (this.matchStatus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create BiologicallyDerivedProductDispense.matchStatus");
            }
            if (Configuration.doAutoCreate()) {
                this.matchStatus = new CodeableConcept();
            }
        }
        return this.matchStatus;
    }

    public boolean hasMatchStatus() {
        return this.matchStatus != null && !this.matchStatus.isEmpty();
    }

    public BiologicallyDerivedProductDispense setMatchStatus(CodeableConcept value) {
        this.matchStatus = value;
        return this;
    }

    public List<BiologicallyDerivedProductDispensePerformerComponent> getPerformer() {
        if (this.performer == null) {
            this.performer = new ArrayList<BiologicallyDerivedProductDispensePerformerComponent>();
        }
        return this.performer;
    }

    public BiologicallyDerivedProductDispense setPerformer(List<BiologicallyDerivedProductDispensePerformerComponent> thePerformer) {
        this.performer = thePerformer;
        return this;
    }

    public boolean hasPerformer() {
        if (this.performer == null) {
            return false;
        }
        for (BiologicallyDerivedProductDispensePerformerComponent item : this.performer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public BiologicallyDerivedProductDispensePerformerComponent addPerformer() {
        BiologicallyDerivedProductDispensePerformerComponent t = new BiologicallyDerivedProductDispensePerformerComponent();
        if (this.performer == null) {
            this.performer = new ArrayList<BiologicallyDerivedProductDispensePerformerComponent>();
        }
        this.performer.add(t);
        return t;
    }

    public BiologicallyDerivedProductDispense addPerformer(BiologicallyDerivedProductDispensePerformerComponent t) {
        if (t == null) {
            return this;
        }
        if (this.performer == null) {
            this.performer = new ArrayList<BiologicallyDerivedProductDispensePerformerComponent>();
        }
        this.performer.add(t);
        return this;
    }

    public BiologicallyDerivedProductDispensePerformerComponent getPerformerFirstRep() {
        if (this.getPerformer().isEmpty()) {
            this.addPerformer();
        }
        return this.getPerformer().get(0);
    }

    public Reference getLocation() {
        if (this.location == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create BiologicallyDerivedProductDispense.location");
            }
            if (Configuration.doAutoCreate()) {
                this.location = new Reference();
            }
        }
        return this.location;
    }

    public boolean hasLocation() {
        return this.location != null && !this.location.isEmpty();
    }

    public BiologicallyDerivedProductDispense setLocation(Reference value) {
        this.location = value;
        return this;
    }

    public Quantity getQuantity() {
        if (this.quantity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create BiologicallyDerivedProductDispense.quantity");
            }
            if (Configuration.doAutoCreate()) {
                this.quantity = new Quantity();
            }
        }
        return this.quantity;
    }

    public boolean hasQuantity() {
        return this.quantity != null && !this.quantity.isEmpty();
    }

    public BiologicallyDerivedProductDispense setQuantity(Quantity value) {
        this.quantity = value;
        return this;
    }

    public DateTimeType getPreparedDateElement() {
        if (this.preparedDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create BiologicallyDerivedProductDispense.preparedDate");
            }
            if (Configuration.doAutoCreate()) {
                this.preparedDate = new DateTimeType();
            }
        }
        return this.preparedDate;
    }

    public boolean hasPreparedDateElement() {
        return this.preparedDate != null && !this.preparedDate.isEmpty();
    }

    public boolean hasPreparedDate() {
        return this.preparedDate != null && !this.preparedDate.isEmpty();
    }

    public BiologicallyDerivedProductDispense setPreparedDateElement(DateTimeType value) {
        this.preparedDate = value;
        return this;
    }

    public Date getPreparedDate() {
        return this.preparedDate == null ? null : (Date)this.preparedDate.getValue();
    }

    public BiologicallyDerivedProductDispense setPreparedDate(Date value) {
        if (value == null) {
            this.preparedDate = null;
        } else {
            if (this.preparedDate == null) {
                this.preparedDate = new DateTimeType();
            }
            this.preparedDate.setValue(value);
        }
        return this;
    }

    public DateTimeType getWhenHandedOverElement() {
        if (this.whenHandedOver == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create BiologicallyDerivedProductDispense.whenHandedOver");
            }
            if (Configuration.doAutoCreate()) {
                this.whenHandedOver = new DateTimeType();
            }
        }
        return this.whenHandedOver;
    }

    public boolean hasWhenHandedOverElement() {
        return this.whenHandedOver != null && !this.whenHandedOver.isEmpty();
    }

    public boolean hasWhenHandedOver() {
        return this.whenHandedOver != null && !this.whenHandedOver.isEmpty();
    }

    public BiologicallyDerivedProductDispense setWhenHandedOverElement(DateTimeType value) {
        this.whenHandedOver = value;
        return this;
    }

    public Date getWhenHandedOver() {
        return this.whenHandedOver == null ? null : (Date)this.whenHandedOver.getValue();
    }

    public BiologicallyDerivedProductDispense setWhenHandedOver(Date value) {
        if (value == null) {
            this.whenHandedOver = null;
        } else {
            if (this.whenHandedOver == null) {
                this.whenHandedOver = new DateTimeType();
            }
            this.whenHandedOver.setValue(value);
        }
        return this;
    }

    public Reference getDestination() {
        if (this.destination == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create BiologicallyDerivedProductDispense.destination");
            }
            if (Configuration.doAutoCreate()) {
                this.destination = new Reference();
            }
        }
        return this.destination;
    }

    public boolean hasDestination() {
        return this.destination != null && !this.destination.isEmpty();
    }

    public BiologicallyDerivedProductDispense setDestination(Reference value) {
        this.destination = value;
        return this;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public BiologicallyDerivedProductDispense setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public BiologicallyDerivedProductDispense addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public StringType getUsageInstructionElement() {
        if (this.usageInstruction == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create BiologicallyDerivedProductDispense.usageInstruction");
            }
            if (Configuration.doAutoCreate()) {
                this.usageInstruction = new StringType();
            }
        }
        return this.usageInstruction;
    }

    public boolean hasUsageInstructionElement() {
        return this.usageInstruction != null && !this.usageInstruction.isEmpty();
    }

    public boolean hasUsageInstruction() {
        return this.usageInstruction != null && !this.usageInstruction.isEmpty();
    }

    public BiologicallyDerivedProductDispense setUsageInstructionElement(StringType value) {
        this.usageInstruction = value;
        return this;
    }

    public String getUsageInstruction() {
        return this.usageInstruction == null ? null : (String)this.usageInstruction.getValue();
    }

    public BiologicallyDerivedProductDispense setUsageInstruction(String value) {
        if (Utilities.noString((String)value)) {
            this.usageInstruction = null;
        } else {
            if (this.usageInstruction == null) {
                this.usageInstruction = new StringType();
            }
            this.usageInstruction.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Unique instance identifiers assigned to a biologically derived product dispense. Note: This is a business identifier, not a resource identifier.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("basedOn", "Reference(ServiceRequest)", "The order or request that the dispense is fulfilling. This is a reference to a ServiceRequest resource.", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property("partOf", "Reference(BiologicallyDerivedProductDispense)", "A larger event of which this particular event is a component.", 0, Integer.MAX_VALUE, this.partOf));
        children.add(new Property(SP_STATUS, "code", "A code specifying the state of the dispense event.", 0, 1, this.status));
        children.add(new Property("originRelationshipType", "CodeableConcept", "Indicates the relationship between the donor of the biologically derived product and the intended recipient.", 0, 1, this.originRelationshipType));
        children.add(new Property(SP_PRODUCT, "Reference(BiologicallyDerivedProduct)", "A link to a resource identifying the biologically derived product that is being dispensed.", 0, 1, this.product));
        children.add(new Property(SP_PATIENT, "Reference(Patient)", "A link to a resource representing the patient that the product is dispensed for.", 0, 1, this.patient));
        children.add(new Property("matchStatus", "CodeableConcept", "Indicates the type of matching associated with the dispense.", 0, 1, this.matchStatus));
        children.add(new Property(SP_PERFORMER, "", "Indicates who or what performed an action.", 0, Integer.MAX_VALUE, this.performer));
        children.add(new Property("location", "Reference(Location)", "The physical location where the dispense was performed.", 0, 1, this.location));
        children.add(new Property("quantity", "Quantity", "The amount of product in the dispense. Quantity will depend on the product being dispensed. Examples are: volume; cell count; concentration.", 0, 1, this.quantity));
        children.add(new Property("preparedDate", "dateTime", "When the product was selected/ matched.", 0, 1, this.preparedDate));
        children.add(new Property("whenHandedOver", "dateTime", "When the product was dispatched for clinical use.", 0, 1, this.whenHandedOver));
        children.add(new Property("destination", "Reference(Location)", "Link to a resource identifying the physical location that the product was dispatched to.", 0, 1, this.destination));
        children.add(new Property("note", "Annotation", "Additional notes.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("usageInstruction", "string", "Specific instructions for use.", 0, 1, this.usageInstruction));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Unique instance identifiers assigned to a biologically derived product dispense. Note: This is a business identifier, not a resource identifier.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(ServiceRequest)", "The order or request that the dispense is fulfilling. This is a reference to a ServiceRequest resource.", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case -995410646: {
                return new Property("partOf", "Reference(BiologicallyDerivedProductDispense)", "A larger event of which this particular event is a component.", 0, Integer.MAX_VALUE, this.partOf);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "A code specifying the state of the dispense event.", 0, 1, this.status);
            }
            case 1746240728: {
                return new Property("originRelationshipType", "CodeableConcept", "Indicates the relationship between the donor of the biologically derived product and the intended recipient.", 0, 1, this.originRelationshipType);
            }
            case -309474065: {
                return new Property(SP_PRODUCT, "Reference(BiologicallyDerivedProduct)", "A link to a resource identifying the biologically derived product that is being dispensed.", 0, 1, this.product);
            }
            case -791418107: {
                return new Property(SP_PATIENT, "Reference(Patient)", "A link to a resource representing the patient that the product is dispensed for.", 0, 1, this.patient);
            }
            case 1644523031: {
                return new Property("matchStatus", "CodeableConcept", "Indicates the type of matching associated with the dispense.", 0, 1, this.matchStatus);
            }
            case 481140686: {
                return new Property(SP_PERFORMER, "", "Indicates who or what performed an action.", 0, Integer.MAX_VALUE, this.performer);
            }
            case 1901043637: {
                return new Property("location", "Reference(Location)", "The physical location where the dispense was performed.", 0, 1, this.location);
            }
            case -1285004149: {
                return new Property("quantity", "Quantity", "The amount of product in the dispense. Quantity will depend on the product being dispensed. Examples are: volume; cell count; concentration.", 0, 1, this.quantity);
            }
            case -2024959605: {
                return new Property("preparedDate", "dateTime", "When the product was selected/ matched.", 0, 1, this.preparedDate);
            }
            case -940241380: {
                return new Property("whenHandedOver", "dateTime", "When the product was dispatched for clinical use.", 0, 1, this.whenHandedOver);
            }
            case -1429847026: {
                return new Property("destination", "Reference(Location)", "Link to a resource identifying the physical location that the product was dispatched to.", 0, 1, this.destination);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Additional notes.", 0, Integer.MAX_VALUE, this.note);
            }
            case 2138372141: {
                return new Property("usageInstruction", "string", "Specific instructions for use.", 0, 1, this.usageInstruction);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -995410646: {
                return this.partOf == null ? new Base[]{} : this.partOf.toArray(new Base[this.partOf.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 1746240728: {
                Base[] baseArray;
                if (this.originRelationshipType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.originRelationshipType;
                }
                return baseArray;
            }
            case -309474065: {
                Base[] baseArray;
                if (this.product == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.product;
                }
                return baseArray;
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.patient;
                }
                return baseArray;
            }
            case 1644523031: {
                Base[] baseArray;
                if (this.matchStatus == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.matchStatus;
                }
                return baseArray;
            }
            case 481140686: {
                return this.performer == null ? new Base[]{} : this.performer.toArray(new Base[this.performer.size()]);
            }
            case 1901043637: {
                Base[] baseArray;
                if (this.location == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.location;
                }
                return baseArray;
            }
            case -1285004149: {
                Base[] baseArray;
                if (this.quantity == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.quantity;
                }
                return baseArray;
            }
            case -2024959605: {
                Base[] baseArray;
                if (this.preparedDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.preparedDate;
                }
                return baseArray;
            }
            case -940241380: {
                Base[] baseArray;
                if (this.whenHandedOver == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.whenHandedOver;
                }
                return baseArray;
            }
            case -1429847026: {
                Base[] baseArray;
                if (this.destination == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.destination;
                }
                return baseArray;
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case 2138372141: {
                Base[] baseArray;
                if (this.usageInstruction == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.usageInstruction;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -995410646: {
                this.getPartOf().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -892481550: {
                value = new BiologicallyDerivedProductDispenseCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 1746240728: {
                this.originRelationshipType = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -309474065: {
                this.product = TypeConvertor.castToReference(value);
                return value;
            }
            case -791418107: {
                this.patient = TypeConvertor.castToReference(value);
                return value;
            }
            case 1644523031: {
                this.matchStatus = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 481140686: {
                this.getPerformer().add((BiologicallyDerivedProductDispensePerformerComponent)((Object)value));
                return value;
            }
            case 1901043637: {
                this.location = TypeConvertor.castToReference(value);
                return value;
            }
            case -1285004149: {
                this.quantity = TypeConvertor.castToQuantity(value);
                return value;
            }
            case -2024959605: {
                this.preparedDate = TypeConvertor.castToDateTime(value);
                return value;
            }
            case -940241380: {
                this.whenHandedOver = TypeConvertor.castToDateTime(value);
                return value;
            }
            case -1429847026: {
                this.destination = TypeConvertor.castToReference(value);
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
            case 2138372141: {
                this.usageInstruction = TypeConvertor.castToString(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(TypeConvertor.castToReference(value));
        } else if (name.equals("partOf")) {
            this.getPartOf().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_STATUS)) {
            value = new BiologicallyDerivedProductDispenseCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("originRelationshipType")) {
            this.originRelationshipType = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_PRODUCT)) {
            this.product = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_PATIENT)) {
            this.patient = TypeConvertor.castToReference(value);
        } else if (name.equals("matchStatus")) {
            this.matchStatus = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_PERFORMER)) {
            this.getPerformer().add((BiologicallyDerivedProductDispensePerformerComponent)((Object)value));
        } else if (name.equals("location")) {
            this.location = TypeConvertor.castToReference(value);
        } else if (name.equals("quantity")) {
            this.quantity = TypeConvertor.castToQuantity(value);
        } else if (name.equals("preparedDate")) {
            this.preparedDate = TypeConvertor.castToDateTime(value);
        } else if (name.equals("whenHandedOver")) {
            this.whenHandedOver = TypeConvertor.castToDateTime(value);
        } else if (name.equals("destination")) {
            this.destination = TypeConvertor.castToReference(value);
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else if (name.equals("usageInstruction")) {
            this.usageInstruction = TypeConvertor.castToString(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(value);
        } else if (name.equals("basedOn")) {
            this.getBasedOn().remove(value);
        } else if (name.equals("partOf")) {
            this.getPartOf().remove(value);
        } else if (name.equals(SP_STATUS)) {
            value = new BiologicallyDerivedProductDispenseCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("originRelationshipType")) {
            this.originRelationshipType = null;
        } else if (name.equals(SP_PRODUCT)) {
            this.product = null;
        } else if (name.equals(SP_PATIENT)) {
            this.patient = null;
        } else if (name.equals("matchStatus")) {
            this.matchStatus = null;
        } else if (name.equals(SP_PERFORMER)) {
            this.getPerformer().remove((BiologicallyDerivedProductDispensePerformerComponent)((Object)value));
        } else if (name.equals("location")) {
            this.location = null;
        } else if (name.equals("quantity")) {
            this.quantity = null;
        } else if (name.equals("preparedDate")) {
            this.preparedDate = null;
        } else if (name.equals("whenHandedOver")) {
            this.whenHandedOver = null;
        } else if (name.equals("destination")) {
            this.destination = null;
        } else if (name.equals("note")) {
            this.getNote().remove(value);
        } else if (name.equals("usageInstruction")) {
            this.usageInstruction = null;
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -995410646: {
                return this.addPartOf();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 1746240728: {
                return this.getOriginRelationshipType();
            }
            case -309474065: {
                return this.getProduct();
            }
            case -791418107: {
                return this.getPatient();
            }
            case 1644523031: {
                return this.getMatchStatus();
            }
            case 481140686: {
                return this.addPerformer();
            }
            case 1901043637: {
                return this.getLocation();
            }
            case -1285004149: {
                return this.getQuantity();
            }
            case -2024959605: {
                return this.getPreparedDateElement();
            }
            case -940241380: {
                return this.getWhenHandedOverElement();
            }
            case -1429847026: {
                return this.getDestination();
            }
            case 3387378: {
                return this.addNote();
            }
            case 2138372141: {
                return this.getUsageInstructionElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -995410646: {
                return new String[]{"Reference"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 1746240728: {
                return new String[]{"CodeableConcept"};
            }
            case -309474065: {
                return new String[]{"Reference"};
            }
            case -791418107: {
                return new String[]{"Reference"};
            }
            case 1644523031: {
                return new String[]{"CodeableConcept"};
            }
            case 481140686: {
                return new String[0];
            }
            case 1901043637: {
                return new String[]{"Reference"};
            }
            case -1285004149: {
                return new String[]{"Quantity"};
            }
            case -2024959605: {
                return new String[]{"dateTime"};
            }
            case -940241380: {
                return new String[]{"dateTime"};
            }
            case -1429847026: {
                return new String[]{"Reference"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case 2138372141: {
                return new String[]{"string"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals("partOf")) {
            return this.addPartOf();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property BiologicallyDerivedProductDispense.status");
        }
        if (name.equals("originRelationshipType")) {
            this.originRelationshipType = new CodeableConcept();
            return this.originRelationshipType;
        }
        if (name.equals(SP_PRODUCT)) {
            this.product = new Reference();
            return this.product;
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals("matchStatus")) {
            this.matchStatus = new CodeableConcept();
            return this.matchStatus;
        }
        if (name.equals(SP_PERFORMER)) {
            return this.addPerformer();
        }
        if (name.equals("location")) {
            this.location = new Reference();
            return this.location;
        }
        if (name.equals("quantity")) {
            this.quantity = new Quantity();
            return this.quantity;
        }
        if (name.equals("preparedDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property BiologicallyDerivedProductDispense.preparedDate");
        }
        if (name.equals("whenHandedOver")) {
            throw new FHIRException("Cannot call addChild on a singleton property BiologicallyDerivedProductDispense.whenHandedOver");
        }
        if (name.equals("destination")) {
            this.destination = new Reference();
            return this.destination;
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("usageInstruction")) {
            throw new FHIRException("Cannot call addChild on a singleton property BiologicallyDerivedProductDispense.usageInstruction");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "BiologicallyDerivedProductDispense";
    }

    @Override
    public BiologicallyDerivedProductDispense copy() {
        BiologicallyDerivedProductDispense dst = new BiologicallyDerivedProductDispense();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(BiologicallyDerivedProductDispense dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        if (this.partOf != null) {
            dst.partOf = new ArrayList<Reference>();
            for (Reference reference : this.partOf) {
                dst.partOf.add(reference.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.originRelationshipType = this.originRelationshipType == null ? null : this.originRelationshipType.copy();
        dst.product = this.product == null ? null : this.product.copy();
        dst.patient = this.patient == null ? null : this.patient.copy();
        CodeableConcept codeableConcept = dst.matchStatus = this.matchStatus == null ? null : this.matchStatus.copy();
        if (this.performer != null) {
            dst.performer = new ArrayList<BiologicallyDerivedProductDispensePerformerComponent>();
            for (BiologicallyDerivedProductDispensePerformerComponent biologicallyDerivedProductDispensePerformerComponent : this.performer) {
                dst.performer.add(biologicallyDerivedProductDispensePerformerComponent.copy());
            }
        }
        dst.location = this.location == null ? null : this.location.copy();
        dst.quantity = this.quantity == null ? null : this.quantity.copy();
        dst.preparedDate = this.preparedDate == null ? null : this.preparedDate.copy();
        dst.whenHandedOver = this.whenHandedOver == null ? null : this.whenHandedOver.copy();
        Reference reference = dst.destination = this.destination == null ? null : this.destination.copy();
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        dst.usageInstruction = this.usageInstruction == null ? null : this.usageInstruction.copy();
    }

    protected BiologicallyDerivedProductDispense typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof BiologicallyDerivedProductDispense)) {
            return false;
        }
        BiologicallyDerivedProductDispense o = (BiologicallyDerivedProductDispense)other_;
        return BiologicallyDerivedProductDispense.compareDeep(this.identifier, o.identifier, true) && BiologicallyDerivedProductDispense.compareDeep(this.basedOn, o.basedOn, true) && BiologicallyDerivedProductDispense.compareDeep(this.partOf, o.partOf, true) && BiologicallyDerivedProductDispense.compareDeep(this.status, o.status, true) && BiologicallyDerivedProductDispense.compareDeep(this.originRelationshipType, o.originRelationshipType, true) && BiologicallyDerivedProductDispense.compareDeep(this.product, o.product, true) && BiologicallyDerivedProductDispense.compareDeep(this.patient, o.patient, true) && BiologicallyDerivedProductDispense.compareDeep(this.matchStatus, o.matchStatus, true) && BiologicallyDerivedProductDispense.compareDeep(this.performer, o.performer, true) && BiologicallyDerivedProductDispense.compareDeep(this.location, o.location, true) && BiologicallyDerivedProductDispense.compareDeep(this.quantity, o.quantity, true) && BiologicallyDerivedProductDispense.compareDeep(this.preparedDate, o.preparedDate, true) && BiologicallyDerivedProductDispense.compareDeep(this.whenHandedOver, o.whenHandedOver, true) && BiologicallyDerivedProductDispense.compareDeep(this.destination, o.destination, true) && BiologicallyDerivedProductDispense.compareDeep(this.note, o.note, true) && BiologicallyDerivedProductDispense.compareDeep(this.usageInstruction, o.usageInstruction, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof BiologicallyDerivedProductDispense)) {
            return false;
        }
        BiologicallyDerivedProductDispense o = (BiologicallyDerivedProductDispense)other_;
        return BiologicallyDerivedProductDispense.compareValues(this.status, o.status, true) && BiologicallyDerivedProductDispense.compareValues(this.preparedDate, o.preparedDate, true) && BiologicallyDerivedProductDispense.compareValues(this.whenHandedOver, o.whenHandedOver, true) && BiologicallyDerivedProductDispense.compareValues(this.usageInstruction, o.usageInstruction, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.basedOn, this.partOf, this.status, this.originRelationshipType, this.product, this.patient, this.matchStatus, this.performer, this.location, this.quantity, this.preparedDate, this.whenHandedOver, this.destination, this.note, this.usageInstruction});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.BiologicallyDerivedProductDispense;
    }

    @Block
    public static class BiologicallyDerivedProductDispensePerformerComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="function", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Identifies the function of the performer during the dispense", formalDefinition="Identifies the function of the performer during the dispense.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/biologicallyderivedproductdispense-performer-function")
        protected CodeableConcept function;
        @Child(name="actor", type={Practitioner.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Who performed the action", formalDefinition="Identifies the person responsible for the action.")
        protected Reference actor;
        private static final long serialVersionUID = -576943815L;

        public BiologicallyDerivedProductDispensePerformerComponent() {
        }

        public BiologicallyDerivedProductDispensePerformerComponent(Reference actor) {
            this.setActor(actor);
        }

        public CodeableConcept getFunction() {
            if (this.function == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BiologicallyDerivedProductDispensePerformerComponent.function");
                }
                if (Configuration.doAutoCreate()) {
                    this.function = new CodeableConcept();
                }
            }
            return this.function;
        }

        public boolean hasFunction() {
            return this.function != null && !this.function.isEmpty();
        }

        public BiologicallyDerivedProductDispensePerformerComponent setFunction(CodeableConcept value) {
            this.function = value;
            return this;
        }

        public Reference getActor() {
            if (this.actor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BiologicallyDerivedProductDispensePerformerComponent.actor");
                }
                if (Configuration.doAutoCreate()) {
                    this.actor = new Reference();
                }
            }
            return this.actor;
        }

        public boolean hasActor() {
            return this.actor != null && !this.actor.isEmpty();
        }

        public BiologicallyDerivedProductDispensePerformerComponent setActor(Reference value) {
            this.actor = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("function", "CodeableConcept", "Identifies the function of the performer during the dispense.", 0, 1, this.function));
            children.add(new Property("actor", "Reference(Practitioner)", "Identifies the person responsible for the action.", 0, 1, this.actor));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1380938712: {
                    return new Property("function", "CodeableConcept", "Identifies the function of the performer during the dispense.", 0, 1, this.function);
                }
                case 92645877: {
                    return new Property("actor", "Reference(Practitioner)", "Identifies the person responsible for the action.", 0, 1, this.actor);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    Base[] baseArray;
                    if (this.function == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.function;
                    }
                    return baseArray;
                }
                case 92645877: {
                    Base[] baseArray;
                    if (this.actor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.actor;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    this.function = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 92645877: {
                    this.actor = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("function")) {
                this.function = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("actor")) {
                this.actor = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("function")) {
                this.function = null;
            } else if (name.equals("actor")) {
                this.actor = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    return this.getFunction();
                }
                case 92645877: {
                    return this.getActor();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    return new String[]{"CodeableConcept"};
                }
                case 92645877: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("function")) {
                this.function = new CodeableConcept();
                return this.function;
            }
            if (name.equals("actor")) {
                this.actor = new Reference();
                return this.actor;
            }
            return super.addChild(name);
        }

        @Override
        public BiologicallyDerivedProductDispensePerformerComponent copy() {
            BiologicallyDerivedProductDispensePerformerComponent dst = new BiologicallyDerivedProductDispensePerformerComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(BiologicallyDerivedProductDispensePerformerComponent dst) {
            super.copyValues(dst);
            dst.function = this.function == null ? null : this.function.copy();
            dst.actor = this.actor == null ? null : this.actor.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof BiologicallyDerivedProductDispensePerformerComponent)) {
                return false;
            }
            BiologicallyDerivedProductDispensePerformerComponent o = (BiologicallyDerivedProductDispensePerformerComponent)other_;
            return BiologicallyDerivedProductDispensePerformerComponent.compareDeep(this.function, o.function, true) && BiologicallyDerivedProductDispensePerformerComponent.compareDeep(this.actor, o.actor, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof BiologicallyDerivedProductDispensePerformerComponent)) {
                return false;
            }
            BiologicallyDerivedProductDispensePerformerComponent o = (BiologicallyDerivedProductDispensePerformerComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.function, this.actor});
        }

        @Override
        public String fhirType() {
            return "BiologicallyDerivedProductDispense.performer";
        }
    }

    public static class BiologicallyDerivedProductDispenseCodesEnumFactory
    implements EnumFactory<BiologicallyDerivedProductDispenseCodes> {
        @Override
        public BiologicallyDerivedProductDispenseCodes fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("preparation".equals(codeString)) {
                return BiologicallyDerivedProductDispenseCodes.PREPARATION;
            }
            if ("in-progress".equals(codeString)) {
                return BiologicallyDerivedProductDispenseCodes.INPROGRESS;
            }
            if ("allocated".equals(codeString)) {
                return BiologicallyDerivedProductDispenseCodes.ALLOCATED;
            }
            if ("issued".equals(codeString)) {
                return BiologicallyDerivedProductDispenseCodes.ISSUED;
            }
            if ("unfulfilled".equals(codeString)) {
                return BiologicallyDerivedProductDispenseCodes.UNFULFILLED;
            }
            if ("returned".equals(codeString)) {
                return BiologicallyDerivedProductDispenseCodes.RETURNED;
            }
            if ("entered-in-error".equals(codeString)) {
                return BiologicallyDerivedProductDispenseCodes.ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return BiologicallyDerivedProductDispenseCodes.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown BiologicallyDerivedProductDispenseCodes code '" + codeString + "'");
        }

        public Enumeration<BiologicallyDerivedProductDispenseCodes> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<BiologicallyDerivedProductDispenseCodes>(this, BiologicallyDerivedProductDispenseCodes.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<BiologicallyDerivedProductDispenseCodes>(this, BiologicallyDerivedProductDispenseCodes.NULL, code);
            }
            if ("preparation".equals(codeString)) {
                return new Enumeration<BiologicallyDerivedProductDispenseCodes>(this, BiologicallyDerivedProductDispenseCodes.PREPARATION, code);
            }
            if ("in-progress".equals(codeString)) {
                return new Enumeration<BiologicallyDerivedProductDispenseCodes>(this, BiologicallyDerivedProductDispenseCodes.INPROGRESS, code);
            }
            if ("allocated".equals(codeString)) {
                return new Enumeration<BiologicallyDerivedProductDispenseCodes>(this, BiologicallyDerivedProductDispenseCodes.ALLOCATED, code);
            }
            if ("issued".equals(codeString)) {
                return new Enumeration<BiologicallyDerivedProductDispenseCodes>(this, BiologicallyDerivedProductDispenseCodes.ISSUED, code);
            }
            if ("unfulfilled".equals(codeString)) {
                return new Enumeration<BiologicallyDerivedProductDispenseCodes>(this, BiologicallyDerivedProductDispenseCodes.UNFULFILLED, code);
            }
            if ("returned".equals(codeString)) {
                return new Enumeration<BiologicallyDerivedProductDispenseCodes>(this, BiologicallyDerivedProductDispenseCodes.RETURNED, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<BiologicallyDerivedProductDispenseCodes>(this, BiologicallyDerivedProductDispenseCodes.ENTEREDINERROR, code);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<BiologicallyDerivedProductDispenseCodes>(this, BiologicallyDerivedProductDispenseCodes.UNKNOWN, code);
            }
            throw new FHIRException("Unknown BiologicallyDerivedProductDispenseCodes code '" + codeString + "'");
        }

        @Override
        public String toCode(BiologicallyDerivedProductDispenseCodes code) {
            if (code == BiologicallyDerivedProductDispenseCodes.PREPARATION) {
                return "preparation";
            }
            if (code == BiologicallyDerivedProductDispenseCodes.INPROGRESS) {
                return "in-progress";
            }
            if (code == BiologicallyDerivedProductDispenseCodes.ALLOCATED) {
                return "allocated";
            }
            if (code == BiologicallyDerivedProductDispenseCodes.ISSUED) {
                return "issued";
            }
            if (code == BiologicallyDerivedProductDispenseCodes.UNFULFILLED) {
                return "unfulfilled";
            }
            if (code == BiologicallyDerivedProductDispenseCodes.RETURNED) {
                return "returned";
            }
            if (code == BiologicallyDerivedProductDispenseCodes.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == BiologicallyDerivedProductDispenseCodes.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(BiologicallyDerivedProductDispenseCodes code) {
            return code.getSystem();
        }
    }

    public static enum BiologicallyDerivedProductDispenseCodes {
        PREPARATION,
        INPROGRESS,
        ALLOCATED,
        ISSUED,
        UNFULFILLED,
        RETURNED,
        ENTEREDINERROR,
        UNKNOWN,
        NULL;


        public static BiologicallyDerivedProductDispenseCodes fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("preparation".equals(codeString)) {
                return PREPARATION;
            }
            if ("in-progress".equals(codeString)) {
                return INPROGRESS;
            }
            if ("allocated".equals(codeString)) {
                return ALLOCATED;
            }
            if ("issued".equals(codeString)) {
                return ISSUED;
            }
            if ("unfulfilled".equals(codeString)) {
                return UNFULFILLED;
            }
            if ("returned".equals(codeString)) {
                return RETURNED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown BiologicallyDerivedProductDispenseCodes code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PREPARATION: {
                    return "preparation";
                }
                case INPROGRESS: {
                    return "in-progress";
                }
                case ALLOCATED: {
                    return "allocated";
                }
                case ISSUED: {
                    return "issued";
                }
                case UNFULFILLED: {
                    return "unfulfilled";
                }
                case RETURNED: {
                    return "returned";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case UNKNOWN: {
                    return "unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PREPARATION: {
                    return "http://hl7.org/fhir/biologicallyderivedproductdispense-status";
                }
                case INPROGRESS: {
                    return "http://hl7.org/fhir/biologicallyderivedproductdispense-status";
                }
                case ALLOCATED: {
                    return "http://hl7.org/fhir/biologicallyderivedproductdispense-status";
                }
                case ISSUED: {
                    return "http://hl7.org/fhir/biologicallyderivedproductdispense-status";
                }
                case UNFULFILLED: {
                    return "http://hl7.org/fhir/biologicallyderivedproductdispense-status";
                }
                case RETURNED: {
                    return "http://hl7.org/fhir/biologicallyderivedproductdispense-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/biologicallyderivedproductdispense-status";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/biologicallyderivedproductdispense-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PREPARATION: {
                    return "The dispense process has started but not yet completed.";
                }
                case INPROGRESS: {
                    return "The dispense process is in progress.";
                }
                case ALLOCATED: {
                    return "The requested product has been allocated and is ready for transport.";
                }
                case ISSUED: {
                    return "The dispensed product has been picked up.";
                }
                case UNFULFILLED: {
                    return "The dispense could not be completed.";
                }
                case RETURNED: {
                    return "The dispensed product was returned.";
                }
                case ENTEREDINERROR: {
                    return "The dispense was entered in error and therefore nullified.";
                }
                case UNKNOWN: {
                    return "The authoring system does not know which of the status values applies for this dispense. Note: this concept is not to be used for other - one of the listed statuses is presumed to apply, it's just not known which one.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PREPARATION: {
                    return "Preparation";
                }
                case INPROGRESS: {
                    return "In Progress";
                }
                case ALLOCATED: {
                    return "Allocated";
                }
                case ISSUED: {
                    return "Issued";
                }
                case UNFULFILLED: {
                    return "Unfulfilled";
                }
                case RETURNED: {
                    return "Returned";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

