/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.ArtifactAssessment;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.MetadataResource;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.PositiveIntType;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Citation", profile="http://hl7.org/fhir/StructureDefinition/Citation")
public class Citation
extends MetadataResource {
    @Child(name="url", type={UriType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Canonical identifier for this citation record, represented as a globally unique URI", formalDefinition="An absolute URI that is used to identify this citation record when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which an authoritative instance of this summary is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the summary is stored on different servers.")
    protected UriType url;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Identifier for the citation record itself", formalDefinition="A formal identifier that is used to identify this citation record when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected List<Identifier> identifier;
    @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business version of the citation record", formalDefinition="The identifier that is used to identify this version of the citation record when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the citation record author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.")
    protected StringType version;
    @Child(name="versionAlgorithm", type={StringType.class, Coding.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="How to compare versions", formalDefinition="Indicates the mechanism used to compare versions to determine which is more current.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/version-algorithm")
    protected DataType versionAlgorithm;
    @Child(name="name", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this citation record (computer friendly)", formalDefinition="A natural language name identifying the citation record. This name should be usable as an identifier for the module by machine processing applications such as code generation.")
    protected StringType name;
    @Child(name="title", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this citation record (human friendly)", formalDefinition="A short, descriptive, user-friendly title for the citation record.")
    protected StringType title;
    @Child(name="status", type={CodeType.class}, order=6, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired | unknown", formalDefinition="The status of this summary. Enables tracking the life-cycle of the content.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected Enumeration<Enumerations.PublicationStatus> status;
    @Child(name="experimental", type={BooleanType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="For testing purposes, not real usage", formalDefinition="A Boolean value to indicate that this citation record is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.")
    protected BooleanType experimental;
    @Child(name="date", type={DateTimeType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date last changed", formalDefinition="The date (and optionally time) when the citation record was last significantly changed. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the citation record changes.")
    protected DateTimeType date;
    @Child(name="publisher", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The publisher of the citation record, not the publisher of the article or artifact being cited", formalDefinition="The name of the organization or individual that published the citation record.")
    protected StringType publisher;
    @Child(name="contact", type={ContactDetail.class}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details for the publisher of the citation record", formalDefinition="Contact details to assist a user in finding and communicating with the publisher.")
    protected List<ContactDetail> contact;
    @Child(name="description", type={MarkdownType.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Natural language description of the citation", formalDefinition="A free text natural language description of the citation from a consumer's perspective.")
    protected MarkdownType description;
    @Child(name="useContext", type={UsageContext.class}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The context that the citation record content is intended to support", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate citation record instances.")
    protected List<UsageContext> useContext;
    @Child(name="jurisdiction", type={CodeableConcept.class}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Intended jurisdiction for citation record (if applicable)", formalDefinition="A legal or geographic region in which the citation record is intended to be used.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    protected List<CodeableConcept> jurisdiction;
    @Child(name="purpose", type={MarkdownType.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why this citation is defined", formalDefinition="Explanation of why this citation is needed and why it has been designed as it has.")
    protected MarkdownType purpose;
    @Child(name="copyright", type={MarkdownType.class}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions for the citation record, not for the cited artifact", formalDefinition="Use and/or publishing restrictions for the citation record, not for the cited artifact.")
    protected MarkdownType copyright;
    @Child(name="copyrightLabel", type={StringType.class}, order=16, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Copyright holder and year(s) for the ciation record, not for the cited artifact", formalDefinition="A short string (<50 characters), suitable for inclusion in a page footer that identifies the copyright holder, effective period, and optionally whether rights are resctricted. (e.g. 'All rights reserved', 'Some rights reserved').")
    protected StringType copyrightLabel;
    @Child(name="approvalDate", type={DateType.class}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the citation record was approved by publisher", formalDefinition="The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.")
    protected DateType approvalDate;
    @Child(name="lastReviewDate", type={DateType.class}, order=18, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the citation record was last reviewed by the publisher", formalDefinition="The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.")
    protected DateType lastReviewDate;
    @Child(name="effectivePeriod", type={Period.class}, order=19, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the citation record is expected to be used", formalDefinition="The period during which the citation record content was or is planned to be in active use.")
    protected Period effectivePeriod;
    @Child(name="author", type={ContactDetail.class}, order=20, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who authored the citation record", formalDefinition="Who authored or created the citation record.")
    protected List<ContactDetail> author;
    @Child(name="editor", type={ContactDetail.class}, order=21, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who edited the citation record", formalDefinition="Who edited or revised the citation record.")
    protected List<ContactDetail> editor;
    @Child(name="reviewer", type={ContactDetail.class}, order=22, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who reviewed the citation record", formalDefinition="Who reviewed the citation record.")
    protected List<ContactDetail> reviewer;
    @Child(name="endorser", type={ContactDetail.class}, order=23, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who endorsed the citation record", formalDefinition="Who endorsed the citation record.")
    protected List<ContactDetail> endorser;
    @Child(name="summary", type={}, order=24, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A human-readable display of key concepts to represent the citation", formalDefinition="A human-readable display of key concepts to represent the citation.")
    protected List<CitationSummaryComponent> summary;
    @Child(name="classification", type={}, order=25, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The assignment to an organizing scheme", formalDefinition="The assignment to an organizing scheme.")
    protected List<CitationClassificationComponent> classification;
    @Child(name="note", type={Annotation.class}, order=26, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Used for general notes and annotations not coded elsewhere", formalDefinition="Used for general notes and annotations not coded elsewhere.")
    protected List<Annotation> note;
    @Child(name="currentState", type={CodeableConcept.class}, order=27, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The status of the citation record", formalDefinition="The status of the citation record.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/citation-status-type")
    protected List<CodeableConcept> currentState;
    @Child(name="statusDate", type={}, order=28, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="An effective date or period for a status of the citation record", formalDefinition="The state or status of the citation record paired with an effective date or period for that state.")
    protected List<CitationStatusDateComponent> statusDate;
    @Child(name="relatedArtifact", type={RelatedArtifact.class}, order=29, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Artifact related to the citation record", formalDefinition="Artifact related to the citation record.")
    protected List<RelatedArtifact> relatedArtifact;
    @Child(name="citedArtifact", type={}, order=30, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The article or artifact being described", formalDefinition="The article or artifact being described.")
    protected CitationCitedArtifactComponent citedArtifact;
    private static final long serialVersionUID = 717016163L;
    @SearchParamDefinition(name="context-quantity", path="(ActivityDefinition.useContext.value.ofType(Quantity)) | (ActivityDefinition.useContext.value.ofType(Range)) | (ActorDefinition.useContext.value.ofType(Quantity)) | (ActorDefinition.useContext.value.ofType(Range)) | (CapabilityStatement.useContext.value.ofType(Quantity)) | (CapabilityStatement.useContext.value.ofType(Range)) | (ChargeItemDefinition.useContext.value.ofType(Quantity)) | (ChargeItemDefinition.useContext.value.ofType(Range)) | (Citation.useContext.value.ofType(Quantity)) | (Citation.useContext.value.ofType(Range)) | (CodeSystem.useContext.value.ofType(Quantity)) | (CodeSystem.useContext.value.ofType(Range)) | (CompartmentDefinition.useContext.value.ofType(Quantity)) | (CompartmentDefinition.useContext.value.ofType(Range)) | (ConceptMap.useContext.value.ofType(Quantity)) | (ConceptMap.useContext.value.ofType(Range)) | (ConditionDefinition.useContext.value.ofType(Quantity)) | (ConditionDefinition.useContext.value.ofType(Range)) | (EventDefinition.useContext.value.ofType(Quantity)) | (EventDefinition.useContext.value.ofType(Range)) | (Evidence.useContext.value.ofType(Quantity)) | (Evidence.useContext.value.ofType(Range)) | (EvidenceReport.useContext.value.ofType(Quantity)) | (EvidenceReport.useContext.value.ofType(Range)) | (EvidenceVariable.useContext.value.ofType(Quantity)) | (EvidenceVariable.useContext.value.ofType(Range)) | (ExampleScenario.useContext.value.ofType(Quantity)) | (ExampleScenario.useContext.value.ofType(Range)) | (GraphDefinition.useContext.value.ofType(Quantity)) | (GraphDefinition.useContext.value.ofType(Range)) | (ImplementationGuide.useContext.value.ofType(Quantity)) | (ImplementationGuide.useContext.value.ofType(Range)) | (Library.useContext.value.ofType(Quantity)) | (Library.useContext.value.ofType(Range)) | (Measure.useContext.value.ofType(Quantity)) | (Measure.useContext.value.ofType(Range)) | (MessageDefinition.useContext.value.ofType(Quantity)) | (MessageDefinition.useContext.value.ofType(Range)) | (NamingSystem.useContext.value.ofType(Quantity)) | (NamingSystem.useContext.value.ofType(Range)) | (OperationDefinition.useContext.value.ofType(Quantity)) | (OperationDefinition.useContext.value.ofType(Range)) | (PlanDefinition.useContext.value.ofType(Quantity)) | (PlanDefinition.useContext.value.ofType(Range)) | (Questionnaire.useContext.value.ofType(Quantity)) | (Questionnaire.useContext.value.ofType(Range)) | (Requirements.useContext.value.ofType(Quantity)) | (Requirements.useContext.value.ofType(Range)) | (SearchParameter.useContext.value.ofType(Quantity)) | (SearchParameter.useContext.value.ofType(Range)) | (StructureDefinition.useContext.value.ofType(Quantity)) | (StructureDefinition.useContext.value.ofType(Range)) | (StructureMap.useContext.value.ofType(Quantity)) | (StructureMap.useContext.value.ofType(Range)) | (TerminologyCapabilities.useContext.value.ofType(Quantity)) | (TerminologyCapabilities.useContext.value.ofType(Range)) | (TestScript.useContext.value.ofType(Quantity)) | (TestScript.useContext.value.ofType(Range)) | (ValueSet.useContext.value.ofType(Quantity)) | (ValueSet.useContext.value.ofType(Range))", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): A quantity- or range-valued use context assigned to the activity definition\r\n* [ActorDefinition](actordefinition.html): A quantity- or range-valued use context assigned to the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): A quantity- or range-valued use context assigned to the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): A quantity- or range-valued use context assigned to the charge item definition\r\n* [Citation](citation.html): A quantity- or range-valued use context assigned to the citation\r\n* [CodeSystem](codesystem.html): A quantity- or range-valued use context assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A quantity- or range-valued use context assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A quantity- or range-valued use context assigned to the concept map\r\n* [ConditionDefinition](conditiondefinition.html): A quantity- or range-valued use context assigned to the condition definition\r\n* [EventDefinition](eventdefinition.html): A quantity- or range-valued use context assigned to the event definition\r\n* [Evidence](evidence.html): A quantity- or range-valued use context assigned to the evidence\r\n* [EvidenceReport](evidencereport.html): A quantity- or range-valued use context assigned to the evidence report\r\n* [EvidenceVariable](evidencevariable.html): A quantity- or range-valued use context assigned to the evidence variable\r\n* [ExampleScenario](examplescenario.html): A quantity- or range-valued use context assigned to the example scenario\r\n* [GraphDefinition](graphdefinition.html): A quantity- or range-valued use context assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A quantity- or range-valued use context assigned to the implementation guide\r\n* [Library](library.html): A quantity- or range-valued use context assigned to the library\r\n* [Measure](measure.html): A quantity- or range-valued use context assigned to the measure\r\n* [MessageDefinition](messagedefinition.html): A quantity- or range-valued use context assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A quantity- or range-valued use context assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A quantity- or range-valued use context assigned to the operation definition\r\n* [PlanDefinition](plandefinition.html): A quantity- or range-valued use context assigned to the plan definition\r\n* [Questionnaire](questionnaire.html): A quantity- or range-valued use context assigned to the questionnaire\r\n* [Requirements](requirements.html): A quantity- or range-valued use context assigned to the requirements\r\n* [SearchParameter](searchparameter.html): A quantity- or range-valued use context assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A quantity- or range-valued use context assigned to the structure definition\r\n* [StructureMap](structuremap.html): A quantity- or range-valued use context assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A quantity- or range-valued use context assigned to the terminology capabilities\r\n* [TestScript](testscript.html): A quantity- or range-valued use context assigned to the test script\r\n* [ValueSet](valueset.html): A quantity- or range-valued use context assigned to the value set\r\n", type="quantity")
    public static final String SP_CONTEXT_QUANTITY = "context-quantity";
    public static final QuantityClientParam CONTEXT_QUANTITY = new QuantityClientParam("context-quantity");
    @SearchParamDefinition(name="context-type-quantity", path="ActivityDefinition.useContext | ActorDefinition.useContext | CapabilityStatement.useContext | ChargeItemDefinition.useContext | Citation.useContext | CodeSystem.useContext | CompartmentDefinition.useContext | ConceptMap.useContext | ConditionDefinition.useContext | EventDefinition.useContext | Evidence.useContext | EvidenceReport.useContext | EvidenceVariable.useContext | ExampleScenario.useContext | GraphDefinition.useContext | ImplementationGuide.useContext | Library.useContext | Measure.useContext | MessageDefinition.useContext | NamingSystem.useContext | OperationDefinition.useContext | PlanDefinition.useContext | Questionnaire.useContext | Requirements.useContext | SearchParameter.useContext | StructureDefinition.useContext | StructureMap.useContext | TerminologyCapabilities.useContext | TestScript.useContext | ValueSet.useContext", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): A use context type and quantity- or range-based value assigned to the activity definition\r\n* [ActorDefinition](actordefinition.html): A use context type and quantity- or range-based value assigned to the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): A use context type and quantity- or range-based value assigned to the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): A use context type and quantity- or range-based value assigned to the charge item definition\r\n* [Citation](citation.html): A use context type and quantity- or range-based value assigned to the citation\r\n* [CodeSystem](codesystem.html): A use context type and quantity- or range-based value assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A use context type and quantity- or range-based value assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A use context type and quantity- or range-based value assigned to the concept map\r\n* [ConditionDefinition](conditiondefinition.html): A use context type and quantity- or range-based value assigned to the condition definition\r\n* [EventDefinition](eventdefinition.html): A use context type and quantity- or range-based value assigned to the event definition\r\n* [Evidence](evidence.html): A use context type and quantity- or range-based value assigned to the evidence\r\n* [EvidenceReport](evidencereport.html): A use context type and quantity- or range-based value assigned to the evidence report\r\n* [EvidenceVariable](evidencevariable.html): A use context type and quantity- or range-based value assigned to the evidence variable\r\n* [ExampleScenario](examplescenario.html): A use context type and quantity- or range-based value assigned to the example scenario\r\n* [GraphDefinition](graphdefinition.html): A use context type and quantity- or range-based value assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A use context type and quantity- or range-based value assigned to the implementation guide\r\n* [Library](library.html): A use context type and quantity- or range-based value assigned to the library\r\n* [Measure](measure.html): A use context type and quantity- or range-based value assigned to the measure\r\n* [MessageDefinition](messagedefinition.html): A use context type and quantity- or range-based value assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A use context type and quantity- or range-based value assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A use context type and quantity- or range-based value assigned to the operation definition\r\n* [PlanDefinition](plandefinition.html): A use context type and quantity- or range-based value assigned to the plan definition\r\n* [Questionnaire](questionnaire.html): A use context type and quantity- or range-based value assigned to the questionnaire\r\n* [Requirements](requirements.html): A use context type and quantity- or range-based value assigned to the requirements\r\n* [SearchParameter](searchparameter.html): A use context type and quantity- or range-based value assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A use context type and quantity- or range-based value assigned to the structure definition\r\n* [StructureMap](structuremap.html): A use context type and quantity- or range-based value assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A use context type and quantity- or range-based value assigned to the terminology capabilities\r\n* [TestScript](testscript.html): A use context type and quantity- or range-based value assigned to the test script\r\n* [ValueSet](valueset.html): A use context type and quantity- or range-based value assigned to the value set\r\n", type="composite", compositeOf={"context-type", "context-quantity"})
    public static final String SP_CONTEXT_TYPE_QUANTITY = "context-type-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> CONTEXT_TYPE_QUANTITY = new CompositeClientParam("context-type-quantity");
    @SearchParamDefinition(name="context-type-value", path="ActivityDefinition.useContext | ActorDefinition.useContext | CapabilityStatement.useContext | ChargeItemDefinition.useContext | Citation.useContext | CodeSystem.useContext | CompartmentDefinition.useContext | ConceptMap.useContext | ConditionDefinition.useContext | EventDefinition.useContext | Evidence.useContext | EvidenceReport.useContext | EvidenceVariable.useContext | ExampleScenario.useContext | GraphDefinition.useContext | ImplementationGuide.useContext | Library.useContext | Measure.useContext | MessageDefinition.useContext | NamingSystem.useContext | OperationDefinition.useContext | PlanDefinition.useContext | Questionnaire.useContext | Requirements.useContext | SearchParameter.useContext | StructureDefinition.useContext | StructureMap.useContext | TerminologyCapabilities.useContext | TestScript.useContext | ValueSet.useContext", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): A use context type and value assigned to the activity definition\r\n* [ActorDefinition](actordefinition.html): A use context type and value assigned to the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): A use context type and value assigned to the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): A use context type and value assigned to the charge item definition\r\n* [Citation](citation.html): A use context type and value assigned to the citation\r\n* [CodeSystem](codesystem.html): A use context type and value assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A use context type and value assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A use context type and value assigned to the concept map\r\n* [ConditionDefinition](conditiondefinition.html): A use context type and value assigned to the condition definition\r\n* [EventDefinition](eventdefinition.html): A use context type and value assigned to the event definition\r\n* [Evidence](evidence.html): A use context type and value assigned to the evidence\r\n* [EvidenceReport](evidencereport.html): A use context type and value assigned to the evidence report\r\n* [EvidenceVariable](evidencevariable.html): A use context type and value assigned to the evidence variable\r\n* [ExampleScenario](examplescenario.html): A use context type and value assigned to the example scenario\r\n* [GraphDefinition](graphdefinition.html): A use context type and value assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A use context type and value assigned to the implementation guide\r\n* [Library](library.html): A use context type and value assigned to the library\r\n* [Measure](measure.html): A use context type and value assigned to the measure\r\n* [MessageDefinition](messagedefinition.html): A use context type and value assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A use context type and value assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A use context type and value assigned to the operation definition\r\n* [PlanDefinition](plandefinition.html): A use context type and value assigned to the plan definition\r\n* [Questionnaire](questionnaire.html): A use context type and value assigned to the questionnaire\r\n* [Requirements](requirements.html): A use context type and value assigned to the requirements\r\n* [SearchParameter](searchparameter.html): A use context type and value assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A use context type and value assigned to the structure definition\r\n* [StructureMap](structuremap.html): A use context type and value assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A use context type and value assigned to the terminology capabilities\r\n* [TestScript](testscript.html): A use context type and value assigned to the test script\r\n* [ValueSet](valueset.html): A use context type and value assigned to the value set\r\n", type="composite", compositeOf={"context-type", "context"})
    public static final String SP_CONTEXT_TYPE_VALUE = "context-type-value";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CONTEXT_TYPE_VALUE = new CompositeClientParam("context-type-value");
    @SearchParamDefinition(name="context-type", path="ActivityDefinition.useContext.code | ActorDefinition.useContext.code | CapabilityStatement.useContext.code | ChargeItemDefinition.useContext.code | Citation.useContext.code | CodeSystem.useContext.code | CompartmentDefinition.useContext.code | ConceptMap.useContext.code | ConditionDefinition.useContext.code | EventDefinition.useContext.code | Evidence.useContext.code | EvidenceReport.useContext.code | EvidenceVariable.useContext.code | ExampleScenario.useContext.code | GraphDefinition.useContext.code | ImplementationGuide.useContext.code | Library.useContext.code | Measure.useContext.code | MessageDefinition.useContext.code | NamingSystem.useContext.code | OperationDefinition.useContext.code | PlanDefinition.useContext.code | Questionnaire.useContext.code | Requirements.useContext.code | SearchParameter.useContext.code | StructureDefinition.useContext.code | StructureMap.useContext.code | TerminologyCapabilities.useContext.code | TestScript.useContext.code | ValueSet.useContext.code", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): A type of use context assigned to the activity definition\r\n* [ActorDefinition](actordefinition.html): A type of use context assigned to the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): A type of use context assigned to the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): A type of use context assigned to the charge item definition\r\n* [Citation](citation.html): A type of use context assigned to the citation\r\n* [CodeSystem](codesystem.html): A type of use context assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A type of use context assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A type of use context assigned to the concept map\r\n* [ConditionDefinition](conditiondefinition.html): A type of use context assigned to the condition definition\r\n* [EventDefinition](eventdefinition.html): A type of use context assigned to the event definition\r\n* [Evidence](evidence.html): A type of use context assigned to the evidence\r\n* [EvidenceReport](evidencereport.html): A type of use context assigned to the evidence report\r\n* [EvidenceVariable](evidencevariable.html): A type of use context assigned to the evidence variable\r\n* [ExampleScenario](examplescenario.html): A type of use context assigned to the example scenario\r\n* [GraphDefinition](graphdefinition.html): A type of use context assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A type of use context assigned to the implementation guide\r\n* [Library](library.html): A type of use context assigned to the library\r\n* [Measure](measure.html): A type of use context assigned to the measure\r\n* [MessageDefinition](messagedefinition.html): A type of use context assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A type of use context assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A type of use context assigned to the operation definition\r\n* [PlanDefinition](plandefinition.html): A type of use context assigned to the plan definition\r\n* [Questionnaire](questionnaire.html): A type of use context assigned to the questionnaire\r\n* [Requirements](requirements.html): A type of use context assigned to the requirements\r\n* [SearchParameter](searchparameter.html): A type of use context assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A type of use context assigned to the structure definition\r\n* [StructureMap](structuremap.html): A type of use context assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A type of use context assigned to the terminology capabilities\r\n* [TestScript](testscript.html): A type of use context assigned to the test script\r\n* [ValueSet](valueset.html): A type of use context assigned to the value set\r\n", type="token")
    public static final String SP_CONTEXT_TYPE = "context-type";
    public static final TokenClientParam CONTEXT_TYPE = new TokenClientParam("context-type");
    @SearchParamDefinition(name="context", path="(ActivityDefinition.useContext.value.ofType(CodeableConcept)) | (ActorDefinition.useContext.value.ofType(CodeableConcept)) | (CapabilityStatement.useContext.value.ofType(CodeableConcept)) | (ChargeItemDefinition.useContext.value.ofType(CodeableConcept)) | (Citation.useContext.value.ofType(CodeableConcept)) | (CodeSystem.useContext.value.ofType(CodeableConcept)) | (CompartmentDefinition.useContext.value.ofType(CodeableConcept)) | (ConceptMap.useContext.value.ofType(CodeableConcept)) | (ConditionDefinition.useContext.value.ofType(CodeableConcept)) | (EventDefinition.useContext.value.ofType(CodeableConcept)) | (Evidence.useContext.value.ofType(CodeableConcept)) | (EvidenceReport.useContext.value.ofType(CodeableConcept)) | (EvidenceVariable.useContext.value.ofType(CodeableConcept)) | (ExampleScenario.useContext.value.ofType(CodeableConcept)) | (GraphDefinition.useContext.value.ofType(CodeableConcept)) | (ImplementationGuide.useContext.value.ofType(CodeableConcept)) | (Library.useContext.value.ofType(CodeableConcept)) | (Measure.useContext.value.ofType(CodeableConcept)) | (MessageDefinition.useContext.value.ofType(CodeableConcept)) | (NamingSystem.useContext.value.ofType(CodeableConcept)) | (OperationDefinition.useContext.value.ofType(CodeableConcept)) | (PlanDefinition.useContext.value.ofType(CodeableConcept)) | (Questionnaire.useContext.value.ofType(CodeableConcept)) | (Requirements.useContext.value.ofType(CodeableConcept)) | (SearchParameter.useContext.value.ofType(CodeableConcept)) | (StructureDefinition.useContext.value.ofType(CodeableConcept)) | (StructureMap.useContext.value.ofType(CodeableConcept)) | (TerminologyCapabilities.useContext.value.ofType(CodeableConcept)) | (TestScript.useContext.value.ofType(CodeableConcept)) | (ValueSet.useContext.value.ofType(CodeableConcept))", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): A use context assigned to the activity definition\r\n* [ActorDefinition](actordefinition.html): A use context assigned to the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): A use context assigned to the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): A use context assigned to the charge item definition\r\n* [Citation](citation.html): A use context assigned to the citation\r\n* [CodeSystem](codesystem.html): A use context assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A use context assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A use context assigned to the concept map\r\n* [ConditionDefinition](conditiondefinition.html): A use context assigned to the condition definition\r\n* [EventDefinition](eventdefinition.html): A use context assigned to the event definition\r\n* [Evidence](evidence.html): A use context assigned to the evidence\r\n* [EvidenceReport](evidencereport.html): A use context assigned to the evidence report\r\n* [EvidenceVariable](evidencevariable.html): A use context assigned to the evidence variable\r\n* [ExampleScenario](examplescenario.html): A use context assigned to the example scenario\r\n* [GraphDefinition](graphdefinition.html): A use context assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A use context assigned to the implementation guide\r\n* [Library](library.html): A use context assigned to the library\r\n* [Measure](measure.html): A use context assigned to the measure\r\n* [MessageDefinition](messagedefinition.html): A use context assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A use context assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A use context assigned to the operation definition\r\n* [PlanDefinition](plandefinition.html): A use context assigned to the plan definition\r\n* [Questionnaire](questionnaire.html): A use context assigned to the questionnaire\r\n* [Requirements](requirements.html): A use context assigned to the requirements\r\n* [SearchParameter](searchparameter.html): A use context assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A use context assigned to the structure definition\r\n* [StructureMap](structuremap.html): A use context assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A use context assigned to the terminology capabilities\r\n* [TestScript](testscript.html): A use context assigned to the test script\r\n* [ValueSet](valueset.html): A use context assigned to the value set\r\n", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="date", path="ActivityDefinition.date | ActorDefinition.date | CapabilityStatement.date | ChargeItemDefinition.date | Citation.date | CodeSystem.date | CompartmentDefinition.date | ConceptMap.date | ConditionDefinition.date | EventDefinition.date | Evidence.date | EvidenceVariable.date | ExampleScenario.date | GraphDefinition.date | ImplementationGuide.date | Library.date | Measure.date | MessageDefinition.date | NamingSystem.date | OperationDefinition.date | PlanDefinition.date | Questionnaire.date | Requirements.date | SearchParameter.date | StructureDefinition.date | StructureMap.date | SubscriptionTopic.date | TerminologyCapabilities.date | TestScript.date | ValueSet.date", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The activity definition publication date\r\n* [ActorDefinition](actordefinition.html): The Actor Definition publication date\r\n* [CapabilityStatement](capabilitystatement.html): The capability statement publication date\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The charge item definition publication date\r\n* [Citation](citation.html): The citation publication date\r\n* [CodeSystem](codesystem.html): The code system publication date\r\n* [CompartmentDefinition](compartmentdefinition.html): The compartment definition publication date\r\n* [ConceptMap](conceptmap.html): The concept map publication date\r\n* [ConditionDefinition](conditiondefinition.html): The condition definition publication date\r\n* [EventDefinition](eventdefinition.html): The event definition publication date\r\n* [Evidence](evidence.html): The evidence publication date\r\n* [EvidenceVariable](evidencevariable.html): The evidence variable publication date\r\n* [ExampleScenario](examplescenario.html): The example scenario publication date\r\n* [GraphDefinition](graphdefinition.html): The graph definition publication date\r\n* [ImplementationGuide](implementationguide.html): The implementation guide publication date\r\n* [Library](library.html): The library publication date\r\n* [Measure](measure.html): The measure publication date\r\n* [MessageDefinition](messagedefinition.html): The message definition publication date\r\n* [NamingSystem](namingsystem.html): The naming system publication date\r\n* [OperationDefinition](operationdefinition.html): The operation definition publication date\r\n* [PlanDefinition](plandefinition.html): The plan definition publication date\r\n* [Questionnaire](questionnaire.html): The questionnaire publication date\r\n* [Requirements](requirements.html): The requirements publication date\r\n* [SearchParameter](searchparameter.html): The search parameter publication date\r\n* [StructureDefinition](structuredefinition.html): The structure definition publication date\r\n* [StructureMap](structuremap.html): The structure map publication date\r\n* [SubscriptionTopic](subscriptiontopic.html): Date status first applied\r\n* [TerminologyCapabilities](terminologycapabilities.html): The terminology capabilities publication date\r\n* [TestScript](testscript.html): The test script publication date\r\n* [ValueSet](valueset.html): The value set publication date\r\n", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="description", path="ActivityDefinition.description | ActorDefinition.description | CapabilityStatement.description | ChargeItemDefinition.description | Citation.description | CodeSystem.description | CompartmentDefinition.description | ConceptMap.description | ConditionDefinition.description | EventDefinition.description | Evidence.description | EvidenceVariable.description | GraphDefinition.description | ImplementationGuide.description | Library.description | Measure.description | MessageDefinition.description | NamingSystem.description | OperationDefinition.description | PlanDefinition.description | Questionnaire.description | Requirements.description | SearchParameter.description | StructureDefinition.description | StructureMap.description | TerminologyCapabilities.description | TestScript.description | ValueSet.description", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The description of the activity definition\r\n* [ActorDefinition](actordefinition.html): The description of the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): The description of the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The description of the charge item definition\r\n* [Citation](citation.html): The description of the citation\r\n* [CodeSystem](codesystem.html): The description of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The description of the compartment definition\r\n* [ConceptMap](conceptmap.html): The description of the concept map\r\n* [ConditionDefinition](conditiondefinition.html): The description of the condition definition\r\n* [EventDefinition](eventdefinition.html): The description of the event definition\r\n* [Evidence](evidence.html): The description of the evidence\r\n* [EvidenceVariable](evidencevariable.html): The description of the evidence variable\r\n* [GraphDefinition](graphdefinition.html): The description of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The description of the implementation guide\r\n* [Library](library.html): The description of the library\r\n* [Measure](measure.html): The description of the measure\r\n* [MessageDefinition](messagedefinition.html): The description of the message definition\r\n* [NamingSystem](namingsystem.html): The description of the naming system\r\n* [OperationDefinition](operationdefinition.html): The description of the operation definition\r\n* [PlanDefinition](plandefinition.html): The description of the plan definition\r\n* [Questionnaire](questionnaire.html): The description of the questionnaire\r\n* [Requirements](requirements.html): The description of the requirements\r\n* [SearchParameter](searchparameter.html): The description of the search parameter\r\n* [StructureDefinition](structuredefinition.html): The description of the structure definition\r\n* [StructureMap](structuremap.html): The description of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): The description of the terminology capabilities\r\n* [TestScript](testscript.html): The description of the test script\r\n* [ValueSet](valueset.html): The description of the value set\r\n", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="identifier", path="ActivityDefinition.identifier | ActorDefinition.identifier | CapabilityStatement.identifier | ChargeItemDefinition.identifier | Citation.identifier | CodeSystem.identifier | ConceptMap.identifier | ConditionDefinition.identifier | EventDefinition.identifier | Evidence.identifier | EvidenceReport.identifier | EvidenceVariable.identifier | ExampleScenario.identifier | GraphDefinition.identifier | ImplementationGuide.identifier | Library.identifier | Measure.identifier | MedicationKnowledge.identifier | MessageDefinition.identifier | NamingSystem.identifier | ObservationDefinition.identifier | OperationDefinition.identifier | PlanDefinition.identifier | Questionnaire.identifier | Requirements.identifier | SearchParameter.identifier | SpecimenDefinition.identifier | StructureDefinition.identifier | StructureMap.identifier | SubscriptionTopic.identifier | TerminologyCapabilities.identifier | TestPlan.identifier | TestScript.identifier | ValueSet.identifier", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): External identifier for the activity definition\r\n* [ActorDefinition](actordefinition.html): External identifier for the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): External identifier for the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): External identifier for the charge item definition\r\n* [Citation](citation.html): External identifier for the citation\r\n* [CodeSystem](codesystem.html): External identifier for the code system\r\n* [ConceptMap](conceptmap.html): External identifier for the concept map\r\n* [ConditionDefinition](conditiondefinition.html): External identifier for the condition definition\r\n* [EventDefinition](eventdefinition.html): External identifier for the event definition\r\n* [Evidence](evidence.html): External identifier for the evidence\r\n* [EvidenceReport](evidencereport.html): External identifier for the evidence report\r\n* [EvidenceVariable](evidencevariable.html): External identifier for the evidence variable\r\n* [ExampleScenario](examplescenario.html): External identifier for the example scenario\r\n* [GraphDefinition](graphdefinition.html): External identifier for the graph definition\r\n* [ImplementationGuide](implementationguide.html): External identifier for the implementation guide\r\n* [Library](library.html): External identifier for the library\r\n* [Measure](measure.html): External identifier for the measure\r\n* [MedicationKnowledge](medicationknowledge.html): Business identifier for this medication\r\n* [MessageDefinition](messagedefinition.html): External identifier for the message definition\r\n* [NamingSystem](namingsystem.html): External identifier for the naming system\r\n* [ObservationDefinition](observationdefinition.html): The unique identifier associated with the specimen definition\r\n* [OperationDefinition](operationdefinition.html): External identifier for the search parameter\r\n* [PlanDefinition](plandefinition.html): External identifier for the plan definition\r\n* [Questionnaire](questionnaire.html): External identifier for the questionnaire\r\n* [Requirements](requirements.html): External identifier for the requirements\r\n* [SearchParameter](searchparameter.html): External identifier for the search parameter\r\n* [SpecimenDefinition](specimendefinition.html): The unique identifier associated with the SpecimenDefinition\r\n* [StructureDefinition](structuredefinition.html): External identifier for the structure definition\r\n* [StructureMap](structuremap.html): External identifier for the structure map\r\n* [SubscriptionTopic](subscriptiontopic.html): Business Identifier for SubscriptionTopic\r\n* [TerminologyCapabilities](terminologycapabilities.html): External identifier for the terminology capabilities\r\n* [TestPlan](testplan.html): An identifier for the test plan\r\n* [TestScript](testscript.html): External identifier for the test script\r\n* [ValueSet](valueset.html): External identifier for the value set\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="jurisdiction", path="ActivityDefinition.jurisdiction | ActorDefinition.jurisdiction | CapabilityStatement.jurisdiction | ChargeItemDefinition.jurisdiction | Citation.jurisdiction | CodeSystem.jurisdiction | ConceptMap.jurisdiction | ConditionDefinition.jurisdiction | EventDefinition.jurisdiction | ExampleScenario.jurisdiction | GraphDefinition.jurisdiction | ImplementationGuide.jurisdiction | Library.jurisdiction | Measure.jurisdiction | MessageDefinition.jurisdiction | NamingSystem.jurisdiction | OperationDefinition.jurisdiction | PlanDefinition.jurisdiction | Questionnaire.jurisdiction | Requirements.jurisdiction | SearchParameter.jurisdiction | StructureDefinition.jurisdiction | StructureMap.jurisdiction | TerminologyCapabilities.jurisdiction | TestScript.jurisdiction | ValueSet.jurisdiction", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): Intended jurisdiction for the activity definition\r\n* [ActorDefinition](actordefinition.html): Intended jurisdiction for the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): Intended jurisdiction for the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): Intended jurisdiction for the charge item definition\r\n* [Citation](citation.html): Intended jurisdiction for the citation\r\n* [CodeSystem](codesystem.html): Intended jurisdiction for the code system\r\n* [ConceptMap](conceptmap.html): Intended jurisdiction for the concept map\r\n* [ConditionDefinition](conditiondefinition.html): Intended jurisdiction for the condition definition\r\n* [EventDefinition](eventdefinition.html): Intended jurisdiction for the event definition\r\n* [ExampleScenario](examplescenario.html): Intended jurisdiction for the example scenario\r\n* [GraphDefinition](graphdefinition.html): Intended jurisdiction for the graph definition\r\n* [ImplementationGuide](implementationguide.html): Intended jurisdiction for the implementation guide\r\n* [Library](library.html): Intended jurisdiction for the library\r\n* [Measure](measure.html): Intended jurisdiction for the measure\r\n* [MessageDefinition](messagedefinition.html): Intended jurisdiction for the message definition\r\n* [NamingSystem](namingsystem.html): Intended jurisdiction for the naming system\r\n* [OperationDefinition](operationdefinition.html): Intended jurisdiction for the operation definition\r\n* [PlanDefinition](plandefinition.html): Intended jurisdiction for the plan definition\r\n* [Questionnaire](questionnaire.html): Intended jurisdiction for the questionnaire\r\n* [Requirements](requirements.html): Intended jurisdiction for the requirements\r\n* [SearchParameter](searchparameter.html): Intended jurisdiction for the search parameter\r\n* [StructureDefinition](structuredefinition.html): Intended jurisdiction for the structure definition\r\n* [StructureMap](structuremap.html): Intended jurisdiction for the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): Intended jurisdiction for the terminology capabilities\r\n* [TestScript](testscript.html): Intended jurisdiction for the test script\r\n* [ValueSet](valueset.html): Intended jurisdiction for the value set\r\n", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="name", path="ActivityDefinition.name | CapabilityStatement.name | Citation.name | CodeSystem.name | CompartmentDefinition.name | ConceptMap.name | ConditionDefinition.name | EventDefinition.name | EvidenceVariable.name | ExampleScenario.name | GraphDefinition.name | ImplementationGuide.name | Library.name | Measure.name | MessageDefinition.name | NamingSystem.name | OperationDefinition.name | PlanDefinition.name | Questionnaire.name | Requirements.name | SearchParameter.name | StructureDefinition.name | StructureMap.name | TerminologyCapabilities.name | TestScript.name | ValueSet.name", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): Computationally friendly name of the activity definition\r\n* [CapabilityStatement](capabilitystatement.html): Computationally friendly name of the capability statement\r\n* [Citation](citation.html): Computationally friendly name of the citation\r\n* [CodeSystem](codesystem.html): Computationally friendly name of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): Computationally friendly name of the compartment definition\r\n* [ConceptMap](conceptmap.html): Computationally friendly name of the concept map\r\n* [ConditionDefinition](conditiondefinition.html): Computationally friendly name of the condition definition\r\n* [EventDefinition](eventdefinition.html): Computationally friendly name of the event definition\r\n* [EvidenceVariable](evidencevariable.html): Computationally friendly name of the evidence variable\r\n* [ExampleScenario](examplescenario.html): Computationally friendly name of the example scenario\r\n* [GraphDefinition](graphdefinition.html): Computationally friendly name of the graph definition\r\n* [ImplementationGuide](implementationguide.html): Computationally friendly name of the implementation guide\r\n* [Library](library.html): Computationally friendly name of the library\r\n* [Measure](measure.html): Computationally friendly name of the measure\r\n* [MessageDefinition](messagedefinition.html): Computationally friendly name of the message definition\r\n* [NamingSystem](namingsystem.html): Computationally friendly name of the naming system\r\n* [OperationDefinition](operationdefinition.html): Computationally friendly name of the operation definition\r\n* [PlanDefinition](plandefinition.html): Computationally friendly name of the plan definition\r\n* [Questionnaire](questionnaire.html): Computationally friendly name of the questionnaire\r\n* [Requirements](requirements.html): Computationally friendly name of the requirements\r\n* [SearchParameter](searchparameter.html): Computationally friendly name of the search parameter\r\n* [StructureDefinition](structuredefinition.html): Computationally friendly name of the structure definition\r\n* [StructureMap](structuremap.html): Computationally friendly name of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): Computationally friendly name of the terminology capabilities\r\n* [TestScript](testscript.html): Computationally friendly name of the test script\r\n* [ValueSet](valueset.html): Computationally friendly name of the value set\r\n", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="publisher", path="ActivityDefinition.publisher | ActorDefinition.publisher | CapabilityStatement.publisher | ChargeItemDefinition.publisher | Citation.publisher | CodeSystem.publisher | CompartmentDefinition.publisher | ConceptMap.publisher | ConditionDefinition.publisher | EventDefinition.publisher | Evidence.publisher | EvidenceReport.publisher | EvidenceVariable.publisher | ExampleScenario.publisher | GraphDefinition.publisher | ImplementationGuide.publisher | Library.publisher | Measure.publisher | MessageDefinition.publisher | NamingSystem.publisher | OperationDefinition.publisher | PlanDefinition.publisher | Questionnaire.publisher | Requirements.publisher | SearchParameter.publisher | StructureDefinition.publisher | StructureMap.publisher | TerminologyCapabilities.publisher | TestScript.publisher | ValueSet.publisher", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): Name of the publisher of the activity definition\r\n* [ActorDefinition](actordefinition.html): Name of the publisher of the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): Name of the publisher of the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): Name of the publisher of the charge item definition\r\n* [Citation](citation.html): Name of the publisher of the citation\r\n* [CodeSystem](codesystem.html): Name of the publisher of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): Name of the publisher of the compartment definition\r\n* [ConceptMap](conceptmap.html): Name of the publisher of the concept map\r\n* [ConditionDefinition](conditiondefinition.html): Name of the publisher of the condition definition\r\n* [EventDefinition](eventdefinition.html): Name of the publisher of the event definition\r\n* [Evidence](evidence.html): Name of the publisher of the evidence\r\n* [EvidenceReport](evidencereport.html): Name of the publisher of the evidence report\r\n* [EvidenceVariable](evidencevariable.html): Name of the publisher of the evidence variable\r\n* [ExampleScenario](examplescenario.html): Name of the publisher of the example scenario\r\n* [GraphDefinition](graphdefinition.html): Name of the publisher of the graph definition\r\n* [ImplementationGuide](implementationguide.html): Name of the publisher of the implementation guide\r\n* [Library](library.html): Name of the publisher of the library\r\n* [Measure](measure.html): Name of the publisher of the measure\r\n* [MessageDefinition](messagedefinition.html): Name of the publisher of the message definition\r\n* [NamingSystem](namingsystem.html): Name of the publisher of the naming system\r\n* [OperationDefinition](operationdefinition.html): Name of the publisher of the operation definition\r\n* [PlanDefinition](plandefinition.html): Name of the publisher of the plan definition\r\n* [Questionnaire](questionnaire.html): Name of the publisher of the questionnaire\r\n* [Requirements](requirements.html): Name of the publisher of the requirements\r\n* [SearchParameter](searchparameter.html): Name of the publisher of the search parameter\r\n* [StructureDefinition](structuredefinition.html): Name of the publisher of the structure definition\r\n* [StructureMap](structuremap.html): Name of the publisher of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): Name of the publisher of the terminology capabilities\r\n* [TestScript](testscript.html): Name of the publisher of the test script\r\n* [ValueSet](valueset.html): Name of the publisher of the value set\r\n", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="status", path="ActivityDefinition.status | ActorDefinition.status | CapabilityStatement.status | ChargeItemDefinition.status | Citation.status | CodeSystem.status | CompartmentDefinition.status | ConceptMap.status | ConditionDefinition.status | EventDefinition.status | Evidence.status | EvidenceReport.status | EvidenceVariable.status | ExampleScenario.status | GraphDefinition.status | ImplementationGuide.status | Library.status | Measure.status | MedicationKnowledge.status | MessageDefinition.status | NamingSystem.status | ObservationDefinition.status | OperationDefinition.status | PlanDefinition.status | Questionnaire.status | Requirements.status | SearchParameter.status | SpecimenDefinition.status | StructureDefinition.status | StructureMap.status | SubscriptionTopic.status | TerminologyCapabilities.status | TestPlan.status | TestScript.status | ValueSet.status", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The current status of the activity definition\r\n* [ActorDefinition](actordefinition.html): The current status of the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): The current status of the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The current status of the charge item definition\r\n* [Citation](citation.html): The current status of the citation\r\n* [CodeSystem](codesystem.html): The current status of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The current status of the compartment definition\r\n* [ConceptMap](conceptmap.html): The current status of the concept map\r\n* [ConditionDefinition](conditiondefinition.html): The current status of the condition definition\r\n* [EventDefinition](eventdefinition.html): The current status of the event definition\r\n* [Evidence](evidence.html): The current status of the evidence\r\n* [EvidenceReport](evidencereport.html): The current status of the evidence report\r\n* [EvidenceVariable](evidencevariable.html): The current status of the evidence variable\r\n* [ExampleScenario](examplescenario.html): The current status of the example scenario\r\n* [GraphDefinition](graphdefinition.html): The current status of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The current status of the implementation guide\r\n* [Library](library.html): The current status of the library\r\n* [Measure](measure.html): The current status of the measure\r\n* [MedicationKnowledge](medicationknowledge.html): active | inactive | entered-in-error\r\n* [MessageDefinition](messagedefinition.html): The current status of the message definition\r\n* [NamingSystem](namingsystem.html): The current status of the naming system\r\n* [ObservationDefinition](observationdefinition.html): Publication status of the ObservationDefinition: draft, active, retired, unknown\r\n* [OperationDefinition](operationdefinition.html): The current status of the operation definition\r\n* [PlanDefinition](plandefinition.html): The current status of the plan definition\r\n* [Questionnaire](questionnaire.html): The current status of the questionnaire\r\n* [Requirements](requirements.html): The current status of the requirements\r\n* [SearchParameter](searchparameter.html): The current status of the search parameter\r\n* [SpecimenDefinition](specimendefinition.html): Publication status of the SpecimenDefinition: draft, active, retired, unknown\r\n* [StructureDefinition](structuredefinition.html): The current status of the structure definition\r\n* [StructureMap](structuremap.html): The current status of the structure map\r\n* [SubscriptionTopic](subscriptiontopic.html): draft | active | retired | unknown\r\n* [TerminologyCapabilities](terminologycapabilities.html): The current status of the terminology capabilities\r\n* [TestPlan](testplan.html): The current status of the test plan\r\n* [TestScript](testscript.html): The current status of the test script\r\n* [ValueSet](valueset.html): The current status of the value set\r\n", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="title", path="ActivityDefinition.title | ActorDefinition.title | CapabilityStatement.title | ChargeItemDefinition.title | Citation.title | CodeSystem.title | ConceptMap.title | ConditionDefinition.title | EventDefinition.title | Evidence.title | EvidenceVariable.title | ImplementationGuide.title | Library.title | Measure.title | MessageDefinition.title | ObservationDefinition.title | OperationDefinition.title | PlanDefinition.title | Questionnaire.title | Requirements.title | SpecimenDefinition.title | StructureDefinition.title | StructureMap.title | SubscriptionTopic.title | TerminologyCapabilities.title | TestScript.title | ValueSet.title", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The human-friendly name of the activity definition\r\n* [ActorDefinition](actordefinition.html): The human-friendly name of the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): The human-friendly name of the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The human-friendly name of the charge item definition\r\n* [Citation](citation.html): The human-friendly name of the citation\r\n* [CodeSystem](codesystem.html): The human-friendly name of the code system\r\n* [ConceptMap](conceptmap.html): The human-friendly name of the concept map\r\n* [ConditionDefinition](conditiondefinition.html): The human-friendly name of the condition definition\r\n* [EventDefinition](eventdefinition.html): The human-friendly name of the event definition\r\n* [Evidence](evidence.html): The human-friendly name of the evidence\r\n* [EvidenceVariable](evidencevariable.html): The human-friendly name of the evidence variable\r\n* [ImplementationGuide](implementationguide.html): The human-friendly name of the implementation guide\r\n* [Library](library.html): The human-friendly name of the library\r\n* [Measure](measure.html): The human-friendly name of the measure\r\n* [MessageDefinition](messagedefinition.html): The human-friendly name of the message definition\r\n* [ObservationDefinition](observationdefinition.html): Human-friendly name of the ObservationDefinition\r\n* [OperationDefinition](operationdefinition.html): The human-friendly name of the operation definition\r\n* [PlanDefinition](plandefinition.html): The human-friendly name of the plan definition\r\n* [Questionnaire](questionnaire.html): The human-friendly name of the questionnaire\r\n* [Requirements](requirements.html): The human-friendly name of the requirements\r\n* [SpecimenDefinition](specimendefinition.html): Human-friendly name of the SpecimenDefinition\r\n* [StructureDefinition](structuredefinition.html): The human-friendly name of the structure definition\r\n* [StructureMap](structuremap.html): The human-friendly name of the structure map\r\n* [SubscriptionTopic](subscriptiontopic.html): Name for this SubscriptionTopic (Human friendly)\r\n* [TerminologyCapabilities](terminologycapabilities.html): The human-friendly name of the terminology capabilities\r\n* [TestScript](testscript.html): The human-friendly name of the test script\r\n* [ValueSet](valueset.html): The human-friendly name of the value set\r\n", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="url", path="ActivityDefinition.url | ActorDefinition.url | CapabilityStatement.url | ChargeItemDefinition.url | Citation.url | CodeSystem.url | CompartmentDefinition.url | ConceptMap.url | ConditionDefinition.url | EventDefinition.url | Evidence.url | EvidenceReport.url | EvidenceVariable.url | ExampleScenario.url | GraphDefinition.url | ImplementationGuide.url | Library.url | Measure.url | MessageDefinition.url | NamingSystem.url | ObservationDefinition.url | OperationDefinition.url | PlanDefinition.url | Questionnaire.url | Requirements.url | SearchParameter.url | SpecimenDefinition.url | StructureDefinition.url | StructureMap.url | SubscriptionTopic.url | TerminologyCapabilities.url | TestPlan.url | TestScript.url | ValueSet.url", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The uri that identifies the activity definition\r\n* [ActorDefinition](actordefinition.html): The uri that identifies the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): The uri that identifies the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The uri that identifies the charge item definition\r\n* [Citation](citation.html): The uri that identifies the citation\r\n* [CodeSystem](codesystem.html): The uri that identifies the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The uri that identifies the compartment definition\r\n* [ConceptMap](conceptmap.html): The URI that identifies the concept map\r\n* [ConditionDefinition](conditiondefinition.html): The uri that identifies the condition definition\r\n* [EventDefinition](eventdefinition.html): The uri that identifies the event definition\r\n* [Evidence](evidence.html): The uri that identifies the evidence\r\n* [EvidenceReport](evidencereport.html): The uri that identifies the evidence report\r\n* [EvidenceVariable](evidencevariable.html): The uri that identifies the evidence variable\r\n* [ExampleScenario](examplescenario.html): The uri that identifies the example scenario\r\n* [GraphDefinition](graphdefinition.html): The uri that identifies the graph definition\r\n* [ImplementationGuide](implementationguide.html): The uri that identifies the implementation guide\r\n* [Library](library.html): The uri that identifies the library\r\n* [Measure](measure.html): The uri that identifies the measure\r\n* [MessageDefinition](messagedefinition.html): The uri that identifies the message definition\r\n* [NamingSystem](namingsystem.html): The uri that identifies the naming system\r\n* [ObservationDefinition](observationdefinition.html): The uri that identifies the observation definition\r\n* [OperationDefinition](operationdefinition.html): The uri that identifies the operation definition\r\n* [PlanDefinition](plandefinition.html): The uri that identifies the plan definition\r\n* [Questionnaire](questionnaire.html): The uri that identifies the questionnaire\r\n* [Requirements](requirements.html): The uri that identifies the requirements\r\n* [SearchParameter](searchparameter.html): The uri that identifies the search parameter\r\n* [SpecimenDefinition](specimendefinition.html): The uri that identifies the specimen definition\r\n* [StructureDefinition](structuredefinition.html): The uri that identifies the structure definition\r\n* [StructureMap](structuremap.html): The uri that identifies the structure map\r\n* [SubscriptionTopic](subscriptiontopic.html): Logical canonical URL to reference this SubscriptionTopic (globally unique)\r\n* [TerminologyCapabilities](terminologycapabilities.html): The uri that identifies the terminology capabilities\r\n* [TestPlan](testplan.html): The uri that identifies the test plan\r\n* [TestScript](testscript.html): The uri that identifies the test script\r\n* [ValueSet](valueset.html): The uri that identifies the value set\r\n", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="version", path="ActivityDefinition.version | ActorDefinition.version | CapabilityStatement.version | ChargeItemDefinition.version | Citation.version | CodeSystem.version | CompartmentDefinition.version | ConceptMap.version | ConditionDefinition.version | EventDefinition.version | Evidence.version | EvidenceVariable.version | ExampleScenario.version | GraphDefinition.version | ImplementationGuide.version | Library.version | Measure.version | MessageDefinition.version | NamingSystem.version | OperationDefinition.version | PlanDefinition.version | Questionnaire.version | Requirements.version | SearchParameter.version | StructureDefinition.version | StructureMap.version | SubscriptionTopic.version | TerminologyCapabilities.version | TestScript.version | ValueSet.version", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The business version of the activity definition\r\n* [ActorDefinition](actordefinition.html): The business version of the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): The business version of the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The business version of the charge item definition\r\n* [Citation](citation.html): The business version of the citation\r\n* [CodeSystem](codesystem.html): The business version of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The business version of the compartment definition\r\n* [ConceptMap](conceptmap.html): The business version of the concept map\r\n* [ConditionDefinition](conditiondefinition.html): The business version of the condition definition\r\n* [EventDefinition](eventdefinition.html): The business version of the event definition\r\n* [Evidence](evidence.html): The business version of the evidence\r\n* [EvidenceVariable](evidencevariable.html): The business version of the evidence variable\r\n* [ExampleScenario](examplescenario.html): The business version of the example scenario\r\n* [GraphDefinition](graphdefinition.html): The business version of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The business version of the implementation guide\r\n* [Library](library.html): The business version of the library\r\n* [Measure](measure.html): The business version of the measure\r\n* [MessageDefinition](messagedefinition.html): The business version of the message definition\r\n* [NamingSystem](namingsystem.html): The business version of the naming system\r\n* [OperationDefinition](operationdefinition.html): The business version of the operation definition\r\n* [PlanDefinition](plandefinition.html): The business version of the plan definition\r\n* [Questionnaire](questionnaire.html): The business version of the questionnaire\r\n* [Requirements](requirements.html): The business version of the requirements\r\n* [SearchParameter](searchparameter.html): The business version of the search parameter\r\n* [StructureDefinition](structuredefinition.html): The business version of the structure definition\r\n* [StructureMap](structuremap.html): The business version of the structure map\r\n* [SubscriptionTopic](subscriptiontopic.html): Business version of the SubscriptionTopic\r\n* [TerminologyCapabilities](terminologycapabilities.html): The business version of the terminology capabilities\r\n* [TestScript](testscript.html): The business version of the test script\r\n* [ValueSet](valueset.html): The business version of the value set\r\n", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="classification-type", path="(Citation.classification.type)", description="A type of classification assigned to the citation", type="token")
    public static final String SP_CLASSIFICATION_TYPE = "classification-type";
    public static final TokenClientParam CLASSIFICATION_TYPE = new TokenClientParam("classification-type");
    @SearchParamDefinition(name="classification", path="Citation.classification", description="A classification type and value assigned to the citation", type="composite", compositeOf={"classification-type", "classifier"})
    public static final String SP_CLASSIFICATION = "classification";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CLASSIFICATION = new CompositeClientParam("classification");
    @SearchParamDefinition(name="classifier", path="(Citation.classification.classifier)", description="A classifier assigned to the citation", type="token")
    public static final String SP_CLASSIFIER = "classifier";
    public static final TokenClientParam CLASSIFIER = new TokenClientParam("classifier");
    @SearchParamDefinition(name="effective", path="ActivityDefinition.effectivePeriod | ChargeItemDefinition.applicability.effectivePeriod | Citation.effectivePeriod | CodeSystem.effectivePeriod | ConceptMap.effectivePeriod | EventDefinition.effectivePeriod | Library.effectivePeriod | Measure.effectivePeriod | NamingSystem.effectivePeriod | PlanDefinition.effectivePeriod | Questionnaire.effectivePeriod | ValueSet.effectivePeriod", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The time during which the activity definition is intended to be in use\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The time during which the charge item definition is intended to be in use\r\n* [Citation](citation.html): The time during which the citation is intended to be in use\r\n* [CodeSystem](codesystem.html): The time during which the CodeSystem is intended to be in use\r\n* [ConceptMap](conceptmap.html): The time during which the ConceptMap is intended to be in use\r\n* [EventDefinition](eventdefinition.html): The time during which the event definition is intended to be in use\r\n* [Library](library.html): The time during which the library is intended to be in use\r\n* [Measure](measure.html): The time during which the measure is intended to be in use\r\n* [NamingSystem](namingsystem.html): The time during which the NamingSystem is intended to be in use\r\n* [PlanDefinition](plandefinition.html): The time during which the plan definition is intended to be in use\r\n* [Questionnaire](questionnaire.html): The time during which the questionnaire is intended to be in use\r\n* [ValueSet](valueset.html): The time during which the ValueSet is intended to be in use\r\n", type="date")
    public static final String SP_EFFECTIVE = "effective";
    public static final DateClientParam EFFECTIVE = new DateClientParam("effective");

    public Citation() {
    }

    public Citation(Enumerations.PublicationStatus status) {
        this.setStatus(status);
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public Citation setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public Citation setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    @Override
    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    @Override
    public Citation setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    @Override
    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    @Override
    public Citation addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    @Override
    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public Citation setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public Citation setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public DataType getVersionAlgorithm() {
        return this.versionAlgorithm;
    }

    @Override
    public StringType getVersionAlgorithmStringType() throws FHIRException {
        if (this.versionAlgorithm == null) {
            this.versionAlgorithm = new StringType();
        }
        if (!(this.versionAlgorithm instanceof StringType)) {
            throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.versionAlgorithm.getClass().getName() + " was encountered");
        }
        return (StringType)this.versionAlgorithm;
    }

    @Override
    public boolean hasVersionAlgorithmStringType() {
        return this != null && this.versionAlgorithm instanceof StringType;
    }

    @Override
    public Coding getVersionAlgorithmCoding() throws FHIRException {
        if (this.versionAlgorithm == null) {
            this.versionAlgorithm = new Coding();
        }
        if (!(this.versionAlgorithm instanceof Coding)) {
            throw new FHIRException("Type mismatch: the type Coding was expected, but " + this.versionAlgorithm.getClass().getName() + " was encountered");
        }
        return (Coding)this.versionAlgorithm;
    }

    @Override
    public boolean hasVersionAlgorithmCoding() {
        return this != null && this.versionAlgorithm instanceof Coding;
    }

    @Override
    public boolean hasVersionAlgorithm() {
        return this.versionAlgorithm != null && !this.versionAlgorithm.isEmpty();
    }

    @Override
    public Citation setVersionAlgorithm(DataType value) {
        if (value != null && !(value instanceof StringType) && !(value instanceof Coding)) {
            throw new FHIRException("Not the right type for Citation.versionAlgorithm[x]: " + value.fhirType());
        }
        this.versionAlgorithm = value;
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public Citation setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public Citation setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    @Override
    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public Citation setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    @Override
    public Citation setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public Citation setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public Citation setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public Citation setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public Citation setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public Citation setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public Citation setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public Citation setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public Citation setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        return this.contact;
    }

    @Override
    public Citation setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public Citation addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public Citation setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public Citation setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        return this.useContext;
    }

    @Override
    public Citation setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public Citation addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        return this.jurisdiction;
    }

    @Override
    public Citation setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public Citation addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    @Override
    public MarkdownType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new MarkdownType();
            }
        }
        return this.purpose;
    }

    @Override
    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    @Override
    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    @Override
    public Citation setPurposeElement(MarkdownType value) {
        this.purpose = value;
        return this;
    }

    @Override
    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    @Override
    public Citation setPurpose(String value) {
        if (Utilities.noString((String)value)) {
            this.purpose = null;
        } else {
            if (this.purpose == null) {
                this.purpose = new MarkdownType();
            }
            this.purpose.setValue(value);
        }
        return this;
    }

    @Override
    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    @Override
    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    @Override
    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    @Override
    public Citation setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    @Override
    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    @Override
    public Citation setCopyright(String value) {
        if (Utilities.noString((String)value)) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getCopyrightLabelElement() {
        if (this.copyrightLabel == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.copyrightLabel");
            }
            if (Configuration.doAutoCreate()) {
                this.copyrightLabel = new StringType();
            }
        }
        return this.copyrightLabel;
    }

    @Override
    public boolean hasCopyrightLabelElement() {
        return this.copyrightLabel != null && !this.copyrightLabel.isEmpty();
    }

    @Override
    public boolean hasCopyrightLabel() {
        return this.copyrightLabel != null && !this.copyrightLabel.isEmpty();
    }

    @Override
    public Citation setCopyrightLabelElement(StringType value) {
        this.copyrightLabel = value;
        return this;
    }

    @Override
    public String getCopyrightLabel() {
        return this.copyrightLabel == null ? null : (String)this.copyrightLabel.getValue();
    }

    @Override
    public Citation setCopyrightLabel(String value) {
        if (Utilities.noString((String)value)) {
            this.copyrightLabel = null;
        } else {
            if (this.copyrightLabel == null) {
                this.copyrightLabel = new StringType();
            }
            this.copyrightLabel.setValue(value);
        }
        return this;
    }

    @Override
    public DateType getApprovalDateElement() {
        if (this.approvalDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.approvalDate");
            }
            if (Configuration.doAutoCreate()) {
                this.approvalDate = new DateType();
            }
        }
        return this.approvalDate;
    }

    @Override
    public boolean hasApprovalDateElement() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    @Override
    public boolean hasApprovalDate() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    @Override
    public Citation setApprovalDateElement(DateType value) {
        this.approvalDate = value;
        return this;
    }

    @Override
    public Date getApprovalDate() {
        return this.approvalDate == null ? null : (Date)this.approvalDate.getValue();
    }

    @Override
    public Citation setApprovalDate(Date value) {
        if (value == null) {
            this.approvalDate = null;
        } else {
            if (this.approvalDate == null) {
                this.approvalDate = new DateType();
            }
            this.approvalDate.setValue(value);
        }
        return this;
    }

    @Override
    public DateType getLastReviewDateElement() {
        if (this.lastReviewDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.lastReviewDate");
            }
            if (Configuration.doAutoCreate()) {
                this.lastReviewDate = new DateType();
            }
        }
        return this.lastReviewDate;
    }

    @Override
    public boolean hasLastReviewDateElement() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    @Override
    public boolean hasLastReviewDate() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    @Override
    public Citation setLastReviewDateElement(DateType value) {
        this.lastReviewDate = value;
        return this;
    }

    @Override
    public Date getLastReviewDate() {
        return this.lastReviewDate == null ? null : (Date)this.lastReviewDate.getValue();
    }

    @Override
    public Citation setLastReviewDate(Date value) {
        if (value == null) {
            this.lastReviewDate = null;
        } else {
            if (this.lastReviewDate == null) {
                this.lastReviewDate = new DateType();
            }
            this.lastReviewDate.setValue(value);
        }
        return this;
    }

    @Override
    public Period getEffectivePeriod() {
        if (this.effectivePeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.effectivePeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.effectivePeriod = new Period();
            }
        }
        return this.effectivePeriod;
    }

    @Override
    public boolean hasEffectivePeriod() {
        return this.effectivePeriod != null && !this.effectivePeriod.isEmpty();
    }

    @Override
    public Citation setEffectivePeriod(Period value) {
        this.effectivePeriod = value;
        return this;
    }

    @Override
    public List<ContactDetail> getAuthor() {
        if (this.author == null) {
            this.author = new ArrayList<ContactDetail>();
        }
        return this.author;
    }

    @Override
    public Citation setAuthor(List<ContactDetail> theAuthor) {
        this.author = theAuthor;
        return this;
    }

    @Override
    public boolean hasAuthor() {
        if (this.author == null) {
            return false;
        }
        for (ContactDetail item : this.author) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addAuthor() {
        ContactDetail t = new ContactDetail();
        if (this.author == null) {
            this.author = new ArrayList<ContactDetail>();
        }
        this.author.add(t);
        return t;
    }

    @Override
    public Citation addAuthor(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.author == null) {
            this.author = new ArrayList<ContactDetail>();
        }
        this.author.add(t);
        return this;
    }

    @Override
    public ContactDetail getAuthorFirstRep() {
        if (this.getAuthor().isEmpty()) {
            this.addAuthor();
        }
        return this.getAuthor().get(0);
    }

    @Override
    public List<ContactDetail> getEditor() {
        if (this.editor == null) {
            this.editor = new ArrayList<ContactDetail>();
        }
        return this.editor;
    }

    @Override
    public Citation setEditor(List<ContactDetail> theEditor) {
        this.editor = theEditor;
        return this;
    }

    @Override
    public boolean hasEditor() {
        if (this.editor == null) {
            return false;
        }
        for (ContactDetail item : this.editor) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addEditor() {
        ContactDetail t = new ContactDetail();
        if (this.editor == null) {
            this.editor = new ArrayList<ContactDetail>();
        }
        this.editor.add(t);
        return t;
    }

    @Override
    public Citation addEditor(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.editor == null) {
            this.editor = new ArrayList<ContactDetail>();
        }
        this.editor.add(t);
        return this;
    }

    @Override
    public ContactDetail getEditorFirstRep() {
        if (this.getEditor().isEmpty()) {
            this.addEditor();
        }
        return this.getEditor().get(0);
    }

    @Override
    public List<ContactDetail> getReviewer() {
        if (this.reviewer == null) {
            this.reviewer = new ArrayList<ContactDetail>();
        }
        return this.reviewer;
    }

    @Override
    public Citation setReviewer(List<ContactDetail> theReviewer) {
        this.reviewer = theReviewer;
        return this;
    }

    @Override
    public boolean hasReviewer() {
        if (this.reviewer == null) {
            return false;
        }
        for (ContactDetail item : this.reviewer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addReviewer() {
        ContactDetail t = new ContactDetail();
        if (this.reviewer == null) {
            this.reviewer = new ArrayList<ContactDetail>();
        }
        this.reviewer.add(t);
        return t;
    }

    @Override
    public Citation addReviewer(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.reviewer == null) {
            this.reviewer = new ArrayList<ContactDetail>();
        }
        this.reviewer.add(t);
        return this;
    }

    @Override
    public ContactDetail getReviewerFirstRep() {
        if (this.getReviewer().isEmpty()) {
            this.addReviewer();
        }
        return this.getReviewer().get(0);
    }

    @Override
    public List<ContactDetail> getEndorser() {
        if (this.endorser == null) {
            this.endorser = new ArrayList<ContactDetail>();
        }
        return this.endorser;
    }

    @Override
    public Citation setEndorser(List<ContactDetail> theEndorser) {
        this.endorser = theEndorser;
        return this;
    }

    @Override
    public boolean hasEndorser() {
        if (this.endorser == null) {
            return false;
        }
        for (ContactDetail item : this.endorser) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addEndorser() {
        ContactDetail t = new ContactDetail();
        if (this.endorser == null) {
            this.endorser = new ArrayList<ContactDetail>();
        }
        this.endorser.add(t);
        return t;
    }

    @Override
    public Citation addEndorser(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.endorser == null) {
            this.endorser = new ArrayList<ContactDetail>();
        }
        this.endorser.add(t);
        return this;
    }

    @Override
    public ContactDetail getEndorserFirstRep() {
        if (this.getEndorser().isEmpty()) {
            this.addEndorser();
        }
        return this.getEndorser().get(0);
    }

    public List<CitationSummaryComponent> getSummary() {
        if (this.summary == null) {
            this.summary = new ArrayList<CitationSummaryComponent>();
        }
        return this.summary;
    }

    public Citation setSummary(List<CitationSummaryComponent> theSummary) {
        this.summary = theSummary;
        return this;
    }

    public boolean hasSummary() {
        if (this.summary == null) {
            return false;
        }
        for (CitationSummaryComponent item : this.summary) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CitationSummaryComponent addSummary() {
        CitationSummaryComponent t = new CitationSummaryComponent();
        if (this.summary == null) {
            this.summary = new ArrayList<CitationSummaryComponent>();
        }
        this.summary.add(t);
        return t;
    }

    public Citation addSummary(CitationSummaryComponent t) {
        if (t == null) {
            return this;
        }
        if (this.summary == null) {
            this.summary = new ArrayList<CitationSummaryComponent>();
        }
        this.summary.add(t);
        return this;
    }

    public CitationSummaryComponent getSummaryFirstRep() {
        if (this.getSummary().isEmpty()) {
            this.addSummary();
        }
        return this.getSummary().get(0);
    }

    public List<CitationClassificationComponent> getClassification() {
        if (this.classification == null) {
            this.classification = new ArrayList<CitationClassificationComponent>();
        }
        return this.classification;
    }

    public Citation setClassification(List<CitationClassificationComponent> theClassification) {
        this.classification = theClassification;
        return this;
    }

    public boolean hasClassification() {
        if (this.classification == null) {
            return false;
        }
        for (CitationClassificationComponent item : this.classification) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CitationClassificationComponent addClassification() {
        CitationClassificationComponent t = new CitationClassificationComponent();
        if (this.classification == null) {
            this.classification = new ArrayList<CitationClassificationComponent>();
        }
        this.classification.add(t);
        return t;
    }

    public Citation addClassification(CitationClassificationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.classification == null) {
            this.classification = new ArrayList<CitationClassificationComponent>();
        }
        this.classification.add(t);
        return this;
    }

    public CitationClassificationComponent getClassificationFirstRep() {
        if (this.getClassification().isEmpty()) {
            this.addClassification();
        }
        return this.getClassification().get(0);
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public Citation setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public Citation addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public List<CodeableConcept> getCurrentState() {
        if (this.currentState == null) {
            this.currentState = new ArrayList<CodeableConcept>();
        }
        return this.currentState;
    }

    public Citation setCurrentState(List<CodeableConcept> theCurrentState) {
        this.currentState = theCurrentState;
        return this;
    }

    public boolean hasCurrentState() {
        if (this.currentState == null) {
            return false;
        }
        for (CodeableConcept item : this.currentState) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCurrentState() {
        CodeableConcept t = new CodeableConcept();
        if (this.currentState == null) {
            this.currentState = new ArrayList<CodeableConcept>();
        }
        this.currentState.add(t);
        return t;
    }

    public Citation addCurrentState(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.currentState == null) {
            this.currentState = new ArrayList<CodeableConcept>();
        }
        this.currentState.add(t);
        return this;
    }

    public CodeableConcept getCurrentStateFirstRep() {
        if (this.getCurrentState().isEmpty()) {
            this.addCurrentState();
        }
        return this.getCurrentState().get(0);
    }

    public List<CitationStatusDateComponent> getStatusDate() {
        if (this.statusDate == null) {
            this.statusDate = new ArrayList<CitationStatusDateComponent>();
        }
        return this.statusDate;
    }

    public Citation setStatusDate(List<CitationStatusDateComponent> theStatusDate) {
        this.statusDate = theStatusDate;
        return this;
    }

    public boolean hasStatusDate() {
        if (this.statusDate == null) {
            return false;
        }
        for (CitationStatusDateComponent item : this.statusDate) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CitationStatusDateComponent addStatusDate() {
        CitationStatusDateComponent t = new CitationStatusDateComponent();
        if (this.statusDate == null) {
            this.statusDate = new ArrayList<CitationStatusDateComponent>();
        }
        this.statusDate.add(t);
        return t;
    }

    public Citation addStatusDate(CitationStatusDateComponent t) {
        if (t == null) {
            return this;
        }
        if (this.statusDate == null) {
            this.statusDate = new ArrayList<CitationStatusDateComponent>();
        }
        this.statusDate.add(t);
        return this;
    }

    public CitationStatusDateComponent getStatusDateFirstRep() {
        if (this.getStatusDate().isEmpty()) {
            this.addStatusDate();
        }
        return this.getStatusDate().get(0);
    }

    @Override
    public List<RelatedArtifact> getRelatedArtifact() {
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        return this.relatedArtifact;
    }

    @Override
    public Citation setRelatedArtifact(List<RelatedArtifact> theRelatedArtifact) {
        this.relatedArtifact = theRelatedArtifact;
        return this;
    }

    @Override
    public boolean hasRelatedArtifact() {
        if (this.relatedArtifact == null) {
            return false;
        }
        for (RelatedArtifact item : this.relatedArtifact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public RelatedArtifact addRelatedArtifact() {
        RelatedArtifact t = new RelatedArtifact();
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        this.relatedArtifact.add(t);
        return t;
    }

    @Override
    public Citation addRelatedArtifact(RelatedArtifact t) {
        if (t == null) {
            return this;
        }
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        this.relatedArtifact.add(t);
        return this;
    }

    @Override
    public RelatedArtifact getRelatedArtifactFirstRep() {
        if (this.getRelatedArtifact().isEmpty()) {
            this.addRelatedArtifact();
        }
        return this.getRelatedArtifact().get(0);
    }

    public CitationCitedArtifactComponent getCitedArtifact() {
        if (this.citedArtifact == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.citedArtifact");
            }
            if (Configuration.doAutoCreate()) {
                this.citedArtifact = new CitationCitedArtifactComponent();
            }
        }
        return this.citedArtifact;
    }

    public boolean hasCitedArtifact() {
        return this.citedArtifact != null && !this.citedArtifact.isEmpty();
    }

    public Citation setCitedArtifact(CitationCitedArtifactComponent value) {
        this.citedArtifact = value;
        return this;
    }

    @Override
    public int getTopicMax() {
        return 0;
    }

    @Override
    public List<CodeableConcept> getTopic() {
        return new ArrayList<CodeableConcept>();
    }

    @Override
    public Citation setTopic(List<CodeableConcept> theTopic) {
        throw new Error("The resource type \"Citation\" does not implement the property \"topic\"");
    }

    @Override
    public boolean hasTopic() {
        return false;
    }

    @Override
    public CodeableConcept addTopic() {
        throw new Error("The resource type \"Citation\" does not implement the property \"topic\"");
    }

    @Override
    public Citation addTopic(CodeableConcept t) {
        throw new Error("The resource type \"Citation\" does not implement the property \"topic\"");
    }

    @Override
    public CodeableConcept getTopicFirstRep() {
        throw new Error("The resource type \"Citation\" does not implement the property \"topic\"");
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this citation record when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which an authoritative instance of this summary is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the summary is stored on different servers.", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this citation record when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the citation record when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the citation record author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version));
        children.add(new Property("versionAlgorithm[x]", "string|Coding", "Indicates the mechanism used to compare versions to determine which is more current.", 0, 1, this.versionAlgorithm));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the citation record. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the citation record.", 0, 1, this.title));
        children.add(new Property(SP_STATUS, "code", "The status of this summary. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property("experimental", "boolean", "A Boolean value to indicate that this citation record is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property(SP_DATE, "dateTime", "The date (and optionally time) when the citation record was last significantly changed. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the citation record changes.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the citation record.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the citation from a consumer's perspective.", 0, 1, this.description));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate citation record instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the citation record is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("purpose", "markdown", "Explanation of why this citation is needed and why it has been designed as it has.", 0, 1, this.purpose));
        children.add(new Property("copyright", "markdown", "Use and/or publishing restrictions for the citation record, not for the cited artifact.", 0, 1, this.copyright));
        children.add(new Property("copyrightLabel", "string", "A short string (<50 characters), suitable for inclusion in a page footer that identifies the copyright holder, effective period, and optionally whether rights are resctricted. (e.g. 'All rights reserved', 'Some rights reserved').", 0, 1, this.copyrightLabel));
        children.add(new Property("approvalDate", SP_DATE, "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate));
        children.add(new Property("lastReviewDate", SP_DATE, "The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.", 0, 1, this.lastReviewDate));
        children.add(new Property("effectivePeriod", "Period", "The period during which the citation record content was or is planned to be in active use.", 0, 1, this.effectivePeriod));
        children.add(new Property("author", "ContactDetail", "Who authored or created the citation record.", 0, Integer.MAX_VALUE, this.author));
        children.add(new Property("editor", "ContactDetail", "Who edited or revised the citation record.", 0, Integer.MAX_VALUE, this.editor));
        children.add(new Property("reviewer", "ContactDetail", "Who reviewed the citation record.", 0, Integer.MAX_VALUE, this.reviewer));
        children.add(new Property("endorser", "ContactDetail", "Who endorsed the citation record.", 0, Integer.MAX_VALUE, this.endorser));
        children.add(new Property("summary", "", "A human-readable display of key concepts to represent the citation.", 0, Integer.MAX_VALUE, this.summary));
        children.add(new Property(SP_CLASSIFICATION, "", "The assignment to an organizing scheme.", 0, Integer.MAX_VALUE, this.classification));
        children.add(new Property("note", "Annotation", "Used for general notes and annotations not coded elsewhere.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("currentState", "CodeableConcept", "The status of the citation record.", 0, Integer.MAX_VALUE, this.currentState));
        children.add(new Property("statusDate", "", "The state or status of the citation record paired with an effective date or period for that state.", 0, Integer.MAX_VALUE, this.statusDate));
        children.add(new Property("relatedArtifact", "RelatedArtifact", "Artifact related to the citation record.", 0, Integer.MAX_VALUE, this.relatedArtifact));
        children.add(new Property("citedArtifact", "", "The article or artifact being described.", 0, 1, this.citedArtifact));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this citation record when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which an authoritative instance of this summary is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the summary is stored on different servers.", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this citation record when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the citation record when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the citation record author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version);
            }
            case -115699031: {
                return new Property("versionAlgorithm[x]", "string|Coding", "Indicates the mechanism used to compare versions to determine which is more current.", 0, 1, this.versionAlgorithm);
            }
            case 1508158071: {
                return new Property("versionAlgorithm[x]", "string|Coding", "Indicates the mechanism used to compare versions to determine which is more current.", 0, 1, this.versionAlgorithm);
            }
            case 1836908904: {
                return new Property("versionAlgorithm[x]", "string", "Indicates the mechanism used to compare versions to determine which is more current.", 0, 1, this.versionAlgorithm);
            }
            case 1373807809: {
                return new Property("versionAlgorithm[x]", "Coding", "Indicates the mechanism used to compare versions to determine which is more current.", 0, 1, this.versionAlgorithm);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the citation record. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the citation record.", 0, 1, this.title);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this summary. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A Boolean value to indicate that this citation record is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date (and optionally time) when the citation record was last significantly changed. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the citation record changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the citation record.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the citation from a consumer's perspective.", 0, 1, this.description);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate citation record instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the citation record is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case -220463842: {
                return new Property("purpose", "markdown", "Explanation of why this citation is needed and why it has been designed as it has.", 0, 1, this.purpose);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "Use and/or publishing restrictions for the citation record, not for the cited artifact.", 0, 1, this.copyright);
            }
            case 765157229: {
                return new Property("copyrightLabel", "string", "A short string (<50 characters), suitable for inclusion in a page footer that identifies the copyright holder, effective period, and optionally whether rights are resctricted. (e.g. 'All rights reserved', 'Some rights reserved').", 0, 1, this.copyrightLabel);
            }
            case 223539345: {
                return new Property("approvalDate", SP_DATE, "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate);
            }
            case -1687512484: {
                return new Property("lastReviewDate", SP_DATE, "The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.", 0, 1, this.lastReviewDate);
            }
            case -403934648: {
                return new Property("effectivePeriod", "Period", "The period during which the citation record content was or is planned to be in active use.", 0, 1, this.effectivePeriod);
            }
            case -1406328437: {
                return new Property("author", "ContactDetail", "Who authored or created the citation record.", 0, Integer.MAX_VALUE, this.author);
            }
            case -1307827859: {
                return new Property("editor", "ContactDetail", "Who edited or revised the citation record.", 0, Integer.MAX_VALUE, this.editor);
            }
            case -261190139: {
                return new Property("reviewer", "ContactDetail", "Who reviewed the citation record.", 0, Integer.MAX_VALUE, this.reviewer);
            }
            case 1740277666: {
                return new Property("endorser", "ContactDetail", "Who endorsed the citation record.", 0, Integer.MAX_VALUE, this.endorser);
            }
            case -1857640538: {
                return new Property("summary", "", "A human-readable display of key concepts to represent the citation.", 0, Integer.MAX_VALUE, this.summary);
            }
            case 382350310: {
                return new Property(SP_CLASSIFICATION, "", "The assignment to an organizing scheme.", 0, Integer.MAX_VALUE, this.classification);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Used for general notes and annotations not coded elsewhere.", 0, Integer.MAX_VALUE, this.note);
            }
            case 1457822360: {
                return new Property("currentState", "CodeableConcept", "The status of the citation record.", 0, Integer.MAX_VALUE, this.currentState);
            }
            case 247524032: {
                return new Property("statusDate", "", "The state or status of the citation record paired with an effective date or period for that state.", 0, Integer.MAX_VALUE, this.statusDate);
            }
            case 666807069: {
                return new Property("relatedArtifact", "RelatedArtifact", "Artifact related to the citation record.", 0, Integer.MAX_VALUE, this.relatedArtifact);
            }
            case -495272225: {
                return new Property("citedArtifact", "", "The article or artifact being described.", 0, 1, this.citedArtifact);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 1508158071: {
                Base[] baseArray;
                if (this.versionAlgorithm == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.versionAlgorithm;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.name;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.title;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.purpose;
                }
                return baseArray;
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.copyright;
                }
                return baseArray;
            }
            case 765157229: {
                Base[] baseArray;
                if (this.copyrightLabel == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.copyrightLabel;
                }
                return baseArray;
            }
            case 223539345: {
                Base[] baseArray;
                if (this.approvalDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.approvalDate;
                }
                return baseArray;
            }
            case -1687512484: {
                Base[] baseArray;
                if (this.lastReviewDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.lastReviewDate;
                }
                return baseArray;
            }
            case -403934648: {
                Base[] baseArray;
                if (this.effectivePeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.effectivePeriod;
                }
                return baseArray;
            }
            case -1406328437: {
                return this.author == null ? new Base[]{} : this.author.toArray(new Base[this.author.size()]);
            }
            case -1307827859: {
                return this.editor == null ? new Base[]{} : this.editor.toArray(new Base[this.editor.size()]);
            }
            case -261190139: {
                return this.reviewer == null ? new Base[]{} : this.reviewer.toArray(new Base[this.reviewer.size()]);
            }
            case 1740277666: {
                return this.endorser == null ? new Base[]{} : this.endorser.toArray(new Base[this.endorser.size()]);
            }
            case -1857640538: {
                return this.summary == null ? new Base[]{} : this.summary.toArray(new Base[this.summary.size()]);
            }
            case 382350310: {
                return this.classification == null ? new Base[]{} : this.classification.toArray(new Base[this.classification.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case 1457822360: {
                return this.currentState == null ? new Base[]{} : this.currentState.toArray(new Base[this.currentState.size()]);
            }
            case 247524032: {
                return this.statusDate == null ? new Base[]{} : this.statusDate.toArray(new Base[this.statusDate.size()]);
            }
            case 666807069: {
                return this.relatedArtifact == null ? new Base[]{} : this.relatedArtifact.toArray(new Base[this.relatedArtifact.size()]);
            }
            case -495272225: {
                Base[] baseArray;
                if (this.citedArtifact == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray18 = new Base[1];
                    baseArray = baseArray18;
                    baseArray18[0] = this.citedArtifact;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = TypeConvertor.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 351608024: {
                this.version = TypeConvertor.castToString(value);
                return value;
            }
            case 1508158071: {
                this.versionAlgorithm = TypeConvertor.castToType(value);
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = TypeConvertor.castToString(value);
                return value;
            }
            case -892481550: {
                value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -404562712: {
                this.experimental = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = TypeConvertor.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(TypeConvertor.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -220463842: {
                this.purpose = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 1522889671: {
                this.copyright = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 765157229: {
                this.copyrightLabel = TypeConvertor.castToString(value);
                return value;
            }
            case 223539345: {
                this.approvalDate = TypeConvertor.castToDate(value);
                return value;
            }
            case -1687512484: {
                this.lastReviewDate = TypeConvertor.castToDate(value);
                return value;
            }
            case -403934648: {
                this.effectivePeriod = TypeConvertor.castToPeriod(value);
                return value;
            }
            case -1406328437: {
                this.getAuthor().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -1307827859: {
                this.getEditor().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -261190139: {
                this.getReviewer().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case 1740277666: {
                this.getEndorser().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -1857640538: {
                this.getSummary().add((CitationSummaryComponent)((Object)value));
                return value;
            }
            case 382350310: {
                this.getClassification().add((CitationClassificationComponent)((Object)value));
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
            case 1457822360: {
                this.getCurrentState().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 247524032: {
                this.getStatusDate().add((CitationStatusDateComponent)((Object)value));
                return value;
            }
            case 666807069: {
                this.getRelatedArtifact().add(TypeConvertor.castToRelatedArtifact(value));
                return value;
            }
            case -495272225: {
                this.citedArtifact = (CitationCitedArtifactComponent)((Object)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = TypeConvertor.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = TypeConvertor.castToString(value);
        } else if (name.equals("versionAlgorithm[x]")) {
            this.versionAlgorithm = TypeConvertor.castToType(value);
        } else if (name.equals(SP_NAME)) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = TypeConvertor.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("experimental")) {
            this.experimental = TypeConvertor.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = TypeConvertor.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = TypeConvertor.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(TypeConvertor.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("purpose")) {
            this.purpose = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("copyright")) {
            this.copyright = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("copyrightLabel")) {
            this.copyrightLabel = TypeConvertor.castToString(value);
        } else if (name.equals("approvalDate")) {
            this.approvalDate = TypeConvertor.castToDate(value);
        } else if (name.equals("lastReviewDate")) {
            this.lastReviewDate = TypeConvertor.castToDate(value);
        } else if (name.equals("effectivePeriod")) {
            this.effectivePeriod = TypeConvertor.castToPeriod(value);
        } else if (name.equals("author")) {
            this.getAuthor().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("editor")) {
            this.getEditor().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("reviewer")) {
            this.getReviewer().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("endorser")) {
            this.getEndorser().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("summary")) {
            this.getSummary().add((CitationSummaryComponent)((Object)value));
        } else if (name.equals(SP_CLASSIFICATION)) {
            this.getClassification().add((CitationClassificationComponent)((Object)value));
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else if (name.equals("currentState")) {
            this.getCurrentState().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("statusDate")) {
            this.getStatusDate().add((CitationStatusDateComponent)((Object)value));
        } else if (name.equals("relatedArtifact")) {
            this.getRelatedArtifact().add(TypeConvertor.castToRelatedArtifact(value));
        } else if (name.equals("citedArtifact")) {
            this.citedArtifact = (CitationCitedArtifactComponent)((Object)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = null;
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(value);
        } else if (name.equals(SP_VERSION)) {
            this.version = null;
        } else if (name.equals("versionAlgorithm[x]")) {
            this.versionAlgorithm = null;
        } else if (name.equals(SP_NAME)) {
            this.name = null;
        } else if (name.equals(SP_TITLE)) {
            this.title = null;
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("experimental")) {
            this.experimental = null;
        } else if (name.equals(SP_DATE)) {
            this.date = null;
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = null;
        } else if (name.equals("contact")) {
            this.getContact().remove(value);
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = null;
        } else if (name.equals("useContext")) {
            this.getUseContext().remove(value);
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().remove(value);
        } else if (name.equals("purpose")) {
            this.purpose = null;
        } else if (name.equals("copyright")) {
            this.copyright = null;
        } else if (name.equals("copyrightLabel")) {
            this.copyrightLabel = null;
        } else if (name.equals("approvalDate")) {
            this.approvalDate = null;
        } else if (name.equals("lastReviewDate")) {
            this.lastReviewDate = null;
        } else if (name.equals("effectivePeriod")) {
            this.effectivePeriod = null;
        } else if (name.equals("author")) {
            this.getAuthor().remove(value);
        } else if (name.equals("editor")) {
            this.getEditor().remove(value);
        } else if (name.equals("reviewer")) {
            this.getReviewer().remove(value);
        } else if (name.equals("endorser")) {
            this.getEndorser().remove(value);
        } else if (name.equals("summary")) {
            this.getSummary().remove((CitationSummaryComponent)((Object)value));
        } else if (name.equals(SP_CLASSIFICATION)) {
            this.getClassification().remove((CitationClassificationComponent)((Object)value));
        } else if (name.equals("note")) {
            this.getNote().remove(value);
        } else if (name.equals("currentState")) {
            this.getCurrentState().remove(value);
        } else if (name.equals("statusDate")) {
            this.getStatusDate().remove((CitationStatusDateComponent)((Object)value));
        } else if (name.equals("relatedArtifact")) {
            this.getRelatedArtifact().remove(value);
        } else if (name.equals("citedArtifact")) {
            this.citedArtifact = (CitationCitedArtifactComponent)((Object)value);
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case -115699031: {
                return this.getVersionAlgorithm();
            }
            case 1508158071: {
                return this.getVersionAlgorithm();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case -220463842: {
                return this.getPurposeElement();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case 765157229: {
                return this.getCopyrightLabelElement();
            }
            case 223539345: {
                return this.getApprovalDateElement();
            }
            case -1687512484: {
                return this.getLastReviewDateElement();
            }
            case -403934648: {
                return this.getEffectivePeriod();
            }
            case -1406328437: {
                return this.addAuthor();
            }
            case -1307827859: {
                return this.addEditor();
            }
            case -261190139: {
                return this.addReviewer();
            }
            case 1740277666: {
                return this.addEndorser();
            }
            case -1857640538: {
                return this.addSummary();
            }
            case 382350310: {
                return this.addClassification();
            }
            case 3387378: {
                return this.addNote();
            }
            case 1457822360: {
                return this.addCurrentState();
            }
            case 247524032: {
                return this.addStatusDate();
            }
            case 666807069: {
                return this.addRelatedArtifact();
            }
            case -495272225: {
                return this.getCitedArtifact();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 1508158071: {
                return new String[]{"string", "Coding"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case -220463842: {
                return new String[]{"markdown"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case 765157229: {
                return new String[]{"string"};
            }
            case 223539345: {
                return new String[]{SP_DATE};
            }
            case -1687512484: {
                return new String[]{SP_DATE};
            }
            case -403934648: {
                return new String[]{"Period"};
            }
            case -1406328437: {
                return new String[]{"ContactDetail"};
            }
            case -1307827859: {
                return new String[]{"ContactDetail"};
            }
            case -261190139: {
                return new String[]{"ContactDetail"};
            }
            case 1740277666: {
                return new String[]{"ContactDetail"};
            }
            case -1857640538: {
                return new String[0];
            }
            case 382350310: {
                return new String[0];
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case 1457822360: {
                return new String[]{"CodeableConcept"};
            }
            case 247524032: {
                return new String[0];
            }
            case 666807069: {
                return new String[]{"RelatedArtifact"};
            }
            case -495272225: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a singleton property Citation.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a singleton property Citation.version");
        }
        if (name.equals("versionAlgorithmString")) {
            this.versionAlgorithm = new StringType();
            return this.versionAlgorithm;
        }
        if (name.equals("versionAlgorithmCoding")) {
            this.versionAlgorithm = new Coding();
            return this.versionAlgorithm;
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a singleton property Citation.name");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a singleton property Citation.title");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property Citation.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a singleton property Citation.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a singleton property Citation.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a singleton property Citation.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a singleton property Citation.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a singleton property Citation.purpose");
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a singleton property Citation.copyright");
        }
        if (name.equals("copyrightLabel")) {
            throw new FHIRException("Cannot call addChild on a singleton property Citation.copyrightLabel");
        }
        if (name.equals("approvalDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property Citation.approvalDate");
        }
        if (name.equals("lastReviewDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property Citation.lastReviewDate");
        }
        if (name.equals("effectivePeriod")) {
            this.effectivePeriod = new Period();
            return this.effectivePeriod;
        }
        if (name.equals("author")) {
            return this.addAuthor();
        }
        if (name.equals("editor")) {
            return this.addEditor();
        }
        if (name.equals("reviewer")) {
            return this.addReviewer();
        }
        if (name.equals("endorser")) {
            return this.addEndorser();
        }
        if (name.equals("summary")) {
            return this.addSummary();
        }
        if (name.equals(SP_CLASSIFICATION)) {
            return this.addClassification();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("currentState")) {
            return this.addCurrentState();
        }
        if (name.equals("statusDate")) {
            return this.addStatusDate();
        }
        if (name.equals("relatedArtifact")) {
            return this.addRelatedArtifact();
        }
        if (name.equals("citedArtifact")) {
            this.citedArtifact = new CitationCitedArtifactComponent();
            return this.citedArtifact;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Citation";
    }

    @Override
    public Citation copy() {
        Citation dst = new Citation();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Citation dst) {
        super.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        dst.versionAlgorithm = this.versionAlgorithm == null ? null : this.versionAlgorithm.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.title = this.title == null ? null : this.title.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList<UsageContext>();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        dst.copyrightLabel = this.copyrightLabel == null ? null : this.copyrightLabel.copy();
        dst.approvalDate = this.approvalDate == null ? null : this.approvalDate.copy();
        dst.lastReviewDate = this.lastReviewDate == null ? null : this.lastReviewDate.copy();
        Period period = dst.effectivePeriod = this.effectivePeriod == null ? null : this.effectivePeriod.copy();
        if (this.author != null) {
            dst.author = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.author) {
                dst.author.add(contactDetail.copy());
            }
        }
        if (this.editor != null) {
            dst.editor = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.editor) {
                dst.editor.add(contactDetail.copy());
            }
        }
        if (this.reviewer != null) {
            dst.reviewer = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.reviewer) {
                dst.reviewer.add(contactDetail.copy());
            }
        }
        if (this.endorser != null) {
            dst.endorser = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.endorser) {
                dst.endorser.add(contactDetail.copy());
            }
        }
        if (this.summary != null) {
            dst.summary = new ArrayList<CitationSummaryComponent>();
            for (CitationSummaryComponent citationSummaryComponent : this.summary) {
                dst.summary.add(citationSummaryComponent.copy());
            }
        }
        if (this.classification != null) {
            dst.classification = new ArrayList<CitationClassificationComponent>();
            for (CitationClassificationComponent citationClassificationComponent : this.classification) {
                dst.classification.add(citationClassificationComponent.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.currentState != null) {
            dst.currentState = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.currentState) {
                dst.currentState.add(codeableConcept.copy());
            }
        }
        if (this.statusDate != null) {
            dst.statusDate = new ArrayList<CitationStatusDateComponent>();
            for (CitationStatusDateComponent citationStatusDateComponent : this.statusDate) {
                dst.statusDate.add(citationStatusDateComponent.copy());
            }
        }
        if (this.relatedArtifact != null) {
            dst.relatedArtifact = new ArrayList<RelatedArtifact>();
            for (RelatedArtifact relatedArtifact : this.relatedArtifact) {
                dst.relatedArtifact.add(relatedArtifact.copy());
            }
        }
        dst.citedArtifact = this.citedArtifact == null ? null : this.citedArtifact.copy();
    }

    protected Citation typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Citation)) {
            return false;
        }
        Citation o = (Citation)other_;
        return Citation.compareDeep(this.url, o.url, true) && Citation.compareDeep(this.identifier, o.identifier, true) && Citation.compareDeep(this.version, o.version, true) && Citation.compareDeep(this.versionAlgorithm, o.versionAlgorithm, true) && Citation.compareDeep(this.name, o.name, true) && Citation.compareDeep(this.title, o.title, true) && Citation.compareDeep(this.status, o.status, true) && Citation.compareDeep(this.experimental, o.experimental, true) && Citation.compareDeep(this.date, o.date, true) && Citation.compareDeep(this.publisher, o.publisher, true) && Citation.compareDeep(this.contact, o.contact, true) && Citation.compareDeep(this.description, o.description, true) && Citation.compareDeep(this.useContext, o.useContext, true) && Citation.compareDeep(this.jurisdiction, o.jurisdiction, true) && Citation.compareDeep(this.purpose, o.purpose, true) && Citation.compareDeep(this.copyright, o.copyright, true) && Citation.compareDeep(this.copyrightLabel, o.copyrightLabel, true) && Citation.compareDeep(this.approvalDate, o.approvalDate, true) && Citation.compareDeep(this.lastReviewDate, o.lastReviewDate, true) && Citation.compareDeep(this.effectivePeriod, o.effectivePeriod, true) && Citation.compareDeep(this.author, o.author, true) && Citation.compareDeep(this.editor, o.editor, true) && Citation.compareDeep(this.reviewer, o.reviewer, true) && Citation.compareDeep(this.endorser, o.endorser, true) && Citation.compareDeep(this.summary, o.summary, true) && Citation.compareDeep(this.classification, o.classification, true) && Citation.compareDeep(this.note, o.note, true) && Citation.compareDeep(this.currentState, o.currentState, true) && Citation.compareDeep(this.statusDate, o.statusDate, true) && Citation.compareDeep(this.relatedArtifact, o.relatedArtifact, true) && Citation.compareDeep(this.citedArtifact, o.citedArtifact, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Citation)) {
            return false;
        }
        Citation o = (Citation)other_;
        return Citation.compareValues(this.url, o.url, true) && Citation.compareValues(this.version, o.version, true) && Citation.compareValues(this.name, o.name, true) && Citation.compareValues(this.title, o.title, true) && Citation.compareValues(this.status, o.status, true) && Citation.compareValues(this.experimental, o.experimental, true) && Citation.compareValues(this.date, o.date, true) && Citation.compareValues(this.publisher, o.publisher, true) && Citation.compareValues(this.description, o.description, true) && Citation.compareValues(this.purpose, o.purpose, true) && Citation.compareValues(this.copyright, o.copyright, true) && Citation.compareValues(this.copyrightLabel, o.copyrightLabel, true) && Citation.compareValues(this.approvalDate, o.approvalDate, true) && Citation.compareValues(this.lastReviewDate, o.lastReviewDate, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.url, this.identifier, this.version, this.versionAlgorithm, this.name, this.title, this.status, this.experimental, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.purpose, this.copyright, this.copyrightLabel, this.approvalDate, this.lastReviewDate, this.effectivePeriod, this.author, this.editor, this.reviewer, this.endorser, this.summary, this.classification, this.note, this.currentState, this.statusDate, this.relatedArtifact, this.citedArtifact});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Citation;
    }

    @Block
    public static class ContributorshipSummaryComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Such as author list, contributorship statement, funding statement, acknowledgements statement, or conflicts of interest statement", formalDefinition="Used most commonly to express an author list or a contributorship statement.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/contributor-summary-type")
        protected CodeableConcept type;
        @Child(name="style", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The format for the display string", formalDefinition="The format for the display string, such as author last name with first letter capitalized followed by forename initials.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/contributor-summary-style")
        protected CodeableConcept style;
        @Child(name="source", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Used to code the producer or rule for creating the display string", formalDefinition="Used to code the producer or rule for creating the display string.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/contributor-summary-source")
        protected CodeableConcept source;
        @Child(name="value", type={MarkdownType.class}, order=4, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The display string for the author list, contributor list, or contributorship statement", formalDefinition="The display string for the author list, contributor list, or contributorship statement.")
        protected MarkdownType value;
        private static final long serialVersionUID = 1353383781L;

        public ContributorshipSummaryComponent() {
        }

        public ContributorshipSummaryComponent(String value) {
            this.setValue(value);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ContributorshipSummaryComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ContributorshipSummaryComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public CodeableConcept getStyle() {
            if (this.style == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ContributorshipSummaryComponent.style");
                }
                if (Configuration.doAutoCreate()) {
                    this.style = new CodeableConcept();
                }
            }
            return this.style;
        }

        public boolean hasStyle() {
            return this.style != null && !this.style.isEmpty();
        }

        public ContributorshipSummaryComponent setStyle(CodeableConcept value) {
            this.style = value;
            return this;
        }

        public CodeableConcept getSource() {
            if (this.source == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ContributorshipSummaryComponent.source");
                }
                if (Configuration.doAutoCreate()) {
                    this.source = new CodeableConcept();
                }
            }
            return this.source;
        }

        public boolean hasSource() {
            return this.source != null && !this.source.isEmpty();
        }

        public ContributorshipSummaryComponent setSource(CodeableConcept value) {
            this.source = value;
            return this;
        }

        public MarkdownType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ContributorshipSummaryComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new MarkdownType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ContributorshipSummaryComponent setValueElement(MarkdownType value) {
            this.value = value;
            return this;
        }

        public String getValue() {
            return this.value == null ? null : (String)this.value.getValue();
        }

        public ContributorshipSummaryComponent setValue(String value) {
            if (this.value == null) {
                this.value = new MarkdownType();
            }
            this.value.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Used most commonly to express an author list or a contributorship statement.", 0, 1, this.type));
            children.add(new Property("style", "CodeableConcept", "The format for the display string, such as author last name with first letter capitalized followed by forename initials.", 0, 1, this.style));
            children.add(new Property("source", "CodeableConcept", "Used to code the producer or rule for creating the display string.", 0, 1, this.source));
            children.add(new Property("value", "markdown", "The display string for the author list, contributor list, or contributorship statement.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Used most commonly to express an author list or a contributorship statement.", 0, 1, this.type);
                }
                case 109780401: {
                    return new Property("style", "CodeableConcept", "The format for the display string, such as author last name with first letter capitalized followed by forename initials.", 0, 1, this.style);
                }
                case -896505829: {
                    return new Property("source", "CodeableConcept", "Used to code the producer or rule for creating the display string.", 0, 1, this.source);
                }
                case 111972721: {
                    return new Property("value", "markdown", "The display string for the author list, contributor list, or contributorship statement.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 109780401: {
                    Base[] baseArray;
                    if (this.style == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.style;
                    }
                    return baseArray;
                }
                case -896505829: {
                    Base[] baseArray;
                    if (this.source == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.source;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 109780401: {
                    this.style = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -896505829: {
                    this.source = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToMarkdown(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("style")) {
                this.style = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("source")) {
                this.source = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value")) {
                this.value = TypeConvertor.castToMarkdown(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = null;
            } else if (name.equals("style")) {
                this.style = null;
            } else if (name.equals("source")) {
                this.source = null;
            } else if (name.equals("value")) {
                this.value = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 109780401: {
                    return this.getStyle();
                }
                case -896505829: {
                    return this.getSource();
                }
                case 111972721: {
                    return this.getValueElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 109780401: {
                    return new String[]{"CodeableConcept"};
                }
                case -896505829: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"markdown"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("style")) {
                this.style = new CodeableConcept();
                return this.style;
            }
            if (name.equals("source")) {
                this.source = new CodeableConcept();
                return this.source;
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a singleton property Citation.citedArtifact.contributorship.summary.value");
            }
            return super.addChild(name);
        }

        @Override
        public ContributorshipSummaryComponent copy() {
            ContributorshipSummaryComponent dst = new ContributorshipSummaryComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ContributorshipSummaryComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.style = this.style == null ? null : this.style.copy();
            dst.source = this.source == null ? null : this.source.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ContributorshipSummaryComponent)) {
                return false;
            }
            ContributorshipSummaryComponent o = (ContributorshipSummaryComponent)other_;
            return ContributorshipSummaryComponent.compareDeep(this.type, o.type, true) && ContributorshipSummaryComponent.compareDeep(this.style, o.style, true) && ContributorshipSummaryComponent.compareDeep(this.source, o.source, true) && ContributorshipSummaryComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ContributorshipSummaryComponent)) {
                return false;
            }
            ContributorshipSummaryComponent o = (ContributorshipSummaryComponent)other_;
            return ContributorshipSummaryComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.style, this.source, this.value});
        }

        @Override
        public String fhirType() {
            return "Citation.citedArtifact.contributorship.summary";
        }
    }

    @Block
    public static class CitationCitedArtifactContributorshipEntryContributionInstanceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The specific contribution", formalDefinition="The specific contribution.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/artifact-contribution-instance-type")
        protected CodeableConcept type;
        @Child(name="time", type={DateTimeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The time that the contribution was made", formalDefinition="The time that the contribution was made.")
        protected DateTimeType time;
        private static final long serialVersionUID = -196837729L;

        public CitationCitedArtifactContributorshipEntryContributionInstanceComponent() {
        }

        public CitationCitedArtifactContributorshipEntryContributionInstanceComponent(CodeableConcept type) {
            this.setType(type);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactContributorshipEntryContributionInstanceComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public CitationCitedArtifactContributorshipEntryContributionInstanceComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public DateTimeType getTimeElement() {
            if (this.time == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactContributorshipEntryContributionInstanceComponent.time");
                }
                if (Configuration.doAutoCreate()) {
                    this.time = new DateTimeType();
                }
            }
            return this.time;
        }

        public boolean hasTimeElement() {
            return this.time != null && !this.time.isEmpty();
        }

        public boolean hasTime() {
            return this.time != null && !this.time.isEmpty();
        }

        public CitationCitedArtifactContributorshipEntryContributionInstanceComponent setTimeElement(DateTimeType value) {
            this.time = value;
            return this;
        }

        public Date getTime() {
            return this.time == null ? null : (Date)this.time.getValue();
        }

        public CitationCitedArtifactContributorshipEntryContributionInstanceComponent setTime(Date value) {
            if (value == null) {
                this.time = null;
            } else {
                if (this.time == null) {
                    this.time = new DateTimeType();
                }
                this.time.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "The specific contribution.", 0, 1, this.type));
            children.add(new Property("time", "dateTime", "The time that the contribution was made.", 0, 1, this.time));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The specific contribution.", 0, 1, this.type);
                }
                case 3560141: {
                    return new Property("time", "dateTime", "The time that the contribution was made.", 0, 1, this.time);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 3560141: {
                    Base[] baseArray;
                    if (this.time == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.time;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 3560141: {
                    this.time = TypeConvertor.castToDateTime(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("time")) {
                this.time = TypeConvertor.castToDateTime(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = null;
            } else if (name.equals("time")) {
                this.time = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 3560141: {
                    return this.getTimeElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 3560141: {
                    return new String[]{"dateTime"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("time")) {
                throw new FHIRException("Cannot call addChild on a singleton property Citation.citedArtifact.contributorship.entry.contributionInstance.time");
            }
            return super.addChild(name);
        }

        @Override
        public CitationCitedArtifactContributorshipEntryContributionInstanceComponent copy() {
            CitationCitedArtifactContributorshipEntryContributionInstanceComponent dst = new CitationCitedArtifactContributorshipEntryContributionInstanceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationCitedArtifactContributorshipEntryContributionInstanceComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.time = this.time == null ? null : this.time.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactContributorshipEntryContributionInstanceComponent)) {
                return false;
            }
            CitationCitedArtifactContributorshipEntryContributionInstanceComponent o = (CitationCitedArtifactContributorshipEntryContributionInstanceComponent)other_;
            return CitationCitedArtifactContributorshipEntryContributionInstanceComponent.compareDeep(this.type, o.type, true) && CitationCitedArtifactContributorshipEntryContributionInstanceComponent.compareDeep(this.time, o.time, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactContributorshipEntryContributionInstanceComponent)) {
                return false;
            }
            CitationCitedArtifactContributorshipEntryContributionInstanceComponent o = (CitationCitedArtifactContributorshipEntryContributionInstanceComponent)other_;
            return CitationCitedArtifactContributorshipEntryContributionInstanceComponent.compareValues(this.time, o.time, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.time});
        }

        @Override
        public String fhirType() {
            return "Citation.citedArtifact.contributorship.entry.contributionInstance";
        }
    }

    @Block
    public static class CitationCitedArtifactContributorshipEntryComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="contributor", type={Practitioner.class, Organization.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The identity of the individual contributor", formalDefinition="The identity of the individual contributor.")
        protected Reference contributor;
        @Child(name="forenameInitials", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="For citation styles that use initials", formalDefinition="For citation styles that use initials.")
        protected StringType forenameInitials;
        @Child(name="affiliation", type={Organization.class, PractitionerRole.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Organizational affiliation", formalDefinition="Organization affiliated with the contributor.")
        protected List<Reference> affiliation;
        @Child(name="contributionType", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The specific contribution", formalDefinition="This element identifies the specific nature of an individual\u2019s contribution with respect to the cited work.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/artifact-contribution-type")
        protected List<CodeableConcept> contributionType;
        @Child(name="role", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The role of the contributor (e.g. author, editor, reviewer, funder)", formalDefinition="The role of the contributor (e.g. author, editor, reviewer, funder).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/contributor-role")
        protected CodeableConcept role;
        @Child(name="contributionInstance", type={}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Contributions with accounting for time or number", formalDefinition="Contributions with accounting for time or number.")
        protected List<CitationCitedArtifactContributorshipEntryContributionInstanceComponent> contributionInstance;
        @Child(name="correspondingContact", type={BooleanType.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Whether the contributor is the corresponding contributor for the role", formalDefinition="Whether the contributor is the corresponding contributor for the role.")
        protected BooleanType correspondingContact;
        @Child(name="rankingOrder", type={PositiveIntType.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Ranked order of contribution", formalDefinition="Provides a numerical ranking to represent the degree of contributorship relative to other contributors, such as 1 for first author and 2 for second author.")
        protected PositiveIntType rankingOrder;
        private static final long serialVersionUID = 1654594857L;

        public CitationCitedArtifactContributorshipEntryComponent() {
        }

        public CitationCitedArtifactContributorshipEntryComponent(Reference contributor) {
            this.setContributor(contributor);
        }

        public Reference getContributor() {
            if (this.contributor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactContributorshipEntryComponent.contributor");
                }
                if (Configuration.doAutoCreate()) {
                    this.contributor = new Reference();
                }
            }
            return this.contributor;
        }

        public boolean hasContributor() {
            return this.contributor != null && !this.contributor.isEmpty();
        }

        public CitationCitedArtifactContributorshipEntryComponent setContributor(Reference value) {
            this.contributor = value;
            return this;
        }

        public StringType getForenameInitialsElement() {
            if (this.forenameInitials == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactContributorshipEntryComponent.forenameInitials");
                }
                if (Configuration.doAutoCreate()) {
                    this.forenameInitials = new StringType();
                }
            }
            return this.forenameInitials;
        }

        public boolean hasForenameInitialsElement() {
            return this.forenameInitials != null && !this.forenameInitials.isEmpty();
        }

        public boolean hasForenameInitials() {
            return this.forenameInitials != null && !this.forenameInitials.isEmpty();
        }

        public CitationCitedArtifactContributorshipEntryComponent setForenameInitialsElement(StringType value) {
            this.forenameInitials = value;
            return this;
        }

        public String getForenameInitials() {
            return this.forenameInitials == null ? null : (String)this.forenameInitials.getValue();
        }

        public CitationCitedArtifactContributorshipEntryComponent setForenameInitials(String value) {
            if (Utilities.noString((String)value)) {
                this.forenameInitials = null;
            } else {
                if (this.forenameInitials == null) {
                    this.forenameInitials = new StringType();
                }
                this.forenameInitials.setValue(value);
            }
            return this;
        }

        public List<Reference> getAffiliation() {
            if (this.affiliation == null) {
                this.affiliation = new ArrayList<Reference>();
            }
            return this.affiliation;
        }

        public CitationCitedArtifactContributorshipEntryComponent setAffiliation(List<Reference> theAffiliation) {
            this.affiliation = theAffiliation;
            return this;
        }

        public boolean hasAffiliation() {
            if (this.affiliation == null) {
                return false;
            }
            for (Reference item : this.affiliation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addAffiliation() {
            Reference t = new Reference();
            if (this.affiliation == null) {
                this.affiliation = new ArrayList<Reference>();
            }
            this.affiliation.add(t);
            return t;
        }

        public CitationCitedArtifactContributorshipEntryComponent addAffiliation(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.affiliation == null) {
                this.affiliation = new ArrayList<Reference>();
            }
            this.affiliation.add(t);
            return this;
        }

        public Reference getAffiliationFirstRep() {
            if (this.getAffiliation().isEmpty()) {
                this.addAffiliation();
            }
            return this.getAffiliation().get(0);
        }

        public List<CodeableConcept> getContributionType() {
            if (this.contributionType == null) {
                this.contributionType = new ArrayList<CodeableConcept>();
            }
            return this.contributionType;
        }

        public CitationCitedArtifactContributorshipEntryComponent setContributionType(List<CodeableConcept> theContributionType) {
            this.contributionType = theContributionType;
            return this;
        }

        public boolean hasContributionType() {
            if (this.contributionType == null) {
                return false;
            }
            for (CodeableConcept item : this.contributionType) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addContributionType() {
            CodeableConcept t = new CodeableConcept();
            if (this.contributionType == null) {
                this.contributionType = new ArrayList<CodeableConcept>();
            }
            this.contributionType.add(t);
            return t;
        }

        public CitationCitedArtifactContributorshipEntryComponent addContributionType(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.contributionType == null) {
                this.contributionType = new ArrayList<CodeableConcept>();
            }
            this.contributionType.add(t);
            return this;
        }

        public CodeableConcept getContributionTypeFirstRep() {
            if (this.getContributionType().isEmpty()) {
                this.addContributionType();
            }
            return this.getContributionType().get(0);
        }

        public CodeableConcept getRole() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactContributorshipEntryComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new CodeableConcept();
                }
            }
            return this.role;
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public CitationCitedArtifactContributorshipEntryComponent setRole(CodeableConcept value) {
            this.role = value;
            return this;
        }

        public List<CitationCitedArtifactContributorshipEntryContributionInstanceComponent> getContributionInstance() {
            if (this.contributionInstance == null) {
                this.contributionInstance = new ArrayList<CitationCitedArtifactContributorshipEntryContributionInstanceComponent>();
            }
            return this.contributionInstance;
        }

        public CitationCitedArtifactContributorshipEntryComponent setContributionInstance(List<CitationCitedArtifactContributorshipEntryContributionInstanceComponent> theContributionInstance) {
            this.contributionInstance = theContributionInstance;
            return this;
        }

        public boolean hasContributionInstance() {
            if (this.contributionInstance == null) {
                return false;
            }
            for (CitationCitedArtifactContributorshipEntryContributionInstanceComponent item : this.contributionInstance) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CitationCitedArtifactContributorshipEntryContributionInstanceComponent addContributionInstance() {
            CitationCitedArtifactContributorshipEntryContributionInstanceComponent t = new CitationCitedArtifactContributorshipEntryContributionInstanceComponent();
            if (this.contributionInstance == null) {
                this.contributionInstance = new ArrayList<CitationCitedArtifactContributorshipEntryContributionInstanceComponent>();
            }
            this.contributionInstance.add(t);
            return t;
        }

        public CitationCitedArtifactContributorshipEntryComponent addContributionInstance(CitationCitedArtifactContributorshipEntryContributionInstanceComponent t) {
            if (t == null) {
                return this;
            }
            if (this.contributionInstance == null) {
                this.contributionInstance = new ArrayList<CitationCitedArtifactContributorshipEntryContributionInstanceComponent>();
            }
            this.contributionInstance.add(t);
            return this;
        }

        public CitationCitedArtifactContributorshipEntryContributionInstanceComponent getContributionInstanceFirstRep() {
            if (this.getContributionInstance().isEmpty()) {
                this.addContributionInstance();
            }
            return this.getContributionInstance().get(0);
        }

        public BooleanType getCorrespondingContactElement() {
            if (this.correspondingContact == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactContributorshipEntryComponent.correspondingContact");
                }
                if (Configuration.doAutoCreate()) {
                    this.correspondingContact = new BooleanType();
                }
            }
            return this.correspondingContact;
        }

        public boolean hasCorrespondingContactElement() {
            return this.correspondingContact != null && !this.correspondingContact.isEmpty();
        }

        public boolean hasCorrespondingContact() {
            return this.correspondingContact != null && !this.correspondingContact.isEmpty();
        }

        public CitationCitedArtifactContributorshipEntryComponent setCorrespondingContactElement(BooleanType value) {
            this.correspondingContact = value;
            return this;
        }

        public boolean getCorrespondingContact() {
            return this.correspondingContact == null || this.correspondingContact.isEmpty() ? false : (Boolean)this.correspondingContact.getValue();
        }

        public CitationCitedArtifactContributorshipEntryComponent setCorrespondingContact(boolean value) {
            if (this.correspondingContact == null) {
                this.correspondingContact = new BooleanType();
            }
            this.correspondingContact.setValue((Object)value);
            return this;
        }

        public PositiveIntType getRankingOrderElement() {
            if (this.rankingOrder == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactContributorshipEntryComponent.rankingOrder");
                }
                if (Configuration.doAutoCreate()) {
                    this.rankingOrder = new PositiveIntType();
                }
            }
            return this.rankingOrder;
        }

        public boolean hasRankingOrderElement() {
            return this.rankingOrder != null && !this.rankingOrder.isEmpty();
        }

        public boolean hasRankingOrder() {
            return this.rankingOrder != null && !this.rankingOrder.isEmpty();
        }

        public CitationCitedArtifactContributorshipEntryComponent setRankingOrderElement(PositiveIntType value) {
            this.rankingOrder = value;
            return this;
        }

        public int getRankingOrder() {
            return this.rankingOrder == null || this.rankingOrder.isEmpty() ? 0 : (Integer)this.rankingOrder.getValue();
        }

        public CitationCitedArtifactContributorshipEntryComponent setRankingOrder(int value) {
            if (this.rankingOrder == null) {
                this.rankingOrder = new PositiveIntType();
            }
            this.rankingOrder.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("contributor", "Reference(Practitioner|Organization)", "The identity of the individual contributor.", 0, 1, this.contributor));
            children.add(new Property("forenameInitials", "string", "For citation styles that use initials.", 0, 1, this.forenameInitials));
            children.add(new Property("affiliation", "Reference(Organization|PractitionerRole)", "Organization affiliated with the contributor.", 0, Integer.MAX_VALUE, this.affiliation));
            children.add(new Property("contributionType", "CodeableConcept", "This element identifies the specific nature of an individual\u2019s contribution with respect to the cited work.", 0, Integer.MAX_VALUE, this.contributionType));
            children.add(new Property("role", "CodeableConcept", "The role of the contributor (e.g. author, editor, reviewer, funder).", 0, 1, this.role));
            children.add(new Property("contributionInstance", "", "Contributions with accounting for time or number.", 0, Integer.MAX_VALUE, this.contributionInstance));
            children.add(new Property("correspondingContact", "boolean", "Whether the contributor is the corresponding contributor for the role.", 0, 1, this.correspondingContact));
            children.add(new Property("rankingOrder", "positiveInt", "Provides a numerical ranking to represent the degree of contributorship relative to other contributors, such as 1 for first author and 2 for second author.", 0, 1, this.rankingOrder));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1895276325: {
                    return new Property("contributor", "Reference(Practitioner|Organization)", "The identity of the individual contributor.", 0, 1, this.contributor);
                }
                case -740521962: {
                    return new Property("forenameInitials", "string", "For citation styles that use initials.", 0, 1, this.forenameInitials);
                }
                case 2019918576: {
                    return new Property("affiliation", "Reference(Organization|PractitionerRole)", "Organization affiliated with the contributor.", 0, Integer.MAX_VALUE, this.affiliation);
                }
                case -1600446614: {
                    return new Property("contributionType", "CodeableConcept", "This element identifies the specific nature of an individual\u2019s contribution with respect to the cited work.", 0, Integer.MAX_VALUE, this.contributionType);
                }
                case 3506294: {
                    return new Property("role", "CodeableConcept", "The role of the contributor (e.g. author, editor, reviewer, funder).", 0, 1, this.role);
                }
                case -547910459: {
                    return new Property("contributionInstance", "", "Contributions with accounting for time or number.", 0, Integer.MAX_VALUE, this.contributionInstance);
                }
                case -1816008851: {
                    return new Property("correspondingContact", "boolean", "Whether the contributor is the corresponding contributor for the role.", 0, 1, this.correspondingContact);
                }
                case -762905416: {
                    return new Property("rankingOrder", "positiveInt", "Provides a numerical ranking to represent the degree of contributorship relative to other contributors, such as 1 for first author and 2 for second author.", 0, 1, this.rankingOrder);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1895276325: {
                    Base[] baseArray;
                    if (this.contributor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.contributor;
                    }
                    return baseArray;
                }
                case -740521962: {
                    Base[] baseArray;
                    if (this.forenameInitials == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.forenameInitials;
                    }
                    return baseArray;
                }
                case 2019918576: {
                    return this.affiliation == null ? new Base[]{} : this.affiliation.toArray(new Base[this.affiliation.size()]);
                }
                case -1600446614: {
                    return this.contributionType == null ? new Base[]{} : this.contributionType.toArray(new Base[this.contributionType.size()]);
                }
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.role;
                    }
                    return baseArray;
                }
                case -547910459: {
                    return this.contributionInstance == null ? new Base[]{} : this.contributionInstance.toArray(new Base[this.contributionInstance.size()]);
                }
                case -1816008851: {
                    Base[] baseArray;
                    if (this.correspondingContact == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.correspondingContact;
                    }
                    return baseArray;
                }
                case -762905416: {
                    Base[] baseArray;
                    if (this.rankingOrder == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.rankingOrder;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1895276325: {
                    this.contributor = TypeConvertor.castToReference(value);
                    return value;
                }
                case -740521962: {
                    this.forenameInitials = TypeConvertor.castToString(value);
                    return value;
                }
                case 2019918576: {
                    this.getAffiliation().add(TypeConvertor.castToReference(value));
                    return value;
                }
                case -1600446614: {
                    this.getContributionType().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 3506294: {
                    this.role = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -547910459: {
                    this.getContributionInstance().add((CitationCitedArtifactContributorshipEntryContributionInstanceComponent)value);
                    return value;
                }
                case -1816008851: {
                    this.correspondingContact = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -762905416: {
                    this.rankingOrder = TypeConvertor.castToPositiveInt(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("contributor")) {
                this.contributor = TypeConvertor.castToReference(value);
            } else if (name.equals("forenameInitials")) {
                this.forenameInitials = TypeConvertor.castToString(value);
            } else if (name.equals("affiliation")) {
                this.getAffiliation().add(TypeConvertor.castToReference(value));
            } else if (name.equals("contributionType")) {
                this.getContributionType().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("role")) {
                this.role = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("contributionInstance")) {
                this.getContributionInstance().add((CitationCitedArtifactContributorshipEntryContributionInstanceComponent)value);
            } else if (name.equals("correspondingContact")) {
                this.correspondingContact = TypeConvertor.castToBoolean(value);
            } else if (name.equals("rankingOrder")) {
                this.rankingOrder = TypeConvertor.castToPositiveInt(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("contributor")) {
                this.contributor = null;
            } else if (name.equals("forenameInitials")) {
                this.forenameInitials = null;
            } else if (name.equals("affiliation")) {
                this.getAffiliation().remove(value);
            } else if (name.equals("contributionType")) {
                this.getContributionType().remove(value);
            } else if (name.equals("role")) {
                this.role = null;
            } else if (name.equals("contributionInstance")) {
                this.getContributionInstance().remove((CitationCitedArtifactContributorshipEntryContributionInstanceComponent)value);
            } else if (name.equals("correspondingContact")) {
                this.correspondingContact = null;
            } else if (name.equals("rankingOrder")) {
                this.rankingOrder = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1895276325: {
                    return this.getContributor();
                }
                case -740521962: {
                    return this.getForenameInitialsElement();
                }
                case 2019918576: {
                    return this.addAffiliation();
                }
                case -1600446614: {
                    return this.addContributionType();
                }
                case 3506294: {
                    return this.getRole();
                }
                case -547910459: {
                    return this.addContributionInstance();
                }
                case -1816008851: {
                    return this.getCorrespondingContactElement();
                }
                case -762905416: {
                    return this.getRankingOrderElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1895276325: {
                    return new String[]{"Reference"};
                }
                case -740521962: {
                    return new String[]{"string"};
                }
                case 2019918576: {
                    return new String[]{"Reference"};
                }
                case -1600446614: {
                    return new String[]{"CodeableConcept"};
                }
                case 3506294: {
                    return new String[]{"CodeableConcept"};
                }
                case -547910459: {
                    return new String[0];
                }
                case -1816008851: {
                    return new String[]{"boolean"};
                }
                case -762905416: {
                    return new String[]{"positiveInt"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("contributor")) {
                this.contributor = new Reference();
                return this.contributor;
            }
            if (name.equals("forenameInitials")) {
                throw new FHIRException("Cannot call addChild on a singleton property Citation.citedArtifact.contributorship.entry.forenameInitials");
            }
            if (name.equals("affiliation")) {
                return this.addAffiliation();
            }
            if (name.equals("contributionType")) {
                return this.addContributionType();
            }
            if (name.equals("role")) {
                this.role = new CodeableConcept();
                return this.role;
            }
            if (name.equals("contributionInstance")) {
                return this.addContributionInstance();
            }
            if (name.equals("correspondingContact")) {
                throw new FHIRException("Cannot call addChild on a singleton property Citation.citedArtifact.contributorship.entry.correspondingContact");
            }
            if (name.equals("rankingOrder")) {
                throw new FHIRException("Cannot call addChild on a singleton property Citation.citedArtifact.contributorship.entry.rankingOrder");
            }
            return super.addChild(name);
        }

        @Override
        public CitationCitedArtifactContributorshipEntryComponent copy() {
            CitationCitedArtifactContributorshipEntryComponent dst = new CitationCitedArtifactContributorshipEntryComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationCitedArtifactContributorshipEntryComponent dst) {
            super.copyValues(dst);
            dst.contributor = this.contributor == null ? null : this.contributor.copy();
            StringType stringType = dst.forenameInitials = this.forenameInitials == null ? null : this.forenameInitials.copy();
            if (this.affiliation != null) {
                dst.affiliation = new ArrayList<Reference>();
                for (Reference reference : this.affiliation) {
                    dst.affiliation.add(reference.copy());
                }
            }
            if (this.contributionType != null) {
                dst.contributionType = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.contributionType) {
                    dst.contributionType.add(codeableConcept.copy());
                }
            }
            CodeableConcept codeableConcept = dst.role = this.role == null ? null : this.role.copy();
            if (this.contributionInstance != null) {
                dst.contributionInstance = new ArrayList<CitationCitedArtifactContributorshipEntryContributionInstanceComponent>();
                for (CitationCitedArtifactContributorshipEntryContributionInstanceComponent citationCitedArtifactContributorshipEntryContributionInstanceComponent : this.contributionInstance) {
                    dst.contributionInstance.add(citationCitedArtifactContributorshipEntryContributionInstanceComponent.copy());
                }
            }
            dst.correspondingContact = this.correspondingContact == null ? null : this.correspondingContact.copy();
            dst.rankingOrder = this.rankingOrder == null ? null : this.rankingOrder.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactContributorshipEntryComponent)) {
                return false;
            }
            CitationCitedArtifactContributorshipEntryComponent o = (CitationCitedArtifactContributorshipEntryComponent)other_;
            return CitationCitedArtifactContributorshipEntryComponent.compareDeep(this.contributor, o.contributor, true) && CitationCitedArtifactContributorshipEntryComponent.compareDeep(this.forenameInitials, o.forenameInitials, true) && CitationCitedArtifactContributorshipEntryComponent.compareDeep(this.affiliation, o.affiliation, true) && CitationCitedArtifactContributorshipEntryComponent.compareDeep(this.contributionType, o.contributionType, true) && CitationCitedArtifactContributorshipEntryComponent.compareDeep(this.role, o.role, true) && CitationCitedArtifactContributorshipEntryComponent.compareDeep(this.contributionInstance, o.contributionInstance, true) && CitationCitedArtifactContributorshipEntryComponent.compareDeep(this.correspondingContact, o.correspondingContact, true) && CitationCitedArtifactContributorshipEntryComponent.compareDeep(this.rankingOrder, o.rankingOrder, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactContributorshipEntryComponent)) {
                return false;
            }
            CitationCitedArtifactContributorshipEntryComponent o = (CitationCitedArtifactContributorshipEntryComponent)other_;
            return CitationCitedArtifactContributorshipEntryComponent.compareValues(this.forenameInitials, o.forenameInitials, true) && CitationCitedArtifactContributorshipEntryComponent.compareValues(this.correspondingContact, o.correspondingContact, true) && CitationCitedArtifactContributorshipEntryComponent.compareValues(this.rankingOrder, o.rankingOrder, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.contributor, this.forenameInitials, this.affiliation, this.contributionType, this.role, this.contributionInstance, this.correspondingContact, this.rankingOrder});
        }

        @Override
        public String fhirType() {
            return "Citation.citedArtifact.contributorship.entry";
        }
    }

    @Block
    public static class CitationCitedArtifactContributorshipComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="complete", type={BooleanType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Indicates if the list includes all authors and/or contributors", formalDefinition="Indicates if the list includes all authors and/or contributors.")
        protected BooleanType complete;
        @Child(name="entry", type={}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="An individual entity named as a contributor", formalDefinition="An individual entity named as a contributor, for example in the author list or contributor list.")
        protected List<CitationCitedArtifactContributorshipEntryComponent> entry;
        @Child(name="summary", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Used to record a display of the author/contributor list without separate data element for each list member", formalDefinition="Used to record a display of the author/contributor list without separate data element for each list member.")
        protected List<ContributorshipSummaryComponent> summary;
        private static final long serialVersionUID = 662810405L;

        public BooleanType getCompleteElement() {
            if (this.complete == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactContributorshipComponent.complete");
                }
                if (Configuration.doAutoCreate()) {
                    this.complete = new BooleanType();
                }
            }
            return this.complete;
        }

        public boolean hasCompleteElement() {
            return this.complete != null && !this.complete.isEmpty();
        }

        public boolean hasComplete() {
            return this.complete != null && !this.complete.isEmpty();
        }

        public CitationCitedArtifactContributorshipComponent setCompleteElement(BooleanType value) {
            this.complete = value;
            return this;
        }

        public boolean getComplete() {
            return this.complete == null || this.complete.isEmpty() ? false : (Boolean)this.complete.getValue();
        }

        public CitationCitedArtifactContributorshipComponent setComplete(boolean value) {
            if (this.complete == null) {
                this.complete = new BooleanType();
            }
            this.complete.setValue((Object)value);
            return this;
        }

        public List<CitationCitedArtifactContributorshipEntryComponent> getEntry() {
            if (this.entry == null) {
                this.entry = new ArrayList<CitationCitedArtifactContributorshipEntryComponent>();
            }
            return this.entry;
        }

        public CitationCitedArtifactContributorshipComponent setEntry(List<CitationCitedArtifactContributorshipEntryComponent> theEntry) {
            this.entry = theEntry;
            return this;
        }

        public boolean hasEntry() {
            if (this.entry == null) {
                return false;
            }
            for (CitationCitedArtifactContributorshipEntryComponent item : this.entry) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CitationCitedArtifactContributorshipEntryComponent addEntry() {
            CitationCitedArtifactContributorshipEntryComponent t = new CitationCitedArtifactContributorshipEntryComponent();
            if (this.entry == null) {
                this.entry = new ArrayList<CitationCitedArtifactContributorshipEntryComponent>();
            }
            this.entry.add(t);
            return t;
        }

        public CitationCitedArtifactContributorshipComponent addEntry(CitationCitedArtifactContributorshipEntryComponent t) {
            if (t == null) {
                return this;
            }
            if (this.entry == null) {
                this.entry = new ArrayList<CitationCitedArtifactContributorshipEntryComponent>();
            }
            this.entry.add(t);
            return this;
        }

        public CitationCitedArtifactContributorshipEntryComponent getEntryFirstRep() {
            if (this.getEntry().isEmpty()) {
                this.addEntry();
            }
            return this.getEntry().get(0);
        }

        public List<ContributorshipSummaryComponent> getSummary() {
            if (this.summary == null) {
                this.summary = new ArrayList<ContributorshipSummaryComponent>();
            }
            return this.summary;
        }

        public CitationCitedArtifactContributorshipComponent setSummary(List<ContributorshipSummaryComponent> theSummary) {
            this.summary = theSummary;
            return this;
        }

        public boolean hasSummary() {
            if (this.summary == null) {
                return false;
            }
            for (ContributorshipSummaryComponent item : this.summary) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ContributorshipSummaryComponent addSummary() {
            ContributorshipSummaryComponent t = new ContributorshipSummaryComponent();
            if (this.summary == null) {
                this.summary = new ArrayList<ContributorshipSummaryComponent>();
            }
            this.summary.add(t);
            return t;
        }

        public CitationCitedArtifactContributorshipComponent addSummary(ContributorshipSummaryComponent t) {
            if (t == null) {
                return this;
            }
            if (this.summary == null) {
                this.summary = new ArrayList<ContributorshipSummaryComponent>();
            }
            this.summary.add(t);
            return this;
        }

        public ContributorshipSummaryComponent getSummaryFirstRep() {
            if (this.getSummary().isEmpty()) {
                this.addSummary();
            }
            return this.getSummary().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("complete", "boolean", "Indicates if the list includes all authors and/or contributors.", 0, 1, this.complete));
            children.add(new Property("entry", "", "An individual entity named as a contributor, for example in the author list or contributor list.", 0, Integer.MAX_VALUE, this.entry));
            children.add(new Property("summary", "", "Used to record a display of the author/contributor list without separate data element for each list member.", 0, Integer.MAX_VALUE, this.summary));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -599445191: {
                    return new Property("complete", "boolean", "Indicates if the list includes all authors and/or contributors.", 0, 1, this.complete);
                }
                case 96667762: {
                    return new Property("entry", "", "An individual entity named as a contributor, for example in the author list or contributor list.", 0, Integer.MAX_VALUE, this.entry);
                }
                case -1857640538: {
                    return new Property("summary", "", "Used to record a display of the author/contributor list without separate data element for each list member.", 0, Integer.MAX_VALUE, this.summary);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -599445191: {
                    Base[] baseArray;
                    if (this.complete == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.complete;
                    }
                    return baseArray;
                }
                case 96667762: {
                    return this.entry == null ? new Base[]{} : this.entry.toArray(new Base[this.entry.size()]);
                }
                case -1857640538: {
                    return this.summary == null ? new Base[]{} : this.summary.toArray(new Base[this.summary.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -599445191: {
                    this.complete = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case 96667762: {
                    this.getEntry().add((CitationCitedArtifactContributorshipEntryComponent)value);
                    return value;
                }
                case -1857640538: {
                    this.getSummary().add((ContributorshipSummaryComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("complete")) {
                this.complete = TypeConvertor.castToBoolean(value);
            } else if (name.equals("entry")) {
                this.getEntry().add((CitationCitedArtifactContributorshipEntryComponent)value);
            } else if (name.equals("summary")) {
                this.getSummary().add((ContributorshipSummaryComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("complete")) {
                this.complete = null;
            } else if (name.equals("entry")) {
                this.getEntry().remove((CitationCitedArtifactContributorshipEntryComponent)value);
            } else if (name.equals("summary")) {
                this.getSummary().remove((ContributorshipSummaryComponent)value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -599445191: {
                    return this.getCompleteElement();
                }
                case 96667762: {
                    return this.addEntry();
                }
                case -1857640538: {
                    return this.addSummary();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -599445191: {
                    return new String[]{"boolean"};
                }
                case 96667762: {
                    return new String[0];
                }
                case -1857640538: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("complete")) {
                throw new FHIRException("Cannot call addChild on a singleton property Citation.citedArtifact.contributorship.complete");
            }
            if (name.equals("entry")) {
                return this.addEntry();
            }
            if (name.equals("summary")) {
                return this.addSummary();
            }
            return super.addChild(name);
        }

        @Override
        public CitationCitedArtifactContributorshipComponent copy() {
            CitationCitedArtifactContributorshipComponent dst = new CitationCitedArtifactContributorshipComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationCitedArtifactContributorshipComponent dst) {
            super.copyValues(dst);
            BooleanType booleanType = dst.complete = this.complete == null ? null : this.complete.copy();
            if (this.entry != null) {
                dst.entry = new ArrayList<CitationCitedArtifactContributorshipEntryComponent>();
                for (CitationCitedArtifactContributorshipEntryComponent citationCitedArtifactContributorshipEntryComponent : this.entry) {
                    dst.entry.add(citationCitedArtifactContributorshipEntryComponent.copy());
                }
            }
            if (this.summary != null) {
                dst.summary = new ArrayList<ContributorshipSummaryComponent>();
                for (ContributorshipSummaryComponent contributorshipSummaryComponent : this.summary) {
                    dst.summary.add(contributorshipSummaryComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactContributorshipComponent)) {
                return false;
            }
            CitationCitedArtifactContributorshipComponent o = (CitationCitedArtifactContributorshipComponent)other_;
            return CitationCitedArtifactContributorshipComponent.compareDeep(this.complete, o.complete, true) && CitationCitedArtifactContributorshipComponent.compareDeep(this.entry, o.entry, true) && CitationCitedArtifactContributorshipComponent.compareDeep(this.summary, o.summary, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactContributorshipComponent)) {
                return false;
            }
            CitationCitedArtifactContributorshipComponent o = (CitationCitedArtifactContributorshipComponent)other_;
            return CitationCitedArtifactContributorshipComponent.compareValues(this.complete, o.complete, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.complete, this.entry, this.summary});
        }

        @Override
        public String fhirType() {
            return "Citation.citedArtifact.contributorship";
        }
    }

    @Block
    public static class CitationCitedArtifactClassificationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The kind of classifier (e.g. publication type, keyword)", formalDefinition="The kind of classifier (e.g. publication type, keyword).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/cited-artifact-classification-type")
        protected CodeableConcept type;
        @Child(name="classifier", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The specific classification value", formalDefinition="The specific classification value.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/citation-artifact-classifier")
        protected List<CodeableConcept> classifier;
        @Child(name="artifactAssessment", type={ArtifactAssessment.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Complex or externally created classification", formalDefinition="Complex or externally created classification.")
        protected List<Reference> artifactAssessment;
        private static final long serialVersionUID = 394554928L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactClassificationComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public CitationCitedArtifactClassificationComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public List<CodeableConcept> getClassifier() {
            if (this.classifier == null) {
                this.classifier = new ArrayList<CodeableConcept>();
            }
            return this.classifier;
        }

        public CitationCitedArtifactClassificationComponent setClassifier(List<CodeableConcept> theClassifier) {
            this.classifier = theClassifier;
            return this;
        }

        public boolean hasClassifier() {
            if (this.classifier == null) {
                return false;
            }
            for (CodeableConcept item : this.classifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addClassifier() {
            CodeableConcept t = new CodeableConcept();
            if (this.classifier == null) {
                this.classifier = new ArrayList<CodeableConcept>();
            }
            this.classifier.add(t);
            return t;
        }

        public CitationCitedArtifactClassificationComponent addClassifier(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.classifier == null) {
                this.classifier = new ArrayList<CodeableConcept>();
            }
            this.classifier.add(t);
            return this;
        }

        public CodeableConcept getClassifierFirstRep() {
            if (this.getClassifier().isEmpty()) {
                this.addClassifier();
            }
            return this.getClassifier().get(0);
        }

        public List<Reference> getArtifactAssessment() {
            if (this.artifactAssessment == null) {
                this.artifactAssessment = new ArrayList<Reference>();
            }
            return this.artifactAssessment;
        }

        public CitationCitedArtifactClassificationComponent setArtifactAssessment(List<Reference> theArtifactAssessment) {
            this.artifactAssessment = theArtifactAssessment;
            return this;
        }

        public boolean hasArtifactAssessment() {
            if (this.artifactAssessment == null) {
                return false;
            }
            for (Reference item : this.artifactAssessment) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addArtifactAssessment() {
            Reference t = new Reference();
            if (this.artifactAssessment == null) {
                this.artifactAssessment = new ArrayList<Reference>();
            }
            this.artifactAssessment.add(t);
            return t;
        }

        public CitationCitedArtifactClassificationComponent addArtifactAssessment(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.artifactAssessment == null) {
                this.artifactAssessment = new ArrayList<Reference>();
            }
            this.artifactAssessment.add(t);
            return this;
        }

        public Reference getArtifactAssessmentFirstRep() {
            if (this.getArtifactAssessment().isEmpty()) {
                this.addArtifactAssessment();
            }
            return this.getArtifactAssessment().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "The kind of classifier (e.g. publication type, keyword).", 0, 1, this.type));
            children.add(new Property(Citation.SP_CLASSIFIER, "CodeableConcept", "The specific classification value.", 0, Integer.MAX_VALUE, this.classifier));
            children.add(new Property("artifactAssessment", "Reference(ArtifactAssessment)", "Complex or externally created classification.", 0, Integer.MAX_VALUE, this.artifactAssessment));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The kind of classifier (e.g. publication type, keyword).", 0, 1, this.type);
                }
                case -281470431: {
                    return new Property(Citation.SP_CLASSIFIER, "CodeableConcept", "The specific classification value.", 0, Integer.MAX_VALUE, this.classifier);
                }
                case 1014987316: {
                    return new Property("artifactAssessment", "Reference(ArtifactAssessment)", "Complex or externally created classification.", 0, Integer.MAX_VALUE, this.artifactAssessment);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -281470431: {
                    return this.classifier == null ? new Base[]{} : this.classifier.toArray(new Base[this.classifier.size()]);
                }
                case 1014987316: {
                    return this.artifactAssessment == null ? new Base[]{} : this.artifactAssessment.toArray(new Base[this.artifactAssessment.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -281470431: {
                    this.getClassifier().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 1014987316: {
                    this.getArtifactAssessment().add(TypeConvertor.castToReference(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals(Citation.SP_CLASSIFIER)) {
                this.getClassifier().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("artifactAssessment")) {
                this.getArtifactAssessment().add(TypeConvertor.castToReference(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = null;
            } else if (name.equals(Citation.SP_CLASSIFIER)) {
                this.getClassifier().remove(value);
            } else if (name.equals("artifactAssessment")) {
                this.getArtifactAssessment().remove(value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -281470431: {
                    return this.addClassifier();
                }
                case 1014987316: {
                    return this.addArtifactAssessment();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -281470431: {
                    return new String[]{"CodeableConcept"};
                }
                case 1014987316: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals(Citation.SP_CLASSIFIER)) {
                return this.addClassifier();
            }
            if (name.equals("artifactAssessment")) {
                return this.addArtifactAssessment();
            }
            return super.addChild(name);
        }

        @Override
        public CitationCitedArtifactClassificationComponent copy() {
            CitationCitedArtifactClassificationComponent dst = new CitationCitedArtifactClassificationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationCitedArtifactClassificationComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
            if (this.classifier != null) {
                dst.classifier = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.classifier) {
                    dst.classifier.add(codeableConcept2.copy());
                }
            }
            if (this.artifactAssessment != null) {
                dst.artifactAssessment = new ArrayList<Reference>();
                for (Reference reference : this.artifactAssessment) {
                    dst.artifactAssessment.add(reference.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactClassificationComponent)) {
                return false;
            }
            CitationCitedArtifactClassificationComponent o = (CitationCitedArtifactClassificationComponent)other_;
            return CitationCitedArtifactClassificationComponent.compareDeep(this.type, o.type, true) && CitationCitedArtifactClassificationComponent.compareDeep(this.classifier, o.classifier, true) && CitationCitedArtifactClassificationComponent.compareDeep(this.artifactAssessment, o.artifactAssessment, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactClassificationComponent)) {
                return false;
            }
            CitationCitedArtifactClassificationComponent o = (CitationCitedArtifactClassificationComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.classifier, this.artifactAssessment});
        }

        @Override
        public String fhirType() {
            return "Citation.citedArtifact.classification";
        }
    }

    @Block
    public static class CitationCitedArtifactWebLocationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="classifier", type={CodeableConcept.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Code the reason for different URLs, e.g. abstract and full-text", formalDefinition="A characterization of the object expected at the web location.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/artifact-url-classifier")
        protected List<CodeableConcept> classifier;
        @Child(name="url", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The specific URL", formalDefinition="The specific URL.")
        protected UriType url;
        private static final long serialVersionUID = -1300703403L;

        public List<CodeableConcept> getClassifier() {
            if (this.classifier == null) {
                this.classifier = new ArrayList<CodeableConcept>();
            }
            return this.classifier;
        }

        public CitationCitedArtifactWebLocationComponent setClassifier(List<CodeableConcept> theClassifier) {
            this.classifier = theClassifier;
            return this;
        }

        public boolean hasClassifier() {
            if (this.classifier == null) {
                return false;
            }
            for (CodeableConcept item : this.classifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addClassifier() {
            CodeableConcept t = new CodeableConcept();
            if (this.classifier == null) {
                this.classifier = new ArrayList<CodeableConcept>();
            }
            this.classifier.add(t);
            return t;
        }

        public CitationCitedArtifactWebLocationComponent addClassifier(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.classifier == null) {
                this.classifier = new ArrayList<CodeableConcept>();
            }
            this.classifier.add(t);
            return this;
        }

        public CodeableConcept getClassifierFirstRep() {
            if (this.getClassifier().isEmpty()) {
                this.addClassifier();
            }
            return this.getClassifier().get(0);
        }

        public UriType getUrlElement() {
            if (this.url == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactWebLocationComponent.url");
                }
                if (Configuration.doAutoCreate()) {
                    this.url = new UriType();
                }
            }
            return this.url;
        }

        public boolean hasUrlElement() {
            return this.url != null && !this.url.isEmpty();
        }

        public boolean hasUrl() {
            return this.url != null && !this.url.isEmpty();
        }

        public CitationCitedArtifactWebLocationComponent setUrlElement(UriType value) {
            this.url = value;
            return this;
        }

        public String getUrl() {
            return this.url == null ? null : (String)this.url.getValue();
        }

        public CitationCitedArtifactWebLocationComponent setUrl(String value) {
            if (Utilities.noString((String)value)) {
                this.url = null;
            } else {
                if (this.url == null) {
                    this.url = new UriType();
                }
                this.url.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Citation.SP_CLASSIFIER, "CodeableConcept", "A characterization of the object expected at the web location.", 0, Integer.MAX_VALUE, this.classifier));
            children.add(new Property(Citation.SP_URL, "uri", "The specific URL.", 0, 1, this.url));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -281470431: {
                    return new Property(Citation.SP_CLASSIFIER, "CodeableConcept", "A characterization of the object expected at the web location.", 0, Integer.MAX_VALUE, this.classifier);
                }
                case 116079: {
                    return new Property(Citation.SP_URL, "uri", "The specific URL.", 0, 1, this.url);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -281470431: {
                    return this.classifier == null ? new Base[]{} : this.classifier.toArray(new Base[this.classifier.size()]);
                }
                case 116079: {
                    Base[] baseArray;
                    if (this.url == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.url;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -281470431: {
                    this.getClassifier().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 116079: {
                    this.url = TypeConvertor.castToUri(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Citation.SP_CLASSIFIER)) {
                this.getClassifier().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals(Citation.SP_URL)) {
                this.url = TypeConvertor.castToUri(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals(Citation.SP_CLASSIFIER)) {
                this.getClassifier().remove(value);
            } else if (name.equals(Citation.SP_URL)) {
                this.url = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -281470431: {
                    return this.addClassifier();
                }
                case 116079: {
                    return this.getUrlElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -281470431: {
                    return new String[]{"CodeableConcept"};
                }
                case 116079: {
                    return new String[]{"uri"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Citation.SP_CLASSIFIER)) {
                return this.addClassifier();
            }
            if (name.equals(Citation.SP_URL)) {
                throw new FHIRException("Cannot call addChild on a singleton property Citation.citedArtifact.webLocation.url");
            }
            return super.addChild(name);
        }

        @Override
        public CitationCitedArtifactWebLocationComponent copy() {
            CitationCitedArtifactWebLocationComponent dst = new CitationCitedArtifactWebLocationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationCitedArtifactWebLocationComponent dst) {
            super.copyValues(dst);
            if (this.classifier != null) {
                dst.classifier = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.classifier) {
                    dst.classifier.add(i.copy());
                }
            }
            dst.url = this.url == null ? null : this.url.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactWebLocationComponent)) {
                return false;
            }
            CitationCitedArtifactWebLocationComponent o = (CitationCitedArtifactWebLocationComponent)other_;
            return CitationCitedArtifactWebLocationComponent.compareDeep(this.classifier, o.classifier, true) && CitationCitedArtifactWebLocationComponent.compareDeep(this.url, o.url, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactWebLocationComponent)) {
                return false;
            }
            CitationCitedArtifactWebLocationComponent o = (CitationCitedArtifactWebLocationComponent)other_;
            return CitationCitedArtifactWebLocationComponent.compareValues(this.url, o.url, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.classifier, this.url});
        }

        @Override
        public String fhirType() {
            return "Citation.citedArtifact.webLocation";
        }
    }

    @Block
    public static class CitationCitedArtifactPublicationFormPublishedInComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Kind of container (e.g. Periodical, database, or book)", formalDefinition="Kind of container (e.g. Periodical, database, or book).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/published-in-type")
        protected CodeableConcept type;
        @Child(name="identifier", type={Identifier.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Journal identifiers include ISSN, ISO Abbreviation and NLMuniqueID; Book identifiers include ISBN", formalDefinition="Journal identifiers include ISSN, ISO Abbreviation and NLMuniqueID; Book identifiers include ISBN.")
        protected List<Identifier> identifier;
        @Child(name="title", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Name of the database or title of the book or journal", formalDefinition="Name of the database or title of the book or journal.")
        protected StringType title;
        @Child(name="publisher", type={Organization.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Name of or resource describing the publisher", formalDefinition="Name of or resource describing the publisher.")
        protected Reference publisher;
        @Child(name="publisherLocation", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Geographic location of the publisher", formalDefinition="Geographic location of the publisher.")
        protected StringType publisherLocation;
        private static final long serialVersionUID = 1440066953L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPublicationFormPublishedInComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public CitationCitedArtifactPublicationFormPublishedInComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public List<Identifier> getIdentifier() {
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            return this.identifier;
        }

        public CitationCitedArtifactPublicationFormPublishedInComponent setIdentifier(List<Identifier> theIdentifier) {
            this.identifier = theIdentifier;
            return this;
        }

        public boolean hasIdentifier() {
            if (this.identifier == null) {
                return false;
            }
            for (Identifier item : this.identifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Identifier addIdentifier() {
            Identifier t = new Identifier();
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return t;
        }

        public CitationCitedArtifactPublicationFormPublishedInComponent addIdentifier(Identifier t) {
            if (t == null) {
                return this;
            }
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return this;
        }

        public Identifier getIdentifierFirstRep() {
            if (this.getIdentifier().isEmpty()) {
                this.addIdentifier();
            }
            return this.getIdentifier().get(0);
        }

        public StringType getTitleElement() {
            if (this.title == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPublicationFormPublishedInComponent.title");
                }
                if (Configuration.doAutoCreate()) {
                    this.title = new StringType();
                }
            }
            return this.title;
        }

        public boolean hasTitleElement() {
            return this.title != null && !this.title.isEmpty();
        }

        public boolean hasTitle() {
            return this.title != null && !this.title.isEmpty();
        }

        public CitationCitedArtifactPublicationFormPublishedInComponent setTitleElement(StringType value) {
            this.title = value;
            return this;
        }

        public String getTitle() {
            return this.title == null ? null : (String)this.title.getValue();
        }

        public CitationCitedArtifactPublicationFormPublishedInComponent setTitle(String value) {
            if (Utilities.noString((String)value)) {
                this.title = null;
            } else {
                if (this.title == null) {
                    this.title = new StringType();
                }
                this.title.setValue(value);
            }
            return this;
        }

        public Reference getPublisher() {
            if (this.publisher == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPublicationFormPublishedInComponent.publisher");
                }
                if (Configuration.doAutoCreate()) {
                    this.publisher = new Reference();
                }
            }
            return this.publisher;
        }

        public boolean hasPublisher() {
            return this.publisher != null && !this.publisher.isEmpty();
        }

        public CitationCitedArtifactPublicationFormPublishedInComponent setPublisher(Reference value) {
            this.publisher = value;
            return this;
        }

        public StringType getPublisherLocationElement() {
            if (this.publisherLocation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPublicationFormPublishedInComponent.publisherLocation");
                }
                if (Configuration.doAutoCreate()) {
                    this.publisherLocation = new StringType();
                }
            }
            return this.publisherLocation;
        }

        public boolean hasPublisherLocationElement() {
            return this.publisherLocation != null && !this.publisherLocation.isEmpty();
        }

        public boolean hasPublisherLocation() {
            return this.publisherLocation != null && !this.publisherLocation.isEmpty();
        }

        public CitationCitedArtifactPublicationFormPublishedInComponent setPublisherLocationElement(StringType value) {
            this.publisherLocation = value;
            return this;
        }

        public String getPublisherLocation() {
            return this.publisherLocation == null ? null : (String)this.publisherLocation.getValue();
        }

        public CitationCitedArtifactPublicationFormPublishedInComponent setPublisherLocation(String value) {
            if (Utilities.noString((String)value)) {
                this.publisherLocation = null;
            } else {
                if (this.publisherLocation == null) {
                    this.publisherLocation = new StringType();
                }
                this.publisherLocation.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Kind of container (e.g. Periodical, database, or book).", 0, 1, this.type));
            children.add(new Property(Citation.SP_IDENTIFIER, "Identifier", "Journal identifiers include ISSN, ISO Abbreviation and NLMuniqueID; Book identifiers include ISBN.", 0, Integer.MAX_VALUE, this.identifier));
            children.add(new Property(Citation.SP_TITLE, "string", "Name of the database or title of the book or journal.", 0, 1, this.title));
            children.add(new Property(Citation.SP_PUBLISHER, "Reference(Organization)", "Name of or resource describing the publisher.", 0, 1, this.publisher));
            children.add(new Property("publisherLocation", "string", "Geographic location of the publisher.", 0, 1, this.publisherLocation));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Kind of container (e.g. Periodical, database, or book).", 0, 1, this.type);
                }
                case -1618432855: {
                    return new Property(Citation.SP_IDENTIFIER, "Identifier", "Journal identifiers include ISSN, ISO Abbreviation and NLMuniqueID; Book identifiers include ISBN.", 0, Integer.MAX_VALUE, this.identifier);
                }
                case 110371416: {
                    return new Property(Citation.SP_TITLE, "string", "Name of the database or title of the book or journal.", 0, 1, this.title);
                }
                case 1447404028: {
                    return new Property(Citation.SP_PUBLISHER, "Reference(Organization)", "Name of or resource describing the publisher.", 0, 1, this.publisher);
                }
                case -1281627695: {
                    return new Property("publisherLocation", "string", "Geographic location of the publisher.", 0, 1, this.publisherLocation);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -1618432855: {
                    return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
                }
                case 110371416: {
                    Base[] baseArray;
                    if (this.title == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.title;
                    }
                    return baseArray;
                }
                case 1447404028: {
                    Base[] baseArray;
                    if (this.publisher == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.publisher;
                    }
                    return baseArray;
                }
                case -1281627695: {
                    Base[] baseArray;
                    if (this.publisherLocation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.publisherLocation;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1618432855: {
                    this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                    return value;
                }
                case 110371416: {
                    this.title = TypeConvertor.castToString(value);
                    return value;
                }
                case 1447404028: {
                    this.publisher = TypeConvertor.castToReference(value);
                    return value;
                }
                case -1281627695: {
                    this.publisherLocation = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals(Citation.SP_IDENTIFIER)) {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
            } else if (name.equals(Citation.SP_TITLE)) {
                this.title = TypeConvertor.castToString(value);
            } else if (name.equals(Citation.SP_PUBLISHER)) {
                this.publisher = TypeConvertor.castToReference(value);
            } else if (name.equals("publisherLocation")) {
                this.publisherLocation = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = null;
            } else if (name.equals(Citation.SP_IDENTIFIER)) {
                this.getIdentifier().remove(value);
            } else if (name.equals(Citation.SP_TITLE)) {
                this.title = null;
            } else if (name.equals(Citation.SP_PUBLISHER)) {
                this.publisher = null;
            } else if (name.equals("publisherLocation")) {
                this.publisherLocation = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1618432855: {
                    return this.addIdentifier();
                }
                case 110371416: {
                    return this.getTitleElement();
                }
                case 1447404028: {
                    return this.getPublisher();
                }
                case -1281627695: {
                    return this.getPublisherLocationElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case 110371416: {
                    return new String[]{"string"};
                }
                case 1447404028: {
                    return new String[]{"Reference"};
                }
                case -1281627695: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals(Citation.SP_IDENTIFIER)) {
                return this.addIdentifier();
            }
            if (name.equals(Citation.SP_TITLE)) {
                throw new FHIRException("Cannot call addChild on a singleton property Citation.citedArtifact.publicationForm.publishedIn.title");
            }
            if (name.equals(Citation.SP_PUBLISHER)) {
                this.publisher = new Reference();
                return this.publisher;
            }
            if (name.equals("publisherLocation")) {
                throw new FHIRException("Cannot call addChild on a singleton property Citation.citedArtifact.publicationForm.publishedIn.publisherLocation");
            }
            return super.addChild(name);
        }

        @Override
        public CitationCitedArtifactPublicationFormPublishedInComponent copy() {
            CitationCitedArtifactPublicationFormPublishedInComponent dst = new CitationCitedArtifactPublicationFormPublishedInComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationCitedArtifactPublicationFormPublishedInComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
            if (this.identifier != null) {
                dst.identifier = new ArrayList<Identifier>();
                for (Identifier i : this.identifier) {
                    dst.identifier.add(i.copy());
                }
            }
            dst.title = this.title == null ? null : this.title.copy();
            dst.publisher = this.publisher == null ? null : this.publisher.copy();
            dst.publisherLocation = this.publisherLocation == null ? null : this.publisherLocation.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactPublicationFormPublishedInComponent)) {
                return false;
            }
            CitationCitedArtifactPublicationFormPublishedInComponent o = (CitationCitedArtifactPublicationFormPublishedInComponent)other_;
            return CitationCitedArtifactPublicationFormPublishedInComponent.compareDeep(this.type, o.type, true) && CitationCitedArtifactPublicationFormPublishedInComponent.compareDeep(this.identifier, o.identifier, true) && CitationCitedArtifactPublicationFormPublishedInComponent.compareDeep(this.title, o.title, true) && CitationCitedArtifactPublicationFormPublishedInComponent.compareDeep(this.publisher, o.publisher, true) && CitationCitedArtifactPublicationFormPublishedInComponent.compareDeep(this.publisherLocation, o.publisherLocation, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactPublicationFormPublishedInComponent)) {
                return false;
            }
            CitationCitedArtifactPublicationFormPublishedInComponent o = (CitationCitedArtifactPublicationFormPublishedInComponent)other_;
            return CitationCitedArtifactPublicationFormPublishedInComponent.compareValues(this.title, o.title, true) && CitationCitedArtifactPublicationFormPublishedInComponent.compareValues(this.publisherLocation, o.publisherLocation, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.identifier, this.title, this.publisher, this.publisherLocation});
        }

        @Override
        public String fhirType() {
            return "Citation.citedArtifact.publicationForm.publishedIn";
        }
    }

    @Block
    public static class CitationCitedArtifactPublicationFormComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="publishedIn", type={}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The collection the cited article or artifact is published in", formalDefinition="The collection the cited article or artifact is published in.")
        protected CitationCitedArtifactPublicationFormPublishedInComponent publishedIn;
        @Child(name="citedMedium", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Internet or Print", formalDefinition="Describes the form of the medium cited. Common codes are \"Internet\" or \"Print\". The CitedMedium value set has 6 codes. The codes internet, print, and offline-digital-storage are the common codes for a typical publication form, though internet and print are more common for study citations. Three additional codes (each appending one of the primary codes with \"-without-issue\" are used for situations when a study is published both within an issue (of a periodical release as commonly done for journals) AND is published separately from the issue (as commonly done with early online publication), to represent specific identification of the publication form not associated with the issue.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/cited-medium")
        protected CodeableConcept citedMedium;
        @Child(name="volume", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Volume number of journal or other collection in which the article is published", formalDefinition="Volume number of journal or other collection in which the article is published.")
        protected StringType volume;
        @Child(name="issue", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Issue, part or supplement of journal or other collection in which the article is published", formalDefinition="Issue, part or supplement of journal or other collection in which the article is published.")
        protected StringType issue;
        @Child(name="articleDate", type={DateTimeType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The date the article was added to the database, or the date the article was released", formalDefinition="The date the article was added to the database, or the date the article was released.")
        protected DateTimeType articleDate;
        @Child(name="publicationDateText", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Text representation of the date on which the issue of the cited artifact was published", formalDefinition="Text representation of the date on which the issue of the cited artifact was published.")
        protected StringType publicationDateText;
        @Child(name="publicationDateSeason", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Season in which the cited artifact was published", formalDefinition="Spring, Summer, Fall/Autumn, Winter.")
        protected StringType publicationDateSeason;
        @Child(name="lastRevisionDate", type={DateTimeType.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The date the article was last revised or updated in the database", formalDefinition="The date the article was last revised or updated in the database.")
        protected DateTimeType lastRevisionDate;
        @Child(name="language", type={CodeableConcept.class}, order=9, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Language(s) in which this form of the article is published", formalDefinition="The language or languages in which this form of the article is published.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/languages")
        protected List<CodeableConcept> language;
        @Child(name="accessionNumber", type={StringType.class}, order=10, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Entry number or identifier for inclusion in a database", formalDefinition="Entry number or identifier for inclusion in a database.")
        protected StringType accessionNumber;
        @Child(name="pageString", type={StringType.class}, order=11, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Used for full display of pagination", formalDefinition="Used for full display of pagination.")
        protected StringType pageString;
        @Child(name="firstPage", type={StringType.class}, order=12, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Used for isolated representation of first page", formalDefinition="Used for isolated representation of first page.")
        protected StringType firstPage;
        @Child(name="lastPage", type={StringType.class}, order=13, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Used for isolated representation of last page", formalDefinition="Used for isolated representation of last page.")
        protected StringType lastPage;
        @Child(name="pageCount", type={StringType.class}, order=14, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Number of pages or screens", formalDefinition="Actual or approximate number of pages or screens. Distinct from reporting the page numbers.")
        protected StringType pageCount;
        @Child(name="copyright", type={MarkdownType.class}, order=15, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Copyright notice for the full article or artifact", formalDefinition="Copyright notice for the full article or artifact.")
        protected MarkdownType copyright;
        private static final long serialVersionUID = 1791622597L;

        public CitationCitedArtifactPublicationFormPublishedInComponent getPublishedIn() {
            if (this.publishedIn == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPublicationFormComponent.publishedIn");
                }
                if (Configuration.doAutoCreate()) {
                    this.publishedIn = new CitationCitedArtifactPublicationFormPublishedInComponent();
                }
            }
            return this.publishedIn;
        }

        public boolean hasPublishedIn() {
            return this.publishedIn != null && !this.publishedIn.isEmpty();
        }

        public CitationCitedArtifactPublicationFormComponent setPublishedIn(CitationCitedArtifactPublicationFormPublishedInComponent value) {
            this.publishedIn = value;
            return this;
        }

        public CodeableConcept getCitedMedium() {
            if (this.citedMedium == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPublicationFormComponent.citedMedium");
                }
                if (Configuration.doAutoCreate()) {
                    this.citedMedium = new CodeableConcept();
                }
            }
            return this.citedMedium;
        }

        public boolean hasCitedMedium() {
            return this.citedMedium != null && !this.citedMedium.isEmpty();
        }

        public CitationCitedArtifactPublicationFormComponent setCitedMedium(CodeableConcept value) {
            this.citedMedium = value;
            return this;
        }

        public StringType getVolumeElement() {
            if (this.volume == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPublicationFormComponent.volume");
                }
                if (Configuration.doAutoCreate()) {
                    this.volume = new StringType();
                }
            }
            return this.volume;
        }

        public boolean hasVolumeElement() {
            return this.volume != null && !this.volume.isEmpty();
        }

        public boolean hasVolume() {
            return this.volume != null && !this.volume.isEmpty();
        }

        public CitationCitedArtifactPublicationFormComponent setVolumeElement(StringType value) {
            this.volume = value;
            return this;
        }

        public String getVolume() {
            return this.volume == null ? null : (String)this.volume.getValue();
        }

        public CitationCitedArtifactPublicationFormComponent setVolume(String value) {
            if (Utilities.noString((String)value)) {
                this.volume = null;
            } else {
                if (this.volume == null) {
                    this.volume = new StringType();
                }
                this.volume.setValue(value);
            }
            return this;
        }

        public StringType getIssueElement() {
            if (this.issue == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPublicationFormComponent.issue");
                }
                if (Configuration.doAutoCreate()) {
                    this.issue = new StringType();
                }
            }
            return this.issue;
        }

        public boolean hasIssueElement() {
            return this.issue != null && !this.issue.isEmpty();
        }

        public boolean hasIssue() {
            return this.issue != null && !this.issue.isEmpty();
        }

        public CitationCitedArtifactPublicationFormComponent setIssueElement(StringType value) {
            this.issue = value;
            return this;
        }

        public String getIssue() {
            return this.issue == null ? null : (String)this.issue.getValue();
        }

        public CitationCitedArtifactPublicationFormComponent setIssue(String value) {
            if (Utilities.noString((String)value)) {
                this.issue = null;
            } else {
                if (this.issue == null) {
                    this.issue = new StringType();
                }
                this.issue.setValue(value);
            }
            return this;
        }

        public DateTimeType getArticleDateElement() {
            if (this.articleDate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPublicationFormComponent.articleDate");
                }
                if (Configuration.doAutoCreate()) {
                    this.articleDate = new DateTimeType();
                }
            }
            return this.articleDate;
        }

        public boolean hasArticleDateElement() {
            return this.articleDate != null && !this.articleDate.isEmpty();
        }

        public boolean hasArticleDate() {
            return this.articleDate != null && !this.articleDate.isEmpty();
        }

        public CitationCitedArtifactPublicationFormComponent setArticleDateElement(DateTimeType value) {
            this.articleDate = value;
            return this;
        }

        public Date getArticleDate() {
            return this.articleDate == null ? null : (Date)this.articleDate.getValue();
        }

        public CitationCitedArtifactPublicationFormComponent setArticleDate(Date value) {
            if (value == null) {
                this.articleDate = null;
            } else {
                if (this.articleDate == null) {
                    this.articleDate = new DateTimeType();
                }
                this.articleDate.setValue(value);
            }
            return this;
        }

        public StringType getPublicationDateTextElement() {
            if (this.publicationDateText == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPublicationFormComponent.publicationDateText");
                }
                if (Configuration.doAutoCreate()) {
                    this.publicationDateText = new StringType();
                }
            }
            return this.publicationDateText;
        }

        public boolean hasPublicationDateTextElement() {
            return this.publicationDateText != null && !this.publicationDateText.isEmpty();
        }

        public boolean hasPublicationDateText() {
            return this.publicationDateText != null && !this.publicationDateText.isEmpty();
        }

        public CitationCitedArtifactPublicationFormComponent setPublicationDateTextElement(StringType value) {
            this.publicationDateText = value;
            return this;
        }

        public String getPublicationDateText() {
            return this.publicationDateText == null ? null : (String)this.publicationDateText.getValue();
        }

        public CitationCitedArtifactPublicationFormComponent setPublicationDateText(String value) {
            if (Utilities.noString((String)value)) {
                this.publicationDateText = null;
            } else {
                if (this.publicationDateText == null) {
                    this.publicationDateText = new StringType();
                }
                this.publicationDateText.setValue(value);
            }
            return this;
        }

        public StringType getPublicationDateSeasonElement() {
            if (this.publicationDateSeason == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPublicationFormComponent.publicationDateSeason");
                }
                if (Configuration.doAutoCreate()) {
                    this.publicationDateSeason = new StringType();
                }
            }
            return this.publicationDateSeason;
        }

        public boolean hasPublicationDateSeasonElement() {
            return this.publicationDateSeason != null && !this.publicationDateSeason.isEmpty();
        }

        public boolean hasPublicationDateSeason() {
            return this.publicationDateSeason != null && !this.publicationDateSeason.isEmpty();
        }

        public CitationCitedArtifactPublicationFormComponent setPublicationDateSeasonElement(StringType value) {
            this.publicationDateSeason = value;
            return this;
        }

        public String getPublicationDateSeason() {
            return this.publicationDateSeason == null ? null : (String)this.publicationDateSeason.getValue();
        }

        public CitationCitedArtifactPublicationFormComponent setPublicationDateSeason(String value) {
            if (Utilities.noString((String)value)) {
                this.publicationDateSeason = null;
            } else {
                if (this.publicationDateSeason == null) {
                    this.publicationDateSeason = new StringType();
                }
                this.publicationDateSeason.setValue(value);
            }
            return this;
        }

        public DateTimeType getLastRevisionDateElement() {
            if (this.lastRevisionDate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPublicationFormComponent.lastRevisionDate");
                }
                if (Configuration.doAutoCreate()) {
                    this.lastRevisionDate = new DateTimeType();
                }
            }
            return this.lastRevisionDate;
        }

        public boolean hasLastRevisionDateElement() {
            return this.lastRevisionDate != null && !this.lastRevisionDate.isEmpty();
        }

        public boolean hasLastRevisionDate() {
            return this.lastRevisionDate != null && !this.lastRevisionDate.isEmpty();
        }

        public CitationCitedArtifactPublicationFormComponent setLastRevisionDateElement(DateTimeType value) {
            this.lastRevisionDate = value;
            return this;
        }

        public Date getLastRevisionDate() {
            return this.lastRevisionDate == null ? null : (Date)this.lastRevisionDate.getValue();
        }

        public CitationCitedArtifactPublicationFormComponent setLastRevisionDate(Date value) {
            if (value == null) {
                this.lastRevisionDate = null;
            } else {
                if (this.lastRevisionDate == null) {
                    this.lastRevisionDate = new DateTimeType();
                }
                this.lastRevisionDate.setValue(value);
            }
            return this;
        }

        public List<CodeableConcept> getLanguage() {
            if (this.language == null) {
                this.language = new ArrayList<CodeableConcept>();
            }
            return this.language;
        }

        public CitationCitedArtifactPublicationFormComponent setLanguage(List<CodeableConcept> theLanguage) {
            this.language = theLanguage;
            return this;
        }

        public boolean hasLanguage() {
            if (this.language == null) {
                return false;
            }
            for (CodeableConcept item : this.language) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addLanguage() {
            CodeableConcept t = new CodeableConcept();
            if (this.language == null) {
                this.language = new ArrayList<CodeableConcept>();
            }
            this.language.add(t);
            return t;
        }

        public CitationCitedArtifactPublicationFormComponent addLanguage(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.language == null) {
                this.language = new ArrayList<CodeableConcept>();
            }
            this.language.add(t);
            return this;
        }

        public CodeableConcept getLanguageFirstRep() {
            if (this.getLanguage().isEmpty()) {
                this.addLanguage();
            }
            return this.getLanguage().get(0);
        }

        public StringType getAccessionNumberElement() {
            if (this.accessionNumber == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPublicationFormComponent.accessionNumber");
                }
                if (Configuration.doAutoCreate()) {
                    this.accessionNumber = new StringType();
                }
            }
            return this.accessionNumber;
        }

        public boolean hasAccessionNumberElement() {
            return this.accessionNumber != null && !this.accessionNumber.isEmpty();
        }

        public boolean hasAccessionNumber() {
            return this.accessionNumber != null && !this.accessionNumber.isEmpty();
        }

        public CitationCitedArtifactPublicationFormComponent setAccessionNumberElement(StringType value) {
            this.accessionNumber = value;
            return this;
        }

        public String getAccessionNumber() {
            return this.accessionNumber == null ? null : (String)this.accessionNumber.getValue();
        }

        public CitationCitedArtifactPublicationFormComponent setAccessionNumber(String value) {
            if (Utilities.noString((String)value)) {
                this.accessionNumber = null;
            } else {
                if (this.accessionNumber == null) {
                    this.accessionNumber = new StringType();
                }
                this.accessionNumber.setValue(value);
            }
            return this;
        }

        public StringType getPageStringElement() {
            if (this.pageString == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPublicationFormComponent.pageString");
                }
                if (Configuration.doAutoCreate()) {
                    this.pageString = new StringType();
                }
            }
            return this.pageString;
        }

        public boolean hasPageStringElement() {
            return this.pageString != null && !this.pageString.isEmpty();
        }

        public boolean hasPageString() {
            return this.pageString != null && !this.pageString.isEmpty();
        }

        public CitationCitedArtifactPublicationFormComponent setPageStringElement(StringType value) {
            this.pageString = value;
            return this;
        }

        public String getPageString() {
            return this.pageString == null ? null : (String)this.pageString.getValue();
        }

        public CitationCitedArtifactPublicationFormComponent setPageString(String value) {
            if (Utilities.noString((String)value)) {
                this.pageString = null;
            } else {
                if (this.pageString == null) {
                    this.pageString = new StringType();
                }
                this.pageString.setValue(value);
            }
            return this;
        }

        public StringType getFirstPageElement() {
            if (this.firstPage == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPublicationFormComponent.firstPage");
                }
                if (Configuration.doAutoCreate()) {
                    this.firstPage = new StringType();
                }
            }
            return this.firstPage;
        }

        public boolean hasFirstPageElement() {
            return this.firstPage != null && !this.firstPage.isEmpty();
        }

        public boolean hasFirstPage() {
            return this.firstPage != null && !this.firstPage.isEmpty();
        }

        public CitationCitedArtifactPublicationFormComponent setFirstPageElement(StringType value) {
            this.firstPage = value;
            return this;
        }

        public String getFirstPage() {
            return this.firstPage == null ? null : (String)this.firstPage.getValue();
        }

        public CitationCitedArtifactPublicationFormComponent setFirstPage(String value) {
            if (Utilities.noString((String)value)) {
                this.firstPage = null;
            } else {
                if (this.firstPage == null) {
                    this.firstPage = new StringType();
                }
                this.firstPage.setValue(value);
            }
            return this;
        }

        public StringType getLastPageElement() {
            if (this.lastPage == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPublicationFormComponent.lastPage");
                }
                if (Configuration.doAutoCreate()) {
                    this.lastPage = new StringType();
                }
            }
            return this.lastPage;
        }

        public boolean hasLastPageElement() {
            return this.lastPage != null && !this.lastPage.isEmpty();
        }

        public boolean hasLastPage() {
            return this.lastPage != null && !this.lastPage.isEmpty();
        }

        public CitationCitedArtifactPublicationFormComponent setLastPageElement(StringType value) {
            this.lastPage = value;
            return this;
        }

        public String getLastPage() {
            return this.lastPage == null ? null : (String)this.lastPage.getValue();
        }

        public CitationCitedArtifactPublicationFormComponent setLastPage(String value) {
            if (Utilities.noString((String)value)) {
                this.lastPage = null;
            } else {
                if (this.lastPage == null) {
                    this.lastPage = new StringType();
                }
                this.lastPage.setValue(value);
            }
            return this;
        }

        public StringType getPageCountElement() {
            if (this.pageCount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPublicationFormComponent.pageCount");
                }
                if (Configuration.doAutoCreate()) {
                    this.pageCount = new StringType();
                }
            }
            return this.pageCount;
        }

        public boolean hasPageCountElement() {
            return this.pageCount != null && !this.pageCount.isEmpty();
        }

        public boolean hasPageCount() {
            return this.pageCount != null && !this.pageCount.isEmpty();
        }

        public CitationCitedArtifactPublicationFormComponent setPageCountElement(StringType value) {
            this.pageCount = value;
            return this;
        }

        public String getPageCount() {
            return this.pageCount == null ? null : (String)this.pageCount.getValue();
        }

        public CitationCitedArtifactPublicationFormComponent setPageCount(String value) {
            if (Utilities.noString((String)value)) {
                this.pageCount = null;
            } else {
                if (this.pageCount == null) {
                    this.pageCount = new StringType();
                }
                this.pageCount.setValue(value);
            }
            return this;
        }

        public MarkdownType getCopyrightElement() {
            if (this.copyright == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPublicationFormComponent.copyright");
                }
                if (Configuration.doAutoCreate()) {
                    this.copyright = new MarkdownType();
                }
            }
            return this.copyright;
        }

        public boolean hasCopyrightElement() {
            return this.copyright != null && !this.copyright.isEmpty();
        }

        public boolean hasCopyright() {
            return this.copyright != null && !this.copyright.isEmpty();
        }

        public CitationCitedArtifactPublicationFormComponent setCopyrightElement(MarkdownType value) {
            this.copyright = value;
            return this;
        }

        public String getCopyright() {
            return this.copyright == null ? null : (String)this.copyright.getValue();
        }

        public CitationCitedArtifactPublicationFormComponent setCopyright(String value) {
            if (Utilities.noString((String)value)) {
                this.copyright = null;
            } else {
                if (this.copyright == null) {
                    this.copyright = new MarkdownType();
                }
                this.copyright.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("publishedIn", "", "The collection the cited article or artifact is published in.", 0, 1, this.publishedIn));
            children.add(new Property("citedMedium", "CodeableConcept", "Describes the form of the medium cited. Common codes are \"Internet\" or \"Print\". The CitedMedium value set has 6 codes. The codes internet, print, and offline-digital-storage are the common codes for a typical publication form, though internet and print are more common for study citations. Three additional codes (each appending one of the primary codes with \"-without-issue\" are used for situations when a study is published both within an issue (of a periodical release as commonly done for journals) AND is published separately from the issue (as commonly done with early online publication), to represent specific identification of the publication form not associated with the issue.", 0, 1, this.citedMedium));
            children.add(new Property("volume", "string", "Volume number of journal or other collection in which the article is published.", 0, 1, this.volume));
            children.add(new Property("issue", "string", "Issue, part or supplement of journal or other collection in which the article is published.", 0, 1, this.issue));
            children.add(new Property("articleDate", "dateTime", "The date the article was added to the database, or the date the article was released.", 0, 1, this.articleDate));
            children.add(new Property("publicationDateText", "string", "Text representation of the date on which the issue of the cited artifact was published.", 0, 1, this.publicationDateText));
            children.add(new Property("publicationDateSeason", "string", "Spring, Summer, Fall/Autumn, Winter.", 0, 1, this.publicationDateSeason));
            children.add(new Property("lastRevisionDate", "dateTime", "The date the article was last revised or updated in the database.", 0, 1, this.lastRevisionDate));
            children.add(new Property("language", "CodeableConcept", "The language or languages in which this form of the article is published.", 0, Integer.MAX_VALUE, this.language));
            children.add(new Property("accessionNumber", "string", "Entry number or identifier for inclusion in a database.", 0, 1, this.accessionNumber));
            children.add(new Property("pageString", "string", "Used for full display of pagination.", 0, 1, this.pageString));
            children.add(new Property("firstPage", "string", "Used for isolated representation of first page.", 0, 1, this.firstPage));
            children.add(new Property("lastPage", "string", "Used for isolated representation of last page.", 0, 1, this.lastPage));
            children.add(new Property("pageCount", "string", "Actual or approximate number of pages or screens. Distinct from reporting the page numbers.", 0, 1, this.pageCount));
            children.add(new Property("copyright", "markdown", "Copyright notice for the full article or artifact.", 0, 1, this.copyright));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -614144077: {
                    return new Property("publishedIn", "", "The collection the cited article or artifact is published in.", 0, 1, this.publishedIn);
                }
                case 612116418: {
                    return new Property("citedMedium", "CodeableConcept", "Describes the form of the medium cited. Common codes are \"Internet\" or \"Print\". The CitedMedium value set has 6 codes. The codes internet, print, and offline-digital-storage are the common codes for a typical publication form, though internet and print are more common for study citations. Three additional codes (each appending one of the primary codes with \"-without-issue\" are used for situations when a study is published both within an issue (of a periodical release as commonly done for journals) AND is published separately from the issue (as commonly done with early online publication), to represent specific identification of the publication form not associated with the issue.", 0, 1, this.citedMedium);
                }
                case -810883302: {
                    return new Property("volume", "string", "Volume number of journal or other collection in which the article is published.", 0, 1, this.volume);
                }
                case 100509913: {
                    return new Property("issue", "string", "Issue, part or supplement of journal or other collection in which the article is published.", 0, 1, this.issue);
                }
                case 817743300: {
                    return new Property("articleDate", "dateTime", "The date the article was added to the database, or the date the article was released.", 0, 1, this.articleDate);
                }
                case 225590343: {
                    return new Property("publicationDateText", "string", "Text representation of the date on which the issue of the cited artifact was published.", 0, 1, this.publicationDateText);
                }
                case 2014643069: {
                    return new Property("publicationDateSeason", "string", "Spring, Summer, Fall/Autumn, Winter.", 0, 1, this.publicationDateSeason);
                }
                case 2129161183: {
                    return new Property("lastRevisionDate", "dateTime", "The date the article was last revised or updated in the database.", 0, 1, this.lastRevisionDate);
                }
                case -1613589672: {
                    return new Property("language", "CodeableConcept", "The language or languages in which this form of the article is published.", 0, Integer.MAX_VALUE, this.language);
                }
                case 1807963277: {
                    return new Property("accessionNumber", "string", "Entry number or identifier for inclusion in a database.", 0, 1, this.accessionNumber);
                }
                case 1287145344: {
                    return new Property("pageString", "string", "Used for full display of pagination.", 0, 1, this.pageString);
                }
                case 132895071: {
                    return new Property("firstPage", "string", "Used for isolated representation of first page.", 0, 1, this.firstPage);
                }
                case -1459540411: {
                    return new Property("lastPage", "string", "Used for isolated representation of last page.", 0, 1, this.lastPage);
                }
                case 857882560: {
                    return new Property("pageCount", "string", "Actual or approximate number of pages or screens. Distinct from reporting the page numbers.", 0, 1, this.pageCount);
                }
                case 1522889671: {
                    return new Property("copyright", "markdown", "Copyright notice for the full article or artifact.", 0, 1, this.copyright);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -614144077: {
                    Base[] baseArray;
                    if (this.publishedIn == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.publishedIn;
                    }
                    return baseArray;
                }
                case 612116418: {
                    Base[] baseArray;
                    if (this.citedMedium == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.citedMedium;
                    }
                    return baseArray;
                }
                case -810883302: {
                    Base[] baseArray;
                    if (this.volume == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.volume;
                    }
                    return baseArray;
                }
                case 100509913: {
                    Base[] baseArray;
                    if (this.issue == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.issue;
                    }
                    return baseArray;
                }
                case 817743300: {
                    Base[] baseArray;
                    if (this.articleDate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.articleDate;
                    }
                    return baseArray;
                }
                case 225590343: {
                    Base[] baseArray;
                    if (this.publicationDateText == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.publicationDateText;
                    }
                    return baseArray;
                }
                case 2014643069: {
                    Base[] baseArray;
                    if (this.publicationDateSeason == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.publicationDateSeason;
                    }
                    return baseArray;
                }
                case 2129161183: {
                    Base[] baseArray;
                    if (this.lastRevisionDate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.lastRevisionDate;
                    }
                    return baseArray;
                }
                case -1613589672: {
                    return this.language == null ? new Base[]{} : this.language.toArray(new Base[this.language.size()]);
                }
                case 1807963277: {
                    Base[] baseArray;
                    if (this.accessionNumber == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.accessionNumber;
                    }
                    return baseArray;
                }
                case 1287145344: {
                    Base[] baseArray;
                    if (this.pageString == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray11 = new Base[1];
                        baseArray = baseArray11;
                        baseArray11[0] = this.pageString;
                    }
                    return baseArray;
                }
                case 132895071: {
                    Base[] baseArray;
                    if (this.firstPage == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray12 = new Base[1];
                        baseArray = baseArray12;
                        baseArray12[0] = this.firstPage;
                    }
                    return baseArray;
                }
                case -1459540411: {
                    Base[] baseArray;
                    if (this.lastPage == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray13 = new Base[1];
                        baseArray = baseArray13;
                        baseArray13[0] = this.lastPage;
                    }
                    return baseArray;
                }
                case 857882560: {
                    Base[] baseArray;
                    if (this.pageCount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray14 = new Base[1];
                        baseArray = baseArray14;
                        baseArray14[0] = this.pageCount;
                    }
                    return baseArray;
                }
                case 1522889671: {
                    Base[] baseArray;
                    if (this.copyright == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray15 = new Base[1];
                        baseArray = baseArray15;
                        baseArray15[0] = this.copyright;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -614144077: {
                    this.publishedIn = (CitationCitedArtifactPublicationFormPublishedInComponent)value;
                    return value;
                }
                case 612116418: {
                    this.citedMedium = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -810883302: {
                    this.volume = TypeConvertor.castToString(value);
                    return value;
                }
                case 100509913: {
                    this.issue = TypeConvertor.castToString(value);
                    return value;
                }
                case 817743300: {
                    this.articleDate = TypeConvertor.castToDateTime(value);
                    return value;
                }
                case 225590343: {
                    this.publicationDateText = TypeConvertor.castToString(value);
                    return value;
                }
                case 2014643069: {
                    this.publicationDateSeason = TypeConvertor.castToString(value);
                    return value;
                }
                case 2129161183: {
                    this.lastRevisionDate = TypeConvertor.castToDateTime(value);
                    return value;
                }
                case -1613589672: {
                    this.getLanguage().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 1807963277: {
                    this.accessionNumber = TypeConvertor.castToString(value);
                    return value;
                }
                case 1287145344: {
                    this.pageString = TypeConvertor.castToString(value);
                    return value;
                }
                case 132895071: {
                    this.firstPage = TypeConvertor.castToString(value);
                    return value;
                }
                case -1459540411: {
                    this.lastPage = TypeConvertor.castToString(value);
                    return value;
                }
                case 857882560: {
                    this.pageCount = TypeConvertor.castToString(value);
                    return value;
                }
                case 1522889671: {
                    this.copyright = TypeConvertor.castToMarkdown(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("publishedIn")) {
                this.publishedIn = (CitationCitedArtifactPublicationFormPublishedInComponent)value;
            } else if (name.equals("citedMedium")) {
                this.citedMedium = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("volume")) {
                this.volume = TypeConvertor.castToString(value);
            } else if (name.equals("issue")) {
                this.issue = TypeConvertor.castToString(value);
            } else if (name.equals("articleDate")) {
                this.articleDate = TypeConvertor.castToDateTime(value);
            } else if (name.equals("publicationDateText")) {
                this.publicationDateText = TypeConvertor.castToString(value);
            } else if (name.equals("publicationDateSeason")) {
                this.publicationDateSeason = TypeConvertor.castToString(value);
            } else if (name.equals("lastRevisionDate")) {
                this.lastRevisionDate = TypeConvertor.castToDateTime(value);
            } else if (name.equals("language")) {
                this.getLanguage().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("accessionNumber")) {
                this.accessionNumber = TypeConvertor.castToString(value);
            } else if (name.equals("pageString")) {
                this.pageString = TypeConvertor.castToString(value);
            } else if (name.equals("firstPage")) {
                this.firstPage = TypeConvertor.castToString(value);
            } else if (name.equals("lastPage")) {
                this.lastPage = TypeConvertor.castToString(value);
            } else if (name.equals("pageCount")) {
                this.pageCount = TypeConvertor.castToString(value);
            } else if (name.equals("copyright")) {
                this.copyright = TypeConvertor.castToMarkdown(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("publishedIn")) {
                this.publishedIn = (CitationCitedArtifactPublicationFormPublishedInComponent)value;
            } else if (name.equals("citedMedium")) {
                this.citedMedium = null;
            } else if (name.equals("volume")) {
                this.volume = null;
            } else if (name.equals("issue")) {
                this.issue = null;
            } else if (name.equals("articleDate")) {
                this.articleDate = null;
            } else if (name.equals("publicationDateText")) {
                this.publicationDateText = null;
            } else if (name.equals("publicationDateSeason")) {
                this.publicationDateSeason = null;
            } else if (name.equals("lastRevisionDate")) {
                this.lastRevisionDate = null;
            } else if (name.equals("language")) {
                this.getLanguage().remove(value);
            } else if (name.equals("accessionNumber")) {
                this.accessionNumber = null;
            } else if (name.equals("pageString")) {
                this.pageString = null;
            } else if (name.equals("firstPage")) {
                this.firstPage = null;
            } else if (name.equals("lastPage")) {
                this.lastPage = null;
            } else if (name.equals("pageCount")) {
                this.pageCount = null;
            } else if (name.equals("copyright")) {
                this.copyright = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -614144077: {
                    return this.getPublishedIn();
                }
                case 612116418: {
                    return this.getCitedMedium();
                }
                case -810883302: {
                    return this.getVolumeElement();
                }
                case 100509913: {
                    return this.getIssueElement();
                }
                case 817743300: {
                    return this.getArticleDateElement();
                }
                case 225590343: {
                    return this.getPublicationDateTextElement();
                }
                case 2014643069: {
                    return this.getPublicationDateSeasonElement();
                }
                case 2129161183: {
                    return this.getLastRevisionDateElement();
                }
                case -1613589672: {
                    return this.addLanguage();
                }
                case 1807963277: {
                    return this.getAccessionNumberElement();
                }
                case 1287145344: {
                    return this.getPageStringElement();
                }
                case 132895071: {
                    return this.getFirstPageElement();
                }
                case -1459540411: {
                    return this.getLastPageElement();
                }
                case 857882560: {
                    return this.getPageCountElement();
                }
                case 1522889671: {
                    return this.getCopyrightElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -614144077: {
                    return new String[0];
                }
                case 612116418: {
                    return new String[]{"CodeableConcept"};
                }
                case -810883302: {
                    return new String[]{"string"};
                }
                case 100509913: {
                    return new String[]{"string"};
                }
                case 817743300: {
                    return new String[]{"dateTime"};
                }
                case 225590343: {
                    return new String[]{"string"};
                }
                case 2014643069: {
                    return new String[]{"string"};
                }
                case 2129161183: {
                    return new String[]{"dateTime"};
                }
                case -1613589672: {
                    return new String[]{"CodeableConcept"};
                }
                case 1807963277: {
                    return new String[]{"string"};
                }
                case 1287145344: {
                    return new String[]{"string"};
                }
                case 132895071: {
                    return new String[]{"string"};
                }
                case -1459540411: {
                    return new String[]{"string"};
                }
                case 857882560: {
                    return new String[]{"string"};
                }
                case 1522889671: {
                    return new String[]{"markdown"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("publishedIn")) {
                this.publishedIn = new CitationCitedArtifactPublicationFormPublishedInComponent();
                return this.publishedIn;
            }
            if (name.equals("citedMedium")) {
                this.citedMedium = new CodeableConcept();
                return this.citedMedium;
            }
            if (name.equals("volume")) {
                throw new FHIRException("Cannot call addChild on a singleton property Citation.citedArtifact.publicationForm.volume");
            }
            if (name.equals("issue")) {
                throw new FHIRException("Cannot call addChild on a singleton property Citation.citedArtifact.publicationForm.issue");
            }
            if (name.equals("articleDate")) {
                throw new FHIRException("Cannot call addChild on a singleton property Citation.citedArtifact.publicationForm.articleDate");
            }
            if (name.equals("publicationDateText")) {
                throw new FHIRException("Cannot call addChild on a singleton property Citation.citedArtifact.publicationForm.publicationDateText");
            }
            if (name.equals("publicationDateSeason")) {
                throw new FHIRException("Cannot call addChild on a singleton property Citation.citedArtifact.publicationForm.publicationDateSeason");
            }
            if (name.equals("lastRevisionDate")) {
                throw new FHIRException("Cannot call addChild on a singleton property Citation.citedArtifact.publicationForm.lastRevisionDate");
            }
            if (name.equals("language")) {
                return this.addLanguage();
            }
            if (name.equals("accessionNumber")) {
                throw new FHIRException("Cannot call addChild on a singleton property Citation.citedArtifact.publicationForm.accessionNumber");
            }
            if (name.equals("pageString")) {
                throw new FHIRException("Cannot call addChild on a singleton property Citation.citedArtifact.publicationForm.pageString");
            }
            if (name.equals("firstPage")) {
                throw new FHIRException("Cannot call addChild on a singleton property Citation.citedArtifact.publicationForm.firstPage");
            }
            if (name.equals("lastPage")) {
                throw new FHIRException("Cannot call addChild on a singleton property Citation.citedArtifact.publicationForm.lastPage");
            }
            if (name.equals("pageCount")) {
                throw new FHIRException("Cannot call addChild on a singleton property Citation.citedArtifact.publicationForm.pageCount");
            }
            if (name.equals("copyright")) {
                throw new FHIRException("Cannot call addChild on a singleton property Citation.citedArtifact.publicationForm.copyright");
            }
            return super.addChild(name);
        }

        @Override
        public CitationCitedArtifactPublicationFormComponent copy() {
            CitationCitedArtifactPublicationFormComponent dst = new CitationCitedArtifactPublicationFormComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationCitedArtifactPublicationFormComponent dst) {
            super.copyValues(dst);
            dst.publishedIn = this.publishedIn == null ? null : this.publishedIn.copy();
            dst.citedMedium = this.citedMedium == null ? null : this.citedMedium.copy();
            dst.volume = this.volume == null ? null : this.volume.copy();
            dst.issue = this.issue == null ? null : this.issue.copy();
            dst.articleDate = this.articleDate == null ? null : this.articleDate.copy();
            dst.publicationDateText = this.publicationDateText == null ? null : this.publicationDateText.copy();
            dst.publicationDateSeason = this.publicationDateSeason == null ? null : this.publicationDateSeason.copy();
            DateTimeType dateTimeType = dst.lastRevisionDate = this.lastRevisionDate == null ? null : this.lastRevisionDate.copy();
            if (this.language != null) {
                dst.language = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.language) {
                    dst.language.add(i.copy());
                }
            }
            dst.accessionNumber = this.accessionNumber == null ? null : this.accessionNumber.copy();
            dst.pageString = this.pageString == null ? null : this.pageString.copy();
            dst.firstPage = this.firstPage == null ? null : this.firstPage.copy();
            dst.lastPage = this.lastPage == null ? null : this.lastPage.copy();
            dst.pageCount = this.pageCount == null ? null : this.pageCount.copy();
            dst.copyright = this.copyright == null ? null : this.copyright.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactPublicationFormComponent)) {
                return false;
            }
            CitationCitedArtifactPublicationFormComponent o = (CitationCitedArtifactPublicationFormComponent)other_;
            return CitationCitedArtifactPublicationFormComponent.compareDeep(this.publishedIn, o.publishedIn, true) && CitationCitedArtifactPublicationFormComponent.compareDeep(this.citedMedium, o.citedMedium, true) && CitationCitedArtifactPublicationFormComponent.compareDeep(this.volume, o.volume, true) && CitationCitedArtifactPublicationFormComponent.compareDeep(this.issue, o.issue, true) && CitationCitedArtifactPublicationFormComponent.compareDeep(this.articleDate, o.articleDate, true) && CitationCitedArtifactPublicationFormComponent.compareDeep(this.publicationDateText, o.publicationDateText, true) && CitationCitedArtifactPublicationFormComponent.compareDeep(this.publicationDateSeason, o.publicationDateSeason, true) && CitationCitedArtifactPublicationFormComponent.compareDeep(this.lastRevisionDate, o.lastRevisionDate, true) && CitationCitedArtifactPublicationFormComponent.compareDeep(this.language, o.language, true) && CitationCitedArtifactPublicationFormComponent.compareDeep(this.accessionNumber, o.accessionNumber, true) && CitationCitedArtifactPublicationFormComponent.compareDeep(this.pageString, o.pageString, true) && CitationCitedArtifactPublicationFormComponent.compareDeep(this.firstPage, o.firstPage, true) && CitationCitedArtifactPublicationFormComponent.compareDeep(this.lastPage, o.lastPage, true) && CitationCitedArtifactPublicationFormComponent.compareDeep(this.pageCount, o.pageCount, true) && CitationCitedArtifactPublicationFormComponent.compareDeep(this.copyright, o.copyright, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactPublicationFormComponent)) {
                return false;
            }
            CitationCitedArtifactPublicationFormComponent o = (CitationCitedArtifactPublicationFormComponent)other_;
            return CitationCitedArtifactPublicationFormComponent.compareValues(this.volume, o.volume, true) && CitationCitedArtifactPublicationFormComponent.compareValues(this.issue, o.issue, true) && CitationCitedArtifactPublicationFormComponent.compareValues(this.articleDate, o.articleDate, true) && CitationCitedArtifactPublicationFormComponent.compareValues(this.publicationDateText, o.publicationDateText, true) && CitationCitedArtifactPublicationFormComponent.compareValues(this.publicationDateSeason, o.publicationDateSeason, true) && CitationCitedArtifactPublicationFormComponent.compareValues(this.lastRevisionDate, o.lastRevisionDate, true) && CitationCitedArtifactPublicationFormComponent.compareValues(this.accessionNumber, o.accessionNumber, true) && CitationCitedArtifactPublicationFormComponent.compareValues(this.pageString, o.pageString, true) && CitationCitedArtifactPublicationFormComponent.compareValues(this.firstPage, o.firstPage, true) && CitationCitedArtifactPublicationFormComponent.compareValues(this.lastPage, o.lastPage, true) && CitationCitedArtifactPublicationFormComponent.compareValues(this.pageCount, o.pageCount, true) && CitationCitedArtifactPublicationFormComponent.compareValues(this.copyright, o.copyright, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.publishedIn, this.citedMedium, this.volume, this.issue, this.articleDate, this.publicationDateText, this.publicationDateSeason, this.lastRevisionDate, this.language, this.accessionNumber, this.pageString, this.firstPage, this.lastPage, this.pageCount, this.copyright});
        }

        @Override
        public String fhirType() {
            return "Citation.citedArtifact.publicationForm";
        }
    }

    @Block
    public static class CitationCitedArtifactRelatesToComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="documentation | justification | citation | predecessor | successor | derived-from | depends-on | composed-of | part-of | amends | amended-with | appends | appended-with | cites | cited-by | comments-on | comment-in | contains | contained-in | corrects | correction-in | replaces | replaced-with | retracts | retracted-by | signs | similar-to | supports | supported-with | transforms | transformed-into | transformed-with | documents | specification-of | created-with | cite-as | reprint | reprint-of", formalDefinition="The type of relationship to the related artifact.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/related-artifact-type-all")
        protected Enumeration<RelatedArtifactTypeExpanded> type;
        @Child(name="classifier", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Additional classifiers", formalDefinition="Provides additional classifiers of the related artifact.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/citation-artifact-classifier")
        protected List<CodeableConcept> classifier;
        @Child(name="label", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Short label", formalDefinition="A short label that can be used to reference the related artifact from elsewhere in the containing artifact, such as a footnote index.")
        protected StringType label;
        @Child(name="display", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Brief description of the related artifact", formalDefinition="A brief description of the document or knowledge resource being referenced, suitable for display to a consumer.")
        protected StringType display;
        @Child(name="citation", type={MarkdownType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Bibliographic citation for the artifact", formalDefinition="A bibliographic citation for the related artifact. This text SHOULD be formatted according to an accepted citation format.")
        protected MarkdownType citation;
        @Child(name="document", type={Attachment.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What document is being referenced", formalDefinition="The document being referenced, represented as an attachment. Do not use this element if using the resource element to provide the canonical to the related artifact.")
        protected Attachment document;
        @Child(name="resource", type={CanonicalType.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What artifact is being referenced", formalDefinition="The related artifact, such as a library, value set, profile, or other knowledge resource.")
        protected CanonicalType resource;
        @Child(name="resourceReference", type={Reference.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What artifact, if not a conformance resource", formalDefinition="The related artifact, if the artifact is not a canonical resource, or a resource reference to a canonical resource.")
        protected Reference resourceReference;
        private static final long serialVersionUID = 1537406923L;

        public CitationCitedArtifactRelatesToComponent() {
        }

        public CitationCitedArtifactRelatesToComponent(RelatedArtifactTypeExpanded type) {
            this.setType(type);
        }

        public Enumeration<RelatedArtifactTypeExpanded> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactRelatesToComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<RelatedArtifactTypeExpanded>(new RelatedArtifactTypeExpandedEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public CitationCitedArtifactRelatesToComponent setTypeElement(Enumeration<RelatedArtifactTypeExpanded> value) {
            this.type = value;
            return this;
        }

        public RelatedArtifactTypeExpanded getType() {
            return this.type == null ? null : (RelatedArtifactTypeExpanded)((Object)this.type.getValue());
        }

        public CitationCitedArtifactRelatesToComponent setType(RelatedArtifactTypeExpanded value) {
            if (this.type == null) {
                this.type = new Enumeration<RelatedArtifactTypeExpanded>(new RelatedArtifactTypeExpandedEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        public List<CodeableConcept> getClassifier() {
            if (this.classifier == null) {
                this.classifier = new ArrayList<CodeableConcept>();
            }
            return this.classifier;
        }

        public CitationCitedArtifactRelatesToComponent setClassifier(List<CodeableConcept> theClassifier) {
            this.classifier = theClassifier;
            return this;
        }

        public boolean hasClassifier() {
            if (this.classifier == null) {
                return false;
            }
            for (CodeableConcept item : this.classifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addClassifier() {
            CodeableConcept t = new CodeableConcept();
            if (this.classifier == null) {
                this.classifier = new ArrayList<CodeableConcept>();
            }
            this.classifier.add(t);
            return t;
        }

        public CitationCitedArtifactRelatesToComponent addClassifier(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.classifier == null) {
                this.classifier = new ArrayList<CodeableConcept>();
            }
            this.classifier.add(t);
            return this;
        }

        public CodeableConcept getClassifierFirstRep() {
            if (this.getClassifier().isEmpty()) {
                this.addClassifier();
            }
            return this.getClassifier().get(0);
        }

        public StringType getLabelElement() {
            if (this.label == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactRelatesToComponent.label");
                }
                if (Configuration.doAutoCreate()) {
                    this.label = new StringType();
                }
            }
            return this.label;
        }

        public boolean hasLabelElement() {
            return this.label != null && !this.label.isEmpty();
        }

        public boolean hasLabel() {
            return this.label != null && !this.label.isEmpty();
        }

        public CitationCitedArtifactRelatesToComponent setLabelElement(StringType value) {
            this.label = value;
            return this;
        }

        public String getLabel() {
            return this.label == null ? null : (String)this.label.getValue();
        }

        public CitationCitedArtifactRelatesToComponent setLabel(String value) {
            if (Utilities.noString((String)value)) {
                this.label = null;
            } else {
                if (this.label == null) {
                    this.label = new StringType();
                }
                this.label.setValue(value);
            }
            return this;
        }

        public StringType getDisplayElement() {
            if (this.display == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactRelatesToComponent.display");
                }
                if (Configuration.doAutoCreate()) {
                    this.display = new StringType();
                }
            }
            return this.display;
        }

        public boolean hasDisplayElement() {
            return this.display != null && !this.display.isEmpty();
        }

        public boolean hasDisplay() {
            return this.display != null && !this.display.isEmpty();
        }

        public CitationCitedArtifactRelatesToComponent setDisplayElement(StringType value) {
            this.display = value;
            return this;
        }

        public String getDisplay() {
            return this.display == null ? null : (String)this.display.getValue();
        }

        public CitationCitedArtifactRelatesToComponent setDisplay(String value) {
            if (Utilities.noString((String)value)) {
                this.display = null;
            } else {
                if (this.display == null) {
                    this.display = new StringType();
                }
                this.display.setValue(value);
            }
            return this;
        }

        public MarkdownType getCitationElement() {
            if (this.citation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactRelatesToComponent.citation");
                }
                if (Configuration.doAutoCreate()) {
                    this.citation = new MarkdownType();
                }
            }
            return this.citation;
        }

        public boolean hasCitationElement() {
            return this.citation != null && !this.citation.isEmpty();
        }

        public boolean hasCitation() {
            return this.citation != null && !this.citation.isEmpty();
        }

        public CitationCitedArtifactRelatesToComponent setCitationElement(MarkdownType value) {
            this.citation = value;
            return this;
        }

        public String getCitation() {
            return this.citation == null ? null : (String)this.citation.getValue();
        }

        public CitationCitedArtifactRelatesToComponent setCitation(String value) {
            if (Utilities.noString((String)value)) {
                this.citation = null;
            } else {
                if (this.citation == null) {
                    this.citation = new MarkdownType();
                }
                this.citation.setValue(value);
            }
            return this;
        }

        public Attachment getDocument() {
            if (this.document == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactRelatesToComponent.document");
                }
                if (Configuration.doAutoCreate()) {
                    this.document = new Attachment();
                }
            }
            return this.document;
        }

        public boolean hasDocument() {
            return this.document != null && !this.document.isEmpty();
        }

        public CitationCitedArtifactRelatesToComponent setDocument(Attachment value) {
            this.document = value;
            return this;
        }

        public CanonicalType getResourceElement() {
            if (this.resource == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactRelatesToComponent.resource");
                }
                if (Configuration.doAutoCreate()) {
                    this.resource = new CanonicalType();
                }
            }
            return this.resource;
        }

        public boolean hasResourceElement() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public boolean hasResource() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public CitationCitedArtifactRelatesToComponent setResourceElement(CanonicalType value) {
            this.resource = value;
            return this;
        }

        public String getResource() {
            return this.resource == null ? null : (String)this.resource.getValue();
        }

        public CitationCitedArtifactRelatesToComponent setResource(String value) {
            if (Utilities.noString((String)value)) {
                this.resource = null;
            } else {
                if (this.resource == null) {
                    this.resource = new CanonicalType();
                }
                this.resource.setValue(value);
            }
            return this;
        }

        public Reference getResourceReference() {
            if (this.resourceReference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactRelatesToComponent.resourceReference");
                }
                if (Configuration.doAutoCreate()) {
                    this.resourceReference = new Reference();
                }
            }
            return this.resourceReference;
        }

        public boolean hasResourceReference() {
            return this.resourceReference != null && !this.resourceReference.isEmpty();
        }

        public CitationCitedArtifactRelatesToComponent setResourceReference(Reference value) {
            this.resourceReference = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "code", "The type of relationship to the related artifact.", 0, 1, this.type));
            children.add(new Property(Citation.SP_CLASSIFIER, "CodeableConcept", "Provides additional classifiers of the related artifact.", 0, Integer.MAX_VALUE, this.classifier));
            children.add(new Property("label", "string", "A short label that can be used to reference the related artifact from elsewhere in the containing artifact, such as a footnote index.", 0, 1, this.label));
            children.add(new Property("display", "string", "A brief description of the document or knowledge resource being referenced, suitable for display to a consumer.", 0, 1, this.display));
            children.add(new Property("citation", "markdown", "A bibliographic citation for the related artifact. This text SHOULD be formatted according to an accepted citation format.", 0, 1, this.citation));
            children.add(new Property("document", "Attachment", "The document being referenced, represented as an attachment. Do not use this element if using the resource element to provide the canonical to the related artifact.", 0, 1, this.document));
            children.add(new Property("resource", "canonical", "The related artifact, such as a library, value set, profile, or other knowledge resource.", 0, 1, this.resource));
            children.add(new Property("resourceReference", "Reference", "The related artifact, if the artifact is not a canonical resource, or a resource reference to a canonical resource.", 0, 1, this.resourceReference));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "code", "The type of relationship to the related artifact.", 0, 1, this.type);
                }
                case -281470431: {
                    return new Property(Citation.SP_CLASSIFIER, "CodeableConcept", "Provides additional classifiers of the related artifact.", 0, Integer.MAX_VALUE, this.classifier);
                }
                case 102727412: {
                    return new Property("label", "string", "A short label that can be used to reference the related artifact from elsewhere in the containing artifact, such as a footnote index.", 0, 1, this.label);
                }
                case 1671764162: {
                    return new Property("display", "string", "A brief description of the document or knowledge resource being referenced, suitable for display to a consumer.", 0, 1, this.display);
                }
                case -1442706713: {
                    return new Property("citation", "markdown", "A bibliographic citation for the related artifact. This text SHOULD be formatted according to an accepted citation format.", 0, 1, this.citation);
                }
                case 861720859: {
                    return new Property("document", "Attachment", "The document being referenced, represented as an attachment. Do not use this element if using the resource element to provide the canonical to the related artifact.", 0, 1, this.document);
                }
                case -341064690: {
                    return new Property("resource", "canonical", "The related artifact, such as a library, value set, profile, or other knowledge resource.", 0, 1, this.resource);
                }
                case -610120995: {
                    return new Property("resourceReference", "Reference", "The related artifact, if the artifact is not a canonical resource, or a resource reference to a canonical resource.", 0, 1, this.resourceReference);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -281470431: {
                    return this.classifier == null ? new Base[]{} : this.classifier.toArray(new Base[this.classifier.size()]);
                }
                case 102727412: {
                    Base[] baseArray;
                    if (this.label == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.label;
                    }
                    return baseArray;
                }
                case 1671764162: {
                    Base[] baseArray;
                    if (this.display == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.display;
                    }
                    return baseArray;
                }
                case -1442706713: {
                    Base[] baseArray;
                    if (this.citation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.citation;
                    }
                    return baseArray;
                }
                case 861720859: {
                    Base[] baseArray;
                    if (this.document == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.document;
                    }
                    return baseArray;
                }
                case -341064690: {
                    Base[] baseArray;
                    if (this.resource == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.resource;
                    }
                    return baseArray;
                }
                case -610120995: {
                    Base[] baseArray;
                    if (this.resourceReference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.resourceReference;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    value = new RelatedArtifactTypeExpandedEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.type = value;
                    return value;
                }
                case -281470431: {
                    this.getClassifier().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 102727412: {
                    this.label = TypeConvertor.castToString(value);
                    return value;
                }
                case 1671764162: {
                    this.display = TypeConvertor.castToString(value);
                    return value;
                }
                case -1442706713: {
                    this.citation = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case 861720859: {
                    this.document = TypeConvertor.castToAttachment(value);
                    return value;
                }
                case -341064690: {
                    this.resource = TypeConvertor.castToCanonical(value);
                    return value;
                }
                case -610120995: {
                    this.resourceReference = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                value = new RelatedArtifactTypeExpandedEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.type = value;
            } else if (name.equals(Citation.SP_CLASSIFIER)) {
                this.getClassifier().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("label")) {
                this.label = TypeConvertor.castToString(value);
            } else if (name.equals("display")) {
                this.display = TypeConvertor.castToString(value);
            } else if (name.equals("citation")) {
                this.citation = TypeConvertor.castToMarkdown(value);
            } else if (name.equals("document")) {
                this.document = TypeConvertor.castToAttachment(value);
            } else if (name.equals("resource")) {
                this.resource = TypeConvertor.castToCanonical(value);
            } else if (name.equals("resourceReference")) {
                this.resourceReference = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                value = new RelatedArtifactTypeExpandedEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.type = value;
            } else if (name.equals(Citation.SP_CLASSIFIER)) {
                this.getClassifier().remove(value);
            } else if (name.equals("label")) {
                this.label = null;
            } else if (name.equals("display")) {
                this.display = null;
            } else if (name.equals("citation")) {
                this.citation = null;
            } else if (name.equals("document")) {
                this.document = null;
            } else if (name.equals("resource")) {
                this.resource = null;
            } else if (name.equals("resourceReference")) {
                this.resourceReference = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getTypeElement();
                }
                case -281470431: {
                    return this.addClassifier();
                }
                case 102727412: {
                    return this.getLabelElement();
                }
                case 1671764162: {
                    return this.getDisplayElement();
                }
                case -1442706713: {
                    return this.getCitationElement();
                }
                case 861720859: {
                    return this.getDocument();
                }
                case -341064690: {
                    return this.getResourceElement();
                }
                case -610120995: {
                    return this.getResourceReference();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"code"};
                }
                case -281470431: {
                    return new String[]{"CodeableConcept"};
                }
                case 102727412: {
                    return new String[]{"string"};
                }
                case 1671764162: {
                    return new String[]{"string"};
                }
                case -1442706713: {
                    return new String[]{"markdown"};
                }
                case 861720859: {
                    return new String[]{"Attachment"};
                }
                case -341064690: {
                    return new String[]{"canonical"};
                }
                case -610120995: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a singleton property Citation.citedArtifact.relatesTo.type");
            }
            if (name.equals(Citation.SP_CLASSIFIER)) {
                return this.addClassifier();
            }
            if (name.equals("label")) {
                throw new FHIRException("Cannot call addChild on a singleton property Citation.citedArtifact.relatesTo.label");
            }
            if (name.equals("display")) {
                throw new FHIRException("Cannot call addChild on a singleton property Citation.citedArtifact.relatesTo.display");
            }
            if (name.equals("citation")) {
                throw new FHIRException("Cannot call addChild on a singleton property Citation.citedArtifact.relatesTo.citation");
            }
            if (name.equals("document")) {
                this.document = new Attachment();
                return this.document;
            }
            if (name.equals("resource")) {
                throw new FHIRException("Cannot call addChild on a singleton property Citation.citedArtifact.relatesTo.resource");
            }
            if (name.equals("resourceReference")) {
                this.resourceReference = new Reference();
                return this.resourceReference;
            }
            return super.addChild(name);
        }

        @Override
        public CitationCitedArtifactRelatesToComponent copy() {
            CitationCitedArtifactRelatesToComponent dst = new CitationCitedArtifactRelatesToComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationCitedArtifactRelatesToComponent dst) {
            super.copyValues(dst);
            Enumeration<RelatedArtifactTypeExpanded> enumeration = dst.type = this.type == null ? null : this.type.copy();
            if (this.classifier != null) {
                dst.classifier = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.classifier) {
                    dst.classifier.add(i.copy());
                }
            }
            dst.label = this.label == null ? null : this.label.copy();
            dst.display = this.display == null ? null : this.display.copy();
            dst.citation = this.citation == null ? null : this.citation.copy();
            dst.document = this.document == null ? null : this.document.copy();
            dst.resource = this.resource == null ? null : this.resource.copy();
            dst.resourceReference = this.resourceReference == null ? null : this.resourceReference.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactRelatesToComponent)) {
                return false;
            }
            CitationCitedArtifactRelatesToComponent o = (CitationCitedArtifactRelatesToComponent)other_;
            return CitationCitedArtifactRelatesToComponent.compareDeep(this.type, o.type, true) && CitationCitedArtifactRelatesToComponent.compareDeep(this.classifier, o.classifier, true) && CitationCitedArtifactRelatesToComponent.compareDeep(this.label, o.label, true) && CitationCitedArtifactRelatesToComponent.compareDeep(this.display, o.display, true) && CitationCitedArtifactRelatesToComponent.compareDeep(this.citation, o.citation, true) && CitationCitedArtifactRelatesToComponent.compareDeep(this.document, o.document, true) && CitationCitedArtifactRelatesToComponent.compareDeep(this.resource, o.resource, true) && CitationCitedArtifactRelatesToComponent.compareDeep(this.resourceReference, o.resourceReference, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactRelatesToComponent)) {
                return false;
            }
            CitationCitedArtifactRelatesToComponent o = (CitationCitedArtifactRelatesToComponent)other_;
            return CitationCitedArtifactRelatesToComponent.compareValues(this.type, o.type, true) && CitationCitedArtifactRelatesToComponent.compareValues(this.label, o.label, true) && CitationCitedArtifactRelatesToComponent.compareValues(this.display, o.display, true) && CitationCitedArtifactRelatesToComponent.compareValues(this.citation, o.citation, true) && CitationCitedArtifactRelatesToComponent.compareValues(this.resource, o.resource, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.classifier, this.label, this.display, this.citation, this.document, this.resource, this.resourceReference});
        }

        @Override
        public String fhirType() {
            return "Citation.citedArtifact.relatesTo";
        }
    }

    @Block
    public static class CitationCitedArtifactPartComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The kind of component", formalDefinition="The kind of component.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/cited-artifact-part-type")
        protected CodeableConcept type;
        @Child(name="value", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The specification of the component", formalDefinition="The specification of the component.")
        protected StringType value;
        @Child(name="baseCitation", type={Citation.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The citation for the full article or artifact", formalDefinition="The citation for the full article or artifact.")
        protected Reference baseCitation;
        private static final long serialVersionUID = -765350500L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPartComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public CitationCitedArtifactPartComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public StringType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPartComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new StringType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public CitationCitedArtifactPartComponent setValueElement(StringType value) {
            this.value = value;
            return this;
        }

        public String getValue() {
            return this.value == null ? null : (String)this.value.getValue();
        }

        public CitationCitedArtifactPartComponent setValue(String value) {
            if (Utilities.noString((String)value)) {
                this.value = null;
            } else {
                if (this.value == null) {
                    this.value = new StringType();
                }
                this.value.setValue(value);
            }
            return this;
        }

        public Reference getBaseCitation() {
            if (this.baseCitation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactPartComponent.baseCitation");
                }
                if (Configuration.doAutoCreate()) {
                    this.baseCitation = new Reference();
                }
            }
            return this.baseCitation;
        }

        public boolean hasBaseCitation() {
            return this.baseCitation != null && !this.baseCitation.isEmpty();
        }

        public CitationCitedArtifactPartComponent setBaseCitation(Reference value) {
            this.baseCitation = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "The kind of component.", 0, 1, this.type));
            children.add(new Property("value", "string", "The specification of the component.", 0, 1, this.value));
            children.add(new Property("baseCitation", "Reference(Citation)", "The citation for the full article or artifact.", 0, 1, this.baseCitation));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The kind of component.", 0, 1, this.type);
                }
                case 111972721: {
                    return new Property("value", "string", "The specification of the component.", 0, 1, this.value);
                }
                case 1182995672: {
                    return new Property("baseCitation", "Reference(Citation)", "The citation for the full article or artifact.", 0, 1, this.baseCitation);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
                case 1182995672: {
                    Base[] baseArray;
                    if (this.baseCitation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.baseCitation;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToString(value);
                    return value;
                }
                case 1182995672: {
                    this.baseCitation = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value")) {
                this.value = TypeConvertor.castToString(value);
            } else if (name.equals("baseCitation")) {
                this.baseCitation = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = null;
            } else if (name.equals("value")) {
                this.value = null;
            } else if (name.equals("baseCitation")) {
                this.baseCitation = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 111972721: {
                    return this.getValueElement();
                }
                case 1182995672: {
                    return this.getBaseCitation();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"string"};
                }
                case 1182995672: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a singleton property Citation.citedArtifact.part.value");
            }
            if (name.equals("baseCitation")) {
                this.baseCitation = new Reference();
                return this.baseCitation;
            }
            return super.addChild(name);
        }

        @Override
        public CitationCitedArtifactPartComponent copy() {
            CitationCitedArtifactPartComponent dst = new CitationCitedArtifactPartComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationCitedArtifactPartComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.value = this.value == null ? null : this.value.copy();
            dst.baseCitation = this.baseCitation == null ? null : this.baseCitation.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactPartComponent)) {
                return false;
            }
            CitationCitedArtifactPartComponent o = (CitationCitedArtifactPartComponent)other_;
            return CitationCitedArtifactPartComponent.compareDeep(this.type, o.type, true) && CitationCitedArtifactPartComponent.compareDeep(this.value, o.value, true) && CitationCitedArtifactPartComponent.compareDeep(this.baseCitation, o.baseCitation, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactPartComponent)) {
                return false;
            }
            CitationCitedArtifactPartComponent o = (CitationCitedArtifactPartComponent)other_;
            return CitationCitedArtifactPartComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.value, this.baseCitation});
        }

        @Override
        public String fhirType() {
            return "Citation.citedArtifact.part";
        }
    }

    @Block
    public static class CitationCitedArtifactAbstractComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The kind of abstract", formalDefinition="Used to express the reason for or classification of the abstract.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/cited-artifact-abstract-type")
        protected CodeableConcept type;
        @Child(name="language", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Used to express the specific language", formalDefinition="Used to express the specific language of the abstract.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/languages")
        protected CodeableConcept language;
        @Child(name="text", type={MarkdownType.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Abstract content", formalDefinition="Abstract content.")
        protected MarkdownType text;
        @Child(name="copyright", type={MarkdownType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Copyright notice for the abstract", formalDefinition="Copyright notice for the abstract.")
        protected MarkdownType copyright;
        private static final long serialVersionUID = -1882363442L;

        public CitationCitedArtifactAbstractComponent() {
        }

        public CitationCitedArtifactAbstractComponent(String text) {
            this.setText(text);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactAbstractComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public CitationCitedArtifactAbstractComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public CodeableConcept getLanguage() {
            if (this.language == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactAbstractComponent.language");
                }
                if (Configuration.doAutoCreate()) {
                    this.language = new CodeableConcept();
                }
            }
            return this.language;
        }

        public boolean hasLanguage() {
            return this.language != null && !this.language.isEmpty();
        }

        public CitationCitedArtifactAbstractComponent setLanguage(CodeableConcept value) {
            this.language = value;
            return this;
        }

        public MarkdownType getTextElement() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactAbstractComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new MarkdownType();
                }
            }
            return this.text;
        }

        public boolean hasTextElement() {
            return this.text != null && !this.text.isEmpty();
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public CitationCitedArtifactAbstractComponent setTextElement(MarkdownType value) {
            this.text = value;
            return this;
        }

        public String getText() {
            return this.text == null ? null : (String)this.text.getValue();
        }

        public CitationCitedArtifactAbstractComponent setText(String value) {
            if (this.text == null) {
                this.text = new MarkdownType();
            }
            this.text.setValue(value);
            return this;
        }

        public MarkdownType getCopyrightElement() {
            if (this.copyright == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactAbstractComponent.copyright");
                }
                if (Configuration.doAutoCreate()) {
                    this.copyright = new MarkdownType();
                }
            }
            return this.copyright;
        }

        public boolean hasCopyrightElement() {
            return this.copyright != null && !this.copyright.isEmpty();
        }

        public boolean hasCopyright() {
            return this.copyright != null && !this.copyright.isEmpty();
        }

        public CitationCitedArtifactAbstractComponent setCopyrightElement(MarkdownType value) {
            this.copyright = value;
            return this;
        }

        public String getCopyright() {
            return this.copyright == null ? null : (String)this.copyright.getValue();
        }

        public CitationCitedArtifactAbstractComponent setCopyright(String value) {
            if (Utilities.noString((String)value)) {
                this.copyright = null;
            } else {
                if (this.copyright == null) {
                    this.copyright = new MarkdownType();
                }
                this.copyright.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Used to express the reason for or classification of the abstract.", 0, 1, this.type));
            children.add(new Property("language", "CodeableConcept", "Used to express the specific language of the abstract.", 0, 1, this.language));
            children.add(new Property("text", "markdown", "Abstract content.", 0, 1, this.text));
            children.add(new Property("copyright", "markdown", "Copyright notice for the abstract.", 0, 1, this.copyright));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Used to express the reason for or classification of the abstract.", 0, 1, this.type);
                }
                case -1613589672: {
                    return new Property("language", "CodeableConcept", "Used to express the specific language of the abstract.", 0, 1, this.language);
                }
                case 3556653: {
                    return new Property("text", "markdown", "Abstract content.", 0, 1, this.text);
                }
                case 1522889671: {
                    return new Property("copyright", "markdown", "Copyright notice for the abstract.", 0, 1, this.copyright);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -1613589672: {
                    Base[] baseArray;
                    if (this.language == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.language;
                    }
                    return baseArray;
                }
                case 3556653: {
                    Base[] baseArray;
                    if (this.text == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.text;
                    }
                    return baseArray;
                }
                case 1522889671: {
                    Base[] baseArray;
                    if (this.copyright == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.copyright;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1613589672: {
                    this.language = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 3556653: {
                    this.text = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case 1522889671: {
                    this.copyright = TypeConvertor.castToMarkdown(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("language")) {
                this.language = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("text")) {
                this.text = TypeConvertor.castToMarkdown(value);
            } else if (name.equals("copyright")) {
                this.copyright = TypeConvertor.castToMarkdown(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = null;
            } else if (name.equals("language")) {
                this.language = null;
            } else if (name.equals("text")) {
                this.text = null;
            } else if (name.equals("copyright")) {
                this.copyright = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1613589672: {
                    return this.getLanguage();
                }
                case 3556653: {
                    return this.getTextElement();
                }
                case 1522889671: {
                    return this.getCopyrightElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1613589672: {
                    return new String[]{"CodeableConcept"};
                }
                case 3556653: {
                    return new String[]{"markdown"};
                }
                case 1522889671: {
                    return new String[]{"markdown"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("language")) {
                this.language = new CodeableConcept();
                return this.language;
            }
            if (name.equals("text")) {
                throw new FHIRException("Cannot call addChild on a singleton property Citation.citedArtifact.abstract.text");
            }
            if (name.equals("copyright")) {
                throw new FHIRException("Cannot call addChild on a singleton property Citation.citedArtifact.abstract.copyright");
            }
            return super.addChild(name);
        }

        @Override
        public CitationCitedArtifactAbstractComponent copy() {
            CitationCitedArtifactAbstractComponent dst = new CitationCitedArtifactAbstractComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationCitedArtifactAbstractComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.language = this.language == null ? null : this.language.copy();
            dst.text = this.text == null ? null : this.text.copy();
            dst.copyright = this.copyright == null ? null : this.copyright.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactAbstractComponent)) {
                return false;
            }
            CitationCitedArtifactAbstractComponent o = (CitationCitedArtifactAbstractComponent)other_;
            return CitationCitedArtifactAbstractComponent.compareDeep(this.type, o.type, true) && CitationCitedArtifactAbstractComponent.compareDeep(this.language, o.language, true) && CitationCitedArtifactAbstractComponent.compareDeep(this.text, o.text, true) && CitationCitedArtifactAbstractComponent.compareDeep(this.copyright, o.copyright, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactAbstractComponent)) {
                return false;
            }
            CitationCitedArtifactAbstractComponent o = (CitationCitedArtifactAbstractComponent)other_;
            return CitationCitedArtifactAbstractComponent.compareValues(this.text, o.text, true) && CitationCitedArtifactAbstractComponent.compareValues(this.copyright, o.copyright, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.language, this.text, this.copyright});
        }

        @Override
        public String fhirType() {
            return "Citation.citedArtifact.abstract";
        }
    }

    @Block
    public static class CitationCitedArtifactTitleComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The kind of title", formalDefinition="Used to express the reason for or classification of the title.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/title-type")
        protected List<CodeableConcept> type;
        @Child(name="language", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Used to express the specific language", formalDefinition="Used to express the specific language of the title.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/languages")
        protected CodeableConcept language;
        @Child(name="text", type={MarkdownType.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The title of the article or artifact", formalDefinition="The title of the article or artifact.")
        protected MarkdownType text;
        private static final long serialVersionUID = 1526221998L;

        public CitationCitedArtifactTitleComponent() {
        }

        public CitationCitedArtifactTitleComponent(String text) {
            this.setText(text);
        }

        public List<CodeableConcept> getType() {
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            return this.type;
        }

        public CitationCitedArtifactTitleComponent setType(List<CodeableConcept> theType) {
            this.type = theType;
            return this;
        }

        public boolean hasType() {
            if (this.type == null) {
                return false;
            }
            for (CodeableConcept item : this.type) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addType() {
            CodeableConcept t = new CodeableConcept();
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return t;
        }

        public CitationCitedArtifactTitleComponent addType(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return this;
        }

        public CodeableConcept getTypeFirstRep() {
            if (this.getType().isEmpty()) {
                this.addType();
            }
            return this.getType().get(0);
        }

        public CodeableConcept getLanguage() {
            if (this.language == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactTitleComponent.language");
                }
                if (Configuration.doAutoCreate()) {
                    this.language = new CodeableConcept();
                }
            }
            return this.language;
        }

        public boolean hasLanguage() {
            return this.language != null && !this.language.isEmpty();
        }

        public CitationCitedArtifactTitleComponent setLanguage(CodeableConcept value) {
            this.language = value;
            return this;
        }

        public MarkdownType getTextElement() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactTitleComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new MarkdownType();
                }
            }
            return this.text;
        }

        public boolean hasTextElement() {
            return this.text != null && !this.text.isEmpty();
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public CitationCitedArtifactTitleComponent setTextElement(MarkdownType value) {
            this.text = value;
            return this;
        }

        public String getText() {
            return this.text == null ? null : (String)this.text.getValue();
        }

        public CitationCitedArtifactTitleComponent setText(String value) {
            if (this.text == null) {
                this.text = new MarkdownType();
            }
            this.text.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Used to express the reason for or classification of the title.", 0, Integer.MAX_VALUE, this.type));
            children.add(new Property("language", "CodeableConcept", "Used to express the specific language of the title.", 0, 1, this.language));
            children.add(new Property("text", "markdown", "The title of the article or artifact.", 0, 1, this.text));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Used to express the reason for or classification of the title.", 0, Integer.MAX_VALUE, this.type);
                }
                case -1613589672: {
                    return new Property("language", "CodeableConcept", "Used to express the specific language of the title.", 0, 1, this.language);
                }
                case 3556653: {
                    return new Property("text", "markdown", "The title of the article or artifact.", 0, 1, this.text);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
                }
                case -1613589672: {
                    Base[] baseArray;
                    if (this.language == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.language;
                    }
                    return baseArray;
                }
                case 3556653: {
                    Base[] baseArray;
                    if (this.text == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.text;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.getType().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -1613589672: {
                    this.language = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 3556653: {
                    this.text = TypeConvertor.castToMarkdown(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.getType().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("language")) {
                this.language = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("text")) {
                this.text = TypeConvertor.castToMarkdown(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.getType().remove(value);
            } else if (name.equals("language")) {
                this.language = null;
            } else if (name.equals("text")) {
                this.text = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.addType();
                }
                case -1613589672: {
                    return this.getLanguage();
                }
                case 3556653: {
                    return this.getTextElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1613589672: {
                    return new String[]{"CodeableConcept"};
                }
                case 3556653: {
                    return new String[]{"markdown"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                return this.addType();
            }
            if (name.equals("language")) {
                this.language = new CodeableConcept();
                return this.language;
            }
            if (name.equals("text")) {
                throw new FHIRException("Cannot call addChild on a singleton property Citation.citedArtifact.title.text");
            }
            return super.addChild(name);
        }

        @Override
        public CitationCitedArtifactTitleComponent copy() {
            CitationCitedArtifactTitleComponent dst = new CitationCitedArtifactTitleComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationCitedArtifactTitleComponent dst) {
            super.copyValues(dst);
            if (this.type != null) {
                dst.type = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.type) {
                    dst.type.add(i.copy());
                }
            }
            dst.language = this.language == null ? null : this.language.copy();
            dst.text = this.text == null ? null : this.text.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactTitleComponent)) {
                return false;
            }
            CitationCitedArtifactTitleComponent o = (CitationCitedArtifactTitleComponent)other_;
            return CitationCitedArtifactTitleComponent.compareDeep(this.type, o.type, true) && CitationCitedArtifactTitleComponent.compareDeep(this.language, o.language, true) && CitationCitedArtifactTitleComponent.compareDeep(this.text, o.text, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactTitleComponent)) {
                return false;
            }
            CitationCitedArtifactTitleComponent o = (CitationCitedArtifactTitleComponent)other_;
            return CitationCitedArtifactTitleComponent.compareValues(this.text, o.text, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.language, this.text});
        }

        @Override
        public String fhirType() {
            return "Citation.citedArtifact.title";
        }
    }

    @Block
    public static class CitationCitedArtifactStatusDateComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="activity", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Classification of the status", formalDefinition="A definition of the status associated with a date or period.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/cited-artifact-status-type")
        protected CodeableConcept activity;
        @Child(name="actual", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Either occurred or expected", formalDefinition="Either occurred or expected.")
        protected BooleanType actual;
        @Child(name="period", type={Period.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When the status started and/or ended", formalDefinition="When the status started and/or ended.")
        protected Period period;
        private static final long serialVersionUID = 1123586924L;

        public CitationCitedArtifactStatusDateComponent() {
        }

        public CitationCitedArtifactStatusDateComponent(CodeableConcept activity, Period period) {
            this.setActivity(activity);
            this.setPeriod(period);
        }

        public CodeableConcept getActivity() {
            if (this.activity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactStatusDateComponent.activity");
                }
                if (Configuration.doAutoCreate()) {
                    this.activity = new CodeableConcept();
                }
            }
            return this.activity;
        }

        public boolean hasActivity() {
            return this.activity != null && !this.activity.isEmpty();
        }

        public CitationCitedArtifactStatusDateComponent setActivity(CodeableConcept value) {
            this.activity = value;
            return this;
        }

        public BooleanType getActualElement() {
            if (this.actual == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactStatusDateComponent.actual");
                }
                if (Configuration.doAutoCreate()) {
                    this.actual = new BooleanType();
                }
            }
            return this.actual;
        }

        public boolean hasActualElement() {
            return this.actual != null && !this.actual.isEmpty();
        }

        public boolean hasActual() {
            return this.actual != null && !this.actual.isEmpty();
        }

        public CitationCitedArtifactStatusDateComponent setActualElement(BooleanType value) {
            this.actual = value;
            return this;
        }

        public boolean getActual() {
            return this.actual == null || this.actual.isEmpty() ? false : (Boolean)this.actual.getValue();
        }

        public CitationCitedArtifactStatusDateComponent setActual(boolean value) {
            if (this.actual == null) {
                this.actual = new BooleanType();
            }
            this.actual.setValue((Object)value);
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactStatusDateComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public CitationCitedArtifactStatusDateComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("activity", "CodeableConcept", "A definition of the status associated with a date or period.", 0, 1, this.activity));
            children.add(new Property("actual", "boolean", "Either occurred or expected.", 0, 1, this.actual));
            children.add(new Property("period", "Period", "When the status started and/or ended.", 0, 1, this.period));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1655966961: {
                    return new Property("activity", "CodeableConcept", "A definition of the status associated with a date or period.", 0, 1, this.activity);
                }
                case -1422939762: {
                    return new Property("actual", "boolean", "Either occurred or expected.", 0, 1, this.actual);
                }
                case -991726143: {
                    return new Property("period", "Period", "When the status started and/or ended.", 0, 1, this.period);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1655966961: {
                    Base[] baseArray;
                    if (this.activity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.activity;
                    }
                    return baseArray;
                }
                case -1422939762: {
                    Base[] baseArray;
                    if (this.actual == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.actual;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.period;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1655966961: {
                    this.activity = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1422939762: {
                    this.actual = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -991726143: {
                    this.period = TypeConvertor.castToPeriod(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("activity")) {
                this.activity = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("actual")) {
                this.actual = TypeConvertor.castToBoolean(value);
            } else if (name.equals("period")) {
                this.period = TypeConvertor.castToPeriod(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("activity")) {
                this.activity = null;
            } else if (name.equals("actual")) {
                this.actual = null;
            } else if (name.equals("period")) {
                this.period = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1655966961: {
                    return this.getActivity();
                }
                case -1422939762: {
                    return this.getActualElement();
                }
                case -991726143: {
                    return this.getPeriod();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1655966961: {
                    return new String[]{"CodeableConcept"};
                }
                case -1422939762: {
                    return new String[]{"boolean"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("activity")) {
                this.activity = new CodeableConcept();
                return this.activity;
            }
            if (name.equals("actual")) {
                throw new FHIRException("Cannot call addChild on a singleton property Citation.citedArtifact.statusDate.actual");
            }
            if (name.equals("period")) {
                this.period = new Period();
                return this.period;
            }
            return super.addChild(name);
        }

        @Override
        public CitationCitedArtifactStatusDateComponent copy() {
            CitationCitedArtifactStatusDateComponent dst = new CitationCitedArtifactStatusDateComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationCitedArtifactStatusDateComponent dst) {
            super.copyValues(dst);
            dst.activity = this.activity == null ? null : this.activity.copy();
            dst.actual = this.actual == null ? null : this.actual.copy();
            dst.period = this.period == null ? null : this.period.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactStatusDateComponent)) {
                return false;
            }
            CitationCitedArtifactStatusDateComponent o = (CitationCitedArtifactStatusDateComponent)other_;
            return CitationCitedArtifactStatusDateComponent.compareDeep(this.activity, o.activity, true) && CitationCitedArtifactStatusDateComponent.compareDeep(this.actual, o.actual, true) && CitationCitedArtifactStatusDateComponent.compareDeep(this.period, o.period, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactStatusDateComponent)) {
                return false;
            }
            CitationCitedArtifactStatusDateComponent o = (CitationCitedArtifactStatusDateComponent)other_;
            return CitationCitedArtifactStatusDateComponent.compareValues(this.actual, o.actual, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.activity, this.actual, this.period});
        }

        @Override
        public String fhirType() {
            return "Citation.citedArtifact.statusDate";
        }
    }

    @Block
    public static class CitationCitedArtifactVersionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="value", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The version number or other version identifier", formalDefinition="The version number or other version identifier.")
        protected StringType value;
        @Child(name="baseCitation", type={Citation.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Citation for the main version of the cited artifact", formalDefinition="Citation for the main version of the cited artifact.")
        protected Reference baseCitation;
        private static final long serialVersionUID = 1437090319L;

        public CitationCitedArtifactVersionComponent() {
        }

        public CitationCitedArtifactVersionComponent(String value) {
            this.setValue(value);
        }

        public StringType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactVersionComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new StringType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public CitationCitedArtifactVersionComponent setValueElement(StringType value) {
            this.value = value;
            return this;
        }

        public String getValue() {
            return this.value == null ? null : (String)this.value.getValue();
        }

        public CitationCitedArtifactVersionComponent setValue(String value) {
            if (this.value == null) {
                this.value = new StringType();
            }
            this.value.setValue(value);
            return this;
        }

        public Reference getBaseCitation() {
            if (this.baseCitation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactVersionComponent.baseCitation");
                }
                if (Configuration.doAutoCreate()) {
                    this.baseCitation = new Reference();
                }
            }
            return this.baseCitation;
        }

        public boolean hasBaseCitation() {
            return this.baseCitation != null && !this.baseCitation.isEmpty();
        }

        public CitationCitedArtifactVersionComponent setBaseCitation(Reference value) {
            this.baseCitation = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("value", "string", "The version number or other version identifier.", 0, 1, this.value));
            children.add(new Property("baseCitation", "Reference(Citation)", "Citation for the main version of the cited artifact.", 0, 1, this.baseCitation));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 111972721: {
                    return new Property("value", "string", "The version number or other version identifier.", 0, 1, this.value);
                }
                case 1182995672: {
                    return new Property("baseCitation", "Reference(Citation)", "Citation for the main version of the cited artifact.", 0, 1, this.baseCitation);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.value;
                    }
                    return baseArray;
                }
                case 1182995672: {
                    Base[] baseArray;
                    if (this.baseCitation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.baseCitation;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    this.value = TypeConvertor.castToString(value);
                    return value;
                }
                case 1182995672: {
                    this.baseCitation = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("value")) {
                this.value = TypeConvertor.castToString(value);
            } else if (name.equals("baseCitation")) {
                this.baseCitation = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("value")) {
                this.value = null;
            } else if (name.equals("baseCitation")) {
                this.baseCitation = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    return this.getValueElement();
                }
                case 1182995672: {
                    return this.getBaseCitation();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    return new String[]{"string"};
                }
                case 1182995672: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a singleton property Citation.citedArtifact.version.value");
            }
            if (name.equals("baseCitation")) {
                this.baseCitation = new Reference();
                return this.baseCitation;
            }
            return super.addChild(name);
        }

        @Override
        public CitationCitedArtifactVersionComponent copy() {
            CitationCitedArtifactVersionComponent dst = new CitationCitedArtifactVersionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationCitedArtifactVersionComponent dst) {
            super.copyValues(dst);
            dst.value = this.value == null ? null : this.value.copy();
            dst.baseCitation = this.baseCitation == null ? null : this.baseCitation.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactVersionComponent)) {
                return false;
            }
            CitationCitedArtifactVersionComponent o = (CitationCitedArtifactVersionComponent)other_;
            return CitationCitedArtifactVersionComponent.compareDeep(this.value, o.value, true) && CitationCitedArtifactVersionComponent.compareDeep(this.baseCitation, o.baseCitation, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactVersionComponent)) {
                return false;
            }
            CitationCitedArtifactVersionComponent o = (CitationCitedArtifactVersionComponent)other_;
            return CitationCitedArtifactVersionComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.value, this.baseCitation});
        }

        @Override
        public String fhirType() {
            return "Citation.citedArtifact.version";
        }
    }

    @Block
    public static class CitationCitedArtifactComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Unique identifier. May include DOI, PMID, PMCID, etc", formalDefinition="A formal identifier that is used to identify the cited artifact when it is represented in other formats, or referenced in a specification, model, design or an instance.")
        protected List<Identifier> identifier;
        @Child(name="relatedIdentifier", type={Identifier.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Identifier not unique to the cited artifact. May include trial registry identifiers", formalDefinition="A formal identifier that is used to identify things closely related to the cited artifact.")
        protected List<Identifier> relatedIdentifier;
        @Child(name="dateAccessed", type={DateTimeType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="When the cited artifact was accessed", formalDefinition="When the cited artifact was accessed.")
        protected DateTimeType dateAccessed;
        @Child(name="version", type={}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The defined version of the cited artifact", formalDefinition="The defined version of the cited artifact.")
        protected CitationCitedArtifactVersionComponent version;
        @Child(name="currentState", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The status of the cited artifact", formalDefinition="The status of the cited artifact.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/cited-artifact-status-type")
        protected List<CodeableConcept> currentState;
        @Child(name="statusDate", type={}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="An effective date or period for a status of the cited artifact", formalDefinition="An effective date or period, historical or future, actual or expected, for a status of the cited artifact.")
        protected List<CitationCitedArtifactStatusDateComponent> statusDate;
        @Child(name="title", type={}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The title details of the article or artifact", formalDefinition="The title details of the article or artifact.")
        protected List<CitationCitedArtifactTitleComponent> title;
        @Child(name="abstract", type={}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Summary of the article or artifact", formalDefinition="The abstract may be used to convey article-contained abstracts, externally-created abstracts, or other descriptive summaries.")
        protected List<CitationCitedArtifactAbstractComponent> abstract_;
        @Child(name="part", type={}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The component of the article or artifact", formalDefinition="The component of the article or artifact.")
        protected CitationCitedArtifactPartComponent part;
        @Child(name="relatesTo", type={}, order=10, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The artifact related to the cited artifact", formalDefinition="The artifact related to the cited artifact.")
        protected List<CitationCitedArtifactRelatesToComponent> relatesTo;
        @Child(name="publicationForm", type={}, order=11, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="If multiple, used to represent alternative forms of the article that are not separate citations", formalDefinition="If multiple, used to represent alternative forms of the article that are not separate citations.")
        protected List<CitationCitedArtifactPublicationFormComponent> publicationForm;
        @Child(name="webLocation", type={}, order=12, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Used for any URL for the article or artifact cited", formalDefinition="Used for any URL for the article or artifact cited.")
        protected List<CitationCitedArtifactWebLocationComponent> webLocation;
        @Child(name="classification", type={}, order=13, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The assignment to an organizing scheme", formalDefinition="The assignment to an organizing scheme.")
        protected List<CitationCitedArtifactClassificationComponent> classification;
        @Child(name="contributorship", type={}, order=14, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Attribution of authors and other contributors", formalDefinition="This element is used to list authors and other contributors, their contact information, specific contributions, and summary statements.")
        protected CitationCitedArtifactContributorshipComponent contributorship;
        @Child(name="note", type={Annotation.class}, order=15, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Any additional information or content for the article or artifact", formalDefinition="Any additional information or content for the article or artifact.")
        protected List<Annotation> note;
        private static final long serialVersionUID = -1685890486L;

        public List<Identifier> getIdentifier() {
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            return this.identifier;
        }

        public CitationCitedArtifactComponent setIdentifier(List<Identifier> theIdentifier) {
            this.identifier = theIdentifier;
            return this;
        }

        public boolean hasIdentifier() {
            if (this.identifier == null) {
                return false;
            }
            for (Identifier item : this.identifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Identifier addIdentifier() {
            Identifier t = new Identifier();
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return t;
        }

        public CitationCitedArtifactComponent addIdentifier(Identifier t) {
            if (t == null) {
                return this;
            }
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return this;
        }

        public Identifier getIdentifierFirstRep() {
            if (this.getIdentifier().isEmpty()) {
                this.addIdentifier();
            }
            return this.getIdentifier().get(0);
        }

        public List<Identifier> getRelatedIdentifier() {
            if (this.relatedIdentifier == null) {
                this.relatedIdentifier = new ArrayList<Identifier>();
            }
            return this.relatedIdentifier;
        }

        public CitationCitedArtifactComponent setRelatedIdentifier(List<Identifier> theRelatedIdentifier) {
            this.relatedIdentifier = theRelatedIdentifier;
            return this;
        }

        public boolean hasRelatedIdentifier() {
            if (this.relatedIdentifier == null) {
                return false;
            }
            for (Identifier item : this.relatedIdentifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Identifier addRelatedIdentifier() {
            Identifier t = new Identifier();
            if (this.relatedIdentifier == null) {
                this.relatedIdentifier = new ArrayList<Identifier>();
            }
            this.relatedIdentifier.add(t);
            return t;
        }

        public CitationCitedArtifactComponent addRelatedIdentifier(Identifier t) {
            if (t == null) {
                return this;
            }
            if (this.relatedIdentifier == null) {
                this.relatedIdentifier = new ArrayList<Identifier>();
            }
            this.relatedIdentifier.add(t);
            return this;
        }

        public Identifier getRelatedIdentifierFirstRep() {
            if (this.getRelatedIdentifier().isEmpty()) {
                this.addRelatedIdentifier();
            }
            return this.getRelatedIdentifier().get(0);
        }

        public DateTimeType getDateAccessedElement() {
            if (this.dateAccessed == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactComponent.dateAccessed");
                }
                if (Configuration.doAutoCreate()) {
                    this.dateAccessed = new DateTimeType();
                }
            }
            return this.dateAccessed;
        }

        public boolean hasDateAccessedElement() {
            return this.dateAccessed != null && !this.dateAccessed.isEmpty();
        }

        public boolean hasDateAccessed() {
            return this.dateAccessed != null && !this.dateAccessed.isEmpty();
        }

        public CitationCitedArtifactComponent setDateAccessedElement(DateTimeType value) {
            this.dateAccessed = value;
            return this;
        }

        public Date getDateAccessed() {
            return this.dateAccessed == null ? null : (Date)this.dateAccessed.getValue();
        }

        public CitationCitedArtifactComponent setDateAccessed(Date value) {
            if (value == null) {
                this.dateAccessed = null;
            } else {
                if (this.dateAccessed == null) {
                    this.dateAccessed = new DateTimeType();
                }
                this.dateAccessed.setValue(value);
            }
            return this;
        }

        public CitationCitedArtifactVersionComponent getVersion() {
            if (this.version == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactComponent.version");
                }
                if (Configuration.doAutoCreate()) {
                    this.version = new CitationCitedArtifactVersionComponent();
                }
            }
            return this.version;
        }

        public boolean hasVersion() {
            return this.version != null && !this.version.isEmpty();
        }

        public CitationCitedArtifactComponent setVersion(CitationCitedArtifactVersionComponent value) {
            this.version = value;
            return this;
        }

        public List<CodeableConcept> getCurrentState() {
            if (this.currentState == null) {
                this.currentState = new ArrayList<CodeableConcept>();
            }
            return this.currentState;
        }

        public CitationCitedArtifactComponent setCurrentState(List<CodeableConcept> theCurrentState) {
            this.currentState = theCurrentState;
            return this;
        }

        public boolean hasCurrentState() {
            if (this.currentState == null) {
                return false;
            }
            for (CodeableConcept item : this.currentState) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addCurrentState() {
            CodeableConcept t = new CodeableConcept();
            if (this.currentState == null) {
                this.currentState = new ArrayList<CodeableConcept>();
            }
            this.currentState.add(t);
            return t;
        }

        public CitationCitedArtifactComponent addCurrentState(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.currentState == null) {
                this.currentState = new ArrayList<CodeableConcept>();
            }
            this.currentState.add(t);
            return this;
        }

        public CodeableConcept getCurrentStateFirstRep() {
            if (this.getCurrentState().isEmpty()) {
                this.addCurrentState();
            }
            return this.getCurrentState().get(0);
        }

        public List<CitationCitedArtifactStatusDateComponent> getStatusDate() {
            if (this.statusDate == null) {
                this.statusDate = new ArrayList<CitationCitedArtifactStatusDateComponent>();
            }
            return this.statusDate;
        }

        public CitationCitedArtifactComponent setStatusDate(List<CitationCitedArtifactStatusDateComponent> theStatusDate) {
            this.statusDate = theStatusDate;
            return this;
        }

        public boolean hasStatusDate() {
            if (this.statusDate == null) {
                return false;
            }
            for (CitationCitedArtifactStatusDateComponent item : this.statusDate) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CitationCitedArtifactStatusDateComponent addStatusDate() {
            CitationCitedArtifactStatusDateComponent t = new CitationCitedArtifactStatusDateComponent();
            if (this.statusDate == null) {
                this.statusDate = new ArrayList<CitationCitedArtifactStatusDateComponent>();
            }
            this.statusDate.add(t);
            return t;
        }

        public CitationCitedArtifactComponent addStatusDate(CitationCitedArtifactStatusDateComponent t) {
            if (t == null) {
                return this;
            }
            if (this.statusDate == null) {
                this.statusDate = new ArrayList<CitationCitedArtifactStatusDateComponent>();
            }
            this.statusDate.add(t);
            return this;
        }

        public CitationCitedArtifactStatusDateComponent getStatusDateFirstRep() {
            if (this.getStatusDate().isEmpty()) {
                this.addStatusDate();
            }
            return this.getStatusDate().get(0);
        }

        public List<CitationCitedArtifactTitleComponent> getTitle() {
            if (this.title == null) {
                this.title = new ArrayList<CitationCitedArtifactTitleComponent>();
            }
            return this.title;
        }

        public CitationCitedArtifactComponent setTitle(List<CitationCitedArtifactTitleComponent> theTitle) {
            this.title = theTitle;
            return this;
        }

        public boolean hasTitle() {
            if (this.title == null) {
                return false;
            }
            for (CitationCitedArtifactTitleComponent item : this.title) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CitationCitedArtifactTitleComponent addTitle() {
            CitationCitedArtifactTitleComponent t = new CitationCitedArtifactTitleComponent();
            if (this.title == null) {
                this.title = new ArrayList<CitationCitedArtifactTitleComponent>();
            }
            this.title.add(t);
            return t;
        }

        public CitationCitedArtifactComponent addTitle(CitationCitedArtifactTitleComponent t) {
            if (t == null) {
                return this;
            }
            if (this.title == null) {
                this.title = new ArrayList<CitationCitedArtifactTitleComponent>();
            }
            this.title.add(t);
            return this;
        }

        public CitationCitedArtifactTitleComponent getTitleFirstRep() {
            if (this.getTitle().isEmpty()) {
                this.addTitle();
            }
            return this.getTitle().get(0);
        }

        public List<CitationCitedArtifactAbstractComponent> getAbstract() {
            if (this.abstract_ == null) {
                this.abstract_ = new ArrayList<CitationCitedArtifactAbstractComponent>();
            }
            return this.abstract_;
        }

        public CitationCitedArtifactComponent setAbstract(List<CitationCitedArtifactAbstractComponent> theAbstract) {
            this.abstract_ = theAbstract;
            return this;
        }

        public boolean hasAbstract() {
            if (this.abstract_ == null) {
                return false;
            }
            for (CitationCitedArtifactAbstractComponent item : this.abstract_) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CitationCitedArtifactAbstractComponent addAbstract() {
            CitationCitedArtifactAbstractComponent t = new CitationCitedArtifactAbstractComponent();
            if (this.abstract_ == null) {
                this.abstract_ = new ArrayList<CitationCitedArtifactAbstractComponent>();
            }
            this.abstract_.add(t);
            return t;
        }

        public CitationCitedArtifactComponent addAbstract(CitationCitedArtifactAbstractComponent t) {
            if (t == null) {
                return this;
            }
            if (this.abstract_ == null) {
                this.abstract_ = new ArrayList<CitationCitedArtifactAbstractComponent>();
            }
            this.abstract_.add(t);
            return this;
        }

        public CitationCitedArtifactAbstractComponent getAbstractFirstRep() {
            if (this.getAbstract().isEmpty()) {
                this.addAbstract();
            }
            return this.getAbstract().get(0);
        }

        public CitationCitedArtifactPartComponent getPart() {
            if (this.part == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactComponent.part");
                }
                if (Configuration.doAutoCreate()) {
                    this.part = new CitationCitedArtifactPartComponent();
                }
            }
            return this.part;
        }

        public boolean hasPart() {
            return this.part != null && !this.part.isEmpty();
        }

        public CitationCitedArtifactComponent setPart(CitationCitedArtifactPartComponent value) {
            this.part = value;
            return this;
        }

        public List<CitationCitedArtifactRelatesToComponent> getRelatesTo() {
            if (this.relatesTo == null) {
                this.relatesTo = new ArrayList<CitationCitedArtifactRelatesToComponent>();
            }
            return this.relatesTo;
        }

        public CitationCitedArtifactComponent setRelatesTo(List<CitationCitedArtifactRelatesToComponent> theRelatesTo) {
            this.relatesTo = theRelatesTo;
            return this;
        }

        public boolean hasRelatesTo() {
            if (this.relatesTo == null) {
                return false;
            }
            for (CitationCitedArtifactRelatesToComponent item : this.relatesTo) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CitationCitedArtifactRelatesToComponent addRelatesTo() {
            CitationCitedArtifactRelatesToComponent t = new CitationCitedArtifactRelatesToComponent();
            if (this.relatesTo == null) {
                this.relatesTo = new ArrayList<CitationCitedArtifactRelatesToComponent>();
            }
            this.relatesTo.add(t);
            return t;
        }

        public CitationCitedArtifactComponent addRelatesTo(CitationCitedArtifactRelatesToComponent t) {
            if (t == null) {
                return this;
            }
            if (this.relatesTo == null) {
                this.relatesTo = new ArrayList<CitationCitedArtifactRelatesToComponent>();
            }
            this.relatesTo.add(t);
            return this;
        }

        public CitationCitedArtifactRelatesToComponent getRelatesToFirstRep() {
            if (this.getRelatesTo().isEmpty()) {
                this.addRelatesTo();
            }
            return this.getRelatesTo().get(0);
        }

        public List<CitationCitedArtifactPublicationFormComponent> getPublicationForm() {
            if (this.publicationForm == null) {
                this.publicationForm = new ArrayList<CitationCitedArtifactPublicationFormComponent>();
            }
            return this.publicationForm;
        }

        public CitationCitedArtifactComponent setPublicationForm(List<CitationCitedArtifactPublicationFormComponent> thePublicationForm) {
            this.publicationForm = thePublicationForm;
            return this;
        }

        public boolean hasPublicationForm() {
            if (this.publicationForm == null) {
                return false;
            }
            for (CitationCitedArtifactPublicationFormComponent item : this.publicationForm) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CitationCitedArtifactPublicationFormComponent addPublicationForm() {
            CitationCitedArtifactPublicationFormComponent t = new CitationCitedArtifactPublicationFormComponent();
            if (this.publicationForm == null) {
                this.publicationForm = new ArrayList<CitationCitedArtifactPublicationFormComponent>();
            }
            this.publicationForm.add(t);
            return t;
        }

        public CitationCitedArtifactComponent addPublicationForm(CitationCitedArtifactPublicationFormComponent t) {
            if (t == null) {
                return this;
            }
            if (this.publicationForm == null) {
                this.publicationForm = new ArrayList<CitationCitedArtifactPublicationFormComponent>();
            }
            this.publicationForm.add(t);
            return this;
        }

        public CitationCitedArtifactPublicationFormComponent getPublicationFormFirstRep() {
            if (this.getPublicationForm().isEmpty()) {
                this.addPublicationForm();
            }
            return this.getPublicationForm().get(0);
        }

        public List<CitationCitedArtifactWebLocationComponent> getWebLocation() {
            if (this.webLocation == null) {
                this.webLocation = new ArrayList<CitationCitedArtifactWebLocationComponent>();
            }
            return this.webLocation;
        }

        public CitationCitedArtifactComponent setWebLocation(List<CitationCitedArtifactWebLocationComponent> theWebLocation) {
            this.webLocation = theWebLocation;
            return this;
        }

        public boolean hasWebLocation() {
            if (this.webLocation == null) {
                return false;
            }
            for (CitationCitedArtifactWebLocationComponent item : this.webLocation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CitationCitedArtifactWebLocationComponent addWebLocation() {
            CitationCitedArtifactWebLocationComponent t = new CitationCitedArtifactWebLocationComponent();
            if (this.webLocation == null) {
                this.webLocation = new ArrayList<CitationCitedArtifactWebLocationComponent>();
            }
            this.webLocation.add(t);
            return t;
        }

        public CitationCitedArtifactComponent addWebLocation(CitationCitedArtifactWebLocationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.webLocation == null) {
                this.webLocation = new ArrayList<CitationCitedArtifactWebLocationComponent>();
            }
            this.webLocation.add(t);
            return this;
        }

        public CitationCitedArtifactWebLocationComponent getWebLocationFirstRep() {
            if (this.getWebLocation().isEmpty()) {
                this.addWebLocation();
            }
            return this.getWebLocation().get(0);
        }

        public List<CitationCitedArtifactClassificationComponent> getClassification() {
            if (this.classification == null) {
                this.classification = new ArrayList<CitationCitedArtifactClassificationComponent>();
            }
            return this.classification;
        }

        public CitationCitedArtifactComponent setClassification(List<CitationCitedArtifactClassificationComponent> theClassification) {
            this.classification = theClassification;
            return this;
        }

        public boolean hasClassification() {
            if (this.classification == null) {
                return false;
            }
            for (CitationCitedArtifactClassificationComponent item : this.classification) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CitationCitedArtifactClassificationComponent addClassification() {
            CitationCitedArtifactClassificationComponent t = new CitationCitedArtifactClassificationComponent();
            if (this.classification == null) {
                this.classification = new ArrayList<CitationCitedArtifactClassificationComponent>();
            }
            this.classification.add(t);
            return t;
        }

        public CitationCitedArtifactComponent addClassification(CitationCitedArtifactClassificationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.classification == null) {
                this.classification = new ArrayList<CitationCitedArtifactClassificationComponent>();
            }
            this.classification.add(t);
            return this;
        }

        public CitationCitedArtifactClassificationComponent getClassificationFirstRep() {
            if (this.getClassification().isEmpty()) {
                this.addClassification();
            }
            return this.getClassification().get(0);
        }

        public CitationCitedArtifactContributorshipComponent getContributorship() {
            if (this.contributorship == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationCitedArtifactComponent.contributorship");
                }
                if (Configuration.doAutoCreate()) {
                    this.contributorship = new CitationCitedArtifactContributorshipComponent();
                }
            }
            return this.contributorship;
        }

        public boolean hasContributorship() {
            return this.contributorship != null && !this.contributorship.isEmpty();
        }

        public CitationCitedArtifactComponent setContributorship(CitationCitedArtifactContributorshipComponent value) {
            this.contributorship = value;
            return this;
        }

        public List<Annotation> getNote() {
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            return this.note;
        }

        public CitationCitedArtifactComponent setNote(List<Annotation> theNote) {
            this.note = theNote;
            return this;
        }

        public boolean hasNote() {
            if (this.note == null) {
                return false;
            }
            for (Annotation item : this.note) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Annotation addNote() {
            Annotation t = new Annotation();
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return t;
        }

        public CitationCitedArtifactComponent addNote(Annotation t) {
            if (t == null) {
                return this;
            }
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return this;
        }

        public Annotation getNoteFirstRep() {
            if (this.getNote().isEmpty()) {
                this.addNote();
            }
            return this.getNote().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Citation.SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify the cited artifact when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
            children.add(new Property("relatedIdentifier", "Identifier", "A formal identifier that is used to identify things closely related to the cited artifact.", 0, Integer.MAX_VALUE, this.relatedIdentifier));
            children.add(new Property("dateAccessed", "dateTime", "When the cited artifact was accessed.", 0, 1, this.dateAccessed));
            children.add(new Property(Citation.SP_VERSION, "", "The defined version of the cited artifact.", 0, 1, this.version));
            children.add(new Property("currentState", "CodeableConcept", "The status of the cited artifact.", 0, Integer.MAX_VALUE, this.currentState));
            children.add(new Property("statusDate", "", "An effective date or period, historical or future, actual or expected, for a status of the cited artifact.", 0, Integer.MAX_VALUE, this.statusDate));
            children.add(new Property(Citation.SP_TITLE, "", "The title details of the article or artifact.", 0, Integer.MAX_VALUE, this.title));
            children.add(new Property("abstract", "", "The abstract may be used to convey article-contained abstracts, externally-created abstracts, or other descriptive summaries.", 0, Integer.MAX_VALUE, this.abstract_));
            children.add(new Property("part", "", "The component of the article or artifact.", 0, 1, this.part));
            children.add(new Property("relatesTo", "", "The artifact related to the cited artifact.", 0, Integer.MAX_VALUE, this.relatesTo));
            children.add(new Property("publicationForm", "", "If multiple, used to represent alternative forms of the article that are not separate citations.", 0, Integer.MAX_VALUE, this.publicationForm));
            children.add(new Property("webLocation", "", "Used for any URL for the article or artifact cited.", 0, Integer.MAX_VALUE, this.webLocation));
            children.add(new Property(Citation.SP_CLASSIFICATION, "", "The assignment to an organizing scheme.", 0, Integer.MAX_VALUE, this.classification));
            children.add(new Property("contributorship", "", "This element is used to list authors and other contributors, their contact information, specific contributions, and summary statements.", 0, 1, this.contributorship));
            children.add(new Property("note", "Annotation", "Any additional information or content for the article or artifact.", 0, Integer.MAX_VALUE, this.note));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1618432855: {
                    return new Property(Citation.SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify the cited artifact when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier);
                }
                case -1007604940: {
                    return new Property("relatedIdentifier", "Identifier", "A formal identifier that is used to identify things closely related to the cited artifact.", 0, Integer.MAX_VALUE, this.relatedIdentifier);
                }
                case 540917457: {
                    return new Property("dateAccessed", "dateTime", "When the cited artifact was accessed.", 0, 1, this.dateAccessed);
                }
                case 351608024: {
                    return new Property(Citation.SP_VERSION, "", "The defined version of the cited artifact.", 0, 1, this.version);
                }
                case 1457822360: {
                    return new Property("currentState", "CodeableConcept", "The status of the cited artifact.", 0, Integer.MAX_VALUE, this.currentState);
                }
                case 247524032: {
                    return new Property("statusDate", "", "An effective date or period, historical or future, actual or expected, for a status of the cited artifact.", 0, Integer.MAX_VALUE, this.statusDate);
                }
                case 110371416: {
                    return new Property(Citation.SP_TITLE, "", "The title details of the article or artifact.", 0, Integer.MAX_VALUE, this.title);
                }
                case 1732898850: {
                    return new Property("abstract", "", "The abstract may be used to convey article-contained abstracts, externally-created abstracts, or other descriptive summaries.", 0, Integer.MAX_VALUE, this.abstract_);
                }
                case 3433459: {
                    return new Property("part", "", "The component of the article or artifact.", 0, 1, this.part);
                }
                case -7765931: {
                    return new Property("relatesTo", "", "The artifact related to the cited artifact.", 0, Integer.MAX_VALUE, this.relatesTo);
                }
                case 1470639376: {
                    return new Property("publicationForm", "", "If multiple, used to represent alternative forms of the article that are not separate citations.", 0, Integer.MAX_VALUE, this.publicationForm);
                }
                case -828032215: {
                    return new Property("webLocation", "", "Used for any URL for the article or artifact cited.", 0, Integer.MAX_VALUE, this.webLocation);
                }
                case 382350310: {
                    return new Property(Citation.SP_CLASSIFICATION, "", "The assignment to an organizing scheme.", 0, Integer.MAX_VALUE, this.classification);
                }
                case 538727831: {
                    return new Property("contributorship", "", "This element is used to list authors and other contributors, their contact information, specific contributions, and summary statements.", 0, 1, this.contributorship);
                }
                case 3387378: {
                    return new Property("note", "Annotation", "Any additional information or content for the article or artifact.", 0, Integer.MAX_VALUE, this.note);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
                }
                case -1007604940: {
                    return this.relatedIdentifier == null ? new Base[]{} : this.relatedIdentifier.toArray(new Base[this.relatedIdentifier.size()]);
                }
                case 540917457: {
                    Base[] baseArray;
                    if (this.dateAccessed == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.dateAccessed;
                    }
                    return baseArray;
                }
                case 351608024: {
                    Base[] baseArray;
                    if (this.version == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.version;
                    }
                    return baseArray;
                }
                case 1457822360: {
                    return this.currentState == null ? new Base[]{} : this.currentState.toArray(new Base[this.currentState.size()]);
                }
                case 247524032: {
                    return this.statusDate == null ? new Base[]{} : this.statusDate.toArray(new Base[this.statusDate.size()]);
                }
                case 110371416: {
                    return this.title == null ? new Base[]{} : this.title.toArray(new Base[this.title.size()]);
                }
                case 1732898850: {
                    return this.abstract_ == null ? new Base[]{} : this.abstract_.toArray(new Base[this.abstract_.size()]);
                }
                case 3433459: {
                    Base[] baseArray;
                    if (this.part == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.part;
                    }
                    return baseArray;
                }
                case -7765931: {
                    return this.relatesTo == null ? new Base[]{} : this.relatesTo.toArray(new Base[this.relatesTo.size()]);
                }
                case 1470639376: {
                    return this.publicationForm == null ? new Base[]{} : this.publicationForm.toArray(new Base[this.publicationForm.size()]);
                }
                case -828032215: {
                    return this.webLocation == null ? new Base[]{} : this.webLocation.toArray(new Base[this.webLocation.size()]);
                }
                case 382350310: {
                    return this.classification == null ? new Base[]{} : this.classification.toArray(new Base[this.classification.size()]);
                }
                case 538727831: {
                    Base[] baseArray;
                    if (this.contributorship == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.contributorship;
                    }
                    return baseArray;
                }
                case 3387378: {
                    return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                    return value;
                }
                case -1007604940: {
                    this.getRelatedIdentifier().add(TypeConvertor.castToIdentifier(value));
                    return value;
                }
                case 540917457: {
                    this.dateAccessed = TypeConvertor.castToDateTime(value);
                    return value;
                }
                case 351608024: {
                    this.version = (CitationCitedArtifactVersionComponent)value;
                    return value;
                }
                case 1457822360: {
                    this.getCurrentState().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 247524032: {
                    this.getStatusDate().add((CitationCitedArtifactStatusDateComponent)value);
                    return value;
                }
                case 110371416: {
                    this.getTitle().add((CitationCitedArtifactTitleComponent)value);
                    return value;
                }
                case 1732898850: {
                    this.getAbstract().add((CitationCitedArtifactAbstractComponent)value);
                    return value;
                }
                case 3433459: {
                    this.part = (CitationCitedArtifactPartComponent)value;
                    return value;
                }
                case -7765931: {
                    this.getRelatesTo().add((CitationCitedArtifactRelatesToComponent)value);
                    return value;
                }
                case 1470639376: {
                    this.getPublicationForm().add((CitationCitedArtifactPublicationFormComponent)value);
                    return value;
                }
                case -828032215: {
                    this.getWebLocation().add((CitationCitedArtifactWebLocationComponent)value);
                    return value;
                }
                case 382350310: {
                    this.getClassification().add((CitationCitedArtifactClassificationComponent)value);
                    return value;
                }
                case 538727831: {
                    this.contributorship = (CitationCitedArtifactContributorshipComponent)value;
                    return value;
                }
                case 3387378: {
                    this.getNote().add(TypeConvertor.castToAnnotation(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Citation.SP_IDENTIFIER)) {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
            } else if (name.equals("relatedIdentifier")) {
                this.getRelatedIdentifier().add(TypeConvertor.castToIdentifier(value));
            } else if (name.equals("dateAccessed")) {
                this.dateAccessed = TypeConvertor.castToDateTime(value);
            } else if (name.equals(Citation.SP_VERSION)) {
                this.version = (CitationCitedArtifactVersionComponent)value;
            } else if (name.equals("currentState")) {
                this.getCurrentState().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("statusDate")) {
                this.getStatusDate().add((CitationCitedArtifactStatusDateComponent)value);
            } else if (name.equals(Citation.SP_TITLE)) {
                this.getTitle().add((CitationCitedArtifactTitleComponent)value);
            } else if (name.equals("abstract")) {
                this.getAbstract().add((CitationCitedArtifactAbstractComponent)value);
            } else if (name.equals("part")) {
                this.part = (CitationCitedArtifactPartComponent)value;
            } else if (name.equals("relatesTo")) {
                this.getRelatesTo().add((CitationCitedArtifactRelatesToComponent)value);
            } else if (name.equals("publicationForm")) {
                this.getPublicationForm().add((CitationCitedArtifactPublicationFormComponent)value);
            } else if (name.equals("webLocation")) {
                this.getWebLocation().add((CitationCitedArtifactWebLocationComponent)value);
            } else if (name.equals(Citation.SP_CLASSIFICATION)) {
                this.getClassification().add((CitationCitedArtifactClassificationComponent)value);
            } else if (name.equals("contributorship")) {
                this.contributorship = (CitationCitedArtifactContributorshipComponent)value;
            } else if (name.equals("note")) {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals(Citation.SP_IDENTIFIER)) {
                this.getIdentifier().remove(value);
            } else if (name.equals("relatedIdentifier")) {
                this.getRelatedIdentifier().remove(value);
            } else if (name.equals("dateAccessed")) {
                this.dateAccessed = null;
            } else if (name.equals(Citation.SP_VERSION)) {
                this.version = (CitationCitedArtifactVersionComponent)value;
            } else if (name.equals("currentState")) {
                this.getCurrentState().remove(value);
            } else if (name.equals("statusDate")) {
                this.getStatusDate().remove((CitationCitedArtifactStatusDateComponent)value);
            } else if (name.equals(Citation.SP_TITLE)) {
                this.getTitle().remove((CitationCitedArtifactTitleComponent)value);
            } else if (name.equals("abstract")) {
                this.getAbstract().remove((CitationCitedArtifactAbstractComponent)value);
            } else if (name.equals("part")) {
                this.part = (CitationCitedArtifactPartComponent)value;
            } else if (name.equals("relatesTo")) {
                this.getRelatesTo().remove((CitationCitedArtifactRelatesToComponent)value);
            } else if (name.equals("publicationForm")) {
                this.getPublicationForm().remove((CitationCitedArtifactPublicationFormComponent)value);
            } else if (name.equals("webLocation")) {
                this.getWebLocation().remove((CitationCitedArtifactWebLocationComponent)value);
            } else if (name.equals(Citation.SP_CLASSIFICATION)) {
                this.getClassification().remove((CitationCitedArtifactClassificationComponent)value);
            } else if (name.equals("contributorship")) {
                this.contributorship = (CitationCitedArtifactContributorshipComponent)value;
            } else if (name.equals("note")) {
                this.getNote().remove(value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.addIdentifier();
                }
                case -1007604940: {
                    return this.addRelatedIdentifier();
                }
                case 540917457: {
                    return this.getDateAccessedElement();
                }
                case 351608024: {
                    return this.getVersion();
                }
                case 1457822360: {
                    return this.addCurrentState();
                }
                case 247524032: {
                    return this.addStatusDate();
                }
                case 110371416: {
                    return this.addTitle();
                }
                case 1732898850: {
                    return this.addAbstract();
                }
                case 3433459: {
                    return this.getPart();
                }
                case -7765931: {
                    return this.addRelatesTo();
                }
                case 1470639376: {
                    return this.addPublicationForm();
                }
                case -828032215: {
                    return this.addWebLocation();
                }
                case 382350310: {
                    return this.addClassification();
                }
                case 538727831: {
                    return this.getContributorship();
                }
                case 3387378: {
                    return this.addNote();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case -1007604940: {
                    return new String[]{"Identifier"};
                }
                case 540917457: {
                    return new String[]{"dateTime"};
                }
                case 351608024: {
                    return new String[0];
                }
                case 1457822360: {
                    return new String[]{"CodeableConcept"};
                }
                case 247524032: {
                    return new String[0];
                }
                case 110371416: {
                    return new String[0];
                }
                case 1732898850: {
                    return new String[0];
                }
                case 3433459: {
                    return new String[0];
                }
                case -7765931: {
                    return new String[0];
                }
                case 1470639376: {
                    return new String[0];
                }
                case -828032215: {
                    return new String[0];
                }
                case 382350310: {
                    return new String[0];
                }
                case 538727831: {
                    return new String[0];
                }
                case 3387378: {
                    return new String[]{"Annotation"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Citation.SP_IDENTIFIER)) {
                return this.addIdentifier();
            }
            if (name.equals("relatedIdentifier")) {
                return this.addRelatedIdentifier();
            }
            if (name.equals("dateAccessed")) {
                throw new FHIRException("Cannot call addChild on a singleton property Citation.citedArtifact.dateAccessed");
            }
            if (name.equals(Citation.SP_VERSION)) {
                this.version = new CitationCitedArtifactVersionComponent();
                return this.version;
            }
            if (name.equals("currentState")) {
                return this.addCurrentState();
            }
            if (name.equals("statusDate")) {
                return this.addStatusDate();
            }
            if (name.equals(Citation.SP_TITLE)) {
                return this.addTitle();
            }
            if (name.equals("abstract")) {
                return this.addAbstract();
            }
            if (name.equals("part")) {
                this.part = new CitationCitedArtifactPartComponent();
                return this.part;
            }
            if (name.equals("relatesTo")) {
                return this.addRelatesTo();
            }
            if (name.equals("publicationForm")) {
                return this.addPublicationForm();
            }
            if (name.equals("webLocation")) {
                return this.addWebLocation();
            }
            if (name.equals(Citation.SP_CLASSIFICATION)) {
                return this.addClassification();
            }
            if (name.equals("contributorship")) {
                this.contributorship = new CitationCitedArtifactContributorshipComponent();
                return this.contributorship;
            }
            if (name.equals("note")) {
                return this.addNote();
            }
            return super.addChild(name);
        }

        @Override
        public CitationCitedArtifactComponent copy() {
            CitationCitedArtifactComponent dst = new CitationCitedArtifactComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationCitedArtifactComponent dst) {
            super.copyValues(dst);
            if (this.identifier != null) {
                dst.identifier = new ArrayList<Identifier>();
                for (Identifier identifier : this.identifier) {
                    dst.identifier.add(identifier.copy());
                }
            }
            if (this.relatedIdentifier != null) {
                dst.relatedIdentifier = new ArrayList<Identifier>();
                for (Identifier identifier : this.relatedIdentifier) {
                    dst.relatedIdentifier.add(identifier.copy());
                }
            }
            dst.dateAccessed = this.dateAccessed == null ? null : this.dateAccessed.copy();
            CitationCitedArtifactVersionComponent citationCitedArtifactVersionComponent = dst.version = this.version == null ? null : this.version.copy();
            if (this.currentState != null) {
                dst.currentState = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.currentState) {
                    dst.currentState.add(codeableConcept.copy());
                }
            }
            if (this.statusDate != null) {
                dst.statusDate = new ArrayList<CitationCitedArtifactStatusDateComponent>();
                for (CitationCitedArtifactStatusDateComponent citationCitedArtifactStatusDateComponent : this.statusDate) {
                    dst.statusDate.add(citationCitedArtifactStatusDateComponent.copy());
                }
            }
            if (this.title != null) {
                dst.title = new ArrayList<CitationCitedArtifactTitleComponent>();
                for (CitationCitedArtifactTitleComponent citationCitedArtifactTitleComponent : this.title) {
                    dst.title.add(citationCitedArtifactTitleComponent.copy());
                }
            }
            if (this.abstract_ != null) {
                dst.abstract_ = new ArrayList<CitationCitedArtifactAbstractComponent>();
                for (CitationCitedArtifactAbstractComponent citationCitedArtifactAbstractComponent : this.abstract_) {
                    dst.abstract_.add(citationCitedArtifactAbstractComponent.copy());
                }
            }
            CitationCitedArtifactPartComponent citationCitedArtifactPartComponent = dst.part = this.part == null ? null : this.part.copy();
            if (this.relatesTo != null) {
                dst.relatesTo = new ArrayList<CitationCitedArtifactRelatesToComponent>();
                for (CitationCitedArtifactRelatesToComponent citationCitedArtifactRelatesToComponent : this.relatesTo) {
                    dst.relatesTo.add(citationCitedArtifactRelatesToComponent.copy());
                }
            }
            if (this.publicationForm != null) {
                dst.publicationForm = new ArrayList<CitationCitedArtifactPublicationFormComponent>();
                for (CitationCitedArtifactPublicationFormComponent citationCitedArtifactPublicationFormComponent : this.publicationForm) {
                    dst.publicationForm.add(citationCitedArtifactPublicationFormComponent.copy());
                }
            }
            if (this.webLocation != null) {
                dst.webLocation = new ArrayList<CitationCitedArtifactWebLocationComponent>();
                for (CitationCitedArtifactWebLocationComponent citationCitedArtifactWebLocationComponent : this.webLocation) {
                    dst.webLocation.add(citationCitedArtifactWebLocationComponent.copy());
                }
            }
            if (this.classification != null) {
                dst.classification = new ArrayList<CitationCitedArtifactClassificationComponent>();
                for (CitationCitedArtifactClassificationComponent citationCitedArtifactClassificationComponent : this.classification) {
                    dst.classification.add(citationCitedArtifactClassificationComponent.copy());
                }
            }
            CitationCitedArtifactContributorshipComponent citationCitedArtifactContributorshipComponent = dst.contributorship = this.contributorship == null ? null : this.contributorship.copy();
            if (this.note != null) {
                dst.note = new ArrayList<Annotation>();
                for (Annotation annotation : this.note) {
                    dst.note.add(annotation.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactComponent)) {
                return false;
            }
            CitationCitedArtifactComponent o = (CitationCitedArtifactComponent)other_;
            return CitationCitedArtifactComponent.compareDeep(this.identifier, o.identifier, true) && CitationCitedArtifactComponent.compareDeep(this.relatedIdentifier, o.relatedIdentifier, true) && CitationCitedArtifactComponent.compareDeep(this.dateAccessed, o.dateAccessed, true) && CitationCitedArtifactComponent.compareDeep(this.version, o.version, true) && CitationCitedArtifactComponent.compareDeep(this.currentState, o.currentState, true) && CitationCitedArtifactComponent.compareDeep(this.statusDate, o.statusDate, true) && CitationCitedArtifactComponent.compareDeep(this.title, o.title, true) && CitationCitedArtifactComponent.compareDeep(this.abstract_, o.abstract_, true) && CitationCitedArtifactComponent.compareDeep(this.part, o.part, true) && CitationCitedArtifactComponent.compareDeep(this.relatesTo, o.relatesTo, true) && CitationCitedArtifactComponent.compareDeep(this.publicationForm, o.publicationForm, true) && CitationCitedArtifactComponent.compareDeep(this.webLocation, o.webLocation, true) && CitationCitedArtifactComponent.compareDeep(this.classification, o.classification, true) && CitationCitedArtifactComponent.compareDeep(this.contributorship, o.contributorship, true) && CitationCitedArtifactComponent.compareDeep(this.note, o.note, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationCitedArtifactComponent)) {
                return false;
            }
            CitationCitedArtifactComponent o = (CitationCitedArtifactComponent)other_;
            return CitationCitedArtifactComponent.compareValues(this.dateAccessed, o.dateAccessed, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.relatedIdentifier, this.dateAccessed, this.version, this.currentState, this.statusDate, this.title, this.abstract_, this.part, this.relatesTo, this.publicationForm, this.webLocation, this.classification, this.contributorship, this.note});
        }

        @Override
        public String fhirType() {
            return "Citation.citedArtifact";
        }
    }

    @Block
    public static class CitationStatusDateComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="activity", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Classification of the status", formalDefinition="The state or status of the citation record (that will be paired with the period).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/citation-status-type")
        protected CodeableConcept activity;
        @Child(name="actual", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Either occurred or expected", formalDefinition="Whether the status date is actual (has occurred) or expected (estimated or anticipated).")
        protected BooleanType actual;
        @Child(name="period", type={Period.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When the status started and/or ended", formalDefinition="When the status started and/or ended.")
        protected Period period;
        private static final long serialVersionUID = 1123586924L;

        public CitationStatusDateComponent() {
        }

        public CitationStatusDateComponent(CodeableConcept activity, Period period) {
            this.setActivity(activity);
            this.setPeriod(period);
        }

        public CodeableConcept getActivity() {
            if (this.activity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationStatusDateComponent.activity");
                }
                if (Configuration.doAutoCreate()) {
                    this.activity = new CodeableConcept();
                }
            }
            return this.activity;
        }

        public boolean hasActivity() {
            return this.activity != null && !this.activity.isEmpty();
        }

        public CitationStatusDateComponent setActivity(CodeableConcept value) {
            this.activity = value;
            return this;
        }

        public BooleanType getActualElement() {
            if (this.actual == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationStatusDateComponent.actual");
                }
                if (Configuration.doAutoCreate()) {
                    this.actual = new BooleanType();
                }
            }
            return this.actual;
        }

        public boolean hasActualElement() {
            return this.actual != null && !this.actual.isEmpty();
        }

        public boolean hasActual() {
            return this.actual != null && !this.actual.isEmpty();
        }

        public CitationStatusDateComponent setActualElement(BooleanType value) {
            this.actual = value;
            return this;
        }

        public boolean getActual() {
            return this.actual == null || this.actual.isEmpty() ? false : (Boolean)this.actual.getValue();
        }

        public CitationStatusDateComponent setActual(boolean value) {
            if (this.actual == null) {
                this.actual = new BooleanType();
            }
            this.actual.setValue((Object)value);
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationStatusDateComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public CitationStatusDateComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("activity", "CodeableConcept", "The state or status of the citation record (that will be paired with the period).", 0, 1, this.activity));
            children.add(new Property("actual", "boolean", "Whether the status date is actual (has occurred) or expected (estimated or anticipated).", 0, 1, this.actual));
            children.add(new Property("period", "Period", "When the status started and/or ended.", 0, 1, this.period));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1655966961: {
                    return new Property("activity", "CodeableConcept", "The state or status of the citation record (that will be paired with the period).", 0, 1, this.activity);
                }
                case -1422939762: {
                    return new Property("actual", "boolean", "Whether the status date is actual (has occurred) or expected (estimated or anticipated).", 0, 1, this.actual);
                }
                case -991726143: {
                    return new Property("period", "Period", "When the status started and/or ended.", 0, 1, this.period);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1655966961: {
                    Base[] baseArray;
                    if (this.activity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.activity;
                    }
                    return baseArray;
                }
                case -1422939762: {
                    Base[] baseArray;
                    if (this.actual == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.actual;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.period;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1655966961: {
                    this.activity = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1422939762: {
                    this.actual = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -991726143: {
                    this.period = TypeConvertor.castToPeriod(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("activity")) {
                this.activity = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("actual")) {
                this.actual = TypeConvertor.castToBoolean(value);
            } else if (name.equals("period")) {
                this.period = TypeConvertor.castToPeriod(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("activity")) {
                this.activity = null;
            } else if (name.equals("actual")) {
                this.actual = null;
            } else if (name.equals("period")) {
                this.period = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1655966961: {
                    return this.getActivity();
                }
                case -1422939762: {
                    return this.getActualElement();
                }
                case -991726143: {
                    return this.getPeriod();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1655966961: {
                    return new String[]{"CodeableConcept"};
                }
                case -1422939762: {
                    return new String[]{"boolean"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("activity")) {
                this.activity = new CodeableConcept();
                return this.activity;
            }
            if (name.equals("actual")) {
                throw new FHIRException("Cannot call addChild on a singleton property Citation.statusDate.actual");
            }
            if (name.equals("period")) {
                this.period = new Period();
                return this.period;
            }
            return super.addChild(name);
        }

        @Override
        public CitationStatusDateComponent copy() {
            CitationStatusDateComponent dst = new CitationStatusDateComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationStatusDateComponent dst) {
            super.copyValues(dst);
            dst.activity = this.activity == null ? null : this.activity.copy();
            dst.actual = this.actual == null ? null : this.actual.copy();
            dst.period = this.period == null ? null : this.period.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationStatusDateComponent)) {
                return false;
            }
            CitationStatusDateComponent o = (CitationStatusDateComponent)other_;
            return CitationStatusDateComponent.compareDeep(this.activity, o.activity, true) && CitationStatusDateComponent.compareDeep(this.actual, o.actual, true) && CitationStatusDateComponent.compareDeep(this.period, o.period, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationStatusDateComponent)) {
                return false;
            }
            CitationStatusDateComponent o = (CitationStatusDateComponent)other_;
            return CitationStatusDateComponent.compareValues(this.actual, o.actual, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.activity, this.actual, this.period});
        }

        @Override
        public String fhirType() {
            return "Citation.statusDate";
        }
    }

    @Block
    public static class CitationClassificationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The kind of classifier (e.g. publication type, keyword)", formalDefinition="The kind of classifier (e.g. publication type, keyword).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/citation-classification-type")
        protected CodeableConcept type;
        @Child(name="classifier", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The specific classification value", formalDefinition="The specific classification value.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/citation-artifact-classifier")
        protected List<CodeableConcept> classifier;
        private static final long serialVersionUID = -283121869L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationClassificationComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public CitationClassificationComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public List<CodeableConcept> getClassifier() {
            if (this.classifier == null) {
                this.classifier = new ArrayList<CodeableConcept>();
            }
            return this.classifier;
        }

        public CitationClassificationComponent setClassifier(List<CodeableConcept> theClassifier) {
            this.classifier = theClassifier;
            return this;
        }

        public boolean hasClassifier() {
            if (this.classifier == null) {
                return false;
            }
            for (CodeableConcept item : this.classifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addClassifier() {
            CodeableConcept t = new CodeableConcept();
            if (this.classifier == null) {
                this.classifier = new ArrayList<CodeableConcept>();
            }
            this.classifier.add(t);
            return t;
        }

        public CitationClassificationComponent addClassifier(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.classifier == null) {
                this.classifier = new ArrayList<CodeableConcept>();
            }
            this.classifier.add(t);
            return this;
        }

        public CodeableConcept getClassifierFirstRep() {
            if (this.getClassifier().isEmpty()) {
                this.addClassifier();
            }
            return this.getClassifier().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "The kind of classifier (e.g. publication type, keyword).", 0, 1, this.type));
            children.add(new Property(Citation.SP_CLASSIFIER, "CodeableConcept", "The specific classification value.", 0, Integer.MAX_VALUE, this.classifier));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The kind of classifier (e.g. publication type, keyword).", 0, 1, this.type);
                }
                case -281470431: {
                    return new Property(Citation.SP_CLASSIFIER, "CodeableConcept", "The specific classification value.", 0, Integer.MAX_VALUE, this.classifier);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -281470431: {
                    return this.classifier == null ? new Base[]{} : this.classifier.toArray(new Base[this.classifier.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -281470431: {
                    this.getClassifier().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals(Citation.SP_CLASSIFIER)) {
                this.getClassifier().add(TypeConvertor.castToCodeableConcept(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = null;
            } else if (name.equals(Citation.SP_CLASSIFIER)) {
                this.getClassifier().remove(value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -281470431: {
                    return this.addClassifier();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -281470431: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals(Citation.SP_CLASSIFIER)) {
                return this.addClassifier();
            }
            return super.addChild(name);
        }

        @Override
        public CitationClassificationComponent copy() {
            CitationClassificationComponent dst = new CitationClassificationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationClassificationComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
            if (this.classifier != null) {
                dst.classifier = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.classifier) {
                    dst.classifier.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationClassificationComponent)) {
                return false;
            }
            CitationClassificationComponent o = (CitationClassificationComponent)other_;
            return CitationClassificationComponent.compareDeep(this.type, o.type, true) && CitationClassificationComponent.compareDeep(this.classifier, o.classifier, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationClassificationComponent)) {
                return false;
            }
            CitationClassificationComponent o = (CitationClassificationComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.classifier});
        }

        @Override
        public String fhirType() {
            return "Citation.classification";
        }
    }

    @Block
    public static class CitationSummaryComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="style", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Format for display of the citation summary", formalDefinition="Format for display of the citation summary.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/citation-summary-style")
        protected CodeableConcept style;
        @Child(name="text", type={MarkdownType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The human-readable display of the citation summary", formalDefinition="The human-readable display of the citation summary.")
        protected MarkdownType text;
        private static final long serialVersionUID = 123416446L;

        public CitationSummaryComponent() {
        }

        public CitationSummaryComponent(String text) {
            this.setText(text);
        }

        public CodeableConcept getStyle() {
            if (this.style == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationSummaryComponent.style");
                }
                if (Configuration.doAutoCreate()) {
                    this.style = new CodeableConcept();
                }
            }
            return this.style;
        }

        public boolean hasStyle() {
            return this.style != null && !this.style.isEmpty();
        }

        public CitationSummaryComponent setStyle(CodeableConcept value) {
            this.style = value;
            return this;
        }

        public MarkdownType getTextElement() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationSummaryComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new MarkdownType();
                }
            }
            return this.text;
        }

        public boolean hasTextElement() {
            return this.text != null && !this.text.isEmpty();
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public CitationSummaryComponent setTextElement(MarkdownType value) {
            this.text = value;
            return this;
        }

        public String getText() {
            return this.text == null ? null : (String)this.text.getValue();
        }

        public CitationSummaryComponent setText(String value) {
            if (this.text == null) {
                this.text = new MarkdownType();
            }
            this.text.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("style", "CodeableConcept", "Format for display of the citation summary.", 0, 1, this.style));
            children.add(new Property("text", "markdown", "The human-readable display of the citation summary.", 0, 1, this.text));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 109780401: {
                    return new Property("style", "CodeableConcept", "Format for display of the citation summary.", 0, 1, this.style);
                }
                case 3556653: {
                    return new Property("text", "markdown", "The human-readable display of the citation summary.", 0, 1, this.text);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 109780401: {
                    Base[] baseArray;
                    if (this.style == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.style;
                    }
                    return baseArray;
                }
                case 3556653: {
                    Base[] baseArray;
                    if (this.text == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.text;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 109780401: {
                    this.style = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 3556653: {
                    this.text = TypeConvertor.castToMarkdown(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("style")) {
                this.style = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("text")) {
                this.text = TypeConvertor.castToMarkdown(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("style")) {
                this.style = null;
            } else if (name.equals("text")) {
                this.text = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 109780401: {
                    return this.getStyle();
                }
                case 3556653: {
                    return this.getTextElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 109780401: {
                    return new String[]{"CodeableConcept"};
                }
                case 3556653: {
                    return new String[]{"markdown"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("style")) {
                this.style = new CodeableConcept();
                return this.style;
            }
            if (name.equals("text")) {
                throw new FHIRException("Cannot call addChild on a singleton property Citation.summary.text");
            }
            return super.addChild(name);
        }

        @Override
        public CitationSummaryComponent copy() {
            CitationSummaryComponent dst = new CitationSummaryComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationSummaryComponent dst) {
            super.copyValues(dst);
            dst.style = this.style == null ? null : this.style.copy();
            dst.text = this.text == null ? null : this.text.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationSummaryComponent)) {
                return false;
            }
            CitationSummaryComponent o = (CitationSummaryComponent)other_;
            return CitationSummaryComponent.compareDeep(this.style, o.style, true) && CitationSummaryComponent.compareDeep(this.text, o.text, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationSummaryComponent)) {
                return false;
            }
            CitationSummaryComponent o = (CitationSummaryComponent)other_;
            return CitationSummaryComponent.compareValues(this.text, o.text, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.style, this.text});
        }

        @Override
        public String fhirType() {
            return "Citation.summary";
        }
    }

    public static class RelatedArtifactTypeExpandedEnumFactory
    implements EnumFactory<RelatedArtifactTypeExpanded> {
        @Override
        public RelatedArtifactTypeExpanded fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("documentation".equals(codeString)) {
                return RelatedArtifactTypeExpanded.DOCUMENTATION;
            }
            if ("justification".equals(codeString)) {
                return RelatedArtifactTypeExpanded.JUSTIFICATION;
            }
            if ("citation".equals(codeString)) {
                return RelatedArtifactTypeExpanded.CITATION;
            }
            if ("predecessor".equals(codeString)) {
                return RelatedArtifactTypeExpanded.PREDECESSOR;
            }
            if ("successor".equals(codeString)) {
                return RelatedArtifactTypeExpanded.SUCCESSOR;
            }
            if ("derived-from".equals(codeString)) {
                return RelatedArtifactTypeExpanded.DERIVEDFROM;
            }
            if ("depends-on".equals(codeString)) {
                return RelatedArtifactTypeExpanded.DEPENDSON;
            }
            if ("composed-of".equals(codeString)) {
                return RelatedArtifactTypeExpanded.COMPOSEDOF;
            }
            if ("part-of".equals(codeString)) {
                return RelatedArtifactTypeExpanded.PARTOF;
            }
            if ("amends".equals(codeString)) {
                return RelatedArtifactTypeExpanded.AMENDS;
            }
            if ("amended-with".equals(codeString)) {
                return RelatedArtifactTypeExpanded.AMENDEDWITH;
            }
            if ("appends".equals(codeString)) {
                return RelatedArtifactTypeExpanded.APPENDS;
            }
            if ("appended-with".equals(codeString)) {
                return RelatedArtifactTypeExpanded.APPENDEDWITH;
            }
            if ("cites".equals(codeString)) {
                return RelatedArtifactTypeExpanded.CITES;
            }
            if ("cited-by".equals(codeString)) {
                return RelatedArtifactTypeExpanded.CITEDBY;
            }
            if ("comments-on".equals(codeString)) {
                return RelatedArtifactTypeExpanded.COMMENTSON;
            }
            if ("comment-in".equals(codeString)) {
                return RelatedArtifactTypeExpanded.COMMENTIN;
            }
            if ("contains".equals(codeString)) {
                return RelatedArtifactTypeExpanded.CONTAINS;
            }
            if ("contained-in".equals(codeString)) {
                return RelatedArtifactTypeExpanded.CONTAINEDIN;
            }
            if ("corrects".equals(codeString)) {
                return RelatedArtifactTypeExpanded.CORRECTS;
            }
            if ("correction-in".equals(codeString)) {
                return RelatedArtifactTypeExpanded.CORRECTIONIN;
            }
            if ("replaces".equals(codeString)) {
                return RelatedArtifactTypeExpanded.REPLACES;
            }
            if ("replaced-with".equals(codeString)) {
                return RelatedArtifactTypeExpanded.REPLACEDWITH;
            }
            if ("retracts".equals(codeString)) {
                return RelatedArtifactTypeExpanded.RETRACTS;
            }
            if ("retracted-by".equals(codeString)) {
                return RelatedArtifactTypeExpanded.RETRACTEDBY;
            }
            if ("signs".equals(codeString)) {
                return RelatedArtifactTypeExpanded.SIGNS;
            }
            if ("similar-to".equals(codeString)) {
                return RelatedArtifactTypeExpanded.SIMILARTO;
            }
            if ("supports".equals(codeString)) {
                return RelatedArtifactTypeExpanded.SUPPORTS;
            }
            if ("supported-with".equals(codeString)) {
                return RelatedArtifactTypeExpanded.SUPPORTEDWITH;
            }
            if ("transforms".equals(codeString)) {
                return RelatedArtifactTypeExpanded.TRANSFORMS;
            }
            if ("transformed-into".equals(codeString)) {
                return RelatedArtifactTypeExpanded.TRANSFORMEDINTO;
            }
            if ("transformed-with".equals(codeString)) {
                return RelatedArtifactTypeExpanded.TRANSFORMEDWITH;
            }
            if ("documents".equals(codeString)) {
                return RelatedArtifactTypeExpanded.DOCUMENTS;
            }
            if ("specification-of".equals(codeString)) {
                return RelatedArtifactTypeExpanded.SPECIFICATIONOF;
            }
            if ("created-with".equals(codeString)) {
                return RelatedArtifactTypeExpanded.CREATEDWITH;
            }
            if ("cite-as".equals(codeString)) {
                return RelatedArtifactTypeExpanded.CITEAS;
            }
            if ("reprint".equals(codeString)) {
                return RelatedArtifactTypeExpanded.REPRINT;
            }
            if ("reprint-of".equals(codeString)) {
                return RelatedArtifactTypeExpanded.REPRINTOF;
            }
            throw new IllegalArgumentException("Unknown RelatedArtifactTypeExpanded code '" + codeString + "'");
        }

        public Enumeration<RelatedArtifactTypeExpanded> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<RelatedArtifactTypeExpanded>(this, RelatedArtifactTypeExpanded.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<RelatedArtifactTypeExpanded>(this, RelatedArtifactTypeExpanded.NULL, code);
            }
            if ("documentation".equals(codeString)) {
                return new Enumeration<RelatedArtifactTypeExpanded>(this, RelatedArtifactTypeExpanded.DOCUMENTATION, code);
            }
            if ("justification".equals(codeString)) {
                return new Enumeration<RelatedArtifactTypeExpanded>(this, RelatedArtifactTypeExpanded.JUSTIFICATION, code);
            }
            if ("citation".equals(codeString)) {
                return new Enumeration<RelatedArtifactTypeExpanded>(this, RelatedArtifactTypeExpanded.CITATION, code);
            }
            if ("predecessor".equals(codeString)) {
                return new Enumeration<RelatedArtifactTypeExpanded>(this, RelatedArtifactTypeExpanded.PREDECESSOR, code);
            }
            if ("successor".equals(codeString)) {
                return new Enumeration<RelatedArtifactTypeExpanded>(this, RelatedArtifactTypeExpanded.SUCCESSOR, code);
            }
            if ("derived-from".equals(codeString)) {
                return new Enumeration<RelatedArtifactTypeExpanded>(this, RelatedArtifactTypeExpanded.DERIVEDFROM, code);
            }
            if ("depends-on".equals(codeString)) {
                return new Enumeration<RelatedArtifactTypeExpanded>(this, RelatedArtifactTypeExpanded.DEPENDSON, code);
            }
            if ("composed-of".equals(codeString)) {
                return new Enumeration<RelatedArtifactTypeExpanded>(this, RelatedArtifactTypeExpanded.COMPOSEDOF, code);
            }
            if ("part-of".equals(codeString)) {
                return new Enumeration<RelatedArtifactTypeExpanded>(this, RelatedArtifactTypeExpanded.PARTOF, code);
            }
            if ("amends".equals(codeString)) {
                return new Enumeration<RelatedArtifactTypeExpanded>(this, RelatedArtifactTypeExpanded.AMENDS, code);
            }
            if ("amended-with".equals(codeString)) {
                return new Enumeration<RelatedArtifactTypeExpanded>(this, RelatedArtifactTypeExpanded.AMENDEDWITH, code);
            }
            if ("appends".equals(codeString)) {
                return new Enumeration<RelatedArtifactTypeExpanded>(this, RelatedArtifactTypeExpanded.APPENDS, code);
            }
            if ("appended-with".equals(codeString)) {
                return new Enumeration<RelatedArtifactTypeExpanded>(this, RelatedArtifactTypeExpanded.APPENDEDWITH, code);
            }
            if ("cites".equals(codeString)) {
                return new Enumeration<RelatedArtifactTypeExpanded>(this, RelatedArtifactTypeExpanded.CITES, code);
            }
            if ("cited-by".equals(codeString)) {
                return new Enumeration<RelatedArtifactTypeExpanded>(this, RelatedArtifactTypeExpanded.CITEDBY, code);
            }
            if ("comments-on".equals(codeString)) {
                return new Enumeration<RelatedArtifactTypeExpanded>(this, RelatedArtifactTypeExpanded.COMMENTSON, code);
            }
            if ("comment-in".equals(codeString)) {
                return new Enumeration<RelatedArtifactTypeExpanded>(this, RelatedArtifactTypeExpanded.COMMENTIN, code);
            }
            if ("contains".equals(codeString)) {
                return new Enumeration<RelatedArtifactTypeExpanded>(this, RelatedArtifactTypeExpanded.CONTAINS, code);
            }
            if ("contained-in".equals(codeString)) {
                return new Enumeration<RelatedArtifactTypeExpanded>(this, RelatedArtifactTypeExpanded.CONTAINEDIN, code);
            }
            if ("corrects".equals(codeString)) {
                return new Enumeration<RelatedArtifactTypeExpanded>(this, RelatedArtifactTypeExpanded.CORRECTS, code);
            }
            if ("correction-in".equals(codeString)) {
                return new Enumeration<RelatedArtifactTypeExpanded>(this, RelatedArtifactTypeExpanded.CORRECTIONIN, code);
            }
            if ("replaces".equals(codeString)) {
                return new Enumeration<RelatedArtifactTypeExpanded>(this, RelatedArtifactTypeExpanded.REPLACES, code);
            }
            if ("replaced-with".equals(codeString)) {
                return new Enumeration<RelatedArtifactTypeExpanded>(this, RelatedArtifactTypeExpanded.REPLACEDWITH, code);
            }
            if ("retracts".equals(codeString)) {
                return new Enumeration<RelatedArtifactTypeExpanded>(this, RelatedArtifactTypeExpanded.RETRACTS, code);
            }
            if ("retracted-by".equals(codeString)) {
                return new Enumeration<RelatedArtifactTypeExpanded>(this, RelatedArtifactTypeExpanded.RETRACTEDBY, code);
            }
            if ("signs".equals(codeString)) {
                return new Enumeration<RelatedArtifactTypeExpanded>(this, RelatedArtifactTypeExpanded.SIGNS, code);
            }
            if ("similar-to".equals(codeString)) {
                return new Enumeration<RelatedArtifactTypeExpanded>(this, RelatedArtifactTypeExpanded.SIMILARTO, code);
            }
            if ("supports".equals(codeString)) {
                return new Enumeration<RelatedArtifactTypeExpanded>(this, RelatedArtifactTypeExpanded.SUPPORTS, code);
            }
            if ("supported-with".equals(codeString)) {
                return new Enumeration<RelatedArtifactTypeExpanded>(this, RelatedArtifactTypeExpanded.SUPPORTEDWITH, code);
            }
            if ("transforms".equals(codeString)) {
                return new Enumeration<RelatedArtifactTypeExpanded>(this, RelatedArtifactTypeExpanded.TRANSFORMS, code);
            }
            if ("transformed-into".equals(codeString)) {
                return new Enumeration<RelatedArtifactTypeExpanded>(this, RelatedArtifactTypeExpanded.TRANSFORMEDINTO, code);
            }
            if ("transformed-with".equals(codeString)) {
                return new Enumeration<RelatedArtifactTypeExpanded>(this, RelatedArtifactTypeExpanded.TRANSFORMEDWITH, code);
            }
            if ("documents".equals(codeString)) {
                return new Enumeration<RelatedArtifactTypeExpanded>(this, RelatedArtifactTypeExpanded.DOCUMENTS, code);
            }
            if ("specification-of".equals(codeString)) {
                return new Enumeration<RelatedArtifactTypeExpanded>(this, RelatedArtifactTypeExpanded.SPECIFICATIONOF, code);
            }
            if ("created-with".equals(codeString)) {
                return new Enumeration<RelatedArtifactTypeExpanded>(this, RelatedArtifactTypeExpanded.CREATEDWITH, code);
            }
            if ("cite-as".equals(codeString)) {
                return new Enumeration<RelatedArtifactTypeExpanded>(this, RelatedArtifactTypeExpanded.CITEAS, code);
            }
            if ("reprint".equals(codeString)) {
                return new Enumeration<RelatedArtifactTypeExpanded>(this, RelatedArtifactTypeExpanded.REPRINT, code);
            }
            if ("reprint-of".equals(codeString)) {
                return new Enumeration<RelatedArtifactTypeExpanded>(this, RelatedArtifactTypeExpanded.REPRINTOF, code);
            }
            throw new FHIRException("Unknown RelatedArtifactTypeExpanded code '" + codeString + "'");
        }

        @Override
        public String toCode(RelatedArtifactTypeExpanded code) {
            if (code == RelatedArtifactTypeExpanded.DOCUMENTATION) {
                return "documentation";
            }
            if (code == RelatedArtifactTypeExpanded.JUSTIFICATION) {
                return "justification";
            }
            if (code == RelatedArtifactTypeExpanded.CITATION) {
                return "citation";
            }
            if (code == RelatedArtifactTypeExpanded.PREDECESSOR) {
                return "predecessor";
            }
            if (code == RelatedArtifactTypeExpanded.SUCCESSOR) {
                return "successor";
            }
            if (code == RelatedArtifactTypeExpanded.DERIVEDFROM) {
                return "derived-from";
            }
            if (code == RelatedArtifactTypeExpanded.DEPENDSON) {
                return "depends-on";
            }
            if (code == RelatedArtifactTypeExpanded.COMPOSEDOF) {
                return "composed-of";
            }
            if (code == RelatedArtifactTypeExpanded.PARTOF) {
                return "part-of";
            }
            if (code == RelatedArtifactTypeExpanded.AMENDS) {
                return "amends";
            }
            if (code == RelatedArtifactTypeExpanded.AMENDEDWITH) {
                return "amended-with";
            }
            if (code == RelatedArtifactTypeExpanded.APPENDS) {
                return "appends";
            }
            if (code == RelatedArtifactTypeExpanded.APPENDEDWITH) {
                return "appended-with";
            }
            if (code == RelatedArtifactTypeExpanded.CITES) {
                return "cites";
            }
            if (code == RelatedArtifactTypeExpanded.CITEDBY) {
                return "cited-by";
            }
            if (code == RelatedArtifactTypeExpanded.COMMENTSON) {
                return "comments-on";
            }
            if (code == RelatedArtifactTypeExpanded.COMMENTIN) {
                return "comment-in";
            }
            if (code == RelatedArtifactTypeExpanded.CONTAINS) {
                return "contains";
            }
            if (code == RelatedArtifactTypeExpanded.CONTAINEDIN) {
                return "contained-in";
            }
            if (code == RelatedArtifactTypeExpanded.CORRECTS) {
                return "corrects";
            }
            if (code == RelatedArtifactTypeExpanded.CORRECTIONIN) {
                return "correction-in";
            }
            if (code == RelatedArtifactTypeExpanded.REPLACES) {
                return "replaces";
            }
            if (code == RelatedArtifactTypeExpanded.REPLACEDWITH) {
                return "replaced-with";
            }
            if (code == RelatedArtifactTypeExpanded.RETRACTS) {
                return "retracts";
            }
            if (code == RelatedArtifactTypeExpanded.RETRACTEDBY) {
                return "retracted-by";
            }
            if (code == RelatedArtifactTypeExpanded.SIGNS) {
                return "signs";
            }
            if (code == RelatedArtifactTypeExpanded.SIMILARTO) {
                return "similar-to";
            }
            if (code == RelatedArtifactTypeExpanded.SUPPORTS) {
                return "supports";
            }
            if (code == RelatedArtifactTypeExpanded.SUPPORTEDWITH) {
                return "supported-with";
            }
            if (code == RelatedArtifactTypeExpanded.TRANSFORMS) {
                return "transforms";
            }
            if (code == RelatedArtifactTypeExpanded.TRANSFORMEDINTO) {
                return "transformed-into";
            }
            if (code == RelatedArtifactTypeExpanded.TRANSFORMEDWITH) {
                return "transformed-with";
            }
            if (code == RelatedArtifactTypeExpanded.DOCUMENTS) {
                return "documents";
            }
            if (code == RelatedArtifactTypeExpanded.SPECIFICATIONOF) {
                return "specification-of";
            }
            if (code == RelatedArtifactTypeExpanded.CREATEDWITH) {
                return "created-with";
            }
            if (code == RelatedArtifactTypeExpanded.CITEAS) {
                return "cite-as";
            }
            if (code == RelatedArtifactTypeExpanded.REPRINT) {
                return "reprint";
            }
            if (code == RelatedArtifactTypeExpanded.REPRINTOF) {
                return "reprint-of";
            }
            return "?";
        }

        @Override
        public String toSystem(RelatedArtifactTypeExpanded code) {
            return code.getSystem();
        }
    }

    public static enum RelatedArtifactTypeExpanded {
        DOCUMENTATION,
        JUSTIFICATION,
        CITATION,
        PREDECESSOR,
        SUCCESSOR,
        DERIVEDFROM,
        DEPENDSON,
        COMPOSEDOF,
        PARTOF,
        AMENDS,
        AMENDEDWITH,
        APPENDS,
        APPENDEDWITH,
        CITES,
        CITEDBY,
        COMMENTSON,
        COMMENTIN,
        CONTAINS,
        CONTAINEDIN,
        CORRECTS,
        CORRECTIONIN,
        REPLACES,
        REPLACEDWITH,
        RETRACTS,
        RETRACTEDBY,
        SIGNS,
        SIMILARTO,
        SUPPORTS,
        SUPPORTEDWITH,
        TRANSFORMS,
        TRANSFORMEDINTO,
        TRANSFORMEDWITH,
        DOCUMENTS,
        SPECIFICATIONOF,
        CREATEDWITH,
        CITEAS,
        REPRINT,
        REPRINTOF,
        NULL;


        public static RelatedArtifactTypeExpanded fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("documentation".equals(codeString)) {
                return DOCUMENTATION;
            }
            if ("justification".equals(codeString)) {
                return JUSTIFICATION;
            }
            if ("citation".equals(codeString)) {
                return CITATION;
            }
            if ("predecessor".equals(codeString)) {
                return PREDECESSOR;
            }
            if ("successor".equals(codeString)) {
                return SUCCESSOR;
            }
            if ("derived-from".equals(codeString)) {
                return DERIVEDFROM;
            }
            if ("depends-on".equals(codeString)) {
                return DEPENDSON;
            }
            if ("composed-of".equals(codeString)) {
                return COMPOSEDOF;
            }
            if ("part-of".equals(codeString)) {
                return PARTOF;
            }
            if ("amends".equals(codeString)) {
                return AMENDS;
            }
            if ("amended-with".equals(codeString)) {
                return AMENDEDWITH;
            }
            if ("appends".equals(codeString)) {
                return APPENDS;
            }
            if ("appended-with".equals(codeString)) {
                return APPENDEDWITH;
            }
            if ("cites".equals(codeString)) {
                return CITES;
            }
            if ("cited-by".equals(codeString)) {
                return CITEDBY;
            }
            if ("comments-on".equals(codeString)) {
                return COMMENTSON;
            }
            if ("comment-in".equals(codeString)) {
                return COMMENTIN;
            }
            if ("contains".equals(codeString)) {
                return CONTAINS;
            }
            if ("contained-in".equals(codeString)) {
                return CONTAINEDIN;
            }
            if ("corrects".equals(codeString)) {
                return CORRECTS;
            }
            if ("correction-in".equals(codeString)) {
                return CORRECTIONIN;
            }
            if ("replaces".equals(codeString)) {
                return REPLACES;
            }
            if ("replaced-with".equals(codeString)) {
                return REPLACEDWITH;
            }
            if ("retracts".equals(codeString)) {
                return RETRACTS;
            }
            if ("retracted-by".equals(codeString)) {
                return RETRACTEDBY;
            }
            if ("signs".equals(codeString)) {
                return SIGNS;
            }
            if ("similar-to".equals(codeString)) {
                return SIMILARTO;
            }
            if ("supports".equals(codeString)) {
                return SUPPORTS;
            }
            if ("supported-with".equals(codeString)) {
                return SUPPORTEDWITH;
            }
            if ("transforms".equals(codeString)) {
                return TRANSFORMS;
            }
            if ("transformed-into".equals(codeString)) {
                return TRANSFORMEDINTO;
            }
            if ("transformed-with".equals(codeString)) {
                return TRANSFORMEDWITH;
            }
            if ("documents".equals(codeString)) {
                return DOCUMENTS;
            }
            if ("specification-of".equals(codeString)) {
                return SPECIFICATIONOF;
            }
            if ("created-with".equals(codeString)) {
                return CREATEDWITH;
            }
            if ("cite-as".equals(codeString)) {
                return CITEAS;
            }
            if ("reprint".equals(codeString)) {
                return REPRINT;
            }
            if ("reprint-of".equals(codeString)) {
                return REPRINTOF;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown RelatedArtifactTypeExpanded code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DOCUMENTATION: {
                    return "documentation";
                }
                case JUSTIFICATION: {
                    return "justification";
                }
                case CITATION: {
                    return "citation";
                }
                case PREDECESSOR: {
                    return "predecessor";
                }
                case SUCCESSOR: {
                    return "successor";
                }
                case DERIVEDFROM: {
                    return "derived-from";
                }
                case DEPENDSON: {
                    return "depends-on";
                }
                case COMPOSEDOF: {
                    return "composed-of";
                }
                case PARTOF: {
                    return "part-of";
                }
                case AMENDS: {
                    return "amends";
                }
                case AMENDEDWITH: {
                    return "amended-with";
                }
                case APPENDS: {
                    return "appends";
                }
                case APPENDEDWITH: {
                    return "appended-with";
                }
                case CITES: {
                    return "cites";
                }
                case CITEDBY: {
                    return "cited-by";
                }
                case COMMENTSON: {
                    return "comments-on";
                }
                case COMMENTIN: {
                    return "comment-in";
                }
                case CONTAINS: {
                    return "contains";
                }
                case CONTAINEDIN: {
                    return "contained-in";
                }
                case CORRECTS: {
                    return "corrects";
                }
                case CORRECTIONIN: {
                    return "correction-in";
                }
                case REPLACES: {
                    return "replaces";
                }
                case REPLACEDWITH: {
                    return "replaced-with";
                }
                case RETRACTS: {
                    return "retracts";
                }
                case RETRACTEDBY: {
                    return "retracted-by";
                }
                case SIGNS: {
                    return "signs";
                }
                case SIMILARTO: {
                    return "similar-to";
                }
                case SUPPORTS: {
                    return "supports";
                }
                case SUPPORTEDWITH: {
                    return "supported-with";
                }
                case TRANSFORMS: {
                    return "transforms";
                }
                case TRANSFORMEDINTO: {
                    return "transformed-into";
                }
                case TRANSFORMEDWITH: {
                    return "transformed-with";
                }
                case DOCUMENTS: {
                    return "documents";
                }
                case SPECIFICATIONOF: {
                    return "specification-of";
                }
                case CREATEDWITH: {
                    return "created-with";
                }
                case CITEAS: {
                    return "cite-as";
                }
                case REPRINT: {
                    return "reprint";
                }
                case REPRINTOF: {
                    return "reprint-of";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DOCUMENTATION: {
                    return "http://hl7.org/fhir/related-artifact-type";
                }
                case JUSTIFICATION: {
                    return "http://hl7.org/fhir/related-artifact-type";
                }
                case CITATION: {
                    return "http://hl7.org/fhir/related-artifact-type";
                }
                case PREDECESSOR: {
                    return "http://hl7.org/fhir/related-artifact-type";
                }
                case SUCCESSOR: {
                    return "http://hl7.org/fhir/related-artifact-type";
                }
                case DERIVEDFROM: {
                    return "http://hl7.org/fhir/related-artifact-type";
                }
                case DEPENDSON: {
                    return "http://hl7.org/fhir/related-artifact-type";
                }
                case COMPOSEDOF: {
                    return "http://hl7.org/fhir/related-artifact-type";
                }
                case PARTOF: {
                    return "http://hl7.org/fhir/related-artifact-type";
                }
                case AMENDS: {
                    return "http://hl7.org/fhir/related-artifact-type";
                }
                case AMENDEDWITH: {
                    return "http://hl7.org/fhir/related-artifact-type";
                }
                case APPENDS: {
                    return "http://hl7.org/fhir/related-artifact-type";
                }
                case APPENDEDWITH: {
                    return "http://hl7.org/fhir/related-artifact-type";
                }
                case CITES: {
                    return "http://hl7.org/fhir/related-artifact-type";
                }
                case CITEDBY: {
                    return "http://hl7.org/fhir/related-artifact-type";
                }
                case COMMENTSON: {
                    return "http://hl7.org/fhir/related-artifact-type";
                }
                case COMMENTIN: {
                    return "http://hl7.org/fhir/related-artifact-type";
                }
                case CONTAINS: {
                    return "http://hl7.org/fhir/related-artifact-type";
                }
                case CONTAINEDIN: {
                    return "http://hl7.org/fhir/related-artifact-type";
                }
                case CORRECTS: {
                    return "http://hl7.org/fhir/related-artifact-type";
                }
                case CORRECTIONIN: {
                    return "http://hl7.org/fhir/related-artifact-type";
                }
                case REPLACES: {
                    return "http://hl7.org/fhir/related-artifact-type";
                }
                case REPLACEDWITH: {
                    return "http://hl7.org/fhir/related-artifact-type";
                }
                case RETRACTS: {
                    return "http://hl7.org/fhir/related-artifact-type";
                }
                case RETRACTEDBY: {
                    return "http://hl7.org/fhir/related-artifact-type";
                }
                case SIGNS: {
                    return "http://hl7.org/fhir/related-artifact-type";
                }
                case SIMILARTO: {
                    return "http://hl7.org/fhir/related-artifact-type";
                }
                case SUPPORTS: {
                    return "http://hl7.org/fhir/related-artifact-type";
                }
                case SUPPORTEDWITH: {
                    return "http://hl7.org/fhir/related-artifact-type";
                }
                case TRANSFORMS: {
                    return "http://hl7.org/fhir/related-artifact-type";
                }
                case TRANSFORMEDINTO: {
                    return "http://hl7.org/fhir/related-artifact-type";
                }
                case TRANSFORMEDWITH: {
                    return "http://hl7.org/fhir/related-artifact-type";
                }
                case DOCUMENTS: {
                    return "http://hl7.org/fhir/related-artifact-type";
                }
                case SPECIFICATIONOF: {
                    return "http://hl7.org/fhir/related-artifact-type";
                }
                case CREATEDWITH: {
                    return "http://hl7.org/fhir/related-artifact-type";
                }
                case CITEAS: {
                    return "http://hl7.org/fhir/related-artifact-type";
                }
                case REPRINT: {
                    return "http://hl7.org/fhir/related-artifact-type-expanded";
                }
                case REPRINTOF: {
                    return "http://hl7.org/fhir/related-artifact-type-expanded";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DOCUMENTATION: {
                    return "Additional documentation for the knowledge resource. This would include additional instructions on usage as well as additional information on clinical context or appropriateness.";
                }
                case JUSTIFICATION: {
                    return "The target artifact is a summary of the justification for the knowledge resource including supporting evidence, relevant guidelines, or other clinically important information. This information is intended to provide a way to make the justification for the knowledge resource available to the consumer of interventions or results produced by the knowledge resource.";
                }
                case CITATION: {
                    return "Bibliographic citation for papers, references, or other relevant material for the knowledge resource. This is intended to allow for citation of related material, but that was not necessarily specifically prepared in connection with this knowledge resource.";
                }
                case PREDECESSOR: {
                    return "The previous version of the knowledge artifact, used to establish an ordering of versions of an artifact, independent of the status of each version.";
                }
                case SUCCESSOR: {
                    return "The subsequent version of the knowledge artfact, used to establish an ordering of versions of an artifact, independent of the status of each version.";
                }
                case DERIVEDFROM: {
                    return "This artifact is derived from the target artifact. This is intended to capture the relationship in which a particular knowledge resource is based on the content of another artifact, but is modified to capture either a different set of overall requirements, or a more specific set of requirements such as those involved in a particular institution or clinical setting. The artifact may be derived from one or more target artifacts.";
                }
                case DEPENDSON: {
                    return "This artifact depends on the target artifact. There is a requirement to use the target artifact in the creation or interpretation of this artifact.";
                }
                case COMPOSEDOF: {
                    return "This artifact is composed of the target artifact. This artifact is constructed with the target artifact as a component. The target artifact is a part of this artifact. (A dataset is composed of data.).";
                }
                case PARTOF: {
                    return "This artifact is a part of the target artifact. The target artifact is composed of this artifact (and possibly other artifacts).";
                }
                case AMENDS: {
                    return "This artifact amends or changes the target artifact. This artifact adds additional information that is functionally expected to replace information in the target artifact. This artifact replaces a part but not all of the target artifact.";
                }
                case AMENDEDWITH: {
                    return "This artifact is amended with or changed by the target artifact. There is information in this artifact that should be functionally replaced with information in the target artifact.";
                }
                case APPENDS: {
                    return "This artifact adds additional information to the target artifact. The additional information does not replace or change information in the target artifact.";
                }
                case APPENDEDWITH: {
                    return "This artifact has additional information in the target artifact.";
                }
                case CITES: {
                    return "This artifact cites the target artifact. This may be a bibliographic citation for papers, references, or other relevant material for the knowledge resource. This is intended to allow for citation of related material, but that was not necessarily specifically prepared in connection with this knowledge resource.";
                }
                case CITEDBY: {
                    return "This artifact is cited by the target artifact.";
                }
                case COMMENTSON: {
                    return "This artifact contains comments about the target artifact.";
                }
                case COMMENTIN: {
                    return "This artifact has comments about it in the target artifact.  The type of comments may be expressed in the targetClassifier element such as reply, review, editorial, feedback, solicited, unsolicited, structured, unstructured.";
                }
                case CONTAINS: {
                    return "This artifact is a container in which the target artifact is contained. A container is a data structure whose instances are collections of other objects. (A database contains the dataset.).";
                }
                case CONTAINEDIN: {
                    return "This artifact is contained in the target artifact. The target artifact is a data structure whose instances are collections of other objects.";
                }
                case CORRECTS: {
                    return "This artifact identifies errors and replacement content for the target artifact.";
                }
                case CORRECTIONIN: {
                    return "This artifact has corrections to it in the target artifact. The target artifact identifies errors and replacement content for this artifact.";
                }
                case REPLACES: {
                    return "This artifact replaces or supersedes the target artifact. The target artifact may be considered deprecated.";
                }
                case REPLACEDWITH: {
                    return "This artifact is replaced with or superseded by the target artifact. This artifact may be considered deprecated.";
                }
                case RETRACTS: {
                    return "This artifact retracts the target artifact. The content that was published in the target artifact should be considered removed from publication and should no longer be considered part of the public record.";
                }
                case RETRACTEDBY: {
                    return "This artifact is retracted by the target artifact. The content that was published in this artifact should be considered removed from publication and should no longer be considered part of the public record.";
                }
                case SIGNS: {
                    return "This artifact is a signature of the target artifact.";
                }
                case SIMILARTO: {
                    return "This artifact has characteristics in common with the target artifact. This relationship may be used in systems to \u201cdeduplicate\u201d knowledge artifacts from different sources, or in systems to show \u201csimilar items\u201d.";
                }
                case SUPPORTS: {
                    return "This artifact provides additional support for the target artifact. The type of support  is not documentation as it does not describe, explain, or instruct regarding the target artifact.";
                }
                case SUPPORTEDWITH: {
                    return "The target artifact contains additional information related to the knowledge artifact but is not documentation as the additional information does not describe, explain, or instruct regarding the knowledge artifact content or application. This could include an associated dataset.";
                }
                case TRANSFORMS: {
                    return "This artifact was generated by transforming the target artifact (e.g., format or language conversion). This is intended to capture the relationship in which a particular knowledge resource is based on the content of another artifact, but changes are only apparent in form and there is only one target artifact with the \u201ctransforms\u201d relationship type.";
                }
                case TRANSFORMEDINTO: {
                    return "This artifact was transformed into the target artifact (e.g., by format or language conversion).";
                }
                case TRANSFORMEDWITH: {
                    return "This artifact was generated by transforming a related artifact (e.g., format or language conversion), noted separately with the \u201ctransforms\u201d relationship type. This transformation used the target artifact to inform the transformation. The target artifact may be a conversion script or translation guide.";
                }
                case DOCUMENTS: {
                    return "This artifact provides additional documentation for the target artifact. This could include additional instructions on usage as well as additional information on clinical context or appropriateness.";
                }
                case SPECIFICATIONOF: {
                    return "The target artifact is a precise description of a concept in this artifact. This may be used when the RelatedArtifact datatype is used in elements contained in this artifact.";
                }
                case CREATEDWITH: {
                    return "This artifact was created with the target artifact. The target artifact is a tool or support material used in the creation of the artifact, and not content that the artifact was derived from.";
                }
                case CITEAS: {
                    return "The related artifact is the citation for this artifact.";
                }
                case REPRINT: {
                    return "A copy of the artifact in a publication with a different artifact identifier.";
                }
                case REPRINTOF: {
                    return "The original version of record for which the current artifact is a copy.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DOCUMENTATION: {
                    return "Documentation";
                }
                case JUSTIFICATION: {
                    return "Justification";
                }
                case CITATION: {
                    return "Citation";
                }
                case PREDECESSOR: {
                    return "Predecessor";
                }
                case SUCCESSOR: {
                    return "Successor";
                }
                case DERIVEDFROM: {
                    return "Derived From";
                }
                case DEPENDSON: {
                    return "Depends On";
                }
                case COMPOSEDOF: {
                    return "Composed Of";
                }
                case PARTOF: {
                    return "Part Of";
                }
                case AMENDS: {
                    return "Amends";
                }
                case AMENDEDWITH: {
                    return "Amended With";
                }
                case APPENDS: {
                    return "Appends";
                }
                case APPENDEDWITH: {
                    return "Appended With";
                }
                case CITES: {
                    return "Cites";
                }
                case CITEDBY: {
                    return "Cited By";
                }
                case COMMENTSON: {
                    return "Is Comment On";
                }
                case COMMENTIN: {
                    return "Has Comment In";
                }
                case CONTAINS: {
                    return "Contains";
                }
                case CONTAINEDIN: {
                    return "Contained In";
                }
                case CORRECTS: {
                    return "Corrects";
                }
                case CORRECTIONIN: {
                    return "Correction In";
                }
                case REPLACES: {
                    return "Replaces";
                }
                case REPLACEDWITH: {
                    return "Replaced With";
                }
                case RETRACTS: {
                    return "Retracts";
                }
                case RETRACTEDBY: {
                    return "Retracted By";
                }
                case SIGNS: {
                    return "Signs";
                }
                case SIMILARTO: {
                    return "Similar To";
                }
                case SUPPORTS: {
                    return "Supports";
                }
                case SUPPORTEDWITH: {
                    return "Supported With";
                }
                case TRANSFORMS: {
                    return "Transforms";
                }
                case TRANSFORMEDINTO: {
                    return "Transformed Into";
                }
                case TRANSFORMEDWITH: {
                    return "Transformed With";
                }
                case DOCUMENTS: {
                    return "Documents";
                }
                case SPECIFICATIONOF: {
                    return "Specification Of";
                }
                case CREATEDWITH: {
                    return "Created With";
                }
                case CITEAS: {
                    return "Cite As";
                }
                case REPRINT: {
                    return "Reprint";
                }
                case REPRINTOF: {
                    return "Reprint Of";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

