/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Account;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.ActorDefinition;
import org.hl7.fhir.r5.model.AdministrableProductDefinition;
import org.hl7.fhir.r5.model.AdverseEvent;
import org.hl7.fhir.r5.model.AllergyIntolerance;
import org.hl7.fhir.r5.model.Appointment;
import org.hl7.fhir.r5.model.AppointmentResponse;
import org.hl7.fhir.r5.model.ArtifactAssessment;
import org.hl7.fhir.r5.model.AuditEvent;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Basic;
import org.hl7.fhir.r5.model.Binary;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.BiologicallyDerivedProductDispense;
import org.hl7.fhir.r5.model.BodyStructure;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.ChargeItem;
import org.hl7.fhir.r5.model.ChargeItemDefinition;
import org.hl7.fhir.r5.model.Citation;
import org.hl7.fhir.r5.model.Claim;
import org.hl7.fhir.r5.model.ClaimResponse;
import org.hl7.fhir.r5.model.ClinicalImpression;
import org.hl7.fhir.r5.model.ClinicalUseDefinition;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Communication;
import org.hl7.fhir.r5.model.CommunicationRequest;
import org.hl7.fhir.r5.model.CompartmentDefinition;
import org.hl7.fhir.r5.model.Composition;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.Condition;
import org.hl7.fhir.r5.model.ConditionDefinition;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Consent;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.Contract;
import org.hl7.fhir.r5.model.Coverage;
import org.hl7.fhir.r5.model.CoverageEligibilityRequest;
import org.hl7.fhir.r5.model.CoverageEligibilityResponse;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.DetectedIssue;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DeviceAssociation;
import org.hl7.fhir.r5.model.DeviceDefinition;
import org.hl7.fhir.r5.model.DeviceDispense;
import org.hl7.fhir.r5.model.DeviceMetric;
import org.hl7.fhir.r5.model.DeviceRequest;
import org.hl7.fhir.r5.model.DeviceUsage;
import org.hl7.fhir.r5.model.DiagnosticReport;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.EncounterHistory;
import org.hl7.fhir.r5.model.Endpoint;
import org.hl7.fhir.r5.model.EnrollmentRequest;
import org.hl7.fhir.r5.model.EnrollmentResponse;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.EpisodeOfCare;
import org.hl7.fhir.r5.model.EventDefinition;
import org.hl7.fhir.r5.model.Evidence;
import org.hl7.fhir.r5.model.EvidenceReport;
import org.hl7.fhir.r5.model.EvidenceVariable;
import org.hl7.fhir.r5.model.ExampleScenario;
import org.hl7.fhir.r5.model.ExplanationOfBenefit;
import org.hl7.fhir.r5.model.FamilyMemberHistory;
import org.hl7.fhir.r5.model.Flag;
import org.hl7.fhir.r5.model.FormularyItem;
import org.hl7.fhir.r5.model.GenomicStudy;
import org.hl7.fhir.r5.model.Goal;
import org.hl7.fhir.r5.model.GraphDefinition;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.GuidanceResponse;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImagingSelection;
import org.hl7.fhir.r5.model.ImagingStudy;
import org.hl7.fhir.r5.model.Immunization;
import org.hl7.fhir.r5.model.ImmunizationEvaluation;
import org.hl7.fhir.r5.model.ImmunizationRecommendation;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.Ingredient;
import org.hl7.fhir.r5.model.InsurancePlan;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.InventoryItem;
import org.hl7.fhir.r5.model.InventoryReport;
import org.hl7.fhir.r5.model.Invoice;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.Linkage;
import org.hl7.fhir.r5.model.ListResource;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.ManufacturedItemDefinition;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Measure;
import org.hl7.fhir.r5.model.MeasureReport;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MedicationAdministration;
import org.hl7.fhir.r5.model.MedicationDispense;
import org.hl7.fhir.r5.model.MedicationKnowledge;
import org.hl7.fhir.r5.model.MedicationRequest;
import org.hl7.fhir.r5.model.MedicationStatement;
import org.hl7.fhir.r5.model.MedicinalProductDefinition;
import org.hl7.fhir.r5.model.MessageDefinition;
import org.hl7.fhir.r5.model.MessageHeader;
import org.hl7.fhir.r5.model.MetadataResource;
import org.hl7.fhir.r5.model.MolecularSequence;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.NutritionIntake;
import org.hl7.fhir.r5.model.NutritionOrder;
import org.hl7.fhir.r5.model.NutritionProduct;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.ObservationDefinition;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.OrganizationAffiliation;
import org.hl7.fhir.r5.model.PackagedProductDefinition;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.PaymentNotice;
import org.hl7.fhir.r5.model.PaymentReconciliation;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Permission;
import org.hl7.fhir.r5.model.Person;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Provenance;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.RegulatedAuthorization;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.RequestOrchestration;
import org.hl7.fhir.r5.model.Requirements;
import org.hl7.fhir.r5.model.ResearchStudy;
import org.hl7.fhir.r5.model.ResearchSubject;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.RiskAssessment;
import org.hl7.fhir.r5.model.Schedule;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.Slot;
import org.hl7.fhir.r5.model.Specimen;
import org.hl7.fhir.r5.model.SpecimenDefinition;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.Subscription;
import org.hl7.fhir.r5.model.SubscriptionStatus;
import org.hl7.fhir.r5.model.SubscriptionTopic;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.SubstanceDefinition;
import org.hl7.fhir.r5.model.SubstanceNucleicAcid;
import org.hl7.fhir.r5.model.SubstancePolymer;
import org.hl7.fhir.r5.model.SubstanceProtein;
import org.hl7.fhir.r5.model.SubstanceReferenceInformation;
import org.hl7.fhir.r5.model.SubstanceSourceMaterial;
import org.hl7.fhir.r5.model.SupplyDelivery;
import org.hl7.fhir.r5.model.SupplyRequest;
import org.hl7.fhir.r5.model.Task;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.TestPlan;
import org.hl7.fhir.r5.model.TestReport;
import org.hl7.fhir.r5.model.TestScript;
import org.hl7.fhir.r5.model.Transport;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.r5.model.VerificationResult;
import org.hl7.fhir.r5.model.VisionPrescription;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ValueSet", profile="http://hl7.org/fhir/StructureDefinition/ValueSet")
public class ValueSet
extends MetadataResource {
    @Child(name="url", type={UriType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Canonical identifier for this value set, represented as a URI (globally unique)", formalDefinition="An absolute URI that is used to identify this value set when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which an authoritative instance of this value set is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the value set is stored on different servers.")
    protected UriType url;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional identifier for the value set (business identifier)", formalDefinition="A formal identifier that is used to identify this value set when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected List<Identifier> identifier;
    @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business version of the value set", formalDefinition="The identifier that is used to identify this version of the value set when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the value set author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.")
    protected StringType version;
    @Child(name="versionAlgorithm", type={StringType.class, Coding.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="How to compare versions", formalDefinition="Indicates the mechanism used to compare versions to determine which ValueSet is more current.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/version-algorithm")
    protected DataType versionAlgorithm;
    @Child(name="name", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this value set (computer friendly)", formalDefinition="A natural language name identifying the value set. This name should be usable as an identifier for the module by machine processing applications such as code generation.")
    protected StringType name;
    @Child(name="title", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this value set (human friendly)", formalDefinition="A short, descriptive, user-friendly title for the value set.")
    protected StringType title;
    @Child(name="status", type={CodeType.class}, order=6, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired | unknown", formalDefinition="The status of this value set. Enables tracking the life-cycle of the content. The status of the value set applies to the value set definition (ValueSet.compose) and the associated ValueSet metadata. Expansions do not have a state.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected Enumeration<Enumerations.PublicationStatus> status;
    @Child(name="experimental", type={BooleanType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="For testing purposes, not real usage", formalDefinition="A Boolean value to indicate that this value set is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.")
    protected BooleanType experimental;
    @Child(name="date", type={DateTimeType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date last changed", formalDefinition="The date (and optionally time) when the value set metadata or content logical definition (.compose) was created or revised.")
    protected DateTimeType date;
    @Child(name="publisher", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of the publisher/steward (organization or individual)", formalDefinition="The name of the organization or individual responsible for the release and ongoing maintenance of the value set.")
    protected StringType publisher;
    @Child(name="contact", type={ContactDetail.class}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details for the publisher", formalDefinition="Contact details to assist a user in finding and communicating with the publisher.")
    protected List<ContactDetail> contact;
    @Child(name="description", type={MarkdownType.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Natural language description of the value set", formalDefinition="A free text natural language description of the value set from a consumer's perspective. The textual description specifies the span of meanings for concepts to be included within the Value Set Expansion, and also may specify the intended use and limitations of the Value Set.")
    protected MarkdownType description;
    @Child(name="useContext", type={UsageContext.class}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The context that the content is intended to support", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate value set instances.")
    protected List<UsageContext> useContext;
    @Child(name="jurisdiction", type={CodeableConcept.class}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Intended jurisdiction for value set (if applicable)", formalDefinition="A legal or geographic region in which the value set is intended to be used.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    protected List<CodeableConcept> jurisdiction;
    @Child(name="immutable", type={BooleanType.class}, order=14, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Indicates whether or not any change to the content logical definition may occur", formalDefinition="If this is set to 'true', then no new versions of the content logical definition can be created.  Note: Other metadata might still change.")
    protected BooleanType immutable;
    @Child(name="purpose", type={MarkdownType.class}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why this value set is defined", formalDefinition="Explanation of why this value set is needed and why it has been designed as it has.")
    protected MarkdownType purpose;
    @Child(name="copyright", type={MarkdownType.class}, order=16, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the value set and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the value set.")
    protected MarkdownType copyright;
    @Child(name="copyrightLabel", type={StringType.class}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Copyright holder and year(s)", formalDefinition="A short string (<50 characters), suitable for inclusion in a page footer that identifies the copyright holder, effective period, and optionally whether rights are resctricted. (e.g. 'All rights reserved', 'Some rights reserved').")
    protected StringType copyrightLabel;
    @Child(name="approvalDate", type={DateType.class}, order=18, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the ValueSet was approved by publisher", formalDefinition="The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.")
    protected DateType approvalDate;
    @Child(name="lastReviewDate", type={DateType.class}, order=19, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the ValueSet was last reviewed by the publisher", formalDefinition="The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.")
    protected DateType lastReviewDate;
    @Child(name="effectivePeriod", type={Period.class}, order=20, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the ValueSet is expected to be used", formalDefinition="The period during which the ValueSet content was or is planned to be in active use.")
    protected Period effectivePeriod;
    @Child(name="topic", type={CodeableConcept.class}, order=21, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="E.g. Education, Treatment, Assessment, etc", formalDefinition="Descriptions related to the content of the ValueSet. Topics provide a high-level categorization as well as keywords for the ValueSet that can be useful for filtering and searching.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/definition-topic")
    protected List<CodeableConcept> topic;
    @Child(name="author", type={ContactDetail.class}, order=22, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who authored the ValueSet", formalDefinition="An individiual or organization primarily involved in the creation and maintenance of the ValueSet.")
    protected List<ContactDetail> author;
    @Child(name="editor", type={ContactDetail.class}, order=23, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who edited the ValueSet", formalDefinition="An individual or organization primarily responsible for internal coherence of the ValueSet.")
    protected List<ContactDetail> editor;
    @Child(name="reviewer", type={ContactDetail.class}, order=24, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who reviewed the ValueSet", formalDefinition="An individual or organization asserted by the publisher to be primarily responsible for review of some aspect of the ValueSet.")
    protected List<ContactDetail> reviewer;
    @Child(name="endorser", type={ContactDetail.class}, order=25, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who endorsed the ValueSet", formalDefinition="An individual or organization asserted by the publisher to be responsible for officially endorsing the ValueSet for use in some setting.")
    protected List<ContactDetail> endorser;
    @Child(name="relatedArtifact", type={RelatedArtifact.class}, order=26, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional documentation, citations, etc", formalDefinition="Related artifacts such as additional documentation, justification, dependencies, bibliographic references, and predecessor and successor artifacts.")
    protected List<RelatedArtifact> relatedArtifact;
    @Child(name="compose", type={}, order=27, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Content logical definition of the value set (CLD)", formalDefinition="A set of criteria that define the contents of the value set by including or excluding codes selected from the specified code system(s) that the value set draws from. This is also known as the Content Logical Definition (CLD).")
    protected ValueSetComposeComponent compose;
    @Child(name="expansion", type={}, order=28, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Used when the value set is \"expanded\"", formalDefinition="A value set can also be \"expanded\", where the value set is turned into a simple collection of enumerated codes. This element holds the expansion, if it has been performed.")
    protected ValueSetExpansionComponent expansion;
    @Child(name="scope", type={}, order=29, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Description of the semantic space the Value Set Expansion is intended to cover and should further clarify the text in ValueSet.description", formalDefinition="Description of the semantic space the Value Set Expansion is intended to cover and should further clarify the text in ValueSet.description.")
    protected ValueSetScopeComponent scope;
    private static final long serialVersionUID = -1050676231L;
    @SearchParamDefinition(name="context-quantity", path="(ActivityDefinition.useContext.value.ofType(Quantity)) | (ActivityDefinition.useContext.value.ofType(Range)) | (ActorDefinition.useContext.value.ofType(Quantity)) | (ActorDefinition.useContext.value.ofType(Range)) | (CapabilityStatement.useContext.value.ofType(Quantity)) | (CapabilityStatement.useContext.value.ofType(Range)) | (ChargeItemDefinition.useContext.value.ofType(Quantity)) | (ChargeItemDefinition.useContext.value.ofType(Range)) | (Citation.useContext.value.ofType(Quantity)) | (Citation.useContext.value.ofType(Range)) | (CodeSystem.useContext.value.ofType(Quantity)) | (CodeSystem.useContext.value.ofType(Range)) | (CompartmentDefinition.useContext.value.ofType(Quantity)) | (CompartmentDefinition.useContext.value.ofType(Range)) | (ConceptMap.useContext.value.ofType(Quantity)) | (ConceptMap.useContext.value.ofType(Range)) | (ConditionDefinition.useContext.value.ofType(Quantity)) | (ConditionDefinition.useContext.value.ofType(Range)) | (EventDefinition.useContext.value.ofType(Quantity)) | (EventDefinition.useContext.value.ofType(Range)) | (Evidence.useContext.value.ofType(Quantity)) | (Evidence.useContext.value.ofType(Range)) | (EvidenceReport.useContext.value.ofType(Quantity)) | (EvidenceReport.useContext.value.ofType(Range)) | (EvidenceVariable.useContext.value.ofType(Quantity)) | (EvidenceVariable.useContext.value.ofType(Range)) | (ExampleScenario.useContext.value.ofType(Quantity)) | (ExampleScenario.useContext.value.ofType(Range)) | (GraphDefinition.useContext.value.ofType(Quantity)) | (GraphDefinition.useContext.value.ofType(Range)) | (ImplementationGuide.useContext.value.ofType(Quantity)) | (ImplementationGuide.useContext.value.ofType(Range)) | (Library.useContext.value.ofType(Quantity)) | (Library.useContext.value.ofType(Range)) | (Measure.useContext.value.ofType(Quantity)) | (Measure.useContext.value.ofType(Range)) | (MessageDefinition.useContext.value.ofType(Quantity)) | (MessageDefinition.useContext.value.ofType(Range)) | (NamingSystem.useContext.value.ofType(Quantity)) | (NamingSystem.useContext.value.ofType(Range)) | (OperationDefinition.useContext.value.ofType(Quantity)) | (OperationDefinition.useContext.value.ofType(Range)) | (PlanDefinition.useContext.value.ofType(Quantity)) | (PlanDefinition.useContext.value.ofType(Range)) | (Questionnaire.useContext.value.ofType(Quantity)) | (Questionnaire.useContext.value.ofType(Range)) | (Requirements.useContext.value.ofType(Quantity)) | (Requirements.useContext.value.ofType(Range)) | (SearchParameter.useContext.value.ofType(Quantity)) | (SearchParameter.useContext.value.ofType(Range)) | (StructureDefinition.useContext.value.ofType(Quantity)) | (StructureDefinition.useContext.value.ofType(Range)) | (StructureMap.useContext.value.ofType(Quantity)) | (StructureMap.useContext.value.ofType(Range)) | (TerminologyCapabilities.useContext.value.ofType(Quantity)) | (TerminologyCapabilities.useContext.value.ofType(Range)) | (TestScript.useContext.value.ofType(Quantity)) | (TestScript.useContext.value.ofType(Range)) | (ValueSet.useContext.value.ofType(Quantity)) | (ValueSet.useContext.value.ofType(Range))", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): A quantity- or range-valued use context assigned to the activity definition\r\n* [ActorDefinition](actordefinition.html): A quantity- or range-valued use context assigned to the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): A quantity- or range-valued use context assigned to the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): A quantity- or range-valued use context assigned to the charge item definition\r\n* [Citation](citation.html): A quantity- or range-valued use context assigned to the citation\r\n* [CodeSystem](codesystem.html): A quantity- or range-valued use context assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A quantity- or range-valued use context assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A quantity- or range-valued use context assigned to the concept map\r\n* [ConditionDefinition](conditiondefinition.html): A quantity- or range-valued use context assigned to the condition definition\r\n* [EventDefinition](eventdefinition.html): A quantity- or range-valued use context assigned to the event definition\r\n* [Evidence](evidence.html): A quantity- or range-valued use context assigned to the evidence\r\n* [EvidenceReport](evidencereport.html): A quantity- or range-valued use context assigned to the evidence report\r\n* [EvidenceVariable](evidencevariable.html): A quantity- or range-valued use context assigned to the evidence variable\r\n* [ExampleScenario](examplescenario.html): A quantity- or range-valued use context assigned to the example scenario\r\n* [GraphDefinition](graphdefinition.html): A quantity- or range-valued use context assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A quantity- or range-valued use context assigned to the implementation guide\r\n* [Library](library.html): A quantity- or range-valued use context assigned to the library\r\n* [Measure](measure.html): A quantity- or range-valued use context assigned to the measure\r\n* [MessageDefinition](messagedefinition.html): A quantity- or range-valued use context assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A quantity- or range-valued use context assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A quantity- or range-valued use context assigned to the operation definition\r\n* [PlanDefinition](plandefinition.html): A quantity- or range-valued use context assigned to the plan definition\r\n* [Questionnaire](questionnaire.html): A quantity- or range-valued use context assigned to the questionnaire\r\n* [Requirements](requirements.html): A quantity- or range-valued use context assigned to the requirements\r\n* [SearchParameter](searchparameter.html): A quantity- or range-valued use context assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A quantity- or range-valued use context assigned to the structure definition\r\n* [StructureMap](structuremap.html): A quantity- or range-valued use context assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A quantity- or range-valued use context assigned to the terminology capabilities\r\n* [TestScript](testscript.html): A quantity- or range-valued use context assigned to the test script\r\n* [ValueSet](valueset.html): A quantity- or range-valued use context assigned to the value set\r\n", type="quantity")
    public static final String SP_CONTEXT_QUANTITY = "context-quantity";
    public static final QuantityClientParam CONTEXT_QUANTITY = new QuantityClientParam("context-quantity");
    @SearchParamDefinition(name="context-type-quantity", path="ActivityDefinition.useContext | ActorDefinition.useContext | CapabilityStatement.useContext | ChargeItemDefinition.useContext | Citation.useContext | CodeSystem.useContext | CompartmentDefinition.useContext | ConceptMap.useContext | ConditionDefinition.useContext | EventDefinition.useContext | Evidence.useContext | EvidenceReport.useContext | EvidenceVariable.useContext | ExampleScenario.useContext | GraphDefinition.useContext | ImplementationGuide.useContext | Library.useContext | Measure.useContext | MessageDefinition.useContext | NamingSystem.useContext | OperationDefinition.useContext | PlanDefinition.useContext | Questionnaire.useContext | Requirements.useContext | SearchParameter.useContext | StructureDefinition.useContext | StructureMap.useContext | TerminologyCapabilities.useContext | TestScript.useContext | ValueSet.useContext", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): A use context type and quantity- or range-based value assigned to the activity definition\r\n* [ActorDefinition](actordefinition.html): A use context type and quantity- or range-based value assigned to the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): A use context type and quantity- or range-based value assigned to the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): A use context type and quantity- or range-based value assigned to the charge item definition\r\n* [Citation](citation.html): A use context type and quantity- or range-based value assigned to the citation\r\n* [CodeSystem](codesystem.html): A use context type and quantity- or range-based value assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A use context type and quantity- or range-based value assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A use context type and quantity- or range-based value assigned to the concept map\r\n* [ConditionDefinition](conditiondefinition.html): A use context type and quantity- or range-based value assigned to the condition definition\r\n* [EventDefinition](eventdefinition.html): A use context type and quantity- or range-based value assigned to the event definition\r\n* [Evidence](evidence.html): A use context type and quantity- or range-based value assigned to the evidence\r\n* [EvidenceReport](evidencereport.html): A use context type and quantity- or range-based value assigned to the evidence report\r\n* [EvidenceVariable](evidencevariable.html): A use context type and quantity- or range-based value assigned to the evidence variable\r\n* [ExampleScenario](examplescenario.html): A use context type and quantity- or range-based value assigned to the example scenario\r\n* [GraphDefinition](graphdefinition.html): A use context type and quantity- or range-based value assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A use context type and quantity- or range-based value assigned to the implementation guide\r\n* [Library](library.html): A use context type and quantity- or range-based value assigned to the library\r\n* [Measure](measure.html): A use context type and quantity- or range-based value assigned to the measure\r\n* [MessageDefinition](messagedefinition.html): A use context type and quantity- or range-based value assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A use context type and quantity- or range-based value assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A use context type and quantity- or range-based value assigned to the operation definition\r\n* [PlanDefinition](plandefinition.html): A use context type and quantity- or range-based value assigned to the plan definition\r\n* [Questionnaire](questionnaire.html): A use context type and quantity- or range-based value assigned to the questionnaire\r\n* [Requirements](requirements.html): A use context type and quantity- or range-based value assigned to the requirements\r\n* [SearchParameter](searchparameter.html): A use context type and quantity- or range-based value assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A use context type and quantity- or range-based value assigned to the structure definition\r\n* [StructureMap](structuremap.html): A use context type and quantity- or range-based value assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A use context type and quantity- or range-based value assigned to the terminology capabilities\r\n* [TestScript](testscript.html): A use context type and quantity- or range-based value assigned to the test script\r\n* [ValueSet](valueset.html): A use context type and quantity- or range-based value assigned to the value set\r\n", type="composite", compositeOf={"context-type", "context-quantity"})
    public static final String SP_CONTEXT_TYPE_QUANTITY = "context-type-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> CONTEXT_TYPE_QUANTITY = new CompositeClientParam("context-type-quantity");
    @SearchParamDefinition(name="context-type-value", path="ActivityDefinition.useContext | ActorDefinition.useContext | CapabilityStatement.useContext | ChargeItemDefinition.useContext | Citation.useContext | CodeSystem.useContext | CompartmentDefinition.useContext | ConceptMap.useContext | ConditionDefinition.useContext | EventDefinition.useContext | Evidence.useContext | EvidenceReport.useContext | EvidenceVariable.useContext | ExampleScenario.useContext | GraphDefinition.useContext | ImplementationGuide.useContext | Library.useContext | Measure.useContext | MessageDefinition.useContext | NamingSystem.useContext | OperationDefinition.useContext | PlanDefinition.useContext | Questionnaire.useContext | Requirements.useContext | SearchParameter.useContext | StructureDefinition.useContext | StructureMap.useContext | TerminologyCapabilities.useContext | TestScript.useContext | ValueSet.useContext", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): A use context type and value assigned to the activity definition\r\n* [ActorDefinition](actordefinition.html): A use context type and value assigned to the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): A use context type and value assigned to the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): A use context type and value assigned to the charge item definition\r\n* [Citation](citation.html): A use context type and value assigned to the citation\r\n* [CodeSystem](codesystem.html): A use context type and value assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A use context type and value assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A use context type and value assigned to the concept map\r\n* [ConditionDefinition](conditiondefinition.html): A use context type and value assigned to the condition definition\r\n* [EventDefinition](eventdefinition.html): A use context type and value assigned to the event definition\r\n* [Evidence](evidence.html): A use context type and value assigned to the evidence\r\n* [EvidenceReport](evidencereport.html): A use context type and value assigned to the evidence report\r\n* [EvidenceVariable](evidencevariable.html): A use context type and value assigned to the evidence variable\r\n* [ExampleScenario](examplescenario.html): A use context type and value assigned to the example scenario\r\n* [GraphDefinition](graphdefinition.html): A use context type and value assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A use context type and value assigned to the implementation guide\r\n* [Library](library.html): A use context type and value assigned to the library\r\n* [Measure](measure.html): A use context type and value assigned to the measure\r\n* [MessageDefinition](messagedefinition.html): A use context type and value assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A use context type and value assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A use context type and value assigned to the operation definition\r\n* [PlanDefinition](plandefinition.html): A use context type and value assigned to the plan definition\r\n* [Questionnaire](questionnaire.html): A use context type and value assigned to the questionnaire\r\n* [Requirements](requirements.html): A use context type and value assigned to the requirements\r\n* [SearchParameter](searchparameter.html): A use context type and value assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A use context type and value assigned to the structure definition\r\n* [StructureMap](structuremap.html): A use context type and value assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A use context type and value assigned to the terminology capabilities\r\n* [TestScript](testscript.html): A use context type and value assigned to the test script\r\n* [ValueSet](valueset.html): A use context type and value assigned to the value set\r\n", type="composite", compositeOf={"context-type", "context"})
    public static final String SP_CONTEXT_TYPE_VALUE = "context-type-value";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CONTEXT_TYPE_VALUE = new CompositeClientParam("context-type-value");
    @SearchParamDefinition(name="context-type", path="ActivityDefinition.useContext.code | ActorDefinition.useContext.code | CapabilityStatement.useContext.code | ChargeItemDefinition.useContext.code | Citation.useContext.code | CodeSystem.useContext.code | CompartmentDefinition.useContext.code | ConceptMap.useContext.code | ConditionDefinition.useContext.code | EventDefinition.useContext.code | Evidence.useContext.code | EvidenceReport.useContext.code | EvidenceVariable.useContext.code | ExampleScenario.useContext.code | GraphDefinition.useContext.code | ImplementationGuide.useContext.code | Library.useContext.code | Measure.useContext.code | MessageDefinition.useContext.code | NamingSystem.useContext.code | OperationDefinition.useContext.code | PlanDefinition.useContext.code | Questionnaire.useContext.code | Requirements.useContext.code | SearchParameter.useContext.code | StructureDefinition.useContext.code | StructureMap.useContext.code | TerminologyCapabilities.useContext.code | TestScript.useContext.code | ValueSet.useContext.code", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): A type of use context assigned to the activity definition\r\n* [ActorDefinition](actordefinition.html): A type of use context assigned to the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): A type of use context assigned to the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): A type of use context assigned to the charge item definition\r\n* [Citation](citation.html): A type of use context assigned to the citation\r\n* [CodeSystem](codesystem.html): A type of use context assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A type of use context assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A type of use context assigned to the concept map\r\n* [ConditionDefinition](conditiondefinition.html): A type of use context assigned to the condition definition\r\n* [EventDefinition](eventdefinition.html): A type of use context assigned to the event definition\r\n* [Evidence](evidence.html): A type of use context assigned to the evidence\r\n* [EvidenceReport](evidencereport.html): A type of use context assigned to the evidence report\r\n* [EvidenceVariable](evidencevariable.html): A type of use context assigned to the evidence variable\r\n* [ExampleScenario](examplescenario.html): A type of use context assigned to the example scenario\r\n* [GraphDefinition](graphdefinition.html): A type of use context assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A type of use context assigned to the implementation guide\r\n* [Library](library.html): A type of use context assigned to the library\r\n* [Measure](measure.html): A type of use context assigned to the measure\r\n* [MessageDefinition](messagedefinition.html): A type of use context assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A type of use context assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A type of use context assigned to the operation definition\r\n* [PlanDefinition](plandefinition.html): A type of use context assigned to the plan definition\r\n* [Questionnaire](questionnaire.html): A type of use context assigned to the questionnaire\r\n* [Requirements](requirements.html): A type of use context assigned to the requirements\r\n* [SearchParameter](searchparameter.html): A type of use context assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A type of use context assigned to the structure definition\r\n* [StructureMap](structuremap.html): A type of use context assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A type of use context assigned to the terminology capabilities\r\n* [TestScript](testscript.html): A type of use context assigned to the test script\r\n* [ValueSet](valueset.html): A type of use context assigned to the value set\r\n", type="token")
    public static final String SP_CONTEXT_TYPE = "context-type";
    public static final TokenClientParam CONTEXT_TYPE = new TokenClientParam("context-type");
    @SearchParamDefinition(name="context", path="(ActivityDefinition.useContext.value.ofType(CodeableConcept)) | (ActorDefinition.useContext.value.ofType(CodeableConcept)) | (CapabilityStatement.useContext.value.ofType(CodeableConcept)) | (ChargeItemDefinition.useContext.value.ofType(CodeableConcept)) | (Citation.useContext.value.ofType(CodeableConcept)) | (CodeSystem.useContext.value.ofType(CodeableConcept)) | (CompartmentDefinition.useContext.value.ofType(CodeableConcept)) | (ConceptMap.useContext.value.ofType(CodeableConcept)) | (ConditionDefinition.useContext.value.ofType(CodeableConcept)) | (EventDefinition.useContext.value.ofType(CodeableConcept)) | (Evidence.useContext.value.ofType(CodeableConcept)) | (EvidenceReport.useContext.value.ofType(CodeableConcept)) | (EvidenceVariable.useContext.value.ofType(CodeableConcept)) | (ExampleScenario.useContext.value.ofType(CodeableConcept)) | (GraphDefinition.useContext.value.ofType(CodeableConcept)) | (ImplementationGuide.useContext.value.ofType(CodeableConcept)) | (Library.useContext.value.ofType(CodeableConcept)) | (Measure.useContext.value.ofType(CodeableConcept)) | (MessageDefinition.useContext.value.ofType(CodeableConcept)) | (NamingSystem.useContext.value.ofType(CodeableConcept)) | (OperationDefinition.useContext.value.ofType(CodeableConcept)) | (PlanDefinition.useContext.value.ofType(CodeableConcept)) | (Questionnaire.useContext.value.ofType(CodeableConcept)) | (Requirements.useContext.value.ofType(CodeableConcept)) | (SearchParameter.useContext.value.ofType(CodeableConcept)) | (StructureDefinition.useContext.value.ofType(CodeableConcept)) | (StructureMap.useContext.value.ofType(CodeableConcept)) | (TerminologyCapabilities.useContext.value.ofType(CodeableConcept)) | (TestScript.useContext.value.ofType(CodeableConcept)) | (ValueSet.useContext.value.ofType(CodeableConcept))", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): A use context assigned to the activity definition\r\n* [ActorDefinition](actordefinition.html): A use context assigned to the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): A use context assigned to the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): A use context assigned to the charge item definition\r\n* [Citation](citation.html): A use context assigned to the citation\r\n* [CodeSystem](codesystem.html): A use context assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A use context assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A use context assigned to the concept map\r\n* [ConditionDefinition](conditiondefinition.html): A use context assigned to the condition definition\r\n* [EventDefinition](eventdefinition.html): A use context assigned to the event definition\r\n* [Evidence](evidence.html): A use context assigned to the evidence\r\n* [EvidenceReport](evidencereport.html): A use context assigned to the evidence report\r\n* [EvidenceVariable](evidencevariable.html): A use context assigned to the evidence variable\r\n* [ExampleScenario](examplescenario.html): A use context assigned to the example scenario\r\n* [GraphDefinition](graphdefinition.html): A use context assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A use context assigned to the implementation guide\r\n* [Library](library.html): A use context assigned to the library\r\n* [Measure](measure.html): A use context assigned to the measure\r\n* [MessageDefinition](messagedefinition.html): A use context assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A use context assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A use context assigned to the operation definition\r\n* [PlanDefinition](plandefinition.html): A use context assigned to the plan definition\r\n* [Questionnaire](questionnaire.html): A use context assigned to the questionnaire\r\n* [Requirements](requirements.html): A use context assigned to the requirements\r\n* [SearchParameter](searchparameter.html): A use context assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A use context assigned to the structure definition\r\n* [StructureMap](structuremap.html): A use context assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A use context assigned to the terminology capabilities\r\n* [TestScript](testscript.html): A use context assigned to the test script\r\n* [ValueSet](valueset.html): A use context assigned to the value set\r\n", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="date", path="ActivityDefinition.date | ActorDefinition.date | CapabilityStatement.date | ChargeItemDefinition.date | Citation.date | CodeSystem.date | CompartmentDefinition.date | ConceptMap.date | ConditionDefinition.date | EventDefinition.date | Evidence.date | EvidenceVariable.date | ExampleScenario.date | GraphDefinition.date | ImplementationGuide.date | Library.date | Measure.date | MessageDefinition.date | NamingSystem.date | OperationDefinition.date | PlanDefinition.date | Questionnaire.date | Requirements.date | SearchParameter.date | StructureDefinition.date | StructureMap.date | SubscriptionTopic.date | TerminologyCapabilities.date | TestScript.date | ValueSet.date", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The activity definition publication date\r\n* [ActorDefinition](actordefinition.html): The Actor Definition publication date\r\n* [CapabilityStatement](capabilitystatement.html): The capability statement publication date\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The charge item definition publication date\r\n* [Citation](citation.html): The citation publication date\r\n* [CodeSystem](codesystem.html): The code system publication date\r\n* [CompartmentDefinition](compartmentdefinition.html): The compartment definition publication date\r\n* [ConceptMap](conceptmap.html): The concept map publication date\r\n* [ConditionDefinition](conditiondefinition.html): The condition definition publication date\r\n* [EventDefinition](eventdefinition.html): The event definition publication date\r\n* [Evidence](evidence.html): The evidence publication date\r\n* [EvidenceVariable](evidencevariable.html): The evidence variable publication date\r\n* [ExampleScenario](examplescenario.html): The example scenario publication date\r\n* [GraphDefinition](graphdefinition.html): The graph definition publication date\r\n* [ImplementationGuide](implementationguide.html): The implementation guide publication date\r\n* [Library](library.html): The library publication date\r\n* [Measure](measure.html): The measure publication date\r\n* [MessageDefinition](messagedefinition.html): The message definition publication date\r\n* [NamingSystem](namingsystem.html): The naming system publication date\r\n* [OperationDefinition](operationdefinition.html): The operation definition publication date\r\n* [PlanDefinition](plandefinition.html): The plan definition publication date\r\n* [Questionnaire](questionnaire.html): The questionnaire publication date\r\n* [Requirements](requirements.html): The requirements publication date\r\n* [SearchParameter](searchparameter.html): The search parameter publication date\r\n* [StructureDefinition](structuredefinition.html): The structure definition publication date\r\n* [StructureMap](structuremap.html): The structure map publication date\r\n* [SubscriptionTopic](subscriptiontopic.html): Date status first applied\r\n* [TerminologyCapabilities](terminologycapabilities.html): The terminology capabilities publication date\r\n* [TestScript](testscript.html): The test script publication date\r\n* [ValueSet](valueset.html): The value set publication date\r\n", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="description", path="ActivityDefinition.description | ActorDefinition.description | CapabilityStatement.description | ChargeItemDefinition.description | Citation.description | CodeSystem.description | CompartmentDefinition.description | ConceptMap.description | ConditionDefinition.description | EventDefinition.description | Evidence.description | EvidenceVariable.description | GraphDefinition.description | ImplementationGuide.description | Library.description | Measure.description | MessageDefinition.description | NamingSystem.description | OperationDefinition.description | PlanDefinition.description | Questionnaire.description | Requirements.description | SearchParameter.description | StructureDefinition.description | StructureMap.description | TerminologyCapabilities.description | TestScript.description | ValueSet.description", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The description of the activity definition\r\n* [ActorDefinition](actordefinition.html): The description of the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): The description of the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The description of the charge item definition\r\n* [Citation](citation.html): The description of the citation\r\n* [CodeSystem](codesystem.html): The description of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The description of the compartment definition\r\n* [ConceptMap](conceptmap.html): The description of the concept map\r\n* [ConditionDefinition](conditiondefinition.html): The description of the condition definition\r\n* [EventDefinition](eventdefinition.html): The description of the event definition\r\n* [Evidence](evidence.html): The description of the evidence\r\n* [EvidenceVariable](evidencevariable.html): The description of the evidence variable\r\n* [GraphDefinition](graphdefinition.html): The description of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The description of the implementation guide\r\n* [Library](library.html): The description of the library\r\n* [Measure](measure.html): The description of the measure\r\n* [MessageDefinition](messagedefinition.html): The description of the message definition\r\n* [NamingSystem](namingsystem.html): The description of the naming system\r\n* [OperationDefinition](operationdefinition.html): The description of the operation definition\r\n* [PlanDefinition](plandefinition.html): The description of the plan definition\r\n* [Questionnaire](questionnaire.html): The description of the questionnaire\r\n* [Requirements](requirements.html): The description of the requirements\r\n* [SearchParameter](searchparameter.html): The description of the search parameter\r\n* [StructureDefinition](structuredefinition.html): The description of the structure definition\r\n* [StructureMap](structuremap.html): The description of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): The description of the terminology capabilities\r\n* [TestScript](testscript.html): The description of the test script\r\n* [ValueSet](valueset.html): The description of the value set\r\n", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="identifier", path="ActivityDefinition.identifier | ActorDefinition.identifier | CapabilityStatement.identifier | ChargeItemDefinition.identifier | Citation.identifier | CodeSystem.identifier | ConceptMap.identifier | ConditionDefinition.identifier | EventDefinition.identifier | Evidence.identifier | EvidenceReport.identifier | EvidenceVariable.identifier | ExampleScenario.identifier | GraphDefinition.identifier | ImplementationGuide.identifier | Library.identifier | Measure.identifier | MedicationKnowledge.identifier | MessageDefinition.identifier | NamingSystem.identifier | ObservationDefinition.identifier | OperationDefinition.identifier | PlanDefinition.identifier | Questionnaire.identifier | Requirements.identifier | SearchParameter.identifier | SpecimenDefinition.identifier | StructureDefinition.identifier | StructureMap.identifier | SubscriptionTopic.identifier | TerminologyCapabilities.identifier | TestPlan.identifier | TestScript.identifier | ValueSet.identifier", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): External identifier for the activity definition\r\n* [ActorDefinition](actordefinition.html): External identifier for the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): External identifier for the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): External identifier for the charge item definition\r\n* [Citation](citation.html): External identifier for the citation\r\n* [CodeSystem](codesystem.html): External identifier for the code system\r\n* [ConceptMap](conceptmap.html): External identifier for the concept map\r\n* [ConditionDefinition](conditiondefinition.html): External identifier for the condition definition\r\n* [EventDefinition](eventdefinition.html): External identifier for the event definition\r\n* [Evidence](evidence.html): External identifier for the evidence\r\n* [EvidenceReport](evidencereport.html): External identifier for the evidence report\r\n* [EvidenceVariable](evidencevariable.html): External identifier for the evidence variable\r\n* [ExampleScenario](examplescenario.html): External identifier for the example scenario\r\n* [GraphDefinition](graphdefinition.html): External identifier for the graph definition\r\n* [ImplementationGuide](implementationguide.html): External identifier for the implementation guide\r\n* [Library](library.html): External identifier for the library\r\n* [Measure](measure.html): External identifier for the measure\r\n* [MedicationKnowledge](medicationknowledge.html): Business identifier for this medication\r\n* [MessageDefinition](messagedefinition.html): External identifier for the message definition\r\n* [NamingSystem](namingsystem.html): External identifier for the naming system\r\n* [ObservationDefinition](observationdefinition.html): The unique identifier associated with the specimen definition\r\n* [OperationDefinition](operationdefinition.html): External identifier for the search parameter\r\n* [PlanDefinition](plandefinition.html): External identifier for the plan definition\r\n* [Questionnaire](questionnaire.html): External identifier for the questionnaire\r\n* [Requirements](requirements.html): External identifier for the requirements\r\n* [SearchParameter](searchparameter.html): External identifier for the search parameter\r\n* [SpecimenDefinition](specimendefinition.html): The unique identifier associated with the SpecimenDefinition\r\n* [StructureDefinition](structuredefinition.html): External identifier for the structure definition\r\n* [StructureMap](structuremap.html): External identifier for the structure map\r\n* [SubscriptionTopic](subscriptiontopic.html): Business Identifier for SubscriptionTopic\r\n* [TerminologyCapabilities](terminologycapabilities.html): External identifier for the terminology capabilities\r\n* [TestPlan](testplan.html): An identifier for the test plan\r\n* [TestScript](testscript.html): External identifier for the test script\r\n* [ValueSet](valueset.html): External identifier for the value set\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="jurisdiction", path="ActivityDefinition.jurisdiction | ActorDefinition.jurisdiction | CapabilityStatement.jurisdiction | ChargeItemDefinition.jurisdiction | Citation.jurisdiction | CodeSystem.jurisdiction | ConceptMap.jurisdiction | ConditionDefinition.jurisdiction | EventDefinition.jurisdiction | ExampleScenario.jurisdiction | GraphDefinition.jurisdiction | ImplementationGuide.jurisdiction | Library.jurisdiction | Measure.jurisdiction | MessageDefinition.jurisdiction | NamingSystem.jurisdiction | OperationDefinition.jurisdiction | PlanDefinition.jurisdiction | Questionnaire.jurisdiction | Requirements.jurisdiction | SearchParameter.jurisdiction | StructureDefinition.jurisdiction | StructureMap.jurisdiction | TerminologyCapabilities.jurisdiction | TestScript.jurisdiction | ValueSet.jurisdiction", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): Intended jurisdiction for the activity definition\r\n* [ActorDefinition](actordefinition.html): Intended jurisdiction for the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): Intended jurisdiction for the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): Intended jurisdiction for the charge item definition\r\n* [Citation](citation.html): Intended jurisdiction for the citation\r\n* [CodeSystem](codesystem.html): Intended jurisdiction for the code system\r\n* [ConceptMap](conceptmap.html): Intended jurisdiction for the concept map\r\n* [ConditionDefinition](conditiondefinition.html): Intended jurisdiction for the condition definition\r\n* [EventDefinition](eventdefinition.html): Intended jurisdiction for the event definition\r\n* [ExampleScenario](examplescenario.html): Intended jurisdiction for the example scenario\r\n* [GraphDefinition](graphdefinition.html): Intended jurisdiction for the graph definition\r\n* [ImplementationGuide](implementationguide.html): Intended jurisdiction for the implementation guide\r\n* [Library](library.html): Intended jurisdiction for the library\r\n* [Measure](measure.html): Intended jurisdiction for the measure\r\n* [MessageDefinition](messagedefinition.html): Intended jurisdiction for the message definition\r\n* [NamingSystem](namingsystem.html): Intended jurisdiction for the naming system\r\n* [OperationDefinition](operationdefinition.html): Intended jurisdiction for the operation definition\r\n* [PlanDefinition](plandefinition.html): Intended jurisdiction for the plan definition\r\n* [Questionnaire](questionnaire.html): Intended jurisdiction for the questionnaire\r\n* [Requirements](requirements.html): Intended jurisdiction for the requirements\r\n* [SearchParameter](searchparameter.html): Intended jurisdiction for the search parameter\r\n* [StructureDefinition](structuredefinition.html): Intended jurisdiction for the structure definition\r\n* [StructureMap](structuremap.html): Intended jurisdiction for the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): Intended jurisdiction for the terminology capabilities\r\n* [TestScript](testscript.html): Intended jurisdiction for the test script\r\n* [ValueSet](valueset.html): Intended jurisdiction for the value set\r\n", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="name", path="ActivityDefinition.name | CapabilityStatement.name | Citation.name | CodeSystem.name | CompartmentDefinition.name | ConceptMap.name | ConditionDefinition.name | EventDefinition.name | EvidenceVariable.name | ExampleScenario.name | GraphDefinition.name | ImplementationGuide.name | Library.name | Measure.name | MessageDefinition.name | NamingSystem.name | OperationDefinition.name | PlanDefinition.name | Questionnaire.name | Requirements.name | SearchParameter.name | StructureDefinition.name | StructureMap.name | TerminologyCapabilities.name | TestScript.name | ValueSet.name", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): Computationally friendly name of the activity definition\r\n* [CapabilityStatement](capabilitystatement.html): Computationally friendly name of the capability statement\r\n* [Citation](citation.html): Computationally friendly name of the citation\r\n* [CodeSystem](codesystem.html): Computationally friendly name of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): Computationally friendly name of the compartment definition\r\n* [ConceptMap](conceptmap.html): Computationally friendly name of the concept map\r\n* [ConditionDefinition](conditiondefinition.html): Computationally friendly name of the condition definition\r\n* [EventDefinition](eventdefinition.html): Computationally friendly name of the event definition\r\n* [EvidenceVariable](evidencevariable.html): Computationally friendly name of the evidence variable\r\n* [ExampleScenario](examplescenario.html): Computationally friendly name of the example scenario\r\n* [GraphDefinition](graphdefinition.html): Computationally friendly name of the graph definition\r\n* [ImplementationGuide](implementationguide.html): Computationally friendly name of the implementation guide\r\n* [Library](library.html): Computationally friendly name of the library\r\n* [Measure](measure.html): Computationally friendly name of the measure\r\n* [MessageDefinition](messagedefinition.html): Computationally friendly name of the message definition\r\n* [NamingSystem](namingsystem.html): Computationally friendly name of the naming system\r\n* [OperationDefinition](operationdefinition.html): Computationally friendly name of the operation definition\r\n* [PlanDefinition](plandefinition.html): Computationally friendly name of the plan definition\r\n* [Questionnaire](questionnaire.html): Computationally friendly name of the questionnaire\r\n* [Requirements](requirements.html): Computationally friendly name of the requirements\r\n* [SearchParameter](searchparameter.html): Computationally friendly name of the search parameter\r\n* [StructureDefinition](structuredefinition.html): Computationally friendly name of the structure definition\r\n* [StructureMap](structuremap.html): Computationally friendly name of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): Computationally friendly name of the terminology capabilities\r\n* [TestScript](testscript.html): Computationally friendly name of the test script\r\n* [ValueSet](valueset.html): Computationally friendly name of the value set\r\n", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="publisher", path="ActivityDefinition.publisher | ActorDefinition.publisher | CapabilityStatement.publisher | ChargeItemDefinition.publisher | Citation.publisher | CodeSystem.publisher | CompartmentDefinition.publisher | ConceptMap.publisher | ConditionDefinition.publisher | EventDefinition.publisher | Evidence.publisher | EvidenceReport.publisher | EvidenceVariable.publisher | ExampleScenario.publisher | GraphDefinition.publisher | ImplementationGuide.publisher | Library.publisher | Measure.publisher | MessageDefinition.publisher | NamingSystem.publisher | OperationDefinition.publisher | PlanDefinition.publisher | Questionnaire.publisher | Requirements.publisher | SearchParameter.publisher | StructureDefinition.publisher | StructureMap.publisher | TerminologyCapabilities.publisher | TestScript.publisher | ValueSet.publisher", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): Name of the publisher of the activity definition\r\n* [ActorDefinition](actordefinition.html): Name of the publisher of the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): Name of the publisher of the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): Name of the publisher of the charge item definition\r\n* [Citation](citation.html): Name of the publisher of the citation\r\n* [CodeSystem](codesystem.html): Name of the publisher of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): Name of the publisher of the compartment definition\r\n* [ConceptMap](conceptmap.html): Name of the publisher of the concept map\r\n* [ConditionDefinition](conditiondefinition.html): Name of the publisher of the condition definition\r\n* [EventDefinition](eventdefinition.html): Name of the publisher of the event definition\r\n* [Evidence](evidence.html): Name of the publisher of the evidence\r\n* [EvidenceReport](evidencereport.html): Name of the publisher of the evidence report\r\n* [EvidenceVariable](evidencevariable.html): Name of the publisher of the evidence variable\r\n* [ExampleScenario](examplescenario.html): Name of the publisher of the example scenario\r\n* [GraphDefinition](graphdefinition.html): Name of the publisher of the graph definition\r\n* [ImplementationGuide](implementationguide.html): Name of the publisher of the implementation guide\r\n* [Library](library.html): Name of the publisher of the library\r\n* [Measure](measure.html): Name of the publisher of the measure\r\n* [MessageDefinition](messagedefinition.html): Name of the publisher of the message definition\r\n* [NamingSystem](namingsystem.html): Name of the publisher of the naming system\r\n* [OperationDefinition](operationdefinition.html): Name of the publisher of the operation definition\r\n* [PlanDefinition](plandefinition.html): Name of the publisher of the plan definition\r\n* [Questionnaire](questionnaire.html): Name of the publisher of the questionnaire\r\n* [Requirements](requirements.html): Name of the publisher of the requirements\r\n* [SearchParameter](searchparameter.html): Name of the publisher of the search parameter\r\n* [StructureDefinition](structuredefinition.html): Name of the publisher of the structure definition\r\n* [StructureMap](structuremap.html): Name of the publisher of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): Name of the publisher of the terminology capabilities\r\n* [TestScript](testscript.html): Name of the publisher of the test script\r\n* [ValueSet](valueset.html): Name of the publisher of the value set\r\n", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="status", path="ActivityDefinition.status | ActorDefinition.status | CapabilityStatement.status | ChargeItemDefinition.status | Citation.status | CodeSystem.status | CompartmentDefinition.status | ConceptMap.status | ConditionDefinition.status | EventDefinition.status | Evidence.status | EvidenceReport.status | EvidenceVariable.status | ExampleScenario.status | GraphDefinition.status | ImplementationGuide.status | Library.status | Measure.status | MedicationKnowledge.status | MessageDefinition.status | NamingSystem.status | ObservationDefinition.status | OperationDefinition.status | PlanDefinition.status | Questionnaire.status | Requirements.status | SearchParameter.status | SpecimenDefinition.status | StructureDefinition.status | StructureMap.status | SubscriptionTopic.status | TerminologyCapabilities.status | TestPlan.status | TestScript.status | ValueSet.status", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The current status of the activity definition\r\n* [ActorDefinition](actordefinition.html): The current status of the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): The current status of the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The current status of the charge item definition\r\n* [Citation](citation.html): The current status of the citation\r\n* [CodeSystem](codesystem.html): The current status of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The current status of the compartment definition\r\n* [ConceptMap](conceptmap.html): The current status of the concept map\r\n* [ConditionDefinition](conditiondefinition.html): The current status of the condition definition\r\n* [EventDefinition](eventdefinition.html): The current status of the event definition\r\n* [Evidence](evidence.html): The current status of the evidence\r\n* [EvidenceReport](evidencereport.html): The current status of the evidence report\r\n* [EvidenceVariable](evidencevariable.html): The current status of the evidence variable\r\n* [ExampleScenario](examplescenario.html): The current status of the example scenario\r\n* [GraphDefinition](graphdefinition.html): The current status of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The current status of the implementation guide\r\n* [Library](library.html): The current status of the library\r\n* [Measure](measure.html): The current status of the measure\r\n* [MedicationKnowledge](medicationknowledge.html): active | inactive | entered-in-error\r\n* [MessageDefinition](messagedefinition.html): The current status of the message definition\r\n* [NamingSystem](namingsystem.html): The current status of the naming system\r\n* [ObservationDefinition](observationdefinition.html): Publication status of the ObservationDefinition: draft, active, retired, unknown\r\n* [OperationDefinition](operationdefinition.html): The current status of the operation definition\r\n* [PlanDefinition](plandefinition.html): The current status of the plan definition\r\n* [Questionnaire](questionnaire.html): The current status of the questionnaire\r\n* [Requirements](requirements.html): The current status of the requirements\r\n* [SearchParameter](searchparameter.html): The current status of the search parameter\r\n* [SpecimenDefinition](specimendefinition.html): Publication status of the SpecimenDefinition: draft, active, retired, unknown\r\n* [StructureDefinition](structuredefinition.html): The current status of the structure definition\r\n* [StructureMap](structuremap.html): The current status of the structure map\r\n* [SubscriptionTopic](subscriptiontopic.html): draft | active | retired | unknown\r\n* [TerminologyCapabilities](terminologycapabilities.html): The current status of the terminology capabilities\r\n* [TestPlan](testplan.html): The current status of the test plan\r\n* [TestScript](testscript.html): The current status of the test script\r\n* [ValueSet](valueset.html): The current status of the value set\r\n", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="title", path="ActivityDefinition.title | ActorDefinition.title | CapabilityStatement.title | ChargeItemDefinition.title | Citation.title | CodeSystem.title | ConceptMap.title | ConditionDefinition.title | EventDefinition.title | Evidence.title | EvidenceVariable.title | ImplementationGuide.title | Library.title | Measure.title | MessageDefinition.title | ObservationDefinition.title | OperationDefinition.title | PlanDefinition.title | Questionnaire.title | Requirements.title | SpecimenDefinition.title | StructureDefinition.title | StructureMap.title | SubscriptionTopic.title | TerminologyCapabilities.title | TestScript.title | ValueSet.title", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The human-friendly name of the activity definition\r\n* [ActorDefinition](actordefinition.html): The human-friendly name of the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): The human-friendly name of the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The human-friendly name of the charge item definition\r\n* [Citation](citation.html): The human-friendly name of the citation\r\n* [CodeSystem](codesystem.html): The human-friendly name of the code system\r\n* [ConceptMap](conceptmap.html): The human-friendly name of the concept map\r\n* [ConditionDefinition](conditiondefinition.html): The human-friendly name of the condition definition\r\n* [EventDefinition](eventdefinition.html): The human-friendly name of the event definition\r\n* [Evidence](evidence.html): The human-friendly name of the evidence\r\n* [EvidenceVariable](evidencevariable.html): The human-friendly name of the evidence variable\r\n* [ImplementationGuide](implementationguide.html): The human-friendly name of the implementation guide\r\n* [Library](library.html): The human-friendly name of the library\r\n* [Measure](measure.html): The human-friendly name of the measure\r\n* [MessageDefinition](messagedefinition.html): The human-friendly name of the message definition\r\n* [ObservationDefinition](observationdefinition.html): Human-friendly name of the ObservationDefinition\r\n* [OperationDefinition](operationdefinition.html): The human-friendly name of the operation definition\r\n* [PlanDefinition](plandefinition.html): The human-friendly name of the plan definition\r\n* [Questionnaire](questionnaire.html): The human-friendly name of the questionnaire\r\n* [Requirements](requirements.html): The human-friendly name of the requirements\r\n* [SpecimenDefinition](specimendefinition.html): Human-friendly name of the SpecimenDefinition\r\n* [StructureDefinition](structuredefinition.html): The human-friendly name of the structure definition\r\n* [StructureMap](structuremap.html): The human-friendly name of the structure map\r\n* [SubscriptionTopic](subscriptiontopic.html): Name for this SubscriptionTopic (Human friendly)\r\n* [TerminologyCapabilities](terminologycapabilities.html): The human-friendly name of the terminology capabilities\r\n* [TestScript](testscript.html): The human-friendly name of the test script\r\n* [ValueSet](valueset.html): The human-friendly name of the value set\r\n", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="url", path="ActivityDefinition.url | ActorDefinition.url | CapabilityStatement.url | ChargeItemDefinition.url | Citation.url | CodeSystem.url | CompartmentDefinition.url | ConceptMap.url | ConditionDefinition.url | EventDefinition.url | Evidence.url | EvidenceReport.url | EvidenceVariable.url | ExampleScenario.url | GraphDefinition.url | ImplementationGuide.url | Library.url | Measure.url | MessageDefinition.url | NamingSystem.url | ObservationDefinition.url | OperationDefinition.url | PlanDefinition.url | Questionnaire.url | Requirements.url | SearchParameter.url | SpecimenDefinition.url | StructureDefinition.url | StructureMap.url | SubscriptionTopic.url | TerminologyCapabilities.url | TestPlan.url | TestScript.url | ValueSet.url", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The uri that identifies the activity definition\r\n* [ActorDefinition](actordefinition.html): The uri that identifies the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): The uri that identifies the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The uri that identifies the charge item definition\r\n* [Citation](citation.html): The uri that identifies the citation\r\n* [CodeSystem](codesystem.html): The uri that identifies the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The uri that identifies the compartment definition\r\n* [ConceptMap](conceptmap.html): The URI that identifies the concept map\r\n* [ConditionDefinition](conditiondefinition.html): The uri that identifies the condition definition\r\n* [EventDefinition](eventdefinition.html): The uri that identifies the event definition\r\n* [Evidence](evidence.html): The uri that identifies the evidence\r\n* [EvidenceReport](evidencereport.html): The uri that identifies the evidence report\r\n* [EvidenceVariable](evidencevariable.html): The uri that identifies the evidence variable\r\n* [ExampleScenario](examplescenario.html): The uri that identifies the example scenario\r\n* [GraphDefinition](graphdefinition.html): The uri that identifies the graph definition\r\n* [ImplementationGuide](implementationguide.html): The uri that identifies the implementation guide\r\n* [Library](library.html): The uri that identifies the library\r\n* [Measure](measure.html): The uri that identifies the measure\r\n* [MessageDefinition](messagedefinition.html): The uri that identifies the message definition\r\n* [NamingSystem](namingsystem.html): The uri that identifies the naming system\r\n* [ObservationDefinition](observationdefinition.html): The uri that identifies the observation definition\r\n* [OperationDefinition](operationdefinition.html): The uri that identifies the operation definition\r\n* [PlanDefinition](plandefinition.html): The uri that identifies the plan definition\r\n* [Questionnaire](questionnaire.html): The uri that identifies the questionnaire\r\n* [Requirements](requirements.html): The uri that identifies the requirements\r\n* [SearchParameter](searchparameter.html): The uri that identifies the search parameter\r\n* [SpecimenDefinition](specimendefinition.html): The uri that identifies the specimen definition\r\n* [StructureDefinition](structuredefinition.html): The uri that identifies the structure definition\r\n* [StructureMap](structuremap.html): The uri that identifies the structure map\r\n* [SubscriptionTopic](subscriptiontopic.html): Logical canonical URL to reference this SubscriptionTopic (globally unique)\r\n* [TerminologyCapabilities](terminologycapabilities.html): The uri that identifies the terminology capabilities\r\n* [TestPlan](testplan.html): The uri that identifies the test plan\r\n* [TestScript](testscript.html): The uri that identifies the test script\r\n* [ValueSet](valueset.html): The uri that identifies the value set\r\n", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="version", path="ActivityDefinition.version | ActorDefinition.version | CapabilityStatement.version | ChargeItemDefinition.version | Citation.version | CodeSystem.version | CompartmentDefinition.version | ConceptMap.version | ConditionDefinition.version | EventDefinition.version | Evidence.version | EvidenceVariable.version | ExampleScenario.version | GraphDefinition.version | ImplementationGuide.version | Library.version | Measure.version | MessageDefinition.version | NamingSystem.version | OperationDefinition.version | PlanDefinition.version | Questionnaire.version | Requirements.version | SearchParameter.version | StructureDefinition.version | StructureMap.version | SubscriptionTopic.version | TerminologyCapabilities.version | TestScript.version | ValueSet.version", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The business version of the activity definition\r\n* [ActorDefinition](actordefinition.html): The business version of the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): The business version of the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The business version of the charge item definition\r\n* [Citation](citation.html): The business version of the citation\r\n* [CodeSystem](codesystem.html): The business version of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The business version of the compartment definition\r\n* [ConceptMap](conceptmap.html): The business version of the concept map\r\n* [ConditionDefinition](conditiondefinition.html): The business version of the condition definition\r\n* [EventDefinition](eventdefinition.html): The business version of the event definition\r\n* [Evidence](evidence.html): The business version of the evidence\r\n* [EvidenceVariable](evidencevariable.html): The business version of the evidence variable\r\n* [ExampleScenario](examplescenario.html): The business version of the example scenario\r\n* [GraphDefinition](graphdefinition.html): The business version of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The business version of the implementation guide\r\n* [Library](library.html): The business version of the library\r\n* [Measure](measure.html): The business version of the measure\r\n* [MessageDefinition](messagedefinition.html): The business version of the message definition\r\n* [NamingSystem](namingsystem.html): The business version of the naming system\r\n* [OperationDefinition](operationdefinition.html): The business version of the operation definition\r\n* [PlanDefinition](plandefinition.html): The business version of the plan definition\r\n* [Questionnaire](questionnaire.html): The business version of the questionnaire\r\n* [Requirements](requirements.html): The business version of the requirements\r\n* [SearchParameter](searchparameter.html): The business version of the search parameter\r\n* [StructureDefinition](structuredefinition.html): The business version of the structure definition\r\n* [StructureMap](structuremap.html): The business version of the structure map\r\n* [SubscriptionTopic](subscriptiontopic.html): Business version of the SubscriptionTopic\r\n* [TerminologyCapabilities](terminologycapabilities.html): The business version of the terminology capabilities\r\n* [TestScript](testscript.html): The business version of the test script\r\n* [ValueSet](valueset.html): The business version of the value set\r\n", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="derived-from", path="ActivityDefinition.relatedArtifact.where(type='derived-from').resource | CodeSystem.relatedArtifact.where(type='derived-from').resource | ConceptMap.relatedArtifact.where(type='derived-from').resource | EventDefinition.relatedArtifact.where(type='derived-from').resource | EvidenceVariable.relatedArtifact.where(type='derived-from').resource | Library.relatedArtifact.where(type='derived-from').resource | Measure.relatedArtifact.where(type='derived-from').resource | NamingSystem.relatedArtifact.where(type='derived-from').resource | PlanDefinition.relatedArtifact.where(type='derived-from').resource | ValueSet.relatedArtifact.where(type='derived-from').resource", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): What resource is being referenced\r\n* [CodeSystem](codesystem.html): A resource that the CodeSystem is derived from\r\n* [ConceptMap](conceptmap.html): A resource that the ConceptMap is derived from\r\n* [EventDefinition](eventdefinition.html): What resource is being referenced\r\n* [EvidenceVariable](evidencevariable.html): What resource is being referenced\r\n* [Library](library.html): What resource is being referenced\r\n* [Measure](measure.html): What resource is being referenced\r\n* [NamingSystem](namingsystem.html): A resource that the NamingSystem is derived from\r\n* [PlanDefinition](plandefinition.html): What resource is being referenced\r\n* [ValueSet](valueset.html): A resource that the ValueSet is derived from\r\n", type="reference", target={Account.class, ActivityDefinition.class, ActorDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, ArtifactAssessment.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BiologicallyDerivedProductDispense.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CarePlan.class, CareTeam.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceAssociation.class, DeviceDefinition.class, DeviceDispense.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentReference.class, Encounter.class, EncounterHistory.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, FormularyItem.class, GenomicStudy.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingSelection.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryItem.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationStatement.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Parameters.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestOrchestration.class, Requirements.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestPlan.class, TestReport.class, TestScript.class, Transport.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_DERIVED_FROM = "derived-from";
    public static final ReferenceClientParam DERIVED_FROM = new ReferenceClientParam("derived-from");
    public static final Include INCLUDE_DERIVED_FROM = new Include("ValueSet:derived-from").toLocked();
    @SearchParamDefinition(name="effective", path="ActivityDefinition.effectivePeriod | ChargeItemDefinition.applicability.effectivePeriod | Citation.effectivePeriod | CodeSystem.effectivePeriod | ConceptMap.effectivePeriod | EventDefinition.effectivePeriod | Library.effectivePeriod | Measure.effectivePeriod | NamingSystem.effectivePeriod | PlanDefinition.effectivePeriod | Questionnaire.effectivePeriod | ValueSet.effectivePeriod", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The time during which the activity definition is intended to be in use\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The time during which the charge item definition is intended to be in use\r\n* [Citation](citation.html): The time during which the citation is intended to be in use\r\n* [CodeSystem](codesystem.html): The time during which the CodeSystem is intended to be in use\r\n* [ConceptMap](conceptmap.html): The time during which the ConceptMap is intended to be in use\r\n* [EventDefinition](eventdefinition.html): The time during which the event definition is intended to be in use\r\n* [Library](library.html): The time during which the library is intended to be in use\r\n* [Measure](measure.html): The time during which the measure is intended to be in use\r\n* [NamingSystem](namingsystem.html): The time during which the NamingSystem is intended to be in use\r\n* [PlanDefinition](plandefinition.html): The time during which the plan definition is intended to be in use\r\n* [Questionnaire](questionnaire.html): The time during which the questionnaire is intended to be in use\r\n* [ValueSet](valueset.html): The time during which the ValueSet is intended to be in use\r\n", type="date")
    public static final String SP_EFFECTIVE = "effective";
    public static final DateClientParam EFFECTIVE = new DateClientParam("effective");
    @SearchParamDefinition(name="predecessor", path="ActivityDefinition.relatedArtifact.where(type='predecessor').resource | CodeSystem.relatedArtifact.where(type='predecessor').resource | ConceptMap.relatedArtifact.where(type='predecessor').resource | EventDefinition.relatedArtifact.where(type='predecessor').resource | EvidenceVariable.relatedArtifact.where(type='predecessor').resource | Library.relatedArtifact.where(type='predecessor').resource | Measure.relatedArtifact.where(type='predecessor').resource | NamingSystem.relatedArtifact.where(type='predecessor').resource | PlanDefinition.relatedArtifact.where(type='predecessor').resource | ValueSet.relatedArtifact.where(type='predecessor').resource", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): What resource is being referenced\r\n* [CodeSystem](codesystem.html): The predecessor of the CodeSystem\r\n* [ConceptMap](conceptmap.html): The predecessor of the ConceptMap\r\n* [EventDefinition](eventdefinition.html): What resource is being referenced\r\n* [EvidenceVariable](evidencevariable.html): What resource is being referenced\r\n* [Library](library.html): What resource is being referenced\r\n* [Measure](measure.html): What resource is being referenced\r\n* [NamingSystem](namingsystem.html): The predecessor of the NamingSystem\r\n* [PlanDefinition](plandefinition.html): What resource is being referenced\r\n* [ValueSet](valueset.html): The predecessor of the ValueSet\r\n", type="reference", target={Account.class, ActivityDefinition.class, ActorDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, ArtifactAssessment.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BiologicallyDerivedProductDispense.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CarePlan.class, CareTeam.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceAssociation.class, DeviceDefinition.class, DeviceDispense.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentReference.class, Encounter.class, EncounterHistory.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, FormularyItem.class, GenomicStudy.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingSelection.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryItem.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationStatement.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Parameters.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestOrchestration.class, Requirements.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestPlan.class, TestReport.class, TestScript.class, Transport.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_PREDECESSOR = "predecessor";
    public static final ReferenceClientParam PREDECESSOR = new ReferenceClientParam("predecessor");
    public static final Include INCLUDE_PREDECESSOR = new Include("ValueSet:predecessor").toLocked();
    @SearchParamDefinition(name="topic", path="ActivityDefinition.topic | CodeSystem.topic | ConceptMap.topic | EventDefinition.topic | Library.topic | Measure.topic | NamingSystem.topic | PlanDefinition.topic | ValueSet.topic", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): Topics associated with the module\r\n* [CodeSystem](codesystem.html): Topics associated with the CodeSystem\r\n* [ConceptMap](conceptmap.html): Topics associated with the ConceptMap\r\n* [EventDefinition](eventdefinition.html): Topics associated with the module\r\n* [EvidenceVariable](evidencevariable.html): Topics associated with the EvidenceVariable\r\n* [Library](library.html): Topics associated with the module\r\n* [Measure](measure.html): Topics associated with the measure\r\n* [NamingSystem](namingsystem.html): Topics associated with the NamingSystem\r\n* [PlanDefinition](plandefinition.html): Topics associated with the module\r\n* [ValueSet](valueset.html): Topics associated with the ValueSet\r\n", type="token")
    public static final String SP_TOPIC = "topic";
    public static final TokenClientParam TOPIC = new TokenClientParam("topic");
    @SearchParamDefinition(name="code", path="ValueSet.expansion.contains.code | ValueSet.compose.include.concept.code", description="This special parameter searches for codes in the value set. See additional notes on the ValueSet resource", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="expansion", path="ValueSet.expansion.identifier", description="Identifies the value set expansion (business identifier)", type="uri")
    public static final String SP_EXPANSION = "expansion";
    public static final UriClientParam EXPANSION = new UriClientParam("expansion");
    @SearchParamDefinition(name="reference", path="ValueSet.compose.include.system", description="A code system included or excluded in the value set or an imported value set", type="uri")
    public static final String SP_REFERENCE = "reference";
    public static final UriClientParam REFERENCE = new UriClientParam("reference");

    public ValueSet() {
    }

    public ValueSet(Enumerations.PublicationStatus status) {
        this.setStatus(status);
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public ValueSet setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public ValueSet setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    @Override
    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    @Override
    public ValueSet setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    @Override
    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    @Override
    public ValueSet addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    @Override
    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public ValueSet setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public ValueSet setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public DataType getVersionAlgorithm() {
        return this.versionAlgorithm;
    }

    @Override
    public StringType getVersionAlgorithmStringType() throws FHIRException {
        if (this.versionAlgorithm == null) {
            this.versionAlgorithm = new StringType();
        }
        if (!(this.versionAlgorithm instanceof StringType)) {
            throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.versionAlgorithm.getClass().getName() + " was encountered");
        }
        return (StringType)this.versionAlgorithm;
    }

    @Override
    public boolean hasVersionAlgorithmStringType() {
        return this != null && this.versionAlgorithm instanceof StringType;
    }

    @Override
    public Coding getVersionAlgorithmCoding() throws FHIRException {
        if (this.versionAlgorithm == null) {
            this.versionAlgorithm = new Coding();
        }
        if (!(this.versionAlgorithm instanceof Coding)) {
            throw new FHIRException("Type mismatch: the type Coding was expected, but " + this.versionAlgorithm.getClass().getName() + " was encountered");
        }
        return (Coding)this.versionAlgorithm;
    }

    @Override
    public boolean hasVersionAlgorithmCoding() {
        return this != null && this.versionAlgorithm instanceof Coding;
    }

    @Override
    public boolean hasVersionAlgorithm() {
        return this.versionAlgorithm != null && !this.versionAlgorithm.isEmpty();
    }

    @Override
    public ValueSet setVersionAlgorithm(DataType value) {
        if (value != null && !(value instanceof StringType) && !(value instanceof Coding)) {
            throw new FHIRException("Not the right type for ValueSet.versionAlgorithm[x]: " + value.fhirType());
        }
        this.versionAlgorithm = value;
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public ValueSet setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public ValueSet setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    @Override
    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public ValueSet setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    @Override
    public ValueSet setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public ValueSet setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public ValueSet setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public ValueSet setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public ValueSet setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public ValueSet setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public ValueSet setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public ValueSet setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public ValueSet setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        return this.contact;
    }

    @Override
    public ValueSet setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public ValueSet addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public ValueSet setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public ValueSet setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        return this.useContext;
    }

    @Override
    public ValueSet setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public ValueSet addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        return this.jurisdiction;
    }

    @Override
    public ValueSet setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public ValueSet addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    public BooleanType getImmutableElement() {
        if (this.immutable == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.immutable");
            }
            if (Configuration.doAutoCreate()) {
                this.immutable = new BooleanType();
            }
        }
        return this.immutable;
    }

    public boolean hasImmutableElement() {
        return this.immutable != null && !this.immutable.isEmpty();
    }

    public boolean hasImmutable() {
        return this.immutable != null && !this.immutable.isEmpty();
    }

    public ValueSet setImmutableElement(BooleanType value) {
        this.immutable = value;
        return this;
    }

    public boolean getImmutable() {
        return this.immutable == null || this.immutable.isEmpty() ? false : (Boolean)this.immutable.getValue();
    }

    public ValueSet setImmutable(boolean value) {
        if (this.immutable == null) {
            this.immutable = new BooleanType();
        }
        this.immutable.setValue((Object)value);
        return this;
    }

    @Override
    public MarkdownType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new MarkdownType();
            }
        }
        return this.purpose;
    }

    @Override
    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    @Override
    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    @Override
    public ValueSet setPurposeElement(MarkdownType value) {
        this.purpose = value;
        return this;
    }

    @Override
    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    @Override
    public ValueSet setPurpose(String value) {
        if (Utilities.noString((String)value)) {
            this.purpose = null;
        } else {
            if (this.purpose == null) {
                this.purpose = new MarkdownType();
            }
            this.purpose.setValue(value);
        }
        return this;
    }

    @Override
    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    @Override
    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    @Override
    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    @Override
    public ValueSet setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    @Override
    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    @Override
    public ValueSet setCopyright(String value) {
        if (Utilities.noString((String)value)) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getCopyrightLabelElement() {
        if (this.copyrightLabel == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.copyrightLabel");
            }
            if (Configuration.doAutoCreate()) {
                this.copyrightLabel = new StringType();
            }
        }
        return this.copyrightLabel;
    }

    @Override
    public boolean hasCopyrightLabelElement() {
        return this.copyrightLabel != null && !this.copyrightLabel.isEmpty();
    }

    @Override
    public boolean hasCopyrightLabel() {
        return this.copyrightLabel != null && !this.copyrightLabel.isEmpty();
    }

    @Override
    public ValueSet setCopyrightLabelElement(StringType value) {
        this.copyrightLabel = value;
        return this;
    }

    @Override
    public String getCopyrightLabel() {
        return this.copyrightLabel == null ? null : (String)this.copyrightLabel.getValue();
    }

    @Override
    public ValueSet setCopyrightLabel(String value) {
        if (Utilities.noString((String)value)) {
            this.copyrightLabel = null;
        } else {
            if (this.copyrightLabel == null) {
                this.copyrightLabel = new StringType();
            }
            this.copyrightLabel.setValue(value);
        }
        return this;
    }

    @Override
    public DateType getApprovalDateElement() {
        if (this.approvalDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.approvalDate");
            }
            if (Configuration.doAutoCreate()) {
                this.approvalDate = new DateType();
            }
        }
        return this.approvalDate;
    }

    @Override
    public boolean hasApprovalDateElement() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    @Override
    public boolean hasApprovalDate() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    @Override
    public ValueSet setApprovalDateElement(DateType value) {
        this.approvalDate = value;
        return this;
    }

    @Override
    public Date getApprovalDate() {
        return this.approvalDate == null ? null : (Date)this.approvalDate.getValue();
    }

    @Override
    public ValueSet setApprovalDate(Date value) {
        if (value == null) {
            this.approvalDate = null;
        } else {
            if (this.approvalDate == null) {
                this.approvalDate = new DateType();
            }
            this.approvalDate.setValue(value);
        }
        return this;
    }

    @Override
    public DateType getLastReviewDateElement() {
        if (this.lastReviewDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.lastReviewDate");
            }
            if (Configuration.doAutoCreate()) {
                this.lastReviewDate = new DateType();
            }
        }
        return this.lastReviewDate;
    }

    @Override
    public boolean hasLastReviewDateElement() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    @Override
    public boolean hasLastReviewDate() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    @Override
    public ValueSet setLastReviewDateElement(DateType value) {
        this.lastReviewDate = value;
        return this;
    }

    @Override
    public Date getLastReviewDate() {
        return this.lastReviewDate == null ? null : (Date)this.lastReviewDate.getValue();
    }

    @Override
    public ValueSet setLastReviewDate(Date value) {
        if (value == null) {
            this.lastReviewDate = null;
        } else {
            if (this.lastReviewDate == null) {
                this.lastReviewDate = new DateType();
            }
            this.lastReviewDate.setValue(value);
        }
        return this;
    }

    @Override
    public Period getEffectivePeriod() {
        if (this.effectivePeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.effectivePeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.effectivePeriod = new Period();
            }
        }
        return this.effectivePeriod;
    }

    @Override
    public boolean hasEffectivePeriod() {
        return this.effectivePeriod != null && !this.effectivePeriod.isEmpty();
    }

    @Override
    public ValueSet setEffectivePeriod(Period value) {
        this.effectivePeriod = value;
        return this;
    }

    @Override
    public List<CodeableConcept> getTopic() {
        if (this.topic == null) {
            this.topic = new ArrayList<CodeableConcept>();
        }
        return this.topic;
    }

    @Override
    public ValueSet setTopic(List<CodeableConcept> theTopic) {
        this.topic = theTopic;
        return this;
    }

    @Override
    public boolean hasTopic() {
        if (this.topic == null) {
            return false;
        }
        for (CodeableConcept item : this.topic) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addTopic() {
        CodeableConcept t = new CodeableConcept();
        if (this.topic == null) {
            this.topic = new ArrayList<CodeableConcept>();
        }
        this.topic.add(t);
        return t;
    }

    @Override
    public ValueSet addTopic(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.topic == null) {
            this.topic = new ArrayList<CodeableConcept>();
        }
        this.topic.add(t);
        return this;
    }

    @Override
    public CodeableConcept getTopicFirstRep() {
        if (this.getTopic().isEmpty()) {
            this.addTopic();
        }
        return this.getTopic().get(0);
    }

    @Override
    public List<ContactDetail> getAuthor() {
        if (this.author == null) {
            this.author = new ArrayList<ContactDetail>();
        }
        return this.author;
    }

    @Override
    public ValueSet setAuthor(List<ContactDetail> theAuthor) {
        this.author = theAuthor;
        return this;
    }

    @Override
    public boolean hasAuthor() {
        if (this.author == null) {
            return false;
        }
        for (ContactDetail item : this.author) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addAuthor() {
        ContactDetail t = new ContactDetail();
        if (this.author == null) {
            this.author = new ArrayList<ContactDetail>();
        }
        this.author.add(t);
        return t;
    }

    @Override
    public ValueSet addAuthor(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.author == null) {
            this.author = new ArrayList<ContactDetail>();
        }
        this.author.add(t);
        return this;
    }

    @Override
    public ContactDetail getAuthorFirstRep() {
        if (this.getAuthor().isEmpty()) {
            this.addAuthor();
        }
        return this.getAuthor().get(0);
    }

    @Override
    public List<ContactDetail> getEditor() {
        if (this.editor == null) {
            this.editor = new ArrayList<ContactDetail>();
        }
        return this.editor;
    }

    @Override
    public ValueSet setEditor(List<ContactDetail> theEditor) {
        this.editor = theEditor;
        return this;
    }

    @Override
    public boolean hasEditor() {
        if (this.editor == null) {
            return false;
        }
        for (ContactDetail item : this.editor) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addEditor() {
        ContactDetail t = new ContactDetail();
        if (this.editor == null) {
            this.editor = new ArrayList<ContactDetail>();
        }
        this.editor.add(t);
        return t;
    }

    @Override
    public ValueSet addEditor(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.editor == null) {
            this.editor = new ArrayList<ContactDetail>();
        }
        this.editor.add(t);
        return this;
    }

    @Override
    public ContactDetail getEditorFirstRep() {
        if (this.getEditor().isEmpty()) {
            this.addEditor();
        }
        return this.getEditor().get(0);
    }

    @Override
    public List<ContactDetail> getReviewer() {
        if (this.reviewer == null) {
            this.reviewer = new ArrayList<ContactDetail>();
        }
        return this.reviewer;
    }

    @Override
    public ValueSet setReviewer(List<ContactDetail> theReviewer) {
        this.reviewer = theReviewer;
        return this;
    }

    @Override
    public boolean hasReviewer() {
        if (this.reviewer == null) {
            return false;
        }
        for (ContactDetail item : this.reviewer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addReviewer() {
        ContactDetail t = new ContactDetail();
        if (this.reviewer == null) {
            this.reviewer = new ArrayList<ContactDetail>();
        }
        this.reviewer.add(t);
        return t;
    }

    @Override
    public ValueSet addReviewer(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.reviewer == null) {
            this.reviewer = new ArrayList<ContactDetail>();
        }
        this.reviewer.add(t);
        return this;
    }

    @Override
    public ContactDetail getReviewerFirstRep() {
        if (this.getReviewer().isEmpty()) {
            this.addReviewer();
        }
        return this.getReviewer().get(0);
    }

    @Override
    public List<ContactDetail> getEndorser() {
        if (this.endorser == null) {
            this.endorser = new ArrayList<ContactDetail>();
        }
        return this.endorser;
    }

    @Override
    public ValueSet setEndorser(List<ContactDetail> theEndorser) {
        this.endorser = theEndorser;
        return this;
    }

    @Override
    public boolean hasEndorser() {
        if (this.endorser == null) {
            return false;
        }
        for (ContactDetail item : this.endorser) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addEndorser() {
        ContactDetail t = new ContactDetail();
        if (this.endorser == null) {
            this.endorser = new ArrayList<ContactDetail>();
        }
        this.endorser.add(t);
        return t;
    }

    @Override
    public ValueSet addEndorser(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.endorser == null) {
            this.endorser = new ArrayList<ContactDetail>();
        }
        this.endorser.add(t);
        return this;
    }

    @Override
    public ContactDetail getEndorserFirstRep() {
        if (this.getEndorser().isEmpty()) {
            this.addEndorser();
        }
        return this.getEndorser().get(0);
    }

    @Override
    public List<RelatedArtifact> getRelatedArtifact() {
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        return this.relatedArtifact;
    }

    @Override
    public ValueSet setRelatedArtifact(List<RelatedArtifact> theRelatedArtifact) {
        this.relatedArtifact = theRelatedArtifact;
        return this;
    }

    @Override
    public boolean hasRelatedArtifact() {
        if (this.relatedArtifact == null) {
            return false;
        }
        for (RelatedArtifact item : this.relatedArtifact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public RelatedArtifact addRelatedArtifact() {
        RelatedArtifact t = new RelatedArtifact();
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        this.relatedArtifact.add(t);
        return t;
    }

    @Override
    public ValueSet addRelatedArtifact(RelatedArtifact t) {
        if (t == null) {
            return this;
        }
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        this.relatedArtifact.add(t);
        return this;
    }

    @Override
    public RelatedArtifact getRelatedArtifactFirstRep() {
        if (this.getRelatedArtifact().isEmpty()) {
            this.addRelatedArtifact();
        }
        return this.getRelatedArtifact().get(0);
    }

    public ValueSetComposeComponent getCompose() {
        if (this.compose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.compose");
            }
            if (Configuration.doAutoCreate()) {
                this.compose = new ValueSetComposeComponent();
            }
        }
        return this.compose;
    }

    public boolean hasCompose() {
        return this.compose != null && !this.compose.isEmpty();
    }

    public ValueSet setCompose(ValueSetComposeComponent value) {
        this.compose = value;
        return this;
    }

    public ValueSetExpansionComponent getExpansion() {
        if (this.expansion == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.expansion");
            }
            if (Configuration.doAutoCreate()) {
                this.expansion = new ValueSetExpansionComponent();
            }
        }
        return this.expansion;
    }

    public boolean hasExpansion() {
        return this.expansion != null && !this.expansion.isEmpty();
    }

    public ValueSet setExpansion(ValueSetExpansionComponent value) {
        this.expansion = value;
        return this;
    }

    public ValueSetScopeComponent getScope() {
        if (this.scope == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.scope");
            }
            if (Configuration.doAutoCreate()) {
                this.scope = new ValueSetScopeComponent();
            }
        }
        return this.scope;
    }

    public boolean hasScope() {
        return this.scope != null && !this.scope.isEmpty();
    }

    public ValueSet setScope(ValueSetScopeComponent value) {
        this.scope = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this value set when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which an authoritative instance of this value set is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the value set is stored on different servers.", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this value set when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the value set when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the value set author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version));
        children.add(new Property("versionAlgorithm[x]", "string|Coding", "Indicates the mechanism used to compare versions to determine which ValueSet is more current.", 0, 1, this.versionAlgorithm));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the value set. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the value set.", 0, 1, this.title));
        children.add(new Property(SP_STATUS, SP_CODE, "The status of this value set. Enables tracking the life-cycle of the content. The status of the value set applies to the value set definition (ValueSet.compose) and the associated ValueSet metadata. Expansions do not have a state.", 0, 1, this.status));
        children.add(new Property("experimental", "boolean", "A Boolean value to indicate that this value set is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property(SP_DATE, "dateTime", "The date (and optionally time) when the value set metadata or content logical definition (.compose) was created or revised.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the organization or individual responsible for the release and ongoing maintenance of the value set.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the value set from a consumer's perspective. The textual description specifies the span of meanings for concepts to be included within the Value Set Expansion, and also may specify the intended use and limitations of the Value Set.", 0, 1, this.description));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate value set instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the value set is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("immutable", "boolean", "If this is set to 'true', then no new versions of the content logical definition can be created.  Note: Other metadata might still change.", 0, 1, this.immutable));
        children.add(new Property("purpose", "markdown", "Explanation of why this value set is needed and why it has been designed as it has.", 0, 1, this.purpose));
        children.add(new Property("copyright", "markdown", "A copyright statement relating to the value set and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the value set.", 0, 1, this.copyright));
        children.add(new Property("copyrightLabel", "string", "A short string (<50 characters), suitable for inclusion in a page footer that identifies the copyright holder, effective period, and optionally whether rights are resctricted. (e.g. 'All rights reserved', 'Some rights reserved').", 0, 1, this.copyrightLabel));
        children.add(new Property("approvalDate", SP_DATE, "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate));
        children.add(new Property("lastReviewDate", SP_DATE, "The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.", 0, 1, this.lastReviewDate));
        children.add(new Property("effectivePeriod", "Period", "The period during which the ValueSet content was or is planned to be in active use.", 0, 1, this.effectivePeriod));
        children.add(new Property(SP_TOPIC, "CodeableConcept", "Descriptions related to the content of the ValueSet. Topics provide a high-level categorization as well as keywords for the ValueSet that can be useful for filtering and searching.", 0, Integer.MAX_VALUE, this.topic));
        children.add(new Property("author", "ContactDetail", "An individiual or organization primarily involved in the creation and maintenance of the ValueSet.", 0, Integer.MAX_VALUE, this.author));
        children.add(new Property("editor", "ContactDetail", "An individual or organization primarily responsible for internal coherence of the ValueSet.", 0, Integer.MAX_VALUE, this.editor));
        children.add(new Property("reviewer", "ContactDetail", "An individual or organization asserted by the publisher to be primarily responsible for review of some aspect of the ValueSet.", 0, Integer.MAX_VALUE, this.reviewer));
        children.add(new Property("endorser", "ContactDetail", "An individual or organization asserted by the publisher to be responsible for officially endorsing the ValueSet for use in some setting.", 0, Integer.MAX_VALUE, this.endorser));
        children.add(new Property("relatedArtifact", "RelatedArtifact", "Related artifacts such as additional documentation, justification, dependencies, bibliographic references, and predecessor and successor artifacts.", 0, Integer.MAX_VALUE, this.relatedArtifact));
        children.add(new Property("compose", "", "A set of criteria that define the contents of the value set by including or excluding codes selected from the specified code system(s) that the value set draws from. This is also known as the Content Logical Definition (CLD).", 0, 1, this.compose));
        children.add(new Property(SP_EXPANSION, "", "A value set can also be \"expanded\", where the value set is turned into a simple collection of enumerated codes. This element holds the expansion, if it has been performed.", 0, 1, this.expansion));
        children.add(new Property("scope", "", "Description of the semantic space the Value Set Expansion is intended to cover and should further clarify the text in ValueSet.description.", 0, 1, this.scope));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this value set when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which an authoritative instance of this value set is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the value set is stored on different servers.", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this value set when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the value set when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the value set author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version);
            }
            case -115699031: {
                return new Property("versionAlgorithm[x]", "string|Coding", "Indicates the mechanism used to compare versions to determine which ValueSet is more current.", 0, 1, this.versionAlgorithm);
            }
            case 1508158071: {
                return new Property("versionAlgorithm[x]", "string|Coding", "Indicates the mechanism used to compare versions to determine which ValueSet is more current.", 0, 1, this.versionAlgorithm);
            }
            case 1836908904: {
                return new Property("versionAlgorithm[x]", "string", "Indicates the mechanism used to compare versions to determine which ValueSet is more current.", 0, 1, this.versionAlgorithm);
            }
            case 1373807809: {
                return new Property("versionAlgorithm[x]", "Coding", "Indicates the mechanism used to compare versions to determine which ValueSet is more current.", 0, 1, this.versionAlgorithm);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the value set. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the value set.", 0, 1, this.title);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "The status of this value set. Enables tracking the life-cycle of the content. The status of the value set applies to the value set definition (ValueSet.compose) and the associated ValueSet metadata. Expansions do not have a state.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A Boolean value to indicate that this value set is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date (and optionally time) when the value set metadata or content logical definition (.compose) was created or revised.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the organization or individual responsible for the release and ongoing maintenance of the value set.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the value set from a consumer's perspective. The textual description specifies the span of meanings for concepts to be included within the Value Set Expansion, and also may specify the intended use and limitations of the Value Set.", 0, 1, this.description);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate value set instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the value set is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case 1596987778: {
                return new Property("immutable", "boolean", "If this is set to 'true', then no new versions of the content logical definition can be created.  Note: Other metadata might still change.", 0, 1, this.immutable);
            }
            case -220463842: {
                return new Property("purpose", "markdown", "Explanation of why this value set is needed and why it has been designed as it has.", 0, 1, this.purpose);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "A copyright statement relating to the value set and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the value set.", 0, 1, this.copyright);
            }
            case 765157229: {
                return new Property("copyrightLabel", "string", "A short string (<50 characters), suitable for inclusion in a page footer that identifies the copyright holder, effective period, and optionally whether rights are resctricted. (e.g. 'All rights reserved', 'Some rights reserved').", 0, 1, this.copyrightLabel);
            }
            case 223539345: {
                return new Property("approvalDate", SP_DATE, "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate);
            }
            case -1687512484: {
                return new Property("lastReviewDate", SP_DATE, "The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.", 0, 1, this.lastReviewDate);
            }
            case -403934648: {
                return new Property("effectivePeriod", "Period", "The period during which the ValueSet content was or is planned to be in active use.", 0, 1, this.effectivePeriod);
            }
            case 110546223: {
                return new Property(SP_TOPIC, "CodeableConcept", "Descriptions related to the content of the ValueSet. Topics provide a high-level categorization as well as keywords for the ValueSet that can be useful for filtering and searching.", 0, Integer.MAX_VALUE, this.topic);
            }
            case -1406328437: {
                return new Property("author", "ContactDetail", "An individiual or organization primarily involved in the creation and maintenance of the ValueSet.", 0, Integer.MAX_VALUE, this.author);
            }
            case -1307827859: {
                return new Property("editor", "ContactDetail", "An individual or organization primarily responsible for internal coherence of the ValueSet.", 0, Integer.MAX_VALUE, this.editor);
            }
            case -261190139: {
                return new Property("reviewer", "ContactDetail", "An individual or organization asserted by the publisher to be primarily responsible for review of some aspect of the ValueSet.", 0, Integer.MAX_VALUE, this.reviewer);
            }
            case 1740277666: {
                return new Property("endorser", "ContactDetail", "An individual or organization asserted by the publisher to be responsible for officially endorsing the ValueSet for use in some setting.", 0, Integer.MAX_VALUE, this.endorser);
            }
            case 666807069: {
                return new Property("relatedArtifact", "RelatedArtifact", "Related artifacts such as additional documentation, justification, dependencies, bibliographic references, and predecessor and successor artifacts.", 0, Integer.MAX_VALUE, this.relatedArtifact);
            }
            case 950497682: {
                return new Property("compose", "", "A set of criteria that define the contents of the value set by including or excluding codes selected from the specified code system(s) that the value set draws from. This is also known as the Content Logical Definition (CLD).", 0, 1, this.compose);
            }
            case 17878207: {
                return new Property(SP_EXPANSION, "", "A value set can also be \"expanded\", where the value set is turned into a simple collection of enumerated codes. This element holds the expansion, if it has been performed.", 0, 1, this.expansion);
            }
            case 109264468: {
                return new Property("scope", "", "Description of the semantic space the Value Set Expansion is intended to cover and should further clarify the text in ValueSet.description.", 0, 1, this.scope);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 1508158071: {
                Base[] baseArray;
                if (this.versionAlgorithm == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.versionAlgorithm;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.name;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.title;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case 1596987778: {
                Base[] baseArray;
                if (this.immutable == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.immutable;
                }
                return baseArray;
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.purpose;
                }
                return baseArray;
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.copyright;
                }
                return baseArray;
            }
            case 765157229: {
                Base[] baseArray;
                if (this.copyrightLabel == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.copyrightLabel;
                }
                return baseArray;
            }
            case 223539345: {
                Base[] baseArray;
                if (this.approvalDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.approvalDate;
                }
                return baseArray;
            }
            case -1687512484: {
                Base[] baseArray;
                if (this.lastReviewDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.lastReviewDate;
                }
                return baseArray;
            }
            case -403934648: {
                Base[] baseArray;
                if (this.effectivePeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray18 = new Base[1];
                    baseArray = baseArray18;
                    baseArray18[0] = this.effectivePeriod;
                }
                return baseArray;
            }
            case 110546223: {
                return this.topic == null ? new Base[]{} : this.topic.toArray(new Base[this.topic.size()]);
            }
            case -1406328437: {
                return this.author == null ? new Base[]{} : this.author.toArray(new Base[this.author.size()]);
            }
            case -1307827859: {
                return this.editor == null ? new Base[]{} : this.editor.toArray(new Base[this.editor.size()]);
            }
            case -261190139: {
                return this.reviewer == null ? new Base[]{} : this.reviewer.toArray(new Base[this.reviewer.size()]);
            }
            case 1740277666: {
                return this.endorser == null ? new Base[]{} : this.endorser.toArray(new Base[this.endorser.size()]);
            }
            case 666807069: {
                return this.relatedArtifact == null ? new Base[]{} : this.relatedArtifact.toArray(new Base[this.relatedArtifact.size()]);
            }
            case 950497682: {
                Base[] baseArray;
                if (this.compose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray19 = new Base[1];
                    baseArray = baseArray19;
                    baseArray19[0] = this.compose;
                }
                return baseArray;
            }
            case 17878207: {
                Base[] baseArray;
                if (this.expansion == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray20 = new Base[1];
                    baseArray = baseArray20;
                    baseArray20[0] = this.expansion;
                }
                return baseArray;
            }
            case 109264468: {
                Base[] baseArray;
                if (this.scope == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray21 = new Base[1];
                    baseArray = baseArray21;
                    baseArray21[0] = this.scope;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = TypeConvertor.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 351608024: {
                this.version = TypeConvertor.castToString(value);
                return value;
            }
            case 1508158071: {
                this.versionAlgorithm = TypeConvertor.castToType(value);
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = TypeConvertor.castToString(value);
                return value;
            }
            case -892481550: {
                value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -404562712: {
                this.experimental = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = TypeConvertor.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(TypeConvertor.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 1596987778: {
                this.immutable = TypeConvertor.castToBoolean(value);
                return value;
            }
            case -220463842: {
                this.purpose = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 1522889671: {
                this.copyright = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 765157229: {
                this.copyrightLabel = TypeConvertor.castToString(value);
                return value;
            }
            case 223539345: {
                this.approvalDate = TypeConvertor.castToDate(value);
                return value;
            }
            case -1687512484: {
                this.lastReviewDate = TypeConvertor.castToDate(value);
                return value;
            }
            case -403934648: {
                this.effectivePeriod = TypeConvertor.castToPeriod(value);
                return value;
            }
            case 110546223: {
                this.getTopic().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1406328437: {
                this.getAuthor().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -1307827859: {
                this.getEditor().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -261190139: {
                this.getReviewer().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case 1740277666: {
                this.getEndorser().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case 666807069: {
                this.getRelatedArtifact().add(TypeConvertor.castToRelatedArtifact(value));
                return value;
            }
            case 950497682: {
                this.compose = (ValueSetComposeComponent)((Object)value);
                return value;
            }
            case 17878207: {
                this.expansion = (ValueSetExpansionComponent)((Object)value);
                return value;
            }
            case 109264468: {
                this.scope = (ValueSetScopeComponent)((Object)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = TypeConvertor.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = TypeConvertor.castToString(value);
        } else if (name.equals("versionAlgorithm[x]")) {
            this.versionAlgorithm = TypeConvertor.castToType(value);
        } else if (name.equals(SP_NAME)) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = TypeConvertor.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("experimental")) {
            this.experimental = TypeConvertor.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = TypeConvertor.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = TypeConvertor.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(TypeConvertor.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("immutable")) {
            this.immutable = TypeConvertor.castToBoolean(value);
        } else if (name.equals("purpose")) {
            this.purpose = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("copyright")) {
            this.copyright = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("copyrightLabel")) {
            this.copyrightLabel = TypeConvertor.castToString(value);
        } else if (name.equals("approvalDate")) {
            this.approvalDate = TypeConvertor.castToDate(value);
        } else if (name.equals("lastReviewDate")) {
            this.lastReviewDate = TypeConvertor.castToDate(value);
        } else if (name.equals("effectivePeriod")) {
            this.effectivePeriod = TypeConvertor.castToPeriod(value);
        } else if (name.equals(SP_TOPIC)) {
            this.getTopic().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("author")) {
            this.getAuthor().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("editor")) {
            this.getEditor().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("reviewer")) {
            this.getReviewer().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("endorser")) {
            this.getEndorser().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("relatedArtifact")) {
            this.getRelatedArtifact().add(TypeConvertor.castToRelatedArtifact(value));
        } else if (name.equals("compose")) {
            this.compose = (ValueSetComposeComponent)((Object)value);
        } else if (name.equals(SP_EXPANSION)) {
            this.expansion = (ValueSetExpansionComponent)((Object)value);
        } else if (name.equals("scope")) {
            this.scope = (ValueSetScopeComponent)((Object)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = null;
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(value);
        } else if (name.equals(SP_VERSION)) {
            this.version = null;
        } else if (name.equals("versionAlgorithm[x]")) {
            this.versionAlgorithm = null;
        } else if (name.equals(SP_NAME)) {
            this.name = null;
        } else if (name.equals(SP_TITLE)) {
            this.title = null;
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("experimental")) {
            this.experimental = null;
        } else if (name.equals(SP_DATE)) {
            this.date = null;
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = null;
        } else if (name.equals("contact")) {
            this.getContact().remove(value);
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = null;
        } else if (name.equals("useContext")) {
            this.getUseContext().remove(value);
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().remove(value);
        } else if (name.equals("immutable")) {
            this.immutable = null;
        } else if (name.equals("purpose")) {
            this.purpose = null;
        } else if (name.equals("copyright")) {
            this.copyright = null;
        } else if (name.equals("copyrightLabel")) {
            this.copyrightLabel = null;
        } else if (name.equals("approvalDate")) {
            this.approvalDate = null;
        } else if (name.equals("lastReviewDate")) {
            this.lastReviewDate = null;
        } else if (name.equals("effectivePeriod")) {
            this.effectivePeriod = null;
        } else if (name.equals(SP_TOPIC)) {
            this.getTopic().remove(value);
        } else if (name.equals("author")) {
            this.getAuthor().remove(value);
        } else if (name.equals("editor")) {
            this.getEditor().remove(value);
        } else if (name.equals("reviewer")) {
            this.getReviewer().remove(value);
        } else if (name.equals("endorser")) {
            this.getEndorser().remove(value);
        } else if (name.equals("relatedArtifact")) {
            this.getRelatedArtifact().remove(value);
        } else if (name.equals("compose")) {
            this.compose = (ValueSetComposeComponent)((Object)value);
        } else if (name.equals(SP_EXPANSION)) {
            this.expansion = (ValueSetExpansionComponent)((Object)value);
        } else if (name.equals("scope")) {
            this.scope = (ValueSetScopeComponent)((Object)value);
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case -115699031: {
                return this.getVersionAlgorithm();
            }
            case 1508158071: {
                return this.getVersionAlgorithm();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case 1596987778: {
                return this.getImmutableElement();
            }
            case -220463842: {
                return this.getPurposeElement();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case 765157229: {
                return this.getCopyrightLabelElement();
            }
            case 223539345: {
                return this.getApprovalDateElement();
            }
            case -1687512484: {
                return this.getLastReviewDateElement();
            }
            case -403934648: {
                return this.getEffectivePeriod();
            }
            case 110546223: {
                return this.addTopic();
            }
            case -1406328437: {
                return this.addAuthor();
            }
            case -1307827859: {
                return this.addEditor();
            }
            case -261190139: {
                return this.addReviewer();
            }
            case 1740277666: {
                return this.addEndorser();
            }
            case 666807069: {
                return this.addRelatedArtifact();
            }
            case 950497682: {
                return this.getCompose();
            }
            case 17878207: {
                return this.getExpansion();
            }
            case 109264468: {
                return this.getScope();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 1508158071: {
                return new String[]{"string", "Coding"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case 1596987778: {
                return new String[]{"boolean"};
            }
            case -220463842: {
                return new String[]{"markdown"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case 765157229: {
                return new String[]{"string"};
            }
            case 223539345: {
                return new String[]{SP_DATE};
            }
            case -1687512484: {
                return new String[]{SP_DATE};
            }
            case -403934648: {
                return new String[]{"Period"};
            }
            case 110546223: {
                return new String[]{"CodeableConcept"};
            }
            case -1406328437: {
                return new String[]{"ContactDetail"};
            }
            case -1307827859: {
                return new String[]{"ContactDetail"};
            }
            case -261190139: {
                return new String[]{"ContactDetail"};
            }
            case 1740277666: {
                return new String[]{"ContactDetail"};
            }
            case 666807069: {
                return new String[]{"RelatedArtifact"};
            }
            case 950497682: {
                return new String[0];
            }
            case 17878207: {
                return new String[0];
            }
            case 109264468: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a singleton property ValueSet.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a singleton property ValueSet.version");
        }
        if (name.equals("versionAlgorithmString")) {
            this.versionAlgorithm = new StringType();
            return this.versionAlgorithm;
        }
        if (name.equals("versionAlgorithmCoding")) {
            this.versionAlgorithm = new Coding();
            return this.versionAlgorithm;
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a singleton property ValueSet.name");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a singleton property ValueSet.title");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property ValueSet.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a singleton property ValueSet.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a singleton property ValueSet.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a singleton property ValueSet.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a singleton property ValueSet.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("immutable")) {
            throw new FHIRException("Cannot call addChild on a singleton property ValueSet.immutable");
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a singleton property ValueSet.purpose");
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a singleton property ValueSet.copyright");
        }
        if (name.equals("copyrightLabel")) {
            throw new FHIRException("Cannot call addChild on a singleton property ValueSet.copyrightLabel");
        }
        if (name.equals("approvalDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property ValueSet.approvalDate");
        }
        if (name.equals("lastReviewDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property ValueSet.lastReviewDate");
        }
        if (name.equals("effectivePeriod")) {
            this.effectivePeriod = new Period();
            return this.effectivePeriod;
        }
        if (name.equals(SP_TOPIC)) {
            return this.addTopic();
        }
        if (name.equals("author")) {
            return this.addAuthor();
        }
        if (name.equals("editor")) {
            return this.addEditor();
        }
        if (name.equals("reviewer")) {
            return this.addReviewer();
        }
        if (name.equals("endorser")) {
            return this.addEndorser();
        }
        if (name.equals("relatedArtifact")) {
            return this.addRelatedArtifact();
        }
        if (name.equals("compose")) {
            this.compose = new ValueSetComposeComponent();
            return this.compose;
        }
        if (name.equals(SP_EXPANSION)) {
            this.expansion = new ValueSetExpansionComponent();
            return this.expansion;
        }
        if (name.equals("scope")) {
            this.scope = new ValueSetScopeComponent();
            return this.scope;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ValueSet";
    }

    @Override
    public ValueSet copy() {
        ValueSet dst = new ValueSet();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ValueSet dst) {
        super.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        dst.versionAlgorithm = this.versionAlgorithm == null ? null : this.versionAlgorithm.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.title = this.title == null ? null : this.title.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList<UsageContext>();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.immutable = this.immutable == null ? null : this.immutable.copy();
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        dst.copyrightLabel = this.copyrightLabel == null ? null : this.copyrightLabel.copy();
        dst.approvalDate = this.approvalDate == null ? null : this.approvalDate.copy();
        dst.lastReviewDate = this.lastReviewDate == null ? null : this.lastReviewDate.copy();
        Period period = dst.effectivePeriod = this.effectivePeriod == null ? null : this.effectivePeriod.copy();
        if (this.topic != null) {
            dst.topic = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.topic) {
                dst.topic.add(codeableConcept.copy());
            }
        }
        if (this.author != null) {
            dst.author = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.author) {
                dst.author.add(contactDetail.copy());
            }
        }
        if (this.editor != null) {
            dst.editor = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.editor) {
                dst.editor.add(contactDetail.copy());
            }
        }
        if (this.reviewer != null) {
            dst.reviewer = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.reviewer) {
                dst.reviewer.add(contactDetail.copy());
            }
        }
        if (this.endorser != null) {
            dst.endorser = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.endorser) {
                dst.endorser.add(contactDetail.copy());
            }
        }
        if (this.relatedArtifact != null) {
            dst.relatedArtifact = new ArrayList<RelatedArtifact>();
            for (RelatedArtifact relatedArtifact : this.relatedArtifact) {
                dst.relatedArtifact.add(relatedArtifact.copy());
            }
        }
        dst.compose = this.compose == null ? null : this.compose.copy();
        dst.expansion = this.expansion == null ? null : this.expansion.copy();
        dst.scope = this.scope == null ? null : this.scope.copy();
    }

    protected ValueSet typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ValueSet)) {
            return false;
        }
        ValueSet o = (ValueSet)other_;
        return ValueSet.compareDeep(this.url, o.url, true) && ValueSet.compareDeep(this.identifier, o.identifier, true) && ValueSet.compareDeep(this.version, o.version, true) && ValueSet.compareDeep(this.versionAlgorithm, o.versionAlgorithm, true) && ValueSet.compareDeep(this.name, o.name, true) && ValueSet.compareDeep(this.title, o.title, true) && ValueSet.compareDeep(this.status, o.status, true) && ValueSet.compareDeep(this.experimental, o.experimental, true) && ValueSet.compareDeep(this.date, o.date, true) && ValueSet.compareDeep(this.publisher, o.publisher, true) && ValueSet.compareDeep(this.contact, o.contact, true) && ValueSet.compareDeep(this.description, o.description, true) && ValueSet.compareDeep(this.useContext, o.useContext, true) && ValueSet.compareDeep(this.jurisdiction, o.jurisdiction, true) && ValueSet.compareDeep(this.immutable, o.immutable, true) && ValueSet.compareDeep(this.purpose, o.purpose, true) && ValueSet.compareDeep(this.copyright, o.copyright, true) && ValueSet.compareDeep(this.copyrightLabel, o.copyrightLabel, true) && ValueSet.compareDeep(this.approvalDate, o.approvalDate, true) && ValueSet.compareDeep(this.lastReviewDate, o.lastReviewDate, true) && ValueSet.compareDeep(this.effectivePeriod, o.effectivePeriod, true) && ValueSet.compareDeep(this.topic, o.topic, true) && ValueSet.compareDeep(this.author, o.author, true) && ValueSet.compareDeep(this.editor, o.editor, true) && ValueSet.compareDeep(this.reviewer, o.reviewer, true) && ValueSet.compareDeep(this.endorser, o.endorser, true) && ValueSet.compareDeep(this.relatedArtifact, o.relatedArtifact, true) && ValueSet.compareDeep(this.compose, o.compose, true) && ValueSet.compareDeep(this.expansion, o.expansion, true) && ValueSet.compareDeep(this.scope, o.scope, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ValueSet)) {
            return false;
        }
        ValueSet o = (ValueSet)other_;
        return ValueSet.compareValues(this.url, o.url, true) && ValueSet.compareValues(this.version, o.version, true) && ValueSet.compareValues(this.name, o.name, true) && ValueSet.compareValues(this.title, o.title, true) && ValueSet.compareValues(this.status, o.status, true) && ValueSet.compareValues(this.experimental, o.experimental, true) && ValueSet.compareValues(this.date, o.date, true) && ValueSet.compareValues(this.publisher, o.publisher, true) && ValueSet.compareValues(this.description, o.description, true) && ValueSet.compareValues(this.immutable, o.immutable, true) && ValueSet.compareValues(this.purpose, o.purpose, true) && ValueSet.compareValues(this.copyright, o.copyright, true) && ValueSet.compareValues(this.copyrightLabel, o.copyrightLabel, true) && ValueSet.compareValues(this.approvalDate, o.approvalDate, true) && ValueSet.compareValues(this.lastReviewDate, o.lastReviewDate, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.url, this.identifier, this.version, this.versionAlgorithm, this.name, this.title, this.status, this.experimental, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.immutable, this.purpose, this.copyright, this.copyrightLabel, this.approvalDate, this.lastReviewDate, this.effectivePeriod, this.topic, this.author, this.editor, this.reviewer, this.endorser, this.relatedArtifact, this.compose, this.expansion, this.scope});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ValueSet;
    }

    @Block
    public static class ValueSetScopeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="inclusionCriteria", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Criteria describing which concepts or codes should be included and why", formalDefinition="Criteria describing which concepts or codes should be included and why.")
        protected StringType inclusionCriteria;
        @Child(name="exclusionCriteria", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Criteria describing which concepts or codes should be excluded and why", formalDefinition="Criteria describing which concepts or codes should be excluded and why.")
        protected StringType exclusionCriteria;
        private static final long serialVersionUID = -641434610L;

        public StringType getInclusionCriteriaElement() {
            if (this.inclusionCriteria == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetScopeComponent.inclusionCriteria");
                }
                if (Configuration.doAutoCreate()) {
                    this.inclusionCriteria = new StringType();
                }
            }
            return this.inclusionCriteria;
        }

        public boolean hasInclusionCriteriaElement() {
            return this.inclusionCriteria != null && !this.inclusionCriteria.isEmpty();
        }

        public boolean hasInclusionCriteria() {
            return this.inclusionCriteria != null && !this.inclusionCriteria.isEmpty();
        }

        public ValueSetScopeComponent setInclusionCriteriaElement(StringType value) {
            this.inclusionCriteria = value;
            return this;
        }

        public String getInclusionCriteria() {
            return this.inclusionCriteria == null ? null : (String)this.inclusionCriteria.getValue();
        }

        public ValueSetScopeComponent setInclusionCriteria(String value) {
            if (Utilities.noString((String)value)) {
                this.inclusionCriteria = null;
            } else {
                if (this.inclusionCriteria == null) {
                    this.inclusionCriteria = new StringType();
                }
                this.inclusionCriteria.setValue(value);
            }
            return this;
        }

        public StringType getExclusionCriteriaElement() {
            if (this.exclusionCriteria == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetScopeComponent.exclusionCriteria");
                }
                if (Configuration.doAutoCreate()) {
                    this.exclusionCriteria = new StringType();
                }
            }
            return this.exclusionCriteria;
        }

        public boolean hasExclusionCriteriaElement() {
            return this.exclusionCriteria != null && !this.exclusionCriteria.isEmpty();
        }

        public boolean hasExclusionCriteria() {
            return this.exclusionCriteria != null && !this.exclusionCriteria.isEmpty();
        }

        public ValueSetScopeComponent setExclusionCriteriaElement(StringType value) {
            this.exclusionCriteria = value;
            return this;
        }

        public String getExclusionCriteria() {
            return this.exclusionCriteria == null ? null : (String)this.exclusionCriteria.getValue();
        }

        public ValueSetScopeComponent setExclusionCriteria(String value) {
            if (Utilities.noString((String)value)) {
                this.exclusionCriteria = null;
            } else {
                if (this.exclusionCriteria == null) {
                    this.exclusionCriteria = new StringType();
                }
                this.exclusionCriteria.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("inclusionCriteria", "string", "Criteria describing which concepts or codes should be included and why.", 0, 1, this.inclusionCriteria));
            children.add(new Property("exclusionCriteria", "string", "Criteria describing which concepts or codes should be excluded and why.", 0, 1, this.exclusionCriteria));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1380638565: {
                    return new Property("inclusionCriteria", "string", "Criteria describing which concepts or codes should be included and why.", 0, 1, this.inclusionCriteria);
                }
                case 985682765: {
                    return new Property("exclusionCriteria", "string", "Criteria describing which concepts or codes should be excluded and why.", 0, 1, this.exclusionCriteria);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1380638565: {
                    Base[] baseArray;
                    if (this.inclusionCriteria == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.inclusionCriteria;
                    }
                    return baseArray;
                }
                case 985682765: {
                    Base[] baseArray;
                    if (this.exclusionCriteria == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.exclusionCriteria;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1380638565: {
                    this.inclusionCriteria = TypeConvertor.castToString(value);
                    return value;
                }
                case 985682765: {
                    this.exclusionCriteria = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("inclusionCriteria")) {
                this.inclusionCriteria = TypeConvertor.castToString(value);
            } else if (name.equals("exclusionCriteria")) {
                this.exclusionCriteria = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("inclusionCriteria")) {
                this.inclusionCriteria = null;
            } else if (name.equals("exclusionCriteria")) {
                this.exclusionCriteria = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1380638565: {
                    return this.getInclusionCriteriaElement();
                }
                case 985682765: {
                    return this.getExclusionCriteriaElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1380638565: {
                    return new String[]{"string"};
                }
                case 985682765: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("inclusionCriteria")) {
                throw new FHIRException("Cannot call addChild on a singleton property ValueSet.scope.inclusionCriteria");
            }
            if (name.equals("exclusionCriteria")) {
                throw new FHIRException("Cannot call addChild on a singleton property ValueSet.scope.exclusionCriteria");
            }
            return super.addChild(name);
        }

        @Override
        public ValueSetScopeComponent copy() {
            ValueSetScopeComponent dst = new ValueSetScopeComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ValueSetScopeComponent dst) {
            super.copyValues(dst);
            dst.inclusionCriteria = this.inclusionCriteria == null ? null : this.inclusionCriteria.copy();
            dst.exclusionCriteria = this.exclusionCriteria == null ? null : this.exclusionCriteria.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ValueSetScopeComponent)) {
                return false;
            }
            ValueSetScopeComponent o = (ValueSetScopeComponent)other_;
            return ValueSetScopeComponent.compareDeep(this.inclusionCriteria, o.inclusionCriteria, true) && ValueSetScopeComponent.compareDeep(this.exclusionCriteria, o.exclusionCriteria, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ValueSetScopeComponent)) {
                return false;
            }
            ValueSetScopeComponent o = (ValueSetScopeComponent)other_;
            return ValueSetScopeComponent.compareValues(this.inclusionCriteria, o.inclusionCriteria, true) && ValueSetScopeComponent.compareValues(this.exclusionCriteria, o.exclusionCriteria, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.inclusionCriteria, this.exclusionCriteria});
        }

        @Override
        public String fhirType() {
            return "ValueSet.scope";
        }
    }

    @Block
    public static class ConceptSubPropertyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reference to ValueSet.expansion.property.code", formalDefinition="A code that is a reference to ValueSet.expansion.property.code.")
        protected CodeType code;
        @Child(name="value", type={CodeType.class, Coding.class, StringType.class, IntegerType.class, BooleanType.class, DateTimeType.class, DecimalType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Value of the subproperty for this concept", formalDefinition="The value of this subproperty.")
        protected DataType value;
        private static final long serialVersionUID = -422546419L;

        public ConceptSubPropertyComponent() {
        }

        public ConceptSubPropertyComponent(String code, DataType value) {
            this.setCode(code);
            this.setValue(value);
        }

        public CodeType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptSubPropertyComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ConceptSubPropertyComponent setCodeElement(CodeType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public ConceptSubPropertyComponent setCode(String value) {
            if (this.code == null) {
                this.code = new CodeType();
            }
            this.code.setValue(value);
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public CodeType getValueCodeType() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeType();
            }
            if (!(this.value instanceof CodeType)) {
                throw new FHIRException("Type mismatch: the type CodeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeType)this.value;
        }

        public boolean hasValueCodeType() {
            return this != null && this.value instanceof CodeType;
        }

        public Coding getValueCoding() throws FHIRException {
            if (this.value == null) {
                this.value = new Coding();
            }
            if (!(this.value instanceof Coding)) {
                throw new FHIRException("Type mismatch: the type Coding was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Coding)this.value;
        }

        public boolean hasValueCoding() {
            return this != null && this.value instanceof Coding;
        }

        public StringType getValueStringType() throws FHIRException {
            if (this.value == null) {
                this.value = new StringType();
            }
            if (!(this.value instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (StringType)this.value;
        }

        public boolean hasValueStringType() {
            return this != null && this.value instanceof StringType;
        }

        public IntegerType getValueIntegerType() throws FHIRException {
            if (this.value == null) {
                this.value = new IntegerType();
            }
            if (!(this.value instanceof IntegerType)) {
                throw new FHIRException("Type mismatch: the type IntegerType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (IntegerType)this.value;
        }

        public boolean hasValueIntegerType() {
            return this != null && this.value instanceof IntegerType;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (this.value == null) {
                this.value = new BooleanType();
            }
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this != null && this.value instanceof BooleanType;
        }

        public DateTimeType getValueDateTimeType() throws FHIRException {
            if (this.value == null) {
                this.value = new DateTimeType();
            }
            if (!(this.value instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.value;
        }

        public boolean hasValueDateTimeType() {
            return this != null && this.value instanceof DateTimeType;
        }

        public DecimalType getValueDecimalType() throws FHIRException {
            if (this.value == null) {
                this.value = new DecimalType();
            }
            if (!(this.value instanceof DecimalType)) {
                throw new FHIRException("Type mismatch: the type DecimalType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DecimalType)this.value;
        }

        public boolean hasValueDecimalType() {
            return this != null && this.value instanceof DecimalType;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ConceptSubPropertyComponent setValue(DataType value) {
            if (!(value == null || value instanceof CodeType || value instanceof Coding || value instanceof StringType || value instanceof IntegerType || value instanceof BooleanType || value instanceof DateTimeType || value instanceof DecimalType)) {
                throw new FHIRException("Not the right type for ValueSet.expansion.contains.property.subProperty.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(ValueSet.SP_CODE, ValueSet.SP_CODE, "A code that is a reference to ValueSet.expansion.property.code.", 0, 1, this.code));
            children.add(new Property("value[x]", "code|Coding|string|integer|boolean|dateTime|decimal", "The value of this subproperty.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property(ValueSet.SP_CODE, ValueSet.SP_CODE, "A code that is a reference to ValueSet.expansion.property.code.", 0, 1, this.code);
                }
                case -1410166417: {
                    return new Property("value[x]", "code|Coding|string|integer|boolean|dateTime|decimal", "The value of this subproperty.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "code|Coding|string|integer|boolean|dateTime|decimal", "The value of this subproperty.", 0, 1, this.value);
                }
                case -766209282: {
                    return new Property("value[x]", ValueSet.SP_CODE, "The value of this subproperty.", 0, 1, this.value);
                }
                case -1887705029: {
                    return new Property("value[x]", "Coding", "The value of this subproperty.", 0, 1, this.value);
                }
                case -1424603934: {
                    return new Property("value[x]", "string", "The value of this subproperty.", 0, 1, this.value);
                }
                case -1668204915: {
                    return new Property("value[x]", "integer", "The value of this subproperty.", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "boolean", "The value of this subproperty.", 0, 1, this.value);
                }
                case 1047929900: {
                    return new Property("value[x]", "dateTime", "The value of this subproperty.", 0, 1, this.value);
                }
                case -2083993440: {
                    return new Property("value[x]", "decimal", "The value of this subproperty.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCode(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ValueSet.SP_CODE)) {
                this.code = TypeConvertor.castToCode(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals(ValueSet.SP_CODE)) {
                this.code = null;
            } else if (name.equals("value[x]")) {
                this.value = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCodeElement();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{ValueSet.SP_CODE};
                }
                case 111972721: {
                    return new String[]{ValueSet.SP_CODE, "Coding", "string", "integer", "boolean", "dateTime", "decimal"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ValueSet.SP_CODE)) {
                throw new FHIRException("Cannot call addChild on a singleton property ValueSet.expansion.contains.property.subProperty.code");
            }
            if (name.equals("valueCode")) {
                this.value = new CodeType();
                return this.value;
            }
            if (name.equals("valueCoding")) {
                this.value = new Coding();
                return this.value;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueInteger")) {
                this.value = new IntegerType();
                return this.value;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueDateTime")) {
                this.value = new DateTimeType();
                return this.value;
            }
            if (name.equals("valueDecimal")) {
                this.value = new DecimalType();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public ConceptSubPropertyComponent copy() {
            ConceptSubPropertyComponent dst = new ConceptSubPropertyComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ConceptSubPropertyComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ConceptSubPropertyComponent)) {
                return false;
            }
            ConceptSubPropertyComponent o = (ConceptSubPropertyComponent)other_;
            return ConceptSubPropertyComponent.compareDeep(this.code, o.code, true) && ConceptSubPropertyComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ConceptSubPropertyComponent)) {
                return false;
            }
            ConceptSubPropertyComponent o = (ConceptSubPropertyComponent)other_;
            return ConceptSubPropertyComponent.compareValues(this.code, o.code, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.code, this.value});
        }

        @Override
        public String fhirType() {
            return "ValueSet.expansion.contains.property.subProperty";
        }
    }

    @Block
    public static class ConceptPropertyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reference to ValueSet.expansion.property.code", formalDefinition="A code that is a reference to ValueSet.expansion.property.code.")
        protected CodeType code;
        @Child(name="value", type={CodeType.class, Coding.class, StringType.class, IntegerType.class, BooleanType.class, DateTimeType.class, DecimalType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Value of the property for this concept", formalDefinition="The value of this property.")
        protected DataType value;
        @Child(name="subProperty", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="SubProperty value for the concept", formalDefinition="A subproperty value for this concept.")
        protected List<ConceptSubPropertyComponent> subProperty;
        private static final long serialVersionUID = -948620650L;

        public ConceptPropertyComponent() {
        }

        public ConceptPropertyComponent(String code, DataType value) {
            this.setCode(code);
            this.setValue(value);
        }

        public CodeType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptPropertyComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ConceptPropertyComponent setCodeElement(CodeType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public ConceptPropertyComponent setCode(String value) {
            if (this.code == null) {
                this.code = new CodeType();
            }
            this.code.setValue(value);
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public CodeType getValueCodeType() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeType();
            }
            if (!(this.value instanceof CodeType)) {
                throw new FHIRException("Type mismatch: the type CodeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeType)this.value;
        }

        public boolean hasValueCodeType() {
            return this != null && this.value instanceof CodeType;
        }

        public Coding getValueCoding() throws FHIRException {
            if (this.value == null) {
                this.value = new Coding();
            }
            if (!(this.value instanceof Coding)) {
                throw new FHIRException("Type mismatch: the type Coding was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Coding)this.value;
        }

        public boolean hasValueCoding() {
            return this != null && this.value instanceof Coding;
        }

        public StringType getValueStringType() throws FHIRException {
            if (this.value == null) {
                this.value = new StringType();
            }
            if (!(this.value instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (StringType)this.value;
        }

        public boolean hasValueStringType() {
            return this != null && this.value instanceof StringType;
        }

        public IntegerType getValueIntegerType() throws FHIRException {
            if (this.value == null) {
                this.value = new IntegerType();
            }
            if (!(this.value instanceof IntegerType)) {
                throw new FHIRException("Type mismatch: the type IntegerType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (IntegerType)this.value;
        }

        public boolean hasValueIntegerType() {
            return this != null && this.value instanceof IntegerType;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (this.value == null) {
                this.value = new BooleanType();
            }
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this != null && this.value instanceof BooleanType;
        }

        public DateTimeType getValueDateTimeType() throws FHIRException {
            if (this.value == null) {
                this.value = new DateTimeType();
            }
            if (!(this.value instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.value;
        }

        public boolean hasValueDateTimeType() {
            return this != null && this.value instanceof DateTimeType;
        }

        public DecimalType getValueDecimalType() throws FHIRException {
            if (this.value == null) {
                this.value = new DecimalType();
            }
            if (!(this.value instanceof DecimalType)) {
                throw new FHIRException("Type mismatch: the type DecimalType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DecimalType)this.value;
        }

        public boolean hasValueDecimalType() {
            return this != null && this.value instanceof DecimalType;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ConceptPropertyComponent setValue(DataType value) {
            if (!(value == null || value instanceof CodeType || value instanceof Coding || value instanceof StringType || value instanceof IntegerType || value instanceof BooleanType || value instanceof DateTimeType || value instanceof DecimalType)) {
                throw new FHIRException("Not the right type for ValueSet.expansion.contains.property.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        public List<ConceptSubPropertyComponent> getSubProperty() {
            if (this.subProperty == null) {
                this.subProperty = new ArrayList<ConceptSubPropertyComponent>();
            }
            return this.subProperty;
        }

        public ConceptPropertyComponent setSubProperty(List<ConceptSubPropertyComponent> theSubProperty) {
            this.subProperty = theSubProperty;
            return this;
        }

        public boolean hasSubProperty() {
            if (this.subProperty == null) {
                return false;
            }
            for (ConceptSubPropertyComponent item : this.subProperty) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ConceptSubPropertyComponent addSubProperty() {
            ConceptSubPropertyComponent t = new ConceptSubPropertyComponent();
            if (this.subProperty == null) {
                this.subProperty = new ArrayList<ConceptSubPropertyComponent>();
            }
            this.subProperty.add(t);
            return t;
        }

        public ConceptPropertyComponent addSubProperty(ConceptSubPropertyComponent t) {
            if (t == null) {
                return this;
            }
            if (this.subProperty == null) {
                this.subProperty = new ArrayList<ConceptSubPropertyComponent>();
            }
            this.subProperty.add(t);
            return this;
        }

        public ConceptSubPropertyComponent getSubPropertyFirstRep() {
            if (this.getSubProperty().isEmpty()) {
                this.addSubProperty();
            }
            return this.getSubProperty().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(ValueSet.SP_CODE, ValueSet.SP_CODE, "A code that is a reference to ValueSet.expansion.property.code.", 0, 1, this.code));
            children.add(new Property("value[x]", "code|Coding|string|integer|boolean|dateTime|decimal", "The value of this property.", 0, 1, this.value));
            children.add(new Property("subProperty", "", "A subproperty value for this concept.", 0, Integer.MAX_VALUE, this.subProperty));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property(ValueSet.SP_CODE, ValueSet.SP_CODE, "A code that is a reference to ValueSet.expansion.property.code.", 0, 1, this.code);
                }
                case -1410166417: {
                    return new Property("value[x]", "code|Coding|string|integer|boolean|dateTime|decimal", "The value of this property.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "code|Coding|string|integer|boolean|dateTime|decimal", "The value of this property.", 0, 1, this.value);
                }
                case -766209282: {
                    return new Property("value[x]", ValueSet.SP_CODE, "The value of this property.", 0, 1, this.value);
                }
                case -1887705029: {
                    return new Property("value[x]", "Coding", "The value of this property.", 0, 1, this.value);
                }
                case -1424603934: {
                    return new Property("value[x]", "string", "The value of this property.", 0, 1, this.value);
                }
                case -1668204915: {
                    return new Property("value[x]", "integer", "The value of this property.", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "boolean", "The value of this property.", 0, 1, this.value);
                }
                case 1047929900: {
                    return new Property("value[x]", "dateTime", "The value of this property.", 0, 1, this.value);
                }
                case -2083993440: {
                    return new Property("value[x]", "decimal", "The value of this property.", 0, 1, this.value);
                }
                case 321372213: {
                    return new Property("subProperty", "", "A subproperty value for this concept.", 0, Integer.MAX_VALUE, this.subProperty);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
                case 321372213: {
                    return this.subProperty == null ? new Base[]{} : this.subProperty.toArray(new Base[this.subProperty.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCode(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
                case 321372213: {
                    this.getSubProperty().add((ConceptSubPropertyComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ValueSet.SP_CODE)) {
                this.code = TypeConvertor.castToCode(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else if (name.equals("subProperty")) {
                this.getSubProperty().add((ConceptSubPropertyComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals(ValueSet.SP_CODE)) {
                this.code = null;
            } else if (name.equals("value[x]")) {
                this.value = null;
            } else if (name.equals("subProperty")) {
                this.getSubProperty().remove((ConceptSubPropertyComponent)value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCodeElement();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
                case 321372213: {
                    return this.addSubProperty();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{ValueSet.SP_CODE};
                }
                case 111972721: {
                    return new String[]{ValueSet.SP_CODE, "Coding", "string", "integer", "boolean", "dateTime", "decimal"};
                }
                case 321372213: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ValueSet.SP_CODE)) {
                throw new FHIRException("Cannot call addChild on a singleton property ValueSet.expansion.contains.property.code");
            }
            if (name.equals("valueCode")) {
                this.value = new CodeType();
                return this.value;
            }
            if (name.equals("valueCoding")) {
                this.value = new Coding();
                return this.value;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueInteger")) {
                this.value = new IntegerType();
                return this.value;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueDateTime")) {
                this.value = new DateTimeType();
                return this.value;
            }
            if (name.equals("valueDecimal")) {
                this.value = new DecimalType();
                return this.value;
            }
            if (name.equals("subProperty")) {
                return this.addSubProperty();
            }
            return super.addChild(name);
        }

        @Override
        public ConceptPropertyComponent copy() {
            ConceptPropertyComponent dst = new ConceptPropertyComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ConceptPropertyComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            DataType dataType = dst.value = this.value == null ? null : this.value.copy();
            if (this.subProperty != null) {
                dst.subProperty = new ArrayList<ConceptSubPropertyComponent>();
                for (ConceptSubPropertyComponent i : this.subProperty) {
                    dst.subProperty.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ConceptPropertyComponent)) {
                return false;
            }
            ConceptPropertyComponent o = (ConceptPropertyComponent)other_;
            return ConceptPropertyComponent.compareDeep(this.code, o.code, true) && ConceptPropertyComponent.compareDeep(this.value, o.value, true) && ConceptPropertyComponent.compareDeep(this.subProperty, o.subProperty, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ConceptPropertyComponent)) {
                return false;
            }
            ConceptPropertyComponent o = (ConceptPropertyComponent)other_;
            return ConceptPropertyComponent.compareValues(this.code, o.code, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.value, this.subProperty});
        }

        @Override
        public String fhirType() {
            return "ValueSet.expansion.contains.property";
        }
    }

    @Block
    public static class ValueSetExpansionContainsComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="system", type={UriType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="System value for the code", formalDefinition="An absolute URI which is the code system in which the code for this item in the expansion is defined.")
        protected UriType system;
        @Child(name="abstract", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="If user cannot select this entry", formalDefinition="If true, this entry is included in the expansion for navigational purposes, and the user cannot select the code directly as a proper value.")
        protected BooleanType abstract_;
        @Child(name="inactive", type={BooleanType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="If concept is inactive in the code system", formalDefinition="If the concept is inactive in the code system that defines it. Inactive codes are those that are no longer to be used, but are maintained by the code system for understanding legacy data. It might not be known or specified whether a concept is inactive (and it may depend on the context of use).")
        protected BooleanType inactive;
        @Child(name="version", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Version in which this code/display is defined", formalDefinition="The version of the code system from this code was taken. Note that a well-maintained code system does not need the version reported, because the meaning of codes is consistent across versions. However this cannot consistently be assured, and when the meaning is not guaranteed to be consistent, the version SHOULD be exchanged.")
        protected StringType version;
        @Child(name="code", type={CodeType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code - if blank, this is not a selectable code", formalDefinition="The code for this item in the expansion hierarchy. If this code is missing the entry in the hierarchy is a place holder (abstract) and does not represent a valid code in the value set.")
        protected CodeType code;
        @Child(name="display", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="User display for the concept", formalDefinition="The recommended display for this item in the expansion.")
        protected StringType display;
        @Child(name="designation", type={ConceptReferenceDesignationComponent.class}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Additional representations for this item", formalDefinition="Additional representations for this item - other languages, aliases, specialized purposes, used for particular purposes, etc. These are relevant when the conditions of the expansion do not fix to a single correct representation.")
        protected List<ConceptReferenceDesignationComponent> designation;
        @Child(name="property", type={}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Property value for the concept", formalDefinition="A property value for this concept.")
        protected List<ConceptPropertyComponent> property;
        @Child(name="contains", type={ValueSetExpansionContainsComponent.class}, order=9, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Codes contained under this entry", formalDefinition="Other codes and entries contained under this entry in the hierarchy.")
        protected List<ValueSetExpansionContainsComponent> contains;
        private static final long serialVersionUID = -1370569439L;

        public UriType getSystemElement() {
            if (this.system == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetExpansionContainsComponent.system");
                }
                if (Configuration.doAutoCreate()) {
                    this.system = new UriType();
                }
            }
            return this.system;
        }

        public boolean hasSystemElement() {
            return this.system != null && !this.system.isEmpty();
        }

        public boolean hasSystem() {
            return this.system != null && !this.system.isEmpty();
        }

        public ValueSetExpansionContainsComponent setSystemElement(UriType value) {
            this.system = value;
            return this;
        }

        public String getSystem() {
            return this.system == null ? null : (String)this.system.getValue();
        }

        public ValueSetExpansionContainsComponent setSystem(String value) {
            if (Utilities.noString((String)value)) {
                this.system = null;
            } else {
                if (this.system == null) {
                    this.system = new UriType();
                }
                this.system.setValue(value);
            }
            return this;
        }

        public BooleanType getAbstractElement() {
            if (this.abstract_ == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetExpansionContainsComponent.abstract_");
                }
                if (Configuration.doAutoCreate()) {
                    this.abstract_ = new BooleanType();
                }
            }
            return this.abstract_;
        }

        public boolean hasAbstractElement() {
            return this.abstract_ != null && !this.abstract_.isEmpty();
        }

        public boolean hasAbstract() {
            return this.abstract_ != null && !this.abstract_.isEmpty();
        }

        public ValueSetExpansionContainsComponent setAbstractElement(BooleanType value) {
            this.abstract_ = value;
            return this;
        }

        public boolean getAbstract() {
            return this.abstract_ == null || this.abstract_.isEmpty() ? false : (Boolean)this.abstract_.getValue();
        }

        public ValueSetExpansionContainsComponent setAbstract(boolean value) {
            if (this.abstract_ == null) {
                this.abstract_ = new BooleanType();
            }
            this.abstract_.setValue((Object)value);
            return this;
        }

        public BooleanType getInactiveElement() {
            if (this.inactive == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetExpansionContainsComponent.inactive");
                }
                if (Configuration.doAutoCreate()) {
                    this.inactive = new BooleanType();
                }
            }
            return this.inactive;
        }

        public boolean hasInactiveElement() {
            return this.inactive != null && !this.inactive.isEmpty();
        }

        public boolean hasInactive() {
            return this.inactive != null && !this.inactive.isEmpty();
        }

        public ValueSetExpansionContainsComponent setInactiveElement(BooleanType value) {
            this.inactive = value;
            return this;
        }

        public boolean getInactive() {
            return this.inactive == null || this.inactive.isEmpty() ? false : (Boolean)this.inactive.getValue();
        }

        public ValueSetExpansionContainsComponent setInactive(boolean value) {
            if (this.inactive == null) {
                this.inactive = new BooleanType();
            }
            this.inactive.setValue((Object)value);
            return this;
        }

        public StringType getVersionElement() {
            if (this.version == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetExpansionContainsComponent.version");
                }
                if (Configuration.doAutoCreate()) {
                    this.version = new StringType();
                }
            }
            return this.version;
        }

        public boolean hasVersionElement() {
            return this.version != null && !this.version.isEmpty();
        }

        public boolean hasVersion() {
            return this.version != null && !this.version.isEmpty();
        }

        public ValueSetExpansionContainsComponent setVersionElement(StringType value) {
            this.version = value;
            return this;
        }

        public String getVersion() {
            return this.version == null ? null : (String)this.version.getValue();
        }

        public ValueSetExpansionContainsComponent setVersion(String value) {
            if (Utilities.noString((String)value)) {
                this.version = null;
            } else {
                if (this.version == null) {
                    this.version = new StringType();
                }
                this.version.setValue(value);
            }
            return this;
        }

        public CodeType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetExpansionContainsComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ValueSetExpansionContainsComponent setCodeElement(CodeType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public ValueSetExpansionContainsComponent setCode(String value) {
            if (Utilities.noString((String)value)) {
                this.code = null;
            } else {
                if (this.code == null) {
                    this.code = new CodeType();
                }
                this.code.setValue(value);
            }
            return this;
        }

        public StringType getDisplayElement() {
            if (this.display == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetExpansionContainsComponent.display");
                }
                if (Configuration.doAutoCreate()) {
                    this.display = new StringType();
                }
            }
            return this.display;
        }

        public boolean hasDisplayElement() {
            return this.display != null && !this.display.isEmpty();
        }

        public boolean hasDisplay() {
            return this.display != null && !this.display.isEmpty();
        }

        public ValueSetExpansionContainsComponent setDisplayElement(StringType value) {
            this.display = value;
            return this;
        }

        public String getDisplay() {
            return this.display == null ? null : (String)this.display.getValue();
        }

        public ValueSetExpansionContainsComponent setDisplay(String value) {
            if (Utilities.noString((String)value)) {
                this.display = null;
            } else {
                if (this.display == null) {
                    this.display = new StringType();
                }
                this.display.setValue(value);
            }
            return this;
        }

        public List<ConceptReferenceDesignationComponent> getDesignation() {
            if (this.designation == null) {
                this.designation = new ArrayList<ConceptReferenceDesignationComponent>();
            }
            return this.designation;
        }

        public ValueSetExpansionContainsComponent setDesignation(List<ConceptReferenceDesignationComponent> theDesignation) {
            this.designation = theDesignation;
            return this;
        }

        public boolean hasDesignation() {
            if (this.designation == null) {
                return false;
            }
            for (ConceptReferenceDesignationComponent item : this.designation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ConceptReferenceDesignationComponent addDesignation() {
            ConceptReferenceDesignationComponent t = new ConceptReferenceDesignationComponent();
            if (this.designation == null) {
                this.designation = new ArrayList<ConceptReferenceDesignationComponent>();
            }
            this.designation.add(t);
            return t;
        }

        public ValueSetExpansionContainsComponent addDesignation(ConceptReferenceDesignationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.designation == null) {
                this.designation = new ArrayList<ConceptReferenceDesignationComponent>();
            }
            this.designation.add(t);
            return this;
        }

        public ConceptReferenceDesignationComponent getDesignationFirstRep() {
            if (this.getDesignation().isEmpty()) {
                this.addDesignation();
            }
            return this.getDesignation().get(0);
        }

        public List<ConceptPropertyComponent> getProperty() {
            if (this.property == null) {
                this.property = new ArrayList<ConceptPropertyComponent>();
            }
            return this.property;
        }

        public ValueSetExpansionContainsComponent setProperty(List<ConceptPropertyComponent> theProperty) {
            this.property = theProperty;
            return this;
        }

        public boolean hasProperty() {
            if (this.property == null) {
                return false;
            }
            for (ConceptPropertyComponent item : this.property) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ConceptPropertyComponent addProperty() {
            ConceptPropertyComponent t = new ConceptPropertyComponent();
            if (this.property == null) {
                this.property = new ArrayList<ConceptPropertyComponent>();
            }
            this.property.add(t);
            return t;
        }

        public ValueSetExpansionContainsComponent addProperty(ConceptPropertyComponent t) {
            if (t == null) {
                return this;
            }
            if (this.property == null) {
                this.property = new ArrayList<ConceptPropertyComponent>();
            }
            this.property.add(t);
            return this;
        }

        public ConceptPropertyComponent getPropertyFirstRep() {
            if (this.getProperty().isEmpty()) {
                this.addProperty();
            }
            return this.getProperty().get(0);
        }

        public List<ValueSetExpansionContainsComponent> getContains() {
            if (this.contains == null) {
                this.contains = new ArrayList<ValueSetExpansionContainsComponent>();
            }
            return this.contains;
        }

        public ValueSetExpansionContainsComponent setContains(List<ValueSetExpansionContainsComponent> theContains) {
            this.contains = theContains;
            return this;
        }

        public boolean hasContains() {
            if (this.contains == null) {
                return false;
            }
            for (ValueSetExpansionContainsComponent item : this.contains) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ValueSetExpansionContainsComponent addContains() {
            ValueSetExpansionContainsComponent t = new ValueSetExpansionContainsComponent();
            if (this.contains == null) {
                this.contains = new ArrayList<ValueSetExpansionContainsComponent>();
            }
            this.contains.add(t);
            return t;
        }

        public ValueSetExpansionContainsComponent addContains(ValueSetExpansionContainsComponent t) {
            if (t == null) {
                return this;
            }
            if (this.contains == null) {
                this.contains = new ArrayList<ValueSetExpansionContainsComponent>();
            }
            this.contains.add(t);
            return this;
        }

        public ValueSetExpansionContainsComponent getContainsFirstRep() {
            if (this.getContains().isEmpty()) {
                this.addContains();
            }
            return this.getContains().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("system", "uri", "An absolute URI which is the code system in which the code for this item in the expansion is defined.", 0, 1, this.system));
            children.add(new Property("abstract", "boolean", "If true, this entry is included in the expansion for navigational purposes, and the user cannot select the code directly as a proper value.", 0, 1, this.abstract_));
            children.add(new Property("inactive", "boolean", "If the concept is inactive in the code system that defines it. Inactive codes are those that are no longer to be used, but are maintained by the code system for understanding legacy data. It might not be known or specified whether a concept is inactive (and it may depend on the context of use).", 0, 1, this.inactive));
            children.add(new Property(ValueSet.SP_VERSION, "string", "The version of the code system from this code was taken. Note that a well-maintained code system does not need the version reported, because the meaning of codes is consistent across versions. However this cannot consistently be assured, and when the meaning is not guaranteed to be consistent, the version SHOULD be exchanged.", 0, 1, this.version));
            children.add(new Property(ValueSet.SP_CODE, ValueSet.SP_CODE, "The code for this item in the expansion hierarchy. If this code is missing the entry in the hierarchy is a place holder (abstract) and does not represent a valid code in the value set.", 0, 1, this.code));
            children.add(new Property("display", "string", "The recommended display for this item in the expansion.", 0, 1, this.display));
            children.add(new Property("designation", "@ValueSet.compose.include.concept.designation", "Additional representations for this item - other languages, aliases, specialized purposes, used for particular purposes, etc. These are relevant when the conditions of the expansion do not fix to a single correct representation.", 0, Integer.MAX_VALUE, this.designation));
            children.add(new Property("property", "", "A property value for this concept.", 0, Integer.MAX_VALUE, this.property));
            children.add(new Property("contains", "@ValueSet.expansion.contains", "Other codes and entries contained under this entry in the hierarchy.", 0, Integer.MAX_VALUE, this.contains));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -887328209: {
                    return new Property("system", "uri", "An absolute URI which is the code system in which the code for this item in the expansion is defined.", 0, 1, this.system);
                }
                case 1732898850: {
                    return new Property("abstract", "boolean", "If true, this entry is included in the expansion for navigational purposes, and the user cannot select the code directly as a proper value.", 0, 1, this.abstract_);
                }
                case 24665195: {
                    return new Property("inactive", "boolean", "If the concept is inactive in the code system that defines it. Inactive codes are those that are no longer to be used, but are maintained by the code system for understanding legacy data. It might not be known or specified whether a concept is inactive (and it may depend on the context of use).", 0, 1, this.inactive);
                }
                case 351608024: {
                    return new Property(ValueSet.SP_VERSION, "string", "The version of the code system from this code was taken. Note that a well-maintained code system does not need the version reported, because the meaning of codes is consistent across versions. However this cannot consistently be assured, and when the meaning is not guaranteed to be consistent, the version SHOULD be exchanged.", 0, 1, this.version);
                }
                case 3059181: {
                    return new Property(ValueSet.SP_CODE, ValueSet.SP_CODE, "The code for this item in the expansion hierarchy. If this code is missing the entry in the hierarchy is a place holder (abstract) and does not represent a valid code in the value set.", 0, 1, this.code);
                }
                case 1671764162: {
                    return new Property("display", "string", "The recommended display for this item in the expansion.", 0, 1, this.display);
                }
                case -900931593: {
                    return new Property("designation", "@ValueSet.compose.include.concept.designation", "Additional representations for this item - other languages, aliases, specialized purposes, used for particular purposes, etc. These are relevant when the conditions of the expansion do not fix to a single correct representation.", 0, Integer.MAX_VALUE, this.designation);
                }
                case -993141291: {
                    return new Property("property", "", "A property value for this concept.", 0, Integer.MAX_VALUE, this.property);
                }
                case -567445985: {
                    return new Property("contains", "@ValueSet.expansion.contains", "Other codes and entries contained under this entry in the hierarchy.", 0, Integer.MAX_VALUE, this.contains);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -887328209: {
                    Base[] baseArray;
                    if (this.system == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.system;
                    }
                    return baseArray;
                }
                case 1732898850: {
                    Base[] baseArray;
                    if (this.abstract_ == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.abstract_;
                    }
                    return baseArray;
                }
                case 24665195: {
                    Base[] baseArray;
                    if (this.inactive == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.inactive;
                    }
                    return baseArray;
                }
                case 351608024: {
                    Base[] baseArray;
                    if (this.version == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.version;
                    }
                    return baseArray;
                }
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.code;
                    }
                    return baseArray;
                }
                case 1671764162: {
                    Base[] baseArray;
                    if (this.display == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.display;
                    }
                    return baseArray;
                }
                case -900931593: {
                    return this.designation == null ? new Base[]{} : this.designation.toArray(new Base[this.designation.size()]);
                }
                case -993141291: {
                    return this.property == null ? new Base[]{} : this.property.toArray(new Base[this.property.size()]);
                }
                case -567445985: {
                    return this.contains == null ? new Base[]{} : this.contains.toArray(new Base[this.contains.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -887328209: {
                    this.system = TypeConvertor.castToUri(value);
                    return value;
                }
                case 1732898850: {
                    this.abstract_ = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case 24665195: {
                    this.inactive = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case 351608024: {
                    this.version = TypeConvertor.castToString(value);
                    return value;
                }
                case 3059181: {
                    this.code = TypeConvertor.castToCode(value);
                    return value;
                }
                case 1671764162: {
                    this.display = TypeConvertor.castToString(value);
                    return value;
                }
                case -900931593: {
                    this.getDesignation().add((ConceptReferenceDesignationComponent)value);
                    return value;
                }
                case -993141291: {
                    this.getProperty().add((ConceptPropertyComponent)value);
                    return value;
                }
                case -567445985: {
                    this.getContains().add((ValueSetExpansionContainsComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("system")) {
                this.system = TypeConvertor.castToUri(value);
            } else if (name.equals("abstract")) {
                this.abstract_ = TypeConvertor.castToBoolean(value);
            } else if (name.equals("inactive")) {
                this.inactive = TypeConvertor.castToBoolean(value);
            } else if (name.equals(ValueSet.SP_VERSION)) {
                this.version = TypeConvertor.castToString(value);
            } else if (name.equals(ValueSet.SP_CODE)) {
                this.code = TypeConvertor.castToCode(value);
            } else if (name.equals("display")) {
                this.display = TypeConvertor.castToString(value);
            } else if (name.equals("designation")) {
                this.getDesignation().add((ConceptReferenceDesignationComponent)value);
            } else if (name.equals("property")) {
                this.getProperty().add((ConceptPropertyComponent)value);
            } else if (name.equals("contains")) {
                this.getContains().add((ValueSetExpansionContainsComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("system")) {
                this.system = null;
            } else if (name.equals("abstract")) {
                this.abstract_ = null;
            } else if (name.equals("inactive")) {
                this.inactive = null;
            } else if (name.equals(ValueSet.SP_VERSION)) {
                this.version = null;
            } else if (name.equals(ValueSet.SP_CODE)) {
                this.code = null;
            } else if (name.equals("display")) {
                this.display = null;
            } else if (name.equals("designation")) {
                this.getDesignation().remove((ConceptReferenceDesignationComponent)value);
            } else if (name.equals("property")) {
                this.getProperty().remove((ConceptPropertyComponent)value);
            } else if (name.equals("contains")) {
                this.getContains().remove((ValueSetExpansionContainsComponent)value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -887328209: {
                    return this.getSystemElement();
                }
                case 1732898850: {
                    return this.getAbstractElement();
                }
                case 24665195: {
                    return this.getInactiveElement();
                }
                case 351608024: {
                    return this.getVersionElement();
                }
                case 3059181: {
                    return this.getCodeElement();
                }
                case 1671764162: {
                    return this.getDisplayElement();
                }
                case -900931593: {
                    return this.addDesignation();
                }
                case -993141291: {
                    return this.addProperty();
                }
                case -567445985: {
                    return this.addContains();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -887328209: {
                    return new String[]{"uri"};
                }
                case 1732898850: {
                    return new String[]{"boolean"};
                }
                case 24665195: {
                    return new String[]{"boolean"};
                }
                case 351608024: {
                    return new String[]{"string"};
                }
                case 3059181: {
                    return new String[]{ValueSet.SP_CODE};
                }
                case 1671764162: {
                    return new String[]{"string"};
                }
                case -900931593: {
                    return new String[]{"@ValueSet.compose.include.concept.designation"};
                }
                case -993141291: {
                    return new String[0];
                }
                case -567445985: {
                    return new String[]{"@ValueSet.expansion.contains"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("system")) {
                throw new FHIRException("Cannot call addChild on a singleton property ValueSet.expansion.contains.system");
            }
            if (name.equals("abstract")) {
                throw new FHIRException("Cannot call addChild on a singleton property ValueSet.expansion.contains.abstract");
            }
            if (name.equals("inactive")) {
                throw new FHIRException("Cannot call addChild on a singleton property ValueSet.expansion.contains.inactive");
            }
            if (name.equals(ValueSet.SP_VERSION)) {
                throw new FHIRException("Cannot call addChild on a singleton property ValueSet.expansion.contains.version");
            }
            if (name.equals(ValueSet.SP_CODE)) {
                throw new FHIRException("Cannot call addChild on a singleton property ValueSet.expansion.contains.code");
            }
            if (name.equals("display")) {
                throw new FHIRException("Cannot call addChild on a singleton property ValueSet.expansion.contains.display");
            }
            if (name.equals("designation")) {
                return this.addDesignation();
            }
            if (name.equals("property")) {
                return this.addProperty();
            }
            if (name.equals("contains")) {
                return this.addContains();
            }
            return super.addChild(name);
        }

        @Override
        public ValueSetExpansionContainsComponent copy() {
            ValueSetExpansionContainsComponent dst = new ValueSetExpansionContainsComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ValueSetExpansionContainsComponent dst) {
            super.copyValues(dst);
            dst.system = this.system == null ? null : this.system.copy();
            dst.abstract_ = this.abstract_ == null ? null : this.abstract_.copy();
            dst.inactive = this.inactive == null ? null : this.inactive.copy();
            dst.version = this.version == null ? null : this.version.copy();
            dst.code = this.code == null ? null : this.code.copy();
            StringType stringType = dst.display = this.display == null ? null : this.display.copy();
            if (this.designation != null) {
                dst.designation = new ArrayList<ConceptReferenceDesignationComponent>();
                for (ConceptReferenceDesignationComponent conceptReferenceDesignationComponent : this.designation) {
                    dst.designation.add(conceptReferenceDesignationComponent.copy());
                }
            }
            if (this.property != null) {
                dst.property = new ArrayList<ConceptPropertyComponent>();
                for (ConceptPropertyComponent conceptPropertyComponent : this.property) {
                    dst.property.add(conceptPropertyComponent.copy());
                }
            }
            if (this.contains != null) {
                dst.contains = new ArrayList<ValueSetExpansionContainsComponent>();
                for (ValueSetExpansionContainsComponent valueSetExpansionContainsComponent : this.contains) {
                    dst.contains.add(valueSetExpansionContainsComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ValueSetExpansionContainsComponent)) {
                return false;
            }
            ValueSetExpansionContainsComponent o = (ValueSetExpansionContainsComponent)other_;
            return ValueSetExpansionContainsComponent.compareDeep(this.system, o.system, true) && ValueSetExpansionContainsComponent.compareDeep(this.abstract_, o.abstract_, true) && ValueSetExpansionContainsComponent.compareDeep(this.inactive, o.inactive, true) && ValueSetExpansionContainsComponent.compareDeep(this.version, o.version, true) && ValueSetExpansionContainsComponent.compareDeep(this.code, o.code, true) && ValueSetExpansionContainsComponent.compareDeep(this.display, o.display, true) && ValueSetExpansionContainsComponent.compareDeep(this.designation, o.designation, true) && ValueSetExpansionContainsComponent.compareDeep(this.property, o.property, true) && ValueSetExpansionContainsComponent.compareDeep(this.contains, o.contains, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ValueSetExpansionContainsComponent)) {
                return false;
            }
            ValueSetExpansionContainsComponent o = (ValueSetExpansionContainsComponent)other_;
            return ValueSetExpansionContainsComponent.compareValues(this.system, o.system, true) && ValueSetExpansionContainsComponent.compareValues(this.abstract_, o.abstract_, true) && ValueSetExpansionContainsComponent.compareValues(this.inactive, o.inactive, true) && ValueSetExpansionContainsComponent.compareValues(this.version, o.version, true) && ValueSetExpansionContainsComponent.compareValues(this.code, o.code, true) && ValueSetExpansionContainsComponent.compareValues(this.display, o.display, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.system, this.abstract_, this.inactive, this.version, this.code, this.display, this.designation, this.property, this.contains});
        }

        @Override
        public String fhirType() {
            return "ValueSet.expansion.contains";
        }
    }

    @Block
    public static class ValueSetExpansionPropertyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Identifies the property on the concepts, and when referred to in operations", formalDefinition="A code that is used to identify the property. The code is used in ValueSet.expansion.contains.property.code.")
        protected CodeType code;
        @Child(name="uri", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Formal identifier for the property", formalDefinition="Reference to the formal meaning of the property. One possible source of meaning is the [Concept Properties](codesystem-concept-properties.html) code system.")
        protected UriType uri;
        private static final long serialVersionUID = 929575836L;

        public ValueSetExpansionPropertyComponent() {
        }

        public ValueSetExpansionPropertyComponent(String code) {
            this.setCode(code);
        }

        public CodeType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetExpansionPropertyComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ValueSetExpansionPropertyComponent setCodeElement(CodeType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public ValueSetExpansionPropertyComponent setCode(String value) {
            if (this.code == null) {
                this.code = new CodeType();
            }
            this.code.setValue(value);
            return this;
        }

        public UriType getUriElement() {
            if (this.uri == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetExpansionPropertyComponent.uri");
                }
                if (Configuration.doAutoCreate()) {
                    this.uri = new UriType();
                }
            }
            return this.uri;
        }

        public boolean hasUriElement() {
            return this.uri != null && !this.uri.isEmpty();
        }

        public boolean hasUri() {
            return this.uri != null && !this.uri.isEmpty();
        }

        public ValueSetExpansionPropertyComponent setUriElement(UriType value) {
            this.uri = value;
            return this;
        }

        public String getUri() {
            return this.uri == null ? null : (String)this.uri.getValue();
        }

        public ValueSetExpansionPropertyComponent setUri(String value) {
            if (Utilities.noString((String)value)) {
                this.uri = null;
            } else {
                if (this.uri == null) {
                    this.uri = new UriType();
                }
                this.uri.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(ValueSet.SP_CODE, ValueSet.SP_CODE, "A code that is used to identify the property. The code is used in ValueSet.expansion.contains.property.code.", 0, 1, this.code));
            children.add(new Property("uri", "uri", "Reference to the formal meaning of the property. One possible source of meaning is the [Concept Properties](codesystem-concept-properties.html) code system.", 0, 1, this.uri));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property(ValueSet.SP_CODE, ValueSet.SP_CODE, "A code that is used to identify the property. The code is used in ValueSet.expansion.contains.property.code.", 0, 1, this.code);
                }
                case 116076: {
                    return new Property("uri", "uri", "Reference to the formal meaning of the property. One possible source of meaning is the [Concept Properties](codesystem-concept-properties.html) code system.", 0, 1, this.uri);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 116076: {
                    Base[] baseArray;
                    if (this.uri == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.uri;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCode(value);
                    return value;
                }
                case 116076: {
                    this.uri = TypeConvertor.castToUri(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ValueSet.SP_CODE)) {
                this.code = TypeConvertor.castToCode(value);
            } else if (name.equals("uri")) {
                this.uri = TypeConvertor.castToUri(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals(ValueSet.SP_CODE)) {
                this.code = null;
            } else if (name.equals("uri")) {
                this.uri = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCodeElement();
                }
                case 116076: {
                    return this.getUriElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{ValueSet.SP_CODE};
                }
                case 116076: {
                    return new String[]{"uri"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ValueSet.SP_CODE)) {
                throw new FHIRException("Cannot call addChild on a singleton property ValueSet.expansion.property.code");
            }
            if (name.equals("uri")) {
                throw new FHIRException("Cannot call addChild on a singleton property ValueSet.expansion.property.uri");
            }
            return super.addChild(name);
        }

        @Override
        public ValueSetExpansionPropertyComponent copy() {
            ValueSetExpansionPropertyComponent dst = new ValueSetExpansionPropertyComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ValueSetExpansionPropertyComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.uri = this.uri == null ? null : this.uri.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ValueSetExpansionPropertyComponent)) {
                return false;
            }
            ValueSetExpansionPropertyComponent o = (ValueSetExpansionPropertyComponent)other_;
            return ValueSetExpansionPropertyComponent.compareDeep(this.code, o.code, true) && ValueSetExpansionPropertyComponent.compareDeep(this.uri, o.uri, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ValueSetExpansionPropertyComponent)) {
                return false;
            }
            ValueSetExpansionPropertyComponent o = (ValueSetExpansionPropertyComponent)other_;
            return ValueSetExpansionPropertyComponent.compareValues(this.code, o.code, true) && ValueSetExpansionPropertyComponent.compareValues(this.uri, o.uri, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.code, this.uri});
        }

        @Override
        public String fhirType() {
            return "ValueSet.expansion.property";
        }
    }

    @Block
    public static class ValueSetExpansionParameterComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Name as assigned by the client or server", formalDefinition="Name of the input parameter to the $expand operation; may be a server-assigned name for additional default or other server-supplied parameters used to control the expansion process.")
        protected StringType name;
        @Child(name="value", type={StringType.class, BooleanType.class, IntegerType.class, DecimalType.class, UriType.class, CodeType.class, DateTimeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Value of the named parameter", formalDefinition="The value of the parameter.")
        protected DataType value;
        private static final long serialVersionUID = 1839679495L;

        public ValueSetExpansionParameterComponent() {
        }

        public ValueSetExpansionParameterComponent(String name) {
            this.setName(name);
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetExpansionParameterComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ValueSetExpansionParameterComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ValueSetExpansionParameterComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public StringType getValueStringType() throws FHIRException {
            if (this.value == null) {
                this.value = new StringType();
            }
            if (!(this.value instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (StringType)this.value;
        }

        public boolean hasValueStringType() {
            return this != null && this.value instanceof StringType;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (this.value == null) {
                this.value = new BooleanType();
            }
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this != null && this.value instanceof BooleanType;
        }

        public IntegerType getValueIntegerType() throws FHIRException {
            if (this.value == null) {
                this.value = new IntegerType();
            }
            if (!(this.value instanceof IntegerType)) {
                throw new FHIRException("Type mismatch: the type IntegerType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (IntegerType)this.value;
        }

        public boolean hasValueIntegerType() {
            return this != null && this.value instanceof IntegerType;
        }

        public DecimalType getValueDecimalType() throws FHIRException {
            if (this.value == null) {
                this.value = new DecimalType();
            }
            if (!(this.value instanceof DecimalType)) {
                throw new FHIRException("Type mismatch: the type DecimalType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DecimalType)this.value;
        }

        public boolean hasValueDecimalType() {
            return this != null && this.value instanceof DecimalType;
        }

        public UriType getValueUriType() throws FHIRException {
            if (this.value == null) {
                this.value = new UriType();
            }
            if (!(this.value instanceof UriType)) {
                throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (UriType)this.value;
        }

        public boolean hasValueUriType() {
            return this != null && this.value instanceof UriType;
        }

        public CodeType getValueCodeType() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeType();
            }
            if (!(this.value instanceof CodeType)) {
                throw new FHIRException("Type mismatch: the type CodeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeType)this.value;
        }

        public boolean hasValueCodeType() {
            return this != null && this.value instanceof CodeType;
        }

        public DateTimeType getValueDateTimeType() throws FHIRException {
            if (this.value == null) {
                this.value = new DateTimeType();
            }
            if (!(this.value instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.value;
        }

        public boolean hasValueDateTimeType() {
            return this != null && this.value instanceof DateTimeType;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ValueSetExpansionParameterComponent setValue(DataType value) {
            if (!(value == null || value instanceof StringType || value instanceof BooleanType || value instanceof IntegerType || value instanceof DecimalType || value instanceof UriType || value instanceof CodeType || value instanceof DateTimeType)) {
                throw new FHIRException("Not the right type for ValueSet.expansion.parameter.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(ValueSet.SP_NAME, "string", "Name of the input parameter to the $expand operation; may be a server-assigned name for additional default or other server-supplied parameters used to control the expansion process.", 0, 1, this.name));
            children.add(new Property("value[x]", "string|boolean|integer|decimal|uri|code|dateTime", "The value of the parameter.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property(ValueSet.SP_NAME, "string", "Name of the input parameter to the $expand operation; may be a server-assigned name for additional default or other server-supplied parameters used to control the expansion process.", 0, 1, this.name);
                }
                case -1410166417: {
                    return new Property("value[x]", "string|boolean|integer|decimal|uri|code|dateTime", "The value of the parameter.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "string|boolean|integer|decimal|uri|code|dateTime", "The value of the parameter.", 0, 1, this.value);
                }
                case -1424603934: {
                    return new Property("value[x]", "string", "The value of the parameter.", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "boolean", "The value of the parameter.", 0, 1, this.value);
                }
                case -1668204915: {
                    return new Property("value[x]", "integer", "The value of the parameter.", 0, 1, this.value);
                }
                case -2083993440: {
                    return new Property("value[x]", "decimal", "The value of the parameter.", 0, 1, this.value);
                }
                case -1410172357: {
                    return new Property("value[x]", "uri", "The value of the parameter.", 0, 1, this.value);
                }
                case -766209282: {
                    return new Property("value[x]", ValueSet.SP_CODE, "The value of the parameter.", 0, 1, this.value);
                }
                case 1047929900: {
                    return new Property("value[x]", "dateTime", "The value of the parameter.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = TypeConvertor.castToString(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ValueSet.SP_NAME)) {
                this.name = TypeConvertor.castToString(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals(ValueSet.SP_NAME)) {
                this.name = null;
            } else if (name.equals("value[x]")) {
                this.value = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"string"};
                }
                case 111972721: {
                    return new String[]{"string", "boolean", "integer", "decimal", "uri", ValueSet.SP_CODE, "dateTime"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ValueSet.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a singleton property ValueSet.expansion.parameter.name");
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueInteger")) {
                this.value = new IntegerType();
                return this.value;
            }
            if (name.equals("valueDecimal")) {
                this.value = new DecimalType();
                return this.value;
            }
            if (name.equals("valueUri")) {
                this.value = new UriType();
                return this.value;
            }
            if (name.equals("valueCode")) {
                this.value = new CodeType();
                return this.value;
            }
            if (name.equals("valueDateTime")) {
                this.value = new DateTimeType();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public ValueSetExpansionParameterComponent copy() {
            ValueSetExpansionParameterComponent dst = new ValueSetExpansionParameterComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ValueSetExpansionParameterComponent dst) {
            super.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ValueSetExpansionParameterComponent)) {
                return false;
            }
            ValueSetExpansionParameterComponent o = (ValueSetExpansionParameterComponent)other_;
            return ValueSetExpansionParameterComponent.compareDeep(this.name, o.name, true) && ValueSetExpansionParameterComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ValueSetExpansionParameterComponent)) {
                return false;
            }
            ValueSetExpansionParameterComponent o = (ValueSetExpansionParameterComponent)other_;
            return ValueSetExpansionParameterComponent.compareValues(this.name, o.name, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.name, this.value});
        }

        @Override
        public String fhirType() {
            return "ValueSet.expansion.parameter";
        }

        public String toString() {
            String s = this.hasValue() ? this.getValue().primitiveValue() : "";
            return this.getName() + "=" + s;
        }
    }

    @Block
    public static class ValueSetExpansionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={UriType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Identifies the value set expansion (business identifier)", formalDefinition="An identifier that uniquely identifies this expansion of the valueset, based on a unique combination of the provided parameters, the system default parameters, and the underlying system code system versions etc. Systems may re-use the same identifier as long as those factors remain the same, and the expansion is the same, but are not required to do so. This is a business identifier.")
        protected UriType identifier;
        @Child(name="next", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Opaque urls for paging through expansion results", formalDefinition="As per paging Search results, the next URLs are opaque to the client, have no dictated structure, and only the server understands them.")
        protected UriType next;
        @Child(name="timestamp", type={DateTimeType.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Time ValueSet expansion happened", formalDefinition="The time at which the expansion was produced by the expanding system.")
        protected DateTimeType timestamp;
        @Child(name="total", type={IntegerType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Total number of codes in the expansion", formalDefinition="The total number of concepts in the expansion. If the number of concept nodes in this resource is less than the stated number, then the server can return more using the offset parameter.")
        protected IntegerType total;
        @Child(name="offset", type={IntegerType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Offset at which this resource starts", formalDefinition="If paging is being used, the offset at which this resource starts.  I.e. this resource is a partial view into the expansion. If paging is not being used, this element SHALL NOT be present.")
        protected IntegerType offset;
        @Child(name="parameter", type={}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Parameter that controlled the expansion process", formalDefinition="A parameter that controlled the expansion process. These parameters may be used by users of expanded value sets to check whether the expansion is suitable for a particular purpose, or to pick the correct expansion.")
        protected List<ValueSetExpansionParameterComponent> parameter;
        @Child(name="property", type={}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Additional information supplied about each concept", formalDefinition="A property defines an additional slot through which additional information can be provided about a concept.")
        protected List<ValueSetExpansionPropertyComponent> property;
        @Child(name="contains", type={}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Codes in the value set", formalDefinition="The codes that are contained in the value set expansion.")
        protected List<ValueSetExpansionContainsComponent> contains;
        private static final long serialVersionUID = 1141573269L;

        public ValueSetExpansionComponent() {
        }

        public ValueSetExpansionComponent(Date timestamp) {
            this.setTimestamp(timestamp);
        }

        public UriType getIdentifierElement() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetExpansionComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new UriType();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifierElement() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public ValueSetExpansionComponent setIdentifierElement(UriType value) {
            this.identifier = value;
            return this;
        }

        public String getIdentifier() {
            return this.identifier == null ? null : (String)this.identifier.getValue();
        }

        public ValueSetExpansionComponent setIdentifier(String value) {
            if (Utilities.noString((String)value)) {
                this.identifier = null;
            } else {
                if (this.identifier == null) {
                    this.identifier = new UriType();
                }
                this.identifier.setValue(value);
            }
            return this;
        }

        public UriType getNextElement() {
            if (this.next == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetExpansionComponent.next");
                }
                if (Configuration.doAutoCreate()) {
                    this.next = new UriType();
                }
            }
            return this.next;
        }

        public boolean hasNextElement() {
            return this.next != null && !this.next.isEmpty();
        }

        public boolean hasNext() {
            return this.next != null && !this.next.isEmpty();
        }

        public ValueSetExpansionComponent setNextElement(UriType value) {
            this.next = value;
            return this;
        }

        public String getNext() {
            return this.next == null ? null : (String)this.next.getValue();
        }

        public ValueSetExpansionComponent setNext(String value) {
            if (Utilities.noString((String)value)) {
                this.next = null;
            } else {
                if (this.next == null) {
                    this.next = new UriType();
                }
                this.next.setValue(value);
            }
            return this;
        }

        public DateTimeType getTimestampElement() {
            if (this.timestamp == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetExpansionComponent.timestamp");
                }
                if (Configuration.doAutoCreate()) {
                    this.timestamp = new DateTimeType();
                }
            }
            return this.timestamp;
        }

        public boolean hasTimestampElement() {
            return this.timestamp != null && !this.timestamp.isEmpty();
        }

        public boolean hasTimestamp() {
            return this.timestamp != null && !this.timestamp.isEmpty();
        }

        public ValueSetExpansionComponent setTimestampElement(DateTimeType value) {
            this.timestamp = value;
            return this;
        }

        public Date getTimestamp() {
            return this.timestamp == null ? null : (Date)this.timestamp.getValue();
        }

        public ValueSetExpansionComponent setTimestamp(Date value) {
            if (this.timestamp == null) {
                this.timestamp = new DateTimeType();
            }
            this.timestamp.setValue(value);
            return this;
        }

        public IntegerType getTotalElement() {
            if (this.total == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetExpansionComponent.total");
                }
                if (Configuration.doAutoCreate()) {
                    this.total = new IntegerType();
                }
            }
            return this.total;
        }

        public boolean hasTotalElement() {
            return this.total != null && !this.total.isEmpty();
        }

        public boolean hasTotal() {
            return this.total != null && !this.total.isEmpty();
        }

        public ValueSetExpansionComponent setTotalElement(IntegerType value) {
            this.total = value;
            return this;
        }

        public int getTotal() {
            return this.total == null || this.total.isEmpty() ? 0 : (Integer)this.total.getValue();
        }

        public ValueSetExpansionComponent setTotal(int value) {
            if (this.total == null) {
                this.total = new IntegerType();
            }
            this.total.setValue((Object)value);
            return this;
        }

        public IntegerType getOffsetElement() {
            if (this.offset == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetExpansionComponent.offset");
                }
                if (Configuration.doAutoCreate()) {
                    this.offset = new IntegerType();
                }
            }
            return this.offset;
        }

        public boolean hasOffsetElement() {
            return this.offset != null && !this.offset.isEmpty();
        }

        public boolean hasOffset() {
            return this.offset != null && !this.offset.isEmpty();
        }

        public ValueSetExpansionComponent setOffsetElement(IntegerType value) {
            this.offset = value;
            return this;
        }

        public int getOffset() {
            return this.offset == null || this.offset.isEmpty() ? 0 : (Integer)this.offset.getValue();
        }

        public ValueSetExpansionComponent setOffset(int value) {
            if (this.offset == null) {
                this.offset = new IntegerType();
            }
            this.offset.setValue((Object)value);
            return this;
        }

        public List<ValueSetExpansionParameterComponent> getParameter() {
            if (this.parameter == null) {
                this.parameter = new ArrayList<ValueSetExpansionParameterComponent>();
            }
            return this.parameter;
        }

        public ValueSetExpansionComponent setParameter(List<ValueSetExpansionParameterComponent> theParameter) {
            this.parameter = theParameter;
            return this;
        }

        public boolean hasParameter() {
            if (this.parameter == null) {
                return false;
            }
            for (ValueSetExpansionParameterComponent item : this.parameter) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ValueSetExpansionParameterComponent addParameter() {
            ValueSetExpansionParameterComponent t = new ValueSetExpansionParameterComponent();
            if (this.parameter == null) {
                this.parameter = new ArrayList<ValueSetExpansionParameterComponent>();
            }
            this.parameter.add(t);
            return t;
        }

        public ValueSetExpansionComponent addParameter(ValueSetExpansionParameterComponent t) {
            if (t == null) {
                return this;
            }
            if (this.parameter == null) {
                this.parameter = new ArrayList<ValueSetExpansionParameterComponent>();
            }
            this.parameter.add(t);
            return this;
        }

        public ValueSetExpansionParameterComponent getParameterFirstRep() {
            if (this.getParameter().isEmpty()) {
                this.addParameter();
            }
            return this.getParameter().get(0);
        }

        public List<ValueSetExpansionPropertyComponent> getProperty() {
            if (this.property == null) {
                this.property = new ArrayList<ValueSetExpansionPropertyComponent>();
            }
            return this.property;
        }

        public ValueSetExpansionComponent setProperty(List<ValueSetExpansionPropertyComponent> theProperty) {
            this.property = theProperty;
            return this;
        }

        public boolean hasProperty() {
            if (this.property == null) {
                return false;
            }
            for (ValueSetExpansionPropertyComponent item : this.property) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ValueSetExpansionPropertyComponent addProperty() {
            ValueSetExpansionPropertyComponent t = new ValueSetExpansionPropertyComponent();
            if (this.property == null) {
                this.property = new ArrayList<ValueSetExpansionPropertyComponent>();
            }
            this.property.add(t);
            return t;
        }

        public ValueSetExpansionComponent addProperty(ValueSetExpansionPropertyComponent t) {
            if (t == null) {
                return this;
            }
            if (this.property == null) {
                this.property = new ArrayList<ValueSetExpansionPropertyComponent>();
            }
            this.property.add(t);
            return this;
        }

        public ValueSetExpansionPropertyComponent getPropertyFirstRep() {
            if (this.getProperty().isEmpty()) {
                this.addProperty();
            }
            return this.getProperty().get(0);
        }

        public List<ValueSetExpansionContainsComponent> getContains() {
            if (this.contains == null) {
                this.contains = new ArrayList<ValueSetExpansionContainsComponent>();
            }
            return this.contains;
        }

        public ValueSetExpansionComponent setContains(List<ValueSetExpansionContainsComponent> theContains) {
            this.contains = theContains;
            return this;
        }

        public boolean hasContains() {
            if (this.contains == null) {
                return false;
            }
            for (ValueSetExpansionContainsComponent item : this.contains) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ValueSetExpansionContainsComponent addContains() {
            ValueSetExpansionContainsComponent t = new ValueSetExpansionContainsComponent();
            if (this.contains == null) {
                this.contains = new ArrayList<ValueSetExpansionContainsComponent>();
            }
            this.contains.add(t);
            return t;
        }

        public ValueSetExpansionComponent addContains(ValueSetExpansionContainsComponent t) {
            if (t == null) {
                return this;
            }
            if (this.contains == null) {
                this.contains = new ArrayList<ValueSetExpansionContainsComponent>();
            }
            this.contains.add(t);
            return this;
        }

        public ValueSetExpansionContainsComponent getContainsFirstRep() {
            if (this.getContains().isEmpty()) {
                this.addContains();
            }
            return this.getContains().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(ValueSet.SP_IDENTIFIER, "uri", "An identifier that uniquely identifies this expansion of the valueset, based on a unique combination of the provided parameters, the system default parameters, and the underlying system code system versions etc. Systems may re-use the same identifier as long as those factors remain the same, and the expansion is the same, but are not required to do so. This is a business identifier.", 0, 1, this.identifier));
            children.add(new Property("next", "uri", "As per paging Search results, the next URLs are opaque to the client, have no dictated structure, and only the server understands them.", 0, 1, this.next));
            children.add(new Property("timestamp", "dateTime", "The time at which the expansion was produced by the expanding system.", 0, 1, this.timestamp));
            children.add(new Property("total", "integer", "The total number of concepts in the expansion. If the number of concept nodes in this resource is less than the stated number, then the server can return more using the offset parameter.", 0, 1, this.total));
            children.add(new Property("offset", "integer", "If paging is being used, the offset at which this resource starts.  I.e. this resource is a partial view into the expansion. If paging is not being used, this element SHALL NOT be present.", 0, 1, this.offset));
            children.add(new Property("parameter", "", "A parameter that controlled the expansion process. These parameters may be used by users of expanded value sets to check whether the expansion is suitable for a particular purpose, or to pick the correct expansion.", 0, Integer.MAX_VALUE, this.parameter));
            children.add(new Property("property", "", "A property defines an additional slot through which additional information can be provided about a concept.", 0, Integer.MAX_VALUE, this.property));
            children.add(new Property("contains", "", "The codes that are contained in the value set expansion.", 0, Integer.MAX_VALUE, this.contains));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1618432855: {
                    return new Property(ValueSet.SP_IDENTIFIER, "uri", "An identifier that uniquely identifies this expansion of the valueset, based on a unique combination of the provided parameters, the system default parameters, and the underlying system code system versions etc. Systems may re-use the same identifier as long as those factors remain the same, and the expansion is the same, but are not required to do so. This is a business identifier.", 0, 1, this.identifier);
                }
                case 3377907: {
                    return new Property("next", "uri", "As per paging Search results, the next URLs are opaque to the client, have no dictated structure, and only the server understands them.", 0, 1, this.next);
                }
                case 55126294: {
                    return new Property("timestamp", "dateTime", "The time at which the expansion was produced by the expanding system.", 0, 1, this.timestamp);
                }
                case 110549828: {
                    return new Property("total", "integer", "The total number of concepts in the expansion. If the number of concept nodes in this resource is less than the stated number, then the server can return more using the offset parameter.", 0, 1, this.total);
                }
                case -1019779949: {
                    return new Property("offset", "integer", "If paging is being used, the offset at which this resource starts.  I.e. this resource is a partial view into the expansion. If paging is not being used, this element SHALL NOT be present.", 0, 1, this.offset);
                }
                case 1954460585: {
                    return new Property("parameter", "", "A parameter that controlled the expansion process. These parameters may be used by users of expanded value sets to check whether the expansion is suitable for a particular purpose, or to pick the correct expansion.", 0, Integer.MAX_VALUE, this.parameter);
                }
                case -993141291: {
                    return new Property("property", "", "A property defines an additional slot through which additional information can be provided about a concept.", 0, Integer.MAX_VALUE, this.property);
                }
                case -567445985: {
                    return new Property("contains", "", "The codes that are contained in the value set expansion.", 0, Integer.MAX_VALUE, this.contains);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.identifier;
                    }
                    return baseArray;
                }
                case 3377907: {
                    Base[] baseArray;
                    if (this.next == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.next;
                    }
                    return baseArray;
                }
                case 55126294: {
                    Base[] baseArray;
                    if (this.timestamp == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.timestamp;
                    }
                    return baseArray;
                }
                case 110549828: {
                    Base[] baseArray;
                    if (this.total == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.total;
                    }
                    return baseArray;
                }
                case -1019779949: {
                    Base[] baseArray;
                    if (this.offset == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.offset;
                    }
                    return baseArray;
                }
                case 1954460585: {
                    return this.parameter == null ? new Base[]{} : this.parameter.toArray(new Base[this.parameter.size()]);
                }
                case -993141291: {
                    return this.property == null ? new Base[]{} : this.property.toArray(new Base[this.property.size()]);
                }
                case -567445985: {
                    return this.contains == null ? new Base[]{} : this.contains.toArray(new Base[this.contains.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.identifier = TypeConvertor.castToUri(value);
                    return value;
                }
                case 3377907: {
                    this.next = TypeConvertor.castToUri(value);
                    return value;
                }
                case 55126294: {
                    this.timestamp = TypeConvertor.castToDateTime(value);
                    return value;
                }
                case 110549828: {
                    this.total = TypeConvertor.castToInteger(value);
                    return value;
                }
                case -1019779949: {
                    this.offset = TypeConvertor.castToInteger(value);
                    return value;
                }
                case 1954460585: {
                    this.getParameter().add((ValueSetExpansionParameterComponent)value);
                    return value;
                }
                case -993141291: {
                    this.getProperty().add((ValueSetExpansionPropertyComponent)value);
                    return value;
                }
                case -567445985: {
                    this.getContains().add((ValueSetExpansionContainsComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ValueSet.SP_IDENTIFIER)) {
                this.identifier = TypeConvertor.castToUri(value);
            } else if (name.equals("next")) {
                this.next = TypeConvertor.castToUri(value);
            } else if (name.equals("timestamp")) {
                this.timestamp = TypeConvertor.castToDateTime(value);
            } else if (name.equals("total")) {
                this.total = TypeConvertor.castToInteger(value);
            } else if (name.equals("offset")) {
                this.offset = TypeConvertor.castToInteger(value);
            } else if (name.equals("parameter")) {
                this.getParameter().add((ValueSetExpansionParameterComponent)value);
            } else if (name.equals("property")) {
                this.getProperty().add((ValueSetExpansionPropertyComponent)value);
            } else if (name.equals("contains")) {
                this.getContains().add((ValueSetExpansionContainsComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals(ValueSet.SP_IDENTIFIER)) {
                this.identifier = null;
            } else if (name.equals("next")) {
                this.next = null;
            } else if (name.equals("timestamp")) {
                this.timestamp = null;
            } else if (name.equals("total")) {
                this.total = null;
            } else if (name.equals("offset")) {
                this.offset = null;
            } else if (name.equals("parameter")) {
                this.getParameter().remove((ValueSetExpansionParameterComponent)value);
            } else if (name.equals("property")) {
                this.getProperty().remove((ValueSetExpansionPropertyComponent)value);
            } else if (name.equals("contains")) {
                this.getContains().remove((ValueSetExpansionContainsComponent)value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.getIdentifierElement();
                }
                case 3377907: {
                    return this.getNextElement();
                }
                case 55126294: {
                    return this.getTimestampElement();
                }
                case 110549828: {
                    return this.getTotalElement();
                }
                case -1019779949: {
                    return this.getOffsetElement();
                }
                case 1954460585: {
                    return this.addParameter();
                }
                case -993141291: {
                    return this.addProperty();
                }
                case -567445985: {
                    return this.addContains();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return new String[]{"uri"};
                }
                case 3377907: {
                    return new String[]{"uri"};
                }
                case 55126294: {
                    return new String[]{"dateTime"};
                }
                case 110549828: {
                    return new String[]{"integer"};
                }
                case -1019779949: {
                    return new String[]{"integer"};
                }
                case 1954460585: {
                    return new String[0];
                }
                case -993141291: {
                    return new String[0];
                }
                case -567445985: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ValueSet.SP_IDENTIFIER)) {
                throw new FHIRException("Cannot call addChild on a singleton property ValueSet.expansion.identifier");
            }
            if (name.equals("next")) {
                throw new FHIRException("Cannot call addChild on a singleton property ValueSet.expansion.next");
            }
            if (name.equals("timestamp")) {
                throw new FHIRException("Cannot call addChild on a singleton property ValueSet.expansion.timestamp");
            }
            if (name.equals("total")) {
                throw new FHIRException("Cannot call addChild on a singleton property ValueSet.expansion.total");
            }
            if (name.equals("offset")) {
                throw new FHIRException("Cannot call addChild on a singleton property ValueSet.expansion.offset");
            }
            if (name.equals("parameter")) {
                return this.addParameter();
            }
            if (name.equals("property")) {
                return this.addProperty();
            }
            if (name.equals("contains")) {
                return this.addContains();
            }
            return super.addChild(name);
        }

        @Override
        public ValueSetExpansionComponent copy() {
            ValueSetExpansionComponent dst = new ValueSetExpansionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ValueSetExpansionComponent dst) {
            super.copyValues(dst);
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            dst.next = this.next == null ? null : this.next.copy();
            dst.timestamp = this.timestamp == null ? null : this.timestamp.copy();
            dst.total = this.total == null ? null : this.total.copy();
            IntegerType integerType = dst.offset = this.offset == null ? null : this.offset.copy();
            if (this.parameter != null) {
                dst.parameter = new ArrayList<ValueSetExpansionParameterComponent>();
                for (ValueSetExpansionParameterComponent valueSetExpansionParameterComponent : this.parameter) {
                    dst.parameter.add(valueSetExpansionParameterComponent.copy());
                }
            }
            if (this.property != null) {
                dst.property = new ArrayList<ValueSetExpansionPropertyComponent>();
                for (ValueSetExpansionPropertyComponent valueSetExpansionPropertyComponent : this.property) {
                    dst.property.add(valueSetExpansionPropertyComponent.copy());
                }
            }
            if (this.contains != null) {
                dst.contains = new ArrayList<ValueSetExpansionContainsComponent>();
                for (ValueSetExpansionContainsComponent valueSetExpansionContainsComponent : this.contains) {
                    dst.contains.add(valueSetExpansionContainsComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ValueSetExpansionComponent)) {
                return false;
            }
            ValueSetExpansionComponent o = (ValueSetExpansionComponent)other_;
            return ValueSetExpansionComponent.compareDeep(this.identifier, o.identifier, true) && ValueSetExpansionComponent.compareDeep(this.next, o.next, true) && ValueSetExpansionComponent.compareDeep(this.timestamp, o.timestamp, true) && ValueSetExpansionComponent.compareDeep(this.total, o.total, true) && ValueSetExpansionComponent.compareDeep(this.offset, o.offset, true) && ValueSetExpansionComponent.compareDeep(this.parameter, o.parameter, true) && ValueSetExpansionComponent.compareDeep(this.property, o.property, true) && ValueSetExpansionComponent.compareDeep(this.contains, o.contains, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ValueSetExpansionComponent)) {
                return false;
            }
            ValueSetExpansionComponent o = (ValueSetExpansionComponent)other_;
            return ValueSetExpansionComponent.compareValues(this.identifier, o.identifier, true) && ValueSetExpansionComponent.compareValues(this.next, o.next, true) && ValueSetExpansionComponent.compareValues(this.timestamp, o.timestamp, true) && ValueSetExpansionComponent.compareValues(this.total, o.total, true) && ValueSetExpansionComponent.compareValues(this.offset, o.offset, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.next, this.timestamp, this.total, this.offset, this.parameter, this.property, this.contains});
        }

        public boolean hasParameterValue(String name, String value) {
            for (ValueSetExpansionParameterComponent p : this.getParameter()) {
                if (!name.equals(p.getName()) || !p.hasValue() || !value.equals(p.getValue().primitiveValue())) continue;
                return true;
            }
            return false;
        }

        public void addParameter(String name, DataType value) {
            this.getParameter().add(new ValueSetExpansionParameterComponent(name).setValue(value));
        }

        @Override
        public String fhirType() {
            return "ValueSet.expansion";
        }
    }

    @Block
    public static class ConceptSetFilterComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="property", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A property/filter defined by the code system", formalDefinition="A code that identifies a property or a filter defined in the code system.")
        protected CodeType property;
        @Child(name="op", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="= | is-a | descendent-of | is-not-a | regex | in | not-in | generalizes | child-of | descendent-leaf | exists", formalDefinition="The kind of operation to perform as a part of the filter criteria.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/filter-operator")
        protected Enumeration<Enumerations.FilterOperator> op;
        @Child(name="value", type={StringType.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Code from the system, or regex criteria, or boolean value for exists", formalDefinition="The match value may be either a code defined by the system, or a string value, which is a regex match on the literal string of the property value  (if the filter represents a property defined in CodeSystem) or of the system filter value (if the filter represents a filter defined in CodeSystem) when the operation is 'regex', or one of the values (true and false), when the operation is 'exists'.")
        protected StringType value;
        private static final long serialVersionUID = 1259153492L;

        public ConceptSetFilterComponent() {
        }

        public ConceptSetFilterComponent(String property, Enumerations.FilterOperator op, String value) {
            this.setProperty(property);
            this.setOp(op);
            this.setValue(value);
        }

        public CodeType getPropertyElement() {
            if (this.property == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptSetFilterComponent.property");
                }
                if (Configuration.doAutoCreate()) {
                    this.property = new CodeType();
                }
            }
            return this.property;
        }

        public boolean hasPropertyElement() {
            return this.property != null && !this.property.isEmpty();
        }

        public boolean hasProperty() {
            return this.property != null && !this.property.isEmpty();
        }

        public ConceptSetFilterComponent setPropertyElement(CodeType value) {
            this.property = value;
            return this;
        }

        public String getProperty() {
            return this.property == null ? null : (String)this.property.getValue();
        }

        public ConceptSetFilterComponent setProperty(String value) {
            if (this.property == null) {
                this.property = new CodeType();
            }
            this.property.setValue(value);
            return this;
        }

        public Enumeration<Enumerations.FilterOperator> getOpElement() {
            if (this.op == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptSetFilterComponent.op");
                }
                if (Configuration.doAutoCreate()) {
                    this.op = new Enumeration<Enumerations.FilterOperator>(new Enumerations.FilterOperatorEnumFactory());
                }
            }
            return this.op;
        }

        public boolean hasOpElement() {
            return this.op != null && !this.op.isEmpty();
        }

        public boolean hasOp() {
            return this.op != null && !this.op.isEmpty();
        }

        public ConceptSetFilterComponent setOpElement(Enumeration<Enumerations.FilterOperator> value) {
            this.op = value;
            return this;
        }

        public Enumerations.FilterOperator getOp() {
            return this.op == null ? null : (Enumerations.FilterOperator)((Object)this.op.getValue());
        }

        public ConceptSetFilterComponent setOp(Enumerations.FilterOperator value) {
            if (this.op == null) {
                this.op = new Enumeration<Enumerations.FilterOperator>(new Enumerations.FilterOperatorEnumFactory());
            }
            this.op.setValue((Object)value);
            return this;
        }

        public StringType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptSetFilterComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new StringType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ConceptSetFilterComponent setValueElement(StringType value) {
            this.value = value;
            return this;
        }

        public String getValue() {
            return this.value == null ? null : (String)this.value.getValue();
        }

        public ConceptSetFilterComponent setValue(String value) {
            if (this.value == null) {
                this.value = new StringType();
            }
            this.value.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("property", ValueSet.SP_CODE, "A code that identifies a property or a filter defined in the code system.", 0, 1, this.property));
            children.add(new Property("op", ValueSet.SP_CODE, "The kind of operation to perform as a part of the filter criteria.", 0, 1, this.op));
            children.add(new Property("value", "string", "The match value may be either a code defined by the system, or a string value, which is a regex match on the literal string of the property value  (if the filter represents a property defined in CodeSystem) or of the system filter value (if the filter represents a filter defined in CodeSystem) when the operation is 'regex', or one of the values (true and false), when the operation is 'exists'.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -993141291: {
                    return new Property("property", ValueSet.SP_CODE, "A code that identifies a property or a filter defined in the code system.", 0, 1, this.property);
                }
                case 3553: {
                    return new Property("op", ValueSet.SP_CODE, "The kind of operation to perform as a part of the filter criteria.", 0, 1, this.op);
                }
                case 111972721: {
                    return new Property("value", "string", "The match value may be either a code defined by the system, or a string value, which is a regex match on the literal string of the property value  (if the filter represents a property defined in CodeSystem) or of the system filter value (if the filter represents a filter defined in CodeSystem) when the operation is 'regex', or one of the values (true and false), when the operation is 'exists'.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -993141291: {
                    Base[] baseArray;
                    if (this.property == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.property;
                    }
                    return baseArray;
                }
                case 3553: {
                    Base[] baseArray;
                    if (this.op == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.op;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -993141291: {
                    this.property = TypeConvertor.castToCode(value);
                    return value;
                }
                case 3553: {
                    value = new Enumerations.FilterOperatorEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.op = value;
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("property")) {
                this.property = TypeConvertor.castToCode(value);
            } else if (name.equals("op")) {
                value = new Enumerations.FilterOperatorEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.op = value;
            } else if (name.equals("value")) {
                this.value = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("property")) {
                this.property = null;
            } else if (name.equals("op")) {
                value = new Enumerations.FilterOperatorEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.op = value;
            } else if (name.equals("value")) {
                this.value = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -993141291: {
                    return this.getPropertyElement();
                }
                case 3553: {
                    return this.getOpElement();
                }
                case 111972721: {
                    return this.getValueElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -993141291: {
                    return new String[]{ValueSet.SP_CODE};
                }
                case 3553: {
                    return new String[]{ValueSet.SP_CODE};
                }
                case 111972721: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("property")) {
                throw new FHIRException("Cannot call addChild on a singleton property ValueSet.compose.include.filter.property");
            }
            if (name.equals("op")) {
                throw new FHIRException("Cannot call addChild on a singleton property ValueSet.compose.include.filter.op");
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a singleton property ValueSet.compose.include.filter.value");
            }
            return super.addChild(name);
        }

        @Override
        public ConceptSetFilterComponent copy() {
            ConceptSetFilterComponent dst = new ConceptSetFilterComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ConceptSetFilterComponent dst) {
            super.copyValues(dst);
            dst.property = this.property == null ? null : this.property.copy();
            dst.op = this.op == null ? null : this.op.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ConceptSetFilterComponent)) {
                return false;
            }
            ConceptSetFilterComponent o = (ConceptSetFilterComponent)other_;
            return ConceptSetFilterComponent.compareDeep(this.property, o.property, true) && ConceptSetFilterComponent.compareDeep(this.op, o.op, true) && ConceptSetFilterComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ConceptSetFilterComponent)) {
                return false;
            }
            ConceptSetFilterComponent o = (ConceptSetFilterComponent)other_;
            return ConceptSetFilterComponent.compareValues(this.property, o.property, true) && ConceptSetFilterComponent.compareValues(this.op, o.op, true) && ConceptSetFilterComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.property, this.op, this.value});
        }

        @Override
        public String fhirType() {
            return "ValueSet.compose.include.filter";
        }
    }

    @Block
    public static class ConceptReferenceDesignationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="language", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Human language of the designation", formalDefinition="The language this designation is defined for.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/all-languages")
        protected CodeType language;
        @Child(name="use", type={Coding.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Types of uses of designations", formalDefinition="A code that represents types of uses of designations.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/designation-use")
        protected Coding use;
        @Child(name="additionalUse", type={Coding.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Additional ways how this designation would be used", formalDefinition="Additional codes that detail how this designation would be used, if there is more than one use.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/designation-use")
        protected List<Coding> additionalUse;
        @Child(name="value", type={StringType.class}, order=4, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The text value for this designation", formalDefinition="The text value for this designation.")
        protected StringType value;
        private static final long serialVersionUID = -141147882L;

        public ConceptReferenceDesignationComponent() {
        }

        public ConceptReferenceDesignationComponent(String value) {
            this.setValue(value);
        }

        public CodeType getLanguageElement() {
            if (this.language == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptReferenceDesignationComponent.language");
                }
                if (Configuration.doAutoCreate()) {
                    this.language = new CodeType();
                }
            }
            return this.language;
        }

        public boolean hasLanguageElement() {
            return this.language != null && !this.language.isEmpty();
        }

        public boolean hasLanguage() {
            return this.language != null && !this.language.isEmpty();
        }

        public ConceptReferenceDesignationComponent setLanguageElement(CodeType value) {
            this.language = value;
            return this;
        }

        public String getLanguage() {
            return this.language == null ? null : (String)this.language.getValue();
        }

        public ConceptReferenceDesignationComponent setLanguage(String value) {
            if (Utilities.noString((String)value)) {
                this.language = null;
            } else {
                if (this.language == null) {
                    this.language = new CodeType();
                }
                this.language.setValue(value);
            }
            return this;
        }

        public Coding getUse() {
            if (this.use == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptReferenceDesignationComponent.use");
                }
                if (Configuration.doAutoCreate()) {
                    this.use = new Coding();
                }
            }
            return this.use;
        }

        public boolean hasUse() {
            return this.use != null && !this.use.isEmpty();
        }

        public ConceptReferenceDesignationComponent setUse(Coding value) {
            this.use = value;
            return this;
        }

        public List<Coding> getAdditionalUse() {
            if (this.additionalUse == null) {
                this.additionalUse = new ArrayList<Coding>();
            }
            return this.additionalUse;
        }

        public ConceptReferenceDesignationComponent setAdditionalUse(List<Coding> theAdditionalUse) {
            this.additionalUse = theAdditionalUse;
            return this;
        }

        public boolean hasAdditionalUse() {
            if (this.additionalUse == null) {
                return false;
            }
            for (Coding item : this.additionalUse) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Coding addAdditionalUse() {
            Coding t = new Coding();
            if (this.additionalUse == null) {
                this.additionalUse = new ArrayList<Coding>();
            }
            this.additionalUse.add(t);
            return t;
        }

        public ConceptReferenceDesignationComponent addAdditionalUse(Coding t) {
            if (t == null) {
                return this;
            }
            if (this.additionalUse == null) {
                this.additionalUse = new ArrayList<Coding>();
            }
            this.additionalUse.add(t);
            return this;
        }

        public Coding getAdditionalUseFirstRep() {
            if (this.getAdditionalUse().isEmpty()) {
                this.addAdditionalUse();
            }
            return this.getAdditionalUse().get(0);
        }

        public StringType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptReferenceDesignationComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new StringType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ConceptReferenceDesignationComponent setValueElement(StringType value) {
            this.value = value;
            return this;
        }

        public String getValue() {
            return this.value == null ? null : (String)this.value.getValue();
        }

        public ConceptReferenceDesignationComponent setValue(String value) {
            if (this.value == null) {
                this.value = new StringType();
            }
            this.value.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("language", ValueSet.SP_CODE, "The language this designation is defined for.", 0, 1, this.language));
            children.add(new Property("use", "Coding", "A code that represents types of uses of designations.", 0, 1, this.use));
            children.add(new Property("additionalUse", "Coding", "Additional codes that detail how this designation would be used, if there is more than one use.", 0, Integer.MAX_VALUE, this.additionalUse));
            children.add(new Property("value", "string", "The text value for this designation.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1613589672: {
                    return new Property("language", ValueSet.SP_CODE, "The language this designation is defined for.", 0, 1, this.language);
                }
                case 116103: {
                    return new Property("use", "Coding", "A code that represents types of uses of designations.", 0, 1, this.use);
                }
                case 938414048: {
                    return new Property("additionalUse", "Coding", "Additional codes that detail how this designation would be used, if there is more than one use.", 0, Integer.MAX_VALUE, this.additionalUse);
                }
                case 111972721: {
                    return new Property("value", "string", "The text value for this designation.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    Base[] baseArray;
                    if (this.language == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.language;
                    }
                    return baseArray;
                }
                case 116103: {
                    Base[] baseArray;
                    if (this.use == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.use;
                    }
                    return baseArray;
                }
                case 938414048: {
                    return this.additionalUse == null ? new Base[]{} : this.additionalUse.toArray(new Base[this.additionalUse.size()]);
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    this.language = TypeConvertor.castToCode(value);
                    return value;
                }
                case 116103: {
                    this.use = TypeConvertor.castToCoding(value);
                    return value;
                }
                case 938414048: {
                    this.getAdditionalUse().add(TypeConvertor.castToCoding(value));
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("language")) {
                this.language = TypeConvertor.castToCode(value);
            } else if (name.equals("use")) {
                this.use = TypeConvertor.castToCoding(value);
            } else if (name.equals("additionalUse")) {
                this.getAdditionalUse().add(TypeConvertor.castToCoding(value));
            } else if (name.equals("value")) {
                this.value = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("language")) {
                this.language = null;
            } else if (name.equals("use")) {
                this.use = null;
            } else if (name.equals("additionalUse")) {
                this.getAdditionalUse().remove(value);
            } else if (name.equals("value")) {
                this.value = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    return this.getLanguageElement();
                }
                case 116103: {
                    return this.getUse();
                }
                case 938414048: {
                    return this.addAdditionalUse();
                }
                case 111972721: {
                    return this.getValueElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    return new String[]{ValueSet.SP_CODE};
                }
                case 116103: {
                    return new String[]{"Coding"};
                }
                case 938414048: {
                    return new String[]{"Coding"};
                }
                case 111972721: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("language")) {
                throw new FHIRException("Cannot call addChild on a singleton property ValueSet.compose.include.concept.designation.language");
            }
            if (name.equals("use")) {
                this.use = new Coding();
                return this.use;
            }
            if (name.equals("additionalUse")) {
                return this.addAdditionalUse();
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a singleton property ValueSet.compose.include.concept.designation.value");
            }
            return super.addChild(name);
        }

        @Override
        public ConceptReferenceDesignationComponent copy() {
            ConceptReferenceDesignationComponent dst = new ConceptReferenceDesignationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ConceptReferenceDesignationComponent dst) {
            super.copyValues(dst);
            dst.language = this.language == null ? null : this.language.copy();
            Coding coding = dst.use = this.use == null ? null : this.use.copy();
            if (this.additionalUse != null) {
                dst.additionalUse = new ArrayList<Coding>();
                for (Coding i : this.additionalUse) {
                    dst.additionalUse.add(i.copy());
                }
            }
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ConceptReferenceDesignationComponent)) {
                return false;
            }
            ConceptReferenceDesignationComponent o = (ConceptReferenceDesignationComponent)other_;
            return ConceptReferenceDesignationComponent.compareDeep(this.language, o.language, true) && ConceptReferenceDesignationComponent.compareDeep(this.use, o.use, true) && ConceptReferenceDesignationComponent.compareDeep(this.additionalUse, o.additionalUse, true) && ConceptReferenceDesignationComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ConceptReferenceDesignationComponent)) {
                return false;
            }
            ConceptReferenceDesignationComponent o = (ConceptReferenceDesignationComponent)other_;
            return ConceptReferenceDesignationComponent.compareValues(this.language, o.language, true) && ConceptReferenceDesignationComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.language, this.use, this.additionalUse, this.value});
        }

        @Override
        public String fhirType() {
            return "ValueSet.compose.include.concept.designation";
        }
    }

    @Block
    public static class ConceptReferenceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code or expression from system", formalDefinition="Specifies a code for the concept to be included or excluded.")
        protected CodeType code;
        @Child(name="display", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Text to display for this code for this value set in this valueset", formalDefinition="The text to display to the user for this concept in the context of this valueset. If no display is provided, then applications using the value set use the display specified for the code by the system.")
        protected StringType display;
        @Child(name="designation", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Additional representations for this concept", formalDefinition="Additional representations for this concept when used in this value set - other languages, aliases, specialized purposes, used for particular purposes, etc.")
        protected List<ConceptReferenceDesignationComponent> designation;
        private static final long serialVersionUID = 260579971L;

        public ConceptReferenceComponent() {
        }

        public ConceptReferenceComponent(String code) {
            this.setCode(code);
        }

        public CodeType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptReferenceComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ConceptReferenceComponent setCodeElement(CodeType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public ConceptReferenceComponent setCode(String value) {
            if (this.code == null) {
                this.code = new CodeType();
            }
            this.code.setValue(value);
            return this;
        }

        public StringType getDisplayElement() {
            if (this.display == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptReferenceComponent.display");
                }
                if (Configuration.doAutoCreate()) {
                    this.display = new StringType();
                }
            }
            return this.display;
        }

        public boolean hasDisplayElement() {
            return this.display != null && !this.display.isEmpty();
        }

        public boolean hasDisplay() {
            return this.display != null && !this.display.isEmpty();
        }

        public ConceptReferenceComponent setDisplayElement(StringType value) {
            this.display = value;
            return this;
        }

        public String getDisplay() {
            return this.display == null ? null : (String)this.display.getValue();
        }

        public ConceptReferenceComponent setDisplay(String value) {
            if (Utilities.noString((String)value)) {
                this.display = null;
            } else {
                if (this.display == null) {
                    this.display = new StringType();
                }
                this.display.setValue(value);
            }
            return this;
        }

        public List<ConceptReferenceDesignationComponent> getDesignation() {
            if (this.designation == null) {
                this.designation = new ArrayList<ConceptReferenceDesignationComponent>();
            }
            return this.designation;
        }

        public ConceptReferenceComponent setDesignation(List<ConceptReferenceDesignationComponent> theDesignation) {
            this.designation = theDesignation;
            return this;
        }

        public boolean hasDesignation() {
            if (this.designation == null) {
                return false;
            }
            for (ConceptReferenceDesignationComponent item : this.designation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ConceptReferenceDesignationComponent addDesignation() {
            ConceptReferenceDesignationComponent t = new ConceptReferenceDesignationComponent();
            if (this.designation == null) {
                this.designation = new ArrayList<ConceptReferenceDesignationComponent>();
            }
            this.designation.add(t);
            return t;
        }

        public ConceptReferenceComponent addDesignation(ConceptReferenceDesignationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.designation == null) {
                this.designation = new ArrayList<ConceptReferenceDesignationComponent>();
            }
            this.designation.add(t);
            return this;
        }

        public ConceptReferenceDesignationComponent getDesignationFirstRep() {
            if (this.getDesignation().isEmpty()) {
                this.addDesignation();
            }
            return this.getDesignation().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(ValueSet.SP_CODE, ValueSet.SP_CODE, "Specifies a code for the concept to be included or excluded.", 0, 1, this.code));
            children.add(new Property("display", "string", "The text to display to the user for this concept in the context of this valueset. If no display is provided, then applications using the value set use the display specified for the code by the system.", 0, 1, this.display));
            children.add(new Property("designation", "", "Additional representations for this concept when used in this value set - other languages, aliases, specialized purposes, used for particular purposes, etc.", 0, Integer.MAX_VALUE, this.designation));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property(ValueSet.SP_CODE, ValueSet.SP_CODE, "Specifies a code for the concept to be included or excluded.", 0, 1, this.code);
                }
                case 1671764162: {
                    return new Property("display", "string", "The text to display to the user for this concept in the context of this valueset. If no display is provided, then applications using the value set use the display specified for the code by the system.", 0, 1, this.display);
                }
                case -900931593: {
                    return new Property("designation", "", "Additional representations for this concept when used in this value set - other languages, aliases, specialized purposes, used for particular purposes, etc.", 0, Integer.MAX_VALUE, this.designation);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 1671764162: {
                    Base[] baseArray;
                    if (this.display == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.display;
                    }
                    return baseArray;
                }
                case -900931593: {
                    return this.designation == null ? new Base[]{} : this.designation.toArray(new Base[this.designation.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCode(value);
                    return value;
                }
                case 1671764162: {
                    this.display = TypeConvertor.castToString(value);
                    return value;
                }
                case -900931593: {
                    this.getDesignation().add((ConceptReferenceDesignationComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ValueSet.SP_CODE)) {
                this.code = TypeConvertor.castToCode(value);
            } else if (name.equals("display")) {
                this.display = TypeConvertor.castToString(value);
            } else if (name.equals("designation")) {
                this.getDesignation().add((ConceptReferenceDesignationComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals(ValueSet.SP_CODE)) {
                this.code = null;
            } else if (name.equals("display")) {
                this.display = null;
            } else if (name.equals("designation")) {
                this.getDesignation().remove((ConceptReferenceDesignationComponent)value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCodeElement();
                }
                case 1671764162: {
                    return this.getDisplayElement();
                }
                case -900931593: {
                    return this.addDesignation();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{ValueSet.SP_CODE};
                }
                case 1671764162: {
                    return new String[]{"string"};
                }
                case -900931593: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ValueSet.SP_CODE)) {
                throw new FHIRException("Cannot call addChild on a singleton property ValueSet.compose.include.concept.code");
            }
            if (name.equals("display")) {
                throw new FHIRException("Cannot call addChild on a singleton property ValueSet.compose.include.concept.display");
            }
            if (name.equals("designation")) {
                return this.addDesignation();
            }
            return super.addChild(name);
        }

        @Override
        public ConceptReferenceComponent copy() {
            ConceptReferenceComponent dst = new ConceptReferenceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ConceptReferenceComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            StringType stringType = dst.display = this.display == null ? null : this.display.copy();
            if (this.designation != null) {
                dst.designation = new ArrayList<ConceptReferenceDesignationComponent>();
                for (ConceptReferenceDesignationComponent i : this.designation) {
                    dst.designation.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ConceptReferenceComponent)) {
                return false;
            }
            ConceptReferenceComponent o = (ConceptReferenceComponent)other_;
            return ConceptReferenceComponent.compareDeep(this.code, o.code, true) && ConceptReferenceComponent.compareDeep(this.display, o.display, true) && ConceptReferenceComponent.compareDeep(this.designation, o.designation, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ConceptReferenceComponent)) {
                return false;
            }
            ConceptReferenceComponent o = (ConceptReferenceComponent)other_;
            return ConceptReferenceComponent.compareValues(this.code, o.code, true) && ConceptReferenceComponent.compareValues(this.display, o.display, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.display, this.designation});
        }

        @Override
        public String fhirType() {
            return "ValueSet.compose.include.concept";
        }
    }

    @Block
    public static class ConceptSetComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="system", type={UriType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The system the codes come from", formalDefinition="An absolute URI which is the code system from which the selected codes come from.")
        protected UriType system;
        @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Specific version of the code system referred to", formalDefinition="The version of the code system that the codes are selected from, or the special version '*' for all versions.")
        protected StringType version;
        @Child(name="concept", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="A concept defined in the system", formalDefinition="Specifies a concept to be included or excluded.")
        protected List<ConceptReferenceComponent> concept;
        @Child(name="filter", type={}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Select codes/concepts by their properties (including relationships)", formalDefinition="Select concepts by specifying a matching criterion based on the properties (including relationships) defined by the system, or on filters defined by the system. If multiple filters are specified within the include, they SHALL all be true.")
        protected List<ConceptSetFilterComponent> filter;
        @Child(name="valueSet", type={CanonicalType.class}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Select the contents included in this value set", formalDefinition="Selects the concepts found in this value set (based on its value set definition). This is an absolute URI that is a reference to ValueSet.url.  If multiple value sets are specified this includes the intersection of the contents of all of the referenced value sets.")
        protected List<CanonicalType> valueSet;
        @Child(name="copyright", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A copyright statement for the specific code system included in the value set", formalDefinition="A copyright statement for the specific code system asserted by the containing ValueSet.compose.include element's system value (if the associated ValueSet.compose.include.version element is not present); or the code system and version combination (if the associated ValueSet.compose.include.version element is present).")
        protected StringType copyright;
        private static final long serialVersionUID = -517139062L;

        public UriType getSystemElement() {
            if (this.system == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptSetComponent.system");
                }
                if (Configuration.doAutoCreate()) {
                    this.system = new UriType();
                }
            }
            return this.system;
        }

        public boolean hasSystemElement() {
            return this.system != null && !this.system.isEmpty();
        }

        public boolean hasSystem() {
            return this.system != null && !this.system.isEmpty();
        }

        public ConceptSetComponent setSystemElement(UriType value) {
            this.system = value;
            return this;
        }

        public String getSystem() {
            return this.system == null ? null : (String)this.system.getValue();
        }

        public ConceptSetComponent setSystem(String value) {
            if (Utilities.noString((String)value)) {
                this.system = null;
            } else {
                if (this.system == null) {
                    this.system = new UriType();
                }
                this.system.setValue(value);
            }
            return this;
        }

        public StringType getVersionElement() {
            if (this.version == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptSetComponent.version");
                }
                if (Configuration.doAutoCreate()) {
                    this.version = new StringType();
                }
            }
            return this.version;
        }

        public boolean hasVersionElement() {
            return this.version != null && !this.version.isEmpty();
        }

        public boolean hasVersion() {
            return this.version != null && !this.version.isEmpty();
        }

        public ConceptSetComponent setVersionElement(StringType value) {
            this.version = value;
            return this;
        }

        public String getVersion() {
            return this.version == null ? null : (String)this.version.getValue();
        }

        public ConceptSetComponent setVersion(String value) {
            if (Utilities.noString((String)value)) {
                this.version = null;
            } else {
                if (this.version == null) {
                    this.version = new StringType();
                }
                this.version.setValue(value);
            }
            return this;
        }

        public List<ConceptReferenceComponent> getConcept() {
            if (this.concept == null) {
                this.concept = new ArrayList<ConceptReferenceComponent>();
            }
            return this.concept;
        }

        public ConceptSetComponent setConcept(List<ConceptReferenceComponent> theConcept) {
            this.concept = theConcept;
            return this;
        }

        public boolean hasConcept() {
            if (this.concept == null) {
                return false;
            }
            for (ConceptReferenceComponent item : this.concept) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ConceptReferenceComponent addConcept() {
            ConceptReferenceComponent t = new ConceptReferenceComponent();
            if (this.concept == null) {
                this.concept = new ArrayList<ConceptReferenceComponent>();
            }
            this.concept.add(t);
            return t;
        }

        public ConceptSetComponent addConcept(ConceptReferenceComponent t) {
            if (t == null) {
                return this;
            }
            if (this.concept == null) {
                this.concept = new ArrayList<ConceptReferenceComponent>();
            }
            this.concept.add(t);
            return this;
        }

        public ConceptReferenceComponent getConceptFirstRep() {
            if (this.getConcept().isEmpty()) {
                this.addConcept();
            }
            return this.getConcept().get(0);
        }

        public List<ConceptSetFilterComponent> getFilter() {
            if (this.filter == null) {
                this.filter = new ArrayList<ConceptSetFilterComponent>();
            }
            return this.filter;
        }

        public ConceptSetComponent setFilter(List<ConceptSetFilterComponent> theFilter) {
            this.filter = theFilter;
            return this;
        }

        public boolean hasFilter() {
            if (this.filter == null) {
                return false;
            }
            for (ConceptSetFilterComponent item : this.filter) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ConceptSetFilterComponent addFilter() {
            ConceptSetFilterComponent t = new ConceptSetFilterComponent();
            if (this.filter == null) {
                this.filter = new ArrayList<ConceptSetFilterComponent>();
            }
            this.filter.add(t);
            return t;
        }

        public ConceptSetComponent addFilter(ConceptSetFilterComponent t) {
            if (t == null) {
                return this;
            }
            if (this.filter == null) {
                this.filter = new ArrayList<ConceptSetFilterComponent>();
            }
            this.filter.add(t);
            return this;
        }

        public ConceptSetFilterComponent getFilterFirstRep() {
            if (this.getFilter().isEmpty()) {
                this.addFilter();
            }
            return this.getFilter().get(0);
        }

        public List<CanonicalType> getValueSet() {
            if (this.valueSet == null) {
                this.valueSet = new ArrayList<CanonicalType>();
            }
            return this.valueSet;
        }

        public ConceptSetComponent setValueSet(List<CanonicalType> theValueSet) {
            this.valueSet = theValueSet;
            return this;
        }

        public boolean hasValueSet() {
            if (this.valueSet == null) {
                return false;
            }
            for (CanonicalType item : this.valueSet) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CanonicalType addValueSetElement() {
            CanonicalType t = new CanonicalType();
            if (this.valueSet == null) {
                this.valueSet = new ArrayList<CanonicalType>();
            }
            this.valueSet.add(t);
            return t;
        }

        public ConceptSetComponent addValueSet(String value) {
            CanonicalType t = new CanonicalType();
            t.setValue(value);
            if (this.valueSet == null) {
                this.valueSet = new ArrayList<CanonicalType>();
            }
            this.valueSet.add(t);
            return this;
        }

        public boolean hasValueSet(String value) {
            if (this.valueSet == null) {
                return false;
            }
            for (CanonicalType v : this.valueSet) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public StringType getCopyrightElement() {
            if (this.copyright == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptSetComponent.copyright");
                }
                if (Configuration.doAutoCreate()) {
                    this.copyright = new StringType();
                }
            }
            return this.copyright;
        }

        public boolean hasCopyrightElement() {
            return this.copyright != null && !this.copyright.isEmpty();
        }

        public boolean hasCopyright() {
            return this.copyright != null && !this.copyright.isEmpty();
        }

        public ConceptSetComponent setCopyrightElement(StringType value) {
            this.copyright = value;
            return this;
        }

        public String getCopyright() {
            return this.copyright == null ? null : (String)this.copyright.getValue();
        }

        public ConceptSetComponent setCopyright(String value) {
            if (Utilities.noString((String)value)) {
                this.copyright = null;
            } else {
                if (this.copyright == null) {
                    this.copyright = new StringType();
                }
                this.copyright.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("system", "uri", "An absolute URI which is the code system from which the selected codes come from.", 0, 1, this.system));
            children.add(new Property(ValueSet.SP_VERSION, "string", "The version of the code system that the codes are selected from, or the special version '*' for all versions.", 0, 1, this.version));
            children.add(new Property("concept", "", "Specifies a concept to be included or excluded.", 0, Integer.MAX_VALUE, this.concept));
            children.add(new Property("filter", "", "Select concepts by specifying a matching criterion based on the properties (including relationships) defined by the system, or on filters defined by the system. If multiple filters are specified within the include, they SHALL all be true.", 0, Integer.MAX_VALUE, this.filter));
            children.add(new Property("valueSet", "canonical(ValueSet)", "Selects the concepts found in this value set (based on its value set definition). This is an absolute URI that is a reference to ValueSet.url.  If multiple value sets are specified this includes the intersection of the contents of all of the referenced value sets.", 0, Integer.MAX_VALUE, this.valueSet));
            children.add(new Property("copyright", "string", "A copyright statement for the specific code system asserted by the containing ValueSet.compose.include element's system value (if the associated ValueSet.compose.include.version element is not present); or the code system and version combination (if the associated ValueSet.compose.include.version element is present).", 0, 1, this.copyright));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -887328209: {
                    return new Property("system", "uri", "An absolute URI which is the code system from which the selected codes come from.", 0, 1, this.system);
                }
                case 351608024: {
                    return new Property(ValueSet.SP_VERSION, "string", "The version of the code system that the codes are selected from, or the special version '*' for all versions.", 0, 1, this.version);
                }
                case 951024232: {
                    return new Property("concept", "", "Specifies a concept to be included or excluded.", 0, Integer.MAX_VALUE, this.concept);
                }
                case -1274492040: {
                    return new Property("filter", "", "Select concepts by specifying a matching criterion based on the properties (including relationships) defined by the system, or on filters defined by the system. If multiple filters are specified within the include, they SHALL all be true.", 0, Integer.MAX_VALUE, this.filter);
                }
                case -1410174671: {
                    return new Property("valueSet", "canonical(ValueSet)", "Selects the concepts found in this value set (based on its value set definition). This is an absolute URI that is a reference to ValueSet.url.  If multiple value sets are specified this includes the intersection of the contents of all of the referenced value sets.", 0, Integer.MAX_VALUE, this.valueSet);
                }
                case 1522889671: {
                    return new Property("copyright", "string", "A copyright statement for the specific code system asserted by the containing ValueSet.compose.include element's system value (if the associated ValueSet.compose.include.version element is not present); or the code system and version combination (if the associated ValueSet.compose.include.version element is present).", 0, 1, this.copyright);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -887328209: {
                    Base[] baseArray;
                    if (this.system == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.system;
                    }
                    return baseArray;
                }
                case 351608024: {
                    Base[] baseArray;
                    if (this.version == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.version;
                    }
                    return baseArray;
                }
                case 951024232: {
                    return this.concept == null ? new Base[]{} : this.concept.toArray(new Base[this.concept.size()]);
                }
                case -1274492040: {
                    return this.filter == null ? new Base[]{} : this.filter.toArray(new Base[this.filter.size()]);
                }
                case -1410174671: {
                    return this.valueSet == null ? new Base[]{} : this.valueSet.toArray(new Base[this.valueSet.size()]);
                }
                case 1522889671: {
                    Base[] baseArray;
                    if (this.copyright == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.copyright;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -887328209: {
                    this.system = TypeConvertor.castToUri(value);
                    return value;
                }
                case 351608024: {
                    this.version = TypeConvertor.castToString(value);
                    return value;
                }
                case 951024232: {
                    this.getConcept().add((ConceptReferenceComponent)value);
                    return value;
                }
                case -1274492040: {
                    this.getFilter().add((ConceptSetFilterComponent)value);
                    return value;
                }
                case -1410174671: {
                    this.getValueSet().add(TypeConvertor.castToCanonical(value));
                    return value;
                }
                case 1522889671: {
                    this.copyright = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("system")) {
                this.system = TypeConvertor.castToUri(value);
            } else if (name.equals(ValueSet.SP_VERSION)) {
                this.version = TypeConvertor.castToString(value);
            } else if (name.equals("concept")) {
                this.getConcept().add((ConceptReferenceComponent)value);
            } else if (name.equals("filter")) {
                this.getFilter().add((ConceptSetFilterComponent)value);
            } else if (name.equals("valueSet")) {
                this.getValueSet().add(TypeConvertor.castToCanonical(value));
            } else if (name.equals("copyright")) {
                this.copyright = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("system")) {
                this.system = null;
            } else if (name.equals(ValueSet.SP_VERSION)) {
                this.version = null;
            } else if (name.equals("concept")) {
                this.getConcept().remove((ConceptReferenceComponent)value);
            } else if (name.equals("filter")) {
                this.getFilter().remove((ConceptSetFilterComponent)value);
            } else if (name.equals("valueSet")) {
                this.getValueSet().remove(value);
            } else if (name.equals("copyright")) {
                this.copyright = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -887328209: {
                    return this.getSystemElement();
                }
                case 351608024: {
                    return this.getVersionElement();
                }
                case 951024232: {
                    return this.addConcept();
                }
                case -1274492040: {
                    return this.addFilter();
                }
                case -1410174671: {
                    return this.addValueSetElement();
                }
                case 1522889671: {
                    return this.getCopyrightElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -887328209: {
                    return new String[]{"uri"};
                }
                case 351608024: {
                    return new String[]{"string"};
                }
                case 951024232: {
                    return new String[0];
                }
                case -1274492040: {
                    return new String[0];
                }
                case -1410174671: {
                    return new String[]{"canonical"};
                }
                case 1522889671: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("system")) {
                throw new FHIRException("Cannot call addChild on a singleton property ValueSet.compose.include.system");
            }
            if (name.equals(ValueSet.SP_VERSION)) {
                throw new FHIRException("Cannot call addChild on a singleton property ValueSet.compose.include.version");
            }
            if (name.equals("concept")) {
                return this.addConcept();
            }
            if (name.equals("filter")) {
                return this.addFilter();
            }
            if (name.equals("valueSet")) {
                throw new FHIRException("Cannot call addChild on a singleton property ValueSet.compose.include.valueSet");
            }
            if (name.equals("copyright")) {
                throw new FHIRException("Cannot call addChild on a singleton property ValueSet.compose.include.copyright");
            }
            return super.addChild(name);
        }

        @Override
        public ConceptSetComponent copy() {
            ConceptSetComponent dst = new ConceptSetComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ConceptSetComponent dst) {
            super.copyValues(dst);
            dst.system = this.system == null ? null : this.system.copy();
            StringType stringType = dst.version = this.version == null ? null : this.version.copy();
            if (this.concept != null) {
                dst.concept = new ArrayList<ConceptReferenceComponent>();
                for (ConceptReferenceComponent conceptReferenceComponent : this.concept) {
                    dst.concept.add(conceptReferenceComponent.copy());
                }
            }
            if (this.filter != null) {
                dst.filter = new ArrayList<ConceptSetFilterComponent>();
                for (ConceptSetFilterComponent conceptSetFilterComponent : this.filter) {
                    dst.filter.add(conceptSetFilterComponent.copy());
                }
            }
            if (this.valueSet != null) {
                dst.valueSet = new ArrayList<CanonicalType>();
                for (CanonicalType canonicalType : this.valueSet) {
                    dst.valueSet.add(canonicalType.copy());
                }
            }
            dst.copyright = this.copyright == null ? null : this.copyright.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ConceptSetComponent)) {
                return false;
            }
            ConceptSetComponent o = (ConceptSetComponent)other_;
            return ConceptSetComponent.compareDeep(this.system, o.system, true) && ConceptSetComponent.compareDeep(this.version, o.version, true) && ConceptSetComponent.compareDeep(this.concept, o.concept, true) && ConceptSetComponent.compareDeep(this.filter, o.filter, true) && ConceptSetComponent.compareDeep(this.valueSet, o.valueSet, true) && ConceptSetComponent.compareDeep(this.copyright, o.copyright, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ConceptSetComponent)) {
                return false;
            }
            ConceptSetComponent o = (ConceptSetComponent)other_;
            return ConceptSetComponent.compareValues(this.system, o.system, true) && ConceptSetComponent.compareValues(this.version, o.version, true) && ConceptSetComponent.compareValues(this.valueSet, o.valueSet, true) && ConceptSetComponent.compareValues(this.copyright, o.copyright, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.system, this.version, this.concept, this.filter, this.valueSet, this.copyright});
        }

        @Override
        public String fhirType() {
            return "ValueSet.compose.include";
        }

        public boolean hasConcept(String code) {
            for (ConceptReferenceComponent c : this.getConcept()) {
                if (!code.equals(c.getCode())) continue;
                return true;
            }
            return false;
        }
    }

    @Block
    public static class ValueSetComposeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="lockedDate", type={DateType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Fixed date for references with no specified version (transitive)", formalDefinition="The Locked Date is  the effective date that is used to determine the version of all referenced Code Systems and Value Set Definitions included in the compose that are not already tied to a specific version.")
        protected DateType lockedDate;
        @Child(name="inactive", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Whether inactive codes are in the value set", formalDefinition="Whether inactive codes - codes that are not approved for current use - are in the value set. If inactive = true, inactive codes are to be included in the expansion, if inactive = false, the inactive codes will not be included in the expansion. If absent, the behavior is determined by the implementation, or by the applicable $expand parameters (but generally, inactive codes would be expected to be included).")
        protected BooleanType inactive;
        @Child(name="include", type={}, order=3, min=1, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Include one or more codes from a code system or other value set(s)", formalDefinition="Include one or more codes from a code system or other value set(s).")
        protected List<ConceptSetComponent> include;
        @Child(name="exclude", type={ConceptSetComponent.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Explicitly exclude codes from a code system or other value sets", formalDefinition="Exclude one or more codes from the value set based on code system filters and/or other value sets.")
        protected List<ConceptSetComponent> exclude;
        @Child(name="property", type={StringType.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Property to return if client doesn't override", formalDefinition="A property to return in the expansion, if the client doesn't ask for any particular properties. May be either a code from the code system definition (convenient) or a the formal URI that refers to the property. The special value '*' means all properties known to the server.")
        protected List<StringType> property;
        private static final long serialVersionUID = -15414259L;

        public ValueSetComposeComponent() {
        }

        public ValueSetComposeComponent(ConceptSetComponent include) {
            this.addInclude(include);
        }

        public DateType getLockedDateElement() {
            if (this.lockedDate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetComposeComponent.lockedDate");
                }
                if (Configuration.doAutoCreate()) {
                    this.lockedDate = new DateType();
                }
            }
            return this.lockedDate;
        }

        public boolean hasLockedDateElement() {
            return this.lockedDate != null && !this.lockedDate.isEmpty();
        }

        public boolean hasLockedDate() {
            return this.lockedDate != null && !this.lockedDate.isEmpty();
        }

        public ValueSetComposeComponent setLockedDateElement(DateType value) {
            this.lockedDate = value;
            return this;
        }

        public Date getLockedDate() {
            return this.lockedDate == null ? null : (Date)this.lockedDate.getValue();
        }

        public ValueSetComposeComponent setLockedDate(Date value) {
            if (value == null) {
                this.lockedDate = null;
            } else {
                if (this.lockedDate == null) {
                    this.lockedDate = new DateType();
                }
                this.lockedDate.setValue(value);
            }
            return this;
        }

        public BooleanType getInactiveElement() {
            if (this.inactive == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetComposeComponent.inactive");
                }
                if (Configuration.doAutoCreate()) {
                    this.inactive = new BooleanType();
                }
            }
            return this.inactive;
        }

        public boolean hasInactiveElement() {
            return this.inactive != null && !this.inactive.isEmpty();
        }

        public boolean hasInactive() {
            return this.inactive != null && !this.inactive.isEmpty();
        }

        public ValueSetComposeComponent setInactiveElement(BooleanType value) {
            this.inactive = value;
            return this;
        }

        public boolean getInactive() {
            return this.inactive == null || this.inactive.isEmpty() ? false : (Boolean)this.inactive.getValue();
        }

        public ValueSetComposeComponent setInactive(boolean value) {
            if (this.inactive == null) {
                this.inactive = new BooleanType();
            }
            this.inactive.setValue((Object)value);
            return this;
        }

        public List<ConceptSetComponent> getInclude() {
            if (this.include == null) {
                this.include = new ArrayList<ConceptSetComponent>();
            }
            return this.include;
        }

        public ValueSetComposeComponent setInclude(List<ConceptSetComponent> theInclude) {
            this.include = theInclude;
            return this;
        }

        public boolean hasInclude() {
            if (this.include == null) {
                return false;
            }
            for (ConceptSetComponent item : this.include) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ConceptSetComponent addInclude() {
            ConceptSetComponent t = new ConceptSetComponent();
            if (this.include == null) {
                this.include = new ArrayList<ConceptSetComponent>();
            }
            this.include.add(t);
            return t;
        }

        public ValueSetComposeComponent addInclude(ConceptSetComponent t) {
            if (t == null) {
                return this;
            }
            if (this.include == null) {
                this.include = new ArrayList<ConceptSetComponent>();
            }
            this.include.add(t);
            return this;
        }

        public ConceptSetComponent getIncludeFirstRep() {
            if (this.getInclude().isEmpty()) {
                this.addInclude();
            }
            return this.getInclude().get(0);
        }

        public List<ConceptSetComponent> getExclude() {
            if (this.exclude == null) {
                this.exclude = new ArrayList<ConceptSetComponent>();
            }
            return this.exclude;
        }

        public ValueSetComposeComponent setExclude(List<ConceptSetComponent> theExclude) {
            this.exclude = theExclude;
            return this;
        }

        public boolean hasExclude() {
            if (this.exclude == null) {
                return false;
            }
            for (ConceptSetComponent item : this.exclude) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ConceptSetComponent addExclude() {
            ConceptSetComponent t = new ConceptSetComponent();
            if (this.exclude == null) {
                this.exclude = new ArrayList<ConceptSetComponent>();
            }
            this.exclude.add(t);
            return t;
        }

        public ValueSetComposeComponent addExclude(ConceptSetComponent t) {
            if (t == null) {
                return this;
            }
            if (this.exclude == null) {
                this.exclude = new ArrayList<ConceptSetComponent>();
            }
            this.exclude.add(t);
            return this;
        }

        public ConceptSetComponent getExcludeFirstRep() {
            if (this.getExclude().isEmpty()) {
                this.addExclude();
            }
            return this.getExclude().get(0);
        }

        public List<StringType> getProperty() {
            if (this.property == null) {
                this.property = new ArrayList<StringType>();
            }
            return this.property;
        }

        public ValueSetComposeComponent setProperty(List<StringType> theProperty) {
            this.property = theProperty;
            return this;
        }

        public boolean hasProperty() {
            if (this.property == null) {
                return false;
            }
            for (StringType item : this.property) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addPropertyElement() {
            StringType t = new StringType();
            if (this.property == null) {
                this.property = new ArrayList<StringType>();
            }
            this.property.add(t);
            return t;
        }

        public ValueSetComposeComponent addProperty(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.property == null) {
                this.property = new ArrayList<StringType>();
            }
            this.property.add(t);
            return this;
        }

        public boolean hasProperty(String value) {
            if (this.property == null) {
                return false;
            }
            for (StringType v : this.property) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("lockedDate", ValueSet.SP_DATE, "The Locked Date is  the effective date that is used to determine the version of all referenced Code Systems and Value Set Definitions included in the compose that are not already tied to a specific version.", 0, 1, this.lockedDate));
            children.add(new Property("inactive", "boolean", "Whether inactive codes - codes that are not approved for current use - are in the value set. If inactive = true, inactive codes are to be included in the expansion, if inactive = false, the inactive codes will not be included in the expansion. If absent, the behavior is determined by the implementation, or by the applicable $expand parameters (but generally, inactive codes would be expected to be included).", 0, 1, this.inactive));
            children.add(new Property("include", "", "Include one or more codes from a code system or other value set(s).", 0, Integer.MAX_VALUE, this.include));
            children.add(new Property("exclude", "@ValueSet.compose.include", "Exclude one or more codes from the value set based on code system filters and/or other value sets.", 0, Integer.MAX_VALUE, this.exclude));
            children.add(new Property("property", "string", "A property to return in the expansion, if the client doesn't ask for any particular properties. May be either a code from the code system definition (convenient) or a the formal URI that refers to the property. The special value '*' means all properties known to the server.", 0, Integer.MAX_VALUE, this.property));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1391591896: {
                    return new Property("lockedDate", ValueSet.SP_DATE, "The Locked Date is  the effective date that is used to determine the version of all referenced Code Systems and Value Set Definitions included in the compose that are not already tied to a specific version.", 0, 1, this.lockedDate);
                }
                case 24665195: {
                    return new Property("inactive", "boolean", "Whether inactive codes - codes that are not approved for current use - are in the value set. If inactive = true, inactive codes are to be included in the expansion, if inactive = false, the inactive codes will not be included in the expansion. If absent, the behavior is determined by the implementation, or by the applicable $expand parameters (but generally, inactive codes would be expected to be included).", 0, 1, this.inactive);
                }
                case 1942574248: {
                    return new Property("include", "", "Include one or more codes from a code system or other value set(s).", 0, Integer.MAX_VALUE, this.include);
                }
                case -1321148966: {
                    return new Property("exclude", "@ValueSet.compose.include", "Exclude one or more codes from the value set based on code system filters and/or other value sets.", 0, Integer.MAX_VALUE, this.exclude);
                }
                case -993141291: {
                    return new Property("property", "string", "A property to return in the expansion, if the client doesn't ask for any particular properties. May be either a code from the code system definition (convenient) or a the formal URI that refers to the property. The special value '*' means all properties known to the server.", 0, Integer.MAX_VALUE, this.property);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1391591896: {
                    Base[] baseArray;
                    if (this.lockedDate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.lockedDate;
                    }
                    return baseArray;
                }
                case 24665195: {
                    Base[] baseArray;
                    if (this.inactive == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.inactive;
                    }
                    return baseArray;
                }
                case 1942574248: {
                    return this.include == null ? new Base[]{} : this.include.toArray(new Base[this.include.size()]);
                }
                case -1321148966: {
                    return this.exclude == null ? new Base[]{} : this.exclude.toArray(new Base[this.exclude.size()]);
                }
                case -993141291: {
                    return this.property == null ? new Base[]{} : this.property.toArray(new Base[this.property.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1391591896: {
                    this.lockedDate = TypeConvertor.castToDate(value);
                    return value;
                }
                case 24665195: {
                    this.inactive = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case 1942574248: {
                    this.getInclude().add((ConceptSetComponent)value);
                    return value;
                }
                case -1321148966: {
                    this.getExclude().add((ConceptSetComponent)value);
                    return value;
                }
                case -993141291: {
                    this.getProperty().add(TypeConvertor.castToString(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("lockedDate")) {
                this.lockedDate = TypeConvertor.castToDate(value);
            } else if (name.equals("inactive")) {
                this.inactive = TypeConvertor.castToBoolean(value);
            } else if (name.equals("include")) {
                this.getInclude().add((ConceptSetComponent)value);
            } else if (name.equals("exclude")) {
                this.getExclude().add((ConceptSetComponent)value);
            } else if (name.equals("property")) {
                this.getProperty().add(TypeConvertor.castToString(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("lockedDate")) {
                this.lockedDate = null;
            } else if (name.equals("inactive")) {
                this.inactive = null;
            } else if (name.equals("include")) {
                this.getInclude().remove((ConceptSetComponent)value);
            } else if (name.equals("exclude")) {
                this.getExclude().remove((ConceptSetComponent)value);
            } else if (name.equals("property")) {
                this.getProperty().remove(value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1391591896: {
                    return this.getLockedDateElement();
                }
                case 24665195: {
                    return this.getInactiveElement();
                }
                case 1942574248: {
                    return this.addInclude();
                }
                case -1321148966: {
                    return this.addExclude();
                }
                case -993141291: {
                    return this.addPropertyElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1391591896: {
                    return new String[]{ValueSet.SP_DATE};
                }
                case 24665195: {
                    return new String[]{"boolean"};
                }
                case 1942574248: {
                    return new String[0];
                }
                case -1321148966: {
                    return new String[]{"@ValueSet.compose.include"};
                }
                case -993141291: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("lockedDate")) {
                throw new FHIRException("Cannot call addChild on a singleton property ValueSet.compose.lockedDate");
            }
            if (name.equals("inactive")) {
                throw new FHIRException("Cannot call addChild on a singleton property ValueSet.compose.inactive");
            }
            if (name.equals("include")) {
                return this.addInclude();
            }
            if (name.equals("exclude")) {
                return this.addExclude();
            }
            if (name.equals("property")) {
                throw new FHIRException("Cannot call addChild on a singleton property ValueSet.compose.property");
            }
            return super.addChild(name);
        }

        @Override
        public ValueSetComposeComponent copy() {
            ValueSetComposeComponent dst = new ValueSetComposeComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ValueSetComposeComponent dst) {
            super.copyValues(dst);
            dst.lockedDate = this.lockedDate == null ? null : this.lockedDate.copy();
            BooleanType booleanType = dst.inactive = this.inactive == null ? null : this.inactive.copy();
            if (this.include != null) {
                dst.include = new ArrayList<ConceptSetComponent>();
                for (ConceptSetComponent conceptSetComponent : this.include) {
                    dst.include.add(conceptSetComponent.copy());
                }
            }
            if (this.exclude != null) {
                dst.exclude = new ArrayList<ConceptSetComponent>();
                for (ConceptSetComponent conceptSetComponent : this.exclude) {
                    dst.exclude.add(conceptSetComponent.copy());
                }
            }
            if (this.property != null) {
                dst.property = new ArrayList<StringType>();
                for (StringType stringType : this.property) {
                    dst.property.add(stringType.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ValueSetComposeComponent)) {
                return false;
            }
            ValueSetComposeComponent o = (ValueSetComposeComponent)other_;
            return ValueSetComposeComponent.compareDeep(this.lockedDate, o.lockedDate, true) && ValueSetComposeComponent.compareDeep(this.inactive, o.inactive, true) && ValueSetComposeComponent.compareDeep(this.include, o.include, true) && ValueSetComposeComponent.compareDeep(this.exclude, o.exclude, true) && ValueSetComposeComponent.compareDeep(this.property, o.property, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ValueSetComposeComponent)) {
                return false;
            }
            ValueSetComposeComponent o = (ValueSetComposeComponent)other_;
            return ValueSetComposeComponent.compareValues(this.lockedDate, o.lockedDate, true) && ValueSetComposeComponent.compareValues(this.inactive, o.inactive, true) && ValueSetComposeComponent.compareValues(this.property, o.property, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.lockedDate, this.inactive, this.include, this.exclude, this.property});
        }

        @Override
        public String fhirType() {
            return "ValueSet.compose";
        }
    }
}

