/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.renderers.Renderer;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.ResourceWrapper;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class CapabilityStatementRenderer
extends ResourceRenderer {
    private static final String EXPECTATION = "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation";
    private static final String COMBINED = "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination";
    private static final String SP_BASE = "http://hl7.org/fhir/searchparameter/";
    private static final String FHIR_BASE = "http://hl7.org/fhir/";
    private static final String VERS_DEF_PREFIX = "FHIR Release ";
    private String currentFhirBase = "";
    private String collapseClass = "panel-collapse in";
    private boolean multExpectationsPresent = false;

    public CapabilityStatementRenderer(RenderingContext context) {
        super(context);
    }

    @Override
    public void buildNarrative(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper r) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        if (!r.isDirect()) {
            throw new Error("CapabilityStatementRenderer only renders native resources directly");
        }
        this.renderResourceTechDetails(r, x);
        this.render(status, x, (CapabilityStatement)r.getBase(), r);
    }

    @Override
    public String buildSummary(ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        return this.canonicalTitle(r);
    }

    public void render(Renderer.RenderingStatus status, XhtmlNode x, CapabilityStatement conf, ResourceWrapper res) throws FHIRFormatError, DefinitionException, IOException {
        status.setExtensions(true);
        boolean igRenderingMode = this.context.getRules() == RenderingContext.GenerationRules.IG_PUBLISHER;
        Enumerations.FHIRVersion currentVersion = conf.getFhirVersion();
        String versionPathComponent = this.getVersionPathComponent(currentVersion.getDefinition());
        this.currentFhirBase = !Utilities.noString((String)versionPathComponent) ? FHIR_BASE + versionPathComponent + "/" : FHIR_BASE;
        String igVersion = conf.getVersion();
        x.h(2, "title").addText(conf.getTitle());
        XhtmlNode uList = x.ul();
        uList.li().addText(this.context.formatPhrase("CAPABILITY_IMP_VER", new Object[]{igVersion}) + " ");
        uList.li().addText(this.context.formatPhrase("CAPABILITY_FHIR_VER", new Object[]{currentVersion.toCode()}) + " ");
        this.addSupportedFormats(uList, conf);
        uList.li().addText(this.context.formatPhrase("CAPABILITY_PUB_ON", new Object[]{this.displayDateTime(this.wrapWC(res, conf.getDateElement())) + " "}));
        uList.li().addText(this.context.formatPhrase("CAPABILITY_PUB_BY", new Object[]{conf.getPublisherElement().asStringValue()}) + " ");
        XhtmlNode block = x.addTag("blockquote").attribute("class", "impl-note");
        block.addTag("p").addTag("strong").addText(this.context.formatPhrase("CAPABILITY_NOTE_CAP", new Object[0]));
        block.addTag("p").addText(this.context.formatPhrase("CAPABILTY_ALLOW_CAP", new Object[0]));
        this.addSupportedCSs(status, x, conf, res);
        this.addSupportedIGs(x, conf);
        int restNum = conf.getRest().size();
        int nextLevel = 3;
        if (restNum > 0) {
            x.h(2, "rest").addText(this.context.formatPhrase("CAPABILITY_REST_CAPS", new Object[0]));
            int count = 1;
            for (CapabilityStatement.CapabilityStatementRestComponent rest : conf.getRest()) {
                if (restNum > 1) {
                    x.h(3, "rest" + Integer.toString(count)).addText(this.context.formatPhrase("CAPABILITY_REST_CONFIG", new Object[]{Integer.toString(count)}) + " ");
                    nextLevel = 4;
                }
                this.addRestConfigPanel(x, rest, nextLevel, count);
                boolean hasVRead = false;
                boolean hasPatch = false;
                boolean hasDelete = false;
                boolean hasHistory = false;
                boolean hasUpdates = false;
                for (CapabilityStatement.CapabilityStatementRestResourceComponent r : rest.getResource()) {
                    hasVRead = hasVRead || this.hasOp(r, CapabilityStatement.TypeRestfulInteraction.VREAD);
                    hasPatch = hasPatch || this.hasOp(r, CapabilityStatement.TypeRestfulInteraction.PATCH);
                    hasDelete = hasDelete || this.hasOp(r, CapabilityStatement.TypeRestfulInteraction.DELETE);
                    hasHistory = hasHistory || this.hasOp(r, CapabilityStatement.TypeRestfulInteraction.HISTORYTYPE);
                    hasUpdates = hasUpdates || this.hasOp(r, CapabilityStatement.TypeRestfulInteraction.HISTORYINSTANCE);
                }
                if (rest.getResource().size() > 0) {
                    x.h(nextLevel, "resourcesCap" + Integer.toString(count)).addText(this.context.formatPhrase("CAPABILITY_RES_PRO", new Object[0]));
                    x.h(nextLevel + 1, "resourcesSummary" + Integer.toString(count)).addText(this.context.formatPhrase("GENERAL_SUMM", new Object[0]));
                    this.addSummaryIntro(x);
                    this.addSummaryTable(status, res, x, rest, hasVRead, hasPatch, hasDelete, hasHistory, hasUpdates, count);
                    x.addTag("hr");
                    int resCount = 1;
                    for (CapabilityStatement.CapabilityStatementRestResourceComponent r : rest.getResource()) {
                        this.addResourceConfigPanel(x, r, nextLevel + 1, count, resCount, igRenderingMode);
                        ++resCount;
                    }
                }
                ++count;
            }
        }
        if (this.multExpectationsPresent) {
            this.addWarningPanel(x, "\u2e4b\u2e4b - this mark indicates that there are more than one expectation extensions present");
        }
    }

    private String getVersionPathComponent(String definition) {
        if (Utilities.noString((String)definition)) {
            return "";
        }
        if (!definition.startsWith(VERS_DEF_PREFIX)) {
            return "";
        }
        String[] restOfDef = definition.substring(VERS_DEF_PREFIX.length()).split(" ");
        if (restOfDef[1].startsWith("(")) {
            return "R" + restOfDef[0];
        }
        return "";
    }

    public void describe(XhtmlNode x, CapabilityStatement cs) {
        x.tx(this.display(cs));
    }

    public String display(CapabilityStatement cs) {
        return cs.present();
    }

    private boolean hasOp(CapabilityStatement.CapabilityStatementRestResourceComponent r, CapabilityStatement.TypeRestfulInteraction on) {
        for (CapabilityStatement.ResourceInteractionComponent op : r.getInteraction()) {
            if (op.getCode() != on) continue;
            return true;
        }
        return false;
    }

    private String showOp(CapabilityStatement.CapabilityStatementRestResourceComponent r, CapabilityStatement.TypeRestfulInteraction on) {
        for (CapabilityStatement.ResourceInteractionComponent op : r.getInteraction()) {
            if (op.getCode() != on) continue;
            return "y";
        }
        return "";
    }

    private String showOp(CapabilityStatement.CapabilityStatementRestComponent r, CapabilityStatement.SystemRestfulInteraction on) {
        for (CapabilityStatement.SystemInteractionComponent op : r.getInteraction()) {
            if (op.getCode() != on) continue;
            return "y";
        }
        return "";
    }

    private XhtmlNode addTableRow(XhtmlNode t, String name) {
        XhtmlNode tr = t.tr();
        tr.td().addText(name);
        return tr.td();
    }

    private void addTableRow(XhtmlNode t, String name, String value) {
        XhtmlNode tr = t.tr();
        tr.td().addText(name);
        tr.td().addText(value);
    }

    @Nullable
    private String getExtValueCode(Extension ext) {
        if (ext != null) {
            return ext.getValueCodeType().getCode();
        }
        return null;
    }

    private void addSupportedCSs(Renderer.RenderingStatus status, XhtmlNode x, CapabilityStatement cap, ResourceWrapper res) throws UnsupportedEncodingException, IOException {
        boolean first;
        XhtmlNode p;
        if (cap.hasInstantiates()) {
            p = x.para();
            p.tx(cap.getInstantiates().size() > 1 ? "This CapabilityStatement instantiates these CapabilityStatements" : "This CapabilityStatement instantiates the CapabilityStatement");
            first = true;
            for (CanonicalType ct : cap.getInstantiates()) {
                if (first) {
                    first = false;
                } else {
                    p.tx(", ");
                }
                this.renderCanonical(status, res, p, CapabilityStatement.class, ct);
            }
        }
        if (cap.hasImports()) {
            p = x.para();
            p.tx(cap.getImports().size() > 1 ? "This CapabilityStatement imports these CapabilityStatements" : "This CapabilityStatement imports the CapabilityStatement");
            first = true;
            for (CanonicalType ct : cap.getImports()) {
                if (first) {
                    first = false;
                } else {
                    p.tx(", ");
                }
                this.renderCanonical(status, res, p, CapabilityStatement.class, ct);
            }
        }
    }

    private void addSupportedIGs(XhtmlNode x, CapabilityStatement cap) {
        String capExpectation = null;
        if (cap.hasImplementationGuide()) {
            ArrayList<String> igShoulds = new ArrayList<String>();
            ArrayList<String> igShalls = new ArrayList<String>();
            ArrayList<String> igMays = new ArrayList<String>();
            boolean i = false;
            for (CanonicalType c : cap.getImplementationGuide()) {
                capExpectation = this.getExtValueCode(c.getExtensionByUrl(EXPECTATION));
                if (!Utilities.noString((String)capExpectation)) {
                    if (capExpectation.equals("SHALL")) {
                        igShalls.add(c.asStringValue());
                        continue;
                    }
                    if (capExpectation.equals("SHOULD")) {
                        igShoulds.add(c.asStringValue());
                        continue;
                    }
                    if (!capExpectation.equals("MAY")) continue;
                    igMays.add(c.asStringValue());
                    continue;
                }
                igShalls.add(c.asStringValue());
            }
            XhtmlNode ul = null;
            if (igShalls.size() > 0) {
                x.h(3, "shallIGs").addText(this.context.formatPhrase("CAPABILTY_SHALL_SUPP", new Object[0]));
                ul = x.ul();
                for (String url : igShalls) {
                    this.addResourceLink(ul.li(), url, url);
                }
            }
            if (igShoulds.size() > 0) {
                x.h(3, "shouldIGs").addText(this.context.formatPhrase("CAPABILITY_SHOULD_SUPP", new Object[0]));
                ul = x.ul();
                for (String url : igShoulds) {
                    this.addResourceLink(ul.li(), url, url);
                }
            }
            if (igMays.size() > 0) {
                x.h(3, "shouldIGs").addText(this.context.formatPhrase("CAPABILITY_SHOULD_SUPP", new Object[0]));
                ul = x.ul();
                for (String url : igMays) {
                    this.addResourceLink(ul.li(), url, url);
                }
            }
        }
    }

    private void addSupportedFormats(XhtmlNode uList, CapabilityStatement conf) {
        XhtmlNode lItem = uList.li();
        lItem.addText(this.context.formatPhrase("CAPABILITY_SUPP_FORM", new Object[0]) + " ");
        Boolean first = true;
        String capExpectation = null;
        for (CodeType c : conf.getFormat()) {
            if (!first.booleanValue()) {
                lItem.addText(", ");
            }
            if (!Utilities.noString((String)(capExpectation = this.getExtValueCode(c.getExtensionByUrl(EXPECTATION))))) {
                lItem.addTag("strong").addText(capExpectation);
                lItem.addText(" " + this.context.formatPhrase("CAPABILITY_SUPP", new Object[0]) + " ");
            }
            lItem.code().addText(c.getCode());
            first = false;
        }
        lItem = uList.li();
        lItem.addText(this.context.formatPhrase("CAPABILITY_SUPP_PATCH_FORM", new Object[0]) + " ");
        first = true;
        for (CodeType c : conf.getPatchFormat()) {
            if (!first.booleanValue()) {
                lItem.addText(", ");
            }
            if (!Utilities.noString((String)(capExpectation = this.getExtValueCode(c.getExtensionByUrl(EXPECTATION))))) {
                lItem.addTag("strong").addText(capExpectation);
                lItem.addText(this.context.formatPhrase("CAPABILITY_SUPP", new Object[0]) + " ");
            }
            lItem.code().addText(c.getCode());
            first = false;
        }
    }

    private void addRestConfigPanel(XhtmlNode x, CapabilityStatement.CapabilityStatementRestComponent rest, int nextLevel, int count) throws FHIRFormatError, DefinitionException, IOException {
        XhtmlNode panel = null;
        XhtmlNode body = null;
        XhtmlNode row = null;
        XhtmlNode cell = null;
        XhtmlNode heading = null;
        panel = x.div().attribute("class", "panel panel-default");
        heading = panel.div().attribute("class", "panel-heading").h(nextLevel, "mode" + Integer.toString(count)).attribute("class", "panel-title");
        heading.addText("Mode: ");
        heading.code().addText(rest.getMode().toCode());
        body = panel.div().attribute("class", "panel-body");
        this.addMarkdown(body, rest.getDocumentation());
        if (rest.hasSecurity()) {
            body.div().attribute("class", "lead").addTag("em").addText("Security");
            String mdText = rest.getSecurity().getDescription();
            boolean cors = rest.getSecurity().getCors();
            List<CodeableConcept> services = rest.getSecurity().getService();
            if (cors || services.size() > 0) {
                row = body.div().attribute("class", "row");
                row.div().attribute("class", "col-lg-6").addText(this.getCorsText(cors));
                cell = row.div().attribute("class", "col-lg-6");
                cell.addText("Security services supported: ");
                this.addSeparatedListOfCodes(cell, this.getSecServices(services), ",");
            }
            if (!Utilities.noString((String)mdText)) {
                this.addMarkdown(body.blockquote(), mdText);
            }
        }
        body.div().attribute("class", "lead").addTag("em").addText(this.context.formatPhrase("CAPABILITY_SUMM_SYS_INT", new Object[0]));
        this.addSystemInteractions(body, rest.getInteraction());
    }

    private String getCorsText(boolean on) {
        if (on) {
            return this.context.formatPhrase("CAPABILITY_CORS_YES", new Object[0]);
        }
        return this.context.formatPhrase("CAPABILITY_CORS_NO", new Object[0]);
    }

    private List<String> getSecServices(List<CodeableConcept> services) {
        ArrayList<String> serviceStrings = new ArrayList<String>();
        for (CodeableConcept c : services) {
            if (c.hasCoding()) {
                serviceStrings.add(c.getCodingFirstRep().getCode());
                continue;
            }
            serviceStrings.add(c.getText());
        }
        return serviceStrings;
    }

    private void addSystemInteractions(XhtmlNode body, List<CapabilityStatement.SystemInteractionComponent> interactions) {
        if (interactions.size() == 0) {
            return;
        }
        XhtmlNode uList = body.ul();
        String capExpectation = null;
        String expName = null;
        String documentation = null;
        HashMap<String, String> expression = null;
        ArrayList<Map<String, String>> shalls = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> shoulds = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> mays = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> shouldnots = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> supports = new ArrayList<Map<String, String>>();
        for (CapabilityStatement.SystemInteractionComponent comp : interactions) {
            capExpectation = this.getExtValueCode(comp.getExtensionByUrl(EXPECTATION));
            expName = comp.getCode().toCode();
            documentation = comp.getDocumentation();
            if (Utilities.noString((String)documentation)) {
                documentation = "";
            }
            expression = new HashMap<String, String>();
            expression.put(expName, documentation);
            if (!Utilities.noString((String)capExpectation)) {
                if (capExpectation.equals("SHALL")) {
                    shalls.add(expression);
                    continue;
                }
                if (capExpectation.equals("SHOULD")) {
                    shoulds.add(expression);
                    continue;
                }
                if (capExpectation.equals("MAY")) {
                    mays.add(expression);
                    continue;
                }
                if (!capExpectation.equals("SHOULD-NOT")) continue;
                shouldnots.add(expression);
                continue;
            }
            supports.add(expression);
        }
        this.addInteractionListItems(uList, "SHALL", shalls);
        this.addInteractionListItems(uList, "SHOULD", shoulds);
        this.addInteractionListItems(uList, "MAY", mays);
        this.addInteractionListItems(uList, "SHOULD NOT", shouldnots);
        this.addInteractionListItems(uList, null, supports);
    }

    private void addInteractionListItems(XhtmlNode uList, String verb, List<Map<String, String>> interactions) {
        XhtmlNode item = null;
        String interaction = null;
        String documentation = null;
        for (Map<String, String> interactionMap : interactions) {
            item = uList.li();
            if (Utilities.noString((String)verb)) {
                item.addText(this.context.formatPhrase("CAPABILITY_SUPP_THE", new Object[0]) + " ");
            } else {
                item.addTag("strong").addText(verb);
                item.addText(this.context.formatPhrase("CAPABILITY_SUPP_THE", new Object[0]) + " ");
            }
            interaction = interactionMap.keySet().toArray()[0].toString();
            item.code(interaction);
            documentation = interactionMap.get(interaction);
            if (Utilities.noString((String)documentation)) {
                item.addText(this.context.formatPhrase("CAPABILITY_INT", new Object[0]));
                continue;
            }
            item.addText(this.context.formatPhrase("CAPABILITY_INT_DESC", new Object[0]));
            try {
                this.addMarkdown(item, documentation);
            }
            catch (FHIRFormatError e) {
                e.printStackTrace();
            }
            catch (DefinitionException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void addInteractionSummaryList(XhtmlNode uList, String verb, List<String> interactions) {
        if (interactions.size() == 0) {
            return;
        }
        XhtmlNode item = uList.li();
        if (Utilities.noString((String)verb)) {
            item.addText(this.context.formatPhrase("CAPABILITY_SUPPS", new Object[0]) + " ");
        } else {
            item.addTag("strong").addText(verb);
            item.addText(this.context.formatPhrase("CAPABILITY_SUPP", new Object[0]) + " ");
        }
        this.addSeparatedListOfCodes(item, interactions, ",");
        item.addText(".");
    }

    private void addSummaryIntro(XhtmlNode x) {
        XhtmlNode uList = null;
        XhtmlNode lItem = null;
        x.para().addText(this.context.formatPhrase("CAPABILITY_SUMM_RES", new Object[0]));
        uList = x.ul();
        uList.li().addText(this.context.formatPhrase("CAPABILITY_REV_PROF", new Object[0]));
        lItem = uList.li();
        lItem.addText(this.context.formatPhrase("CAPABILITY_INTER_SUPP", new Object[0]));
        lItem.b().addTag("span").attribute("class", "bg-info").addText("R");
        lItem.addText("ead, ");
        lItem.b().addTag("span").attribute("class", "bg-info").addText("S");
        lItem.addText("earch, ");
        lItem.b().addTag("span").attribute("class", "bg-info").addText("U");
        lItem.addText("pdate, and ");
        lItem.b().addTag("span").attribute("class", "bg-info").addText("C");
        lItem.addText("reate, are always shown, while ");
        lItem.b().addTag("span").attribute("class", "bg-info").addText("VR");
        lItem.addText("ead, ");
        lItem.b().addTag("span").attribute("class", "bg-info").addText("P");
        lItem.addText("atch, ");
        lItem.b().addTag("span").attribute("class", "bg-info").addText("D");
        lItem.addText("elete, ");
        lItem.b().addTag("span").attribute("class", "bg-info").addText("H");
        lItem.addText("istory on ");
        lItem.b().addTag("span").attribute("class", "bg-info").addText("I");
        lItem.addText("nstance, or ");
        lItem.b().addTag("span").attribute("class", "bg-info").addText("H");
        lItem.addText("istory on ");
        lItem.b().addTag("span").attribute("class", "bg-info").addText("T");
        lItem.addText(this.context.formatPhrase("CAPABILITY_TYP_PRES", new Object[0]));
        uList.li().addTag("span").addText(this.context.formatPhrase("CAPABILITY_SEARCH_PAR", new Object[0]) + " ");
        lItem = uList.li();
        lItem.addText(this.context.formatPhrase("CAPABILITY_RES_ENB", new Object[0]) + " ");
        lItem.code().addText("_include");
        lItem = uList.li();
        lItem.addText(this.context.formatPhrase("CAPABILITY_OTH_RES_ENB", new Object[0]) + " ");
        lItem.code().addText("_revinclude");
        uList.li().addText(this.context.formatPhrase("CAPABILITY_RES_OPER", new Object[0]));
    }

    private void addSummaryTable(Renderer.RenderingStatus status, ResourceWrapper res, XhtmlNode x, CapabilityStatement.CapabilityStatementRestComponent rest, boolean hasVRead, boolean hasPatch, boolean hasDelete, boolean hasHistory, boolean hasUpdates, int count) throws IOException {
        XhtmlNode t = x.div().attribute("class", "table-responsive").table("table table-condensed table-hover");
        XhtmlNode tr = t.addTag("thead").tr();
        tr.th().b().tx(this.context.formatPhrase("CAPABILITY_RES_TYP", new Object[0]));
        tr.th().b().tx(this.context.formatPhrase("GENERAL_PROF", new Object[0]));
        tr.th().attribute("class", "text-center").b().attribute("title", this.context.formatPhrase("CAPABILITY_READ_INT", new Object[0])).tx("R");
        if (hasVRead) {
            tr.th().attribute("class", "text-center").b().attribute("title", this.context.formatPhrase("CAPABILITY_VREAD_INT", new Object[0])).tx("V-R");
        }
        tr.th().attribute("class", "text-center").b().attribute("title", this.context.formatPhrase("CAPABILITY_SEARCH_INT", new Object[0])).tx("S");
        tr.th().attribute("class", "text-center").b().attribute("title", this.context.formatPhrase("CAPABILITY_UPDATE_INT", new Object[0])).tx("U");
        if (hasPatch) {
            tr.th().attribute("class", "text-center").b().attribute("title", this.context.formatPhrase("CAPABILITY_PATCH_INT", new Object[0])).tx("P");
        }
        tr.th().attribute("class", "text-center").b().attribute("title", this.context.formatPhrase("CAPABILITY_CREATE_INT", new Object[0])).tx("C");
        if (hasDelete) {
            tr.th().attribute("class", "text-center").b().attribute("title", this.context.formatPhrase("CAPABILITY_DELETE_INT", new Object[0])).tx("D");
        }
        if (hasUpdates) {
            tr.th().attribute("class", "text-center").b().attribute("title", this.context.formatPhrase("CAPABILITY_HISTORY_INT", new Object[0])).tx("H-I");
        }
        if (hasHistory) {
            tr.th().attribute("class", "text-center").b().attribute("title", this.context.formatPhrase("CAPABILITY_HISTORY_TYPE", new Object[0])).tx("H-T");
        }
        tr.th().b().attribute("title", this.context.formatPhrase("CAPABILITY_REQ_RECOM", new Object[0])).tx(this.context.formatPhrase("CAPABILITY_SEARCHES", new Object[0]));
        tr.th().code().b().tx("_include");
        tr.th().code().b().tx("_revinclude");
        tr.th().b().tx(this.context.formatPhrase("CAPABILITY_OP", new Object[0]));
        XhtmlNode tbody = t.addTag("tbody");
        XhtmlNode profCell = null;
        boolean hasProf = false;
        boolean hasSupProf = false;
        int resCount = 1;
        Object countString = "";
        for (CapabilityStatement.CapabilityStatementRestResourceComponent r : rest.getResource()) {
            tr = tbody.tr();
            countString = Integer.toString(count) + "-" + Integer.toString(resCount);
            tr.td().ah("#" + r.getType() + (String)countString).addText(r.getType());
            ++resCount;
            profCell = tr.td();
            hasProf = r.hasProfile();
            hasSupProf = r.hasSupportedProfile();
            if (!hasProf && !hasSupProf) {
                profCell.nbsp();
            } else if (hasProf) {
                this.addResourceLink(profCell, r.getProfile(), r.getProfile());
                if (hasSupProf) {
                    profCell.br();
                    profCell.addTag("em").addText(this.context.formatPhrase("CAPABILITY_ADD_SUPP_PROF", new Object[0]));
                    this.renderSupportedProfiles(status, res, profCell, r);
                }
            } else {
                profCell.addText(this.context.formatPhrase("CAPABILITY_SUPP_PROFS", new Object[0]));
                this.renderSupportedProfiles(status, res, profCell, r);
            }
            tr.td().addText(this.showOp(r, CapabilityStatement.TypeRestfulInteraction.READ));
            if (hasVRead) {
                tr.td().attribute("class", "text-center").addText(this.showOp(r, CapabilityStatement.TypeRestfulInteraction.VREAD));
            }
            tr.td().attribute("class", "text-center").addText(this.showOp(r, CapabilityStatement.TypeRestfulInteraction.SEARCHTYPE));
            tr.td().attribute("class", "text-center").addText(this.showOp(r, CapabilityStatement.TypeRestfulInteraction.UPDATE));
            if (hasPatch) {
                tr.td().attribute("class", "text-center").addText(this.showOp(r, CapabilityStatement.TypeRestfulInteraction.PATCH));
            }
            tr.td().attribute("class", "text-center").addText(this.showOp(r, CapabilityStatement.TypeRestfulInteraction.CREATE));
            if (hasDelete) {
                tr.td().attribute("class", "text-center").addText(this.showOp(r, CapabilityStatement.TypeRestfulInteraction.DELETE));
            }
            if (hasUpdates) {
                tr.td().attribute("class", "text-center").addText(this.showOp(r, CapabilityStatement.TypeRestfulInteraction.HISTORYINSTANCE));
            }
            if (hasHistory) {
                tr.td().attribute("class", "text-center").addText(this.showOp(r, CapabilityStatement.TypeRestfulInteraction.HISTORYTYPE));
            }
            List<String> stringList = new ArrayList<String>();
            this.getParams(stringList, r.getSearchParam());
            this.getCombinedParams(stringList, r.getExtensionsByUrl(COMBINED));
            tr.td().addText(this.getSeparatedList(stringList, ","));
            stringList = this.getStringListFromStringTypeList(r.getSearchInclude());
            this.addSeparatedListOfCodes(tr.td(), stringList, ",");
            stringList = this.getStringListFromStringTypeList(r.getSearchRevInclude());
            this.addSeparatedListOfCodes(tr.td(), stringList, ",");
            stringList = this.getStringListFromOperations(r.getOperation());
            this.addSeparatedListOfCodes(tr.td(), stringList, ",");
        }
    }

    private List<String> getCombinedParams(List<String> paramNames, List<Extension> paramExtensions) {
        for (Extension e : paramExtensions) {
            String capExpectation = this.expectationForDisplay(e, EXPECTATION);
            if (Utilities.noString((String)capExpectation) || !capExpectation.equals("SHALL") && !capExpectation.equals("SHOULD") && !capExpectation.equals("MAY")) continue;
            paramNames.add(this.printCombinedParams(e));
        }
        return paramNames;
    }

    private void renderSupportedProfiles(Renderer.RenderingStatus status, ResourceWrapper res, XhtmlNode profCell, CapabilityStatement.CapabilityStatementRestResourceComponent r) throws IOException {
        for (CanonicalType sp : r.getSupportedProfile()) {
            profCell.br();
            profCell.nbsp().nbsp();
            this.renderCanonical(status, res, profCell, StructureDefinition.class, sp);
        }
        if (r.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/profile-mapping")) {
            profCell.br();
            profCell.b().tx(this.context.formatPhrase("CAPABILITY_PROF_MAP", new Object[0]));
            XhtmlNode tbl = profCell.table("grid");
            boolean doco = false;
            for (Extension ext : r.getExtensionsByUrl("http://hl7.org/fhir/tools/StructureDefinition/profile-mapping")) {
                doco = doco || ext.hasExtension("documentation");
            }
            XhtmlNode tr = tbl.tr();
            tr.th().tx(this.context.formatPhrase("GENERAL_CRIT", new Object[0]));
            tr.th().tx(this.context.formatPhrase("GENERAL_PROF", new Object[0]));
            if (doco) {
                tr.th().tx(this.context.formatPhrase("GENERAL_CRIT", new Object[0]));
            }
            for (Extension ext : r.getExtensionsByUrl("http://hl7.org/fhir/tools/StructureDefinition/profile-mapping")) {
                tr = tbl.tr();
                tr.td().code().tx(ToolingExtensions.readStringExtension((Element)ext, "search"));
                String url = ToolingExtensions.readStringExtension((Element)ext, "profile");
                StructureDefinition sd = this.context.getContext().fetchResource(StructureDefinition.class, url);
                if (sd != null) {
                    tr.td().code().ah(sd.getWebPath()).tx(sd.present());
                } else {
                    tr.td().code().tx(url);
                }
                if (!doco) continue;
                tr.td().code().markdown(ToolingExtensions.readStringExtension((Element)ext, "documentation"), "documentation");
            }
        }
    }

    private String printCombinedParams(Extension e) {
        StringBuilder params = new StringBuilder();
        List<Extension> requiredParams = e.getExtensionsByUrl("required");
        List<Extension> optionalParams = e.getExtensionsByUrl("optional");
        boolean first = true;
        for (Extension param : requiredParams) {
            if (!first) {
                params.append("+");
            }
            first = false;
            params.append(param.getValueStringType());
        }
        for (Extension param : optionalParams) {
            params.append("+");
            params.append(param.getValueStringType());
        }
        return params.toString();
    }

    private List<String> getParams(List<String> paramNames, List<CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent> params) {
        for (CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent p : params) {
            String capExpectation = this.expectationForDisplay(p, EXPECTATION);
            if (!Utilities.noString((String)capExpectation)) {
                if (!capExpectation.equals("SHALL") && !capExpectation.equals("SHOULD") && !capExpectation.equals("MAY")) continue;
                paramNames.add(p.getName());
                continue;
            }
            paramNames.add(p.getName());
        }
        return paramNames;
    }

    private String getSeparatedList(List<String> list, String separator) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String s : list) {
            if (!first) {
                result.append(separator + " ");
            }
            first = false;
            result.append(s);
        }
        return result.toString();
    }

    private List<String> getStringListFromStringTypeList(List<StringType> list) {
        ArrayList<String> stringList = new ArrayList<String>();
        for (StringType st : list) {
            stringList.add(st.asStringValue());
        }
        return stringList;
    }

    private void addSeparatedListOfCodes(XhtmlNode parent, List<String> list, String separator) {
        boolean first = true;
        for (String s : list) {
            if (!first) {
                parent.addText(separator + " ");
            }
            first = false;
            parent.code().addText(s);
        }
    }

    private List<String> getStringListFromOperations(List<CapabilityStatement.CapabilityStatementRestResourceOperationComponent> list) {
        ArrayList<String> result = new ArrayList<String>();
        for (CapabilityStatement.CapabilityStatementRestResourceOperationComponent op : list) {
            String capExpectation = this.expectationForDisplay(op, EXPECTATION);
            if (Utilities.noString((String)capExpectation) || !capExpectation.equals("SHALL") && !capExpectation.equals("SHOULD") && !capExpectation.equals("MAY")) continue;
            result.add("$" + op.getName());
        }
        return result;
    }

    private void addResourceConfigPanel(XhtmlNode x, CapabilityStatement.CapabilityStatementRestResourceComponent r, int nextLevel, int count, int resCount, boolean igRenderingMode) throws FHIRFormatError, DefinitionException, IOException {
        XhtmlNode panel = null;
        XhtmlNode body = null;
        XhtmlNode panelHead = null;
        XhtmlNode panelRef = null;
        String countString = Integer.toString(count) + "-" + Integer.toString(resCount);
        panel = x.div().attribute("class", "panel panel-default");
        if (igRenderingMode) {
            panelHead = panel.div().attribute("class", "panel-heading").attribute("role", "tab").attribute("id", "heading" + countString).h(nextLevel, r.getType() + countString).attribute("class", "panel-title");
            panelRef = panelHead.ah("#collapse" + countString).attribute("role", "button").attribute("data-toggle", "collapse").attribute("aria-expanded", "true").attribute("aria-controls", "collapse" + countString);
            panelRef.span("float: right;", "").addText("Resource Conformance: " + this.getResourceExpectation(r));
            panelRef.addText(r.getType());
            body = panel.div().attribute("class", this.collapseClass).attribute("id", "collapse" + countString).attribute("role", "tabpanel").attribute("aria-labelledby", "heading" + countString).div().attribute("class", "panel-body").div().attribute("class", "container");
        } else {
            panelHead = panel.div().attribute("class", "panel-heading").h(nextLevel, r.getType() + countString).attribute("class", "panel-title");
            panelHead.span("float: right;", "").addText(this.context.formatPhrase("CAPABILITY_RES_CONF", new Object[]{this.getResourceExpectation(r)}) + " ");
            panelHead.addText(r.getType());
            body = panel.div().attribute("class", "panel-body").div().attribute("class", "container");
        }
        XhtmlNode cell = null;
        XhtmlNode row = body.div().attribute("class", "row");
        String text = r.getProfile();
        boolean pullInteraction = false;
        String refPolicyWidth = "col-lg-3";
        if (!Utilities.noString((String)text)) {
            cell = row.div().attribute("class", "col-lg-6");
            this.addLead(cell, this.context.formatPhrase("CAPABILITY_BASE_SYS", new Object[0]));
            cell.br();
            this.addResourceLink(cell, text, text);
            cell = row.div().attribute("class", "col-lg-3");
            this.addLead(cell, this.context.formatPhrase("CAPABILITY_PROF_CONF", new Object[0]));
            cell.br();
            cell.b().addText(this.getProfileExpectation(r.getProfileElement()));
        } else {
            cell = row.div().attribute("class", "col-lg-4");
            this.addLead(cell, this.context.formatPhrase("CAPABILITY_FHIR", new Object[0]));
            cell.br();
            cell.ah(this.currentFhirBase + r.getType().toLowerCase() + ".html").addText(r.getType());
            pullInteraction = true;
            refPolicyWidth = "col-lg-4";
        }
        cell = row.div().attribute("class", refPolicyWidth);
        this.addLead(cell, this.context.formatPhrase("CAPABILITY_REF_PROF", new Object[0]));
        cell.br();
        this.addSeparatedListOfCodes(cell, this.getReferencePolicyStrings(r.getReferencePolicy()), ",");
        if (pullInteraction) {
            this.addInteractions(row, r, 4);
        }
        body.para();
        List<CanonicalType> supportedProfiles = r.getSupportedProfile();
        if (supportedProfiles.size() > 0) {
            row = body.div().attribute("class", "row");
            cell = row.div().attribute("class", "col-6");
            this.addLead(cell, this.context.formatPhrase("CAPABILITY_SUPP_PROFS", new Object[0]));
            XhtmlNode para = cell.para();
            boolean first = true;
            for (CanonicalType c : supportedProfiles) {
                if (!first) {
                    para.br();
                }
                first = false;
                this.addResourceLink(para, c.asStringValue(), c.asStringValue());
            }
        }
        if (!pullInteraction) {
            if (supportedProfiles.size() < 1) {
                row = body.div().attribute("class", "row");
            }
            this.addInteractions(row, r, 6);
        }
        body.para();
        String mdText = r.getDocumentation();
        if (!Utilities.noString((String)mdText)) {
            row = body.div().attribute("class", "row");
            cell = row.div().attribute("class", "col-12");
            this.addLead(cell, this.context.formatPhrase("GENERAL_DOCUMENTATION", new Object[0]));
            this.addMarkdown(cell.blockquote(), mdText);
        }
        ResourceSearchParams sParams = this.collectParams(r);
        this.addSearchParams(body, sParams);
        ResourceOperations ops = this.collectOperations(r);
        this.addExtendedOperations(body, ops);
    }

    private void addExtendedOperations(XhtmlNode body, ResourceOperations ops) {
        if (ops == null) {
            return;
        }
        Map<String, List<SingleOperation>> map = ops.getOperations();
        if (!this.hasOperations(map)) {
            return;
        }
        XhtmlNode row = body.div().attribute("class", "row");
        XhtmlNode cell = row.div().attribute("class", "col-12");
        this.addLead(cell, this.context.formatPhrase("CAPABILITY_EXT_OP", new Object[0]));
        XhtmlNode table = cell.table("table table-condensed table-hover");
        XhtmlNode tr = table.addTag("thead").tr();
        tr.th().addText(this.context.formatPhrase("GENERAL_CONFORMANCE", new Object[0]));
        tr.th().addText(this.context.formatPhrase("CAPABILITY_OPER", new Object[0]));
        tr.th().addText(this.context.formatPhrase("GENERAL_DOCUMENTATION", new Object[0]));
        XhtmlNode tbody = table.addTag("tbody");
        this.addOps(tbody, map, "supported");
        this.addOps(tbody, map, "SHALL");
        this.addOps(tbody, map, "SHOULD");
        this.addOps(tbody, map, "MAY");
        this.addOps(tbody, map, "SHOULD-NOT");
    }

    private ResourceOperations collectOperations(CapabilityStatement.CapabilityStatementRestResourceComponent r) {
        List<CapabilityStatement.CapabilityStatementRestResourceOperationComponent> opList = r.getOperation();
        if (opList.size() == 0) {
            return null;
        }
        ResourceOperations ops = new ResourceOperations();
        for (CapabilityStatement.CapabilityStatementRestResourceOperationComponent op : opList) {
            String capExpectation = this.expectationForDisplay(op, EXPECTATION);
            if (Utilities.noString((String)capExpectation)) {
                capExpectation = "supported";
            }
            SingleOperation operation = new SingleOperation(op.getName(), op.getDefinition(), op.getDocumentation(), capExpectation);
            ops.addOperation(capExpectation, operation);
        }
        return ops;
    }

    private void addInteractions(XhtmlNode row, CapabilityStatement.CapabilityStatementRestResourceComponent r, int width) {
        String widthString = "col-lg-" + Integer.toString(width);
        ArrayList<String> shalls = new ArrayList<String>();
        ArrayList<String> shoulds = new ArrayList<String>();
        ArrayList<String> mays = new ArrayList<String>();
        ArrayList<String> shouldnots = new ArrayList<String>();
        ArrayList<String> supporteds = new ArrayList<String>();
        for (CapabilityStatement.ResourceInteractionComponent op : r.getInteraction()) {
            String capExpectation = this.expectationForDisplay(op, EXPECTATION);
            if (!Utilities.noString((String)capExpectation)) {
                switch (capExpectation) {
                    case "SHALL": {
                        shalls.add(op.getCode().toCode());
                        break;
                    }
                    case "SHOULD": {
                        shoulds.add(op.getCode().toCode());
                        break;
                    }
                    case "MAY": {
                        mays.add(op.getCode().toCode());
                        break;
                    }
                    case "SHOULD-NOT": {
                        shouldnots.add(op.getCode().toCode());
                    }
                }
                continue;
            }
            supporteds.add(op.getCode().toCode());
        }
        XhtmlNode cell = row.div().attribute("class", widthString);
        this.addLead(cell, this.context.formatPhrase("CAPABILITY_INT_SUMM", new Object[0]));
        cell.br();
        XhtmlNode ul = cell.ul();
        this.addInteractionSummaryList(ul, "SHALL", shalls);
        this.addInteractionSummaryList(ul, "SHOULD", shoulds);
        this.addInteractionSummaryList(ul, "MAY", mays);
        this.addInteractionSummaryList(ul, "SHOULD-NOT", shouldnots);
        this.addInteractionSummaryList(ul, "", supporteds);
    }

    private ResourceSearchParams collectParams(CapabilityStatement.CapabilityStatementRestResourceComponent r) {
        SingleParam param;
        String capExpectation;
        ResourceSearchParams sParams = new ResourceSearchParams();
        for (CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent sp : r.getSearchParam()) {
            capExpectation = this.expectationForDisplay(sp, EXPECTATION);
            if (Utilities.noString((String)capExpectation)) {
                capExpectation = "supported";
            }
            param = new SingleParam(sp.getName(), sp.getDefinition(), sp.getType().toCode(), sp.getDocumentation(), capExpectation, r.getType().toLowerCase());
            sParams.addIndividualbyName(param.getName(), param);
            sParams.addIndividualbyExp(capExpectation, param);
        }
        for (Extension e : r.getExtensionsByUrl(COMBINED)) {
            String paramName;
            capExpectation = this.expectationForDisplay(e, EXPECTATION);
            if (Utilities.noString((String)capExpectation)) {
                capExpectation = "supported";
            }
            CombinedSearchParamSet combinedParams = new CombinedSearchParamSet(capExpectation);
            for (Extension cmpnt : e.getExtensionsByUrl("required")) {
                paramName = cmpnt.getValueStringType().asStringValue();
                param = sParams.getIndbyName().get(paramName);
                if (param == null) {
                    param = new SingleParam(paramName, "", "<unknown>");
                }
                combinedParams.addParam(true, param);
            }
            for (Extension cmpnt : e.getExtensionsByUrl("optional")) {
                paramName = cmpnt.getValueStringType().asStringValue();
                param = sParams.getIndbyName().get(paramName);
                if (param == null) {
                    param = new SingleParam(paramName);
                }
                combinedParams.addParam(false, param);
            }
            sParams.addCombinedParamSet(capExpectation, combinedParams);
        }
        return sParams;
    }

    private void addSearchParams(XhtmlNode body, ResourceSearchParams sParams) {
        Map<String, List<CombinedSearchParamSet>> comboMap = sParams.getCombined();
        if (this.isCombinedEmpty(comboMap) && sParams.getIndbyName().size() == 0) {
            return;
        }
        XhtmlNode row = body.div().attribute("class", "row");
        XhtmlNode cell = row.div().attribute("class", "col-lg-7");
        this.addLead(cell, this.context.formatPhrase("CAPABILITY_SEARCH_PARS", new Object[0]));
        XhtmlNode table = cell.table("table table-condensed table-hover");
        XhtmlNode tr = table.addTag("thead").tr();
        tr.th().addText(this.context.formatPhrase("GENERAL_CONFORMANCE", new Object[0]));
        tr.th().addText(this.context.formatPhrase("GENERAL_PAR", new Object[0]));
        tr.th().addText(this.context.formatPhrase("GENERAL_TYPE", new Object[0]));
        tr.th().addText(this.context.formatPhrase("GENERAL_DOCUMENTATION", new Object[0]));
        XhtmlNode tbody = table.addTag("tbody");
        Map<String, List<SingleParam>> map = sParams.getIndbyExp();
        this.addIndRows(tbody, map, "supported");
        this.addIndRows(tbody, map, "SHALL");
        this.addIndRows(tbody, map, "SHOULD");
        this.addIndRows(tbody, map, "MAY");
        this.addIndRows(tbody, map, "SHOULD-NOT");
        cell = row.div().attribute("class", "col-lg-5");
        if (!this.isCombinedEmpty(comboMap)) {
            this.addLead(cell, this.context.formatPhrase("CAPABILITY_COMB_SEARCH_PAR", new Object[0]));
            table = cell.table("table table-condensed table-hover");
            tr = table.addTag("thead").tr();
            tr.th().addText(this.context.formatPhrase("GENERAL_CONFORMANCE", new Object[0]));
            tr.th().addText(this.context.formatPhrase("GENERAL_PARS", new Object[0]));
            tr.th().addText(this.context.formatPhrase("CAPABILITY_TYPS", new Object[0]));
            tbody = table.addTag("tbody");
            this.addComboRows(tbody, comboMap, "supported");
            this.addComboRows(tbody, comboMap, "SHALL");
            this.addComboRows(tbody, comboMap, "SHOULD");
            this.addComboRows(tbody, comboMap, "MAY");
            this.addComboRows(tbody, comboMap, "SHOULD-NOT");
        } else {
            cell.nbsp();
        }
    }

    private void addIndRows(XhtmlNode tbody, Map<String, List<SingleParam>> map, String exp) {
        for (SingleParam param : map.get(exp)) {
            XhtmlNode tr = tbody.tr();
            if (!exp.equals("supported")) {
                tr.td().b().addText(exp);
            } else {
                tr.td().b().addText("SHALL");
            }
            this.addResourceLink(tr.td(), param.getName(), param.getDefinition(), true, param.getHostResource());
            tr.td().code().addText(param.getType());
            try {
                this.addMarkdown(tr.td(), param.getDocumentation());
            }
            catch (FHIRFormatError e) {
                e.printStackTrace();
            }
            catch (DefinitionException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void addOps(XhtmlNode tbody, Map<String, List<SingleOperation>> map, String exp) {
        for (SingleOperation operation : map.get(exp)) {
            XhtmlNode tr = tbody.tr();
            String name = "$" + operation.getName();
            if (!exp.equals("supported")) {
                tr.td().b().addText(exp);
            } else {
                tr.td().b().addText("SHALL");
            }
            String canonicalUri = operation.getDefinition();
            this.addResourceLink(tr.td(), name, canonicalUri);
            try {
                this.addMarkdown(tr.td(), operation.getDocumentation());
            }
            catch (FHIRFormatError e) {
                e.printStackTrace();
            }
            catch (DefinitionException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void addComboRows(XhtmlNode tbody, Map<String, List<CombinedSearchParamSet>> map, String exp) {
        for (CombinedSearchParamSet paramSet : map.get(exp)) {
            XhtmlNode tr = tbody.tr();
            if (!exp.equals("supported")) {
                tr.td().b().addText(exp);
            } else {
                tr.td().nbsp();
            }
            XhtmlNode td = tr.td();
            boolean first = true;
            for (SingleParam p : paramSet.getParams().get(true)) {
                if (!first) {
                    td.addText("+");
                }
                first = false;
                if (Utilities.noString((String)p.getDefinition())) {
                    td.addText(p.getName());
                    continue;
                }
                this.addResourceLink(td, p.getName(), p.getDefinition(), true, p.getHostResource());
            }
            if (paramSet.getParams().get(false).size() > 0) {
                td.addText("(");
                for (SingleParam p : paramSet.getParams().get(false)) {
                    td.addText("+");
                    if (Utilities.noString((String)p.getDefinition())) {
                        td.addText(p.getName());
                        continue;
                    }
                    this.addResourceLink(td, p.getName(), p.getDefinition(), true, p.getHostResource());
                }
                td.addText(")");
            }
            td = tr.td();
            first = true;
            for (SingleParam p : paramSet.getParams().get(true)) {
                if (!first) {
                    td.addText("+");
                }
                first = false;
                td.code().addText(p.getType());
            }
            if (paramSet.getParams().get(false).size() <= 0) continue;
            td.addText("(");
            for (SingleParam p : paramSet.getParams().get(false)) {
                td.addText("+");
                if (!p.getType().equals("<unknown>")) {
                    td.code().addText(p.getType());
                    continue;
                }
                td.addText(p.getType());
            }
            td.addText(")");
        }
    }

    boolean isCombinedEmpty(Map<String, List<CombinedSearchParamSet>> combinedMap) {
        boolean result = true;
        for (String s : combinedMap.keySet()) {
            if (combinedMap.get(s).size() <= 0) continue;
            result = false;
            break;
        }
        return result;
    }

    boolean hasOperations(Map<String, List<SingleOperation>> operationsMap) {
        boolean result = false;
        for (String s : operationsMap.keySet()) {
            if (operationsMap.get(s).size() <= 0) continue;
            result = true;
            break;
        }
        return result;
    }

    private List<String> getReferencePolicyStrings(List<Enumeration<CapabilityStatement.ReferenceHandlingPolicy>> list) {
        ArrayList<String> stringList = new ArrayList<String>();
        for (Enumeration<CapabilityStatement.ReferenceHandlingPolicy> p : list) {
            stringList.add(p.getCode());
        }
        return stringList;
    }

    private String getResourceExpectation(CapabilityStatement.CapabilityStatementRestResourceComponent r) {
        String capExpectation = this.expectationForDisplay(r, EXPECTATION);
        if (!Utilities.noString((String)capExpectation)) {
            return capExpectation;
        }
        boolean shalls = false;
        boolean shoulds = false;
        boolean mays = false;
        boolean shouldnots = false;
        for (CapabilityStatement.ResourceInteractionComponent ric : r.getInteraction()) {
            capExpectation = this.expectationForDisplay(ric, EXPECTATION);
            if (Utilities.noString((String)capExpectation)) continue;
            switch (capExpectation) {
                case "SHALL": {
                    shalls = true;
                    break;
                }
                case "SHOULD": {
                    shoulds = true;
                    break;
                }
                case "MAY": {
                    mays = true;
                    break;
                }
                case "SHOULD-NOT": {
                    shouldnots = true;
                }
            }
        }
        if (shalls) {
            return "SHALL";
        }
        for (CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent sp : r.getSearchParam()) {
            capExpectation = this.expectationForDisplay(sp, EXPECTATION);
            if (Utilities.noString((String)capExpectation)) continue;
            switch (capExpectation) {
                case "SHALL": {
                    shalls = true;
                    break;
                }
                case "SHOULD": {
                    shoulds = true;
                    break;
                }
                case "MAY": {
                    mays = true;
                    break;
                }
                case "SHOULD-NOT": {
                    shouldnots = true;
                }
            }
        }
        if (shalls) {
            return "SHALL";
        }
        if (shoulds) {
            return "SHOULD";
        }
        if (mays) {
            return "MAY";
        }
        if (shouldnots) {
            return "SHOULD NOT";
        }
        return "supported";
    }

    private String getProfileExpectation(CanonicalType r) {
        String capExpectation = this.expectationForDisplay(r, EXPECTATION);
        if (!Utilities.noString((String)capExpectation)) {
            return capExpectation;
        }
        return "SHALL";
    }

    private void addLead(XhtmlNode node, String text) {
        node.addTag("span").attribute("class", "lead").addText(text);
    }

    private void addResourceLink(XhtmlNode node, String name, String canonicalUri) {
        this.addResourceLink(node, name, canonicalUri, false, "");
    }

    private void addResourceLink(XhtmlNode node, String name, String canonicalUri, boolean isParam, String hostResource) {
        if (Utilities.noString((String)canonicalUri)) {
            node.addText(name);
            return;
        }
        Resource cr = this.context.getContext().fetchResource(Resource.class, canonicalUri);
        if (cr == null) {
            node.addText(name);
        } else {
            String path = cr.getWebPath();
            if (Utilities.noString((String)path)) {
                if (isParam && canonicalUri.toLowerCase().startsWith(SP_BASE) && !Utilities.noString((String)this.currentFhirBase) && !Utilities.noString((String)hostResource)) {
                    String resourceName = "";
                    resourceName = canonicalUri.substring(SP_BASE.length()).split("-")[0].toLowerCase().equals("resource") ? "resource" : (canonicalUri.substring(SP_BASE.length()).split("-")[0].toLowerCase().equals("domainresource") ? "domainresource" : hostResource);
                    node.ah(this.currentFhirBase + resourceName + ".html#search").addText(name);
                } else {
                    node.addText(name);
                }
            } else {
                node.ah(path).addText(name);
            }
        }
    }

    private String expectationForDisplay(Element e, String url) {
        try {
            String result = e.getExtensionString(url);
            return result;
        }
        catch (FHIRException fex) {
            List<Extension> ext = e.getExtensionsByUrl(url);
            if (ext.isEmpty()) {
                return null;
            }
            if (!ext.get(0).hasValue()) {
                return null;
            }
            this.multExpectationsPresent = true;
            return ext.get(0).getValue().primitiveValue() + "-\u2e4b\u2e4b";
        }
    }

    private void addWarningPanel(XhtmlNode node, String text) {
        XhtmlNode panel = node.addTag("div").attribute("class", "panel panel-danger").addTag("div").attribute("class", "panel-body");
        panel.addTag("span").attribute("class", "label label-danger").addText("Error detected");
        panel.addText(" " + text);
    }

    private class ResourceOperations {
        private Map<String, List<SingleOperation>> operationsByExp = new HashMap<String, List<SingleOperation>>();

        public ResourceOperations() {
            this.operationsByExp.put("SHALL", new ArrayList());
            this.operationsByExp.put("SHOULD", new ArrayList());
            this.operationsByExp.put("MAY", new ArrayList());
            this.operationsByExp.put("SHOULD-NOT", new ArrayList());
            this.operationsByExp.put("supported", new ArrayList());
        }

        public Map<String, List<SingleOperation>> getOperations() {
            return this.operationsByExp;
        }

        public void addOperation(String exp, SingleOperation op) {
            this.operationsByExp.get(exp).add(op);
        }
    }

    private class SingleOperation {
        private String name = "";
        private String definition = "";
        private String documentation = "";
        private String expectation = "";

        public SingleOperation(String name) {
            if (!Utilities.noString((String)name)) {
                this.name = name;
            }
        }

        public SingleOperation(String name, String definition) {
            if (!Utilities.noString((String)name)) {
                this.name = name;
            }
            if (!Utilities.noString((String)definition)) {
                this.definition = definition;
            }
        }

        public SingleOperation(String name, String definition, String documentation) {
            if (!Utilities.noString((String)name)) {
                this.name = name;
            }
            if (!Utilities.noString((String)definition)) {
                this.definition = definition;
            }
            if (!Utilities.noString((String)documentation)) {
                this.documentation = documentation;
            }
        }

        public SingleOperation(String name, String definition, String documentation, String expectation) {
            if (!Utilities.noString((String)name)) {
                this.name = name;
            }
            if (!Utilities.noString((String)definition)) {
                this.definition = definition;
            }
            if (!Utilities.noString((String)documentation)) {
                this.documentation = documentation;
            }
            if (!Utilities.noString((String)expectation)) {
                this.expectation = expectation;
            }
        }

        public String getName() {
            return this.name;
        }

        public String getDefinition() {
            return this.definition;
        }

        public String getDocumentation() {
            return this.documentation;
        }

        public String getExpectation() {
            return this.expectation;
        }
    }

    private class ResourceSearchParams {
        private Map<String, List<CombinedSearchParamSet>> combinedParams = new HashMap<String, List<CombinedSearchParamSet>>();
        private Map<String, SingleParam> individualParamsByName;
        private Map<String, List<SingleParam>> individualParamsByExp;

        public ResourceSearchParams() {
            this.combinedParams.put("SHALL", new ArrayList());
            this.combinedParams.put("SHOULD", new ArrayList());
            this.combinedParams.put("SHOULD-NOT", new ArrayList());
            this.combinedParams.put("MAY", new ArrayList());
            this.combinedParams.put("supported", new ArrayList());
            this.individualParamsByName = new HashMap<String, SingleParam>();
            this.individualParamsByExp = new HashMap<String, List<SingleParam>>();
            this.individualParamsByExp.put("SHALL", new ArrayList());
            this.individualParamsByExp.put("SHOULD", new ArrayList());
            this.individualParamsByExp.put("MAY", new ArrayList());
            this.individualParamsByExp.put("SHOULD-NOT", new ArrayList());
            this.individualParamsByExp.put("supported", new ArrayList());
        }

        public Map<String, List<CombinedSearchParamSet>> getCombined() {
            return this.combinedParams;
        }

        public Map<String, SingleParam> getInd() {
            return this.individualParamsByName;
        }

        public Map<String, SingleParam> getIndbyName() {
            return this.individualParamsByName;
        }

        public Map<String, List<SingleParam>> getIndbyExp() {
            return this.individualParamsByExp;
        }

        public void addCombinedParamSet(String exp, CombinedSearchParamSet params) {
            this.combinedParams.get(exp).add(params);
        }

        public void addIndividualbyName(String name, SingleParam param) {
            this.individualParamsByName.put(name, param);
        }

        public void addIndividualbyExp(String exp, SingleParam param) {
            this.individualParamsByExp.get(exp).add(param);
        }
    }

    private class SingleParam {
        private String name = "";
        private String definition = "";
        private String type = "";
        private String documentation = "";
        private String expectation = "";
        private String hostResource = "";

        public SingleParam(String name) {
            if (!Utilities.noString((String)name)) {
                this.name = name;
            }
        }

        public SingleParam(String name, String definition) {
            if (!Utilities.noString((String)name)) {
                this.name = name;
            }
            if (!Utilities.noString((String)definition)) {
                this.definition = definition;
            }
        }

        public SingleParam(String name, String definition, String type) {
            if (!Utilities.noString((String)name)) {
                this.name = name;
            }
            if (!Utilities.noString((String)definition)) {
                this.definition = definition;
            }
            if (!Utilities.noString((String)type)) {
                this.type = type;
            }
        }

        public SingleParam(String name, String definition, String type, String documentation) {
            if (!Utilities.noString((String)name)) {
                this.name = name;
            }
            if (!Utilities.noString((String)definition)) {
                this.definition = definition;
            }
            if (!Utilities.noString((String)type)) {
                this.type = type;
            }
            if (!Utilities.noString((String)documentation)) {
                this.documentation = documentation;
            }
        }

        public SingleParam(String name, String definition, String type, String documentation, String expectation, String hostResource) {
            if (!Utilities.noString((String)name)) {
                this.name = name;
            }
            if (!Utilities.noString((String)definition)) {
                this.definition = definition;
            }
            if (!Utilities.noString((String)type)) {
                this.type = type;
            }
            if (!Utilities.noString((String)documentation)) {
                this.documentation = documentation;
            }
            if (!Utilities.noString((String)expectation)) {
                this.expectation = expectation;
            }
            if (!Utilities.noString((String)hostResource)) {
                this.hostResource = hostResource;
            }
        }

        public String getName() {
            return this.name;
        }

        public String getDefinition() {
            return this.definition;
        }

        public String getDocumentation() {
            return this.documentation;
        }

        public String getType() {
            return this.type;
        }

        public String getExpectation() {
            return this.expectation;
        }

        public String getHostResource() {
            return this.hostResource;
        }
    }

    private class CombinedSearchParamSet {
        private Map<Boolean, List<SingleParam>> params = new HashMap<Boolean, List<SingleParam>>();
        String expectation = "";

        CombinedSearchParamSet(String expectation) {
            this.params.put(true, new ArrayList());
            this.params.put(false, new ArrayList());
            if (!Utilities.noString((String)expectation)) {
                this.expectation = expectation;
            }
        }

        public Map<Boolean, List<SingleParam>> getParams() {
            return this.params;
        }

        public String getExpectation() {
            return this.expectation;
        }

        public void addParam(boolean required, SingleParam param) {
            this.params.get(required).add(param);
        }
    }
}

