/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.comparison.VersionComparisonAnnotation;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.renderers.Renderer;
import org.hl7.fhir.r5.renderers.TerminologyRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.ResourceWrapper;
import org.hl7.fhir.r5.terminologies.CodeSystemUtilities;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.utilities.LoincLinker;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class CodeSystemRenderer
extends TerminologyRenderer {
    private Boolean doMarkdown = null;

    public CodeSystemRenderer(RenderingContext context) {
        super(context);
    }

    @Override
    public void buildNarrative(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper r) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        if (!r.isDirect()) {
            throw new Error("CodeSystemRenderer only renders native resources directly");
        }
        this.renderResourceTechDetails(r, x);
        this.genSummaryTable(status, x, (CodeSystem)r.getBase());
        this.render(status, x, (CodeSystem)r.getBase(), r);
    }

    @Override
    public String buildSummary(ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        return this.canonicalTitle(r);
    }

    public void render(Renderer.RenderingStatus status, XhtmlNode x, CodeSystem cs, ResourceWrapper res) throws FHIRFormatError, DefinitionException, IOException {
        if (this.context.isShowSummaryTable()) {
            XhtmlNode h = x.h2();
            h.addText(cs.hasTitle() ? cs.getTitle() : cs.getName());
            this.addMarkdown(x, cs.getDescription());
            if (cs.hasCopyright()) {
                this.generateCopyright(x, res);
            }
        }
        boolean props = this.generateProperties(x, cs);
        this.generateFilters(x, cs);
        ArrayList<TerminologyRenderer.UsedConceptMap> maps = new ArrayList<TerminologyRenderer.UsedConceptMap>();
        this.generateCodeSystemContent(status, x, cs, maps, props);
    }

    public void describe(XhtmlNode x, CodeSystem cs) {
        x.tx(this.display(cs));
    }

    public String display(CodeSystem cs) {
        return cs.present();
    }

    private void generateFilters(XhtmlNode x, CodeSystem cs) {
        if (cs.hasFilter()) {
            x.para().b().tx(this.formatPhrase("CODESYSTEM_FILTERS", new Object[0]));
            XhtmlNode tbl = x.table("grid");
            XhtmlNode tr = tbl.tr();
            tr.td().b().tx(this.formatPhrase("GENERAL_CODE", new Object[0]));
            tr.td().b().tx(this.formatPhrase("GENERAL_DESC", new Object[0]));
            tr.td().b().tx(this.formatPhrase("CODESYSTEM_FILTER_OP", new Object[0]));
            tr.td().b().tx(this.formatPhrase("GENERAL_VALUE", new Object[0]));
            for (CodeSystem.CodeSystemFilterComponent f : cs.getFilter()) {
                tr = tbl.tr();
                this.renderStatus(f, tr.td()).tx(f.getCode());
                this.renderStatus(f.getDescriptionElement(), tr.td()).tx(f.getDescription());
                XhtmlNode td = tr.td();
                for (Enumeration<Enumerations.FilterOperator> t : f.getOperator()) {
                    this.renderStatus(t, td).tx(t.asStringValue() + " ");
                }
                this.renderStatus(f.getValueElement(), tr.td()).tx(f.getValue());
            }
        }
    }

    private boolean generateProperties(XhtmlNode x, CodeSystem cs) {
        if (cs.hasProperty()) {
            boolean hasRendered = false;
            boolean hasURI = false;
            boolean hasDescription = false;
            for (CodeSystem.PropertyComponent p : cs.getProperty()) {
                hasRendered = hasRendered || this.getDisplayForProperty(p) != null;
                hasURI = hasURI || p.hasUri();
                hasDescription = hasDescription || p.hasDescription();
            }
            x.para().b().tx(this.formatPhrase("GENERAL_PROPS", new Object[0]));
            x.para().b().tx(this.formatPhrase("CODESYSTEM_PROPS_DESC", new Object[0]));
            XhtmlNode tbl = x.table("grid");
            XhtmlNode tr = tbl.tr();
            if (hasRendered) {
                tr.td().b().tx(this.formatPhrase("GENERAL_NAME", new Object[0]));
            }
            tr.td().b().tx(this.formatPhrase("GENERAL_CODE", new Object[0]));
            if (hasURI) {
                tr.td().b().tx(this.formatPhrase("GENERAL_URI", new Object[0]));
            }
            tr.td().b().tx(this.formatPhrase("GENERAL_TYPE", new Object[0]));
            if (hasDescription) {
                tr.td().b().tx(this.formatPhrase("GENERAL_DESC", new Object[0]));
            }
            for (CodeSystem.PropertyComponent p : cs.getProperty()) {
                tr = tbl.tr();
                if (hasRendered) {
                    tr.td().tx(this.getDisplayForProperty(p));
                }
                this.renderStatus(p, tr.td()).tx(p.getCode());
                if (hasURI) {
                    this.renderStatus(p.getUriElement(), tr.td()).tx(p.getUri());
                }
                this.renderStatus(p.getTypeElement(), tr.td()).tx(p.hasType() ? p.getType().toCode() : "");
                if (!hasDescription) continue;
                this.renderStatus(p.getDescriptionElement(), tr.td()).tx(p.getDescription());
            }
            return true;
        }
        return false;
    }

    private String sentenceForContent(Enumerations.CodeSystemContentMode mode, CodeSystem cs) {
        if (mode == null) {
            return this.formatPhrase("CODESYSTEM_CONTENT_NOTPRESENT", new Object[0]);
        }
        switch (mode) {
            case COMPLETE: {
                return this.formatPhrase("CODESYSTEM_CONTENT_COMPLETE", new Object[0]);
            }
            case EXAMPLE: {
                return this.formatPhrase("CODESYSTEM_CONTENT_EXAMPLE", new Object[0]);
            }
            case FRAGMENT: {
                return this.formatPhrase("CODESYSTEM_CONTENT_FRAGMENT", new Object[0]);
            }
            case NOTPRESENT: {
                return this.formatPhrase("CODESYSTEM_CONTENT_NOTPRESENT", new Object[0]);
            }
            case SUPPLEMENT: {
                boolean properties = CodeSystemUtilities.hasProperties(cs);
                boolean designations = CodeSystemUtilities.hasDesignations(cs);
                String features = properties && designations ? this.context.formatPhrase("CODE_SYS_DISP_PROP", new Object[0]) : (properties ? this.context.formatPhrase("CODE_SYS_PROP", new Object[0]) : (designations ? this.context.formatPhrase("CODE_SYS_DISP", new Object[0]) : this.context.formatPhrase("CODE_SYS_FEAT", new Object[0])));
                return this.formatPhrase("CODESYSTEM_CONTENT_SUPPLEMENT", features);
            }
        }
        throw new FHIRException(this.context.formatPhrase("CODE_SYS_UNKN_MODE", new Object[0]));
    }

    private void generateCodeSystemContent(Renderer.RenderingStatus status, XhtmlNode x, CodeSystem cs, List<TerminologyRenderer.UsedConceptMap> maps, boolean props) throws FHIRFormatError, DefinitionException, IOException {
        if (props) {
            x.para().b().tx(this.formatPhrase("CODESYSTEM_CONCEPTS", new Object[0]));
        }
        XhtmlNode p = x.para();
        p.startScript("csc");
        this.renderStatus(cs.getUrlElement(), p.param("cs")).code().tx(cs.getUrl());
        this.makeCasedParam(p.param("cased"), cs, cs.getCaseSensitiveElement());
        this.makeHierarchyParam(p.param("h"), cs, cs.getHierarchyMeaningElement());
        p.paramValue("code-count", CodeSystemUtilities.countCodes(cs));
        p.execScript(this.sentenceForContent(cs.getContent(), cs));
        p.closeScript();
        if (cs.getContent() == Enumerations.CodeSystemContentMode.NOTPRESENT) {
            return;
        }
        XhtmlNode t = x.table("codes");
        boolean definitions = false;
        boolean commentS = false;
        boolean deprecated = false;
        boolean display = false;
        boolean hierarchy = false;
        boolean version = false;
        boolean ignoreStatus = false;
        boolean isSupplement = cs.getContent() == Enumerations.CodeSystemContentMode.SUPPLEMENT;
        ArrayList<CodeSystem.PropertyComponent> properties = new ArrayList<CodeSystem.PropertyComponent>();
        for (CodeSystem.PropertyComponent propertyComponent : cs.getProperty()) {
            if (!this.showPropertyInTable(propertyComponent)) continue;
            boolean exists = false;
            for (CodeSystem.ConceptDefinitionComponent c : cs.getConcept()) {
                exists = exists || this.conceptsHaveProperty(c, propertyComponent);
            }
            if (!exists) continue;
            properties.add(propertyComponent);
            if (!"status".equals(propertyComponent.getCode())) continue;
            ignoreStatus = true;
        }
        ArrayList<String> langs = new ArrayList<String>();
        for (CodeSystem.ConceptDefinitionComponent c : cs.getConcept()) {
            commentS = commentS || this.conceptsHaveComments(c);
            deprecated = deprecated || this.conceptsHaveDeprecated(cs, c, ignoreStatus);
            display = display || this.conceptsHaveDisplay(c);
            version = version || this.conceptsHaveVersion(c);
            hierarchy = hierarchy || c.hasConcept();
            definitions = definitions || this.conceptsHaveDefinition(c);
            this.listConceptLanguages(cs, c, langs);
        }
        CodeSystemUtilities.CodeSystemNavigator codeSystemNavigator = new CodeSystemUtilities.CodeSystemNavigator(cs);
        boolean bl = hierarchy = hierarchy || codeSystemNavigator.isRestructure();
        if (langs.size() < 2) {
            this.addCopyColumn(this.addMapHeaders(this.addTableHeaderRowStandard(t, hierarchy, display, definitions, commentS, version, deprecated, properties, langs, null, true), maps));
        } else {
            this.addCopyColumn(this.addMapHeaders(this.addTableHeaderRowStandard(t, hierarchy, display, definitions, commentS, version, deprecated, properties, null, null, false), maps));
        }
        for (CodeSystem.ConceptDefinitionComponent c : codeSystemNavigator.getConcepts(null)) {
            this.addDefineRowToTable(status, t, c, 0, hierarchy, display, definitions, commentS, version, deprecated, maps, cs.getUrl(), cs, properties, codeSystemNavigator, langs.size() < 2 ? langs : null, isSupplement);
        }
        if (langs.size() >= 2) {
            Collections.sort(langs);
            x.para().b().tx(this.context.formatPhrase("GENERAL_ADD_LANG", new Object[0]));
            t = x.table("codes");
            XhtmlNode tr = t.tr();
            tr.td().b().tx(this.context.formatPhrase("GENERAL_CODE", new Object[0]));
            for (String lang : langs) {
                tr.td().b().addText(this.describeLang(lang));
            }
            for (CodeSystem.ConceptDefinitionComponent c : cs.getConcept()) {
                this.addLanguageRow(c, t, langs);
            }
        }
    }

    private void makeHierarchyParam(XhtmlNode x, CodeSystem cs, Enumeration<CodeSystem.CodeSystemHierarchyMeaning> hm) {
        if (hm.hasValue()) {
            String s = ((CodeSystem.CodeSystemHierarchyMeaning)((Object)hm.getValue())).getDisplay();
            this.renderStatus(hm, x).tx(" " + this.context.formatPhrase("CODE_SYS_IN_A_HIERARCHY", new Object[]{s}));
        } else if (VersionComparisonAnnotation.hasDeleted(cs, "hierarchyMeaning")) {
            this.makeHierarchyParam(x, null, (Enumeration)VersionComparisonAnnotation.getDeleted(cs, "hierarchyMeaning").get(0));
        } else if (CodeSystemUtilities.hasHierarchy(cs)) {
            x.tx(" " + this.context.formatPhrase("CODE_SYS_UNDEF_HIER", new Object[0]));
        } else {
            x.tx("");
        }
    }

    private void makeCasedParam(XhtmlNode x, CodeSystem cs, BooleanType caseSensitiveElement) {
        if (caseSensitiveElement.hasValue()) {
            String s = (Boolean)caseSensitiveElement.getValue() == true ? "case-sensitive" : "case-insensitive";
            this.renderStatus(caseSensitiveElement, x).tx(s);
        } else if (VersionComparisonAnnotation.hasDeleted(cs, "caseSensitive")) {
            this.makeCasedParam(x, null, (BooleanType)VersionComparisonAnnotation.getDeleted(cs, "caseSensitive").get(0));
        } else {
            x.tx("");
        }
    }

    private void listConceptLanguages(CodeSystem cs, CodeSystem.ConceptDefinitionComponent c, List<String> langs) {
        for (CodeSystem.ConceptDefinitionDesignationComponent cd : c.getDesignation()) {
            if (!cd.hasLanguage() || langs.contains(cd.getLanguage()) || cs.hasLanguage() && cs.getLanguage().equals(cd.getLanguage())) continue;
            langs.add(cd.getLanguage());
        }
        for (CodeSystem.ConceptDefinitionComponent g : c.getConcept()) {
            this.listConceptLanguages(cs, g, langs);
        }
    }

    private void addCopyColumn(XhtmlNode tr) {
        if (this.context.isCopyButton()) {
            tr.td().b().tx(this.context.formatPhrase("CODE_SYS_COPY", new Object[0]));
        }
    }

    private boolean conceptsHaveDefinition(CodeSystem.ConceptDefinitionComponent c) {
        if (c.hasDefinition()) {
            return true;
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent cd : c.getDesignation()) {
            if (!cd.getUse().is("http://terminology.hl7.org/CodeSystem/designation-usage", "definition") || !cd.hasLanguage() || c.getDefinition().equalsIgnoreCase(cd.getValue())) continue;
            return true;
        }
        for (CodeSystem.ConceptDefinitionComponent g : c.getConcept()) {
            if (!this.conceptsHaveDefinition(g)) continue;
            return true;
        }
        return false;
    }

    private boolean conceptsHaveProperty(CodeSystem.ConceptDefinitionComponent c, CodeSystem.PropertyComponent cp) {
        if (CodeSystemUtilities.hasProperty(c, cp.getCode())) {
            return true;
        }
        for (CodeSystem.ConceptDefinitionComponent g : c.getConcept()) {
            if (!this.conceptsHaveProperty(g, cp)) continue;
            return true;
        }
        return false;
    }

    private boolean showPropertyInTable(CodeSystem.PropertyComponent cp) {
        if (cp.hasCode()) {
            if (cp.hasExtension("http://hl7.org/fhir/StructureDefinition/rendered-value")) {
                return true;
            }
            if (cp.getCodeElement().hasExtension("http://hl7.org/fhir/StructureDefinition/rendered-value")) {
                return true;
            }
            String uri = cp.getUri();
            if (Utilities.noString((String)uri)) {
                return true;
            }
            String code = null;
            if (uri.contains("#")) {
                code = uri.substring(uri.indexOf("#") + 1);
                uri = uri.substring(0, uri.indexOf("#"));
            }
            if (Utilities.existsInList((String)uri, (String[])new String[]{"http://hl7.org/fhir/concept-properties"}) || this.context.getCodeSystemPropList().contains(uri)) {
                return true;
            }
            CodeSystem cs = this.getContext().getWorker().fetchCodeSystem(uri);
            if (cs == null) {
                return false;
            }
            return code == null ? false : CodeSystemUtilities.hasCode(cs, code);
        }
        return false;
    }

    private int countConcepts(List<CodeSystem.ConceptDefinitionComponent> list) {
        int count = list.size();
        for (CodeSystem.ConceptDefinitionComponent c : list) {
            if (!c.hasConcept()) continue;
            count += this.countConcepts(c.getConcept());
        }
        return count;
    }

    private boolean conceptsHaveComments(CodeSystem.ConceptDefinitionComponent c) {
        if (ToolingExtensions.hasCSComment(c)) {
            return true;
        }
        for (CodeSystem.ConceptDefinitionComponent g : c.getConcept()) {
            if (!this.conceptsHaveComments(g)) continue;
            return true;
        }
        return false;
    }

    private boolean conceptsHaveDisplay(CodeSystem.ConceptDefinitionComponent c) {
        if (c.hasDisplay() && !c.getDisplay().equals(c.getCode())) {
            return true;
        }
        for (CodeSystem.ConceptDefinitionComponent g : c.getConcept()) {
            if (!this.conceptsHaveDisplay(g)) continue;
            return true;
        }
        return false;
    }

    private boolean conceptsHaveVersion(CodeSystem.ConceptDefinitionComponent c) {
        if (c.hasUserData("cs.version.notes")) {
            return true;
        }
        for (CodeSystem.ConceptDefinitionComponent g : c.getConcept()) {
            if (!this.conceptsHaveVersion(g)) continue;
            return true;
        }
        return false;
    }

    private boolean conceptsHaveDeprecated(CodeSystem cs, CodeSystem.ConceptDefinitionComponent c, boolean ignoreStatus) {
        if (CodeSystemUtilities.isDeprecated(cs, c, ignoreStatus)) {
            return true;
        }
        for (CodeSystem.ConceptDefinitionComponent g : c.getConcept()) {
            if (!this.conceptsHaveDeprecated(cs, g, ignoreStatus)) continue;
            return true;
        }
        return false;
    }

    private void addDefineRowToTable(Renderer.RenderingStatus status, XhtmlNode t, CodeSystem.ConceptDefinitionComponent c, int level, boolean hasHierarchy, boolean hasDisplay, boolean hasDefinitions, boolean comment, boolean version, boolean deprecated, List<TerminologyRenderer.UsedConceptMap> maps, String system, CodeSystem cs, List<CodeSystem.PropertyComponent> properties, CodeSystemUtilities.CodeSystemNavigator csNav, List<String> langs, boolean isSupplement) throws FHIRFormatError, DefinitionException, IOException {
        XhtmlNode a;
        ArrayList<Translateable> list;
        String link;
        boolean hasExtensions = false;
        XhtmlNode tr = t.tr();
        boolean notCurrent = CodeSystemUtilities.isNotCurrent(cs, c);
        if (notCurrent) {
            tr.setAttribute("style", "background-color: #ffeeee");
        }
        XhtmlNode td = this.renderStatusRow(c, t, tr);
        if (hasHierarchy) {
            td.addText(Integer.toString(level + 1));
            td = tr.td();
            String s = Utilities.padLeft((String)"", (char)'\u00a0', (int)(level * 2));
            td.addText(s);
        }
        String string = link = isSupplement ? this.getLinkForCode(cs.getSupplements(), null, c.getCode()) : null;
        if (link != null) {
            td.ah(this.context.prefixLocalHref(link)).style("white-space:nowrap").addText(c.getCode());
        } else {
            td.style("white-space:nowrap").addText(c.getCode());
        }
        if (c.hasCodeElement()) {
            td.an(this.context.prefixAnchor(cs.getId() + "-" + Utilities.nmtokenize((String)c.getCode())));
        }
        if (hasDisplay) {
            td = tr.td();
            boolean bl = hasExtensions = this.renderDisplayName(c, cs, td, langs) || hasExtensions;
        }
        if (hasDefinitions) {
            td = tr.td();
            if (c != null && c.hasDefinitionElement()) {
                StringType defn = this.context.getTranslatedElement(c.getDefinitionElement());
                boolean sl = false;
                for (CodeSystem.ConceptDefinitionDesignationComponent conceptDefinitionDesignationComponent : c.getDesignation()) {
                    if (!conceptDefinitionDesignationComponent.getUse().is("http://terminology.hl7.org/CodeSystem/designation-usage", "definition") || !conceptDefinitionDesignationComponent.hasLanguage() || c.getDefinition().equalsIgnoreCase(conceptDefinitionDesignationComponent.getValue())) continue;
                    sl = true;
                }
                if (this.getContext().getMultiLanguagePolicy() == RenderingContext.MultiLanguagePolicy.NONE || !sl && !ToolingExtensions.hasLanguageTranslations(defn)) {
                    if (this.hasMarkdownInDefinitions(cs)) {
                        this.addMarkdown(this.renderStatusDiv(defn, td), defn.asStringValue());
                    } else {
                        this.renderStatus(defn, td).addText(defn.asStringValue());
                    }
                } else {
                    list = new ArrayList<Translateable>();
                    list.add(new Translateable(cs.getLanguage(), defn));
                    for (Extension extension : defn.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/translation")) {
                        hasExtensions = true;
                        list.add(new Translateable(extension.getExtensionString("lang"), extension.getExtensionByUrl("content").getValueStringType()));
                    }
                    for (CodeSystem.ConceptDefinitionDesignationComponent conceptDefinitionDesignationComponent : c.getDesignation()) {
                        if (!conceptDefinitionDesignationComponent.getUse().is("http://terminology.hl7.org/CodeSystem/designation-usage", "definition") || !conceptDefinitionDesignationComponent.hasLanguage() || c.getDefinition().equalsIgnoreCase(conceptDefinitionDesignationComponent.getValue())) continue;
                        list.add(new Translateable(conceptDefinitionDesignationComponent.getLanguage(), conceptDefinitionDesignationComponent.getValueElement()));
                    }
                    boolean bl = true;
                    for (Translateable ti : list) {
                        boolean bl2;
                        if (bl2) {
                            bl2 = false;
                        } else {
                            td.br();
                        }
                        if (ti.lang != null) {
                            td.addText(ti.lang + ": ");
                        }
                        if (this.hasMarkdownInDefinitions(cs)) {
                            this.addMarkdown(this.renderStatusDiv(ti.getValue(), td), ti.getValue().asStringValue());
                            continue;
                        }
                        this.renderStatus(ti.getValue(), td).addText(ti.getValue().asStringValue());
                    }
                }
            }
        }
        if (deprecated) {
            td = tr.td();
            Boolean b = CodeSystemUtilities.isDeprecated(cs, c, false);
            if (b != null && b.booleanValue()) {
                this.smartAddText(td, this.formatPhrase("CODESYSTEM_DEPRECATED", new Object[0]));
                hasExtensions = true;
                if (ToolingExtensions.hasExtension(c, "http://hl7.org/fhir/StructureDefinition/codesystem-replacedby")) {
                    Coding cc = (Coding)ToolingExtensions.getExtension(c, "http://hl7.org/fhir/StructureDefinition/codesystem-replacedby").getValue();
                    td.tx(" " + this.context.formatPhrase("CODE_SYS_REPLACED_BY", new Object[0]) + " ");
                    String url = this.getCodingReference(cc, system);
                    if (url != null) {
                        td.ah(this.context.prefixLocalHref(url)).addText(cc.getCode());
                        td.tx(": " + cc.getDisplay() + ")");
                    } else {
                        td.addText(cc.getCode() + " '" + cc.getDisplay() + "' in " + cc.getSystem() + ")");
                    }
                } else {
                    Extension ext = c.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status");
                    if (ext != null && (ext = ext.getValue().getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status-reason")) != null) {
                        this.addMarkdown(td, ext.getValue().primitiveValue());
                    }
                }
            }
        }
        if (comment) {
            td = tr.td();
            Extension ext = c.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/codesystem-concept-comments");
            if (ext != null && ext.hasValue() && ext.getValue().primitiveValue() != null) {
                hasExtensions = true;
                StringType defn = this.context.getTranslatedElement((PrimitiveType)ext.getValue());
                if (this.getContext().getMultiLanguagePolicy() == RenderingContext.MultiLanguagePolicy.NONE || !ToolingExtensions.hasLanguageTranslations(ext.getValue())) {
                    td.addText(defn.asStringValue());
                } else {
                    list = new ArrayList();
                    list.add(new Translateable(cs.getLanguage(), defn));
                    for (Extension extension : defn.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/translation")) {
                        hasExtensions = true;
                        list.add(new Translateable(extension.getExtensionString("lang"), extension.getExtensionByUrl("content").getValueStringType()));
                    }
                    boolean bl = true;
                    for (Translateable ti : list) {
                        boolean bl3;
                        if (bl3) {
                            bl3 = false;
                        } else {
                            td.br();
                        }
                        if (ti.lang != null) {
                            td.addText(ti.lang + ": ");
                        }
                        this.renderStatus(ti.getValue(), td).addText(ti.getValue().asStringValue());
                    }
                }
            }
        }
        if (version) {
            td = tr.td();
            if (c.hasUserData("cs.version.notes")) {
                td.addText(c.getUserString("cs.version.notes"));
            }
        }
        if (properties != null) {
            for (CodeSystem.PropertyComponent pc : properties) {
                td = tr.td();
                boolean first = true;
                List<CodeSystem.ConceptPropertyComponent> list2 = CodeSystemUtilities.getPropertyValues(c, pc.getCode());
                for (CodeSystem.ConceptPropertyComponent pcv : list2) {
                    if (!pcv.hasValue()) continue;
                    if (first) {
                        first = false;
                    } else {
                        td.addText(", ");
                    }
                    if (pcv.hasValueCoding()) {
                        td.addText(pcv.getValueCoding().getCode());
                        continue;
                    }
                    if (pcv.hasValueStringType() && Utilities.isAbsoluteUrl((String)pcv.getValue().primitiveValue())) {
                        CanonicalResource cr = (CanonicalResource)this.context.getContext().fetchResource(Resource.class, pcv.getValue().primitiveValue());
                        if (cr != null) {
                            td.ah(this.context.prefixLocalHref(cr.getWebPath()), cr.getVersionedUrl()).tx(cr.present());
                            continue;
                        }
                        if (Utilities.isAbsoluteUrlLinkable((String)pcv.getValue().primitiveValue())) {
                            td.ah(this.context.prefixLocalHref(pcv.getValue().primitiveValue())).tx(pcv.getValue().primitiveValue());
                            continue;
                        }
                        td.code(pcv.getValue().primitiveValue());
                        continue;
                    }
                    if ("parent".equals(pcv.getCode())) {
                        td.ah(this.context.prefixLocalHref("#" + cs.getId() + "-" + Utilities.nmtokenize((String)pcv.getValue().primitiveValue()))).addText(pcv.getValue().primitiveValue());
                        continue;
                    }
                    td.addText(pcv.getValue().primitiveValue());
                }
            }
        }
        if (langs != null) {
            for (String lang : langs) {
                td = tr.td().tx(this.getDisplay(lang, c));
            }
        }
        for (TerminologyRenderer.UsedConceptMap m : maps) {
            td = tr.td();
            List<TerminologyRenderer.TargetElementComponentWrapper> mappings = this.findMappingsForCode(c.getCode(), m.getMap());
            boolean bl = true;
            for (TerminologyRenderer.TargetElementComponentWrapper mapping : mappings) {
                if (!bl) {
                    td.br();
                }
                bl = false;
                XhtmlNode span = td.span(null, mapping.comp.hasRelationship() ? mapping.comp.getRelationship().toCode() : "");
                span.addText(this.getCharForRelationship(mapping.comp));
                a = td.ah(this.context.prefixLocalHref(this.getContext().getLink(RenderingContext.KnownLinkType.SPEC) + m.getLink() + "#" + this.makeAnchor(mapping.group.getTarget(), mapping.comp.getCode())));
                a.addText(mapping.comp.getCode());
                if (Utilities.noString((String)mapping.comp.getComment())) continue;
                td.i().tx("(" + mapping.comp.getComment() + ")");
            }
        }
        List<CodeSystem.ConceptDefinitionComponent> ocl = csNav.getOtherChildren(c);
        for (CodeSystem.ConceptDefinitionComponent cc : csNav.getConcepts(c)) {
            this.addDefineRowToTable(status, t, cc, level + 1, hasHierarchy, hasDisplay, hasDefinitions, comment, version, deprecated, maps, system, cs, properties, csNav, langs, isSupplement);
        }
        for (CodeSystem.ConceptDefinitionComponent cc : ocl) {
            int n;
            tr = t.tr();
            td = tr.td();
            td.addText(Integer.toString(level + 2));
            td = tr.td();
            String string2 = Utilities.padLeft((String)"", (char)'\u00a0', (int)((level + 1) * 2));
            td.addText(string2);
            td.style("white-space:nowrap");
            a = td.ah(this.context.prefixLocalHref("#" + cs.getId() + "-" + Utilities.nmtokenize((String)cc.getCode())));
            a.addText(cc.getCode());
            if (hasDisplay) {
                td = tr.td();
                hasExtensions = this.renderDisplayName(cc, cs, td, langs) || hasExtensions;
            }
            int n2 = 1 + (deprecated ? 1 : 0) + (comment ? 1 : 0) + (version ? 1 : 0) + maps.size();
            if (properties != null) {
                n = n2 + properties.size();
            }
            td = tr.td().colspan(Integer.toString(n));
        }
        if (this.context.isCopyButton()) {
            td = tr.td();
            this.clipboard(td, "icon_clipboard_x.png", "XML", "<system value=\"" + Utilities.escapeXml((String)cs.getUrl()) + "\">\n" + (String)(cs.getVersionNeeded() ? "<version value=\"" + Utilities.escapeXml((String)cs.getVersion()) + "\">\n" : "") + "<code value=\"" + Utilities.escapeXml((String)c.getCode()) + "\">\n<display value=\"" + Utilities.escapeXml((String)c.getDisplay()) + "\">\n");
            td.nbsp();
            this.clipboard(td, "icon_clipboard_j.png", "JSON", "\"system\" : \"" + Utilities.escapeXml((String)cs.getUrl()) + "\",\n" + (String)(cs.getVersionNeeded() ? "\"version\" : \"" + Utilities.escapeXml((String)cs.getVersion()) + "\",\n" : "") + "\"code\" : \"" + Utilities.escapeXml((String)c.getCode()) + "\",\n\"display\" : \"" + Utilities.escapeXml((String)c.getDisplay()) + "\"\n");
        }
    }

    private String getDisplay(String lang, CodeSystem.ConceptDefinitionComponent c) {
        for (CodeSystem.ConceptDefinitionDesignationComponent cd : c.getDesignation()) {
            if (!cd.getUse().is("http://terminology.hl7.org/CodeSystem/designation-usage", "display") || !cd.hasLanguage() || !cd.getLanguage().equals(lang)) continue;
            return cd.getValue();
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent cd : c.getDesignation()) {
            if (!cd.hasLanguage() || !cd.getLanguage().equals(lang)) continue;
            return cd.getValue();
        }
        return null;
    }

    private boolean hasMarkdownInDefinitions(CodeSystem cs) {
        if (this.doMarkdown == null) {
            this.doMarkdown = cs.hasExtension("http://hl7.org/fhir/StructureDefinition/codesystem-use-markdown") ? Boolean.valueOf(ToolingExtensions.readBoolExtension(cs, "http://hl7.org/fhir/StructureDefinition/codesystem-use-markdown")) : Boolean.valueOf(CodeSystemUtilities.hasMarkdownInDefinitions(cs, this.context.getMarkdown()));
        }
        return this.doMarkdown;
    }

    public boolean renderDisplayName(CodeSystem.ConceptDefinitionComponent c, CodeSystem cs, XhtmlNode td, List<String> langs) {
        boolean hasExtensions = false;
        if (c.hasDisplayElement()) {
            StringType disp = c.getDisplayElement();
            ArrayList<Translateable> list = new ArrayList<Translateable>();
            list.add(new Translateable(cs.getLanguage(), disp));
            for (Extension ext : disp.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/translation")) {
                if (langs.contains(ext.getExtensionString("lang"))) continue;
                hasExtensions = true;
                list.add(new Translateable(ext.getExtensionString("lang"), ext.getExtensionByUrl("content").getValueStringType()));
            }
            for (CodeSystem.ConceptDefinitionDesignationComponent cd : c.getDesignation()) {
                if (!cd.hasLanguage() || langs != null && langs.contains(cd.getLanguage()) || c.getDefinition() != null && c.getDefinition().equalsIgnoreCase(cd.getValue())) continue;
                list.add(new Translateable(cd.getLanguage(), cd.getValueElement()));
            }
            if (this.getContext().getMultiLanguagePolicy() == RenderingContext.MultiLanguagePolicy.NONE || list.size() <= 1) {
                this.renderStatus(disp, td).addText(disp.asStringValue());
            } else {
                boolean first = true;
                for (Translateable ti : list) {
                    if (first) {
                        first = false;
                    } else {
                        td.br();
                    }
                    if (ti.lang != null) {
                        td.addText(ti.lang + ": ");
                    }
                    this.renderStatus(ti.getValue(), td).addText(ti.getValue().asStringValue());
                }
            }
        }
        return hasExtensions;
    }

    private String getCodingReference(Coding cc, String system) {
        if (cc.getSystem().equals(system)) {
            return "#" + cc.getCode();
        }
        if (cc.getSystem().equals("http://snomed.info/sct")) {
            return "http://snomed.info/sct/" + cc.getCode();
        }
        if (cc.getSystem().equals("http://loinc.org")) {
            return LoincLinker.getLinkForCode((String)cc.getCode());
        }
        return null;
    }

    private void addLanguageRow(CodeSystem.ConceptDefinitionComponent c, XhtmlNode t, List<String> langs) {
        XhtmlNode tr = t.tr();
        tr.td().addText(c.getCode());
        for (String lang : langs) {
            CodeSystem.ConceptDefinitionDesignationComponent d = null;
            for (CodeSystem.ConceptDefinitionDesignationComponent designation : c.getDesignation()) {
                if (!designation.hasLanguage() || !lang.equals(designation.getLanguage())) continue;
                d = designation;
            }
            tr.td().addText(d == null ? "" : d.getValue());
        }
    }

    @Override
    protected void genSummaryTableContent(Renderer.RenderingStatus status, XhtmlNode tbl, CanonicalResource cr) throws IOException {
        XhtmlNode tr;
        super.genSummaryTableContent(status, tbl, cr);
        CodeSystem cs = (CodeSystem)cr;
        if (cs.hasContent()) {
            tr = tbl.tr();
            tr.td().tx(this.context.formatPhrase("GENERAL_CONTENT", new Object[0]) + ":");
            XhtmlNode td = tr.td();
            td.tx(cs.getContent().getDisplay() + ": " + this.describeContent(cs.getContent(), cs));
            if (cs.getContent() == Enumerations.CodeSystemContentMode.SUPPLEMENT) {
                td.tx(" ");
                CodeSystem tgt = this.context.getContext().fetchCodeSystem(cs.getSupplements());
                if (tgt != null) {
                    td.ah(tgt.getWebPath()).tx(tgt.present());
                } else {
                    td.code().tx(cs.getSupplements());
                }
            }
        }
        if (CodeSystemUtilities.hasOID(cs)) {
            tr = tbl.tr();
            tr.td().tx(this.context.formatPhrase("GENERAL_OID", new Object[0]) + ":");
            tr.td().tx(this.context.formatPhrase("CODE_SYS_FOR_OID", new Object[]{CodeSystemUtilities.getOID(cs)}));
        }
        if (cs.hasValueSet()) {
            tr = tbl.tr();
            tr.td().tx(this.context.formatPhrase("GENERAL_VALUESET", new Object[0]) + ":");
            ValueSet vs = this.context.getContext().findTxResource(ValueSet.class, cs.getValueSet());
            if (vs == null) {
                tr.td().tx(this.context.formatPhrase("CODE_SYS_THE_VALUE_SET", new Object[]{cs.getValueSet()}) + ")");
            } else {
                tr.td().ah(vs.getWebPath()).tx(this.context.formatPhrase("CODE_SYS_THE_VALUE_SET", new Object[]{cs.getValueSet()}) + ")");
            }
        }
    }

    private String describeContent(Enumerations.CodeSystemContentMode content, CodeSystem cs) {
        switch (content) {
            case COMPLETE: {
                return this.context.formatPhrase("CODE_SYS_COMPLETE", new Object[0]);
            }
            case NOTPRESENT: {
                return this.context.formatPhrase("CODE_SYS_NOTPRESENT", new Object[0]);
            }
            case EXAMPLE: {
                return this.context.formatPhrase("CODE_SYS_EXAMPLE", new Object[0]);
            }
            case FRAGMENT: {
                return this.context.formatPhrase("CODE_SYS_FRAGMENT", new Object[0]);
            }
            case SUPPLEMENT: {
                return this.context.formatPhrase("CODE_SYS_SUPPLEMENT", new Object[0]);
            }
        }
        return "?? illegal content status value " + (content == null ? "(null)" : content.toCode());
    }

    public class Translateable {
        private String lang;
        private StringType value;

        public Translateable(String lang, StringType value) {
            this.lang = lang;
            this.value = value;
        }

        public String getLang() {
            return this.lang;
        }

        public StringType getValue() {
            return this.value;
        }
    }
}

