/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.renderers.Renderer;
import org.hl7.fhir.r5.renderers.TerminologyRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.ResourceWrapper;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class ConceptMapRenderer
extends TerminologyRenderer {
    public ConceptMapRenderer(RenderingContext context) {
        super(context);
    }

    @Override
    public void buildNarrative(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper r) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        if (!r.isDirect()) {
            throw new Error("ConceptMapRenderer only renders native resources directly");
        }
        this.renderResourceTechDetails(r, x);
        this.genSummaryTable(status, x, (ConceptMap)r.getBase());
        this.render(status, r, x, (ConceptMap)r.getBase(), false);
    }

    @Override
    public String buildSummary(ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        return this.canonicalTitle(r);
    }

    public void render(Renderer.RenderingStatus status, ResourceWrapper res, XhtmlNode x, ConceptMap cm, boolean header) throws FHIRFormatError, DefinitionException, IOException {
        if (header) {
            x.h2().addText(cm.getName() + " (" + cm.getUrl() + ")");
        }
        XhtmlNode p = x.para();
        p.tx(this.context.formatPhrase("CONC_MAP_FROM", new Object[0]) + " ");
        if (cm.hasSourceScope()) {
            this.AddVsRef(cm.getSourceScope().primitiveValue(), p, cm);
        } else {
            p.tx(this.context.formatPhrase("CONC_MAP_NOT_SPEC", new Object[0]));
        }
        p.tx(" " + this.context.formatPhrase("CONC_MAP_TO", new Object[0]) + " ");
        if (cm.hasTargetScope()) {
            this.AddVsRef(cm.getTargetScope().primitiveValue(), p, cm);
        } else {
            p.tx(this.context.formatPhrase("CONC_MAP_NOT_SPEC", new Object[0]));
        }
        p = x.para();
        if (cm.getExperimental()) {
            p.addText(Utilities.capitalize((String)cm.getStatus().toString()) + " " + this.context.formatPhrase("CONC_MAP_NO_PROD_USE", new Object[0]) + " ");
        } else {
            p.addText(Utilities.capitalize((String)cm.getStatus().toString()) + ". ");
        }
        p.tx(this.context.formatPhrase("CONC_MAP_PUB_ON", new Object[]{(cm.hasDate() ? this.displayDataType(cm.getDateElement()) : "?ngen-10?") + " by " + cm.getPublisher()}) + " ");
        if (!cm.getContact().isEmpty()) {
            p.tx(" (");
            boolean firsti = true;
            for (ContactDetail ci : cm.getContact()) {
                if (firsti) {
                    firsti = false;
                } else {
                    p.tx(", ");
                }
                if (ci.hasName()) {
                    p.addText(ci.getName() + ": ");
                }
                boolean first = true;
                for (ContactPoint c : ci.getTelecom()) {
                    if (first) {
                        first = false;
                    } else {
                        p.tx(", ");
                    }
                    this.addTelecom(p, this.wrapWC(res, c));
                }
            }
            p.tx(")");
        }
        p.tx(". ");
        p.addText(cm.getCopyright());
        if (!Utilities.noString((String)cm.getDescription())) {
            this.addMarkdown(x, cm.getDescription());
        }
        x.br();
        int gc = 0;
        CodeSystem cs = this.getContext().getWorker().fetchCodeSystem("http://hl7.org/fhir/concept-map-relationship");
        if (cs == null) {
            cs = this.getContext().getWorker().fetchCodeSystem("http://hl7.org/fhir/concept-map-equivalence");
        }
        String eqpath = cs == null ? null : cs.getWebPath();
        for (ConceptMap.ConceptMapGroupComponent grp : cm.getGroup()) {
            String url;
            String display;
            String src = grp.getSource();
            boolean comment = false;
            boolean ok = true;
            HashMap props = new HashMap();
            HashMap sources = new HashMap();
            HashMap targets = new HashMap();
            sources.put("code", new HashSet());
            targets.put("code", new HashSet());
            ((HashSet)sources.get("code")).add(grp.getSource());
            ((HashSet)targets.get("code")).add(grp.getTarget());
            for (ConceptMap.SourceElementComponent ccl : grp.getElement()) {
                ok = ok && (ccl.getNoMap() || ccl.getTarget().size() == 1 && ccl.getTarget().get(0).getDependsOn().isEmpty() && ccl.getTarget().get(0).getProduct().isEmpty());
                for (ConceptMap.TargetElementComponent ccm : ccl.getTarget()) {
                    comment = comment || !Utilities.noString((String)ccm.getComment());
                    for (ConceptMap.MappingPropertyComponent pp : ccm.getProperty()) {
                        if (props.containsKey(pp.getCode())) continue;
                        props.put(pp.getCode(), new HashSet());
                    }
                    for (ConceptMap.OtherElementComponent d : ccm.getDependsOn()) {
                        if (sources.containsKey(d.getAttribute())) continue;
                        sources.put(d.getAttribute(), new HashSet());
                    }
                    for (ConceptMap.OtherElementComponent d : ccm.getProduct()) {
                        if (targets.containsKey(d.getAttribute())) continue;
                        targets.put(d.getAttribute(), new HashSet());
                    }
                }
            }
            if (++gc > 1) {
                x.hr();
            }
            XhtmlNode pp = x.para();
            pp.b().tx(this.context.formatPhrase("CONC_MAP_GRP", new Object[]{gc}) + " ");
            pp.tx(this.context.formatPhrase("CONC_MAP_FROM", new Object[0]) + " ");
            if (grp.hasSource()) {
                this.renderCanonical(status, res, pp, CodeSystem.class, grp.getSourceElement());
            } else {
                pp.code(this.context.formatPhrase("CONC_MAP_CODE_SYS_UNSPEC", new Object[0]));
            }
            pp.tx(" to ");
            if (grp.hasTarget()) {
                this.renderCanonical(status, res, pp, CodeSystem.class, grp.getTargetElement());
            } else {
                pp.code(this.context.formatPhrase("CONC_MAP_CODE_SYS_UNSPEC", new Object[0]));
            }
            if (ok) {
                XhtmlNode tbl = x.table("grid");
                XhtmlNode tr = tbl.tr();
                tr.td().b().tx(this.context.formatPhrase("CONC_MAP_SOURCE", new Object[0]));
                tr.td().b().tx(this.context.formatPhrase("CONC_MAP_REL", new Object[0]));
                tr.td().b().tx(this.context.formatPhrase("CONC_MAP_TRGT", new Object[0]));
                if (comment) {
                    tr.td().b().tx(this.context.formatPhrase("GENERAL_COMMENT", new Object[0]));
                }
                for (ConceptMap.SourceElementComponent ccl : grp.getElement()) {
                    tr = tbl.tr();
                    XhtmlNode td = tr.td();
                    td.addText(ccl.getCode());
                    String string = display = ccl.hasDisplay() ? ccl.getDisplay() : this.getDisplayForConcept(grp.getSource(), ccl.getCode());
                    if (display != null && !this.isSameCodeAndDisplay(ccl.getCode(), display)) {
                        td.tx(" (" + display + ")");
                    }
                    if (ccl.getNoMap()) {
                        tr.td().colspan(comment ? "3" : "2").style("background-color: #efefef").tx("(not mapped)");
                    } else {
                        ConceptMap.TargetElementComponent ccm = ccl.getTarget().get(0);
                        if (!ccm.hasRelationship()) {
                            tr.td().tx(":(" + Enumerations.ConceptMapRelationship.EQUIVALENT.toCode() + ")");
                        } else if (ccm.hasExtension("http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence")) {
                            String code = ToolingExtensions.readStringExtension((Element)ccm, "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence");
                            tr.td().ah(this.context.prefixLocalHref(eqpath + "#" + code), code).tx(this.presentEquivalenceCode(code));
                        } else {
                            tr.td().ah(this.context.prefixLocalHref(eqpath + "#" + ccm.getRelationship().toCode()), ccm.getRelationship().toCode()).tx(this.presentRelationshipCode(ccm.getRelationship().toCode()));
                        }
                        td = tr.td();
                        td.addText(ccm.getCode());
                        String string2 = display = ccm.hasDisplay() ? ccm.getDisplay() : this.getDisplayForConcept(grp.getTarget(), ccm.getCode());
                        if (display != null && !this.isSameCodeAndDisplay(ccm.getCode(), display)) {
                            td.tx(" (" + display + ")");
                        }
                        if (comment) {
                            tr.td().addText(ccm.getComment());
                        }
                    }
                    this.addUnmapped(tbl, grp);
                }
                continue;
            }
            boolean hasRelationships = false;
            for (int si = 0; si < grp.getElement().size(); ++si) {
                ConceptMap.SourceElementComponent ccl = grp.getElement().get(si);
                for (int ti = 0; ti < ccl.getTarget().size(); ++ti) {
                    ConceptMap.TargetElementComponent ccm = ccl.getTarget().get(ti);
                    if (!ccm.hasRelationship()) continue;
                    hasRelationships = true;
                }
            }
            XhtmlNode tbl = x.table("grid");
            XhtmlNode tr = tbl.tr();
            tr.td().colspan(Integer.toString(1 + sources.size())).b().tx(this.context.formatPhrase("CONC_MAP_SRC_DET", new Object[0]));
            if (hasRelationships) {
                tr.td().b().tx(this.context.formatPhrase("CONC_MAP_REL", new Object[0]));
            }
            tr.td().colspan(Integer.toString(1 + targets.size())).b().tx(this.context.formatPhrase("CONC_MAP_TRGT_DET", new Object[0]));
            if (comment) {
                tr.td().b().tx(this.context.formatPhrase("GENERAL_COMMENT", new Object[0]));
            }
            tr.td().colspan(Integer.toString(1 + targets.size())).b().tx(this.context.formatPhrase("GENERAL_PROPS", new Object[0]));
            tr = tbl.tr();
            if (((HashSet)sources.get("code")).size() == 1) {
                String url2 = (String)((HashSet)sources.get("code")).iterator().next();
                this.renderCSDetailsLink(tr, url2, true);
            } else {
                tr.td().b().tx(this.context.formatPhrase("GENERAL_CODE", new Object[0]));
            }
            for (String s : sources.keySet()) {
                if (s == null || s.equals("code")) continue;
                if (((HashSet)sources.get(s)).size() == 1) {
                    url = (String)((HashSet)sources.get(s)).iterator().next();
                    this.renderCSDetailsLink(tr, url, false);
                    continue;
                }
                tr.td().b().addText(this.getDescForConcept(s));
            }
            if (hasRelationships) {
                tr.td();
            }
            if (((HashSet)targets.get("code")).size() == 1) {
                Iterator url2 = (String)((HashSet)targets.get("code")).iterator().next();
                this.renderCSDetailsLink(tr, (String)((Object)url2), true);
            } else {
                tr.td().b().tx(this.context.formatPhrase("GENERAL_CODE", new Object[0]));
            }
            for (String s : targets.keySet()) {
                if (s == null || s.equals("code")) continue;
                if (((HashSet)targets.get(s)).size() == 1) {
                    url = (String)((HashSet)targets.get(s)).iterator().next();
                    this.renderCSDetailsLink(tr, url, false);
                    continue;
                }
                tr.td().b().addText(this.getDescForConcept(s));
            }
            if (comment) {
                tr.td();
            }
            for (String s : props.keySet()) {
                if (s == null) continue;
                if (((HashSet)props.get(s)).size() == 1) {
                    url = (String)((HashSet)props.get(s)).iterator().next();
                    this.renderCSDetailsLink(tr, url, false);
                    continue;
                }
                tr.td().b().addText(this.getDescForConcept(s));
            }
            for (int si = 0; si < grp.getElement().size(); ++si) {
                XhtmlNode td;
                ConceptMap.SourceElementComponent ccl = grp.getElement().get(si);
                boolean slast = si == grp.getElement().size() - 1;
                boolean first = true;
                if (ccl.hasNoMap() && ccl.getNoMap()) {
                    tr = tbl.tr();
                    td = tr.td().style("border-right-width: 0px");
                    if (!first) {
                        td.style("border-top-style: none");
                    } else {
                        td.style("border-bottom-style: none");
                    }
                    if (((HashSet)sources.get("code")).size() == 1) {
                        td.addText(ccl.getCode());
                    } else {
                        td.addText(grp.getSource() + " / " + ccl.getCode());
                    }
                    display = ccl.hasDisplay() ? ccl.getDisplay() : this.getDisplayForConcept(grp.getSource(), ccl.getCode());
                    tr.td().style("border-left-width: 0px").tx(display == null ? "" : display);
                    tr.td().colspan("4").style("background-color: #efefef").tx("(not mapped)");
                } else {
                    for (int ti = 0; ti < ccl.getTarget().size(); ++ti) {
                        ConceptMap.TargetElementComponent ccm = ccl.getTarget().get(ti);
                        boolean last = ti == ccl.getTarget().size() - 1;
                        tr = tbl.tr();
                        td = tr.td().style("border-right-width: 0px");
                        if (!first && !last) {
                            td.style("border-top-style: none; border-bottom-style: none");
                        } else if (!first) {
                            td.style("border-top-style: none");
                        } else if (!last) {
                            td.style("border-bottom-style: none");
                        }
                        if (first) {
                            if (((HashSet)sources.get("code")).size() == 1) {
                                td.addText(ccl.getCode());
                            } else {
                                td.addText(grp.getSource() + " / " + ccl.getCode());
                            }
                            display = ccl.hasDisplay() ? ccl.getDisplay() : this.getDisplayForConcept(grp.getSource(), ccl.getCode());
                            td = tr.td();
                            if (!last) {
                                td.style("border-left-width: 0px; border-bottom-style: none");
                            } else {
                                td.style("border-left-width: 0px");
                            }
                            td.tx(display == null ? "" : display);
                        } else {
                            td = tr.td();
                            if (!last) {
                                td.style("border-left-width: 0px; border-top-style: none; border-bottom-style: none");
                            } else {
                                td.style("border-top-style: none; border-left-width: 0px");
                            }
                        }
                        for (String s : sources.keySet()) {
                            if (s == null || s.equals("code")) continue;
                            td = tr.td();
                            if (!first) continue;
                            td.addText(this.getValue(ccm.getDependsOn(), s, ((HashSet)sources.get(s)).size() != 1));
                            display = this.getDisplay(ccm.getDependsOn(), s);
                            if (display == null) continue;
                            td.tx(" (" + display + ")");
                        }
                        first = false;
                        if (hasRelationships) {
                            if (!ccm.hasRelationship()) {
                                tr.td();
                            } else if (ccm.getRelationshipElement().hasExtension("http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence")) {
                                String code = ToolingExtensions.readStringExtension(ccm.getRelationshipElement(), "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence");
                                tr.td().ah(this.context.prefixLocalHref(eqpath + "#" + code), code).tx(this.presentEquivalenceCode(code));
                            } else {
                                tr.td().ah(this.context.prefixLocalHref(eqpath + "#" + ccm.getRelationship().toCode()), ccm.getRelationship().toCode()).tx(this.presentRelationshipCode(ccm.getRelationship().toCode()));
                            }
                        }
                        td = tr.td().style("border-right-width: 0px");
                        if (((HashSet)targets.get("code")).size() == 1) {
                            td.addText(ccm.getCode());
                        } else {
                            td.addText(grp.getTarget() + " / " + ccm.getCode());
                        }
                        display = ccm.hasDisplay() ? ccm.getDisplay() : this.getDisplayForConcept(grp.getSource(), ccm.getCode());
                        tr.td().style("border-left-width: 0px").tx(display == null ? "" : display);
                        for (String s : targets.keySet()) {
                            if (s == null || s.equals("code")) continue;
                            td = tr.td();
                            td.addText(this.getValue(ccm.getProduct(), s, ((HashSet)targets.get(s)).size() != 1));
                            display = this.getDisplay(ccm.getProduct(), s);
                            if (display == null) continue;
                            td.tx(" (" + display + ")");
                        }
                        if (comment) {
                            tr.td().addText(ccm.getComment());
                        }
                        for (String s : props.keySet()) {
                            if (s == null) continue;
                            td = tr.td();
                            td.addText(this.getValue(ccm.getProperty(), s));
                        }
                    }
                }
                this.addUnmapped(tbl, grp);
            }
        }
    }

    public void describe(XhtmlNode x, ConceptMap cm) {
        x.tx(this.display(cm));
    }

    public String display(ConceptMap cm) {
        return cm.present();
    }

    private boolean isSameCodeAndDisplay(String code, String display) {
        String c = code.replace(" ", "").replace("-", "").toLowerCase();
        String d = display.replace(" ", "").replace("-", "").toLowerCase();
        return c.equals(d);
    }

    private String presentRelationshipCode(String code) {
        if ("related-to".equals(code)) {
            return "is related to";
        }
        if ("equivalent".equals(code)) {
            return "is equivalent to";
        }
        if ("source-is-narrower-than-target".equals(code)) {
            return "is narrower than";
        }
        if ("source-is-broader-than-target".equals(code)) {
            return "is broader than";
        }
        if ("not-related-to".equals(code)) {
            return "is not related to";
        }
        return code;
    }

    private String presentEquivalenceCode(String code) {
        if ("relatedto".equals(code)) {
            return "is related to";
        }
        if ("equivalent".equals(code)) {
            return "is equivalent to";
        }
        if ("equal".equals(code)) {
            return "is equal to";
        }
        if ("wider".equals(code)) {
            return "maps to wider concept";
        }
        if ("subsumes".equals(code)) {
            return "is subsumed by";
        }
        if ("source-is-broader-than-target".equals(code)) {
            return "maps to narrower concept";
        }
        if ("specializes".equals(code)) {
            return "has specialization";
        }
        if ("inexact".equals(code)) {
            return "maps loosely to";
        }
        if ("unmatched".equals(code)) {
            return "has no match";
        }
        if ("disjoint".equals(code)) {
            return "is not related to";
        }
        return code;
    }

    public void renderCSDetailsLink(XhtmlNode tr, String url, boolean span2) {
        CodeSystem cs = this.getContext().getWorker().fetchCodeSystem(url);
        XhtmlNode td = tr.td();
        if (span2) {
            td.colspan("2");
        }
        td.b().tx(this.context.formatPhrase("CONC_MAP_CODES", new Object[0]));
        td.tx(" " + this.context.formatPhrase("CONC_MAP_FRM", new Object[0]) + " ");
        if (cs == null) {
            td.tx(url);
        } else {
            td.ah(this.context.prefixLocalHref(this.context.fixReference(cs.getWebPath()))).attribute("title", url).tx(cs.present());
        }
    }

    private void addUnmapped(XhtmlNode tbl, ConceptMap.ConceptMapGroupComponent grp) {
        if (grp.hasUnmapped()) {
            // empty if block
        }
    }

    private String getDescForConcept(String s) {
        if (s.startsWith("http://hl7.org/fhir/v2/element/")) {
            return "v2 " + s.substring("http://hl7.org/fhir/v2/element/".length());
        }
        return s;
    }

    private String getValue(List<ConceptMap.MappingPropertyComponent> list, String s) {
        return "todo";
    }

    private String getValue(List<ConceptMap.OtherElementComponent> list, String s, boolean withSystem) {
        for (ConceptMap.OtherElementComponent c : list) {
            if (!s.equals(c.getAttribute())) continue;
            if (withSystem) {
                return c.getValue().primitiveValue();
            }
            return c.getValue().primitiveValue();
        }
        return null;
    }

    private String getDisplay(List<ConceptMap.OtherElementComponent> list, String s) {
        for (ConceptMap.OtherElementComponent c : list) {
            if (!s.equals(c.getAttribute())) continue;
        }
        return null;
    }

    public static XhtmlNode renderMultipleMaps(String start, List<ConceptMap> maps, IMultiMapRendererAdvisor advisor, Object rmmContext) {
        ArrayList<MultipleMappingRow> rowSets = new ArrayList<MultipleMappingRow>();
        for (int i = 0; i < maps.size(); ++i) {
            ConceptMapRenderer.populateRows(rowSets, maps.get(i), i, advisor, rmmContext);
        }
        ConceptMapRenderer.collateRows(rowSets);
        if (advisor.sortPolicy(rmmContext) != RenderMultiRowSortPolicy.UNSORTED) {
            Collections.sort(rowSets, new MultipleMappingRowSorter(advisor.sortPolicy(rmmContext) == RenderMultiRowSortPolicy.FIRST_COL));
        }
        XhtmlNode div = new XhtmlNode(NodeType.Element, "div");
        XhtmlNode tbl = div.table("none").style("text-align: left; border-spacing: 0; padding: 5px");
        XhtmlNode tr = tbl.tr();
        ConceptMapRenderer.styleCell(tr.td(), false, true, 5).b().tx(start);
        for (ConceptMap map : maps) {
            XhtmlNode td;
            if (advisor.describeMap(rmmContext, map, td = ConceptMapRenderer.styleCell(tr.td(), false, true, 5).colspan(2))) continue;
            if (map.hasWebPath() && advisor.makeMapLinks()) {
                td.b().ah(map.getWebPath(), map.getVersionedUrl()).tx(map.present());
                continue;
            }
            td.b().tx(map.present());
        }
        if (advisor.hasCollateral(rmmContext)) {
            tr = tbl.tr();
            ConceptMapRenderer.renderLinks(ConceptMapRenderer.styleCell(tr.td(), false, true, 5), advisor.getCollateral(rmmContext, null));
            for (ConceptMap map : maps) {
                ConceptMapRenderer.renderLinks(ConceptMapRenderer.styleCell(tr.td(), false, true, 5).colspan(2), advisor.getCollateral(rmmContext, map.getUrl()));
            }
        }
        for (MultipleMappingRow row : rowSets) {
            ConceptMapRenderer.renderMultiRow(tbl, row, maps, advisor, rmmContext);
        }
        return div;
    }

    private static void renderLinks(XhtmlNode td, List<CollateralDefinition> collateral) {
        if (collateral.size() > 0) {
            td.tx("Links:");
            td.tx(" ");
            boolean first = true;
            for (CollateralDefinition c : collateral) {
                if (first) {
                    first = false;
                } else {
                    td.tx(", ");
                }
                td.ah(c.getResource().getWebPath()).tx(c.getLabel());
            }
        }
    }

    private static void collateRows(List<MultipleMappingRow> rowSets) {
        ArrayList<MultipleMappingRow> toDelete = new ArrayList<MultipleMappingRow>();
        for (MultipleMappingRow rowSet : rowSets) {
            MultipleMappingRow tgt = rowSet.stickySource;
            while (toDelete.contains(tgt)) {
                tgt = tgt.stickySource;
            }
            if (tgt == null || !rowSets.contains(tgt)) continue;
            tgt.rowSets.addAll(rowSet.rowSets);
            toDelete.add(rowSet);
        }
        rowSets.removeAll(toDelete);
    }

    private static void renderMultiRow(XhtmlNode tbl, MultipleMappingRow rows, List<ConceptMap> maps, IMultiMapRendererAdvisor advisor, Object rmmContext) {
        int rowCounter = 0;
        for (MultipleMappingRowItem row : rows.rowSets) {
            XhtmlNode tr = tbl.tr();
            boolean first = true;
            int cellCounter = 0;
            Cell last = null;
            for (Cell cell : row.cells) {
                XhtmlNode x;
                int c;
                if (first) {
                    if (!cell.renderedCode) {
                        c = 1;
                        for (int i = rowCounter + 1; i < rows.rowSets.size() && cell.code != null && rows.rowSets.get((int)i).cells.size() > cellCounter && cell.code.equals(rows.rowSets.get((int)i).cells.get((int)cellCounter).code); ++i) {
                            rows.rowSets.get((int)i).cells.get((int)cellCounter).renderedCode = true;
                            ++c;
                        }
                        if (cell.code == null) {
                            ConceptMapRenderer.styleCell(tr.td(), rowCounter == 0, true, 5).rowspan(c).style("background-color: #eeeeee");
                        } else {
                            String link = advisor.getLink(rmmContext, cell.system, cell.code);
                            x = null;
                            x = link != null ? ConceptMapRenderer.styleCell(tr.td(), rowCounter == 0, true, 5).attributeNN("title", cell.display).rowspan(c).ah(link) : ConceptMapRenderer.styleCell(tr.td(), rowCounter == 0, true, 5).attributeNN("title", cell.display).rowspan(c);
                            x.tx(cell.present());
                        }
                    }
                    first = false;
                } else {
                    if (!cell.renderedRel) {
                        c = 1;
                        for (int i = rowCounter + 1; i < rows.rowSets.size() && cell.relationship != null && rows.rowSets.get((int)i).cells.size() > cellCounter && cell.relationship.equals(rows.rowSets.get((int)i).cells.get((int)cellCounter).relationship) && cell.code != null && cell.code.equals(rows.rowSets.get((int)i).cells.get((int)cellCounter).code) && last.code != null && cell.code.equals(rows.rowSets.get((int)i).cells.get((int)(cellCounter - 1)).code); ++i) {
                            rows.rowSets.get((int)i).cells.get((int)cellCounter).renderedRel = true;
                            ++c;
                        }
                        if (last.code == null || cell.code == null) {
                            ConceptMapRenderer.styleCell(tr.td(), rowCounter == 0, true, 5).style("background-color: #eeeeee");
                        } else if (cell.relationship != null) {
                            ConceptMapRenderer.styleCell(tr.tdW(16), rowCounter == 0, true, 0).attributeNN("title", cell.relComment).rowspan(c).style("background-color: LightGrey; text-align: center; vertical-align: middle; color: white").tx(cell.relationship);
                        } else {
                            ConceptMapRenderer.styleCell(tr.tdW(16), rowCounter == 0, false, 0).rowspan(c);
                        }
                    }
                    if (!cell.renderedCode) {
                        c = 1;
                        for (int i = rowCounter + 1; i < rows.rowSets.size() && cell.code != null && rows.rowSets.get((int)i).cells.size() > cellCounter && cell.code.equals(rows.rowSets.get((int)i).cells.get((int)cellCounter).code); ++i) {
                            rows.rowSets.get((int)i).cells.get((int)cellCounter).renderedCode = true;
                            ++c;
                        }
                        if (cell.code == null) {
                            ConceptMapRenderer.styleCell(tr.td(), rowCounter == 0, true, 5).rowspan(c).style("background-color: #eeeeee");
                        } else {
                            String link = advisor.getLink(rmmContext, cell.system, cell.code);
                            x = null;
                            x = link != null ? ConceptMapRenderer.styleCell(tr.td(), rowCounter == 0, true, 5).attributeNN("title", cell.display).rowspan(c).ah(link) : ConceptMapRenderer.styleCell(tr.td(), rowCounter == 0, true, 5).attributeNN("title", cell.display).rowspan(c);
                            x.tx(cell.present());
                        }
                    }
                }
                last = cell;
                ++cellCounter;
            }
            ++rowCounter;
        }
    }

    private static XhtmlNode styleCell(XhtmlNode td, boolean firstrow, boolean sides, int padding) {
        if (firstrow) {
            td.style("vertical-align: middle; border-top: 1px solid black; padding: " + padding + "px");
        } else {
            td.style("vertical-align: middle; border-top: 1px solid LightGrey; padding: " + padding + "px");
        }
        if (sides) {
            td.style("border-left: 1px solid LightGrey; border-right: 2px solid LightGrey");
        }
        return td;
    }

    private static void populateRows(List<MultipleMappingRow> rowSets, ConceptMap map, int i, IMultiMapRendererAdvisor advisor, Object rmmContext) {
        Iterator iterator;
        Object codings;
        if (map.hasSourceScope() && (codings = advisor.getMembers(rmmContext, map.getSourceScope().primitiveValue())) != null) {
            iterator = codings.iterator();
            while (iterator.hasNext()) {
                Coding c = (Coding)iterator.next();
                MultipleMappingRow multipleMappingRow = i == 0 ? null : ConceptMapRenderer.findExistingRowBySource(rowSets, c.getSystem(), c.getCode(), i);
                if (multipleMappingRow != null) continue;
                MultipleMappingRow multipleMappingRow2 = new MultipleMappingRow(i, c.getSystem(), c.getCode(), c.getDisplay());
                rowSets.add(multipleMappingRow2);
            }
        }
        for (ConceptMap.ConceptMapGroupComponent grp : map.getGroup()) {
            for (ConceptMap.SourceElementComponent sourceElementComponent : grp.getElement()) {
                MultipleMappingRow trow;
                MultipleMappingRow row2 = ConceptMapRenderer.findExistingRowBySource(rowSets, grp.getSource(), sourceElementComponent.getCode(), i);
                if (row2 == null) {
                    row2 = new MultipleMappingRow(i, grp.getSource(), sourceElementComponent.getCode(), sourceElementComponent.getDisplay());
                    rowSets.add(row2);
                }
                if (sourceElementComponent.getNoMap()) {
                    row2.addTerminus();
                    continue;
                }
                ArrayList<ConceptMap.TargetElementComponent> todo = new ArrayList<ConceptMap.TargetElementComponent>();
                for (ConceptMap.TargetElementComponent tgt : sourceElementComponent.getTarget()) {
                    trow = ConceptMapRenderer.findExistingRowByTarget(rowSets, grp.getTarget(), tgt.getCode(), i);
                    if (trow == null) {
                        row2.addTarget(grp.getTarget(), tgt.getCode(), tgt.getRelationship(), tgt.getComment(), rowSets, i);
                        continue;
                    }
                    todo.add(tgt);
                }
                for (ConceptMap.TargetElementComponent t : todo) {
                    trow = ConceptMapRenderer.findExistingRowByTarget(rowSets, grp.getTarget(), t.getCode(), i);
                    if (row2.alreadyHasMappings(i)) {
                        trow.cloneSource(i, row2.getLastSource(i));
                        continue;
                    }
                    trow.addSource(row2, rowSets, t.getRelationship(), t.getComment());
                }
            }
            boolean copy = grp.hasUnmapped() && grp.getUnmapped().getMode() == ConceptMap.ConceptMapGroupUnmappedMode.USESOURCECODE;
            if (!copy) continue;
            for (MultipleMappingRow row : rowSets) {
                if (row.rowSets.get((int)0).cells.size() != i || !row.lastSystem().equals(grp.getSource())) continue;
                row.addCopy(grp.getTarget());
            }
        }
        codings = rowSets.iterator();
        while (codings.hasNext()) {
            MultipleMappingRow row3 = codings.next();
            if (row3.rowSets.get((int)0).cells.size() != i) continue;
            row3.addTerminus();
        }
        if (map.hasTargetScope() && (codings = advisor.getMembers(rmmContext, map.getTargetScope().primitiveValue())) != null) {
            iterator = codings.iterator();
            while (iterator.hasNext()) {
                Coding c = (Coding)iterator.next();
                MultipleMappingRow multipleMappingRow = ConceptMapRenderer.findExistingRowByTarget(rowSets, c.getSystem(), c.getCode(), i);
                if (multipleMappingRow == null) {
                    MultipleMappingRow multipleMappingRow3 = new MultipleMappingRow(i + 1, c.getSystem(), c.getCode(), c.getDisplay());
                    rowSets.add(multipleMappingRow3);
                    continue;
                }
                for (MultipleMappingRowItem cells : multipleMappingRow.rowSets) {
                    Cell last = cells.cells.get(cells.cells.size() - 1);
                    if (last.system == null || !last.system.equals(c.getSystem()) || !last.code.equals(c.getCode()) || last.display != null) continue;
                    last.display = c.getDisplay();
                }
            }
        }
    }

    private static MultipleMappingRow findExistingRowByTarget(List<MultipleMappingRow> rows, String system, String code, int i) {
        for (MultipleMappingRow row : rows) {
            for (MultipleMappingRowItem cells : row.rowSets) {
                if (cells.cells.size() <= i + 1 || !cells.cells.get(i + 1).matches(system, code)) continue;
                return row;
            }
        }
        return null;
    }

    private static MultipleMappingRow findExistingRowBySource(List<MultipleMappingRow> rows, String system, String code, int i) {
        for (MultipleMappingRow row : rows) {
            for (MultipleMappingRowItem cells : row.rowSets) {
                if (cells.cells.size() <= i || !cells.cells.get(i).matches(system, code)) continue;
                return row;
            }
        }
        return null;
    }

    public static class MultipleMappingRow {
        private List<MultipleMappingRowItem> rowSets = new ArrayList<MultipleMappingRowItem>();
        private MultipleMappingRow stickySource;

        public MultipleMappingRow(int i, String system, String code, String display) {
            MultipleMappingRowItem row = new MultipleMappingRowItem();
            this.rowSets.add(row);
            for (int c = 0; c < i; ++c) {
                row.cells.add(new Cell());
            }
            row.cells.add(new Cell(system, code, display));
        }

        public MultipleMappingRow(MultipleMappingRow stickySource) {
            this.stickySource = stickySource;
        }

        public String toString() {
            CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
            for (MultipleMappingRowItem rowSet : this.rowSets) {
                b.append("" + rowSet.cells.size());
            }
            CommaSeparatedStringBuilder b2 = new CommaSeparatedStringBuilder(";");
            for (MultipleMappingRowItem rowSet : this.rowSets) {
                b2.append(rowSet.toString());
            }
            return this.rowSets.size() + " [" + b.toString() + "] (" + b2.toString() + ")";
        }

        public String lastCode() {
            MultipleMappingRowItem first = this.rowSets.get(0);
            for (int i = first.cells.size() - 1; i >= 0; --i) {
                if (first.cells.get((int)i).code == null) continue;
                return first.cells.get((int)i).code;
            }
            return "";
        }

        public String firstCode() {
            MultipleMappingRowItem first = this.rowSets.get(0);
            for (int i = 0; i < first.cells.size(); ++i) {
                if (first.cells.get((int)i).code == null) continue;
                return first.cells.get((int)i).code;
            }
            return "";
        }

        public void addSource(MultipleMappingRow sourceRow, List<MultipleMappingRow> rowList, Enumerations.ConceptMapRelationship relationship, String comment) {
            assert (sourceRow.rowSets.get((int)0).cells.size() == this.rowSets.get((int)0).cells.size() - 1);
            rowList.remove(sourceRow);
            Cell template = this.rowSets.get((int)0).cells.get(this.rowSets.get((int)0).cells.size() - 1);
            for (MultipleMappingRowItem row : sourceRow.rowSets) {
                row.cells.add(new Cell(template.system, template.code, relationship.getSymbol(), comment));
            }
            this.rowSets.addAll(sourceRow.rowSets);
        }

        public void addTerminus() {
            for (MultipleMappingRowItem row : this.rowSets) {
                row.cells.add(new Cell(null, null, "X", null));
            }
        }

        public void addTarget(String system, String code, Enumerations.ConceptMapRelationship relationship, String comment, List<MultipleMappingRow> sets, int colCount) {
            if (this.rowSets.get((int)0).cells.size() == colCount + 1) {
                for (MultipleMappingRowItem row : this.rowSets) {
                    row.cells.add(new Cell(system, code, relationship.getSymbol(), comment));
                }
            } else {
                MultipleMappingRow nrow = new MultipleMappingRow(this);
                for (MultipleMappingRowItem row : this.rowSets) {
                    MultipleMappingRowItem n = new MultipleMappingRowItem();
                    for (int i = 0; i < row.cells.size() - 1; ++i) {
                        n.cells.add(row.cells.get(i).copy(true));
                    }
                    n.cells.add(new Cell(system, code, relationship.getSymbol(), comment));
                    nrow.rowSets.add(n);
                }
                sets.add(sets.indexOf(this), nrow);
            }
        }

        public String lastSystem() {
            MultipleMappingRowItem first = this.rowSets.get(0);
            for (int i = first.cells.size() - 1; i >= 0; --i) {
                if (first.cells.get((int)i).system == null) continue;
                return first.cells.get((int)i).system;
            }
            return "";
        }

        public void addCopy(String system) {
            for (MultipleMappingRowItem row : this.rowSets) {
                row.cells.add(new Cell(system, this.lastCode(), "=", null));
            }
        }

        public boolean alreadyHasMappings(int i) {
            for (MultipleMappingRowItem row : this.rowSets) {
                if (row.cells.size() <= i + 1) continue;
                return true;
            }
            return false;
        }

        public Cell getLastSource(int i) {
            Iterator<MultipleMappingRowItem> iterator = this.rowSets.iterator();
            if (iterator.hasNext()) {
                MultipleMappingRowItem row = iterator.next();
                return row.cells.get(i + 1);
            }
            throw new Error("Should not get here");
        }

        public void cloneSource(int i, Cell cell) {
            MultipleMappingRowItem row = new MultipleMappingRowItem();
            this.rowSets.add(row);
            for (int c = 0; c < i - 1; ++c) {
                row.cells.add(new Cell());
            }
            row.cells.add(cell.copy(true));
            row.cells.add(this.rowSets.get((int)0).cells.get(this.rowSets.get((int)0).cells.size() - 1).copy(false));
        }
    }

    public static class MultipleMappingRowItem {
        List<Cell> cells = new ArrayList<Cell>();

        public String toString() {
            CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
            for (Cell cell : this.cells) {
                if (cell.relationship != null) {
                    b.append(cell.relationship + cell.code);
                    continue;
                }
                b.append(cell.code);
            }
            return b.toString();
        }
    }

    public static class Cell {
        private String system;
        private String code;
        private String display;
        private String relationship;
        private String relComment;
        public boolean renderedRel;
        public boolean renderedCode;
        private Cell clone;

        protected Cell() {
        }

        public Cell(String system, String code, String display) {
            this.system = system;
            this.code = code;
            this.display = display;
        }

        public Cell(String system, String code, String relationship, String comment) {
            this.system = system;
            this.code = code;
            this.relationship = relationship;
            this.relComment = comment;
        }

        public boolean matches(String system, String code) {
            return system != null && system.equals(this.system) && code != null && code.equals(this.code);
        }

        public String present() {
            if (this.system == null) {
                return this.code;
            }
            return this.code;
        }

        public Cell copy(boolean clone) {
            Cell res = new Cell();
            res.system = this.system;
            res.code = this.code;
            res.display = this.display;
            res.relationship = this.relationship;
            res.relComment = this.relComment;
            res.renderedRel = this.renderedRel;
            res.renderedCode = this.renderedCode;
            if (clone) {
                res.clone = this;
            }
            return res;
        }

        public String toString() {
            return this.relationship + " " + this.system + "#" + this.code + " \"" + this.display + "\"";
        }
    }

    public static class MultipleMappingRowSorter
    implements Comparator<MultipleMappingRow> {
        private boolean first;

        protected MultipleMappingRowSorter(boolean first) {
            this.first = first;
        }

        @Override
        public int compare(MultipleMappingRow o1, MultipleMappingRow o2) {
            String s1 = this.first ? o1.firstCode() : o1.lastCode();
            String s2 = this.first ? o2.firstCode() : o2.lastCode();
            return s1.compareTo(s2);
        }
    }

    public static interface IMultiMapRendererAdvisor {
        public RenderMultiRowSortPolicy sortPolicy(Object var1);

        public List<Coding> getMembers(Object var1, String var2);

        public boolean describeMap(Object var1, ConceptMap var2, XhtmlNode var3);

        public boolean hasCollateral(Object var1);

        public List<CollateralDefinition> getCollateral(Object var1, String var2);

        public String getLink(Object var1, String var2, String var3);

        public boolean makeMapLinks();
    }

    public static enum RenderMultiRowSortPolicy {
        UNSORTED,
        FIRST_COL,
        LAST_COL;

    }

    public static class CollateralDefinition {
        private Resource resource;
        private String label;

        public CollateralDefinition(Resource resource, String label) {
            this.resource = resource;
            this.label = label;
        }

        public Resource getResource() {
            return this.resource;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

