/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.renderers.PatientRenderer;
import org.hl7.fhir.r5.renderers.Renderer;
import org.hl7.fhir.r5.renderers.RendererFactory;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.Resolver;
import org.hl7.fhir.r5.renderers.utils.ResourceWrapper;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class DiagnosticReportRenderer
extends ResourceRenderer {
    public DiagnosticReportRenderer(RenderingContext context) {
        super(context);
    }

    @Override
    public void buildNarrative(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper dr) throws IOException, FHIRException, EOperationOutcome {
        this.renderDiagnosticReport(status, x, dr);
    }

    public void renderDiagnosticReport(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper dr) throws IOException, FHIRException, EOperationOutcome {
        XhtmlNode tr;
        this.renderResourceTechDetails(dr, x);
        XhtmlNode h2 = x.h2();
        this.renderDataType(status, h2, dr.child("code"));
        h2.tx(" ");
        List<ResourceWrapper> cats = dr.children("category");
        if (!cats.isEmpty()) {
            h2.tx("(");
            boolean first = true;
            for (ResourceWrapper b : cats) {
                if (first) {
                    first = false;
                } else {
                    h2.tx(", ");
                }
                this.renderDataType(status, h2, b);
            }
            h2.tx(") ");
        }
        XhtmlNode tbl = x.table("grid");
        if (dr.has("subject")) {
            tr = tbl.tr();
            tr.td().tx(this.context.formatPhrase("GENERAL_SUBJ", new Object[0]));
            this.populateSubjectSummary(status, tr.td(), dr.child("subject"));
        }
        ResourceWrapper eff = null;
        ResourceWrapper iss = null;
        if (dr.has("effective[x]")) {
            tr = tbl.tr();
            tr.td().tx(this.context.formatPhrase("DIAG_REP_REND_WHEN", new Object[0]));
            eff = dr.child("effective[x]");
            this.renderDataType(status, tr.td(), eff);
        }
        if (dr.has("issued")) {
            tr = tbl.tr();
            tr.td().tx(this.context.formatPhrase("DIAG_REP_REND_REP", new Object[0]));
            iss = dr.child("issued");
            this.renderDataType(status, tr.td(), iss);
        }
        this.addTableRow(status, tbl, dr, "DIAG_REP_REND_PER", "performer");
        this.addTableRow(status, tbl, dr, "DIAG_REP_REND_IDENTIFIER", "identifier");
        this.addTableRow(status, tbl, dr, "GENERAL_REQUEST", "request");
        x.para().b().tx(this.context.formatPhrase("DIAG_REP_REND_REPDET", new Object[0]));
        List<ResourceWrapper> items = dr.children("result");
        if (!items.isEmpty()) {
            List<ObservationNode> observations = this.fetchObservations(items);
            this.buildObservationsTable(status, x, observations, eff, iss);
        }
        if (dr.has("conclusion")) {
            ResourceWrapper conc = dr.child("conclusion");
            if (conc.fhirType().equals("markdown")) {
                this.renderDataType(status, x, conc);
            } else {
                this.renderDataType(status, x.para(), conc);
            }
        }
        if (dr.hasMN("conclusionCode", "codedDiagnosis")) {
            x.para().b().tx(this.context.formatPhrase("DIAG_REP_REND_CODECON", new Object[0]));
            this.addListRows(status, x.ul(), dr, "DIAG_REP_REND_CODECON", "conclusionCode", "codedDiagnosis");
        }
        for (ResourceWrapper cont : dr.children("contained")) {
            x.hr();
            RendererFactory.factory(cont, this.context.forContained()).buildNarrative(status, x, cont);
        }
    }

    private void addTableRow(Renderer.RenderingStatus status, XhtmlNode tbl, ResourceWrapper dr, String constName, String ... names) throws FHIRFormatError, DefinitionException, IOException {
        List<ResourceWrapper> items = dr.childrenMN(names);
        if (!items.isEmpty()) {
            XhtmlNode tr = tbl.tr();
            tr.td().tx(Utilities.pluralize((String)this.context.formatPhrase(constName, new Object[0]), (int)items.size()));
            XhtmlNode tdr = tr.td();
            for (ResourceWrapper v : items) {
                tdr.tx(" ");
                this.renderDataType(status, tdr, v);
            }
        }
    }

    private void addListRows(Renderer.RenderingStatus status, XhtmlNode ul, ResourceWrapper dr, String constName, String ... names) throws FHIRFormatError, DefinitionException, IOException {
        List<ResourceWrapper> items = dr.childrenMN(names);
        if (!items.isEmpty()) {
            for (ResourceWrapper v : items) {
                XhtmlNode li = ul.li();
                this.renderDataType(status, li, v);
            }
        }
    }

    public void describeDiagnosticReport(XhtmlNode x, ResourceWrapper dr) {
        x.tx(this.displayDiagnosticReport(dr));
    }

    public String displayDiagnosticReport(ResourceWrapper dr) {
        ResourceWrapper c = dr.child("code");
        String cd = c == null ? this.context.formatPhrase("DIAG_REP_UNSPECIFIED_CODE", new Object[0]) : this.displayCodeableConcept(c);
        ResourceWrapper s = dr.child("subject");
        String sd = s == null ? this.context.formatPhrase("DIAG_REP_UNSPECIFIED_SUBJECT", new Object[0]) : this.displayReference(s);
        return this.context.formatPhrase("DIAG_REP_SUMMARY", new Object[]{cd, sd});
    }

    @Override
    public String buildSummary(ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        return this.displayDiagnosticReport(r);
    }

    private void populateSubjectSummary(Renderer.RenderingStatus status, XhtmlNode container, ResourceWrapper subject) throws UnsupportedEncodingException, FHIRException, IOException, EOperationOutcome {
        Resolver.ResourceWithReference r = this.resolveReference(subject);
        if (r == null) {
            container.tx(this.context.formatPhrase("DIAG_REP_REND_UNABLE", new Object[0]));
        } else if (r.getResource().fhirType().equals("Patient")) {
            this.generatePatientSummary(container, r.getResource());
        } else {
            container.tx(this.context.formatPhrase("GENERAL_TODO", new Object[0]));
        }
    }

    private void generatePatientSummary(XhtmlNode c, ResourceWrapper r) throws FHIRFormatError, DefinitionException, FHIRException, IOException, EOperationOutcome {
        new PatientRenderer(this.context).describe(c, r);
    }

    private List<ObservationNode> fetchObservations(List<ResourceWrapper> list) throws UnsupportedEncodingException, FHIRException, IOException {
        ArrayList<ObservationNode> res = new ArrayList<ObservationNode>();
        for (ResourceWrapper b : list) {
            List<ResourceWrapper> t;
            if (!b.has("reference")) continue;
            ObservationNode obs = new ObservationNode();
            obs.ref = b.primitiveValue("reference");
            obs.resolution = this.resolveReference(b.child("reference"));
            if (obs.resolution != null && obs.resolution.getResource() != null && !(t = obs.resolution.getResource().children("contained")).isEmpty()) {
                obs.contained = this.fetchObservations(t);
            }
            res.add(obs);
        }
        return res;
    }

    private void buildObservationsTable(Renderer.RenderingStatus status, XhtmlNode root, List<ObservationNode> observations, ResourceWrapper eff, ResourceWrapper iss) throws UnsupportedEncodingException, FHIRException, IOException {
        XhtmlNode tbl = root.table("grid");
        boolean refRange = this.scanObsForRefRange(observations);
        boolean flags = this.scanObsForFlags(observations);
        boolean note = this.scanObsForNote(observations);
        boolean effectiveTime = this.scanObsForEffective(observations, eff);
        boolean issued = this.scanObsForIssued(observations, iss);
        int cs = 2;
        if (refRange) {
            ++cs;
        }
        if (flags) {
            ++cs;
        }
        if (note) {
            ++cs;
        }
        if (issued) {
            ++cs;
        }
        if (effectiveTime) {
            ++cs;
        }
        XhtmlNode tr = tbl.tr();
        tr.td().b().tx(this.context.formatPhrase("GENERAL_CODE", new Object[0]));
        tr.td().b().tx(this.context.formatPhrase("GENERAL_VALUE", new Object[0]));
        if (refRange) {
            tr.td().b().tx(this.context.formatPhrase("DIAG_REP_REND_REFRAN", new Object[0]));
        }
        if (flags) {
            tr.td().b().tx(this.context.formatPhrase("GENERAL_FLAGS", new Object[0]));
        }
        if (note) {
            tr.td().b().tx(this.context.formatPhrase("GENERAL_NOTE", new Object[0]));
        }
        if (effectiveTime) {
            tr.td().b().tx(this.context.formatPhrase("DIAG_REP_REND_WHEN", new Object[0]));
        }
        if (issued) {
            tr.td().b().tx(this.context.formatPhrase("DIAG_REP_REND_REP", new Object[0]));
        }
        for (ObservationNode o : observations) {
            this.addObservationToTable(status, tbl, o, 0, Integer.toString(cs), refRange, flags, note, effectiveTime, issued, eff, iss);
        }
    }

    private boolean scanObsForRefRange(List<ObservationNode> observations) {
        for (ObservationNode o : observations) {
            if (o.resolution == null) continue;
            ResourceWrapper obs = o.resolution.getResource();
            if (obs != null && obs.has("referenceRange")) {
                return true;
            }
            if (o.contained == null || !this.scanObsForRefRange(o.contained)) continue;
            return true;
        }
        return false;
    }

    private boolean scanObsForNote(List<ObservationNode> observations) {
        for (ObservationNode o : observations) {
            if (o.resolution == null) continue;
            ResourceWrapper obs = o.resolution.getResource();
            if (obs != null && obs.has("note")) {
                return true;
            }
            if (o.contained == null || !this.scanObsForNote(o.contained)) continue;
            return true;
        }
        return false;
    }

    private boolean scanObsForIssued(List<ObservationNode> observations, ResourceWrapper iss) throws UnsupportedEncodingException, FHIRException, IOException {
        for (ObservationNode o : observations) {
            if (o.resolution == null) continue;
            ResourceWrapper obs = o.resolution.getResource();
            if (obs != null && obs.has("issued") && (iss == null || !iss.matches(obs.child("issued")))) {
                return true;
            }
            if (o.contained == null || !this.scanObsForIssued(o.contained, iss)) continue;
            return true;
        }
        return false;
    }

    private boolean scanObsForEffective(List<ObservationNode> observations, ResourceWrapper eff) throws UnsupportedEncodingException, FHIRException, IOException {
        for (ObservationNode o : observations) {
            if (o.resolution == null) continue;
            ResourceWrapper obs = o.resolution.getResource();
            if (obs != null && obs.has("effective[x]") && (eff == null || !eff.matches(obs.child("effective[x]")))) {
                return true;
            }
            if (o.contained == null || !this.scanObsForEffective(o.contained, eff)) continue;
            return true;
        }
        return false;
    }

    private boolean scanObsForFlags(List<ObservationNode> observations) throws UnsupportedEncodingException, FHIRException, IOException {
        for (ObservationNode o : observations) {
            if (o.resolution == null) continue;
            ResourceWrapper obs = o.resolution.getResource();
            if (obs != null && (obs.has("interpretation") || obs.has("status"))) {
                return true;
            }
            if (o.contained == null || !this.scanObsForFlags(o.contained)) continue;
            return true;
        }
        return false;
    }

    private void addObservationToTable(Renderer.RenderingStatus status, XhtmlNode tbl, ObservationNode o, int i, String cs, boolean refRange, boolean flags, boolean note, boolean effectiveTime, boolean issued, ResourceWrapper eff, ResourceWrapper iss) throws UnsupportedEncodingException, FHIRException, IOException {
        XhtmlNode tr = tbl.tr();
        if (o.resolution == null) {
            XhtmlNode td = tr.td().colspan(cs);
            td.i().tx(this.context.formatPhrase("DIAG_REP_REND_NOTRES", new Object[]{o.ref}));
        } else {
            if (o.resolution.getResource() != null) {
                this.addObservationToTable(status, tr, o.resolution.getResource(), i, o.resolution.getWebPath(), refRange, flags, note, effectiveTime, issued, eff, iss);
            } else {
                XhtmlNode td = tr.td().colspan(cs);
                td.i().tx(this.context.formatPhrase("DIAG_REP_REND_OBS", new Object[0]));
            }
            if (o.contained != null) {
                for (ObservationNode c : o.contained) {
                    this.addObservationToTable(status, tbl, c, i + 1, cs, refRange, flags, note, effectiveTime, issued, eff, iss);
                }
            }
        }
    }

    private void addObservationToTable(Renderer.RenderingStatus status, XhtmlNode tr, ResourceWrapper obs, int i, String ref, boolean refRange, boolean flags, boolean note, boolean effectiveTime, boolean issued, ResourceWrapper eff, ResourceWrapper iss) throws UnsupportedEncodingException, FHIRException, IOException {
        XhtmlNode td = tr.td();
        if (obs.has("code")) {
            this.renderDataType(status, td.ah(this.context.prefixLocalHref(ref)), obs.child("code"));
        }
        if (obs.has("bodySite")) {
            td.tx(" (");
            this.renderDataType(status, td, obs.child("bodySite"));
            td.tx(")");
        }
        td = tr.td();
        if (obs.has("value[x]")) {
            this.renderDataType(status, td, obs.child("value[x]"));
        } else if (obs.has("dataAbsentReason")) {
            XhtmlNode span = td.span("color: maroon", "Error");
            span.tx(this.context.formatPhrase("DIAG_REP_REND_ERR", new Object[0]) + " ");
            this.renderDataType(status, span.b(), obs.child("dataAbsentReason"));
        }
        if (refRange) {
            td = tr.td();
            List<ResourceWrapper> items = obs.children("referenceRange");
            if (!items.isEmpty()) {
                boolean first = true;
                for (ResourceWrapper v : items) {
                    ResourceWrapper pwt;
                    if (first) {
                        first = false;
                    } else {
                        td.br();
                    }
                    ResourceWrapper pwr = v.child("type");
                    if (pwr != null) {
                        this.renderDataType(status, td, pwr);
                        td.tx(": ");
                    }
                    if ((pwt = v.child("text")) != null) {
                        this.renderDataType(status, td, pwt);
                    } else {
                        ResourceWrapper pwl = v.child("low");
                        ResourceWrapper pwh = v.child("high");
                        if (pwl != null && pwh != null) {
                            this.renderDataType(status, td, pwl);
                            td.tx(" - ");
                            this.renderDataType(status, td, pwh);
                        } else if (pwl != null) {
                            td.tx(">");
                            this.renderDataType(status, td, pwl);
                        } else if (pwh != null) {
                            td.tx("<");
                            this.renderDataType(status, td, pwh);
                        } else {
                            td.tx("??");
                        }
                    }
                    List<ResourceWrapper> pwrF = v.children("appliesTo");
                    ResourceWrapper pwrA = v.child("age");
                    if (pwrF.isEmpty() && pwrA == null) continue;
                    boolean firstA = true;
                    td.tx(" " + this.context.formatPhrase("DIAG_REP_REND_FOR", new Object[0]) + " ");
                    if (!pwrF.isEmpty()) {
                        for (ResourceWrapper va : pwrF) {
                            if (firstA) {
                                firstA = false;
                            } else {
                                td.tx(", ");
                            }
                            this.renderDataType(status, td, va);
                        }
                    }
                    if (pwrA == null) continue;
                    if (firstA) {
                        firstA = false;
                    } else {
                        td.tx(", ");
                    }
                    td.tx(this.context.formatPhrase("DIAG_REP_REND_AGE", new Object[0]) + " ");
                    this.renderDataType(status, td, pwrA);
                }
            }
        }
        this.addCellToTable(flags, status, tr, obs, null, "status", "interpretation");
        this.addCellToTable(note, status, tr, obs, null, "note");
        this.addCellToTable(effectiveTime, status, tr, obs, eff, "effective[x]");
        this.addCellToTable(issued, status, tr, obs, iss, "issued");
    }

    private void addCellToTable(boolean included, Renderer.RenderingStatus status, XhtmlNode tr, ResourceWrapper obs, ResourceWrapper diff, String ... names) throws FHIRFormatError, DefinitionException, IOException {
        if (included) {
            XhtmlNode td = tr.td();
            List<ResourceWrapper> list = obs.childrenMN(names);
            if (!list.isEmpty()) {
                boolean first = true;
                for (ResourceWrapper b : list) {
                    if (diff != null && diff.matches(b)) continue;
                    if (first) {
                        first = false;
                    } else {
                        td.tx(", ");
                    }
                    this.renderDataType(status, td, b);
                }
            }
        }
    }

    public class ObservationNode {
        private String ref;
        private Resolver.ResourceWithReference resolution;
        private List<ObservationNode> contained;
    }
}

