/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.renderers.Renderer;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.ResourceWrapper;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.r5.utils.LiquidEngine;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.utilities.xhtml.XhtmlParser;

public class LiquidRenderer
extends ResourceRenderer
implements LiquidEngine.ILiquidRenderingSupport {
    private String liquidTemplate;

    public LiquidRenderer(RenderingContext context, String liquidTemplate) {
        super(context);
        this.liquidTemplate = liquidTemplate;
    }

    @Override
    public String buildSummary(ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        return this.canonicalTitle(r);
    }

    @Override
    public void buildNarrative(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper r) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        XhtmlNode xn;
        LiquidEngine engine = new LiquidEngine(this.context.getWorker(), this.context.getServices());
        try {
            engine.setIncludeResolver(new LiquidRendererIncludeResolver(this.context));
            engine.setRenderingSupport(this);
            LiquidEngine.LiquidDocument doc = engine.parse(this.liquidTemplate, "template");
            String html = engine.evaluate(doc, r.getBase(), new LiquidRendererContext(status, r));
            xn = new XhtmlParser().parseFragment(html);
            if (!x.getName().equals("div")) {
                throw new FHIRException("Error in template: Root element is not 'div'");
            }
        }
        catch (IOException | FHIRException e) {
            xn = new XhtmlNode(NodeType.Element, "div");
            xn.para().b().style("color: maroon").tx("Exception generating Narrative: " + e.getMessage());
        }
        x.getChildNodes().addAll((Collection)xn.getChildNodes());
        status.setExtensions(true);
    }

    @Override
    public ResourceRenderer.RendererType getRendererType() {
        return ResourceRenderer.RendererType.LIQUID;
    }

    @Override
    public String renderForLiquid(Object appContext, Base base) throws FHIRException {
        try {
            LiquidRendererContext ctxt = (LiquidRendererContext)appContext;
            ResourceWrapper r = null;
            if (base instanceof Element) {
                r = ResourceWrapper.forType(this.context.getContextUtilities(), (Element)base);
            } else if (base instanceof DataType) {
                r = ResourceWrapper.forType(this.context.getContextUtilities(), (DataType)base);
            } else {
                return base.toString();
            }
            XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
            this.renderDataType(ctxt.status, x, r);
            String res = new XhtmlComposer(true).compose(x);
            res = res.substring(5);
            if (res.length() < 6) {
                return "";
            }
            return res.substring(0, res.length() - 6);
        }
        catch (FHIRFormatError e) {
            throw new FHIRException((Throwable)e);
        }
        catch (IOException e) {
            throw new FHIRException((Throwable)e);
        }
    }

    private class LiquidRendererIncludeResolver
    implements LiquidEngine.ILiquidEngineIncludeResolver {
        private RenderingContext context;

        public LiquidRendererIncludeResolver(RenderingContext context) {
            this.context = context;
        }

        @Override
        public String fetchInclude(LiquidEngine engine, String name) {
            return this.context.getTemplateProvider().findTemplate(this.context, name);
        }
    }

    private class LiquidRendererContext {
        private Renderer.RenderingStatus status;
        private ResourceWrapper resource;

        protected LiquidRendererContext(Renderer.RenderingStatus status, ResourceWrapper resource) {
            this.status = status;
            this.resource = resource;
        }
    }
}

