/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.renderers.Renderer;
import org.hl7.fhir.r5.renderers.RendererFactory;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.ResourceWrapper;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class PatientRenderer
extends ResourceRenderer {
    private static final int MAX_IMAGE_LENGTH = 0x200000;
    private static final boolean SHORT = false;

    public PatientRenderer(RenderingContext context) {
        super(context);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String buildSummary(ResourceWrapper pat) throws UnsupportedEncodingException, IOException {
        ResourceWrapper id = null;
        List<ResourceWrapper> list = pat.children("identifier");
        for (ResourceWrapper resourceWrapper : list) {
            id = this.chooseId(id, resourceWrapper);
        }
        list = pat.children("name");
        ResourceWrapper n = null;
        for (ResourceWrapper t : list) {
            n = this.chooseName(n, t);
        }
        Object var5_7 = null;
        ResourceWrapper item = pat.child("gender");
        if (item != null) {
            String string = this.context.getTranslatedCode(item.primitiveValue(), "http://hl7.org/fhir/administrative-gender");
        }
        ResourceWrapper dt = pat.child("birthDate");
        StringBuilder b = new StringBuilder();
        if (n != null) {
            b.append(PatientRenderer.displayHumanName(n));
        } else {
            b.append(this.context.formatPhrase("PAT_NO_NAME", new Object[0]));
        }
        b.append(" ");
        if (item == null) {
            b.append(this.context.formatPhrase("PAT_NO_GENDER", new Object[0]));
        } else {
            void var5_9;
            b.append((String)var5_9);
        }
        b.append(", ");
        if (dt == null) {
            b.append(this.context.formatPhrase("PAT_NO_DOB", new Object[0]));
        } else {
            b.append(this.context.formatPhrase("PAT_DOB", new Object[]{this.displayDateTime(dt)}));
        }
        if (id != null) {
            b.append(" ( ");
            b.append(this.displayIdentifier(id));
            b.append(")");
        }
        return b.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void buildNarrative(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper pat) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        this.renderResourceTechDetails(pat, x);
        if (this.context.isShortPatientForm()) {
            void var7_13;
            ResourceWrapper id = null;
            List<ResourceWrapper> list = pat.children("identifier");
            for (ResourceWrapper resourceWrapper : list) {
                id = this.chooseId(id, resourceWrapper);
            }
            list = pat.children("name");
            ResourceWrapper n = null;
            for (ResourceWrapper t : list) {
                n = this.chooseName(n, t);
            }
            Object var7_11 = null;
            ResourceWrapper item = pat.child("gender");
            if (item != null) {
                String string = this.getTranslatedCode(item);
            }
            ResourceWrapper dt = pat.child("birthDate");
            if (n == null) {
                x.b().tx(this.context.formatPhrase("PAT_NO_NAME", new Object[0]));
            } else {
                this.renderDataType(status, x.b(), n);
            }
            x.tx(" ");
            if (var7_13 == null) {
                x.tx(this.context.formatPhrase("PAT_NO_GENDER", new Object[0]));
            } else {
                x.tx((String)var7_13);
            }
            x.tx(", ");
            if (dt == null) {
                x.tx(this.context.formatPhrase("PAT_NO_DOB", new Object[0]));
            } else {
                x.tx(this.context.formatPhrase("PAT_DOB", new Object[]{this.displayDateTime(dt)}));
            }
            if (id != null) {
                x.tx(" ( ");
                this.renderDataType(status, x, id);
                x.tx(")");
            }
        } else {
            XhtmlNode tbl;
            this.makeBanner(x.para()).tx(this.buildSummary(pat));
            x.hr();
            if (this.hasRenderablePhoto(pat)) {
                tbl = x.table("none");
                XhtmlNode tr = tbl.tr();
                tbl = tr.td().table("grid");
                this.renderPhoto(tr.td(), pat);
            } else {
                tbl = x.table("grid");
            }
            this.addStatus(status, tbl, pat);
            this.addIdentifiers(status, tbl, pat);
            this.addNames(status, tbl, pat);
            this.addComms(status, tbl, pat);
            this.addLangs(status, tbl, pat);
            this.addNOKs(status, tbl, pat);
            this.addLinks(status, tbl, pat);
            this.addExtensions(status, tbl, pat);
            if (tbl.isEmpty()) {
                x.remove(tbl);
            }
            if (pat.has("contained") && this.context.isTechnicalMode()) {
                x.hr();
                x.para().b().tx(this.context.formatMessagePlural(pat.children("contained").size(), "PAT_CONTAINED", new Object[0]));
                this.addContained(status, x, pat.children("contained"));
            }
        }
    }

    private ResourceWrapper chooseId(ResourceWrapper oldId, ResourceWrapper newId) {
        if (oldId == null) {
            return newId;
        }
        if (newId == null) {
            return oldId;
        }
        return this.isPreferredId(newId.primitiveValue("use"), oldId.primitiveValue("use")) ? newId : oldId;
    }

    private boolean isPreferredId(String newUse, String oldUse) {
        if (newUse == null && oldUse == null || newUse == oldUse) {
            return false;
        }
        if (newUse == null) {
            return true;
        }
        switch (newUse) {
            case "official": {
                return !Utilities.existsInList((String)oldUse, (String[])new String[]{"usual"});
            }
            case "old": {
                return !Utilities.existsInList((String)oldUse, (String[])new String[]{"official", "secondary", "usual"});
            }
            case "secondary": {
                return !Utilities.existsInList((String)oldUse, (String[])new String[]{"official", "usual"});
            }
            case "temp": {
                return !Utilities.existsInList((String)oldUse, (String[])new String[]{"official", "secondary", "usual"});
            }
            case "usual": {
                return true;
            }
        }
        return false;
    }

    private ResourceWrapper chooseName(ResourceWrapper oldName, ResourceWrapper newName) {
        if (oldName == null) {
            return newName;
        }
        if (newName == null) {
            return oldName;
        }
        return this.isPreferredName(newName.primitiveValue("use"), oldName.primitiveValue("use")) ? newName : oldName;
    }

    private boolean isPreferredName(String newUse, String oldUse) {
        if (newUse == null && oldUse == null || newUse == oldUse) {
            return false;
        }
        if (newUse == null) {
            return true;
        }
        if (oldUse == null) {
            return Utilities.existsInList((String)newUse, (String[])new String[]{"official", "usual"});
        }
        switch (oldUse) {
            case "anonymous": {
                return Utilities.existsInList((String)newUse, (String[])new String[]{"official", "usual"});
            }
            case "maiden": {
                return Utilities.existsInList((String)newUse, (String[])new String[]{"official", "usual"});
            }
            case "nickname": {
                return Utilities.existsInList((String)newUse, (String[])new String[]{"official", "usual"});
            }
            case "official": {
                return Utilities.existsInList((String)newUse, (String[])new String[]{"usual"});
            }
            case "old": {
                return Utilities.existsInList((String)newUse, (String[])new String[]{"official", "usual"});
            }
            case "temp": {
                return Utilities.existsInList((String)newUse, (String[])new String[]{"official", "usual"});
            }
            case "usual": {
                return false;
            }
        }
        return false;
    }

    private void addContained(Renderer.RenderingStatus status, XhtmlNode x, List<ResourceWrapper> list) throws FHIRFormatError, DefinitionException, FHIRException, IOException, EOperationOutcome {
        for (ResourceWrapper c : list) {
            x.hr();
            x.an(this.context.prefixAnchor(c.getId()));
            RendererFactory.factory(c, this.context.forContained()).buildNarrative(status, x, c);
        }
    }

    private void addExtensions(Renderer.RenderingStatus status, XhtmlNode tbl, ResourceWrapper r) throws UnsupportedEncodingException, FHIRException, IOException {
        HashMap extensions = new HashMap();
        List<ResourceWrapper> pw = r.children("extension");
        for (ResourceWrapper t : pw) {
            String url = t.primitiveValue("url");
            if (!extensions.containsKey(url)) {
                extensions.put(url, new ArrayList());
            }
            ((List)extensions.get(url)).add(t);
        }
        for (String url : extensions.keySet()) {
            StructureDefinition sd = this.findCanonical(StructureDefinition.class, url, r);
            if (sd == null) continue;
            List list = (List)extensions.get(url);
            boolean anyComplex = false;
            for (ResourceWrapper ext : list) {
                anyComplex = anyComplex || ext.has("extension");
            }
            if (!anyComplex) {
                XhtmlNode tr = tbl.tr();
                this.nameCell(tr, this.getContext().getTranslated(sd.getTitleElement()), sd.getDescription(), sd.getWebPath());
                XhtmlNode td = tr.td();
                td.colspan("3");
                if (list.size() != 1) {
                    XhtmlNode ul = td.ul();
                    for (ResourceWrapper s : list) {
                        XhtmlNode li = ul.li();
                        this.renderDataType(status, li, s.child("value"));
                    }
                    continue;
                }
                this.renderDataType(status, td, ((ResourceWrapper)list.get(0)).child("value"));
                continue;
            }
            for (ResourceWrapper ext : list) {
                XhtmlNode tr = tbl.tr();
                this.nameCell(tr, sd.getTitle() + ":", sd.getDescription());
                XhtmlNode td = tr.td();
                td.colspan("3");
                if (ext.has("extension")) {
                    XhtmlNode ul = td.ul();
                    for (ResourceWrapper s : ext.extensions()) {
                        XhtmlNode li = ul.li();
                        li.tx(s.primitiveValue("url") + ": ");
                        if (s.has("extension")) {
                            boolean first = true;
                            for (ResourceWrapper t : s.extensions()) {
                                if (first) {
                                    first = false;
                                } else {
                                    li.tx("; ");
                                }
                                li.tx(t.primitiveValue("url") + "=");
                                this.renderDataType(status, li, t.child("value"));
                            }
                            continue;
                        }
                        this.renderDataType(status, li, s.child("value"));
                    }
                    continue;
                }
                this.renderDataType(status, td, ext.child("value"));
            }
        }
    }

    private void addIdentifiers(Renderer.RenderingStatus status, XhtmlNode tbl, ResourceWrapper r) throws FHIRFormatError, DefinitionException, IOException {
        List<ResourceWrapper> ids = r.children("identifier");
        ResourceWrapper id = null;
        for (ResourceWrapper i : ids) {
            id = this.chooseId(id, i);
        }
        if (id != null) {
            ids.remove(id);
        }
        if (ids.size() > 0) {
            XhtmlNode tr = tbl.tr();
            this.nameCell(tr, this.context.formatMessagePlural(ids.size(), "PAT_OTHER_ID", new Object[0]), this.context.formatMessagePlural(ids.size(), "PAT_OTHER_ID_HINT", new Object[0]));
            XhtmlNode td = tr.td();
            td.colspan("3");
            if (ids.size() == 1) {
                this.renderDataType(status, td, ids.get(0));
            } else {
                XhtmlNode ul = td.ul();
                for (ResourceWrapper i : ids) {
                    this.renderDataType(status, ul.li(), i);
                }
            }
        }
    }

    private void addLangs(Renderer.RenderingStatus status, XhtmlNode tbl, ResourceWrapper r) throws FHIRFormatError, DefinitionException, IOException {
        ArrayList<ResourceWrapper> langs = new ArrayList<ResourceWrapper>();
        List<ResourceWrapper> comms = r.children("communication");
        ResourceWrapper prefLang = null;
        for (ResourceWrapper t : comms) {
            ResourceWrapper lang = t.child("language");
            if (lang == null) continue;
            langs.add(lang);
            ResourceWrapper l = t.child("preferred");
            if (l == null || !"true".equals(l.primitiveValue())) continue;
            prefLang = lang;
        }
        if (langs.size() > 0) {
            XhtmlNode tr = tbl.tr();
            this.nameCell(tr, this.context.formatMessagePlural(langs.size(), "PAT_LANG", new Object[0]), this.context.formatMessagePlural(langs.size(), "PAT_LANG_HINT", new Object[0]));
            XhtmlNode td = tr.td();
            td.colspan("3");
            if (langs.size() == 1) {
                this.renderDataType(status, td, (ResourceWrapper)langs.get(0));
                if (prefLang != null) {
                    td.tx(" " + this.context.formatPhrase("PAT_LANG_PREFERRED", new Object[0]));
                }
            } else if (langs.size() > 1) {
                XhtmlNode ul = td.ul();
                for (ResourceWrapper i : langs) {
                    XhtmlNode li = ul.li();
                    this.renderDataType(status, li, i);
                    if (i != prefLang) continue;
                    li.tx(" " + this.context.formatPhrase("PAT_LANG_PREFERRED", new Object[0]));
                }
            }
        }
    }

    private void addLinks(Renderer.RenderingStatus status, XhtmlNode tbl, ResourceWrapper r) throws UnsupportedEncodingException, FHIRException, IOException {
        ArrayList<NamedReferance> refs = new ArrayList<NamedReferance>();
        List<ResourceWrapper> pw = r.children("generalPractitioner");
        for (ResourceWrapper t : pw) {
            refs.add(new NamedReferance(this.context.formatPhrase("PAT_GP", new Object[0]), t));
        }
        pw = r.children("managingOrganization");
        for (ResourceWrapper t : pw) {
            refs.add(new NamedReferance(this.context.formatPhrase("PAT_MO", new Object[0]), t));
        }
        pw = r.children("link");
        for (ResourceWrapper t : pw) {
            ResourceWrapper o = t.firstChild("other");
            ResourceWrapper l = t.firstChild("type");
            if (l == null || o == null) continue;
            refs.add(new NamedReferance(this.describeLinkedRecord(l.primitiveValue()), o));
        }
        if (refs.size() > 0) {
            XhtmlNode tr = tbl.tr();
            this.nameCell(tr, this.context.formatPhrase("PAT_LINKS", new Object[0]), this.context.formatPhrase("PAT_LINKS_HINT", new Object[0]));
            XhtmlNode td = tr.td();
            td.colspan("3");
            XhtmlNode ul = td.ul();
            for (NamedReferance ref : refs) {
                XhtmlNode li = ul.li();
                li.tx(ref.getName());
                li.tx(": ");
                this.renderReference(status, li, ref.getReference());
            }
        }
    }

    private String describeLinkedRecord(String type) {
        switch (type) {
            case "replaced-by": {
                return this.context.formatPhrase("PAT_LINK_REPLBY", new Object[0]);
            }
            case "replaces": {
                return this.context.formatPhrase("PAT_LINK_REPL", new Object[0]);
            }
            case "refer": {
                return this.context.formatPhrase("PAT_LINK_REFER", new Object[0]);
            }
            case "seealso": {
                return this.context.formatPhrase("PAT_LINK_SEE", new Object[0]);
            }
        }
        return "Unknown";
    }

    private void addNOKs(Renderer.RenderingStatus status, XhtmlNode tbl, ResourceWrapper r) throws FHIRFormatError, DefinitionException, IOException {
        for (ResourceWrapper t : r.children("contact")) {
            this.addNOK(status, tbl, r, t);
        }
    }

    private void addNOK(Renderer.RenderingStatus status, XhtmlNode tbl, ResourceWrapper r, ResourceWrapper bw) throws FHIRFormatError, DefinitionException, IOException {
        XhtmlNode li;
        List<ResourceWrapper> rels = bw.children("relationship");
        ResourceWrapper name = bw.firstChild("name");
        ResourceWrapper add = bw.firstChild("address");
        String gender = this.context.getTranslatedCode(bw.primitiveValue("gender"), "http://hl7.org/fhir/administrative-gender");
        ResourceWrapper period = bw.firstChild("period");
        ResourceWrapper organization = bw.firstChild("organization");
        List<ResourceWrapper> tels = bw.children("telecom");
        if (rels.size() < 2 && name == null && add == null && gender == null && period == null && organization == null && tels.size() == 0) {
            return;
        }
        XhtmlNode tr = tbl.tr();
        if (rels.size() == 1) {
            this.nameCell(tr, this.displayDataType(rels.get(0)) + ":", this.context.formatPhrase("PAT_NOM_CONTACT", new Object[0]) + " " + this.displayDataType(rels.get(0)));
        } else {
            this.nameCell(tr, this.context.formatPhrase("GENERAL_CONTACT", new Object[0]), this.context.formatPhrase("PAT_NOK_CONTACT_HINT", new Object[0]));
        }
        XhtmlNode td = tr.td();
        td.colspan("3");
        XhtmlNode ul = td.ul();
        if (name != null) {
            li = ul.li();
            this.renderDataType(status, li, name);
            if (gender != null) {
                li.tx(" (" + gender + ")");
            }
        } else if (gender != null) {
            li = ul.li();
            li.tx(this.context.formatPhrase("PAT_GENDER", new Object[]{gender}));
        }
        if (rels.size() > 1) {
            li = ul.li();
            li.tx(this.context.formatPhrase("PAT_RELN", new Object[0]));
            boolean first = true;
            for (ResourceWrapper rel : rels) {
                if (first) {
                    first = false;
                } else {
                    li.tx(", ");
                }
                this.renderDataType(status, li, rel);
            }
        }
        if (add != null) {
            this.renderDataType(status, ul.li(), add);
        }
        for (ResourceWrapper cp : tels) {
            this.renderDataType(status, ul.li(), cp);
        }
        if (organization != null) {
            li = ul.li();
            li.tx(this.context.formatPhrase("PAT_ORG", new Object[0]));
            this.renderDataType(status, li, organization);
        }
        if (period != null) {
            li = ul.li();
            li.tx(this.context.formatPhrase("PAT_PERIOD", new Object[0]));
            this.renderDataType(status, li, period);
        }
    }

    private void addNames(Renderer.RenderingStatus status, XhtmlNode tbl, ResourceWrapper r) throws FHIRFormatError, DefinitionException, IOException {
        List<ResourceWrapper> names = r.children("name");
        ResourceWrapper name = null;
        for (ResourceWrapper n : names) {
            name = this.chooseName(name, n);
        }
        if (name != null) {
            names.remove(name);
        }
        if (names.size() == 1) {
            XhtmlNode tr = tbl.tr();
            this.nameCell(tr, this.context.formatPhrase("PAT_ALT_NAME", new Object[0]), this.context.formatPhrase("PAT_ALT_NAME_HINT", new Object[0]));
            XhtmlNode td = tr.td();
            td.colspan("3");
            if (names.size() == 1) {
                this.renderDataType(status, td, names.get(0));
            } else {
                XhtmlNode ul = td.ul();
                for (ResourceWrapper n : names) {
                    this.renderDataType(status, ul.li(), n);
                }
            }
        }
    }

    private void addComms(Renderer.RenderingStatus status, XhtmlNode tbl, ResourceWrapper r) throws FHIRFormatError, DefinitionException, IOException {
        List<ResourceWrapper> tels = r.children("telecom");
        List<ResourceWrapper> adds = r.children("address");
        if (tels.size() + adds.size() > 0) {
            XhtmlNode tr = tbl.tr();
            this.nameCell(tr, this.context.formatPhrase("PAT_CONTACT", new Object[0]), this.context.formatPhrase("PAT_CONTACT_HINT", new Object[0]));
            XhtmlNode td = tr.td();
            td.colspan("3");
            if (tels.size() + adds.size() == 1) {
                if (adds.isEmpty()) {
                    this.renderDataType(status, td, tels.get(0));
                } else {
                    this.renderDataType(status, td, adds.get(0));
                }
            } else {
                XhtmlNode ul = td.ul();
                for (ResourceWrapper n : tels) {
                    this.renderDataType(status, ul.li(), n);
                }
                for (ResourceWrapper n : adds) {
                    this.renderDataType(status, ul.li(), n);
                }
            }
        }
    }

    private void addStatus(Renderer.RenderingStatus status, XhtmlNode tbl, ResourceWrapper r) throws FHIRFormatError, DefinitionException, UnsupportedEncodingException, FHIRException, IOException {
        int count = 0;
        if (r.has("active")) {
            ++count;
        }
        if (r.has("deceased")) {
            ++count;
        }
        if (r.has("maritalStatus")) {
            ++count;
        }
        if (r.has("multipleBirth")) {
            ++count;
        }
        if (count > 0) {
            XhtmlNode td;
            List<ResourceWrapper> a;
            XhtmlNode tr = tbl.tr();
            int pos = 0;
            if (r.has("active") && !(a = r.children("active")).isEmpty()) {
                this.nameCell(tr, this.context.formatPhrase("PAT_ACTIVE", new Object[0]), this.context.formatPhrase("PAT_ACTIVE_HINT", new Object[0]));
                td = tr.td();
                if (++pos == count) {
                    td.colspan("3");
                }
                this.renderDataType(status, td, a.get(0));
            }
            if (r.has("deceased[x]") && !(a = r.children("deceased[x]")).isEmpty()) {
                this.nameCell(tr, this.context.formatPhrase("PAT_DECEASED", new Object[0]), this.context.formatPhrase("PAT_DECEASED_HINT", new Object[0]));
                td = tr.td();
                if (++pos == count) {
                    td.colspan("3");
                }
                this.renderDataType(status, td, a.get(0));
            }
            if (r.has("maritalStatus") && !(a = r.children("maritalStatus")).isEmpty()) {
                if (++pos == 3) {
                    tr = tbl.tr();
                }
                this.nameCell(tr, this.context.formatPhrase("PAT_MARITAL", new Object[0]), this.context.formatPhrase("PAT_MARITAL_HINT", new Object[0]));
                td = tr.td();
                if (pos == count) {
                    td.colspan("3");
                }
                this.renderDataType(status, td, a.get(0));
            }
            if (r.has("multipleBirth[x]") && !(a = r.children("multipleBirth[x]")).isEmpty()) {
                if (++pos == 3) {
                    tr = tbl.tr();
                }
                this.nameCell(tr, this.context.formatPhrase("PAT_MUL_BIRTH", new Object[0]), this.context.formatPhrase("PAT_MUL_BIRTH_HINT", new Object[0]));
                td = tr.td();
                if (pos == count) {
                    td.colspan("3");
                }
                this.renderDataType(status, td, a.get(0));
            }
        }
    }

    private void nameCell(XhtmlNode tr, String text, String title) {
        XhtmlNode td = tr.td();
        td.setAttribute("title", title);
        td.tx(text);
        td.style("background-color: #f3f5da");
    }

    private void nameCell(XhtmlNode tr, String text, String title, String link) {
        XhtmlNode td = tr.td();
        td.setAttribute("title", title);
        if (link != null) {
            td.ah(this.context.prefixLocalHref(link)).tx(text);
        } else {
            td.tx(text);
        }
        td.style("background-color: #f3f5da");
    }

    private void renderPhoto(XhtmlNode td, ResourceWrapper r) throws UnsupportedEncodingException, FHIRException, IOException {
        if (r.has("photo")) {
            List<ResourceWrapper> a = r.children("photo");
            for (ResourceWrapper att : a) {
                byte[] cnt;
                String ct = att.primitiveValue("contentType");
                byte[] byArray = cnt = att.has("data") ? Base64.getDecoder().decode(att.primitiveValue("data")) : null;
                if (!ct.startsWith("image/") || cnt == null || this.context.isInlineGraphics() && (cnt.length <= 0 || cnt.length >= 0x200000)) continue;
                String ext = this.extensionForType(ct);
                if (this.context.isInlineGraphics() || Utilities.noString((String)this.context.getDestDir()) || ext == null) {
                    td.img("data:" + ct + ";base64," + att.primitiveValue("data"), "patient photo");
                } else {
                    String n = UUID.randomUUID().toString().toLowerCase() + ext;
                    TextFile.bytesToFile((byte[])cnt, (File)ManagedFileAccess.file((String)Utilities.path((String[])new String[]{this.context.getDestDir(), n})));
                    this.context.registerFile(n);
                    td.img(n, this.context.formatPhrase("PAT_PHOTO", new Object[0]));
                }
                return;
            }
        }
    }

    private String extensionForType(String contentType) {
        if (contentType.equals("image/gif")) {
            return ".gif";
        }
        if (contentType.equals("image/png")) {
            return ".png";
        }
        if (contentType.equals("image/jpeg")) {
            return ".jpg";
        }
        return null;
    }

    private boolean hasRenderablePhoto(ResourceWrapper r) throws UnsupportedEncodingException, FHIRException, IOException {
        if (r.has("photo")) {
            List<ResourceWrapper> a = r.children("photo");
            for (ResourceWrapper att : a) {
                if (!att.has("contentType") || !att.primitiveValue("contentType").startsWith("image/") || !att.has("data") || this.context.isInlineGraphics() && (att.primitiveValue("data").length() <= 0 || att.primitiveValue("data").length() >= 0x200000)) continue;
                return true;
            }
        }
        return false;
    }

    private XhtmlNode makeBanner(XhtmlNode para) {
        para.style("border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;");
        return para;
    }

    public class NamedReferance {
        private String name;
        private ResourceWrapper reference;

        public NamedReferance(String name, ResourceWrapper ref) {
            this.name = name;
            this.reference = ref;
        }

        public String getName() {
            return this.name;
        }

        public ResourceWrapper getReference() {
            return this.reference;
        }
    }
}

