/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils.client;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okhttp3.Headers;
import okhttp3.internal.http2.Header;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.utils.client.EFhirClientException;
import org.hl7.fhir.r5.utils.client.ResourceAddress;
import org.hl7.fhir.r5.utils.client.ResourceFormat;
import org.hl7.fhir.r5.utils.client.network.ByteUtils;
import org.hl7.fhir.r5.utils.client.network.Client;
import org.hl7.fhir.r5.utils.client.network.ResourceRequest;
import org.hl7.fhir.utilities.FHIRBaseToolingClient;
import org.hl7.fhir.utilities.ToolingClientLogger;
import org.hl7.fhir.utilities.Utilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FHIRToolingClient
extends FHIRBaseToolingClient {
    private static final Logger logger = LoggerFactory.getLogger(FHIRToolingClient.class);
    public static final String DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ssK";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String hostKey = "http.proxyHost";
    public static final String portKey = "http.proxyPort";
    private String base;
    private ResourceAddress resourceAddress;
    private ResourceFormat preferredResourceFormat;
    private int maxResultSetSize = -1;
    private CapabilityStatement capabilities;
    private Client client = new Client();
    private ArrayList<Header> headers = new ArrayList();
    private String username;
    private String password;
    private String userAgent;
    private String acceptLang;
    private String contentLang;
    private int useCount;

    public FHIRToolingClient(String baseServiceUrl, String userAgent) throws URISyntaxException {
        this.preferredResourceFormat = ResourceFormat.RESOURCE_JSON;
        this.userAgent = userAgent;
        this.initialize(baseServiceUrl);
    }

    public void initialize(String baseServiceUrl) throws URISyntaxException {
        this.base = baseServiceUrl;
        this.client.setBase(this.base);
        this.resourceAddress = new ResourceAddress(baseServiceUrl);
        this.maxResultSetSize = -1;
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public String getPreferredResourceFormat() {
        return this.preferredResourceFormat.getHeader();
    }

    public void setPreferredResourceFormat(ResourceFormat resourceFormat) {
        this.preferredResourceFormat = resourceFormat;
    }

    public int getMaximumRecordCount() {
        return this.maxResultSetSize;
    }

    public void setMaximumRecordCount(int maxResultSetSize) {
        this.maxResultSetSize = maxResultSetSize;
    }

    private List<ResourceFormat> getResourceFormatsWithPreferredFirst() {
        return Stream.concat(Arrays.stream(new ResourceFormat[]{this.preferredResourceFormat}), Arrays.stream(ResourceFormat.values()).filter(a -> a != this.preferredResourceFormat)).collect(Collectors.toList());
    }

    private <T extends Resource> T getCapabilities(URI resourceUri, String message, String exceptionMessage) throws FHIRException {
        List<ResourceFormat> resourceFormats = this.getResourceFormatsWithPreferredFirst();
        for (ResourceFormat attemptedResourceFormat : resourceFormats) {
            try {
                Object output = this.client.issueGetResourceRequest(resourceUri, this.withVer(this.preferredResourceFormat.getHeader(), "5.0"), this.generateHeaders(false), message, this.timeoutNormal).getReference();
                if (attemptedResourceFormat != this.preferredResourceFormat) {
                    this.setPreferredResourceFormat(attemptedResourceFormat);
                }
                return output;
            }
            catch (Exception e) {
                logger.warn("Failed attempt to fetch " + resourceUri, (Throwable)e);
            }
        }
        throw new FHIRException(exceptionMessage);
    }

    public TerminologyCapabilities getTerminologyCapabilities() {
        TerminologyCapabilities capabilities = null;
        try {
            capabilities = (TerminologyCapabilities)this.getCapabilities(this.resourceAddress.resolveMetadataTxCaps(), "TerminologyCapabilities", "Error fetching the server's terminology capabilities");
        }
        catch (ClassCastException e) {
            throw new FHIRException("Unexpected response format for Terminology Capability metadata", (Throwable)e);
        }
        return capabilities;
    }

    public CapabilityStatement getCapabilitiesStatement() {
        CapabilityStatement capabilityStatement = null;
        capabilityStatement = (CapabilityStatement)this.getCapabilities(this.resourceAddress.resolveMetadataUri(false), "CapabilitiesStatement", "Error fetching the server's conformance statement");
        return capabilityStatement;
    }

    public CapabilityStatement getCapabilitiesStatementQuick() throws EFhirClientException {
        if (this.capabilities != null) {
            return this.capabilities;
        }
        this.capabilities = (CapabilityStatement)this.getCapabilities(this.resourceAddress.resolveMetadataUri(true), "CapabilitiesStatement-Quick", "Error fetching the server's capability statement");
        return this.capabilities;
    }

    public Resource read(String resourceClass, String id) {
        this.recordUse();
        ResourceRequest result = null;
        try {
            result = this.client.issueGetResourceRequest(this.resourceAddress.resolveGetUriFromResourceClassAndId(resourceClass, id), this.withVer(this.getPreferredResourceFormat(), "4.0"), this.generateHeaders(false), "Read " + resourceClass + "/" + id, this.timeoutNormal);
            if (result.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
            }
        }
        catch (Exception e) {
            throw new FHIRException((Throwable)e);
        }
        return result.getPayload();
    }

    public <T extends Resource> T read(Class<T> resourceClass, String id) {
        this.recordUse();
        ResourceRequest result = null;
        try {
            result = this.client.issueGetResourceRequest(this.resourceAddress.resolveGetUriFromResourceClassAndId(resourceClass, id), this.withVer(this.getPreferredResourceFormat(), "4.0"), this.generateHeaders(false), "Read " + resourceClass.getName() + "/" + id, this.timeoutNormal);
            if (result.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
            }
        }
        catch (Exception e) {
            throw new FHIRException((Throwable)e);
        }
        return result.getPayload();
    }

    public <T extends Resource> T vread(Class<T> resourceClass, String id, String version) {
        this.recordUse();
        ResourceRequest result = null;
        try {
            result = this.client.issueGetResourceRequest(this.resourceAddress.resolveGetUriFromResourceClassAndIdAndVersion(resourceClass, id, version), this.withVer(this.getPreferredResourceFormat(), "4.0"), this.generateHeaders(false), "VRead " + resourceClass.getName() + "/" + id + "/?_history/" + version, this.timeoutNormal);
            if (result.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
            }
        }
        catch (Exception e) {
            throw new FHIRException("Error trying to read this version of the resource", (Throwable)e);
        }
        return result.getPayload();
    }

    public <T extends Resource> T getCanonical(Class<T> resourceClass, String canonicalURL) {
        this.recordUse();
        ResourceRequest result = null;
        try {
            result = this.client.issueGetResourceRequest(this.resourceAddress.resolveGetUriFromResourceClassAndCanonical(resourceClass, canonicalURL), this.withVer(this.getPreferredResourceFormat(), "4.0"), this.generateHeaders(false), "Read " + resourceClass.getName() + "?url=" + canonicalURL, this.timeoutNormal);
            if (result.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
            }
        }
        catch (Exception e) {
            this.handleException("An error has occurred while trying to read this version of the resource", e);
        }
        Bundle bnd = (Bundle)result.getPayload();
        if (bnd.getEntry().size() == 0) {
            throw new EFhirClientException("No matching resource found for canonical URL '" + canonicalURL + "'");
        }
        if (bnd.getEntry().size() > 1) {
            throw new EFhirClientException("Multiple matching resources found for canonical URL '" + canonicalURL + "'");
        }
        return (T)bnd.getEntry().get(0).getResource();
    }

    public Resource update(Resource resource) {
        this.recordUse();
        ResourceRequest result = null;
        try {
            result = this.client.issuePutRequest(this.resourceAddress.resolveGetUriFromResourceClassAndId(resource.getClass(), resource.getId()), ByteUtils.resourceToByteArray(resource, false, this.isJson(this.getPreferredResourceFormat()), false), this.withVer(this.getPreferredResourceFormat(), "4.0"), this.generateHeaders(true), "Update " + resource.fhirType() + "/" + resource.getId(), this.timeoutOperation);
            if (result.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
            }
        }
        catch (Exception e) {
            throw new EFhirClientException("An error has occurred while trying to update this resource", e);
        }
        try {
            OperationOutcome operationOutcome = (OperationOutcome)result.getPayload();
            ResourceAddress.ResourceVersionedIdentifier resVersionedIdentifier = ResourceAddress.parseCreateLocation(result.getLocation());
            return this.vread(resource.getClass(), resVersionedIdentifier.getId(), resVersionedIdentifier.getVersionId());
        }
        catch (ClassCastException classCastException) {
            return result.getPayload();
        }
    }

    public <T extends Resource> T update(Class<T> resourceClass, T resource, String id) {
        this.recordUse();
        ResourceRequest result = null;
        try {
            result = this.client.issuePutRequest(this.resourceAddress.resolveGetUriFromResourceClassAndId(resourceClass, id), ByteUtils.resourceToByteArray(resource, false, this.isJson(this.getPreferredResourceFormat()), false), this.withVer(this.getPreferredResourceFormat(), "4.0"), this.generateHeaders(true), "Update " + resource.fhirType() + "/" + id, this.timeoutOperation);
            if (result.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
            }
        }
        catch (Exception e) {
            throw new EFhirClientException("An error has occurred while trying to update this resource", e);
        }
        try {
            OperationOutcome operationOutcome = (OperationOutcome)result.getPayload();
            ResourceAddress.ResourceVersionedIdentifier resVersionedIdentifier = ResourceAddress.parseCreateLocation(result.getLocation());
            return this.vread(resourceClass, resVersionedIdentifier.getId(), resVersionedIdentifier.getVersionId());
        }
        catch (ClassCastException classCastException) {
            return result.getPayload();
        }
    }

    /*
     * WARNING - void declaration
     */
    public <T extends Resource> Parameters operateType(Class<T> resourceClass, String name, Parameters params) {
        this.recordUse();
        boolean complex = false;
        for (Parameters.ParametersParameterComponent parametersParameterComponent : params.getParameter()) {
            complex = complex || !(parametersParameterComponent.getValue() instanceof PrimitiveType);
        }
        Object ps = "";
        try {
            void var6_11;
            if (!complex) {
                for (Parameters.ParametersParameterComponent p : params.getParameter()) {
                    if (!(p.getValue() instanceof PrimitiveType)) continue;
                    ps = (String)ps + p.getName() + "=" + Utilities.encodeUri((String)((PrimitiveType)p.getValue()).asStringValue()) + "&";
                }
            }
            URI url = this.resourceAddress.resolveOperationURLFromClass(resourceClass, name, (String)ps);
            if (complex) {
                byte[] body = ByteUtils.resourceToByteArray(params, false, this.isJson(this.getPreferredResourceFormat()), true);
                ResourceRequest resourceRequest = this.client.issuePostRequest(url, body, this.withVer(this.getPreferredResourceFormat(), "4.0"), this.generateHeaders(true), "POST " + resourceClass.getName() + "/$" + name, this.timeoutLong);
            } else {
                ResourceRequest resourceRequest = this.client.issueGetResourceRequest(url, this.withVer(this.getPreferredResourceFormat(), "4.0"), this.generateHeaders(false), "GET " + resourceClass.getName() + "/$" + name, this.timeoutLong);
            }
            if (var6_11.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server returned error code " + var6_11.getHttpStatus(), (OperationOutcome)var6_11.getPayload());
            }
            if (var6_11.getPayload() instanceof Parameters) {
                return (Parameters)var6_11.getPayload();
            }
            Parameters p_out = new Parameters();
            p_out.addParameter().setName("return").setResource((Resource)var6_11.getPayload());
            return p_out;
        }
        catch (Exception exception) {
            this.handleException("Error performing tx5 operation '" + name + ": " + exception.getMessage() + "' (parameters = \"" + (String)ps + "\")", exception);
            return null;
        }
    }

    public Bundle transaction(Bundle batch) {
        this.recordUse();
        Bundle transactionResult = null;
        try {
            transactionResult = this.client.postBatchRequest(this.resourceAddress.getBaseServiceUri(), ByteUtils.resourceToByteArray(batch, false, this.isJson(this.getPreferredResourceFormat()), false), this.withVer(this.getPreferredResourceFormat(), "4.0"), this.generateHeaders(true), "transaction", this.timeoutOperation + this.timeoutEntry * batch.getEntry().size());
        }
        catch (Exception e) {
            this.handleException("An error occurred trying to process this transaction request", e);
        }
        return transactionResult;
    }

    public <T extends Resource> OperationOutcome validate(Class<T> resourceClass, T resource, String id) {
        this.recordUse();
        ResourceRequest result = null;
        try {
            result = this.client.issuePostRequest(this.resourceAddress.resolveValidateUri(resourceClass, id), ByteUtils.resourceToByteArray(resource, false, this.isJson(this.getPreferredResourceFormat()), false), this.withVer(this.getPreferredResourceFormat(), "4.0"), this.generateHeaders(true), "POST " + resourceClass.getName() + (String)(id != null ? "/" + id : "") + "/$validate", this.timeoutLong);
            if (result.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
            }
        }
        catch (Exception e) {
            this.handleException("An error has occurred while trying to validate this resource", e);
        }
        return (OperationOutcome)result.getPayload();
    }

    protected void handleException(String message, Exception e) throws EFhirClientException {
        if (e instanceof EFhirClientException) {
            throw (EFhirClientException)e;
        }
        throw new EFhirClientException(message, e);
    }

    protected boolean isJson(String format) {
        boolean isJson = false;
        if (format.toLowerCase().contains("json")) {
            isJson = true;
        }
        return isJson;
    }

    public Bundle fetchFeed(String url) {
        this.recordUse();
        Bundle feed = null;
        try {
            feed = this.client.issueGetFeedRequest(new URI(url), this.getPreferredResourceFormat());
        }
        catch (Exception e) {
            this.handleException("An error has occurred while trying to retrieve history since last update", e);
        }
        return feed;
    }

    public ValueSet expandValueset(ValueSet source, Parameters expParams) {
        this.recordUse();
        Parameters p = expParams == null ? new Parameters() : expParams.copy();
        p.addParameter().setName("valueSet").setResource(source);
        ResourceRequest result = null;
        try {
            result = this.client.issuePostRequest(this.resourceAddress.resolveOperationUri(ValueSet.class, "expand"), ByteUtils.resourceToByteArray(p, false, this.isJson(this.getPreferredResourceFormat()), true), this.withVer(this.getPreferredResourceFormat(), "4.0"), this.generateHeaders(true), "ValueSet/$expand?url=" + source.getUrl(), this.timeoutExpand);
        }
        catch (IOException e) {
            throw new FHIRException((Throwable)e);
        }
        if (result.isUnsuccessfulRequest()) {
            throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
        }
        return result == null ? null : (ValueSet)result.getPayload();
    }

    public Parameters lookupCode(Map<String, String> params) {
        this.recordUse();
        ResourceRequest result = null;
        try {
            result = this.client.issueGetResourceRequest(this.resourceAddress.resolveOperationUri(CodeSystem.class, "lookup", params), this.withVer(this.getPreferredResourceFormat(), "4.0"), this.generateHeaders(false), "CodeSystem/$lookup", this.timeoutNormal);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (result.isUnsuccessfulRequest()) {
            throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
        }
        return (Parameters)result.getPayload();
    }

    public Parameters lookupCode(Parameters p) {
        this.recordUse();
        ResourceRequest result = null;
        try {
            result = this.client.issuePostRequest(this.resourceAddress.resolveOperationUri(CodeSystem.class, "lookup"), ByteUtils.resourceToByteArray(p, false, this.isJson(this.getPreferredResourceFormat()), true), this.withVer(this.getPreferredResourceFormat(), "4.0"), this.generateHeaders(true), "CodeSystem/$lookup", this.timeoutNormal);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (result.isUnsuccessfulRequest()) {
            throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
        }
        return (Parameters)result.getPayload();
    }

    public Parameters translate(Parameters p) {
        this.recordUse();
        ResourceRequest result = null;
        try {
            result = this.client.issuePostRequest(this.resourceAddress.resolveOperationUri(ConceptMap.class, "translate"), ByteUtils.resourceToByteArray(p, false, this.isJson(this.getPreferredResourceFormat()), true), this.withVer(this.getPreferredResourceFormat(), "4.0"), this.generateHeaders(true), "ConceptMap/$translate", this.timeoutNormal);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (result.isUnsuccessfulRequest()) {
            throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
        }
        return (Parameters)result.getPayload();
    }

    public String getAddress() {
        return this.base;
    }

    public ConceptMap initializeClosure(String name) {
        this.recordUse();
        Parameters params = new Parameters();
        params.addParameter().setName("name").setValue(new StringType(name));
        ResourceRequest result = null;
        try {
            result = this.client.issuePostRequest(this.resourceAddress.resolveOperationUri(null, "closure", new HashMap<String, String>()), ByteUtils.resourceToByteArray(params, false, this.isJson(this.getPreferredResourceFormat()), true), this.withVer(this.getPreferredResourceFormat(), "4.0"), this.generateHeaders(true), "Closure?name=" + name, this.timeoutNormal);
            if (result.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result == null ? null : (ConceptMap)result.getPayload();
    }

    public ConceptMap updateClosure(String name, Coding coding) {
        this.recordUse();
        Parameters params = new Parameters();
        params.addParameter().setName("name").setValue(new StringType(name));
        params.addParameter().setName("concept").setValue(coding);
        ResourceRequest result = null;
        try {
            result = this.client.issuePostRequest(this.resourceAddress.resolveOperationUri(null, "closure", new HashMap<String, String>()), ByteUtils.resourceToByteArray(params, false, this.isJson(this.getPreferredResourceFormat()), true), this.withVer(this.getPreferredResourceFormat(), "4.0"), this.generateHeaders(true), "UpdateClosure?name=" + name, this.timeoutOperation);
            if (result.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result == null ? null : (ConceptMap)result.getPayload();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public long getTimeout() {
        return this.client.getTimeout();
    }

    public void setTimeout(long timeout) {
        this.client.setTimeout(timeout);
    }

    public ToolingClientLogger getLogger() {
        return this.client.getLogger();
    }

    public void setLogger(ToolingClientLogger logger) {
        this.client.setLogger(logger);
    }

    public int getRetryCount() {
        return this.client.getRetryCount();
    }

    public void setRetryCount(int retryCount) {
        this.client.setRetryCount(retryCount);
    }

    public void setClientHeaders(ArrayList<Header> headers) {
        this.headers = headers;
    }

    private Headers generateHeaders(boolean hasBody) {
        Headers.Builder builder = new Headers.Builder();
        if (this.basicAuthHeaderExists()) {
            builder.add(this.getAuthorizationHeader().toString());
        }
        if (this.headers != null) {
            this.headers.forEach(header -> builder.add(header.toString()));
        }
        if (!Utilities.noString((String)this.userAgent)) {
            builder.add("User-Agent: " + this.userAgent);
        }
        if (!Utilities.noString((String)this.acceptLang)) {
            builder.add("Accept-Language: " + this.acceptLang);
        }
        if (hasBody && !Utilities.noString((String)this.contentLang)) {
            builder.add("Content-Language: " + this.contentLang);
        }
        return builder.build();
    }

    public boolean basicAuthHeaderExists() {
        return this.username != null && this.password != null;
    }

    public Header getAuthorizationHeader() {
        String usernamePassword = this.username + ":" + this.password;
        String base64usernamePassword = Base64.getEncoder().encodeToString(usernamePassword.getBytes());
        return new Header("Authorization", "Basic " + base64usernamePassword);
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getServerVersion() {
        if (this.capabilities == null) {
            try {
                this.getCapabilitiesStatementQuick();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.capabilities == null ? null : this.capabilities.getSoftware().getVersion();
    }

    public void setAcceptLanguage(String lang) {
        this.acceptLang = lang;
    }

    public void setContentLanguage(String lang) {
        this.contentLang = lang;
    }

    public Bundle search(String type, String criteria) {
        this.recordUse();
        return this.fetchFeed(Utilities.pathURL((String[])new String[]{this.base, type + criteria}));
    }

    public <T extends Resource> T fetchResource(Class<T> resourceClass, String id) {
        this.recordUse();
        ResourceRequest result = null;
        try {
            result = this.client.issueGetResourceRequest(this.resourceAddress.resolveGetResource(resourceClass, id), this.withVer(this.getPreferredResourceFormat(), "4.0"), this.generateHeaders(false), resourceClass.getName() + "/" + id, this.timeoutNormal);
        }
        catch (IOException e) {
            throw new FHIRException((Throwable)e);
        }
        if (result.isUnsuccessfulRequest()) {
            throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
        }
        return result.getPayload();
    }

    private void recordUse() {
        ++this.useCount;
    }

    public int getUseCount() {
        return this.useCount;
    }
}

