/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils.sql;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.PathEngineException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.fhirpath.ExpressionNode;
import org.hl7.fhir.r5.fhirpath.FHIRPathEngine;
import org.hl7.fhir.r5.fhirpath.FHIRPathUtilityClasses;
import org.hl7.fhir.r5.fhirpath.TypeDetails;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Base64BinaryType;
import org.hl7.fhir.r5.model.BaseDateTimeType;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.utils.sql.Cell;
import org.hl7.fhir.r5.utils.sql.Column;
import org.hl7.fhir.r5.utils.sql.Provider;
import org.hl7.fhir.r5.utils.sql.Storage;
import org.hl7.fhir.r5.utils.sql.Store;
import org.hl7.fhir.r5.utils.sql.Validator;
import org.hl7.fhir.r5.utils.sql.Value;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class Runner
implements FHIRPathEngine.IEvaluationContext {
    private IWorkerContext context;
    private Provider provider;
    private Storage storage;
    private List<String> prohibitedNames = new ArrayList<String>();
    private FHIRPathEngine fpe;
    private String resourceName;
    private List<ValidationMessage> issues;

    public IWorkerContext getContext() {
        return this.context;
    }

    public void setContext(IWorkerContext context) {
        this.context = context;
    }

    public Provider getProvider() {
        return this.provider;
    }

    public void setProvider(Provider provider) {
        this.provider = provider;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public void setStorage(Storage storage) {
        this.storage = storage;
    }

    public List<String> getProhibitedNames() {
        return this.prohibitedNames;
    }

    public void execute(JsonObject viewDefinition) {
        this.execute("$", viewDefinition);
    }

    public void execute(String path, JsonObject viewDefinition) {
        if (this.context == null) {
            throw new FHIRException("No context provided");
        }
        this.fpe = new FHIRPathEngine(this.context);
        this.fpe.setHostServices(this);
        this.fpe.setEmitSQLonFHIRWarning(true);
        if (viewDefinition == null) {
            throw new FHIRException("No viewDefinition provided");
        }
        if (this.provider == null) {
            throw new FHIRException("No provider provided");
        }
        if (this.storage == null) {
            throw new FHIRException("No storage provided");
        }
        Validator validator = new Validator(this.context, this.fpe, this.prohibitedNames, this.storage.supportsArrays(), this.storage.supportsComplexTypes(), this.storage.needsName());
        validator.checkViewDefinition(path, viewDefinition);
        this.issues = validator.getIssues();
        validator.dump();
        validator.check();
        this.resourceName = validator.getResourceName();
        this.evaluate(viewDefinition);
    }

    private void evaluate(JsonObject vd) {
        Store store = this.storage.createStore(vd.asString("name"), (List)vd.getUserData("columns"));
        List<Base> data = this.provider.fetch(this.resourceName);
        for (Base b : data) {
            boolean ok = true;
            for (JsonObject w : vd.getJsonObjects("where")) {
                String string = w.asString("path");
                ExpressionNode node = this.fpe.parse(string);
                boolean pass = this.fpe.evaluateToBoolean(null, b, b, b, node);
                if (pass) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            ArrayList<List<Cell>> rows = new ArrayList<List<Cell>>();
            rows.add(new ArrayList());
            for (JsonObject jsonObject : vd.getJsonObjects("select")) {
                this.executeSelect(jsonObject, b, rows);
            }
            for (List list : rows) {
                this.storage.addRow(store, list);
            }
        }
        this.storage.finish(store);
    }

    private void executeSelect(JsonObject select, Base b, List<List<Cell>> rows) {
        ArrayList<Base> focus = new ArrayList<Base>();
        if (select.has("forEach")) {
            focus.addAll(this.executeForEach(select, b));
        } else if (select.has("forEachOrNull")) {
            focus.addAll(this.executeForEachOrNull(select, b));
            if (focus.isEmpty()) {
                List columns = (List)select.getUserData("columns");
                for (List<Cell> row : rows) {
                    for (Column c : columns) {
                        Cell cell = this.cell(row, c.getName());
                        if (cell != null) continue;
                        row.add(new Cell(c, null));
                    }
                }
                return;
            }
        } else {
            focus.add(b);
        }
        ArrayList<List<Cell>> tempRows = new ArrayList<List<Cell>>();
        tempRows.addAll(rows);
        rows.clear();
        for (Base f : focus) {
            List<List<Cell>> rowsToAdd = this.cloneRows(tempRows);
            for (JsonObject column : select.getJsonObjects("column")) {
                this.executeColumn(column, f, rowsToAdd);
            }
            for (JsonObject sub : select.getJsonObjects("select")) {
                this.executeSelect(sub, f, rowsToAdd);
            }
            this.executeUnionAll(select.getJsonObjects("unionAll"), f, rowsToAdd);
            rows.addAll(rowsToAdd);
        }
    }

    private void executeUnionAll(List<JsonObject> unionList, Base b, List<List<Cell>> rows) {
        if (unionList.isEmpty()) {
            return;
        }
        ArrayList<List<Cell>> sourceRows = new ArrayList<List<Cell>>();
        sourceRows.addAll(rows);
        rows.clear();
        for (JsonObject union : unionList) {
            ArrayList<List<Cell>> tempRows = new ArrayList<List<Cell>>();
            tempRows.addAll(sourceRows);
            this.executeSelect(union, b, tempRows);
            rows.addAll(tempRows);
        }
    }

    private List<List<Cell>> cloneRows(List<List<Cell>> rows) {
        ArrayList<List<Cell>> list = new ArrayList<List<Cell>>();
        for (List<Cell> row : rows) {
            list.add(this.cloneRow(row));
        }
        return list;
    }

    private List<Cell> cloneRow(List<Cell> cells) {
        ArrayList<Cell> list = new ArrayList<Cell>();
        for (Cell cell : cells) {
            list.add(cell.copy());
        }
        return list;
    }

    private List<Base> executeForEach(JsonObject focus, Base b) {
        ExpressionNode n = (ExpressionNode)focus.getUserData("forEach");
        ArrayList<Base> result = new ArrayList<Base>();
        result.addAll(this.fpe.evaluate(b, n));
        return result;
    }

    private List<Base> executeForEachOrNull(JsonObject focus, Base b) {
        ExpressionNode n = (ExpressionNode)focus.getUserData("forEachOrNull");
        ArrayList<Base> result = new ArrayList<Base>();
        result.addAll(this.fpe.evaluate(b, n));
        return result;
    }

    private void executeColumn(JsonObject column, Base b, List<List<Cell>> rows) {
        Column col;
        ExpressionNode n = (ExpressionNode)column.getUserData("path");
        ArrayList<Base> bl2 = new ArrayList<Base>();
        if (b != null) {
            bl2.addAll(this.fpe.evaluate(b, n));
        }
        if ((col = (Column)column.getUserData("column")) == null) {
            System.out.println("Error");
        } else {
            for (List<Cell> row : rows) {
                Cell c = this.cell(row, col.getName());
                if (c == null) {
                    c = new Cell(col);
                    row.add(c);
                }
                if (bl2.isEmpty()) continue;
                if (bl2.size() + c.getValues().size() > 1 && !c.getColumn().isColl()) {
                    throw new FHIRException("The column " + c.getColumn().getName() + " is not allowed multiple values, but at least one row has multiple values");
                }
                for (Base b2 : bl2) {
                    c.getValues().add(this.genValue(c.getColumn(), b2));
                }
            }
        }
    }

    private Value genValue(Column column, Base b) {
        if (column.getKind() == null) {
            throw new FHIRException("Attempt to add a type " + b.fhirType() + " to an unknown column type (null) for column " + column.getName());
        }
        switch (column.getKind()) {
            case Binary: {
                if (b instanceof Base64BinaryType) {
                    Base64BinaryType bb = (Base64BinaryType)b;
                    return Value.makeBinary(bb.primitiveValue(), bb.getValue());
                }
                if (b.isBooleanPrimitive()) {
                    return Value.makeBinary(b.primitiveValue(), Base64.decodeBase64((String)b.primitiveValue()));
                }
                throw new FHIRException("Attempt to add a type " + b.fhirType() + " to a binary column for column " + column.getName());
            }
            case Boolean: {
                if (b instanceof BooleanType) {
                    BooleanType bb = (BooleanType)b;
                    return Value.makeBoolean(bb.primitiveValue(), bb.booleanValue());
                }
                if (b.isBooleanPrimitive()) {
                    return Value.makeBoolean(b.primitiveValue(), "true".equals(b.primitiveValue()));
                }
                throw new FHIRException("Attempt to add a type " + b.fhirType() + " to a boolean column for column " + column.getName());
            }
            case Complex: {
                if (b.isPrimitive()) {
                    throw new FHIRException("Attempt to add a primitive type " + b.fhirType() + " to a complex column for column " + column.getName());
                }
                return Value.makeComplex(b);
            }
            case DateTime: {
                if (b instanceof BaseDateTimeType) {
                    BaseDateTimeType d = (BaseDateTimeType)b;
                    return Value.makeDate(d.primitiveValue(), (Date)d.getValue());
                }
                if (b.isPrimitive() && b.isDateTime()) {
                    return Value.makeDate(b.primitiveValue(), (Date)b.dateTimeValue().getValue());
                }
                throw new FHIRException("Attempt to add a type " + b.fhirType() + " to an integer column for column " + column.getName());
            }
            case Decimal: {
                if (b instanceof DecimalType) {
                    DecimalType d = (DecimalType)b;
                    return Value.makeDecimal(d.primitiveValue(), (BigDecimal)d.getValue());
                }
                if (b.isPrimitive()) {
                    return Value.makeDecimal(b.primitiveValue(), new BigDecimal(b.primitiveValue()));
                }
                throw new FHIRException("Attempt to add a type " + b.fhirType() + " to an integer column for column " + column.getName());
            }
            case Integer: {
                if (b instanceof IntegerType) {
                    IntegerType i = (IntegerType)b;
                    return Value.makeInteger(i.primitiveValue(), (Integer)i.getValue());
                }
                if (b.isPrimitive()) {
                    return Value.makeInteger(b.primitiveValue(), Integer.valueOf(b.primitiveValue()));
                }
                throw new FHIRException("Attempt to add a type " + b.fhirType() + " to an integer column for column " + column.getName());
            }
            case String: {
                if (b.isPrimitive()) {
                    return Value.makeString(b.primitiveValue());
                }
                throw new FHIRException("Attempt to add a complex type " + b.fhirType() + " to a string column for column " + column.getName());
            }
            case Time: {
                if (b.fhirType().equals("time")) {
                    return Value.makeString(b.primitiveValue());
                }
                throw new FHIRException("Attempt to add a type " + b.fhirType() + " to a time column for column " + column.getName());
            }
        }
        throw new FHIRException("Attempt to add a type " + b.fhirType() + " to an unknown column type for column " + column.getName());
    }

    private Column column(String columnName, List<Column> columns) {
        for (Column t : columns) {
            if (!t.getName().equalsIgnoreCase(columnName)) continue;
            return t;
        }
        return null;
    }

    private Cell cell(List<Cell> cells, String columnName) {
        for (Cell t : cells) {
            if (!t.getColumn().getName().equalsIgnoreCase(columnName)) continue;
            return t;
        }
        return null;
    }

    @Override
    public List<Base> resolveConstant(FHIRPathEngine engine, Object appContext, String name, boolean beforeContext, boolean explicitConstant) throws PathEngineException {
        throw new Error("Not implemented yet: resolveConstant");
    }

    @Override
    public TypeDetails resolveConstantType(FHIRPathEngine engine, Object appContext, String name, boolean explicitConstant) throws PathEngineException {
        throw new Error("Not implemented yet: resolveConstantType");
    }

    @Override
    public boolean log(String argument, List<Base> focus) {
        throw new Error("Not implemented yet: log");
    }

    @Override
    public FHIRPathUtilityClasses.FunctionDetails resolveFunction(FHIRPathEngine engine, String functionName) {
        switch (functionName) {
            case "getResourceKey": {
                return new FHIRPathUtilityClasses.FunctionDetails("Unique Key for resource", 0, 0);
            }
            case "getReferenceKey": {
                return new FHIRPathUtilityClasses.FunctionDetails("Unique Key for resource that is the target of the reference", 0, 1);
            }
        }
        return null;
    }

    @Override
    public TypeDetails checkFunction(FHIRPathEngine engine, Object appContext, String functionName, TypeDetails focus, List<TypeDetails> parameters) throws PathEngineException {
        switch (functionName) {
            case "getResourceKey": {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "string");
            }
            case "getReferenceKey": {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "string");
            }
        }
        throw new Error("Not known: " + functionName);
    }

    @Override
    public List<Base> executeFunction(FHIRPathEngine engine, Object appContext, List<Base> focus, String functionName, List<List<Base>> parameters) {
        switch (functionName) {
            case "getResourceKey": {
                return this.executeResourceKey(focus);
            }
            case "getReferenceKey": {
                return this.executeReferenceKey(null, focus, parameters);
            }
        }
        throw new Error("Not known: " + functionName);
    }

    private List<Base> executeResourceKey(List<Base> focus) {
        ArrayList<Base> base = new ArrayList<Base>();
        if (focus.size() == 1) {
            Base res = focus.get(0);
            if (!res.hasUserData("Storage.key")) {
                String key = this.storage.getKeyForSourceResource(res);
                if (key == null) {
                    throw new FHIRException("Unidentified resource: " + res.fhirType() + "/" + res.getIdBase());
                }
                res.setUserData("Storage.key", key);
            }
            base.add(new StringType(res.getUserString("Storage.key")));
        }
        return base;
    }

    private List<Base> executeReferenceKey(Base rootResource, List<Base> focus, List<List<Base>> parameters) {
        String rt = null;
        if (parameters.size() > 0 && (rt = parameters.get(0).get(0).primitiveValue()).startsWith("FHIR.")) {
            rt = rt.substring(5);
        }
        ArrayList<Base> base = new ArrayList<Base>();
        if (focus.size() == 1) {
            Base target;
            Base res = focus.get(0);
            String ref = null;
            if (res.fhirType().equals("Reference")) {
                ref = this.getRef(res);
            } else if (res.isPrimitive()) {
                ref = res.primitiveValue();
            } else {
                throw new FHIRException("Unable to generate a reference key based on a " + res.fhirType());
            }
            if (ref != null && (target = this.provider.resolveReference(rootResource, ref, rt)) != null) {
                if (!res.hasUserData("Storage.key")) {
                    String key = this.storage.getKeyForTargetResource(target);
                    if (key == null) {
                        throw new FHIRException("Unidentified resource: " + res.fhirType() + "/" + res.getIdBase());
                    }
                    res.setUserData("Storage.key", key);
                }
                base.add(new StringType(res.getUserString("Storage.key")));
            }
        }
        return base;
    }

    private String getRef(Base res) {
        Property prop = res.getChildByName("reference");
        if (prop != null && prop.getValues().size() == 1) {
            return prop.getValues().get(0).primitiveValue();
        }
        return null;
    }

    @Override
    public Base resolveReference(FHIRPathEngine engine, Object appContext, String url, Base refContext) throws FHIRException {
        throw new Error("Not implemented yet: resolveReference");
    }

    @Override
    public boolean conformsToProfile(FHIRPathEngine engine, Object appContext, Base item, String url) throws FHIRException {
        throw new Error("Not implemented yet: conformsToProfile");
    }

    @Override
    public ValueSet resolveValueSet(FHIRPathEngine engine, Object appContext, String url) {
        throw new Error("Not implemented yet: resolveValueSet");
    }

    @Override
    public boolean paramIsType(String name, int index) {
        return "getReferenceKey".equals(name);
    }

    public List<ValidationMessage> getIssues() {
        return this.issues;
    }
}

