/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies.utilities;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.terminologies.utilities.TerminologyServiceErrorClass;
import org.hl7.fhir.utilities.validation.ValidationOptions;

public class TerminologyOperationContext {
    public static boolean debugging = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("-agentlib:jdwp") > 0;
    private static final int EXPANSION_DEAD_TIME_SECS = 60;
    private long deadTime;
    private List<String> contexts = new ArrayList<String>();
    private IWorkerContext worker;
    private boolean original;
    private ValidationOptions options;

    public TerminologyOperationContext(IWorkerContext worker, ValidationOptions options) {
        this.worker = worker;
        this.original = true;
        this.options = options;
        this.deadTime = debugging ? 0L : System.currentTimeMillis() + 60000L;
    }

    private TerminologyOperationContext(ValidationOptions options) {
        this.options = options;
    }

    public TerminologyOperationContext copy() {
        TerminologyOperationContext ret = new TerminologyOperationContext(this.options);
        ret.worker = this.worker;
        ret.contexts.addAll(this.contexts);
        ret.deadTime = this.deadTime;
        return ret;
    }

    public void deadCheck() {
        if (this.deadTime != 0L && System.currentTimeMillis() > this.deadTime) {
            throw new TerminologyServiceProtectionException(this.worker.formatMessage("VALUESET_TOO_COSTLY_TIME", this.contexts.get(0), 60), TerminologyServiceErrorClass.TOO_COSTLY, OperationOutcome.IssueType.TOOCOSTLY);
        }
    }

    public void seeContext(String context) {
        if (this.contexts.contains(context)) {
            throw new TerminologyServiceProtectionException(this.worker.formatMessage("VALUESET_CIRCULAR_REFERENCE", context, this.contexts.toString()), TerminologyServiceErrorClass.PROCESSING, OperationOutcome.IssueType.PROCESSING);
        }
        this.contexts.add(context);
    }

    public boolean isOriginal() {
        return this.original;
    }

    public ValidationOptions getOptions() {
        return this.options;
    }

    public static class TerminologyServiceProtectionException
    extends FHIRException {
        private TerminologyServiceErrorClass error;
        private OperationOutcome.IssueType type;

        public TerminologyServiceProtectionException(String message, TerminologyServiceErrorClass error, OperationOutcome.IssueType type) {
            super(message);
            this.error = error;
            this.type = type;
        }

        public TerminologyServiceErrorClass getError() {
            return this.error;
        }

        public OperationOutcome.IssueType getType() {
            return this.type;
        }
    }
}

