/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils.client;

import org.hl7.fhir.r5.model.OperationOutcome;

public class EFhirClientException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private OperationOutcome error = null;

    public EFhirClientException(String message) {
        super(message);
    }

    public EFhirClientException(Exception cause) {
        super(cause);
    }

    public EFhirClientException(String message, Exception cause) {
        super(message, cause);
    }

    public EFhirClientException(String message, OperationOutcome serverError) {
        super(message);
        this.error = serverError;
    }

    public EFhirClientException(String message, OperationOutcome serverError, Exception cause) {
        super(message, cause);
        this.error = serverError;
    }

    public EFhirClientException(OperationOutcome serverError) {
        super("Error on the server: " + serverError.getText().getDiv().allText() + ". Refer to e.getServerErrors() for additional details.");
        this.error = serverError;
    }

    public OperationOutcome getServerError() {
        return this.error;
    }

    public boolean hasServerError() {
        return this.error != null;
    }
}

