/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.terminologies.utilities.TerminologyServiceErrorClass;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;

public class ValidationProcessInfo {
    private TerminologyServiceErrorClass err;
    private List<OperationOutcome.OperationOutcomeIssueComponent> issues = new ArrayList<OperationOutcome.OperationOutcomeIssueComponent>();

    public ValidationProcessInfo() {
    }

    public ValidationProcessInfo(List<OperationOutcome.OperationOutcomeIssueComponent> issues) {
        this.issues = issues;
    }

    public TerminologyServiceErrorClass getErr() {
        return this.err;
    }

    public void setErr(TerminologyServiceErrorClass err) {
        this.err = err;
    }

    public List<OperationOutcome.OperationOutcomeIssueComponent> getIssues() {
        return this.issues;
    }

    public void addIssue(List<OperationOutcome.OperationOutcomeIssueComponent> issues) {
        this.issues.addAll(issues);
    }

    public boolean hasErrors() {
        for (OperationOutcome.OperationOutcomeIssueComponent issue : this.issues) {
            if (issue.getSeverity() != OperationOutcome.IssueSeverity.FATAL && issue.getSeverity() != OperationOutcome.IssueSeverity.ERROR) continue;
            return true;
        }
        return false;
    }

    public String summary() {
        ArrayList<String> msgs = new ArrayList<String>();
        for (OperationOutcome.OperationOutcomeIssueComponent issue : this.issues) {
            msgs.add(issue.getDetails().getText());
        }
        Collections.sort(msgs);
        return CommaSeparatedStringBuilder.join((String)"; ", msgs);
    }

    public List<String> summaryList() {
        ArrayList<String> msgs = new ArrayList<String>();
        for (OperationOutcome.OperationOutcomeIssueComponent issue : this.issues) {
            msgs.add(issue.getDetails().getText());
        }
        Collections.sort(msgs);
        return msgs;
    }

    public boolean hasMessage(String msg) {
        for (OperationOutcome.OperationOutcomeIssueComponent iss : this.issues) {
            if (!msg.equals(iss.getDetails().getText())) continue;
            return true;
        }
        return false;
    }

    public boolean hasNotFound(String system) {
        for (OperationOutcome.OperationOutcomeIssueComponent iss : this.issues) {
            if (!iss.getDetails().hasCoding("http://hl7.org/fhir/tools/CodeSystem/tx-issue-type", "not-found") || !iss.getDetails().hasText() || !iss.getDetails().getText().contains(system)) continue;
            return true;
        }
        return false;
    }
}

