/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils.client.network;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import org.hl7.fhir.utilities.ToolingClientLogger;

public class FhirLoggingInterceptor
implements Interceptor {
    private ToolingClientLogger logger;

    public FhirLoggingInterceptor(ToolingClientLogger logger) {
        this.logger = logger;
    }

    public FhirLoggingInterceptor setLogger(ToolingClientLogger logger) {
        this.logger = logger;
        return this;
    }

    public Response intercept(@Nonnull Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        ArrayList<String> hdrs = new ArrayList<String>();
        for (String s : request.headers().toString().split("\\n")) {
            hdrs.add(s.trim());
        }
        byte[] cnt = null;
        if (request.body() != null) {
            Buffer buf = new Buffer();
            request.body().writeTo((BufferedSink)buf);
            cnt = buf.readByteArray();
        }
        if (this.logger != null) {
            this.logger.logRequest(request.method(), request.url().toString(), hdrs, cnt);
        }
        Response response = null;
        response = chain.proceed(chain.request());
        MediaType contentType = null;
        byte[] bodyBytes = null;
        if (response.body() != null) {
            contentType = response.body().contentType();
            bodyBytes = response.body().bytes();
        }
        ArrayList headerList = new ArrayList();
        Map headerMap = response.headers().toMultimap();
        headerMap.keySet().forEach(key -> ((List)headerMap.get(key)).forEach(value -> headerList.add(key + ":" + value)));
        if (this.logger != null) {
            this.logger.logResponse(Integer.toString(response.code()), headerList, bodyBytes);
        }
        ResponseBody body = ResponseBody.create((byte[])bodyBytes, (MediaType)contentType);
        return response.newBuilder().body(body).build();
    }
}

