/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.profilemodel;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.r5.conformance.profile.ProfileUtilities;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.profilemodel.PEBuilder;
import org.hl7.fhir.r5.profilemodel.PEDefinition;
import org.hl7.fhir.r5.profilemodel.PEType;

public class PEDefinitionExtension
extends PEDefinition {
    private StructureDefinition extension;
    private ElementDefinition sliceDefinition;
    private ElementDefinition eed;
    private ElementDefinition ved;

    public PEDefinitionExtension(PEBuilder builder, String name, StructureDefinition profile, ElementDefinition definition, ElementDefinition sliceDefinition, StructureDefinition extension, String ppath) {
        super(builder, name, profile, definition, ppath);
        this.sliceDefinition = sliceDefinition;
        this.extension = extension;
        this.eed = extension.getSnapshot().getElementByPath("Extension.extension");
        this.ved = extension.getSnapshot().getElementByPath("Extension.value[x]");
    }

    @Override
    public void listTypes(List<PEType> types) {
        if (this.ved.isRequired() || this.eed.isProhibited()) {
            for (ElementDefinition.TypeRefComponent t : this.ved.getType()) {
                if (t.hasProfile()) {
                    for (CanonicalType u : t.getProfile()) {
                        types.add(this.builder.makeType(t, u));
                    }
                    continue;
                }
                types.add(this.builder.makeType(t.getWorkingCode()));
            }
        } else if (ProfileUtilities.isComplexExtension(this.extension)) {
            types.add(this.builder.makeType(this.extension.getName(), this.extension.getUrl()));
        } else {
            types.add(this.builder.makeType("Extension"));
        }
    }

    @Override
    protected void makeChildren(String typeUrl, List<PEDefinition> children, boolean allFixed) {
        if (this.ved.isRequired() || this.eed.isProhibited()) {
            children.addAll(this.builder.listChildren(allFixed, this, this.extension, this.ved, typeUrl, new String[0]));
        } else {
            List<PEDefinition> slices = this.builder.listSlices(this.extension, this.eed, this);
            if (this.eed.getSlicing().getRules() != ElementDefinition.SlicingRules.CLOSED) {
                children.addAll(this.builder.listChildren(allFixed, this, this.extension, this.eed, "http://hl7.org/fhir/StructureDefinition/Extension", "value[x]", "url"));
                if (!children.isEmpty()) {
                    children.get(0).setSlices(slices);
                }
            }
            children.addAll(slices);
        }
    }

    @Override
    public String fhirpath() {
        if (this.ved.isRequired() || this.eed.isProhibited()) {
            return "extension('" + this.extension.getUrl() + "').value";
        }
        return "extension('" + this.extension.getUrl() + "')";
    }

    @Override
    public PEDefinition.PEDefinitionElementMode mode() {
        return PEDefinition.PEDefinitionElementMode.Extension;
    }

    @Override
    public List<PEDefinition> directChildren(boolean allFixed) {
        ArrayList<PEDefinition> children = new ArrayList<PEDefinition>();
        children.addAll(this.builder.listChildren(allFixed, this, this.extension, this.extension.getSnapshot().getElementFirstRep(), "http://hl7.org/fhir/StructureDefinition/Extension", new String[0]));
        return children;
    }

    @Override
    public boolean isExtension() {
        return true;
    }
}

