/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers.utils;

import java.io.IOException;
import java.text.NumberFormat;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.conformance.profile.ProfileKnowledgeProvider;
import org.hl7.fhir.r5.conformance.profile.ProfileUtilities;
import org.hl7.fhir.r5.context.ContextUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.fhirpath.FHIRPathEngine;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.renderers.utils.Resolver;
import org.hl7.fhir.r5.renderers.utils.ResourceWrapper;
import org.hl7.fhir.r5.terminologies.utilities.ValidationResult;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.utilities.FhirPublication;
import org.hl7.fhir.utilities.MarkDownProcessor;
import org.hl7.fhir.utilities.StandardsStatus;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.i18n.RenderingI18nContext;
import org.hl7.fhir.utilities.validation.ValidationOptions;

public class RenderingContext
extends RenderingI18nContext {
    private IWorkerContext worker;
    private MarkDownProcessor markdown;
    private ResourceRendererMode mode;
    private GenerationRules rules;
    private Resolver.IReferenceResolver resolver;
    private ILiquidTemplateProvider templateProvider;
    private FHIRPathEngine.IEvaluationContext services;
    private ITypeParser parser;
    private boolean secondaryLang;
    private MultiLanguagePolicy multiLanguagePolicy = MultiLanguagePolicy.NONE;
    private Set<String> allowedLanguages = new HashSet<String>();
    private ZoneId timeZoneId;
    private DateTimeFormatter dateTimeFormat;
    private DateTimeFormatter dateFormat;
    private DateTimeFormatter dateYearFormat;
    private DateTimeFormatter dateYearMonthFormat;
    private String localPrefix;
    private int headerLevelContext;
    private boolean canonicalUrlsAsLinks;
    private boolean pretty;
    private boolean showSummaryTable;
    private boolean contained;
    private ValidationOptions terminologyServiceOptions = new ValidationOptions(FhirPublication.R5);
    private boolean noSlowLookup;
    private List<String> codeSystemPropList = new ArrayList<String>();
    private ProfileUtilities profileUtilitiesR;
    private ContextUtilities contextUtilities;
    private String definitionsTarget;
    private String destDir;
    private boolean inlineGraphics;
    private StandardsStatus defaultStandardsStatus;
    private ExampleScenarioRendererMode scenarioMode = null;
    private QuestionnaireRendererMode questionnaireMode = QuestionnaireRendererMode.FORM;
    private StructureDefinitionRendererMode structureMode = StructureDefinitionRendererMode.SUMMARY;
    private FixedValueFormat fixedFormat = FixedValueFormat.JSON;
    private boolean showComments = false;
    private FhirPublication targetVersion;
    private boolean copyButton;
    private ProfileKnowledgeProvider pkp;
    private String changeVersion;
    private List<String> files = new ArrayList<String>();
    private Map<KnownLinkType, String> links = new HashMap<KnownLinkType, String>();
    private Map<String, String> namedLinks = new HashMap<String, String>();
    private boolean addName = false;
    private Map<String, String> typeMap = new HashMap<String, String>();
    private int base64Limit = 1024;
    private boolean shortPatientForm;
    private String uniqueLocalPrefix;
    private Set<String> anchors = new HashSet<String>();
    private boolean unknownLocalReferencesNotLinks;

    public RenderingContext(IWorkerContext worker, MarkDownProcessor markdown, ValidationOptions terminologyServiceOptions, String specLink, String localPrefix, Locale locale, ResourceRendererMode mode, GenerationRules rules) {
        this.worker = worker;
        this.markdown = markdown;
        this.locale = locale;
        this.links.put(KnownLinkType.SPEC, specLink);
        this.localPrefix = localPrefix;
        this.mode = mode;
        this.rules = rules;
        if (terminologyServiceOptions != null) {
            this.terminologyServiceOptions = terminologyServiceOptions;
        }
    }

    public RenderingContext copy(boolean copyAnchors) {
        RenderingContext res = new RenderingContext(this.worker, this.markdown, this.terminologyServiceOptions, this.getLink(KnownLinkType.SPEC), this.localPrefix, this.locale, this.mode, this.rules);
        res.resolver = this.resolver;
        res.templateProvider = this.templateProvider;
        res.services = this.services;
        res.parser = this.parser;
        res.headerLevelContext = this.headerLevelContext;
        res.canonicalUrlsAsLinks = this.canonicalUrlsAsLinks;
        res.pretty = this.pretty;
        res.contained = this.contained;
        res.noSlowLookup = this.noSlowLookup;
        res.codeSystemPropList.addAll(this.codeSystemPropList);
        res.profileUtilitiesR = this.profileUtilitiesR;
        res.contextUtilities = this.contextUtilities;
        res.definitionsTarget = this.definitionsTarget;
        res.destDir = this.destDir;
        res.scenarioMode = this.scenarioMode;
        res.questionnaireMode = this.questionnaireMode;
        res.structureMode = this.structureMode;
        res.showSummaryTable = this.showSummaryTable;
        res.links.putAll(this.links);
        res.inlineGraphics = this.inlineGraphics;
        res.timeZoneId = this.timeZoneId;
        res.dateTimeFormat = this.dateTimeFormat;
        res.dateFormat = this.dateFormat;
        res.dateYearFormat = this.dateYearFormat;
        res.dateYearMonthFormat = this.dateYearMonthFormat;
        res.targetVersion = this.targetVersion;
        res.showComments = this.showComments;
        res.copyButton = this.copyButton;
        res.pkp = this.pkp;
        res.defaultStandardsStatus = this.defaultStandardsStatus;
        res.changeVersion = this.changeVersion;
        res.terminologyServiceOptions = this.terminologyServiceOptions.copy();
        res.typeMap.putAll(this.typeMap);
        res.multiLanguagePolicy = this.multiLanguagePolicy;
        res.allowedLanguages.addAll(this.allowedLanguages);
        if (copyAnchors) {
            res.anchors = this.anchors;
        }
        res.unknownLocalReferencesNotLinks = this.unknownLocalReferencesNotLinks;
        return res;
    }

    public IWorkerContext getContext() {
        return this.worker;
    }

    public ProfileUtilities getProfileUtilities() {
        if (this.profileUtilitiesR == null) {
            this.profileUtilitiesR = new ProfileUtilities(this.worker, null, this.pkp);
        }
        return this.profileUtilitiesR;
    }

    public IWorkerContext getWorker() {
        return this.worker;
    }

    public boolean isCanonicalUrlsAsLinks() {
        return this.canonicalUrlsAsLinks;
    }

    public RenderingContext setCanonicalUrlsAsLinks(boolean canonicalUrlsAsLinks) {
        this.canonicalUrlsAsLinks = canonicalUrlsAsLinks;
        return this;
    }

    public MarkDownProcessor getMarkdown() {
        if (this.markdown == null) {
            this.markdown = new MarkDownProcessor(MarkDownProcessor.Dialect.COMMON_MARK);
        }
        return this.markdown;
    }

    public MultiLanguagePolicy getMultiLanguagePolicy() {
        return this.multiLanguagePolicy;
    }

    public void setMultiLanguagePolicy(MultiLanguagePolicy multiLanguagePolicy) {
        this.multiLanguagePolicy = multiLanguagePolicy;
    }

    public Set<String> getAllowedLanguages() {
        return this.allowedLanguages;
    }

    public String getLocalPrefix() {
        return this.localPrefix;
    }

    public ValidationOptions getTerminologyServiceOptions() {
        return this.terminologyServiceOptions;
    }

    public int getHeaderLevelContext() {
        return this.headerLevelContext;
    }

    public RenderingContext setHeaderLevelContext(int headerLevelContext) {
        this.headerLevelContext = headerLevelContext;
        return this;
    }

    public Resolver.IReferenceResolver getResolver() {
        return this.resolver;
    }

    public RenderingContext setResolver(Resolver.IReferenceResolver resolver) {
        this.resolver = resolver;
        return this;
    }

    public RenderingContext setTerminologyServiceOptions(ValidationOptions terminologyServiceOptions) {
        this.terminologyServiceOptions = terminologyServiceOptions;
        return this;
    }

    public boolean isNoSlowLookup() {
        return this.noSlowLookup;
    }

    public RenderingContext setNoSlowLookup(boolean noSlowLookup) {
        this.noSlowLookup = noSlowLookup;
        return this;
    }

    public String getDefinitionsTarget() {
        return this.definitionsTarget;
    }

    public RenderingContext setDefinitionsTarget(String definitionsTarget) {
        this.definitionsTarget = definitionsTarget;
        return this;
    }

    public String getDestDir() {
        return this.destDir;
    }

    public RenderingContext setDestDir(String destDir) {
        this.destDir = destDir;
        return this;
    }

    public RenderingContext setProfileUtilities(ProfileUtilities profileUtilities) {
        this.profileUtilitiesR = profileUtilities;
        if (this.pkp == null && profileUtilities.getPkp() != null) {
            this.pkp = profileUtilities.getPkp();
        }
        return this;
    }

    public ILiquidTemplateProvider getTemplateProvider() {
        return this.templateProvider;
    }

    public RenderingContext setTemplateProvider(ILiquidTemplateProvider templateProvider) {
        this.templateProvider = templateProvider;
        return this;
    }

    public FHIRPathEngine.IEvaluationContext getServices() {
        return this.services;
    }

    public RenderingContext setServices(FHIRPathEngine.IEvaluationContext services) {
        this.services = services;
        return this;
    }

    public boolean isPretty() {
        return this.pretty;
    }

    public RenderingContext setPretty(boolean pretty) {
        this.pretty = pretty;
        return this;
    }

    public ITypeParser getParser() {
        return this.parser;
    }

    public RenderingContext setParser(ITypeParser parser) {
        this.parser = parser;
        return this;
    }

    public List<String> getCodeSystemPropList() {
        return this.codeSystemPropList;
    }

    public RenderingContext setCodeSystemPropList(List<String> codeSystemPropList) {
        this.codeSystemPropList = codeSystemPropList;
        return this;
    }

    public boolean isInlineGraphics() {
        return this.inlineGraphics;
    }

    public RenderingContext setInlineGraphics(boolean inlineGraphics) {
        this.inlineGraphics = inlineGraphics;
        return this;
    }

    public boolean isShowSummaryTable() {
        return this.showSummaryTable;
    }

    public RenderingContext setShowSummaryTable(boolean header) {
        this.showSummaryTable = header;
        return this;
    }

    public ExampleScenarioRendererMode getScenarioMode() {
        return this.scenarioMode;
    }

    public RenderingContext setScenarioMode(ExampleScenarioRendererMode scenarioMode) {
        this.scenarioMode = scenarioMode;
        return this;
    }

    public QuestionnaireRendererMode getQuestionnaireMode() {
        return this.questionnaireMode;
    }

    public RenderingContext setQuestionnaireMode(QuestionnaireRendererMode questionnaireMode) {
        this.questionnaireMode = questionnaireMode;
        return this;
    }

    public StructureDefinitionRendererMode getStructureMode() {
        return this.structureMode;
    }

    public RenderingContext setStructureMode(StructureDefinitionRendererMode structureMode) {
        this.structureMode = structureMode;
        return this;
    }

    public String fixReference(String ref) {
        if (ref == null) {
            return null;
        }
        if (!Utilities.isAbsoluteUrl((String)ref)) {
            return (this.localPrefix == null ? "" : this.localPrefix) + ref;
        }
        if (ref.startsWith("http://hl7.org/fhir") && !ref.substring(20).contains("/")) {
            return this.getLink(KnownLinkType.SPEC) + ref.substring(20);
        }
        return ref;
    }

    public RenderingContext setLocalPrefix(String localPrefix) {
        this.localPrefix = localPrefix;
        return this;
    }

    public FhirPublication getTargetVersion() {
        return this.targetVersion;
    }

    public RenderingContext setTargetVersion(FhirPublication targetVersion) {
        this.targetVersion = targetVersion;
        return this;
    }

    public boolean isTechnicalMode() {
        return this.mode == ResourceRendererMode.TECHNICAL;
    }

    public ZoneId getTimeZoneId() {
        return this.timeZoneId;
    }

    public RenderingContext setTimeZoneId(ZoneId timeZoneId) {
        this.timeZoneId = timeZoneId;
        return this;
    }

    public DateTimeFormatter getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public RenderingContext setDateTimeFormat(DateTimeFormatter dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
        return this;
    }

    public RenderingContext setDateTimeFormatString(String dateTimeFormat) {
        this.dateTimeFormat = DateTimeFormatter.ofPattern(dateTimeFormat);
        return this;
    }

    public DateTimeFormatter getDateFormat() {
        return this.dateFormat;
    }

    public RenderingContext setDateFormat(DateTimeFormatter dateFormat) {
        this.dateFormat = dateFormat;
        return this;
    }

    public RenderingContext setDateFormatString(String dateFormat) {
        this.dateFormat = DateTimeFormatter.ofPattern(dateFormat);
        return this;
    }

    public DateTimeFormatter getDateYearFormat() {
        return this.dateYearFormat;
    }

    public RenderingContext setDateYearFormat(DateTimeFormatter dateYearFormat) {
        this.dateYearFormat = dateYearFormat;
        return this;
    }

    public RenderingContext setDateYearFormatString(String dateYearFormat) {
        this.dateYearFormat = DateTimeFormatter.ofPattern(dateYearFormat);
        return this;
    }

    public DateTimeFormatter getDateYearMonthFormat() {
        return this.dateYearMonthFormat;
    }

    public RenderingContext setDateYearMonthFormat(DateTimeFormatter dateYearMonthFormat) {
        this.dateYearMonthFormat = dateYearMonthFormat;
        return this;
    }

    public RenderingContext setDateYearMonthFormatString(String dateYearMonthFormat) {
        this.dateYearMonthFormat = DateTimeFormatter.ofPattern(dateYearMonthFormat);
        return this;
    }

    public ResourceRendererMode getMode() {
        return this.mode;
    }

    public RenderingContext setMode(ResourceRendererMode mode) {
        this.mode = mode;
        return this;
    }

    public boolean isContained() {
        return this.contained;
    }

    public RenderingContext setContained(boolean contained) {
        this.contained = contained;
        return this;
    }

    public boolean isShowComments() {
        return this.showComments;
    }

    public RenderingContext setShowComments(boolean showComments) {
        this.showComments = showComments;
        return this;
    }

    public boolean isCopyButton() {
        return this.copyButton;
    }

    public RenderingContext setCopyButton(boolean copyButton) {
        this.copyButton = copyButton;
        return this;
    }

    public RenderingContext setPkp(ProfileKnowledgeProvider pkp) {
        this.pkp = pkp;
        return this;
    }

    public ProfileKnowledgeProvider getPkp() {
        return this.pkp;
    }

    public boolean hasLink(KnownLinkType link) {
        return this.links.containsKey((Object)link);
    }

    public String getLink(KnownLinkType link) {
        return this.links.get((Object)link);
    }

    public void addLink(KnownLinkType type, String link) {
        this.links.put(type, link);
    }

    public GenerationRules getRules() {
        return this.rules;
    }

    public RenderingContext setRules(GenerationRules rules) {
        this.rules = rules;
        return this;
    }

    public StandardsStatus getDefaultStandardsStatus() {
        return this.defaultStandardsStatus;
    }

    public RenderingContext setDefaultStandardsStatus(StandardsStatus defaultStandardsStatus) {
        this.defaultStandardsStatus = defaultStandardsStatus;
        return this;
    }

    public String getChangeVersion() {
        return this.changeVersion;
    }

    public RenderingContext setChangeVersion(String changeVersion) {
        this.changeVersion = changeVersion;
        return this;
    }

    public Map<String, String> getNamedLinks() {
        return this.namedLinks;
    }

    public void registerFile(String n) {
        try {
            this.files.add(Utilities.path((String[])new String[]{this.destDir, n}));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public List<String> getFiles() {
        return this.files;
    }

    public FixedValueFormat getFixedFormat() {
        return this.fixedFormat;
    }

    public void setFixedFormat(FixedValueFormat fixedFormat) {
        this.fixedFormat = fixedFormat;
    }

    public boolean isAddName() {
        return this.addName;
    }

    public RenderingContext setAddName(boolean addName) {
        this.addName = addName;
        return this;
    }

    public Map<String, String> getTypeMap() {
        return this.typeMap;
    }

    public String toStr(int v) {
        NumberFormat nf = NumberFormat.getInstance(this.locale);
        return nf.format(v);
    }

    public String getTranslated(PrimitiveType<?> t) {
        String v;
        if (this.locale != null && (v = ToolingExtensions.getLanguageTranslation(t, this.locale.toString())) != null) {
            return v;
        }
        return t.asStringValue();
    }

    public String getTranslated(ResourceWrapper t) {
        if (t == null) {
            return null;
        }
        if (this.locale != null) {
            for (ResourceWrapper e : t.extensions("http://hl7.org/fhir/StructureDefinition/translation")) {
                String v;
                String l = e.extensionString("lang");
                if (l == null || !l.equals(this.locale.toString()) || (v = e.extensionString("content")) == null) continue;
                return v;
            }
        }
        return t.primitiveValue();
    }

    public StringType getTranslatedElement(PrimitiveType<?> t) {
        StringType v;
        if (this.locale != null && (v = ToolingExtensions.getLanguageTranslationElement(t, this.locale.toString())) != null) {
            return v;
        }
        if (t instanceof StringType) {
            return (StringType)t;
        }
        return new StringType(t.asStringValue());
    }

    public String getTranslatedCode(Base b, String codeSystem) {
        if (b instanceof Element) {
            Element e = (Element)b;
            if (this.locale != null) {
                String v = ToolingExtensions.getLanguageTranslation(e, this.locale.toString());
                if (v != null) {
                    return v;
                }
                try {
                    ValidationResult t = this.getContext().validateCode(this.getTerminologyServiceOptions().withLanguage(this.locale.toString()).withVersionFlexible(true), codeSystem, null, e.primitiveValue(), null);
                    if (t.isOk() && t.getDisplay() != null) {
                        return t.getDisplay();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (e instanceof Enumeration) {
                return ((Enumeration)e).getDisplay();
            }
            return e.primitiveValue();
        }
        if (b instanceof org.hl7.fhir.r5.elementmodel.Element) {
            return this.getTranslatedCode((org.hl7.fhir.r5.elementmodel.Element)b, codeSystem);
        }
        return "??";
    }

    public String getTranslatedCode(String code, String codeSystem) {
        if (this.locale != null) {
            try {
                ValidationResult t = this.getContext().validateCode(this.getTerminologyServiceOptions().withLanguage(this.locale.toString()).withVersionFlexible(true), codeSystem, null, code, null);
                if (t.isOk() && t.getDisplay() != null) {
                    return t.getDisplay();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return code;
    }

    public String getTranslatedCode(Enumeration<?> e, String codeSystem) {
        if (this.locale != null) {
            String v = ToolingExtensions.getLanguageTranslation(e, this.locale.toString());
            if (v != null) {
                return v;
            }
            try {
                ValidationResult t = this.getContext().validateCode(this.getTerminologyServiceOptions().withLanguage(this.locale.toString()).withVersionFlexible(true), codeSystem, null, e.getCode(), null);
                if (t.isOk() && t.getDisplay() != null) {
                    return t.getDisplay();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            ValidationResult t = this.getContext().validateCode(this.getTerminologyServiceOptions().withVersionFlexible(true), codeSystem, null, e.getCode(), null);
            if (t.isOk() && t.getDisplay() != null) {
                return t.getDisplay();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return e.getCode();
    }

    public String getTranslatedCode(org.hl7.fhir.r5.elementmodel.Element e, String codeSystem) {
        if (this.locale != null) {
            for (org.hl7.fhir.r5.elementmodel.Element ext : e.getChildrenByName("extension")) {
                Base e1;
                String url = ext.getNamedChildValue("url");
                if (!url.equals("http://hl7.org/fhir/StructureDefinition/translation") || (e1 = ext.getExtensionValue("lang")) == null || e1.primitiveValue() == null || !e1.primitiveValue().equals(this.locale.toString()) || (e1 = ext.getExtensionValue("content")) == null || !e1.isPrimitive()) continue;
                return e1.primitiveValue();
            }
            try {
                ValidationResult t = this.getContext().validateCode(this.getTerminologyServiceOptions().withLanguage(this.locale.toString()).withVersionFlexible(true), codeSystem, null, e.primitiveValue(), null);
                if (t.isOk() && t.getDisplay() != null) {
                    return t.getDisplay();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return e.primitiveValue();
    }

    public RenderingContext withLocale(Locale locale) {
        this.setLocale(locale);
        return this;
    }

    public RenderingContext withLocaleCode(String locale) {
        this.setLocale(new Locale(locale));
        return this;
    }

    public ContextUtilities getContextUtilities() {
        if (this.contextUtilities == null) {
            this.contextUtilities = new ContextUtilities(this.worker);
        }
        return this.contextUtilities;
    }

    public int getBase64Limit() {
        return this.base64Limit;
    }

    public void setBase64Limit(int base64Limit) {
        this.base64Limit = base64Limit;
    }

    public boolean isShortPatientForm() {
        return this.shortPatientForm;
    }

    public void setShortPatientForm(boolean shortPatientForm) {
        this.shortPatientForm = shortPatientForm;
    }

    public boolean isSecondaryLang() {
        return this.secondaryLang;
    }

    public void setSecondaryLang(boolean secondaryLang) {
        this.secondaryLang = secondaryLang;
    }

    public String prefixAnchor(String anchor) {
        return this.uniqueLocalPrefix == null ? anchor : this.uniqueLocalPrefix + "-" + anchor;
    }

    public String prefixLocalHref(String url) {
        if (url == null || this.uniqueLocalPrefix == null || !url.startsWith("#")) {
            return url;
        }
        return "#" + this.uniqueLocalPrefix + "-" + url.substring(1);
    }

    public String getUniqueLocalPrefix() {
        return this.uniqueLocalPrefix;
    }

    public void setUniqueLocalPrefix(String uniqueLocalPrefix) {
        this.uniqueLocalPrefix = uniqueLocalPrefix;
    }

    public RenderingContext withUniqueLocalPrefix(String uniqueLocalPrefix) {
        RenderingContext self = this.copy(true);
        self.uniqueLocalPrefix = uniqueLocalPrefix;
        return self;
    }

    public RenderingContext forContained() {
        RenderingContext self = this.copy(true);
        self.contained = true;
        return self;
    }

    public boolean hasAnchor(String anchor) {
        return this.anchors.contains(anchor);
    }

    public void addAnchor(String anchor) {
        this.anchors.add(anchor);
    }

    public Set<String> getAnchors() {
        return this.anchors;
    }

    public void clearAnchors() {
        this.anchors.clear();
    }

    public boolean isUnknownLocalReferencesNotLinks() {
        return this.unknownLocalReferencesNotLinks;
    }

    public void setUnknownLocalReferencesNotLinks(boolean unknownLocalReferencesNotLinks) {
        this.unknownLocalReferencesNotLinks = unknownLocalReferencesNotLinks;
    }

    public static enum MultiLanguagePolicy {
        NONE,
        DESIGNATIONS,
        ALL;

    }

    public static enum FixedValueFormat {
        JSON,
        JSON_ALL,
        XML,
        XML_ALL;


        public static FixedValueFormat fromCode(String value) {
            if (value == null) {
                return JSON;
            }
            switch (value.toLowerCase()) {
                case "json": {
                    return JSON;
                }
                case "json-all": {
                    return JSON_ALL;
                }
                case "xml": {
                    return XML;
                }
                case "xml-all": {
                    return XML_ALL;
                }
            }
            return JSON;
        }

        public boolean notPrimitives() {
            return this == JSON || this == XML;
        }

        public boolean isXml() {
            return this == XML_ALL || this == XML;
        }
    }

    public static enum KnownLinkType {
        SELF,
        SPEC,
        JSON_NAMES;

    }

    public static enum QuestionnaireRendererMode {
        FORM,
        TREE,
        LOGIC,
        DEFNS,
        LINKS;

    }

    public static enum ExampleScenarioRendererMode {
        ACTORS,
        INSTANCES,
        PROCESSES,
        DIAGRAM;

    }

    public static enum StructureDefinitionRendererMode {
        SUMMARY,
        BINDINGS,
        OBLIGATIONS,
        DATA_DICT;

    }

    public static enum GenerationRules {
        VALID_RESOURCE,
        IG_PUBLISHER;

    }

    public static enum ResourceRendererMode {
        END_USER,
        TECHNICAL;

    }

    public static interface ITypeParser {
        public Base parseType(String var1, String var2) throws FHIRFormatError, IOException, FHIRException;

        public Base parseType(org.hl7.fhir.r5.elementmodel.Element var1) throws FHIRFormatError, IOException, FHIRException;
    }

    public static interface ILiquidTemplateProvider {
        public String findTemplate(RenderingContext var1, DomainResource var2);

        public String findTemplate(RenderingContext var1, String var2);
    }
}

