/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies.expansion;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.ValueSetUtilities;
import org.hl7.fhir.r5.terminologies.utilities.TerminologyServiceErrorClass;

public class ValueSetExpansionOutcome {
    private ValueSet valueset;
    private String error;
    private TerminologyServiceErrorClass errorClass;
    private String txLink;
    private List<String> allErrors = new ArrayList<String>();
    private boolean fromServer;

    public ValueSetExpansionOutcome(ValueSet valueset) {
        this.valueset = valueset;
        this.error = null;
    }

    public ValueSetExpansionOutcome(ValueSet valueset, String error, TerminologyServiceErrorClass errorClass, boolean fromServer) {
        this.valueset = valueset;
        this.error = error;
        this.errorClass = errorClass;
        this.fromServer = fromServer;
        this.allErrors.add(error);
    }

    public ValueSetExpansionOutcome(String error, TerminologyServiceErrorClass errorClass, boolean fromServer) {
        this.valueset = null;
        this.error = error;
        this.errorClass = errorClass;
        this.fromServer = fromServer;
        this.allErrors.add(error);
    }

    public ValueSetExpansionOutcome(String error, TerminologyServiceErrorClass errorClass, List<String> errList, boolean fromServer) {
        this.valueset = null;
        this.error = error;
        this.errorClass = errorClass;
        this.fromServer = fromServer;
        this.allErrors.addAll(errList);
        if (!this.allErrors.contains(error)) {
            this.allErrors.add(error);
        }
        if (!errList.contains(error)) {
            errList.add(error);
        }
    }

    public ValueSet getValueset() {
        return this.valueset;
    }

    public String getError() {
        return this.error;
    }

    public TerminologyServiceErrorClass getErrorClass() {
        return this.errorClass;
    }

    public String getTxLink() {
        return this.txLink;
    }

    public ValueSetExpansionOutcome setTxLink(String txLink) {
        this.txLink = txLink;
        return this;
    }

    public List<String> getAllErrors() {
        return this.allErrors;
    }

    public boolean isFromServer() {
        return this.fromServer;
    }

    public boolean isOk() {
        return (this.allErrors.isEmpty() || this.allErrors.size() == 1 && this.allErrors.get(0) == null) && this.error == null;
    }

    public int count() {
        if (this.valueset == null) {
            return 0;
        }
        return ValueSetUtilities.countExpansion(this.valueset);
    }
}

