/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.ICoding;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="Coding")
public class Coding
extends DataType
implements IBaseCoding,
ICompositeType,
ICoding {
    @Child(name="system", type={UriType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Identity of the terminology system", formalDefinition="The identification of the code system that defines the meaning of the symbol in the code.")
    protected UriType system;
    @Child(name="version", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Version of the system - if relevant", formalDefinition="The version of the code system which was used when choosing this code. Note that a well-maintained code system does not need the version reported, because the meaning of codes is consistent across versions. However this cannot consistently be assured, and when the meaning is not guaranteed to be consistent, the version SHOULD be exchanged.")
    protected StringType version;
    @Child(name="code", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Symbol in syntax defined by the system", formalDefinition="A symbol in syntax defined by the system. The symbol may be a predefined code or an expression in a syntax defined by the coding system (e.g. post-coordination).")
    protected CodeType code;
    @Child(name="display", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Representation defined by the system", formalDefinition="A representation of the meaning of the code in the system, following the rules of the system.")
    protected StringType display;
    @Child(name="userSelected", type={BooleanType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If this coding was chosen directly by the user", formalDefinition="Indicates that this coding was chosen by a user directly - e.g. off a pick list of available items (codes or displays).")
    protected BooleanType userSelected;
    private static final long serialVersionUID = -1417514061L;

    public Coding() {
    }

    public Coding(String theSystem, String theCode, String theDisplay) {
        this.setSystem(theSystem);
        this.setCode(theCode);
        this.setDisplay(theDisplay);
    }

    public UriType getSystemElement() {
        if (this.system == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coding.system");
            }
            if (Configuration.doAutoCreate()) {
                this.system = new UriType();
            }
        }
        return this.system;
    }

    public boolean hasSystemElement() {
        return this.system != null && !this.system.isEmpty();
    }

    @Override
    public boolean hasSystem() {
        return this.system != null && !this.system.isEmpty();
    }

    public Coding setSystemElement(UriType value) {
        this.system = value;
        return this;
    }

    @Override
    public String getSystem() {
        return this.system == null ? null : (String)this.system.getValue();
    }

    public Coding setSystem(String value) {
        if (Utilities.noString((String)value)) {
            this.system = null;
        } else {
            if (this.system == null) {
                this.system = new UriType();
            }
            this.system.setValue(value);
        }
        return this;
    }

    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coding.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    public Coding setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    public Coding setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    public CodeType getCodeElement() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coding.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeType();
            }
        }
        return this.code;
    }

    public boolean hasCodeElement() {
        return this.code != null && !this.code.isEmpty();
    }

    @Override
    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public Coding setCodeElement(CodeType value) {
        this.code = value;
        return this;
    }

    @Override
    public String getCode() {
        return this.code == null ? null : (String)this.code.getValue();
    }

    public Coding setCode(String value) {
        if (Utilities.noString((String)value)) {
            this.code = null;
        } else {
            if (this.code == null) {
                this.code = new CodeType();
            }
            this.code.setValue(value);
        }
        return this;
    }

    public StringType getDisplayElement() {
        if (this.display == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coding.display");
            }
            if (Configuration.doAutoCreate()) {
                this.display = new StringType();
            }
        }
        return this.display;
    }

    public boolean hasDisplayElement() {
        return this.display != null && !this.display.isEmpty();
    }

    @Override
    public boolean hasDisplay() {
        return this.display != null && !this.display.isEmpty();
    }

    public Coding setDisplayElement(StringType value) {
        this.display = value;
        return this;
    }

    @Override
    public String getDisplay() {
        return this.display == null ? null : (String)this.display.getValue();
    }

    public Coding setDisplay(String value) {
        if (Utilities.noString((String)value)) {
            this.display = null;
        } else {
            if (this.display == null) {
                this.display = new StringType();
            }
            this.display.setValue(value);
        }
        return this;
    }

    public BooleanType getUserSelectedElement() {
        if (this.userSelected == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Coding.userSelected");
            }
            if (Configuration.doAutoCreate()) {
                this.userSelected = new BooleanType();
            }
        }
        return this.userSelected;
    }

    public boolean hasUserSelectedElement() {
        return this.userSelected != null && !this.userSelected.isEmpty();
    }

    public boolean hasUserSelected() {
        return this.userSelected != null && !this.userSelected.isEmpty();
    }

    public Coding setUserSelectedElement(BooleanType value) {
        this.userSelected = value;
        return this;
    }

    public boolean getUserSelected() {
        return this.userSelected == null || this.userSelected.isEmpty() ? false : (Boolean)this.userSelected.getValue();
    }

    public Coding setUserSelected(boolean value) {
        if (this.userSelected == null) {
            this.userSelected = new BooleanType();
        }
        this.userSelected.setValue((Object)value);
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("system", "uri", "The identification of the code system that defines the meaning of the symbol in the code.", 0, 1, this.system));
        children.add(new Property("version", "string", "The version of the code system which was used when choosing this code. Note that a well-maintained code system does not need the version reported, because the meaning of codes is consistent across versions. However this cannot consistently be assured, and when the meaning is not guaranteed to be consistent, the version SHOULD be exchanged.", 0, 1, this.version));
        children.add(new Property("code", "code", "A symbol in syntax defined by the system. The symbol may be a predefined code or an expression in a syntax defined by the coding system (e.g. post-coordination).", 0, 1, this.code));
        children.add(new Property("display", "string", "A representation of the meaning of the code in the system, following the rules of the system.", 0, 1, this.display));
        children.add(new Property("userSelected", "boolean", "Indicates that this coding was chosen by a user directly - e.g. off a pick list of available items (codes or displays).", 0, 1, this.userSelected));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -887328209: {
                return new Property("system", "uri", "The identification of the code system that defines the meaning of the symbol in the code.", 0, 1, this.system);
            }
            case 351608024: {
                return new Property("version", "string", "The version of the code system which was used when choosing this code. Note that a well-maintained code system does not need the version reported, because the meaning of codes is consistent across versions. However this cannot consistently be assured, and when the meaning is not guaranteed to be consistent, the version SHOULD be exchanged.", 0, 1, this.version);
            }
            case 3059181: {
                return new Property("code", "code", "A symbol in syntax defined by the system. The symbol may be a predefined code or an expression in a syntax defined by the coding system (e.g. post-coordination).", 0, 1, this.code);
            }
            case 1671764162: {
                return new Property("display", "string", "A representation of the meaning of the code in the system, following the rules of the system.", 0, 1, this.display);
            }
            case 423643014: {
                return new Property("userSelected", "boolean", "Indicates that this coding was chosen by a user directly - e.g. off a pick list of available items (codes or displays).", 0, 1, this.userSelected);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -887328209: {
                Base[] baseArray;
                if (this.system == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.system;
                }
                return baseArray;
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.code;
                }
                return baseArray;
            }
            case 1671764162: {
                Base[] baseArray;
                if (this.display == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.display;
                }
                return baseArray;
            }
            case 423643014: {
                Base[] baseArray;
                if (this.userSelected == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.userSelected;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -887328209: {
                this.system = TypeConvertor.castToUri(value);
                return value;
            }
            case 351608024: {
                this.version = TypeConvertor.castToString(value);
                return value;
            }
            case 3059181: {
                this.code = TypeConvertor.castToCode(value);
                return value;
            }
            case 1671764162: {
                this.display = TypeConvertor.castToString(value);
                return value;
            }
            case 423643014: {
                this.userSelected = TypeConvertor.castToBoolean(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("system")) {
            this.system = TypeConvertor.castToUri(value);
        } else if (name.equals("version")) {
            this.version = TypeConvertor.castToString(value);
        } else if (name.equals("code")) {
            this.code = TypeConvertor.castToCode(value);
        } else if (name.equals("display")) {
            this.display = TypeConvertor.castToString(value);
        } else if (name.equals("userSelected")) {
            this.userSelected = TypeConvertor.castToBoolean(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals("system")) {
            this.system = null;
        } else if (name.equals("version")) {
            this.version = null;
        } else if (name.equals("code")) {
            this.code = null;
        } else if (name.equals("display")) {
            this.display = null;
        } else if (name.equals("userSelected")) {
            this.userSelected = null;
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -887328209: {
                return this.getSystemElement();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 3059181: {
                return this.getCodeElement();
            }
            case 1671764162: {
                return this.getDisplayElement();
            }
            case 423643014: {
                return this.getUserSelectedElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -887328209: {
                return new String[]{"uri"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 3059181: {
                return new String[]{"code"};
            }
            case 1671764162: {
                return new String[]{"string"};
            }
            case 423643014: {
                return new String[]{"boolean"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("system")) {
            throw new FHIRException("Cannot call addChild on a singleton property Coding.system");
        }
        if (name.equals("version")) {
            throw new FHIRException("Cannot call addChild on a singleton property Coding.version");
        }
        if (name.equals("code")) {
            throw new FHIRException("Cannot call addChild on a singleton property Coding.code");
        }
        if (name.equals("display")) {
            throw new FHIRException("Cannot call addChild on a singleton property Coding.display");
        }
        if (name.equals("userSelected")) {
            throw new FHIRException("Cannot call addChild on a singleton property Coding.userSelected");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Coding";
    }

    @Override
    public Coding copy() {
        Coding dst = new Coding();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Coding dst) {
        super.copyValues(dst);
        dst.system = this.system == null ? null : this.system.copy();
        dst.version = this.version == null ? null : this.version.copy();
        dst.code = this.code == null ? null : this.code.copy();
        dst.display = this.display == null ? null : this.display.copy();
        dst.userSelected = this.userSelected == null ? null : this.userSelected.copy();
    }

    protected Coding typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Coding)) {
            return false;
        }
        Coding o = (Coding)other_;
        return Coding.compareDeep(this.system, o.system, true) && Coding.compareDeep(this.version, o.version, true) && Coding.compareDeep(this.code, o.code, true) && Coding.compareDeep(this.display, o.display, true) && Coding.compareDeep(this.userSelected, o.userSelected, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Coding)) {
            return false;
        }
        Coding o = (Coding)other_;
        return Coding.compareValues(this.system, o.system, true) && Coding.compareValues(this.version, o.version, true) && Coding.compareValues(this.code, o.code, true) && Coding.compareValues(this.display, o.display, true) && Coding.compareValues(this.userSelected, o.userSelected, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.system, this.version, this.code, this.display, this.userSelected});
    }

    @Override
    public boolean supportsVersion() {
        return true;
    }

    @Override
    public boolean supportsDisplay() {
        return true;
    }

    public boolean is(String system, String code) {
        return this.hasSystem() && this.hasCode() && this.getSystem().equals(system) && this.getCode().equals(code);
    }

    public String toString() {
        Object base;
        Object object = base = this.hasSystem() ? this.getSystem() : "";
        if (this.hasVersion()) {
            base = (String)base + "|" + this.getVersion();
        }
        base = (String)base + "#" + this.getCode();
        if (this.hasDisplay()) {
            base = (String)base + ": '" + this.getDisplay() + "'";
        }
        return base;
    }

    public static Coding fromLiteral(String value) {
        String display;
        String sv = value.contains("#") ? value.substring(0, value.indexOf("#")) : value;
        String cp = value.contains("#") ? value.substring(value.indexOf("#") + 1) : null;
        String system = sv.contains("|") ? sv.substring(0, sv.indexOf("|")) : sv;
        String version = sv.contains("|") ? sv.substring(sv.indexOf("|") + 1) : null;
        String code = cp != null && cp.contains("'") ? cp.substring(0, cp.indexOf("'")) : cp;
        String string = display = cp != null && cp.contains("'") ? cp.substring(cp.indexOf("'") + 1) : null;
        if (display != null) {
            display = display.trim();
            display = display.substring(0, display.length() - 1);
        }
        if (!(system != null && Utilities.isAbsoluteUrl((String)system) || code != null)) {
            return null;
        }
        return new Coding(system, version, code, display);
    }

    public boolean matches(Coding other) {
        return other.hasCode() && this.hasCode() && other.hasSystem() && this.hasSystem() && this.getCode().equals(other.getCode()) && this.getSystem().equals(other.getSystem());
    }

    public static Coding merge(Coding l, Coding r) {
        Coding res = new Coding();
        if (l.hasSystem()) {
            res.setSystem(l.getSystem());
        } else {
            res.setSystem(r.getSystem());
        }
        if (l.hasVersion()) {
            res.setVersion(l.getVersion());
        } else {
            res.setVersion(r.getVersion());
        }
        if (l.hasCode()) {
            res.setCode(l.getCode());
        } else {
            res.setCode(r.getCode());
        }
        if (l.hasDisplay()) {
            res.setDisplay(l.getDisplay());
        } else {
            res.setDisplay(r.getDisplay());
        }
        if (l.hasUserSelected()) {
            res.setUserSelected(l.getUserSelected());
        } else {
            res.setUserSelected(r.getUserSelected());
        }
        return res;
    }

    public static Coding intersect(Coding l, Coding r) {
        Coding res = new Coding();
        if (l.hasSystem() && l.getSystem().equals(r.getSystem())) {
            res.setSystem(l.getSystem());
        }
        if (l.hasVersion() && l.getVersion().equals(r.getVersion())) {
            res.setVersion(l.getVersion());
        }
        if (l.hasCode() && l.getCode().equals(r.getCode())) {
            res.setCode(l.getCode());
        }
        if (l.hasDisplay() && l.getDisplay().equals(r.getDisplay())) {
            res.setDisplay(l.getDisplay());
        }
        if (l.hasUserSelected() && l.getUserSelected() == r.getUserSelected()) {
            res.setUserSelected(l.getUserSelected());
        }
        return res;
    }

    public Coding(String theSystem, String theVersion, String theCode, String theDisplay) {
        this.setSystem(theSystem);
        this.setVersion(theVersion);
        this.setCode(theCode);
        this.setDisplay(theDisplay);
    }

    public String getVersionedSystem() {
        return this.hasVersion() ? this.getSystem() + "|" + this.getVersion() : this.getSystem();
    }
}

