/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="SubstanceProtein", profile="http://hl7.org/fhir/StructureDefinition/SubstanceProtein")
public class SubstanceProtein
extends DomainResource {
    @Child(name="sequenceType", type={CodeableConcept.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The SubstanceProtein descriptive elements will only be used when a complete or partial amino acid sequence is available or derivable from a nucleic acid sequence", formalDefinition="The SubstanceProtein descriptive elements will only be used when a complete or partial amino acid sequence is available or derivable from a nucleic acid sequence.")
    protected CodeableConcept sequenceType;
    @Child(name="numberOfSubunits", type={IntegerType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Number of linear sequences of amino acids linked through peptide bonds. The number of subunits constituting the SubstanceProtein shall be described. It is possible that the number of subunits can be variable", formalDefinition="Number of linear sequences of amino acids linked through peptide bonds. The number of subunits constituting the SubstanceProtein shall be described. It is possible that the number of subunits can be variable.")
    protected IntegerType numberOfSubunits;
    @Child(name="disulfideLinkage", type={StringType.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The disulphide bond between two cysteine residues either on the same subunit or on two different subunits shall be described. The position of the disulfide bonds in the SubstanceProtein shall be listed in increasing order of subunit number and position within subunit followed by the abbreviation of the amino acids involved. The disulfide linkage positions shall actually contain the amino acid Cysteine at the respective positions", formalDefinition="The disulphide bond between two cysteine residues either on the same subunit or on two different subunits shall be described. The position of the disulfide bonds in the SubstanceProtein shall be listed in increasing order of subunit number and position within subunit followed by the abbreviation of the amino acids involved. The disulfide linkage positions shall actually contain the amino acid Cysteine at the respective positions.")
    protected List<StringType> disulfideLinkage;
    @Child(name="subunit", type={}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="This subclause refers to the description of each subunit constituting the SubstanceProtein. A subunit is a linear sequence of amino acids linked through peptide bonds. The Subunit information shall be provided when the finished SubstanceProtein is a complex of multiple sequences; subunits are not used to delineate domains within a single sequence. Subunits are listed in order of decreasing length; sequences of the same length will be ordered by decreasing molecular weight; subunits that have identical sequences will be repeated multiple times", formalDefinition="This subclause refers to the description of each subunit constituting the SubstanceProtein. A subunit is a linear sequence of amino acids linked through peptide bonds. The Subunit information shall be provided when the finished SubstanceProtein is a complex of multiple sequences; subunits are not used to delineate domains within a single sequence. Subunits are listed in order of decreasing length; sequences of the same length will be ordered by decreasing molecular weight; subunits that have identical sequences will be repeated multiple times.")
    protected List<SubstanceProteinSubunitComponent> subunit;
    private static final long serialVersionUID = 469786856L;

    public CodeableConcept getSequenceType() {
        if (this.sequenceType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceProtein.sequenceType");
            }
            if (Configuration.doAutoCreate()) {
                this.sequenceType = new CodeableConcept();
            }
        }
        return this.sequenceType;
    }

    public boolean hasSequenceType() {
        return this.sequenceType != null && !this.sequenceType.isEmpty();
    }

    public SubstanceProtein setSequenceType(CodeableConcept value) {
        this.sequenceType = value;
        return this;
    }

    public IntegerType getNumberOfSubunitsElement() {
        if (this.numberOfSubunits == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceProtein.numberOfSubunits");
            }
            if (Configuration.doAutoCreate()) {
                this.numberOfSubunits = new IntegerType();
            }
        }
        return this.numberOfSubunits;
    }

    public boolean hasNumberOfSubunitsElement() {
        return this.numberOfSubunits != null && !this.numberOfSubunits.isEmpty();
    }

    public boolean hasNumberOfSubunits() {
        return this.numberOfSubunits != null && !this.numberOfSubunits.isEmpty();
    }

    public SubstanceProtein setNumberOfSubunitsElement(IntegerType value) {
        this.numberOfSubunits = value;
        return this;
    }

    public int getNumberOfSubunits() {
        return this.numberOfSubunits == null || this.numberOfSubunits.isEmpty() ? 0 : (Integer)this.numberOfSubunits.getValue();
    }

    public SubstanceProtein setNumberOfSubunits(int value) {
        if (this.numberOfSubunits == null) {
            this.numberOfSubunits = new IntegerType();
        }
        this.numberOfSubunits.setValue((Object)value);
        return this;
    }

    public List<StringType> getDisulfideLinkage() {
        if (this.disulfideLinkage == null) {
            this.disulfideLinkage = new ArrayList<StringType>();
        }
        return this.disulfideLinkage;
    }

    public SubstanceProtein setDisulfideLinkage(List<StringType> theDisulfideLinkage) {
        this.disulfideLinkage = theDisulfideLinkage;
        return this;
    }

    public boolean hasDisulfideLinkage() {
        if (this.disulfideLinkage == null) {
            return false;
        }
        for (StringType item : this.disulfideLinkage) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addDisulfideLinkageElement() {
        StringType t = new StringType();
        if (this.disulfideLinkage == null) {
            this.disulfideLinkage = new ArrayList<StringType>();
        }
        this.disulfideLinkage.add(t);
        return t;
    }

    public SubstanceProtein addDisulfideLinkage(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.disulfideLinkage == null) {
            this.disulfideLinkage = new ArrayList<StringType>();
        }
        this.disulfideLinkage.add(t);
        return this;
    }

    public boolean hasDisulfideLinkage(String value) {
        if (this.disulfideLinkage == null) {
            return false;
        }
        for (StringType v : this.disulfideLinkage) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<SubstanceProteinSubunitComponent> getSubunit() {
        if (this.subunit == null) {
            this.subunit = new ArrayList<SubstanceProteinSubunitComponent>();
        }
        return this.subunit;
    }

    public SubstanceProtein setSubunit(List<SubstanceProteinSubunitComponent> theSubunit) {
        this.subunit = theSubunit;
        return this;
    }

    public boolean hasSubunit() {
        if (this.subunit == null) {
            return false;
        }
        for (SubstanceProteinSubunitComponent item : this.subunit) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SubstanceProteinSubunitComponent addSubunit() {
        SubstanceProteinSubunitComponent t = new SubstanceProteinSubunitComponent();
        if (this.subunit == null) {
            this.subunit = new ArrayList<SubstanceProteinSubunitComponent>();
        }
        this.subunit.add(t);
        return t;
    }

    public SubstanceProtein addSubunit(SubstanceProteinSubunitComponent t) {
        if (t == null) {
            return this;
        }
        if (this.subunit == null) {
            this.subunit = new ArrayList<SubstanceProteinSubunitComponent>();
        }
        this.subunit.add(t);
        return this;
    }

    public SubstanceProteinSubunitComponent getSubunitFirstRep() {
        if (this.getSubunit().isEmpty()) {
            this.addSubunit();
        }
        return this.getSubunit().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("sequenceType", "CodeableConcept", "The SubstanceProtein descriptive elements will only be used when a complete or partial amino acid sequence is available or derivable from a nucleic acid sequence.", 0, 1, this.sequenceType));
        children.add(new Property("numberOfSubunits", "integer", "Number of linear sequences of amino acids linked through peptide bonds. The number of subunits constituting the SubstanceProtein shall be described. It is possible that the number of subunits can be variable.", 0, 1, this.numberOfSubunits));
        children.add(new Property("disulfideLinkage", "string", "The disulphide bond between two cysteine residues either on the same subunit or on two different subunits shall be described. The position of the disulfide bonds in the SubstanceProtein shall be listed in increasing order of subunit number and position within subunit followed by the abbreviation of the amino acids involved. The disulfide linkage positions shall actually contain the amino acid Cysteine at the respective positions.", 0, Integer.MAX_VALUE, this.disulfideLinkage));
        children.add(new Property("subunit", "", "This subclause refers to the description of each subunit constituting the SubstanceProtein. A subunit is a linear sequence of amino acids linked through peptide bonds. The Subunit information shall be provided when the finished SubstanceProtein is a complex of multiple sequences; subunits are not used to delineate domains within a single sequence. Subunits are listed in order of decreasing length; sequences of the same length will be ordered by decreasing molecular weight; subunits that have identical sequences will be repeated multiple times.", 0, Integer.MAX_VALUE, this.subunit));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 807711387: {
                return new Property("sequenceType", "CodeableConcept", "The SubstanceProtein descriptive elements will only be used when a complete or partial amino acid sequence is available or derivable from a nucleic acid sequence.", 0, 1, this.sequenceType);
            }
            case -847111089: {
                return new Property("numberOfSubunits", "integer", "Number of linear sequences of amino acids linked through peptide bonds. The number of subunits constituting the SubstanceProtein shall be described. It is possible that the number of subunits can be variable.", 0, 1, this.numberOfSubunits);
            }
            case -1996102436: {
                return new Property("disulfideLinkage", "string", "The disulphide bond between two cysteine residues either on the same subunit or on two different subunits shall be described. The position of the disulfide bonds in the SubstanceProtein shall be listed in increasing order of subunit number and position within subunit followed by the abbreviation of the amino acids involved. The disulfide linkage positions shall actually contain the amino acid Cysteine at the respective positions.", 0, Integer.MAX_VALUE, this.disulfideLinkage);
            }
            case -1867548732: {
                return new Property("subunit", "", "This subclause refers to the description of each subunit constituting the SubstanceProtein. A subunit is a linear sequence of amino acids linked through peptide bonds. The Subunit information shall be provided when the finished SubstanceProtein is a complex of multiple sequences; subunits are not used to delineate domains within a single sequence. Subunits are listed in order of decreasing length; sequences of the same length will be ordered by decreasing molecular weight; subunits that have identical sequences will be repeated multiple times.", 0, Integer.MAX_VALUE, this.subunit);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 807711387: {
                Base[] baseArray;
                if (this.sequenceType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.sequenceType;
                }
                return baseArray;
            }
            case -847111089: {
                Base[] baseArray;
                if (this.numberOfSubunits == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.numberOfSubunits;
                }
                return baseArray;
            }
            case -1996102436: {
                return this.disulfideLinkage == null ? new Base[]{} : this.disulfideLinkage.toArray(new Base[this.disulfideLinkage.size()]);
            }
            case -1867548732: {
                return this.subunit == null ? new Base[]{} : this.subunit.toArray(new Base[this.subunit.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 807711387: {
                this.sequenceType = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -847111089: {
                this.numberOfSubunits = TypeConvertor.castToInteger(value);
                return value;
            }
            case -1996102436: {
                this.getDisulfideLinkage().add(TypeConvertor.castToString(value));
                return value;
            }
            case -1867548732: {
                this.getSubunit().add((SubstanceProteinSubunitComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("sequenceType")) {
            this.sequenceType = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("numberOfSubunits")) {
            this.numberOfSubunits = TypeConvertor.castToInteger(value);
        } else if (name.equals("disulfideLinkage")) {
            this.getDisulfideLinkage().add(TypeConvertor.castToString(value));
        } else if (name.equals("subunit")) {
            this.getSubunit().add((SubstanceProteinSubunitComponent)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals("sequenceType")) {
            this.sequenceType = null;
        } else if (name.equals("numberOfSubunits")) {
            this.numberOfSubunits = null;
        } else if (name.equals("disulfideLinkage")) {
            this.getDisulfideLinkage().remove(value);
        } else if (name.equals("subunit")) {
            this.getSubunit().remove((SubstanceProteinSubunitComponent)value);
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 807711387: {
                return this.getSequenceType();
            }
            case -847111089: {
                return this.getNumberOfSubunitsElement();
            }
            case -1996102436: {
                return this.addDisulfideLinkageElement();
            }
            case -1867548732: {
                return this.addSubunit();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 807711387: {
                return new String[]{"CodeableConcept"};
            }
            case -847111089: {
                return new String[]{"integer"};
            }
            case -1996102436: {
                return new String[]{"string"};
            }
            case -1867548732: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("sequenceType")) {
            this.sequenceType = new CodeableConcept();
            return this.sequenceType;
        }
        if (name.equals("numberOfSubunits")) {
            throw new FHIRException("Cannot call addChild on a singleton property SubstanceProtein.numberOfSubunits");
        }
        if (name.equals("disulfideLinkage")) {
            throw new FHIRException("Cannot call addChild on a singleton property SubstanceProtein.disulfideLinkage");
        }
        if (name.equals("subunit")) {
            return this.addSubunit();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "SubstanceProtein";
    }

    @Override
    public SubstanceProtein copy() {
        SubstanceProtein dst = new SubstanceProtein();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(SubstanceProtein dst) {
        super.copyValues(dst);
        dst.sequenceType = this.sequenceType == null ? null : this.sequenceType.copy();
        IntegerType integerType = dst.numberOfSubunits = this.numberOfSubunits == null ? null : this.numberOfSubunits.copy();
        if (this.disulfideLinkage != null) {
            dst.disulfideLinkage = new ArrayList<StringType>();
            for (StringType stringType : this.disulfideLinkage) {
                dst.disulfideLinkage.add(stringType.copy());
            }
        }
        if (this.subunit != null) {
            dst.subunit = new ArrayList<SubstanceProteinSubunitComponent>();
            for (SubstanceProteinSubunitComponent substanceProteinSubunitComponent : this.subunit) {
                dst.subunit.add(substanceProteinSubunitComponent.copy());
            }
        }
    }

    protected SubstanceProtein typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof SubstanceProtein)) {
            return false;
        }
        SubstanceProtein o = (SubstanceProtein)other_;
        return SubstanceProtein.compareDeep(this.sequenceType, o.sequenceType, true) && SubstanceProtein.compareDeep(this.numberOfSubunits, o.numberOfSubunits, true) && SubstanceProtein.compareDeep(this.disulfideLinkage, o.disulfideLinkage, true) && SubstanceProtein.compareDeep(this.subunit, o.subunit, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof SubstanceProtein)) {
            return false;
        }
        SubstanceProtein o = (SubstanceProtein)other_;
        return SubstanceProtein.compareValues(this.numberOfSubunits, o.numberOfSubunits, true) && SubstanceProtein.compareValues(this.disulfideLinkage, o.disulfideLinkage, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.sequenceType, this.numberOfSubunits, this.disulfideLinkage, this.subunit});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.SubstanceProtein;
    }

    @Block
    public static class SubstanceProteinSubunitComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="subunit", type={IntegerType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Index of primary sequences of amino acids linked through peptide bonds in order of decreasing length. Sequences of the same length will be ordered by molecular weight. Subunits that have identical sequences will be repeated and have sequential subscripts", formalDefinition="Index of primary sequences of amino acids linked through peptide bonds in order of decreasing length. Sequences of the same length will be ordered by molecular weight. Subunits that have identical sequences will be repeated and have sequential subscripts.")
        protected IntegerType subunit;
        @Child(name="sequence", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The sequence information shall be provided enumerating the amino acids from N- to C-terminal end using standard single-letter amino acid codes. Uppercase shall be used for L-amino acids and lowercase for D-amino acids. Transcribed SubstanceProteins will always be described using the translated sequence; for synthetic peptide containing amino acids that are not represented with a single letter code an X should be used within the sequence. The modified amino acids will be distinguished by their position in the sequence", formalDefinition="The sequence information shall be provided enumerating the amino acids from N- to C-terminal end using standard single-letter amino acid codes. Uppercase shall be used for L-amino acids and lowercase for D-amino acids. Transcribed SubstanceProteins will always be described using the translated sequence; for synthetic peptide containing amino acids that are not represented with a single letter code an X should be used within the sequence. The modified amino acids will be distinguished by their position in the sequence.")
        protected StringType sequence;
        @Child(name="length", type={IntegerType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Length of linear sequences of amino acids contained in the subunit", formalDefinition="Length of linear sequences of amino acids contained in the subunit.")
        protected IntegerType length;
        @Child(name="sequenceAttachment", type={Attachment.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The sequence information shall be provided enumerating the amino acids from N- to C-terminal end using standard single-letter amino acid codes. Uppercase shall be used for L-amino acids and lowercase for D-amino acids. Transcribed SubstanceProteins will always be described using the translated sequence; for synthetic peptide containing amino acids that are not represented with a single letter code an X should be used within the sequence. The modified amino acids will be distinguished by their position in the sequence", formalDefinition="The sequence information shall be provided enumerating the amino acids from N- to C-terminal end using standard single-letter amino acid codes. Uppercase shall be used for L-amino acids and lowercase for D-amino acids. Transcribed SubstanceProteins will always be described using the translated sequence; for synthetic peptide containing amino acids that are not represented with a single letter code an X should be used within the sequence. The modified amino acids will be distinguished by their position in the sequence.")
        protected Attachment sequenceAttachment;
        @Child(name="nTerminalModificationId", type={Identifier.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Unique identifier for molecular fragment modification based on the ISO 11238 Substance ID", formalDefinition="Unique identifier for molecular fragment modification based on the ISO 11238 Substance ID.")
        protected Identifier nTerminalModificationId;
        @Child(name="nTerminalModification", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The name of the fragment modified at the N-terminal of the SubstanceProtein shall be specified", formalDefinition="The name of the fragment modified at the N-terminal of the SubstanceProtein shall be specified.")
        protected StringType nTerminalModification;
        @Child(name="cTerminalModificationId", type={Identifier.class}, order=7, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Unique identifier for molecular fragment modification based on the ISO 11238 Substance ID", formalDefinition="Unique identifier for molecular fragment modification based on the ISO 11238 Substance ID.")
        protected Identifier cTerminalModificationId;
        @Child(name="cTerminalModification", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The modification at the C-terminal shall be specified", formalDefinition="The modification at the C-terminal shall be specified.")
        protected StringType cTerminalModification;
        private static final long serialVersionUID = 99973841L;

        public IntegerType getSubunitElement() {
            if (this.subunit == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceProteinSubunitComponent.subunit");
                }
                if (Configuration.doAutoCreate()) {
                    this.subunit = new IntegerType();
                }
            }
            return this.subunit;
        }

        public boolean hasSubunitElement() {
            return this.subunit != null && !this.subunit.isEmpty();
        }

        public boolean hasSubunit() {
            return this.subunit != null && !this.subunit.isEmpty();
        }

        public SubstanceProteinSubunitComponent setSubunitElement(IntegerType value) {
            this.subunit = value;
            return this;
        }

        public int getSubunit() {
            return this.subunit == null || this.subunit.isEmpty() ? 0 : (Integer)this.subunit.getValue();
        }

        public SubstanceProteinSubunitComponent setSubunit(int value) {
            if (this.subunit == null) {
                this.subunit = new IntegerType();
            }
            this.subunit.setValue((Object)value);
            return this;
        }

        public StringType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceProteinSubunitComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new StringType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public SubstanceProteinSubunitComponent setSequenceElement(StringType value) {
            this.sequence = value;
            return this;
        }

        public String getSequence() {
            return this.sequence == null ? null : (String)this.sequence.getValue();
        }

        public SubstanceProteinSubunitComponent setSequence(String value) {
            if (Utilities.noString((String)value)) {
                this.sequence = null;
            } else {
                if (this.sequence == null) {
                    this.sequence = new StringType();
                }
                this.sequence.setValue(value);
            }
            return this;
        }

        public IntegerType getLengthElement() {
            if (this.length == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceProteinSubunitComponent.length");
                }
                if (Configuration.doAutoCreate()) {
                    this.length = new IntegerType();
                }
            }
            return this.length;
        }

        public boolean hasLengthElement() {
            return this.length != null && !this.length.isEmpty();
        }

        public boolean hasLength() {
            return this.length != null && !this.length.isEmpty();
        }

        public SubstanceProteinSubunitComponent setLengthElement(IntegerType value) {
            this.length = value;
            return this;
        }

        public int getLength() {
            return this.length == null || this.length.isEmpty() ? 0 : (Integer)this.length.getValue();
        }

        public SubstanceProteinSubunitComponent setLength(int value) {
            if (this.length == null) {
                this.length = new IntegerType();
            }
            this.length.setValue((Object)value);
            return this;
        }

        public Attachment getSequenceAttachment() {
            if (this.sequenceAttachment == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceProteinSubunitComponent.sequenceAttachment");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequenceAttachment = new Attachment();
                }
            }
            return this.sequenceAttachment;
        }

        public boolean hasSequenceAttachment() {
            return this.sequenceAttachment != null && !this.sequenceAttachment.isEmpty();
        }

        public SubstanceProteinSubunitComponent setSequenceAttachment(Attachment value) {
            this.sequenceAttachment = value;
            return this;
        }

        public Identifier getNTerminalModificationId() {
            if (this.nTerminalModificationId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceProteinSubunitComponent.nTerminalModificationId");
                }
                if (Configuration.doAutoCreate()) {
                    this.nTerminalModificationId = new Identifier();
                }
            }
            return this.nTerminalModificationId;
        }

        public boolean hasNTerminalModificationId() {
            return this.nTerminalModificationId != null && !this.nTerminalModificationId.isEmpty();
        }

        public SubstanceProteinSubunitComponent setNTerminalModificationId(Identifier value) {
            this.nTerminalModificationId = value;
            return this;
        }

        public StringType getNTerminalModificationElement() {
            if (this.nTerminalModification == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceProteinSubunitComponent.nTerminalModification");
                }
                if (Configuration.doAutoCreate()) {
                    this.nTerminalModification = new StringType();
                }
            }
            return this.nTerminalModification;
        }

        public boolean hasNTerminalModificationElement() {
            return this.nTerminalModification != null && !this.nTerminalModification.isEmpty();
        }

        public boolean hasNTerminalModification() {
            return this.nTerminalModification != null && !this.nTerminalModification.isEmpty();
        }

        public SubstanceProteinSubunitComponent setNTerminalModificationElement(StringType value) {
            this.nTerminalModification = value;
            return this;
        }

        public String getNTerminalModification() {
            return this.nTerminalModification == null ? null : (String)this.nTerminalModification.getValue();
        }

        public SubstanceProteinSubunitComponent setNTerminalModification(String value) {
            if (Utilities.noString((String)value)) {
                this.nTerminalModification = null;
            } else {
                if (this.nTerminalModification == null) {
                    this.nTerminalModification = new StringType();
                }
                this.nTerminalModification.setValue(value);
            }
            return this;
        }

        public Identifier getCTerminalModificationId() {
            if (this.cTerminalModificationId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceProteinSubunitComponent.cTerminalModificationId");
                }
                if (Configuration.doAutoCreate()) {
                    this.cTerminalModificationId = new Identifier();
                }
            }
            return this.cTerminalModificationId;
        }

        public boolean hasCTerminalModificationId() {
            return this.cTerminalModificationId != null && !this.cTerminalModificationId.isEmpty();
        }

        public SubstanceProteinSubunitComponent setCTerminalModificationId(Identifier value) {
            this.cTerminalModificationId = value;
            return this;
        }

        public StringType getCTerminalModificationElement() {
            if (this.cTerminalModification == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceProteinSubunitComponent.cTerminalModification");
                }
                if (Configuration.doAutoCreate()) {
                    this.cTerminalModification = new StringType();
                }
            }
            return this.cTerminalModification;
        }

        public boolean hasCTerminalModificationElement() {
            return this.cTerminalModification != null && !this.cTerminalModification.isEmpty();
        }

        public boolean hasCTerminalModification() {
            return this.cTerminalModification != null && !this.cTerminalModification.isEmpty();
        }

        public SubstanceProteinSubunitComponent setCTerminalModificationElement(StringType value) {
            this.cTerminalModification = value;
            return this;
        }

        public String getCTerminalModification() {
            return this.cTerminalModification == null ? null : (String)this.cTerminalModification.getValue();
        }

        public SubstanceProteinSubunitComponent setCTerminalModification(String value) {
            if (Utilities.noString((String)value)) {
                this.cTerminalModification = null;
            } else {
                if (this.cTerminalModification == null) {
                    this.cTerminalModification = new StringType();
                }
                this.cTerminalModification.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("subunit", "integer", "Index of primary sequences of amino acids linked through peptide bonds in order of decreasing length. Sequences of the same length will be ordered by molecular weight. Subunits that have identical sequences will be repeated and have sequential subscripts.", 0, 1, this.subunit));
            children.add(new Property("sequence", "string", "The sequence information shall be provided enumerating the amino acids from N- to C-terminal end using standard single-letter amino acid codes. Uppercase shall be used for L-amino acids and lowercase for D-amino acids. Transcribed SubstanceProteins will always be described using the translated sequence; for synthetic peptide containing amino acids that are not represented with a single letter code an X should be used within the sequence. The modified amino acids will be distinguished by their position in the sequence.", 0, 1, this.sequence));
            children.add(new Property("length", "integer", "Length of linear sequences of amino acids contained in the subunit.", 0, 1, this.length));
            children.add(new Property("sequenceAttachment", "Attachment", "The sequence information shall be provided enumerating the amino acids from N- to C-terminal end using standard single-letter amino acid codes. Uppercase shall be used for L-amino acids and lowercase for D-amino acids. Transcribed SubstanceProteins will always be described using the translated sequence; for synthetic peptide containing amino acids that are not represented with a single letter code an X should be used within the sequence. The modified amino acids will be distinguished by their position in the sequence.", 0, 1, this.sequenceAttachment));
            children.add(new Property("nTerminalModificationId", "Identifier", "Unique identifier for molecular fragment modification based on the ISO 11238 Substance ID.", 0, 1, this.nTerminalModificationId));
            children.add(new Property("nTerminalModification", "string", "The name of the fragment modified at the N-terminal of the SubstanceProtein shall be specified.", 0, 1, this.nTerminalModification));
            children.add(new Property("cTerminalModificationId", "Identifier", "Unique identifier for molecular fragment modification based on the ISO 11238 Substance ID.", 0, 1, this.cTerminalModificationId));
            children.add(new Property("cTerminalModification", "string", "The modification at the C-terminal shall be specified.", 0, 1, this.cTerminalModification));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1867548732: {
                    return new Property("subunit", "integer", "Index of primary sequences of amino acids linked through peptide bonds in order of decreasing length. Sequences of the same length will be ordered by molecular weight. Subunits that have identical sequences will be repeated and have sequential subscripts.", 0, 1, this.subunit);
                }
                case 1349547969: {
                    return new Property("sequence", "string", "The sequence information shall be provided enumerating the amino acids from N- to C-terminal end using standard single-letter amino acid codes. Uppercase shall be used for L-amino acids and lowercase for D-amino acids. Transcribed SubstanceProteins will always be described using the translated sequence; for synthetic peptide containing amino acids that are not represented with a single letter code an X should be used within the sequence. The modified amino acids will be distinguished by their position in the sequence.", 0, 1, this.sequence);
                }
                case -1106363674: {
                    return new Property("length", "integer", "Length of linear sequences of amino acids contained in the subunit.", 0, 1, this.length);
                }
                case 364621764: {
                    return new Property("sequenceAttachment", "Attachment", "The sequence information shall be provided enumerating the amino acids from N- to C-terminal end using standard single-letter amino acid codes. Uppercase shall be used for L-amino acids and lowercase for D-amino acids. Transcribed SubstanceProteins will always be described using the translated sequence; for synthetic peptide containing amino acids that are not represented with a single letter code an X should be used within the sequence. The modified amino acids will be distinguished by their position in the sequence.", 0, 1, this.sequenceAttachment);
                }
                case -182796415: {
                    return new Property("nTerminalModificationId", "Identifier", "Unique identifier for molecular fragment modification based on the ISO 11238 Substance ID.", 0, 1, this.nTerminalModificationId);
                }
                case -1497395258: {
                    return new Property("nTerminalModification", "string", "The name of the fragment modified at the N-terminal of the SubstanceProtein shall be specified.", 0, 1, this.nTerminalModification);
                }
                case -990303818: {
                    return new Property("cTerminalModificationId", "Identifier", "Unique identifier for molecular fragment modification based on the ISO 11238 Substance ID.", 0, 1, this.cTerminalModificationId);
                }
                case 472711995: {
                    return new Property("cTerminalModification", "string", "The modification at the C-terminal shall be specified.", 0, 1, this.cTerminalModification);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1867548732: {
                    Base[] baseArray;
                    if (this.subunit == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.subunit;
                    }
                    return baseArray;
                }
                case 1349547969: {
                    Base[] baseArray;
                    if (this.sequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.sequence;
                    }
                    return baseArray;
                }
                case -1106363674: {
                    Base[] baseArray;
                    if (this.length == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.length;
                    }
                    return baseArray;
                }
                case 364621764: {
                    Base[] baseArray;
                    if (this.sequenceAttachment == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.sequenceAttachment;
                    }
                    return baseArray;
                }
                case -182796415: {
                    Base[] baseArray;
                    if (this.nTerminalModificationId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.nTerminalModificationId;
                    }
                    return baseArray;
                }
                case -1497395258: {
                    Base[] baseArray;
                    if (this.nTerminalModification == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.nTerminalModification;
                    }
                    return baseArray;
                }
                case -990303818: {
                    Base[] baseArray;
                    if (this.cTerminalModificationId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.cTerminalModificationId;
                    }
                    return baseArray;
                }
                case 472711995: {
                    Base[] baseArray;
                    if (this.cTerminalModification == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.cTerminalModification;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1867548732: {
                    this.subunit = TypeConvertor.castToInteger(value);
                    return value;
                }
                case 1349547969: {
                    this.sequence = TypeConvertor.castToString(value);
                    return value;
                }
                case -1106363674: {
                    this.length = TypeConvertor.castToInteger(value);
                    return value;
                }
                case 364621764: {
                    this.sequenceAttachment = TypeConvertor.castToAttachment(value);
                    return value;
                }
                case -182796415: {
                    this.nTerminalModificationId = TypeConvertor.castToIdentifier(value);
                    return value;
                }
                case -1497395258: {
                    this.nTerminalModification = TypeConvertor.castToString(value);
                    return value;
                }
                case -990303818: {
                    this.cTerminalModificationId = TypeConvertor.castToIdentifier(value);
                    return value;
                }
                case 472711995: {
                    this.cTerminalModification = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("subunit")) {
                this.subunit = TypeConvertor.castToInteger(value);
            } else if (name.equals("sequence")) {
                this.sequence = TypeConvertor.castToString(value);
            } else if (name.equals("length")) {
                this.length = TypeConvertor.castToInteger(value);
            } else if (name.equals("sequenceAttachment")) {
                this.sequenceAttachment = TypeConvertor.castToAttachment(value);
            } else if (name.equals("nTerminalModificationId")) {
                this.nTerminalModificationId = TypeConvertor.castToIdentifier(value);
            } else if (name.equals("nTerminalModification")) {
                this.nTerminalModification = TypeConvertor.castToString(value);
            } else if (name.equals("cTerminalModificationId")) {
                this.cTerminalModificationId = TypeConvertor.castToIdentifier(value);
            } else if (name.equals("cTerminalModification")) {
                this.cTerminalModification = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("subunit")) {
                this.subunit = null;
            } else if (name.equals("sequence")) {
                this.sequence = null;
            } else if (name.equals("length")) {
                this.length = null;
            } else if (name.equals("sequenceAttachment")) {
                this.sequenceAttachment = null;
            } else if (name.equals("nTerminalModificationId")) {
                this.nTerminalModificationId = null;
            } else if (name.equals("nTerminalModification")) {
                this.nTerminalModification = null;
            } else if (name.equals("cTerminalModificationId")) {
                this.cTerminalModificationId = null;
            } else if (name.equals("cTerminalModification")) {
                this.cTerminalModification = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1867548732: {
                    return this.getSubunitElement();
                }
                case 1349547969: {
                    return this.getSequenceElement();
                }
                case -1106363674: {
                    return this.getLengthElement();
                }
                case 364621764: {
                    return this.getSequenceAttachment();
                }
                case -182796415: {
                    return this.getNTerminalModificationId();
                }
                case -1497395258: {
                    return this.getNTerminalModificationElement();
                }
                case -990303818: {
                    return this.getCTerminalModificationId();
                }
                case 472711995: {
                    return this.getCTerminalModificationElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1867548732: {
                    return new String[]{"integer"};
                }
                case 1349547969: {
                    return new String[]{"string"};
                }
                case -1106363674: {
                    return new String[]{"integer"};
                }
                case 364621764: {
                    return new String[]{"Attachment"};
                }
                case -182796415: {
                    return new String[]{"Identifier"};
                }
                case -1497395258: {
                    return new String[]{"string"};
                }
                case -990303818: {
                    return new String[]{"Identifier"};
                }
                case 472711995: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("subunit")) {
                throw new FHIRException("Cannot call addChild on a singleton property SubstanceProtein.subunit.subunit");
            }
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a singleton property SubstanceProtein.subunit.sequence");
            }
            if (name.equals("length")) {
                throw new FHIRException("Cannot call addChild on a singleton property SubstanceProtein.subunit.length");
            }
            if (name.equals("sequenceAttachment")) {
                this.sequenceAttachment = new Attachment();
                return this.sequenceAttachment;
            }
            if (name.equals("nTerminalModificationId")) {
                this.nTerminalModificationId = new Identifier();
                return this.nTerminalModificationId;
            }
            if (name.equals("nTerminalModification")) {
                throw new FHIRException("Cannot call addChild on a singleton property SubstanceProtein.subunit.nTerminalModification");
            }
            if (name.equals("cTerminalModificationId")) {
                this.cTerminalModificationId = new Identifier();
                return this.cTerminalModificationId;
            }
            if (name.equals("cTerminalModification")) {
                throw new FHIRException("Cannot call addChild on a singleton property SubstanceProtein.subunit.cTerminalModification");
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceProteinSubunitComponent copy() {
            SubstanceProteinSubunitComponent dst = new SubstanceProteinSubunitComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubstanceProteinSubunitComponent dst) {
            super.copyValues(dst);
            dst.subunit = this.subunit == null ? null : this.subunit.copy();
            dst.sequence = this.sequence == null ? null : this.sequence.copy();
            dst.length = this.length == null ? null : this.length.copy();
            dst.sequenceAttachment = this.sequenceAttachment == null ? null : this.sequenceAttachment.copy();
            dst.nTerminalModificationId = this.nTerminalModificationId == null ? null : this.nTerminalModificationId.copy();
            dst.nTerminalModification = this.nTerminalModification == null ? null : this.nTerminalModification.copy();
            dst.cTerminalModificationId = this.cTerminalModificationId == null ? null : this.cTerminalModificationId.copy();
            dst.cTerminalModification = this.cTerminalModification == null ? null : this.cTerminalModification.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceProteinSubunitComponent)) {
                return false;
            }
            SubstanceProteinSubunitComponent o = (SubstanceProteinSubunitComponent)other_;
            return SubstanceProteinSubunitComponent.compareDeep(this.subunit, o.subunit, true) && SubstanceProteinSubunitComponent.compareDeep(this.sequence, o.sequence, true) && SubstanceProteinSubunitComponent.compareDeep(this.length, o.length, true) && SubstanceProteinSubunitComponent.compareDeep(this.sequenceAttachment, o.sequenceAttachment, true) && SubstanceProteinSubunitComponent.compareDeep(this.nTerminalModificationId, o.nTerminalModificationId, true) && SubstanceProteinSubunitComponent.compareDeep(this.nTerminalModification, o.nTerminalModification, true) && SubstanceProteinSubunitComponent.compareDeep(this.cTerminalModificationId, o.cTerminalModificationId, true) && SubstanceProteinSubunitComponent.compareDeep(this.cTerminalModification, o.cTerminalModification, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceProteinSubunitComponent)) {
                return false;
            }
            SubstanceProteinSubunitComponent o = (SubstanceProteinSubunitComponent)other_;
            return SubstanceProteinSubunitComponent.compareValues(this.subunit, o.subunit, true) && SubstanceProteinSubunitComponent.compareValues(this.sequence, o.sequence, true) && SubstanceProteinSubunitComponent.compareValues(this.length, o.length, true) && SubstanceProteinSubunitComponent.compareValues(this.nTerminalModification, o.nTerminalModification, true) && SubstanceProteinSubunitComponent.compareValues(this.cTerminalModification, o.cTerminalModification, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.subunit, this.sequence, this.length, this.sequenceAttachment, this.nTerminalModificationId, this.nTerminalModification, this.cTerminalModificationId, this.cTerminalModification});
        }

        @Override
        public String fhirType() {
            return "SubstanceProtein.subunit";
        }
    }
}

