/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.conformance.profile.BindingResolution;
import org.hl7.fhir.r5.conformance.profile.ProfileKnowledgeProvider;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.renderers.CodeResolver;
import org.hl7.fhir.r5.renderers.DataRenderer;
import org.hl7.fhir.r5.renderers.IMarkdownProcessor;
import org.hl7.fhir.r5.renderers.Renderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.xhtml.HierarchicalTableGenerator;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.utilities.xhtml.XhtmlNodeList;

public class AdditionalBindingsRenderer {
    private static String STYLE_UNCHANGED = "opacity: 0.5;";
    private static String STYLE_REMOVED = STYLE_UNCHANGED + "text-decoration: line-through;";
    private List<AdditionalBindingDetail> bindings = new ArrayList<AdditionalBindingDetail>();
    private ProfileKnowledgeProvider pkp;
    private String corePath;
    private StructureDefinition profile;
    private String path;
    private RenderingContext context;
    private IMarkdownProcessor md;
    private CodeResolver cr;

    public AdditionalBindingsRenderer(ProfileKnowledgeProvider pkp, String corePath, StructureDefinition profile, String path, RenderingContext context, IMarkdownProcessor md, CodeResolver cr) {
        this.pkp = pkp;
        this.corePath = corePath;
        this.profile = profile;
        this.path = path;
        this.context = context;
        this.md = md;
        this.cr = cr;
    }

    public void seeMaxBinding(Extension ext) {
        this.seeMaxBinding(ext, null, false);
    }

    public void seeMaxBinding(Extension ext, Extension compExt, boolean compare) {
        this.seeBinding(ext, compExt, compare, "maximum");
    }

    protected void seeBinding(Extension ext, Extension compExt, boolean compare, String label) {
        AdditionalBindingDetail abr = new AdditionalBindingDetail();
        abr.purpose = label;
        abr.valueSet = ext.getValue().primitiveValue();
        if (compare) {
            abr.isUnchanged = compExt != null && ext.getValue().primitiveValue().equals(compExt.getValue().primitiveValue());
            (abr.compare = (AdditionalBindingsRenderer)this.new AdditionalBindingDetail()).valueSet = compExt == null ? null : compExt.getValue().primitiveValue();
        } else {
            abr.isUnchanged = ext.hasUserData("derivation.equals");
        }
        this.bindings.add(abr);
    }

    public void seeMinBinding(Extension ext) {
        this.seeMinBinding(ext, null, false);
    }

    public void seeMinBinding(Extension ext, Extension compExt, boolean compare) {
        this.seeBinding(ext, compExt, compare, "minimum");
    }

    public void seeAdditionalBindings(List<Extension> list) {
        this.seeAdditionalBindings(list, null, false);
    }

    public void seeAdditionalBindings(List<Extension> list, List<Extension> compList, boolean compare) {
        AdditionalBindingDetail abr;
        HashMap<String, AdditionalBindingDetail> compBindings = new HashMap<String, AdditionalBindingDetail>();
        if (compare && compList != null) {
            for (Extension ext : compList) {
                abr = this.additionalBinding(ext);
                if (compBindings.containsKey(abr.getKey())) {
                    abr.incrementCount();
                }
                compBindings.put(abr.getKey(), abr);
            }
        }
        for (Extension ext : list) {
            abr = this.additionalBinding(ext);
            if (compare && compList != null) {
                AdditionalBindingDetail match = null;
                do {
                    match = (AdditionalBindingDetail)compBindings.get(abr.getKey());
                    if (!abr.alreadyMatched()) continue;
                    abr.incrementCount();
                } while (match != null && abr.alreadyMatched());
                if (match != null) {
                    abr.setCompare(match);
                }
                this.bindings.add(abr);
                if (abr.compare == null) continue;
                compBindings.remove(abr.compare.getKey());
                continue;
            }
            this.bindings.add(abr);
        }
        for (AdditionalBindingDetail b : compBindings.values()) {
            b.removed = true;
            this.bindings.add(b);
        }
    }

    protected AdditionalBindingDetail additionalBinding(Extension ext) {
        AdditionalBindingDetail abr = new AdditionalBindingDetail();
        abr.purpose = ext.getExtensionString("purpose");
        abr.valueSet = ext.getExtensionString("valueSet");
        abr.doco = ext.getExtensionString("documentation");
        abr.docoShort = ext.getExtensionString("shortDoco");
        for (Extension x : ext.getExtensionsByUrl("usage")) {
            if (!x.hasValueUsageContext()) continue;
            abr.usages.add(x.getValueUsageContext());
        }
        abr.any = "any".equals(ext.getExtensionString("scope"));
        abr.isUnchanged = ext.hasUserData("derivation.equals");
        return abr;
    }

    protected AdditionalBindingDetail additionalBinding(ElementDefinition.ElementDefinitionBindingAdditionalComponent ab) {
        AdditionalBindingDetail abr = new AdditionalBindingDetail();
        abr.purpose = ab.getPurpose().toCode();
        abr.valueSet = ab.getValueSet();
        abr.doco = ab.getDocumentation();
        abr.docoShort = ab.getShortDoco();
        abr.usages.addAll(ab.getUsage());
        abr.any = ab.getAny();
        abr.isUnchanged = ab.hasUserData("derivation.equals");
        return abr;
    }

    public String render() throws IOException {
        if (this.bindings.isEmpty()) {
            return "";
        }
        XhtmlNode tbl = new XhtmlNode(NodeType.Element, "table");
        tbl.attribute("class", "grid");
        this.render((List<XhtmlNode>)tbl.getChildNodes(), true);
        return new XhtmlComposer(false).compose(tbl);
    }

    public void render(HierarchicalTableGenerator gen, HierarchicalTableGenerator.Cell c) throws FHIRFormatError, DefinitionException, IOException {
        if (this.bindings.isEmpty()) {
            return;
        }
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.Piece piece = new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "table").attr("class", "grid");
        c.getPieces().add(piece);
        this.render((List<XhtmlNode>)piece.getChildren(), false);
    }

    public void render(List<XhtmlNode> children, boolean fullDoco) throws FHIRFormatError, DefinitionException, IOException {
        boolean doco = false;
        boolean usage = false;
        boolean any = false;
        for (AdditionalBindingDetail binding : this.bindings) {
            doco = doco || binding.getDoco(fullDoco) != null || binding.compare != null && binding.compare.getDoco(fullDoco) != null;
            usage = usage || !binding.usages.isEmpty() || binding.compare != null && !binding.compare.usages.isEmpty();
            any = any || binding.any || binding.compare != null && binding.compare.any;
        }
        XhtmlNode tr = new XhtmlNode(NodeType.Element, "tr");
        children.add(tr);
        tr.td().style("font-size: 11px").b().tx(this.context.formatPhrase("ADD_BIND_ADD_BIND", new Object[0]));
        tr.td().style("font-size: 11px").tx(this.context.formatPhrase("GENERAL_PURPOSE", new Object[0]));
        if (usage) {
            tr.td().style("font-size: 11px").tx(this.context.formatPhrase("GENERAL_USAGE", new Object[0]));
        }
        if (any) {
            tr.td().style("font-size: 11px").tx(this.context.formatPhrase("ADD_BIND_ANY", new Object[0]));
        }
        if (doco) {
            tr.td().style("font-size: 11px").tx(this.context.formatPhrase("GENERAL_DOCUMENTATION", new Object[0]));
        }
        for (AdditionalBindingDetail binding : this.bindings) {
            tr = new XhtmlNode(NodeType.Element, "tr");
            if (binding.unchanged()) {
                tr.style(STYLE_REMOVED);
            } else if (binding.removed) {
                tr.style(STYLE_REMOVED);
            }
            children.add(tr);
            BindingResolution br = this.pkp == null ? this.makeNullBr(binding) : this.pkp.resolveBinding(this.profile, binding.valueSet, this.path);
            BindingResolution compBr = null;
            if (binding.compare != null && binding.compare.valueSet != null) {
                compBr = this.pkp == null ? this.makeNullBr(binding.compare) : this.pkp.resolveBinding(this.profile, binding.compare.valueSet, this.path);
            }
            XhtmlNode valueset = tr.td().style("font-size: 11px");
            if (binding.compare != null && binding.valueSet.equals(binding.compare.valueSet)) {
                valueset.style(STYLE_UNCHANGED);
            }
            if (br.url != null) {
                XhtmlNode a = valueset.ah(this.context.prefixLocalHref(this.determineUrl(br.url)), br.uri);
                a.tx(br.display);
                if (br.external) {
                    a.tx(" ");
                    a.img("external.png", null);
                }
            } else {
                valueset.span(null, binding.valueSet).tx(br.display);
            }
            if (binding.compare != null && binding.compare.valueSet != null && !binding.valueSet.equals(binding.compare.valueSet)) {
                valueset.br();
                valueset = valueset.span(STYLE_REMOVED, null);
                if (compBr.url != null) {
                    valueset.ah(this.context.prefixLocalHref(this.determineUrl(compBr.url)), binding.compare.valueSet).tx(compBr.display);
                } else {
                    valueset.span(null, binding.compare.valueSet).tx(compBr.display);
                }
            }
            XhtmlNode purpose = tr.td().style("font-size: 11px");
            if (binding.compare != null && binding.purpose.equals(binding.compare.purpose)) {
                purpose.style("font-color: darkgray");
            }
            this.renderPurpose(purpose, binding.purpose);
            if (binding.compare != null && binding.compare.purpose != null && !binding.purpose.equals(binding.compare.purpose)) {
                purpose.br();
                purpose = purpose.span(STYLE_UNCHANGED, null);
                this.renderPurpose(purpose, binding.compare.purpose);
            }
            if (usage) {
                if (!binding.usages.isEmpty()) {
                    XhtmlNode td = tr.td();
                    for (UsageContext uc : binding.usages) {
                        td.sep(", ");
                        new DataRenderer(this.context).renderBase(new Renderer.RenderingStatus(), td, uc);
                    }
                } else {
                    tr.td();
                }
            }
            if (any) {
                String newRepeat = binding.any ? this.context.formatPhrase("ADD_BIND_ANY_REP", new Object[0]) : this.context.formatPhrase("ADD_BIND_ALL_REP", new Object[0]);
                String oldRepeat = binding.compare != null && binding.compare.any ? this.context.formatPhrase("ADD_BIND_ANY_REP", new Object[0]) : this.context.formatPhrase("ADD_BIND_ALL_REP", new Object[0]);
                this.compareString(tr.td().style("font-size: 11px"), newRepeat, oldRepeat);
            }
            if (!doco) continue;
            if (binding.doco != null) {
                String d;
                String string = d = fullDoco ? this.md.processMarkdown("Binding.description", binding.doco) : binding.docoShort;
                String oldD = binding.compare == null ? null : (fullDoco ? this.md.processMarkdown("Binding.description.compare", binding.compare.doco) : binding.compare.docoShort);
                tr.td().style("font-size: 11px").innerHTML(this.compareHtml(d, oldD));
                continue;
            }
            tr.td().style("font-size: 11px");
        }
    }

    private XhtmlNode compareString(XhtmlNode node, String newS, String oldS) {
        if (oldS == null) {
            return node.tx(newS);
        }
        if (newS.equals(oldS)) {
            return node.style(STYLE_UNCHANGED).tx(newS);
        }
        node.tx(newS);
        node.br();
        return node.span(STYLE_REMOVED, null).tx(oldS);
    }

    private String compareHtml(String newS, String oldS) {
        if (oldS == null) {
            return newS;
        }
        if (newS.equals(oldS)) {
            return "<span style=\"" + STYLE_UNCHANGED + "\">" + newS + "</span>";
        }
        return newS + "<br/><span style=\"" + STYLE_REMOVED + "\">" + oldS + "</span>";
    }

    private String determineUrl(String url) {
        return Utilities.isAbsoluteUrl((String)url) || !this.pkp.prependLinks() ? url : this.corePath + url;
    }

    private void renderPurpose(XhtmlNode td, String purpose) {
        boolean r5 = this.context == null || this.context.getWorker() == null ? false : VersionUtilities.isR5Plus((String)this.context.getWorker().getVersion());
        switch (purpose) {
            case "maximum": {
                td.ah(r5 ? this.corePath + "valueset-additional-binding-purpose.html#additional-binding-purpose-maximum" : this.corePath + "extension-elementdefinition-maxvalueset.html", this.context.formatPhrase("ADD_BIND_EXT_PREF", new Object[0])).tx(this.context.formatPhrase("ADD_BIND_MAX", new Object[0]));
                break;
            }
            case "minimum": {
                td.ah(r5 ? this.corePath + "valueset-additional-binding-purpose.html#additional-binding-purpose-minimum" : this.corePath + "extension-elementdefinition-minvalueset.html", this.context.formatPhrase("GENERAL_BIND_MIN_ALLOW", new Object[0])).tx(this.context.formatPhrase("ADD_BIND_MIN", new Object[0]));
                break;
            }
            case "required": {
                td.ah(r5 ? this.corePath + "valueset-additional-binding-purpose.html#additional-binding-purpose-required" : this.corePath + "terminologies.html#strength", this.context.formatPhrase("ADD_BIND_VALID_REQ", new Object[0])).tx(this.context.formatPhrase("ADD_BIND_REQ_BIND", new Object[0]));
                break;
            }
            case "extensible": {
                td.ah(r5 ? this.corePath + "valueset-additional-binding-purpose.html#additional-binding-purpose-extensible" : this.corePath + "terminologies.html#strength", this.context.formatPhrase("ADD_BIND_VALID_EXT", new Object[0])).tx(this.context.formatPhrase("ADD_BIND_EX_BIND", new Object[0]));
                break;
            }
            case "preferred": {
                td.ah(r5 ? this.corePath + "valueset-additional-binding-purpose.html#additional-binding-purpose-preferred" : this.corePath + "terminologies.html#strength", this.context.formatPhrase("ADD_BIND_RECOM_VALUE_SET", new Object[0])).tx(this.context.formatPhrase("ADD_BIND_PREF_BIND", new Object[0]));
                break;
            }
            case "current": {
                if (r5) {
                    td.ah(this.corePath + "valueset-additional-binding-purpose.html#additional-binding-purpose-current", this.context.formatPhrase("ADD_BIND_NEW_REC", new Object[0])).tx(this.context.formatPhrase("ADD_BIND_CURR_BIND", new Object[0]));
                    break;
                }
                td.span(null, this.context.formatPhrase("ADD_BIND_NEW_REC", new Object[0])).tx(this.context.formatPhrase("GENERAL_REQUIRED", new Object[0]));
                break;
            }
            case "ui": {
                if (r5) {
                    td.ah(this.corePath + "valueset-additional-binding-purpose.html#additional-binding-purpose-ui", this.context.formatPhrase("ADD_BIND_GIVEN_CONT", new Object[0])).tx(this.context.formatPhrase("ADD_BIND_UI_BIND", new Object[0]));
                    break;
                }
                td.span(null, this.context.formatPhrase("ADD_BIND_GIVEN_CONT", new Object[0])).tx(this.context.formatPhrase("ADD_BIND_UI", new Object[0]));
                break;
            }
            case "starter": {
                if (r5) {
                    td.ah(this.corePath + "valueset-additional-binding-purpose.html#additional-binding-purpose-starter", "This value set is a good set of codes to start with when designing your system").tx("Starter Set");
                    break;
                }
                td.span(null, this.context.formatPhrase("ADD_BIND_DESIG_SYS", new Object[0])).tx(this.context.formatPhrase("GENERAL_STARTER", new Object[0]));
                break;
            }
            case "component": {
                if (r5) {
                    td.ah(this.corePath + "valueset-additional-binding-purpose.html#additional-binding-purpose-component", "This value set is a component of the base value set").tx("Component");
                    break;
                }
                td.span(null, this.context.formatPhrase("ADD_BIND_VALUE_COMP", new Object[0])).tx(this.context.formatPhrase("GENERAL_COMPONENT", new Object[0]));
                break;
            }
            default: {
                td.span(null, this.context.formatPhrase("ADD_BIND_UNKNOWN_PUR", new Object[0])).tx(purpose);
            }
        }
    }

    private BindingResolution makeNullBr(AdditionalBindingDetail binding) {
        BindingResolution br = new BindingResolution();
        br.url = "http://none.none/none";
        br.display = "todo";
        return br;
    }

    public boolean hasBindings() {
        return !this.bindings.isEmpty();
    }

    public void render(XhtmlNodeList children, List<ElementDefinition.ElementDefinitionBindingAdditionalComponent> list) {
        if (list.size() == 1) {
            this.render(children, list.get(0));
        } else {
            XhtmlNode ul = children.ul();
            for (ElementDefinition.ElementDefinitionBindingAdditionalComponent b : list) {
                this.render(ul.li().getChildNodes(), b);
            }
        }
    }

    private void render(XhtmlNodeList children, ElementDefinition.ElementDefinitionBindingAdditionalComponent b) {
        if (b.getValueSet() == null) {
            return;
        }
        BindingResolution br = this.pkp.resolveBinding(this.profile, b.getValueSet(), this.corePath);
        XhtmlNode a = children.ahOrCode((String)(br.url == null ? null : (Utilities.isAbsoluteUrl((String)br.url) || !this.context.getPkp().prependLinks() ? br.url : this.corePath + br.url)), b.hasDocumentation() ? b.getDocumentation() : br.uri);
        if (b.hasDocumentation()) {
            a.attribute("title", b.getDocumentation());
        }
        a.tx(br.display);
        if (b.hasShortDoco()) {
            children.tx(": ");
            children.tx(b.getShortDoco());
        }
        if (b.getAny() || b.hasUsage()) {
            boolean ffirst;
            children.tx(" (");
            boolean bl = ffirst = !b.getAny();
            if (b.getAny()) {
                children.tx(this.context.formatPhrase("ADD_BIND_ANY_REP", new Object[0]));
            }
            for (UsageContext uc : b.getUsage()) {
                if (ffirst) {
                    ffirst = false;
                } else {
                    children.tx(",");
                }
                if (!uc.getCode().is("http://terminology.hl7.org/CodeSystem/usage-context-type", "jurisdiction")) {
                    children.tx(this.displayForUsage(uc.getCode()));
                    children.tx("=");
                }
                CodeResolver.CodeResolution ccr = this.cr.resolveCode(uc.getValueCodeableConcept());
                children.ah(this.context.prefixLocalHref(ccr.getLink()), ccr.getHint()).tx(ccr.getDisplay());
            }
            children.tx(")");
        }
    }

    private String displayForUsage(Coding c) {
        if (c.hasDisplay()) {
            return c.getDisplay();
        }
        if ("http://terminology.hl7.org/CodeSystem/usage-context-type".equals(c.getSystem())) {
            return c.getCode();
        }
        return c.getCode();
    }

    public void seeAdditionalBinding(String purpose, String doco, ValueSet valueSet) {
        AdditionalBindingDetail abr = new AdditionalBindingDetail();
        abr.purpose = purpose;
        abr.valueSet = valueSet.getUrl();
        abr.vs = valueSet;
        this.bindings.add(abr);
    }

    public void seeAdditionalBinding(String purpose, String doco, String ref) {
        AdditionalBindingDetail abr = new AdditionalBindingDetail();
        abr.purpose = purpose;
        abr.valueSet = ref;
        this.bindings.add(abr);
    }

    public void seeAdditionalBindings(ElementDefinition definition, ElementDefinition compDef, boolean compare) {
        AdditionalBindingDetail abr;
        HashMap<String, AdditionalBindingDetail> compBindings = new HashMap<String, AdditionalBindingDetail>();
        if (compare && compDef.getBinding().getAdditional() != null) {
            for (ElementDefinition.ElementDefinitionBindingAdditionalComponent ab : compDef.getBinding().getAdditional()) {
                abr = this.additionalBinding(ab);
                if (compBindings.containsKey(abr.getKey())) {
                    abr.incrementCount();
                }
                compBindings.put(abr.getKey(), abr);
            }
        }
        for (ElementDefinition.ElementDefinitionBindingAdditionalComponent ab : definition.getBinding().getAdditional()) {
            abr = this.additionalBinding(ab);
            if (compare && compDef != null) {
                AdditionalBindingDetail match = null;
                do {
                    match = (AdditionalBindingDetail)compBindings.get(abr.getKey());
                    if (!abr.alreadyMatched()) continue;
                    abr.incrementCount();
                } while (match != null && abr.alreadyMatched());
                if (match != null) {
                    abr.setCompare(match);
                }
                this.bindings.add(abr);
                if (abr.compare == null) continue;
                compBindings.remove(abr.compare.getKey());
                continue;
            }
            this.bindings.add(abr);
        }
        for (AdditionalBindingDetail b : compBindings.values()) {
            b.removed = true;
            this.bindings.add(b);
        }
    }

    public class AdditionalBindingDetail {
        private String purpose;
        private String valueSet;
        private String doco;
        private String docoShort;
        private List<UsageContext> usages = new ArrayList<UsageContext>();
        private boolean any = false;
        private boolean isUnchanged = false;
        private boolean matched = false;
        private boolean removed = false;
        private ValueSet vs;
        private AdditionalBindingDetail compare;
        private int count = 1;

        private String getKey() {
            return this.purpose + Integer.toString(this.count);
        }

        private void incrementCount() {
            ++this.count;
        }

        private void setCompare(AdditionalBindingDetail match) {
            this.compare = match;
            match.matched = true;
        }

        private boolean alreadyMatched() {
            return this.matched;
        }

        public String getDoco(boolean full) {
            return full ? this.doco : this.docoShort;
        }

        public boolean unchanged() {
            if (!this.isUnchanged) {
                return false;
            }
            if (this.compare == null) {
                return true;
            }
            this.isUnchanged = true;
            this.isUnchanged = this.isUnchanged && (this.purpose == null && this.compare.purpose == null || this.purpose.equals(this.compare.purpose));
            this.isUnchanged = this.isUnchanged && (this.valueSet == null && this.compare.valueSet == null || this.valueSet.equals(this.compare.valueSet));
            this.isUnchanged = this.isUnchanged && (this.doco == null && this.compare.doco == null || this.doco.equals(this.compare.doco));
            this.isUnchanged = this.isUnchanged && (this.docoShort == null && this.compare.docoShort == null || this.docoShort.equals(this.compare.docoShort));
            this.isUnchanged = this.isUnchanged && (this.usages == null && this.compare.usages == null || this.usages.equals(this.compare.usages));
            return this.isUnchanged;
        }
    }
}

