/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers.spreadsheets;

import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.renderers.spreadsheets.SpreadsheetGenerator;

public class CanonicalSpreadsheetGenerator
extends SpreadsheetGenerator {
    public CanonicalSpreadsheetGenerator(IWorkerContext context) {
        super(context);
    }

    protected Sheet renderCanonicalResource(CanonicalResource cr, boolean forMultiple) {
        Sheet sheet = forMultiple && this.hasSheet("Metadata") ? this.getSheet("Metadata") : this.makeSheet("Metadata");
        Row headerRow = sheet.createRow(forMultiple ? sheet.getLastRowNum() + 1 : 0);
        this.addCell(headerRow, 0, "Property", (CellStyle)this.styles.get("header"));
        this.addCell(headerRow, 1, "Value", (CellStyle)this.styles.get("header"));
        if (forMultiple) {
            this.addMetadataRow(sheet, "ID", cr.getId());
        }
        this.addMetadataRow(sheet, "URL", cr.getUrl());
        for (Identifier id : cr.getIdentifier()) {
            this.addMetadataRow(sheet, "Identifier", this.dr.displayDataType(id));
        }
        this.addMetadataRow(sheet, "Version", cr.getVersion());
        this.addMetadataRow(sheet, "Name", cr.getName());
        this.addMetadataRow(sheet, "Title", cr.getTitle());
        this.addMetadataRow(sheet, "Status", cr.getStatusElement().asStringValue());
        this.addMetadataRow(sheet, "Experimental", cr.getExperimentalElement().asStringValue());
        this.addMetadataRow(sheet, "Date", cr.getDateElement().asStringValue());
        this.addMetadataRow(sheet, "Publisher", cr.getPublisher());
        for (ContactDetail c : cr.getContact()) {
            this.addMetadataRow(sheet, "Contact", this.dr.displayDataType(c));
        }
        for (CodeableConcept j : cr.getJurisdiction()) {
            this.addMetadataRow(sheet, "Jurisdiction", this.dr.displayDataType(j));
        }
        this.addMetadataRow(sheet, "Description", cr.getDescription());
        this.addMetadataRow(sheet, "Purpose", cr.getPurpose());
        this.addMetadataRow(sheet, "Copyright", cr.getCopyright());
        this.configureSheet(sheet);
        return sheet;
    }

    private void configureSheet(Sheet sheet) {
        sheet.setColumnWidth(0, this.columnPixels(15.0));
        sheet.setColumnWidth(1, this.columnPixels(80.0));
    }

    protected void addMetadataRow(Sheet sheet, String name, String value) {
        Row row = sheet.createRow(sheet.getLastRowNum() + 1);
        this.addCell(row, 0, name, (CellStyle)this.styles.get("body"));
        this.addCell(row, 1, value);
    }
}

