/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers.utils;

import java.io.IOException;
import java.util.Collection;
import java.util.Locale;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.renderers.utils.ResourceWrapper;
import org.hl7.fhir.utilities.NamedItemList;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class ResourceWrapperModel
extends ResourceWrapper {
    protected Element model;

    ResourceWrapperModel() {
    }

    private ResourceWrapperModel makeChild(String name, int index, ResourceWrapper.ElementKind kind, Element em) {
        ResourceWrapperModel self = new ResourceWrapperModel();
        self.contextUtils = this.contextUtils;
        self.parent = this;
        self.name = name;
        self.index = index;
        self.kind = kind;
        self.model = em;
        return self;
    }

    @Override
    public String fhirVersion() {
        return this.model.getFHIRPublicationVersion().toCode();
    }

    @Override
    public String fhirType() {
        if (this.kind == ResourceWrapper.ElementKind.BackboneElement) {
            return this.basePath();
        }
        return this.model.fhirType();
    }

    @Override
    public boolean isPrimitive() {
        return this.model.isPrimitive();
    }

    @Override
    public boolean hasPrimitiveValue() {
        return this.model.hasPrimitiveValue();
    }

    @Override
    public String primitiveValue() {
        return this.model.primitiveValue();
    }

    @Override
    protected void loadTheChildren() {
        for (Element child : this.model.getChildren()) {
            String name = child.getProperty().isChoice() ? child.getProperty().getName() : child.getName();
            int index = child.isList() ? child.getIndex() : -1;
            ResourceWrapper.ElementKind kind = this.determineModelKind(child);
            this.children.add(this.makeChild(name, index, kind, child));
        }
    }

    private ResourceWrapper.ElementKind determineModelKind(Element child) {
        if (child.isPrimitive()) {
            return ResourceWrapper.ElementKind.PrimitiveType;
        }
        if (child.fhirType().contains("Backbone")) {
            return ResourceWrapper.ElementKind.BackboneElement;
        }
        if (child.getProperty().getContextUtils().isDatatype(child.fhirType())) {
            return ResourceWrapper.ElementKind.DataType;
        }
        if (!child.isResource()) {
            return ResourceWrapper.ElementKind.BackboneElement;
        }
        switch (child.getSpecial()) {
            case BUNDLE_ENTRY: {
                return ResourceWrapper.ElementKind.BundleEntry;
            }
            case BUNDLE_ISSUES: {
                return ResourceWrapper.ElementKind.InlineResource;
            }
            case BUNDLE_OUTCOME: {
                return ResourceWrapper.ElementKind.InlineResource;
            }
            case CONTAINED: {
                return ResourceWrapper.ElementKind.ContainedResource;
            }
            case PARAMETER: {
                return ResourceWrapper.ElementKind.InlineResource;
            }
        }
        return ResourceWrapper.ElementKind.IndependentResource;
    }

    @Override
    public boolean isResource() {
        return this.model.isResource();
    }

    @Override
    public boolean canHaveNarrative() {
        if (!this.isResource()) {
            return false;
        }
        return this.contextUtils.isDomainResource(this.fhirType());
    }

    @Override
    public XhtmlNode getNarrative() {
        if (!this.canHaveNarrative()) {
            return null;
        }
        ResourceWrapper text = this.child("text");
        if (text == null) {
            return null;
        }
        ResourceWrapper div = text.child("div");
        if (div == null) {
            return null;
        }
        return ((ResourceWrapperModel)div).model.getXhtml();
    }

    @Override
    public boolean hasNarrative() {
        if (!this.canHaveNarrative()) {
            return false;
        }
        ResourceWrapper text = this.child("text");
        if (text == null) {
            return false;
        }
        ResourceWrapper div = text.child("div");
        if (div == null) {
            return false;
        }
        return ((ResourceWrapperModel)div).model.getXhtml() != null;
    }

    @Override
    public void setNarrative(XhtmlNode x, String status, boolean multiLangMode, Locale locale, boolean isPretty) throws IOException {
        Element st;
        Element txt = this.model.getNamedChild("text");
        if (txt == null) {
            int i;
            txt = new Element("text", this.model.getProperty().getChild(null, "text"));
            for (i = 0; i < this.model.getChildren().size() && (((Element)this.model.getChildren().get(i)).getName().equals("id") || ((Element)this.model.getChildren().get(i)).getName().equals("meta") || ((Element)this.model.getChildren().get(i)).getName().equals("implicitRules") || ((Element)this.model.getChildren().get(i)).getName().equals("language")); ++i) {
            }
            if (i >= this.model.getChildren().size()) {
                this.model.getChildren().add((NamedItemList.NamedItem)txt);
            } else {
                this.model.getChildren().add(i, (NamedItemList.NamedItem)txt);
            }
        }
        if ((st = txt.getNamedChild("status")) == null) {
            st = new Element("status", txt.getProperty().getChild(null, "status"));
            txt.getChildren().add(0, (NamedItemList.NamedItem)st);
        }
        st.setValue(status);
        Element div = txt.getNamedChild("div");
        if (div == null) {
            div = new Element("div", txt.getProperty().getChild(null, "div"));
            txt.getChildren().add((NamedItemList.NamedItem)div);
        }
        if (multiLangMode) {
            XhtmlNode xd = div.getXhtml();
            if (xd == null) {
                xd = new XhtmlNode(NodeType.Element, "div");
                xd.setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
                div.setXhtml(xd);
            } else {
                xd.getChildNodes().removeIf(c -> !"div".equals(c.getName()) || !c.hasAttribute("xml:lang"));
            }
            this.markLanguage(x, locale);
            xd.addChildNode(x);
        } else {
            String l;
            if (!x.hasAttribute("xmlns")) {
                x.setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
            }
            if (!Utilities.noString((String)(l = this.model.getChildValue("language")))) {
                x.setAttribute("lang", l);
                x.setAttribute("xml:lang", l);
            }
            div.setXhtml(x);
        }
        div.setValue(new XhtmlComposer(true, isPretty).compose(div.getXhtml()));
    }

    @Override
    public void markLanguage(XhtmlNode x, Locale locale) {
        x.setAttribute("lang", locale.toString());
        x.setAttribute("xml:lang", locale.toString());
        x.addTag(0, "hr");
        x.addTag(0, "p").b().tx(locale.getDisplayName());
        x.addTag(0, "hr");
    }

    @Override
    public String getId() {
        return this.model.getIdBase();
    }

    public String toString() {
        return this.name + (String)(this.index == -1 ? "" : "[" + this.index + "]") + ": " + this.fhirType() + " (" + this.kind + "/" + this.path() + "): element = " + this.model.fhirType() + " -> " + this.model.toString();
    }

    public boolean matches(ResourceWrapperModel b) {
        if (this.isEmpty() || b.isEmpty()) {
            return this.isEmpty() && b.isEmpty();
        }
        if (!(!this.hasPrimitiveValue() && !b.hasPrimitiveValue() || this.hasPrimitiveValue() && b.hasPrimitiveValue() && this.primitiveValue().equals(b.primitiveValue()))) {
            return false;
        }
        if (this.children().size() != b.children().size()) {
            return false;
        }
        for (int i = 0; i < this.children().size(); ++i) {
            if (this.children().get(i).matches(b.children().get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Resource getResourceNative() {
        return null;
    }

    @Override
    public boolean hasFormatComment() {
        return this.model.hasFormatComment();
    }

    @Override
    public Collection<String> getFormatCommentsPre() {
        return this.model.getFormatCommentsPre();
    }

    @Override
    public XhtmlNode getXhtml() {
        return this.model.getXhtml();
    }

    @Override
    public Base getBase() {
        return this.model;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public String getWebPath() {
        return null;
    }

    @Override
    public String getCodeSystemUri() {
        ValueSet vs;
        ElementDefinition pd = this.model.getProperty().getDefinition();
        if (pd != null && pd.hasBinding() && pd.getBinding().hasValueSet() && (vs = this.contextUtils.getWorker().fetchResource(ValueSet.class, pd.getBinding().getValueSet())) != null && vs.hasCompose() && !vs.getCompose().hasExclude() && vs.getCompose().getInclude().size() == 1) {
            return vs.getCompose().getIncludeFirstRep().getSystem();
        }
        return null;
    }
}

