/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies.client;

import java.util.EnumSet;
import java.util.Map;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.utils.client.network.ClientHeaders;
import org.hl7.fhir.utilities.FhirPublication;
import org.hl7.fhir.utilities.ToolingClientLogger;

public interface ITerminologyClient {
    public EnumSet<FhirPublication> supportableVersions();

    public void setAllowedVersions(EnumSet<FhirPublication> var1);

    public EnumSet<FhirPublication> getAllowedVersions();

    public FhirPublication getActualVersion();

    public String getId();

    public String getAddress();

    public String getServerVersion();

    public TerminologyCapabilities getTerminologyCapabilities() throws FHIRException;

    public ValueSet expandValueset(ValueSet var1, Parameters var2) throws FHIRException;

    public Parameters validateCS(Parameters var1) throws FHIRException;

    public Parameters validateVS(Parameters var1) throws FHIRException;

    public Parameters subsumes(Parameters var1) throws FHIRException;

    public ITerminologyClient setTimeoutFactor(int var1) throws FHIRException;

    public ToolingClientLogger getLogger();

    public ITerminologyClient setLogger(ToolingClientLogger var1) throws FHIRException;

    public int getRetryCount() throws FHIRException;

    public ITerminologyClient setRetryCount(int var1) throws FHIRException;

    public CapabilityStatement getCapabilitiesStatementQuick() throws FHIRException;

    public Parameters lookupCode(Map<String, String> var1) throws FHIRException;

    public Parameters lookupCode(Parameters var1) throws FHIRException;

    public Parameters translate(Parameters var1) throws FHIRException;

    public Bundle validateBatch(Bundle var1);

    public CanonicalResource read(String var1, String var2);

    public ClientHeaders getClientHeaders();

    public ITerminologyClient setClientHeaders(ClientHeaders var1);

    public ITerminologyClient setUserAgent(String var1);

    public ITerminologyClient setAcceptLanguage(String var1);

    public ITerminologyClient setContentLanguage(String var1);

    public String getUserAgent();

    public int getUseCount();

    public Bundle search(String var1, String var2);
}

