/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.test.utils;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.json.model.JsonArray;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonNull;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.model.JsonPrimitive;
import org.hl7.fhir.utilities.json.model.JsonProperty;
import org.hl7.fhir.utilities.json.parser.JsonParser;
import org.hl7.fhir.utilities.settings.FhirSettings;
import org.hl7.fhir.utilities.tests.BaseTestingUtilities;
import org.hl7.fhir.utilities.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class CompareUtilities
extends BaseTestingUtilities {
    private static final boolean SHOW_DIFF = false;
    private JsonObject externals;

    public String createNotEqualMessage(String id, String message, String expected, String actual) {
        return message + '\n' + "Expected:" + this.presentExpected(expected) + (" for " + id) + '\n' + "Actual  :" + ("\"" + actual + "\"");
    }

    private String presentExpected(String expected) {
        if (expected == null) {
            return "null";
        }
        if (expected.startsWith("$") && expected.endsWith("$")) {
            if (expected.startsWith("$choice:")) {
                return "Contains one of " + this.readChoices(expected.substring(8, expected.length() - 1)).toString();
            }
            if (expected.startsWith("$fragments:")) {
                List<String> fragments = this.readChoices(expected.substring(11, expected.length() - 1));
                return "Contains all of " + fragments.toString();
            }
            if (expected.startsWith("$external:")) {
                String[] cmd = expected.substring(1, expected.length() - 1).split(":");
                if (this.externals != null) {
                    String s = this.externals.asString(cmd[1]);
                    return "\"" + s + "\" (Ext)";
                }
                List<String> fragments = this.readChoices(cmd[2]);
                return "Contains all of " + fragments.toString() + " (because no external string provided for " + cmd[1] + ")";
            }
            switch (expected) {
                case "$$": {
                    return "$$";
                }
                case "$instant$": {
                    return "\"An Instant\"";
                }
                case "$uuid$": {
                    return "\"A Uuid\"";
                }
                case "$id$": {
                    return "\"An Id\"";
                }
            }
            return "Unhandled template: " + expected;
        }
        return "\"" + expected + "\"";
    }

    public static String checkXMLIsSame(String id, InputStream expected, InputStream actual) throws Exception {
        CompareUtilities self = new CompareUtilities();
        String result = self.compareXml(id, expected, actual);
        return result;
    }

    public static String checkXMLIsSame(String id, String expected, String actual) throws Exception {
        CompareUtilities self = new CompareUtilities();
        String result = self.compareXml(id, expected, actual);
        if (result != null) {
            // empty if block
        }
        return result;
    }

    private static String getDiffTool() throws IOException {
        if (FhirSettings.hasDiffToolPath()) {
            return FhirSettings.getDiffToolPath();
        }
        if (System.getenv("ProgramFiles") != null) {
            return Utilities.path((String[])new String[]{System.getenv("ProgramFiles"), "WinMerge", "WinMergeU.exe"});
        }
        return null;
    }

    private String compareXml(String id, InputStream expected, InputStream actual) throws Exception {
        return this.compareElements(id, "", this.loadXml(expected).getDocumentElement(), this.loadXml(actual).getDocumentElement());
    }

    private String compareXml(String id, String expected, String actual) throws Exception {
        return this.compareElements(id, "", this.loadXml(expected).getDocumentElement(), this.loadXml(actual).getDocumentElement());
    }

    private String compareElements(String id, String path, Element expectedElement, Element actualElement) {
        if (!this.namespacesMatch(expectedElement.getNamespaceURI(), actualElement.getNamespaceURI())) {
            return this.createNotEqualMessage(id, "Namespaces differ at " + (String)path, expectedElement.getNamespaceURI(), actualElement.getNamespaceURI());
        }
        if (!expectedElement.getLocalName().equals(actualElement.getLocalName())) {
            return this.createNotEqualMessage(id, "Names differ at " + (String)path, expectedElement.getLocalName(), actualElement.getLocalName());
        }
        String s = this.compareAttributes(id, (String)(path = (String)path + "/" + expectedElement.getLocalName()), expectedElement.getAttributes(), actualElement.getAttributes());
        if (!Utilities.noString((String)s)) {
            return s;
        }
        s = this.compareAttributes(id, (String)path, expectedElement.getAttributes(), actualElement.getAttributes());
        if (!Utilities.noString((String)s)) {
            return s;
        }
        Node expectedChild = expectedElement.getFirstChild();
        Node actualChild = actualElement.getFirstChild();
        expectedChild = this.skipBlankText(expectedChild);
        actualChild = this.skipBlankText(actualChild);
        while (expectedChild != null && actualChild != null) {
            if (expectedChild.getNodeType() != actualChild.getNodeType()) {
                return this.createNotEqualMessage(id, "node type mismatch in children of " + (String)path, Short.toString(expectedElement.getNodeType()), Short.toString(actualElement.getNodeType()));
            }
            if (expectedChild.getNodeType() == 3) {
                if (!this.normalise(expectedChild.getTextContent()).equals(this.normalise(actualChild.getTextContent()))) {
                    return this.createNotEqualMessage(id, "Text differs at " + (String)path, this.normalise(expectedChild.getTextContent()).toString(), this.normalise(actualChild.getTextContent()).toString());
                }
            } else if (expectedChild.getNodeType() == 1 && !Utilities.noString((String)(s = this.compareElements(id, (String)path, (Element)expectedChild, (Element)actualChild)))) {
                return s;
            }
            expectedChild = this.skipBlankText(expectedChild.getNextSibling());
            actualChild = this.skipBlankText(actualChild.getNextSibling());
        }
        if (expectedChild != null) {
            return "node mismatch - more nodes in actual in children of " + (String)path;
        }
        if (actualChild != null) {
            return "node mismatch - more nodes in expected in children of " + (String)path;
        }
        return null;
    }

    private boolean namespacesMatch(String ns1, String ns2) {
        return ns1 == null ? ns2 == null : ns1.equals(ns2);
    }

    private String normalise(String text) {
        String result = text.trim().replace('\r', ' ').replace('\n', ' ').replace('\t', ' ');
        while (result.contains("  ")) {
            result = result.replace("  ", " ");
        }
        return result;
    }

    private String compareAttributes(String id, String path, NamedNodeMap expected, NamedNodeMap actual) {
        for (int i = 0; i < expected.getLength(); ++i) {
            byte[] b2;
            byte[] b1;
            Node expectedNode = expected.item(i);
            String expectedNodeName = expectedNode.getNodeName();
            if (expectedNodeName.equals("xmlns") || expectedNodeName.startsWith("xmlns:")) continue;
            Node actualNode = actual.getNamedItem(expectedNodeName);
            if (actualNode == null) {
                return "Attributes differ at " + path + ": missing attribute " + expectedNodeName;
            }
            if (this.normalise(expectedNode.getTextContent()).equals(this.normalise(actualNode.getTextContent())) || this.sameBytes(b1 = this.unBase64(expectedNode.getTextContent()), b2 = this.unBase64(actualNode.getTextContent()))) continue;
            return this.createNotEqualMessage(id, "Attributes differ at " + path, this.normalise(expectedNode.getTextContent()).toString(), this.normalise(actualNode.getTextContent()).toString());
        }
        return null;
    }

    private boolean sameBytes(byte[] b1, byte[] b2) {
        if (b1.length == 0 || b2.length == 0) {
            return false;
        }
        if (b1.length != b2.length) {
            return false;
        }
        for (int i = 0; i < b1.length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    private byte[] unBase64(String text) {
        return Base64.decodeBase64((String)text);
    }

    private Node skipBlankText(Node node) {
        while (node != null && (node.getNodeType() == 3 && StringUtils.isWhitespace((CharSequence)node.getTextContent()) || node.getNodeType() == 8)) {
            node = node.getNextSibling();
        }
        return node;
    }

    private Document loadXml(String fn) throws Exception {
        return this.loadXml(ManagedFileAccess.inStream((String)fn));
    }

    private Document loadXml(InputStream fn) throws Exception {
        DocumentBuilderFactory factory = XMLUtil.newXXEProtectedDocumentBuilderFactory();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        factory.setXIncludeAware(false);
        factory.setExpandEntityReferences(false);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(fn);
    }

    public static String checkJsonSrcIsSame(String id, String expected, String actual, JsonObject externals) throws FileNotFoundException, IOException {
        return CompareUtilities.checkJsonSrcIsSame(id, expected, actual, true, externals);
    }

    public static String checkJsonSrcIsSame(String id, String expectedString, String actualString, boolean showDiff, JsonObject externals) throws FileNotFoundException, IOException {
        CompareUtilities self = new CompareUtilities();
        self.externals = externals;
        String result = self.compareJsonSrc(id, expectedString, actualString);
        if (result != null) {
            // empty if block
        }
        return result;
    }

    public static String checkJsonIsSame(String id, String expected, String actual) throws FileNotFoundException, IOException {
        CompareUtilities self = new CompareUtilities();
        String result = self.compareJson(id, expected, actual);
        if (result != null) {
            // empty if block
        }
        return result;
    }

    private String compareJsonSrc(String id, String expected, String actual) throws FileNotFoundException, IOException {
        JsonObject actualJsonObject = JsonParser.parseObject((String)actual);
        JsonObject expectedJsonObject = JsonParser.parseObject((String)expected);
        return this.compareObjects(id, "", expectedJsonObject, actualJsonObject);
    }

    private String compareJson(String id, String expected, String actual) throws FileNotFoundException, IOException {
        JsonObject actualJsonObject = JsonParser.parseObject((String)TextFile.fileToString((String)actual));
        JsonObject expectedJsonObject = JsonParser.parseObject((String)TextFile.fileToString((String)expected));
        return this.compareObjects(id, "", expectedJsonObject, actualJsonObject);
    }

    private String compareObjects(String id, String path, JsonObject expectedJsonObject, JsonObject actualJsonObject) {
        String n;
        List<String> optionals = this.listOptionals(expectedJsonObject);
        List<String> countOnlys = this.listCountOnlys(expectedJsonObject);
        for (JsonProperty en : actualJsonObject.getProperties()) {
            n = en.getName();
            if (n.equals("fhir_comments")) continue;
            if (expectedJsonObject.has(n)) {
                String s = this.compareNodes(id, path + "." + n, expectedJsonObject.get(n), en.getValue(), countOnlys.contains(n));
                if (Utilities.noString((String)s)) continue;
                return s;
            }
            return "properties differ at " + path + ": missing property " + n;
        }
        for (JsonProperty en : expectedJsonObject.getProperties()) {
            n = en.getName();
            if (n.equals("fhir_comments") || n.equals("$optional$") || optionals.contains(n) || actualJsonObject.has(n) || this.allOptional(en.getValue())) continue;
            return "properties differ at " + path + ": missing property " + n;
        }
        return null;
    }

    private boolean allOptional(JsonElement value) {
        if (value.isJsonArray()) {
            JsonArray a = value.asJsonArray();
            for (JsonElement e : a) {
                JsonObject o;
                if (!e.isJsonObject() || (o = e.asJsonObject()).has("$optional$")) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private List<String> listOptionals(JsonObject expectedJsonObject) {
        ArrayList<String> res = new ArrayList<String>();
        if (expectedJsonObject.has("$optional-properties$")) {
            res.add("$optional-properties$");
            res.add("$count-arrays$");
            for (String s : expectedJsonObject.getStrings("$optional-properties$")) {
                res.add(s);
            }
        }
        return res;
    }

    private List<String> listCountOnlys(JsonObject expectedJsonObject) {
        ArrayList<String> res = new ArrayList<String>();
        if (expectedJsonObject.has("$count-arrays$")) {
            for (String s : expectedJsonObject.getStrings("$count-arrays$")) {
                res.add(s);
            }
        }
        return res;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String compareNodes(String id, String path, JsonElement expectedJsonElement, JsonElement actualJsonElement, boolean countOnly) {
        if (!(expectedJsonElement instanceof JsonPrimitive && actualJsonElement instanceof JsonPrimitive || actualJsonElement.getClass() == expectedJsonElement.getClass())) {
            return this.createNotEqualMessage(id, "properties differ at " + path, expectedJsonElement.getClass().getName(), actualJsonElement.getClass().getName());
        }
        if (actualJsonElement instanceof JsonPrimitive) {
            JsonPrimitive actualJsonPrimitive = (JsonPrimitive)actualJsonElement;
            JsonPrimitive expectedJsonPrimitive = (JsonPrimitive)expectedJsonElement;
            if (actualJsonPrimitive.isJsonBoolean() && expectedJsonPrimitive.isJsonBoolean()) {
                if (actualJsonPrimitive.asBoolean() == expectedJsonPrimitive.asBoolean()) return null;
                return this.createNotEqualMessage(id, "boolean property values differ at " + path, expectedJsonPrimitive.asString(), actualJsonPrimitive.asString());
            }
            if (actualJsonPrimitive.isJsonString() && expectedJsonPrimitive.isJsonString()) {
                String actualJsonString = actualJsonPrimitive.asString();
                String expectedJsonString = expectedJsonPrimitive.asString();
                if (actualJsonString.contains("<div")) {
                    if (expectedJsonString.contains("<div")) return null;
                }
                if (this.matches(actualJsonString, expectedJsonString)) return null;
                if (this.sameBytes(this.unBase64(actualJsonString), this.unBase64(expectedJsonString))) return null;
                return this.createNotEqualMessage(id, "string property values differ at " + path, expectedJsonString, actualJsonString);
            }
            if (actualJsonPrimitive.isJsonNumber() && expectedJsonPrimitive.isJsonNumber()) {
                if (actualJsonPrimitive.asString().equals(expectedJsonPrimitive.asString())) return null;
                return this.createNotEqualMessage(id, "number property values differ at " + path, expectedJsonPrimitive.asString(), actualJsonPrimitive.asString());
            }
            if (!(expectedJsonElement instanceof JsonNull)) return this.createNotEqualMessage(id, "property types differ at " + path, expectedJsonPrimitive.asString(), actualJsonPrimitive.asString());
            if (actualJsonPrimitive instanceof JsonNull) {
                return null;
            }
            String string = this.createNotEqualMessage(id, "null Properties differ at " + path, "null", actualJsonPrimitive.asString());
            return string;
        }
        if (actualJsonElement instanceof JsonObject) {
            String s = this.compareObjects(id, path, (JsonObject)expectedJsonElement, (JsonObject)actualJsonElement);
            if (Utilities.noString((String)s)) return null;
            return s;
        }
        if (!(actualJsonElement instanceof JsonArray)) return "unhandled property " + actualJsonElement.getClass().getName();
        JsonArray actualArray = (JsonArray)actualJsonElement;
        JsonArray expectedArray = (JsonArray)expectedJsonElement;
        int as = actualArray.size();
        int es = expectedArray.size();
        if (countOnly) {
            if (as == es) return null;
            return this.createNotEqualMessage(id, "array item count differs at " + path, Integer.toString(es), Integer.toString(as));
        }
        int expectedMin = this.countExpectedMin(expectedArray);
        int oc = this.optionalCount(expectedArray);
        if (as > es) return this.createNotEqualMessage(id, "array item count differs at " + path, Integer.toString(es), Integer.toString(as));
        if (as < expectedMin) {
            return this.createNotEqualMessage(id, "array item count differs at " + path, Integer.toString(es), Integer.toString(as));
        }
        int c = 0;
        for (int i = 0; i < es; ++i) {
            if (c >= as) {
                if (i < es - oc) return "One or more array items did not match at " + path + " starting at index " + i;
                if (!this.isOptional(expectedArray.get(i))) return "One or more array items did not match at " + path + " starting at index " + i;
                return null;
            }
            String s = this.compareNodes(id, path + "[" + Integer.toString(i) + "]", expectedArray.get(i), actualArray.get(c), false);
            if (!Utilities.noString((String)s) && !this.isOptional(expectedArray.get(i))) {
                return s;
            }
            if (!Utilities.noString((String)s)) continue;
            ++c;
        }
        if (c >= as) return null;
        return "Unexpected Node found in array at '" + path + "' at index " + c;
    }

    private int optionalCount(JsonArray arr) {
        int c = 0;
        for (JsonElement e : arr) {
            JsonObject j;
            if (!e.isJsonObject() || !(j = e.asJsonObject()).has("$optional$") || !j.asBoolean("$optional$")) continue;
            ++c;
        }
        return c;
    }

    private boolean isOptional(JsonElement e) {
        return e.isJsonObject() && e.asJsonObject().has("$optional$");
    }

    private int countExpectedMin(JsonArray array) {
        int count = array.size();
        for (JsonElement e : array) {
            if (!this.isOptional(e)) continue;
            --count;
        }
        return count;
    }

    private boolean matches(String actualJsonString, String expectedJsonString) {
        if (expectedJsonString.startsWith("$") && expectedJsonString.endsWith("$")) {
            if (expectedJsonString.startsWith("$choice:")) {
                return Utilities.existsInList((String)actualJsonString, this.readChoices(expectedJsonString.substring(8, expectedJsonString.length() - 1)));
            }
            if (expectedJsonString.startsWith("$fragments:")) {
                List<String> fragments = this.readChoices(expectedJsonString.substring(11, expectedJsonString.length() - 1));
                for (String f : fragments) {
                    if (actualJsonString.toLowerCase().contains(f.toLowerCase())) continue;
                    return false;
                }
                return true;
            }
            if (expectedJsonString.startsWith("$external:")) {
                String[] cmd = expectedJsonString.substring(1, expectedJsonString.length() - 1).split("\\:");
                if (this.externals != null) {
                    String s = this.externals.asString(cmd[1]);
                    return actualJsonString.equals(s);
                }
                if (cmd.length <= 2) {
                    return true;
                }
                List<String> fragments = this.readChoices(cmd[2]);
                for (String f : fragments) {
                    if (actualJsonString.toLowerCase().contains(f.toLowerCase())) continue;
                    return false;
                }
                return true;
            }
            switch (expectedJsonString) {
                case "$$": {
                    return true;
                }
                case "$instant$": {
                    return actualJsonString.matches("([0-9]([0-9]([0-9][1-9]|[1-9]0)|[1-9]00)|[1-9]000)-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])T([01][0-9]|2[0-3]):[0-5][0-9]:([0-5][0-9]|60)(\\.[0-9]{1,9})?(Z|(\\+|-)((0[0-9]|1[0-3]):[0-5][0-9]|14:00))");
                }
                case "$uuid$": {
                    return actualJsonString.matches("urn:uuid:[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}");
                }
                case "$id$": {
                    return actualJsonString.matches("[A-Za-z0-9\\-\\.]{1,64}");
                }
            }
            throw new Error("Unhandled template: " + expectedJsonString);
        }
        return actualJsonString.equals(expectedJsonString);
    }

    private List<String> readChoices(String s) {
        ArrayList<String> list = new ArrayList<String>();
        for (String p : s.split("\\|")) {
            list.add(p);
        }
        return list;
    }

    public static String checkTextIsSame(String id, String expected, String actual) throws FileNotFoundException, IOException {
        return CompareUtilities.checkTextIsSame(id, expected, actual, true);
    }

    public static String checkTextIsSame(String id, String expectedString, String actualString, boolean showDiff) throws FileNotFoundException, IOException {
        CompareUtilities self = new CompareUtilities();
        String result = self.compareText(id, expectedString, actualString);
        if (result != null) {
            // empty if block
        }
        return result;
    }

    private String compareText(String id, String expectedString, String actualString) {
        for (int i = 0; i < Integer.min(expectedString.length(), actualString.length()); ++i) {
            if (expectedString.charAt(i) == actualString.charAt(i)) continue;
            return this.createNotEqualMessage(id, "Strings differ at character " + Integer.toString(i), this.charWithContext(expectedString, i), this.charWithContext(actualString, i));
        }
        if (expectedString.length() != actualString.length()) {
            return this.createNotEqualMessage(id, "Strings differ in length but match to the end of the shortest.", Integer.toString(expectedString.length()), Integer.toString(actualString.length()));
        }
        return null;
    }

    private String charWithContext(String s, int i) {
        int e;
        Object result = s.substring(i, i + 1);
        if (i > 7) {
            i -= 7;
        }
        if ((e = i + 20) > s.length()) {
            e = s.length();
        }
        if (e > i + 1) {
            result = (String)result + " with context '" + s.substring(i, e) + "'";
        }
        return result;
    }
}

