/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.elementmodel;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.conformance.profile.ProfileUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.Manager;
import org.hl7.fhir.r5.elementmodel.ParserBase;
import org.hl7.fhir.r5.elementmodel.Property;
import org.hl7.fhir.r5.elementmodel.ValidatedFragment;
import org.hl7.fhir.r5.fhirpath.FHIRPathEngine;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.JsonCreator;
import org.hl7.fhir.r5.formats.JsonCreatorCanonical;
import org.hl7.fhir.r5.formats.JsonCreatorDirect;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.NamedItemList;
import org.hl7.fhir.utilities.StringPair;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.json.model.JsonArray;
import org.hl7.fhir.utilities.json.model.JsonComment;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonNull;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.model.JsonPrimitive;
import org.hl7.fhir.utilities.json.model.JsonProperty;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.xhtml.XhtmlParser;

public class JsonParser
extends ParserBase {
    private JsonCreator json;
    private boolean allowComments;
    private boolean elideElements;
    private Element baseElement;
    private boolean markedXhtml;

    public JsonParser(IWorkerContext context, ProfileUtilities utilities) {
        super(context, utilities);
    }

    public JsonParser(IWorkerContext context) {
        super(context);
    }

    public Element parse(String source, String type) throws Exception {
        return this.parse(source, type, false);
    }

    public Element parse(String source, String type, boolean inner) throws Exception {
        ValidatedFragment focusFragment = new ValidatedFragment("focus", "json", source.getBytes(StandardCharsets.UTF_8), false);
        JsonObject obj = org.hl7.fhir.utilities.json.parser.JsonParser.parseObject((String)source, (boolean)true, (boolean)true);
        String path = "/" + type;
        StructureDefinition sd = this.getDefinition(focusFragment.getErrors(), -1, -1, type);
        if (sd == null) {
            return null;
        }
        if (inner) {
            sd = new StructureDefinition();
            sd.setType("Wrapper");
            ElementDefinition bEd = sd.getSnapshot().addElement();
            ElementDefinition nEd = sd.getSnapshot().addElement();
            bEd.setPath("Wrapper");
            nEd.setPath("Wrapper." + ((JsonProperty)obj.getProperties().get(0)).getName());
            nEd.addType().setCode(type);
            nEd.setMax(((JsonProperty)obj.getProperties().get(0)).getValue().isJsonArray() ? "*" : "1");
        }
        Element result = new Element(type, new Property(this.context, sd.getSnapshot().getElement().get(0), sd, this.getProfileUtilities(), this.getContextUtilities())).setFormat(Manager.FhirFormat.JSON);
        result.setPath(type);
        this.checkObject(focusFragment.getErrors(), obj, result, path);
        result.setType(type);
        this.parseChildren(focusFragment.getErrors(), path, obj, result, true, null);
        result.numberChildren();
        return result;
    }

    @Override
    public List<ValidatedFragment> parse(InputStream inStream) throws IOException, FHIRException {
        return this.parse(inStream, 0);
    }

    public List<ValidatedFragment> parse(InputStream inStream, int line) throws IOException, FHIRException {
        byte[] content = TextFile.streamToBytes((InputStream)inStream);
        ValidatedFragment focusFragment = new ValidatedFragment("focus", "json", content, false);
        ByteArrayInputStream stream = new ByteArrayInputStream(content);
        String source = TextFile.streamToString((InputStream)stream);
        JsonObject obj = null;
        if (this.policy == ParserBase.ValidationPolicy.EVERYTHING) {
            try {
                obj = org.hl7.fhir.utilities.json.parser.JsonParser.parseObject((String)source, (boolean)true, (boolean)true, (int)line);
            }
            catch (Exception e) {
                this.logError(focusFragment.getErrors(), ValidationMessage.NO_RULE_DATE, -1, -1, null, ValidationMessage.IssueType.INVALID, this.context.formatMessage("Error_parsing_JSON_", e.getMessage()), ValidationMessage.IssueSeverity.FATAL);
            }
        } else {
            obj = org.hl7.fhir.utilities.json.parser.JsonParser.parseObject((String)source, (boolean)true, (boolean)true, (int)line);
        }
        if (obj != null) {
            focusFragment.setElement(this.parse(focusFragment.getErrors(), obj));
        }
        ArrayList<ValidatedFragment> res = new ArrayList<ValidatedFragment>();
        res.add(focusFragment);
        return res;
    }

    public Element parse(List<ValidationMessage> errors, JsonObject object) throws FHIRException {
        return this.parse(errors, object, null);
    }

    public Element parse(List<ValidationMessage> errors, JsonObject object, String statedPath) throws FHIRException {
        String path;
        String name;
        StructureDefinition sd;
        if (object == null) {
            System.out.println("What?");
        }
        if ((sd = this.getLogical()) == null) {
            JsonElement rt = object.get("resourceType");
            if (rt == null) {
                this.logError(errors, ValidationMessage.NO_RULE_DATE, this.line((JsonElement)object), this.col((JsonElement)object), "$", ValidationMessage.IssueType.INVALID, this.context.formatMessage("Unable_to_find_resourceType_property", new Object[0]), ValidationMessage.IssueSeverity.FATAL);
                return null;
            }
            if (!rt.isJsonString()) {
                this.logError(errors, "2022-11-26", this.line((JsonElement)object), this.col((JsonElement)object), "$", ValidationMessage.IssueType.INVALID, this.context.formatMessage("RESOURCETYPE_PROPERTY_WRONG_TYPE", rt.type().toName()), ValidationMessage.IssueSeverity.FATAL);
                return null;
            }
            name = rt.asString();
            sd = this.getDefinition(errors, this.line((JsonElement)object), this.col((JsonElement)object), name);
            if (sd == null) {
                return null;
            }
            path = statedPath == null ? name : statedPath;
        } else {
            name = sd.getType();
            path = statedPath == null ? sd.getTypeTail() : statedPath;
        }
        this.baseElement = new Element(name, new Property(this.context, sd.getSnapshot().getElement().get(0), sd, this.getProfileUtilities(), this.getContextUtilities())).setFormat(Manager.FhirFormat.JSON);
        this.checkObject(errors, object, this.baseElement, path);
        this.baseElement.markLocation(this.line((JsonElement)object), this.col((JsonElement)object));
        this.baseElement.setType(name);
        this.baseElement.setPath(statedPath == null ? this.baseElement.fhirTypeRoot() : statedPath);
        this.parseChildren(errors, path, object, this.baseElement, true, null);
        this.baseElement.numberChildren();
        return this.baseElement;
    }

    private void checkObject(List<ValidationMessage> errors, JsonObject object, Element b, String path) {
        b.setNativeObject(object);
        this.checkComments(errors, (JsonElement)object, b, path);
        if (this.policy == ParserBase.ValidationPolicy.EVERYTHING && object.getProperties().size() == 0) {
            this.logError(errors, ValidationMessage.NO_RULE_DATE, this.line((JsonElement)object), this.col((JsonElement)object), path, ValidationMessage.IssueType.INVALID, this.context.formatMessage("Object_must_have_some_content", new Object[0]), ValidationMessage.IssueSeverity.ERROR);
        }
    }

    private void checkComments(List<ValidationMessage> errors, JsonElement element, Element b, String path) throws FHIRFormatError {
        block4: {
            if (element == null || !element.hasComments()) break block4;
            if (this.allowComments) {
                for (JsonComment c : element.getComments()) {
                    b.getComments().add(c.getContent());
                }
            } else {
                for (JsonComment c : element.getComments()) {
                    this.logError(errors, "2022-11-26", c.getStart().getLine(), c.getStart().getCol(), path, ValidationMessage.IssueType.INVALID, this.context.formatMessage("JSON_COMMENTS_NOT_ALLOWED", new Object[0]), ValidationMessage.IssueSeverity.ERROR);
                }
            }
        }
    }

    private List<Property> parseChildren(List<ValidationMessage> errors, String path, JsonObject object, Element element, boolean hasResourceType, List<Property> properties) throws FHIRException {
        if (properties == null) {
            properties = element.getProperty().getChildProperties(element.getName(), null);
        }
        this.processChildren(errors, path, object);
        for (Property property : properties) {
            this.parseChildItem(errors, path, object.getProperties(), element, property);
        }
        this.checkNotProcessed(errors, path, element, hasResourceType, object.getProperties());
        if (object.isExtraComma()) {
            this.logError(errors, "2022-11-26", object.getEnd().getLine(), object.getEnd().getCol(), path, ValidationMessage.IssueType.INVALID, this.context.formatMessage("JSON_COMMA_EXTRA", "Object"), ValidationMessage.IssueSeverity.ERROR);
        }
        return properties;
    }

    private void checkNotProcessed(List<ValidationMessage> errors, String path, Element element, boolean hasResourceType, List<JsonProperty> children) {
        if (this.policy != ParserBase.ValidationPolicy.NONE) {
            for (JsonProperty e : children) {
                StructureDefinition sd;
                if (e.getTag() != 0) continue;
                StructureDefinition structureDefinition = sd = element.getProperty().isLogical() ? this.getContextUtilities().fetchByJsonName(e.getName()) : null;
                if (sd != null) {
                    Property property = new Property(this.context, sd.getSnapshot().getElementFirstRep(), sd, element.getProperty().getUtils(), element.getProperty().getContextUtils());
                    this.parseChildItem(errors, path, children, element, property);
                    continue;
                }
                if ("fhir_comments".equals(e.getName()) && (VersionUtilities.isR2BVer((String)this.context.getVersion()) || VersionUtilities.isR2Ver((String)this.context.getVersion()))) {
                    if (!e.getValue().isJsonArray()) {
                        this.logError(errors, "2022-12-17", this.line(e.getValue()), this.col(e.getValue()), path, ValidationMessage.IssueType.STRUCTURE, this.context.formatMessage("ILLEGAL_COMMENT_TYPE", e.getValue().type().toName()), ValidationMessage.IssueSeverity.ERROR);
                        continue;
                    }
                    for (JsonElement c : e.getValue().asJsonArray()) {
                        if (!c.isJsonString()) {
                            this.logError(errors, "2022-12-17", this.line(e.getValue()), this.col(e.getValue()), path, ValidationMessage.IssueType.STRUCTURE, this.context.formatMessage("ILLEGAL_COMMENT_TYPE", c.type().toName()), ValidationMessage.IssueSeverity.ERROR);
                            continue;
                        }
                        element.getComments().add(c.asString());
                    }
                    continue;
                }
                if (hasResourceType && "resourceType".equals(e.getName())) continue;
                JsonProperty p = this.getFoundJsonPropertyByName(e.getName(), children);
                if (p != null) {
                    this.logError(errors, "2022-11-26", this.line(e.getValue()), this.col(e.getValue()), path, ValidationMessage.IssueType.INVALID, this.context.formatMessage("DUPLICATE_JSON_PROPERTY_KEY", e.getName()), ValidationMessage.IssueSeverity.ERROR);
                    continue;
                }
                this.logError(errors, ValidationMessage.NO_RULE_DATE, this.line(e.getValue()), this.col(e.getValue()), path, ValidationMessage.IssueType.STRUCTURE, this.context.formatMessage("Unrecognised_property_", e.getName()), ValidationMessage.IssueSeverity.ERROR);
            }
        }
    }

    private JsonProperty getFoundJsonPropertyByName(String name, List<JsonProperty> children) {
        int hash = name.hashCode();
        for (JsonProperty p : children) {
            if (p.getTag() != 1 || hash != p.getNameHash()) continue;
            return p;
        }
        return null;
    }

    private JsonProperty getJsonPropertyByName(String name, List<JsonProperty> children) {
        int hash = name.hashCode();
        for (JsonProperty p : children) {
            if (p.getTag() != 0 || hash != p.getNameHash()) continue;
            return p;
        }
        return null;
    }

    private JsonProperty getJsonPropertyByBaseName(String name, List<JsonProperty> children) {
        for (JsonProperty p : children) {
            if (p.getTag() != 0 || !p.getName().startsWith(name)) continue;
            return p;
        }
        return null;
    }

    private void processChildren(List<ValidationMessage> errors, String path, JsonObject object) {
        for (JsonProperty p : object.getProperties()) {
            if (p.isUnquotedName()) {
                this.logError(errors, "2022-11-26", this.line(p.getValue()), this.col(p.getValue()), path, ValidationMessage.IssueType.INVALID, this.context.formatMessage("JSON_PROPERTY_NO_QUOTES", p.getName()), ValidationMessage.IssueSeverity.ERROR);
            }
            if (!p.isNoComma()) continue;
            this.logError(errors, "2022-11-26", this.line(p.getValue()), this.col(p.getValue()), path, ValidationMessage.IssueType.INVALID, this.context.formatMessage("JSON_COMMA_MISSING", new Object[0]), ValidationMessage.IssueSeverity.ERROR);
        }
    }

    public void parseChildItem(List<ValidationMessage> errors, String path, List<JsonProperty> children, Element context, Property property) {
        JsonProperty jp = this.getJsonPropertyByName(property.getJsonName(), children);
        if (property.isChoice() || property.getDefinition().getPath().endsWith("data[x]")) {
            if (property.isJsonPrimitiveChoice()) {
                if (jp != null) {
                    jp.setTag(1);
                    JsonElement je = jp.getValue();
                    String type = this.getTypeFromJsonType(je);
                    if (type == null) {
                        this.logError(errors, ValidationMessage.NO_RULE_DATE, this.line(je), this.col(je), path, ValidationMessage.IssueType.STRUCTURE, this.context.formatMessage("UNRECOGNISED_PROPERTY_TYPE", this.describeType(je), property.getName(), property.typeSummary()), ValidationMessage.IssueSeverity.ERROR);
                    } else if (property.hasType(type)) {
                        Property np = new Property(property.getContext(), property.getDefinition(), property.getStructure(), property.getUtils(), property.getContextUtils(), type);
                        this.parseChildPrimitive(errors, jp, this.getJsonPropertyByName("_" + property.getJsonName(), children), context, np, path, property.getName(), false);
                    } else {
                        this.logError(errors, ValidationMessage.NO_RULE_DATE, this.line(je), this.col(je), path, ValidationMessage.IssueType.STRUCTURE, this.context.formatMessage("UNRECOGNISED_PROPERTY_TYPE_WRONG", this.describeType(je), property.getName(), type, property.typeSummary()), ValidationMessage.IssueSeverity.ERROR);
                    }
                }
            } else {
                String baseName = property.getJsonName().substring(0, property.getName().length() - 3);
                jp = this.getJsonPropertyByBaseName(baseName, children);
                JsonProperty jp1 = this.getJsonPropertyByBaseName("_" + baseName, children);
                if (jp != null || jp1 != null) {
                    for (ElementDefinition.TypeRefComponent type : property.getDefinition().getType()) {
                        String eName = baseName + Utilities.capitalize((String)type.getWorkingCode());
                        if ((jp == null || !jp.getName().equals(eName)) && (jp1 == null || !jp1.getName().equals("_" + eName))) continue;
                        if (!this.isPrimitive(type.getWorkingCode()) && jp != null) {
                            this.parseChildComplex(errors, path, jp, context, property, eName, false);
                        } else {
                            if (!this.isPrimitive(type.getWorkingCode()) || jp == null && jp1 == null) continue;
                            this.parseChildPrimitive(errors, jp, jp1, context, property, path, eName, false);
                        }
                        break;
                    }
                }
            }
        } else if (property.isPrimitive(property.getType(null))) {
            this.parseChildPrimitive(errors, jp, this.getJsonPropertyByName("_" + property.getJsonName(), children), context, property, path, property.getJsonName(), property.hasJsonName());
        } else if (jp != null) {
            this.parseChildComplex(errors, path, jp, context, property, property.getJsonName(), property.hasJsonName());
        }
    }

    private String getTypeFromJsonType(JsonElement je) {
        if (je.isJsonPrimitive()) {
            JsonPrimitive p = je.asJsonPrimitive();
            if (p.isJsonString()) {
                return "string";
            }
            if (p.isJsonBoolean()) {
                return "boolean";
            }
            String s = p.asString();
            if (Utilities.isInteger((String)s)) {
                return "integer";
            }
            return "decimal";
        }
        return null;
    }

    private void parseChildComplex(List<ValidationMessage> errors, String path, JsonProperty p, Element element, Property property, String name, boolean isJsonName) throws FHIRException {
        JsonElement e;
        String npath = path + "." + property.getName();
        String fpath = element.getPath() + "." + property.getName();
        if (p != null) {
            p.setTag(1);
        }
        JsonElement jsonElement = e = p == null ? null : p.getValue();
        if (property.isList() && !property.isJsonKeyArray() && e instanceof JsonArray) {
            JsonArray arr = (JsonArray)e;
            if (arr.isExtraComma()) {
                this.logError(errors, "2022-11-26", arr.getEnd().getLine(), arr.getEnd().getCol(), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("JSON_COMMA_EXTRA", "Array"), ValidationMessage.IssueSeverity.ERROR);
            }
            if (arr.size() == 0 && !property.canBeEmpty()) {
                this.logError(errors, ValidationMessage.NO_RULE_DATE, this.line(e), this.col(e), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("ARRAY_CANNOT_BE_EMPTY", new Object[0]), ValidationMessage.IssueSeverity.ERROR);
            }
            int c = 0;
            List<Property> properties = null;
            for (JsonElement am : arr) {
                properties = this.parseChildComplexInstance(errors, npath + "[" + c + "]", fpath + "[" + c + "]", element, property, name, am, (JsonElement)(c == 0 ? arr : null), path, properties);
                ++c;
            }
        } else if (property.isJsonKeyArray()) {
            String code = property.getJsonKeyProperty();
            List<Property> properties = property.getChildProperties(element.getName(), null);
            if (properties.size() != 2) {
                this.logError(errors, ValidationMessage.NO_RULE_DATE, this.line(e), this.col(e), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("OBJECT_CANNOT_BE_KEYED_ARRAY_CHILD_COUNT", this.propNames(properties)), ValidationMessage.IssueSeverity.ERROR);
            } else {
                Property propK = properties.get(0);
                Property propV = properties.get(1);
                if (!propK.getName().equals(code)) {
                    this.logError(errors, ValidationMessage.NO_RULE_DATE, this.line(e), this.col(e), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("OBJECT_CANNOT_BE_KEYED_ARRAY_PROP_NAME", this.propNames(properties)), ValidationMessage.IssueSeverity.ERROR);
                } else if (!propK.isPrimitive()) {
                    this.logError(errors, ValidationMessage.NO_RULE_DATE, this.line(e), this.col(e), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("OBJECT_CANNOT_BE_KEYED_ARRAY_PROP_TYPE", this.propNames(properties), propK.typeSummary()), ValidationMessage.IssueSeverity.ERROR);
                } else if (propV.isList()) {
                    this.logError(errors, ValidationMessage.NO_RULE_DATE, this.line(e), this.col(e), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("OBJECT_CANNOT_BE_KEYED_ARRAY_NO_LIST", propV.getName()), ValidationMessage.IssueSeverity.ERROR);
                } else if (propV.isChoice() && propV.getName().endsWith("[x]")) {
                    this.logError(errors, ValidationMessage.NO_RULE_DATE, this.line(e), this.col(e), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("OBJECT_CANNOT_BE_KEYED_ARRAY_NO_CHOICE", propV.getName()), ValidationMessage.IssueSeverity.ERROR);
                } else if (!(e instanceof JsonObject)) {
                    this.logError(errors, ValidationMessage.NO_RULE_DATE, this.line(e), this.col(e), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("This_property_must_be_an_object_not_", this.describe(e)), ValidationMessage.IssueSeverity.ERROR);
                } else {
                    JsonObject o = (JsonObject)e;
                    if (o.isExtraComma()) {
                        this.logError(errors, "2022-11-26", o.getEnd().getLine(), o.getEnd().getCol(), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("JSON_COMMA_EXTRA", "Object"), ValidationMessage.IssueSeverity.ERROR);
                    }
                    int i = 0;
                    HashSet<String> names = new HashSet<String>();
                    for (JsonProperty pv : o.getProperties()) {
                        if (names.contains(pv.getName())) {
                            this.logError(errors, "2022-11-26", this.line(e), this.col(e), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("DUPLICATE_JSON_PROPERTY_KEY", pv.getName()), ValidationMessage.IssueSeverity.ERROR);
                        } else {
                            names.add(pv.getName());
                            pv.setTag(1);
                        }
                        String npathArr = path + "." + property.getName() + "[" + i + "]";
                        String fpathArr = element.getPath() + "." + property.getName() + "[" + i + "]";
                        Element n = new Element(name, property).markLocation(this.line(pv.getValue()), this.col(pv.getValue())).setFormat(Manager.FhirFormat.JSON);
                        n.setPath(fpath);
                        element.getChildren().add((NamedItemList.NamedItem)n);
                        String fpathKey = fpathArr + "." + propK.getName();
                        Element nKey = new Element(code, propK).markLocation(this.line(pv.getValue()), this.col(pv.getValue())).setFormat(Manager.FhirFormat.JSON);
                        this.checkComments(errors, pv.getValue(), n, fpathArr);
                        nKey.setPath(fpathKey);
                        n.getChildren().add((NamedItemList.NamedItem)nKey);
                        nKey.setValue(pv.getName());
                        boolean ok = true;
                        Property pvl = propV;
                        if (propV.isJsonPrimitiveChoice()) {
                            ok = false;
                            String type = this.getTypeFromJsonType(pv.getValue());
                            if (type == null) {
                                this.logError(errors, ValidationMessage.NO_RULE_DATE, this.line(pv.getValue()), this.col(pv.getValue()), path, ValidationMessage.IssueType.STRUCTURE, this.context.formatMessage("UNRECOGNISED_PROPERTY_TYPE", this.describeType(pv.getValue()), propV.getName(), propV.typeSummary()), ValidationMessage.IssueSeverity.ERROR);
                            } else if (propV.hasType(type)) {
                                pvl = new Property(propV.getContext(), propV.getDefinition(), propV.getStructure(), propV.getUtils(), propV.getContextUtils(), type);
                                ok = true;
                            } else if (propV.getDefinition().getType().size() == 1 && propV.typeIsConsistent(type)) {
                                pvl = new Property(propV.getContext(), propV.getDefinition(), propV.getStructure(), propV.getUtils(), propV.getContextUtils(), propV.getType());
                                ok = true;
                            } else {
                                this.logError(errors, ValidationMessage.NO_RULE_DATE, this.line(pv.getValue()), this.col(pv.getValue()), path, ValidationMessage.IssueType.STRUCTURE, this.context.formatMessage("UNRECOGNISED_PROPERTY_TYPE_WRONG", this.describeType(pv.getValue()), propV.getName(), type, propV.typeSummary()), ValidationMessage.IssueSeverity.ERROR);
                            }
                        }
                        if (ok) {
                            String npathV = npathArr + "." + pvl.getName();
                            String fpathV = fpathArr + "." + pvl.getName();
                            if (propV.isPrimitive(pvl.getType(null))) {
                                this.parseChildPrimitiveInstance(errors, n, pvl, pvl.getName(), false, npathV, fpathV, pv.getValue(), null);
                            } else if (pv.getValue() instanceof JsonObject || pv.getValue() instanceof JsonNull) {
                                this.parseChildComplexInstance(errors, npathV, fpathV, n, pvl, pvl.getName(), pv.getValue(), null, null, null);
                            } else {
                                this.logError(errors, ValidationMessage.NO_RULE_DATE, this.line(e), this.col(e), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("This_property_must_be_an_object_not_", this.describe(pv.getValue())), ValidationMessage.IssueSeverity.ERROR);
                            }
                        }
                        ++i;
                    }
                }
            }
        } else {
            if (property.isJsonList()) {
                this.logError(errors, ValidationMessage.NO_RULE_DATE, this.line(e), this.col(e), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("This_property_must_be_an_Array_not_", this.describe(e), name, path), ValidationMessage.IssueSeverity.ERROR);
            }
            this.parseChildComplexInstance(errors, npath, fpath, element, property, name, e, null, null, null);
        }
    }

    private Object propNames(List<Property> properties) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (Property p : properties) {
            b.append(p.getName());
        }
        return b.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Property> parseChildComplexInstance(List<ValidationMessage> errors, String npath, String fpath, Element element, Property property, String name, JsonElement e, JsonElement commentContext, String commentPath, List<Property> properties) throws FHIRException {
        Element n;
        JsonObject child;
        if (property.hasTypeSpecifier()) {
            StructureDefinition sd;
            FHIRPathEngine fpe = new FHIRPathEngine(this.context);
            String type = null;
            String cond = null;
            for (StringPair sp : property.getTypeSpecifiers()) {
                if (!fpe.evaluateToBoolean(null, this.baseElement, this.baseElement, (Base)element, fpe.parse(sp.getName()))) continue;
                type = sp.getValue();
                cond = sp.getName();
                break;
            }
            if (type != null) {
                sd = this.context.fetchResource(StructureDefinition.class, type);
                if (sd == null) {
                    this.logError(errors, ValidationMessage.NO_RULE_DATE, this.line(e), this.col(e), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("TYPE_SPECIFIER_ILLEGAL_TYPE", type, cond), ValidationMessage.IssueSeverity.ERROR);
                } else {
                    if (sd.getAbstract()) {
                        this.logError(errors, ValidationMessage.NO_RULE_DATE, this.line(e), this.col(e), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("TYPE_SPECIFIER_ABSTRACT_TYPE", type, cond), ValidationMessage.IssueSeverity.ERROR);
                    }
                    property = property.cloneToType(sd);
                }
            } else {
                sd = this.context.fetchTypeDefinition(property.getType());
                if (sd == null) {
                    this.logError(errors, ValidationMessage.NO_RULE_DATE, this.line(e), this.col(e), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("TYPE_SPECIFIER_NM_ILLEGAL_TYPE", property.getType()), ValidationMessage.IssueSeverity.ERROR);
                } else if (sd.getAbstract()) {
                    this.logError(errors, ValidationMessage.NO_RULE_DATE, this.line(e), this.col(e), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("TYPE_SPECIFIER_NM_ABSTRACT_TYPE", property.getType()), ValidationMessage.IssueSeverity.ERROR);
                }
            }
        }
        if (e instanceof JsonObject) {
            child = (JsonObject)e;
            n = new Element(name, property).markLocation(this.line((JsonElement)child), this.col((JsonElement)child)).setFormat(Manager.FhirFormat.JSON);
            n.setPath(fpath);
            this.checkComments(errors, commentContext, n, commentPath);
            this.checkObject(errors, child, n, npath);
            element.getChildren().add((NamedItemList.NamedItem)n);
            if (!property.isResource()) return this.parseChildren(errors, npath, child, n, false, properties);
            this.parseResource(errors, npath, child, n, property);
            return null;
        } else if (property.isNullable() && e instanceof JsonNull) {
            child = (JsonNull)e;
            n = new Element(name, property).markLocation(this.line((JsonElement)child), this.col((JsonElement)child)).setFormat(Manager.FhirFormat.JSON);
            this.checkComments(errors, commentContext, n, commentPath);
            this.checkComments(errors, (JsonElement)child, n, fpath);
            n.setPath(fpath);
            element.getChildren().add((NamedItemList.NamedItem)n);
            n.setNull(true);
            return null;
        } else {
            String msg = this.context.formatMessage("This_property_must_be__not_", property.isList() ? "an Array" : "an Object", this.describe(e), name, npath);
            this.logError(errors, ValidationMessage.NO_RULE_DATE, this.line(e), this.col(e), npath, ValidationMessage.IssueType.INVALID, msg, ValidationMessage.IssueSeverity.ERROR);
        }
        return null;
    }

    private String describe(JsonElement e) {
        if (e instanceof JsonArray) {
            return "an Array";
        }
        if (e instanceof JsonObject) {
            return "an Object";
        }
        if (e instanceof JsonNull) {
            return "a Null";
        }
        if (e instanceof JsonPrimitive) {
            return "a Primitive property";
        }
        return null;
    }

    private String describeType(JsonElement e) {
        return e.type().toName();
    }

    private void parseChildPrimitive(List<ValidationMessage> errors, JsonProperty main, JsonProperty fork, Element element, Property property, String path, String name, boolean isJsonName) throws FHIRException {
        String npath = path + "." + property.getName();
        String fpath = element.getPath() + "." + property.getName();
        if (main != null) {
            main.setTag(1);
        }
        if (fork != null) {
            fork.setTag(1);
        }
        if (main != null && main.getValue().isJsonString() && main.isUnquotedValue()) {
            this.logError(errors, "2022-11-26", this.line(main.getValue()), this.col(main.getValue()), path, ValidationMessage.IssueType.INVALID, this.context.formatMessage("JSON_PROPERTY_VALUE_NO_QUOTES", main.getName(), main.getValue().asString()), ValidationMessage.IssueSeverity.ERROR);
        }
        if (main != null || fork != null) {
            if (property.isJsonList()) {
                boolean ok = true;
                if (main != null && !(main.getValue() instanceof JsonArray)) {
                    this.logError(errors, ValidationMessage.NO_RULE_DATE, this.line(main.getValue()), this.col(main.getValue()), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("This_property_must_be_an_Array_not_", this.describe(main.getValue()), name, path), ValidationMessage.IssueSeverity.ERROR);
                    ok = false;
                }
                if (fork != null && !(fork.getValue() instanceof JsonArray)) {
                    this.logError(errors, ValidationMessage.NO_RULE_DATE, this.line(fork.getValue()), this.col(fork.getValue()), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("This_base_property_must_be_an_Array_not_", this.describe(main.getValue()), name, path), ValidationMessage.IssueSeverity.ERROR);
                    ok = false;
                }
                if (ok) {
                    JsonArray arr1 = (JsonArray)(main == null ? null : main.getValue());
                    JsonArray arr2 = (JsonArray)(fork == null ? null : fork.getValue());
                    if (arr1 != null && arr1.isExtraComma()) {
                        this.logError(errors, "2022-11-26", arr1.getEnd().getLine(), arr1.getEnd().getCol(), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("JSON_COMMA_EXTRA", "Array"), ValidationMessage.IssueSeverity.ERROR);
                    }
                    if (arr2 != null && arr2.isExtraComma()) {
                        this.logError(errors, "2022-11-26", arr2.getEnd().getLine(), arr2.getEnd().getCol(), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("JSON_COMMA_EXTRA", "Array"), ValidationMessage.IssueSeverity.ERROR);
                    }
                    for (int i = 0; i < Math.max(this.arrC(arr1), this.arrC(arr2)); ++i) {
                        JsonElement m = this.arrI(arr1, i);
                        JsonElement f = this.arrI(arr2, i);
                        if (m != null && m.isJsonString() && arr1.isUnquoted(i)) {
                            this.logError(errors, "2022-11-26", this.line(m), this.col(m), path + "." + name + "[" + i + "]", ValidationMessage.IssueType.INVALID, this.context.formatMessage("JSON_PROPERTY_VALUE_NO_QUOTES", "item", m.asString()), ValidationMessage.IssueSeverity.ERROR);
                        }
                        this.parseChildPrimitiveInstance(errors, element, property, name, isJsonName, npath, fpath, m, f);
                    }
                }
            } else {
                this.parseChildPrimitiveInstance(errors, element, property, name, isJsonName, npath, fpath, main == null ? null : main.getValue(), fork == null ? null : fork.getValue());
            }
        }
    }

    private JsonElement arrI(JsonArray arr, int i) {
        return arr == null || i >= arr.size() || arr.get(i) instanceof JsonNull ? null : arr.get(i);
    }

    private int arrC(JsonArray arr) {
        return arr == null ? 0 : arr.size();
    }

    private void parseChildPrimitiveInstance(List<ValidationMessage> errors, Element element, Property property, String name, boolean isJsonName, String npath, String fpath, JsonElement main, JsonElement fork) throws FHIRException {
        if (!(main == null || main.isJsonBoolean() || main.isJsonNumber() || main.isJsonString())) {
            this.logError(errors, ValidationMessage.NO_RULE_DATE, this.line(main), this.col(main), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("This_property_must_be_an_simple_value_not_", this.describe(main), name, npath), ValidationMessage.IssueSeverity.ERROR);
        } else if (fork != null && !(fork instanceof JsonObject)) {
            this.logError(errors, ValidationMessage.NO_RULE_DATE, this.line(fork), this.col(fork), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("This_property_must_be_an_object_not_", this.describe(fork), name, npath), ValidationMessage.IssueSeverity.ERROR);
        } else {
            Element n = new Element(isJsonName ? property.getName() : name, property).markLocation(this.line(main != null ? main : fork), this.col(main != null ? main : fork)).setFormat(Manager.FhirFormat.JSON);
            if (main != null) {
                this.checkComments(errors, main, n, npath);
            }
            if (fork != null) {
                this.checkComments(errors, fork, n, npath);
            }
            n.setPath(fpath);
            element.getChildren().add((NamedItemList.NamedItem)n);
            if (main != null) {
                JsonPrimitive p = (JsonPrimitive)main;
                n.setValue((String)(property.hasImpliedPrefix() ? property.getImpliedPrefix() + p.asString() : p.asString()));
                if (!n.getProperty().isChoice() && n.getType().equals("xhtml")) {
                    try {
                        XhtmlParser xhtml = new XhtmlParser();
                        n.setXhtml(xhtml.setXmlMode(true).parse(n.getValue(), null).getDocumentElement());
                        if (this.policy == ParserBase.ValidationPolicy.EVERYTHING) {
                            for (StringPair s : xhtml.getValidationIssues()) {
                                this.logError(errors, "2022-11-17", this.line(main), this.col(main), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage(s.getName(), s.getValue()), ValidationMessage.IssueSeverity.ERROR);
                            }
                        }
                    }
                    catch (Exception e) {
                        this.logError(errors, ValidationMessage.NO_RULE_DATE, this.line(main), this.col(main), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("Error_parsing_XHTML_", e.getMessage()), ValidationMessage.IssueSeverity.ERROR);
                    }
                }
                if (this.policy == ParserBase.ValidationPolicy.EVERYTHING) {
                    if (Utilities.existsInList((String)n.getType(), (String[])new String[]{"boolean"})) {
                        if (!p.isJsonBoolean()) {
                            this.logError(errors, ValidationMessage.NO_RULE_DATE, this.line(main), this.col(main), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("Error_parsing_JSON_the_primitive_value_must_be_a_boolean", new Object[0]), ValidationMessage.IssueSeverity.ERROR);
                        }
                    } else if (Utilities.existsInList((String)n.getType(), (String[])new String[]{"integer", "unsignedInt", "positiveInt", "decimal"})) {
                        if (!p.isJsonNumber()) {
                            this.logError(errors, ValidationMessage.NO_RULE_DATE, this.line(main), this.col(main), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("Error_parsing_JSON_the_primitive_value_must_be_a_number", new Object[0]), ValidationMessage.IssueSeverity.ERROR);
                        }
                    } else if (!p.isJsonString()) {
                        this.logError(errors, ValidationMessage.NO_RULE_DATE, this.line(main), this.col(main), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("Error_parsing_JSON_the_primitive_value_must_be_a_string", new Object[0]), ValidationMessage.IssueSeverity.ERROR);
                    }
                }
            }
            if (fork != null) {
                JsonObject child = (JsonObject)fork;
                this.checkObject(errors, child, n, npath);
                this.parseChildren(errors, npath, child, n, false, null);
            }
        }
    }

    private void parseResource(List<ValidationMessage> errors, String npath, JsonObject res, Element parent, Property elementProperty) throws FHIRException {
        JsonElement rt = res.get("resourceType");
        if (rt == null) {
            this.logError(errors, ValidationMessage.NO_RULE_DATE, this.line((JsonElement)res), this.col((JsonElement)res), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("Unable_to_find_resourceType_property", new Object[0]), ValidationMessage.IssueSeverity.FATAL);
        } else if (!rt.isJsonString()) {
            this.logError(errors, "2022-11-26", this.line((JsonElement)res), this.col((JsonElement)res), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("RESOURCETYPE_PROPERTY_WRONG_TYPE", rt.type().toName()), ValidationMessage.IssueSeverity.FATAL);
        } else {
            String name = rt.asString();
            StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, ProfileUtilities.sdNs(name, null));
            if (sd == null) {
                this.logError(errors, ValidationMessage.NO_RULE_DATE, this.line((JsonElement)res), this.col((JsonElement)res), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("Contained_resource_does_not_appear_to_be_a_FHIR_resource_unknown_name_", name), ValidationMessage.IssueSeverity.FATAL);
            } else {
                parent.updateProperty(new Property(this.context, sd.getSnapshot().getElement().get(0), sd, this.getProfileUtilities(), this.getContextUtilities()), Element.SpecialElement.fromProperty(parent.getProperty()), elementProperty);
                parent.setType(name);
                this.parseChildren(errors, npath, res, parent, true, null);
            }
        }
        if (res.isExtraComma()) {
            this.logError(errors, "2022-11-26", res.getEnd().getLine(), res.getEnd().getCol(), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("JSON_COMMA_EXTRA", "Object"), ValidationMessage.IssueSeverity.ERROR);
        }
    }

    private int line(JsonElement e) {
        return e.getStart().getLine();
    }

    private int col(JsonElement e) {
        return e.getEnd().getCol();
    }

    protected void prop(String name, String value, String link) throws IOException {
        this.json.link(link);
        if (name != null) {
            this.json.name(name);
        }
        this.json.value(value);
    }

    protected void open(String name, String link) throws IOException {
        this.json.link(link);
        if (name != null) {
            this.json.name(name);
        }
        this.json.beginObject();
    }

    protected void close() throws IOException {
        this.json.endObject();
    }

    protected void openArray(String name, String link) throws IOException {
        this.json.link(link);
        if (name != null) {
            this.json.name(name);
        }
        this.json.beginArray();
    }

    protected void closeArray() throws IOException {
        this.json.endArray();
    }

    @Override
    public void compose(Element e, OutputStream stream, IParser.OutputStyle style, String identity) throws FHIRException, IOException {
        if (e.getPath() == null) {
            e.populatePaths(null);
        }
        this.markedXhtml = false;
        OutputStreamWriter osw = new OutputStreamWriter(stream, "UTF-8");
        this.json = style == IParser.OutputStyle.CANONICAL ? new JsonCreatorCanonical(osw) : (style == IParser.OutputStyle.PRETTY ? new JsonCreatorDirect(osw, true, this.allowComments) : new JsonCreatorDirect(osw, false, this.allowComments));
        this.checkComposeComments(e);
        this.json.beginObject();
        if (!this.isSuppressResourceType(e.getProperty())) {
            this.prop("resourceType", e.getType(), null);
        }
        HashSet<String> done = new HashSet<String>();
        for (Element child : e.getChildren()) {
            this.compose(e.getName(), e, done, child);
        }
        this.json.endObject();
        this.json.finish();
        osw.flush();
    }

    private boolean isSuppressResourceType(Property property) {
        StructureDefinition sd = property.getStructure();
        if (sd != null && sd.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/json-suppress-resourcetype")) {
            return ToolingExtensions.readBoolExtension(sd, "http://hl7.org/fhir/tools/StructureDefinition/json-suppress-resourcetype");
        }
        return false;
    }

    private void checkComposeComments(Element e) {
        for (String s : e.getComments()) {
            this.json.comment(s);
        }
    }

    public void compose(Element e, JsonCreator json) throws Exception {
        if (e.getPath() == null) {
            e.populatePaths(null);
        }
        this.json = json;
        this.checkComposeComments(e);
        json.beginObject();
        if (!this.isSuppressResourceType(e.getProperty())) {
            this.prop("resourceType", e.getType(), this.linkResolver == null ? null : this.linkResolver.resolveProperty(e.getProperty()));
        }
        HashSet<String> done = new HashSet<String>();
        for (Element child : e.getChildren()) {
            this.compose(e.getName(), e, done, child);
        }
        json.endObject();
        json.finish();
    }

    private void compose(String path, Element e, Set<String> done, Element child) throws IOException {
        this.checkComposeComments(child);
        if (this.wantCompose(path, child)) {
            boolean isList;
            boolean bl = isList = child.hasElementProperty() ? child.getElementProperty().isList() : child.getProperty().isList();
            if (!isList) {
                if (child.isElided() && this.isElideElements() && this.json.canElide()) {
                    this.json.elide();
                } else {
                    this.compose(path, child);
                }
            } else if (!done.contains(child.getName())) {
                done.add(child.getName());
                List<Element> list = e.getChildrenByName(child.getName());
                boolean skipList = false;
                if (this.json.canElide() && this.isElideElements()) {
                    boolean foundNonElide = false;
                    for (Element listElement : list) {
                        if (listElement.isElided()) continue;
                        foundNonElide = true;
                        break;
                    }
                    if (!foundNonElide) {
                        this.json.elide();
                        skipList = true;
                    }
                }
                if (!skipList) {
                    if (child.getProperty().getDefinition().hasExtension("http://hl7.org/fhir/tools/StructureDefinition/json-property-key")) {
                        this.composeKeyList(path, list);
                    } else {
                        this.composeList(path, list);
                    }
                }
            }
        }
    }

    private void composeKeyList(String path, List<Element> list) throws IOException {
        String keyName = list.get(0).getProperty().getDefinition().getExtensionString("http://hl7.org/fhir/tools/StructureDefinition/json-property-key");
        this.json.name(list.get(0).getName());
        this.json.beginObject();
        for (Element e : list) {
            Element key = null;
            Element value = null;
            for (Element child : e.getChildren()) {
                if (child.getName().equals(keyName)) {
                    key = child;
                    continue;
                }
                value = child;
            }
            if (value.isPrimitive()) {
                this.primitiveValue(key.getValue(), value);
                continue;
            }
            this.json.name(key.getValue());
            this.checkComposeComments(e);
            this.json.beginObject();
            HashSet<String> done = new HashSet<String>();
            for (Element child : value.getChildren()) {
                this.compose(value.getName(), value, done, child);
            }
            this.json.endObject();
            this.compose(path + "." + key.getValue(), value);
        }
        this.json.endObject();
    }

    private void composeList(String path, List<Element> list) throws IOException {
        String ref;
        Object name = list.get(0).getName();
        boolean complex = true;
        if (list.get(0).isPrimitive()) {
            boolean prim = false;
            complex = false;
            for (Element item : list) {
                if (item.hasValue()) {
                    prim = true;
                }
                if (!item.hasChildren()) continue;
                complex = true;
            }
            if (prim) {
                this.openArray((String)name, this.linkResolver == null ? null : this.linkResolver.resolveProperty(list.get(0).getProperty()));
                for (Element item : list) {
                    if (item.isElided() && this.json.canElide()) {
                        this.json.elide();
                        continue;
                    }
                    if (item.hasValue()) {
                        if (this.linkResolver != null && item.getProperty().isReference() && (ref = this.linkResolver.resolveReference(this.getReferenceForElement(item))) != null) {
                            this.json.externalLink(ref);
                        }
                        this.primitiveValue(null, item);
                        continue;
                    }
                    this.json.nullValue();
                }
                this.closeArray();
            }
            name = "_" + (String)name;
        }
        if (complex) {
            this.openArray((String)name, this.linkResolver == null ? null : this.linkResolver.resolveProperty(list.get(0).getProperty()));
            int i = 0;
            for (Element item : list) {
                if (item.isElided() && this.json.canElide()) {
                    this.json.elide();
                } else if (item.hasChildren()) {
                    this.open(null, null);
                    if (item.getProperty().isResource() && !this.isSuppressResourceType(item.getProperty())) {
                        this.prop("resourceType", item.getType(), this.linkResolver == null ? null : this.linkResolver.resolveType(item.getType()));
                    }
                    if (this.linkResolver != null && item.getProperty().isReference() && (ref = this.linkResolver.resolveReference(this.getReferenceForElement(item))) != null) {
                        this.json.externalLink(ref);
                    }
                    HashSet<String> done = new HashSet<String>();
                    for (Element child : item.getChildren()) {
                        this.compose(path + "." + (String)name + "[]", item, done, child);
                    }
                    this.close();
                } else {
                    this.json.nullValue();
                }
                ++i;
            }
            this.closeArray();
        }
    }

    private void primitiveValue(String name, Element item) throws IOException {
        String type;
        if (name != null) {
            if (this.linkResolver != null) {
                this.json.link(this.linkResolver.resolveProperty(item.getProperty()));
            }
            this.json.name(name);
        }
        if (Utilities.existsInList((String)(type = item.getType()), (String[])new String[]{"boolean"})) {
            this.json.value(item.getValue().trim().equals("true") ? new Boolean(true) : new Boolean(false));
        } else if (Utilities.existsInList((String)type, (String[])new String[]{"integer", "unsignedInt", "positiveInt"})) {
            this.json.value(new Integer(item.getValue()));
        } else if (Utilities.existsInList((String)type, (String[])new String[]{"decimal"})) {
            try {
                this.json.value(new BigDecimal(item.getValue()));
            }
            catch (Exception e) {
                throw new NumberFormatException(this.context.formatMessage("error_writing_number__to_JSON", item.getValue()));
            }
        } else {
            this.json.value(item.getValue());
        }
    }

    private void compose(String path, Element element) throws IOException {
        Object name = element.getName();
        if (element.isPrimitive() || this.isPrimitive(element.getType())) {
            if (element.hasValue()) {
                this.primitiveValue((String)name, element);
            }
            name = "_" + (String)name;
            if (!this.markedXhtml && element.getType().equals("xhtml")) {
                this.json.anchor("end-xhtml");
            }
            this.markedXhtml = true;
        }
        if (element.hasChildren()) {
            String ref;
            this.open((String)name, this.linkResolver == null ? null : this.linkResolver.resolveProperty(element.getProperty()));
            if (element.getProperty().isResource() && !this.isSuppressResourceType(element.getProperty())) {
                this.prop("resourceType", element.getType(), this.linkResolver == null ? null : this.linkResolver.resolveType(element.getType()));
            }
            if (this.linkResolver != null && element.getProperty().isReference() && (ref = this.linkResolver.resolveReference(this.getReferenceForElement(element))) != null) {
                this.json.externalLink(ref);
            }
            HashSet<String> done = new HashSet<String>();
            for (Element child : element.getChildren()) {
                this.compose(path + "." + element.getName(), element, done, child);
            }
            this.close();
        }
    }

    public boolean isAllowComments() {
        return this.allowComments;
    }

    public JsonParser setAllowComments(boolean allowComments) {
        this.allowComments = allowComments;
        return this;
    }

    public boolean isElideElements() {
        return this.elideElements;
    }

    public JsonParser setElideElements(boolean elideElements) {
        this.elideElements = elideElements;
        return this;
    }
}

