/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.elementmodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.r5.context.ContextUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.terminologies.CodeSystemUtilities;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.i18n.AcceptLanguageHeader;
import org.hl7.fhir.utilities.i18n.LanguageFileProducer;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class LanguageUtils {
    public static final List<String> TRANSLATION_SUPPLEMENT_RESOURCE_TYPES = Arrays.asList("CodeSystem", "StructureDefinition", "Questionnaire");
    IWorkerContext context;
    private List<String> crlist;

    public LanguageUtils(IWorkerContext context) {
        this.context = context;
    }

    public void generateTranslations(Element resource, LanguageFileProducer.LanguageProducerLanguageSession session) {
        this.translate(null, resource, session);
    }

    private void translate(Element parent, Element element, LanguageFileProducer.LanguageProducerLanguageSession langSession) {
        String base;
        if (element.isPrimitive() && this.isTranslatable(element) && (base = element.primitiveValue()) != null) {
            String translation = this.getSpecialTranslation(parent, element, langSession.getTargetLang());
            if (translation == null) {
                translation = element.getTranslation(langSession.getTargetLang());
            }
            langSession.entry(new LanguageFileProducer.TextUnit(this.pathForElement(element), this.contextForElement(element), base, translation));
        }
        for (Element c : element.getChildren()) {
            if (c.getName().equals("designation")) continue;
            this.translate(element, c, langSession);
        }
    }

    private String contextForElement(Element element) {
        throw new Error("Not done yet");
    }

    private String getSpecialTranslation(Element parent, Element element, String targetLang) {
        if (parent == null) {
            return null;
        }
        if (Utilities.existsInList((String)this.pathForElement(parent), (String[])new String[]{"CodeSystem.concept", "CodeSystem.concept.concept"}) && "CodeSystem.concept.display".equals(this.pathForElement(element))) {
            return this.getDesignationTranslation(parent, targetLang);
        }
        if (Utilities.existsInList((String)this.pathForElement(parent), (String[])new String[]{"ValueSet.compose.include.concept"}) && "ValueSet.compose.include.concept.display".equals(this.pathForElement(element))) {
            return this.getDesignationTranslation(parent, targetLang);
        }
        if (Utilities.existsInList((String)this.pathForElement(parent), (String[])new String[]{"ValueSet.expansion.contains", "ValueSet.expansion.contains.contains"}) && "ValueSet.expansion.contains.display".equals(this.pathForElement(element))) {
            return this.getDesignationTranslation(parent, targetLang);
        }
        return null;
    }

    private String getDesignationTranslation(Element parent, String targetLang) {
        for (Element e : parent.getChildren("designation")) {
            String lang = e.getNamedChildValue("language");
            if (!LanguageUtils.langsMatch(targetLang, lang)) continue;
            return e.getNamedChildValue("value");
        }
        return null;
    }

    private boolean isTranslatable(Element element) {
        return element.getProperty().isTranslatable();
    }

    private String pathForElement(Element element) {
        String bp = element.getBasePath();
        return this.pathForElement(bp, element.getProperty().getStructure().getType());
    }

    private String pathForElement(String path, String type) {
        if (this.crlist == null) {
            this.crlist = new ContextUtilities(this.context).getCanonicalResourceNames();
        }
        if (this.crlist.contains(type)) {
            String fp = path.replace(type + ".", "CanonicalResource.");
            if (Utilities.existsInList((String)fp, (String[])new String[]{"CanonicalResource.url", "CanonicalResource.identifier", "CanonicalResource.version", "CanonicalResource.name", "CanonicalResource.title", "CanonicalResource.status", "CanonicalResource.experimental", "CanonicalResource.date", "CanonicalResource.publisher", "CanonicalResource.contact", "CanonicalResource.description", "CanonicalResource.useContext", "CanonicalResource.jurisdiction"})) {
                return fp;
            }
        }
        return path;
    }

    public int importFromTranslations(Element resource, List<LanguageFileProducer.TranslationUnit> translations) {
        return this.importFromTranslations(null, resource, translations, new HashSet<LanguageFileProducer.TranslationUnit>());
    }

    public int importFromTranslations(Element resource, List<LanguageFileProducer.TranslationUnit> translations, List<ValidationMessage> messages) {
        HashSet<LanguageFileProducer.TranslationUnit> usedUnits = new HashSet<LanguageFileProducer.TranslationUnit>();
        int r = 0;
        r = resource.fhirType().equals("StructureDefinition") ? this.importFromTranslationsForSD(null, resource, translations, usedUnits) : this.importFromTranslations(null, resource, translations, usedUnits);
        for (LanguageFileProducer.TranslationUnit t : translations) {
            if (usedUnits.contains(t) || messages == null) continue;
            messages.add(new ValidationMessage(ValidationMessage.Source.Publisher, ValidationMessage.IssueType.INFORMATIONAL, t.getId(), "Unused '" + t.getLanguage() + "' translation '" + t.getSrcText() + "' -> '" + t.getTgtText() + "'", ValidationMessage.IssueSeverity.INFORMATION));
        }
        return r;
    }

    public int importFromTranslations(Resource resource, List<LanguageFileProducer.TranslationUnit> translations, List<ValidationMessage> messages) {
        HashSet<LanguageFileProducer.TranslationUnit> usedUnits = new HashSet<LanguageFileProducer.TranslationUnit>();
        int r = 0;
        if (!resource.fhirType().equals("StructureDefinition")) {
            r = this.importResourceFromTranslations(null, resource, translations, usedUnits, resource.fhirType());
        }
        for (LanguageFileProducer.TranslationUnit t : translations) {
            if (usedUnits.contains(t) || messages == null) continue;
            messages.add(new ValidationMessage(ValidationMessage.Source.Publisher, ValidationMessage.IssueType.INFORMATIONAL, t.getId(), "Unused '" + t.getLanguage() + "' translation '" + t.getSrcText() + "' -> '" + t.getTgtText() + "'", ValidationMessage.IssueSeverity.INFORMATION));
        }
        return r;
    }

    private int importFromTranslationsForSD(Object object, Element resource, List<LanguageFileProducer.TranslationUnit> translations, Set<LanguageFileProducer.TranslationUnit> usedUnits) {
        int r = 0;
        r += this.checkForTranslations(translations, usedUnits, resource, "name", "name");
        r += this.checkForTranslations(translations, usedUnits, resource, "title", "title");
        r += this.checkForTranslations(translations, usedUnits, resource, "publisher", "publisher");
        for (Element cd : resource.getChildrenByName("contact")) {
            r += this.checkForTranslations(translations, usedUnits, cd, "contact.name", "name");
        }
        r += this.checkForTranslations(translations, usedUnits, resource, "purpose", "purpose");
        r += this.checkForTranslations(translations, usedUnits, resource, "copyright", "copyright");
        Element diff = resource.getNamedChild("differential");
        if (diff != null) {
            for (Element ed : diff.getChildrenByName("element")) {
                String id = ed.getNamedChildValue("id");
                r += this.checkForTranslations(translations, usedUnits, ed, id + "/label", "label");
                r += this.checkForTranslations(translations, usedUnits, ed, id + "/short", "short");
                r += this.checkForTranslations(translations, usedUnits, ed, id + "/definition", "definition");
                r += this.checkForTranslations(translations, usedUnits, ed, id + "/comment", "comment");
                r += this.checkForTranslations(translations, usedUnits, ed, id + "/requirements", "requirements");
                r += this.checkForTranslations(translations, usedUnits, ed, id + "/meaningWhenMissing", "meaningWhenMissing");
                r += this.checkForTranslations(translations, usedUnits, ed, id + "/orderMeaning", "orderMeaning");
            }
        }
        return r;
    }

    private int checkForTranslations(List<LanguageFileProducer.TranslationUnit> translations, Set<LanguageFileProducer.TranslationUnit> usedUnits, Element context, String tname, String pname) {
        String v;
        int r = 0;
        Element child = context.getNamedChild(pname);
        if (child != null && (v = child.primitiveValue()) != null) {
            for (LanguageFileProducer.TranslationUnit tu : translations) {
                if (!tname.equals(tu.getId()) || !v.equals(tu.getSrcText())) continue;
                usedUnits.add(tu);
                child.setTranslation(tu.getLanguage(), tu.getTgtText());
                ++r;
            }
        }
        return r;
    }

    private int importResourceFromTranslations(Base parent, Base element, List<LanguageFileProducer.TranslationUnit> translations, Set<LanguageFileProducer.TranslationUnit> usedUnits, String path) {
        int t = 0;
        if (element.isPrimitive() && this.isTranslatable(element, path) && element instanceof org.hl7.fhir.r5.model.Element) {
            org.hl7.fhir.r5.model.Element e = (org.hl7.fhir.r5.model.Element)element;
            String base = element.primitiveValue();
            if (base != null) {
                String epath = this.pathForElement(path, element.fhirType());
                Set<LanguageFileProducer.TranslationUnit> tlist = this.findTranslations(epath, base, translations);
                for (LanguageFileProducer.TranslationUnit translation : tlist) {
                    ++t;
                    if (this.handleAsSpecial(parent, element, translation)) continue;
                    ToolingExtensions.setLanguageTranslation(e, translation.getLanguage(), translation.getTgtText());
                    usedUnits.add(translation);
                }
            }
        }
        for (Property c : element.children()) {
            for (Base v : c.getValues()) {
                if (c.getName().equals("designation")) continue;
                t += this.importResourceFromTranslations(element, v, translations, usedUnits, path + "." + c.getName());
            }
        }
        return t;
    }

    private boolean handleAsSpecial(Base parent, Base element, LanguageFileProducer.TranslationUnit translation) {
        return false;
    }

    private boolean isTranslatable(Base element, String path) {
        return Utilities.existsInList((String)element.fhirType(), (String[])new String[]{"string", "markdown"});
    }

    private int importFromTranslations(Element parent, Element element, List<LanguageFileProducer.TranslationUnit> translations, Set<LanguageFileProducer.TranslationUnit> usedUnits) {
        String base;
        int t = 0;
        if (element.isPrimitive() && this.isTranslatable(element) && (base = element.primitiveValue()) != null) {
            String path = this.pathForElement(element);
            Set<LanguageFileProducer.TranslationUnit> tlist = this.findTranslations(path, base, translations);
            for (LanguageFileProducer.TranslationUnit translation : tlist) {
                ++t;
                if (this.handleAsSpecial(parent, element, translation)) continue;
                element.setTranslation(translation.getLanguage(), translation.getTgtText());
                usedUnits.add(translation);
            }
        }
        List<Element> childrenCopy = List.copyOf(element.getChildren());
        for (Element c : childrenCopy) {
            if (c.getName().equals("designation")) continue;
            t += this.importFromTranslations(element, c, translations, usedUnits);
        }
        return t;
    }

    private boolean handleAsSpecial(Element parent, Element element, LanguageFileProducer.TranslationUnit translation) {
        if (parent == null) {
            return false;
        }
        if (Utilities.existsInList((String)this.pathForElement(parent), (String[])new String[]{"CodeSystem.concept", "CodeSystem.concept.concept"}) && "CodeSystem.concept.display".equals(this.pathForElement(element))) {
            return this.setDesignationTranslation(parent, translation.getLanguage(), translation.getTgtText());
        }
        if (Utilities.existsInList((String)this.pathForElement(parent), (String[])new String[]{"ValueSet.compose.include.concept"}) && "ValueSet.compose.include.concept.display".equals(this.pathForElement(element))) {
            return this.setDesignationTranslation(parent, translation.getLanguage(), translation.getTgtText());
        }
        if (Utilities.existsInList((String)this.pathForElement(parent), (String[])new String[]{"ValueSet.expansion.contains", "ValueSet.expansion.contains.contains"}) && "ValueSet.expansion.contains.display".equals(this.pathForElement(element))) {
            return this.setDesignationTranslation(parent, translation.getLanguage(), translation.getTgtText());
        }
        return false;
    }

    private boolean setDesignationTranslation(Element parent, String targetLang, String translation) {
        for (Element e : parent.getChildren("designation")) {
            String lang = e.getNamedChildValue("language");
            if (!LanguageUtils.langsMatch(targetLang, lang)) continue;
            Element value = e.getNamedChild("value");
            if (value != null) {
                value.setValue(translation);
            } else {
                e.addElement("value").setValue(translation);
            }
            return true;
        }
        Element d = parent.addElement("designation");
        d.addElement("language").setValue(targetLang);
        d.addElement("value").setValue(translation);
        return true;
    }

    private Set<LanguageFileProducer.TranslationUnit> findTranslations(String path, String src, List<LanguageFileProducer.TranslationUnit> translations) {
        HashSet<LanguageFileProducer.TranslationUnit> res = new HashSet<LanguageFileProducer.TranslationUnit>();
        for (LanguageFileProducer.TranslationUnit translation : translations) {
            if (!path.equals(translation.getId()) || !src.equals(translation.getSrcText())) continue;
            res.add(translation);
        }
        return res;
    }

    public static boolean langsMatchExact(AcceptLanguageHeader langs, String srcLang) {
        if (langs == null) {
            return false;
        }
        for (AcceptLanguageHeader.LanguagePreference lang : langs.getLangs()) {
            if (!(lang.getValue() > 0.0)) continue;
            if ("*".equals(lang.getLang())) {
                return true;
            }
            return LanguageUtils.langsMatch(lang.getLang(), srcLang);
        }
        return false;
    }

    public static boolean langsMatch(AcceptLanguageHeader langs, String srcLang) {
        if (langs == null) {
            return false;
        }
        for (AcceptLanguageHeader.LanguagePreference lang : langs.getLangs()) {
            if (!(lang.getValue() > 0.0)) continue;
            if ("*".equals(lang.getLang())) {
                return true;
            }
            boolean ok = LanguageUtils.langsMatch(lang.getLang(), srcLang);
            if (!ok) continue;
            return true;
        }
        return false;
    }

    public static boolean langsMatchExact(String dstLang, String srcLang) {
        return dstLang == null ? false : dstLang.equals(srcLang);
    }

    public static boolean langsMatch(String dstLang, String srcLang) {
        return dstLang == null || srcLang == null ? false : dstLang.startsWith(srcLang) || "*".equals(srcLang);
    }

    public void fillSupplement(CodeSystem csSrc, CodeSystem csDst, List<LanguageFileProducer.TranslationUnit> list) {
        csDst.setUserData("translations.supplemented", csSrc);
        csDst.setUserData("translations.source-list", list);
        for (LanguageFileProducer.TranslationUnit tu : list) {
            String tt;
            CodeSystem.ConceptDefinitionComponent cdSrc;
            String code = tu.getId();
            String subCode = null;
            if (code.contains("@")) {
                subCode = code.substring(code.indexOf("@") + 1);
                code = code.substring(0, code.indexOf("@"));
            }
            if ((cdSrc = CodeSystemUtilities.getCode(csSrc, tu.getId())) == null) {
                this.addOrphanTranslation(csSrc, tu);
                continue;
            }
            CodeSystem.ConceptDefinitionComponent cdDst = CodeSystemUtilities.getCode(csDst, cdSrc.getCode());
            if (cdDst == null) {
                cdDst = csDst.addConcept().setCode(cdSrc.getCode());
            }
            if ((tt = tu.getTgtText()).startsWith("!!")) {
                tt = tt.substring(3);
            }
            if (subCode == null) {
                cdDst.setDisplay(tt);
                continue;
            }
            if ("definition".equals(subCode)) {
                cdDst.setDefinition(tt);
                continue;
            }
            boolean found = false;
            for (CodeSystem.ConceptDefinitionDesignationComponent d : cdSrc.getDesignation()) {
                if (!d.hasUse() || !subCode.equals(d.getUse().getCode())) continue;
                found = true;
                cdDst.addDesignation().setUse(d.getUse()).setLanguage(tu.getLanguage()).setValue(tt);
                break;
            }
            if (!found) {
                for (Extension e : cdSrc.getExtension()) {
                    if (!subCode.equals(this.tail(e.getUrl()))) continue;
                    found = true;
                    cdDst.addExtension().setUrl(e.getUrl()).setValue(e.getValue().fhirType().equals("markdown") ? new MarkdownType(tt) : new StringType(tt));
                    break;
                }
            }
            if (found) continue;
            this.addOrphanTranslation(csSrc, tu);
        }
    }

    private String tail(String url) {
        return url.contains("/") ? url.substring(url.lastIndexOf("/") + 1) : url;
    }

    private void addOrphanTranslation(CodeSystem cs, LanguageFileProducer.TranslationUnit tu) {
        ArrayList<LanguageFileProducer.TranslationUnit> list = (ArrayList<LanguageFileProducer.TranslationUnit>)cs.getUserData("translations.orphans");
        if (list == null) {
            list = new ArrayList<LanguageFileProducer.TranslationUnit>();
            cs.setUserData("translations.orphans", list);
        }
        list.add(tu);
    }

    public String nameForLang(String lang) {
        switch (lang) {
            case "en": {
                return "English";
            }
            case "de": {
                return "German";
            }
            case "es": {
                return "Spanish";
            }
            case "nl": {
                return "Dutch";
            }
        }
        return Utilities.capitalize((String)lang);
    }

    public String titleForLang(String lang) {
        switch (lang) {
            case "en": {
                return "English";
            }
            case "de": {
                return "German";
            }
            case "es": {
                return "Spanish";
            }
            case "nl": {
                return "Dutch";
            }
        }
        return Utilities.capitalize((String)lang);
    }

    public boolean handlesAsResource(Resource resource) {
        return resource instanceof CodeSystem && resource.hasUserData("translations.supplemented") || resource instanceof StructureDefinition;
    }

    public boolean handlesAsElement(Element element) {
        return true;
    }

    public List<LanguageFileProducer.TranslationUnit> generateTranslations(Resource res, String lang) {
        ArrayList<LanguageFileProducer.TranslationUnit> list;
        block5: {
            block4: {
                list = new ArrayList<LanguageFileProducer.TranslationUnit>();
                if (!(res instanceof StructureDefinition)) break block4;
                StructureDefinition sd = (StructureDefinition)res;
                this.generateTranslations(list, sd, lang);
                if (!res.hasUserData("translations.orphans")) break block5;
                List orphans = (List)res.getUserData("translations.orphans");
                for (LanguageFileProducer.TranslationUnit t : orphans) {
                    list.add(new LanguageFileProducer.TranslationUnit(lang, "!!" + t.getId(), t.getContext1(), t.getSrcText(), t.getTgtText()));
                }
                break block5;
            }
            CodeSystem cs = (CodeSystem)res.getUserData("translations.supplemented");
            ArrayList<LanguageFileProducer.TranslationUnit> inputs = res.hasUserData("translations.source-list") ? (List)res.getUserData("translations.source-list") : new ArrayList();
            for (CodeSystem.ConceptDefinitionComponent cd : cs.getConcept()) {
                this.generateTranslations(list, cd, lang, inputs);
            }
            if (cs.hasUserData("translations.orphans")) {
                List orphans = (List)cs.getUserData("translations.orphans");
                for (LanguageFileProducer.TranslationUnit t : orphans) {
                    list.add(new LanguageFileProducer.TranslationUnit(lang, "!!" + t.getId(), t.getContext1(), t.getSrcText(), t.getTgtText()));
                }
            }
        }
        return list;
    }

    private void generateTranslations(List<LanguageFileProducer.TranslationUnit> list, StructureDefinition sd, String lang) {
        this.addToList(list, lang, sd, "name", "name", sd.getNameElement());
        this.addToList(list, lang, sd, "title", "title", sd.getTitleElement());
        this.addToList(list, lang, sd, "publisher", "publisher", sd.getPublisherElement());
        for (ContactDetail cd : sd.getContact()) {
            this.addToList(list, lang, cd, "contact.name", "name", cd.getNameElement());
        }
        this.addToList(list, lang, sd, "purpose", "purpose", sd.getPurposeElement());
        this.addToList(list, lang, sd, "copyright", "copyright", sd.getCopyrightElement());
        for (ElementDefinition ed : sd.getDifferential().getElement()) {
            this.addToList(list, lang, ed, ed.getId() + "/label", "label", ed.getLabelElement());
            this.addToList(list, lang, ed, ed.getId() + "/short", "short", ed.getShortElement());
            this.addToList(list, lang, ed, ed.getId() + "/definition", "definition", ed.getDefinitionElement());
            this.addToList(list, lang, ed, ed.getId() + "/comment", "comment", ed.getCommentElement());
            this.addToList(list, lang, ed, ed.getId() + "/requirements", "requirements", ed.getRequirementsElement());
            this.addToList(list, lang, ed, ed.getId() + "/meaningWhenMissing", "meaningWhenMissing", ed.getMeaningWhenMissingElement());
            this.addToList(list, lang, ed, ed.getId() + "/orderMeaning", "orderMeaning", ed.getOrderMeaningElement());
            for (ElementDefinition.ElementDefinitionConstraintComponent con : ed.getConstraint()) {
                this.addToList(list, lang, con, ed.getId() + "/constraint", "human", con.getHumanElement());
            }
            if (!ed.hasBinding()) continue;
            this.addToList(list, lang, ed.getBinding(), ed.getId() + "/b/desc", "description", ed.getBinding().getDescriptionElement());
            for (ElementDefinition.ElementDefinitionBindingAdditionalComponent ab : ed.getBinding().getAdditional()) {
                this.addToList(list, lang, ab, ed.getId() + "/ab/doco", "documentation", ab.getDocumentationElement());
                this.addToList(list, lang, ab, ed.getId() + "/ab/short", "shortDoco", ab.getShortDocoElement());
            }
        }
    }

    private void addToList(List<LanguageFileProducer.TranslationUnit> list, String lang, Base ctxt, String name, String propName, DataType value) {
        if (value != null && value.hasPrimitiveValue()) {
            list.add(new LanguageFileProducer.TranslationUnit(lang, name, ctxt.getNamedProperty(propName).getDefinition(), value.primitiveValue(), value.getTranslation(lang)));
        }
    }

    private void generateTranslations(List<LanguageFileProducer.TranslationUnit> list, CodeSystem.ConceptDefinitionComponent cd, String lang, List<LanguageFileProducer.TranslationUnit> inputs) {
        this.addTranslationUnit(list, cd.getCode(), cd.getDisplay(), lang, inputs);
        if (cd.hasDefinition()) {
            this.addTranslationUnit(list, cd.getCode() + "@definition", cd.getDefinition(), lang, inputs);
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent d : cd.getDesignation()) {
            this.addTranslationUnit(list, cd.getCode() + "@" + d.getUse().getCode(), d.getValue(), lang, inputs);
        }
        for (Extension e : cd.getExtension()) {
            this.addTranslationUnit(list, cd.getCode() + "@" + this.tail(e.getUrl()), e.getValue().primitiveValue(), lang, inputs);
        }
    }

    private void addTranslationUnit(List<LanguageFileProducer.TranslationUnit> list, String id, String srcText, String lang, List<LanguageFileProducer.TranslationUnit> inputs) {
        LanguageFileProducer.TranslationUnit existing = null;
        for (LanguageFileProducer.TranslationUnit t : inputs) {
            if (!id.equals(t.getId())) continue;
            existing = t;
            break;
        }
        if (existing == null) {
            list.add(new LanguageFileProducer.TranslationUnit(lang, id, null, srcText, null));
        } else if (srcText.equals(existing.getSrcText())) {
            list.add(new LanguageFileProducer.TranslationUnit(lang, id, null, srcText, existing.getTgtText()));
        } else {
            list.add(new LanguageFileProducer.TranslationUnit(lang, id, null, srcText, "!!" + existing.getTgtText()).setOriginal(existing.getSrcText()));
        }
    }

    private String getDefinition(CodeSystem.ConceptDefinitionComponent cd) {
        CodeSystem.ConceptPropertyComponent v = CodeSystemUtilities.getProperty(cd, "translation-context");
        if (v != null && v.hasValue()) {
            return v.getValue().primitiveValue();
        }
        return cd.getDefinition();
    }

    public List<LanguageFileProducer.TranslationUnit> generateTranslations(Element e, String lang) {
        ArrayList<LanguageFileProducer.TranslationUnit> list = new ArrayList<LanguageFileProducer.TranslationUnit>();
        this.generateTranslations(e, lang, list);
        return list;
    }

    private void generateTranslations(Element e, String lang, List<LanguageFileProducer.TranslationUnit> list) {
        if (e.getProperty().isTranslatable()) {
            String id = this.pathForElement(e);
            String context = e.getProperty().getDefinition().getDefinition();
            String src = e.primitiveValue();
            String tgt = this.getTranslation(e, lang);
            list.add(new LanguageFileProducer.TranslationUnit(lang, id, context, src, tgt));
        }
        if (e.hasChildren()) {
            for (Element c : e.getChildren()) {
                this.generateTranslations(c, lang, list);
            }
        }
    }

    private String getTranslation(Element e, String lang) {
        if (!e.hasChildren()) {
            return null;
        }
        for (Element ext : e.getChildren()) {
            if (!"Extension".equals(ext.fhirType()) || !"http://hl7.org/fhir/StructureDefinition/translation".equals(ext.getNamedChildValue("url"))) continue;
            String l = null;
            String v = null;
            for (Element subExt : ext.getChildren()) {
                if ("Extension".equals(subExt.fhirType()) && "lang".equals(subExt.getNamedChildValue("url"))) {
                    l = subExt.getNamedChildValue("value");
                }
                if (!"Extension".equals(subExt.fhirType()) || !"content".equals(subExt.getNamedChildValue("url"))) continue;
                v = subExt.getNamedChildValue("value");
            }
            if (!lang.equals(l)) continue;
            return v;
        }
        return null;
    }

    public boolean switchLanguage(Element e, String lang) {
        if (e.getProperty().isTranslatable()) {
            String cnt = this.getTranslation(e, lang);
            e.removeExtension("http://hl7.org/fhir/StructureDefinition/translation");
            if (cnt != null) {
                e.setValue(cnt);
            }
        }
        if (e.hasChildren()) {
            for (Element c : e.getChildren()) {
                if (this.switchLanguage(c, lang)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean hasTranslation(org.hl7.fhir.r5.model.Element e, String lang) {
        return this.getTranslation(e, lang) != null;
    }

    public String getTranslation(org.hl7.fhir.r5.model.Element e, String lang) {
        for (Extension ext : e.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/translation")) {
            String l = ext.getExtensionString("lang");
            String v = ext.getExtensionString("content");
            if (!LanguageUtils.langsMatch(l, lang) || v == null) continue;
            return v;
        }
        return null;
    }

    public String getTranslationOrBase(PrimitiveType<?> e, String lang) {
        for (Extension ext : e.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/translation")) {
            String l = ext.getExtensionString("lang");
            String v = ext.getExtensionString("content");
            if (!LanguageUtils.langsMatch(l, lang) || v == null) continue;
            return v;
        }
        return e.primitiveValue();
    }
}

